<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'jazzquiz', language 'sr_lt', version '5.0'.
 *
 * @package     jazzquiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['a_out_of_b_responded'] = 'Odgovorilo {$a->a} / {$a->b}';
$string['a_out_of_b_voted'] = 'Glasalo {$a->a} / {$a->b}';
$string['a_responses'] = 'Broj odgovora: {$a}';
$string['a_students_answered'] = 'Broj polaznika koji su odgovorili na barem jedno pitanje: <b>{$a}</b>.';
$string['a_students_joined_quiz'] = 'Broj polaznika koji su priključili testu: <b>{$a}</b>.';
$string['add'] = 'Dodaj';
$string['add_question'] = 'Dodaj pitanje';
$string['add_to_quiz'] = 'Dodaj u test';
$string['allow_guests'] = 'Dozvoli pristup gostima';
$string['anonymous'] = 'Anoninmno';
$string['anonymous_answers'] = 'Anonimni odgovori (prisustvo se može videti)';
$string['anonymous_answers_info'] = 'Odgovori su anonimni u ovoj sesiji. Vaše prisustvo se i dalje beleži.';
$string['answer'] = 'Odgovor';
$string['ask_teacher'] = 'Ako ste u nedoumici, pitajte predavača.';
$string['attempt_started'] = 'Vi ste već započeli pokušaj, kliknite ispod kako biste nastavili sa svojim započetim pokušajem';
$string['attempts'] = 'Pokušaji';
$string['attendance'] = 'Prisustvo';
$string['attendance_list'] = 'Spisak prisutnih';
$string['click_to_show_original_results'] = 'Kliknite kako biste prikazali originalne rezultate';
$string['click_to_show_vote_results'] = 'Kliknite kako biste videli rezultate glasanja';
$string['closing_session'] = 'Zatvaranje sesije...';
$string['create_new_question'] = 'Kreirajte novo pitanje';
$string['default_question_time'] = 'Podrazumevano vreme prikazivanja pitanja';
$string['default_question_time_help'] = 'Podrazumevano vreme za prikaz svakog pitanja.<br>Ovo se može izmeniti unutar svakog pojedinačnog pitanja.';
$string['delete_question'] = 'Obriši pitanje {$a}';
$string['delete_report'] = 'Obriši izveštaj';
$string['download_attendance_list'] = 'Preuzmite spisak prisutnih';
$string['download_report'] = 'Preuzmite izveštaj';
$string['download_responses'] = 'Preuzmite odgovore';
$string['edit'] = 'Uredi';
$string['edit_page_open_session_error'] = 'Ne možete da uređujete test dok je sesija otvorena.';
$string['edit_question'] = 'Uredi pitanje';
$string['end'] = 'Kraj';
$string['error_getting_current_results'] = 'Došlo je do greške prilikom preuzimanja trenutnih rezultata.';
$string['error_getting_vote_results'] = 'Došlo je do greške prilikom preuzimanja rezultata glasanja.';
$string['error_saving_vote'] = 'Došlo je do greške prilikom pokušaja da se sačuva vaš glas.';
$string['error_starting_vote'] = 'Došlo je do greške prilikom pokretanja glasanja.';
$string['error_with_request'] = 'Došlo je do greške sa zahtevom.';
$string['event_attempt_started'] = 'Pokušaj je započet';
$string['event_question_answered'] = 'Na pitanje je odgovoreno u okviru pokušaja';
$string['exit'] = 'Izlaz';
$string['failed_to_end_question'] = 'Pokušaj da se završi pitanje nije uspeo.';
$string['fullscreen'] = 'Prikaz preko celog ekrana';
$string['fully_anonymous'] = 'Potpuno anonimno';
$string['fully_anonymous_info'] = 'И одговори и присуство су потпуно анонимни у овој сесији.';
$string['goto_session'] = 'Idite na sesiju koja u toku';
$string['guest_login'] = 'Niste upisani na kurs i trenutno ne postoji sesija testa koja je otvorena za goste.';
$string['improvise'] = 'Improvizujte';
$string['instructions_for_instructor'] = '<h3>Obavezno pročitajte uputstva:</h3>
<p>Dostupne su prečice koje se mogu upotrebiti kada polje za unos nije u fokusu.</p>
<table>
    <tbody>
        <tr>
            <th>Kontrolna komanda</th>
            <th>Prečica</th>
            <th>Opis</th>
        </tr>
        <tr>
            <td>
                <i class="fa fa-repeat"></i> Ponovno glasanje
            </td>
            <td>r</td>
            <td>
                Dozvoljava predavaču da ponovi pitanje koje je upravo postavljeno.
                Ovo je isto kao da se započinje sa pitanjem iz <i class="fa fa-bars"></i> padajućeg spiska ”Prelaz”.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-bar-chart"></i> Glasanje
            </td>
            <td>v</td>
            <td>
                Daje mogućnost polaznicima da glasaju tj. pošalju svoje odgovore.
                Predavač može da klikne na odgovor kako bi promenio da li ga treba uključiti u glasanje ili ne.
                Klikom na traku odgovora započinje spajanje tog odgovora.
                Note that this bar will consume the bar you click on next.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-edit"></i> Improvizacija
            </td>
            <td>i</td>
            <td>
                Prikazuje spisak pitanja napravljenih za improvizaciju. Napišite pitanje na tabli i zamolite polaznike da odgovore na ova pitanja.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-bars"></i> Prelaz
            </td>
            <td>j</td>
            <td>
                Prikazuje spisak svih pitanja planiranih za test.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-forward"></i> Sledeće pitanje
            </td>
            <td>n</td>
            <td>
                Nastavlja sa sledećim pitanjem sa spiska planiranih pitanja.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-random"></i> Nasumično
            </td>
            <td>m</td>
            <td>
                Započinje se nasumično odabranim pitanjem sa spiska planiranih pitanja.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-close"></i> Kraj
            </td>
            <td>e</td>
            <td>
                Završetak tekućeg pitanje.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-expand"></i> Prikaz preko celog ekrana
            </td>
            <td>f</td>
            <td>
                Prikaz rezultate preko celog ekrana. Odgovori se neće pojavljivati dok je pitanje postavljeno, tako da možete nastaviti sa ovim tokom cele sesije.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-square-o"></i>/ <i class="fa fa-check-square-o"></i> Odgovor
            </td>
            <td>a</td>
            <td>
                Prikazuje predavaču pitanje sa izabranim tačnim odgovorom.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-square-o"></i>/ <i class="fa fa-check-square-o"></i> Odgovori polaznika
            </td>
            <td>t (prekidač)</td>
            <td>
                Sakriva ili prikazuje odgovore polaznika.
            </td>
        </tr>
        <tr>
            <td>
                <i class="fa fa-window-close"></i> Prekid sesije
            </td>
            <td></td>
            <td>
                Izlazak iz tekuće sesije testa.
            </td>
        </tr>
    </tbody>
</table>';
$string['instructions_for_student'] = '<p> Sačekajte da instruktor započne test.</p>';
$string['instructor_sessions_going'] = 'Sesija je već u toku. Kliknite na dugme ispod kako biste se priključili sesiji';
$string['invalid_question_time'] = 'Vreme za pitanje mora biti ceo broj od 0 pa naviše';
$string['jazzquiz:addinstance'] = 'Dodajte probni JazzQuiz testa';
$string['jazzquiz:attempt'] = 'Pokušaj rešavanja JazzQuiz testa';
$string['jazzquiz:control'] = 'Kontrola JazzQuiz (obično samo za predavače).';
$string['jazzquiz:editquestions'] = 'Uređivanje pitanja za JazzQuiz.';
$string['jazzquiz:seeresponses'] = 'Pregled odgovora drugih polaznika kako bi bili ocenjeni';
$string['jazzquizsettings'] = 'Opšta JazzQuiz podešavanja';
$string['join_quiz'] = 'Pristupi testu';
$string['join_quiz_instructions'] = 'Kliknite na donje dugme da biste pristupili testu';
$string['jump'] = 'Prelaz';
$string['loading'] = 'Učitava se...';
$string['modulename'] = 'JazzQuiz';
$string['modulename_help'] = '<p>
    Aktivnost JazzQuiz daje mogućnost predavačima da kreiraju i administriraju testove u realnom vremenu. U ovoj aktivnosti mogu se koristiti svi uobičajeni tipovi pitanja za test.
</p>
<p>
    Dok vodi sesiju predavač ima mogućnost da bira različita pitanja, redosledom kojim on želi, čak i da pojedina pitanja preskoči.
    Odgovori se prikazuju uživo u obliku grafikona, optimizovanog za projektore. Režim prikaza preko celog ekrana je takođe dostupan.
    Vremensko ograničenje može biti postavljeno tako da se pitanje nakon zadatog vremenskog intervala automatski završi, ili da ga predavač sam ručno završi i pređe na sledeće pitanje, po izboru.
</p>';
$string['modulenameplural'] = 'JazzQuiz testovi';
$string['multichoice_options'] = 'Opcije za višestruki izbor';
$string['next'] = 'Sledeće pitanje';
$string['no_attempts_found'] = 'Nije pronađen nijedan pokušaj.';
$string['no_guests'] = 'Moguće je da predavač još nije započeo test, pa možete pokušati ponovo kasnije. Takođe je moguće da ćete morati da se prijavite kao polaznik i upišete se na kurs kako biste mogli da vidite test i učestvujete u njegovom rešavanju.';
$string['no_session'] = 'Nema otvorene sesije';
$string['no_sessions_exist'] = 'Još ne postoje sesije.';
$string['no_students_have_joined'] = 'Nijedan polaznik se nije pridružio.';
$string['no_time_limit'] = 'Bez vremenskog ograničenja';
$string['no_time_limit_help'] = 'Označite ovo polje kako bi pitanje bilo prikazano bez tajmera. <p>U tom slučaju od predavača će se očekivati da klikne na dugme za kraj pitanja kako bi se završilo prikazivanje pitanja</p>';
$string['nonanonymous_session'] = 'Neanonimna sesija';
$string['nonanonymous_session_info'] = 'Ovo je neanonimna sesija. Biće zabeleženi, kako vaše prisustvo, tako i vaši odgovori.';
$string['one_student_has_joined'] = '1 polaznik se pridružio.';
$string['pluginadministration'] = 'JazzQuiz administracija';
$string['pluginname'] = 'JazzQuiz';
$string['privacy:metadata:core_question'] = 'Aktivnost JazzQuiz čuva informacije o upotrebi pitanja u podsistemu core_question.';
$string['privacy:metadata:jazzquiz_attempts'] = 'Detalji o pokušaju rešavanja testa za JazzQuiz sesiju.';
$string['privacy:metadata:jazzquiz_attempts:responded'] = 'Da li je dat odgovor ili nije na poslednje postavljeno pitanje.';
$string['privacy:metadata:jazzquiz_attempts:timefinish'] = 'Vreme kada je poslednje pitanje u pokušaju rešavanja testa završeno.';
$string['privacy:metadata:jazzquiz_attempts:timemodified'] = 'Vreme kada je poslednje pitanje u pokušaju rešavanja testa promenjeno.';
$string['privacy:metadata:jazzquiz_attempts:timestart'] = 'Vreme kada je poslednje pitanje u pokušaju rešavanja testa započeto.';
$string['privacy:metadata:jazzquiz_attempts:userid'] = 'Korisnik koji je načinio pokušaj.';
$string['question'] = 'Pitanje';
$string['question_move_down'] = 'Помери питање {$a} надоле';
$string['question_move_up'] = 'Pomeri pitanje {$a} nagore';
$string['question_time'] = 'Vreme za pitanje';
$string['question_time_help'] = 'Vreme za pitanje u sekundama.';
$string['question_will_end_in_x_seconds'] = 'Pitanje će se završiti za {$a} sekunde/i';
$string['question_will_start_in_x_seconds'] = 'Pitanje će biti prikazano za {$a} sekunde/i';
$string['question_will_start_now'] = 'Pitanje će se pojaviti sada';
$string['questions'] = 'Pitanja';
$string['quit'] = 'Prekid sesije';
$string['quiz_not_running'] = '<p>Sačekajte da vaš predavač započne test.</p><p>Upotrebite dugme za ponovno učitavanje kako biste proverili da li je test započeo.</p>';
$string['random'] = 'Nasumilčno';
$string['repoll'] = 'Ponovno glasanje';
$string['reports'] = 'Izveštaji';
$string['responses'] = 'Odgovori';
$string['review'] = 'Pregled';
$string['save_question'] = 'Sačuvaj pitanje';
$string['select_session'] = 'Izaberite sesiju za pregled:';
$string['session'] = 'Sesija';
$string['session_closed'] = 'Sesija je sada zatvorena';
$string['session_name'] = 'Naziv sesije';
$string['session_name_required'] = 'Naziv sesije je obavezan';
$string['short_answer'] = 'Kratak odgovor';
$string['short_math_answer'] = 'Kratak matematički odgovor';
$string['showing_original_results'] = 'Prikazuju se originalni rezultati';
$string['showing_vote_results'] = 'Prikazuju se rezultata glasanja';
$string['start_session'] = 'Započnite sesiju';
$string['startquiz'] = 'Započnite test';
$string['student'] = 'Polaznik';
$string['teacher_start_instructions'] = '<p> Započnite test za polaznike.</p><p>Definišite naziv sesije u nastavku kako biste kasnije lakše pregledali rezultate.</p>';
$string['unable_to_create_session'] = 'Nije moguće kreirati sesiju';
$string['view'] = 'Pregled';
$string['vote'] = 'Glasanje';
$string['wait_for_instructor'] = 'Sačekajte da instruktor započne sledeće pitanje.';
$string['wait_for_question_time'] = 'Vreme čekanje na sledeće pitanje';
$string['wait_for_question_time_help'] = 'Vreme čekanja do pojavljivanja sledećeg pitanja.';
$string['wait_for_students'] = 'Čeka se da se polaznici povežu';
$string['x_seconds_left'] = 'Preostalo vreme: {$a}s';
$string['x_students_have_joined'] = 'Broj polaznika koji se pridružio {$a}.';
$string['you_already_voted'] = 'Izvinite, ali već ste poslali svoj odgovor.';
