<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'aiprovider_openai', language 'it', version '5.0'.
 *
 * @package     aiprovider_openai
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action:explain_text:endpoint'] = 'Endpoint API';
$string['action:explain_text:model'] = 'Modello AI';
$string['action:explain_text:model_help'] = 'Il modello da utilizzare per spiegare il testo.';
$string['action:explain_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:explain_text:systeminstruction_help'] = 'Queste istruzioni vengono inviata al modello AI insieme al prompt dell\'utente. Non è consigliabile modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['action:generate_image:endpoint'] = 'Endpoint API';
$string['action:generate_image:model'] = 'Modello IA';
$string['action:generate_image:model_desc'] = 'Modello utilizzato per generare immagini a partire dai prompt degli utenti.';
$string['action:generate_image:model_help'] = 'Il modello utilizzato per generare immagini a partire dai prompt degli utenti.';
$string['action:generate_text:endpoint'] = 'Endpoint API';
$string['action:generate_text:model'] = 'Modello IA';
$string['action:generate_text:model_desc'] = 'Il modello utilizzato per generare la risposta testuale.';
$string['action:generate_text:model_help'] = 'Il modello utilizzato per generare la risposta testuale.';
$string['action:generate_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:generate_text:systeminstruction_desc'] = 'Queste istruzioni verranno inviate al modello IA assieme al prompt dell\'utente. Non è consigliabile modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['action:generate_text:systeminstruction_help'] = 'Le istruzioni verranno inviate al modello AI insieme al prompt dell\'utente. Non è consigliabile modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['action:summarise_text:endpoint'] = 'Endpoint API';
$string['action:summarise_text:model'] = 'Modello IA';
$string['action:summarise_text:model_desc'] = 'Il modello utilizzato per riassumere il testo fornito.';
$string['action:summarise_text:model_help'] = 'Il modello utilizzato per riassumere il testo fornito.';
$string['action:summarise_text:systeminstruction'] = 'Istruzioni di sistema';
$string['action:summarise_text:systeminstruction_desc'] = 'Queste istruzioni verranno inviate al modello IA assieme al prompt dell\'utente. Non è consigliabile modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['action:summarise_text:systeminstruction_help'] = 'Le istruzioni verranno inviate al modello AI insieme al prompt dell\'utente. Non è consigliabile modificare queste istruzioni, a meno che non sia assolutamente necessario.';
$string['apikey'] = 'Chiave API OpenAI';
$string['apikey_desc'] = 'Per ottenere una chiave: <a href="https://platform.openai.com/account/api-keys">OpenAI Platform API keys</a>.';
$string['apikey_help'] = 'Per ottenere una chiave: <a href="https://platform.openai.com/account/api-keys" target="_blank">chiavi API OpenAI</a>.';
$string['custom_model_name'] = 'Nome del modello personalzzato';
$string['enableglobalratelimit'] = 'Limitazione globale delle richieste';
$string['enableglobalratelimit_desc'] = 'Limita il numero di richieste all\'ora che il provider dell\'API OpenAI può ricevere globalmente dal sito.';
$string['enableuserratelimit'] = 'Limitazione utente delle richieste';
$string['enableuserratelimit_desc'] = 'Limita il numero di richieste all\'ora che ogni utente può effettuare al provider dell\'API OpenAI.';
$string['extraparams'] = 'Parametri extra';
$string['extraparams_help'] = 'Consente di configurare parametri aggiuntivi. Il formato JSON è suportato. Ad esempio:
<pre>
{
  "temperature": 0.5,
  "max_completion_tokens": 100
}
</pre>';
$string['globalratelimit'] = 'Massimo numero di richieste globali';
$string['globalratelimit_desc'] = 'Il numero di richieste all\'ora consentite globalmente.';
$string['invalidjson'] = 'Stringa JSON non valida';
$string['orgid'] = 'ID organizzazione OpenAI';
$string['orgid_desc'] = 'Ottieni l\'ID OpenAI  della tua organizzazione dal tuo <a href="https://platform.openai.com/account/org-settings">OpenAI Platform account</a>.';
$string['orgid_help'] = 'Per ottenere l\'ID della organizzazione OpenAI: <a href="https://platform.openai.com/account/org-settings" target="_blank">account OpenAI</a>.';
$string['pluginname'] = 'Provider API OpenAI';
$string['privacy:metadata'] = 'Il plugin provider API OpenAI non memorizza dati personali.';
$string['privacy:metadata:aiprovider_openai:externalpurpose'] = 'Queste informazioni vengono inviate all\'API di OpenAI per generare una risposta. Le impostazioni dell\'account OpenAI potrebbero modificare il modo in cui OpenAI archivia e conserva questi dati. Nessun dato utente viene inviato esplicitamente a OpenAI o archiviato in Moodle LMS da questo plugin.';
$string['privacy:metadata:aiprovider_openai:model'] = 'Modello utilizzato per generare la risposta.';
$string['privacy:metadata:aiprovider_openai:numberimages'] = 'Numero di immagini utilizzate nella risposta durante la generazione di immagini.';
$string['privacy:metadata:aiprovider_openai:prompttext'] = 'prompt di testo inserito dall\'utente ed utilizzato per generare la risposta.';
$string['privacy:metadata:aiprovider_openai:responseformat'] = 'Formato della risposta. Quando si generano immagini.';
$string['settings'] = 'Impostazioni';
$string['settings_frequency_penalty'] = 'frequency_penalty';
$string['settings_frequency_penalty_help'] = 'La penalità di frequenza regola la frequenza con cui le parole vengono ripetute. Maggiore è la penalità, minore sarà il numero di ripetizioni nel testo generato.';
$string['settings_help'] = 'Regolare le impostazioni seguenti per personalizzare il modo in cui le richieste vengono inviate a OpenAI.';
$string['settings_max_completion_tokens'] = 'max_completion_tokens';
$string['settings_max_completion_tokens_help'] = 'Il numero massimo di token da generare nella risposta.';
$string['settings_max_tokens'] = 'max_tokens';
$string['settings_max_tokens_help'] = 'Il numero massimo di token da generare nella risposta.';
$string['settings_presence_penalty'] = 'presence_penalty';
$string['settings_presence_penalty_help'] = 'La penalità di presenza incoraggia il modello a usare parole nuove, aumentando la probabilità di scegliere parole mai usate prima. Un valore più alto rende il testo generato più vario, mentre un valore più basso consente una maggiore ripetizione.';
$string['settings_top_p'] = 'top_p';
$string['settings_top_p_help'] = 'top_p (campionamento del nucleo) determina quante possibili parole considerare. Un valore elevato (ad esempio 0,9) indica che il modello considera più parole, il che rende il testo generato più diversificato.';
$string['userratelimit'] = 'Massimo numero di richieste utente';
$string['userratelimit_desc'] = 'Il numero di richieste all\'ora consentite a ciascun utente.';
