<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'it', version '5.0'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Azioni';
$string['activate'] = 'Abilita accesso';
$string['activatesuccess'] = 'L\'accesso al badge \'{$a}\' è stato abilitato.';
$string['addalignment'] = 'Aggiungi standard o abilità esterno';
$string['addbadge'] = 'Aggiungi badge';
$string['addbadge_help'] = 'Seleziona i badge da aggiungere come criterio. Tenere premuto il pulsante CTRL per selezionare più badge.';
$string['addbadgecriteria'] = 'Aggiungi criterio';
$string['addcohort'] = 'Aggiungi gruppo globale';
$string['addcohort_help'] = 'Seleziona i gruppi globali che consentono di conseguire questo badge. Tieni premuto il tasto CTRL per selezionare più gruppi globali.';
$string['addcompetency'] = 'Aggiungi competenza';
$string['addcompetency_help'] = 'Seleziona le competenze che consentono di conseguire questo badge. Tieni premuto il tasto CTRL per selezionare più corsi.';
$string['addcourse'] = 'Aggiungi corsi';
$string['addcourse_help'] = 'Seleziona i corsi che consentono di conseguire questo badge. Tieni premuto il tasto CTRL per selezionare più corsi.';
$string['addcriteria'] = 'Aggiungi criterio';
$string['addcriteriatext'] = 'Per aggiungere criteri, selezionare una della opzioni presenti nel menu a discesa.';
$string['addcriterion'] = 'Aggiungi criterio';
$string['addedtobackpack'] = 'Il badge è stato aggiunto al backpack';
$string['addrelated'] = 'Aggiungi badge correlato';
$string['addtobackpack'] = 'Aggiungi al backpack';
$string['adminonly'] = 'Solo gli amministratori del sito sono autorizzati ad accedere a questa pagina';
$string['after'] = 'dopo la data di rilascio';
$string['aggregationmethod'] = 'Metodo di aggregazione';
$string['alignment'] = 'Equivalenza';
$string['all'] = 'Tutti';
$string['allmethod'] = 'Tutte le condizioni selezionate devono essere soddisfatte';
$string['allmethodactivity'] = 'Completamento di tutte le attività selezionate';
$string['allmethodbadges'] = 'Conseguimento di tutti i badge selezionati';
$string['allmethodcohort'] = 'Appartenenza a tutti gruppi globali selezionati';
$string['allmethodcompetencies'] = 'Tutte le competenze selezionate devono essere raggiunte';
$string['allmethodcourseset'] = 'Completamento di tutti i corsi selezionati';
$string['allmethodmanual'] = 'Rilascio da parte di tutti i ruoli selezionati';
$string['allmethodprofile'] = 'Compilazione di tutti i campi del profilo utente selezionati';
$string['allowcoursebadges'] = 'Abilita badge nei corsi';
$string['allowcoursebadges_desc'] = 'Consente di creare ed assegnare badge nei corsi';
$string['allowexternalbackpack'] = 'Abilita collegamento a backpack esterni';
$string['allowexternalbackpack_desc'] = 'Gli utenti potranno impostare collegamenti a backpack esterni e caricarvi i badge conseguiti in questo sito. Gli utenti potranno anche scegliere di visualizzare raccolte pubbliche di badge presenti nel loro backpack. Si raccomanda di disabilitare l\'opzione qualora il sito non sia raggiungibile da internet.';
$string['any'] = 'Almeno uno';
$string['anymethod'] = 'Almeno una delle seguenti condizioni deve essere soddisfatta';
$string['anymethodactivity'] = 'Completamento di almeno una delle attività selezionate';
$string['anymethodbadges'] = 'Conseguimento di almeno uno dei badge selezionati';
$string['anymethodcohort'] = 'Appartenenza ad almeno uno dei gruppi globali selezionati';
$string['anymethodcompetencies'] = 'Almeno una delle competenze selezionate deve essere raggiunta';
$string['anymethodcourseset'] = 'Completamento di almeno uno dei corsi selezionati';
$string['anymethodmanual'] = 'Rilascio da parte di almeno uno dei ruoli selezioanti';
$string['anymethodprofile'] = 'Compilazione di almeno uno dei campi del profilo utente selezionati';
$string['apiversion'] = 'Versione API supportata';
$string['archivebadge'] = 'Vuoi eliminare il badge \'{$a}\'  mantenendo i badge rilasciati?';
$string['archiveconfirm'] = 'Elimina e mantieni i badge rilasciati';
$string['archivehelp'] = '<p>Con questa opzione il badge sarà contrassegnato come "ritirato" e non comparirà più nell\'elenco dei badge. Gli utenti non potranno più conseguire il badge ma coloro i quali lo hanno già conseguito potranno comunque visualizzarlo nella pagina del proprio profilo e caricarlo su backpack esterni.</p>
<p>Se desideri che gli utenti mantengano l\'accesso al badge, è necessario scegliere questa opzione.</p>';
$string['attachment'] = 'Allega badge al messaggio';
$string['attachment_help'] = 'Consente di allegare il file del badge al messaggio indirizzato al destinatario. Prerequisito è l\'abilitazione degli allegati alle email in Amministrazione del sito > Plugin > Instradamento messaggi > Email.';
$string['award'] = 'Rilascia badge';
$string['awardedto'] = 'Rilasciato a {$a}';
$string['awardedtoyou'] = 'Conseguiti da me';
$string['awardoncron'] = 'Molti utenti stanno conseguendo il badge \'{$a->badgename}\'. l\'operazione di recapito dei badge potrà impiegare diverso tempo.';
$string['awards'] = 'Destinatari';
$string['backpackapiurl'] = 'URL delle API del backpack';
$string['backpackavailability'] = 'Verifica esterna badge';
$string['backpackavailability_help'] = 'Affinché i destinatari dei badge ne possano provare il conseguimento, un servizio backpack esterno deve essere in grado di accedere al tuo sito per verificarne il rilascio.
Il tuo sito sembra che non sia raggiungibile, quindi non è possibile verificare né i badge già rilasciati né i badge che saranno rilasciati in futuro.

**Perché visualizzo questo messaggio ?**

È possibile che un firewall impedisca l\'accesso da un rete esterna, che lo spazio web sia protetto da password oppure che il sito giri su un computer che non può essere acceduto da internet (ad esempio una macchina locale di sviluppo).

**È un problema ?**

Se nel tuo sito di produzione vuoi rilasciare badge, allora devi risolvere il problema altrimenti i destinatari dei badge non ne potranno provare il conseguimento. Se il tuo sito non è ancora in produzione, puoi creare e rilasciare badge di test prima che il tuo sito passi in produzione.

**Come posso fare qualora non fosse possibile pubblicare l\'intero sito ?**

L\'unico URL necessario per la verifica è [your-site-url]/badges/assertion.php. Per la sola verifica dei badge è sufficiente l\'accesso a quell\'URL.';
$string['backpackbadgessettings'] = 'Modifica impostazioni backpack';
$string['backpackbadgessummary'] = 'Sono visualizzati {$a->totalbadges} badge provenienti da {$a->totalcollections} raccolte.';
$string['backpackcannotsendverification'] = 'Non è stato possibile inviare l\'email di verifica';
$string['backpackconnected'] = 'Il backpack è collegato';
$string['backpackconnection'] = 'Collegamento al backpack';
$string['backpackconnection_connected'] = 'Il tuo backpack';
$string['backpackconnection_help'] = 'Il collegamento al backpack consente di caricare i badge conseguiti in questo sito. Potrai anche scegliere di visualizzare raccolte pubbliche di badge presenti nel tuo backpack.';
$string['backpackconnectioncancelattempt'] = 'Collegati utilizzando un indirizzo email diverso';
$string['backpackconnectionconnect'] = 'Collegati al backpack';
$string['backpackconnectionnottested'] = 'Non è possibile testare il collegamento con il backpack poiché solo i backpack Open Badges v2.0 lo supportano il test.';
$string['backpackconnectionok'] = 'Il collegamento con il backpack è avvenuto correttamente';
$string['backpackconnectionresendemail'] = 'Invia nuovamente l\'email di verifica';
$string['backpackconnectionunexpectedmessage'] = 'Il backpack ha restituito il seguente errore: "{$a}"';
$string['backpackconnectionunexpectedresult'] = 'Si è verificato un problema durante il collegamento al backpack. Il backpack provider ha inviato il seguente messaggio: \'{$a}\'.';
$string['backpackdetails'] = 'Impostazioni backpack';
$string['backpackdisconnected'] = 'Il backpack non è collegato';
$string['backpackemail_required'] = 'L\'indirizzo email non può essere vuoto';
$string['backpackemailverificationpending'] = 'Verifica in attesa';
$string['backpackemailverifyemailbody'] = 'Gentile {$a->userfirstname},

il collegamento al backpack dei badge su \'{$a->sitename}\' è quasi pronto.

Per completare il collegamento al backpack, devi verificare la tua email utilizzando il pulsante sottostante:

{$a->buttonlink}

Se il pulsante non funziona, copia ed incolla il seguente URL nel tuo browser:
{$a->link}

Se non sei stati t a richiedere il collegamento al backpack, puoi ignorare questa email.

Se hai bisogno di aiuto, contatta l\'amministratore del sito:
{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: email di verifica del backpack';
$string['backpackemailverifypending'] = 'Un\'email di verifica è stata inviata a <strong>{$a}</strong>. Fai click sul link di verifica nell\'email per attivare il collegamento al tuo backpack.';
$string['backpackemailverifysuccess'] = 'Ora sei collegato con il tuo backpack.';
$string['backpackemailverifytokenmismatch'] = 'Il token nel link su cui hai cliccato non corrisponde al token memorizzato. Verifica di aver cliccato il link nella email più recente che hai ricevuto.';
$string['backpackexporterror'] = 'Non è possibile esportare il badge nel backpack';
$string['backpackexporterrorwithinfo'] = 'Non è possibile esportare il badge "{$a->badgename}" nel backpack. Errore: {$a->error}';
$string['backpackimport'] = 'Impostazioni importazione badge';
$string['backpackimport_help'] = 'Dopo aver stabilito il collegamento, i badge provenienti dal backpack compariranno nella sezione Badge e nel tuo profilo.

È anche possibile selezionare le raccolte di badge nel tuo backpack per visualizzarle nel tuo profilo.';
$string['backpackprovider'] = 'Provider backpack';
$string['backpacksettings'] = 'Impostazioni backpack';
$string['backpackweburl'] = 'URL del backpack';
$string['badgedetails'] = 'Dettagli badge';
$string['badgeimage'] = 'Immagine';
$string['badgeimage_help'] = 'L\'immagine deve avere una dimensione di ameno 300 x 300 pixel. Sarà visualizzata con dimensione 300 x 300 pixel nella pagina del badge e con dimensione 100 x100 pixel nella pagina del profilo utente.';
$string['badgeimageinfo'] = 'Per ottenere risultati ottimali, caricare un\'immagine quadrata con una dimensione minima di 300 x 300 pixel.';
$string['badgeissued'] = 'Badge rilasciati';
$string['badgeprivacysetting'] = 'Impostazioni di privacy del badge';
$string['badgeprivacysetting_help'] = 'I badge conseguiti possono essere visualizzati automaticamente nella pagina del profilo. L\'impostazione definisce la visibilità dei nuovi badge conseguiti.

È possibile controllare la privacy di specifici badge nella propria pagina "Badge"';
$string['badgeprivacysetting_str'] = 'Visualizza automaticamente nel mio profilo i badge conseguiti';
$string['badges'] = 'Badge';
$string['badgesalt'] = 'Salt per l\'hashing dell\'indirizzo email del destinatario';
$string['badgesalt_desc'] = 'L\'hash consente ai servizi backpack di confermare i badge conseguiti dagli utenti senza dover rivelare il loro indirizzo email. L\'impostazione deve contenere solo numeri e lettere.

Nota: per consentire la verifica dei destinatari evitare di modificare questa impostazione dopo aver cominciato a rilasciare badge.';
$string['badgesdisabled'] = 'In questo sito i badge non sono attivi.';
$string['badgesearned'] = 'Numero di badge conseguiti: {$a}';
$string['badgesettings'] = 'Impostazioni badge';
$string['badgesnavigation'] = 'Navigazione badge';
$string['badgestatus_0'] = 'Non disponibile';
$string['badgestatus_1'] = 'Disponibile';
$string['badgestatus_2'] = 'Non disponibile (criteri bloccati)';
$string['badgestatus_3'] = 'Disponibile (criteri bloccati)';
$string['badgestatus_4'] = 'Archiviato';
$string['badgestoearn'] = 'Numero di badge disponibili: {$a}';
$string['badgesview'] = 'Badge del corso';
$string['badgetags'] = 'Tag dei badge';
$string['badgeurl'] = 'Link al badge rilasciato';
$string['balignment'] = 'Equivalenze ({$a})';
$string['bawards'] = 'Rilasci ({$a})';
$string['bcriteria'] = 'Criteri';
$string['bdetails'] = 'Modifica';
$string['bendorsement'] = 'Garanzia di terzi';
$string['bmessage'] = 'Messaggio';
$string['boverview'] = 'Panoramica';
$string['brelated'] = 'Badge correlato: ({$a})';
$string['bydate'] = 'Da completare entro';
$string['canvascredentialsprovider'] = 'Credenziali Canvas';
$string['canvasregions'] = 'Regione delle credenziali Canvas';
$string['canvasregions_desc'] = 'È possibile configurare il contenuto delle regioni Canvas Credentials. Ogni riga è separata da caratteri pipe e contiene 1) il nome della regione, 2) l\'URL del backpack e 3) l\'URL dell\'API backpack.';
$string['claim'] = 'Verifica';
$string['claimcomment'] = 'Commento della garanzia di terzi';
$string['claimid'] = 'URL della garanzia di terzi';
$string['clearsettings'] = 'Elimina impostazioni';
$string['completioninfo'] = 'Il badge è stato rilasciato a valle del completamento di:';
$string['completionnotenabled'] = 'In questo corso il completamento non è abilitato e pertanto non è possibile utilizzare il completamento del corso come criterio di conseguimento del badge. È possibile abilitare il completamento nelle impostazioni del corso.';
$string['configenablebadges'] = 'Consente di creare badge e rilasciarli agli utenti del sito';
$string['configuremessage'] = 'Messaggio badge';
$string['connect'] = 'Collega';
$string['connected'] = 'Collegato';
$string['connecting'] = 'Collegamento in corso...';
$string['contact'] = 'Email';
$string['contact_help'] = 'Indirizzo email associato con chi rilascia il badge';
$string['copy'] = 'Copia';
$string['copyof'] = 'Copia di {$a}';
$string['course'] = 'Corso: {$a}';
$string['coursebadges'] = 'Badge';
$string['coursebadgesdisabled'] = 'I badge del corso non sono abilitati.';
$string['coursebadgetitle'] = '{$a} badge del corso';
$string['coursecompletion'] = 'Gli utenti devono completare il corso';
$string['create'] = 'Aggiungi badge';
$string['createbutton'] = 'Crea badge';
$string['creatorbody'] = '<p>{$a->user} ha soddisfatto i criteri necessari ed ha conseguito il badge. Per vedere il badge rilasciato:  {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\' è stato conseguito!';
$string['criteria_0'] = 'Criteri di rilascio badge';
$string['criteria_1'] = 'Completamento attività';
$string['criteria_1_help'] = 'Il badge sarà rilasciato al completamento di un insieme di attività del corso';
$string['criteria_2'] = 'Rilascio manuale in base al ruolo';
$string['criteria_2_help'] = 'Il badge sarà rilasciato manuamente da utenti che posseggono uno specifico ruolo a livello di sito o di corso.';
$string['criteria_3'] = 'Partecipazione relazionale';
$string['criteria_3_help'] = 'Relazionale';
$string['criteria_4'] = 'Completamento corso';
$string['criteria_4_help'] = 'Il badge sarà rilasciato al completamento del corso. Questo requisito può avere parametri addizionali come ad esempio il punteggio minimo richiesto o la data di completamento corso.';
$string['criteria_5'] = 'Completamento di un gruppo di corsi';
$string['criteria_5_help'] = 'Il badge sarà rilasciato a coloro che completeranno un gruppo di corsi. Per ogni corso è possibile impostare parametri come il punteggio minimo o la data di completamento.';
$string['criteria_6'] = 'Compilazione profilo utente';
$string['criteria_6_help'] = 'Il badge sarà rilasciato a coloro che compileranno determinati campi del profilo utente. È possibile selezionare sia campi standard sia campi personalizzati.';
$string['criteria_7'] = 'Rilascio badge';
$string['criteria_7_help'] = 'Il badge sarà rilasciato sulla base di altri badge conseguiti dall\'utente.';
$string['criteria_8'] = 'Appartenenza a gruppi globali';
$string['criteria_8_help'] = 'Il badge sarà rilasciato sulla base dell\'appartenenza a gruppi globali';
$string['criteria_9'] = 'Competenze';
$string['criteria_9_help'] = 'Il badge sarà rilasciato sulla base del raggiungimento dei competenze.';
$string['criteria_descr'] = 'Gli utenti conseguono il badge al soddisfacimento dei requisti elencati:';
$string['criteria_descr_0'] = 'Gli utenti conseguono il badge se <strong>{$a}</strong> dei requisiti elencati risultano soddisfatti';
$string['criteria_descr_1'] = 'Le seguenti attività devono essere completate (<strong>{$a}</strong>):';
$string['criteria_descr_2'] = 'Il badge viene conseguito se i ruoli elencati (<strong>{$a}</strong>) lo rilasciano:';
$string['criteria_descr_4'] = 'Gli utenti devono completare il corso';
$string['criteria_descr_5'] = 'I seguenti corsi devono essere completati (<strong>{$a}</strong>):';
$string['criteria_descr_6'] = 'I seguenti campi del profilo utente devono essere compilati (<strong>{$a}</strong>):';
$string['criteria_descr_7'] = 'Devono essere conseguiti <strong>{$a}</strong> dei seguenti badge';
$string['criteria_descr_8'] = 'Deve appartenere ai gruppi globali sottostanti secondo il criterio seguente: <strong>{$a}</strong>';
$string['criteria_descr_9'] = 'Le seguenti competenze devono essere raggiunte (<strong>{$a}</strong>):';
$string['criteria_descr_bydate'] = 'entro il <em>{$a}</em>';
$string['criteria_descr_grade'] = 'con un punteggio minimo di <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Criteri da soddisfare (<strong>{$a}</strong>):';
$string['criteria_descr_short1'] = 'Completamento attività (<strong>{$a}</strong>):';
$string['criteria_descr_short2'] = 'Rilascio da parte di ruoli (<strong>{$a}</strong>):';
$string['criteria_descr_short4'] = 'Completare il corso&nbsp;';
$string['criteria_descr_short5'] = 'Completamento corsi (<strong>{$a}</strong>):';
$string['criteria_descr_short6'] = 'Compilazione campi profilo (<strong>{$a}</strong>):';
$string['criteria_descr_short7'] = 'Completare <strong>{$a}</strong> di:';
$string['criteria_descr_short8'] = 'Appartenenza ai gruppi globali sottostanti secondo il criterio seguente: <strong>{$a}</strong>';
$string['criteria_descr_short9'] = 'Completare <strong>{$a}</strong> di:';
$string['criteria_descr_single_1'] = 'La seguente attività deve essere completata:';
$string['criteria_descr_single_2'] = 'Il badge viene conseguito se il ruolo seguente lo rilascia:';
$string['criteria_descr_single_4'] = 'Gli utenti devono completare il corso';
$string['criteria_descr_single_5'] = 'Corso da completare:';
$string['criteria_descr_single_6'] = 'Attività da completare:';
$string['criteria_descr_single_7'] = 'Deve essere conseguito il seguente badge:';
$string['criteria_descr_single_8'] = 'È necessaria l\'appartenenza al seguente gruppo globale:';
$string['criteria_descr_single_9'] = 'Le seguente competenze devono essere raggiunte:';
$string['criteria_descr_single_short1'] = 'Completare:';
$string['criteria_descr_single_short2'] = 'Rilasciato da:';
$string['criteria_descr_single_short4'] = 'Completare il corso';
$string['criteria_descr_single_short5'] = 'Completare:';
$string['criteria_descr_single_short6'] = 'Completare:';
$string['criteria_descr_single_short7'] = 'Completare:';
$string['criteria_descr_single_short8'] = 'Appartenenza a:';
$string['criteria_descr_single_short9'] = 'Completare:';
$string['criteriacreated'] = 'I criteri per il badge sono stati creati correttamente';
$string['criteriadeleted'] = 'I criteri per il badge sono stati eliminati correttamente';
$string['criteriasummary'] = 'Sintesi dei criteri';
$string['criteriaupdated'] = 'I criteri per il badge sono stati aggiornati correttamente';
$string['criterror'] = 'Problematiche sui parametri';
$string['criterror_help'] = 'Di seguito vengono visualizzati  i parametri non più disponibili ma utilizzati per il rilascio del badge. Si raccomanda di deselezionare tali parametri per garantire che il badge possa essere nuovamente conseguito.';
$string['currentimage'] = 'Immagine utilizzata';
$string['currentstatus'] = 'Stato:';
$string['dateawarded'] = 'Data di rilascio';
$string['dateearned'] = 'Data: {$a}';
$string['day'] = 'Giorni';
$string['deactivate'] = 'Disabilita accesso';
$string['deactivatesuccess'] = 'L\'accesso al badge \'{$a}\' è stato disabilitato.';
$string['defaultissuercontact'] = 'Email di chi rilascia il badge';
$string['defaultissuercontact_desc'] = 'Indirizzo email di default associato alla persona che rilascia il badge. Per i backpack Open Badge v2.0, l\'indirizzo verrà utilizzato per l\'autenticazione durante la pubblicazione del badge nel backpack.';
$string['defaultissuername'] = 'Nome di chi rilascia il badge';
$string['defaultissuername_desc'] = 'Nome di default dell\'agenzia o dell\'autorità che rilascia il badge';
$string['defaultissuerpassword'] = 'Password di chi rilascia il badge';
$string['defaultissuerpassword_help'] = 'Nel sito del backpack è necessario un account che abbia l\'indirizzo email impostato in "Email di chi rilascia il badge" (Amministrazione del sito / Badge / Impostazioni badge). Anche la password dell\'account può essere impostata nella stessa pagina.';
$string['delbadge'] = 'Vuoi eliminare il badge \'{$a}\'  e rimuovere anche tutti i badge rilasciati?';
$string['delconfirm'] = 'Elimina e rimuovi i badge rilasciati';
$string['delcritconfirm'] = 'Sei sicuro di eliminare questo requisito?';
$string['deletehelp'] = '<p>Eliminare totalmente il badge comporta l\'eliminazione di di tutte le informazione associate e dei relativi criteri di rilascio. Gli utenti che hanno conseguito il badge non potranno più visualizzarlo nella propria pagina del profilo.</p>
<p>Nota: gli utenti che hanno conseguito il badge e che lo hanno anche caricato su un backpack esterno, visualizzeranno il badge nel backapck ma non potranno accedere alle pagina dei criteri e di verifica collegate a questo sito.</p>';
$string['delexternalbackpack'] = 'Elimina backpack del sito';
$string['delexternalbackpackconfirm'] = 'Eliminare il backpack di sito \'{$a}\'?';
$string['delparamconfirm'] = 'Sei sicuro di eliminare questo parametro?';
$string['description'] = 'Descrizione';
$string['descriptioninfo'] = 'Cosa rappresenta questo badge?';
$string['disconnect'] = 'Scollega';
$string['donotaward'] = 'Il badge non è attivo e gli utenti non possono conseguirlo. Se desideri che gli utenti conseguano il badge, devi cambiare lo stato ad attivo.';
$string['enablebadges'] = 'Abilita badge';
$string['endorsement'] = 'Garanzia di terzi';
$string['error:backpackdatainvalid'] = 'I dati restituiti dal backpack non sono validi';
$string['error:backpackemailnotfound'] = 'L\'email \'{$a}\' non è associata ad un backpack. È necessario <a href="http://backpack.openbadges.org">creare un backpack</a> per l\'account o autenticarsi con un altro indirizzo email.';
$string['error:badgeawardnotfound'] = 'Non è possibile verificare il badge. È possibile che il badge sia stato revocato.';
$string['error:badgenotfound'] = 'Il badge non è stato trovato';
$string['error:cannotact'] = 'Non è possibile attivare i badge.';
$string['error:cannotawardbadge'] = 'Non è possibile rilasciare badge all\'utente.';
$string['error:cannotdeletecriterion'] = 'Non è possibile eliminare questo requisito.';
$string['error:cannotrevokebadge'] = 'Non è possibile revocare il badge dell\'utente.';
$string['error:cannotsendtobackpack'] = '<strong>Non è stato possibile aggiungere il badge al backpack</strong><br />
Il fornitore del backpack ha inviato il seguente messaggio: \'{$a}\'.<br /><br />
È possibile provare a scaricare il badge e aggiungerlo manualmente al backpack, oppure riprovare più tardi.';
$string['error:clone'] = 'Non è possibile clonare il badge.';
$string['error:connectionunknownreason'] = 'Il collegamento non è riuscito ma non ne sono stati forniti i motivi.';
$string['error:duplicatename'] = 'Nel sistema esiste già un badge con lo stesso nome';
$string['error:externalbadgedoesntexist'] = 'Badge non trovato';
$string['error:guestuseraccess'] = 'Stai utilizzando un accesso ospite. Per visualizzare i badge devi autenticarti con il tuo account.';
$string['error:invalidcriteriatype'] = 'Tipo di criterio non valido.';
$string['error:invalidexpiredate'] = 'La scadenza deve essere una data futura';
$string['error:invalidexpireperiod'] = 'La scadenza non può essere negativa o uguale a zero.';
$string['error:invalidparambadge'] = 'Il badge non esiste.';
$string['error:invalidparamcohort'] = 'Il gruppo globale non esiste.';
$string['error:noactivities'] = 'In questo corso non ci sono attività con il completamento abilitato.';
$string['error:nobadges'] = 'Non sono presenti badge di sito o di corso da aggiungere come criterio di rilascio di altri badge.';
$string['error:nocohorts'] = 'Non sono presenti gruppi globali.';
$string['error:nocourses'] = 'Il completamento del corso non è abilitato in nessun corso di questo sito. È possibile abilitare il completamento nelle impostazioni del corso.';
$string['error:nogroupslink'] = '<p>Possono essere visualizzate solamente raccolte pubbliche, <a href="{$a}" target="_blank" rel="nofollow">Visita il tuo backpack</a> per creare raccolte pubbliche.</p>';
$string['error:nogroupssummary'] = '<p>Nel tuo backpack non sono disponibili raccolte pubbliche.</p>';
$string['error:nopermissiontoview'] = 'Non sei autorizzato a visualizzare i destinatari del badge';
$string['error:nosuchbadge'] = 'Il badge id {$a} non esiste';
$string['error:nosuchcohort'] = 'Attenzione: il gruppo globale non è più disponibile';
$string['error:nosuchcourse'] = 'Attenzione: il corso non è più disponible';
$string['error:nosuchfield'] = 'Attenzione: il campo del profilo utente non è più disponibile';
$string['error:nosuchmod'] = 'Attenzione: l\'attività non è più disponibile';
$string['error:nosuchrole'] = 'Attenzione: il ruolo non è più disponibile';
$string['error:nosuchuser'] = 'Nel backack provider non sono presenti utenti con l\'email indicata.';
$string['error:notifycoursedate'] = 'I badge i cui criteri dipendono dal completamento del corso e delle attività non saranno rilasciati fino alla data di inizio del corso ({$a})..';
$string['error:parameter'] = 'Attenzione: devi scegliere almeno un parametro per consentire il corretto rilasci del badge';
$string['error:relatedbadgedoesntexist'] = 'Non sono presenti badge pubblici con questo identificativo.';
$string['error:requesterror'] = 'La richiesta di collegamento non è riuscita (codice errore {$a}).';
$string['error:requesttimeout'] = 'La richiesta di collegamento è andata in time out prima del completamento.';
$string['error:save'] = 'Non è possibile salvare il badge.';
$string['error:userdeleted'] = '{$a->user} (Questo utente non esiste più in {$a->site})';
$string['eventbadgearchived'] = 'Archiviazione badge';
$string['eventbadgeawarded'] = 'Badge rilasciati';
$string['eventbadgecreated'] = 'Creazione badge';
$string['eventbadgecriteriacreated'] = 'Creazione criterio badge';
$string['eventbadgecriteriadeleted'] = 'Eliminazione criterio badge';
$string['eventbadgecriteriaupdated'] = 'Aggiornamento criterio badge';
$string['eventbadgedeleted'] = 'Eliminazione badge';
$string['eventbadgedisabled'] = 'Disabilitazione badge';
$string['eventbadgeduplicated'] = 'Duplicazione badge';
$string['eventbadgeenabled'] = 'Abilitazione badge';
$string['eventbadgelistingviewed'] = 'Visualizzazione elenco badge';
$string['eventbadgerevoked'] = 'Revoca badge';
$string['eventbadgeupdated'] = 'Aggiornamento badge';
$string['eventbadgeviewed'] = 'Visualizzazione badge';
$string['existingrecipients'] = 'Destinatari badge esistenti';
$string['existsinbackpack'] = 'Il badge è già presente nel backpack';
$string['expired'] = 'Scaduto';
$string['expiredate'] = 'Il badge scade il {$a}.';
$string['expireddate'] = 'Il badge è scaduto il {$a}.';
$string['expiredin'] = 'Scaduto il {$a}';
$string['expireperiod'] = 'Il badge scade {$a} giorni dopo l\'emissione.';
$string['expireperiodh'] = 'Il badge scade {$a} ore dopo l\'emissione.';
$string['expireperiodm'] = 'Il badge scade {$a} minuti dopo l\'emissione.';
$string['expireperiods'] = 'Il badge scade {$a} secondi dopo l\'emissione.';
$string['expiresin'] = 'Scade il {$a}';
$string['expirydate'] = 'Data di scadenza';
$string['expirydate_help'] = 'È possibile impostare una data di scadenza per i badge. La data può essere fissa oppure calcolata a partire dalla data di emissione.';
$string['externalbackpack_required'] = 'Il provider del backpack non può essere vuoto';
$string['externalbadges'] = 'Badge conseguiti su altri siti';
$string['externalbadges_help'] = 'Quest\'area visualizza i badge provenienti dal tuo backpack esterno';
$string['externalbadgesp'] = 'Badge conseguiti in altri siti:';
$string['externalconnectto'] = 'Per visualizzare badge esterni, devi <a href="{$a}">connetterti ad un backpack</a>.';
$string['fixed'] = 'Data fissa - il badge scade il:';
$string['hidden'] = 'Nascosto';
$string['hiddenbadge'] = 'Sfortunatamente il titolare del badge non ha reso disponibile questa informazione.';
$string['hostedurl'] = 'URL esterno';
$string['hostedurldescription'] = 'L\'URL esterno dove si trova il badge.';
$string['imageauthoremail'] = 'Email dell\'autore dell\'immagine';
$string['imageauthoremail_help'] = 'È possibile impostare l\'email dell\'autore dell\'immagine del badge.';
$string['imageauthorname'] = 'Nome dell\'autore dell\'immagine';
$string['imageauthorname_help'] = 'È possibile impostare il nome dell\'autore dell\'immagine del badge.';
$string['imageauthorurl'] = 'URL dell\'autore dell\'immagine';
$string['imageauthorurl_help'] = 'È possibile impostare l\'URL dell\'autore dell\'immagine del badge.';
$string['imagecaption'] = 'Didascalia dell\'immagine';
$string['imagecaption_help'] = 'È possibile impostare una didascalia che sarà visualizzata nella pagina del badge.';
$string['includeauthdetails'] = 'Connettiti all\'account del fornitore del backpack';
$string['includeauthdetails_desc'] = 'Inserire le credenziali dell\'emittente del badge per connettersi al fornitore del backpack.';
$string['includeauthdetails_help'] = 'Invia le credenziali dell\'emittente assieme ai badge esportati in questo backpak.';
$string['includeauthdetailscanvas'] = 'Collega un account emittente di credenziali Canvas';
$string['includeauthdetailscanvas_desc'] = 'Inserire i dettagli delleproprie credenziali Canvas per collegare l\'account emittente.';
$string['includeauthdetailscanvas_help'] = 'I badge esportati in Canvas Credentials indicheranno la tua organizzazione come emittente. Questo permetterà anche di tenere traccia di chi ha ricevuto i badge e di gestirne gli aggiornamenti.';
$string['includeauthdetailscanvas_subtitle'] = '(Richiede un piano a pagamento Canvas Credentials)';
$string['invalidurl'] = 'URL non valida';
$string['issuancedetails'] = 'Scadenza badge';
$string['issuedbadge'] = 'Informazioni sul badge rilasciato';
$string['issuedby'] = 'Rilasciato da {$a}';
$string['issuedon'] = 'Rilasciato {$a}';
$string['issuerdetails'] = 'Dettagli di chi rilascia il badge';
$string['issueremail'] = 'Email';
$string['issueremail_help'] = 'Indirizzo email dell\'organizzazione garante.';
$string['issuername'] = 'Nome';
$string['issuername_endorsement'] = 'Nome del garante';
$string['issuername_endorsement_help'] = 'Il nome del garante.';
$string['issuername_help'] = 'Nome dell\'agenzia o dell\'autorità che rilascia il badge';
$string['issuerurl'] = 'URL';
$string['issuerurl_help'] = 'Sito web dell\'organizzazione garante. L\'URL deve avere il prefisso http:// o https://.';
$string['language'] = 'Lingua';
$string['language_help'] = 'Lingua utilizzata nella pagina del badge.';
$string['listbackpacks'] = 'Elenco backpack';
$string['localbadges'] = 'Badge conseguiti su {$a}';
$string['localbadgesh'] = 'Badge conseguiti su questo sito';
$string['localbadgesh_help'] = 'L\'elenco dei badge conseguiti su questo sito dopo aver  completato corsi, attività dei corsi e aver soddisfatto altri requisiti.

È possibile gestire i tuoi badge rendendoli pubblici o privati.

Puoi scaricare i badge singolarmente oppure tutti assieme e scalvarli nel tuo computer. I badge scaricati possono essere aggiunti a servizi backpack esterni.';
$string['localbadgesp'] = 'Badge da {$a}:';
$string['localconnectto'] = 'Per condividere badge al di fuori dei questo sito, devi <a href="{$a}">connetterti ad un backpack</a>.';
$string['loginbackpacktitle'] = '<strong>Autenticati sul tuo backpack</strong>';
$string['makeprivate'] = 'Rendi privato';
$string['makepublic'] = 'Rendi pubblico';
$string['managebackpacks'] = 'Gestione backpack';
$string['managebadges'] = 'Gestione badge';
$string['message'] = 'Corpo del messaggio';
$string['messagebody'] = '<p>Hai conseguito il badge "%badgename%"!</p>
<p>Per maggiori informazioni sul badge:  %badgelink%.</p>
<p>Puoi gestire e scaricare il badge dalla tua pagina {$a}.</p>';
$string['messagesubject'] = 'Complimenti! Hai conseguito un badge!';
$string['method'] = 'Requisti da soddisfare';
$string['mingrade'] = 'Punteggio minimo richiesto';
$string['month'] = 'Mesi';
$string['moredetails'] = 'Ulteriori dettagli';
$string['mybackpack'] = 'Impostazioni mio backpack';
$string['mybadges'] = 'Badge';
$string['namewithimagelink'] = 'Nome con immagine e link';
$string['namewithlink'] = 'Nome con link';
$string['never'] = 'Mai: il badge non scade.';
$string['newbackpack'] = 'Aggiungi backpack';
$string['newbadge'] = 'Creazione badge';
$string['newbadgedeprecated'] = 'Sei stato reindirizzato da badges/newbadge.php. Da notare che badges/newbadge.php verrà rimosso a breve.
<br/>Aggiornare i link e i segnalibri per usare la pagina corrente badges/edit.php.';
$string['newimage'] = 'Nuova immagine';
$string['noalignment'] = 'Il badge non ha equivalenze con standard o abilità esterni.';
$string['noawards'] = 'Questo badge non è stato rilasciato.';
$string['nobackpack'] = 'Non ci sono servizi backpack collegati a questo account.<br/>';
$string['nobackpackbadgessummary'] = 'Nella raccolta selezionata non sono presenti badge.';
$string['nobackpackcollectionssummary'] = 'Non sono state sezionate raccolte di badge.';
$string['nobackpacks'] = 'Non ci sono backpack disponibili.';
$string['nobadges'] = 'Non ci sono badge da rilasciare agli utenti.';
$string['nocompetencies'] = 'Non sono state selezionate competenze.';
$string['nocriteria'] = 'I criteri per questo badge non sono stati impostati';
$string['noendorsement'] = 'Il badge non ha garanzie.';
$string['noexpiry'] = 'Questo badge non ha data di scadenza';
$string['nomatchingawards'] = 'Non ci sono ancora destinatari corrispondenti che hanno conseguito questo badge.';
$string['nomatchingbadges'] = 'Non ci sono badge corrispondenti che gli utenti possono conseguire.';
$string['noparamstoadd'] = 'Non ci sono altri parametri disponibili da aggiungere ai criteri di rilascio del badge';
$string['norelated'] = 'Il badge non ha badge correlati.';
$string['notacceptedrole'] = 'Il tuo ruolo non è presente tra i ruoli che possono rilasciare manualmente il badge.<br/>
Per visualizzare l\'elenco degli utenti che hanno conseguito questo badge, visita {$a}.';
$string['notconnected'] = 'Non collegato';
$string['notealignment'] = 'È possibile specificare gli standard o le abilità definiti esternamente che sono equivalenti al badge. Le equivalenze saranno visualizzate nella pagina del badge';
$string['noteendorsement'] = 'Una garanzia di terze parti  può accrescere il valore del badge. Ad esempio,una scuola può farsi garante di un badge rilasciato da un docente, oppure un di una organizzazione nazionale può farsi garante dei badge rilasciati da una organizzazione locale.';
$string['noterelated'] = 'I badge con delle analogie possono essere indicati come correlati. Ad esempio, badge che hanno gli stessi criteri ma che sono visualizzati i lingue diverse. I badge correlati vengono visualizzati nella pagina dei badge.';
$string['nothingtoadd'] = 'Non sono disponibili criteri da aggiungere';
$string['notification'] = 'Informa il creatore del badge';
$string['notification_help'] = 'Consente di impostare le notifiche dei badge rilasciati da inviare al creatore del badge.

Sono disponibili le seguenti opzioni:

* **MAI** - Non saranno inviate notifiche.

 * **SEMPRE** - Invia una notifica tutte le volte che un badge viene conseguito.

 * **GIORNALMENTE** - Invia una notifica una sola volta al giorno.

 * **SETTIMANALMENTE** - Invia una notifica una sola volta alla settimana.

 * **MENSILMENTE** - Invia una notifica una sola volta al mese.';
$string['notifydaily'] = 'Giornalmente';
$string['notifyevery'] = 'Sempre';
$string['notifymonthly'] = 'Mensilmente';
$string['notifyweekly'] = 'Settimanalmente';
$string['numawards'] = 'Badge  \'{$a->badgename}\' rilasciato a <a href="{$a->link}">{$a->count}</a> utenti.';
$string['numawardstat'] = 'Badge {$a->badgename}\' rilasciato a {$a->awards} utenti.';
$string['oauth2issuer'] = 'Servizi Oauth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Altra navigazione...';
$string['otherprovider'] = 'Altro';
$string['overallcrit'] = 'Metodo di aggregazione dei requisiti';
$string['password_required'] = 'La password non può essere vuota';
$string['potentialrecipients'] = 'Destinatari potenziali badge';
$string['preferences'] = 'Preferenze badge';
$string['privacy:metadata:backpack'] = 'Registro dei backpack dell\'utente.';
$string['privacy:metadata:backpack:backpackuid'] = 'Identificativo univoco del backpack';
$string['privacy:metadata:backpack:email'] = 'Email associata al backpack';
$string['privacy:metadata:backpack:externalbackpackid'] = 'ID del backpack';
$string['privacy:metadata:backpack:userid'] = 'ID dell\'utente a cui appartiene il backpack.';
$string['privacy:metadata:backpackoauth2'] = 'Informazioni Oauth2 del collegamento dell\'utente al backpack esterno';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID servizio Oauth2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Elenco degli ambiti del collegamento al backpack';
$string['privacy:metadata:backpackoauth2:token'] = 'Token del collegamento backpack';
$string['privacy:metadata:backpackoauth2:userid'] = 'ID dell\'utente che ha collegato il backpack';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'ID dell\'utente che ha modificato il collegamento al backpack';
$string['privacy:metadata:badge'] = 'Raccolta di badge.';
$string['privacy:metadata:badge:timecreated'] = 'Data e orario di creazione del badge';
$string['privacy:metadata:badge:timemodified'] = 'Data e orario di modifica del badge';
$string['privacy:metadata:badge:usercreated'] = 'ID dell\'utente che ha creato il badge';
$string['privacy:metadata:badge:usermodified'] = 'ID dell\'utente che ha modificato il badge';
$string['privacy:metadata:criteriamet'] = 'Insieme di criteri soddisfatti';
$string['privacy:metadata:criteriamet:datemet'] = 'Data di soddisfacimento del criterio';
$string['privacy:metadata:criteriamet:userid'] = 'ID dell\'utente che ha soddisfatto i criteri';
$string['privacy:metadata:external:backpacks'] = 'Informazioni condivise quando l\'utente invia i propri badge al backpack esterno';
$string['privacy:metadata:external:backpacks:badge'] = 'Nome del badge';
$string['privacy:metadata:external:backpacks:description'] = 'Descrizione del badge';
$string['privacy:metadata:external:backpacks:image'] = 'Immagine del badge';
$string['privacy:metadata:external:backpacks:issuer'] = 'Alcune informazioni su chi rilascia il badge';
$string['privacy:metadata:external:backpacks:url'] = 'URL di Moodle per visualizzare le informazioni sul badge rilasciato.';
$string['privacy:metadata:issued'] = 'Registro dei badge ottenuti.';
$string['privacy:metadata:issued:dateexpire'] = 'Data di scadenza del badge.';
$string['privacy:metadata:issued:dateissued'] = 'Data di ottenimento del badge.';
$string['privacy:metadata:issued:userid'] = 'ID dell\'utente che ha ottenuto un badge.';
$string['privacy:metadata:manualaward'] = 'Registro dei rilasci manuali.';
$string['privacy:metadata:manualaward:datemet'] = 'Data di ottenimento del badge da parte dell\'utente.';
$string['privacy:metadata:manualaward:issuerid'] = 'ID dell\'utente che ha ottenuto il badge.';
$string['privacy:metadata:manualaward:issuerrole'] = 'Ruolo dell\'utente che ha ottenuto il badge.';
$string['privacy:metadata:manualaward:recipientid'] = 'ID dell\'utente che ha ottenuto manualmente il badge.';
$string['provider'] = 'Provider';
$string['recipient'] = 'Destinatario del badge';
$string['recipients'] = 'Destinatari badge';
$string['recipientvalidationproblem'] = 'Questo utente non può essere verificato come destinatario del badge.';
$string['region'] = 'Regione';
$string['relatedbages'] = 'Badge correlati';
$string['relative'] = 'Data relativa - il badge scade dopo il seguente periodo di tempo:';
$string['requiredbadge'] = 'È necessario aggiungere almeno un badge al criterio.';
$string['requiredcohort'] = 'È necessario aggiungere almeno un gruppo globale al criterio.';
$string['requiredcompetency'] = 'È necessario aggiungere almeno una competenza  al criterio .';
$string['requiredcourse'] = 'È necessario aggiungere almeno un corso al criterio.';
$string['reviewbadge'] = 'Modifica accesso al badge';
$string['reviewconfirm'] = '<p>Il badge diverrà visibile agli utenti i quali potranno cominciare a conseguirlo.</p>

<p>È possibile che alcuni utenti abbiano già soddisfatto i criteri, nel qual caso riceveranno il badge.</p>

<p>Una volta che un badge sarà stato rilasciato, sarà <strong>bloccato</strong> - alcune impostazioni, inclusi i criteri e la scadenza, non potranno più essere modificate.</p>

<p>Sei certo di abilitare l\'accesso al badge \'{$a}\'?</p>';
$string['revoke'] = 'Revoca badge';
$string['save'] = 'Salva';
$string['searchname'] = 'Cerca per nome';
$string['selectaward'] = 'Scegliere il ruolo da utilizzare per rilasciare il badge';
$string['selectgroup_end'] = 'Possono essere visualizzate solamente raccolte pubbliche, <a href="{$a}">Visita il tuo backpack</a> per creare ulteriori raccolte pubbliche.';
$string['selectgroup_start'] = 'Seleziona dal tuo backpack le raccolte da visualizzare in questo sito:';
$string['selecting'] = 'Con i badge selezionati...';
$string['setup'] = 'Imposta connesione';
$string['sitebackpackdeleted'] = 'Il backpack di sito è stato eliminato.';
$string['sitebackpacknotdeleted'] = 'Non è possibile eliminare il backpack poiché è il backpack di default del sito.';
$string['sitebackpackwarning'] = 'Non è stato possibile collegarsi al backpack.<br/><br/>Verificare che l\'"Email di chi rilascia il badge" sia una email valida per l\'account backpack del sito.<br/><br/>Verificare che la "Password di chi rilascia il badge" inserita nelle  <a href="{$a->url}">impostazioni backpack del sito</a> sia corretta.<br/><br/> Di seguito la riposta del backpack: "{$a->warning}"';
$string['sitebadges'] = 'Badge del sito';
$string['sitebadges_help'] = 'I badge del sito possono essere rilasciati agli utenti solo per attività svolte a livello di sito, come ad esempio completare un gruppo di corsi o compilare campi del profilo utente. I badge del sito possono essere rilasciati manualmente da un utente abilitato.

I badge relatavi ad attività dei corsi devono essere creati a livello di corso. I badge del corso sono gestibili tramite la voce di menu Amministrazione > Badge';
$string['sitebadgetitle'] = '{$a} badge del sito';
$string['status'] = 'Stato badge';
$string['status_help'] = 'Lo stato del badge determina il suo comportamento nel sistema:

* **DISPONIBILE** - Il badge può essere conseguito dagli utenti. Se un badge è disponibile agli utenti, i criteri di conseguimento non possono essere modificati

* **NON DISPONIBILE** - Il badge non può essere conseguito dagli utenti né essere rilasciato manualmente. Se il badge non è mai stato rilasciato, i criteri di conseguimento possono essere modificati.

Dopo il rilascio di un badge ad almeno un utente, il badge diventa **BLOCCATO**. I badge bloccati possono essere conseguiti dagli utenti ma non possono essere modificati i criteri di rialscio. Se devi modificare un badge bloccato, puoi duplicarlo e applicare le modifiche.

*Perché i badge vengono bloccati?*

È indispensabile garantire che gli utenti conseguano il badge in base agli stessi criteri. Al momento non è possibile revocare badge. Se fosse possibile modificare i criteri di rilascio liberamente, si rischierebbe di rilasciare lo stesso badge sulla base di criteri completamente diversi.';
$string['statusmessage_0'] = 'Il badge non è disponibile agli utenti. Se desideri che gli utenti possano conseguire il badge, devi abilitarne l\'accesso.';
$string['statusmessage_1'] = 'Il badge è disponibile agli utenti. Per modificarlo, devi disabilitarne l\'accesso.';
$string['statusmessage_2'] = 'Il badge non è disponibile agli utenti e i criteri per conseguirlo sono bloccati. Se desideri che gli utenti possano conseguire il badge, devi abilitarne l\'accesso.';
$string['statusmessage_3'] = 'Il badge è disponibile agli utenti e i criteri per conseguirlo sono bloccati.';
$string['statusmessage_4'] = 'Questo badge al momento è archiviato.';
$string['subject'] = 'Oggetto del messaggio';
$string['tagarea_badge'] = 'Badge';
$string['tags'] = 'Tag';
$string['targetcode'] = 'Codice';
$string['targetcode_help'] = 'Identificativo univoco dello standard o dell\'abilità definito esternamente, all\'interno del proprio quadro.';
$string['targetdescription'] = 'Descrizione';
$string['targetdescription_help'] = 'Breve descrizione dello standard o dell\'abilità definito esternamente';
$string['targetframework'] = 'Quadro';
$string['targetframework_help'] = 'Il nome del quadro esterno di standard o abilità.';
$string['targetname'] = 'Nome';
$string['targetname_help'] = 'Lo standard o l\'abilità definito esternamente che sono equivalenti al badge.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Link alla pagina che descrive lo standard o l\'abilità definito esternamente. L\'URL deve contenere il prefisso http:// or https://.';
$string['testbackpack'] = 'Testa il backpack \'{$a}\'';
$string['testsettings'] = 'Impostazioni test';
$string['type'] = 'Tipo';
$string['userbadges'] = 'Badge del\'utente';
$string['variablesubstitution'] = 'Sostituzione delle variabili nel messaggio';
$string['variablesubstitution_help'] = 'In un messaggio badge è possibile inserire variabili nell\'oggetto o nel corpo del messaggio affinché vengano sostituite da valori reali all\'atto dell\'invio del messaggio. Le variabili devono essere inserite esattamente come riportate sotto.

%badgename% : sarà sostituita dal nome del badge

%username% : sarà sostituita dal nome di chi ha conseguito il badge

%badgelink% : sarà sostituita dall\'URL pubblico contenente le informazioni del badge rilasciato.';
$string['verifyemail'] = 'Verifica email';
$string['version'] = 'Versione';
$string['version_help'] = 'Il campo versione è utile per tenere traccia dall\'evoluzione del badge. Se inserita, la versione sarà visualizzata nella pagina del badge.';
$string['viewbadge'] = 'Visualizza badge rilasciati';
$string['visible'] = 'Visibile';
$string['warnexpired'] = '(Questo badge è scaduto!)';
$string['year'] = 'Anni';
