<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'it', version '5.0'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Azione';
$string['activityoverview'] = 'Ci sono questionari che richiedono la tua attenzione';
$string['additionalinfo'] = 'Informazioni aggiuntive';
$string['additionalinfo_help'] = 'Le informazioni aggiuntive vengono visualizzate nella intestazione della prima pagina del questionario. Sono state pensate per fornire all\'utente al quale il questionario è sottoposto, informazioni di carattere generale quali: istruzioni, informazioni di contesto, dettagli tecnici e/o organizzativi o quant\'altro possa apparire necessario.';
$string['addnewquestion'] = 'Nuova domanda di tipo: {$a}.';
$string['addnewsection'] = 'Aggiungi una sezione';
$string['addquestion'] = 'Aggiungi una domanda...';
$string['addquestions'] = 'Aggiungi domande';
$string['addquestiontosection'] = 'Aggiungi una domanda alla sezione';
$string['addselqtype'] = 'Aggiungi una domanda del tipo selezionato';
$string['alignment'] = 'Allineamento';
$string['alignment_help'] = 'Di default, i pulsanti radio sono allineati verticalmente. Se le indicazioni nella lista "Risposte" sono relativamente corte (o numerose) si può scegliere di mostrarle orizzontalmente. <br /><strong>Nota:</strong><br />La correttezza della visualizzazione orizzontale non è garantita su tutti i browsers. Si prega di effettuare delle verifiche personali.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Tutto';
$string['allnameddegrees'] = 'Gradi nominali';
$string['allnameddegrees_help'] = 'Specificare il testo per far visualizzare gradi nominali al posto dei numeri. Lasciare vuoto se non utilizzato.';
$string['alreadyfilled'] = 'Il questionario è già stato compilato. Grazie.';
$string['andaveragevalues'] = 'e valori medi';
$string['anonymous'] = 'Anonimo';
$string['answer'] = 'Risposta';
$string['answergiven'] = 'Risposta data';
$string['answernotgiven'] = 'Risposta non data';
$string['answerquestions'] = 'Rispondi alle domande...';
$string['answers'] = 'Risposte';
$string['attempted'] = 'Il questionario è stato inviato.';
$string['attemptstillinprogress'] = 'In svolgimento. Salvato il:';
$string['autonumbering'] = 'Numerazione automatica';
$string['autonumbering_help'] = 'Numerazione automatica delle domande e delle pagine. La numerazione automatica potrebbe essere disattivata per i questionari con domande condizionate.';
$string['autonumberno'] = 'Non numerare domande o pagine';
$string['autonumberpages'] = 'Numera automaticamente le pagine';
$string['autonumberpagesandquestions'] = 'Numera automaticamente le pagine e le domande';
$string['autonumberquestions'] = 'Numera automaticamente le domande';
$string['average'] = 'Media';
$string['averageposition'] = 'Posizione media';
$string['averagerank'] = 'Punteggio medio';
$string['averagesrow'] = 'Media (quando applicabile):';
$string['bodytext'] = 'Corpo del testo';
$string['boxesnbexact'] = 'esattamente {$a} casella(e).';
$string['boxesnbmax'] = 'un massimo di {$a} casella(e).';
$string['boxesnbmin'] = 'un minimo di {$a} casella(e).';
$string['boxesnbreq'] = 'Per questa domanda è necessario spuntare';
$string['by'] = 'di';
$string['cannotviewpublicresponses'] = 'Non puoi visualizzare le risposte di questo questionario pubblico';
$string['chart:bipolar'] = 'Barre bipolari';
$string['chart:hbar'] = 'Barre orizzontali';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Rosa';
$string['chart:type'] = 'Tipo di grafico';
$string['chart:type_help'] = 'Seleziona il tipo di grafico da utilizzare per il feedback';
$string['chart:vprogress'] = 'Barra verticale';
$string['checkallradiobuttons'] = 'Selezionare tutti i <strong>{$a}</strong> pulsanti radio!';
$string['checkboxes'] = 'Caselle di spunta';
$string['checkboxes_help'] = 'Inserisci una opzione per ogni linea.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Interruzioni di pagina inserite nelle posizioni:';
$string['checkbreaksok'] = 'Tute le interruzioni di pagina richieste sono presenti!';
$string['checkbreaksremoved'] = 'Rimosse {$a} interruzioni di pagina  in eccesso.';
$string['checknotstarted'] = 'Seleziona i questionari non iniziati';
$string['checkstarted'] = 'Seleziona i questionari iniziati';
$string['clicktoswitch'] = '(clicca per cambiare)';
$string['closebeforeopen'] = 'E\' stata indicata una data di chiusura precedente alla data di apertura.';
$string['closed'] = 'Il questionario si è chiuso il  {$a}. Grazie';
$string['closedate'] = 'Consenti risposte fino a';
$string['closeson'] = 'Il questionario chiude il {$a}';
$string['completionsubmit'] = 'Gli studenti devono inviare il questionario per completarlo';
$string['condition'] = 'Condizione';
$string['confalts'] = 'oppure<br />Pagina di conferma';
$string['configemailreporting'] = 'Consenti invio di report via email';
$string['configemailreportinglong'] = 'Abilita le opzioni per inviare direttamente via email alcuni report direttamente a specifici indirizzi email.';
$string['configmaxsections'] = 'Massimo numero di sezioni di feedback';
$string['configusergraph'] = 'Visualizza i grafici per il feedback del "Test della personalità"';
$string['configusergraphlong'] = 'Usa <a href="http://www.rgraph.net/">Rgraph</a>  per visualizzare i grafici del feedback del "Test della personalità".';
$string['confirmdelallresp'] = 'Sei sicuro di eliminare TUTTE le risposte del questionario?';
$string['confirmdelchildren'] = 'Eliminando questa domanda, verranno eliminate anche le domande "figlie":';
$string['confirmdeletesection'] = 'Sei sicuro di eliminare la sezione "{$a}" del feedback?';
$string['confirmdelgroupresp'] = 'Sei sicuro di eliminare TUTTE le risposte del gruppo {$a}?';
$string['confirmdelquestion'] = 'Sei sicuro di voler eliminare la domanda alla posizione {$a}?';
$string['confirmdelquestionresps'] = 'Verranno anche eliminate le {$a} risposte già date.';
$string['confirmdelresp'] = 'Sei sicuro di eliminare le risposte di {$a} ?';
$string['confirmremovequestion'] = 'Sei sicuro di eliminare la domanda  "{$a->qname}" dalla sezione "{$a->sname}"?';
$string['confpage'] = 'Pagina di conferma';
$string['confpage_help'] = 'La <strong>pagina di conferma</strong> verrà visualizzata all\'utente a valle dell\'invio del questionario. Consta di una intestazione (in grassetto) e di un messaggio.<br />
<strong>Nota:</strong><br /> Un\'eventuale pagina web specifica nel campo URL di questa scheda ha la precedenza su questa opzione. Qualora non si specifichi un URL e neppure si definiscano le opzioni intestazione e messaggio, all\'invio del questionario da parte dell\'utente verrà mostrato il messaggio di default: "Grazie per aver compilato il questionario."';
$string['confpagedesc'] = 'Intestazione (in grassetto) e corpo del testo per la Pagina di Conferma; viene visualizzata dopo che l\'utente ha inviato il questionario. (La URL, se inserita, ha la precedenza sulla conferma testuale)';
$string['contentoptions'] = 'Opzioni del contenuto';
$string['couldnotcreatenewsurvey'] = 'Impossibile creare un nuovo questionario!';
$string['couldnotdelresp'] = 'Non è stato possibile eliminare la risposta';
$string['createcontent'] = 'Definisce nuovo contenuto';
$string['createcontent_help'] = 'Per creare un nuovo questionario selezionare uno dei tre pulsanti radio e quindi \'Continua\'. \'Crea nuovo\' è l\'opzione di default. Ai tre bottoni radio sono associate tre differenti modalità di realizzazione di un nuovo questionario: <br >

    * **Crea nuovo:** Questa opzione consente di realizzare un questionario cominciando da zero.
    * **Copia esistente:** Questa opzione consente di realizzare un questionario a partire dalla copia di un questionario preesistente. E\' possibile copiare sia un altro questionario del corso sia un qualunque altro questionario di tipo "modello". Le domande del questionario potranno essere visualizzate in anteprima e modificate selezionandole dal loro nome.
    * **Usa Pubblico:** Se un questionario di tipo Pubblico è già stato creato (in un altro corso dello stessa installazione di Moodle), questa opzione consente di usare tale questionario in questa attività. Il numero di opzioni disponibili, per questo tipo di questionario, ai docenti di questo corso è ridotto e non è possibile né modificarne il contenuto né visualizzarne le risposte.

    <br />**Esempio:** Se un questionario di tipo "Pubblico" è stato creato nel corso A, esso può essere erogato nei corsi B, C... Tutte le risposte dagli utenti dei corsi A, B, C... saranno raccolte nel questionario pubblico creato nel corso A e saranno visualizzabili solamente nel contesto del corso A dagli amministratori o docenti che lo hanno realizzato.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Crea nuovo';
$string['crontask'] = 'Pulizia Questionario';
$string['date'] = 'Data';
$string['date_help'] = 'Usare questo tipo di domanda se si desidera che la risposta sia formattata correttamente come data.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'E\' possibile usare il formato gg/mm/aaaa, es: 14 Marzo, 1945 <strong>14/3/1945</strong>';
$string['deleteallresponses'] = 'Elimina TUTTE le risposte';
$string['deletecurrentquestion'] = 'Elimina la domanda';
$string['deletedallgroupresp'] = 'Elimina TUTTE le risposte del gruppo {$a}';
$string['deletedallresp'] = 'Le risposte al questionario sono state eliminate.';
$string['deletedisabled'] = 'L\'elemento non può essere eliminato';
$string['deletedresp'] = 'Risposte eliminate';
$string['deleteresp'] = 'Elimina questa risposta';
$string['deletesection'] = 'Elimina sezione';
$string['deletingresp'] = 'Eliminazione delle risposte';
$string['dependencies'] = 'Dipendenze';
$string['dependquestion'] = 'Domanda genitore';
$string['dependquestion_help'] = 'E\' possibile selezionare una domanda genitore e un\'opzione di scelta per questa domanda. Allo studente verrà visualizzata una domanda figlia"
                 in basse alla scelta operata nella domanda genitore.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Non ha risposto alla domanda';
$string['directwarnings'] = 'Le dipendenze dirette di questa domanda verranno rimosse. Questo influenzerà:';
$string['displaymethod'] = 'Il metodo di visualizzazione delle domande non è definito.';
$string['download'] = 'Download';
$string['downloadpdf'] = 'Scarica PDF';
$string['downloadtextformat'] = 'Download in formato testo';
$string['downloadtextformat_help'] = 'Questa opzione permette di salvare tutte le risposte di un questionario in un file di testo (CSV).
Questo file può essere importato in un programma di foglio di calcolo (ad esempio, MS Excel o Open Office Calc).';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Tipo di report';
$string['dropdown'] = 'Menu a tendina';
$string['dropdown_help'] = 'Inserire una opzione di risposta per ogni linea';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Modifica';
$string['editingfeedback'] = 'Modifica impostazioni del feedback';
$string['editingquestionnaire'] = 'Modifica del questionario - Pagina principale';
$string['editquestion'] = 'Modifica la domanda di tipo: {$a}';
$string['email'] = 'Email';
$string['emailextra'] = 'Invia email con file scaricati';
$string['emailextra_help'] = 'Invierà il file di download agli indirizzi e-mail elencati, separati da virgole. Nota: NON verrà eseguito alcun controllo di sicurezza o privacy.
 per accedere a questa opzione è necessario abilitare \'autoremailreporting\' nelle impostazioni del modulo.';
$string['emailroles'] = 'Invia file scaricati a ruoli';
$string['emailroles_help'] = 'Questa opzione invierà il file scaricato a tutti i ruoli con funzionalità "mod / questionnaire: submissionnotification" via e-mail.
 per accedere a questa opzione è necessario abilitare \'autoremailreporting\' nelle impostazioni del modulo.';
$string['emailsend'] = 'Invia report';
$string['emailsnotspecified'] = 'Nessuna email specificata.';
$string['emailssent'] = 'File scaricati inviati alle email specificate.';
$string['errnewname'] = 'Spiacente, nome già in uso. Scegline un altro';
$string['erroropening'] = 'Errore nell\'apertura del questionario.';
$string['errortable'] = 'Errore!! Tabelle di sistema danneggiate.';
$string['essaybox'] = 'Testo lungo';
$string['essaybox_help'] = 'E\' possibile definire l\'ampiezza (numero di colonne) e l\'altezza (numero di righe) dell\'area di testo (la textarea).
                      Se si lasciano entrambi i valori vuoti (o se si inserisce "0"), l\'editor HTML di Moodle (se disponibile) verrà visualizzato con altezza e ampiezza standard.';
$string['event_all_responses_deleted'] = 'Eliminate tutte le risposte';
$string['event_all_responses_saved_as_text'] = 'Salvate tutte le risposte in formato testo';
$string['event_all_responses_viewed'] = 'Visualizzato il report di tutte le risposte';
$string['event_individual_responses_viewed'] = 'Visualizzato il report delle risposte individuali';
$string['event_non_respondents_viewed'] = 'Visualizzati gli utenti che non hanno risposto';
$string['event_previewed'] = 'Visualizzata anteprima del questionario';
$string['event_question_created'] = 'Creato questionario';
$string['event_question_deleted'] = 'Eliminato questionario';
$string['event_response_deleted'] = 'Eliminata risposta individuale';
$string['event_resumed'] = 'Tentativo ripreso';
$string['event_saved'] = 'Salvate risposte';
$string['event_submitted'] = 'Inviate risposte';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Aiuto sul feedback';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Aggiungi {no} campi feedback';
$string['feedbackbysection'] = 'Sezioni di feedback';
$string['feedbackdefaultlabel'] = '[Nuova sezione]';
$string['feedbackeditingglobal'] = 'Modifica del Feedback globale del questionario';
$string['feedbackeditingmessages'] = 'Modifica del Feedback dei messaggi del questionario';
$string['feedbackeditingsections'] = 'Modifica le sezioni del feedback del questionario';
$string['feedbackeditmessages'] = 'Salva le impostazioni della sezione e modifica i messaggi di feedback';
$string['feedbackeditsections'] = 'Salva le impostazioni e modifica le sezioni di feedback';
$string['feedbackerrorboundaryformat'] = 'I limiti delle valutazioni del feedback devono essere espresse in percentuale o in numero. Il valore immesso nella posizione {$a} non è valido.';
$string['feedbackerrorboundaryoutofrange'] = 'I limiti delle valutazioni del feedback devono essere comprese tra 0% e 100%. Il valore immesso nella posizione {$a} non è valido.';
$string['feedbackerrorjunkinboundary'] = 'Devi compilare i limiti delle valutazioni del feedback senza lasciare intervalli vuoti.';
$string['feedbackerrorjunkinfeedback'] = 'Devi compilare i campi del feedback senza lasciare intervalli intervalli vuoti.';
$string['feedbackerrororder'] = 'Ii limiti delle valutazioni del feedback devono essere in ordine decrescente. Il valore immesso nella posizione  {$a} è fuori sequenza.';
$string['feedbackglobal'] = 'Feedback complessivo';
$string['feedbackglobalheading'] = 'Intestazione del feedback complessivo';
$string['feedbackglobalmessages'] = 'Messaggi del feedback compessivo';
$string['feedbackhdr'] = 'Feedback';
$string['feedbackheading'] = 'Intestazione del feedback';
$string['feedbackheading_help'] = 'Nel campo dell\'intestazione del feedback è possibile utilizzare 2 variabili:  $scorepercent e $oppositescorepercent.';
$string['feedbackmessages'] = 'Messaggi di feedback per la sezione  {$a}';
$string['feedbacknextsection'] = 'Sezione successiva  {$a}';
$string['feedbacknone'] = 'Nessun messaggio di feedback';
$string['feedbacknotes'] = 'Note sul feedback';
$string['feedbacknotes_help'] = 'Il testo inserito verrà visualizzato dall\'utente al termine del Report del Feedback';
$string['feedbackoptions'] = 'Opzioni di feedback';
$string['feedbackoptions_help'] = 'Le opzioni del feedback saranno disponibili se il questionario contiene i seguenti tipi di domande e impostazioni:
Pulsanti radio; Menu a tendina; Scala. Queste domande devono essere impostate con risposta obbligatoria, deve essere inserito un nome e le possibili risposte devono contenere un valore.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Questa domanda fa parte della sezione del feedback [{$a}]';
$string['feedbackremovesection'] = 'Eliminando questa domanda si eliminerà la sezione del feedback [{$a}]';
$string['feedbackreport'] = 'Report del feedback';
$string['feedbackscore'] = 'Punteggio del feedback';
$string['feedbackscoreboundary'] = 'Valutazioni di riferimento del feedback';
$string['feedbackscores'] = 'Visualizza punteggi';
$string['feedbackscores_help'] = 'Visualizza la tabella dei punteggi del feedback';
$string['feedbacksection'] = 'Sezione';
$string['feedbacksectionheading'] = 'Intestazione del feedback per la sezione  {$a}';
$string['feedbacksectionheadingmissing'] = 'Inserire un\'intestazione per la sezione del Feedback!';
$string['feedbacksectionheadingtext'] = 'Intestazione';
$string['feedbacksectionlabel'] = 'Etichetta';
$string['feedbacksectionlabel_help'] = 'Questa etichetta verrà utilizzata in grafici/diagrammi. Deve essere il più breve possibile!';
$string['feedbacksectionquestions'] = '{$a} domande della sezione';
$string['feedbacksections'] = '{$a} sezioni per il feedback';
$string['feedbacksectionsselect'] = 'Sezioni';
$string['feedbacksectionsselect_help'] = 'Posiziona le tue domande in queste sezioni';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Impostazioni del feedback salvate';
$string['feedbacktype'] = 'Tipo di feedback';
$string['field'] = 'La domanda numero {$a}';
$string['fieldlength'] = 'Lunghezza del campo';
$string['fieldlength_help'] = 'Per il tipo di domanda **Campo di testo**, si può definire l\'ampiezza in caratteri del "Campo" visualizzato nel questionario e la massima lunghezza del testo da immettere.
I valori di default sono di 20 caratteri per l\'ampiezza del campo di testo e 25 caratteri per la massima lunghezza del testo da immettere.';
$string['finished'] = 'Hai risposto a tutte le domande di questo questionario!';
$string['firstrespondent'] = 'Primo utente che ha risposto';
$string['formateditor'] = 'Editor HTML';
$string['formatplain'] = 'Testo';
$string['grade'] = 'Valutazione ottenuta';
$string['gradesdeleted'] = 'Le valutazioni del questionario sono state eliminate';
$string['headingtext'] = 'Testo dell\'Intestazione';
$string['horizontal'] = 'Orizzontale';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Sovrascrivi le risposte con il valore dell\'opzione html';
$string['includechoicetext'] = 'Includi anche i testi delle risposte';
$string['includeincomplete'] = 'Includi risposte incomplete';
$string['includerankaverages'] = '';
$string['incorrectcourseid'] = 'ID del corso non corretto';
$string['incorrectmodule'] = 'ID del modulo non corretto';
$string['incorrectquestionnaire'] = 'Il questionario non è corretto';
$string['indirectwarnings'] = 'Lìelenco mostra le domande dipendenti indirette e le dipendenze rimanenti per le domande dipendenti dirette:';
$string['invalidresponse'] = 'La risposta specificata non è valida.';
$string['invalidresponserecord'] = 'Il record specificato per la risposta non è corretto.';
$string['invalidsectionid'] = 'E\' stata specificata una sezione non corretta del feedback.';
$string['invalidsurveyid'] = 'ID del questionario non corretto';
$string['kindofratescale'] = 'Tipo di scala';
$string['kindofratescale_help'] = 'Click con il pulsante destro del mouse sul link "Aiuto ulteriore"';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Ultimo utente che ha risposto';
$string['length'] = 'Lunghezza';
$string['managequestions'] = 'Gestisci domande';
$string['managequestions_help'] = 'Nella sezione Gestisci domande della pagina Modifica domande, puoi effettuare varie operazioni sulle domande del Questionario';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Obbligatorio - Tutte queste dipendenze devono essere soddisfatte.';
$string['maxdigitsallowed'] = 'Numero massimo di cifre consentite';
$string['maxdigitsallowed_help'] = 'Impostando i parametri del numero massimo di cifre consentite e delle cifre decimali, è possibile specificare la lunghezza e il numero dei decimali.';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Numero massimo di scelte';
$string['maxforcedresponses_help'] = 'Utilizza questi parametri per obbligare chi compila il questionario a selezionare un minimo di **Min.** caselle di spunta e un massimo di **Massimo** caselle di controllo. Per fare in modo che venga selezionato un numero esatto di caselle di controllo, imposta lo stesso valore su **Min.** e **Massimo**. Se si desidera impostare solo un valore minimo o solo un valore massimo, lasciare l\'altro valore di default a **00**: verrà visualizzato un messaggio di avviso se il rispondente non soddisfa i requisiti impostati. Occorre ovviamente chiarire qualsiasi requisito al rispondente, nelle istruzioni generali o nel testo delle domande pertinenti.';
$string['maxtextlength'] = 'Massima lunghezza del testo';
$string['maxtextlength_help'] = 'Per il tipo di domanda Casella di testo, immettere la lunghezza della casella di input e la lunghezza massima del testo del testo che deve essere inserita dal rispondente.
I valori predefiniti sono 20 caratteri per la larghezza della casella di input e 25 caratteri per la lunghezza massima del testo immesso.';
$string['messageprovider:message'] = 'Promemoria per il questionario';
$string['messageprovider:notification'] = 'Invio del quesionario';
$string['minforcedresponses'] = 'Numero minimo di scelte';
$string['minforcedresponses_help'] = 'Usa questi parametri per obbligare l\'utente a spuntare un **numero minimo di scelte** o un **numero massimo di scelte** fra le caselle di spunta disponibili. Per forzare un numero preciso di caselle di spunta da selezionare, assegnare a **numero minimo di scelte** e **numero massimo di scelte** il medesimo valore. Se si desidera soltanto un minimo o un massimo valore, lasciare l\'altro al suo valore di default **0**. Se si imposta il numero minimo di scelte o il numero massimo di scelte su valori diversi dallo 0 di default, sarà mostrato un messaggio di errore se chi risponde non si adeguerà ai vincoli imposti per la risposta. Ovviamente, è consigliabile fornire tutti i chiarimenti del caso nelle istruzioni generali del questionario o nel testo della specifica domanda o attraverso una etichetta.';
$string['misconfigured'] = 'Corso danneggiato';
$string['missingname'] = 'La domanda {$a} non può essere utilizzata nella sezione del feedback perché non ha un nome.';
$string['missingnameandrequired'] = 'La domanda {$a} non può essere utilizzata nella sezione del feedback perché non ha un nome e perché non è obbigatoria.';
$string['missingquestion'] = 'Per favore rispondi alla domanda obbligatoria';
$string['missingquestions'] = 'Per favore rispondi alle seguenti  domande obbligatorie:';
$string['missingrequired'] = 'La domanda {$a} non può essere utilizzata nella sezione del feedback perché non è obbligatoria.';
$string['modulename'] = 'Questionario';
$string['modulename_help'] = 'Il modulo Questionario consente di costruire questionari (indagini) usando diversi tipi di domande, allo scopo di raccogliere dati dagli utenti.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Questionari';
$string['movedisabled'] = 'Questo elemento non può essere spostato';
$string['myresponses'] = 'Tutte le mie risposte';
$string['myresponsetitle'] = 'I tuoi risultati per {$a} risposte';
$string['myresults'] = 'I miei risultati';
$string['name'] = 'Nome';
$string['navigate'] = 'Consenti domande condizionate';
$string['navigate_help'] = 'Consente alle domande di tipo Sì/No e Pulsanti radio di avere domande figlie dipendenti dalle opzioni selezionate nel questionario.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Ritorna alla sezione del feedback';
$string['next'] = 'Prossimo';
$string['nextpage'] = 'Pagina successiva';
$string['nlines'] = '{$a} linee';
$string['noanswer'] = 'Nessuna risposta';
$string['noattempts'] = 'Nessun tentativo è stato effettuato in questo questionario';
$string['nodata'] = 'Nessuna informazione inviata.';
$string['noduplicates'] = 'Duplicati non ammessi';
$string['noduplicateschoiceserror'] = 'Inserire almeno 2 risposte possibili per l\'opzione "Duplicati non ammessi"!';
$string['non_respondents'] = 'Utenti che non hanno ancora inviato le loro risposte al questionario';
$string['noneinuse'] = 'Il questionario non contiene domande.';
$string['nopublicsurveys'] = 'Non ci sono questionari pubblici.';
$string['noresponsedata'] = 'Nessuna risposta per questa domanda';
$string['noresponses'] = 'Nessuna risposta';
$string['normal'] = 'Normale';
$string['not_started'] = 'non iniziato';
$string['notanumber'] = '<strong>{$a}</strong> non è in un formato consentito.';
$string['notapplicable'] = 'N/D';
$string['notapplicablecolumn'] = 'Con colonna N/D';
$string['notavail'] = 'Questionario non ancora disponibile. Prova più tardi.';
$string['noteligible'] = 'Non è possibile partecipare al questionario';
$string['notemplatesurveys'] = 'Non ci sono modelli di questionario.';
$string['notenoughscaleitems'] = 'Inserire almeno 2 elementi!';
$string['notificationfull'] = 'Invio completo';
$string['notifications'] = 'Invia notifica della consegna del questionario';
$string['notifications_help'] = 'Invia una notifica della consegna del questionario agli utenti con la capability "mod/questionnaire:submissionnotification"';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Solo notifica';
$string['notopen'] = 'Il questionario sarà disponibile a partire dal {$a}';
$string['notrequired'] = 'Risposta non obbligatoria';
$string['notset'] = 'non impostato';
$string['nousersselected'] = 'Nessun utente selezionato';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} tentativi effettuati in questo questionario';
$string['numberfloat'] = 'Il numero inserito <strong>{$a->number}</strong> è stato arrotondato a <strong>{$a->precision}</strong> cifra/e decimale/i.';
$string['numberofdecimaldigits'] = 'Numero di cifre decimali';
$string['numberofdecimaldigits_help'] = 'Utilizza **Numero di cifre decimali** per specificare il formato del valore medio calcolato e mostrato nella pagina del report del Questionario.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Numero di valori';
$string['numberscaleitems_help'] = 'Numero di valori è il *numero di opzioni* che saranno usate nella scala. Si usa comunemente un valore compreso fra 3 e 5. Valore di default: **5**.';
$string['numeric'] = 'Numerico';
$string['numeric_help'] = 'Si usi questo tipo di domanda se si desidera che la risposta sia in formato numerico.';
$string['of'] = 'di';
$string['openafterclose'] = 'E\' stata indicata una data di apertura successiva a quella di chiusura';
$string['opendate'] = 'Consenti risposte dal';
$string['option'] = 'opzione {$a}';
$string['optional'] = 'Opzionale - Almeno una di queste dipendenze deve essere soddisfatta.';
$string['optionalname'] = 'Nome <em>(opzionale)</em>';
$string['optionalname_help'] = 'Il nome di una domanda è un identificativo mnemonico utile per il docente che gestisce il questionario.
Ciò nonostante, assegnare un nome ad una domanda non è assolutamente necessario. Quest\'ultimo, infatti, viene usato soltanto come intestazione delle colonne dei documenti di esportazione delle risposte ai questionari nel formato CSV ed Excel. Se non si intendono esportare tali dati, non c\'è alcuna necessità di assegnare dei nomi alle domande. Se, per contro, si prevede di esportare sistematicamente le risposte acquisite nei questionari, si hanno due possibilità d\'uso del nome della domanda.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = 'oppure:';
$string['order_ascending'] = 'Ascendente';
$string['order_default'] = 'Default';
$string['order_descending'] = 'Discendente';
$string['orderresponses'] = 'Ordina le risposte';
$string['orderresponses_help'] = 'Nella pagina "Visualizza tutte le risposte", le risposte sono ordinate di default nell\'ordine di creazione delle domande.
E\' possibile ordinare i 4 seguenti tipi di domande per numero di risposte:

* pulsanti radio (scelta singola)
* menu a tendina (scelta singola)
* caselle di spunta (scelta multipla)
* scala (1..5) (inclusa la Scala Likert).

E\' possibile visualizzarle in ordine discendente o ascendente.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Scala di Osgood';
$string['other'] = 'Altro:';
$string['otherempty'] = 'Questa selezione prevede che si debba inserire del testo nel campo corrispondente';
$string['overviewnumresplog'] = 'risposte';
$string['overviewnumresplog1'] = 'risposta';
$string['overviewnumrespvw'] = 'risposte';
$string['overviewnumrespvw1'] = 'risposta';
$string['owner'] = 'Proprietario';
$string['page'] = 'Pagina';
$string['pageof'] = 'Pagina {$a->page} di {$a->totpages}';
$string['parent'] = 'Domanda genitore';
$string['participant'] = 'Partecipanti';
$string['pleasecomplete'] = 'Per favore completa questa scelta.';
$string['pluginadministration'] = 'Amministrazione del Questionario';
$string['pluginname'] = 'Questionario';
$string['position'] = 'posizione';
$string['possibleanswers'] = 'Inserisci le possibili risposte';
$string['posteddata'] = 'Raggiunta la pagina con dati presenti:';
$string['preview_label'] = 'Anteprima';
$string['preview_questionnaire'] = 'Anteprima del questionario';
$string['previewing'] = 'Anteprima';
$string['previous'] = 'Precedente';
$string['previouspage'] = 'Pagina precedente';
$string['print'] = 'Stampa questo questionario';
$string['printblank'] = 'Stampa il modello vuoto';
$string['printblanktooltip'] = 'Apri il modello vuoto pronto per la stampa in una nuova finestra';
$string['printtooltip'] = 'Apri le risposte correnti pronte per la stampa in una nuova finestra';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Una domanda a risposta multipla.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'ID del record della scelta per questa risposta.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'ID del record della domanda per questa risposta.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'ID del record della risposta.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Risposta della domanda di tipo "scelta singola".';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'ID del record della scelta per questa risposta.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'ID del record della domanda per questa risposta.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'ID del record della risposta.';
$string['privacy:metadata:questionnaire_response'] = 'Risposta in corso o inviata';
$string['privacy:metadata:questionnaire_response:complete'] = 'Stato di completamento per questa risposta.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Punteggio della risposta.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'L\'ID del record del questionario per questa risposta.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Data ed ora del salvataggio più recente della risposta.';
$string['privacy:metadata:questionnaire_response:userid'] = 'ID del record dell\'utente per questa risposta.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Risposta a una domanda di tipo booleano (sì/no).';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Risposta specifica di tipo booleano.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'ID del record della domanda per questa risposta.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'ID del record della risposta.';
$string['privacy:metadata:questionnaire_response_date'] = 'Risposta della domanda di tipo "data".';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'ID del record della domanda per questa risposta.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Specifica risposta della domanda di tipo "data".';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'ID del record della risposta.';
$string['privacy:metadata:questionnaire_response_other'] = 'Testo della risposta alla domanda di tipo "altro",';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'ID del record della scelta per questa risposta.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'ID del record della domanda per questa risposta.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Specifica risposta alla domanda di tipo "altro".';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'ID del record della risposta.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Risposta della domanda di tipo "punteggio".';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'ID del record della scelta per questa risposta.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'ID del record della domanda per questa risposta.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Specifica risposta alla domanda di tipo "punteggio".';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'ID del record della risposta.';
$string['privacy:metadata:questionnaire_response_text'] = 'Risposta della domanda di tipo "campo di testo".';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'ID del record della domanda per questa risposta.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Specifica risposta alla domanda di tipo "campo di testo".';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'ID del record della risposta.';
$string['private'] = 'Privato';
$string['progressbar'] = 'Visualizza barra di progresso';
$string['progressbar_info'] = 'Questionario {$a} completo.';
$string['progresshelp'] = 'Barra di progesso';
$string['progresshelp_help'] = 'Vai alla pagina successiva per riempire la barra di progresso';
$string['public'] = 'Pubblico';
$string['publiccopy'] = 'Copia:';
$string['publicoriginal'] = 'Originale:';
$string['qtype'] = 'Possibilità di risposte';
$string['qtype_help'] = 'E\' possibile scegliere se limitare l\'erogazione del questionario ad una sola risposta per utente o consentirne la compilazione più volte e, nel caso, con quale cadenza.

* Se si desidera che l\'utente possa compilare il questionario una sola volta, si selezioni **Rispondi una sola volta**.
* Se si desidera abilitare l\'utente a rispondere liberamente al questionario un numero imprecisato di volte, si selezioni **Rispondi più volte**.
* Se si desidera abilitare l\'utente a rispondere al questionario con frequenza giornaliera, si selezioni **Rispondi quotidianamente**.
* Se si desidera abilitare l\'utente a rispondere al questionario con frequenza settimanale, si selezioni **Rispondi settimanalmente**.
* Se si desidera abilitare l\'utente a rispondere al questionario con frequenza mensile, si selezioni **Rispondi mensilmente**.';
$string['qtypedaily'] = 'Rispondi quotidianamente';
$string['qtypemonthly'] = 'Rispondi mensilmente';
$string['qtypeonce'] = 'Rispondi una sola volta';
$string['qtypeunlimited'] = 'Rispondi più volte';
$string['qtypeweekly'] = 'Rispondi settimanalmente';
$string['questionnaire:addinstance'] = 'Aggiungi un nuovo questionario';
$string['questionnaire:copysurveys'] = 'Copiare i modelli e i questionari non pubblici';
$string['questionnaire:createpublic'] = 'Creare questionari pubblici';
$string['questionnaire:createtemplates'] = 'Creare modelli di questionari';
$string['questionnaire:deleteresponses'] = 'Eliminare qualsiasi risposta';
$string['questionnaire:downloadresponses'] = 'Scaricare le risposte in un file di testo CSV';
$string['questionnaire:editquestions'] = 'Creare e modificare le domande dei questionari';
$string['questionnaire:manage'] = 'Creare e modificare i questionari';
$string['questionnaire:message'] = 'Invia messaggio agli utenti che non hanno risposto';
$string['questionnaire:preview'] = 'Anteprima dei questionari';
$string['questionnaire:printblank'] = 'Stampare il modello vuoto';
$string['questionnaire:readallresponseanytime'] = 'Leggere le risposte in qualunque momento';
$string['questionnaire:readallresponses'] = 'Leggere i sommari delle risposte, soggette a restrizioni temporali';
$string['questionnaire:readownresponses'] = 'Leggere le proprie risposte';
$string['questionnaire:submissionnotification'] = 'Ricevi notifiche per ogni invio';
$string['questionnaire:submit'] = 'Completare ed inviare questionari';
$string['questionnaire:view'] = 'Visualizzare i questionari';
$string['questionnaire:viewsingleresponse'] = 'Visualizzare le risposte di un singolo utente';
$string['questionnaireadministration'] = 'Amministrazione Questionario';
$string['questionnairecloses'] = 'Chiusura del questionario';
$string['questionnaireopens'] = 'Apertura del questionario';
$string['questionnairereport'] = 'Rapporto del questionario';
$string['questionnum'] = 'Domanda n°';
$string['questions'] = 'Domande';
$string['questionsinsection'] = 'Domande in questa sezione:';
$string['questiontypes'] = 'Tipi di domande';
$string['questiontypes_help'] = 'Per aggiungere al proprio questionario una nuova domanda, selezionare il tipo di domanda dal menu a tendina e premere il pulsante **Aggiungi una domanda del tipo selezionato**';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Pulsanti radio';
$string['radiobuttons_help'] = 'In questo tipo di domanda l\'utente deve selezionare una delle possibili scelte elencate.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Punteggio';
$string['ratescale'] = 'Scala (1..5)';
$string['ratescale_help'] = 'Per questo tipo di domanda si hanno due opzioni di visualizzazione. L\'opzione di default mostra i gradi della scala Likert come numeri (1...5). Se si preferisce avere gradi nominali invece di numeri, è possibile registrare questi nomi nella lista delle risposte. In ogni riga del campo relativo alle "risposte" registrare il numero del grado, immediatamente seguito dal segno di uguale = immediatamente seguito dal nome che si desidera assegnare a tale grado.
<br />
Attualmente, il numero che precede ogni nome del grado serve solo a ricordare la posizione nella scala orizzontale; esso non viene usato dal programma, e si può comunque utilizzare, ad esempio 0=Quasi mai; 0=Raramente; 0=Talvolta; etc. E\' necessario, però, cominciare con un numero immediatamente seguito dal segno di uguale = .
<br />
Se il numero di gradi nominali nella lista delle risposte è diverso da quello indicato nel campo **Numero di valori,** questo verrà automaticamente corretto quando si salverà la domanda. Se si decide di usare gradi nominali nella scala Likert, si raccomanda (ma non è obbligatorio) di cominciare la lista delle risposte con i gradi nominali, e registrare poi i diversi items da ordinare (per es. "Il mio studio è orientato...", "Ciò che studio è importante...", etc).';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Tipo di Questionario';
$string['realm_help'] = 'Sono previsti tre tipi di questionario:

* **Privato**: riguarda il solo corso nel quale è definito.
    Questa è la modalità standard di questo modulo. Viene creato un questionario nel corso di Moodle e i suoi contenuti divengono parte integrante del corso stesso. I docenti con permesso di modifica del corso (editing teacher) possono modificare il questionario e tutti i docenti possono esaminare i risultati.
* **Modello**: può essere copiato ed modificato.
    Questo tipo di questionario non può essere usato direttamente ma il suo contenuto può essere copiato in un nuovo questionario, modificato e, quindi, essere riutilizzato.
* **Pubblico**: può essere condiviso fra più corsi.
    Se un questionario è già stato creato (in un altro corso della stessa installazione di Moodle) con l\'opzione **Tipo di questionario** impostata a **Pubblico**, allora può essere utilizzato, così come è, in altri corsi. Il numero di opzioni disponibili ai docenti dei corsi (con i quali questo questionario è condiviso) per questo tipo di questionario è ridotto e non è possibile né modificarne il contenuto né visualizzarne le risposte.

<br />**Esempio**:
    Se un questionario di tipo "Pubblico" è stato creato nel corso A esso può essere erogato nei corsi B, C... Tutte le risposte dagli utenti dei corsi A, B, C... saranno raccolte nel questionario pubblico creato nel corso A e saranno visualizzabili solamente nel contesto del corso A dagli amministratori o docenti che lo hanno realizzato. In altri termini, le modifiche e la visulizzazione potranno essere eseguite solamente dagli aventi diritto nel contesto del corso nel quale il questionario è stato originariamente creato come "Pubblico".';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'L\'URL alla quale viene re-indirizzato l\'utente dopo aver partecipato al questionario';
$string['remove'] = 'Elimina';
$string['removeallquestionnaireattempts'] = 'Elimina tutte le risposte al questionario';
$string['removenotinuse'] = 'Questo questionario dipendeva da un questionario pubblico che è stato eliminato.
Non può più essere usato e deve essere cancellato.';
$string['required'] = 'Risposta obbligatoria';
$string['required_help'] = 'Se si seleziona **Sì**, la domanda sarà obbligatoria, ovvero l\'utente non potrà inviare il questionario senza aver prima risposto a questa domanda. Se, prima di rispondere alle domande obbligatorie, si cercherà di inviare un questionario (o, nel caso di questionari su più pagine, di passare ad un\'altra pagina dello stesso) verrà mostrato un messaggio di errore con l\'elenco di tutte le domande obbligatorie alle quali non si è fornita risposta nel questionario (o nella pagina).';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'E\' stato omesso un parametro obbligatorio.';
$string['reset'] = 'Resetta';
$string['respeligiblerepl'] = '(rimpiazzata dai ruoli)';
$string['respondent'] = 'Partecipante';
$string['respondenteligibleall'] = 'tutti';
$string['respondenteligiblestudents'] = 'solo studenti';
$string['respondenteligibleteachers'] = 'solo docenti';
$string['respondents'] = 'Partecipanti';
$string['respondenttype'] = 'Riconoscimento del partecipante';
$string['respondenttype_help'] = 'E\' possibile mostrare il nome completo degli utenti che compilano il questionario selezionando la voce "nome completo".
E\' possibile nascondere l\'identità degli stessi selezionando la voce "anonimo". <br />
**Nota:**<br />
Se il corso Moodle consente l\'accesso agli ospiti, questi ultimi saranno autorizzati a rispondere soltanto ai questionari per i quali l\'identità del compilatore è stato impostata ad "anonima".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonimo';
$string['respondenttypefullname'] = 'nome completo';
$string['response'] = 'Risposta';
$string['responsefieldlines'] = 'Dimensione della casella di testo';
$string['responseformat'] = 'Formato delle risposte';
$string['responseoptions'] = 'Opzioni delle risposte';
$string['responses'] = 'Risposte';
$string['responseview'] = 'Visibilità dei questionari inviati';
$string['responseview_help'] = 'E\' possibile specificare in quale circostanza si consente la visualizzazione della totalità dei questionari inviati dagli utenti (statistiche generali)

-	Per consentire agli studenti di vedere tutti i questionari inviati a posteriori dell\'invio del proprio questionario si scelga **Dopo aver risposto al questionario**. Ovviamente l\'accesso alla totalità dei questionari inviati sarà consentita solo se il parametro **Diritto di rispondere** risulterà impostato a **Rispondi una sola volta**.
- Se il parametro **Diritto di rispondere** dovesse essere impostato, invece, a **Rispondi più volte** (o comunque ad una voce diversa da **Rispondi una sola volta**), allora gli studenti potrebbero vedere le risposte inviate soltanto se una delle seguenti due opzioni venisse selezionata per il parametro **Visibilità dei questionari inviati**:

* Dopo che il questionario è stato chiuso.
* Sempre

 <br />
Si ricorra al sistema di ruoli e privilegi per decidere quale categoria di utenti può visualizzare:

* le risposte inviate personalmente
* tutte le risposte inviate';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Sempre';
$string['responseviewstudentsnever'] = 'Mai';
$string['responseviewstudentswhenanswered'] = 'Dopo aver risposto al questionario';
$string['responseviewstudentswhenclosed'] = 'Dopo che il questionario è stato chiuso';
$string['restrictedtoteacher'] = 'Queste funzioni sono riservate ai docenti con il diritto di modifica del corso';
$string['resume'] = 'Salva/Riprendi risposte';
$string['resume_help'] = 'Quando è selezionata l\'opzione **Sì**, gli utenti possono salvare le loro risposte nel questionario prima di inviarlo. Gli utenti possono, cioè, interrompere la compilazione del questionario non terminato e riprenderla, successivamente, così come la avevano lasciata.
<br />**Nota:**<br />
Se questa opzione è impostata a **Sì**, gli ospiti non saranno autorizzati a compilare il questionario.
Questo dipende dal fatto che non c\'è modo per Moodle di distinguere un ospite da un altro, e, di conseguenza, non avrebbe senso che un ospite potesse cominciasse a rispondere ad un questionario mentre un altro potesse portarlo a termine.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Riprendi questionario';
$string['return'] = 'Ritorna';
$string['save'] = 'Salva';
$string['saveasnew'] = 'Salva come nuova domanda';
$string['savedbutnotsubmitted'] = 'La compilazione del questionario è stata salvata ma non ancora inviata.';
$string['savedprogress'] = 'La compilazione del questionario è stata salvata. E\' possibile riprendere e concludere il questionario in qualsiasi momento.';
$string['saveeditedquestion'] = 'Salva la domanda corrente';
$string['savesettings'] = 'Salva le modifiche';
$string['search:activity'] = 'Questionario - informazioni sull\'attività';
$string['search:question'] = 'Questionario - domande';
$string['section'] = 'Descrizione';
$string['sectionbreak'] = '---Interruzione di pagina---';
$string['sectionbreak_help'] = '---Interruzione di pagina---';
$string['sectionsnotset'] = 'Selezionare almeno UNA domanda per sezione! <br /> Sezione/i non selezionata/e: {$a}';
$string['sectiontext'] = 'Etichetta';
$string['sectiontext_help'] = 'Questa non è una domanda bensì un testo (breve) che sarà mostrato all\'interno del questionario.';
$string['selecttheme'] = 'Seleziona un tema (css) da usare per il questionario.';
$string['send'] = 'Invia';
$string['send_message'] = 'Invia un messaggio agli utenti selezionati';
$string['send_message_to'] = 'Invia messaggio a:';
$string['sendemail'] = 'Invia una copia di ogni questionario completato a questo indirizzo: (oppure lascia in bianco per non ricevere email)';
$string['sendemail_help'] = 'Ad ogni invio di un questionario da parte di un qualunque utente, una copia dei dati inviati verrà spedita per posta elettronica ANCHE all\'indirizzo qui indicato. Nel caso in cui non venga specificato alcun indirizzo di posta elettronica, non verrà inviata alcuna email.
Si possono inserire più indirizzi di posta elettronica separati da una virgola.';
$string['set'] = 'imposta';
$string['settings'] = 'Impostazioni';
$string['settingssaved'] = 'Impostazioni salvate';
$string['show_nonrespondents'] = 'Mostra gli utenti che non hanno risposto';
$string['started'] = 'iniziato';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'E\' possibile usare il formato gg/mm/aaaa, es: 14 Marzo, 1945 <strong>14/3/1945</strong>';
$string['subject'] = 'Argomento';
$string['submissionnotificationhtmlanon'] = 'Nuovo <a href="{$a->submissionurl}">invio</a> per il questionario "{$a->name}"';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> ha effettuato un nuovo <a href="{$a->submissionurl}">invio</a> del questionario "{$a->name}" del corso "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Nuovo invio del questionario';
$string['submissionnotificationtextanon'] = 'Nuovo <a href="{$a->submissionurl}">invio</a> per il questionario "{$a->name}"';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) ha effettuato un nuovo invio ({$a->submissionurl}) del questionario "{$a->name}" nel corso "{$a->coursename}".';
$string['submitoptions'] = 'Opzioni di invio';
$string['submitpreview'] = 'Invia l\'anteprima';
$string['submitpreviewcorrect'] = 'Questo invio sarebbe stato accettato perché correttamente compilato.';
$string['submitsurvey'] = 'Invia questionario';
$string['submitted'] = 'Inviato in data:';
$string['subtitle'] = 'Sottotitolo';
$string['subtitle_help'] = 'Sottotitolo del questionario. Il sottotitolo viene visualizzato immediatamente dopo il titolo del questionario soltanto nella prima pagina del questionario stesso.';
$string['summary'] = 'Sommario';
$string['summaryreportattached'] = 'Sommario del report del questionario allegato';
$string['surveynotexists'] = 'Il questionario non esiste.';
$string['surveyowner'] = 'Devi essere il titolare del questionario per procedere.';
$string['surveyresponse'] = 'Risposte dal questionario';
$string['template'] = 'Modello';
$string['templatenotviewable'] = 'Il modello del questionario non è visibile';
$string['text'] = 'Contenuto della domanda';
$string['textareacolumns'] = 'Numero di colonne';
$string['textareacolumns_help'] = 'Questo tipo di domanda mostra all\'utente un\'area per digitare una risposta di tipo **testo lungo**. L\'ampiezza di questa area è misurata in colonne e righe. Le prime definiscono la larghezza dell\'area, le seconde l\'altezza della stessa. Se non si specificano i valori per Numero di colonne e Numero di righe (ovvero se si lasciano al loro valore di default **0** o se si pongono pari a **0**), allora l\'editor HTML verrà mostrato (se reso disponibile nel contesto corso/utente e nel profilo utente) con ampiezza ed altezza standard.';
$string['textarearows'] = 'Numero di righe';
$string['textbox'] = 'Campo di testo';
$string['textbox_help'] = 'Per le domande di tipo **Campo di testo**, si indichi l\'ampiezza del campo di testo (espressa in caratteri) e la massima lunghezza del testo che l\'utente può immettere.
I valori di default sono: 20 caratteri per l\'ampiezza (in caratteri) del campo di testo e 25 caratteri di lunghezza massima del testo da immettere.';
$string['textdownloadoptions'] = 'Opzioni per il dowload in formato testo (CSV)';
$string['thank_head'] = 'Grazie per aver compilato il questionario.';
$string['theme'] = 'Tema';
$string['thismonth'] = 'questo mese';
$string['thisresponse'] = 'Questa risposta';
$string['thisweek'] = 'questa settimana';
$string['thousands'] = 'Non utilizzare il separatore delle migliaia.';
$string['title'] = 'Titolo';
$string['title_help'] = 'Il titolo del questionario appare nell\'intestazione di ogni pagina del questionario stesso. Di default il titolo corrisponde al nome del questionario ma, ovviamente, è possibile modificarlo sulla base delle proprie necessità.';
$string['today'] = 'oggi';
$string['total'] = 'Totale';
$string['totalofnumbers'] = 'Totale dei numeri inseriti';
$string['totalresponses'] = 'Risposte totali al questionario';
$string['type'] = 'Tipo';
$string['undefinedquestiontype'] = 'Tipo di domanda non definito!';
$string['unknown'] = 'Sconosciuto';
$string['unknownaction'] = 'E\' stata inoltrata una richiesta incomprensibile...';
$string['url'] = 'URL';
$string['url_help'] = 'E\' l\'indirizzo internet al quale l\'utente verrà re-indirizzato successivamente all\'invio del questionario.';
$string['useprivate'] = 'Copia esistente';
$string['usepublic'] = 'Usa pubblico';
$string['usetemplate'] = 'Copia esistente';
$string['vertical'] = 'Verticale';
$string['view'] = 'Visualizza';
$string['viewallresponses'] = 'Visualizza tutte le risposte';
$string['viewallresponses_help'] = 'Se il questionario è impostato su **Modalità Gruppi: Gruppi visibili** o se è impostato su **Gruppi separati** e  l\'utente è autorizzato a visualizzare tutti i gruppi (nel contesto corrente) e i gruppi sono stati definiti nel corso corrente, sarà disponibile un menu a tendina con la lista dei gruppi, che permetterà di "filtrare" le risposte dei questionari per gruppi. Se invece l\'impostazione è **Modalità gruppi: Gruppi separati**, gli utenti che non sono autorizzati a visualizzare tutti i gruppi (ad esempio, in genere gli studenti o i docenti non editor), potranno visualizzare esclusivamente le risposte del gruppo o gruppi a cui appartengono.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Elenco delle risposte';
$string['viewindividualresponse'] = 'Risposte individuali';
$string['viewindividualresponse_help'] = 'Per visualizzare le risposte individuali, clicca sul nome degli utenti che hanno compilato il questionario nell\'elenco sottostante';
$string['viewresponses'] = 'Tutte le risposte ({$a})';
$string['viewyourresponses'] = 'Le mie risposte ({$a})';
$string['warning'] = 'Attenzione: E\' stato rilevato un errore.';
$string['wronganswers'] = 'Errore nelle risposte (vedi sotto)';
$string['wrongdateformat'] = 'La data immessa: <strong>{$a}</strong> non corrisponde al formato mostrato nell\'esempio.';
$string['wrongdaterange'] = 'ERRORE! L\'anno deve essere compreso fra il 1902 ed il 2037.';
$string['wrongformat'] = 'Errore nella risposta alla domanda:&nbsp;';
$string['wrongformats'] = 'Errore nella risposta alle domande:&nbsp;';
$string['yesno'] = 'Sì/No';
$string['yesno_help'] = 'Domanda di tipo Sì/No.';
$string['yourresponse'] = 'La tua risposta';
$string['yourresponses'] = 'Le tue risposte';
