define("core/local/collapsable_section/controls",["exports","core/local/collapsable_section/events","theme_boost/bootstrap/collapse"],(function(_exports,_events,_collapse){var obj;
/**
   * The collapsable sections controls.
   *
   * @module     core/local/collapsable_section/controls
   * @copyright  2024 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   *
   * @example <caption>Example of controlling a collapsable section.</caption>
   *
   * import CollapsableSection from 'core/local/collapsable_section/controls';
   *
   * const section = CollapsableSection.instanceFromSelector('#MyCollapsableSection');
   *
   * // Use hide, show and toggle methods to control the section.
   * section.hide();
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_collapse=(obj=_collapse)&&obj.__esModule?obj:{default:obj};let initialized=!1;return _exports.default=class{static instanceFromSelector(selector){const elements=document.querySelector(selector);if(!elements)throw new Error("No elements found with the selector: "+selector);return new this(elements)}static init(){initialized||(initialized=!0,document.addEventListener(_events.eventTypes.hiddenBsCollapse,(event=>{this.isCollapsableComponent(event.target)&&(0,_events.notifyCollapsableSectionHidden)(event.target)})),document.addEventListener(_events.eventTypes.shownBsCollapse,(event=>{this.isCollapsableComponent(event.target)&&(0,_events.notifyCollapsableSectionShown)(event.target)})))}static isCollapsableComponent(element){return element.hasAttribute("data-mdl-component")&&"core/local/collapsable_section"===element.getAttribute("data-mdl-component")}constructor(element){this.element=element}hide(){_collapse.default.getOrCreateInstance(this.element).hide()}show(){_collapse.default.getOrCreateInstance(this.element).show()}toggle(){_collapse.default.getOrCreateInstance(this.element).toggle()}isVisible(){return _collapse.default.getOrCreateInstance(this.element)._isShown()}},_exports.default}));

//# sourceMappingURL=controls.min.js.map