<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'ru', version '5.0'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Отказано в доступе';
$string['accountlocked'] = 'Ваша учетная запись заблокирована. Ссылка для разблокировки была отправлена на адрес электронной почты.';
$string['accounts'] = 'Учетные записи';
$string['accountunlocked'] = 'Ваша учетная запись успешно разблокирована. Теперь вы можете войти в систему.';
$string['addcategory'] = 'Добавить категорию';
$string['additionalhtml'] = 'Дополнительный HTML';
$string['additionalhtml_desc'] = 'Эти параметры позволяют указать HTML-код, который необходимо добавить на каждую страницу. Вы можете задать HTML-код, который будет добавлен на странице в тег HEAD, сразу после открывающего тега BODY или непосредственно перед закрывающим тегом BODY.<br />Это позволяет очень легко расположить пользовательские колонтитулы на каждой странице или добавить поддержку таких сервисов как Google Analytics независимо от выбранной Вами темы.';
$string['additionalhtml_heading'] = 'Дополнительный HTML-код, добавляемый на каждую страницу.';
$string['additionalhtmlfooter'] = 'Перед закрывающим тегом BODY';
$string['additionalhtmlfooter_desc'] = 'Это содержимое будет добавлено на каждую страницу непосредственно перед закрывающим тегом BODY.';
$string['additionalhtmlhead'] = 'В тег HEAD';
$string['additionalhtmlhead_desc'] = 'Это содержимое будет добавлено в конец тега HEAD для каждой страницы.';
$string['additionalhtmltopofbody'] = 'После открывающего тега BODY';
$string['additionalhtmltopofbody_desc'] = 'Это содержимое будет добавлено на каждую страницу сразу после открывающего тега BODY.';
$string['admincategory'] = 'Категория: {$a}';
$string['adminseesall'] = 'Администраторы видят всё';
$string['adminseesallevents'] = 'Администраторы видят все события';
$string['adminseesownevents'] = 'Администратор видит события как простые пользователи';
$string['advancedfeatures'] = 'Расширенные возможности';
$string['agedigitalconsentverification'] = 'Проверка возраста цифровой дееспособности';
$string['agedigitalconsentverification_desc'] = 'Включает проверку возраста цифровой дееспособности перед отображением страницы регистрации для самостоятельно регистрирующихся пользователей. Это защищает ваш сайт от несовершеннолетних, регистрирующихся без согласия родителей/опекунов. Для дополнительной помощи предоставляются <a target="_blank" href="{$a}">Контакты службы поддержки</a>.';
$string['ageofdigitalconsentmap'] = 'Возраст цифровой дееспособности';
$string['ageofdigitalconsentmap_desc'] = 'Здесь можно указать возраст цифровой дееспособности по умолчанию и его значение в любой стране, где он отличается от возраста по умолчанию. Введите каждое значение возраста с новой строки в формате: код страны, возраст (разделяя из запятой). Для возраста по умолчанию вместо кода страны введите *. Коды стран указываются в соответствии с ISO 3166-2.';
$string['allcountrycodes'] = 'Коды доступных стран';
$string['allowattachments'] = 'Разрешить вложения';
$string['allowbeforeblock'] = 'Начать со списка разрешенных адресов';
$string['allowbeforeblockdesc'] = 'По умолчанию сначала проверяется список заблокированных адресов. При включенном параметре адреса будут сначала проверяться по списку разрешенных IP-адресов.';
$string['allowcategorythemes'] = 'Разрешить темы для категорий';
$string['allowcohortthemes'] = 'Разрешить темы для глобальных групп';
$string['allowcoursethemes'] = 'Разрешить темы для курсов';
$string['allowedemaildomains'] = 'Разрешенные почтовые домены';
$string['allowediplist'] = 'Список разрешенных IP-адресов';
$string['allowemailaddresses'] = 'Разрешенные почтовые домены';
$string['allowemojipicker'] = 'Палитра эмодзи';
$string['allowframembedding'] = 'Разрешить встраивание во фрейм';
$string['allowframembedding_help'] = 'При включенном параметре этот сайт может быть встроен во фрейм в удаленной системе, что рекомендуется делать при использовании плагина записи на курс «Опубликовать как инструмент LTI». Во всех остальных случаях, рекомендуется оставлять встраивание во фрейм отключенным по соображениям безопасности.<br /> Обратите внимание, что для мобильного приложения этот параметр игнорируется, а встраивание во фрейм всегда разрешено.';
$string['allowguestmymoodle'] = 'Разрешить гостевой доступ к странице «Личный кабинет»';
$string['allowindexing'] = 'Разрешить индексирование поисковыми системами';
$string['allowindexing_desc'] = 'Этот параметр определяет варианты индексирования вашего сайта поисковыми системами. «Везде» позволит поисковым системам искать везде, включая страницы входа и регистрации, что означает, что сайты с включенным принудительным входом по-прежнему индексируются. Чтобы избежать риска спама, связанного с доступной для индексирования страницы регистрации, используйте «Везде, кроме страниц входа и регистрации». «Нигде» не позволит поисковым системам индексировать какую-либо страницу. Обратите внимание, что параметр  только задает тег в заголовке сайта. Отслеживание тега зависит от поисковой системы.';
$string['allowindexingeverywhere'] = 'Везде';
$string['allowindexingexceptlogin'] = 'Везде, кроме страниц входа и регистрации';
$string['allowindexingnowhere'] = 'Нигде';
$string['allowobjectembed'] = 'Разрешить теги EMBED и OBJECT';
$string['allowthemechangeonurl'] = 'Разрешить смену темы в строке адреса';
$string['allowuserblockhiding'] = 'Разрешить пользователям скрывать блоки';
$string['allowusermailcharset'] = 'Разрешить пользователю выбирать кодировку';
$string['allowuserswitchrolestheycantassign'] = 'Разрешить пользователям без права назначения ролей переключать роли';
$string['allowuserthemes'] = 'Разрешить пользовательские темы';
$string['alternativefullnameformat'] = 'Формат альтернативного полного имени';
$string['alternativefullnameformat_desc'] = 'Параметр определяет, как пользователям с правом «viewfullnames» (по умолчанию пользователи с ролью управляющего, учителя или ассистента) отображаются имена. Подстановки, которые могут быть использованы, такие же, как для параметра «Формат полного имени».';
$string['always'] = 'Всегда';
$string['appearance'] = 'Внешний вид';
$string['aspellpath'] = 'Путь к aspell';
$string['asyncbackupdisabled'] = 'В настоящее время ваш сайт настроен на использование синхронного резервного копирования. Опыт показал, что асинхронное резервное копирование обеспечивает лучший результат.
Асинхронное резервное копирование будет включено для всех сайтов LMS Moodle 4.5 LTS.
Синхронное резервное копирование будет исключено из LMS Moodle после версии 4.5 LTS.';
$string['authentication'] = 'Аутентификация';
$string['authpreventaccountcreation'] = 'Предотвратить создание учетной записи при аутентификации';
$string['authpreventaccountcreation_help'] = 'Во время аутентификации пользователя автоматически создается учетная запись, если таковой еще не существует. Если для аутентификации используется внешняя база данных, такая как LDAP, но Вы хотите ограничить доступ к сайту только пользователям с существующей учетной записью, то следует включить этот параметр. В этом случае новые учетные записи должны быть созданы вручную или через функцию загрузки пользователей. Обратите внимание, что этот параметр не относится к аутентификации MNet.';
$string['authsettings'] = 'Настройки аутентификации';
$string['autolang'] = 'Автоопределение языка';
$string['autolangusercreation'] = 'При создании учетной записи установить язык браузера пользователя в качестве предпочтительного языка';
$string['autologinguests'] = 'Автоматический вход гостем';
$string['availableto'] = 'Доступно для';
$string['availabletoanyone'] = 'Доступно для всех посетителей сайта';
$string['availabletoauthenticated'] = 'Доступно для аутентифицированных пользователей';
$string['backgroundcolour'] = 'Цвет фона (для эффекта прозрачности)';
$string['backup_shortname'] = 'Использовать название курса в имени файла резервной копии';
$string['backup_shortnamehelp'] = 'Использовать название курса в имени файла резервной копии.';
$string['backups'] = 'Резервные копии';
$string['badwordsconfig'] = 'Введите список нецензурных слов через запятую';
$string['badwordsdefault'] = 'Если данный список пуст, то будет использован стандартный список из языкового пакета.';
$string['badwordslist'] = 'Список нецензурных слов';
$string['blockediplist'] = 'Список заблокированных IP-адресов';
$string['blockinstances'] = 'Экземпляров';
$string['blockmultiple'] = 'Многократный';
$string['blockprotect'] = 'Защитить экземпляры';
$string['blockprotect_help'] = 'Если Вы блокируете конкретный тип блока, то никто не сможет добавить или удалить его. (Конечно, можно разблокировать его снова, если нужно отредактировать).

В первую очередь это используется для защиты блоков навигации и настроек, которые очень трудно вернуть обратно при случайном удалении.';
$string['blockprotectblock'] = 'Защитить экземпляры блока {$a}';
$string['blockprotected'] = 'Блок {$a} теперь защищен';
$string['blocksettings'] = 'Управление блоками';
$string['blockunprotectblock'] = 'Снять защиту экземпляров блока {$a}';
$string['blockunprotected'] = 'Блок {$a} больше не защищен';
$string['bloglevel'] = 'Просмотр блогов';
$string['bookmarkadded'] = 'Закладка добавлена.';
$string['bookmarkalreadyexists'] = 'Вы уже добавили эту страницу в закладки.';
$string['bookmarkdeleted'] = 'Закладка удалена.';
$string['bookmarkthispage'] = 'Добавить в избранное';
$string['cacheapplication'] = 'Кэш приложения';
$string['cacheapplicationhelp'] = 'Кэшированные элементы являются общими для всех пользователей и обновляются через заданный интервал времени (ttl).';
$string['cachejs'] = 'Кэшировать Javascript';
$string['cachejs_help'] = 'Кэширование и сжатие Javascript значительно повышают скорость загрузки страниц. Настоятельно рекомендуется для сайтов в промышленной эксплуатации. Разработчикам, вероятно, стоит отключить эту функцию.';
$string['cacherequest'] = 'Кэш запросов';
$string['cacherequesthelp'] = 'Кэш каждого отдельного пользователя, истекающий после завершения запроса. Предназначен для замены областей, использующих статические данные.';
$string['cachesession'] = 'Кэш сеансов';
$string['cachesessionhelp'] = 'Кэш каждого отдельного пользователя на время действия сеанса. Предназначен для снижения нагрузки при управлении сеансами.';
$string['cachesettings'] = 'Настройки кэширования';
$string['cachetemplates'] = 'Кэшировать шаблоны';
$string['cachetemplates_help'] = 'Кэширование шаблонов улучшит производительность загрузки страниц и настоятельно рекомендуется для рабочих сайтов. Разработчики, вероятно, захотят отключить эту функцию.';
$string['caching'] = 'Кэширование';
$string['calendar_weekend'] = 'Выходные';
$string['calendarexportsalt'] = 'Зашумление для экспорта календаря';
$string['calendarsettings'] = 'Календарь';
$string['calendartype'] = 'Тип календаря';
$string['calendartype_desc'] = 'Выберите для всего сайта тип календаря по умолчанию. Этот параметр может быть изменен в настройках курса или пользователями в своем личном профиле.';
$string['campaign'] = 'Кампания';
$string['cannotdeletemodfilter'] = 'Вы не можете удалить «{$a->filter}», так как он является частью модуля «{$a->module}».';
$string['cannotuninstall'] = 'Невозможно удалить {$a}.';
$string['categoryemail'] = 'Электронная почта';
$string['cfgwwwrootslashwarning'] = 'В файле config.php неправильно определен параметр $CFG->wwwroot. В конце он содержит символ «/», который необходимо удалить.';
$string['cfgwwwrootwarning'] = 'В файле config.php неправильно определен параметр $CFG->wwwroot. Он должен соответствовать URL, который вы используете для доступа к этой странице.';
$string['change'] = 'изменить';
$string['checkboxno'] = 'Нет';
$string['checkboxyes'] = 'Да';
$string['checkupgradepending'] = 'Обновить';
$string['choosefiletoedit'] = 'Выберите файл для редактирования';
$string['cleanup'] = 'Очистка';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Выходим не спеша, пожалуйста, подождите ...';
$string['cliexitnow'] = 'Выходим прямо СЕЙЧАС';
$string['cliincorrectvalueerror'] = 'Ошибка, некорректное значение «{$a->value}» для «{$a->option}»';
$string['cliincorrectvalueretry'] = 'Некорректное значение, пожалуйста, попробуйте заново';
$string['clistatusdisabled'] = 'Состояние: режим технического обслуживания выключен';
$string['clistatusenabled'] = 'Состояние: режим технического обслуживания включен';
$string['clistatusenabledlater'] = 'Состояние: режим технического обслуживания будет включен в {$a}';
$string['clitypevalue'] = 'введите значение';
$string['clitypevaluedefault'] = 'введите значение, нажмите Enter для использования значения по умолчанию ({$a})';
$string['cliunknowoption'] = 'Нераспознанные параметры:
  {$a}
Пожалуйста, воспользуйтесь параметром --help';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Для очистки остальных кэшей после переключения пользовательского трафика на новый код:

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

Рекомендуется выполнять эти очистки по отдельности, с промежутком между командами, чтобы уменьшить пиковые нагрузки на веб-сервер.';
$string['cliupgradedefault'] = 'Новый параметр: {$a}';
$string['cliupgradedefaultheading'] = 'Установка новых значений по умолчанию';
$string['cliupgradedefaultverbose'] = 'Новый параметр: {$a->name}, Значение по умолчанию: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Обновление из командной строки с версии {$a->oldversion} до версии {$a->newversion} успешно завершено.';
$string['cliupgrademaintenancenotrequired'] = 'Это обновление НЕ приведет к режиму обслуживания для пользователей.';
$string['cliupgrademaintenancerequired'] = 'Это обновление приведет к режиму обслуживания для пользователей.';
$string['cliupgradenoneed'] = 'Для установленной версии {$a} обновление не требуется. В любом случае, спасибо!';
$string['cliupgradepending'] = 'Ожидается обновление';
$string['cliupgradesetlock'] = 'Выполнение обновления с командной строки заблокировано.';
$string['cliupgradeunsetlock'] = 'Существующая блокировка выполнения обновления с командной строки была снята.';
$string['cliyesnoprompt'] = 'Введите y (обозначает Да) или n (обозначает Нет)';
$string['close'] = 'Закрыть';
$string['cohort_customfield'] = 'Пользовательские поля глобальной группы';
$string['commentsperpage'] = 'Количество комментариев на странице';
$string['commonactivitysettings'] = 'Общие настройки';
$string['commonfiltersettings'] = 'Общие настройки фильтров';
$string['commonsettings'] = 'Общие настройки';
$string['componentinstalled'] = 'Компонент установлен';
$string['computedfromlogs'] = 'Вычислять из журнала событий, начиная с {$a}.';
$string['condifmodeditdefaults'] = 'Значения по умолчанию используются в форме параметров при создании новых элементов курса или ресурсов.';
$string['confeditorhidebuttons'] = 'Выберите кнопки, которые будут скрыты в HTML-редакторе.';
$string['configallcountrycodes'] = 'Этот список доступных стран будет отображаться в различных местах, например, в профиле пользователя. Если параметр пуст (по умолчанию), то будет использоваться список из файла countries.php стандартного английского языкового пакета. Это список из ISO 3166-1. В противном случае Вы можете указать список разделенных запятыми кодов, например: «RU,UK,FR». Если Вы добавляете сюда новые нестандартные коды, то необходимо добавить их в файлы countries.php английского и своего языкового пакета.';
$string['configallowassign'] = 'Для каждой роли в левом столбце выберите роли, которые они могут назначать другим.';
$string['configallowattachments'] = 'При включенном параметре письма, отправляемые с сайта, могут иметь вложения (например, значки).';
$string['configallowcategorythemes'] = 'Если Вы включите этот параметр, то можно будет устанавливать темы на уровне категорий курсов. Это затронет все дочерние категории и курсы, если у них не установлены свои собственные темы. ПРЕДУПРЕЖДЕНИЕ: Включение тем для категорий может снизить производительность.';
$string['configallowcohortthemes'] = 'При включенном параметре можно задать темы на уровне глобальных групп. Это затронет всех пользователей только одной глобальной группы или нескольких глобальных групп, но с одинаковой темой.';
$string['configallowcoursethemes'] = 'Если Вы включите этот параметр, то появится возможность устанавливать курсам их собственные темы. Тема курса преобладает над остальными темами (темами сайта, пользователя или глобальной группы).';
$string['configallowedemaildomains'] = 'Перечислите почтовые домены, адреса которых разрешено раскрывать в поле «От кого» исходящей почты. При использовании значения по умолчанию (пустой строки) для всех исходящих писем в поле «От кого» будет указано значение параметра «Адрес для писем, не требующих ответа». Допустимо использование подстановок. Если указать значение *.example.ru, то будет разрешено отправлять сообщения с любого поддомена example.ru, но не с самого домена example.ru. Для самого домена потребуется отдельная запись.';
$string['configallowemailaddresses'] = 'Если Вы хотите ограничить все новые адреса электронной почты определенными доменами, перечислите их, разделяя пробелами. Все остальные домены будут запрещены. Чтобы разрешить все дочерние домены, начните название с точки (.),
Чтобы разрешить корневой домен вместе с его поддоменами, добавьте домен дважды - один раз с предшествующей точкой (.) и один раз без неё, например, <strong>.ourcollege.edu.ru ourcollege.edu.ru </strong>.';
$string['configallowemojipicker'] = 'Палитра эмодзи позволяет пользователям выбирать эмодзи, такие как смайлики, для добавления в сообщения и другие текстовые области с помощью кнопки выбора эмодзи на панели инструментов Atto.';
$string['configallowemojipickerincompatible'] = 'Ваша текущая конфигурация базы данных не поддерживает эмодзи. Чтобы включить палитру эмодзи, вам необходимо <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> обновить базу данных для полной поддержки юникода </a>.';
$string['configallowguestmymoodle'] = 'Открывает гостевой доступ к странице «Личный кабинет». Если отключено, то гость перенаправляется на главную страницу сайта.';
$string['configallowobjectembed'] = 'В целях безопасности пользователям с ролью студента не разрешено встраивать мультимедиа в HTML-тексты с помощью тегов EMBED и OBJECT, хотя мультимедиа все равно может отображаться с помощью фильтра плагинов мультимедиа. Если вы хотите разрешить использовать эти теги, то включите эту опцию.';
$string['configallowoverride'] = 'Вы можете разрешить людям с ролями в левом столбце переопределять роли из некоторых столбцов';
$string['configallowoverride2'] = 'Для каждой роли в левом столбце выберите роли, для которых они могут устанавливать переопределения.<br />Пользователи также должны иметь право moodle/role:override либо moodle/role:safeoverride.';
$string['configallowswitch'] = 'Для каждой роли в левом столбце выберите роли, на которые они могут переключаться.<br />Пользователи также должны иметь право moodle/role:switchroles.';
$string['configallowthemechangeonurl'] = 'Если параметр включен, то тема может быть изменена путем добавления одного из вариантов:<br />?theme=themename в любой адрес Moodle  (например: mymoodlesite.com/?theme=afterburner ) или <br />&theme=themename в любой внутренний адрес Moodle (например: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Вы хотите позволить пользователям скрывать/отображать блоки на всем сайте? Эта особенности используется Javascript и cookies, для сохранения состояние каждого свернутого блока и затрагивает только собственное представление пользователя.';
$string['configallowusermailcharset'] = 'Включение этого параметра позволит каждому пользователю выбрать кодировку писем электронной почты в своих настройках сообщений.';
$string['configallowuserswitchrolestheycantassign'] = 'По умолчанию пользователям требуется возможность «moodle/role:assign» для переключения к ролям. Включение этого параметра отменяет это требование, в результате чего доступные роли в выпадающем меню «Переключиться к роли...» определяются только параметрами таблицы «Назначить разрешения ролей».
Рекомендуется, чтобы настройки таблицы «Назначить разрешения ролей» не позволяли пользователям перейти к роли с более широкими возможностями, чем у их имеющейся роли.';
$string['configallowuserthemes'] = 'Включение этого параметра разрешит пользователям устанавливать собственные темы. Пользовательские темы преобладают над темой сайта (но не над темой курса).';
$string['configallowview'] = 'Для каждой роли в левом столбце выберите роли, которые они могут использовать для просмотра, поиска и фильтра.';
$string['configallusersaresitestudents'] = 'Должны ли ВСЕ пользователи рассматриваться как студенты для элементов курса на главной странице сайта? Если Вы ответите «Да», то любому пользователю, подтвердившему учетную запись, будет разрешено участвовать в качестве студента в этих элементах. Если Вы ответите «Нет», то только пользователи, являющиеся участниками по меньшей мере одного курса смогут стать участниками этих элементов главной страницы. Только администраторы и специально назначенные преподаватели могут быть преподавателями для элементов курса главной страницы.';
$string['configauthenticationplugins'] = 'Выберите плагины аутентификации, которые Вы хотите использовать и упорядочите их в соответствие с очередностью проверки.';
$string['configautolang'] = 'Определять язык интерфейса из настроек браузера. Если параметр выключен, то используется язык по умолчанию для сайта.';
$string['configautolangusercreation'] = 'Если этот параметр включен, то при первом входе в систему с автоматическим созданием учетной записи пользователя  (например, с использованием аутентификации LDAP или OAuth 2), язык используемого браузера устанавливается в качестве предпочтительного языка пользователя. При отключенном параметре предпочтительным языком пользователя устанавливается язык по умолчанию для сайта.';
$string['configautologinguests'] = 'Должны ли посетители автоматически заходить в курс под учетной записью гостя, если гостевой доступ для курса разрешен?';
$string['configbloglevel'] = 'Этот параметр позволяет ограничить уровень доступности блогов на этом сайте. Обратите внимание, что он определяет права на ПРОСМОТР, а не на публикацию или использование разных типов записей. Также можно полностью отключить блоги.';
$string['configcalendarcustomexport'] = 'Разрешить экспортировать пользовательские настройки диапазона дат календаря';
$string['configcalendarexportsalt'] = 'Этот случайный текст применяется для того, чтобы улучшить безопасность «authentication tokens», используемых для экспорта календарей. Заметьте, что все текущие «authentication tokens» станут неработоспособными, если Вы измените эту последовательность.';
$string['configcookiesecure'] = 'Если сервер принимает только https-соединения, то рекомендуется включить установку поля «Secure» в cookies. Если параметр включен, то, пожалуйста, убедитесь, что веб-сервер не отвечает на запросы с http:// или установлено постоянное перенаправление на адрес с https:// и отправка заголовков HSTS. Если адрес <em>wwwroot</em> не начинается с https://, то параметр игнорируется.';
$string['configcountry'] = 'Если Вы укажете здесь страну, то эта страна будет выбрана по умолчанию для новых учетных записей. Чтобы заставить пользователя выбирать страну, оставьте поле пустым.';
$string['configcoursegraceperiodafter'] = 'Считать прошедшие курсы текущими в течение этих дней после даты окончания курса.';
$string['configcoursegraceperiodbefore'] = 'Считать будущие курсы текущими в течение этих дней до даты начала курса.';
$string['configcourseoverviewfilesext'] = 'Список допустимых расширений для файла изображения курса (перечислить через запятую).';
$string['configcourseoverviewfileslimit'] = 'Максимальное количество файлов, которое может отображаться рядом с описанием курса на странице списка курсов. Первый добавленный файл изображения используется в качестве изображения курса в обзоре курса на пользовательских инструментальных панелях; любые дополнительные файлы отображаются только на странице списка курсов.';
$string['configcourserequestnotify'] = 'Введите логин пользователя, оповещаемого о запросах на создание новых курсов.';
$string['configcourserequestnotify2'] = 'Пользователи, которые будут уведомлены при запросе на создание курса. Здесь перечислены только те пользователи, которые могут одобрить запрос на создание курса.';
$string['configcoursesperpage'] = 'Введите количество курсов, отображаемых на одной странице в списке курсов.';
$string['configcourseswithsummarieslimit'] = 'Если количество курсов в списке не превышает указанное, то будут отображаться описания курсов. При большем количестве курсов будет использоваться более простой формат списка без описаний.';
$string['configcronclionly'] = 'Запуск cron из веб-браузера может сделать доступной  конфиденциальную информацию анонимным пользователям. Рекомендуется запускать cron только из командной строки или задать пароль для удаленного доступа к cron.';
$string['configcronremotepassword'] = 'Установка этого параметра означает, что запускать cron через веб-интерфейс можно только указав в URL пароль следующим образом: <pre>http://site.example.com/admin/cron.php?password=пароль</pre> Если это поле оставить  пустым, пароль не потребуется.';
$string['configcurlcache'] = 'Время жизни кэша cURL, в секундах.';
$string['configcustommenuitems'] = 'Здесь можно настроить пользовательское меню. Введите каждый пункт меню с новой строки в формате: текст меню, URL-адрес ссылки (необязательно, не для верхнего пункта меню с подпунктами), заголовок всплывающей подсказки (необязательно) и код языка или список кодов, разделенных запятыми ( необязательно, для отображения строки только для пользователей указанного языка), разделенные вертикальной чертой. Строки, начинающиеся с дефиса, будут отображаться как подменю предыдущего элемента верхнего уровня, а символ ### образует разделитель. Например:
<pre>
Курсы
-Все курсы|/course/
-Поиск курса|/course/search.php
-###
-Часто задаваемые вопросы|https://example.org/faq
-Preguntas más frecuentes|https://example.org/pmf||es
Мобильное приложение|https://example.org/app|Скачать наше приложение
</pre>';
$string['configcustomusermenuitems'] = 'Вы можете настроить содержимое меню пользователя (за исключением ссылки «Выход», которая добавляется автоматически). Каждая строка разделяется символами | и состоит из: 1) строки в форме «идентификаторстроки, названиекомпонента» или обычного текста, 2) адреса URL. Также возможно создание разделительной линии путем добавления в нужном месте строки из одного или нескольких символов #.';
$string['configdbsessions'] = 'Если параметр включен, то для сохранения информации о текущих сеансах будет использоваться база данных. Внимание! Изменение этого свойства немедленно приведет к выходу из системы всех пользователей (включая и Вас). Если Вы используете MySQL, то, пожалуйста, убедитесь, что значение параметра «max_allowed_packet» в my.cnf (или my.ini) не меньше 4M. Другие механизмы хранения информации о сеансах могут быть настроены непосредственно в файле config.php, информацию можно найти в файле config-dist.php. Этот параметр исчезнет, если Вы настроите механизм хранения информации о сеансах в файле config.php.';
$string['configdebug'] = 'Если Вы включите эту опцию, сообщения об ошибках и предупреждениях PHP будут выводиться на экран чаще.<br />(Полезно только для разработчиков).';
$string['configdebugdisplay'] = 'Если выбрано «Да», то сообщения об ошибках будут отображаться на странице HTML. Это полезно, но обычно портит XHTML, JS, cookies и заголовки HTTP. Если выбрано «Нет» - ошибки будут регистрироваться в файлах «error_log» сервера, что может улучшить процесс отладки. Параметр PHP «error_log» указывает, где именно они будут фиксироваться.';
$string['configdebugpageinfo'] = 'Включите этот параметр, чтобы в нижнем колонтитуле отображалась информация о странице.';
$string['configdebugvalidators'] = 'Включите эту настройку, если хотите, чтобы в колонтитуле были ссылки на внешние серверы-валидаторы. Возможно, для этого Вам потребуется создать нового пользователя с логином <em>w3cvalidator</em> и разрешить ему гостевой доступ. Такие изменения могут повлечь несанкционированный доступ к серверу, не включайте на сайтах в промышленной эксплуатации!';
$string['configdefaulthomepage'] = 'На какую страницу следует перенаправлять пользователей после входа на сайт? Параметр также определяет первую ссылку в навигации для пользователей классических тем.';
$string['configdefaultrequestcategory'] = 'Курсы, созданные по запросу в контексте системы, будут автоматически помещаться в эту категорию, кроме случаев, когда пользователь может выбрать другую категорию .';
$string['configdefaultrequestedcategory'] = 'Категория по умолчанию, в которую будут помещены курсы, созданные по запросу.';
$string['configdefaultuserroleid'] = 'Все вошедшие в систему пользователи получат указанную роль в ДОПОЛНЕНИЕ ко всем другим ролям, которые у них есть. По умолчанию эта роль - «Аутентифицированный пользователь». Обратите внимание, что это не будет противоречить другим ролям (если в ролях не используются запреты), это только гарантирует, что все пользователи получат возможности, которые не присваиваются на уровне курсов (создавать записи в блогах, управлять собственным календарем, и т.д.).';
$string['configdeleteincompleteusers'] = 'По истечении этого времени все учетные записи без заполненных имени, фамилии или адреса электронной почты будут удалены.';
$string['configdeleteunconfirmed'] = 'Для некоторых методов аутентификации, например, самостоятельной регистрации по электронной почте, пользователи должны подтвердить свою учетную запись в течение указанного периода. По окончании этого периода все старые неподтвержденные учетные записи будут удалены.';
$string['configdenyemailaddresses'] = 'Чтобы запретить почтовые адреса с определенных доменов, перечислите их здесь через пробел. Все другие домены будут разрешены. Чтобы запретить все дочерние домены, начните название домена с точки (.), например, <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Запретить пользователям изменять изображения в своих профилях.';
$string['configdisplayloginfailures'] = 'Указанные пользователи будут видеть информацию о неудачных попытках входа в систему.';
$string['configdndallowtextandlinks'] = 'Включение или отключение возможности перетаскивать текст и ссылки на страницу курса, наряду с перетаскиванием файлов. Обратите внимание, что перетаскивание текста в Firefox или между разными браузерами ненадежно и может привести к незагрузке данных или повреждению загружаемого текста.';
$string['configdoclang'] = 'Этот язык будет использоваться в ссылках на страницы документации.';
$string['configdocroot'] = 'Определяет путь к контекстно-зависимой документации Moodle «Документация Moodle для этой страницы», расположенной в нижнем колонтитуле каждой страницы. Если поле оставлено пустым, то ссылки отображаться не будут.';
$string['configdoctonewwindow'] = 'Если Вы включите этот параметр, то ссылки на документацию Moodle будут открываться в новом окне.';
$string['configduration_high'] = 'Это значение слишком велико. Максимальное значение равно {$a}.';
$string['configduration_low'] = 'Это значение слишком мало. Минимальное значение равно {$a}.';
$string['configeditordictionary'] = 'Это значение будет использоваться, если в aspell нет словаря для языка пользователя.';
$string['configeditorfontlist'] = 'Выберите шрифты, которые должны отображаться в выпадающем списке редактора.';
$string['configemailchangeconfirmation'] = 'Требовать подтверждения электронной почты при смене пользователем адреса электронной почты в профиле.';
$string['configemaildkimselector'] = 'Селектор DKIM является произвольным, и ваша запись DNS должна ему соответствовать.';
$string['configemailfromvia'] = 'Добавлять адрес сайта в поле «От кого» исходящей почты. Это позволит проинформировать получателя о том, через какой сайт было отправлено сообщение. Также это помогает бороться с получателями почты, которые по ошибке отправляют ответы на адрес для писем, не требующих ответа.';
$string['configemailheaders'] = 'Необработанные заголовки электронной почты, добавляемые ко всем исходящим письмам.';
$string['configemailsubjectprefix'] = 'Текст, который должен стоять в начале темы всех исходящих писем.';
$string['configenableanalytics'] = 'Аналитические модели, такие как «Учащиеся с риском отчисления» или «Предстоящие мероприятия», могут генерировать прогнозы, отправлять аналитические уведомления и предлагать дальнейшие действия, такие как обмен сообщениями с пользователями.';
$string['configenableblogs'] = 'Позволяет всем пользователям сайта иметь на нем собственный блог.';
$string['configenablecalendarexport'] = 'Разрешить экспорт календарей и подписку на календари.';
$string['configenablecomments'] = 'Разрешить комментарии';
$string['configenablecourserequests'] = 'При включенном параметре пользователи с правом запроса новых курсов  (moodle/course:request) будут иметь возможность запросить курс. По умолчанию это право не дано ни одной из ролей. Может применяться в контексте системы или категории.';
$string['configenablemobilewebservice'] = 'Для приложения Moodle требуются мобильные веб-службы. При использовании сайтом HTTPS мобильные веб-службы включены по умолчанию. Для получения дополнительной информации см. {$a}.';
$string['configenablerssfeeds'] = 'При включенном параметре на всем сайте для различных элементов (блоги, форумы, базы данных, глоссарии) могут быть созданы RSS-ленты. Обратите внимание, что RSS-ленты также потребуется включить в настройках конкретных элементов кусров.';
$string['configenablerssfeedsdisabled'] = 'Это не поддерживается, потому что RSS-ленты отключены на всем сайте. Чтобы сделать их доступными, необходимо в режиме Управления изменить настройки.';
$string['configenablerssfeedsdisabled2'] = 'RSS-ленты в настоящий момент отключены на уровне сервера. Их можно включить в «Администрирование - Расширенные возможности - Включить RSS-ленты»';
$string['configenablestats'] = 'При включении этого параметра, служба cron в Moodle будет обрабатывать журнал системных событий и собирать некоторую статистику. В зависимости от нагрузки на Ваш сайт, для этого может потребоваться определенное время. Если Вы включите этот режим, то сможете посмотреть некоторые интересные графики и статистику по каждому из Ваших курсов, а также по всему сайту.';
$string['configenabletrusttext'] = 'По умолчанию система Moodle всегда тщательно очищает загружаемые пользователями тексты от любых потенциально-опасных скриптов и внедренных объектов. Включение доверенного содержимого дает возможность тем пользователям, которым Вы доверяете, защитить эти дополнительные функции своего содержимого от вмешательства. Для этого необходимо включить эту настройку, а затем разрешить возможность «Доверять содержимому» для соответствующей роли пользователя. Тексты, созданные и загруженные такими пользователями, будут помечены как доверенные и не будут очищаться в процессе вывода.';
$string['configenablewebservices'] = 'Веб-службы позволяют другим системам подключаться к Moodle и выполнять некоторые операции. Для повышения уровня безопасности эту функцию не следует включать, если вы не используете приложение или внешний инструмент / службу, требующие интеграции через веб-службы.';
$string['configenablewsdocumentation'] = 'Включить автоматическую генерацию документации для веб-служб. Пользователь может получить доступ к документации на странице «Ключи безопасности» {$a}. Там отображается документация только для включенных протоколов.';
$string['configerrorlevel'] = 'Выберите значимость отображаемых PHP предупреждений. Обычно лучше выбрать «Нормальный».';
$string['configexportlookahead'] = 'Сколько наступающих дней включать в экспорт';
$string['configexportlookback'] = 'Сколько прошедших дней включать в экспорт';
$string['configextendedusernamechars'] = 'При включенном параметре в логинах пользователей могут использоваться любые символы, кроме прописных букв. В противном случае разрешены только цифры, буквы в нижнем регистре, знак подчеркивания (_), дефис (-), точка (.) и символ @.';
$string['configextramemorylimit'] = 'Некоторые скрипты, такие как поиск, резервное копирование/восстановление или cron требуют большего количества памяти. Чем больше размер сайта, тем большее значение следует устанавливать.';
$string['configfilterall'] = 'Фильтрация всех строк, включая заголовки, названия, панель навигации и т.д. Это большей частью полезно при использовании фильтра многоязыкового содержимого, иначе просто возникнет дополнительная нагрузка на Ваш сайт без какой либо выгоды.';
$string['configfiltermatchoneperpage'] = 'Фильтры автосвязывания будут создавать на странице только по одной ссылке в месте первого совпадения с образцом текста. Все остальные совпадения будут пропущены.';
$string['configfiltermatchonepertext'] = 'Фильтры автосвязывания будут создавать в каждом текстовом элементе страницы (например, ресурсе или блоке) только по одной ссылке в месте первого совпадения с образцом текста. Все остальные совпадения будут пропущены. Этот параметр игнорируется, если <i>включен</i> параметр «Фильтр работает до первого совпадения на странице».';
$string['configfilternavigationwithsystemcontext'] = 'Обычно использование фильтров привязано к контексту, в котором они используются (например, контекст курса), но для навигации по сайту при использовании всех фильтров в контексте сайта можно повысить производительность применяя фильтр «контент и заголовки».';
$string['configfilteruploadedfiles'] = 'Обрабатывать ли фильтрами перед выводом на экран - все загруженные HTML и текстовые файлы, только загруженные HTML-файлы или вообще ничего не обрабатывать.';
$string['configforcelogin'] = 'Обычно главная страница сайта и список курсов (но не сами курсы) доступны до входа пользователя в систему. Если Вы хотите заставить пользователей входить в систему, прежде чем совершить ЛЮБОЕ действие, включите этот параметр.';
$string['configforceloginforprofiles'] = 'При включенном параметре пользователи должны будут зайти под реальной учетной записью (а не гостем), чтобы просмотреть профиль любого пользователя. Если отключить этот параметр, то может оказаться, что опубликованные некоторыми пользователями в своих профилях реклама (спам) или другое нежелательное содержимое будут доступны всему миру.';
$string['configfrontpage'] = 'Выбранные выше элементы будут отображаться на главной странице сайта.';
$string['configfrontpagecourselimit'] = 'Максимальное количество курсов';
$string['configfrontpagecourselimithelp'] = 'Максимальное количество курсов, отображаемых в списке курсов на главной странице сайта.';
$string['configfrontpageloggedin'] = 'Выбранные выше элементы будут отображаться на главной странице сайта после входа пользователя в систему.';
$string['configfullnamedisplay'] = 'Этот параметр определяет как будет выглядеть полное имя пользователя. При выборе значения по умолчанию «language», формат полного имени пользователя будет определяться значением строки «fullnamedisplay» текущего языкового пакета. В разных языках есть разные соглашения о формате полного имени.

Для большинства сайтов на одном языке лучше всего подойдет значение «firstname lastname» (Имя Фамилия), но можно, например, вообще скрыть фамилии. Подстановки, которые можно использовать в этом поле: firstname - имя, lastname - фамилия, middlename - отчество, alternatename - альтернативное имя, firstnamephonetic - фонетическая запись имени, lastnamephonetic - фонетическая запись фамилии.';
$string['configgeoipfile'] = 'Расположение двоичного файла данных GeoIP City. Этот файл не распространяется вместе с Moodle и должен быть получен отдельно, от <a href="https://www.maxmind.com/"> MaxMind</a>. Вы можете купить коммерческую версию или использовать бесплатную.
Вам необходимо зарегистрироваться, чтобы загрузить файл базы данных городов, что можно сделать на странице  <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. После регистрации и загрузки файла распакуйте его в каталог «{$a}» своего сервера.';
$string['configgetremoteaddrconf'] = 'Если Ваш сервер находится за реверсивным прокси-сервером, этот параметр указывает, какой именно из заголовков HTTP содержит IP-адрес удаленного компьютера. Заголовки просматриваются в указанном порядке, используется первый доступный.';
$string['configgradebookroles'] = 'Этот параметр позволяет Вам выбрать тех, кто будет отображаться в журнале оценок. В журнале будут отображаться пользователи, которым назначена хотя бы одна из этих ролей.';
$string['configgradeexport'] = 'Выберите основные форматы экспорта оценок из журнала. Указанные плагины будут использовать и изменять поле «last exported» каждой оценки. В результате этого при экспорте некоторые оценки могут быть отмечены как новые, а некоторые как обновленные. Если Вы не знаете, о чём идет речь, то ничего не отмечайте.';
$string['configgradeexportdefault'] = 'Выберите, какой формат экспорта журнала оценок используется по умолчанию.';
$string['confighiddenuserfields'] = 'Выберите, какие поля профиля пользователя должны быть доступны только учителям и администраторам. Это повысит конфиденциальность информации о студентах. Для выбора нескольких полей удерживайте клавишу CTRL.';
$string['configidnumber'] = 'Этот параметр определяет варианты: (a)- Не просить пользователей вводить ID-номер; (b)- Пользователя просят ввести ID, но он может оставить это поле пустым; (c)- Пользователя просят ввести ID и он должен его ввести. Если ID указан, то он отображается в профиле пользователя.';
$string['configintro'] = 'На этой странице можно настроить большое число параметров конфигурации, чтобы Ваша система Moodle работала должным образом. Не беспокойтесь, настройки по умолчанию подходят в большинстве случаев. Вы всегда сможете вернуться на эту страницу позже и изменить эти параметры.';
$string['configintroadmin'] = 'На этой странице Вам необходимо настроить учетную запись основного администратора, имеющего полный контроль над сайтом. Убедитесь, что Вы указали безопасный логин и пароль, а также корректный адрес электронной почты. Позже Вы сможете добавить других администраторов.';
$string['configintrosite'] = 'На этой странице Вы можете настроить внешний вид главной страницы и указать название своего сайта. Вы всегда сможете вернуться на эту страницу через меню «Администрирование».';
$string['configiplookup'] = 'Когда Вы нажимаете на IP-адрес (типа 34.12.222.93), например, в отчетах - Вам показывают карту с предположением того места, где этот IP расположен. Есть другие аналогичные программы, у всех свои достоинства и недостатки.';
$string['configkeeptagnamecase'] = 'Поставьте отметку, если Вы хотите, чтобы регистр символов сохранялся в тегах в том виде, в как они был введены создавшим их пользователем.';
$string['configlang'] = 'Выберите язык по умолчанию для всего сайта. Пользователи могут переопределить это значение с помощью меню выбора языка или соответствующего параметра в профиле.';
$string['configlanglist'] = 'Если оставить это поле пустым, все языки, установленные на сайте, будут отображаться в языковом меню. Можно сократить этот список, перечислив через запятую коды нужных языков, например, так: «ru,uk,en».
При желании для языка можно указать другое имя, нежели название языкового пакета, используя формат: код языка|название языка, например: en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Выберите, нужно ли отображать меню выбора языка на главной странице, странице входа в систему и т.п. Этот параметр не влияет на возможность выбора предпочитаемого языка в профиле пользователя.';
$string['configlangstringcache'] = 'При кэшировании все строки языкового пакета буду компилироваться в файлы в каталоге данных. Если Вы занимаетесь переводом Moodle или правите исходный код системы, то можете отключить эту настройку. В остальных случаях параметр лучше оставить включенным для повышения производительности.';
$string['configlatinexcelexport'] = 'Выберите кодировку для экспорта в Excel.';
$string['configlocale'] = 'Выберите локаль (набор региональных параметров) для всего сайта - это значение будет преобладать над настройками языка и форматом дат из языковых пакетов (кроме названий дней недели в календаре). Данные соответствующей локали должны быть установлены в операционной системе (например, en_US.UTF-8 или es_ES.UTF-8 в Linux). В большинстве случаев это поле следует оставить пустым.';
$string['configlockrequestcategory'] = 'При включенном параметре пользователи с правом запроса новых курсов в контексте системы не смогут выбрать категорию при запросе нового курса. Альтернативный способ ограничить запросы  пользователей на новые курсы только в одной категории - использовать возможность запрашивать новые курсы в контексте категории.';
$string['configloglifetime'] = 'Этот параметр определяет срок хранения записей о действиях пользователей в журнале событий. Более старые записи будут автоматически удаляться. Лучше всего, на всякий случай, сохранять записи как можно дольше. Но если у Вас очень загруженный сервер и есть проблемы с производительностью, можно уменьшить время хранения записей в журнале событий. Не рекомендуется устанавливать значения меньше 30, так как в этом случае может неправильно работать статистика.';
$string['configlookahead'] = 'Интервал отображения предстоящих событий';
$string['configmailnewline'] = 'Символы перевода строки, используемые в почтовых сообщениях. CRLF требуется в соответствии с RFC 822bis; некоторые почтовые серверы автоматически конвертируют LF в CRLF; другие почтовые сервера некорректно конвертируют CRLF в CRCRLF, а иные отвергают сообщения с простым LF (например, qmail). Попробуйте изменить этот параметр, если у Вас возникают проблемы с  доставкой почты или с сообщениями с двумя пустыми строками подряд.';
$string['configmaxbytes'] = 'Этот параметр ограничивает максимальный размер файлов, загружаемых на сайт. Этот параметр ограничен следующими настройками: в PHP - post_max_size и upload_max_filesize, в Apache - LimitRequestBody. В свою очередь, максимальный размер загружаемых файлов может быть ограничен на уровне курса или на уровне элемента. В случае, если будет выбрано значение «Ограничение сервера», то будет использоваться разрешенный сервером максимум.';
$string['configmaxconsecutiveidentchars'] = 'В пароле не должно встречаться больше этого числа последовательных одинаковых символов. Чтобы отключить такую проверку, введите 0.';
$string['configmaxeditingtime'] = 'Этот параметр определяет время, в течение которого пользователь может изменить свои сообщения на форуме, записи в глоссарии и т.п. Обычно используется значение 30 мин.';
$string['configmaxevents'] = 'Число предстоящих событий';
$string['configmaxusersperpage'] = 'Максимальное число пользователей, которые отображаются при выборе пользователем курса, группы, глобальной группы, веб-службы и т.д.';
$string['configmessaging'] = 'Если этот параметр включен, пользователи могут отправлять сообщения другим пользователям сайта.';
$string['configmessagingallowemailoverride'] = 'Разрешить пользователям получать сообщения по электронной почте на адрес, отличный от адреса электронной почты в их профиле';
$string['configmessagingallusers'] = 'Если этот параметр включен, пользователи могут просматривать список всех пользователей на сайте, когда выбирают кого-либо для отправки сообщений, и их настройки включают возможность принимать сообщения от всех, кто находится на сайте. Если этот параметр отключен, пользователи могут просматривать только список пользователей в своих курсах, и у них есть только два варианта в настройках сообщений - принимать сообщения только от своих контактов или от своих контактов и всех участников своих курсов.';
$string['configmessagingdefaultpressenter'] = 'Включен ли по умолчанию параметр «Использовать Enter для отправки»  в настройках обмена сообщениями.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Прочитанные и непрочитанные уведомления могут быть удалены для экономии места. Через какое время после создания уведомления его можно удалить?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Можно удалять прочитанные уведомления для экономии места. Через какое время после получения уведомления, оно может быть удалено?';
$string['configminpassworddigits'] = 'В пароле должно быть как минимум столько цифр.';
$string['configminpasswordlength'] = 'Пароль должен состоять по меньшей мере из такого числа символов.';
$string['configminpasswordlower'] = 'В пароле должно быть как минимум столько букв в нижнем регистре.';
$string['configminpasswordnonalphanum'] = 'В пароле должно встречаться как минимум столько символов, не являющихся буквами и цифрами.';
$string['configminpasswordupper'] = 'В пароле должно быть как минимум столько букв в верхнем регистре.';
$string['configmypagelocked'] = 'Этот параметр по умолчанию предотвращает редактирование страницы всеми, кроме администраторов';
$string['confignavcourselimit'] = 'Этот параметр ограничивает количество курсов, отображаемое пользователю в навигации.';
$string['confignavshowallcourses'] = 'Этот параметр определяет, должны ли пользователи, записанные на какие-то курсы, видеть в блоке навигации кроме элемента «Мои курсы» (список тех курсов, на которые пользователь записан) еще и элемент «Курсы» (полный список курсов).';
$string['confignavshowcategories'] = 'Отображать категории курсов в блоках и панели навигации. Этот параметр не относится к курсам, на которые пользователь записан, эти курсы будут перечислены в пункте «Мои курсы» без разделения на категории.';
$string['confignoreplyaddress'] = 'Иногда сообщения электронной почты отсылаются без непосредственного участия пользователя (например, сообщения с форума). Указанный здесь адрес электронной почты будет использоваться в поле «От кого», в том случае, если получатели не должны иметь возможность ответить непосредственно пользователю (например, когда пользователь не хочет показывать свой адрес).';
$string['confignotifyloginfailures'] = 'Отправлять уведомления о неудачных попытках входа в систему следующим пользователям. Для корректной работы уведомления требуется, чтобы был включен внутренний (например, «Стандартный журнал») способ хранения журнала событий.';
$string['confignotifyloginthreshold'] = 'После какого числа неудачных попыток входа в систему одного пользователя или с одного IP-адреса требуется отправка уведомления? (В том случае, если включены уведомления о неудачных попытках входах в систему)';
$string['confignotloggedinroleid'] = 'Будет считаться, что всем не вошедшим в систему пользователям назначена эта роль в контексте всего сайта. В большинстве случаев подходит роль Гостя, но Вы можете создать роли с большим или меньшим числом прав. Для таких действий, как создание сообщений на форуме, всё равно требуется, чтобы пользователь вошел в систему.';
$string['configopentowebcrawlers'] = 'Если Вы включите этот параметр, то поисковая машина Google сможет входить на Ваш сайт под учетной записью гостя. Кроме того, люди, переходящие на этот сайт со страницы поиска Google, автоматически войдут в систему под гостевой учетной записью. Заметьте, что такой простой доступ возможен только к тем курсам, которые позволяют гостевой доступ.';
$string['configoverride'] = 'Значение определено в файле config.php';
$string['configpasswordpolicy'] = 'При включенном параметре сложность паролей пользователей будет проверяться по политике паролей; её настройки указаны ниже. Включение политики паролей не повлияет на существующих пользователей, пока они не попробуют изменить свой пароль или пока не будет включен параметр «Изменить пароль при входе».';
$string['configpasswordpolicycheckonlogin'] = 'Если этот параметр включен, пароли пользователей будут проверяться в соответствии с политикой паролей каждый раз, когда пользователи входят в систему. Если проверка не удалась, пользователь должен будет изменить свой пароль, прежде чем продолжить.
Полезно включить этот параметр после обновления политики паролей.';
$string['configpasswordresettime'] = 'Этот параметр задает время, в течение которого необходимо подтвердить запрос на сброс пароля. Обычно используется 30 минут.';
$string['configpathtodu'] = 'Путь к утилите du. Обычно это /usr/bin/du. При использовании этой утилиты страницы, отображающие содержимое папок будут работать значительно быстрее, особенно для папок с большим числом файлов.';
$string['configpathtophp'] = 'Путь к PHP CLI. Вероятно, что-то вроде /usr/bin/php. Если вы введете путь, сценарии cron смогут выполняться администратором из веб-интерфейса.';
$string['configperfdebug'] = 'При включении этого параметра в нижнем колонтитуле стандартной темы будет выводиться информация о производительности.';
$string['configprofileroles'] = 'Список ролей, которые отображаются в профилях пользователей и на странице участников курса.';
$string['configprofilesforenrolledusersonly'] = 'Для предотвращения злоупотребления спамерами описания профилей скрыты для пользователей, которые еще не записаны ни на один курс. Новые пользователи должны записаться хотя бы на один курс, прежде чем смогут заполнить в профиле поле «Описание».';
$string['configprotectusernames'] = 'При включенном параметре форма восстановления пароля не будет отображать никаких подсказок, которые позволили бы угадать логины или адреса электронной почты учетных записей.';
$string['configproxybypass'] = 'Список имен узлов сети и IP-адресов (или их частей) для доступа к которым не нужен прокси-сервер. Разделяйте каждый элемент запятыми, без пробелов. Например: 192.168.0.0/16,*.mydomain.com.';
$string['configproxyfixunsafe_help'] = 'Это попытка исправить внутренние вызовы, которые не проходят через прокси, путем добавления агента пользователя MoodleBot и использования прокси.';
$string['configproxyhost'] = 'Если этот <b>сервер</b> подключается к Интернету через прокси-сервер, то укажите здесь прокси-сервер и порт. В противном случае оставьте поле пустым.';
$string['configproxylogunsafe_help'] = 'Это попытка использовать внутренние вызовы, которые не проходят через прокси, а должны.';
$string['configproxypassword'] = 'Если для доступа в Интернет через прокси-сервер необходим пароль, укажите его здесь, иначе оставьте поле пустым (требуется расширение PHP cURL).';
$string['configproxyport'] = 'Если этот сервер подключается к интернету через прокси, то укажите здесь его порт прокси-сервера.';
$string['configproxytype'] = 'Тип веб-прокси (для поддержки SOCKS5 требуется PHP5 и расширение cURL).';
$string['configproxyuser'] = 'Если для доступа в Интернет через прокси-сервер необходимо указать логин пользователя, то укажите его здесь, иначе оставьте поле пустым (требуется расширение PHP cURL).';
$string['configrecaptchaprivatekey'] = 'Строка символов (секретный ключ), используемая для взаимодействия между вашим сервером Moodle и сервером recaptcha. Ключи ReCAPTCHA могут быть получены с сайта <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Строка символов (открытый ключ), используемая для отображения элемента reCAPTCHA в форме регистрации. Ключи ReCAPTCHA могут быть получены с сайта <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Слово для студента, используемое в запрашиваемых курсах.';
$string['configrequestedstudentsname'] = 'Слово для студентов, используемое в запрашиваемых курсах.';
$string['configrequestedteachername'] = 'Слово для преподавателя, используемое в запрашиваемых курсах.';
$string['configrequestedteachersname'] = 'Слово для преподавателей, используемое в запрашиваемых курсах.';
$string['configreverseproxyignore'] = 'Если ваш сервер находится за несколькими обратными прокси-серверами, которые добавляются в заголовок X-Forwarded-For, то вам нужно будет указать разделенный запятыми список IP-адресов или подсетей обратных прокси-серверов, которые будут игнорироваться, чтобы найти правильный IP-адрес пользователя.';
$string['configsectioninterface'] = 'Интерфейс';
$string['configsectionmail'] = 'Почта';
$string['configsectionmaintenance'] = 'Обслуживание';
$string['configsectionmisc'] = 'Разное';
$string['configsectionoperatingsystem'] = 'Операционная система';
$string['configsectionpermissions'] = 'Права';
$string['configsectionrequestedcourse'] = 'Запросы курса';
$string['configsectionsecurity'] = 'Безопасность';
$string['configsectionstats'] = 'Статистика';
$string['configsectionuser'] = 'Пользователь';
$string['configsecureforms'] = 'Система может использовать дополнительный уровень безопасности при получении данных из web через формы. Если опция включена, то переменная браузера HTTP_REFERER сверяется c текущим адресом формы. В очень немногих случаях это может вызвать проблемы, например, если пользователь использует систему сетевой защиты (например, Zonealarm) сконфигурированную таким образом, чтобы отделять HTTP_REFERER от трафика сети. Симптом - «прилипание» к форме. Если Ваши пользователи имеют проблемы при входе в систему, возможно, следует отключить этот параметр, хотя это может сделатьь ваш сайт более открытым для подбора пароля перебором. Если Вы сомневаетесь, то оставьте параметр включенным.';
$string['configservicespage'] = 'Введите URL-адрес страницы «Услуги и поддержка» или оставьте поле пустым, чтобы обеспечить ссылку на услуги Moodle на сайте moodle.com. Ссылка отображается только администраторам сайта.';
$string['configsessioncookie'] = 'Этот параметр позволяет изменить имя cookie, используемого в Moodle для работы с сеансами. Это необязательный параметр, он нужен только, чтобы не возникало путаницы, когда на одном сайте используется несколько копий Moodle.';
$string['configsessioncookiedomain'] = 'Этот параметр позволяет изменить домен из которого принимаются cookies Moodle. Это необходимо при совместном использовании системой Moodle и веб-приложением из другого субдомена информации о сеансах (при использовании некоторых плагинов аутентификации и записи на курсы). <strong> ВНИМАНИЕ: настоятельно не рекомендуется менять значение по умолчанию (пустое) - установка неправильного значения заблокирует все возможности для входа на сайт.</strong>';
$string['configsessioncookiepath'] = 'Если Вам необходимо изменить путь, по которому браузеры будут посылать cookies для Moodle, то укажите здесь соответствующий каталог Вашего сайта. В остальных случаях лучше оставить путь по умолчанию - «/».';
$string['configsessiontimeout'] = 'Если пользователь зашел на сайт и ничего не делает в течении длительного времени (не загружает страницы), то он автоматически выходит из системы (сеанс заканчивается). Эта переменная задает время, через которое это должно произойти.';
$string['configsessiontimeoutwarning'] = 'Если пользователи, вошедшие на этот сайт, долгое время простаивают (без загрузки страниц), то они получают предупреждение о том, что их сеанс скоро закончится. Эта переменная определяет продолжительность этого времени.';
$string['configsessiontimeoutwarningcheck'] = 'Предупреждение о тайм-ауте сеанса должно быть меньше времени тайм-аута сеанса';
$string['configshowcommentscount'] = 'Показывать количество комментариев, для этого требуется дополнительный запрос при отображении ссылки на комментарии.';
$string['configshowicalsource'] = 'Показать источник информации для событий импорта календаря';
$string['configshowsiteparticipantslist'] = 'Все эти студенты и преподаватели сайта будут внесены в список участников сайта. Кому будет разрешено видеть этот список участников сайта?';
$string['configsitedefaultlicense'] = 'Лицензия по умолчанию';
$string['configsitedefaultlicensehelp'] = 'Лицензия по умолчанию при публикации материалов на этом сайте';
$string['configsitemailcharset'] = 'Этот параметр определяет кодировку по умолчанию для всех писем, отправляемых с сайта.';
$string['configsitemaxcategorydepth'] = 'Максимум вложенных категорий';
$string['configsitemaxcategorydepthhelp'] = 'Задает максимальное количество развернутых вложенных категорий при отображении категорий или комбинированного списка.
Категории более низких уровней отображаются в виде ссылок и пользователь может развернуть их, используя AJAX.';
$string['configslasharguments'] = 'Так называемые «slash arguments» (использующие <em>PATH_INFO</em>) требуются для правильного отображения пакетов SCORM и ресурсов, содержащих несколько файлов. Если ваш веб-сервер не поддерживает «slash arguments» и Вы не можете их настроить, эта настройка может быть отключена, хотя это может привести к тому, что некоторые функции не будут работать.<br />Примечание: Использование «slash arguments» будет обязательным в будущих версиях Moodle.';
$string['configsmtpauthtype'] = 'Этот параметр задает тип аутентификации, который использует сервер SMTP.';
$string['configsmtphosts'] = 'Введите полное имя одного или нескольких SMTP-серверов, которые Moodle должен использовать для отправки электронной почты (например, «mail.a.com» или «mail.a.com;mail.b.com»).Чтобы указать нестандартный (любой кроме 25) порт, используйте синтаксис [сервер]:[порт] (например, «mail.a.com:587»). Для безопасного соединения порт 465 обычно используется с SSL, порт 587 - с TLS. При необходимости выберите ниже безопасный протокол. Если оставить поле пустым, то Moodle будет использовать метод отправки почты, установленный в настройках PHP.';
$string['configsmtpmaxbulk'] = 'Максимальное количество сообщений, посылаемых за один SMTP-сеанс. Группировка сообщений может ускорить отправку писем. При значениях меньше 2 каждое электронное сообщение будет отправляться отдельным SMTP-сеансом.';
$string['configsmtpoauthservice'] = 'Выберите службу OAuth 2, настроенную для связи с SMTP-сервером. Если служба еще не существует, вам нужно будет её создать. Обратите внимание, что вам необходимо установить тип аутентификации SMTP на XOAUTH2.';
$string['configsmtpsecure'] = 'Если SMTP-сервер требует защищенного соединения, то задайте соответствующий тип протокола.';
$string['configsmtpuser'] = 'Если Вы указали выше SMTP-сервер, и ему необходима аутентификация, то введите здесь имя пользователя и пароль.';
$string['configstartwday'] = 'Начало недели';
$string['configstatsfirstrun'] = 'Этим параметром определяется, за какой срок будут обработаны записи системного журнала для подсчета статистики при <b>первом</b> запуске cron. Если у Вас нагруженный сервер или используется совместный хостинг, возможно, не стоит устанавливать слишком большое значение, поскольку работа cron может быть продолжительной и использовать много ресурсов. (Обратите внимание, что для этого параметра 1 месяц = 28 дней. В генерируемых графиках и отчетах 1 месяц = 1 календарный месяц).';
$string['configstatsmaxruntime'] = 'Обработка статистики может быть весьма интенсивной. Используйте комбинацию этого и следующего полей, чтобы определить, когда запускать процесс и на какую продолжительность времени.';
$string['configstatsmaxruntime2'] = 'Обработка статистики довольно требовательна к ресурсам; задайте максимальное разрешенное время для сбора дневной статистики. Максимальное количество дней, обрабатываемых при одном запуске cron, равно 31.';
$string['configstatsmaxruntime3'] = 'Укажите ограничение времени подсчета статистики за один день, принимая во внимание, что расчет статистики может сильно нагружать сервер. Максимальное число дней, обрабатываемых за один запуск cron, может быть указано ниже.';
$string['configstatsruntimedays'] = 'Укажите ограничения числа дней, обрабатываемых при каждом запуске подсчета статистики. Когда статистика за все дни будет актуальной, будет обрабатываться по одному дню за раз. Поэтому установите это значение в зависимости от нагрузки на Ваш сервер. Уменьшите это значение, если необходимо сократить время работы процессов cron.';
$string['configstatsruntimestart'] = 'В какое время служба cron должна <b>начинать</b> обработку статистики? Если на одном сервере используется несколько сайтов Moodle, укажите для них разные значения.';
$string['configstatsuserthreshold'] = 'Этот параметр определяет минимальное число записанных на курс пользователей необходимое, чтобы курс был учтен при подсчете статистики.';
$string['configstrictformsrequired'] = 'При включенном параметре пользователи не смогут в обязательные поля форм вводить пробел или разрыв строки.';
$string['configstripalltitletags'] = 'Отключите этот параметр, чтобы разрешить использовать HTML-теги в названиях ресурсов и элементов курса.';
$string['configsupportavailability'] = 'Определяет, у кого есть доступ к контактам поддержки сайта из нижнего колонтитула.';
$string['configsupportemail'] = 'Если на этом сайте настроен SMTP, а страница техподдержки не настроена, на этот адрес электронной почты будут приходить сообщения, отправленные через форму поддержки. Если отправка не удалась, этот адрес электронной почты будет отображаться вошедшим в систему пользователям.';
$string['configsupportname'] = 'Имя лица или сторонней организации, предоставляющих поддержку через форму поддержки или страницу поддержки.';
$string['configsupportpage'] = 'Введите URL-адрес страницы техподдержки или оставьте поле пустым, чтобы перейти к контактной форме. Ссылка отображается в нижнем колонтитуле сайта.';
$string['configtempdatafoldercleanup'] = 'Удалить временные файлы старше выбранной даты из каталога данных';
$string['configthemedesignermode'] = 'Обычно для повышения производительности все изображения и таблицы стилей темы кэшируются в браузерах и на сервере в течение очень длительного времени. Если Вы занимаетесь дизайном тем или правкой исходного кода, то, вероятно, следует включить этот режим, чтобы не использовать версии из кэша. Предупреждение: от этого Ваш сайт станет работать медленнее для всех пользователей! Вместо этого можно вручную очистить кэш на странице выбора темы.';
$string['configthemelist'] = 'Чтобы разрешить использовать любую допустимую тему, оставьте это поле пустым. Если Вы хотите сократить список доступных тем, перечислите их здесь через запятую (Не используйте пробелы!).
Например, «standard,orangewhite».';
$string['configtimezone'] = 'Этот часовой пояс будет использоваться ПО УМОЛЧАНИЮ при отображении дат и времени, каждый пользователь сможет переопределить этот значение в своем профиле. Запуск задач cron и другие настройки сервера указываются в этом часовом поясе. Вы должны изменить значение, если оно показывается как «Неверный часовой пояс».';
$string['configuseblogassociations'] = 'Нужна ли пользователям возможность связывать записи блога с курсами и элементами курсов?';
$string['configusesitenameforsitepages'] = 'При включении этого параметра вместо строки «Страницы сайта» в навигации будет использоваться краткое название сайта';
$string['configusetags'] = 'Разрешить использование тегов (ключевых слов в блогах) на всем сайте?';
$string['configvariables'] = 'Настройка переменных';
$string['configverifychangedemail'] = 'Включить проверку по списку разрешенных и запрещенных доменов при изменении пользователем адреса электронной почты. Если отключить этот параметр, адреса будут проверяться только при создании новых учетных записей.';
$string['configvisiblecourses'] = 'Показывать курсы в скрытых категориях.';
$string['configwarning'] = 'Будьте осторожны, изменяя эти параметры - неверные значения могут вызывать ряд проблем.';
$string['configyuicomboloading'] = 'Эта параметр отвечает оптимизацию загрузки файлов библиотеки YUI. Для повышения производительности этот параметр стоит включить на сайтах в промышленной эксплуатации.';
$string['confirmation'] = 'Подтверждение';
$string['confirmationpending'] = 'Ожидается подтверждение';
$string['confirmcontextlock'] = 'Контекст «{$a->contextname}» в настоящее время не заморожен. Замораживание делает его доступным только для чтения и не позволяет пользователям вносить изменения. Вы уверены, что хотите продолжить?';
$string['confirmcontextunlock'] = 'Контекст «{$a->contextname}» в данный момент заморожен. Размораживание позволит пользователям вносить изменения. Вы уверены, что хотите продолжить?';
$string['confirmdeletecomments'] = 'Вы уверены в том, что собираетесь удалить выбранные комментарии?';
$string['confirmed'] = 'Подтверждено';
$string['contactsitesupport'] = 'Служба поддержки сайта';
$string['contenttypeuninstalling'] = 'Есть элементы ({$a->count}) , использующие {$a->type}. Они будут удалены. Вы уверены, что хотите продолжить?';
$string['contextlockappliestoadmin'] = 'Замораживание контекста относится к администраторам';
$string['contextlockappliestoadmin_desc'] = 'Если отключено, администраторы остаются с правами на запись в любых замороженных контекстах.';
$string['contextlocking'] = 'Замораживание контекста';
$string['contextlocking_desc'] = 'Этот параметр обеспечивает доступ только для чтения для выбранных категорий, курсов, элементов курса или блоков.';
$string['cookiesecure'] = 'Устанавливать поле «Secure»';
$string['country'] = 'Страна по умолчанию';
$string['course_customfield'] = 'Пользовательские поля курса';
$string['coursecolor'] = 'Цвет {$a}';
$string['coursecolorheading_desc'] = 'Любые курсы, для которых в настройках курса не установлено изображение курса, отображаются на странице «Мои курсы» с узорчатой карточкой курса. Цвета, используемые в узоре, могут быть указаны ниже.';
$string['coursecolorsettings'] = 'Цвета карты курса';
$string['coursecontact'] = 'Контакты курса';
$string['coursecontact_desc'] = 'Этот параметр позволяет Вам указать, кто должен отображаться в описании курса. В описании курса будут отображаться пользователи, которым назначена хотя бы одна из этих ролей.';
$string['coursecontactduplicates'] = 'Показать все контактные роли курса';
$string['coursecontactduplicates_desc'] = 'Если включено, пользователи с более чем одной из выбранных ролей контакта курса будут отображаться в описании курса с каждой из своих ролей. В противном случае они будут отображаться только с одной ролью (той, которая находится выше в разделе «Определить роли» в меню Администрирование).';
$string['coursecreationguide'] = 'URL-адрес руководства по созданию курса Moodle';
$string['coursecreationguide_help'] = 'Определяет путь к краткому руководству с короткими видеороликами и общими советами по созданию курсов. Ссылка на руководство отображается на странице Мои курсы, когда нет курсов для отображения. Ссылка отображается только пользователям, имеющим право создавать курсы.';
$string['coursegraceperiodafter'] = 'Льготный период для прошедших курсов';
$string['coursegraceperiodbefore'] = 'Льготный период для будущих курсов';
$string['courselistshortnames'] = 'Отображать краткие названия курсов';
$string['courselistshortnames_desc'] = 'При включенном параметре в списке курсов краткие названия курсов будут отображаться в дополнение к их полным названиям. При необходимости, расширенные имена курсов могут быть настроены редактированием строки «courseextendednamedisplay» с помощью функции настройки языка.';
$string['coursemgmt'] = 'Управление курсами и категориями';
$string['courseoverview'] = 'Обзор курсов';
$string['courserequestnotify'] = 'Кто уведомляется о запросе на создание курса';
$string['courserequestnotifyemail'] = 'Пользователь {$a->user} запросил(а) создание нового курса <a href="{$a->link}">{$a->link}</a>';
$string['courserequests'] = 'Запросы на создание курсов';
$string['courserequestspending'] = 'Ожидающие рассмотрения запросы на создание курсов';
$string['courses'] = 'Курсы';
$string['coursesperpage'] = 'Курсов на странице';
$string['courseswithsummarieslimit'] = 'Максимальное количество курсов с описанием';
$string['creatornewroleid'] = 'Роль создателя в новом курсе';
$string['creatornewroleid_help'] = 'Если у пользователя, создавшего курс, еще нет права на управление новым курсом, то он получит эту роль в рамках курса.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Включить cron';
$string['cron_enabled_desc'] = 'Обычно Cron должен быть включен, однако этот параметр позволяет временно отключить его, например, перед перезапуском сервера. Если этот параметр отключен, система не может запускать новые фоновые задачи. Обратите внимание, что cron не следует отключать надолго, так как это помешает работе важных функций.';
$string['cron_help'] = 'Выполнение скрипта обслуживания cron.php позволяет некоторым модулям Moodle выполнять задания по расписанию, например, рассылку копий новых сообщений форума. Запуск скрипта необходимо выполнять регулярно, желательно каждую минуту.';
$string['cron_keepalive'] = 'Время действия';
$string['cron_keepalive_desc'] = 'Количество времени, в течение которого необходимо продолжать опрос для дополнительных задач. Этот параметр обеспечивает постоянную работу cron. Если вы используете специализированные средства запуска задач, то следует установить это значение равным 0. В противном случае рекомендуется установить значение, близкое к вашему пределу параллелизма разовых задач. Следует избегать больших значений, максимальное значение составляет 15 минут.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Запуск cron только из командной строки';
$string['cronerrorclionly'] = 'Извините, доступ к этой странице через интернет заблокирован администратором.';
$string['cronerrorpassword'] = 'Извините, Вы указали неверный пароль для доступа к этой странице';
$string['croninfrequent'] = 'Между двумя последними запусками сценария обслуживания cron было {$a->actual}, а он должен выполняться каждые {$a->expected} Рекомендуется настроить его для более частого запуска.';
$string['cronremotepassword'] = 'Пароль cron для удаленного доступа';
$string['cronwarning'] = '<a href="{$a->url}">Скрипт admin/cron.php</a> не запускался {$a->actual}, а должен запускаться каждые {$a->expected}';
$string['cronwarningcli'] = 'Скрипт <code>admin/cron.php</code> не запускался {$a->actual}, а должен запускаться каждые {$a->expected}';
$string['cronwarningnever'] = 'Скрипт <code>admin/cli/cron.php</code> никогда не запускался, а должен запускаться каждую {$a->expected}';
$string['cronwarningneverweb'] = 'Скрипт <a href="{$a->url}">admin/cron.php</a> никогда не запускался, а должен запускаться каждую {$a->expected}';
$string['ctyperequired'] = 'Расширение PHP ctype теперь является обязательным для Moodle, оно позволяет повысить производительность сайта и обеспечить многоязыковую совместимость.';
$string['curlcache'] = 'Время жизни кэша cURL';
$string['curlrequired'] = 'Расширение PHP cURL необходимо системе Moodle для взаимодействия с внешними хранилищами.';
$string['curlsecurityallowedport'] = 'Список разрешенных портов cURL';
$string['curlsecurityallowedportsyntax'] = 'Список номеров портов, к которым может подключаться cURL. Допустимые значения - только целые числа. Каждая запись размещается на новой строке. Если оставить поле пустым, все порты разрешены. При задании почти во всех случаях необходимо указать как 443, так и 80 для подключения cURL к стандартным портам HTTPS и HTTP.';
$string['curlsecurityblockedhosts'] = 'Список заблокированных хостов cURL';
$string['curlsecurityblockedhostssyntax'] = 'Каждая запись размещается на новой строке. Допустимыми являются полные адреса IPv4 либо IPv6 (например, 192.168.10.1, 0: 0: 0: 0: 0: 0: 0: 1, :: 1, fe80: :), которые соответствуют одному хосту. Могут использоваться и CIDR (например, 231.54.211.0/20 или fe80 :: / 64) или диапазон IP-адресов (например, 231.3.56.10-20 или fe80 :: 1111-bbbb), где диапазон применяется к последней группе адреса. Допустимы и имена доменов (например, localhost или example.com) или подстановочные имена доменов (например, * .example.com или * .sub.example.com). Пустые строки не допускаются.';
$string['curlsecurityurlblocked'] = 'Этот URL заблокирован.';
$string['curltimeoutkbitrate'] = 'Скорость передачи данных при вычислении cURL необходимого времени (в килобитах в секунду)';
$string['curltimeoutkbitrate_help'] = 'Этот параметр используется для расчета соответствующих пауз во время длительных cURL-запросов. Как часть этого расчета выполняется запрос HTTP HEAD для определения размера контента. Значение 0 отключает выполнение этого запроса.';
$string['currenttheme'] = 'Текущая тема';
$string['customcheck'] = 'Другие проверки';
$string['custommenu'] = 'Настраиваемое меню';
$string['custommenuitems'] = 'Настраиваемые элементы меню';
$string['customusermenuitems'] = 'Настраиваемые элементы меню пользователя';
$string['datarootsecurityerror'] = '<p><strong>ВНИМАНИЕ! ОПАСНОСТЬ!</strong></p><p>Ваш каталог dataroot находится в неправильном месте и доступен через интернет. Это означает, что все личные файлы доступны для всего мира и некоторые из них могут быть использованы хакерами для получения несанкционированного административного доступа к сайту!</p>
<p>Вы <em>должны</em> переместить каталог dataroot ({$a}) в новое место, недоступное через интернет и соответствующим образом обновить значение параметра <code>$CFG->dataroot</code> в файле config.php.</p>';
$string['datarootsecuritywarning'] = 'Конфигурация Вашего сайта, возможно, не безопасна. Пожалуйста, убедитесь, что к каталогу dataroot ({$a}) нет прямого доступа через интернет.';
$string['dbprefixtoolong'] = 'Префикс базы данных вашего сайта ($CFG->prefix) слишком длинный ({$a->current} символов). Максимально допустимое количество символов – {$a->maximum}.';
$string['dbsessions'] = 'Хранить сеансы в базе данных';
$string['debug'] = 'Отладочные сообщения';
$string['debugall'] = 'ВСЕ: выводить все сообщения отладчика PHP';
$string['debugdeveloper'] = 'РАЗРАБОТЧИК: дополнительные сообщения отладчика Moodle для разработчиков';
$string['debugdisplay'] = 'Отображать отладочные сообщения';
$string['debugging'] = 'Отладка';
$string['debugminimal'] = 'МИНИМУМ: выводить только неустранимые ошибки';
$string['debugnone'] = 'НЕТ: не выводить никаких ошибок и предупреждений';
$string['debugnormal'] = 'СТАНДАРТНО: выводить ошибки, предупреждения и примечания';
$string['debugpageinfo'] = 'Показать информацию о странице';
$string['debugsqltrace'] = 'Показать трассировку стека SQL';
$string['debugsqltrace1'] = 'Показать только одну строку трассировки стека';
$string['debugsqltrace100'] = 'Показать полную трассировку стека';
$string['debugsqltrace2'] = 'Показать 2 строки трассировки стека';
$string['debugsqltrace_desc'] = 'При включенном параметре частичная или полная трассировка стека PHP добавляется в SQL как комментарий.';
$string['debugstringids'] = 'Выводить источник строк перевода';
$string['debugstringids_desc'] = 'Если параметр включен, отображаются компоненты и идентификаторы языковых строк при добавлении к URL страницы ?strings=1 или &strings=1.';
$string['debugtemplateinfo'] = 'Показать информацию о шаблоне';
$string['debugtemplateinfo_desc'] = 'При включенном параметре шаблоны, используемые для визуализации, отображаются в виде комментариев в HTML-коде страницы. После изменения настройки необходимо очистить кеши. Используйте только для временной отладки, так как это приводит к ошибкам проверки HTML и может нарушить работу скриптов некоторых страниц. Возможно и нарушение основных функции системы!';
$string['debugvalidators'] = 'Показать ссылки на валидатор';
$string['defaultcity'] = 'Город по умолчанию';
$string['defaultcity_help'] = 'Указанный здесь город будет указан по умолчанию при создании новых учетных записей пользователей.';
$string['defaultformatnotset'] = 'Ошибка в формате курса по умолчанию. Проверьте настройки сайта.';
$string['defaulthomepage'] = 'Стартовая страница для пользователей.';
$string['defaultrequestcategory'] = 'Категория по умолчанию для запрашиваемых курсов';
$string['defaultsettinginfo'] = 'Значение по умолчанию: {$a}';
$string['defaultuserroleid'] = 'Роль по умолчанию для всех пользователей';
$string['deletedplugintypesdetected'] = 'Обнаружен удаленный плагин «{$a}». Его следовало перенести/удалить в период отмены поддержки. Теперь этот тип плагина не поддерживается и установка/обновление не могут быть продолжены, пока этот плагин не будет удален.';
$string['deleteduserx'] = 'Пользователь {$a} удален.';
$string['deleteincompleteusers'] = 'Удалять пользователей, не завершивших регистрацию через';
$string['deleteunconfirmed'] = 'Удалять неподтвержденных пользователей после';
$string['deleteuser'] = 'Удалить пользователя';
$string['density'] = 'Плотность';
$string['denyemailaddresses'] = 'Запрещенные почтовые домены';
$string['development'] = 'Разработка';
$string['devicetype'] = 'Тип устройства';
$string['devlibdirpresent'] = 'На доступных через интернет сайтах не должно быть каталогов с библиотеками для разработки, особенно <em>/vendor</em> и <em>/node_modules</em>. Подробнее смотрите в отчете <a href="{$a->moreinfourl}">Сведения о безопасности </a>.';
$string['disabled'] = 'Отключено';
$string['disableplugin'] = 'Отключить плагин {$a}';
$string['disableuserimages'] = 'Отключить изображения в профилях пользователей';
$string['displayerrorswarning'] = 'Включение настройки PHP <em>display_errors</em> не рекомендуется на сайтах в промышленной эксплуатации, потому что в некоторых сообщениях может оказаться закрытая информация о Вашем сервере.';
$string['displayloginfailures'] = 'Уведомлять об ошибках входа';
$string['divertallemails'] = 'Переадресация электронной почты';
$string['divertallemailsdetail'] = 'Применяется в средах разработки в качестве защиты при тестировании электронных писем, не использовать на рабочих сайтах.';
$string['divertallemailsexcept'] = 'Исключения переадресации электронной почты';
$string['divertallemailsexcept_desc'] = 'Список правил исключений электронной почты, разделенных запятыми или новыми строками. Каждое правило интерпретируется как регулярное выражение, например<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Перенаправлять все электронные письма';
$string['divertallemailsto_desc'] = 'При установленном параметре все электронные письма будут перенаправляться на этот адрес электронной почты.';
$string['dndallowtextandlinks'] = 'Перетаскивание загружаемого текста / ссылок';
$string['doclang'] = 'Язык документации';
$string['docroot'] = 'Адрес документации Moodle';
$string['doctonewwindow'] = 'Открыть в новом окне';
$string['doesnotfit'] = 'Внешний вид электронной почты';
$string['doesnotfitdetail'] = 'Настройки внешнего вида электронной почты, отправляемой из Moodle.';
$string['download'] = 'Скачать';
$string['downloadcoursecontentallowed'] = 'Разрешить скачивание содержимого курса';
$string['downloadcoursecontentallowed_desc'] = 'Доступна ли в курсах функция скачивания содержимого курса. Если доступна, то скачивание содержимого курса может быть включено/отключено с помощью параметра «Разрешить скачивание содержимого курса» в меню редактирования курса (значение по умолчанию для этого может быть установлено в <a href={$a} target="_blank"> Настройках курса по умолчанию</a>).';
$string['durationunits'] = 'единицы времени';
$string['edithelpdocs'] = 'Править файлы справки';
$string['editlang'] = '<b>Редактировать</b>';
$string['editorbackgroundcolor'] = 'Цвет фона';
$string['editordictionary'] = 'Словарь редактора';
$string['editorfontfamily'] = 'Семейство шрифтов';
$string['editorfontlist'] = 'Список шрифтов';
$string['editorfontsize'] = 'Размер шрифта';
$string['editorhidebuttons'] = 'Скрытые кнопки';
$string['editorkillword'] = 'Фильтр формата Word';
$string['editorspelling'] = 'Проверка правописания';
$string['editorspellinghelp'] = 'Включить или нет проверку правописания. Если включено, то <strong>aspell</strong> должен быть установлен на сервере.';
$string['editstrings'] = 'Редактирование слов и фраз';
$string['emailchangeconfirmation'] = 'Подтверждение изменения электронной почты';
$string['emaildkim'] = 'Подпись DomainKeys Identified Mail (DKIM) для эл.почты';
$string['emaildkiminfo'] = 'Если задан и селектор DKIM, и найден файл личного сертификата, который соответствует адресному домену «От» электронного письма $CFG->dataroot/dkim/[domain]/[selector].private, то электронное письмо будет подписано. В большинстве случаев (например, если параметр «Разрешенные почтовые домены» - allowedemaildomains не заполнен), требуется только сертификат в <pre>{$a->path}</pre>. Дополнительные сведения о настройке см. в документации <a href="{$a->docs}">Конфигурация почты</a>.';
$string['emaildkimselector'] = 'Селектор DKIM';
$string['emailfromvia'] = 'Информация о сайте, с которого отправлено сообщение';
$string['emailheaders'] = 'Заголовки электронного письма';
$string['emailsubjectprefix'] = 'Текст префикса темы электронного письма';
$string['emoticonalt'] = 'Альтернативный текст';
$string['emoticoncomponent'] = 'Компонент изображения смайлика';
$string['emoticonimagename'] = 'Имя изображения';
$string['emoticons'] = 'Смайлики';
$string['emoticons_desc'] = 'Эта форма определяет смайлики, используемые на вашем сайте. Чтобы удалить строку из таблицы, сохраните форму с пустым значением в любом из обязательных полей. Для регистрации новых смайликов, заполните поля в последней пустой строке. Для сброса всех полей в значения по умолчанию, перейдите по ссылке выше.

* Текст (обязательно) - этот текст будет заменен изображением смайлика. Он должен быть не менее двух символов.
* Имя изображения (обязательно) - имя файла изображения смайлика без расширения, относительно компонента папки pix.
* Компонент изображения (обязательно) - компонент, обеспечивающий значок.
* Альтернативный текст (не обязательно) - идентификатор строки и компонент альтернативного текста смайлика.';
$string['emoticonsreset'] = 'Сбросить настройки смайликов к значениям по умолчанию';
$string['emoticontext'] = 'Текст';
$string['emptysettingvalue'] = 'Не заполнено';
$string['enableanalytics'] = 'Аналитика';
$string['enableblogs'] = 'Разрешить блоги';
$string['enablecalendarexport'] = 'Разрешить экспорт календарей';
$string['enablecomments'] = 'Включить комментарии';
$string['enablecommunicationsubsystem'] = 'Разрешить общение через поставщиков услуг связи';
$string['enablecommunicationsubsystem_desc'] = 'Разрешить интеграцию с провайдерами общения, такими как Matrix, чтобы учителям и студентам было легче общаться. Управлять этими интеграциями можно в разделе <a href="settings.php?section=managecommunicationproviders">Плагины</a>.';
$string['enablecourserelativedates'] = 'Разрешить относительные даты курса';
$string['enablecourserelativedates_desc'] = 'Разрешить в курсах настройку отображения дат, относительно даты начала обучения пользователя в курсе.';
$string['enablecourserequests'] = 'Разрешить запросы на создание курса';
$string['enabled'] = 'Включено';
$string['enabledashboard'] = 'Включить личный кабинет';
$string['enabledashboard_help'] = 'По умолчанию в личном кабинете отображаются Шкала времени, Календарь и недавно просмотренные элементы. Вы можете установить по умолчанию для всех другую конфигурацию личного кабинета и позволить пользователям настраивать свою собственную конфигурацию. Если эта функция отключена, необходимо установить для параметра «Стартовая страница для пользователей» значение, отличное от «Личный кабинет».';
$string['enableglobalsearch'] = 'Включить глобальный поиск';
$string['enableglobalsearch_desc'] = 'При включенном параметре данные будут индексироваться и синхронизироваться с помощью запланированной задачи.';
$string['enablegravatar'] = 'Включить поддержку Gravatar';
$string['enablegravatar_help'] = 'При включении этого параметра Moodle будет пытаться использовать изображение пользователя с сервера Gravatar, если пользователь не загрузил свое изображение.';
$string['enablemobilewebservice'] = 'Включить веб-службы для мобильных устройств';
$string['enablepdfexportfont'] = 'Включить шрифты PDF';
$string['enablepdfexportfont_desc'] = 'Если на вашем сайте есть курсы на разных языках, которым нужны другие шрифты в сгенерированных файлах PDF, вы можете  в настройках курса предоставить возможность установить шрифт. Вам нужно указать доступные шрифты в $CFG->pdfexportfont в config.php.';
$string['enableplugin'] = 'Включить плагин {$a}';
$string['enablerecordcache'] = 'Включить кэш записей';
$string['enablerssfeeds'] = 'Включить RSS-ленты';
$string['enablesearchareas'] = 'Включить области поиска';
$string['enablesharingtomoodlenet'] = 'Разрешить обмен с MoodleNet (исходящий)';
$string['enablesharingtomoodlenet_desc'] = 'Разрешить пользователям делиться содержимым курса с настроенным экземпляром MoodleNet, если у них есть соответствующие возможности.';
$string['enablestats'] = 'Включить статистику';
$string['enabletrusttext'] = 'Включить возможность «Доверять содержимому».';
$string['enableuserfeedback'] = 'Включить сбор отзывов об этом программном обеспечении';
$string['enableuserfeedback_desc'] = 'Если эта функция включена, в нижнем колонтитуле будет отображаться ссылка «Оставить отзыв об этом программном обеспечении», чтобы пользователи могли отправить отзыв по поводу программного обеспечения Moodle в штаб-квартиру Moodle. Если включен параметр «Следующее напоминание про отзыв», пользователю через заданный интервал времени также будет отображаться напоминание в личном кабинете. Установка для параметра «Следующее напоминание про отзыв» значения «Никогда» отключает напоминание в личном кабинете, оставляя ссылку «Оставить отзыв об этом программном обеспечении» в нижнем колонтитуле.';
$string['enablewebservices'] = 'Включить веб-службы';
$string['enablewsdocumentation'] = 'Документация веб-служб';
$string['encryptedpassword_edit'] = 'Введите новое значение';
$string['encryptedpassword_set'] = '(Установлено и зашифровано)';
$string['enroladminnewcourse'] = 'Автоматически зачислять администратора в создаваемые курсы';
$string['enroladminnewcourse_help'] = 'При создании нового курса администратором нужно ли зачислять его в курс с ролью создателя?';
$string['enrolinstancedefaults'] = 'Параметры записи на курс по умолчанию';
$string['enrolinstancedefaults_desc'] = 'Настройки записи на курс по умолчанию для новых курсов.';
$string['enrolmultipleusers'] = 'Записать пользователей';
$string['ensureauroraversion'] = 'Ваш сайт использует базу данных Amazon Aurora. Убедитесь, что версия MySQL в Amazon Aurora совместима с версией Moodle, которую вы устанавливаете или обновляете. Вы можете проверить совместимость в <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraMySQLReleaseNotes/AuroraMySQL.Updates.30Updates.html" target="_blank">Обновлениях базы данных для Amazon Aurora MySQL версии 3</a>.';
$string['entitytasklog'] = 'Журнал задач';
$string['environment'] = 'Среда (версии ПО)';
$string['environmenterrortodo'] = 'Вам следует устранить указанные выше проблемы (ошибки), прежде чем начать установку этой версии Moodle!';
$string['environmenterrorupgrade'] = 'Предупреждение: Вам следует устранить все указанные выше проблемы (ошибки) перед обновлением версии Moodle! Обновление без учета этих требований может вызвать такие проблемы, как потеря данных. Вы уверены, что хотите продолжить обновление?';
$string['environmentmariadbwrongdbtype'] = 'Неправильный параметр $CFG->dbtype. В файле config.php измените его значение с «mysqli» на «mariadb».';
$string['environmentmustfixsetting'] = 'Необходимо изменить параметр PHP.';
$string['environmentok'] = 'Конфигурация сервера отвечает всем минимальным требованиям.';
$string['environmentrecommendcustomcheck'] = 'непрохождение данного теста указывает на возможную проблему';
$string['environmentrecommendinstall'] = 'рекомендуется установить и включить для наилучшей производительности';
$string['environmentrecommendversion'] = 'рекомендуемая версия {$a->needed}, у Вас используется версия {$a->current}';
$string['environmentrequirecustomcheck'] = 'этот тест должен быть пройден';
$string['environmentrequireinstall'] = 'необходимо установить и включить';
$string['environmentrequireversion'] = 'требуется версия {$a->needed}, у Вас используется версия {$a->current}';
$string['environmentsettingok'] = 'обнаружены рекомендуемые настройки ';
$string['environmentshouldfixcustomcheck'] = 'нужно включить для достижения наилучших результатов';
$string['environmentshouldfixsetting'] = 'следует изменить параметр PHP.';
$string['environmentxmlerror'] = 'Ошибка чтения данных о системе ({$a->error_code})';
$string['errordeletingconfig'] = 'Произошла ошибка при удалении записей конфигурации плагина «{$a}».';
$string['errorsetting'] = 'Невозможно сохранить настройку:';
$string['errorwithsettings'] = 'Некоторые настройки не были изменены из-за ошибки.';
$string['eventshandlersinuse'] = 'Следующие плагины, использующие события 1 интерфейса API, устарели: «{$a}». Пожалуйста, обновите их для использования событий 2 API-интерфейса. См https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Все, кто может {$a}';
$string['exceptions'] = 'исключения';
$string['execpathnotallowed'] = 'Настройка исполняемых и локальных путей отключена в config.php';
$string['experimental'] = 'Экспериментальные возможности';
$string['experimentalsettings'] = 'Экспериментальные настройки';
$string['extendedusernamechars'] = 'Разрешить в логинах дополнительные символы';
$string['extramemorylimit'] = 'Предел дополнительный памяти PHP';
$string['fatalsessionautostart'] = '<p>Обнаружены серьезные ошибки конфигурации, пожалуйста, сообщите администратору сервера.</p><p>Для нормальной работы Moodle требуется, чтобы администратор изменил настройки PHP.</p><p><code> session.auto_start</code> должно быть установлено в <code>off</code>.</p><p>Этот параметр управляется редактированием <code>php.ini</code>, конфигурации Apache/IIS <br /> или файла <code>.htaccess</code> на сервере.</p>';
$string['favicon'] = 'Фавикон';
$string['favicon_desc'] = 'Значок Фавикон отображается рядом с заголовком страницы во вкладке браузера.  Если пользовательский значок не задан, то отображается значок Moodle.';
$string['feedbacksettings'] = 'Настройки сбора отзывов';
$string['fileconversioncleanuptask'] = 'Очистка временных записей для преобразования файлов';
$string['filecreated'] = 'Создан новый файл';
$string['filescleanupperiod'] = 'Очищать корзину';
$string['filescleanupperiod_help'] = 'Как часто удаляются файлы из корзины. Это файлы, которые связаны с контекстом, который больше не существует, например, когда курс удален. Обратите внимание: этот параметр может привести к отсутствию файлов в курсе, для которого выполняется резервное копирование, удаление и последующее восстановление, если параметр «Включать файлы» (backup_auto_files) в «Настройках автоматического резервного копирования» отключен.';
$string['filesizeunits'] = 'единицы размера файла';
$string['filestoredin'] = 'Сохранить файл в папку:';
$string['filestoredinhelp'] = 'Где будет сохранен файл';
$string['filterall'] = 'Фильтровать все строки';
$string['filtermatchoneperpage'] = 'Фильтр работает до первого совпадения на странице';
$string['filtermatchonepertext'] = 'Фильтр работает до первого совпадения в каждом тексте';
$string['filternavigationwithsystemcontext'] = 'Фильтр навигации в контексте системы';
$string['filters'] = 'Фильтры';
$string['filtersettings'] = 'Управление фильтрами';
$string['filtersettingsgeneral'] = 'Основные настройки фильтра';
$string['filteruploadedfiles'] = 'Фильтрация загружаемых файлов';
$string['forceclean'] = 'Повсеместная очистка контента';
$string['forceclean_desc'] = 'Добавленный на сайт контент обычно очищается перед отображением , чтобы убрать всё, что может представлять угрозу безопасности. Однако, в определенных местах контент не очищается, например, в описаниях элементов, ресурсах «Страница» или блоках HTML, разрешая добавление скриптов, медиа, встроенных фреймов и т. д. Если этот параметр включен, ВЕСЬ контент будет очищаться. Это может привести к тому, что существующий контент будет отображаться некорректно.';
$string['forcelogin'] = 'Принуждать пользователей входить в систему';
$string['forceloginforprofileimage'] = 'Необходимо войти в систему для просмотра изображений других пользователей';
$string['forceloginforprofileimage_help'] = 'Если параметр включен, пользователи должны зайти в систему, чтобы просматривать изображения в профилях других пользователей, а изображение по умолчанию для пользователя будет использоваться во всех уведомлениях,  рассылаемых по электронной почте.';
$string['forceloginforprofiles'] = 'Необходимо войти в систему для просмотра профилей';
$string['forcetimezone'] = 'Принудительный часовой пояс';
$string['formatuninstallwithcourses'] = 'Формат «{$a->format}» используется в {$a->count} курсах(е). Их формат будет изменен на «{$a->defaultformat}» (формат по умолчанию для этого сайта). Некоторые специфичные для этого формата данные могут быть безвозвратно утеряны. Продолжить?';
$string['frontpage'] = 'Главная страница';
$string['frontpagebackup'] = 'Резервная копия главной страницы';
$string['frontpagedefaultrole'] = 'Роль по умолчанию для главной страницы';
$string['frontpagefilters'] = 'Фильтры главной страницы';
$string['frontpageloggedin'] = 'Элементы главной страницы после входа';
$string['frontpageoverrides'] = 'Переопределения разрешений для главной страницы';
$string['frontpagequestions'] = 'Вопросы главной страницы';
$string['frontpagerestore'] = 'Восстановление главной страницы';
$string['frontpageroles'] = 'Роли главной страницы';
$string['frontpagesettings'] = 'Настройки главной страницы';
$string['fullnamedisplay'] = 'Формат полного имени';
$string['fullnamedisplayprivate'] = 'Формат полного имени - личное';
$string['gdrequired'] = 'Расширение GD требуется Moodle для преобразования изображений.';
$string['generalsettings'] = 'Основные настройки
';
$string['geoipdbedition'] = 'Версия базы данных GeoIP';
$string['geoipdbedition_desc'] = 'Выберите версию базы данных GeoIP для загрузки. Обратите внимание, что для использования базы данных GeoIP2-City требуется действующая платная лицензия.';
$string['geoipfile'] = 'База данных GeoIP City';
$string['geoipmaxmindaccid'] = 'ID учетной записи MaxMind';
$string['geoipmaxmindaccid_desc'] = 'ID учетной записи, созданной в сервисе API MaxMind.';
$string['geoipmaxmindlicensekey'] = 'Лицензионный ключ MaxMind';
$string['geoipmaxmindlicensekey_desc'] = 'Лицензионный ключ учетной записи, созданной в сервисе API MaxMind.';
$string['geopluginapikey'] = 'Ключ API GeoPlugin';
$string['geopluginapikey_desc'] = 'Ключ API, используемый для доступа к сервису GeoPlugin. Получите свой собственный ключ на странице <a href="https://www.geoplugin.com/" target="_blank">geoplugin.com</a>.';
$string['getremoteaddrconf'] = 'Источник IP-адреса';
$string['globalsearch'] = 'Глобальный поиск';
$string['globalsearchmanage'] = 'Управление глобальным поиском';
$string['googlemapkey3'] = 'Ключ Google Maps API v3';
$string['googlemapkey3_help'] = 'Вам необходимо ввести специальный ключ, чтобы использовать Google Maps для визуализации положения IP-адреса. Вы можете бесплатно получить этот ключ по адресу <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Перейти к первой пропущенной строке';
$string['gradebook'] = 'Журнал оценок';
$string['gradebookroles'] = 'Оцениваемые роли';
$string['gradeexport'] = 'Основные форматы экспорта оценок';
$string['gradeexportdefault'] = 'Метод экспорта оценок по умолчанию';
$string['gravatardefaulturl'] = 'URL-адрес изображения по умолчанию для сервиса Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar необходимо изображение по умолчанию для отображения, если он не может найти изображение для данного пользователя. Укажите полный URL для изображения. Коды для создания изображений по умолчанию доступны на сайте <a href="https://docs.gravatar.com/api/avatars/images/">Gravatar для разработчиков - Запросы аватара</a>.';
$string['group_customfield'] = 'Настраиваемые поля группы';
$string['groupenrolmentkeypolicy'] = 'Применять политику для кодовых слов';
$string['groupenrolmentkeypolicy_desc'] = 'Если этот параметр включен, ключи регистрации групп будут сверяться с политикой паролей, указанной в параметрах выше.';
$string['grouping_customfield'] = 'Настраиваемые поля потока';
$string['guestroleid'] = 'Роль для гостя';
$string['guestroleid_help'] = 'Эта роль автоматически присваивается пользователю-гостю. Она также временно назначается не записанным на курс пользователям, которые входят в курс как гости.';
$string['h5pgetcontenttypestask'] = 'Загрузка доступных типов контента H5P с h5p.org';
$string['helpadminseesall'] = 'Должны ли администраторы видеть все события календарей всех курсов или только тех, участниками которых являются? Независимо от выбранного варианта, администраторы всегда смогут управлять событиями календаря любого курса, сначала переходя к курсу, а затем напрямую обращаясь к его календарю.';
$string['helpcalendarcustomexport'] = 'Разрешить экспортировать пользовательские настройки диапазона дат при экспорте календаря. Предварительно должен быть разрешен экспорт календаря.';
$string['helpexportlookahead'] = 'События скольких предстоящих дней можно внести в пользовательские настройки при экспорте календаря?';
$string['helpexportlookback'] = 'События скольких прошедших дней можно внести в пользовательские настройки при экспорте календаря?';
$string['helpforcetimezone'] = 'Вы можете разрешить пользователям выбирать часовой пояс индивидуально или принудительно установить всем часовой пояс по умолчанию.';
$string['helpshowicalsource'] = 'При включенном параметре для импортируемых событий календаря будут показаны название подписки и ссылка.';
$string['helpsitemaintenance'] = 'Для обновления и других работ по обслуживанию системы';
$string['helpstartofweek'] = 'С какого дня начинается неделя в календаре?';
$string['helpupcominglookahead'] = 'На сколько дней вперед, по умолчанию, нужно выводить предстоящие события?';
$string['helpupcomingmaxevents'] = 'Какое максимальное число предстоящих событий, по умолчанию, следует показывать пользователям?';
$string['helpweekenddays'] = 'Какие дни недели считаются выходными и отображаются другим цветом?';
$string['hiddenuserfields'] = 'Скрыть поля пользователя';
$string['hidefromall'] = 'Скрыть от всех пользователей';
$string['hidefromnone'] = 'Ни от кого не скрывать';
$string['hidefromstudents'] = 'Скрыть от студентов';
$string['hookcallbacknotcallable'] = 'Этот обратный вызов не может быть вызван. Это может быть связано с тем, что класс или метод не существует, или метод не является общедоступным.';
$string['hookcallbacks'] = 'Обратные вызовы';
$string['hookcallbacks_help'] = 'Список обратных вызовов, которые будут вызываться при отправке хука.

Показанный порядок — это порядок, в котором вызываются обратные вызовы.

Обратный вызов с более высоким приоритетом будет вызван до вызова с более низким приоритетом.';
$string['hookclassmissing'] = 'Класс хука не найден';
$string['hookclassmissing_desc'] = 'Агент обнаружения хуков вернул несуществующий класс.';
$string['hookconfigoverride'] = 'Переопределено';
$string['hookconfigoverride_help'] = 'Определение этого обратного вызова было переопределено в файле конфигурации сайта config.php.';
$string['hookdeprecates'] = 'Устаревшие обратные вызовы';
$string['hookdescription'] = 'Описание';
$string['hookdescriptionmissing'] = 'У хука нет описания.';
$string['hookname'] = 'Хук';
$string['hooksoverview'] = 'Обзор хуков';
$string['hookunknown'] = 'Хук не найден';
$string['hookunknown_desc'] = 'Объект, который слушает этот обратный вызов, недоступен. Он мог быть удален или переименован; возможно, он недоступен в этой версии Moodle.';
$string['hostname'] = 'Имя хоста';
$string['htmleditor'] = 'редактор HTML';
$string['htmleditorsettings'] = 'Настройки редактора HTML';
$string['htmlsettings'] = 'Настройки HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Безопасность HTTP';
$string['iconvrequired'] = 'Установка расширения ICONV обязательна.';
$string['igbinary322buggyversion'] = 'Установленное на сайте расширение php-igbinary может привести к проблемам при работе с PHP 7.2. Рекомендуется либо обновить php-igbinary до версии 3.2.5 или новее, либо, в качестве альтернативы, обновить PHP до 7.3 или новее.';
$string['ignore'] = 'Игнорировать';
$string['importantupdates_content'] = '<p>В Moodle 5.0 элементы «Чат» и «Анкета» удалены из ядра Moodle. Они доступны как плагины в
<a href="https://moodle.org/plugins/">каталоге плагинов Moodle</a>.</p>
<p>При желании продолжить использовать «Чат» или «Анкету» на своем сайте вы можете установить их как плагины при обновлении до Moodle 5.0.</p>';
$string['importantupdates_title'] = 'Важное обновление о Чате и Анкете';
$string['includemoduleuserdata'] = 'Включать данные пользователей';
$string['incompatibleblocks'] = 'Несовместимые блоки';
$string['incompleteunicodesupport'] = 'Текущая настройка MySQL или MariaDB использует «utf8». Этот набор символов не поддерживает четырехбайтные символы, которые используют некоторые смайлики. Попытка использования этих символов приведет к ошибке при обновлении записи, и любая информация, отправляемая в базу данных, будет потеряна. Пожалуйста, подумайте о том, чтобы изменить настройки на «utf8mb4». Подробную информацию см. в документации.';
$string['indexdata'] = 'Данные индекса';
$string['indexinginfo'] = 'Рекомендуемый способ индексирования содержимого вашего сайта - использовать запланированную задачу «Индексирование глобального поиска»';
$string['installhijacked'] = 'Извините, но установка должна быть завершена с первоначального IP-адреса.';
$string['installsessionerror'] = 'Не удается инициализировать сеанс PHP. Убедитесь, что Ваш браузер принимает cookies.';
$string['intlrecommended'] = 'Расширение Intl используется для улучшения интернациональной поддержки, такой как сортировка с учетом региональных особенностей.';
$string['intlrequired'] = 'Для улучшения поддержки интернационализации, например, сортировка по локали и международные доменные имена. требуется международное обозначение страны.';
$string['invalidagedigitalconsent'] = 'Некорректный возраст цифровой дееспособности: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL-адрес для восстановления забытого пароля не является допустимым адресом.';
$string['invalidsection'] = 'Некорректный раздел.';
$string['invalidthemepreset'] = 'Выбранный файл заготовок не совместим с этой темой. Ошибка компиляции SCSS: «{$a}»';
$string['invaliduserchangeme'] = 'Логин «changeme» зарезервирован - его нельзя использовать для создания учетной записи.';
$string['ipblocked'] = 'В настоящее время этот сайт не доступен.';
$string['ipblocker'] = 'Блокировка IP-адресов';
$string['ipblockersyntax'] = 'Разместите каждую запись на отдельной строке. Допустимые значения: полный IP-адрес (например, <b>192.168.10.1</b>), соответствующий одному узлу; неполный адрес (например, <b>192.168</b>), соответствующий любому адресу, начинающемуся с этих чисел; CIDR-обозначения (например, <b>231.54.211.0/20</b>); диапазон IP-адресов (например: <b>231.3.56.10-20</b>), где диапазон относится к последней части адреса. Текстовые доменные имена (например, «example.com») не поддерживаются. Игнорируются пустые строки и текст, следующий за символом «#».';
$string['iplookup'] = 'Местонахождение IP-адреса';
$string['iplookupgeoplugin'] = 'В настоящее время для поиска географической информации  используется служба <a href="https://www.geoplugin.com">geoPlugin</a>. Для получения более точных результатов рекомендуется установить локальную копию базы данных MaxMind GeoIP City.';
$string['iplookupinfo'] = 'Для поиска местоположений IP-адресов используется бесплатный онлайн-сервер NetGeo. Однако база данных больше не поддерживается и может выдавать неверные данные.Рекомендуется установить локальную копию базы данных GeoIP от MaxMind.<br />
При наличии ключа Google Maps API V3 местонахождение IP-адреса отображается с помощью Google Maps. Вам потребуется создать учетную запись Google и отправить запрос на бесплатный ключ API Google Maps.
Если ключ Google Maps API V3 отсутствует, местоположение IP-адреса отображается с помощью OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'В этой программе используется база данных GeoIP City компании MaxMind, доступная по адресу: <a href="https://www.maxmind.com/">http://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'Обнаружено, что ваш сайт использует настраиваемый административный каталог. Эта функция больше не поддерживается и будет удалена после Moodle 4.2.';
$string['ishttpswarning'] = 'Обнаружено, что ваш сайт не защищен с помощью HTTPS. Настоятельно рекомендуется перенести ваш сайт на HTTPS для повышения безопасности и улучшения интеграции с другими системами.';
$string['keeptagnamecase'] = 'Сохранять регистр тегов';
$string['lang'] = 'Язык по умолчанию';
$string['langcache'] = 'Кэшировать список языков';
$string['langcache_desc'] = 'Кэшировать список языков. В случае, если параметр включен, список доступных языков интерфейса системы будет кэшироваться. Кэш будет автоматически обновляться при установке и удалении языковых пакетов через страницу импорта языковых пакетов. Если Вы устанавливаете языковой пакет вручную, вам потребуется использовать функцию «Очистить все кэши».';
$string['langlist'] = 'Языки в меню языков';
$string['langmenu'] = 'Отображать меню языков';
$string['langmenuinsecurelayout'] = 'Отображать языковое меню в защищенном режиме';
$string['langmenuinsecurelayout_desc'] = 'Если включено, пользователь сможет изменить язык во время прохождения теста или работы с другими элементами, использующими защищенный режим.';
$string['langpackwillbeupdated'] = 'ПРИМЕЧАНИЕ: при обновлении Moodle попытается загрузить обновления языковых пакетов.';
$string['langstringcache'] = 'Кэшировать все строки языкового пакета';
$string['languagesettings'] = 'Языковые настройки';
$string['latinexcelexport'] = 'Кодировка Excel';
$string['legacyfilesaddallowed'] = 'Разрешить добавление к устаревшим файлам курса';
$string['legacyfilesaddallowed_help'] = 'Если в курсе есть устаревшие файлы курса, разрешить новым файлам и папкам быть добавленными к ним.';
$string['legacyfilesinnewcourses'] = 'Устаревшее хранилище файлов в новых курсах';
$string['legacyfilesinnewcourses_help'] = 'По умолчанию устаревшее хранилище файлов курса сохранено только в тех курсах, которые были обновлены из прошлой версии Moodle. Обратите внимание, что резервное копирование/восстановление некоторых элементов курса не совместимо с этим параметром.';
$string['libcurlwarning'] = 'Обнаружено, что libcurl не поддерживает CURLOPT_PROTOCOL. Из соображений безопасности рекомендуется обновить libcurl.';
$string['licensesettings'] = 'Параметры лицензии';
$string['linkadmincategories'] = 'Категории администрирования в виде ссылок';
$string['linkadmincategories_help'] = 'При включенном параметре категории администрирования будут отображаться в навигации в виде ссылок, ведущих на страницы управления соответствующими категориями настроек.';
$string['loading'] = 'Загрузка';
$string['localetext'] = 'Локаль сайта';
$string['localstringcustomization'] = 'Локальное переопределение строк';
$string['location'] = 'Местонахождение';
$string['locationsettings'] = 'Настройки местонахождения';
$string['locked'] = 'Заблокировано';
$string['lockoutduration'] = 'Продолжительность блокировки учетной записи';
$string['lockoutduration_desc'] = 'Заблокированная учетная запись после этого срока автоматически разблокируется.';
$string['lockoutemailbody'] = 'Здравствуйте, {$a->firstname}!

Ваша учетная запись с логином «{$a->username}» на сайте «{$a->sitename}» была заблокирована после нескольких неудачных попыток входа.

Чтобы разблокировать учетную запись пройдите по следующему адресу:

{$a->link}

В большинстве почтовых программ этот адрес должен выглядеть как синяя ссылка, на которую достаточно нажать. Если это не так, просто скопируйте этот адрес и вставьте его в строку адреса в верхней части окна Вашего браузера.

Если вам нужна помощь -  свяжитесь с администратором сайта
{$a->admin}';
$string['lockoutemailsubject'] = 'Ваша учетная запись на {$a} была заблокирована';
$string['lockouterrorunlock'] = 'Представлена неверная информация для разблокировки учетной записи.';
$string['lockoutthreshold'] = 'Порог блокировки учетной записи';
$string['lockoutthreshold_desc'] = 'Укажите количество неудачных попыток входа в систему, при котором учетная запись блокируется. Эта функция поможет избегать атак «Отказ в обслуживании».';
$string['lockoutwindow'] = 'Продолжительность блокировки';
$string['lockoutwindow_desc'] = 'Время наблюдения за порогом блокировки. Если больше нет неудачных попыток, то счетчик порога сбрасывается после этого времени.';
$string['lockrequestcategory'] = 'Предотвратить выбор категории';
$string['log'] = 'Журнал событий';
$string['logguests'] = 'Записывать в журнал действия гостей';
$string['logguests_help'] = 'Этот параметр отвечает за запись в журнал событий действий учетной записи гостя и пользователей, не вошедших в систему. Отключение этого параметра может потребоваться на сильно нагруженных сайтах для повышения производительности. Однако для сайтов в промышленной эксплуатации рекомендуется оставить этот параметр включенным.';
$string['logininfoinsecurelayout'] = 'Отображать зарегистрированного пользователя в защищенном режиме.';
$string['logininfoinsecurelayout_desc'] = 'Если эта функция включена, полное имя зарегистрированного пользователя будет отображаться в навигационной панели во время прохождения теста или работы с другими элементами, использующими защищенный режим.';
$string['loginpageautofocus'] = 'Автофокус формы страницы входа';
$string['loginpageautofocus_help'] = 'Включение этого параметра делает страницу входа более удобной. Но автоматический выбор полей может ввести в заблуждение слепых и слабовидящих пользователей, использующих программы для чтения с экрана.';
$string['loglifetime'] = 'Сохранять записи в течение';
$string['logo'] = 'Логотип';
$string['logo_desc'] = 'Полный логотип, который будет использоваться в качестве оформления некоторыми темами (например, основными темами). Это изображение должно иметь довольно высокое разрешение, потому что оно будет уменьшено для использования (и кэшировано для повышения производительности). Лучше использовать логотипы, у которых ширина больше высоты.';
$string['logocompact'] = 'Компактный логотип';
$string['logocompact_desc'] = 'Компактная версия того же логотипа, что и выше, например, эмблема, иконка или значок. Изображение должно быть четким даже при небольших размерах.';
$string['logossettings'] = 'Логотипы';
$string['logstorenotrequired'] = 'Взаимодействие с журналом событий не требуется';
$string['logstoressupported'] = 'Журналы событий, которые поддерживают этот отчет';
$string['longtimewarning'] = '<b> Учтите, что этот процесс может занять много времени. </b>';
$string['mailnewline'] = 'Символы перевода строки в электронных письмах';
$string['maintenancemode'] = 'В режиме обслуживания';
$string['maintenancemodeisscheduled'] = 'Через {$a->min} мин. {$a->sec} сек. сайт переходит в режим обслуживания';
$string['maintenancemodeisscheduledlong'] = 'Этот сайт будет переключен в режим обслуживания через {$a->hour} час. {$a->min} мин. {$a->sec} сек.';
$string['maintfileopenerror'] = 'Ошибка открытия обслуживаемых файлов';
$string['maintinprogress'] = 'Процесс обслуживания...';
$string['managecontextlock'] = 'Заморозить этот контекст';
$string['managecontextlocklocked'] = '{$a->contextname} и все нижерасположенные контексты теперь заморожены.';
$string['managecontextlockunlocked'] = '{$a->contextname} и все нижерасположенные контексты теперь разморожены.';
$string['managecontextunlock'] = 'Разморозить этот контекст';
$string['managecustomfields'] = 'Управление типами пользовательских полей';
$string['manageformats'] = 'Управление форматами курсов';
$string['manageformatsgotosettings'] = 'Формат по умолчанию может быть изменен в {$a}';
$string['managelang'] = 'Управление';
$string['manageqbanks'] = 'Управление плагинами банка вопросов';
$string['manageqbehaviours'] = 'Управление поведением вопросов';
$string['manageqtypes'] = 'Управление типами вопросов';
$string['maturity100'] = 'Бета-версия';
$string['maturity150'] = 'Релиз-кандидат';
$string['maturity200'] = 'Стабильная версия';
$string['maturity50'] = 'Альфа-версия';
$string['maturityallowunstable'] = 'Подсказка: Вы можете запустить этот скрипт в тестовом варианте';
$string['maturitycoreinfo'] = 'Сейчас Ваш сайт работает на нестабильном коде стадии разработки «{$a}».';
$string['maturitycorewarning'] = 'Версия Moodle, которую Вы собираетесь установить или обновить, содержит нестабильный код, находящийся в стадии разработки «{$a}», и не подходит для большинства сайтов в промышленной эксплуатации. Если это не то, чего Вы хотели, то Вы должны убедиться, что обновляете Moodle из ветви STABLE. Более подробная информация содержится в документации Moodle.';
$string['maxbytes'] = 'Максимальный размер загружаемого файла';
$string['maxcharacter'] = 'Максимум символов: {$a}';
$string['maxconsecutiveidentchars'] = 'Последовательных одинаковых символов';
$string['maxeditingtime'] = 'Максимальное время редактирования сообщения';
$string['maxsizeperdownloadcoursefile'] = 'Максимальный размер файла';
$string['maxsizeperdownloadcoursefile_desc'] = 'Максимальный размер каждого файла при скачивании содержимого курса. Файлы, превышающие этот размер, не будут скачиваться.';
$string['maxtimelimit'] = 'Ограничение времени';
$string['maxtimelimit_desc'] = 'Для ограничения максимального времени выполнения PHP, что позволит  Moodle работать без отображения вывода какого-либо сообщения, введите  здесь значение в секундах.
0 означает, что используются ограничения Moodle по умолчанию.
Если Вы используете внешний сервер с его собственным ограничением времени, то установите здесь более низкое значение, чтобы получать в журналах сообщения об ошибках PHP. Не относится к скриптам CLI.';
$string['maxusersperpage'] = 'Максимальное количество пользователей на странице';
$string['mbstringrecommended'] = 'Установка дополнительной библиотеки MBSTRING настоятельно рекомендуется для повышения производительности сайта, особенно если на сайте используются языки с нелатинскими символами.';
$string['mbstringrequired'] = 'Установка библиотеки MBSTRING необходима для повышения производительности сайта, особенно если ваш сайт поддерживает нелатинские языки.';
$string['mediapluginavi'] = 'Включить фильтр .avi';
$string['mediapluginflv'] = 'Включить фильтр .flv';
$string['mediapluginimg'] = 'Включить автоматическую замену ссылок на рисунки на сами рисунки';
$string['mediapluginmov'] = 'Включить фильтр .mov';
$string['mediapluginmp3'] = 'Включить фильтр .mp3';
$string['mediapluginmpg'] = 'Включить фильтр .mpg';
$string['mediapluginogg'] = 'Включить фильтр .ogg';
$string['mediapluginogv'] = 'Включить фильтр .ogv';
$string['mediapluginram'] = 'Включить фильтр .ram';
$string['mediapluginrm'] = 'Включить фильтр .rm';
$string['mediapluginrpm'] = 'Включить фильтр .rpm';
$string['mediapluginwmv'] = 'Включить фильтр .wmv';
$string['mediapluginyoutube'] = 'Включить фильтр ссылок на YouTube';
$string['messaging'] = 'Включить систему обмена сообщениями';
$string['messagingallowemailoverride'] = 'Разрешить переопределение адреса для сообщений';
$string['messagingallusers'] = 'Разрешить обмен сообщениями по всему сайту';
$string['messagingcategory'] = 'Обмен сообщениями';
$string['messagingdefaultpressenter'] = 'Использование Enter для отправки включено по умолчанию';
$string['messagingdeleteallnotificationsdelay'] = 'Удалять все уведомления через';
$string['messagingdeletereadnotificationsdelay'] = 'Удалять прочитанные уведомления через';
$string['messagingssettings'] = 'Настройки обмена сообщениями';
$string['minpassworddigits'] = 'Цифр';
$string['minpasswordlength'] = 'Длина пароля';
$string['minpasswordlower'] = 'Букв в нижнем регистре';
$string['minpasswordnonalphanum'] = 'Не буквенно-цифровых символов';
$string['minpasswordupper'] = 'Букв в верхнем регистре';
$string['misc'] = 'Разное';
$string['mlbackendsettings'] = 'Серверные настройки машинного обучения';
$string['mnetrestore_extusers'] = '<strong>Примечание:</strong> Этот файл резервной копии содержит учетные записи внешних пользователей из Moodle Network, которые также будут восстановлены.';
$string['mnetrestore_extusers_admin'] = '<strong> Примечание: </strong> Этот файл резервной копии, вероятно, создан в другой установке Moodle и содержит учетные записи внешних пользователей из Moodle Network. Процесс восстановления попытается найти подходящие серверы Moodle Network для всех таких пользователей. Если это не удастся, пользователи будут автоматически переключены на внутреннюю аутентификацию (вместо mnet). Информация об этом будет в журнале восстановления.';
$string['mnetrestore_extusers_mismatch'] = '<strong> Примечание: </strong> Этот файл резервной копии, вероятно, создан в другой установке Moodle и содержит учетные записи внешних пользователей из Moodle Network, которые, возможно, не удастся восстановить. Эта операция не поддерживается. Если Вы уверены, что резервная копия была создано на этой установке Moodle или Вы убедились, что все указаны настройки для всех необходимых серверов Moodle Network, то Вы можете попробовать осуществить восстановление.';
$string['mnetrestore_extusers_noadmin'] = '<strong> Примечание: </strong> Этот файл резервной копии, вероятно, создан в другой установке Moodle и содержит учетные записи внешних пользователей из Moodle Network. Вам запрещено выполнять такой вид восстановления. Свяжитесь с администратором сайта или восстановите этот курс без какой-либо информации о пользователях (модули, файлы...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Внешиний пользователь «{$a->username}» из Moodle Network (пришел с {$a->mnethosturl}) переключен на внутреннюю аутентификацию «{$a->auth}».';
$string['mobilenotconfiguredwarning'] = 'Приложение Moodle не включено.';
$string['modassignmentinuse'] = 'Обнаружено, что на сайте все еще используется плагин Задание 2.2. Перед обновлением вы можете решить эту проблему следующим образом: 1) Создать резервные копии активных элементов Задание 2.2 и восстановить их как новые Задания; или 2) Удалить все данные Задания 2.2 из таблицы assignment в базе данных.';
$string['modassignmentsubpluginsexist'] = 'В Задании 2.2. могут присутствовать субплагины. Перед обновлением необходимо удалить папку mod/assignment и все ее подпапки.';
$string['modeditdefaults'] = 'Значения настроек элемента курса по умолчанию';
$string['modsettings'] = 'Управление элементами курса';
$string['modulesecurity'] = 'Безопасность модулей';
$string['moodlebrandedapp'] = 'Фирменное приложение Moodle';
$string['moodlebrandedappreference'] = 'Кроме того, вы можете получить <a href="https://moodle.com/branded-app/">фирменное приложение Moodle</a> со своим собственным фирменным знаком.';
$string['mustenablestats'] = 'На сайте не включен сбор статистики.';
$string['mycourses'] = 'Мои курсы';
$string['mydashboard'] = 'Личный кабинет по умолчанию';
$string['mymoodle'] = 'Личный кабинет';
$string['mypage'] = 'Настройки по умолчанию для страницы «Личный кабинет»';
$string['mypagelocked'] = 'Заблокировать страницу по умолчанию';
$string['myprofile'] = 'Страница профиля по умолчанию';
$string['navadduserpostslinks'] = 'Добавлять ссылки для просмотра сообщений пользователя';
$string['navadduserpostslinks_help'] = 'При включении этого параметра в блоке навигации к каждому пользователю будут добавлены две ссылки для просмотра списка созданных пользователем обсуждений и списка всех сообщений на форумах по всему сайту или в конкретных курсах.';
$string['navcourselimit'] = 'Предельное количество курсов';
$string['navfilter'] = 'Фильтровать пользовательское меню';
$string['navfilter_desc'] = 'Применить к пользовательскому меню фильтры Moodle, настроенные на применение к <strong>Контенту и Заголовкам</strong>. Полезно для включения динамических пользовательских элементов меню.';
$string['navigationupgrade'] = 'В данном обновлении введены два новых блока навигации, которые заменят следующие блоки: «Управление», «Курсы», «Элементы курса» и «Участники курса». Если в этих блоках Вы наделяли пользователей определенными правами, то удостоверьтесь, всё ли работает так, как Вам необходимо.';
$string['navshowallcourses'] = 'Отображать «Все курсы»';
$string['navshowcategories'] = 'Отображать категории курсов';
$string['navshowfrontpagemods'] = 'Отображать в навигации элементы главной страницы';
$string['navshowfrontpagemods_help'] = 'При включенном параметре элементы главной страницы будут отображаться в навигации на страницах сайта.';
$string['navshowfullcoursenames'] = 'Отображать полные названия курсов';
$string['navshowfullcoursenames_help'] = 'При включении этого параметра при отображении курсов в блоке «Навигация» вместо кратких названий курсов будут отображаться полные названия.';
$string['navshowmycoursecategories'] = 'Показывать «Мои курсы» с категориями';
$string['navshowmycoursecategories_help'] = 'При включении этого параметра курсы в блоке навигации в разделе «Мои курсы» (только для классических тем) будут отображаться с разделением на категории.';
$string['navsortmycourseshiddenlast'] = 'Отображать мои скрытые курсы последними';
$string['navsortmycourseshiddenlast_help'] = 'При включенном параметре любые скрытые курсы будут перечислены после видимых курсов (для пользователей, которые могут видеть скрытые курсы). В противном случае все курсы, независимо от их видимости, будут перечислены в соответствии с настройкой «Сортировать мои курсы».';
$string['navsortmycoursessort'] = 'Порядок курсов в блоке навигации';
$string['navsortmycoursessort_help'] = 'Должны ли курсы быть перечислены в порядке, заданном в разделе Администрирование > Курсы > Управление курсами и категориями или в алфавитном порядке по названиям курсов? Этот параметр применяется только к темам на основе Classic.';
$string['never'] = 'Никогда';
$string['neverdeleteruns'] = 'Никогда не останавливать';
$string['newestdocindexed'] = '';
$string['nobookmarksforuser'] = 'У Вас нет закладок';
$string['nodatabase'] = 'Нет базы данных';
$string['noemaileverwarning'] = '<strong>Примечание:</strong> Все исходящие электронные письма отключены.';
$string['nohttpsformobilewarning'] = 'Рекомендуется включить HTTPS с действующим сертификатом. Приложение Moodle всегда будет в первую очередь пытаться использовать защищенное соединение.';
$string['nomissingstrings'] = 'Нет пропущенных строк';
$string['none'] = 'Нет';
$string['nonewsettings'] = 'После этого обновления не появилось новых параметров настройки';
$string['nonexistentbookmark'] = 'Запрошенная закладка не существует';
$string['noreplyaddress'] = 'Адрес для писем, не требующих ответа';
$string['noreplydomain'] = 'Письма, не требующие ответа, и почтовые домены';
$string['noreplydomaindetail'] = 'Параметры для писем, не требующих ответа, и настроенных доменов';
$string['noresults'] = 'Ничего не найдено';
$string['noroles'] = 'Нет ролей';
$string['nosupportedlogstore'] = 'Не найдено поддерживаемых способов хранения журнала событий';
$string['noteunneededblocks'] = 'Примечание: Блоки, настроенные для отображения, не будут перечислены в меню курса «Добавить блок», если они указаны в параметре настроек темы «Ненужные блоки».';
$string['notifications'] = 'Уведомления';
$string['notifyloginfailures'] = 'Кто уведомляется по электронной почте о неудачных попытках входа';
$string['notifyloginthreshold'] = 'Порог для уведомления по электронной почте';
$string['notloggedinroleid'] = 'Роль для посетителей';
$string['numberofmissingstrings'] = 'Количество пропущенных строк: {$a}';
$string['numberofstrings'] = 'Общее число строк: {$a->strings}<br />Не заполнено: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Истек ключ обновления для одной из служб OAuth {$a->issuer} на вашем сайте {$a->siteurl}. Это ограничит функциональность любых плагинов, которые используют эту службу. Для устранения проблемы перейдите на страницу конфигурации служб OAuth 2 и нажмите значок «Подключить системную учетную запись» в строке таблицы для этой службы. Обязательно входите в систему, каждый раз используя одну и ту же учетную запись службы OAuth.';
$string['oauthrefreshtokenexpiredshort'] = 'Ключ обновления OAuth истек для {$a->issuer} на вашем сайте {$a->siteurl}.';
$string['onlynoreply'] = 'Только при отправке с адреса для писем, не требующих ответа';
$string['opcacherecommended'] = 'Кэширование байт-кода улучшает производительность и уменьшает требования к памяти. Расширение OPcache языка PHP рекомендуется к установке и полностью поддерживается.';
$string['opensslrecommended'] = 'Настоятельно рекомендуется установка дополнительной библиотеки OpenSSL - от нее зависит функционирование Moodle Networking.';
$string['opensslrequired'] = 'Расширение PHP OpenSSL требуется Moodle для обеспечения более надежных криптографических услуг.';
$string['opentowebcrawlers'] = 'Открыть для Google';
$string['optionalmaintenancemessage'] = 'Сообщение о техническом обслуживании (необязательно)';
$string['order1'] = 'Первый';
$string['order2'] = 'Второй';
$string['order3'] = 'Третий';
$string['order4'] = 'Четвертый';
$string['outgoingmailconfig'] = 'Настройка исходящей почты';
$string['overridetossl'] = 'HTTPS для логинов уже устарел. Этот экземпляр теперь должен использовать SSL. Чтобы учесть это предупреждение, измените ваш wwwroot в conig.php на https://';
$string['pageinfodebugsummary'] = 'Эта страница: {$a}';
$string['passwordchangelogout'] = 'Выход после смены пароля';
$string['passwordchangelogout_desc'] = 'При включенном параметре после смены пароля все сеансы браузера будут закрыты, кроме того, в котором и была произведена смена пароля. (Эта опция не влияет на смену пароля при пакетной загрузке пользователей.)';
$string['passwordchangetokendeletion'] = 'Удалить ключи доступа к веб-сервисам после смены пароля';
$string['passwordchangetokendeletion_desc'] = 'Если включено, то при изменении пароля все ключи доступа к веб-сервисам пользователя удаляются.';
$string['passwordpolicy'] = 'Политика паролей';
$string['passwordpolicycheckonlogin'] = 'Проверка пароля при входе';
$string['passwordresettime'] = 'Максимальное время подтверждения запроса восстановления пароля';
$string['passwordreuselimit'] = 'Лимит повторного использования паролей';
$string['passwordreuselimit_desc'] = 'Количество раз, которое пользователь должен изменить свой пароль прежде чем он сможет повторно использовать пароль. Хэши ранее использованных паролей хранятся в локальной таблице базы данных. Эта возможность может быть несовместима с некоторыми плагинами внешней аутентификации.';
$string['pathtodot'] = 'Путь к dot';
$string['pathtodot_help'] = 'Путь к dot. На Linux это что-то вроде /usr/bin/dot. На Windows — что-то вроде C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. На Mac — что-то вроде /opt/local/bin/dot. Чтобы иметь возможность генерировать графики из файлов DOT, Вам необходимо установить исполняемый файл dot и здесь указать путь к нему.';
$string['pathtodu'] = 'Путь к du';
$string['pathtogs'] = 'Путь к Ghostscript';
$string['pathtogs_help'] = 'Для большинства установок Linux это можно оставить как «/usr/bin/gs». В Windows это будет что-то вроде «c:\\gs\\bin\\gswin32c.exe» (убедитесь, что в пути нет пробелов  - при необходимости скопируйте файлы «gswin32c.exe» и «gsdll32.dll» в новую папку без пробелов в пути)';
$string['pathtopdftoppm'] = 'Путь к pdftoppm';
$string['pathtopdftoppm_help'] = '«pdftoppm» - это инструмент, который конвертирует страницы PDF в PNG так же быстро, как «Ghostscript». Но при преобразовании больших документов ожидается лучшая производительность. Если поле заполнено, для этой задачи будет использоваться pdftoppm вместо Ghostscript. В большинстве установок Linux его можно оставить как «/usr/bin/pdftoppm». Если его нет, установите пакет poppler-utils или poppler, в зависимости от дистрибутива Linux. В Windows он будет предоставлен установкой Cygwin. Дополнительные сведения см. <a href="https://poppler.freedesktop.org/" target="_blank">в проекте Poppler</a>.';
$string['pathtopgdump'] = 'Путь к pg_dump';
$string['pathtopgdumpdesc'] = 'Этот параметр необходимо указывать только в том случае, если в системе установлено более одного файла pg_dump (например, если у Вас установлено несколько версий postgresql).';
$string['pathtopgdumpinvalid'] = 'Или путь к pg_dump неверный, или файл не исполняемый';
$string['pathtophp'] = 'Путь к PHP CLI';
$string['pathtopsql'] = 'Путь к psql';
$string['pathtopsqldesc'] = 'Этот параметр необходимо указывать только в том случае, если в системе установлено более одного файла psql (например, если у Вас установлено несколько версий postgresql).';
$string['pathtopsqlinvalid'] = 'Или путь к psql неверный, или файл не исполняемый';
$string['pathtopython'] = 'Путь к Python';
$string['pathtopythondesc'] = 'Путь к исполняемому файлу Python (Python 2 и Python 3 приемлемы).';
$string['pathtosassc'] = 'Путь к SassC';
$string['pathtosassc_help'] = 'Задание пути к бинарному файлу SassC приведет к переключению компилятора SASS с PHP-реализации в Moodle на SassC. Подробная информация на https://github.com/sass/sassc.';
$string['pcreunicodewarning'] = 'Настоятельно рекомендуется использовать расширение PHP PCRE, совместимое с символами Unicode.';
$string['perfdebug'] = 'Информация о производительности';
$string['perfdebugdeferred'] = 'Ожидание завершения скрипта, чтобы показать отладку производительности...';
$string['performance'] = 'Производительность';
$string['pgcluster'] = 'Кластер PostgreSQL';
$string['pgclusterdescription'] = 'Параметры версии/кластера PostgreSQL для операций в командной строке. Если в системе только один PostgreSQL или Вы не уверены в том, что нужно указывать, оставьте это поле пустым.';
$string['phpfloatproblem'] = 'Обнаружена проблема с обработкой PHP чисел с плавающей запятой  - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Ваш сайт зарегистрирован. Последнее обновление регистрации - {$a}.<br />Запланированная задача «Регистрация сайта» поддерживает вашу регистрацию актуальной. Вы также можете в любой момент вручную обновить свою регистрацию.';
$string['pleaserefreshregistrationnewdata'] = 'Регистрационная информация была изменена. Пожалуйста, подтвердите ее, используя кнопку «Обновить регистрацию».';
$string['pleaserefreshregistrationunknown'] = 'Ваш сайт был зарегистрирован, но дата регистрации неизвестна. Пожалуйста, обновите свою регистрацию, использовав кнопку «Обновить регистрацию» или убедитесь, что запланированная задача «Регистрация сайта» включена, чтобы ваша регистрация автоматически обновлялась.';
$string['plugin'] = 'Плагин';
$string['plugin_disabled'] = 'Плагин {$a} отключен';
$string['plugin_enabled'] = 'Плагин {$a} включен';
$string['plugins'] = 'Плагины';
$string['pluginscheck'] = 'Плагин проверки зависимостей';
$string['pluginscheckfailed'] = 'Не удалось проверить зависимости для {$a->pluginslist}';
$string['pluginschecktodo'] = 'Вам необходимо удовлетворить зависимости для всех плагинов, прежде чем продолжить установку этой версии Moodle!';
$string['pluginsoverview'] = 'Обзор плагинов';
$string['pluginsoverviewsee'] = 'Подробности можно найти на странице <a href="{$a->url}">обзора плагинов</a>';
$string['policysettings'] = 'Выбор обработчика политик сайта';
$string['privacy:metadata'] = 'Плагин «Администрирование» не хранит никаких персональных данных.';
$string['privacyandpolicies'] = 'Конфиденциальность и политики';
$string['privacysettings'] = 'Настройки конфиденциальности';
$string['profilecategory'] = 'Категория';
$string['profilecategoryname'] = 'Название категории (должно быть уникальным)';
$string['profilecategorynamenotunique'] = 'Такое название категории уже используется';
$string['profilecommonsettings'] = 'Общие настройки';
$string['profileconfirmcategorydeletion'] = 'Полей в этой категории: {$a}<br />Все они будут перемещены в вышестоящую категорию (или в нижестоящую, если находятся в высшей категории).<br />Вы все же хотите удалить эту категорию?';
$string['profileconfirmfielddeletion'] = 'Пользовательских записей в этом поле: {$a}.<br />Все они будут удалены.<br />Вы все же хотите удалить это поле?';
$string['profilecreatecategory'] = 'Создать новую категорию профиля';
$string['profilecreatefield'] = 'Создать новое поле профиля:';
$string['profilecreatenewcategory'] = 'Создание новой категории';
$string['profilecreatenewfield'] = 'Создание нового поля профиля типа «{$a}»';
$string['profiledefaultcategory'] = 'Другие поля';
$string['profiledefaultchecked'] = 'Отмечено по умолчанию';
$string['profiledefaultdata'] = 'Значение по умолчанию';
$string['profiledeletecategory'] = 'Удаление категории';
$string['profiledeletefield'] = 'Удаление поля «{$a}»';
$string['profiledescription'] = 'Описание поля';
$string['profiledscript'] = 'Этот скрипт был профилирован';
$string['profiledscriptview'] = 'Просмотр данных профилирования для этого скрипта';
$string['profileeditcategory'] = 'Редактирование категории: {$a}';
$string['profileeditfield'] = 'Редактирование поля профиля: {$a}';
$string['profilefield'] = 'Поле профиля';
$string['profilefieldcolumns'] = 'Столбцов';
$string['profilefieldispassword'] = 'Это поле пароля?';
$string['profilefieldlink'] = 'Ссылка';
$string['profilefieldlink_help'] = 'Для преобразования текста в ссылку введите URL, содержащий $$, где $$ будут заменены на текст. Например, для преобразования Twitter ID в ссылку, введите https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Открывать ссылку';
$string['profilefieldmaxlength'] = 'Ограничение количества символов';
$string['profilefieldmaxlength_help'] = 'Чтобы использовать это поле в настройке «Показать идентификатор пользователя», ограничение должно быть не более 255 символов.';
$string['profilefieldrows'] = 'Строк';
$string['profilefields'] = 'Дополнительные поля профиля';
$string['profilefieldsize'] = 'Отображаемый размер';
$string['profileforceunique'] = 'Значения должны быть уникальными?';
$string['profileinvaliddata'] = 'Некорректное значение';
$string['profilelocked'] = 'Это поле заблокировано?';
$string['profilemenudefaultnotinoptions'] = 'Значение по умолчанию не совпадает ни с одним из вариантов';
$string['profilemenunooptions'] = 'Нет вариантов для выбора';
$string['profilemenuoptions'] = 'Варианты выбора (каждый с новой строки)';
$string['profilemenutoofewoptions'] = 'Вы должны указать как минимум 2 варианта';
$string['profilename'] = 'Название';
$string['profilenofieldsdefined'] = 'Поля не определены';
$string['profilerequired'] = 'Это обязательное поле?';
$string['profileroles'] = 'Видимые роли профиля';
$string['profilesforenrolledusersonly'] = 'Профили только для записанных на курс пользователей';
$string['profileshortname'] = 'Краткое название (должно быть уникальным)';
$string['profileshortnameinvalid'] = 'Короткое имя может содержать только буквы, цифры или нижнее подчеркивание ( _ ).';
$string['profileshortnamenotunique'] = 'Это краткое название уже используется';
$string['profilesignup'] = 'Показывать на странице регистрации?';
$string['profilespecificsettings'] = 'Особые параметры';
$string['profilevisible'] = 'Кому видно это поле?';
$string['profilevisible_help'] = '* Не видно никому - для конфиденциальных пользовательских данных, доступных только администраторам и управляющим.
* Видно пользователю - для личных данных, доступных только пользователю и администраторам.
* Видно пользователям, преподавателям и администраторам - для личных данных, доступных для просмотра только пользователям, администраторам и преподавателям (в профиле курса)
* Видно всем - для открытых данных.';
$string['profilevisibleall'] = 'Видно всем';
$string['profilevisiblenone'] = 'Не видно никому';
$string['profilevisibleprivate'] = 'Видно пользователю';
$string['profilevisibleteachers'] = 'Видно пользователям, преподавателям и администраторам';
$string['profiling'] = 'Профилирование';
$string['profilingallowall'] = 'Непрерывное профилирование';
$string['profilingallowall_help'] = 'При включении этого параметра Вы затем, в любой момент, сможете использовать параметр PROFILEALL в любом месте (PGS), чтобы включить профилирование для всех выполняемых скриптов во время сеанса Moodle. Аналогично, Вы сможете использовать параметр PROFILEALLSTOP, чтобы остановить его.';
$string['profilingallowme'] = 'Выборочное профилирование';
$string['profilingallowme_help'] = 'При включении этого параметра Вы затем, выборочно, сможете использовать параметр PROFILEME в любом месте (PGS) и произойдет профилирование этого скрипта. Аналогично, Вы сможете использовать параметр DONTPROFILEME для предотвращения профилирования.';
$string['profilingautofrec'] = 'Автоматическое профилирование';
$string['profilingautofrec_help'] = 'При настройке этого параметра некоторый запрос  (случайный, на основе указанной частоты - 1 из N) будет выбран и автоматически профилирован с сохранением результата для дальнейшего анализа. Обратите внимание, что этот способ наблюдения профилирования можно включить/выключить. Установив параметр в 0, Вы отключите автоматическое профилирование.';
$string['profilingenabled'] = 'Включить профилирование';
$string['profilingenabled_help'] = 'При включении этого параметра  профилирование будет доступно на этом сайте и Вы сможете определить его поведение, настроив следующие параметры.';
$string['profilingexcluded'] = 'Не профилировать эти';
$string['profilingexcluded_help'] = 'Список путей (относительно папки wwwroot, через запятую или с новой строки), которые не будут профилироваться, из тех, что определены настройками как «Профилировать эти».';
$string['profilingimportprefix'] = 'Префикс импортированного профилирования';
$string['profilingimportprefix_desc'] = 'Для более легкого обнаружения все импортированные профилирования будут работать с указанным здесь префиксом.';
$string['profilingincluded'] = 'Профилировать эти';
$string['profilingincluded_help'] = 'Список путей (относительно папки wwwroot, через запятую или с новой строки), которые будут автоматически профилироваться. Примеры: /index.php, /course/view.php. Также допускаются подстановки * в любом месте. Примеры: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Хранить результаты профилирования';
$string['profilinglifetime_help'] = 'Укажите какое время Вы хотите хранить информацию о прошедших запусках профилирования. Старые результаты будут периодически удаляться. Это не относится к результатам профилирования, помеченным как «reference run»';
$string['profilingslow'] = 'Профилирование медленных страниц';
$string['profilingslow_help'] = 'При установке минимального времени в секундах все более медленные страницы будут профилироваться. Будут сохранены только профайлы, которые медленнее, чем существующий профайл для того же скрипта. Установите 0, чтобы отключить функцию. Обратите внимание, что при этом учитываются параметры исключения.';
$string['protectusernames'] = 'Защищать логины';
$string['proxybypass'] = 'Не использовать прокси для';
$string['proxyfixunsafe'] = 'Исправлять внутренние вызовы';
$string['proxyhost'] = 'Прокси-сервер';
$string['proxylogunsafe'] = 'Использовать внутренние вызовы';
$string['proxypassword'] = 'Пароль прокси';
$string['proxyport'] = 'Порт прокси';
$string['proxytype'] = 'Тип прокси';
$string['proxyuser'] = 'Имя пользователя прокси-сервера';
$string['purgecaches'] = 'Очистить все кэши';
$string['purgecachesconfirm'] = 'Moodle может кэшировать темы, JavaScript, строки языковых пакетов, обработанный фильтрами текст, RSS-ленты и многие другие составляющие обрабатываемых данных. Очистка кэшированных данных вынудит браузеры заново их загрузить, и Вы точно увидите актуальные значения, заново сгенерированные системой. Очистка кэша абсолютно безопасна, но после этого, возможно, сайт первое время будет работать медленней, так как потребуется заново генерировать часть информации и кэшировать ее.';
$string['purgecachesfinished'] = 'Все кэши были очищены.';
$string['purgecachesnoneselected'] = 'Выберите один или несколько кэшей для очистки';
$string['purgecachespage'] = 'Очистить кэши';
$string['purgecoursecache'] = 'Курсы';
$string['purgefiltercache'] = 'Текстовые фильтры';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Языковые строки';
$string['purgemuc'] = 'Все MUC кэши';
$string['purgeothercaches'] = 'Все файловые и прочие кэши';
$string['purgeselectedcaches'] = 'Очистить выбранные кэши';
$string['purgeselectedcachesfinished'] = 'Выбранные кэши были очищены.';
$string['purgetemplates'] = 'Шаблоны';
$string['purgethemecache'] = 'Темы';
$string['query'] = 'Запрос';
$string['question'] = 'Вопрос';
$string['questionbehaviours'] = 'Поведение вопроса';
$string['questioncwqpfscheck'] = 'Один или несколько случайных вопросов теста настроены для выбора вопросов одновременно из общих и из необщих категорий. Смотрите <a href="{$a->reporturl}"> отчет о случайных вопросах</a> и <a href="{$a->docsurl}">документацию</a>.';
$string['questioncwqpfsok'] = 'Хорошо. В ваших тестах нет вопросов типа «случайный», настроенных на выбор вопросов одновременно из общих и из не общих категорий.';
$string['questiontype'] = 'Тип вопроса';
$string['questiontypes'] = 'Типы вопросов';
$string['quizattemptsupgradedmessage'] = 'В Moodle 2.1 было серьезное обновление работы вопросов. Обновление части базы данных было отложено на будущее. Перед обновлением до Moodle 2.7 вышеуказанное обновление должно быть завершено.';
$string['recaptchaprivatekey'] = 'Секретный ключ ReCAPTCHA';
$string['recaptchapublickey'] = 'Ключ сайта ReCAPTCHA';
$string['referrernone'] = 'Браузер по умолчанию';
$string['referrerpolicy'] = 'Заголовок ответа «Referrer-Policy»';
$string['referrerpolicydesc'] = 'Задайте заголовок «Referrer-Policy», который будет включаться в ответы с вашего сайта.';
$string['register'] = 'Зарегистрировать этот сайт';
$string['registration'] = 'Регистрация';
$string['registration_help'] = 'Зарегистрировавшись:

* Вы будете получать предупреждения безопасности
* Вы можете активировать push-уведомления мобильного приложения со своего сайта.
* Вы вносите свой вклад в нашу статистику мирового сообщества Moodle';
$string['registrationwarning'] = 'Не пропустите важные обновления и оповещения о безопасности.';
$string['registrationwarningcontactadmin'] = 'Этот сайт не зарегистрирован. Попросите администратора зарегистрировать сайт, чтобы они не пропустили важные обновления.';
$string['releasenoteslink'] = 'Информацию об этой версии Moodle можно посмотреть онлайн в <a target="_blank" href="{$a}">Release Notes</a>';
$string['rememberuserlicensepref'] = 'Запоминать предпочитаемые пользователем лицензии';
$string['rememberuserlicensepref_help'] = 'Если эта опция включена, то при загрузке файла в менеджер файлов автоматически выбирается последняя использованная пользователем лицензия. В противном случае выбирается лицензия сайта по умолчанию.';
$string['rememberusername'] = 'Запомнить логин';
$string['rememberusername_desc'] = 'Включите этот параметр, если при входе в систему нужно сохранять логин пользователя с помощью постоянных cookie. Использование постоянных cookie без разрешения может расцениваться как угроза конфиденциальности.';
$string['replacefrontsearch'] = 'Использовать поиск на сайте для сведений о курсе';
$string['reportsmanage'] = 'Управление отчетами';
$string['required'] = 'Требуется';
$string['requiredentrieschanged'] = 'Примечание. После обновления параметр «Требуется записей до разрешения просмотра» теперь применяется в следующих действиях с базой данных: <br/> {$a->text} <br/>';
$string['requiremodintro'] = 'Обязательное описание элементов курса';
$string['requiremodintro_desc'] = 'Если параметр включен, пользователи должны будут обязательно вводить описание для каждого элемента.';
$string['requires'] = 'Необходимо';
$string['resetindentation'] = 'Сбросить отступ по всему сайту';
$string['resetindentation_help'] = 'Это удалит все ранее установленные отступы для всех курсов в формате {$a->format}.';
$string['resetindentation_title'] = 'Сбросить отступы на всем сайте?';
$string['resetindentationsuccess'] = 'Отступы сброшены';
$string['restorecourse'] = 'Восстановление курса';
$string['restorernewroleid'] = 'Роль для пользователя, восстановившего курс';
$string['restorernewroleid_help'] = 'Если у пользователя нет права на управление восстановленным им из резервной копии курсом, этому пользователю будет назначена эта роль. Выберите вариант «Пусто», если Вы не хотите, чтобы пользователи, которые восстанавливают курсы, обязательно могли управлять этими курсами.';
$string['resultfilter'] = 'Фильтр по результату';
$string['reverseproxy'] = 'Реверсивный прокси-сервер';
$string['reverseproxyignore'] = 'Игнорировать обратные прокси';
$string['riskconfig'] = 'Пользователи могут изменить конфигурацию и поведение сайта';
$string['riskconfigshort'] = 'Риск, связанный с конфигурацией';
$string['riskdataloss'] = 'Пользователи могут уничтожить большое количество содержимого или информации';
$string['riskdatalossshort'] = 'Риск потери данных';
$string['riskmanagetrust'] = 'Пользователи могут изменить настройки доверия других пользователей';
$string['riskmanagetrustshort'] = 'Управление доверием';
$string['riskpersonal'] = 'Пользователи могут получить доступ к личной информации других пользователей';
$string['riskpersonalshort'] = 'Угроза конфиденциальности';
$string['riskspam'] = 'Пользователи могут рассылать спам пользователям сайта или другим людям';
$string['riskspamshort'] = 'Риск спама';
$string['riskxss'] = 'Пользователи могут добавить файлы и тексты, содержащие Сross Site Sсriрting (XSS)';
$string['riskxssshort'] = 'Риск XSS';
$string['roleswithexceptions'] = '{$a->roles}, с {$a->exceptions}';
$string['rssglobaldisabled'] = 'Отключено на уровне сайта';
$string['save'] = 'Сохранить';
$string['savechanges'] = 'Сохранить изменения';
$string['scssinvalid'] = 'Код SCSS неверен, сбой: {$ a}';
$string['search'] = 'Поиск';
$string['searchablecourses'] = 'Курсы с возможностью поиска';
$string['searchallavailablecourses'] = 'Курсы, доступные для поиска';
$string['searchallavailablecourses_desc'] = 'В некоторых ситуациях поисковая машина может не работать при поиске по большому количеству курсов. Задайте поиск только внутри курсов, на которые записан пользователь, если Вам нужно ограничить число курсов для поиска.';
$string['searchallavailablecourses_off'] = 'Искать только внутри курсов, на которые пользователь записан';
$string['searchallavailablecourses_on'] = 'Искать внутри всех курсов, к которым пользователь может иметь доступ';
$string['searchallavailablecoursesdesc'] = 'Если поиск задан только по курсам, на которые зачислены, то информация о курсе (название и краткое описание) и содержимое курса будут выполняться только в тех курсах, в которые зарегистрирован пользователь. В противном случае поиск информации и содержимого курса будет выполняться во всех курсах, к которым пользователь может получить доступ, например, в курсах с включенным гостевым доступом.';
$string['searchalldeleted'] = 'Все результаты индексирования содержимого были удалены';
$string['searchalternatesettings'] = 'Альтернативные настройки только для запросов';
$string['searchalternatesettings_desc'] = 'При выполнении этих настроек вы можете выбрать «альтернативные настройки» для этой поисковой системы только по запросу в параметре поисковой системы на странице «Управление глобальным поиском». Это полезно только при перемещении между двумя поисковыми системами одного типа.';
$string['searchareadisabled'] = 'Область поиска выключена';
$string['searchareaenabled'] = 'Область поиска включена';
$string['searchareas'] = 'Области поиска';
$string['searchbanner'] = 'Информация о поиске';
$string['searchbannerenable'] = 'Показать информацию о поиске';
$string['searchbannerenable_desc'] = 'Если этот параметр включен, то приведенный ниже текст будет отображаться в верхней части экрана поиска для всех пользователей. Это может быть использовано для информирования пользователей о проведении технического обслуживания поисковой системы.';
$string['searchdefaultcategory'] = 'Категория поиска по умолчанию';
$string['searchdefaultcategory_desc'] = 'Результаты из выбранной категории области поиска будут отображаться по умолчанию.';
$string['searchdeleteindex'] = 'Удалить всё выделенное содержимое';
$string['searchdisplay'] = 'Параметры отображения результатов поиска';
$string['searchenablecategories'] = 'Отображение результатов в отдельных категориях';
$string['searchenablecategories_desc'] = 'Если этот параметр включен, то результаты поиска будут отображаться в отдельных категориях.';
$string['searchengine'] = 'Поисковик';
$string['searchenginealternatesettings'] = '{$a} (альтернативные настройки)';
$string['searchenginequeryonly'] = 'Поисковая система только для запросов';
$string['searchenginequeryonly_desc'] = 'Эта поисковая система будет использоваться только для выполнения запросов, но не для индексации. Используя эту функцию, вы можете изменить индексы в другой поисковой системе, в то время как запросы пользователей продолжают работать с этой.';
$string['searchenginequeryonly_none'] = 'Нет (использовать основную поисковую систему для запросов)';
$string['searchenginequeryonlysame'] = 'Для поисковой системы только для запросов и для основной поисковой системы нельзя задать одно и то же значение.';
$string['searchhideallcategory'] = 'Скрыть категории со всеми результатами поиска';
$string['searchhideallcategory_desc'] = 'Если флажок установлен, категория со всеми результатами будет скрыта на экране результатов поиска.';
$string['searchincludeallcourses'] = 'Включить все видимые курсы';
$string['searchincludeallcourses_desc'] = 'Если этот параметр включен, то результаты поиска будут содержать сведения о курсе (название и краткое описание), которые будут видны пользователю, даже если у него нет доступа к содержимому курса.';
$string['searchindexactions'] = 'Действия над индексом';
$string['searchindexdeleted'] = 'Индекс удален';
$string['searchindextime'] = 'Лимит времени на индексацию';
$string['searchindextime_desc'] = 'При индексировании большого количества нового содержимого запланированная задача будет остановлена после достижения этого предельного значения. Она будет продолжена при следующем запуске задачи.';
$string['searchindexupdated'] = 'Содержание поисковой системы было обновлено';
$string['searchindexwhendisabled'] = 'Индексировать при отключении';
$string['searchindexwhendisabled_desc'] = 'Разрешает запланированной задаче строить индекс поиска даже если поиск отключен. Это может быть полезно, если вы хотите построить индекс до того, как возможность поиска появится у студентов.';
$string['searchinsettings'] = 'Поиск в настройках';
$string['searchlastrun'] = 'Последний запуск (время, число документов, число записей, число пропущенных)';
$string['searchmanagement'] = 'Управление поиском';
$string['searchmanagement_desc'] = 'Эти параметры полезны при внесении изменений на сайтах с очень большими поисковыми индексами, восстановление которых занимает много времени.';
$string['searchmaxtopresults'] = 'Максимальное количество лучших результатов';
$string['searchmaxtopresults_desc'] = 'Максимальное количество результатов с наивысшим рейтингом, отображаемых над результатами поиска для содержимого курса, курсов и пользователей.';
$string['searchnotavailable'] = 'Поиск недоступен';
$string['searchoptions'] = 'Параметры поиска';
$string['searchpartial'] = '(пока полностью не проиндексировано)';
$string['searchreindexed'] = 'Все содержимое сайта было повторно проиндексировано.';
$string['searchreindexindex'] = 'Повторно проиндексировать все содержимое сайта';
$string['searchresults'] = 'Результаты поиска';
$string['searchsetupinfo'] = 'Настройки поиска';
$string['searchteacherroles'] = 'Роли учителя';
$string['searchteacherroles_desc'] = 'Выберите все роли учителя для отображения преподавателя курса при поиске.';
$string['searchtopresults'] = 'Лучшие результаты';
$string['searchupdateindex'] = 'Обновление индексированного содержимого';
$string['sectionerror'] = 'Ошибка раздела!';
$string['secureforms'] = 'Использовать расширенную безопасность форм';
$string['security'] = 'Безопасность';
$string['selectsearchengine'] = 'Выбрать поисковую систему';
$string['server'] = 'Сервер';
$string['serverchecks'] = 'Проверка настроек сервера';
$string['serverlimit'] = 'Ограничение сервера';
$string['servicespage'] = 'Ссылка на страницу «Услуги и поддержка»';
$string['sessionautostartwarning'] = '<p>Обнаружены серьезные ошибки конфигурации, пожалуйста, сообщите администратору сервера.</p><p>Для нормальной работы Moodle требуется, чтобы администратор изменил настройки PHP.</p><p>Параметр <code>session.auto_start</code> должен быть установлено в <code>off</code>.</p><p>Этот параметр управляется редактированием <code>php.ini</code>, конфигурации Apache/IIS <br /> или файла <code>.htaccess</code> на сервере.</p>';
$string['sessioncookie'] = 'Суффикс файла cookie';
$string['sessioncookiedomain'] = 'Домен cookie';
$string['sessioncookiepath'] = 'Путь для cookie';
$string['sessionhandling'] = 'Обработка сеанса';
$string['sessiontimeout'] = 'Тайм-аут сеанса';
$string['sessiontimeoutwarning'] = 'Предупреждение о тайм-ауте';
$string['settingdependenton'] = 'Этот параметр может быть скрыт в зависимости от значения <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Для нормальной работы требуется возможноть загрузки файлов на сервер, включите ее в настройках PHP.';
$string['settingmaxinputvars'] = 'Параметр PHP max_input_vars рекомендуется не менее 5000.';
$string['settingmaxinputvarsrequired'] = 'Параметр PHP max_input_vars должен быть не менее 5000.';
$string['settingmemorylimit'] = 'Обнаружен недостаток памяти, установите более высокие ограничения памяти в настройках PHP.';
$string['settingsafemode'] = 'Moodle не полностью совместима с режимом «safe mode» в PHP, попросите администратора сервера отключить его. Запуск Moodle в режиме «safe mode» не поддерживается, при этом могут возникнуть самые разнообразные проблемы...';
$string['settingzendexceptionignoreargs'] = 'Для безопасности настоятельно рекомендуется включить параметр PHP zend.exception_ignore_args.';
$string['setupsearchengine'] = 'Настройки поисковика';
$string['showcommentscount'] = 'Отображать число комментариев';
$string['showdetails'] = 'Показать подробности';
$string['showuseridentity'] = 'Отображать персональные данные';
$string['showuseridentity_desc'] = 'При выборе или поиске пользователей, а также при отображении списков пользователей эти поля могут отображаться в дополнение к полному имени пользователя. Поля отображаются только для пользователей, у которых есть право moodle/site:viewuseridentity; по умолчанию учителя и менеджеры. (Эта опция имеет наибольший смысл, если вы выберете одно или два обязательных поля в вашем учреждении.)

Поля, отмеченные *, являются настраиваемыми полями профиля пользователя. Вы можете выбрать эти поля, но в настоящее время есть некоторые страницы, на которых они не отображаются.';
$string['simplexmlrequired'] = 'Расширение SimpleXML PHP теперь является обязательным для Moodle.';
$string['sitemailcharset'] = 'Кодировка';
$string['sitemaintenance'] = 'Извините, сайт находится в режиме технического обслуживания и сейчас недоступен';
$string['sitemaintenancemode'] = 'Режим технического обслуживания';
$string['sitemaintenanceoff'] = 'Режим технического обслуживания отключен и сайт снова работает в нормальном режиме.';
$string['sitemaintenanceon'] = 'Сейчас Ваш сайт находится в режиме технического обслуживания (войти могут только администраторы).';
$string['sitemaintenanceoncli'] = 'Ваш сайт сейчас находится в режиме технического обслуживания через интерфейс командной строки, доступ через веб-интерфейс запрещен.';
$string['sitemaintenancetitle'] = '{$a} на обслуживании';
$string['sitemaintenancewarning'] = 'Ваш сайт в настоящее время в режиме технического обслуживания (войти могут только администраторы). Для возврата сайта в нормальный режим работы <a href="maintenance.php"> отключите режим обслуживания </a>.';
$string['sitemaintenancewarning2'] = 'Ваш сайт сейчас находится в режиме технического обслуживания (вход только для администраторов). Для возврата сайта в нормальный режим работы <a href="{$a}">отключите режим обслуживания</a>.';
$string['sitemenubar'] = 'Навигация по сайту';
$string['sitenameintitle'] = 'Включить название сайта в заголовок страницы';
$string['sitenameintitle_help'] = 'Этот параметр добавит название сайта в конце заголовка страницы. Рекомендуется включать название сайта в заголовок страницы, поскольку это улучшит доступность сайта, позволяя пользователям быстро идентифицировать страницу, на которой они в данный момент находятся.';
$string['sitepolicies'] = 'Параметры безопасности сайта';
$string['sitepolicy'] = 'Ссылка на пользовательское соглашение';
$string['sitepolicy_help'] = 'URL пользовательского соглашения, которое все зарегистрированные пользователи должны просмотреть и принять перед использованием этого сайта. Обратите внимание, что этот параметр действует только в случае, если обработчик политики сайта установлен в «По умолчанию (ядро)».';
$string['sitepolicyguest'] = 'Ссылка на пользовательское соглашение для гостя';
$string['sitepolicyguest_help'] = 'URL пользовательского соглашения, которое все гости должны просмотреть и принять перед использованием этого сайта. Обратите внимание, что этот параметр действует только в случае, если обработчик политики сайта установлен в «По умолчанию (ядро)».';
$string['sitepolicyhandler'] = 'Обработчик политик сайта';
$string['sitepolicyhandler_desc'] = 'Этот параметр определяет, каким образом происходит управление политиками сайта и пользовательскими соглашениями. Обработчик «По умолчанию (ядро)» позволяет указать ссылку на пользовательское соглашение и ссылку на пользовательское соглашение для гостя. Обработчик «Политики» позволяет настраивать пользовательское соглашение, политику в области обработки персональных данных и конфиденциальности и другие политики. Этот обработчик также позволяет требовать от пользователя согласия с политиками и, при необходимости, давать такое согласие от имени несовершеннолетнего.';
$string['sitepolicyhandlercore'] = 'По умолчанию (ядро)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Отобразить вверху страницы раздел, куда можно будет добавить собственный контент.';
$string['sixtyfourbitsrequired'] = 'Обнаружено, что ваш сайт не использует 64-битную версию PHP. Вам необходимо обновить свою систему (операционную систему, PHP...) перед установкой этой версии Moodle.';
$string['sixtyfourbitswarning'] = 'Ваш сайт не использует 64-битную версию PHP. Рекомендуется обновить ваш сайт для обеспечения совместимости в будущем.';
$string['slasharguments'] = 'Использовать «slash arguments»';
$string['slashargumentswarning'] = 'Рекомендуется включить использование так называемых «slash arguments». В будущем это будет обязательным требованием. Подробную информацию можно найти в документации <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smallscreensonly'] = 'Только маленькие экраны';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Тип аутентификации SMTP';
$string['smtpdetail'] = 'Настройки SMTP для отправки электронной почты.';
$string['smtphosts'] = 'SMTP-серверы';
$string['smtpmaxbulk'] = 'Ограничение сеанса SMTP';
$string['smtppass'] = 'Пароль SMTP';
$string['smtpsecure'] = 'Безопасность SMTP';
$string['smtpuser'] = 'Логин SMTP';
$string['soaprecommended'] = 'Установка расширения SOAP необходима для функционирования веб-служб и некоторых плагинов.';
$string['sort_fullname'] = 'Полное название';
$string['sort_idnumber'] = 'ID номер';
$string['sort_shortname'] = 'Краткое название';
$string['sort_sortorder'] = 'Заданный порядок';
$string['spellengine'] = 'Инструмент проверки правописания';
$string['spelllanguagelist'] = 'Список языков для проверки правописания';
$string['splrequired'] = 'Расширение PHP SPL теперь является обязательным для Moodle.';
$string['stats'] = 'Статистика';
$string['statsfirstrun'] = 'Максимальный интервал обработки';
$string['statsmaxruntime'] = 'Максимальное время работы';
$string['statsmoodleorg'] = 'статистику';
$string['statsruntimedays'] = 'Обрабатывать дней';
$string['statsruntimestart'] = 'Запускать в';
$string['statsuserthreshold'] = 'Порог числа пользователей';
$string['stickyblocks'] = 'Закрепленные блоки';
$string['stickyblockscourseview'] = 'Страница курса';
$string['stickyblocksduplicatenotice'] = 'Если Вы добавляете любой блок и он уже существует на странице, он будет продублирован.<br />Первоначальный (закрепленный) блок будет недоступен для редактирования, а дубликат можно будет редактировать.';
$string['stickyblocksmymoodle'] = 'Мой Moodle';
$string['stickyblockspagetype'] = 'Конфигурирование типа страницы';
$string['storedprogressbarcleanuptask'] = 'Сохраненная задача очистки индикатора выполнения';
$string['strictformsrequired'] = 'Строгая проверка обязательных полей';
$string['stripalltitletags'] = 'Удалять HTML-теги из названий всех элементов';
$string['supportandservices'] = 'Поддержка и услуги';
$string['supportavailability'] = 'Доступность техподдержки';
$string['supportcontact'] = 'Контакты службы поддержки';
$string['supportemail'] = 'Электронная почта техподдержки';
$string['supportemailsubject'] = 'Обращение в техподдержку сайта - {$a}';
$string['supportname'] = 'Имя техподдержки';
$string['supportpage'] = 'Страница техподдержки';
$string['suspenduser'] = 'Заблокировать учетную запись пользователя';
$string['swaggerui'] = 'Moodle REST API UI (SwaggerUI)';
$string['switchlang'] = 'Переключить каталог языка';
$string['systempaths'] = 'Системные пути';
$string['tablenosave'] = 'Изменения в вышеприведенной таблице сохраняются автоматически.';
$string['tablesnosave'] = 'Изменения в вышеприведенных таблицах сохраняются автоматически.';
$string['tabselectedtofront'] = 'В таблицах с вкладками строка с текущей выбранной вкладки должна быть вынесена на передний план';
$string['tabselectedtofronttext'] = 'Перенести строку выбранной вкладки на передний план';
$string['task_adhoc_concurrency_limit'] = 'Ограничение количества одновременно выполняемых разовых задач';
$string['task_adhoc_concurrency_limit_desc'] = 'Количество одновременно выполняемых разовых задач. Если ограничение велико, то запланированные задачи могут выполняться не регулярно, когда есть много таких задач. Значение 0 полностью отключает обработку разовых задач.';
$string['task_adhoc_failed_retention'] = 'Срок хранения невыполненной разовой задачи';
$string['task_adhoc_failed_retention_desc'] = 'Максимальный срок, в течение которого невыполненные разовые задачи должны оставаться в очереди после достижения предела повторных попыток.';
$string['task_adhoc_max_runtime'] = 'Максимальное время выполнения разовой задачи';
$string['task_adhoc_max_runtime_desc'] = 'Время выполнения разовой задачи, прежде чем она будет сброшена. Рекомендуется низкая продолжительность, так как нет ограничений на количество разовых задач в очереди. Если это число слишком велико и имеется большая очередь разовых задач, то запланированные задачи могут выполняться нерегулярно.';
$string['task_dbreads'] = 'Чтение из базы данных';
$string['task_dbstats'] = 'Название базы данных';
$string['task_dbwrites'] = 'Запись в базу данных';
$string['task_duration'] = 'Продолжительность';
$string['task_endtime'] = 'Время завершения';
$string['task_logmode'] = 'Когда записывать события';
$string['task_logmode_all'] = 'Хранить записи событий всех задач';
$string['task_logmode_desc'] = 'Вы можете выбрать, когда вы хотите записывать события задач. По умолчанию события всегда записываются. Вы можете полностью отключить запись событий или выбрать только те события задач, которые имеют ошибки.';
$string['task_logmode_failonly'] = 'Хранить записи событий только для неудачных задач';
$string['task_logmode_none'] = 'Ничего не записывать';
$string['task_logoutput'] = 'Вывод задачи';
$string['task_logretainruns'] = 'Хранение запусков';
$string['task_logretainruns_desc'] = 'Количество запусков каждой задачи, которое необходимо сохранить. Этот параметр взаимодействует с параметром «Период хранения»: применяется то, что будет достигнуто первым.';
$string['task_logretention'] = 'Период хранения';
$string['task_logretention_desc'] = 'Максимальный период, в течение которого должны храниться записи событий. Этот параметр взаимодействует с параметром «Хранение запусков»: применяется то, что будет достигнуто первым';
$string['task_logtostdout'] = 'Отобразить вывод логов';
$string['task_logtostdout_desc'] = 'Когда задания выполняются и фиксируются выходные данные, следует ли также отображать полученный  при выполнении задачи результат.';
$string['task_result'] = 'Результат';
$string['task_result:failed'] = 'Тест не пройден';
$string['task_scheduled_concurrency_limit'] = 'Ограничение одновременно выполняемых запланированных задач';
$string['task_scheduled_concurrency_limit_desc'] = 'Число запусков запланированных задач, разрешенных для одновременного выполнения. Если лимит высокий, то сервер может испытывать высокую нагрузку, которая влияет на производительность. Значение 0 полностью отключает обработку запланированных задач.';
$string['task_scheduled_max_runtime'] = 'Продолжительность выполнения запланированной задачи';
$string['task_scheduled_max_runtime_desc'] = 'Время выполнения запланированной задачи до её прекращения.';
$string['task_starttime'] = 'Время начала';
$string['task_stats:dbreads'] = 'Чтение - {$a}';
$string['task_stats:dbwrites'] = 'Запись - {$a}';
$string['task_status'] = 'Состояние задачи';
$string['task_status_desc'] = 'Задача «{$a->name}»:  {$a->status}. Подробнее см. {$a->class}{$a->extradescription} в <a href="{$a->gotourl}">Расписании задач</a>.';
$string['task_type:adhoc'] = 'Разовая';
$string['task_type:scheduled'] = 'Запланированная';
$string['taskadmintitle'] = 'Задачи';
$string['taskanalyticscleanup'] = 'Очистка аналитики';
$string['taskautomatedbackup'] = 'Автоматическое резервное копирование';
$string['taskautomatedbackup_report'] = 'Отчет об автоматическом резервном копировании';
$string['taskbackupcleanup'] = 'Очистка таблиц, журналов и файлов резервного копирования';
$string['taskbadgesadhoc'] = 'Награждение значками';
$string['taskbadgescron'] = 'Добавить разовые задачи награждения значками';
$string['taskbadgesmessagecron'] = 'Фоновая обработка для отправки уведомлений о значках';
$string['taskblogcron'] = 'Синхронизация внешних блогов';
$string['taskcachecleanup'] = 'Удаление просроченных записей кэша';
$string['taskcachecron'] = 'Обработка кэша в фоновом режиме';
$string['taskcalendarcron'] = 'Рассылка уведомлений календаря';
$string['taskcheckforupdates'] = 'Проверка обновлений';
$string['taskcompletiondaily'] = 'Отметка завершения курса как начатого';
$string['taskcompletionregular'] = 'Расчет стандартных данных, связанных с завершением курса';
$string['taskcontextcleanup'] = 'Очистка контекстов';
$string['taskcreatecontexts'] = 'Создание недостающих контекстов';
$string['taskdeleteincompleteusers'] = 'Удаление пользователей с незаконченной регистрацией';
$string['taskdeleteunconfirmedusers'] = 'Удаление неподтвержденных пользователей';
$string['taskeventscron'] = 'Обработка событий в фоновом режиме';
$string['taskfiletrashcleanup'] = 'Очистка корзины';
$string['taskglobalsearchindex'] = 'Построение глобального поискового индекса';
$string['taskglobalsearchoptimize'] = 'Оптимизация глобального поискового индекса';
$string['taskgradecron'] = 'Обработка журнала оценок в фоновом режиме';
$string['taskgradehistorycleanup'] = 'Фоновая обработка для очистки таблиц истории оценок';
$string['taskh5pcleanup'] = 'Очистка неиспользуемых файлов H5P';
$string['tasklegacycron'] = 'Обработка cron для плагинов, использующих устаревший cron';
$string['tasklockcleanuptask'] = 'Очистить метаданные специальной задачи';
$string['tasklogcleanup'] = 'Очистка журналов событий задач';
$string['tasklogging'] = 'Настройка журнала событий задач';
$string['tasklogs'] = 'Журналы задач';
$string['taskmessagingcleanup'] = 'Обработка сообщений в фоновом режиме';
$string['taskpasswordresetcleanup'] = 'Сброс количества попыток ввода пароля';
$string['taskplagiarismcron'] = 'Запуск в фоновом режиме устаревшего cron для плагинов проверки на плагиат';
$string['taskportfoliocron'] = 'Обработка портфолио в фоновом режиме';
$string['taskprocessing'] = 'Обработка задач';
$string['taskquestioncron'] = 'Фоновый процесс для очистки предварительного просмотра вопросов';
$string['taskquestionstatscleanupcron'] = 'Фоновая очистка кэша статистики вопросов';
$string['taskrefreshsystemtokens'] = 'Обновить ключи OAuth для учетных записей служб';
$string['taskregistrationcron'] = 'Регистрация сайта';
$string['tasksendfailedloginnotifications'] = 'Отправка уведомлений о неудачных попытках входа в систему';
$string['tasksendnewuserpasswords'] = 'Рассылка паролей новым пользователям';
$string['tasksessioncleanup'] = 'Очистка устаревших сеансов';
$string['taskstatscron'] = 'Фоновый процесс сбора статистики';
$string['tasktagcron'] = 'Фоновая обработка тегов';
$string['tasktempfilecleanup'] = 'Удаление устаревших временных файлов';
$string['tasktype'] = 'Тип';
$string['taskupdategeoip2file'] = 'Обновить файл GeoIP';
$string['tempdatafoldercleanup'] = 'Очищать временные файлы старше чем';
$string['templates'] = 'Шаблоны';
$string['testoutgoingmailconf'] = 'Проверка настроек исходящей почты';
$string['testoutgoingmailconf_errorcommunications'] = 'Ваш сайт не может связаться с вашим почтовым сервером. Пожалуйста, проверьте настройки исходящей почты.';
$string['testoutgoingmailconf_fromemail'] = 'От имени пользователя или адреса электронной почты';
$string['testoutgoingmailconf_fromemail_help'] = 'Это поле имитирует отправку сообщения от этого пользователя, но заголовок From, используемый в реальном отправленном письме, будет зависеть от других настроек, таких как разрешенные почтовые домены (allowedemaildomains).';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Неверное имя пользователя или электронная почта отправителя. Должен быть использован действительный формат электронной почты или существующее имя пользователя в Moodle.';
$string['testoutgoingmailconf_message'] = 'Это тестовое сообщение, подтверждающее, что вы успешно настроили исходящую почту своего сайта.
Отправлено: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Отправить тестовое сообщение';
$string['testoutgoingmailconf_sentmail'] = 'Этот сайт успешно отправил тестовое сообщение на почтовый сервер.<br />От: {$a->fromemail}<br />На: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: тестовое сообщение. {$a->additional} Отправлено: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Дополнительная тема';
$string['testoutgoingmailconf_toemail'] = 'На адрес электронной почты';
$string['testoutgoingmaildetail'] = 'Примечание: Перед тестированием, пожалуйста, сохраните вашу конфигурацию.<br />{$a}';
$string['testsiteupgradewarning'] = 'Вы используете тестовый сайт {$a}, обновите его с помощью интерфейса командной строки';
$string['themedefinedinconfigphp'] = 'Тему нельзя изменить, поскольку в config.php для нее установлено значение {$a}.';
$string['themedesignermode'] = 'Режим дизайнера темы';
$string['themedesignermodewarning'] = 'Включен режим дизайнера темы. Данный режим не следует использовать на сайтах в промышленной эксплуатации, так как это может существенно снизить производительность.';
$string['themeeditsettingsname'] = 'Изменить настройки темы «{$a}»';
$string['themelist'] = 'Список тем';
$string['themeresetcaches'] = 'Очистить кэш тем';
$string['themeselect'] = 'Выбрать тему';
$string['themeselector'] = 'Темы';
$string['themesettingsadvanced'] = 'Расширенные настройки темы';
$string['themesettingscustom'] = 'Пользовательские настройки темы';
$string['themesettingsname'] = 'Настройки темы «{$a}»';
$string['themeusagereportname'] = 'Отчет об использовании темы «{$a}»';
$string['therewereerrors'] = 'В Ваших данных были ошибки';
$string['thirdpartylibrary'] = 'Библиотека';
$string['thirdpartylibrarylocation'] = 'Расположение';
$string['thirdpartylibs'] = 'Сторонние библиотеки';
$string['timezone'] = 'Часовой пояс по умолчанию';
$string['timezoneforced'] = 'Значение установлено администратором сайта';
$string['timezoneinvalid'] = 'Неверный часовой пояс «{$a}»';
$string['timezoneisforcedto'] = 'Принудительно установить всем пользователям';
$string['timezonenotforced'] = 'Пользователи могут выбирать свои собственные часовые пояса';
$string['timezonephpdefault'] = 'Часовой пояс PHP по умолчанию ({$a})';
$string['timezoneserver'] = 'Часовой пояс сервера ({$a})';
$string['tlswarning'] = 'Не обнаружено расширение PHP/cURL с поддержкой TLSv1.2. Некоторые службы могут не работать. Настоятельно рекомендуется обновить библиотеки TLS.';
$string['tokenduration'] = 'Срок действия ключа, созданного пользователем.';
$string['tokenduration_desc'] = 'Продолжительность времени, в течение которого действителен ключ веб-сервисов, созданный пользователем (например, с помощью мобильного приложения).';
$string['tokenizerrecommended'] = 'Установка расширения PHP Tokinizer рекомендуется для улучшения функционала Moodle Networking.';
$string['tools'] = 'Инструменты администрирования';
$string['toolsmanage'] = 'Управление инструментами администрирования';
$string['unattendedoperation'] = 'Автоматически продолжать без моего участия';
$string['unbookmarkthispage'] = 'Удалить закладку для этой страницы';
$string['unicoderequired'] = 'Требуется хранить все данные в кодировке Unicode (UTF-8). Новые установки должны производиться в базу данных с кодировкой по умолчанию UTF-8. При обновлении необходимо выполнить процесс преобразования в UTF-8.';
$string['uninstallplugin'] = 'Удалить';
$string['unlockaccount'] = 'Разблокировать учетную запись';
$string['unoconvwarning'] = 'Установленная версия unoconv не поддерживается. Для возможности оценивания заданий Moodle требуется версия 0.7 или выше.';
$string['unsupported'] = 'Не поддерживается';
$string['unsupporteddbfileformat'] = 'В вашей базе данных есть таблицы с использованием формата файла Antelope. Полная поддержка UTF-8 в MySQL и MariaDB требует формата файла Barracuda. Преобразуйте таблицы в формат файла Barracuda. Подробнее об инструменте преобразования таблиц InnoDB в Barracuda см. в документации <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">Полная поддержка unicode в MySQL</a>.';
$string['unsupporteddbfilepertable'] = 'Для полной поддержки UTF-8 MySQL и MariaDB требуется изменить настройку MySQL «innodb_file_per_table» на «ON». Дополнительную информацию см. в документации.';
$string['unsupporteddblargeprefix'] = 'Для полной поддержки UTF-8 MySQL и MariaDB требуется изменить настройку MySQL «innodb_large_prefix» на «ON». Дополнительную информацию см. в документации.';
$string['unsupporteddbstorageengine'] = 'Использовавшаяся СУБД больше не поддерживается.';
$string['unsupporteddbtablerowformat'] = 'Ваша база данных содержит таблицы, использующие формат файла Antelope. Рекомендуется преобразовать эти таблицы в формат файла Barracuda. Подробности об инструменте преобразования таблиц InnoDB в Barracuda смотрите в документации <a href="https://docs.moodle.org/en/cli">Administration via command line</a>.';
$string['unsupportedphpversion7'] = 'PHP версии 7 и выше не поддерживается.';
$string['unsupportedphpversion71'] = 'PHP версии 7.1 и выше не поддерживается.';
$string['unsupportedphpversion72'] = 'Версия PHP 7.2 и выше не поддерживается.';
$string['unsupportedphpversion73'] = 'PHP версии 7.3 и выше не поддерживается.';
$string['unsupportedphpversion74'] = 'Версия PHP 7.4 и выше не поддерживается.';
$string['unsupportedphpversion80'] = 'Версия PHP 8.0 и выше не поддерживается.';
$string['unsupportedphpversion81'] = 'Версия PHP 8.1 и выше не поддерживается.';
$string['unsupportedphpversion82'] = 'Версии PHP 8.2 и выше не поддерживаются.';
$string['unsupportedphpversion83'] = 'PHP версии 8.3 и выше не поддерживаются.';
$string['unsupportedphpversion84'] = 'PHP версии 8.4 и выше не поддерживаются.';
$string['unsuspenduser'] = 'Активировать учетную запись';
$string['updateaccounts'] = 'Обновить существующие учетные записи';
$string['updateautocheck'] = 'Автоматически проверять наличие обновлений';
$string['updateautocheck_desc'] = 'При включении этого параметра Ваш сайт будет автоматически проверять наличие обновлений системы Moodle и всех дополнительных модулей. При наличии обновления администраторам сайта будет разослано соответствующее уведомление.';
$string['updateavailable'] = 'Доступна более новая версия Moodle!';
$string['updateavailable_moreinfo'] = 'Подробнее ...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Версия {$a}';
$string['updateavailabledetailslink'] = 'Подробнее см. на {$a->url}';
$string['updateavailableforplugin'] = 'Доступны более новые версии некоторых из ваших плагинов!';
$string['updateavailableinstall'] = 'Установить это обновление';
$string['updateavailableinstallall'] = 'Установите доступные обновления  ({$a})';
$string['updateavailableinstallallhead'] = 'Установка доступных обновлений';
$string['updateavailablenot'] = 'У Вас установлена самая последняя версия Moodle!';
$string['updateavailablerecommendation'] = 'Настоятельно рекомендуется обновить ваш сайт до последней версии, чтобы получить все последние обновления безопасности и исправления ошибок.';
$string['updatecomponent'] = 'Обновить компонент';
$string['updateminmaturity'] = 'Требуемая стадия разработки';
$string['updateminmaturity_desc'] = 'Уведомлять только о тех обновлениях, стадия разработки которых не ниже указанной. Уведомления об обновлениях для тех плагинов, у которых не указана стадия разработки, выводятся всегда независимо от этого параметра.';
$string['updatenotificationfooter'] = 'Ваш сайт Moodle {$a->siteurl} настроен на автоматическую проверку обновлений. Вы получили это сообщение, потому что являетесь администратором сайта. Вы можете отключить автоматическую проверку обновлений (Администрирование - Сервер - Уведомления об обновлениях) или можете настроить способ доставки этого сообщения на странице настроек своего профиля.';
$string['updatenotifications'] = 'Уведомления об обновлениях';
$string['updatenotificationsubject'] = 'Доступны обновления Moodle ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Уведомлять о новых сборках';
$string['updatenotifybuilds_desc'] = 'При включении этого параметра уведомления будут рассылаться при выходе каждой новой сборки (build) Moodle. Сборки содержат постоянные улучшения текущей версии Moodle и обычно выходят каждую неделю. Если отключить этот параметр, то Вы будете уведомлены только при выходе следующей версии Moodle. Этот параметр не влияет на проверку версий плагинов.';
$string['upgradeerror'] = 'Неизвестная ошибка при обновлении модуля «{$a->plugin}» к версии {$a->version}; продолжение не возможно.';
$string['upgradeforumread'] = 'Новая функция была добавлена в Moodle 1.5 для отслеживания прочитанных/непрочитанных сообщений. <br /> Для использования этой функции необходимо <a href="{$a}"> обновить таблицы</a>.';
$string['upgradeforumreadinfo'] = 'Новая особенность была добавлена в Moodle 1.5, чтобы отслеживать прочитанную/непрочитанную почту форума. Чтобы использовать эту функцию, Вам нужно обновить свои таблицы со всей отслеживаемой информацией для существующей почты. В зависимости от размера Вашего сайта это может длиться длительное время (часы) и может быть весьма накладным для Вашей базы данных, так что это лучше делать в период небольшой активности пользователей. Тем не менее, Ваш сайт будет функционировать на протяжении этого обновления. Если Вы запускаете этот процесс, то должны позволить ему завершиться (удерживайте окно своего браузера открытым). Тем не менее, если Вы останавливаете процесс, закрывая окно, не беспокойтесь - Вы можете стартовать снова.<br /><br />Вы хотите сейчас запустить процесс обновления?';
$string['upgradekeyreq'] = 'Требуется ключ (пароль) обновления';
$string['upgradekeyset'] = 'Ключ обновления (оставьте пустым, если не хотите его задавать)';
$string['upgradelogs'] = 'Для полной функциональности необходимо преобразовать старые записи журнала событий. <a href="{$a}">Подробнее</a>';
$string['upgradelogsinfo'] = 'С системной информацией (logs) и ее записью могут происходить некоторые изменения. Для того, чтобы можно было просматривать все старые logs на основе per-activity basis, Ваши старые logs должны периодически обновляться. Это зависит от Вашего сайта и может занимать много времени (даже несколько часов), и Вы можете даже превысить допустимые пределы в БД для очень больших сайтов. Однако Вы должны запускать такой процесс  обновления системной информации и не прерывать его (не закрывать окна браузера) до полного окончания. Не волнуйтесь: во время такой работы сайт для других пользователей будет работать в обычном режиме. Вы хотите провести обновление системной информации (logs) прямо сейчас?';
$string['upgradepluginsfirst'] = 'Рекомендуется сначала установить все доступные обновления';
$string['upgradepluginsinfo'] = 'Обновление плагинов';
$string['upgradepluginsinfo_help'] = 'Есть доступные обновления для некоторых плагинов. Вы должны установить их все перед обновлением базы данных Moodle. Если сайт не поддерживает автоматическое развертывание обновлений, то Вы должны вручную загрузить и установить новые версии плагина на своем сервере.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Новые настройки';
$string['upgradesettingsintro'] = 'Настройки, показанные ниже, были добавлены во время последнего обновления Moodle. Внесите необходимые изменения в настройки по умолчанию, а затем нажмите кнопку «Сохранить изменения» в нижней части этой страницы.';
$string['upgradestalefiles'] = 'Обнаружено смешение версий Moodle, продолжение обновления невозможно.';
$string['upgradestalefilesinfo'] = 'Процесс обновления Moodle был приостановлен, потому что в каталоге Moodle были обнаружены скрипты, по меньшей мере, двух основных версий Moodle. В дальнейшем это может вызвать большие проблемы, поэтому для продолжения необходимо убедиться, что каталог Moodle содержит файлы только одной версии Moodle.

Рекомендуемый способ очистки каталога Moodle выглядит следующим образом:

* переименовать текущую директорию Moodle на «moodle_old»
* создать новую директорию Moodle, содержащую только файлы из репозитория GIT
* переместить исходный файл config.php и любые нестандартные плагины из каталога «moodle_old» в новый каталог Moodle.

После очистки каталога Moodle обновите страницу, чтобы возобновить процесс обновления Moodle.

Часто причиной этого предупреждения является распаковка стандартного пакета Moodle в предыдущую версию Moodle. Хотя это нормально для небольших модернизаций, она не рекомендуется для крупных обновлений Moodle.

Это предупреждение может быть вызвано и неполной проверкой или обновления из репозитория GIT, в этом случае Вы можете просто ждать завершения операции, или, возможно, отменить команду и повторить операцию.

Вы можете найти более подробную информацию по обновлению в документации <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Обновить Moodle';
$string['upgradesure'] = '<p>Файлы Moodle изменены, можно приступить к автоматическому обновлению сервера до следующей версии:</p>
<p><strong>{$a}</strong>.</p>
<p>Если Вы сделаете это, то не сможете вернуться назад. Учтите, что этот процесс может занимать много времени.</p>
<p>Вы уверены, что хотите обновить сервер до этой версии?</p>';
$string['upgradetimedout'] = 'Обновление прервано; пожалуйста, перезапустите обновление.';
$string['upgradingdata'] = 'Обновление данных';
$string['upgradinglogs'] = 'Журналы обновлений';
$string['upgradingversion'] = 'Обновление до новой версии';
$string['upwards'] = 'самая новая';
$string['useblogassociations'] = 'Включить ассоциации';
$string['user'] = 'Пользователь';
$string['userbulk'] = 'Действия над несколькими пользователями';
$string['userbulkdownload'] = 'Экспортировать пользователей как';
$string['userdefaultpreferences'] = 'Предпочтения пользователя по умолчанию';
$string['userfeedbackafterupgrade'] = 'После каждой смены версии';
$string['userfeedbackencouragement'] = '<p>Moodle включает функцию, которая дает пользователям возможность отправлять отзывы о системе Moodle через внешний сайт опроса, расположенный на сервере штаб-квартиры Moodle. При этом никакая идентифицирующая пользователя информация не передается на сайт опроса.</p>
<p>Штаб-квартира Moodle стремится быть открытой и прозрачной в отношении своих методов сбора данных. Таким образом, мы хотим убедиться, что вы осведомлены об этом и сами контролируете этот функционал.</p>
<p>Отзывы пользователей в значительной степени помогут штаб-квартире Moodle в улучшении программного обеспечения Moodle. Чтобы включить эту функцию, перейдите по ссылке <a href="{$a}">Настройки сбора отзывов</a>.</p>';
$string['userfeedbacknextreminder'] = 'Следующее напоминание про отзыв';
$string['userfeedbacknextreminder_desc'] = 'Когда нужно снова предложить пользователю отправить отзыв?';
$string['userfeedbackperiodically'] = 'Периодически';
$string['userfeedbackremindafter'] = 'Напоминать через';
$string['userfeedbackremindafter_desc'] = 'Напоминать пользователям про отзыв о программном обеспечении через указанное количество дней.';
$string['userfiltersdefault'] = 'Фильтры пользователей по умолчанию';
$string['userfiltersdefault_desc'] = 'Выберите фильтры, которые должны отображаться на странице «Массовые действия с пользователями». Удерживайте клавишу Ctrl, чтобы выбрать несколько элементов. Все фильтры, которые не выбраны, будут доступны при нажатии на ссылку «Показать больше».';
$string['userimagesdisabled'] = 'Изображения профилей пользователей отключены.';
$string['userlist'] = 'Список пользователей';
$string['usermanagement'] = 'Управление пользователями';
$string['userpolicies'] = 'Глобальные настройки пользователей';
$string['userpreference'] = 'Настройки пользователя';
$string['userquota'] = 'Квота пользователя';
$string['userquota_desc'] = 'Максимальное количество данных, которое пользователь может сохранить в своей личной файловой области.';
$string['users'] = 'Пользователи';
$string['usesitenameforsitepages'] = 'Использовать название сайта вместо «Страницы сайта»';
$string['usetags'] = 'Включить теги';
$string['validateemptylineerror'] = 'Пустые строки не допустимы';
$string['validateerror'] = 'Это значение не допустимо';
$string['validateerrorlist'] = 'Эти записи содержат ошибки: {$a}';
$string['validateiperror'] = 'Эти IP-адреса содержат ошибки: {$a}';
$string['verifychangedemail'] = 'Учитывать ограничения доменов при смене почты';
$string['warningcurrentsetting'] = 'Недопустимое текущее значение: {$a}';
$string['warningiconvbuggy'] = 'Ваша версия библиотеки Iconv не поддерживает модификатор //IGNORE. Вы должны установить расширение mbstring, которое может быть использовано для очистки строк, содержащих символы не UTF-8.';
$string['webproxy'] = 'Веб-прокси';
$string['webproxyinfo'] = 'Заполните следующие параметры, если Ваш сервер Moodle не может соединяться с Интернетом напрямую. Доступ в Интернет требуется для загрузки данных о контекстах, языковых пакетах, RSS-каналах, часовых поясах и т.д. <br /><em>Настоятельно рекомендуется расширение PHP cURL.</em>';
$string['xmlrpcwebserviceenabled'] = 'Обнаружено, что на вашем сайте включен протокол веб-службы XML-RPC. Эта функция зависит от расширения PHP XML-RPC, которое PHP больше не поддерживает.';
$string['yuicomboloading'] = 'Комбинированная загрузка YUI';
$string['ziprequired'] = 'Расширение PHP Zip теперь является обязательным для Moodle. Исполняемые файлы info-ZIP и библиотека PclZip больше не используются.';
