<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'ar', version '5.0'.
 *
 * @package     glossary
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcategory'] = 'إضافة تصنيف';
$string['addcomment'] = 'إضافة تعليق';
$string['addentry'] = 'إضافة مصطلح جديد';
$string['addingcomment'] = 'أضف تعليق';
$string['addsingleentry'] = 'إضافة مصطلح';
$string['alias'] = 'كلمة مفتاحية';
$string['aliases'] = 'الكلمة/الكلمات المفتاحية';
$string['aliases_help'] = 'يمكن أن يكون لكل مصطلح في قاموس المصطلحات قائمة مرتبطة من الكلمات المفتاحية (أو الأسماء المستعارة). إذا تم ربط المصطلح تلقائياً، فسيتم ربط الكلمات المفتاحية أيضاً بشكل تلقائي.

أدخل كل كلمة مفتاحية في سطر جديد (غير مفصولة بفوارز).';
$string['allcategories'] = 'كل التصانيف';
$string['allentries'] = 'الكل';
$string['allowcomments'] = 'السماح بالتعليقات على المصطلحات';
$string['allowcomments_help'] = 'عند تمكينه، سيتمكن كل المشاركين ممن لديهم صلاحية إنشاء التعليقات من إضافة تعليقات إلى مصطلحات قاموس المصطلحات.';
$string['allowduplicatedentries'] = 'تكرار المصطلحات مسموح';
$string['allowduplicatedentries_help'] = 'عند تمكينه، يمكن لمصطلحات متعددة أن يكون لها نفس تسمية المفهوم.';
$string['allowprintview'] = 'السماح بعرض الطباعة';
$string['allowprintview_help'] = 'عند تمكينه، سيتوفر لدى الطلاب رابط لنسخة ملائمة للطباعة من قاموس المصطلحات. هذا الرابط متوافر للمعلمين دائماً.';
$string['andmorenewentries'] = 'إضافة {$a} من المصطلحات الجديدة.';
$string['answer'] = 'الإجابة';
$string['approvaldisplayformat'] = 'تنسيق عرض المصادقة';
$string['approvaldisplayformat_help'] = 'عند المصادقة على فقرات قاموس المصطلحات قد ترغب بعرضه بتنسيق مختلف';
$string['approve'] = 'المصادقة';
$string['areaattachment'] = 'المرفقات';
$string['areaentry'] = 'التعاريف';
$string['areyousuredelete'] = 'هل أنت متأكد من رغبتك في حذف هذ المصطلح؟';
$string['areyousuredeletecomment'] = 'هل أنت متأكد من رغبتك في حذف هذا التعليق؟';
$string['areyousureexport'] = 'هل أنت متأكد من رغبتك في تصدير هذا المصطلح إلى';
$string['ascending'] = 'تصاعدي';
$string['attachment'] = 'المرفق';
$string['attachment_help'] = 'يمكنك اختيارياً إرفاق ملف واحد أو أكثر بمصطلح القاموس.';
$string['author'] = 'الكاتب';
$string['authorview'] = 'الاستعراض حسب الكاتب';
$string['back'] = 'عودة';
$string['cachedef_concepts'] = 'ربط المفهوم';
$string['cantinsertcat'] = 'لا يمكن إدراج التصنيف';
$string['cantinsertrec'] = 'تعذر إدراج السجل';
$string['cantinsertrel'] = 'تعذر إدراج العلاقة الفئة-المصطلح';
$string['casesensitive'] = 'هذا المصطلح يتحسس حالة الأحرف';
$string['casesensitive_help'] = 'هذا الإعداد يحدد فيما إذا كان ضرورياً مطابقة حالة الأحرف الصغيرة والكبيرة عند الربط التلقائي مع المصطلح.';
$string['cat'] = 'التصنيف';
$string['categories'] = 'التصنيفات';
$string['category'] = 'التصنيف';
$string['categorydeleted'] = 'تم حذف التصنيف';
$string['categoryview'] = 'استعرض حسب التصنيف';
$string['changeto'] = 'التغيير إلى {$a}';
$string['cnfallowcomments'] = 'حدد ما إذا كان يُسمح إفتراضياً بالتعليقات على مصطلحات القاموس';
$string['cnfallowdupentries'] = 'حدد ما إذا كان يُسمح إفتراضياً بتكرار مصطلحات القاموس';
$string['cnfapprovalstatus'] = 'حدد إفتراضياً حالة الموافقة على المصطلح المقدم من الطالب';
$string['cnfcasesensitive'] = 'حدد فيما إذا كان المصطلح عند ربطه يتحسس حالة الأحرف إفتراضياً';
$string['cnfdefaulthook'] = 'إختر المجموعة الافتراضية التي ستظهر عند عرض قاموس المصطلحات لأول مرة';
$string['cnfdefaultmode'] = 'إختر الإطار الافتراضي الذي سيظهر عند عرض قاموس المصطلحات لأول مرة';
$string['cnffullmatch'] = 'حدد ما إذا كان يجب مطابقة الكلمات الكاملة للمصطلح عند ربطه بالنص المقصود (وليس مطابقة كلمات ضمن كلمات أخرى) إفتراضياً.';
$string['cnflinkentry'] = 'حدد ما إذا كان ينبغي إفتراضياً ربط المصطلح بشكل تلقائي';
$string['cnflinkglossaries'] = 'حدد ما إذا كان ينبغي إفتراضياً ربط قاموس المصطلحات بشكل تلقائي';
$string['cnfrelatedview'] = 'حدد تنسيق العرض الذي سيستعمل للربط التلقائي ومعاينة المصطلح.';
$string['cnfshowgroup'] = 'حدد ما إذا كان تجزئة المجموعات ستظهر ام لا.';
$string['cnfsortkey'] = 'حدد إفتراضياً مفتاح الفرز.';
$string['cnfsortorder'] = 'حدد افتراضيا ترتيب الفرز';
$string['cnfstudentcanpost'] = 'حدد افتراضيا امكانية الطلاب من تقديم المصطلاحات أو عدم إمكانيتهم';
$string['cnftabs'] = 'إختر التبويبات المرئية لهذا التنسيق من قاموس المصطلحات';
$string['comment'] = 'التعليق';
$string['commentdeleted'] = 'تم حذف التعليق.';
$string['comments'] = 'التعليقات';
$string['commentson'] = 'التعليقات على';
$string['commentupdated'] = 'تم تحديث التعليق';
$string['completiondetail:entries'] = 'تقديم المصطلحات: {$a}';
$string['completionentries'] = 'إضافة المصطلحات';
$string['completionentriesdesc'] = 'ينبغي على الطلبة إنشاء {$a} مصطلح/مصطلحات على الأقل';
$string['concept'] = 'المفهوم';
$string['concepts'] = 'المفاهيم';
$string['configenablerssfeeds'] = 'هذا المفتاح سيسمح بإمكانية وضع خدمة التغذية الإخبارية في جميع المسارد. مع ذلك، سينبغي عليك تمكين تلك التغذيات يدوياً في كل مسرد من خلال إعداداته.';
$string['current'] = 'حالياً مفروز {$a}';
$string['currentglossary'] = 'قاموس المصطلحات الحالي';
$string['date'] = 'التاريخ';
$string['dateview'] = 'استعراض حسب التاريخ';
$string['defaultapproval'] = 'مصادق عليه إفتراضياً';
$string['defaultapproval_help'] = 'عند ضبطه على لا، ستتطلب المصطلحات المصادقة عليها من قبل المعلم قبل جعلها مرئية للجميع.';
$string['defaulthook'] = 'الواصل الافتراضي';
$string['defaultmode'] = 'النمط الافتراضي';
$string['defaultsortkey'] = 'مفتاح الفرز الافتراضي';
$string['defaultsortorder'] = 'اتجاه الفرز الافتراضي';
$string['definition'] = 'التعريف';
$string['definitions'] = 'التعاريف';
$string['deletecategory'] = 'حذف التصنيف';
$string['deleteentry'] = 'حذف المصطلح';
$string['deleteentrya'] = 'حذف المصطلح: {$a}';
$string['deletenotenrolled'] = 'مصطلحات المستخدمين غير المنضمين';
$string['deletingcomment'] = 'حذف التعليق';
$string['deletingnoneemptycategory'] = 'حذف هذا التصنيف لن يحذف المصطلحات التي يحتويها ـ سيشار إلى هذه المصطلحات على أنها لا تنتمي إلى تصنيف.';
$string['descending'] = 'تنازلي';
$string['destination'] = 'مقصد المصطلحات المستوردة';
$string['destination_help'] = 'يمكن استيراد المصطلحات إما إلى قاموس المصطلحات الحالي أو إلى قاموس جديد، وعندها سيتم إنشاء قاموس آخر بناءً على المعلومات في ملف XML.';
$string['disapprove'] = 'إلغاء الموافقة';
$string['displayformat'] = 'تنسيق العرض';
$string['displayformat_help'] = 'هناك 7 تنسيقات للعرض:

* بسيط، نمط القاموس - لا يتم عرض الكُتَّاب والمرفقات تظهر بشكل روابط
* مستمر بدون الكاتب - تظهر المصطلحات واحدة تلو الأخرى بدون الفصل ما بينها وبين أيقونات التحرير
* كامل مع الكاتب - تنسيق عرض مشابه للمنتدى حيث يتم عرض بيانات الكاتب مع إظهار المرفقات بشكل روابط
* كامل بدون الكاتب - تنسيق عرض مشابه للمنتدى بدون عرض الكاتب مع إظهار المرفقات بشكل روابط
* موسوعة - كما في "كامل مع الكاتب" لكن مع إظهار الصور المرفقة مع النص
* قائمة مصطلحات - المفاهيم تُدرج كروابط
* أسئلة شائعة - يتم إلحاق كلمتي سؤال وجواب إلى المفهوم والتعريف على التوالي';
$string['displayformatcontinuous'] = 'مستمر بدون الكاتب';
$string['displayformatdefault'] = 'إفتراضياً كما هو تنسيق العرض';
$string['displayformatdictionary'] = 'نمط قاموسي بسيط';
$string['displayformatencyclopedia'] = 'دائرة معارف';
$string['displayformatentrylist'] = 'قائمة مصطلحات';
$string['displayformatfaq'] = 'الأسئلة الشائعة';
$string['displayformatfullwithauthor'] = 'كامل مع الكاتب';
$string['displayformatfullwithoutauthor'] = 'كامل بدون الكاتب';
$string['displayformats'] = 'تنسيقات العرض';
$string['displayformatssetup'] = 'إعداد تنسيقات العرض';
$string['duplicatecategory'] = 'تكرار التصنيف';
$string['duplicateentry'] = 'تكرار المصطلح';
$string['editalways'] = 'إسمح دائماً بالتحرير';
$string['editalways_help'] = 'هذا الإعداد يحدد فيما إذا كانت المصطلحات قابلة للتحرير دائماً أو أن الطلبة يمكنهم فقط تحرير مصطلحاتهم خلال فترة السماح بالتحرير (عادة 30 دقيقة).';
$string['editcategories'] = 'تحرير التصنيفات';
$string['editcategory'] = 'تحرير التصنيف';
$string['editentry'] = 'تحرير المصطلح';
$string['editentrya'] = 'تحرير المصطلح: {$a}';
$string['editingcomment'] = 'تحرير التعليق';
$string['entbypage'] = 'عدد المصطلحات المعروضة في كل صفحة';
$string['entries'] = 'المصطلحات';
$string['entrieswithoutcategory'] = 'مصطلحات بلا تصنيف';
$string['entry'] = 'المصطلح';
$string['entryalreadyexist'] = 'هذا المصطلح موجود مسبقاً';
$string['entryapproved'] = 'تم الموافقة على هذا المصطلح';
$string['entrydeleted'] = 'تم حذف المصطلح';
$string['entryexported'] = 'تم تصدير المصطلح بنجاح';
$string['entryishidden'] = '(هذا المصطلح مخفي حالياً)';
$string['entryleveldefaultsettings'] = 'الإعداد الإفتراضي للمصطلح';
$string['entrylink'] = 'رابط المصطلح: {$a}';
$string['entrynotapproved'] = 'المصطلح غير مصادق عليه';
$string['entrysaved'] = 'تم حفظ هذا المصطلح';
$string['entryupdated'] = 'تم تحديث هذا المصطلح';
$string['entryusedynalink'] = 'ينبغي ربط هذا المصطلح تلقائياً';
$string['entryusedynalink_help'] = 'إذا تم تمكين الربط التلقائي للقاموس على مستوى عموم الموقع من قبل المشرف وتم تأشير هذه الخانة، سيتم ربط المصطلح تلقائياً أينما ظهرت كلمات المفهوم وعباراته في باقي أرجاء المقرر.';
$string['errcannoteditothers'] = 'لا يمكنك تحرير مصطلحات الآخرين.';
$string['errconceptalreadyexists'] = 'هذا المصطلح موجود مسبقاً. لا يمكن التكرار في هذا القاموس';
$string['errdeltimeexpired'] = 'لا يمكنك حذفه. الوقت انتهى!';
$string['erredittimeexpired'] = 'لقد انتهت مهلة تحرير هذا المصطلح.';
$string['errorparsingxml'] = '‏‏وقع خطأ أثناء تحليل الملف. تأكد أنه بصياغة XML صحيحة.';
$string['errreservedkeywords'] = 'كلمة مرور واحدة أو أكثر تحتوي على حروف خاصة لا يمكن استعمالها.';
$string['eventcategorycreated'] = 'تصنيف تم إنشاؤه';
$string['eventcategorydeleted'] = 'تصنيف تم حذفه';
$string['eventcategoryupdated'] = 'تصنيف تم تحديثه';
$string['evententryapproved'] = 'مصطلح تمت المصادقة عليه';
$string['evententrycreated'] = 'مصطلح تم إنشاؤه';
$string['evententrydeleted'] = 'مصطلح تم حذفه';
$string['evententrydisapproved'] = 'مصطلح تم إلغاء المصادقة عليه';
$string['evententryupdated'] = 'مصطلح تم تحديثه';
$string['evententryviewed'] = 'مصطلح تمت معاينته';
$string['explainaddentry'] = 'أضف مصطلحًا جديدًا إلى قاموس المصطلحات الحالي.<br /> حقلا المفهوم والتعريف إجباريان.';
$string['explainall'] = 'عرض كل المصطلحات في صفحة واحدة';
$string['explainalphabet'] = 'استعراض قاموس المصطلحات باستعمال الفهرس';
$string['explainexport'] = 'أنقر على الزر أدناه لتصدير مصطلحات القاموس.
يمكنك استيراده في أي وقت تشاء إلى هذا المقرر أو لغيره.<p>لطفاً، لاحظ أن المرفقات (أي الصور) والكتاب لم يتم استيرادها.</p>';
$string['explainimport'] = 'ينبغي عليك تحديد ملف الاستيراد وتعريف معايير العملية.<p>سلم طلبك وقم بمراجعة النتائج.</p>';
$string['explainspecial'] = 'إظهار المصطلحات التى لا تبدأ بحرف';
$string['export'] = 'تصدير';
$string['exportedentry'] = 'مصطلح مُصدَّر';
$string['exportentries'] = 'تصدير المصطلحات';
$string['exportentriestoxml'] = 'تصدير المصطلحات إلى ملف بصيغة XML';
$string['exportfile'] = 'تصدير المصطلحات إلى ملف';
$string['exportglossary'] = 'صدر قاموس المصطلحات';
$string['exporttomainglossary'] = 'التصدير إلى قاموس المصطلحات الرئيسي';
$string['filetoimport'] = 'الملف المراد استيراده';
$string['filetoimport_help'] = 'استعرض حاسبتك للوصول إلى ملف XML الذي يحتوي على المصطلحات المطلوب استيرادها.';
$string['fillfields'] = 'حقول المفهوم والتعريف اجبارية';
$string['filtername'] = 'الربط التلقائي لقاموس المصطلحات';
$string['fullmatch'] = 'مقارنة الكلمات بالكامل فقط';
$string['fullmatch_help'] = 'هذا الإعداد يحدد فيما إذا كان ينبغي ربط الكلمات الكاملة فقط، على سبيل المثال، مصطلح القاموس المسمى "construct" لن ينشئ رابطاً داخل الكلمة "constructivism".';
$string['glossary:addinstance'] = 'إضافة قاموس مصطلحات جديد';
$string['glossary:approve'] = 'المصادقة وإلغاء المصادقة على المصطلحات';
$string['glossary:comment'] = 'إنشاء التعليقات';
$string['glossary:export'] = 'تصدير المصطلحات';
$string['glossary:exportentry'] = 'تصدير مصطلح منفرد';
$string['glossary:exportownentry'] = 'تصدير مصطلح منفرد مما هو لك';
$string['glossary:import'] = 'استيراد المصطلحات';
$string['glossary:managecategories'] = 'إدارة التصنيفات';
$string['glossary:managecomments'] = 'إدارة التعليقات';
$string['glossary:manageentries'] = 'إدارة المصطلحات';
$string['glossary:rate'] = 'تقييم المصطلحات';
$string['glossary:view'] = 'معانية القاموس';
$string['glossary:viewallratings'] = 'معاينة كل التقييمات الخام المقدمة من قبل الأفراد';
$string['glossary:viewanyrating'] = 'معاينة إجمالي التقييمات التي تلقاها كل شخص';
$string['glossary:viewrating'] = 'معاينة إجمالي التقييم الذي تلقاه';
$string['glossary:write'] = 'إنشاء مصطلحات جديدة';
$string['glossaryleveldefaultsettings'] = 'الإعدادات الإفتراضية على مستوى القاموس';
$string['glossarytype'] = 'نوع قاموس المصطلحات';
$string['glossarytype_help'] = 'القاموس الرئيسي هو القاموس الذي يمكن استيراد المصطلحات إليه من القواميس الثانوية. يمكن أن يكون هناك قاموس رئيسي واحد في المقرر. إذا لم تكن هناك حاجة لاستيراد المصطلحات، يمكن جعل كل القواميس في المقرر ثانوية.';
$string['guestnoedit'] = 'الضيوف لا يسمح لهم بتحرير المسارد';
$string['importcategories'] = 'استيراد التصنيفات';
$string['importedcategories'] = 'التصنيفات المستوردة';
$string['importedentries'] = 'المصطلحات المستوردة';
$string['importentries'] = 'استيراد المصطلحات';
$string['importentriesfromxml'] = 'استيراد المصطلحات من ملف XML';
$string['includegroupbreaks'] = 'تضمين فواصل المجموعات';
$string['indicator:cognitivedepth'] = 'القاموس المعرفي';
$string['indicator:cognitivedepth_help'] = 'هذا المؤشر مبني على عمق الحالة المعرفية التي وصلها الطالب في نشاط القاموس.';
$string['indicator:cognitivedepthdef'] = 'القاموس المعرفي';
$string['indicator:cognitivedepthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة المعرفية التي وفرتها نشاطات قاموس المصطلحات خلال فترة التحليل هذه (المستويات = لا معاينة، معاينة، تقديم)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'قاموس اجتماعي';
$string['indicator:socialbreadth_help'] = 'هذا المؤشر مبني على عمق التوسع الاجتماعي الذي وصله الطالب في نشاط قاموس المصطلحات.';
$string['indicator:socialbreadthdef'] = 'قاموس اجتماعي';
$string['indicator:socialbreadthdef_help'] = 'لقد وصل المشارك إلى هذه النسبة المئوية من المشاركة الاجتماعية التي وفرتها نشاطات قاموس المصطلحات خلال فترة التحليل هذه (المستويات = لا مشاركة، المشاركة منفرداً)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['isglobal'] = 'هل هذا القاموس عمومي؟';
$string['isglobal_help'] = 'القاموس العمومي فيه مصطلحات يُرتبط بها من أرجاء الموقع بدلاً من مجرد المقرر الذي يتواجد فيه القاموس. المشرفون وحدهم يمكنهم جعل القاموس عمومياً.';
$string['letter'] = 'حرف';
$string['linkcategory'] = 'أربط هذا التصنيف تلقائياً';
$string['linkcategory_help'] = 'إذا تم تمكين الربط التلقائي مع تمكين هذا الإعداد، سيتم ربط اسم التصنيف تلقائياً حيثما يظهر في أرجاء المقرر. عندما ينقر المشارك على رابط اسم التصنيف، سينتقل إلى صفحة "الاستعراض حسب التصنيف" في قاموس المصطلحات.';
$string['linking'] = 'ربط تلقائي';
$string['mainglossary'] = 'قاموس مصطلحات رئيسي';
$string['maxtimehaspassed'] = 'عذراَ، انتهى الوقت الاقصى لتحرير ({$a}) هذا التعليق';
$string['modulename'] = 'قاموس المصطلحات';
$string['modulename_help'] = 'إن وحدة نشاط قاموس المصطلحات تُمَكن المشاركين من إنشاء وإدامة قائمة من التعاريف كما في المعجم أو جمع وتنظيم الموارد أو المعلومات.

يمكن للمعلم السماح بإرفاق الملفات بمصطلحات القاموس. الصور المرفقة يتم عرضها مع المصطلح. يمكن البحث في المصطلحات أو استعراضها هجائياً أو حسب التصنيف، التاريخ أو الكاتب. يمكن جعل المصطلحات خاضعة لمصادقة المعلم لكي يتم عرضها للجميع أو متاحة تلقائياً دون الحاجة إلى مصادقة.

إذا تم تمكين الربط التلقائي للقاموس، سيتم ربط المصطلحات تلقائياً حيثما ظهرت كلمات و/أو عبارات المفاهيم ضمن المقرر.

يمكن للمعلم السماح بالتعليقات على المصطلحات. كذلك يمكنه إتاحة المصطلحات للتقييم من قبله أو من قبل الطلاب (التقييم المناظر). يمكن تجميع التقييمات للخروج بدرجة نهائية يتم توثيقها في سجل التقديرات.

للقواميس استعمالات عديدة، منها:

* بنك تعاوني لمصطلحات أساسية
* فضاء \'تعرف عليَّ\' حيث يضع الطلبة أسماءهم وتفاصيل عن شخصياتهم
* مورد لـ \'تلميحات مفيدة\' لأفضل الممارسات في موضوع عملي
* منطقة مشاركة لملفات مفيدة من فيديو وصور وأصوات
* مورد لمراجعة الحقائق واستذكارها';
$string['modulename_link'] = 'mod/glossary/view';
$string['modulenameplural'] = 'مسارد';
$string['newentries'] = 'مصطلحات القاموس الجديدة';
$string['newglossary'] = 'قاموس مصطلحات جديد';
$string['newglossarycreated'] = 'تم إنشاء قاموس مصطلحات جديد.';
$string['newglossaryentries'] = 'مصطلحات قاموس جديدة:';
$string['nocomment'] = 'لم يتم العثور على تعليق';
$string['nocomments'] = '(لم يتم العثور على تعليقات على هذا المصطلح)';
$string['noconceptfound'] = 'لم يتم العثور على أي تعريف أو مفهوم.';
$string['noentries'] = 'لم يتم العثور على مصطلحات في هذ القسم';
$string['noentry'] = 'لم تم العثور على أى مصطلح';
$string['nopermissiontodelcomment'] = 'لا يمكنك حذف تعليقات الآخرين!';
$string['nopermissiontodelinglossary'] = 'لا يمكنك إضافة تعليقات في هذا القاموس!';
$string['nopermissiontoviewresult'] = 'يمكنك فقط النظر في النتائج المتعلقة بمصطلحاتك';
$string['notapproved'] = 'لم تتم المصادقة على المصطلح بعد.';
$string['notcategorised'] = 'لم يتم تصنيفها';
$string['numberofentries'] = 'عدد المصطلحات';
$string['onebyline'] = '(واحدة في السطر)';
$string['page-mod-glossary-edit'] = 'صفحة إضافة/تحرير مصطلح القاموس';
$string['page-mod-glossary-view'] = 'معاينة صفحة تحرير قاموس المصطلحات';
$string['page-mod-glossary-x'] = 'أي صفحة لوحدة القاموس';
$string['pendingapproval'] = 'ينتظر الموافقة';
$string['pendingapprovalcount'] = 'بانتظار الموافقة ({$a})';
$string['pluginadministration'] = 'إدارة قاموس المصطلحات';
$string['pluginname'] = 'قاموس المصطلحات';
$string['popupformat'] = 'شكل الانبثاق';
$string['print'] = 'طباعة';
$string['printerfriendly'] = 'نسخة سهلة الطباعة';
$string['printviewnotallowed'] = 'معاينة الطباعة غير متاحة';
$string['privacy'] = 'خصوصية النتائج';
$string['privacy:metadata:core_comments'] = 'التعليقات المسجلة على تعاريف قاموس المصطلحات يتم خزنها باستعمال نظام التعليقات المركزي';
$string['privacy:metadata:core_files'] = 'الملفات المرتبطة بتعاريف قاموس المصطلحات يتم خزنها باستعمال نظام الملفات المركزي';
$string['privacy:metadata:core_rating'] = 'التقييمات المضافة إلى تعاريف قاموس المصطلحات يتم خزنها باستعمال نظام التقييم المركزي';
$string['privacy:metadata:core_tag'] = 'الوسوم المضافة إلى تعاريف قاموس المصطلحات يتم خزنها باستعمال نظام الوسوم المركزي';
$string['privacy:metadata:glossary_entries'] = 'معلومات عن مصطلحات المستخدم في نشاط قاموس معين';
$string['privacy:metadata:glossary_entries:attachment'] = 'مرفق المصطلح الذي أضافه المستخدم';
$string['privacy:metadata:glossary_entries:concept'] = 'مفهوم المصطلح الذي أضافه المستخدم';
$string['privacy:metadata:glossary_entries:definition'] = 'تعريف المصطلح الذي أضافه المستخدم';
$string['privacy:metadata:glossary_entries:glossaryid'] = 'مُعرَّف نشاط قاموس المصطلحات';
$string['privacy:metadata:glossary_entries:timemodified'] = 'الطابع الزمني الذي يشير إلى وقت تعديل المصطلح من قبل المستخدم';
$string['privacy:metadata:glossary_entries:userid'] = 'مُعرَّف المستخدم الذي أضاف هذا المصطلح';
$string['question'] = 'السؤال';
$string['rejectedentries'] = 'المصطلحات المرفوضة';
$string['rejectionrpt'] = 'تقرير الرفض';
$string['removeallglossarytags'] = 'كل وسوم قاموس المصطلحات';
$string['resetglossaries'] = 'إحذف المصطلحات من';
$string['resetglossariesall'] = 'المصطلحات من كل المسارد';
$string['rssarticles'] = 'عدد المقالات الأخيرة في خدمة مغذي الأخبار';
$string['rssarticles_help'] = 'هذا الإعداد يحدد عدد مفاهيم مصطلحات قاموس المصطلحات التي ينبغي تضمينها في خدمة مغذي الأخبار. العدد المقبول عادة يتراوح ما بين 5 و 20.';
$string['rssfeed'] = 'التغذية الأخبارية';
$string['rsssubscriberss'] = 'عرض خدمة تغذية الأخبار لمفاهيم \'{$a}\'';
$string['rsstype'] = 'مغذي خدمة الأخبار لهذا النشاط';
$string['rsstype_help'] = 'لتمكين مغذي خدمة الأخبار لهذا النشاط، إختر ما بين المفاهيم مع الكتاب أو المفاهيم بدون الكتاب ليتم تضمينها في المغذي.';
$string['search:activity'] = 'قاموس المصطلحات - معلومات النشاط';
$string['search:entry'] = 'القاموس - المصطلحات';
$string['searchindefinition'] = 'بحث نصي كامل';
$string['secondaryglossary'] = 'قاموس مصطلحات ثانوي';
$string['showall'] = 'أظهر رابط \'الكل\'';
$string['showall_help'] = 'عند تمكينه، سيتمكن المشاركون من استعراض كل المصطلحات مرة واحدة.';
$string['showalphabet'] = 'أظهر الروابط الهجائية';
$string['showalphabet_help'] = 'عند تمكينه، سيتمكن المشاركون من استعراض قاموس المصطلحات حسب الأحرف الهجائية.';
$string['showspecial'] = 'أظهر رابط \'الخاص\'';
$string['showspecial_help'] = 'عند تمكينه، سيتمكن المشاركون من استعراض قاموس المصطلحات حسب الرموز الخاصة، مثل @ و #.';
$string['sortby'] = 'الفرز حسب';
$string['sortbycreation'] = 'حسب تاريخ الانشاء';
$string['sortbylastupdate'] = 'حسب آخر تحديث';
$string['sortchronogically'] = 'رتب تاريخياً';
$string['special'] = 'خاص';
$string['standardview'] = 'استعرض أبجدياً';
$string['studentcanpost'] = 'الطلاب يمكنهم إضافة المصطلحات';
$string['tagarea_glossary_entries'] = 'مصطلحات القاموس';
$string['tagsdeleted'] = 'تم حذف وسوم قاموس المصطلحات';
$string['totalentries'] = 'إجمالي المصطلحات';
$string['usedynalink'] = 'ربط مصطلحات القاموس تلقائياً';
$string['usedynalink_help'] = 'إذا تم تمكين الربط التلقائي لقاموس المصطلحات على مستوى عموم الموقع من قبل المشرف مع تمكين هذا الإعداد، سيتضمن نموذج "أضف مصطلحاً جديداً" خيار ربطه تلقائياً حيثما ظهرت كلمات أو عبارات المصطلح في باقي أرجاء المقرر.';
$string['visibletabs'] = 'التبويبات المرئية';
$string['warningstudentcapost'] = '(ينطبق فقط إذا لم يكن قاموس المصطلحات هو القاموس الرئيسي)';
$string['withauthor'] = 'المفاهيم مع الكاتب';
$string['withoutauthor'] = 'المفاهيم بدون الكاتب';
$string['writtenby'] = 'بواسطة';
$string['youarenottheauthor'] = 'أنت لست كاتب هذا التعليق، لذا ليس مسموحًا لك بتحريره.';
