<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'cs', version '5.0'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = 'Přijímám <a href=":url" target="_blank"> podmínky použití </a>';
$string['accountdetailslinktext'] = 'zde';
$string['action'] = 'Akce';
$string['add'] = 'Přidat';
$string['addedandupdatedpp'] = 'Přidány {$a->%new} nové knihovny H5P a aktualizovány staré {$a->%old}.';
$string['addedandupdatedps'] = 'Přidány {$a->%new} nové knihovny H5P a aktualizovány staré {$a->%old}.';
$string['addedandupdatedsp'] = 'Přidány {$a->%new} nové knihovny H5P a aktualizovány staré {$a->%old}.';
$string['addedandupdatedss'] = 'Přidány {$a->%new} nové knihovny H5P a aktualizovány staré {$a->%old}.';
$string['addednewlibraries'] = 'Přidány {$a->%new} nové knihovny H5P.';
$string['addednewlibrary'] = 'Přidány {$a->%new} nové knihovny H5P.';
$string['additionalinfo'] = 'Další informace';
$string['additionallicenseinfo'] = 'Další informace o licenci';
$string['addlibraries'] = 'Přidat knihovny';
$string['address'] = 'Adresa';
$string['age'] = 'Typický věk';
$string['agedescription'] = 'Cílová skupina tohoto obsahu. Možné vstupní formáty oddělené čárkami: „1, 34-45, -50, 59-“.';
$string['ajaxfailed'] = 'Načtení dat se nezdařilo.';
$string['alttext'] = 'Alternativní text';
$string['anunexpectedsave'] = 'Stalo se něco neočekávaného. Tento obsah se nepodařilo uložit.';
$string['assistivetechnologieslabel'] = 'Popisek pomocné technologie';
$string['attribution'] = 'Uvedení zdroje 4.0';
$string['attributionnc'] = 'Uvedení zdroje - nekomerční použití 4.0';
$string['attributionncnd'] = 'Uvedení autora - nekomerční použití - NoDerivs 4.0';
$string['attributionncsa'] = 'Uvedení autora - nekomerční užití - jako 4.0';
$string['attributionnd'] = 'Uvedení autora-NoDerivs 4.0';
$string['attributionsa'] = 'Uvedení autora-jako 4.0';
$string['author'] = 'Autor';
$string['authorcomments'] = 'Komentáře autora';
$string['authorcommentsdescription'] = 'Komentáře pro editora obsahu (Tento text nebude zveřejněn jako součást informací o autorských právech)';
$string['authorname'] = 'Jméno autora';
$string['authorrole'] = 'Role autora';
$string['back'] = 'Zpět';
$string['by'] = 'od';
$string['cancel'] = 'Zrušit';
$string['cancellabel'] = 'Zrušit';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = 'Ne';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = 'Ano';
$string['cancelpublishconfirmationdialogdescription'] = 'Opravdu chcete zrušit proces sdílení?';
$string['cancelpublishconfirmationdialogtitle'] = 'Zrušit sdílení';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution-NonCommercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribution-NonCommercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribution-NonCommercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribution-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['ccpdm'] = 'Public Domain Mark (PDM)';
$string['changedby'] = 'Změnil';
$string['changedescription'] = 'Popis změny';
$string['changehasbeensubmitted'] = 'Byla odeslána změna pro';
$string['changelog'] = 'Seznam změn';
$string['changeplaceholder'] = 'Oříznutí fotografie, změněný text atd.';
$string['city'] = 'Město';
$string['close'] = 'Zavřít';
$string['completionpass'] = 'Vyžadovat získání známky';
$string['completionpass_help'] = 'Pokud je povoleno, považuje se tato aktivita za dokončenou, když student získá požadovanou známku (jak je uvedeno v části Hodnocení v nastavení aktivity H5P) nebo vyšší.';
$string['completionpassdesc'] = 'K dokončení této činnosti musí student získat známku';
$string['confirmdialogbody'] = 'Potvrďte, že chcete pokračovat. Tato akce není vratná.';
$string['confirmdialogheader'] = 'Potvrdit akci';
$string['confirmlabel'] = 'Potvrdit';
$string['connectionlost'] = 'Připojení ztraceno. Výsledky budou uloženy a odeslány po obnovení připojení.';
$string['connectionreestablished'] = 'Připojení bylo obnoveno.';
$string['contactperson'] = 'Kontaktní osoba';
$string['contactpersondescription'] = 'H5P se obrátí na kontaktní osobu v případě, že dojde k problémům s obsahem sdíleným vydavatelem. Jméno kontaktní osoby ani další informace nebudou zveřejněny ani sdíleny s třetími stranami';
$string['contentavailable'] = 'Váš obsah bude obvykle k dispozici v Hubu do jednoho pracovního dne.';
$string['contentchanged'] = 'Tento obsah se od posledního použití změnil.';
$string['contentcopied'] = 'Obsah je zkopírován do schránky';
$string['contenthub:changesettings'] = 'Nastavení účtu můžete změnit <a href="{$a}"> zde </a>';
$string['contenthub:licenseagreementdescription'] = 'Než budete pokračovat v, přečtěte si následující smlouvu';
$string['contenthub:licenseagreementmaintext'] = 'UDĚLAT';
$string['contenthub:licenseagreementtitle'] = 'End User License Agreement (EULA)';
$string['contenthub:nopermissions'] = 'Nemáte oprávnění registrovat web v HUBu.';
$string['contenthub:register'] = 'Zaregistrujte si účet v H5P Hub <a href="{$a}"> zde </a>';
$string['contenthub:settings:box'] = 'Účet Hub obsahu';
$string['contenthub:settings:heading'] = 'Nastavení účtu H5P Hub';
$string['contenthubeditsharing'] = 'Upravit informace o sdílení';
$string['contenthuboptions'] = 'H5P OER Hub volby';
$string['contenthubsearchdescription'] = 'Vyhledat a stáhnout sdílený obsah z H5P Hub.';
$string['contenthubsearchenable'] = 'Povolit sdílený obsah v H5P Hubu';
$string['contenthubshare'] = 'Sdílet na H5P Hub';
$string['contenthubsharinginprogress'] = 'Sdílení ...';
$string['contenthubsyncchanges'] = 'Synchronizovat změny';
$string['contenthubunshare'] = 'Zrušit sdílení';
$string['contentissyncing'] = 'Probíhá synchronizace obsahu.';
$string['contentlicensetitle'] = 'Informace o licenci na obsah';
$string['contentnotshared'] = 'Obsah není v Hub sdílen.';
$string['contentstatefrequency'] = 'Uložit frekvenci stavu obsahu';
$string['contentstatefrequency_help'] = 'Jak často si přejete, aby uživatel během několika sekund automaticky ukládal svůj pokrok. Pokud máte problémy s mnoha požadavky na Ajax, zvyšte toto číslo';
$string['contenttype'] = 'Typ obsahu';
$string['contenttypecacheheader'] = 'Mezipaměť typu obsahu';
$string['contentupdatesoon'] = 'Váš obsah se brzy aktualizuje';
$string['copyright'] = 'Práva na užití';
$string['copyrightinfo'] = 'Informace o autorských právech';
$string['copyrightstring'] = 'Autorská práva';
$string['copyrighttitle'] = 'Zobrazit informace o autorských právech k tomuto obsahu.';
$string['copyrightwarning'] = 'Materiál chráněný autorskými právy nelze sdílet v H5P Content Hub. Pokud je obsah licencován licencí vhodnou pro OER, jako je Creative Commons, vyberte příslušnou licenci. Pokud ne, nelze tento obsah sdílet.';
$string['couldnotcopy'] = 'Soubor nelze zkopírovat.';
$string['couldnotparsejsonfromzip'] = 'Nelze analyzovat JSON z balíčku: %fileName';
$string['couldnotparsepostdata'] = 'Data příspěvku nelze analyzovat';
$string['couldnotreadfilefromzip'] = 'Nelze přečíst soubor z balíčku: %fileName';
$string['couldnotsave'] = 'Soubor nelze uložit.';
$string['country'] = 'Země';
$string['create'] = 'Vytvořit';
$string['creativecommons'] = 'Creative Commons';
$string['ctcachebuttonlabel'] = 'Aktualizovat mezipaměť typu obsahu';
$string['ctcacheconnectionfailed'] = 'Nelze komunikovat s H5P Hubem. Prosím zkuste to znovu později.';
$string['ctcachedescription'] = 'Zajištění aktuality mezipaměti typu obsahu zajistí, že budete moci prohlížet, stahovat a používat nejnovější knihovny. To se liší od aktualizace samotných knihoven.';
$string['ctcachelastupdatelabel'] = 'Poslední aktualizace';
$string['ctcacheneverupdated'] = 'Nikdy';
$string['ctcachenolibraries'] = 'Z Hubu H5P nebyly obdrženy žádné typy obsahu. Prosím zkuste to znovu později.';
$string['ctcachesuccess'] = 'Mezipaměť knihovny byla úspěšně aktualizována!';
$string['ctcachetaskname'] = 'Aktualizovat mezipaměť typu obsahu';
$string['currentpage'] = 'Strana $current z $total';
$string['currentstep'] = 'Krok :step z :total';
$string['dataviewreportlabel'] = 'Zobrazit odpovědi';
$string['date'] = 'Datum';
$string['description'] = 'Popis';
$string['disablefileextensioncheck'] = 'Zakázat kontrolu přípony souboru';
$string['disablefileextensioncheckwarning'] = 'Varování! Zakázání kontroly přípony souborů může mít bezpečnostní důsledky, protože umožňuje nahrávání souborů php. To by zase mohlo útočníkům umožnit spuštění škodlivého kódu na vašem webu. Ujistěte se, že přesně víte, co nahráváte.';
$string['disablefullscreen'] = 'Zakázat celou obrazovku';
$string['disablehubconfirmationmsg'] = 'Chcete stále aktivovat hub?';
$string['disablehubdescription'] = 'Důrazně se doporučuje ponechat tuto možnost povolenou. H5P Hub poskytuje snadné rozhraní pro získávání nových typů obsahu a udržování stávajících typů obsahu aktuální. V budoucnu také usnadní sdílení a opětovné použití obsahu. Pokud je tato možnost zakázána, budete muset nainstalovat a aktualizovat typy obsahu pomocí formulářů pro odesílání souborů.';
$string['disciplinedescription'] = 'Můžete vybrat více oborů';
$string['disciplinelabel'] = 'Obory';
$string['disciplinelimitreachedmessage'] = 'Můžete vybrat až: numDisciplines oborů';
$string['disciplines'] = 'Obory';
$string['displayoptionalwaysshow'] = 'Vždy zobrazit';
$string['displayoptionauthoroff'] = 'Ovládáno autorem, výchozí nastavení je vypnuto';
$string['displayoptionauthoron'] = 'Ovládáno autorem, výchozí nastavení je zapnuto';
$string['displayoptiondownloadalways'] = 'Vždy';
$string['displayoptiondownloadnever'] = 'Nikdy';
$string['displayoptiondownloadpermission'] = 'Pouze pokud má uživatel oprávnění k exportu H5P';
$string['displayoptionnevershow'] = 'Nikdy nezobrazovat';
$string['displayoptionpermissions'] = 'Zobrazit, pouze pokud má uživatel oprávnění k exportu H5P';
$string['displayoptionpermissionsembed'] = 'Zobrazit, pouze pokud má uživatel oprávnění k vložení H5P';
$string['displayoptions'] = 'Volby zobrazení';
$string['download'] = 'Stáhnout';
$string['downloadfailed'] = 'Stažení požadované knihovny se nezdařilo.';
$string['downloadtitle'] = 'Stáhnout tento obsah jako soubor H5P.';
$string['dropdownbutton'] = 'Rozevírací tlačítko';
$string['editinfotitle'] = 'Upravit informace pro <strong>: title </strong>';
$string['editingfailed'] = 'Úpravy se nezdařily.';
$string['editor'] = 'Editor';
$string['emailaddress'] = 'Emailová adresa';
$string['emailaddressdescription'] = 'E-mailovou adresu použije H5P k kontaktování vydavatele v případě jakýchkoli problémů s obsahem nebo v případě, že vydavatel potřebuje obnovit svůj účet. Nebude zveřejněn ani sdílen s žádnými třetími stranami';
$string['emailconfirmbody'] = 'Vážený/á  {$a->username},

Děkujeme vám za zaslání vašich odpovědí na "{$a->hvpname}" v kurzu "{$a->coursename}".

Tato zpráva potvrzuje, že vaše odpovědi byly uloženy.

K aktivitě H5P se dostanete na {$a->hvpurl}.';
$string['emailconfirmsmall'] = 'Děkujeme, že jste odeslali odpovědi na \'{$a->hvpname}\\';
$string['emailconfirmsubject'] = 'Potvrzení odevzdání příspěvku: {$a->hvpname}';
$string['emailnotifybody'] = 'Vážený/á  {$a->username},

{$a->studentname} dokončil "{$a->hvpname}" ({$a->hvpurl}) v kurzu "{$a->coursename}".

Výsledky tohoto pokusu si můžete prohlédnout na stránce {$a->hvpreporturl}.';
$string['emailnotifysmall'] = '{$a->studentname} dokončil {$a->hvpname}. Viz {$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} dokončil {$a->hvpname}';
$string['embed'] = 'Vložit';
$string['embedloginfailed'] = 'K tomuto obsahu nemáte přístup. Zkuste se přihlásit.';
$string['embedtitle'] = 'Zobrazit kód pro vložení tohoto obsahu.';
$string['empty'] = 'Nejsou k dispozici žádné výsledky';
$string['enableabout'] = 'Tlačítko O H5P';
$string['enablecopyright'] = 'Tlačítko autorských práv';
$string['enabledlrscontenttypes'] = 'Povolit typy obsahu závislé na LRS';
$string['enabledlrscontenttypes_help'] = 'Umožňuje používat typy obsahu, které spoléhají na Learning Record Store, aby správně fungovaly, jako je typ obsahu Dotazníku.';
$string['enabledownload'] = 'Povolit stahování';
$string['enableembed'] = 'Tlačítko Vložit';
$string['enableframe'] = 'Zobrazit akční lištu a rámeček';
$string['enablehublabel'] = 'Použít H5P Hub';
$string['enablejavascript'] = 'Povolte prosím JavaScript.';
$string['enablesavecontentstate'] = 'Uložit stav obsahu';
$string['enablesavecontentstate_help'] = 'Automaticky uloží aktuální stav interaktivního obsahu pro každého uživatele. To znamená, že uživatel může pokračovat, kde přestal.';
$string['failedtodownloadh5p'] = 'Požadované H5P se nepodařilo stáhnout.';
$string['fileexceedsmaxsize'] = 'Jeden ze souborů uvnitř balíčku přesahuje maximální povolenou velikost souboru. (%file %used > %max)';
$string['filenotfoundonserver'] = 'Soubor nebyl na serveru nalezen. Zkontrolujte nastavení nahrávání souborů.';
$string['filenotimage'] = 'Soubor není obrázek.';
$string['filetypenotallowed'] = 'Typ souboru není povolen.';
$string['finished'] = 'Dokončeno';
$string['fullscreen'] = 'Celá obrazovka';
$string['gpl'] = 'General Public License v3';
$string['gradeheading'] = 'Výsledky pro {$a}';
$string['gradetopassmustbeset'] = 'Známka k úspěšnému absolvování nemůže být nula, protože u této aktivity H5P je metoda dokončení nastavena tak, aby vyžadovala úspěšné absolvování. Nastavte nenulovou hodnotu.';
$string['gradetopassnotset'] = 'Tato aktivita H5P ještě nemá nastavenou požadovanou známku pro úspěšné absolvování. Může být nastaven v části Známky v nastavení aktivity H5P.';
$string['h5pfile'] = 'Soubor H5P';
$string['h5ptitle'] = 'Navštivte stránku H5P.org a podívejte se na další skvělý obsah.';
$string['helpchoosinglicense'] = 'Pomozte mi vybrat licenci';
$string['hide'] = 'Skrýt';
$string['hideadvanced'] = 'Skrýt pokročilé';
$string['hubcommunicationdisabled'] = 'Komunikace hubu H5P byla deaktivována, protože jeden nebo více požadavků H5P selhalo.';
$string['hubisdisabled'] = 'Hub je deaktivován. Můžete jej znovu povolit v nastavení H5P.';
$string['hubisdisableduploadlibraries'] = 'Hub H5P byl deaktivován, dokud nebude možné tento problém vyřešit. Knihovny můžete stále nahrávat prostřednictvím stránky „Knihovny H5P“.';
$string['hubsettingsheader'] = 'Typy obsahu';
$string['hvp:addinstance'] = 'Vytvořit nové aktivity H5P';
$string['hvp:contenthubregistration'] = 'Zaregistrovat web v H5P Content Hub';
$string['hvp:emailconfirmsubmission'] = 'Při odeslání příspěvku obdržíte potvrzovací zprávu';
$string['hvp:emailnotifysubmission'] = 'Po odeslání pokusu obdržíte oznamovací zprávu';
$string['hvp:getcachedassets'] = 'Vyžadováno pro prohlížení aktivit H5P';
$string['hvp:getembedcode'] = 'Pokud je nastavena možnost „řízeno pomocí oprávnění“, zobrazte kód pro vložení H5P';
$string['hvp:getexport'] = 'Po nastavení možnosti „řízeno pomocí oprávnění“ stáhněte soubor .h5p';
$string['hvp:installrecommendedh5plibraries'] = 'Nainstalovat nové bezpečné typy obsahu H5P doporučené H5P.org';
$string['hvp:manage'] = 'Upravit existující aktivity H5P';
$string['hvp:restrictlibraries'] = 'Omezit přístup k určitým typům obsahu H5P';
$string['hvp:savecontentuserdata'] = 'Uložit pokrok uživatelů pro aktivity H5P';
$string['hvp:saveresults'] = 'Uložit výsledky z dokončených aktivit H5P';
$string['hvp:share'] = 'Sdílet obsah v H5P OER Hubu';
$string['hvp:updatelibraries'] = 'Nainstalovat nové typy obsahu H5P nebo aktualizovat stávající typy';
$string['hvp:userestrictedlibraries'] = 'Použijte omezení typů obsahu H5P';
$string['hvp:view'] = 'Prohlédnout si aktivity H5P a použijte  interakce';
$string['hvp:viewallresults'] = 'Zobrazit všechny výsledky pro dokončené aktivity H5P';
$string['hvp:viewresults'] = 'Zobrazit vlastní výsledky za dokončené aktivity H5P';
$string['icon'] = 'Ikona';
$string['icondescription'] = '640x480px. Pokud není vybrán, použije se ikona kategorie';
$string['in'] = 'v';
$string['installdenied'] = 'Nemáte oprávnění k instalaci typů obsahu. Kontaktujte správce stránek.';
$string['installedlibraries'] = 'Nainstalované knihovny';
$string['intro'] = 'Úvod';
$string['invalidage'] = 'Neplatný vstupní formát pro typický věk. Možné vstupní formáty oddělené čárkami: „1, 34-45, -50, -59-“.';
$string['invalidaudioformat'] = 'Neplatný formát zvukového souboru. Použijte mp3 nebo WAV.';
$string['invalidcontentfolder'] = 'Neplatná složka obsahu';
$string['invalidcontenttype'] = 'Zvolený typ obsahu je neplatný.';
$string['invalidfieldtype'] = 'Neplatný typ pole.';
$string['invalidfile'] = 'Soubor "{$a->%filename}" není povolen. Povoleny jsou pouze soubory s následujícími příponami: {$a->%files-allowed}.';
$string['invalidh5ppost'] = 'Nelze zveřejnit H5P.';
$string['invalidhvp'] = 'Neplatná aktivita H5P';
$string['invalidimageformat'] = 'Neplatný formát souboru obrázku. Použijte jpg, png nebo gif.';
$string['invalidlanguagefile'] = 'Neplatný jazykový soubor {$a->%file} v knihovně {$a->%library}';
$string['invalidlanguagefile2'] = 'Do knihovny {$a ->% name} byl zahrnut neplatný jazykový soubor {$a ->% languageFile}';
$string['invalidlibrary'] = 'Neplatná knihovna';
$string['invalidlibrarydata'] = 'V {$a->%library} byly poskytnuty neplatné údaje pro {$a->%property}';
$string['invalidlibrarydataboolean'] = 'V {$a->%library} byly poskytnuty neplatné údaje pro {$a->%property}. Očekávány binární (Boolean).';
$string['invalidlibraryname'] = 'Neplatný název knihovny: {$a->%name}';
$string['invalidlibrarynamed'] = 'Knihovna H5P {$a->%library} použitá v obsahu není platná';
$string['invalidlibraryoption'] = 'Neplatná volba {$a->%option} v {$a->%library}';
$string['invalidlibraryproperty'] = 'Nelze číst vlastnost {$a->%property} v {$a->%library}';
$string['invalidmainjson'] = 'Chybí platný hlavní soubor h5p.json';
$string['invalidmultiselectoption'] = 'Neplatná vybraná volba ve vícečetném výběru.';
$string['invalidparameters'] = 'Neplatné parametry';
$string['invalidselectoption'] = 'Neplatná vybraná volba ve výběru.';
$string['invalidsemanticsjson'] = 'Do knihovny {$a->%name} byl zahrnut neplatný soubor semantics.json';
$string['invalidsemanticstype'] = 'Interní chyba H5P: neznámý typ obsahu „{$a ->@type}“ v sémantice. Odstraňování obsahu!';
$string['invalidstring'] = 'Zadaný řetězec není platný podle regexpu v sémantice.  (hodnota: \\"{$a->%value}\\", regexp: \\"{$a->%regexp}\\")';
$string['invalidtoken'] = 'H5P obdržel neplatný token. Obnovte stránku a zkuste to znovu.';
$string['invalidvideoformat'] = 'Neplatný formát video souboru. Použijte mp4 nebo webm.';
$string['invalidxapiresult'] = 'Pro danou kombinaci obsahu a ID uživatele nebyly nalezeny žádné výsledky xAPI';
$string['isnowsubmitted'] = 'Nyní se odesílá do centra H5P';
$string['javascriptloading'] = 'Čekání na JavaScript ...';
$string['keywordexists'] = 'Klíčové slovo již existuje!';
$string['keywords'] = 'Klíčové slovo';
$string['keywordsdescription'] = 'Můžete přidat více klíčových slov oddělených čárkami. Stisknutím klávesy „Enter“ nebo „Přidat“ potvrďte klíčová slova';
$string['keywordsexists'] = 'Klíčové slovo již existuje!';
$string['keywordsplaceholder'] = 'Přidat klíčová slova';
$string['language'] = 'Jazyk';
$string['level'] = 'Úroveň';
$string['libraries'] = 'Knihovny H5P';
$string['librarydirectoryerror'] = 'Název adresáře knihovny musí odpovídat machineName nebo machineName-majorVersion.minorVersion (z library.json).  (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librarylistactions'] = 'Akce';
$string['librarylistinstancedependencies'] = 'Závislosti instance';
$string['librarylistinstances'] = 'Instance';
$string['librarylistlibrarydependencies'] = 'Závislosti knihovny';
$string['librarylistrestricted'] = 'Omezeno';
$string['librarylisttitle'] = 'Nadpis';
$string['librarynotselected'] = 'Musíte vybrat typ obsahu.';
$string['license'] = 'Licence';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Verze 1';
$string['licenseV2'] = 'Verze 2';
$string['licenseV3'] = 'Verze 3';
$string['licensedescription'] = 'Vybrat licenci pro svůj obsah';
$string['licensedetails'] = 'Podrobnosti licence';
$string['licensedialogdescription'] = 'Kliknutím na konkrétní licenci získáte informace o správném použití';
$string['licensee'] = 'Držitel licence';
$string['licenseextras'] = 'Extra licence';
$string['licenseversion'] = 'Verze licence';
$string['licenseversiondescription'] = 'Vybrat verzi licence';
$string['loadingdata'] = 'Načítání dat.';
$string['logouploadtext'] = 'Logo organizace nebo avatar';
$string['longdescription'] = 'Dlouhý popis';
$string['longdescriptionplaceholder'] = 'Dlouhý popis vašeho obsahu';
$string['lookforupdates'] = 'Hledat aktualizace H5P';
$string['maintitle'] = 'Sdílení <strong>:title</strong>';
$string['maximumgrade'] = 'Maximální známka';
$string['maximumgradeerror'] = 'Jako platné maximální počet bodů pro tuto aktivitu zadejte platné kladné celé číslo';
$string['maxlength'] = ':length je maximální počet znaků';
$string['maxpostsizetoosmall'] = 'Vaše maximální velikost příspěvku v PHP je poměrně malá. Při současném nastavení nesmíte nahrávat soubory větší než {$a->%number}  MB. To může být problém, když se pokoušíte nahrát H5P, obrázky a videa. Zvažte, prosím, zvýšení na více než 5 MB';
$string['maxscore'] = 'Maximální skóre';
$string['maxuploadsizetoosmall'] = 'Vaše maximální velikost příspěvku v PHP je poměrně malá. Při současném nastavení nesmíte nahrávat soubory větší než {$a->%number}  MB. To může být problém, když se pokoušíte nahrát H5P, obrázky a videa. Zvažte, prosím, zvýšení na více než 5 MB.';
$string['messageprovider:confirmation'] = 'Potvrzení vašich odevzdaných příspěvků H5P';
$string['messageprovider:submission'] = 'Oznámení o odevzdaných příspěvcích H5P';
$string['missingcontentfolder'] = 'Chybí platná složka obsahu';
$string['missingcontentuserdata'] = 'Chyba: Nelze najít uživatelská data obsahu';
$string['missingcoreversion'] = 'Systém nemohl nainstalovat komponentu <em>{$a->%component}</em> z balíčku, vyžaduje novější verzi pluginu H5P. Na tomto webu je aktuálně spuštěna verze {$a->%current}, zatímco požadovaná verze je {$a->%required} nebo vyšší. Měli byste zvážit upgrade a zkusit to znovu.';
$string['missingdependency'] = 'Chybí závislost {$a->@dep} vyžadovaná od {$a->@lib}.';
$string['missinglibrary'] = 'Chybí požadovaná knihovna {$a->%library}';
$string['missinglibraryfile'] = 'Chybí soubor "{$a->%file}"  z knihovny: "{$a->%name}"';
$string['missinglibraryjson'] = 'Nelze najít soubor library.json s platným formátem json pro knihovnu {$a->%name}';
$string['missinglibraryproperty'] = 'Požadovaná vlastnost {$a->%property chybí v {$a->%library}';
$string['missingmbstring'] = 'Rozšíření mbstring PHP není načteno. H5P potřebuje toto, aby správně fungoval';
$string['missingparameters'] = 'Chybějící parametry';
$string['missinguploadpermissions'] = 'Knihovny mohou existovat v nahraném souboru, ale nemůžete nahrát nové knihovny. Kontaktujte správce stránek.';
$string['modulename'] = 'Interaktivní obsah';
$string['modulename_help'] = 'Modul aktivity H5P umožňuje vytvářet interaktivní obsah, jako jsou interaktivní videa, sady otázek, otázky přetahováním, otázky s možností výběru, prezentace a mnoho dalšího.

Kromě toho, že H5P je nástrojem pro tvorbu bohatého obsahu, umožňuje importovat a exportovat soubory H5P pro efektivní opětovné použití a sdílení obsahu.

Interakce uživatelů a skóre jsou sledovány pomocí xAPI a jsou k dispozici prostřednictvím Moodle Známky. Všimněte si, že v současné době je možné, aby lidé s programovacími schopnostmi podváděli interakce H5P a získali plné skóre, aniž by znali správné odpovědi. H5P se nesmí používat pro zkoušky nebo podobné.

Interaktivní obsah H5P přidáte vytvořením obsahu pomocí vestavěného vývojového nástroje nebo nahráním souborů H5P nalezených na jiných webech podporujících H5P.';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = 'Interaktivní obsah';
$string['next'] = 'Další';
$string['nextpage'] = 'Další strana';
$string['noanswersubmitted'] = 'Tento uživatel dosud neodeslal odpověď na H5P';
$string['nocontent'] = 'Nelze najít nebo analyzovat soubor content.json';
$string['nocontenttype'] = 'Nebyl zadán žádný typ obsahu.';
$string['nocopyright'] = 'Pro tento obsah nejsou k dispozici žádné informace o autorských právech.';
$string['nodata'] = 'Nejsou k dispozici žádná data, která odpovídají vašim kritériím.';
$string['noexport'] = 'Chybí exportní soubor.';
$string['noextension'] = 'Nahraný soubor není platný balíček HTML5 (nemá příponu .h5p)';
$string['noh5ps'] = 'Pro tento kurz není k dispozici žádný interaktivní obsah.';
$string['nohubregistration'] = 'Není registrován u H5P Hubu';
$string['nojson'] = 'Hlavní soubor h5p.json není platný';
$string['nombstringexteension'] = 'Rozšíření mbstring PHP není načteno. H5P to potřebuje, aby správně fungoval';
$string['noparameters'] = 'Žádné parametry';
$string['noparse'] = 'Nelze analyzovat hlavní soubor h5p.json';
$string['nopermissiontogettranslations'] = 'Nemáte oprávnění získat překlady';
$string['nopermissiontorestrict'] = 'Nemáte oprávnění omezovat knihovny.';
$string['nopermissiontosavecontentuserdata'] = 'Nemáte oprávnění ukládat uživatelská data obsahu.';
$string['nopermissiontosaveresult'] = 'Nemáte pro tento obsah oprávnění uložit výsledek.';
$string['nopermissiontoupgrade'] = 'Nemáte oprávnění upgradovat knihovny.';
$string['nopermissiontouploadcontent'] = 'Zde nemáte oprávnění k nahrávání obsahu.';
$string['nopermissiontouploadfiles'] = 'Zde nemáte oprávnění k nahrávání souborů.';
$string['nopermissiontoviewcontenthubcache'] = 'Nemáte oprávnění k zobrazení metadat pro centrum obsahu.';
$string['nopermissiontoviewcontenttypes'] = 'K zobrazení typů obsahu nemáte oprávnění.';
$string['nopermissiontoviewresult'] = 'K prohlížení výsledků tohoto obsahu nemáte oprávnění.';
$string['nosuchlibrary'] = 'Žádná taková knihovna';
$string['notapplicable'] = 'N/A';
$string['nounzip'] = 'Nahraný soubor není platný balíček HTML5 (nemůžeme jej rozbalit)';
$string['noversionattribution'] = 'Uvedení autora';
$string['noversionattributionnc'] = 'Uveďte původ-Neužívejte komerčně';
$string['noversionattributionncnd'] = 'Uveďte původ-Neužívejte komerčně-Nezpracovávejte';
$string['noversionattributionncsa'] = 'Uveďte původ-Neužívejte komerčně-Zachovejte licenci';
$string['noversionattributionnd'] = 'Uveďte původ-Nezpracovávejte';
$string['noversionattributionsa'] = 'Uveďte původ-Zachovejte licenci';
$string['nowriteaccess'] = 'Byl zjištěn problém s přístupem pro zápis na server. Ujistěte se, že váš server může zapisovat do datové složky.';
$string['noziparchive'] = 'Vaše verze PHP nepodporuje ZipArchive.';
$string['offlinedialogbody'] = 'Nepodařilo se nám poslat informace o dokončení tohoto úkolu. Zkontrolujte připojení k internetu.';
$string['offlinedialogheader'] = 'Vaše připojení k serveru bylo ztraceno';
$string['offlinedialogretrybuttonlabel'] = 'Zkuste to znovu';
$string['offlinedialogretrymessage'] = 'Opakování za :num ....';
$string['offlinesuccessfulsubmit'] = 'Výsledky byly úspěšně odeslány.';
$string['oldphpversion'] = 'Vaše verze PHP je zastaralá. H5P vyžaduje, aby verze 5.2 správně fungovala. Doporučuje se verze 5.6 nebo novější.';
$string['olduploadoldcontent'] = 'Pokoušíte se nahrát obsah starší verze H5P. Upgradujte obsah na serveru, ze kterého pochází, a zkuste nahrát znovu nebo zapněte H5P Hub, aby to tento server upgradoval automaticky.';
$string['onlyupdate'] = 'Aktualizujte pouze stávající knihovny';
$string['optionalinfo'] = 'Volitelné informace';
$string['options'] = 'Volby';
$string['originator'] = 'Původce';
$string['pd'] = 'Public Domain';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'Public Domain Mark';
$string['phone'] = 'Telefon';
$string['pleasewait'] = 'Prosím, čekejte...';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = 'Pro přístup k danému koncovému bodu je vyžadována zpráva';
$string['previouspage'] = 'Předchozí strana';
$string['privacy:metadata:core_files'] = 'Aktivita H5P ukládá soubory, které byly nahrány jako součást obsahu H5P.';
$string['privacy:metadata:core_grades'] = 'Aktivita H5P ukládá známky uživatelů, kteří odpověděli na obsah H5P.';
$string['privacy:metadata:hvp_content_user_data'] = 'Popisuje aktuální stav, ve kterém je obsah pro uživatele. Slouží k obnovení obsahu do předchozího stavu.';
$string['privacy:metadata:hvp_content_user_data:data'] = 'Uživatelská data, která byla uložena.';
$string['privacy:metadata:hvp_content_user_data:data_id'] = 'Identifikátor datového typu.';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = 'Příznak určující, zda mají být data změněna při změně obsahu.';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = 'ID obsahu H5P, do kterého data patří.';
$string['privacy:metadata:hvp_content_user_data:id'] = 'ID vztahu dat uživatele s obsahem.';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = 'Příznak určující, zda mají být data předem načtena do obsahu.';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'Dílčí obsah H5P, 0, pokud to není dílčí obsah.';
$string['privacy:metadata:hvp_content_user_data:user_id'] = 'ID uživatele, kterému data patří.';
$string['privacy:metadata:hvp_events'] = 'Sleduje zaznamenané události H5P.';
$string['privacy:metadata:hvp_events:content_id'] = 'ID obsahu, na kterém byla akce provedena, 0, pokud je nový nebo žádný obsah.';
$string['privacy:metadata:hvp_events:content_title'] = 'Název obsahu.';
$string['privacy:metadata:hvp_events:created_at'] = 'Čas, kdy byla událost vytvořena.';
$string['privacy:metadata:hvp_events:id'] = 'Jedinečné ID události.';
$string['privacy:metadata:hvp_events:library_name'] = 'Knihovna, která událost ovlivnila.';
$string['privacy:metadata:hvp_events:library_version'] = 'Verze knihovny, která událost ovlivnila.';
$string['privacy:metadata:hvp_events:sub_type'] = 'Podtyp události nebo akce události.';
$string['privacy:metadata:hvp_events:type'] = 'Typ události.';
$string['privacy:metadata:hvp_events:user_id'] = 'ID uživatele, který akci provedl.';
$string['privacy:metadata:hvp_xapi_results'] = 'Ukládá události xAPI do obsahu H5P.';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'Další informace, které může H5P poslat.';
$string['privacy:metadata:hvp_xapi_results:content_id'] = 'ID obsahu, na kterém byla událost provedena.';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = 'Správný vzorec odpovědi.';
$string['privacy:metadata:hvp_xapi_results:description'] = 'Popis, úkol nebo otázka obsahu, na kterém byla akce provedena.';
$string['privacy:metadata:hvp_xapi_results:id'] = 'Jedinečné ID události xAPI.';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = 'Druh interakce.';
$string['privacy:metadata:hvp_xapi_results:max_score'] = 'Maximální dosažitelné skóre pro událost.';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = 'ID nadřazeného obsahu, na kterém byla tato událost provedena. Null, pokud nemá rodiče.';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = 'Dosažené skóre za událost.';
$string['privacy:metadata:hvp_xapi_results:response'] = 'Odpověď, kterou uživatel odeslal.';
$string['privacy:metadata:hvp_xapi_results:user_id'] = 'ID uživatele, který akci provedl.';
$string['publisherdescription'] = 'Popis vydavatele';
$string['publisherdescriptiontext'] = 'Toto se zobrazí v části „Informace o vydavateli“ u sdíleného obsahu';
$string['publisherfielddescription'] = 'U sdíleného obsahu se zobrazí jako „Jméno vydavatele“';
$string['publisherfieldtitle'] = 'Vydavatel';
$string['question'] = 'Otázka';
$string['registeronhub'] = 'Zaregistrujte se na H5P Hubu';
$string['registrationfailed'] = 'Vyskytla se chyba';
$string['registrationfaileddescription'] = 'V tuto chvíli jsme nebyli schopni vytvořit účet. Něco se pokazilo. Zkuste to později.';
$string['registrationtitle'] = 'Registrace Hub H5P';
$string['remove'] = 'Odstranit';
$string['removechip'] = 'Odebrat :chip ze seznamu';
$string['removeimage'] = 'Odebrat obrázek';
$string['removeoldlogentries'] = 'Odstranit staré položky protokolu H5P';
$string['removeoldmobileauthentries'] = 'Odstranit staré položky H5P pro mobilní autorizaci';
$string['removetmpfiles'] = 'Odstranit staré dočasné soubory H5P';
$string['reportingquestionsremaininglabel'] = 'otázky zbývající do hodnocení';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = 'Skóre známky:';
$string['reportingscoredelimiter'] = 'ze';
$string['reportingscorelabel'] = 'Skóre:';
$string['reportnotsupported'] = 'Není podporováno';
$string['reportsubmitgradelabel'] = 'Odeslat známku';
$string['requiredinfo'] = 'Povinné informace';
$string['resizescript'] = 'Chcete-li dynamicky měnit velikost vloženého obsahu, zahrňte tento skript na svůj web:';
$string['resubmitscores'] = 'Pokus o odeslání uložených výsledků.';
$string['reuse'] = 'Opětovné použití';
$string['reusecontent'] = 'Opětovné použití obsahu';
$string['reusedescription'] = 'Znovu použít tento obsah.';
$string['reveal'] = 'Ukázat';
$string['reviewandsave'] = 'Zkontrolovat a uložit';
$string['reviewandshare'] = 'Zkontrolovat a sdílet';
$string['reviewinfo'] = 'Zkontrolovat informace';
$string['reviewmessage'] = 'Před sdílením si prosím přečtěte níže uvedené informace';
$string['reviseserversetupandretry'] = 'Po revizi nastavení serveru můžete v Nastavení H5P znovu povolit komunikaci hubu H5P.';
$string['savechanges'] = 'Uložit změny';
$string['score'] = 'Skóre';
$string['screenshots'] = 'Snímky obrazovky';
$string['screenshotsdescription'] = 'Přidejte až pět snímků obrazovky s vaším obsahem';
$string['search'] = 'Vyhledat';
$string['searchplaceholder'] = 'Zadejte vyhledávání oborů';
$string['sendusagestatistics'] = 'Přispět do statistik využití';
$string['sendusagestatistics_help'] = 'Statistická čísla použití budou automaticky vykazována, aby vývojářům pomohla lépe pochopit, jak se používá H5P, a určit potenciální oblasti zlepšení. Přečtěte si další informace o tom, která data <a {$a}> jsou shromažďována na webu h5p.org </a>.';
$string['settings'] = 'Nastavení H5P';
$string['share'] = 'Sdílení';
$string['shared'] = 'Sdílené';
$string['sharefailed'] = 'Sdílení se nezdařilo.';
$string['sharetryagain'] = 'Něco se pokazilo, zkuste to sdílet znovu.';
$string['sharingnote'] = 'Po sdílení lze upravit všechny podrobnosti obsahu';
$string['shortdescription'] = 'Krátký popis';
$string['shortdescriptionplaceholder'] = 'Krátký popis vašeho obsahu';
$string['showadvanced'] = 'Zobrazit pokročilé';
$string['showless'] = 'Zobrazit méně';
$string['showmore'] = 'Zobrazit více';
$string['sitecouldnotberegistered'] = 'Web nemohl být zaregistrován v Hubu. Obraťte se na správce webu.';
$string['sitekey'] = 'Klíč webu';
$string['sitekeydescription'] = 'Klíč webu je soukromý klíč, které jedinečně identifikuje tento web s Hubem.';
$string['sitekeyregistered'] = 'Při přijímání nových aktualizací vám byl poskytnut jedinečný klíč, který vás identifikuje s Hubem. Tento klíč je k dispozici pro prohlížení na stránce „Nastavení H5P“.';
$string['size'] = 'Velikost';
$string['somekeywordsexists'] = 'Některá z těchto klíčových slov již existují';
$string['source'] = 'Zdroj';
$string['sslnotenabled'] = 'Váš server nemá povoleno SSL. Pro zajištění bezpečného připojení k hubu H5P by měl být povolen protokol SSL.';
$string['startingover'] = 'Začnete znovu.';
$string['subcontentwarning'] = 'Dílčí obsah (obrázky, dotazy atd.) Bude sdílen pod licencí: license, pokud není v nástroji pro tvorbu uvedeno jinak';
$string['sublevel'] = 'Podúrovně';
$string['submitted'] = 'Odesláno!';
$string['successfullyregisteredwithhub'] = 'Vaše stránka byla úspěšně zaregistrována na H5P Hub.';
$string['successfullyregistred'] = 'Úspěšně jste zaregistrovali účet v H5P Hubu';
$string['successfullyregistreddescription'] = 'Podrobnosti vašeho účtu lze změnit';
$string['successfullyupdated'] = 'Vaše nastavení účtu H5P Hub bylo úspěšně změněno';
$string['thumbnail'] = 'Náhled';
$string['title'] = 'Nadpis';
$string['unabletocreatedir'] = 'Adresář nelze vytvořit.';
$string['unabletogetfieldtype'] = 'Nelze získat typ pole.';
$string['undisclosed'] = 'Nezveřejněno';
$string['unpackedfilesexceedsmaxsize'] = 'Celková velikost rozbalených souborů přesahuje maximální povolenou velikost. (%used > %max)';
$string['updatedlibraries'] = 'Aktualizované knihovny {$a->%old} H5P.';
$string['updatedlibrary'] = 'Aktualizovaná knihovna {$a->%old} H5P.';
$string['updatelibraries'] = 'Aktualizovat všechny knihovny';
$string['updateregistrationonhub'] = 'Uložit nastavení účtu';
$string['upgrade'] = 'Upgradovat H5P';
$string['upgradebuttonlabel'] = 'Upgradovat';
$string['upgradedone'] = 'Úspěšně jste aktualizovali {$a} instance obsahu.';
$string['upgradeerror'] = 'Při zpracování parametrů došlo k chybě:';
$string['upgradeerrorcontent'] = 'Nelze upgradovat obsah %id:';
$string['upgradeerrordata'] = 'Nelze načíst data do knihovny %lib.';
$string['upgradeerrormissinglibrary'] = 'Chybí požadovaná knihovna %lib.';
$string['upgradeerrornotsupported'] = 'Parametry obsahují  %used nejsou podporovány.';
$string['upgradeerrorparamsbroken'] = 'Parametry jsou rozbité.';
$string['upgradeerrorscript'] = 'Skript pro upgrade %lib nelze načíst.';
$string['upgradeerrortoohighversion'] = 'Parametry obsahují  %used , zatímco podporovány jsou pouze  %supported  nebo starší.';
$string['upgradeheading'] = 'Aktualizovat obsah {$a}';
$string['upgradeinprogress'] = 'Aktualizace na %ver ...';
$string['upgradeinvalidtoken'] = 'Chyba: Neplatný bezpečnostní token!';
$string['upgradelibrarycontent'] = 'Aktualizovat obsah knihovny';
$string['upgradelibrarymissing'] = 'Chyba: Vaše knihovna chybí!';
$string['upgrademessage'] = 'Chystáte se aktualizovat instance obsahu {$a}. Vyberte verzi.';
$string['upgradenoavailableupgrades'] = 'Pro tuto knihovnu nejsou k dispozici žádné Aktualizovat .';
$string['upgradenothingtodo'] = 'Neexistují žádné instance obsahu pro aktualizaci.';
$string['upgradereturn'] = 'Zpět';
$string['upload'] = 'Nahrát';
$string['uploadlibraries'] = 'Nahrát knihovny';
$string['uploadsizelargerthanpostsize'] = 'Vaše maximální velikost nahrávání PHP je větší než vaše maximální velikost příspěvku. Je známo, že to v některých instalacích způsobuje problémy.';
$string['user'] = 'Uživatel';
$string['validatingh5pfailed'] = 'Ověření balíčku h5p se nezdařilo.';
$string['validationfailed'] = 'Požadovaný H5P nebyl platný';
$string['viewreportlabel'] = 'Sestava';
$string['welcomecommunity'] = 'Doufáme, že se vám bude líbit H5P a zapojíte se do naší rostoucí komunity prostřednictvím našich <a {$a->forums}> fór </a>.';
$string['welcomecontactus'] = 'Pokud máte zpětnou vazbu, neváhejte nás <a {$a}> kontaktovat </a>. Zpětnou vazbu bereme velmi vážně a každý den se věnujeme zlepšování H5P!';
$string['welcomegettingstarted'] = 'Chcete-li začít s H5P a Moodle, podívejte se na náš <a {$a->moodle_tutorial}> tutoriál </a> a podívejte se na <a {$a->example_content}> ukázkový obsah </a> na H5P. org pro inspiraci.';
$string['welcomeheader'] = 'Vítejte ve světě H5P!';
$string['wrongversion'] = 'Verze knihovny H5P {$a->%machineName} použitá v tomto obsahu není platná. Obsah obsahuje {$a->%contentLibrary}, ale měl by to být {$a->%semanticsLibrary}.';
$string['year'] = 'Rok';
$string['years'] = 'Rok(y)';
$string['yearsfrom'] = 'Rok (od)';
$string['yearsto'] = 'Rok (do)';
$string['zip'] = 'Zip';
