<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'uk', version '5.0'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'У вас найближчі сеанси BigBlueButton';
$string['bbbduetimeoverstartingtime'] = 'Час закриття має бути пізніше, ніж час відкриття.';
$string['bbbdurationwarning'] = 'Максимальна тривалість цього сеансу - %duration% хвилин.';
$string['bbbrecordallfromstartwarning'] = 'Цей сеанс записується з самого початку.';
$string['bbbrecordwarning'] = 'Цей сеанс може бути записаний.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Додайте нову кімнату BigBlueButton';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Створіть екземпляр живих сеансів';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Створіть екземпляр із записами';
$string['bigbluebuttonbn:deleterecordings'] = 'Видалити записи';
$string['bigbluebuttonbn:importrecordings'] = 'Імпортувати записи';
$string['bigbluebuttonbn:join'] = 'Приєднатися до кімнати BigBlueButton';
$string['bigbluebuttonbn:managerecordings'] = 'Управління записами';
$string['bigbluebuttonbn:protectrecordings'] = 'Захистити записи';
$string['bigbluebuttonbn:publishrecordings'] = 'Публікувати записи';
$string['bigbluebuttonbn:seepresentation'] = 'Завжди дивіться файл презентації на сторінці активності';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Зніміть захист записів';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Скасувати публікацію записів';
$string['bigbluebuttonbn:view'] = 'Переглянути кімнату BigBlueButton';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Переглянути всі формати запису';
$string['cachedef_currentfetch'] = 'Дані для переліку будь-яких нещодавно отриманих записів.';
$string['cachedef_recordings'] = 'Запис метаданих';
$string['cachedef_serverinfo'] = 'Інформація про віддалений сервер';
$string['cachedef_subplugins'] = 'Кеш, який використовується процедурами підплагінів для прискорення процесу виявлення плагінів.';
$string['cachedef_validatedurls'] = 'Кеш підтверджених перевірок URL-адрес';
$string['calendarstarts'] = '{$a} заплановано для';
$string['cannotperformaction'] = 'Неможливо виконати дію {$a} щодо цього запису';
$string['completionattendance'] = 'Обов’язкова явка (хвилин)';
$string['completionattendance_desc'] = 'Увійдіть і залишайтеся в кімнаті принаймні {$a} хвилин(и).';
$string['completionattendance_event_desc'] = 'Студент увійшов до кімнати та залишився на сесії щонайменше {$a} хв.';
$string['completionattendancegroup'] = 'Обов’язкова явка (хвилин)';
$string['completionengagement_desc'] = 'Беріть участь у заходах під час зустрічі.';
$string['completionengagementchats'] = 'Чати';
$string['completionengagementchats_desc'] = 'Візьміть участь у {$a} чатах.';
$string['completionengagementchats_event_desc'] = 'Створив {$a} чат(ів)';
$string['completionengagementemojis'] = 'Emojis';
$string['completionengagementemojis_desc'] = 'Змінити їхні смайли {$a} разів.';
$string['completionengagementemojis_event_desc'] = 'Змінили свої смайли {$a} раз(ів)';
$string['completionengagementgroup'] = 'Вимагають участі';
$string['completionengagementpollvotes'] = 'Голосування при опитуванні';
$string['completionengagementpollvotes_desc'] = 'Голосуйте в опитуваннях {$a} раз(ів).';
$string['completionengagementpollvotes_event_desc'] = 'Відповів на стільки голосів в опитуванні: {$a}';
$string['completionengagementraisehand'] = 'Вимагають піднятої руки';
$string['completionengagementraisehand_desc'] = 'Підняти руку {$a} раз(ів).';
$string['completionengagementraisehand_event_desc'] = 'Підняв руку {$a} разів';
$string['completionengagementtalks'] = 'Поговорити';
$string['completionengagementtalks_desc'] = 'Розмова {$a} раз(ів)';
$string['completionengagementtalks_event_desc'] = 'Підняв {$a} розмов';
$string['completionupdatestate'] = 'Стан завершення оновлення';
$string['completionvalidatestate'] = 'Підтвердження завершення';
$string['completionvalidatestatetriggered'] = 'Підтвердження завершення запущено.';
$string['completionview_event_desc'] = 'Переглянув кімнату.';
$string['config_checksum_algorithm'] = 'Алгоритм контрольної суми сервера BigBlueButton';
$string['config_checksum_algorithm_description'] = 'SHA1 сумісний зі старими серверами. SHA256 і SHA512 більш безпечні. SHA512 відповідає FIPS 140-2.';
$string['config_default_messages'] = 'Повідомлення за замовчуванням';
$string['config_default_messages_description'] = 'Встановити повідомлення за замовчування для діяльності';
$string['config_disablecam_default'] = 'Вимкнути веб-камеру, увімкнену за замовчуванням';
$string['config_disablecam_default_description'] = 'Якщо відмічено, то камера буде вимкнена.';
$string['config_disablecam_editable'] = 'Вимкнути веб-камеру можна відредагувати';
$string['config_disablecam_editable_description'] = 'Вимкнути веб-камеру за замовчуванням можна відредагувати, коли екземпляр додається або оновлюється.';
$string['config_disablemic_default'] = 'За замовченням мікрофон вимкнено';
$string['config_disablemic_default_description'] = 'Якщо ввімкнено, мікрофони будуть вимкнені.';
$string['config_disablemic_editable'] = 'Вимкнення мікрофону може бути змінено';
$string['config_disablemic_editable_description'] = 'Вимкнути мікрофон за замовчуванням можна відредагувати, коли екземпляр додається або оновлюється.';
$string['config_disablenote_default'] = 'Вимкнути спільні нотатки ввімкнено за замовчуванням';
$string['config_disablenote_default_description'] = 'Якщо ввімкнено, спільні нотатки будуть вимкнені.';
$string['config_disablenote_editable'] = 'Вимкнути спільні нотатки можна редагувати';
$string['config_disablenote_editable_description'] = 'Вимкнути спільні нотатки за замовчуванням можна редагувати, коли екземпляр додається або оновлюється.';
$string['config_disableprivatechat_default'] = 'Вимкнути приватний чат увімкнено за замовчуванням';
$string['config_disableprivatechat_default_description'] = 'Якщо ввімкнено, приватний чат буде вимкнено.';
$string['config_disableprivatechat_editable'] = 'Вимкнути приватний чат можна відредагувати';
$string['config_disableprivatechat_editable_description'] = 'Вимкнути приватний чат за замовчуванням можна відредагувати, коли екземпляр додається або оновлюється.';
$string['config_disablepublicchat_default'] = 'Вимкнути публічний чат увімкнено за замовчуванням';
$string['config_disablepublicchat_default_description'] = 'Якщо ввімкнено, публічний чат буде вимкнено.';
$string['config_disablepublicchat_editable'] = 'Вимкнути публічний чат можна відредагувати';
$string['config_disablepublicchat_editable_description'] = 'Вимкнути публічний чат за замовчуванням можна відредагувати, коли екземпляр додається або оновлюється.';
$string['config_experimental_features'] = 'Експериментальні особливості';
$string['config_experimental_features_description'] = 'Конфігурація для експериментальних функцій.';
$string['config_extended_capabilities'] = 'Розширені можливості';
$string['config_extended_capabilities_description'] = 'Configuration for extended capabilities when the BigBlueButton server offers them.';
$string['config_general'] = 'Загальні налаштування';
$string['config_general_description'] = 'Щоб налаштувати BigBlueButton, ви можете використовувати власний сервер і облікові дані BigBlueButton або отримати облікові дані через <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">портал реєстрації Blindside Networks (відкривається у новому вікні)</a>.';
$string['config_guestaccess_enabled'] = 'Зовнішній гостьовий доступ';
$string['config_guestaccess_enabled_description'] = 'Дозвольте користувачам без облікового запису на вашому сайті отримати доступ до кімнати.';
$string['config_hideuserlist_default'] = 'Приховати список користувачів увімкнено за замовчуванням';
$string['config_hideuserlist_default_description'] = 'Якщо ввімкнено, список користувачів сеансу буде приховано.';
$string['config_hideuserlist_editable'] = 'Приховати список користувачів можна редагувати';
$string['config_hideuserlist_editable_description'] = 'Приховати список користувачів за замовчуванням можна редагувати, коли екземпляр додається або оновлюється.';
$string['config_importrecordings'] = 'Імпортувати записи';
$string['config_importrecordings_description'] = 'Ці налаштування залежать від певних функцій.';
$string['config_importrecordings_enabled'] = 'Імпорт записів увімкнено';
$string['config_importrecordings_enabled_description'] = 'When this and the recording feature are enabled, it is possible to import recordings from different courses into an activity.';
$string['config_importrecordings_from_deleted_enabled'] = 'Import recordings from deleted activities enabled';
$string['config_importrecordings_from_deleted_enabled_description'] = 'When this and the import recording feature are enabled, it is possible to import recordings from activities that are no longer in the course.';
$string['config_locksettings'] = 'Конфігурація параметрів блокування';
$string['config_locksettings_description'] = 'Ці параметри вмикають або вимикають параметри в інтерфейсі користувача для налаштувань блокування, а також визначають значення за замовчуванням для цих параметрів.';
$string['config_meetingevents_enabled'] = 'Реєстрація сеансів у прямому ефірі';
$string['config_meetingevents_enabled_description'] = 'Якщо ввімкнено, сеанси в реальному часі оброблятимуться після завершення сеансу. Ця функція необхідна для завершення активності і працюватиме, лише якщо сервер BigBlueButton здатний обробляти сценарії post_events.';
$string['config_muteonstart'] = 'Вимкнути звук під час запуску';
$string['config_muteonstart_default'] = 'Вимкнення звуку під час запуску ввімкнено за замовчуванням';
$string['config_muteonstart_default_description'] = 'Якщо ввімкнено, сеанс буде вимкнено під час початку.';
$string['config_muteonstart_description'] = 'Ці параметри вмикають або вимикають параметри в інтерфейсі користувача, а також визначають значення за замовчуванням для цих параметрів.';
$string['config_muteonstart_editable'] = 'Вимкнути звук під час запуску можна редагувати';
$string['config_muteonstart_editable_description'] = 'Вимкнути звук під час запуску за замовчуванням можна редагувати, коли екземпляр додається або оновлюється.';
$string['config_participant'] = 'Учасники';
$string['config_participant_description'] = 'Ці параметри визначають роль за замовчуванням для учасників.';
$string['config_participant_moderator_default'] = 'Модератор';
$string['config_participant_moderator_default_description'] = 'This rule is used by default when a new room is added.';
$string['config_poll_interval'] = 'Інтервал опитування (у секундах) для оновлення статусу кімнати';
$string['config_poll_interval_description'] = 'Інтервал опитування повинен бути не менше 2 секунд. При необхідності ви можете знизити навантаження на віддалений сервер, збільшивши інтервал.';
$string['config_presentation_default'] = 'Файл презентації за замовчуванням';
$string['config_presentation_default_description'] = 'Файл може бути наданий для використання в усіх кімнатах.';
$string['config_preuploadpresentation'] = 'Файл презентації';
$string['config_preuploadpresentation_description'] = 'Ці параметри вмикають або вимикають параметри в інтерфейсі користувача, а також визначають значення за замовчуванням для цих параметрів. Функція працює, лише якщо сервер Moodle доступний для BigBlueButton.';
$string['config_preuploadpresentation_editable'] = 'Файл презентації на сторінці активності';
$string['config_preuploadpresentation_editable_description'] = 'Опція в налаштуваннях активності для завантаження файлу презентації для показу на сторінці активності.';
$string['config_profile_picture_enabled'] = 'Показати фотографії профілю';
$string['config_profile_picture_enabled_description'] = 'Чи слід показувати фотографії профілів учасників під час сеансів BigBlueButton?';
$string['config_recording'] = 'Запис';
$string['config_recording_all_from_start_default'] = 'Почніть запис на початку';
$string['config_recording_all_from_start_default_description'] = 'Чи слід увімкнути параметр «Почати запис з початку» за замовчуванням під час додавання нової кімнати BigBlueButton?';
$string['config_recording_all_from_start_editable'] = 'Почніть запис з початку редагування';
$string['config_recording_all_from_start_editable_description'] = 'Чи можна редагувати параметр "Почати запис з початку" в налаштуваннях активності BigBlueButton?';
$string['config_recording_default'] = 'Запис увімкнено за замовчуванням';
$string['config_recording_default_description'] = 'Чи слід увімкнути параметр «Сесію можна записувати» за замовчуванням під час додавання нової кімнати BigBlueButton?';
$string['config_recording_description'] = 'Ці параметри залежать від функції';
$string['config_recording_editable'] = 'Сеанс можна записати, щоб редагувати';
$string['config_recording_editable_description'] = 'Чи можна редагувати "Сесію можна записати" в налаштуваннях активності BigBlueButton?';
$string['config_recording_hide_button_default'] = 'Приховати кнопку запису';
$string['config_recording_hide_button_default_description'] = 'Якщо позначено, кнопка запису буде прихована';
$string['config_recording_hide_button_editable'] = 'Приховати кнопку запису, яку можна редагувати';
$string['config_recording_hide_button_editable_description'] = 'Чи можна редагувати "Сховати кнопку запису" в налаштуваннях активності BigBlueButton?';
$string['config_recording_protect_editable'] = 'Стан захищених записів можна редагувати';
$string['config_recording_protect_editable_description'] = 'Якщо позначено, інтерфейс містить опцію для захисту/зняття захисту записів.';
$string['config_recording_refresh_period'] = 'Період оновлення запису (у секундах)';
$string['config_recording_refresh_period_description'] = 'Як часто потрібно запитувати сервер BigBlueButton, щоб оновити віддалену інформацію для запису?';
$string['config_recording_safe_formats'] = 'Формати записів, доступні для перегляду всім';
$string['config_recording_safe_formats_description'] = 'Виберіть формати, доступні для перегляду всім. Усі інші формати можуть переглядати лише вчителі та інші користувачі з можливостями mod/bigbluebuttonbn:viewallrecordingformats і mod/bigbluebuttonbn:managerecordings.';
$string['config_recordingready_enabled'] = 'Надіслати сповіщення про доступний запис';
$string['config_recordingready_enabled_description'] = 'Якщо ввімкнено, сповіщення буде надіслано, коли буде доступне посилання на запис. Для цієї функції потрібно ввімкнути сценарій post_publish_recording_ready_callback на сервері BigBlueButton.';
$string['config_recordings'] = 'Показати записи';
$string['config_recordings_asc_sort'] = 'Перерахуйте записи в хронологічному порядку';
$string['config_recordings_asc_sort_description'] = 'Записи впорядковуються за датою в хронологічному або зворотному хронологічному порядку (найновіший запис спочатку).';
$string['config_recordings_deleted_default'] = 'Включати записи з видалених активностей доступних за замовчуванням';
$string['config_recordings_deleted_default_description'] = 'Якщо ввімкнено, таблиця запису включатиме записи про будь-які дії, які були видалені.';
$string['config_recordings_deleted_editable'] = 'Включати записів із видалених активностей, що можна редагувати';
$string['config_recordings_deleted_editable_description'] = 'Включати записи із видалених дій за замовчуванням можна редагувати, коли екземпляр додається або оновлюється.';
$string['config_recordings_description'] = 'Ці параметри залежать від функції';
$string['config_recordings_general'] = 'Показати настройки запису';
$string['config_recordings_general_description'] = 'Ці параметри використовуються лише під час показу записів';
$string['config_recordings_imported_default'] = 'Показати лише імпортовані посилання, включено за замовчуванням';
$string['config_recordings_imported_default_description'] = 'Якщо увімкнено, таблиця запису буде містити лише імпортовані посилання на записи.';
$string['config_recordings_imported_editable'] = 'Функцію "Показати лише імпортовані посилання" можна редагувати';
$string['config_recordings_imported_editable_description'] = 'Show only imported links by default can be edited when the instance is added or updated.';
$string['config_recordings_preview_default'] = 'Preview is enabled by default';
$string['config_recordings_preview_default_description'] = 'If enabled the table includes a preview of the presentation.';
$string['config_recordings_preview_editable'] = 'Preview feature can be edited';
$string['config_recordings_preview_editable_description'] = 'Preview feature can be edited when the instance is added or updated.';
$string['config_scheduled'] = 'Заплановані сесії';
$string['config_scheduled_description'] = 'Ці параметри визначають поведінку за замовчуванням для запланованих сеансів.';
$string['config_scheduled_pre_opening'] = 'Доступ до відкриття';
$string['config_scheduled_pre_opening_description'] = 'Час у хвилинах, протягом якого приміщення відкрито до запланованого часу відкриття.';
$string['config_server_url'] = 'URL-адреса BigBlueButton сервера';
$string['config_server_url_description'] = 'URL-адреса вашого сервера BigBlueButton.';
$string['config_shared_secret'] = 'BigBlueButton Shared Secret';
$string['config_shared_secret_description'] = 'Секрет безпеки вашого сервера BigBlueButton.';
$string['config_showpresentation_default'] = 'Показати файл презентації на сторінці активності';
$string['config_showpresentation_default_description'] = 'Чи повинні студенти мати доступ до файлу презентації до сесії? Цей параметр не впливає на користувачів із можливістю «Завжди переглядати файл презентації на сторінці активності».';
$string['config_showpresentation_editable'] = 'Параметр «Показати файл презентації на сторінці активності».';
$string['config_showpresentation_editable_description'] = 'У налаштуваннях діяльності вчителі можуть вибрати, чи показувати файл презентації учням.';
$string['config_uidelegation_enabled'] = 'UI delegation is enabled';
$string['config_uidelegation_enabled_description'] = 'These settings enable or disable the UI delegation to the BigBlueButton server.';
$string['config_userlimit'] = 'Ліміт користувача';
$string['config_userlimit_default'] = 'User limit enabled by default';
$string['config_userlimit_default_description'] = 'Кількість користувачів, дозволених у сеансі за замовчуванням, коли додається нова кімната. Встановіть 0, щоб дозволити необмежену кількість користувачів.';
$string['config_userlimit_description'] = 'These settings enable or disable options in the UI and also define default values for these options.';
$string['config_userlimit_editable'] = 'User limit feature can be edited';
$string['config_userlimit_editable_description'] = 'User limit value by default can be edited when the room or conference is added or updated.';
$string['config_voicebridge'] = 'Голосовий міст';
$string['config_voicebridge_description'] = 'These settings enable or disable options in the UI and also define default values for these options.';
$string['config_voicebridge_editable'] = 'Conference voice bridge can be edited';
$string['config_voicebridge_editable_description'] = 'Номер голосового моста конференції можна призначити кімнаті назавжди. Якщо номер призначений, його не можна використовувати для інших кімнат.';
$string['config_waitformoderator'] = 'Очікування на модератора';
$string['config_waitformoderator_cache_ttl'] = 'Wait for moderator cache TTL (seconds)';
$string['config_waitformoderator_cache_ttl_description'] = 'To support a heavy load of clients this plugin makes use of a cache. This parameter defines the time the cache will be kept before the next request is sent to the BigBlueButton server.';
$string['config_waitformoderator_default'] = 'Очікування на модератора увімкнена за замовчуванням';
$string['config_waitformoderator_default_description'] = 'Чи слід увімкнути параметр «Зачекати модератора» за замовчуванням під час додавання нової кімнати BigBlueButton?';
$string['config_waitformoderator_description'] = 'Ці параметри залежать від функції';
$string['config_waitformoderator_editable'] = 'Зачекайте, поки модератор зможе редагувати';
$string['config_waitformoderator_editable_description'] = 'Чи можна редагувати "Зачекати модератора" в налаштуваннях активності BigBlueButton?';
$string['config_waitformoderator_ping_interval'] = 'Wait for moderator ping (seconds)';
$string['config_waitformoderator_ping_interval_description'] = 'Як часто потрібно запитувати сервер, щоб перевірити, чи зайшов модератор до кімнати?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton використовує config.php із глобальною змінною, яка не підтримується. Будь ласка, конвертуйте файл, оскільки він не підтримуватиметься в наступних версіях.';
$string['config_warning_curl_not_installed'] = 'This feature requires the CURL extension for php installed and enabled. The settings will be accessible only if this condition is fulfilled.';
$string['config_welcome_default'] = 'Привітальне повідомлення за замовчуванням';
$string['config_welcome_default_description'] = 'Вітальне повідомлення відображається, коли учасники заходять до кімнати. Якщо поле залишити порожнім, використовується мовний рядок "mod_form_field_welcome_default".';
$string['config_welcome_editable'] = 'Привітальне повідомлення за замовчуванням доступне для редагування викладачами';
$string['config_welcome_editable_description'] = 'Вітальне повідомлення можна редагувати, коли екземпляр додається або оновлюється';
$string['credentials_warning'] = 'Термін дії облікових даних сервера за замовчуванням скоро закінчиться (див. примітку вище, щоб отримати нові облікові дані).';
$string['end_session_confirm'] = 'Ви впевнені, що хочете завершити сеанс?';
$string['end_session_confirm_title'] = 'Справді закінчити сесію?';
$string['end_session_notification'] = 'Сесія закінчилася.';
$string['ends_at'] = 'Закінчується';
$string['event_activity_created'] = 'Створена діяльність BigBlueButtonBN';
$string['event_activity_deleted'] = 'Діяльність BigBlueButtonBN видалена';
$string['event_activity_updated'] = 'Діяльність оновлено';
$string['event_live_session'] = 'Подія сесії в прямому ефірі';
$string['event_meeting_created'] = 'Зустріч BigBlueButtonBN створена';
$string['event_meeting_ended'] = 'Зустріч BigBlueButtonBN примусово закінчилася';
$string['event_meeting_joined'] = 'BigBlueButtonBN meeting joined';
$string['event_meeting_left'] = 'BigBlueButtonBN meeting left';
$string['event_recording_deleted'] = 'Запис видалено';
$string['event_recording_edited'] = 'Запис змінено';
$string['event_recording_imported'] = 'Запис імпортовано';
$string['event_recording_protected'] = 'Запис із захистом';
$string['event_recording_published'] = 'Запис опублікований';
$string['event_recording_unprotected'] = 'Запис без захисту';
$string['event_recording_unpublished'] = 'Запис неопубліковано';
$string['event_recording_viewed'] = 'Запис переглянуто';
$string['event_unknown'] = 'Невідома подія';
$string['general_error_cannot_create_meeting'] = 'Неможливо створити сеанс.';
$string['general_error_cannot_get_recordings'] = 'Не вдається отримати записи.';
$string['general_error_no_answer'] = 'Порожня відповідь. Будь ласка, перевірте URL-адресу сервера BigBlueButton І перевірте, чи працює сервер BigBlueButton.';
$string['general_error_not_allowed_to_create_instances'] = 'Користувачеві заборонено створювати будь-які типи екземплярів.';
$string['general_error_not_found'] = 'Не вдається знайти дію BigBlueButton з ідентифікатором {$a}.';
$string['general_error_unable_connect'] = 'Не може підключитися. Будь ласка, перевірте URL-адресу сервера BigBlueButton І перевірте, чи працює сервер BigBlueButton. Деталі : {$a}';
$string['guest_invitation_full_message'] = 'Привіт,
<p>Вас запросили на сеанс BigBlueButton <strong>{$a->name}</strong> у курсі {$a->course_fullname}.</p>
<p>Посилання: {$a->guestjoinurl}<br/>
<p>Пароль: {$a->guestpassword}</p>
<p>Якщо вам потрібна допомога, зверніться до {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Привіт,
Вас запросили на сеанс BigBlueButton {$a->name} у курсі {$a->course_fullname}.

Посилання: {$a->guestjoinurl} Пароль: {$a->guestpassword}

Якщо вам потрібна допомога, зверніться до {$a->sender}.';
$string['guest_invitation_subject'] = 'Запрошення: {$a->name} сесія в {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Діяльність не знайдена.';
$string['guestaccess_add'] = 'Додайте гостей';
$string['guestaccess_add_no_id'] = 'Ідентифікатор екземпляра BigBlueButton не надано.';
$string['guestaccess_copy_link'] = 'Копіювати посилання';
$string['guestaccess_copy_password'] = 'Копіювати пароль';
$string['guestaccess_emails'] = 'Електронні листи гостей';
$string['guestaccess_emails_help'] = 'Список адрес електронної пошти, розділених комами.';
$string['guestaccess_emails_invalidemail'] = 'Недійсна електронна адреса: {$a}';
$string['guestaccess_feature_disabled'] = 'Гостьовий доступ вимкнено.';
$string['guestaccess_invite_failure'] = 'Помилка {$a->errors} під час запрошення {$a->emails}.';
$string['guestaccess_invite_success'] = 'Запрошення буде надіслано на адресу {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Приєднатися до зустрічі';
$string['guestaccess_meeting_invalid_password'] = 'Неправильний пароль.';
$string['guestaccess_meeting_link'] = 'Посилання на зустріч';
$string['guestaccess_meeting_not_started'] = 'Зустріч ще не почалася. Будь ласка, поверніться пізніше.';
$string['guestaccess_meeting_password'] = 'Пароль зустрічі';
$string['guestaccess_password'] = 'Пароль';
$string['guestaccess_title'] = 'Додайте гостей до цієї зустрічі';
$string['guestaccess_username'] = 'Ім\'я користувача гостя';
$string['index_confirm_end'] = 'Бажаєте завершити сесію?';
$string['index_disabled'] = 'вимкнено';
$string['index_enabled'] = 'увімкнено';
$string['index_ending'] = 'Завершення сеансу... будь ласка, зачекайте';
$string['index_error_bbtn'] = 'Ідентифікатор BigBlueButton {$a} неправильний';
$string['index_error_checksum'] = 'Сталася помилка контрольної суми. Будь ласка, переконайтеся, що ви ввели правильний секрет.';
$string['index_error_forciblyended'] = 'Неможливо приєднатися до сеансу, оскільки його було завершено вручну.';
$string['index_error_noinstances'] = 'Немає екземплярів кімнат BigBlueButton';
$string['index_error_unable_display'] = 'Неможливо відобразити сеанси. Будь ласка, перевірте URL-адресу сервера BigBlueButton І перевірте, чи працює сервер BigBlueButton.';
$string['index_heading'] = 'Кімнати BigBlueButton';
$string['index_heading_actions'] = 'Дії';
$string['index_heading_group'] = 'Група';
$string['index_heading_moderator'] = 'Модератори';
$string['index_heading_name'] = 'Кімната';
$string['index_heading_recording'] = 'Запис';
$string['index_heading_users'] = 'Користувачі';
$string['index_heading_viewer'] = 'Спостерігачі';
$string['indicator:cognitivedepth'] = 'BigBlueButton когнітивний';
$string['indicator:cognitivedepth_help'] = 'Цей показник ґрунтується на глибині когнітивної діяльності, досягнутої студентом під час дії BigBlueButton.';
$string['indicator:socialbreadth'] = 'BigBlueButton соц';
$string['indicator:socialbreadth_help'] = 'Цей показник заснований на соціальному розширенні, досягнутому студентом у діяльності BigBlueButton.';
$string['instance_type_default'] = 'Кімната із записами';
$string['instance_type_recording_only'] = 'Тільки записи';
$string['instance_type_room_only'] = 'Тільки кімната';
$string['instanceprofilewithoutrecordings'] = 'Цей профіль екземпляра не може відображати записи';
$string['managebbbextplugins'] = 'Керуйте плагінами розширення BigBlueButton';
$string['messageprovider:instance_updated'] = 'Сесію BigBlueButton оновлено';
$string['messageprovider:recording_ready'] = 'Доступний запис BigBlueButton';
$string['minute'] = 'хвилина';
$string['minutes'] = 'хвилин';
$string['mod_form_block_general'] = 'Загальне';
$string['mod_form_block_guestaccess'] = 'Гостьовий доступ';
$string['mod_form_block_participants'] = 'Учасники';
$string['mod_form_block_presentation'] = 'Зміст презентації';
$string['mod_form_block_presentation_default'] = 'Вміст презентації за замовчуванням';
$string['mod_form_block_record'] = 'Налаштування запису';
$string['mod_form_block_recordings'] = 'Перегляд запису';
$string['mod_form_block_room'] = 'Параметри кімнати';
$string['mod_form_block_schedule'] = 'Хронометраж сесії';
$string['mod_form_field_closingtime'] = 'Закрити';
$string['mod_form_field_conference_name'] = 'Назва сеансу';
$string['mod_form_field_disablecam'] = 'Вимкнути камери';
$string['mod_form_field_disablemic'] = 'Вимкнути мікрофони';
$string['mod_form_field_disablenote'] = 'Вимкнути загальні примітки';
$string['mod_form_field_disableprivatechat'] = 'Вимкнути приватний чат';
$string['mod_form_field_disablepublicchat'] = 'Вимкнути загальний чат';
$string['mod_form_field_duration'] = 'Тривалість';
$string['mod_form_field_duration_help'] = 'Setting the duration for a meeting will establish the maximum time for a meeting to keep alive before the recording finish';
$string['mod_form_field_guestallowed'] = 'Дозволити гостьовий доступ';
$string['mod_form_field_hideuserlist'] = 'Сховати перелік користувачів';
$string['mod_form_field_instanceprofiles'] = 'Тип екземпляру';
$string['mod_form_field_instanceprofiles_help'] = 'Якщо сеанс потрібно записати, виберіть «Кімната із записами», інакше «Лише кімната». Після запису сеансу, якщо сеансів більше не буде, виберіть «Лише записи».';
$string['mod_form_field_intro'] = 'Опис';
$string['mod_form_field_intro_help'] = 'Короткий опис кімнати.';
$string['mod_form_field_mustapproveuser'] = 'Для приєднання гостей має дати дозвіл модератора';
$string['mod_form_field_muteonstart'] = 'Вимкнення звуку на початку';
$string['mod_form_field_name'] = 'Назва кімнати';
$string['mod_form_field_nosettings'] = 'Налаштування не можна змінювати';
$string['mod_form_field_openingtime'] = 'Відкрито';
$string['mod_form_field_participant_add'] = 'Додати правонаступника';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Модератор';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Спостерігач';
$string['mod_form_field_participant_list'] = 'Правоодержувач';
$string['mod_form_field_participant_list_action_add'] = 'Додати';
$string['mod_form_field_participant_list_action_remove'] = 'Видалити';
$string['mod_form_field_participant_list_text_as'] = 'як';
$string['mod_form_field_participant_list_type_all'] = 'Усі зареєстровані користувачі';
$string['mod_form_field_participant_list_type_owner'] = 'Власник';
$string['mod_form_field_participant_list_type_role'] = 'Роль';
$string['mod_form_field_participant_list_type_user'] = 'Користувач';
$string['mod_form_field_record'] = 'Сеанс може бути записаний.';
$string['mod_form_field_recordallfromstart'] = 'Записувати все з початку';
$string['mod_form_field_recordhidebutton'] = 'Приховати кнопку запису';
$string['mod_form_field_recordings_deleted'] = 'Включати записи із видалених активностей';
$string['mod_form_field_recordings_html'] = 'Показувати таблицю у звичайному HTML';
$string['mod_form_field_recordings_imported'] = 'Показати лише імпортовані посилання';
$string['mod_form_field_recordings_preview'] = 'Показати попередній перегляд запису';
$string['mod_form_field_room_name'] = 'Назва  кімнати';
$string['mod_form_field_showpresentation'] = 'Показати файл презентації на сторінці активності';
$string['mod_form_field_userlimit'] = 'Ліміт користувачів';
$string['mod_form_field_userlimit_help'] = 'Максимальна кількість користувачів, дозволена під час сеансу. Встановіть 0, щоб дозволити необмежену кількість користувачів.';
$string['mod_form_field_voicebridge'] = 'Голосовий міст [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Format error. You should input a number between 1 and 9999.';
$string['mod_form_field_voicebridge_help'] = 'Число від 1 до 9999, яке учасники вводять, щоб приєднатися до голосового сеансу під час використання телефонного зв’язку. Якщо значення дорівнює 0, то статичний номер голосового мосту буде проігноровано, а BigBlueButton згенерує випадкове число. Перед чотирма введеними цифрами буде число 7.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Не унікальне значення. Цим номером користується інша кімната.';
$string['mod_form_field_wait'] = 'Чекати модератора';
$string['mod_form_field_wait_help'] = 'Чи повинні учасники чекати модератора, перш ніж увійти до кімнати?';
$string['mod_form_field_welcome'] = 'Повідомлення-привітання';
$string['mod_form_field_welcome_default'] = 'Ласкаво просимо до %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Вітальне повідомлення відображається, коли учасники входять до кімнати. Якщо поле залишено порожнім, то відображається повідомлення за замовчуванням, встановлене в адмініструванні сайту.';
$string['mod_form_locksettings'] = 'Налаштування блокування';
$string['modulename'] = 'BigBlueButtonBN';
$string['modulename_help'] = 'BigBlueButton — це система веб-конференцій з відкритим кодом, розроблена для онлайн-навчання, яка підтримує обмін аудіо, відео, чат, слайди, спільне використання екрана, багатокористувацьку дошку, кімнати для груп, опитування та смайли в режимі реального часу.

Використовуючи BigBlueButton, ви можете створити кімнату для таких сесій, як онлайн-заняття, віртуальні робочі години або групова співпраця з віддаленими студентами. Сеанс можна записати для подальшого відтворення.';
$string['modulename_link'] = 'BigBlueButtonBN/view';
$string['modulenameplural'] = 'BigBlueButtonBN';
$string['new_bigblubuttonbn_activities'] = 'Активність BigBlueButton';
$string['nosuchinstance'] = 'Немає такого екземпляра {$a->entity} з ідентифікатором {$a->id}';
$string['notification_instance_created_intro'] = 'Кімнату BigBlueButton {$a->name} створено.';
$string['notification_instance_created_small'] = 'Створено нову кімнату BigBlueButton з назвою {$a->name}.';
$string['notification_instance_created_subject'] = 'Створено нову кімнату BigBlueButton';
$string['notification_instance_description'] = 'Опис';
$string['notification_instance_end_date'] = 'Дата закінчення';
$string['notification_instance_name'] = 'Назва';
$string['notification_instance_start_date'] = 'Дата початку';
$string['notification_instance_updated_intro'] = 'Кімнату BigBlueButton {$a->name} оновлено.';
$string['notification_instance_updated_small'] = 'Сеанс BigBlueButton {$a->name} оновлено';
$string['notification_instance_updated_subject'] = 'Вашу кімнату BigBlueButton оновлено';
$string['notification_recording_ready_html'] = 'Тепер доступний запис для сеансу в кімнаті BigBlueButton {$a->name}.';
$string['notification_recording_ready_plain'] = 'Тепер доступний запис для сеансу в кімнаті BigBlueButton {$a->name}. Перейдіть до {$a->link}, щоб отримати доступ до посилання на запис.';
$string['notification_recording_ready_small'] = 'Для кімнати BigBlueButton {$a->name} доступний запис.';
$string['notification_recording_ready_subject'] = 'Запис доступний';
$string['pluginadministration'] = 'BigBlueButton administration';
$string['pluginname'] = 'BigBlueButtonBN';
$string['privacy:metadata:bigbluebutton'] = 'Для створення та приєднання до сесій BigBlueButton  потрібно обмінятися з сервером  даними користувачів.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Повне ім’я користувача, який отримує доступ до сервера BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'Ідентифікатор користувача, який отримує доступ до сервера BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Конфігурація сеансу BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Список правил, які визначають роль користувачів у сеансі BigBlueButton. Ідентифікатор користувача може зберігатися, оскільки дозволи можуть бути надані для ролі або для кожного користувача.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Зберігає події, що спрацьовують під час використання плагіна.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Тип події, викликаної користувачем.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'Ідентифікатор сеансу, до якого користувач мав доступ.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Додаткова інформація, пов’язана із сеансом або записом.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Час створення журналу.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'Ідентифікатор користувача користувача, який ініціював подію.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Зберігає метадані про записи.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'Ідентифікатор користувача, який останній змінив запис.';
$string['progress_createbigbluebuttonbn'] = 'Створення дії BigBlueButton ({$a})';
$string['recordings_from_deleted_activities'] = 'Записи видалених дій';
$string['recordingurlnotfound'] = 'URL-адреса запису недійсна.';
$string['removedevents'] = 'Видалені події';
$string['removedlogs'] = 'Видалені користувацькі журнали';
$string['removedrecordings'] = 'Видалені записи';
$string['removedtags'] = 'Видалені теги';
$string['report_join_info'] = '{$a} зустріч(і)';
$string['report_play_recording_info'] = 'Відтворено {$a} запис(ів).';
$string['report_room_view'] = 'переглянуто';
$string['resetevents'] = 'Видалити події';
$string['resetlogs'] = 'Видалити журнали';
$string['resetlogs_help'] = 'Видалення журналів призведе до втрати посилань на записи.';
$string['resetrecordings'] = 'Видалити записи';
$string['resetrecordings_help'] = 'Видалення записів зробить їх недоступними з будь-якого місця. Цю дію неможливо скасувати!';
$string['resettags'] = 'Видалити теги';
$string['search:activity'] = 'BigBlueButton - інформація про активність';
$string['search:tags'] = 'BigBlueButton - інформація про теги';
$string['sendnotification'] = 'Надіслати сповіщення';
$string['settings'] = 'Налаштування BigBlueButton';
$string['settings_credential_warning'] = 'Термін дії облікових даних сервера BigBlueButton скоро закінчиться. Перегляньте <a href="{$a->settingslink}" target="_blank">загальні налаштування BigBlueButton (відкривається в новому вікні)</a>.';
$string['settings_credential_warning_no_capability'] = 'Термін дії облікових даних сервера BigBlueButton скоро закінчиться. Будь ласка, зверніться до адміністратора сайту.';
$string['started_at'] = 'Почато';
$string['starts_at'] = 'Починається';
$string['subplugintype_bbbext'] = 'Розширення активності BigBlueButton';
$string['subplugintype_bbbext_plural'] = 'Розширення діяльності BigBlueButton';
$string['taskname:check_dismissed_recordings'] = 'Перевірте записи, які ще не знайдено';
$string['taskname:check_pending_recordings'] = 'Отримати незавершені записи';
$string['userlimitreached'] = 'Досягнуто дозволеної кількості користувачів у сеансі.';
$string['view_conference_action_end'] = 'Завершити сеанс';
$string['view_conference_action_join'] = 'Приєднатися ...';
$string['view_error_action_not_completed'] = 'Дію не вдалося завершити';
$string['view_error_bigbluebutton'] = 'BigBlueButton відповів з помилками. {$a}';
$string['view_error_create'] = 'Сервер BigBlueButton відповів повідомленням про помилку. Не вдалося створити кімнату.';
$string['view_error_current_state_not_found'] = 'Поточний стан не знайдено. Запис може бути видалено або сервер BigBlueButton не сумісний з виконаною дією.';
$string['view_error_import_no_courses'] = 'Немає курсів для пошуку записів.';
$string['view_error_import_no_recordings'] = 'У цьому курсі немає записів для імпорту.';
$string['view_error_invalid_session'] = 'Сеанс закінчився. Поверніться на сторінку активності.';
$string['view_error_max_concurrent'] = 'Досягнуто дозволеної кількості одночасних сеансів.';
$string['view_error_meeting_not_running'] = 'Щось пішло не так; сеанс не виконується.';
$string['view_error_no_group'] = 'Груп немає. Вам потрібно створити кілька груп, перш ніж намагатися приєднатися до сеансу.';
$string['view_error_no_group_student'] = 'Вас не додали до групи. Будь ласка, зверніться до свого вчителя.';
$string['view_error_no_group_teacher'] = 'Неможливо увійти в кімнату. Будь ласка, перевірте URL-адресу сервера BigBlueButton І перевірте, чи працює сервер BigBlueButton.';
$string['view_error_unable_join'] = 'Неможливо увійти в кімнату. Будь ласка, перевірте URL-адресу сервера BigBlueButton І перевірте, чи працює сервер BigBlueButton.';
$string['view_error_unable_join_student'] = 'Не вдається підключитися до сервера BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'Не вдається підключитися до сервера BigBlueButton. Зверніться до адміністратора.';
$string['view_error_url_missing_parameters'] = 'У цій URL-адресі відсутні параметри';
$string['view_error_userlimit_reached'] = 'Досягнуто обмеження кількості користувачів, дозволених у сеансі.';
$string['view_groups_nogroups_warning'] = 'Кімната була налаштована для використання груп, але на курсі не визначено груп.';
$string['view_groups_notenrolled_warning'] = 'Кімнату налаштовано для використання груп, але ви не є членом групи.';
$string['view_groups_selection'] = 'Виберіть групу, до якої потрібно приєднатися, та підтвердьте дію';
$string['view_groups_selection_join'] = 'Приєднатися';
$string['view_groups_selection_warning'] = 'Для кожної групи є кімната, і у вас є доступ до кількох. Обов’язково виберіть правильний.';
$string['view_login_moderator'] = 'Вхід як модератор ...';
$string['view_login_viewer'] = 'Вхід як спостерігач ...';
$string['view_message_and'] = 'і';
$string['view_message_conference_has_ended'] = 'Сесія закінчилася.';
$string['view_message_conference_in_progress'] = 'Сесія триває.';
$string['view_message_conference_not_started'] = 'Сесія ще не розпочалася.';
$string['view_message_conference_room_ready'] = 'Ця кімната готова. Ви можете приєднатися до сесії зараз.';
$string['view_message_conference_user_limit_reached'] = 'Досягнуто обмеження кількості користувачів, дозволених у сеансі.';
$string['view_message_conference_wait_for_moderator'] = 'Очікування приєднання модератора.';
$string['view_message_cron_disabled'] = 'Список записів може бути неактуальним. Будь ласка, зверніться до адміністратора сайту з такою інформацією: {$a}';
$string['view_message_finished'] = 'Діяльність завершена.';
$string['view_message_has_joined'] = 'приєднався';
$string['view_message_have_joined'] = 'приєдналися';
$string['view_message_hour'] = 'год.';
$string['view_message_hours'] = 'год.';
$string['view_message_importrecordings_disabled'] = 'Імпорт посилань на запис вимкнено на сервері.';
$string['view_message_minute'] = 'хв.';
$string['view_message_minutes'] = 'хв.';
$string['view_message_moderator'] = 'Модератор';
$string['view_message_moderators'] = 'Модератори';
$string['view_message_norecordings'] = 'Немає доступних записів.';
$string['view_message_notavailableyet'] = 'Цей сеанс ще недоступний.';
$string['view_message_recordings_disabled'] = 'Записи на сервері вимкнені. Не можна використовувати дії BigBlueButton типу "Лише записи".';
$string['view_message_room_closed'] = 'Ця кімната закрита.';
$string['view_message_room_open'] = 'Ця кімната відкрита.';
$string['view_message_room_ready'] = 'Ця кімната готова.';
$string['view_message_session_for'] = 'сеанс для';
$string['view_message_session_has_user'] = 'Є';
$string['view_message_session_has_users'] = 'Є';
$string['view_message_session_no_users'] = 'У цьому сеансі немає користувачів';
$string['view_message_session_running_for'] = 'Цей сеанс вже запущений';
$string['view_message_session_started_at'] = 'Сеанс розпочався о';
$string['view_message_tab_close'] = 'Цю вкладку / вікно потрібно закрити вручну';
$string['view_message_times'] = 'разів';
$string['view_message_user'] = 'Користувач';
$string['view_message_users'] = 'Користувачі';
$string['view_message_viewer'] = 'Спостерігач';
$string['view_message_viewers'] = 'Спостерігачі';
$string['view_mobile_message_groups_not_supported'] = 'Цей екземпляр увімкнено для роботи з групами, але мобільний додаток ще не підтримує його. Будь ласка, використовуйте веб-версію.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Ви перевищили 45 секунд на цій сторінці. Оновіть сторінку, щоб приєднатися до сеансу.';
$string['view_noguests'] = 'Кімната BigBlueButton не відкрита для гостей.';
$string['view_nojoin'] = 'У вас немає ролі, якій дозволено приєднатися до цього сеансу.';
$string['view_recording'] = 'запис';
$string['view_recording_actionbar'] = 'Панель інструментів';
$string['view_recording_activity'] = 'Діяльність';
$string['view_recording_button_import'] = 'Імпортувати посилання на запис';
$string['view_recording_button_return'] = 'Повернутися назад';
$string['view_recording_course'] = 'Курс';
$string['view_recording_date'] = 'Дата';
$string['view_recording_delete_confirmation'] = 'Ви впевнені, що хочете видалити {$a}?';
$string['view_recording_delete_confirmation_warning_p'] = 'З цим записом пов’язано {$a} посилань, які було імпортовано в різні курси чи заходи. Якщо запис буде видалено, ці посилання також буде видалено.';
$string['view_recording_delete_confirmation_warning_s'] = 'Цей запис пов’язано з посиланням {$a}, яке було імпортовано в інший курс або діяльність. Якщо запис буде видалено, це посилання також буде видалено.';
$string['view_recording_description'] = 'Опис';
$string['view_recording_description_edithint'] = 'Можна додати опис, щоб допомогти ідентифікувати запис.';
$string['view_recording_description_editlabel'] = 'Редагувати опис';
$string['view_recording_duration'] = 'Тривалість';
$string['view_recording_duration_min'] = 'хв.';
$string['view_recording_format_errror_unreachable'] = 'URL-адреса цього формату запису недосяжна.';
$string['view_recording_format_notes'] = 'Примітки';
$string['view_recording_format_podcast'] = 'подкаст';
$string['view_recording_format_presentation'] = 'презентація';
$string['view_recording_format_screenshare'] = 'показ екрану';
$string['view_recording_format_statistics'] = 'статистика';
$string['view_recording_format_video'] = 'відео';
$string['view_recording_import_confirmation'] = 'Ви впевнені, що хочете імпортувати цей запис?';
$string['view_recording_length'] = 'Довжина';
$string['view_recording_link'] = 'імпортоване посилання';
$string['view_recording_link_warning'] = 'Це посилання, яке вказує на запис, створений під час іншого курсу або діяльності.';
$string['view_recording_list_action_delete'] = 'Видалення';
$string['view_recording_list_action_edit'] = 'Оновлення';
$string['view_recording_list_action_play'] = 'Відтворити';
$string['view_recording_list_action_process'] = 'Обробка';
$string['view_recording_list_action_protect'] = 'Захист';
$string['view_recording_list_action_publish'] = 'Публікування';
$string['view_recording_list_action_unprotect'] = 'Зняти захист';
$string['view_recording_list_action_unpublish'] = 'Скасування публікації';
$string['view_recording_list_action_update'] = 'Оновлення';
$string['view_recording_list_actionbar'] = 'Панель інструментів';
$string['view_recording_list_actionbar_delete'] = 'Видалити';
$string['view_recording_list_actionbar_edit'] = 'Редагувати';
$string['view_recording_list_actionbar_hide'] = 'Сховати';
$string['view_recording_list_actionbar_import'] = 'Імпорт';
$string['view_recording_list_actionbar_protect'] = 'Зробити це приватним';
$string['view_recording_list_actionbar_publish'] = 'Опублікувати';
$string['view_recording_list_actionbar_show'] = 'Показати';
$string['view_recording_list_actionbar_unprotect'] = 'Зробити це загальнодоступним';
$string['view_recording_list_actionbar_unpublish'] = 'Скасувати публікацію';
$string['view_recording_list_activity'] = 'Діяльність';
$string['view_recording_list_course'] = 'Курс';
$string['view_recording_list_date'] = 'Дата';
$string['view_recording_list_description'] = 'Опис';
$string['view_recording_list_duration'] = 'Тривалість';
$string['view_recording_list_recording'] = 'Запис';
$string['view_recording_meeting'] = 'Зустріч';
$string['view_recording_modal_button'] = 'Застосувати';
$string['view_recording_modal_title'] = 'Встановити значення для запису';
$string['view_recording_name'] = 'Назва';
$string['view_recording_name_edithint'] = 'Можна додати ім’я, щоб допомогти ідентифікувати запис.';
$string['view_recording_name_editlabel'] = 'Редагувати назву';
$string['view_recording_playback'] = 'Відтворення';
$string['view_recording_preview'] = 'Попередній перегляд';
$string['view_recording_preview_help'] = 'Наведіть курсор на зображення, щоб переглянути його у повному розмірі';
$string['view_recording_protect_confirmation'] = 'Ви впевнені, що хочете захистити цей {$a}?';
$string['view_recording_protect_confirmation_warning_p'] = 'З цим записом пов’язано {$a} посилань, які було імпортовано в різні курси чи заходи. Якщо запис захищений, це також вплине на імпортовані посилання.';
$string['view_recording_protect_confirmation_warning_s'] = 'Цей запис пов’язано з посиланням {$a}, яке було імпортовано в інший курс або діяльність. Якщо запис захищений, це також вплине на імпортовані посилання.';
$string['view_recording_publish_confirmation'] = 'Ви впевнені, що хочете опублікувати цей {$a}?';
$string['view_recording_publish_confirmation_warning_p'] = 'З цим записом пов’язано {$a} посилань, які було імпортовано в різні курси чи заходи. Якщо запис буде опубліковано, ці посилання також будуть опубліковані.';
$string['view_recording_publish_confirmation_warning_s'] = 'Цей запис пов’язано з посиланням {$a}, яке було імпортовано в інший курс або діяльність. Якщо запис буде опубліковано, це посилання також буде опубліковано.';
$string['view_recording_publish_link_deleted'] = 'Це посилання не можна повторно опублікувати, оскільки оригінальний запис не існує на сервері BigBlueButton. Посилання слід видалити.';
$string['view_recording_publish_link_not_published'] = 'Це посилання не можна опублікувати повторно, оскільки вихідний запис скасовано.';
$string['view_recording_recording'] = 'Запис';
$string['view_recording_select_course'] = 'Спочатку виберіть курс у спадному меню';
$string['view_recording_tags'] = 'Теги';
$string['view_recording_unprotect_confirmation'] = 'Ви впевнені, що хочете зняти захист цього {$a}?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'З цим записом пов’язано {$a} посилань, які було імпортовано в різні курси чи заходи. Якщо запис незахищений, це також вплине на імпортовані посилання.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Цей запис пов’язано з посиланням {$a}, яке було імпортовано в інший курс або діяльність. Якщо запис незахищений, це також вплине на імпортовані посилання.';
$string['view_recording_unprotect_link_deleted'] = 'Це посилання не можна зняти з захисту, оскільки оригінальний запис не існує на сервері BigBlueButton. Посилання слід видалити.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Це посилання не можна зняти з захисту, оскільки оригінальний запис захищено.';
$string['view_recording_unpublish_confirmation'] = 'Ви впевнені, що скасовуєте публікацію цього {$a}?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'З цим записом пов’язано {$a} посилань, які було імпортовано в різні курси чи заходи. Якщо запис не опубліковано, ці посилання також буде скасовано.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Цей запис пов’язано з посиланням {$a}, яке було імпортовано в інший курс або діяльність. Якщо запис скасовано, це посилання також буде скасовано.';
$string['view_recording_yui_first'] = 'Спочатку';
$string['view_recording_yui_go'] = 'Старт';
$string['view_recording_yui_last'] = 'Останній';
$string['view_recording_yui_next'] = 'Далі';
$string['view_recording_yui_page'] = 'Сторінка';
$string['view_recording_yui_prev'] = 'Попередній';
$string['view_recording_yui_rows'] = 'Рядки';
$string['view_recording_yui_show_all'] = 'Показати все';
$string['view_room'] = 'Перегляд кімнати';
$string['view_section_title_presentation'] = 'Файл презентації';
$string['view_section_title_recordings'] = 'Записи';
$string['waitformoderator'] = 'Чекаємо на приєднання модератора.';
