<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_pioneer', language 'es_mx', version '5.0'.
 *
 * @package     theme_pioneer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitybackground'] = 'Color del Fondo de Actividad en Curso';
$string['activitybackground_desc'] = 'Este es el color del fondo de la caja al ver actividades tales como lección, tarea, etc.';
$string['allclasses'] = 'Todas las Clases';
$string['allcourses'] = 'Todos los Cursos';
$string['allmodules'] = 'Todos los Módulos';
$string['allunits'] = 'Todas las Unidades';
$string['alwaysdisplay'] = 'Mostrar Siempre';
$string['analyticscleanurl'] = 'URLs limpias';
$string['analyticscleanurldesc'] = 'Generar URLs limpias para seguimiento avanzado';
$string['analyticsenabled'] = 'Habilitado';
$string['analyticsenableddesc'] = 'Habilitar Analytics (Análisis) para Moodle';
$string['analyticsheading'] = 'Google Analytics';
$string['analyticssiteid'] = 'ID del sitio';
$string['analyticssiteiddesc'] = 'Escriba la ID de su sitio';
$string['analyticstrackadmin'] = 'Seguimiento de Admins';
$string['analyticstrackadmindesc'] = 'Habilitar seguimiento de usuarios Admins (no recomendado)';
$string['analyticstrackingid'] = 'ID del sitio';
$string['analyticstrackingiddesc'] = 'Escriba su ID de seguimiento (Tracking ID) de Google';
$string['backgroundfixed'] = 'Fondo fijo';
$string['backgroundfixed_desc'] = 'Use esta configuración para fijar la imagen del fondo a la página.';
$string['backgroundimage'] = 'Imagen del fondo';
$string['backgroundimage_desc'] = 'La imagen a mostrar como fondo del sitio.';
$string['backgroundimageinfo'] = 'Imagen del fondo';
$string['backgroundimageinfodesc'] = 'Dado que el contenido principal está en ancho completo, Usted solamente verá una pequeña parte del color del fondo en la parte inferior de  la página. Usted puede subir una imagen si lo desea.';
$string['backgroundposition'] = 'Posición del fondo';
$string['backgroundposition_desc'] = 'La posición de la imagen del fondo.';
$string['backgroundpositioncenterbottom'] = 'Centrado abajo';
$string['backgroundpositioncentercenter'] = 'Centrado enmedio';
$string['backgroundpositioncentertop'] = 'Centrado superior';
$string['backgroundpositionleftbottom'] = 'Izquierda al fondo';
$string['backgroundpositionleftcenter'] = 'Izquierda al centro';
$string['backgroundpositionlefttop'] = 'Izquierda superior';
$string['backgroundpositionrightbottom'] = 'Derecha al fondo';
$string['backgroundpositionrightcenter'] = 'Derecha enmedio';
$string['backgroundpositionrighttop'] = 'Derecha superior';
$string['backgroundrepeat'] = 'Repetición del fondo';
$string['backgroundrepeat_desc'] = 'Define la forma en que la imagen del fondo se repetirá.';
$string['backgroundrepeatnorepeat'] = 'No repetir';
$string['backgroundrepeatrepeat'] = 'Repetir';
$string['backgroundrepeatrepeatx'] = 'Repetir horizontalmente';
$string['backgroundrepeatrepeaty'] = 'Repetir verticalmente';
$string['blockbordercolor'] = 'Color del Borde del Bloque';
$string['blockbordercolor_desc'] = 'Este es el color del borde del bloque del curso. Es el color del fondo del área del título.';
$string['blockcolor'] = 'Color del Bloque';
$string['blockcolor_desc'] = 'Essta es el área de color del fondo del bloque del curso.';
$string['blockheadercolor'] = 'Color del Encabezado del Bloque';
$string['blockheadercolor_desc'] = 'Este es el color del fondo del encabezado en cada bloque. Use esta configuración si quisiera un color del fondo del encabezado para todos los bloques.';
$string['blockposition'] = 'Alinear Bloques';
$string['blockposition_desc'] = 'Ponwer los bloques a la izquierda o a la derecha del contenido';
$string['blocksdesc'] = 'Alinear bloques a la izquierda o a la derecha de la página';
$string['blocksinfo'] = 'Posición del Bloque';
$string['blocksleft'] = 'Alinear bloques  a la izquierda';
$string['blocksright'] = 'Alinear bloques  a la derecha';
$string['blocktitlecolor'] = 'Color del Texto del Título del Bloque';
$string['blocktitlecolor_desc'] = 'Este es el Color del Texto del Título del Bloque.';
$string['bodybackground'] = 'Color del Fondo';
$string['bodybackground_desc'] = 'El color principal a usar para el fondo.';
$string['bodyfont'] = 'Letra del Cuerpo';
$string['bodyfontdesc'] = 'CUERPO PASO 2: Copie y pegue el código del Font de Google que comienza con font-family (integre los tipos de letra dentro de su CSS)';
$string['bodysize'] = 'Tamaño de Letra del Cuerpo';
$string['bodysizedesc'] = 'Use un número como 14px';
$string['bodyweight'] = 'Peso del Cuerpo';
$string['bodyweightdesc'] = 'Típicamente los tipos de letra (fonts) de Google tendrán un número como 100, 200, 300, 300. Úselo aquí.';
$string['bothpositions'] = 'Ambas posiciones';
$string['breadcrumbcolor'] = 'Color de Ruta de Navegación';
$string['breadcrumbcolor_desc'] = 'Elegir un color del fondo para la barra de la Ruta de Navegación. Esto es justamente debajo de la imagen principal del encabezado en la página.';
$string['breadcrumbcolorhover'] = 'Ruta de navegación al pasar el ratón encima';
$string['breadcrumbcolorhover_desc'] = 'Elija un color del fondo para la barra de la ruta de navegación cuando se pasa el ratón encima de un ítem. Esto es justamente debajo de la imagen del encabezado principal en la página.';
$string['breadcrumbtext'] = 'Color de la Ruta de Navegación';
$string['breadcrumbtext_desc'] = 'Elija un color para la ruta de navegación';
$string['choosereadme'] = '<p>El tema Pionero (Pioneer) es un tema responsivo basado en arranque (bootstrap) para Moodle, altamente personalizable y cargado con grandes características. Este tema es ideal para instituciones educativas y negocios por igual. Pioneer está enfocado a simplicidad y proporciona una experiencia del usuario intuitiva.</p><p>Desarrollado y mantenido por Dearborn Public Schools. Nosotros somos un distrito escolar K-12 en Dearborn, Michigan, Estados Unidos. Pioneer es la mascota de la preparatoria de Dearborn.</p>';
$string['colorheading'] = 'Opciones de Color';
$string['configtitle'] = 'Pioneer';
$string['contentbackground'] = 'Color del Fondo del contenido principal';
$string['contentbackground_desc'] = 'El color del fondo del contenido principal del sitio; déjelo vacío para ninguno.';
$string['contentbackgroundcolor'] = 'Color del Fondo del contenido';
$string['contentbackgroundcolor_desc'] = 'Este es el color del fondo para el área del contenido principal del curso. Si Usted elimina el color aquí, se pondrá predeterminadamente las configuraciones del Fondo del Cuerpo de abajo y también las configuraciones de Imagen del Fondo.';
$string['copyrighttext'] = 'Aviso de Copyright';
$string['copyrighttext_desc'] = 'Añada un aviso de copyright (derecho de autor) para el sitio. Aparecerá en el pie de página.';
$string['coursecomplete'] = 'Visualización de Finalización de Curso Radial';
$string['coursecomplete_desc'] = 'Si un curso usa finalización del curso y se activa ésto, entonces Pioneer mostrará un estatus radial de dinalización para el estudiante en la parte superior izquierda de la página.';
$string['coursegradebutton'] = 'Calificaciones del curso';
$string['coursegradeinfo'] = 'Área del encabezado del Curso (Pestañas de Portada y Calificaciones del Curso)';
$string['coursegradeinfodesc'] = 'Al activar esta casilla se mostrarán a los estudiantes los ítems del Libro de calificaciones del curso en un deslizador/alternador en cada página del curso. Esto hace mucho muy sencillo el que un estudiante vea sus calificaciones para un curso.';
$string['coursegradestext'] = 'Texto del Botón de Calificaciones del curso';
$string['coursegradestextdesc'] = 'Escriba el texto que le gustaría que aparezca para el botón de alternar.';
$string['coursegradetoggle'] = 'Mostrar / ocultar deslizador de Calificación del curso';
$string['coursegradetoggle_desc'] = 'Esto les permitirá a los estudiantes ver rápidamente una lista de todas las actividades y sus calificaciones en el área superior del encabezado arriba de la ruta de navegación y debajo del título del curso.';
$string['coursetitlebkg'] = 'Color del Fondo del Título del Curso';
$string['coursetitlebkg_desc'] = 'Este es el color de la caja que aparece detrás del Título del Curso. También se usa como el color del fondo para el Carrusel del Curso y los Títulos de Cursos Disponibles para crear un aspecto consistente.';
$string['coursetitletxt'] = 'Color del Texto del Título del Curso.';
$string['coursetitletxt_desc'] = 'Este es el color del título del curso.';
$string['createusertoggle'] = 'Enlace para Crear Usuario';
$string['createusertoggle_desc'] = 'Ocultar o Mostrar el enlacepara crear usuario dentro del formato personalizado para ingresar al sitio en la Portada.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Todas las reglas CSS que añada a esta área-de-texto se reflejarán en todas las páginas, haciendo más fácil personalizar este tema.';
$string['customlogindesc'] = 'Opciones personalizadas de Ingreso al sitio';
$string['customlogininfo'] = 'Ingreso personalizado al sitio';
$string['custommenudesc'] = 'Las configuraciones aquí le permiten añadir nueva funcionalidad dinámica al menú personalizado (también llamado menú Desplegable)';
$string['custommenuheadingsub'] = 'Añadir funcionalidad adicional a su menú personalizado.';
$string['displayafterlogin'] = 'Mostrar solamente después de ingresar al sitio';
$string['displaybeforelogin'] = 'Mostrar solamente antes de ingresar al sitio';
$string['displaymycourses'] = 'Mostrar cursos inscritos';
$string['displaymycoursesdesc'] = 'Mostrar cursos inscritos para usuarios en el menú Personalizado';
$string['displaymydashboard'] = 'Mostrar Tablero';
$string['displaymydashboarddesc'] = 'Mostrar Tablero de enlaces del usuario en el Menú Personalizado';
$string['dontdisplay'] = 'Nunca Mostrar';
$string['editoff'] = 'Edición desactivada';
$string['editon'] = 'Edición activada';
$string['enablethiscourse'] = 'Menú de Actividad del Curso';
$string['enablethiscoursedesc'] = 'Mostrar un menú desplegable de actividades del curso.';
$string['footertext1'] = 'Caja_de_texto de Pie de página Uno';
$string['footertext2'] = 'Caja_de_texto de Pie de página Dos';
$string['footertext3'] = 'Caja_de_texto de Pie de página Tres';
$string['footertext4'] = 'Caja_de_texto de Pie de página Cuatro';
$string['footertext_desc'] = 'Escriba texto HTML y aparecerá al fondo de cada página. Se usan cuatro columnas con Bootstrap <span3>.';
$string['footertextboxes'] = 'Pie de página personalizado';
$string['forgotpasstoggle'] = 'Enlace para olvido de contraseña';
$string['forgotpasstoggle_desc'] = 'Ocultar o mostrar el enlace para Contraseña olvidada en el formato personalizado para ingresar al sitio en la Portada.';
$string['fpcreatortextbox'] = 'Caja_de_texto de Rol de Usuario Creador de Curso en Portada';
$string['fpcreatortextbox_desc'] = 'Añada contenido visible solamente para usuarios con el Rol de Creador de Curso.';
$string['fpdashboard'] = 'Tablero de la Portada';
$string['fpheaderimagepadding'] = 'Relleno de Imagen del Encabezado de la Portada';
$string['fpheaderimagepadding_desc'] = 'Controla el relleno y la altura de la imagen del encabezado par la Portada. Esta configuración se aplica arriba y abajo del formato para ingresar al sitio para los usuarios que están afuera del sitio.';
$string['fpsearch'] = 'Buscar cursos';
$string['fpsearchboxmain'] = 'Mostrar Caja_de_Búsqueda de Curso en Área de Contenido Principal';
$string['fpsearchboxmain_desc'] = 'Mostrar una caja para búsqueda de cursos en el área de caja_de_texto en la Portada. Esta opción es dependiente de las configuraciones de la navegación ´por íconos y solamente será mostrada si se configura la navegación por iconos a mostrarse dentro del área de contenido principal.';
$string['fpsearchboxtop'] = 'Mostrar caja_de_búsqueda de Curso en Navegación Superior';
$string['fpsearchboxtop_desc'] = 'Mostrar una caja para búsqueda de curso en la Barra de Navegación superior. Esto aparecerá a la derecha de la navegación por íconos en la parte superior de la página y puede mostrarse aunque estuviera oculta la navegación por íconos. Esta caja_de_búsqueda no es dependiente de las configuraciones de la navegación por íconosw.';
$string['fpsearchbutton'] = 'Buscar';
$string['fptextbox'] = 'Caja_de_texto de Portada';
$string['fptextboxdesc'] = 'La caja_de_texto aparece en la portada y es ideal para poner un mensaje de BienVenida.';
$string['fptextboxinfo'] = 'Caja de Texto de BienVenida en Portada';
$string['fptextboxinfodesc'] = 'Añadir un mensaje de BienVenida para usuarios.';
$string['fptoppromotedpadding'] = 'Altura del Carrusel del Curso';
$string['fptoppromotedpadding_desc'] = 'Esto controlará la altura del carrusel de imágenes de curso.';
$string['frontpagecoursesettings'] = 'Cursos en Portada';
$string['frontpagedesc'] = 'Configurar la forma en que las cajas del curso son renderizadas en la Portada.';
$string['frontpageheading'] = 'Opciones de Portada';
$string['frontpagerenderer'] = 'Cajas de Cursos en Portada';
$string['frontpagerendererdefaultimage'] = 'Imagen del curso por defecto';
$string['frontpagerendererdefaultimagedesc'] = 'La Imagen del curso por defecto a usar cuando no se encuentre imagen del curso (solamente aplica para Mosaicos c/sobrepuesto)';
$string['frontpagerendererdesc'] = 'Controlar la forma en que las cajas del curso en laPortada son renderizadas.';
$string['frontpagerendereroption1'] = 'Mosaicos';
$string['frontpagerendereroption2'] = 'Mosaicos con sobrepuestos';
$string['frontpagesettingsheading'] = 'Renderizado de Portada';
$string['fullfootertext'] = 'Caja_de_texto de Pie de página de Ancho-Completo';
$string['fullfootertext_desc'] = 'Esta es una caja_de_texto de ancho-completo que aparece en el pie de página arriba de las cajas_de_texto de 4 columnas. Esto es ideal si Usted no quisiera usar las cajas_de_texto de 4 columnas debajo.';
$string['gbodyimporturl'] = 'Cuerpo Importar URL';
$string['gbodyimporturldesc'] = 'CUERPO PASO 1: Encuentre un tipo de letra en google.com/fonts. Haga click en el ícono para uso rápido (quick use). Encuentre el paso que dice  "Add this code to your website" (añada este códgo a su sitio web). Copie y pegue eso aquí. Asegúrese de completar el CUERPO PASO 2.  <a href="https://www.google.com/fonts"> Encuentre un tipo de letra de Google (Find a Google Font)</a>';
$string['geneicsettings'] = 'Configuraciones Generales';
$string['generalalert'] = 'Alerta General';
$string['generalalertdesc'] = 'Todo lo que añada a esta área-de-texto se mostrará en el área de Alerta General en la Portada.';
$string['gheadingimporturl'] = 'Encabezado Importar URL';
$string['gheadingimporturldesc'] = 'ENCABEZADO PASO 1: Encuentre un tipo de letra en google.com/fonts. Haga click en el ícono para uso rápido (quick use). Encuentre el paso que dice  "Add this code to your website" (añada este códgo a su sitio web).Copie y pegue eso aquí. Asegúrese de completar el ENCABEZADO PASO 2.  <a href="https://www.google.com/fonts"> Encuentre un tipo de letra de Google (Find a Google Font)</a>';
$string['googleheading'] = 'Tipos de Letras de Google';
$string['gradecomplete'] = 'Total de CAlificación de Curso Radial';
$string['gradecomplete_desc'] = 'Si un curso est´´a configurado para mostrar calificaciones de estudiantes y ésto se activa, entonces Pionero mostrará una calificación total del curso en una radial animada para el estudiante en la parte superior izquierda de la página.';
$string['grades'] = 'Mis Calificaciones';
$string['headerbackgroundimage'] = 'Imagen del Encabezado por defecto';
$string['headerbackgroundimage_desc'] = 'Esta es la Imagen del Encabezado por defecto';
$string['headerbackgroundtoggle'] = 'Permitirles a los profesores subir imagen del encabezado';
$string['headerbackgroundtoggle_desc'] = 'Si se activa, un profesor puede subir una imagen a los  <a href="https://docs.moodle.org/all/es/Configuraciones_del_curso#Archivos_del_resumen_del_curso" target="_new">Archivos del resumen del curso</a>. Esta imagen debe de ser pequeña para reducir el tiempo de carga. El tamaño recomendado es 1024 pixeles de ancho y menos de 500kb en tamaño (peso). En caso contrario todos los cursos usarán la foto que Usted suba debajo para la imagen del encabezado.';
$string['headerimageinfo'] = 'Altura de Imagen del Encabezado';
$string['headerimageinfodesc'] = 'Estas configuraciones controlan la altura de la imagen del encabezado en el sitio y en actividades dentro del curso.';
$string['headerimagepadding'] = 'Relleno Imagen Encabezado';
$string['headerimagepadding_desc'] = 'Controla el relleno y altura de la imagen del encabezado para cursos. Debería seleccionarse un mínimo de 120 pixeles si se usan las visualizaciones de Finalización Radial y Calificación del Curso.';
$string['headerimagepage'] = 'Configuraciones de Imagen del Encabezado';
$string['headerincourseimagepadding'] = 'Relleno de Imagen de Encabezado en Actividades del Curso (dentro_del_curso)';
$string['headerincourseimagepadding_desc'] = 'Después de la página inicial del curso, esta será la altura del relleno de la imagen del encabezado. El hacer esto más corto permite que se muestre más contenido.';
$string['headingfont'] = 'Familia del Tipo de Letra del encabezado';
$string['headingfontdesc'] = 'ENCABEZADO PASO 2: Copie y pegue la información de la familia del tipo de letra de Google aquí.';
$string['iconnavbackgroundcolor'] = 'Ícono del contenido principal y Fondo de Navegación de Caja de Búsqueda';
$string['iconnavbackgroundcolor_desc'] = 'Este es el color del fondo para la navegación por íconos y el área de caja de búsqueda en el área de contenido principal.';
$string['iconnavbackgroundcolortop'] = 'Fondo de Navegación de Caja_de_Búsqueda y de Ícono Superior';
$string['iconnavbackgroundcolortop_desc'] = 'Este es el color del fondo para la navegación por íconos y el área de la caja de búsqueda en la parte más superior a la derecha de la página.';
$string['iconnavheading'] = 'Navegación por Íconos';
$string['inmaincontent'] = 'Solamente contenido Principal';
$string['intopnav'] = 'Solamente Barra_De_Navegación Principal';
$string['invert'] = 'Invertir Barra de Navegación';
$string['invertdesc'] = 'Alterna texto y fondo, entre blanco y negro, para la Barra de navegación en la parte superior de la página.';
$string['lginforgot'] = '¿se le olvidó?';
$string['lginlogin'] = 'Ingresar';
$string['lginpass'] = 'contraseña';
$string['lginuser'] = 'nombre_de_usuario';
$string['linkcolor'] = 'Color del enlace';
$string['linkcolor_desc'] = 'El color de los enlaces.';
$string['loginbuttoncolor'] = 'Color del botón para ingresar al sitio';
$string['loginbuttoncolor_desc'] = 'Este es el color del botón en el formato personalizado para ingresar al sitio.';
$string['logo'] = 'Logo';
$string['logodesc'] = 'El logo debería ser de 140 pixeles por 140 pixeles. El logo es mostrado en las partes superior izquierda y la inferior derecha del tema.';
$string['marketboxbuttoncolor'] = 'Color del Botón del Bloque Publicitario';
$string['marketboxbuttoncolor_desc'] = 'El color del fondo del botón para el Bloque Publicitario.';
$string['marketboxcolor'] = 'Color del fondo del Bloque Publicitario';
$string['marketboxcolor_desc'] = 'El color del fondo para el Bloque Publicitario.';
$string['marketboxcontentcolor'] = 'Color del fondo del Contenido del Bloque Publicitario';
$string['marketboxcontentcolor_desc'] = 'El color del fondo para el contenido del Bloque Publicitario. Aquí es donde aparece el texto en el Bloque Publicitario y puede ser diferente del color del fondo de la caja, para llamar la atención hacia el texto..';
$string['marketing1'] = 'Bloque Publicitario Uno';
$string['marketing2'] = 'Bloque Publicitario Dos';
$string['marketing3'] = 'Bloque Publicitario Tres';
$string['marketing4'] = 'Bloque Publicitario Cuatro';
$string['marketing5'] = 'Bloque Publicitario Cinco';
$string['marketing6'] = 'Bloque Publicitario Seis';
$string['marketingbuttontext'] = 'Texto del Enlace';
$string['marketingbuttontextdesc'] = 'Texto a aparecer en el botón.';
$string['marketingbuttonurl'] = 'URL del Enlace';
$string['marketingbuttonurldesc'] = 'URL a donde apuntará el botón.';
$string['marketingcontent'] = 'Contenido';
$string['marketingcontentdesc'] = 'Contenido a mostrar en el bloque publicitario. Hágalo breve y dulce.';
$string['marketingdesc'] = 'Este tema proporciona la opción para habilitar tres puntos de "Promoción" o "anuncio" justamente debajo del carrusel de imágenes. Estos le permiten a Usted identificar fácilmente información básica para sus usuarios y proporcionarles enlaces directos.';
$string['marketingheading'] = 'Fondo de Bloques Publicitarios';
$string['marketingheadingsub'] = 'Estos lugares en la Portada añaden información y enlaces';
$string['marketingheadingtextbox'] = 'Caja-de-texto Superior de los Bloques Publicitarios';
$string['marketingheadingtop'] = 'Parte Superior del Bloque Publicitario';
$string['marketingheight'] = 'Altura de Imágenes Publicitarias';
$string['marketingheightdesc'] = 'Si Usted quiere mostrar imágenes dentro de los Bloques Publicitarios Usted puede especificar aquí su altura.';
$string['marketingicon'] = 'Ícono del Enlace';
$string['marketingicondesc'] = 'Nombre del ícono que Usted desea usar en el Botón de la URL publicitaria. La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Simplemente escriba lo que sigue de  "fa-", como por ejemplo "star".';
$string['marketingimage'] = 'Imagen';
$string['marketingimage_desc'] = 'Esto proporciona la opción de mostrar una imagen en el bloque publicitario';
$string['marketinginfodesc'] = 'Escriba las configuraciones para su bloque publicitario';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título a mostrar en este bloque publicitario';
$string['marketingurltarget'] = 'Destino del Enlace';
$string['marketingurltargetdesc'] = 'Elija como se abrirá el enlace';
$string['marketingurltargetnew'] = 'Página Nueva';
$string['marketingurltargetparent'] = 'Marco Paterno';
$string['marketingurltargetself'] = 'Página Actual';
$string['mybkg'] = 'Fondo del Deslizador de Mis Cursos';
$string['mybkg_desc'] = 'Elija un color para el Fondo del Deslizador de Mis Cursos';
$string['myclasses'] = 'Mis Clases';
$string['mycorusesinfo'] = 'Opciones del Menú de Navegación';
$string['mycorusesinfodesc'] = 'Estas opciones controlan la barra de navegación superior. Estas incluyen el desplegable de Mis Cursos y el desplegable de Este Curso.';
$string['mycourses'] = 'Mis Cursos';
$string['mycoursesheading'] = 'Deslizador de Mis Cursos';
$string['mycoursesheadingdesc'] = 'Esto mostrará los curso en los que un usuario está inscrito o está enseñando. Los cursos son mostrados en un hermoso deslizador responsivo. Es más apropiado para presentación en PC de escritorio.';
$string['mycoursesinfo'] = 'Lista Dinámica de cursos Inscritos';
$string['mycoursesinfodesc'] = 'Muestra una lista dinámica de cursos inscritos por el usuario.';
$string['mycoursetitle'] = 'Terminología';
$string['mycoursetitledesc'] = 'Elija la terminología para el enlace hacia "Mis Cursos" en el menú desplegable';
$string['mydashboardinfo'] = 'Tablero personalizado del Usuario';
$string['mydashboardinfodesc'] = 'Muestra una lista de funciones comunes usadas por usuarios.';
$string['mymodules'] = 'Mis Módulos';
$string['myunits'] = 'Mis Unidades';
$string['navbkgcolor'] = 'Fondo de Navegación Principal';
$string['navbkgcolor_desc'] = 'Este es el color del fondo para la Barra de Navegación Principal.';
$string['navcolor'] = 'Color Desplegable Barra de Navegación';
$string['navcolor_desc'] = 'Este es el color del menú desplegable en la Barra de Navegación.';
$string['navcolorhover'] = 'Color al pasar el ratón encima del desplegable de Barra de Navegación';
$string['navcolorhover_desc'] = 'El color del mení desplegable de Barra de Navegación al pasarle el ratón encima';
$string['navicon'] = 'Ícono';
$string['navicon1'] = 'Ícono de Portada Personalizado Uno';
$string['navicon2'] = 'Ícono de Portada Personalizado Dos';
$string['navicon3'] = 'Ícono de Portada Personalizado tres';
$string['navicon4'] = 'Ícono de Portada Personalizado Cuatro';
$string['navicon5'] = 'Ícono de Portada Personalizado Cinco';
$string['navicon6'] = 'Ícono de Portada Personalizado Seis';
$string['navicon7'] = 'Ícono de Portada Personalizado Siete';
$string['navicon8'] = 'Ícono de Portada Personalizado Ocho';
$string['naviconbuttontext'] = 'Texto de Herramienta';
$string['naviconbuttontextdesc'] = 'Texto a aparecer en la herramienta del ícono cuando Usted pasa el ratón encima.';
$string['naviconbuttonurl'] = 'URL del enlace';
$string['naviconbuttonurldesc'] = 'URL a donde apuntará el botón.';
$string['navicondesc'] = 'Nombre del ícono que Usted desea usar. La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Simplemente escriba lo que sigue de  "fa-", como por ejemplo "star".';
$string['naviconoff'] = 'Desactivar íconos de navegación personalizados';
$string['naviconon'] = 'Activar íconos de navegación personalizados';
$string['navigation'] = 'Opciones de Navegación';
$string['noenrolments'] = 'Usted no tiene inscripciones actualmente';
$string['pcourseenable'] = 'Habilitar Cursos Destacados';
$string['pcourses'] = 'Fondo de Cursos Destacados';
$string['pcoursesdesc'] = 'Por favor proporcione IDs separadas por comas para los cursos destacados.';
$string['people'] = 'Compañeros de clase';
$string['pluginname'] = 'Pioneer';
$string['promotedcoursesheading'] = 'Fondo de Deslizador de Cursos Destacados';
$string['promotedlink'] = 'URL de Ver Más Cursos Destacados';
$string['promotedlink_desc'] = 'Escriba una URL hacia una de sus categorías de cursos. Esto es mostrado junto al título de los cursos destacados.';
$string['promotedlinktext'] = 'Texto de Ver Más Cursos destacados';
$string['promotedlinktext_desc'] = 'Esto proporciona una opción para enlazar hacia una categoría de curso para mostrar más cursos en el fondo del deslizador de cursos destacados. Escriba debajo una URL.';
$string['promotedmylink'] = 'URL para Vea Más Cursos en el Deslizador de Mis Cursos';
$string['promotedmylink_desc'] = 'Escriba una URL hacia una de sus categorías de curso. Esto es mostrado junto al título del Deslizador de Mis Cursos.';
$string['promotedmylinktext'] = 'Texto para Vea Más Cursos en el Deslizador de Mis Cursos';
$string['promotedmylinktext_desc'] = 'Esto proporciona una opción para enlazar hacia una categoría de curso para mostrar más cursos. Escriba debajo una URL.';
$string['promotedmytextbox'] = 'Caja_de_texto de Descripción del Deslizador de Mis Cursos';
$string['promotedmytextbox_desc'] = 'Una caja_de_texto que aparece con el bloque del Deslizador de Mis Cursos.';
$string['promotedmytitle'] = 'Título del Deslizador de Mis Cursos';
$string['promotedmytitledesc'] = 'Por favor dele un título al bloque del Deslizador de Mis Cursos.';
$string['promotedtaglink'] = 'URL para Vea Más Cursos Recomendados';
$string['promotedtaglink_desc'] = 'Escriba una URL hacia una de suscategorias de curso. Esto es mostrado junto al titulo de los cursos destacados.';
$string['promotedtaglinktext'] = 'Texto para Vea Más Cursos Recomedados';
$string['promotedtaglinktext_desc'] = 'Esto proporciona una opción para enlazar hacia una categoría de curso para mostrar más cursos. Escriba debajo una URL.';
$string['promotedtagtextbox'] = 'Caja_de_texto Descripción Personalizada';
$string['promotedtagtextbox_desc'] = 'Use esto para explicarle al usuario como añadir marcas del perfil y marcas del curso,, para que los cursos recomendados le aparezcan al usuario.';
$string['promotedtagtitle'] = 'Título de Cursos Recomendados Personalizados';
$string['promotedtagtitledesc'] = 'Por favor dele un título al bloque de Cursos Recomendados Personalizados';
$string['promotedtitledefault'] = 'Cursos destacados';
$string['promotedtitledesc'] = 'Por favor dele un título al bloque de Cursos Destacados.';
$string['radialboxbackground'] = 'Fondo de Finalización y Calificación del Curso Radial';
$string['radialboxbackground_desc'] = 'Este es el color del fondo para la caja que contiene los elementos radiales del Total de Calificación del Curso y de Finalización del Curso en la parte superior izquierda de las páginas del curso.';
$string['radialcolor'] = 'Color del Círculo Radial';
$string['radialcolor_desc'] = 'Configurar el color del círculo radial.';
$string['recommendedbkg'] = 'Color del Fondo del Deslizador Múltiple';
$string['recommendedbkg_desc'] = 'Este color será aplicado para los Deslizadores de Cursos Destacados, Cursos Recomendados Personalizados y Mis Cursos. Estos están localizados en la Portada.';
$string['recommendedcoursesheading'] = 'Deslizador de Cursos Recomendados Personalizados';
$string['recommendedcoursesheadingdesc'] = 'El Deslizador de Curso Recomendado Personalizado coincidirá con las marcas del curso con los intereses del usuario. Cuando se encuentra una coincidencia se mostrará la lista de cursos resultante en un hermoso deslizador responsivo en la Portada. Esta configuracion es automática y no se requiere interacción más allá de proporcionar las marcas para los cursos y para los perfiles de los usuarios.';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['rendereroverlaycolor'] = 'Color del sobrepuesto';
$string['rendereroverlaycolordesc'] = 'El color del sobrepuesto, cuiando se selecciona el renderizador de "Mosaicos c/ sobrepuesto".';
$string['rendereroverlayfontcolor'] = 'Color del tipo de letra (font) sobrepuesto';
$string['rendereroverlayfontcolordesc'] = 'El color del tipo de letra (font), cuiando le pasa el ratón encima sobre una caja_de_curso con el renderizador activado de "Mosaicos c/ sobrepuesto".';
$string['secondarybackground'] = 'Color de Fondo secundario';
$string['secondarybackground_desc'] = 'El color del fondo de cualquier contenido secundario, como los bloques.';
$string['sectionheadericon'] = 'Ícono del Título de Sección';
$string['sectionheadericondesc'] = 'Este ícono aparece antes del título de cada tópico/tema para los formatos de curso basados en tópico/tema y semanal. Use la configuración Unicode del Tipo de letra (font) Awesome. La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. El ícono \'f02d\' es un libro.';
$string['settingfeaturedmyslider'] = 'Mis Cursos Inscritos';
$string['settingfeaturedslider'] = 'Cursos Destacados';
$string['settingfeaturedtagslider'] = 'Cursos recomendados Personalizados';
$string['settinggradebutton'] = 'Ver Calificaciones del Curso';
$string['settingpromotedlink'] = 'ejemplo: http://misitiomoodle/curso/';
$string['settingpromotedlinktext'] = 'Ver Más Cursos Recomendados';
$string['settingpromotedmylink'] = 'ejemplo: http://misitiomoodle/curso/';
$string['settingpromotedmylinktext'] = 'Deslizador de Mis Cursos Ver Más Cursos';
$string['settingpromotedtaglink'] = 'ejemplo: http://misitiomoodle/curso/';
$string['settingpromotedtaglinktext'] = 'Ver Más Cursos recomendados';
$string['settingshowtagline'] = 'Inscribirse ahora';
$string['settingtabbutton'] = 'Empezando con Moodle';
$string['showlogintoggle'] = 'Mostrar Formato para Ingresar';
$string['showlogintoggle_desc'] = 'Ocultar o Mostrar en la Portada el formato personalizado para ingresar.';
$string['showmycourses'] = 'Ocultar/Mostrar Deslizador Mis Cursos';
$string['showmycourses_desc'] = 'Desactive esto si no desea mostrar Deslizador de Mis Cursos.';
$string['showrecommendedcourses'] = 'Mostrar/Ocultar Cursos Recomendados Personalizados';
$string['showrecommendedcourses_desc'] = 'Desactive esto si Usted no desea mostrar cursos recomendados personalizados.';
$string['signuplogin'] = 'Crear Nuevo';
$string['socialicon1'] = 'URL de Facebook';
$string['socialicon2'] = 'URL de Twitter';
$string['socialicon3'] = 'URL de Pinterest';
$string['socialicon4'] = 'URL de Flickr';
$string['socialicon5'] = 'URL de Linkedln';
$string['socialicon6'] = 'URL de YouTube';
$string['socialicon7'] = 'URL de Vimeo';
$string['socialicon8'] = 'URL de Google Plus';
$string['socialiconheading'] = 'Navegación por Íconos Sociales';
$string['socialwallheaddesc'] = 'El formato de Curso de ParedSocial (SocialWall) es un conjunto de plugins de formato de curso para Moodle, que proporciona a los profesores un curso sencillo de usar que opera en forma similar a Facebook. Usted puede descargar el formato de Curso de ParedSocial desde  Moodle.org <a href="https://moodle.org/plugins/browse.php?list=set&id=74">https://moodle.org/plugins/browse.php?list=set&id=74</a>.  Las configuraciones inferiores le permiten a Usted personalizar los colores de la ParedSocial.';
$string['socialwallheading'] = 'Opciones de Formato de Curso ParedSocial';
$string['stylinginfo'] = 'Estilo y Alertas';
$string['stylinginfodesc'] = 'Opciones adicionales de configuraciones de personalización y alerta';
$string['swaddpost'] = 'Fondo de Añadir Publicaciones de Formato de Curso de ParedSocial';
$string['swaddpost_desc'] = 'Si Usted usa el Formato de Curso de ParedSocial (SocialWall), esta configuración cambiará el color del fondo del área de Añadir Publicaciones en la alimentación de la pared.';
$string['swattach'] = 'Fondo de Anexos de Formato de Curso de ParedSocial';
$string['swattach_desc'] = 'Si Usted usa el Formato de Curso de ParedSocial (SocialWall), esta configuración cambiará el color del fondo del área de anexos en la alimentación de la pared.';
$string['swcomment'] = 'Fondo de Comentarios de Formato de Curso de ParedSocial';
$string['swcomment_desc'] = 'Si Usted usa el Formato de Curso de ParedSocial (SocialWall), esta configuración cambiará el color del fondo del área de comentarios en la alimentación de la pared.';
$string['swicontext'] = 'Ciolores de Texto e Íconos del Formato de Curso ParedSocial';
$string['swicontext_desc'] = 'Si Usted usa el Formato de Curso de ParedSocial (SocialWall), esta configuración cambiará los colores de los íconos y palabras de Anexos, Publicaciones, Mensajes y Comentarios en la alimentación de la pared.';
$string['swlabelattachment'] = 'Etiqueta de Anexo CSS';
$string['swlabelattachment_desc'] = 'Cuando hay anexos con una publicación esta etiqueta identificará los anexos.';
$string['swlabelcomment'] = 'Etiqueta Comentario CSS';
$string['swlabelcomment_desc'] = 'Esta etiqueta identifica la sección de comentarios para cada publicación en la línea-de-tiempo.';
$string['swlabelmessage'] = 'Gestionar Ertiqueta CSS';
$string['swlabelmessage_desc'] = 'Arriba del contenido de una publicación esta ertiqueta del mensaje aparece en la línea-de-tiempo.';
$string['swlabelpost'] = 'Etiqueta Post CSS';
$string['swlabelpost_desc'] = 'Arriba de cada publicación esta es la ertiqueta que aparece en la línea-de-tiempo.';
$string['swmessage'] = 'Fondo de Mensaje en Formato de Curso de ParedSocial';
$string['swmessage_desc'] = 'Si Usted usa el formato de Curso de ParedSocial (SocialWall), esta configuración cambiará el color del fondo del área de texto de los  mensajes en la alimentación de la pared.';
$string['swmultilangcss'] = 'Trducir Etiquetas ParedSocial';
$string['swmultilangcss_desc'] = 'Si Usted opera un sitio multi-idioma, Usted puede usar el ejemplo proporcionado para localizar las etiquetas de ParedSocial a los idiomas que Usted soporta.';
$string['swpost'] = 'Fondo de Publicación en Formato de Curso de ParedSocial';
$string['swpost_desc'] = 'Si Usted usa el Formato de Curso de ParedSocial (Socialwall), esta configuración cambiará el color del fondo de las publicaciones en la alimentación de noticias de la pared.';
$string['tab1'] = 'Pestaña Uno';
$string['tab2'] = 'Pestaña Dos';
$string['tab3'] = 'Pestaña Tres';
$string['tab4'] = 'Pestaña Cuatro';
$string['tab5'] = 'Pestaña Cinco';
$string['tab6'] = 'Pestaña Seis';
$string['tabbutton'] = 'Comenzar';
$string['tabbuttoncolor'] = 'Color de Botón de Pestaña';
$string['tabbuttoncolor_desc'] = 'El color del botón usado para alternar las pestañas de la Portada y el deslizador de calificaciones del curso. Esto aparece justo debajo del título de la página cuando se activa.';
$string['tabbuttonhovercolor'] = 'Color al pasar ratón encima del Botón de Pestaña';
$string['tabbuttonhovercolor_desc'] = 'El color del botón al pasarle el raton encima usado para alternar los deslizadores de las pestañas en la Portada y las calificaciones del curso. Esto aparece justamente debajo del título de la página cuando se activa.';
$string['tabbuttontext'] = 'Texto Botón Pestaña';
$string['tabbuttontextdesc'] = 'Este texto es usado en el botón mostrar/ocultar para visualizar las pestañas.';
$string['tabcontent'] = 'Contenido de Pestaña';
$string['tabcontentdesc'] = 'El texto y HTML que Usted escriba aquí se mostrará en la pestaña.';
$string['tabheading'] = 'pestañas de Portada';
$string['tabinfodesc'] = 'Añadir debajo un título y una descripción. Esto solamente aparecerá en la página de portada como un deslizador. El botón para activar el deslizador está localizado en el encabezado superior.';
$string['tabtitle'] = 'Título de Pestaña';
$string['tabtitledesc'] = 'Este es el título de la pestaña que aparecerá en la parte superior del contenido de la pestaña';
$string['tabtoggle'] = 'Alternador de Pestaña';
$string['tabtoggle_desc'] = 'Ocultar o Mostrar las pestañas de página inicial.';
$string['textcolor'] = 'Color del texto';
$string['textcolor_desc'] = 'El color del texto.';
$string['themecolorsettings'] = 'Colores del tema';
$string['thiscourse'] = 'Este Curso';
$string['title'] = 'Título';
$string['togglefptextbox'] = 'Ocultar/Mostrar Caja de Texto';
$string['togglefptextboxdesc'] = 'Elija si quiere ocultar o mostrar la caja de Texto en la Portada para usuarios que han salido del sitio en la Portada.';
$string['toggleiconnav'] = 'Ubicación de la Navegación por Íconos';
$string['toggleiconnav_desc'] = 'Determinar donde aparecen la caja e íconos de búsqueda de curso.';
$string['togglemarketing'] = 'Alternar mostrar Bloques Publicitarios';
$string['togglemarketingdesc'] = 'Elija si quiere ocultar o mostrar los tres bloques publicitarios';
$string['togglenavicons'] = 'Activar Íconos Personalizados';
$string['togglenaviconsdesc'] = 'Elija si quiere incluir íconos de navegación personalizados basados en Font-Awesome.';
$string['toolsmenu'] = 'Menú de Herramientas';
$string['toolsmenudesc'] = 'Puedes configurar los items a mostrar debajo de un menú de herramientas. Cada línea consiste en texto del menú, URL del enlace  (opcional), un título de la herramienta de ayuda (opcional)  y el código de idioma o una lista de códigos separada por comas (opcional, para mostrar el item dependiendo del idioma del usuario) separado por una linea vertical (|) (AltGr + 1). . También pueden añadirse sub-items usando guiones. Por ejemplo:
<pre>
Comunidad Moodle|https://moodle.org
-Soporte Moodle gratuito|https://moodle.org/support
-Moodle development|https://moodle.org/development
--Documentación de Moodle|http://docs.moodle.org|Moodle Docs
--Documentación de Moodle en español|http://docs.moodle.org/es|Documentación en español|es
Moodle.com|http://moodle.com/
</pre>';
$string['toolsmenulabel'] = 'herramientas';
$string['topclosefeatured'] = 'Cerrar Enlace a Listado de Cursos Destacados';
$string['topclosefeatureddesc'] = 'Este texto aparece arriba del listado de cursos destacados y cerrará la lista de cursos destacados. El texto sugerido es "Cerrar Listado de Cursos".';
$string['topclosefeaturedtext'] = 'Cerrar Listado de Cursos';
$string['topichighlight'] = 'Color Tópico Resaltado';
$string['topichighlight_desc'] = 'Color usado cuando un tópico o semana está resaltado en un curso.';
$string['topicweekcolor'] = 'Fondo de Sección Tópico/Tema y Semana';
$string['topicweekcolor_desc'] = 'El los formatos de curso de Tópico/Tema y Semanal este es el color del fondo para cada tópico/tema o semana en el curso.';
$string['toppcourseenable'] = 'Habilitar Carrusel de Cursos Destacados';
$string['toppcourses'] = 'Carrusel de Cursos destacados';
$string['toppcoursesdesc'] = 'LÍMITE=10. Usted no puede ingresar más de 10 IDs de cursos. Por favor ponga las IDs de los cursos destacados separadas por comas.';
$string['toppromotedcoursesheading'] = 'Carrusel de Cursos destacados';
$string['toppromotedtitledefault'] = 'Cursos destacados';
$string['toppromotedtitledesc'] = 'Este texto aparece debajo del Título del Curso en el deslizador. "Inscríbase ahora" es un lema ideal.';
$string['topsearch'] = 'Buscar cursos';
$string['topsearchbutton'] = 'Encontrar';
$string['topshowfeatured'] = 'Mostrar Enlace hacia Listado de Todos los Cursos';
$string['topshowfeatureddesc'] = 'Este texto aparece en el carrusel y mostrará una lista de todos los cursos destacados. El texto sugerido es "Ver Todos los Cursos".';
$string['topshowfeaturedtext'] = 'Ver todos los Cursos Destacados';
$string['toptitle'] = 'Lema';
