<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_mucertify', language 'pt_br', version '5.0'.
 *
 * @package     tool_mucertify
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allcertifications'] = 'Todas as certificações';
$string['archived'] = 'Arquivado';
$string['assignment'] = 'Atribuição';
$string['assignment_archive'] = 'Atribuição de arquivo';
$string['assignment_delete'] = 'Excluir atribuição';
$string['assignment_restore'] = 'Restaurar atribuição';
$string['assignment_update'] = 'Atualizar atribuições';
$string['assignments'] = 'Atribuições';
$string['assignmentsources'] = 'Fontes de atribuições';
$string['catalogue'] = 'Catálogo de certificações';
$string['catalogue_actions'] = 'Ações de catálogo';
$string['catalogue_dofilter'] = 'Procurar';
$string['catalogue_resetfilter'] = 'Limpar';
$string['catalogue_searchtext'] = 'Pesquisar texto';
$string['catalogue_tag'] = 'Filtrar por tag';
$string['certificates'] = 'Certificados';
$string['certification'] = 'Certificação';
$string['certification_actions'] = 'Ações de certificação';
$string['certification_archive'] = 'Certificação de arquivo';
$string['certification_archive_info'] = 'Arquivamento de certificação: * arquiva alocações relevantes de programas, * impede atualizações de certificação, * e, em geral, oculta a certificação de usuários comuns. O arquivamento é uma etapa necessária antes que a certificação possa ser excluída.';
$string['certification_create'] = 'Adicionar certificação';
$string['certification_delete'] = 'Excluir certificação';
$string['certification_delete_info'] = 'Durante a exclusão da certificação, todos os dados de certificação são excluídos e os usuários são desalocados dos programas.';
$string['certification_restore'] = 'Restaurar certificação';
$string['certification_restore_info'] = 'A restauração da certificação reverte as alterações feitas durante o arquivamento da certificação. No entanto, é recomendável verificar todas as configurações de certificação e os usuários atribuídos posteriormente.';
$string['certification_update'] = 'Atualizar certificação';
$string['certificationidnumber'] = 'ID de certificação';
$string['certificationimage'] = 'Imagem de certificação';
$string['certificationname'] = 'Nome da certificação';
$string['certifications'] = 'Certificações';
$string['certificationsactive'] = 'Ativo';
$string['certificationsarchived'] = 'Arquivado';
$string['certificationstatus'] = 'Status de certificação';
$string['certificationstatus_any'] = 'Qualquer';
$string['certificationstatus_archived'] = 'Arquivado';
$string['certificationstatus_certified'] = 'Certificado';
$string['certificationstatus_expired'] = 'Expirado';
$string['certificationstatus_notcertified'] = 'Não certificado';
$string['certificationstatus_temporary'] = 'Temporariamente válido';
$string['certificationstatus_valid'] = 'Válido';
$string['certificationurl'] = 'URL de certificação';
$string['certifieddate'] = 'Data de conclusão da certificação';
$string['certifieduntiltemporary'] = 'Certificação temporária até';
$string['cohorts'] = 'Visível para coortes';
$string['cohorts_help'] = 'Certificações não públicas podem ser disponibilizadas para membros específicos da coorte. O status de visibilidade não afeta as certificações já atribuídas.';
$string['columnusedalready'] = 'A coluna já está em uso';
$string['currentcontextonly'] = 'Excluir subcategorias';
$string['customfields'] = 'Campos personalizados de certificação';
$string['customfields_assignment'] = 'Campos personalizados para atribuição de certificação';
$string['customfieldsettings'] = 'Configurações comuns de campos personalizados de certificação';
$string['customfieldvisible:assigned'] = 'Usuários atribuídos à certificação';
$string['customfieldvisible:everyone'] = 'Todos que podem ver outros detalhes de certificação';
$string['customfieldvisible:viewcapability'] = 'Usuários com capacidade de certificação de visualização';
$string['customfieldvisibleto'] = 'O conteúdo do campo é visível para';
$string['delayafter'] = '{$a->delay} após {$a->after}';
$string['delaybefore'] = '{$a->delay} antes de {$a->before}';
$string['errornoassignment'] = 'A certificação não é atribuída';
$string['errornoassignments'] = 'Nenhuma atribuições de certificação encontrada.';
$string['errornocertifications'] = 'Nenhuma certificação encontrada.';
$string['errornomycertifications'] = 'Nenhuma certificação atribuída encontrada.';
$string['errornorequests'] = 'Nenhuma solicitação de certificação encontrada';
$string['event_assignment_archived'] = 'Atribuição de certificação de usuário arquivada';
$string['event_assignment_created'] = 'Usuário atribuído à certificação';
$string['event_assignment_deleted'] = 'O usuário foi desatribuído da certificação';
$string['event_assignment_restored'] = 'Atribuição de certificação de usuário restaurada';
$string['event_assignment_updated'] = 'Atribuição de certificação de usuário atualizada';
$string['event_certification_archived'] = 'Certificação arquivada';
$string['event_certification_created'] = 'Certificação criada';
$string['event_certification_deleted'] = 'Certificação excluída';
$string['event_certification_restored'] = 'Certificação restaurada';
$string['event_certification_updated'] = 'Certificação atualizada';
$string['event_period_certified'] = 'O usuário foi certificado';
$string['event_period_created'] = 'Período de certificação criado';
$string['event_period_deleted'] = 'Período de certificação excluído';
$string['event_period_updated'] = 'Período de certificação atualizado';
$string['evidence_default'] = 'Inadimplência de evidências';
$string['evidence_default_text'] = 'Upload de períodos históricos de certificação';
$string['evidence_details'] = 'Detalhes das evidências';
$string['evidence_details_help'] = 'Os detalhes das evidências servem como explicação do motivo pelo qual a certificação foi concedida ou revogada.';
$string['expirationafter'] = 'Expira após';
$string['fromdate'] = 'Válido a partir de';
$string['graceperiod'] = 'Período de carência';
$string['history_upload'] = 'Histórico de upload';
$string['history_upload_assign'] = 'Criar novas atribuições';
$string['history_upload_evidencecolumn'] = 'Coluna de evidências';
$string['history_upload_result_assigned'] = 'Usuários atribuídos à certificação: {$a}';
$string['history_upload_result_errors'] = 'Linhas inválidas ignoradas: {$a}';
$string['history_upload_result_periods'] = 'Períodos de certificação importados: {$a}';
$string['history_upload_result_skipped'] = 'Linhas ignoradas: {$a}';
$string['history_upload_skipassigned'] = 'Ignorar usuários já atribuídos';
$string['history_upload_timecertifiedcolumn'] = 'Coluna de data de certificação';
$string['history_upload_timefromcolumn'] = 'Período válido a partir da coluna';
$string['history_upload_timeuntilcolumn'] = 'Coluna de expiração do período';
$string['management'] = 'Gestão de Certificação';
$string['management_certification_general_actions'] = 'Ações de certificação';
$string['management_certification_users_actions'] = 'Ações do usuário';
$string['messageprovider:approval_reject_notification'] = 'Notificação de rejeição de solicitação de certificação';
$string['messageprovider:approval_request_notification'] = 'Notificação de solicitação de aprovação de certificação';
$string['messageprovider:assignment_notification'] = 'Notificação de atribuição de certificação';
$string['messageprovider:unassignment_notification'] = 'Notificação de não atribuição de certificação';
$string['messageprovider:valid_notification'] = 'Notificação de validade da certificação';
$string['mucertify:admin'] = 'Administração de certificação avançada';
$string['mucertify:assign'] = 'Atribuir usuários a certificações';
$string['mucertify:configurecustomfields'] = 'Configurar campos personalizados de certificação';
$string['mucertify:delete'] = 'Excluir certificações';
$string['mucertify:edit'] = 'Adicionar e atualizar certificações';
$string['mucertify:unassign'] = 'Desatribuir usuários de certificações';
$string['mucertify:view'] = 'Ver gerenciamento de certificação';
$string['mucertify:viewcatalogue'] = 'Catálogo de certificações de acesso';
$string['mycertifications'] = 'Minhas certificações';
$string['never'] = 'Nunca';
$string['noexpiration'] = 'Sem expiração';
$string['notallocated'] = 'Não alocado';
$string['notification_assignment'] = 'Usuário atribuído';
$string['notification_assignment_body'] = 'Olá {$a->user_fullname}, você foi designado para a certificação "{$a->certification_fullname}".';
$string['notification_assignment_description'] = 'Notificação enviada aos usuários quando eles são atribuídos à certificação.';
$string['notification_assignment_subject'] = 'Notificação de atribuição de certificação';
$string['notification_unassignment'] = 'Usuário não atribuído';
$string['notification_unassignment_body'] = 'Olá {$a->user_fullname}, sua atribuição da certificação "{$a->certification_fullname}" foi cancelada.';
$string['notification_unassignment_description'] = 'Notificação enviada aos usuários quando eles são removidos da certificação.';
$string['notification_unassignment_subject'] = 'Notificação de não atribuição de certificação';
$string['notification_valid'] = 'Certificação válida';
$string['notification_valid_body'] = 'Olá {$a->user_fullname}, sua certificação "{$a->certification_fullname}" agora é válida: * válida a partir de: {$a->period_fromdate} * expira em: {$a->period_untildate} * a recertificação abre em: {$a->period_recertificationdate}';
$string['notification_valid_description'] = 'Notificação enviada aos usuários quando sua certificação se torna válida.';
$string['notification_valid_subject'] = 'Notificação de certificação válida';
$string['notificationdates'] = 'Notificações';
$string['notifications'] = 'Notificações de certificação';
$string['notset'] = 'Não definido';
$string['period'] = 'Período de certificação';
$string['period_create'] = 'Adicionar período';
$string['period_delete'] = 'Excluir período';
$string['period_update'] = 'Datas do período de substituição';
$string['periods'] = 'Períodos de certificação';
$string['periodstatus'] = 'Status';
$string['periodstatus_archived'] = 'Arquivado';
$string['periodstatus_certified'] = 'Certificado';
$string['periodstatus_expired'] = 'Expirado';
$string['periodstatus_failed'] = 'Fracassado';
$string['periodstatus_future'] = 'Futuro';
$string['periodstatus_overdue'] = 'Atrasado';
$string['periodstatus_pending'] = 'Pendente';
$string['periodstatus_revoked'] = 'Revogado';
$string['pluginname'] = 'Certificações';
$string['pluginname_desc'] = 'Ferramenta de certificação e recertificação Open LMS';
$string['privacy:metadata:field:archived'] = 'Bandeira arquivada';
$string['privacy:metadata:field:assignmentid'] = 'ID da atribuições';
$string['privacy:metadata:field:certificationid'] = 'ID de certificação';
$string['privacy:metadata:field:datajson'] = 'Dados JSON';
$string['privacy:metadata:field:programid'] = 'ID do programa';
$string['privacy:metadata:field:quantity'] = 'Quantidade';
$string['privacy:metadata:field:rejectedby'] = 'Rejeitado por';
$string['privacy:metadata:field:sourceid'] = 'ID da fonte';
$string['privacy:metadata:field:timecertified'] = 'Data de certificação';
$string['privacy:metadata:field:timecertifiedtemp'] = 'Certificado temporariamente até a data';
$string['privacy:metadata:field:timefrom'] = 'Certificado a partir da data';
$string['privacy:metadata:field:timerejected'] = 'Data de rejeição';
$string['privacy:metadata:field:timerequested'] = 'Data da solicitação';
$string['privacy:metadata:field:timerevoked'] = 'Data de revogação da certificação';
$string['privacy:metadata:field:timeuntil'] = 'Certificado até a data';
$string['privacy:metadata:field:timewindowdue'] = 'Data de vencimento da janela';
$string['privacy:metadata:field:timewindowend'] = 'Data final da janela';
$string['privacy:metadata:field:timewindowstart'] = 'Data de início da janela';
$string['privacy:metadata:field:userid'] = 'ID do usuário';
$string['privacy:metadata:table:tool_mucertify_assignment'] = 'Tabela de atribuições de usuário';
$string['privacy:metadata:table:tool_mucertify_period'] = 'Tabela de períodos de certificação';
$string['privacy:metadata:table:tool_mucertify_request'] = 'Tabela de solicitações de certificação';
$string['program1'] = 'Programa de certificação';
$string['program2'] = 'Programa de recertificação';
$string['publicaccess'] = 'Público';
$string['publicaccess_help'] = 'As certificações públicas são visíveis para todos os usuários. O status de visibilidade não afeta as certificações já atribuídas.';
$string['purchaseaccess'] = 'Acesso de compra';
$string['recertification'] = 'Recertificação';
$string['recertifications'] = 'Recertificações';
$string['recertify'] = 'Recertificar automaticamente';
$string['recertifybefore'] = 'Recertificar antes do vencimento';
$string['recertifyifexpired'] = 'Se expirado';
$string['resettype1'] = 'Redefinição do programa de certificação';
$string['resettype2'] = 'Redefinição do programa de recertificação';
$string['revokeddate'] = 'Data de revogação';
$string['selectcategory'] = 'Selecione a categoria';
$string['settings'] = 'Configurações de certificação';
$string['source'] = 'Fonte';
$string['source_approval'] = 'Solicitações com aprovação';
$string['source_approval_allownew'] = 'Permitir aprovações';
$string['source_approval_allownew_desc'] = 'Permitir adicionar novas _solicitações com fontes de aprovação_ às certificações';
$string['source_approval_allowrequest'] = 'Permitir novas solicitações';
$string['source_approval_confirm'] = 'Por favor, confirme que você deseja solicitar a atribuição da certificação.';
$string['source_approval_daterejected'] = 'Data de rejeição';
$string['source_approval_daterequested'] = 'Data solicitada';
$string['source_approval_makerequest'] = 'Solicitar acesso';
$string['source_approval_notification_approval_reject_body'] = 'Olá {$a->user_fullname}, sua solicitação para acessar a certificação "{$a->certification_fullname}" foi rejeitada. {$a->reason}';
$string['source_approval_notification_approval_reject_subject'] = 'Notificação de rejeição de solicitação de certificação';
$string['source_approval_notification_approval_request_body'] = 'O usuário {$a->user_fullname} solicitou acesso à certificação "{$a->certification_fullname}".';
$string['source_approval_notification_approval_request_subject'] = 'Notificação de solicitação de certificação';
$string['source_approval_rejectionreason'] = 'Motivo da rejeição';
$string['source_approval_request'] = 'Solicitar';
$string['source_approval_requestallowed'] = 'Solicitações são permitidas';
$string['source_approval_requestapprove'] = 'Aprovar solicitação';
$string['source_approval_requestdelete'] = 'Solicitação de exclusão';
$string['source_approval_requestnotallowed'] = 'Não são permitidos pedidos';
$string['source_approval_requestpending'] = 'Solicitação de acesso pendente';
$string['source_approval_requestreject'] = 'Rejeitar solicitação';
$string['source_approval_requestrejected'] = 'O pedido de acesso foi rejeitado';
$string['source_approval_requests'] = 'Solicitações';
$string['source_cohort'] = 'Atribuição automática de coorte';
$string['source_cohort_allownew'] = 'Permitir alocação de coorte';
$string['source_cohort_allownew_desc'] = 'Permitir adicionar novas fontes de _alocação automática de coorte_ às certificações';
$string['source_cohort_cohortstoassign'] = 'Atribuir a coortes';
$string['source_manual'] = 'Atribuição manual';
$string['source_manual_assignusers'] = 'Atribuir usuários';
$string['source_manual_hasheaders'] = 'A primeira linha é o cabeçalho';
$string['source_manual_result_assigned'] = '{$a} usuários foram atribuídos à certificação';
$string['source_manual_result_errors'] = 'Erros {$a} detectados ao atribuir certificação';
$string['source_manual_result_skipped'] = '{$a} usuários já foram atribuídos à certificação';
$string['source_manual_timeduecolumn'] = 'Coluna de tempo de entrega da certificação';
$string['source_manual_timeendcolumn'] = 'Coluna de tempo de fechamento da janela';
$string['source_manual_timestartcolumn'] = 'Coluna de tempo de abertura da janela';
$string['source_manual_uploadusers'] = 'Carregar atribuições';
$string['source_manual_usercolumn'] = 'Coluna de identificação do usuário';
$string['source_manual_usermapping'] = 'Mapeamento de usuários via';
$string['source_selfassignment'] = 'Autoatribuição';
$string['source_selfassignment_allownew'] = 'Permitir autoatribuição';
$string['source_selfassignment_allownew_desc'] = 'Permitir adicionar novas fontes de _autoatribuição_ às certificações';
$string['source_selfassignment_allowsignup'] = 'Permitir novas inscrições';
$string['source_selfassignment_assign'] = 'Inscrever-se';
$string['source_selfassignment_confirm'] = 'Por favor, confirme que você deseja ser atribuído à certificação.';
$string['source_selfassignment_enable'] = 'Habilitar autoatribuição';
$string['source_selfassignment_key'] = 'Chave de inscrição';
$string['source_selfassignment_keyrequired'] = 'A chave de inscrição é necessária';
$string['source_selfassignment_maxusers'] = 'Máximo de usuários';
$string['source_selfassignment_maxusers_status'] = 'Usuários {$a->count}/{$a->max}';
$string['source_selfassignment_maxusersreached'] = 'Número máximo de usuários já autoatribuídos';
$string['source_selfassignment_signupallowed'] = 'Inscrições são permitidas';
$string['source_selfassignment_signupnotallowed'] = 'Não são permitidas inscrições';
$string['stoprecertify'] = 'Recertificação interrompida';
$string['tabassignment'] = 'Configurações de atribuição';
$string['tabgeneral'] = 'Geral';
$string['tabsettings'] = 'Configurações de período';
$string['tabusers'] = 'Usuários';
$string['tabvisibility'] = 'Visibilidade do catálogo';
$string['tagarea_tool_mucertify_certification'] = 'Certificações';
$string['taskcron'] = 'Tarefa cron de certificação';
$string['tasktriggercertificate'] = 'Disparar emissão de certificado cron o mais rápido possível';
$string['untildate'] = 'Vencimento';
$string['updateassignments'] = 'Atualizar configurações de atribuição';
$string['updatecertificatetemplate'] = 'Atualizar modelo de certificado';
$string['updaterecertification'] = 'Atualizar recertificação';
$string['updatesource'] = 'Atualizar {$a}';
$string['upload_csvfile'] = 'arquivo CSV';
$string['validfrom'] = 'Válido a partir de';
$string['windowdueafter'] = 'Devido após';
$string['windowduedate'] = 'Certificação devida';
$string['windowendafter'] = 'Fechamento da janela após';
$string['windowenddate'] = 'Fechamento de janela';
$string['windowstartdate'] = 'Abertura de janela';
