<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'sk', version '5.0'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'TODO';
$string['activityisscheduledfordeletion'] = 'Prebieha odstraňovanie aktivít ...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" nie je platná hodnota pre vek.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" má viac alebo menej než jeden oddeľovač.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" nie je platná hodnota pre krajinu.';
$string['agedigitalconsentmapinvaliddefault'] = 'Chýba východzia hodnota (*)';
$string['agelocationverificationdisabled'] = 'Overenie veku a polohy je zakázané';
$string['alreadyloggedin'] = 'Už ste prihlásení ako {$a}, potrebujete sa odhlásiť a potom prihlásiť ako iný používateľ.';
$string['authnotexisting'] = 'Autorizačný zásuvný modul neexistuje';
$string['backupcontainexternal'] = 'Tento súbor záloh obsahuje externých sieťových hostiteľov Moodle, ktorí nie sú konfigurovaní lokálne.';
$string['backuptablefail'] = 'Nebolo možné nastaviť tabuľky záloh!';
$string['blockcannotadd'] = 'Nie je možné pridať blok';
$string['blockcannotconfig'] = 'Tento blok nepodporuje globálnu konfiguráciu';
$string['blockcannotinistantiate'] = 'Problém pri vytvorení objektu bloku';
$string['blockcannotread'] = 'Nebolo možné čítať údaje pre blockid= {$a}';
$string['blockdoesnotexist'] = 'Tento blok neexistuje';
$string['blockdoesnotexistonpage'] = 'Tento blok (id={$a->instanceid}) neexistuje na tejto stránke ({$a->url}).';
$string['blocknameconflict'] = 'Konflikt pri pomenovaní: blok {$a->name} má rovnaký názov s existujúcim blokom: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Modul odmieta pridať tento komentár';
$string['cannotaddcoursemodule'] = 'Nemožno pridať nový modul kurzu';
$string['cannotaddcoursemoduletosection'] = 'Nebolo možné pridať nový kurz modul do tejto sekcie.';
$string['cannotaddmodule'] = 'Modul {$a} nemohol byť pridaný do zoznamu modulov!';
$string['cannotaddnewmodule'] = 'Nebolo možné pridať nový modul {$a}';
$string['cannotaddrss'] = 'Nemáte oprávnenie pridávať rss kanály.';
$string['cannotaddthisblocktype'] = 'Nemôžete pridávať blok {$a} na túto stránku.';
$string['cannotassignrole'] = 'Nie je možné v kurze priradiť rolu';
$string['cannotassignrolehere'] = 'Nemáte oprávnenie priradiť túto rolu (id = {$a->roleid}) v tomto kontexte ({$a->context}) ';
$string['cannotassignselfasparent'] = 'Nemôžete sa priradiť sám seba ako rodiča!';
$string['cannotcallscript'] = 'Týmto spôsobom nemôžete volať tento skript';
$string['cannotcallusgetselecteduser'] = 'Nemôžete zavolať funkciu user_selector::get_selected_user, ak je multi select pravdivý.';
$string['cannotcreatebackupdir'] = 'Nie je možné vytvoriť adresár backupdata. Administrátor portálu potrebuje opraviť oprávnenia.';
$string['cannotcreatecategory'] = 'Táto kategória nebola vložená';
$string['cannotcreatedboninstall'] = '<p>Nie je možné vytvoriť databázu.</p>
<p>Zadaná databáza neexistuje a používateľ nemá oprávnenie pre vytvorenie databázy.</p>
<p>Administrátor portálu by mal overiť konfiguráciu databázy.</p>';
$string['cannotcreategroup'] = 'Chyba pri vytváraní skupiny';
$string['cannotcreatelangbase'] = 'Chyba: nebolo možné vytvoriť základný jazykový adresár';
$string['cannotcreatelangdir'] = 'Nie je možné vytvoriť priečinok pre jazykové súbory';
$string['cannotcreateorfindstructs'] = 'Chyba pri vyhľadávaní alebo vytváraní sekcií v tomto kurze';
$string['cannotcreatepopupwin'] = 'Nedefinovaný prvok - nie je možné vytvoriť pop-up okno';
$string['cannotcreatesitedir'] = 'Nie je možné vytvoriť adresár portálu. Administrátor portálu potrebuje opraviť oprávnenia.';
$string['cannotcreatetempdir'] = 'Nie je možné vytvoriť dočasný adresár.';
$string['cannotcreateuploaddir'] = 'Nie je možné vytvoriť adresár na nahrávanie. Administrátor portálu potrebuje opraviť oprávnenia.';
$string['cannotcustomisefiltersblockuser'] = 'Nemôžete upravovať nastavenia filtrov v kontextoch používateľa alebo bloku.';
$string['cannotdeletebackupids'] = 'Nie je možné vymazať identifikátory predošlých záloh';
$string['cannotdeletecategorycourse'] = 'Nepodarilo sa vymazať kurz \'{$a}\'.';
$string['cannotdeletecategoryquestions'] = 'Nie je možné vymazať otázky z kategórie \'{$a}\'.';
$string['cannotdeletecourse'] = 'Nemáte oprávnenie na vymazanie tohto kurzu.';
$string['cannotdeletecustomfield'] = 'Chyba pri vymazávaní údajov používateľského poľa.';
$string['cannotdeletedir'] = 'Nie je možné vymazať ({$a})';
$string['cannotdeletefile'] = 'Nie je možné vymazať tento súbor';
$string['cannotdeleterole'] = 'Nemôže to byť vymazané, pretože {$a}';
$string['cannotdeleterolewithid'] = 'Nie je možné vymazať rolu s ID {$a}';
$string['cannotdeletethisrole'] = 'Nemôžete vymazať túto rolu, pretože je využívaná systémom, alebo preto, lebo je to posledná rola s administrátorskými schopnosťami.';
$string['cannotdisableformat'] = 'Východzí formát nemôže byť zakázaný.';
$string['cannotdownloadcomponents'] = 'Nie je možné stiahnuť komponenty.';
$string['cannotdownloadlanguageupdatelist'] = 'Nie je možné stiahnuť aktualizácie jazykov z download.moodle.org.';
$string['cannotdownloadzipfile'] = 'Nie je možné stiahnuť súbor ZIP.';
$string['cannoteditcomment'] = 'Tento komentár nie je váš, nemôžete ho upravovať!';
$string['cannoteditcommentexpired'] = 'Toto nemôžete upravovať. Čas uplynul!';
$string['cannoteditpostorblog'] = 'Nemôžete vkladať príspevky alebo upravovať blogy.';
$string['cannoteditsiteform'] = 'Použitím tohto formulára nemôžete upravovať kurz portálu';
$string['cannotedituserpreferences'] = 'Predvoľby tohto používateľa nie je možné upravovať';
$string['cannotedityourprofile'] = 'Nemôžete upravovať vlastný profil';
$string['cannotexecduringupgrade'] = 'Nemôže byť spustené počas aktualizácie';
$string['cannotfindcategory'] = 'Nie je možné nájsť záznam kategórie z databázy podľa jej identifikátora - {$a}';
$string['cannotfindcomponent'] = 'Komponent nenájdený.';
$string['cannotfindcontext'] = 'Nie je možné nájsť kontext';
$string['cannotfindcourse'] = 'Nie je možné nájsť kurz';
$string['cannotfinddocs'] = 'Nie je možné nájsť "{$a}" súbory jazykových dokumentov';
$string['cannotfindgradeitem'] = 'Nie je možné nájsť grade_item';
$string['cannotfindgroup'] = 'Nebolo možné nájsť skupinu';
$string['cannotfindhelp'] = 'Nie je možné nájsť "{$a}" súbory  dokumentov nápovedy';
$string['cannotfindinfo'] = 'Nie je možné nájsť informácie pre: "{$a}"';
$string['cannotfindlang'] = 'Nie je možné nájsť jazykový balíček "{$a}"!';
$string['cannotfindteacher'] = 'Nie je možné nájsť učiteľa';
$string['cannotfinduser'] = 'Nie je možné nájsť používateľa: "{$a}"';
$string['cannotgeoplugin'] = 'Nie je možné sa pripojiť k serveru geoPlugin na https://www.geoplugin.com. Skontrolujte nastavení proxy, alebo nainštalujte súbor údajov MaxMind GeoIP City.';
$string['cannotgetblock'] = 'Nepodarilo sa načítať bloky z databázy';
$string['cannotgetcats'] = 'Nie je možné získať záznam kategórie';
$string['cannotgetdata'] = 'Nie je možné získať údaje';
$string['cannotgradeuser'] = 'Nie je možné ohodnotiť tohto používateľa';
$string['cannothaveparentcate'] = 'Kategória kurzu nemôže mať rodiča!';
$string['cannotimport'] = 'Chyba pri importe';
$string['cannotimportformat'] = 'Ľutujeme, importovanie tohto formátu ešte nie je implementované!';
$string['cannotimportgrade'] = 'Chyba pri importovaní známok';
$string['cannotinsertgrade'] = 'Nie je možné vložiť známku bez identifikátora kurzu!';
$string['cannotinsertrate'] = 'Nebolo možné vložiť nové hodnotenie ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Nie je možné vložiť nový záznam ID {$a}';
$string['cannotmailconfirm'] = 'Chyba pri posielaní potvrdzujúceho mailu pre zmenu hesla';
$string['cannotmanualctrack'] = 'Aktivita neposkytuje manuálne sledovanie plnenia podmienok.';
$string['cannotmapfield'] = 'Kolízia mapovania - dve polia sú namapované na rovnakú položku hodnotenia {$a}';
$string['cannotmigratedatacomments'] = 'Nie je možné migrovať komentáre dátového modulu';
$string['cannotmodulename'] = 'Nie je možné získať názov modulu v navigácii.';
$string['cannotmoduletype'] = 'Nie je možné získať typ modulu v navigácii.';
$string['cannotmovecategory'] = 'Kategóriu nie je možné presunúť';
$string['cannotmovecourses'] = 'Nie je možné presunúť kurzy z tejto kategórie do inej.';
$string['cannotmoverolewithid'] = 'Nie je možné presunúť rolu s identifikátorom {$a}';
$string['cannotopencsv'] = 'Nie je možné otvoriť CSV súbor';
$string['cannotopenfile'] = 'Nie je možné otvoriť súbor ({$a})';
$string['cannotopenforwrit'] = 'Nie je možné otvoriť pre súbor zápis: {$a}';
$string['cannotopentemplate'] = 'Nie je možné otvoriť šablónu ({$a})';
$string['cannotopenzip'] = 'Nie je možné otvoriť zip súbor, pravdepodobne chyba rozšírenia zip na 64bitovom operačnom systéme';
$string['cannotoverridebaserole'] = 'Nie je možné prepísať základné schopnosti roly';
$string['cannotoverriderolehere'] = 'Nemáte oprávnenie prepísať túto rolu (id = {$a->roleid}) v tomto kontexte ({$a->context})';
$string['cannotreadfile'] = 'Nie je možné prečítať súbor ({$a})';
$string['cannotreadtmpfile'] = 'Chyba pri čítaní dočasného súboru';
$string['cannotreaduploadfile'] = 'Nie je možné prečítať nahraný súbor';
$string['cannotremovefrommeta'] = 'Nebolo možné odstrániť vybraný kurz z tohto metakurzu';
$string['cannotreprocessgrades'] = 'Nepodarilo sa spracovať známky pre túto aktivitu {$a}';
$string['cannotresetguestpwd'] = 'Nie je možné resetovať hosťovské heslo';
$string['cannotresetmail'] = 'Chyba pri resete hesla a jeho poslaní vám';
$string['cannotresetthisrole'] = 'Nie je možné resetovať túto rolu';
$string['cannotrestore'] = 'Vyskytla sa chyba a obnova kurzu nemohla byť dokončená!';
$string['cannotrestoreadminorcreator'] = 'Pre obnovenie do nového kurzu potrebujete byť tvorca kurzov alebo administrátor!';
$string['cannotrestoreadminoredit'] = 'Pre obnovenie do vybraného kurzu potrebujete byť učiteľ s právom úprav  alebo administrátor!';
$string['cannotsaveagreement'] = 'Nepodarilo sa uložiť váš súhlas';
$string['cannotsaveblock'] = 'Chyba pri ukladaní konfigurácie bloku';
$string['cannotsavecomment'] = 'Nie je možné uložiť komentár';
$string['cannotsavedata'] = 'Nie je možné uložiť údaje';
$string['cannotsavefile'] = 'Nie je možné uložiť súbor "{$a}"';
$string['cannotsavemd5file'] = 'Nie je možné uložiť súbor MD5.';
$string['cannotsavezipfile'] = 'Nie je možné uložiť súbor ZIP.';
$string['cannotservefile'] = 'Nie je možné poskytnúť súbor - problém konfigurácie servera.';
$string['cannotsetparentforcatoritem'] = 'Nie je možné nastaviť rodičovskú kategóriu alebo kurz';
$string['cannotsetpassword'] = 'Nebolo možné nastaviť používateľské heslo!';
$string['cannotsetprefgrade'] = 'Nebolo možné nastaviť preferencie aggregationview pre {$a} v tejto kategórii známok';
$string['cannotsettheme'] = 'Nie je možné nastaviť tému!';
$string['cannotsetupblock'] = 'Nebolo možné nastaviť tabuľky blokov!';
$string['cannotsetupcapformod'] = 'Nebolo možné nastaviť schopnosti pre {$a}';
$string['cannotsetupcapforplugin'] = 'Nebolo možné nastaviť schopnosti pre {$a}';
$string['cannotshowhidecoursesincategory'] = 'Nie je možné zobraziť/skryť kurzy v kategórii {$a}.';
$string['cannotsignup'] = 'Nemôžete vytvoriť nový účet, pretože ste už prihlásený ako {$a}.';
$string['cannotunassigncap'] = 'Nebolo možné odobrať zastaranú schopnosť {$a->cap} od roly {$a->role}';
$string['cannotunassignrolefrom'] = 'Nie je možné odobrať tohto používateľa z roly id: {$a}';
$string['cannotunzipfile'] = 'Nie je možné dekomprimovať súbor';
$string['cannotupdatemod'] = 'Nebolo možné aktualizovať {$a}';
$string['cannotupdatepasswordonextauth'] = 'Nepodarilo sa aktualizovať heslo pomocou externej autentifikácie: {$a}. Pozrite si logy servera pre viac informácií.';
$string['cannotupdateprofile'] = 'Chyba pri aktualizácii záznamu používateľa';
$string['cannotupdaterecord'] = 'Nie je možné aktualizovať záznam ID {$a}';
$string['cannotupdaterss'] = 'Nie je možné aktualizovať RSS';
$string['cannotupdatesubcourse'] = 'Nebolo možné aktualizovať podriadený kurz!';
$string['cannotupdateusermsgpref'] = 'Nie je možné aktualizovať preferencie posielania správ používateľa';
$string['cannotupdateuseronexauth'] = 'Nepodarilo sa aktualizovať používateľské údaje pomocou externej autentifikácie: {$a}. Pozrite si logy servera pre viac informácií.';
$string['cannotuploadfile'] = 'Chyba pri spracovaní nahraného súboru';
$string['cannotuseadmin'] = 'Pre použitie tejto stránky potrebujete byť administrátor';
$string['cannotuseadminadminorteacher'] = 'Pre použitie tejto stránky potrebujete byť učiteľ alebo administrátor';
$string['cannotusepage'] = 'Iba učitelia a administrátori môžu používať túto stránku';
$string['cannotusepage2'] = 'Ľutujeme, nemôžete používať túto stránku.';
$string['cannotviewcategory'] = 'Nemáte oprávnenie pre zobrazenie tohto zoznamu kurzov.';
$string['cannotviewprofile'] = 'Nemáte dovolené si prezerať profil tohto používateľa.';
$string['cannotviewreport'] = 'Nemôžete prezerať tento výkaz';
$string['cannotwritefile'] = 'Nie je možné zapisovať do súboru ({$a})';
$string['categoryerror'] = 'Chyba kategórie';
$string['categoryidnumbertaken'] = 'Identifikátor ID je už používaný inou kategóriou';
$string['categorynamerequired'] = 'Je vyžadovaný názov kategórie';
$string['categorytoolong'] = 'Názov kategórie je príliš dlhý';
$string['commentmisconf'] = 'Komentár ID je nesprávne nakonfigurovaný';
$string['componentisuptodate'] = 'Komponent je aktuálny.';
$string['confirmationnotenabled'] = 'Na tomto portáli nie je povolené potvrdenie používateľov';
$string['confirmsesskeybad'] = 'Ľutujeme, ale kľúču Vášho sedenia (session) nebolo povolené vykonať túto akciu. Toto bezpečnostné opatrenie zabraňuje náhodnému alebo zákernému spúšťaniu dôležitých funkcií pod Vašim menom. Prosím, uistite sa, že skutočne chcete spustiť túto funkciu.';
$string['contenttypenotfound'] = 'Typ banky obsahu „{$a}“ neexistuje alebo nie je rozpoznaný.';
$string['contentvisibilitynotfound'] = 'Viditeľnosť obsahu s hodnotou „{$a}“ neexistuje alebo nie je rozpoznaná.';
$string['couldnotassignrole'] = 'V priebehu priraďovania vašej roly sa objavila vážna, ale bližšie neurčená chyba.';
$string['couldnotupdatenoexistinguser'] = 'Nie je možné aktualizovať používateľa - neexistuje';
$string['couldnotverifyagedigitalconsent'] = 'Pri pokuse o overenie veku pre digitálny súhlas došlo k chybe. <br /> Kontaktujte administrátora.';
$string['countriesphpempty'] = 'Chyba: Súbor countries.php v jazykovom balíčku {$a} chýba alebo je prázdny.';
$string['coursedoesnotbelongtocategory'] = 'Tento kurz nepatrí do tejto kategórie';
$string['courseformatnotfound'] = 'Formát kurzu "{$a}" neexistuje alebo nebol rozpoznaný';
$string['coursegroupunknown'] = 'Nebol určený kurz zodpovedajúci skupine {$a}';
$string['courseidnotfound'] = 'Kurz ID neexistuje';
$string['courseidnumbertaken'] = 'Identifikátor kurzu ID je už používaný iným kurzom ({$a})';
$string['coursemisconf'] = 'Kurz je nesprávne nakonfigurovaný';
$string['courserequestdisabled'] = 'Ľutujeme, ale žiadosti o vytvorenie kurzov boli zakázané administrátorom.';
$string['csvcolumnduplicates'] = 'Boli zistené duplicitné stĺpce';
$string['csvemptyfile'] = 'CSV súbor je prázdny';
$string['csvfewcolumns'] = 'Nedostatočný počet stĺpcov, skontrolujte nastavenie oddeľovača zoznamu.';
$string['csvfileerror'] = 'S formátom súboru CSV nie je niečo v poriadku. Skontrolujte počet záhlaví a zhodu stĺpcov, správnosť oddeľovača a kódovanie súborov. {$a}';
$string['csvinvalidcols'] = '<b>Neplatný formát CSV súboru:</b>Prvý riadok musí obsahovať "Header Fields" a súbor musí byť typu<br />"Expanded Fields/Comma Separated"<br />alebo<br />"Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Nesprávny CSV súbor - každý riadok musí zahŕňať alebo 49 alebo 70 polí';
$string['csvloaderror'] = 'Chyba pri nahrávaní CSV kurzu: {$a}';
$string['csvnodata'] = 'Neplatný súbor CSV - súbor CSV má záhlavie, ale neobsahuje žiadne údaje.';
$string['csvweirdcolumns'] = 'Nekorektný CSV formát súboru - počet stĺpcov nie je konštantný.';
$string['dbconnectionfailed'] = '<p>Chyba: Nedá sa pripojiť k databáze</p>
<p>Je možné, že databázový server je preťažený alebo má iné problémy.</p>
<p>Správca stránok by mal skontrolovať správnosť údajov pre pripojenie k databáze v súbore config.php</p>';
$string['dbdriverproblem'] = '<p>Chyba: Databázový ovládač má problém</p>
<p>Administrátor portálu by mal skontrolovať nastavenie serveru</p>
<p>{$a}</p>';
$string['dbsessionbroken'] = 'Bol zistený vážny problém s databázou sedenia. <br /><br />Prosím upovedomte administrátora servera.';
$string['dbsessionhandlerproblem'] = 'Natavovanie databázy sedenia sa nepodarilo. Prosím upovedomte administrátora servera.';
$string['dbsessionmysqlpacketsize'] = 'Bol zistený vážny problém so sedením. Prosím upovedomte administrátora, problém je pravdepodobne spôsobený nízkou hodnotou nastavenia MySQL: max_allowed_packet.';
$string['dbupdatefailed'] = 'Aktualizácia databázy zlyhala.';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" nemôže byť upravované. Bola nájdená závislosť na {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Chyba DDL sql vykonávania';
$string['ddlfieldalreadyexists'] = 'Pole "{$a}" už existuje';
$string['ddlfieldnotexist'] = 'Pole "{$a->fieldname}" neexistuje v tabuľke "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabuľka "{$a}" už existuje';
$string['ddltablenotexist'] = 'Tabuľka "{$a}" neexistuje';
$string['ddlunknownerror'] = 'Neznáma chyba v knižnici DDL';
$string['ddlxmlfileerror'] = 'Boli nájdené chyby XML databázového súboru';
$string['ddsequenceerror'] = 'Nesprávna definícia tabuľky "{$a}". Môže existovať iba jeden stĺpec auto a musí byť definovaný ako kľúč.';
$string['destinationcmnotexit'] = 'Modul v cieľovom súbore neexistuje';
$string['detectedbrokenplugin'] = 'Zásuvný modul "{$a}" je chybný alebo zastaralý. Nie je možné pokračovať. ';
$string['dmlexceptiononinstall'] = '<p>Došlo k chybe databázy [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Chyba pri analýze SQL dotazu';
$string['dmlreadexception'] = 'Chyba pri čítaní z databázy';
$string['dmltransactionexception'] = 'Chyba transakcie databázy';
$string['dmlwriteexception'] = 'Chyba pri zápise do databázy';
$string['dndmaxbytes'] = 'Súbor je príliš veľký. Maximálna povolená veľkosť je {$a->size}';
$string['dndread'] = 'Chyba pri čítaní súboru';
$string['dndunkownfile'] = 'Tento typ súboru nie je podporovaný';
$string['dndupload'] = 'Pri nahrávaní súboru došlo k neznámej chybe.';
$string['downgradedcore'] = 'Chyba: Kód, ktorý používate je starší ako verzia zaznamenaná v databáze.';
$string['downloadedfilecheckfailed'] = 'Kontrola stiahnutého súboru bola neúspešná';
$string['duplicatefieldname'] = 'Chyba: Duplicitný názov poľa "{$a}"';
$string['duplicatenosupport'] = 'Aktivita "{$a->modname}" sa nedá duplikovať, pretože modul {$a->modtype} nepodporuje zálohovanie a obnovenie.';
$string['duplicateparaminsql'] = 'CHYBA: v dotaze je duplikovaný parameter';
$string['duplicaterolename'] = 'V systéme už existuje rola s týmto názvom!';
$string['duplicateroleshortname'] = 'V systéme už existuje rola s týmto krátkym názvom!';
$string['duplicateusername'] = 'Duplicitné meno používateľa - záznam preskočený';
$string['editedpagenotfound'] = 'Systém nedokázal určiť stránku, na ktorej sa nachádzate. Obnovte stránku a skúste to znovu.';
$string['emailfail'] = 'E-mailovanie zlyhalo';
$string['encryption_decryptfailed'] = 'Dešifrovanie sa nepodarilo';
$string['encryption_encryptfailed'] = 'Šifrovanie sa nepodarilo';
$string['encryption_invalidkey'] = 'Nesprávny kľúč';
$string['encryption_keyalreadyexists'] = 'Kľúč už existuje';
$string['encryption_nokey'] = 'Kľúč nebol nájdený';
$string['encryption_wrongmethod'] = 'Údaje nezodpovedajú podporovanej metóde šifrovania';
$string['enddatebeforestartdate'] = 'Dátum ukončenia kurzu musí byť po dátume začiatku.';
$string['error'] = 'Vyskytla sa chyba';
$string['error_question_answers_missing_in_db'] = 'Nepodarilo sa nájsť zhodu odpoveď "{$a->answer}" v tabuľke question_answers databázy. K tomu došlo pri obnovovaní otázky s id {$a->filequestionid} zo záložného súboru, ktoré bolo zhodné s existujúcou otázkou s id {$a->dbquestionid} v databáze.';
$string['errorcleaningdirectory'] = 'Chyba pri vymazávaní adresára "{$a}"';
$string['errorcopyingfiles'] = 'Chyba pri kopírovaní súborov';
$string['errorcreatingdirectory'] = 'Chyba pri vytváraní adresára "{$a}"';
$string['errorcreatingfile'] = 'Chyba pri vytváraní súboru "{$a}"';
$string['errorcreatingrole'] = 'Chyba pri vytvorení roly';
$string['errorfetchingrssfeed'] = 'Chyba pri načítaní RSS kanálu.';
$string['erroronline'] = 'Chyba na riadku {$a}';
$string['erroroutput'] = 'Chyba výstupu, takže bolo deaktivované automatické presmerovanie.';
$string['errorparsingxml'] = 'Chyba pri spracovaní XML: {$a->errorstring} na riadku {$a->errorline}, znak {$a->errorchar}';
$string['errorprocessingarchive'] = 'Chyba pri spracovávaní archívneho súboru';
$string['errorreadingfile'] = 'Chyba pri čítaní súboru"{$a}"';
$string['errorsavingrequest'] = 'Pri ukladaní vašej žiadosti sa vyskytla chyba.';
$string['errorsettinguserpref'] = 'Chyba pri nastavovaní preferencií používateľa';
$string['errorunzippingfiles'] = 'Chyba pri odzipovaní súborov';
$string['expiredkey'] = 'Kľuč expiroval';
$string['externalauthpassworderror'] = 'Neprázdne heslo pre externé overovanie';
$string['externalfilenolocation'] = 'Externý súbor nemá žiadne umiestnenie';
$string['failtoloadblocks'] = 'Jeden alebo viac blokov je registrovaných v databáze, ale všetky nebolo možné nahrať!';
$string['fieldrequired'] = '"{$a}" je povinné pole';
$string['fileexists'] = 'Súbor existuje';
$string['filemismatch'] = 'Meno súboru nezodpovedá. Súbor "{$a->current}" by mal byť {$a->file}';
$string['filenotfound'] = 'Ľutujeme, požadovaný súbor sa nenašiel';
$string['filenotreadable'] = 'Súbor nie je čitateľný';
$string['filterdoesnothavelocalconfig'] = 'Filter {$a} nepovoľuje lokálnu konfiguráciu';
$string['filternotactive'] = 'Filter {$a} nie je v súčasnosti aktívny';
$string['filternotenabled'] = 'Filter nie je povolený!';
$string['filternotinstalled'] = 'Filter {$a} nie je nainštalovaný';
$string['forumblockingtoomanyposts'] = 'Prekročili ste limit vložených príspevkov pre toto fórum';
$string['functionalityremoved'] = 'Pokúšate sa o prístup k funkciám, ktoré boli odobraté.';
$string['gdfeaturenotsupported'] = 'Rozšírenie GD nebolo skompilované s metódami pre {$a}';
$string['gdmimetypenotsupported'] = 'Typ MIME nie je podporovaný.';
$string['generalexceptionmessage'] = 'Výnimka - {$a}';
$string['gradecantregrade'] = 'Pri výpočte známky došlo k chybe: {$a}';
$string['gradepubdisable'] = 'Publikovanie známok nie je povolené';
$string['gradesneedregrading'] = 'Známky kurzov musia byť prepočítané';
$string['groupalready'] = 'Používateľ už je členom skupiny {$a}';
$string['groupexistforcourse'] = 'Skupina "{$a}" už je v tomto kurze vytvorená';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Skupina "{$a->name}" s identifikátorom "{$a->idnumber}" už v tomto kurze existuje';
$string['grouphasidnumber'] = 'Skupina "{$a}" má nastavený identifikátor a mohla byť automaticky vytvorená externým systémom. Nemáte oprávnenie odstrániť túto skupinu.';
$string['groupinghasidnumber'] = 'Zoskupenie "{$a}" má nastavený identifikátor a mohlo byť automaticky vytvorené externým systémom. Nemáte oprávnenie odstrániť toto zoskupenie.';
$string['groupingnotaddederror'] = 'Zoskupenie "{$a}" nebolo pridané';
$string['groupnotaddederror'] = 'Skupina "{$a}" nebola pridaná';
$string['groupnotaddedtogroupingerror'] = 'Skupina "{$a->groupname}" nebola pridaná do zoskupenia "{$a->groupingname}"';
$string['groupunknown'] = 'Skupina {$a} nebola priradená k určenému kurzu';
$string['groupusernotmember'] = 'Používateľ nie je členom tejto skupiny';
$string['guestcantaccessprofiles'] = 'Hostia nemajú prístup do používateľských profilov. Prihláste sa používateľským účtom a pokračujte.';
$string['guestnocomment'] = 'Hostia nemôžu pridávať komentáre';
$string['guestnoeditprofile'] = 'Používateľ "hosť" nemôže upravovať svoj profil';
$string['guestnoeditprofileother'] = 'Profil používateľa "hosť" nie je možné upravovať';
$string['guestnorate'] = 'Hostia nemôžu hodnotiť príspevky';
$string['guestsarenotallowed'] = 'Hosťovský používateľ nemá oprávnenie na túto činnosť';
$string['hackdetected'] = 'Zistený útok hackerov';
$string['hashpoolproblem'] = 'Neplatný obsah v úložisku súborov {$a}';
$string['headersent'] = 'Hlavičky web stránky už boli poslané';
$string['idnumbertaken'] = 'ID číslo je už používané.';
$string['idnumbertoolong'] = 'ID číslo je príliš dlhé';
$string['importformatnotimplement'] = 'Ľutujeme, ale importovanie tohto formátu v súčasnosti nie je implementované!';
$string['incorrectext'] = 'Súbor má nesprávnu príponu';
$string['inplaceeditableerror'] = 'Chyba pri volaní aktualizácie procesora';
$string['installproblem'] = 'Väčšinou nie je možné zotaviť sa z chýb, ktoré sa objavia pri inštalácii. Zrejme budete musieť založiť novú databázu alebo použiť inú predponu názvov tabuliek a inštaláciu opakovať.';
$string['internalauthpassworderror'] = 'Chýbajúce alebo neplatné heslo pre interné overovanie';
$string['invalidaccess'] = 'Prístup k  tejto stránke nebol správny';
$string['invalidaccessparameter'] = 'Nesprávny parameter prístupu';
$string['invalidaction'] = 'Nesprávny parameter akcie';
$string['invalidactivityid'] = 'Nesprávne ID aktivity';
$string['invalidadminsettingname'] = 'Neplatné administrátorské nastavenie ({$a})';
$string['invalidargorconf'] = 'Neboli poskytnuté platné parametre, alebo server nie je korektne nakonfigurovaný';
$string['invalidarguments'] = 'Neboli poskytnuté platné parametre';
$string['invalidblockinstance'] = 'Neplatná inštancia bloku pre {$a}';
$string['invalidbulkenrolop'] = 'Požadovaná neplatná hromadná operácia so zápismi';
$string['invalidcategory'] = 'Nesprávna kategória';
$string['invalidcategoryid'] = 'Nesprávne ID kategórie!';
$string['invalidcomment'] = 'Nesprávny komentár';
$string['invalidcommentarea'] = 'Neplatná oblasť komentára';
$string['invalidcommentid'] = 'Neplatné ID komentára';
$string['invalidcommentitemid'] = 'Neplatné ID komentovanej položky';
$string['invalidcommentparam'] = 'Neplatné parametre komentára';
$string['invalidcomponent'] = 'Neplatný názov komponentu';
$string['invalidconfirmdata'] = 'Neplatné potvrdzujúce údaje';
$string['invalidcontentid'] = 'Neplatné ID obsahu';
$string['invalidcontext'] = 'Neplatný kontext';
$string['invalidcountrycode'] = 'Neplatný kód krajiny: {$a}';
$string['invalidcourse'] = 'Neplatný kurz';
$string['invalidcourseformat'] = 'Neplatný formát kurzu';
$string['invalidcourseid'] = 'Pokúšate sa použiť neplatný identifikátor kurzu';
$string['invalidcourselevel'] = 'Neplatná úroveň kontextu';
$string['invalidcoursemodule'] = 'Neplatný identifikátor modulu kurzu';
$string['invalidcoursemoduleid'] = 'Neplatné ID modulu kurzu: {$a}';
$string['invalidcoursenameshort'] = 'Nesprávny skrátený názov kurzu';
$string['invaliddata'] = 'Vložené údaje nie sú platné';
$string['invaliddatarootpermissions'] = 'Pri pokuse o vytvorenie adresára bolo zistené neplatné oprávnenie. Pre ďalšie podrobnosti zapnite ladenie.';
$string['invaliddatetimebetween'] = '{$a->after} musí byť pred {$a->before}.';
$string['invaliddatetimemode'] = 'Neplatný režim pre filter dátumu a času: {$a}';
$string['invaliddevicetype'] = 'Neplatný typ zariadenia';
$string['invalidelementid'] = 'Nesprávny identifikátor elementu!';
$string['invalidentry'] = 'Toto nie je platná položka!';
$string['invalidevent'] = 'Neplatná udalosť';
$string['invalidfieldname'] = '"{$a}" nie je platný názov poľa';
$string['invalidfile'] = 'Súbor nebol nájdený';
$string['invalidfiletype'] = '"{$a}" nie je platný typ súboru';
$string['invalidformatpara'] = 'Nesprávny formát pre vybraný parameter';
$string['invalidformdata'] = 'Nesprávne formulárové údaje';
$string['invalidfunction'] = 'Nesprávna funkcia';
$string['invalidgradeitemid'] = 'Nesprávny identifikátor položky hodnotenia';
$string['invalidgroupid'] = 'Zadaný nesprávny identifikátor skupiny';
$string['invalidipformat'] = 'Nesprávna IP adresa';
$string['invaliditemid'] = 'Nesprávny identifikátor položky';
$string['invalidkey'] = 'Nesprávny kľúč';
$string['invalidlanguagecode'] = 'Neplatný kód jazyka: {$a}';
$string['invalidlegacy'] = 'Nesprávna definícia typu zastaralej roly: {$a}';
$string['invalidmd5'] = 'Kontrolovaná premenná bola nesprávna - skúste znova';
$string['invalidmode'] = 'Neplatný mód ({$a})';
$string['invalidmodule'] = 'Neplatný modul';
$string['invalidmoduleid'] = 'Neplatný identifikátor modulu: {$a}';
$string['invalidmodulename'] = 'Neplatný názov modulu: {$a}';
$string['invalidnum'] = 'Neplatná numerická hodnota';
$string['invalidnumkey'] = 'Pole $conditions môže obsahovať iba numerické kľúče. Opravte prosím kód!';
$string['invalidoutcome'] = 'Nesprávny identifikátor cieľa';
$string['invalidpagesize'] = 'Neplatná veľkosť stránky';
$string['invalidpasswordpolicy'] = 'Neplatná politika hesiel';
$string['invalidpaymentmethod'] = 'Neplatná metóda platby: {$a}';
$string['invalidpersistenterror'] = 'Chyba: {$a}';
$string['invalidqueryparam'] = 'CHYBA: nesprávny počet parametrov dotazu. Malo byť: {$a->expected}, je: {$a->actual}.';
$string['invalidratingarea'] = 'Neplatná oblasť hodnotenia';
$string['invalidrecord'] = 'Nie je možné nájsť záznam v databázovej tabuľke {$a}.';
$string['invalidrecordunknown'] = 'Nie je možné nájsť žiaden záznam v databáze.';
$string['invalidrequest'] = 'Neplatná požiadavka';
$string['invalidrole'] = 'Neplatná rola';
$string['invalidroleid'] = 'Neplatný identifikátor roly';
$string['invalidscaleid'] = 'Nesprávny identifikátor stupnice';
$string['invalidsection'] = 'Modul kurzu obsahuje neplatnú sekciu';
$string['invalidsesskey'] = 'Vaša relácia pravdepodobne vypršala. Skontrolujte, či ste prihlásení, alebo sa vráťte na predchádzajúcu obrazovku a znovu načítajte stránku.';
$string['invalidshortname'] = 'Krátky názov kurzu nie je platný';
$string['invalidsourcefield'] = 'Zdrojové pole súboru konceptu je neplatné';
$string['invalidstatedetected'] = 'Niečo sa pokazilo: {$a}. Toto by sa nemalo stať.';
$string['invalidurl'] = 'Neplatný parameter URL.';
$string['invaliduser'] = 'Neplatný používateľ';
$string['invaliduserdata'] = 'Neplatné používateľské údaje: {$a}';
$string['invaliduserfield'] = 'Neplatné používateľské pole: {$a}';
$string['invaliduserid'] = 'Neplatný identifikátor používateľa';
$string['invalidusername'] = 'Zadané používateľské meno obsahuje neplatné znaky';
$string['invalidusernameblank'] = 'Meno používateľa nesmie byť prázdne';
$string['invalidxmlfile'] = '"{$a}" nie je platný XML súbor';
$string['iplookupfailed'] = 'Nie je možné nájsť geografickú informáciu o tento IP adrese {$a}.';
$string['iplookupprivate'] = 'Nie je možné zobraziť vyhľadávanie súkromnej IP adresy';
$string['ipmismatch'] = 'IP adresa klienta sa nezhoduje';
$string['itemnotfound'] = 'Nebol nájdený žiadny {$a->itemtype} s identifikátorom \'{$a->identifier}\'.';
$string['listcantmovedown'] = 'Neúspešné presunutie položky nižšie, je to posledný prvok.';
$string['listcantmoveleft'] = 'Neúspešné presunutie položky doľava, neexistuje nadradená.';
$string['listcantmoveright'] = 'Neúspešné presunutie položky doprava, neexistuje položka, ktorá by bola nadradená. Presuňte ju pod inú položku a potom ju môžete posunúť doprava.';
$string['listcantmoveup'] = 'Neúspešné presunutie položky vyššie, je to prvý prvok.';
$string['listnochildren'] = 'Položka nemá podriadené položky.';
$string['listnoitem'] = 'Položka nenájdená.';
$string['listnopeers'] = 'Nenájdení partneri k položke';
$string['listupdatefail'] = 'Databázová operácia zlyhala pri úprave hierarchie zoznamu.';
$string['logfilenotavailable'] = 'Záznamy nie sú dostupné';
$string['loginasnoenrol'] = 'Kým ste v režime "prihlásiť sa ako", nemôžete použiť funkciu zápisu a odhlásenia z kurzu.';
$string['loginasonecourse'] = 'Do tohto kurzu nemôžete vstúpiť.<br /> Musíte ukončiť režim "prihlásiť sa ako" predtým, ako vstúpite do iného kurzu.';
$string['maxareabytes'] = 'Súbor je väčší ako zostávajúci priestor v tejto oblasti.';
$string['maxbytesfile'] = 'Súbor {$a->file} je príliš veľký. Maximálna veľkosť, ktorú môžete nahrať, je {$a->size}.';
$string['maxdraftitemids'] = 'Po nahratí veľkého množstva súborov je nahrávanie súborov dočasne obmedzené. Počkajte prosím a skúste to znova.';
$string['messageundeliveredbynotificationsettings'] = 'Správu nemožno odoslať, pretože osobné správy medzi používateľmi (v nastaveniach oznámení) boli deaktivované správcom portálu.';
$string['messagingdisable'] = 'Na tomto portáli nie je povolené posielanie správ.';
$string['mimetexisnotexist'] = 'Vo vašom systéme nie je konfigurované spúšťanie mimeTeXu. Potrebujete získať <a href="https://www.forkosh.com/mimetex.zip"> https://www.forkosh.com/mimetex.zip</a> zdrojový kód v jazyku C, skompilovať ho a spustiteľný program vložiť do adresára moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Vlastný program mimetex nie je spustiteľný!';
$string['missing_moodle_backup_xml_file'] = 'V súbore zálohy {$a} chýba XML súbor.';
$string['missingcategoryrole'] = 'Nebolo možné priradiť rolu, chýbajúca rola pre kategóriu.';
$string['missingfield'] = 'Chýba pole "{$a}"';
$string['missingkeyinsql'] = 'CHYBA: v dotaze chýba parameter "{$a}".';
$string['missingparam'] = 'Chýbal potrebný parameter ({$a})';
$string['missingparameter'] = 'Chýbajúci parameter';
$string['missingrequiredfield'] = 'Chýba niektoré z povinných polí';
$string['missinguseranditemid'] = 'Chýbajúci identifikátor položky a používateľa';
$string['missingvarname'] = 'Chýbajúci povinný názov premennej!';
$string['mixedtypesqlparam'] = 'CHYBA: zmiešané typy parametrov SQL dotazu!';
$string['mnetdisable'] = 'MNET nie je povolený';
$string['mnetlocal'] = 'Vzdialení MNET používatelia sa nemôžu prihlásiť lokálne';
$string['moduledisable'] = 'Tento modul ({$a}) bol v tomto kurze zakázaný';
$string['moduledoesnotexist'] = 'Tento modul neexistuje';
$string['moduleinstancedoesnotexist'] = 'Inštancia tohto modulu neexistuje';
$string['modulemissingcode'] = 'Modul {$a} nemá k dispozícii kód potrebný pre vykonanie tejto operácie.';
$string['moodlenet:invalidshareformat'] = 'Nesprávny formát zdieľania MoodleNet';
$string['moodlenet:invalidsharestatus'] = 'Nesprávny stav zdieľania MoodleNet';
$string['moodlenet:invalidsharetype'] = 'Neplatný stav zdieľania MoodleNet';
$string['moodlenet:usernotconfigured'] = 'Nemáte oprávnenie zdieľať obsah na MoodleNet alebo je váš účet nesprávne nakonfigurovaný.';
$string['movecatcontentstoroot'] = 'Presun obsahu kategórie do koreňového umiestnenia nie je povolený. Obsah môže byť presunutý iba do inej existujúcej kategórie.';
$string['movecatcontentstoselected'] = 'Časť obsahu kategórie nemožno presunúť do vybranej kategórie.';
$string['movecategorynotpossible'] = 'Kategóriu "{$a}" nemožno presunúť do vybranej kategórie.';
$string['movecategoryownparent'] = 'Nemôžete nastaviť kategóriu "{$a}" ako nadradenú sebe samej.';
$string['movecategoryparentconflict'] = 'Nemôžete nastaviť kategóriu "{$a}" ako podkategóriu seba samej.';
$string['mssqlrcsmodemissing'] = 'Databáza nepoužíva očakávaný režim READ_COMMITTED_SNAPSHOT, čo môže viesť k nesprávnym výsledkom, hlavne u scenárov s vysokou súbežnosťou procesov. Prosím, aktivujte ju, aby bolo správanie korektné. Ďalšie informácie nájdete v dokumentácii <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Inštalovanie MSSQL pre PHP</a>.';
$string['multiplerecordsfound'] = 'Bolo nájdených viacero záznamov, očakávaný bol iba jeden.';
$string['multiplerestorenotallow'] = 'Vykonávanie viacerých obnov kurzov naraz nie je povolené!';
$string['mustbeloggedin'] = 'Na uskutočnenie tejto činnosti musíte byť prihlásený';
$string['mustbeteacher'] = 'Prístup na túto stránku je povolený iba učiteľom';
$string['myisamproblem'] = 'Databázové tabuľky využívajú systém MyISAM. Doporučuje sa využiť systém, ktorý podporuje transakcie, ako napríklad InnoDB.';
$string['needcopy'] = 'Najprv musíte niečo skopírovať!';
$string['needcoursecategroyid'] = 'Musíte zadať alebo identifikátor kurzu alebo kategóriu.';
$string['needphpext'] = 'Potrebujete pridať podporu {$a} do vašej PHP inštalácie';
$string['noadmins'] = 'Neexistujú žiadni administrátori!';
$string['noblocks'] = 'Neboli nájdené žiadne bloky!';
$string['nocapabilitytousethisservice'] = 'Používateľ nemá požadované schopnosti pre použitie tejto služby';
$string['nocategorydelete'] = 'Kategória \'{$a}\' nemôže byť vymazaná!';
$string['nocontext'] = 'Ľutujeme, tento kurz nie je platný kontext';
$string['nodata'] = 'Žiadne údaje';
$string['noexistingcategory'] = 'Neexistujúca kategória';
$string['nofile'] = 'Súbor nie je zadaný';
$string['nofiltersenabled'] = 'Nie sú povolené žiadne filtre.';
$string['nofolder'] = 'Požadovaný adresár neexistuje';
$string['noformdesc'] = 'Pre túto aktivitu nebol nájdený súbor opisu formslib.';
$string['noguest'] = 'Sem nemôžu vstupovať hostia!';
$string['noinstances'] = 'V tomto kurze sa nevyskytuje žiadna inštancia {$a}!';
$string['nologinas'] = 'Nemáte povolenie prihlásiť sa ako tento používateľ';
$string['nonmeaningfulcontent'] = 'Nezmyselný obsah';
$string['noparticipants'] = 'V tomto kurze neboli nájdení žiadni účastníci.';
$string['noparticipatorycms'] = 'Nemáte dostupné žiadne moduly kurzu, u ktorých je možné viesť záznamy v protokoloch.';
$string['nopermissions'] = 'Ľutujeme, ale v súčasnosti nemáte oprávnenia vykonať túto operáciu ({$a}).';
$string['nopermissiontoaccesspage'] = 'Na prístup na túto stránku nemáte oprávnenie.';
$string['nopermissiontocomment'] = 'Nemôžete pridávať komentáre';
$string['nopermissiontodelentry'] = 'Nemôžete odstrániť tento komentár!';
$string['nopermissiontoeditcomment'] = 'Nemôžete upraviť položky iných ľudí!';
$string['nopermissiontohide'] = 'Nie je možné skryť oprávnenia!';
$string['nopermissiontoimportact'] = 'Nemáte potrebné oprávnenia pre import aktivít do tohto kurzu';
$string['nopermissiontolock'] = 'Nie je možné zamknúť oprávnenia!';
$string['nopermissiontomanagegroup'] = 'Nemáte potrebné oprávnenia na spravovanie skupín';
$string['nopermissiontorate'] = 'Hodnotenie položiek nie je povolené!';
$string['nopermissiontoshow'] = 'Nemáte oprávnenie toto vidieť!';
$string['nopermissiontounlock'] = 'Nedá sa odomknúť oprávnenie!';
$string['nopermissiontoupdatecalendar'] = 'Ľutujeme, ale v súčasnosti nemáte oprávnenie aktualizovať udalosť v kalendári';
$string['nopermissiontoviewcalendar'] = 'Ľutujeme, ale v súčasnosti nemáte oprávnenie zobrazovať udalosť v kalendári';
$string['nopermissiontoviewgrades'] = 'Nie je možné zobraziť známky.';
$string['nopermissiontoviewletergrade'] = 'Chýbajú oprávnenia na prezeranie slovných známok';
$string['nopermissiontoviewpage'] = 'Nemáte oprávnenie na prezeranie tejto stránky';
$string['nosite'] = 'Nepodarilo sa nájsť kurz na najvyššej úrovni!';
$string['nositeid'] = 'Neexistuje identifikátor portálu';
$string['nostartdatenoenddate'] = 'Dátum ukončenia kurzu je možné nastaviť iba vtedy, keď je nastavený aj dátum začatia.';
$string['nostatstodisplay'] = 'Ľutujem, nie sú v dipozícii žiadne údaje na zobrazenie';
$string['notallowedtoupdateprefremotely'] = 'Nemáte oprávnenie na vzdialenú aktualizáciu používateľských preferencií';
$string['notavailable'] = 'Momentálne nie je dostupné';
$string['notfound'] = 'Nenájdené';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Nie ste členom tejto skupiny kurzu';
$string['notownerofkey'] = 'Nie ste vlastník tohto kľúča';
$string['nousers'] = 'Takýto používateľ neexistuje';
$string['oauth1accesstoken'] = 'Chyba OAuth 1.0: Nedostali sme prístupový token.';
$string['oauth1requesttoken'] = 'Chyba OAuth 1.0: Neobdržali sme požiadavku o token - poskytovateľ služieb môže byť dočasne nefunkčný.';
$string['oauth2refreshtokenerror'] = 'Token OAuth 2 sa nepodarilo obnoviť. Stav HTTP pre vzdialený koncový bod: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Token OAuth 2 sa nepodarilo obnoviť pre jedného alebo viacerých vydavateľov. Zobraziť výstup úlohy s podrobnosťami.';
$string['oauth2upgradetokenerror'] = 'Token OAuth 2 nie je možné aktualizovať. Stav HTTP pre vzdialený koncový bod: {$a}';
$string['onlyadmins'] = 'Túto operáciu sú oprávnení vykonať iba administrátori.';
$string['onlyeditingteachers'] = 'Túto operáciu sú oprávnení vykonať iba učitelia s právom úprav.';
$string['onlyeditown'] = 'Môžete upravovať len vlastné údaje';
$string['opensslsealerror'] = 'OpenSSL nedokáže zaistiť údaje pečaťou';
$string['opensslsignerror'] = 'OpenSSL nedokáže podpisovať údaje';
$string['orderidnotfound'] = 'Identifikátor triedenia {$a} nebol nájdený';
$string['pagenotexist'] = '<p> Došlo k neobvyklej chybe pri pokuse o zobrazenie stránky, ktorá neexistuje: </p> {$a}';
$string['pagenotexisttitle'] = 'Chyba 404: Súbor nebol nájdený';
$string['passwordexceeded'] = 'Heslo nesmie obsahovať viac ako {$a} znakov.';
$string['pathdoesnotstartslash'] = 'Neboli zadané platné argumenty, cesta nezačína s lomítkom!';
$string['pleasereport'] = 'Ak môžete, pošlite nám prosím správu s opisom operácie, ktorú ste sa pokúšali vykonať a ktorá viedla k chybe:';
$string['pluginnotexist'] = '{$a} plugin neexistuje';
$string['pluginrequirementsnotmet'] = 'Zásuvný modul "{$a->pluginname}" ({$a->pluginversion}) sa nepodarilo nainštalovať -- vyžaduje vyššiu verziu Moodle (používate verziu {$a->currentmoodle}, potrebujete verziu {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Doplnok "{$a->pluginname}" {$a->pluginversion} nepodporuje túto verziu Moodle {$a->moodleversion}. Vyhľadajte informácie doplnku a vyhľadajte podporované verzie.';
$string['prefixcannotbeempty'] = '<p>Chyba: predpona názvu tabuľky databázy nemôže byť prázdna ({$a})</p> <p>Tento problém musí opraviť administrátor portálu.</p>';
$string['privatefilesupload'] = 'Nahrávanie priamo do užívateľského neverejnej oblasti súborov už nie je podporované. Nahráva sa do pracovného priestoru a potom presúva súbory core_user::add_user_private_files';
$string['processingstops'] = 'Tu sa ukončilo spracovávanie. Zostávajúce záznamy boli ignorované.';
$string['protected_cc_not_supported'] = 'Chránené balíčky nie sú podporované';
$string['querystringcannotbeempty'] = 'Reťazec dopytu nemôže byť prázdny.';
$string['redirecterrordetected'] = 'Zistené nepodporované presmerovanie, spustenie skriptu bolo ukončené.';
$string['redissessionhandlerproblem'] = 'Nastavenie relácie redis zlyhalo. Informujte správcu servera.';
$string['refoundto'] = 'Môže byť vrátené až do sumy {$a}';
$string['refoundtoorigi'] = 'Vrátená pôvodná suma {$a}';
$string['registrationdisabled'] = 'Na tomto portáli je registrácia zakázaná';
$string['remotedownloaderror'] = '<p>Sťahovanie komponentu na váš server zlyhalo. Preverte nastavenia proxy. Vrelo odporúčame PHP rozšírenie cURL.</p>
<p>Teraz musíte stiahnuť súbor <a href="{$a->url}">{$a->url}</a> ručne, prekopírovať ho do "{$a->dest}" na vašom serveri a tam ho rozbaliť.</p>';
$string['remotedownloadnotallowed'] = 'Nahrávanie komponentov na server nie je povolené (direktíva allow_url_fopen je v stave \'vypnuté\').<br /><br />Musíte súbor stiahnuť <a href="{$a->url}">{$a->url}</a> ručne, skopírovať ho na serveri do umiestnenia "{$a->dest}" a tam ho dekomprimovať.';
$string['reportnotavailable'] = 'Tento typ správy je dostupný iba na titulný kurz.';
$string['requirecorrectaccess'] = 'Neplatná adresa URL alebo port.';
$string['requireloginerror'] = 'Kurz alebo aktivita nie je dostupný.';
$string['restore_path_element_missingmethod'] = 'Chýba metóda obnovenia {$a}. Musí ju vytvoriť vývojár.';
$string['restore_path_element_noobject'] = 'Obnovený objekt {$a} nie je objekt.';
$string['restorechecksumfailed'] = 'Vyskytli sa problémy pri spracovaní informácie o obnovovaní uloženej vo vašom sedení (session). Skontrolujte prosím nastavenia pamäte v PHP a databázové limity veľkosti. Obnovovanie bolo zastavené.';
$string['restrictedcontextexception'] = 'Ľutujeme, vykonávanie externej funkcie porušuje obmedzenia kontextu.';
$string['restricteduser'] = 'Ľutujeme, ale súčasnému účtu "{$a}" nebolo dovolené toto vykonať.';
$string['reverseproxyabused'] = 'Reverzné proxy je povolené, na server nemožno pristupovať priamo. <br /> Prosím, kontaktujte správcu servera.';
$string['rpcerror'] = 'Ooops! Vaša Mnet komunikácia zlyhala! Tu je to chybové hlásenie, ktoré by ste mali  poslať administrátorovi: ';
$string['scheduledbackupsdisabled'] = 'Automatické zálohovanie bolo administrátorom servera vypnuté';
$string['secretalreadyused'] = 'Potvrdzovací odkaz pre zmenu hesla už bol použitý, heslo nebolo zmenené.';
$string['sectioncantbefound'] = '<p><strong>Tento obsah nie je možné nájsť.</strong></p><p>Možno bol odstránený alebo je nesprávna adresa URL.';
$string['sectionnotexist'] = 'Táto sekcia neexistuje';
$string['sendmessage'] = 'Odoslať správu';
$string['sendmessagesent'] = 'Ďakujeme za spätnú väzbu týkajúcu sa: <br> {$a}';
$string['serverconnection'] = 'Chyba spojenia so serverom';
$string['servicedonotexist'] = 'Táto služba neexistuje';
$string['sessioncannotobtainlock'] = '<p>Nie je možné získať uzamknutie pre identifikátor relácie {$a->id} v rámci {$a->acquiretimeout}.</p>
<p>Je pravdepodobné, že iná stránka ({$a->whohaslock}) stále beží v inej karte prehliadača alebo neprepustila uzamknutie kvôli chybe.</p>
<p>Môžete počkať, kým vyprší časový limit uzamknutia relácie ({$a->lockexpire}), alebo môžete reštartovať reláciu prehliadača. Ak táto chyba pretrváva, informujte správcu servera.';
$string['sessioncookiesdisable'] = 'Nesprávne používanie funkcie require_key_login () - session cookies musia byť zakázané!';
$string['sessiondiskfull'] = 'Diskový priestor je zaplnený. V tomto okamihu nie je možné sa prihlásiť. <br /> <br /> Prosím, upovedomte správcu servera.';
$string['sessionerroruser'] = 'Časový limit vašej relácie vypršal. Prihláste sa znova.';
$string['sessionerroruser2'] = 'Objavila sa chyba na serveri, ktorá ovplyvňuje vaše prihlásenie. Prosím, prihláste sa znova alebo reštartujte váš prehliadač.';
$string['sessionexpired'] = 'Relácia vypršala';
$string['sessionhandlerproblem'] = 'Obslužný program relácie je nesprávne nakonfigurovaný';
$string['sessionipnomatch'] = 'Ľutujeme, ale Vaše IP číslo sa od Vášho prvého prihlásenia zmenilo. Toto bezpečnostné opatrenie zabraňuje útočníkom vydávať sa za prihláseného používateľa. Bežným používateľom by sa táto správa nemala zobraziť - kontaktujte Vášho administrátora a požiadajte ho o pomoc.';
$string['sessionipnomatch2'] = '<p>Prepáčte, ale zdá sa, že vaše IP adresa sa zmenila oproti stavu, keď ste sa prvýkrát prihlásili. Táto bezpečnostná funkcia zabraňuje crackerom ukradnúť vašu identitu, keď ste prihlásení na tento portál. Táto chyba sa môže zobraziť, ak používate bezdrôtové siete alebo ak používate roaming medzi rôznymi sieťami. Požiadajte správcu portálu o ďalšiu pomoc.</p>
<p>Ak chcete pokračovať, obnovte túto stránku stlačením klávesy F5.</p>';
$string['sessionstarterror'] = 'Reláciu sa nepodarilo spustiť. Skúste to neskôr.';
$string['sessionwaiterr'] = 'Časový limit vypršal počas čakania na uzamknutie relácie.<br />Počkajte na dokončenie aktuálnych požiadaviek a skúste to znova neskôr.';
$string['shortnametaken'] = 'Krátky názov kurzusa už používa pre iný kurz ({$a})';
$string['sitepolicynotagreed'] = 'Súhlas s pravidlami používania stránok nebol potvrdený<a href="{$a}">Kliknite na Súhlas s pravidlami používania týchto stránok.</a>';
$string['socksnotsupported'] = 'SOCKS5 proxy nie je podporovaný v PHP4';
$string['spellcheckernotconf'] = 'Kontrola pravopisu nie je nakonfigurovaná';
$string['sslonlyaccess'] = 'Ľutujeme, ale z dôvodov bezpečnosti je povolené iba pripojenie pomocou https.';
$string['statscatchupmode'] = 'Prebieha spracovanie štatistík. Doteraz boli spracované štatistiky za {$a->daysdone} dní, ešte ostáva {$a->dayspending} dní. Skúste neskôr!';
$string['statsdisable'] = 'Štatistiky nie sú povolené';
$string['statsnodata'] = 'Pre túto kombináciu kurzu a časového obdobia neexistujú žiadne údaje.';
$string['storedfilecannotcreatefile'] = 'V úložisku súborov nemožno vytvoriť lokálny súbor. Preverte nastavenie prístupových práv v dátovom adresári Moodle a voľné miesto na disku.';
$string['storedfilecannotcreatefiledirs'] = 'Nemožno vytvoriť zásobník adresárov miestnych súborov, skontrolujte oprávnenia v adresári dataroot.';
$string['storedfilecannotread'] = 'Nemožno čítať súbor: alebo neexistuje alebo je problém s oprávneniami.';
$string['storedfilecannotreadfile'] = 'Súbor "{$a}" nemožno čítať. Buď súbor neexistuje alebo existuje problém s oprávnením.';
$string['storedfilenotcreated'] = 'Nemožno vytvoriť súbor {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Neznáma výnimka pre lokálne súbory ({$a})';
$string['tagdisabled'] = 'Tagy nie sú povolené';
$string['tagnotfound'] = 'Hľadaný tag nebol nájdený v databáze.';
$string['targetdatabasenotempty'] = 'Cieľová databáza nie je prázdna. Prenos je ukončený z dôvodov bezpečnosti.';
$string['textconditionsnotallowed'] = 'Priame porovnanie textových stĺpcov nie je povolené. Použite funkciu sql_compare_text()';
$string['themenotinstall'] = 'Táto téma nie je inštalovaná!';
$string['tokengenerationfailed'] = 'Nemožno generovať nový token.';
$string['transactionvoid'] = 'Transakcia nemôže byť zrušená, pretože už zrušená bola.';
$string['unenrolerror'] = 'Pri odhlasovaní používateľa sa vyskytla chyba';
$string['unicodeupgradeerror'] = 'Ľutujeme. Vaša databáza zatiaľ nepoužíva kódovanie Unicode a táto verzia Moodle nie je schopná migráciu na Unicode vykonať. Prosím, urobte najprv upgrade na verziu 1.7.x a spusťte proces migrácie na Unicode zo stránky Administratíve. Potom budete môcť migrovať na Moodle {$a}';
$string['unknowaction'] = 'Neznáma akcia!';
$string['unknowcategory'] = 'Neznáma kategória!';
$string['unknowcontext'] = 'Toto je neznámy kontext ({$a}) v get_child_contexts!';
$string['unknowformat'] = 'Formát nie je známy ({$a})';
$string['unknownbackupexporterror'] = 'Neznáma chyba pri príprave informácií o importe';
$string['unknownblockregion'] = 'Oblasť bloku \'{$a}\' nie je rozpoznaná na tejto stránke.';
$string['unknowncategory'] = 'Neznáma kategória v kategórii s ID číslom "{$a}"';
$string['unknowncontext'] = 'Toto je neznámy kontext.';
$string['unknowncourse'] = 'Neznámy kurz s názvom "{$a}"';
$string['unknowncourseidnumber'] = 'Neznámy identifikátor kurzu "{$a}"';
$string['unknowncourserequest'] = 'Požiadavka na neznámy kurz';
$string['unknowncoursesection'] = 'Neznáma sekcia kurzu v kurze "{$a}"';
$string['unknownevent'] = 'Neznáma udalosť';
$string['unknownfiletype'] = 'Chyba, neznámy typ súboru';
$string['unknowngroup'] = 'Neznáma skupina "{$a}".';
$string['unknownjsinrequirejs'] = 'Nie je možné nájsť knižnicu JS: {$a}';
$string['unknownmodulename'] = 'Neznáme meno modulu pre formulár';
$string['unknownrole'] = 'Neznáma rola "{$a}".';
$string['unknownsortcolumn'] = 'Neznámy druh stĺpca {$a}';
$string['unknownuseraction'] = 'Nerozumiem tejto akcii používateľa';
$string['unknownuserselector'] = 'Neznámy výber používateľa';
$string['unknoworder'] = 'Neznáme poradie';
$string['unknowparamtype'] = 'Neznámy typ parametra: {$a}';
$string['unknowquestiontype'] = 'Nepodporovaný typ otázky {$a}';
$string['unknowuploadaction'] = 'Chyba: neznáma akcia pri nahrávaní ({$a})';
$string['unspecifycourseid'] = 'Je potrebné zadať alebo identifikátor kurzu, alebo jeho krátky názov alebo číselný identifikátor.';
$string['unsupportedevent'] = 'Nepodporovaný typ udalosti';
$string['unsupportedstate'] = 'Nepodporovaný stav plnenia';
$string['unsupportedwebserver'] = 'Web server softvér ({$a}) nie je podporovaný.';
$string['upgraderequires19'] = 'Chyba: Nová verzia Moodle bola nainštalovaná na server. Bohužiaľ upgrade z predchádzajúcej verzie nie je podporované.<br /> Aktualizujte prosím najprv najnovšiu verziu 1.9.x.. Môžete tiež vrátiť k predchádzajúcej verzii preinštalovaním pôvodných súborov.';
$string['upgraderunning'] = 'Práve prebieha aktualizácia portálu, skúste neskôr.';
$string['urlnotdefinerss'] = 'Pre RSS kanál nie je definované URL.';
$string['useradmineditadmin'] = 'Iba administrátori môžu upraviť konto iného administrátora';
$string['useradminodelete'] = 'Účty administrátorov nie je možné vymazať.';
$string['userautherror'] = 'Neznámy autentifikačný zásuvný modul.';
$string['userauthunsupported'] = 'Autentifikačný zásuvný modul tu nie je podporovaný.';
$string['useremailduplicate'] = 'Duplicitná adresa.';
$string['userisfilteredout'] = 'Tento používateľ nezodpovedá filtrom a preferenciám tabuliek!';
$string['usermustbemnet'] = 'Zoznam pre riadenie prístupu cez MNet sa týka iba vzdialených používateľov.';
$string['usernamelowercase'] = 'Používateľské meno musí byť malými písmenami';
$string['usernotaddederror'] = 'Používateľ nebol pridaný - chyba';
$string['usernotaddedregistered'] = 'Používateľ nebol pridaný - už sa zaregistroval';
$string['usernotaddedusernameexists'] = 'Používateľ nebol pridaný – používateľské meno už existuje pod inou e-mailovou adresou.';
$string['usernotavailable'] = 'Informácie o tomto používateľovi Vám nie sú dostupné.';
$string['usernotdeletedadmin'] = 'Používateľ nebol vymazaný - nie je možné vymazať účty administrátorov';
$string['usernotdeleteddeleted'] = 'Tento používateľ už bol odstránený.';
$string['usernotdeletederror'] = 'Používateľ nebol vymazaný - chyba-';
$string['usernotdeletedmissing'] = 'Používateľ nebol vymazaný - nebolo nájdené  používateľské meno (login).';
$string['usernotdeletedoff'] = 'Používateľ nebol vymazaný - vymazanie nebolo povolené.';
$string['usernotfullysetup'] = 'Používateľ nie je plne nastavený';
$string['usernotincourse'] = 'Tento používateľ v tomto kurze neexistuje!';
$string['usernotrenamedadmin'] = 'Nie je možné premenovať administrátorské kontá.';
$string['usernotrenamedexists'] = 'Používateľ nebol premenovaný - nové užívateľské meno už používa niekto iný.';
$string['usernotrenamedmissing'] = 'Používateľ nebol premenovaný - pôvodné užívateľské meno nebolo nájdené.';
$string['usernotrenamedoff'] = 'Používateľ nebol premenovaný - premenovanie nie je povolené.';
$string['usernotupdatedadmin'] = 'Nie je možné aktualizovať administrátorské kontá.';
$string['usernotupdatederror'] = 'Používateľ nebol aktualizovaný - chyba.';
$string['usernotupdatednotexists'] = 'Používateľ nebol aktualizovaný - neexistuje.';
$string['userquotalimit'] = 'Presiahli ste svoj limit na veľkosť súborov.';
$string['userselectortoomany'] = 'user_selector má viac ako jedného vybratého používateľa, aj keď je viacnásobný výber nepravdivý.';
$string['verifyagedigitalconsentnotpossible'] = 'Ľutujeme, digitálne overenie súhlasu s vekom momentálne nie je možné.';
$string['wrongcall'] = 'Tento skript bol zavolaný nesprávne';
$string['wrongcontextid'] = 'Identifikátor kontextu bol nesprávny (nie je možné ho nájsť)';
$string['wrongdestpath'] = 'Chybné umiestnenie cieľa';
$string['wrongroleid'] = 'Nesprávny identifikátor roly!';
$string['wrongsourcebase'] = 'Chybné základné URL serveru';
$string['wrongusernamepassword'] = 'Chybný login/heslo';
$string['wrongzipfilename'] = 'Chybné meno súboru ZIP';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Nemožno vytvoriť kurz - nemáte oprávnenie.';
$string['wwwrootmismatch'] = 'Nesprávny prístup detekovaný, tento server môže byť prístupný len cez adresu "{$a}". <br /> Prosím informujte správcu servera.';
$string['wwwrootslash'] = 'Premenná $CFG->wwwroot v súbore config.php je nastavená nesprávne, nesmie obsahovať lomku na konci.<br />Prosím informujte správcu servera.';
$string['xmldberror'] = 'Chyba XMLDB!';
$string['youcannotdeletecategory'] = 'Nemôžete vymazať kategóriu \'{$a}\', pretože alebo nemôžete vymazať jej obsah alebo ju nemôžete presunúť inam.';
