<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hvp', language 'zh_cn', version '5.0'.
 *
 * @package     hvp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptterms'] = '我接受<a href=":url" target="_blank">使用条款</a>';
$string['accountdetailslinktext'] = '这里';
$string['action'] = '操作';
$string['add'] = '添加';
$string['addedandupdatedpp'] = '添加了{$a->%new} 个新的H5P库，并更新了{$a->%old}个旧的H5P库。';
$string['addedandupdatedps'] = '添加了{$a->%new} 个新的H5P库，并更新了{$a->%old}旧的H5P库。';
$string['addedandupdatedsp'] = '添加了{$a->%new} 新的H5P库，并更新了{$a->%old}个旧的H5P库。';
$string['addedandupdatedss'] = '添加了{$a->%new} 新的H5P库，并更新了{$a->%old}旧的H5P库。';
$string['addednewlibraries'] = '添加了{$a->%new} 个新的H5P库。';
$string['addednewlibrary'] = '添加了{$a->%new} 新的H5P库。';
$string['additionalinfo'] = '附加信息';
$string['additionallicenseinfo'] = '任何关于这个证书的额外信息';
$string['addlibraries'] = '添加库';
$string['address'] = '地址';
$string['age'] = '典型年龄';
$string['agedescription'] = '此内容的目标受众。可能的输入格式，以逗号分隔：“ 1,34-45,- 50,59 -”。';
$string['ajaxfailed'] = '加载数据失败';
$string['alttext'] = '替换文字';
$string['anunexpectedsave'] = '一些意外发生，我们不能保存这些内容。';
$string['assistivetechnologieslabel'] = '辅助技术标签';
$string['attribution'] = 'attribution 4.0 国际许可证';
$string['attributionnc'] = 'Attribution-NonCommercial 4.0 国际许可证';
$string['attributionncnd'] = 'Attribution-NonCommercial-NoDerivs 4.0 国际许可证';
$string['attributionncsa'] = 'Attribution-NonCommercial-ShareAlike 4.0 国际许可证';
$string['attributionnd'] = 'Attribution-NoDerivs 4.0 国际许可证';
$string['attributionsa'] = 'Attribution-ShareAlike 4.0 国际许可证';
$string['author'] = '作者';
$string['authorcomments'] = '作者评论';
$string['authorcommentsdescription'] = '对编辑内容的评论 (此文本不会作为版权信息的一部分发布)';
$string['authorname'] = '作者姓名';
$string['authorrole'] = '作者角色';
$string['back'] = '返回';
$string['by'] = '通过';
$string['cancel'] = '取消';
$string['cancellabel'] = '取消';
$string['cancelpublishconfirmationdialogcancelbuttontext'] = '否';
$string['cancelpublishconfirmationdialogconfirmbuttontext'] = '是';
$string['cancelpublishconfirmationdialogdescription'] = '您确定要取消共享过程吗？';
$string['cancelpublishconfirmationdialogtitle'] = '取消共享';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution-NonCommercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribution-NonCommercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribution-NonCommercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribution-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['ccpdm'] = 'Public Domain Mark (PDM)';
$string['changedby'] = '更新者';
$string['changedescription'] = '更新说明';
$string['changehasbeensubmitted'] = '已提交更改';
$string['changelog'] = '更新日志';
$string['changeplaceholder'] = '裁剪照片，修改文字等';
$string['city'] = '城市';
$string['close'] = '关闭';
$string['completionpass'] = '要求及格';
$string['completionpass_help'] = '如果启用，则当学生收到及格分数（在H5P活动设置的grade部分中指定）或更高分数时，此活动被认为完成。';
$string['completionpassdesc'] = '学生必须达到及格分数才能完成此活动';
$string['confirmdialogbody'] = '您确定继续吗？此操作不可逆。';
$string['confirmdialogheader'] = '确认操作';
$string['confirmlabel'] = '确认';
$string['connectionlost'] = '连接断开。 重新连接时，结果将被存储并发送。';
$string['connectionreestablished'] = '重新建立连接。';
$string['contactperson'] = '联系人';
$string['contactpersondescription'] = '如果发布者分享的内容有任何问题，H5P将与联系人联系。联系人的姓名或其他信息将不会被公布或与第三方共享';
$string['contentavailable'] = '您的内容通常会在一个工作日内在中心可用。';
$string['contentchanged'] = '这个内容在你上次使用后已发生变化。';
$string['contentcopied'] = '内容已复制到剪贴板';
$string['contenthub:changesettings'] = '更改帐户设置<a href="{$a}">在这里</a>';
$string['contenthub:licenseagreementdescription'] = '请先阅读以下协议，然后再进行';
$string['contenthub:licenseagreementmaintext'] = '待办事项';
$string['contenthub:licenseagreementtitle'] = '最终用户许可协议（英文缩写是EULA）';
$string['contenthub:nopermissions'] = '您没有向内容中心注册网站的权限。';
$string['contenthub:register'] = '在H5P Hub上注册一个帐户<a href="{$a}">在这里</a>';
$string['contenthub:settings:box'] = '内容中心帐户';
$string['contenthub:settings:heading'] = 'H5P Hub 帐户设置';
$string['contenthubeditsharing'] = '编辑共享信息';
$string['contenthuboptions'] = 'H5P OER 中心选项';
$string['contenthubsearchdescription'] = '从 H5P Hub 查找和下载共享内容。';
$string['contenthubsearchenable'] = '在 H5P Hub 启用共享内容';
$string['contenthubshare'] = '在 H5P Hub上分享';
$string['contenthubsharinginprogress'] = '分享中';
$string['contenthubsyncchanges'] = '同步变化';
$string['contenthubunshare'] = '停止共享';
$string['contentissyncing'] = '内容正在同步。';
$string['contentlicensetitle'] = '内容许可证信息';
$string['contentnotshared'] = '内容不在中心上共享。';
$string['contentstatefrequency'] = '内容保存频率';
$string['contentstatefrequency_help'] = '您希望用户多久自动保存一次进度，按秒计算。 如果您遇到过多ajax请求的问题，请增加此数字。';
$string['contenttype'] = '内容类型';
$string['contenttypecacheheader'] = '内容类型缓存';
$string['contentupdatesoon'] = '您的内容将很快更新';
$string['copyright'] = '使用权';
$string['copyrightinfo'] = '信息版权';
$string['copyrightstring'] = '版权';
$string['copyrighttitle'] = '查看这个内容的版权信息';
$string['copyrightwarning'] = '版权材料不能在H5P内容中心共享。如果内容使用的是对开放资源友好的许可协议，如知识共享协议，请选择合适的许可协议。否则，此内容不能共享。';
$string['couldnotcopy'] = '无法复制文件';
$string['couldnotparsejsonfromzip'] = '无法从包中解析JSON：%fileName';
$string['couldnotparsepostdata'] = '无法解析发布数据。';
$string['couldnotreadfilefromzip'] = '无法从包中读取文件：%fileName';
$string['couldnotsave'] = '无法保存文件';
$string['country'] = '国家';
$string['create'] = '创建';
$string['creativecommons'] = '知识共享';
$string['ctcachebuttonlabel'] = '更新内容类型缓存';
$string['ctcacheconnectionfailed'] = '无法与 H5P Hub通信，请稍后再试。';
$string['ctcachedescription'] = '确保内容类型缓存是最新的状态将确保您可以查看，下载和使用最新的库，这不同于更新库本身。';
$string['ctcachelastupdatelabel'] = '最后更新时间';
$string['ctcacheneverupdated'] = '从未更新';
$string['ctcachenolibraries'] = '没有从H5P Hub收到任何内容类型，请稍后再试。';
$string['ctcachesuccess'] = '库缓存已成功更新！';
$string['ctcachetaskname'] = '更新内容类型缓存';
$string['currentpage'] = '页面 $current / $total';
$string['currentstep'] = '步长：总步长';
$string['dataviewreportlabel'] = '查看答案';
$string['date'] = '日期';
$string['description'] = '说明';
$string['disablefileextensioncheck'] = '禁用文件扩展名检查';
$string['disablefileextensioncheckwarning'] = '警告！ 禁用文件扩展名检查可能会带来安全隐患。禁用后将允许上传php文件，从而使攻击者有可能在您的站点上执行恶意代码。 请确保您知道您要上传的内容。';
$string['disablefullscreen'] = '禁用全屏';
$string['disablehubconfirmationmsg'] = '您是否仍要启用H5P Hub？';
$string['disablehubdescription'] = '强烈建议将此选项保持启用状态。 H5P hub提供了一个简单的界面，用于获取新的内容类型并保持现有的内容类型为最新。 通过H5P Hub, 使用共享和可重复使用内容变得更加容易。 如果禁用此选项，则必须通过文件上传表单安装和更新内容类型。';
$string['disciplinedescription'] = '您可以选择多个学科';
$string['disciplinelabel'] = '学科';
$string['disciplinelimitreachedmessage'] = '您最多可以选择的：学科数量';
$string['disciplines'] = '学科';
$string['displayoptionalwaysshow'] = '总是显示';
$string['displayoptionauthoroff'] = '由作者控制，默认为关闭';
$string['displayoptionauthoron'] = '由作者控制，默认为开启';
$string['displayoptiondownloadalways'] = '总是';
$string['displayoptiondownloadnever'] = '从不';
$string['displayoptiondownloadpermission'] = '仅当用户具有导出H5P的权限时';
$string['displayoptionnevershow'] = '从不显示';
$string['displayoptionpermissions'] = '仅在用户具有导出H5P的权限时显示';
$string['displayoptionpermissionsembed'] = '仅在用户具有嵌入H5P的权限时显示';
$string['displayoptions'] = '显示选项';
$string['download'] = '下载';
$string['downloadfailed'] = '下载请求的库失败。';
$string['downloadtitle'] = '将此内容作为H5P文件下载。';
$string['dropdownbutton'] = '按钮下拉菜单';
$string['editinfotitle'] = '编辑<strong>:标题</strong>的信息';
$string['editingfailed'] = '编辑失败了。';
$string['editor'] = '编辑器';
$string['emailaddress'] = '电子邮件地址';
$string['emailaddressdescription'] = 'H5P将使用该电子邮件地址，以便在内容出现任何问题或发布者需要恢复其帐户时与发布者联系。它不会被发布或与任何第三方共享';
$string['emailconfirmbody'] = '{$a->username}，您好：感谢您在课程“ {$a->coursename}”中对“{$a->hvpname}”提交答案。 此消息确认您的答案已保存。 您可以通过{$a->hvpurl}访问此H5P。';
$string['emailconfirmsmall'] = '感谢您向“{$a->hvpname}”提交您的答案。';
$string['emailconfirmsubject'] = '提交确认：{$a->hvpname}';
$string['emailnotifybody'] = '{$a->username}，您好：{$a->studentname}在课程“{$a->coursename}”中完成了“{$a->hvpname}”（{$a->hvpurl}）。 您可以在{$a->hvpreporturl}上查看此尝试。';
$string['emailnotifysmall'] = '{$a->studentname}已完成{$a->hvpname}。 参见{$a->hvpreporturl}';
$string['emailnotifysubject'] = '{$a->studentname} 已完成{$a->hvpname}';
$string['embed'] = '嵌入';
$string['embedloginfailed'] = '您无权访问此内容，请登录。';
$string['embedtitle'] = '查看此内容的嵌入代码。';
$string['empty'] = '无可用结果';
$string['enableabout'] = '关于H5P按钮';
$string['enablecopyright'] = '版权按钮';
$string['enabledlrscontenttypes'] = '启用依赖于LRS的内容类型';
$string['enabledlrscontenttypes_help'] = '支持那些依赖于学习记录存储（LRS) 的内容类型正常运行，例如问卷内容类型。';
$string['enabledownload'] = '允许下载';
$string['enableembed'] = '嵌入按钮';
$string['enableframe'] = '显示操作栏和框架';
$string['enablehublabel'] = '使用 H5P Hub';
$string['enablejavascript'] = '请启用 JavaScript。';
$string['enablesavecontentstate'] = '保存内容状态';
$string['enablesavecontentstate_help'] = '自动为每个用户保存交互式内容的当前状态。 这意味着用户可以在他上次退出的地方继续。';
$string['failedtodownloadh5p'] = '无法下载请求的H5P。';
$string['fileexceedsmaxsize'] = '软件包内的文件之一超出了允许的最大文件大小。 （%file %used > %max）';
$string['filenotfoundonserver'] = '在服务器上找不到文件，请检查文件上传设置。';
$string['filenotimage'] = '该文件不是图片。';
$string['filetypenotallowed'] = '不允许的文件类型。';
$string['finished'] = '已经完成';
$string['fullscreen'] = '全屏';
$string['gpl'] = '通用公共许可 V3';
$string['gradeheading'] = '{$a}的结果';
$string['gradetopassmustbeset'] = '通过等级不能为零，因为此H5P活动将其完成方法设置为要求通过等级。请设置非零值。';
$string['gradetopassnotset'] = '这个H5P活动还没有通过设置的等级。它可以在H5P活动设置的Grade部分中设置。';
$string['h5pfile'] = 'H5P文件';
$string['h5ptitle'] = '请访问H5P.org以查看更多精彩内容。';
$string['helpchoosinglicense'] = '帮我选择一个许可证';
$string['hide'] = '隐藏';
$string['hideadvanced'] = '隐藏高级的';
$string['hubcommunicationdisabled'] = '由于一项或多项H5P要求失败，因此H5P Hub通信已被禁用。';
$string['hubisdisabled'] = 'Hub 已禁用。 您可以在H5P设置中重新启用它。';
$string['hubisdisableduploadlibraries'] = 'H5P Hub已被禁用。在解决此问题以前，您仍然可以通过“ H5P库”页面上载库。';
$string['hubsettingsheader'] = '内容类型';
$string['hvp:addinstance'] = '创建新的H5P活动';
$string['hvp:contenthubregistration'] = '在H5P 内容中心注册站点';
$string['hvp:emailconfirmsubmission'] = '提交时收到确认消息';
$string['hvp:emailnotifysubmission'] = '提交尝试时获得通知消息';
$string['hvp:getcachedassets'] = '查看H5P活动所需';
$string['hvp:getembedcode'] = '当“由权限控制”选项设置时，允许查看H5P嵌入代码';
$string['hvp:getexport'] = '当“由权限控制”选项设置时，允许下载.h5p文件';
$string['hvp:installrecommendedh5plibraries'] = '安装由H5P.org建议的新的安全的H5P内容类型';
$string['hvp:manage'] = '编辑现有的H5P活动';
$string['hvp:restrictlibraries'] = '限制对某些H5P内容类型的访问';
$string['hvp:savecontentuserdata'] = '保存用户的H5P活动进度';
$string['hvp:saveresults'] = '保存已完成的H5P活动的结果';
$string['hvp:share'] = '在H5P OER 中心上共享内容';
$string['hvp:updatelibraries'] = '安装新的H5P内容类型或更新现有的内容类型';
$string['hvp:userestrictedlibraries'] = '使用受限的H5P内容类型';
$string['hvp:view'] = '查看H5P活动并与之互动';
$string['hvp:viewallresults'] = '查看所有已完成的H5P活动的结果';
$string['hvp:viewresults'] = '查看自己已完成的H5P活动的结果';
$string['icon'] = '图标';
$string['icondescription'] = '640 x480px。如果没有选择内容将使用类别图标';
$string['in'] = '在';
$string['installdenied'] = '您无权安装内容类型，请与您的系统管理员联系。';
$string['installedlibraries'] = '已安装的库';
$string['intro'] = '介绍';
$string['invalidage'] = '典型年龄的输入格式无效。可能的输入格式，以逗号分隔：“ 1,34 -45,-50,-59-”。';
$string['invalidaudioformat'] = '无效的音频文件格式，请使用mp3或wav格式。';
$string['invalidcontentfolder'] = '无效的内容文件夹';
$string['invalidcontenttype'] = '所选内容类型无效。';
$string['invalidfieldtype'] = '无效的字段类型。';
$string['invalidfile'] = '不允许使用文件“{$a->%filename}”。 仅允许使用具有以下扩展名的文件：{$a->%files-allowed}。';
$string['invalidh5ppost'] = '无法发布H5P。';
$string['invalidhvp'] = '无效的 H5P 活动';
$string['invalidimageformat'] = '图片文件格式无效，请使用jpg，png或gif。';
$string['invalidlanguagefile'] = '{$a->%library}库中的无效语言文件{$a->%file}';
$string['invalidlanguagefile2'] = '库{$a->%name}中包含无效的语言文件 {$a->%languageFile}';
$string['invalidlibrary'] = '无效的库';
$string['invalidlibrarydata'] = '{$a->%library}中为{$a->%property} 提供了无效数据';
$string['invalidlibrarydataboolean'] = '在{$a->%library}中为{$a->%property}提供了无效的数据，预期为布尔值。';
$string['invalidlibraryname'] = '无效的库名称：{$a->%name}';
$string['invalidlibrarynamed'] = '内容中使用的H5P库{$a->%library}无效';
$string['invalidlibraryoption'] = '{$a->%library}中的非法选项{$a->%option}';
$string['invalidlibraryproperty'] = '无法读取{$a->%library}中的属性{$a->%property}';
$string['invalidmainjson'] = '缺少有效的主要h5p.json文件';
$string['invalidmultiselectoption'] = '多项选择中的所选选项无效。';
$string['invalidparameters'] = '无效的参数';
$string['invalidselectoption'] = '所选选项无效。';
$string['invalidsemanticsjson'] = '{$a->%name}库中包含无效的semantics.json文件';
$string['invalidsemanticstype'] = 'H5P内部错误：语义中未知的内容类型“ {$a->@type}”，请删除内容！';
$string['invalidstring'] = '根据语义上的正则表达式，提供的字符串无效。 （值：\\\\"{$a->%value}\\\\"，正则表达式： \\\\"{$a->%regexp}\\\\”）';
$string['invalidtoken'] = 'H5P已收到无效令牌。刷新页面后再试一次';
$string['invalidvideoformat'] = '无效的视频文件格式，请使用mp4或webm格式。';
$string['invalidxapiresult'] = '找不到给定内容和用户ID组合的xAPI结果';
$string['isnowsubmitted'] = '是否已提交给H5P Hub';
$string['javascriptloading'] = '等待JavaScript ...';
$string['keywordexists'] = '关键字已经存在！';
$string['keywords'] = '关键字';
$string['keywordsdescription'] = '您可以添加多个以逗号分隔的关键字。按“Enter”或“Add”确认关键字';
$string['keywordsexists'] = '关键字已经存在！';
$string['keywordsplaceholder'] = '添加关键字';
$string['language'] = '语言';
$string['level'] = '级别';
$string['libraries'] = 'H5P库';
$string['librarydirectoryerror'] = '库目录名称必须与machineName或machineName-majorVersion.minorVersion（来自library.json）匹配。 （目录：{$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion}）';
$string['librarylistactions'] = '操作';
$string['librarylistinstancedependencies'] = '实例依赖';
$string['librarylistinstances'] = '实例';
$string['librarylistlibrarydependencies'] = '库依赖';
$string['librarylistrestricted'] = '受限的';
$string['librarylisttitle'] = '标题';
$string['librarynotselected'] = '您必须选择一种内容类型。';
$string['license'] = '许可证';
$string['licenseCC010'] = 'CC0 1.0通用（CC0 1.0）公共领域专用';
$string['licenseCC010U'] = 'CC0 1.0通用';
$string['licenseCC10'] = '1.0泛型';
$string['licenseCC20'] = '2.0泛型';
$string['licenseCC25'] = '2.5泛型';
$string['licenseCC30'] = '3.0未移植';
$string['licenseCC40'] = '4.0国际';
$string['licenseGPL'] = '通用公共许可证';
$string['licenseV1'] = '版本1';
$string['licenseV2'] = '版本2';
$string['licenseV3'] = '版本3';
$string['licensedescription'] = '为您的内容选择许可';
$string['licensedetails'] = '许可证细节';
$string['licensedialogdescription'] = '单击特定的许可证以获取有关正确使用的信息';
$string['licensee'] = '被许可人';
$string['licenseextras'] = '许可证额外费用';
$string['licenseversion'] = '许可证版本';
$string['licenseversiondescription'] = '选择许可版本';
$string['loadingdata'] = '加载数据中。';
$string['logouploadtext'] = '组织标志或头像';
$string['longdescription'] = '详细描述';
$string['longdescriptionplaceholder'] = '您的内容的详细描述';
$string['lookforupdates'] = '查询H5P更新';
$string['maintitle'] = '分享 <strong>:标题</strong>';
$string['maximumgrade'] = '最高分数';
$string['maximumgradeerror'] = '请输入一个有效的正整数作为此活动的最高分数';
$string['maxlength'] = '：length是最大字符数';
$string['maxpostsizetoosmall'] = '您的PHP最大帖子大小值(max post size)设置的很小。 使用当前设置，您不能上传大于{$a->%number} MB的文件。 在您尝试上传H5P文件，图片和视频时，这可能是个问题。 请考虑将其增加到5MB以上。';
$string['maxscore'] = '最高分数';
$string['maxuploadsizetoosmall'] = '您的PHP最大上传大小值(max upload size)设置的很小。 使用当前设置，您不能上传大于{$a->%number} MB的文件。 在您尝试上传H5P文件，图片和视频时，这可能是个问题。 请考虑将其增加到5MB以上。';
$string['messageprovider:confirmation'] = '确认您自己的H5P提交';
$string['messageprovider:submission'] = 'H5P提交通知';
$string['missingcontentfolder'] = '缺少有效的内容文件夹';
$string['missingcontentuserdata'] = '错误：找不到内容用户数据';
$string['missingcoreversion'] = '系统无法从软件包中安装<em>{$a->%component}</em> 组件，它需要更新版本的H5P插件。 本站当前正在运行版本{$a->%current}，而所需版本为{$a->%required} 或更高版本。 您应该考虑升级，然后再试一次。';
$string['missingdependency'] = '{$a->@lib}所需的依赖项{$a->@dep}缺失。';
$string['missinglibrary'] = '缺少必需的库{$a->@library}';
$string['missinglibraryfile'] = '库“{$a->%name}”缺少文件“{$a->%file}”';
$string['missinglibraryjson'] = '找不到库{$a->%name}里具有有效json格式的library.json文件';
$string['missinglibraryproperty'] = '{$a->%library}中缺少必需的属性{$a->%property}';
$string['missingmbstring'] = 'mbstring PHP扩展未加载。 H5P需要此功能才能正常运行';
$string['missingparameters'] = '缺少参数';
$string['missinguploadpermissions'] = '请注意，新的库可能存在于您上载的文件中，但系统不允许您上载新的库。 请与系统管理员联系。';
$string['modulename'] = 'H5P互动内容';
$string['modulename_help'] = 'H5P活动模块使您可以创建交互式内容，例如交互式视频，问题集，拖放问题，多项选择问题，演示等等。 除了作为丰富内容的创作工具之外，H5P还使您能够导入和导出H5P文件，从而有效地重用和共享内容。 使用xAPI可以跟踪用户交互和得分，并且可以通过系统内的得分集获得。 请注意，具有编程技能的人可能会在不了解正确答案的情况下在H5P交互中作弊并获得满分。 我们建议您不将H5P用于考试或类似考试的活动中。您可以通过使用内置的创作工具创建内容或上传您在其他启用H5P的站点上找到的H5P文件来添加交互式H5P内容。';
$string['modulename_link'] = 'https://h5p.org/moodle-more-help';
$string['modulenameplural'] = '互动内容';
$string['next'] = '下一步';
$string['nextpage'] = '下一页';
$string['noanswersubmitted'] = '该用户尚未提交对H5P的答案';
$string['nocontent'] = '找不到或无法解析content.json文件';
$string['nocontenttype'] = '没有指定内容类型。';
$string['nocopyright'] = '没有关于此内容的版权信息。';
$string['nodata'] = '没有找到符合您条件的数据。';
$string['noexport'] = '丢失的导出文件。';
$string['noextension'] = '您上传的文件不是有效的HTML5软件包（它没有.h5p文件扩展名）';
$string['noh5ps'] = '该课程没有交互式内容。';
$string['nohubregistration'] = '未在 H5P Hub注册';
$string['nojson'] = '主h5p.json文件无效';
$string['nombstringexteension'] = 'mbstring PHP扩展未加载。 H5P需要此功能才能正常运行';
$string['noparameters'] = '没有参数';
$string['noparse'] = '无法解析主h5p.json文件';
$string['nopermissiontogettranslations'] = '无法解析主h5p.json文件';
$string['nopermissiontorestrict'] = '您无权限制库。';
$string['nopermissiontosavecontentuserdata'] = '您无权保存内容用户数据。';
$string['nopermissiontosaveresult'] = '您无权保存此内容的结果。';
$string['nopermissiontoupgrade'] = '您没有升级库的权限。';
$string['nopermissiontouploadcontent'] = '您无权在此处上传内容。';
$string['nopermissiontouploadfiles'] = '您无权在此处上传文件。';
$string['nopermissiontoviewcontenthubcache'] = '您没有权限查看内容中心的元数据。';
$string['nopermissiontoviewcontenttypes'] = '您无权查看内容类型。';
$string['nopermissiontoviewresult'] = '您无权查看此内容的结果。';
$string['nosuchlibrary'] = '没有这样的库';
$string['notapplicable'] = '不适用';
$string['nounzip'] = '您上传的文件不是有效的HTML5软件包（我们无法将其解压缩）';
$string['noversionattribution'] = 'Attribution';
$string['noversionattributionnc'] = 'Attribution-NonCommercial';
$string['noversionattributionncnd'] = 'Attribution-NonCommercial-NoDerivs';
$string['noversionattributionncsa'] = 'Attribution-NonCommercial-ShareAlike';
$string['noversionattributionnd'] = 'Attribution-NoDerivs';
$string['noversionattributionsa'] = 'Attribution-ShareAlike';
$string['nowriteaccess'] = '检测到服务器存在写入访问问题。 请确保您的服务器可以写入您的数据文件夹。';
$string['noziparchive'] = '您的PHP版本不支持ZipArchive。';
$string['offlinedialogbody'] = '我们无法发送有关您完成此任务的信息。 请检查您的互联网连接。';
$string['offlinedialogheader'] = '您与服务器的连接已断开';
$string['offlinedialogretrybuttonlabel'] = '立即重试';
$string['offlinedialogretrymessage'] = '在:num....中重试';
$string['offlinesuccessfulsubmit'] = '成功提交结果。';
$string['oldphpversion'] = '您的PHP版本已过时。 H5P需要5.2版才能正常运行。 建议使用5.6版或更高版本。';
$string['olduploadoldcontent'] = '您正在尝试上传在较旧版本的H5P创建的内容。 请在其原始服务器上升级内容，然后尝试再次上传，或打开H5P Hub以使该服务器自动升级。';
$string['onlyupdate'] = '仅更新现有库';
$string['optionalinfo'] = '可选信息';
$string['options'] = '选项';
$string['originator'] = '发起者';
$string['pd'] = '公共领域';
$string['pddl'] = '公共领域的贡献和许可';
$string['pdm'] = '公共领域商标';
$string['phone'] = '电话';
$string['pleasewait'] = '请稍后';
$string['pluginadministration'] = 'H5P';
$string['pluginname'] = 'H5P';
$string['postmessagerequired'] = '必须输入发布消息才能访问给定的端点';
$string['previouspage'] = '上一页';
$string['privacy:metadata:core_files'] = 'H5P活动存储的文件将作为H5P内容包的一部分上传。';
$string['privacy:metadata:core_grades'] = 'H5P活动存储已回答H5P内容的用户得分。';
$string['privacy:metadata:hvp_content_user_data'] = '描述用户所处内容的当前状态。 用于将内容还原到以前的状态。';
$string['privacy:metadata:hvp_content_user_data:data'] = '已存储的用户数据。';
$string['privacy:metadata:hvp_content_user_data:data_id'] = '数据类型标识符。';
$string['privacy:metadata:hvp_content_user_data:delete_on_content_change'] = '标记，用于确定在内容更改时是否应删除数据。';
$string['privacy:metadata:hvp_content_user_data:hvp_id'] = '数据所属的H5P内容的ID。';
$string['privacy:metadata:hvp_content_user_data:id'] = '内容用户数据关系的ID。';
$string['privacy:metadata:hvp_content_user_data:preloaded'] = '标记，用于确定是否应将数据预加载到内容中。';
$string['privacy:metadata:hvp_content_user_data:sub_content_id'] = 'H5P的子内容，如果没有子内容，则为0。';
$string['privacy:metadata:hvp_content_user_data:user_id'] = '数据所属的用户的ID。';
$string['privacy:metadata:hvp_events'] = '跟踪已记录的H5P事件。';
$string['privacy:metadata:hvp_events:content_id'] = '对其执行操作的内容ID，如果为新内容则为0，否则为没有内容。';
$string['privacy:metadata:hvp_events:content_title'] = '内容标题。';
$string['privacy:metadata:hvp_events:created_at'] = '创建事件的时间';
$string['privacy:metadata:hvp_events:id'] = '事件的唯一ID。';
$string['privacy:metadata:hvp_events:library_name'] = '影响事件的库。';
$string['privacy:metadata:hvp_events:library_version'] = '事件影响的库版本。';
$string['privacy:metadata:hvp_events:sub_type'] = '事件的子类型，或事件的动作。';
$string['privacy:metadata:hvp_events:type'] = '事件的类型。';
$string['privacy:metadata:hvp_events:user_id'] = '执行操作的用户的ID。';
$string['privacy:metadata:hvp_xapi_results'] = '将xAPI事件存储在H5P内容中。';
$string['privacy:metadata:hvp_xapi_results:additionals'] = 'H5P可以发送的其他信息。';
$string['privacy:metadata:hvp_xapi_results:content_id'] = '执行事件的内容的ID。';
$string['privacy:metadata:hvp_xapi_results:correct_responses_pattern'] = '正确的答案模式。';
$string['privacy:metadata:hvp_xapi_results:description'] = '对操作执行的内容的描述，任务或问题。';
$string['privacy:metadata:hvp_xapi_results:id'] = 'xAPI事件的唯一ID。';
$string['privacy:metadata:hvp_xapi_results:interaction_type'] = '互动的类型。';
$string['privacy:metadata:hvp_xapi_results:max_score'] = '该事件允许获得的最高分。';
$string['privacy:metadata:hvp_xapi_results:parent_id'] = '执行此事件的内容的父级ID。 如果没有父项，则为Null。';
$string['privacy:metadata:hvp_xapi_results:raw_score'] = '为该事件获得的得分。';
$string['privacy:metadata:hvp_xapi_results:response'] = '用户发送的响应。';
$string['privacy:metadata:hvp_xapi_results:user_id'] = '执行操作的用户的ID。';
$string['publisherdescription'] = '发布者说明';
$string['publisherdescriptiontext'] = '这将显示在共享内容的“发布者信息”下';
$string['publisherfielddescription'] = '这将在共享内容上显示为“发布者名称”';
$string['publisherfieldtitle'] = '发布者';
$string['question'] = '问题';
$string['registeronhub'] = '在H5P Hub上注册';
$string['registrationfailed'] = '出现了一个错误';
$string['registrationfaileddescription'] = '此时我们无法创建一个帐户。出了一些问题。请稍后再试。';
$string['registrationtitle'] = 'H5P Hub 注册';
$string['remove'] = '移除';
$string['removechip'] = '移除：从名单上移除芯片';
$string['removeimage'] = '清除图片';
$string['removeoldlogentries'] = '删除旧的H5P日志条目';
$string['removeoldmobileauthentries'] = '删除旧的H5P移动身份验证条目';
$string['removetmpfiles'] = '删除旧的H5P临时文件';
$string['reportingquestionsremaininglabel'] = '剩下的待评分问题';
$string['reportingscaledscoredelimiter'] = ',';
$string['reportingscaledscorelabel'] = '成绩簿分数：';
$string['reportingscoredelimiter'] = '总分为';
$string['reportingscorelabel'] = '得分:';
$string['reportnotsupported'] = '不支持';
$string['reportsubmitgradelabel'] = '提交成绩';
$string['requiredinfo'] = '必填信息';
$string['resizescript'] = '如果需要动态调整嵌入内容的大小，请在您的网站上包含此脚本：';
$string['resubmitscores'] = '尝试提交存储的结果。';
$string['reuse'] = '重复使用';
$string['reusecontent'] = '允许重复使用';
$string['reusedescription'] = '重复使用这个内容。';
$string['reveal'] = '显示';
$string['reviewandsave'] = '查看和保存';
$string['reviewandshare'] = '查看和保存';
$string['reviewinfo'] = '审核信息';
$string['reviewmessage'] = '请在您分享之前查看下面的信息';
$string['reviseserversetupandretry'] = '修改服务器设置后，可以在“ H5P设置”中重新启用H5P Hub通信。';
$string['savechanges'] = '保存更改';
$string['score'] = '分数';
$string['screenshots'] = '截屏';
$string['screenshotsdescription'] = '最多添加五个内容的截图';
$string['search'] = '搜索';
$string['searchplaceholder'] = '键入搜索学科';
$string['sendusagestatistics'] = '贡献使用情况统计数据';
$string['sendusagestatistics_help'] = '使用情况统计数字将自动报告，以帮助开发人员更好地了解H5P的使用方式并确定潜在的改进领域。 在<a {$a}> h5p.org上详细了解收集哪些数据</a>。';
$string['settings'] = 'H5P设置';
$string['share'] = '分享';
$string['shared'] = '分享成功';
$string['sharefailed'] = '分享失败';
$string['sharetryagain'] = '出错了，请再试一次分享。';
$string['sharingnote'] = '所有内容细节都可以在分享后进行编辑';
$string['shortdescription'] = '简短描述';
$string['shortdescriptionplaceholder'] = '对您的内容的简短描述';
$string['showadvanced'] = '显示高级设置';
$string['showless'] = '显示较少内容';
$string['showmore'] = '显示更多内容';
$string['sitecouldnotberegistered'] = '无法将站点注册到Hub，请与您的站点管理员联系。';
$string['sitekey'] = '站点密钥';
$string['sitekeydescription'] = '站点密钥是一个秘密，可以通过Hub唯一地标识此站点。';
$string['sitekeyregistered'] = '为您提供了一个唯一密钥，该密钥可在接收新更新时用Hub标识您。 该键可在“ H5P设置”页面中查看。';
$string['size'] = '尺寸';
$string['somekeywordsexists'] = '其中一些关键词已经存在';
$string['source'] = '来源';
$string['sslnotenabled'] = '您的服务器未启用SSL。 您应该启用SSL以确保其与H5P Hub的安全连接。';
$string['startingover'] = '您将重新开始。';
$string['subcontentwarning'] = '子内容（图片、问题等）将在许可下共享，除非在创作工具中另有规定';
$string['sublevel'] = '子级别';
$string['submitted'] = '提交！';
$string['successfullyregisteredwithhub'] = '您的站点已成功在H5P Hub中注册。';
$string['successfullyregistred'] = '您已经在H5P Hub上成功注册了一个帐户';
$string['successfullyregistreddescription'] = '您的帐户详细信息可以更改';
$string['successfullyupdated'] = '您的H5P Hub帐户设置已成功更改';
$string['thumbnail'] = '缩略图';
$string['title'] = '标题';
$string['unabletocreatedir'] = '无法创建目录。';
$string['unabletogetfieldtype'] = '无法获取字段类型。';
$string['undisclosed'] = '未公开';
$string['unpackedfilesexceedsmaxsize'] = '解压缩文件的总大小超过了允许的最大大小值。 (%used > %max)';
$string['updatedlibraries'] = '更新了{$a->%old} H5P库。';
$string['updatedlibrary'] = '更新了{$a->%old} H5P库。';
$string['updatelibraries'] = '更新了所有库';
$string['updateregistrationonhub'] = '保存帐户设置';
$string['upgrade'] = '升级H5P';
$string['upgradebuttonlabel'] = '升级';
$string['upgradedone'] = '您已成功升级{$a}个内容实例。';
$string['upgradeerror'] = '处理参数时发生错误：';
$string['upgradeerrorcontent'] = '无法升级内容%id:';
$string['upgradeerrordata'] = '无法加载库%lib的数据。';
$string['upgradeerrormissinglibrary'] = '缺少必需的库%lib。';
$string['upgradeerrornotsupported'] = '参数包含不支持的%used。';
$string['upgradeerrorparamsbroken'] = '参数已损坏。';
$string['upgradeerrorscript'] = '无法加载%lib的升级脚本。';
$string['upgradeerrortoohighversion'] = '参数仅包含%used，但仅支持%supported或更早的版本。';
$string['upgradeheading'] = '升级{$a}个内容';
$string['upgradeinprogress'] = '升级到%ver...';
$string['upgradeinvalidtoken'] = '错误：无效的安全令牌！';
$string['upgradelibrarycontent'] = '升级库内容';
$string['upgradelibrarymissing'] = '错误：库缺失！';
$string['upgrademessage'] = '您将要升级{$a}个内容实例。 请选择升级版本。';
$string['upgradenoavailableupgrades'] = '该库没有可用的升级。';
$string['upgradenothingtodo'] = '没有要升级的内容实例。';
$string['upgradereturn'] = '返回';
$string['upload'] = '上传';
$string['uploadlibraries'] = '上传库';
$string['uploadsizelargerthanpostsize'] = '您的PHP最大上传大小值大于最大发布大小值。 已知这会在某些安装中引起问题。';
$string['user'] = '用户';
$string['validatingh5pfailed'] = '验证h5p软件包失败。';
$string['validationfailed'] = '请求的H5P无效';
$string['viewreportlabel'] = '报告';
$string['welcomecommunity'] = '我们希望您会喜欢H5P，并通过我们的<a {$a->forums}>论坛</a>加入我们不断发展的社区。';
$string['welcomecontactus'] = '如果您有任何反馈意见，请随时<a {$a}>与我们联系</a>.。 我们非常重视用户的反馈，并致力于每天改善H5P！';
$string['welcomegettingstarted'] = '要开始使用H5P和Moodle，请查看我们的<a {$a->moodle_tutorial}>教程</a>，并查看H5P的<a {$a->example_content}>示例内容</a> 来获取创作灵感。';
$string['welcomeheader'] = '欢迎来到H5P的世界！';
$string['wrongversion'] = '此内容中使用的H5P库 {$a->%machineName}的版本无效。 内容包含{$a->%contentLibrary}，但应为{$a->%semanticsLibrary}。';
$string['year'] = '年';
$string['years'] = '年份';
$string['yearsfrom'] = '年（从）';
$string['yearsto'] = '年（至）';
$string['zip'] = 'Zip';
