<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'et', version '5.0'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'ÜLESANDED';
$string['activityisscheduledfordeletion'] = 'Tegevuse kustutamine on pooleli...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" ei on vanuse jaoks kehtiv väärtus.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" on enam kui üks komaeraldaja.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" pole riigi jaoks kehtiv väärtus.';
$string['agedigitalconsentmapinvaliddefault'] = 'Vaikeväärtus (*) puudub.';
$string['agelocationverificationdisabled'] = 'Vanuse ja asukoha kinnitamine on keelatud';
$string['alreadyloggedin'] = 'Olete sisse logitud kasutajana {$a}, enne teise kasutajana sisselogimist peate välja logima.';
$string['authnotexisting'] = 'Volituste pluginat ei eksisteeri';
$string['backupcontainexternal'] = 'See varufail sisaldab väliseid Moodle\'i võrgu hoste, mida pole kohapeal konfigureeritud';
$string['backuptablefail'] = 'Varukoopiate tabeleid EI õnnestunud seadistada!';
$string['blockcannotconfig'] = 'See plokk ei toeta globaalset konfigureerimist';
$string['blockcannotinistantiate'] = 'Probleem plokiobjekti eksemplari loomisel';
$string['blockcannotread'] = 'Blockid = {$a} andmeid ei õnnestunud lugeda';
$string['blockdoesnotexist'] = 'Seda plokki pole olemas';
$string['blockdoesnotexistonpage'] = 'Seda plokki (ID={$a->instanceid}) ei eksisteeri sellel lehel ({$a->url}).';
$string['blocknameconflict'] = 'Nimetamise konflikt: plokil {$a->name} on olemasoleva plokiga sama pealkiri: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Kommentaari tagakutse lükkas selle kommentaari tagasi.';
$string['cannotaddcoursemodule'] = 'Uut kursusemoodulit ei saa lisada';
$string['cannotaddcoursemoduletosection'] = 'Sellesse jaotisse ei saa uut kursusemoodulit lisada';
$string['cannotaddmodule'] = 'Moodulit {$a} ei saanud moodulite loendisse lisada!';
$string['cannotaddnewmodule'] = 'Uut kursuse {$a} moodulit ei saa lisada';
$string['cannotaddrss'] = 'Teil pole luba RSS-voogude lisamiseks';
$string['cannotaddthisblocktype'] = 'Te ei saa lisada sellele lehele plokki {$a}.';
$string['cannotassignrole'] = 'Ei saa määrata kursusel rolli';
$string['cannotassignrolehere'] = 'Teil pole lubatud määrata seda rolli (ID = {$a->roleid}) selles kontekstis ({$a->context})';
$string['cannotassignselfasparent'] = 'Ei saa määrata ennast vanemaks.';
$string['cannotcallscript'] = 'Te ei saa niimoodi seda skripti välja kutsuda';
$string['cannotcallusgetselecteduser'] = 'Te ei saa kutsuda user_selector::get_selected_user, kui mitmikvalik on tõene.';
$string['cannotcreatebackupdir'] = 'Varundusandmete kausta ei saanud luua. Saidi administraator peab parandama faili õigused';
$string['cannotcreatecategory'] = 'Kategooriat ei sisestatud';
$string['cannotcreatedboninstall'] = '<p>Andmebaasi ei saa luua.</p>
<p>Määratud andmebaasi pole ja antud kasutajal puudub õigus andmebaasi loomiseks.</p>
<p>Õpikeskkonna administraator peab kontrollima andmebaasi konfiguratsiooni</p>';
$string['cannotcreategroup'] = 'Viga grupi loomisel';
$string['cannotcreatelangbase'] = 'Viga: kataloogi ei saanud luua';
$string['cannotcreatelangdir'] = 'Keelekataloogi ei saa luua';
$string['cannotcreateorfindstructs'] = 'Selle kursuse jaoks jaotisestruktuuride otsimisel või loomisel ilmnes tõrge';
$string['cannotcreatepopupwin'] = 'Määratlemata element - hüpikakent ei saa luua';
$string['cannotcreatesitedir'] = 'Saidikausta ei saa luua. Saidi administraator peab parandama faili õigused.';
$string['cannotcreatetempdir'] = 'Ajutist kataloogi ei saa luua';
$string['cannotcreateuploaddir'] = 'Üleslaadimiskausta ei saa luua. Saidi administraator peab parandama faili õigused.';
$string['cannotcustomisefiltersblockuser'] = 'Te ei saa kohandada filtrite sätteid kasutaja või ploki kontekstides.';
$string['cannotdeletebackupids'] = 'Eelmise varundamise ID-sid ei saanud kustutada';
$string['cannotdeletecategorycourse'] = 'Kursuse „{$a}“ kustutamine nurjus';
$string['cannotdeletecategoryquestions'] = 'Küsimusi ei saanud kategooriast „{$a}“ kustutada';
$string['cannotdeletecourse'] = 'Teil pole selle kursuse kustutamise õigust';
$string['cannotdeletecustomfield'] = 'Kohandatud välja andmete kustutamisel ilmnes tõrge';
$string['cannotdeletedir'] = 'Ei saa kustutada ({$a})';
$string['cannotdeletefile'] = 'Seda faili ei saa kustutada';
$string['cannotdeleterole'] = 'Ei saa kustutada, sest {$a}';
$string['cannotdeleterolewithid'] = 'Rolli ID-ga {$a} ei saa kustutada';
$string['cannotdeletethisrole'] = 'Te ei saa seda rolli kustutada, sest seda kasutab süsteem või see on viimane administraatori tegevusloaga roll.';
$string['cannotdisableformat'] = 'Vaikevormingut ei saa keelata';
$string['cannotdownloadcomponents'] = 'Komponente ei saa alla laadida';
$string['cannotdownloadlanguageupdatelist'] = 'Keelevärskenduste loendit ei saa saidilt download.moodle.org alla laadida';
$string['cannotdownloadzipfile'] = 'ZIP-faili ei saa alla laadida';
$string['cannoteditcomment'] = 'See kommentaar pole teie redigeerida!';
$string['cannoteditcommentexpired'] = 'Te ei saa seda redigeerida. Aeg on lõppenud!';
$string['cannoteditpostorblog'] = 'Blogisid ei saa postitada ega redigeerida';
$string['cannoteditsiteform'] = 'Te ei saa muuta õpikeskkonna kursust, kasutades seda vormi';
$string['cannotedituserpreferences'] = 'Selle kasutaja eelistusi ei saa muuta';
$string['cannotedityourprofile'] = 'Kahjuks ei saa te oma profiili muuta';
$string['cannotexecduringupgrade'] = 'Ei saa käivitada uuendamise ajal';
$string['cannotfindcategory'] = 'Ei leia kategooria kirjet andmebaasist (ID = {$a})';
$string['cannotfindcomponent'] = 'Ei leia komponenti';
$string['cannotfindcontext'] = 'Ei leidnud konteksti';
$string['cannotfindcourse'] = 'Ei leia kursust';
$string['cannotfinddocs'] = '"{$a}" keeledokumentide faile ei leita';
$string['cannotfindgradeitem'] = 'Ei leia üksust grade_item';
$string['cannotfindgroup'] = 'Rühma ei leitud';
$string['cannotfindhelp'] = '"{$a}" keeleabifaile ei leita';
$string['cannotfindinfo'] = 'Ei leia teavet järgmise kohta: „{$a}”';
$string['cannotfindlang'] = 'Keelekomplekti „{$a}” ei leitud!';
$string['cannotfindteacher'] = 'Ei leia õpetajat';
$string['cannotfinduser'] = 'Ei leia kasutajat nimega „{$a}“';
$string['cannotgeoplugin'] = 'Ei saa luua ühendust geoPlugini serveriga aadressil http://www.geoplugin.com, kontrollige puhverserveri sätteid või installige MaxMind GeoLite City andmefail';
$string['cannotgetblock'] = 'Plokke andmebaasist ei õnnestunud leida';
$string['cannotgetcats'] = 'Ei saa kategooria kirjet';
$string['cannotgetdata'] = 'Ei saa andmeid';
$string['cannotgradeuser'] = 'Ei saa seda kasutajat hinnata';
$string['cannothaveparentcate'] = 'Kursuse kategoorial ei saa olla ülemkategooriat.';
$string['cannotimport'] = 'Importimistõrge';
$string['cannotimportformat'] = 'Kahjuks pole selle vormingu import veel juurutatud.';
$string['cannotimportgrade'] = 'Hinde importimise tõrge';
$string['cannotinsertgrade'] = 'Hinnet ei saa sisestada ilma kursuse ID-ta.';
$string['cannotinsertrate'] = 'Ei saanud sisestada uut reitingut ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Uut kirje ID-d {$a} ei saanud sisestada';
$string['cannotmailconfirm'] = 'Parooli muutmise kinnitusmeili saatmisel ilmnes tõrge';
$string['cannotmanualctrack'] = 'Tegevus ei paku lõpetamise edenemise käsitsi jälgimist';
$string['cannotmapfield'] = 'Tuvastati vastenduse vasturääkivus: kaks välja seostuvad sama hindeelemendiga {$a}';
$string['cannotmigratedatacomments'] = 'Andmemooduli kommentaare ei saa migreerida';
$string['cannotmodulename'] = 'Järgu navigeerimisel ei õnnestu  leida mooduli nime';
$string['cannotmoduletype'] = 'Järgu navigeerimisel ei õnnestu leida mooduli tüüpi';
$string['cannotmovecategory'] = 'Kategooriat ei saa teisaldada';
$string['cannotmovecourses'] = 'Kursusi ei saa praegusest kategooriast uude kategooriasse teisaldada.';
$string['cannotmoverolewithid'] = 'Ei saa teisaldada rolli ID-ga {$a}';
$string['cannotopencsv'] = 'CSV-faili ei saa avada';
$string['cannotopenfile'] = 'Ei saa avada faili ({$a})';
$string['cannotopenforwrit'] = 'Kirjutamiseks avamine ebaõnnestus: {$a}';
$string['cannotopentemplate'] = 'Malli faili ei saa avada ({$a})';
$string['cannotopenzip'] = 'ZIP-faili ei saa avada, tõenäoliselt on 64-bitises operatsioonisüsteemis ZIP-laiendi programmiviga';
$string['cannotoverridebaserole'] = 'Baasrolli tegevuslube ei saa alistada';
$string['cannotoverriderolehere'] = 'Teil pole lubatud seda rolli (id = {$a->roleid}) selles kontekstis ({$a->context}) üle kirjutada';
$string['cannotreadfile'] = 'Faili ({$a}) ei saa lugeda';
$string['cannotreadtmpfile'] = 'Ajutise faili lugemisel ilmnes tõrge';
$string['cannotreaduploadfile'] = 'Üles laaditud faili ei saa lugeda';
$string['cannotremovefrommeta'] = 'Valitud kursust ei saanud sellest metakursusest eemaldada!';
$string['cannotreprocessgrades'] = 'Selle tegevuse {$a} hindeid ei saanud ümber töödelda';
$string['cannotresetguestpwd'] = 'Külalise parooli ei saa lähtestada';
$string['cannotresetmail'] = 'Parooli lähtestamisel ja teile meilisõnumi saatmisel ilmnes tõrge';
$string['cannotresetthisrole'] = 'Seda rolli ei saa lähtestada';
$string['cannotrestore'] = 'Ilmnes tõrge ja taastamist ei saanud lõpetada.';
$string['cannotrestoreadminorcreator'] = 'Uuele kursusele naasmiseks peate olema looja või administraator!';
$string['cannotrestoreadminoredit'] = 'Valitud kursusele naasmiseks peate olema õpetaja või administraator!';
$string['cannotsaveagreement'] = 'Teie lepingut ei õnnestunud salvestada';
$string['cannotsaveblock'] = 'Viga ploki konfiguratsiooni salvestamisel';
$string['cannotsavecomment'] = 'Ei saa kommentaari salvestada';
$string['cannotsavedata'] = 'Ei saa andmeid salvestada';
$string['cannotsavefile'] = 'Ei saa salvestada faili {$a}"!';
$string['cannotsavemd5file'] = 'MD5-faili ei saa salvestada';
$string['cannotsavezipfile'] = 'ZIP-faili ei saa salvestada';
$string['cannotservefile'] = 'Faili ei saa teenindada – serveri konfiguratsiooniprobleem.';
$string['cannotsetparentforcatoritem'] = 'Kategooriale ega kursuseüksusele ei saa ülatasemeüksust määrata.';
$string['cannotsetpassword'] = 'Kasutaja parooli ei saanud määrata.';
$string['cannotsetprefgrade'] = 'Selle hinnete kategooria jaoks ei saanud eelistuste liitmise vaateks seada {$a}';
$string['cannotsettheme'] = 'Ei saanud teemat seadistada.';
$string['cannotsetupblock'] = 'Blokeerimistabeleid EI SAA edukalt seadistada!';
$string['cannotsetupcapformod'] = '{$a} võimalusi ei saanud seadistada';
$string['cannotsetupcapforplugin'] = '{$a} võimalusi ei saanud seadistada';
$string['cannotshowhidecoursesincategory'] = 'Ei saa kuvada/peita kursusi kategoorias {$a}.';
$string['cannotsignup'] = 'Te ei saa uut kontot luua, kuna olete juba sisse logitud kui {$a}.';
$string['cannotunassigncap'] = 'Ebasoovitatavat tegevusluba {$a->cap} ei saa rollilt {$a->role} eemaldada';
$string['cannotunassignrolefrom'] = 'ei saa eraldada seda kasutajat rolli ID-st {$a}';
$string['cannotunzipfile'] = 'Faili ei saa lahti pakkida.';
$string['cannotupdatemod'] = 'Üksust {$a} ei saanud värskendada';
$string['cannotupdatepasswordonextauth'] = 'Parooli värskendamine välises autentimises nurjus: {$a}. Rohkem üksikasju leiate serveri logidest.';
$string['cannotupdateprofile'] = 'Tõrge kasutajakirje värskendamisel';
$string['cannotupdaterecord'] = 'Ei saanud uuendada kaardi ID-d {$a}';
$string['cannotupdaterss'] = 'Ei saa RSS-i uuendada';
$string['cannotupdatesubcourse'] = 'Ei saanud uuendada alamkursust.';
$string['cannotupdateusermsgpref'] = 'Kasutaja sõnumieelistusi ei saa värskendada';
$string['cannotupdateuseronexauth'] = 'Kasutajaandmete värskendamine välises autentimises nurjus: {$a}. Rohkem üksikasju leiate serveri logidest.';
$string['cannotuploadfile'] = 'Tõrge üleslaaditud faili töötlemisel';
$string['cannotuseadmin'] = 'Selle lehe kasutamiseks peate olema administraator';
$string['cannotuseadminadminorteacher'] = 'Sa pead oleme õpetaja või administraator, et seda lehte kasutada';
$string['cannotusepage'] = 'Ainult õpetajad ja administraatorid saavad seda lehte kasutada';
$string['cannotusepage2'] = 'Kahjuks ei või te seda lehte kasutada';
$string['cannotviewcategory'] = 'Sul ei ole õigust kursuste nimekirja vaadata';
$string['cannotviewprofile'] = 'Te ei saa selle kasutaja profiili vaadata.';
$string['cannotviewreport'] = 'Te ei saa seda aruannet vaadata';
$string['cannotwritefile'] = 'Faili ei saa kirjutada ({$a})';
$string['categoryerror'] = 'Kategooriatõrge';
$string['categoryidnumbertaken'] = 'ID-numbrit kasutatakse juba teises kategoorias';
$string['categorynamerequired'] = 'Kategooria nimi on nõutav';
$string['categorytoolong'] = 'Kategooria nimi on liiga pikk';
$string['commentmisconf'] = 'Kommentaari ID on valesti konfigureeritud';
$string['componentisuptodate'] = 'Komponent on ajakohane';
$string['confirmationnotenabled'] = 'Kasutaja kinnitus pole sellel saidil lubatud';
$string['confirmsesskeybad'] = 'Kahjuks ei saanud teie seansivõtit selle toimingu tegemiseks kinnitada. See turbefunktsioon takistab tähtsate funktsioonide kogemata või pahatahtlikult teie nimel käivitamist. Veenduge, et soovite tõesti seda funktsiooni kasutada.';
$string['contenttypenotfound'] = 'Sisupanga tüüpi \'{$a}\' ei eksisteeri või seda ei tuvastata.';
$string['couldnotassignrole'] = 'Tõsine, kuid teadmata viga tekkis, kui prooviti määrata Sinule rolli';
$string['couldnotupdatenoexistinguser'] = 'Kasutajat ei saa värskendada - kasutajat pole olemas';
$string['countriesphpempty'] = 'Viga: keelepaketis {$a} sisalduv fail country.php on tühi või puudub.';
$string['coursedoesnotbelongtocategory'] = 'Kursus ei kuulu sellesse kategooriasse';
$string['courseformatnotfound'] = 'Kursusevormingut {$a} pole olemas või ei tunta seda ära';
$string['coursegroupunknown'] = 'Rühmale {$a} vastavat kursust ei ole määratud';
$string['courseidnotfound'] = 'Kursuse ID-d pole olemas';
$string['courseidnumbertaken'] = 'ID-numbrit kasutatakse juba teise kursusega ({$a})';
$string['coursemisconf'] = 'Kursus on valesti konfigureeritud';
$string['courserequestdisabled'] = 'Kahjuks on administraator kursusetaotlused keelanud.';
$string['csvcolumnduplicates'] = 'Tuvastati duplikaatveerud';
$string['csvemptyfile'] = 'CSV-fail on tühi';
$string['csvfewcolumns'] = 'Veerge pole piisavalt, kontrollige eraldaja sätet';
$string['csvfileerror'] = 'CSV-faili vormingus on midagi valesti. Kontrolli, kas pealkirjade ja veergude arv ühtib ning kas eraldaja ja failikodeering on õiged: {$a}';
$string['csvinvalidcols'] = '<b>CSV-fail ei sobi:</b> Esimeses reas peab sisalduma „Header Fields“ ja faili tüüp peab olema <br />„Expanded Fields/Comma Separated“<br />või<br /> „Expanded Fields with CAVV Result Code/Comma Separated“';
$string['csvinvalidcolsnum'] = 'CSV-fail ei sobi: iga rida peab sisaldama 49 või 70 välja';
$string['csvloaderror'] = 'CSV-faili laadimisel ilmnes tõrge: {$a}';
$string['csvnodata'] = 'Kehtetu CSV-fail - CSV-failil on päised, kuid need ei sisalda andmeid.';
$string['csvweirdcolumns'] = 'CSV-faili vorming ei sobi: veergude arv pole püsiv.';
$string['dbconnectionfailed'] = '<p>Tõrge: Andmebaasiühendus nurjus</p>
<p>On võimalik, et andmebaas on üle koormatud või ei tööta korralikult.</p>
<p>Õpikeskkonna administraator peaks kontrollima ka andmebaasi üksikasju, et need oleksid failis config.php õigesti määratud.</p>';
$string['dbdriverproblem'] = '<p>Tõrge: tuvastati andmebaasidraiveri probleem</p>
<p>Õpikeskkonna administraator peaks kontrollima serveri konfiguratsiooni</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Tuvastati tõsine andmebaasisessiooni probleem. <br /> <br /> Palun teavitage serveri administraatorit.Viga: keelepaketis {$a} sisalduv fail country.php on tühi või puudub.';
$string['dbsessionhandlerproblem'] = 'Andmebaasiseansi häälestamine nurjus. Pöörduge serveri administraatori poole.';
$string['dbsessionmysqlpacketsize'] = 'Tuvastati tõsine seansitõrge.<br /><br />Pöörduge õpikeskkonna administraatori poole. Probleemi põhjus on tõenäoliselt MySQL-i sätte max_allowed_packet väike väärtus.';
$string['dbupdatefailed'] = 'Andmebaasi värskendamine nurjus';
$string['ddldependencyerror'] = 'Ei saa muuta: {$a->targettype} „{$a->targetname}“. Leiti sõltuvus {$a->offendingtype} nimega „{$a->offendingname}“';
$string['ddlexecuteerror'] = 'DDL SQL-i käivitustõrge';
$string['ddlfieldalreadyexists'] = 'Väli „{$a}“ on juba olemas';
$string['ddlfieldnotexist'] = 'Välja „{$a->fieldname}“ pole tabelis „{$a->tablename}“';
$string['ddltablealreadyexists'] = 'Tabel „{$a}“ on juba olemas';
$string['ddltablenotexist'] = 'Tabelit „{$a}“ pole olemas';
$string['ddlunknownerror'] = 'Tundmatu DDL-teegi tõrge';
$string['ddlxmlfileerror'] = 'Ilmnesid XML-andmebaasifaili tõrked';
$string['ddsequenceerror'] = 'Vigane tabeli „{$a}“ definitsioon; olla saab ainult üks automaatne veerg ja see peab olema määratletud võtmena.';
$string['destinationcmnotexit'] = 'Sihtkursuse moodulit pole olemas';
$string['detectedbrokenplugin'] = 'Kahjuks on lisandmoodul „{$a}“ katkine või aegunud, mistõttu ei saa jätkata.';
$string['dmlexceptiononinstall'] = '<p>Ilmnes andmebaasitõrge [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Viga SQL-i päringu parsimisel';
$string['dmlreadexception'] = 'Andmebaasist lugemisel ilmnes tõrge';
$string['dmltransactionexception'] = 'Andmebaasitoimingu tõrge';
$string['dmlwriteexception'] = 'Andmebaasi kirjutamisel ilmnes tõrge';
$string['downgradedcore'] = 'TÕRGE! Kood, mida kasutate, on VANEM kui versioon, millega need andmebaasid tehti.';
$string['downloadedfilecheckfailed'] = 'Allalaaditud faili kontroll nurjus';
$string['duplicatefieldname'] = 'Tuvastati välja nime duplikaat „{$a}“';
$string['duplicatenosupport'] = '{$a->modname} tegevust ei saa dubleerida, kuna moodul {$a->modtype} ei toeta varundamist ja taastamist.';
$string['duplicateparaminsql'] = 'TÕRGE: päringus dubleeriv parameetri nimi';
$string['duplicaterolename'] = 'Sellise nimega roll on juba olemas.';
$string['duplicateroleshortname'] = 'Sellise nimega roll on juba olemas.';
$string['duplicateusername'] = 'Kasutajanime duplikaat – kirje jäetakse vahele';
$string['emailfail'] = 'Emaili saatmine ebaõnnestus';
$string['enddatebeforestartdate'] = 'Kursuse lõppkuupäev peab olema pärast alguskuupäeva.';
$string['error'] = 'Ilmnes tõrge';
$string['error_question_answers_missing_in_db'] = 'Andmebaasitabelis question_answers ei leitud vastust „{$a->answer}“. See ilmnes, kui varundusfailist taastati küsimust ID-ga {$a->filequestionid}, mis on vastendatud andmebaasis leiduva küsimusega, mille ID on {$a->dbquestionid}.';
$string['errorcleaningdirectory'] = 'Viga kataloogi "{$a}" puhastamisel';
$string['errorcopyingfiles'] = 'Viga faili kopeerimisel';
$string['errorcreatingdirectory'] = 'Viga kataloogi "{$a}" loomisel';
$string['errorcreatingfile'] = 'Viga faili "{$a}" loomisel';
$string['errorcreatingrole'] = 'Viga rolli loomisel';
$string['errorfetchingrssfeed'] = 'RSS-kanali toomisel ilmnes tõrge.';
$string['erroronline'] = 'Real {$a} tekkis viga';
$string['erroroutput'] = 'Väljundi tõrge, seega keelatakse automaatne ümbersuunamine.';
$string['errorparsingxml'] = 'XML-i sõelumisel ilmnes tõrge: {$a->errorstring} real {$a->errorline}, märk {$a->errorchar}';
$string['errorprocessingarchive'] = 'Tõrge arhiivifaili töötlemisel';
$string['errorreadingfile'] = 'Viga faili "{$a}" lugemisel';
$string['errorsavingrequest'] = 'Teie päringu salvestamisel ilmnes viga.';
$string['errorsettinguserpref'] = 'Kasutajaeelistuse seadistamisel ilmnes tõrge';
$string['errorunzippingfiles'] = 'Viga failide lahtipakkimisel';
$string['expiredkey'] = 'Aegunud võti';
$string['externalauthpassworderror'] = 'Mittetühi parool väliseks autentimiseks';
$string['externalfilenolocation'] = 'Välisel failil puudub asukohatee';
$string['failtoloadblocks'] = 'Üks või mitu plokki on andmebaasis registreeritud, kuid neid kõiki ei õnnestunud laadida!';
$string['fieldrequired'] = '{$a} on kohustuslik väli';
$string['fileexists'] = 'Fail on juba olemas';
$string['filemismatch'] = 'Põhituumata failinime vastavus. Fail "{$a->current}" peaks olema {$a->file}';
$string['filenotfound'] = 'Soovitud faili kahjuks ei leitud';
$string['filenotreadable'] = 'Fail pole loetav';
$string['filterdoesnothavelocalconfig'] = 'Filter {$a} ei luba kohalikku konfiguratsiooni.';
$string['filternotactive'] = 'Filter {$ a} pole praegu aktiivne';
$string['filternotenabled'] = 'Filter pole lubatud.';
$string['filternotinstalled'] = 'Filter {$a} pole praegu installitud';
$string['forumblockingtoomanyposts'] = 'Olete ületanud sellele foorumile määratud postituste arvu lävendi';
$string['functionalityremoved'] = 'Proovite juurde pääseda funktsioonidele mis on eemaldatud';
$string['generalexceptionmessage'] = 'Erand: {$a}';
$string['gradecantregrade'] = 'Hinde arvutamisel ilmnes tõrge: {$a}';
$string['gradepubdisable'] = 'Hinde avaldamine on keelatud';
$string['gradesneedregrading'] = 'Kursuse hinded peab ümber arvutama';
$string['groupalready'] = 'Kasutaja kuulub juba rühma {$a}';
$string['groupexistforcourse'] = 'Rühm {$a} on sellel kursusel juba olemas';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Sellel kursusel on juba rühm {$a->name}, mille idnumber on {$a->idnumber}';
$string['grouphasidnumber'] = 'Rühmal „{$a}“ on idnumber ja võimalik, et selle on automaatselt loonud väline süsteem. Teil pole selle rühma eemaldamise õigust.';
$string['groupinghasidnumber'] = 'Rühmakogumil „{$a}“ on idnumber ja võimalik, et selle on automaatselt loonud väline süsteem. Teil pole selle rühmakogumi eemaldamise õigust.';
$string['groupingnotaddederror'] = 'Rühmakogumit {$a} ei lisatud';
$string['groupnotaddederror'] = 'Rühma {$a} ei lisatud';
$string['groupnotaddedtogroupingerror'] = 'Rühma {$a->groupname} ei lisatud rühmakogumisse {$a->groupingname}';
$string['groupunknown'] = 'Rühm {$a} pole seotud ühegi kursusega';
$string['groupusernotmember'] = 'Kasutaja pole selle rühma liige';
$string['guestcantaccessprofiles'] = 'Külalised ei saa kasutajaprofiile vaadata. Jätkamiseks logige sisse täieõigusliku kasutaja kontoga.';
$string['guestnocomment'] = 'Külalistel pole lubatud kommentaare postitada!';
$string['guestnoeditprofile'] = 'Külaliskasutaja ei saa oma profiili muuta';
$string['guestnoeditprofileother'] = 'Külaliskasutaja profiili ei saa muuta';
$string['guestnorate'] = 'Külalistel pole lubatud sisestusi hinnata';
$string['guestsarenotallowed'] = 'Külaliskasutajal pole lubatud seda teha';
$string['hackdetected'] = 'Hack rünnak tuvastatud!';
$string['hashpoolproblem'] = 'Laofaili sisu {$a} ei sobi.';
$string['headersent'] = 'Juba saadetud päised';
$string['idnumbertaken'] = 'See ID-number on juba kasutusel';
$string['idnumbertoolong'] = 'ID-number on liiga pikk';
$string['importformatnotimplement'] = 'Vabandust, selle formaadi importimist veel ei toetata!';
$string['incorrectext'] = 'Failil on vale laiend';
$string['inplaceeditableerror'] = 'Värskendamisprotsessori kutsumisel ilmnes tõrge';
$string['installproblem'] = 'Tavaliselt pole võimalik installi ajal käivitunud tõrkeid kõrvaldada; kui soovite uuesti installida, on võimalik, et peate looma uue andmebaasi või kasutama mõnd muud andmebaasi eesliidet.';
$string['internalauthpassworderror'] = 'Parool puudub või sisemise autentimise paroolipõhimõtted ei sobi';
$string['invalidaccess'] = 'Juurdepääs sellele lehele polnud õige';
$string['invalidaccessparameter'] = 'Juurdepääsuparameeter ei sobi';
$string['invalidaction'] = 'Toiminguparameeter ei sobi';
$string['invalidactivityid'] = 'Vale tegevuse ID';
$string['invalidadminsettingname'] = 'Administraatorisäte ({$a}) ei sobi';
$string['invalidargorconf'] = 'Sobivaid argumente ei esitatud või on serveri konfiguratsioon vale';
$string['invalidarguments'] = 'Sobivaid argumente ei esitatud';
$string['invalidblockinstance'] = 'Vale blokeerimiseksemplar domeenile {$a}';
$string['invalidbulkenrolop'] = 'Taotletud hulgiregistreerumistoiming ei sobi.';
$string['invalidcategory'] = 'Vale kategooria.';
$string['invalidcategoryid'] = 'Kategooria ID on vale.';
$string['invalidcomment'] = 'Kommentaar on vale';
$string['invalidcommentarea'] = 'Kommentaaride ala ei sobi';
$string['invalidcommentid'] = 'Kommentaari ID ei sobi';
$string['invalidcommentitemid'] = 'Kommentaari ItemId ei sobi';
$string['invalidcommentparam'] = 'Kommentaari parameetrid ei sobi';
$string['invalidcomponent'] = 'Komponendi nimi ei sobi';
$string['invalidconfirmdata'] = 'Kinnitusandmed ei sobi';
$string['invalidcontentid'] = 'Vale sisu ID';
$string['invalidcontext'] = 'Kontekst ei sobi';
$string['invalidcountrycode'] = 'Vale riigi kood {$a}';
$string['invalidcourse'] = 'Kursus ei sobi';
$string['invalidcourseformat'] = 'Kursuse formaat on sobimatu';
$string['invalidcourseid'] = 'Proovite kasutada sobimatut kursuse ID-d';
$string['invalidcourselevel'] = 'Konteksti tase on vale';
$string['invalidcoursemodule'] = 'Kursusemooduli ID ei sobi';
$string['invalidcoursenameshort'] = 'Kursuse lühinimi ei sobi';
$string['invaliddata'] = 'Postitatud andmed ei sobi';
$string['invaliddatarootpermissions'] = 'Kataloogi loomise katsel tuvastati sobimatud õigused. Lisateabe saamiseks lülitage sisse silumine.';
$string['invaliddevicetype'] = 'Seadme tüüp ei sobi';
$string['invalidelementid'] = 'Elemendi ID on vale.';
$string['invalidentry'] = 'See pole sobiv sissekanne';
$string['invalidevent'] = 'Vigane sündmus';
$string['invalidfieldname'] = 'Väljanimi {$a} ei sobi';
$string['invalidfiletype'] = 'Failitüüp {$a} ei sobi';
$string['invalidformatpara'] = 'Vale formaat parameetri valimiseks';
$string['invalidformdata'] = 'Vormiandmed on valed';
$string['invalidfunction'] = 'Funktsioon on vale';
$string['invalidgradeitemid'] = 'Vale hindeelemendi ID';
$string['invalidgroupid'] = 'Määratud rühma ID on vale';
$string['invalidipformat'] = 'IP-aadressi vorming ei sobi';
$string['invaliditemid'] = 'Elemendi ID on vale';
$string['invalidkey'] = 'Võti on vale';
$string['invalidlanguagecode'] = 'Vale keelekood: {$a}';
$string['invalidlegacy'] = 'Vale pärandrollimääratlus tüübile: {$a}';
$string['invalidmd5'] = 'Kontrolli muutuja oli vale – proovige uuesti';
$string['invalidmode'] = 'Režiim ({$a}) ei sobi';
$string['invalidmodule'] = 'Vale moodul';
$string['invalidmoduleid'] = 'Vale mooduli ID: {$a}';
$string['invalidmodulename'] = 'Vale mooduli nimi: {$a}';
$string['invalidnum'] = 'Arvuline väärtus ei sobi';
$string['invalidnumkey'] = 'Massiiv $conditions paistab sisaldavat arvulisi võtmeid, parandage programmikoodi.';
$string['invalidoutcome'] = 'Vale tulemuse ID';
$string['invalidpagesize'] = 'Lehekülje formaat ei sobi';
$string['invalidpasswordpolicy'] = 'Paroolipõhimõtted ei sobi';
$string['invalidpaymentmethod'] = 'Makseviis ei sobi: {$a}';
$string['invalidqueryparam'] = 'TÕRGE: vale päringuparameetrite arv. Eeldati {$a->expected}, saadi {$a->actual}.';
$string['invalidratingarea'] = 'Hinnanguala ei sobi';
$string['invalidrecord'] = 'Ei leia andmebaasitabelist {$a} andmekirjet.';
$string['invalidrecordunknown'] = 'Ei leia andmebaasist andmekirjet.';
$string['invalidrequest'] = 'Päring ei sobi';
$string['invalidrole'] = 'Roll ei sobi';
$string['invalidroleid'] = 'Rolli ID ei sobi';
$string['invalidscaleid'] = 'Vale skaala ID';
$string['invalidsection'] = 'Kursusemooduli kirjes on sobimatu jaotis';
$string['invalidsesskey'] = 'Teie seanss on tõenäoliselt aegunud. Palun logige uuesti sisse.';
$string['invalidshortname'] = 'See kursuse lühinimi ei sobi';
$string['invalidsourcefield'] = 'Mustandifaili allika väli ei sobi';
$string['invalidstatedetected'] = 'Midagi läks valesti: {$a}. Üldjuhul ei tohiks seda kunagi juhtuda.';
$string['invalidurl'] = 'URL ei sobi';
$string['invaliduser'] = 'Kasutaja ei sobi';
$string['invaliduserdata'] = 'Sobimatud kasutajaandmed: {$a}';
$string['invaliduserfield'] = 'Sobimatu kasutajaväli: {$a}';
$string['invaliduserid'] = 'Kasutaja ID ei sobi';
$string['invalidusername'] = 'Antud kasutajanimi sisaldab sobimatuid märke';
$string['invalidusernameblank'] = 'Kasutajanimi ei saa olla tühi';
$string['invalidxmlfile'] = '"{$a}" ei ole korrektne XML-fail';
$string['iplookupfailed'] = 'Ei leia geograafilist teavet IP-aadressi {$a} kohta';
$string['iplookupprivate'] = 'Ei saa kuvada otsingut privaatsele IP-aadressile';
$string['ipmismatch'] = 'Kliendi IP-aadressi vastuolu';
$string['listcantmovedown'] = 'Üksuse allapoole nihutamine nurjus, see on selle partneri viimane';
$string['listcantmoveleft'] = 'Üksuse vasakule nihutamine nurjus, kuna sellel pole ülatasemeüksust';
$string['listcantmoveright'] = 'Üksuse paremale nihutamine nurjus, sest seal ei olnud partnerit, mille alamtasemeüksuseks see üksus teha. Nihutage see teise partneri alla ja seejärel saate selle paremale nihutada.';
$string['listcantmoveup'] = 'Üksuse üles nihutamine nurjus, kuna see on esimene oma partnerite seas';
$string['listnochildren'] = 'Alamüksuse kirjet ei leitud';
$string['listnoitem'] = 'Üksust ei leitud';
$string['listupdatefail'] = 'DB toiming nurjus loendihierarhia muutmisel';
$string['logfilenotavailable'] = 'Logisid pole saadaval';
$string['loginasnoenrol'] = 'Te ei saa kursusele registreeruda ega registreeringut tühistada, kui olete kursuse „Logi sisse kui“ seansil';
$string['loginasonecourse'] = 'Te ei saa sellele kursusele siseneda.<br /> Enne mis tahes muule kursusele sisenemist peate lõpetama seansi „Sisene kui“.';
$string['maxareabytes'] = 'Faili maht ületab selle ala vaba ruumi.';
$string['maxbytesfile'] = 'Faili {$a->file} maht on liiga suur. Üleslaaditavate failide maksimummaht on {$a->size}.';
$string['messageundeliveredbynotificationsettings'] = 'Sõnumit ei õnnestunud saata, kuna saidi administraator on kasutajate vahelised isiklikud sõnumid (teavitusseadetes) keelanud.';
$string['messagingdisable'] = 'Sõnumivahetus on selles õpikeskkonnas keelatud';
$string['mimetexisnotexist'] = 'Teie süsteem pole mimeTeX-i käitamiseks konfigureeritud. Te peate PHP_OS platvormile vajalikud täitmisfailid saidilt <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a> alla laadima või soetama saidilt <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, C lähtekoodi, selle kompileerima ja täitmisfaili oma kataloogi moodle/filter/tex/ paigutama.';
$string['mimetexnotexecutable'] = 'Kohandatud mimeTeX pole käivitatav.';
$string['missing_moodle_backup_xml_file'] = 'Varukoopiast puudub XML-fail: {$a}';
$string['missingfield'] = 'Väli „{$a}“ on puudu';
$string['missingkeyinsql'] = 'TÕRGE: päringust puudub parameeter „{$a}“';
$string['missingparam'] = 'Nõutav parameeter ({$a}) oli puudu';
$string['missingparameter'] = 'Parameeter puudub';
$string['missingrequiredfield'] = 'Mõni nõutav väli on puudu';
$string['missinguseranditemid'] = 'UserId ja ItemId puuduvad';
$string['missingvarname'] = 'Nõutav muutuja nimi puudub!';
$string['mixedtypesqlparam'] = 'TÕRGE: SQL-päringu parameetrid on segatüüpi.';
$string['mnetdisable'] = 'MNET on keelatud';
$string['mnetlocal'] = 'MNET-i kaugkasutajad ei saa kohalikult sisse logida';
$string['moduledisable'] = 'Moodul ({$a}) on selle kursuse puhul keelatud';
$string['moduledoesnotexist'] = 'Seda moodulit pole olemas';
$string['moduleinstancedoesnotexist'] = 'Selle mooduli instantsi ei eksisteeri';
$string['modulemissingcode'] = 'Moodulist {$a} puudub selle funktsiooni teostamiseks vajalik kood';
$string['movecatcontentstoroot'] = 'Kategooria sisu ei tohi teisaldada juurtasemele. Peate sisu teisaldama olemasolevasse kategooriasse!';
$string['movecatcontentstoselected'] = 'Osa kategooria sisust ei saa valitud kategooriasse teisaldada.';
$string['movecategorynotpossible'] = 'Kategooriat „{$a}“ ei saa valitud kategooriasse teisaldada.';
$string['movecategoryownparent'] = 'Kategooriat {$a} ei saa määrata enda ülataseme üksuseks.';
$string['movecategoryparentconflict'] = 'Kategooriat {$a} ei saa määrata selle alamkategooria alamkategooriaks.';
$string['mssqlrcsmodemissing'] = 'Andmebaas ei kasuta eeldatud režiimi READ_COMMITTED_SNAPSHOT. See võib põhjustada valede tulemuste moodustamist, seda eriti kõrge samaaegsuse korral. Lubage see, et tagada süsteemi nõuetekohane toimimine. Lisateavet leiate dokumentatsioonist <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Installing MSSQL for PHP</a> (MSSQL for PHP installimine).';
$string['multiplerecordsfound'] = 'Leiti mitu kirjet, eeldati ainult ühte kirjet.';
$string['multiplerestorenotallow'] = 'Mitme taastamise käivitamine pole lubatud!';
$string['mustbeloggedin'] = 'Selle tegemiseks peate sisse logima';
$string['mustbeteacher'] = 'Selle lehe vaatamiseks pead olema õpetaja';
$string['myisamproblem'] = 'Andmebaasitabelid kasutavad MyISAM-i andmebaasimootorit, soovitatav on kasutada ACID-iga ühilduvat mootorit, millel on täielik tehingutugi, näiteks InnoDB-d.';
$string['needcopy'] = 'Teil on vaja enne midagi kopeerida.';
$string['needcoursecategroyid'] = 'Määrata tuleb kas kursuse ID või kategooria';
$string['needphpext'] = 'Teil on vaja lisada PHP installile {$a} tugi';
$string['noadmins'] = 'Administraatoreid pole.';
$string['noblocks'] = 'Plokke ei leitud.';
$string['nocapabilitytousethisservice'] = 'Kasutajal pole selle teenuse kasutamiseks nõutavat tegevusluba';
$string['nocategorydelete'] = 'Kategooriat \'{$a}\' ei saa kustutada!';
$string['nocontext'] = 'Kahjuks pole see kursus sobiv kontekst';
$string['nodata'] = 'Andmeid pole';
$string['noexistingcategory'] = 'Pole eksisteerivat kategooriat';
$string['nofile'] = 'Faili pole määratud';
$string['nofiltersenabled'] = 'Ükski filter pole sisse lubatud.';
$string['nofolder'] = 'Päritud kataloogi ei eksisteeri';
$string['noformdesc'] = 'Selle tegevuse jaoks ei leitud vormi formslib kirjeldusfaili.';
$string['noguest'] = 'Külalised pole siia lubatud.';
$string['noinstances'] = 'Sellest kursusest puuduvad {$a} eksemplarid.';
$string['nologinas'] = 'Teil pole lubatud selle kasutajana sisse logida';
$string['nonmeaningfulcontent'] = 'Tähendut mitteomav sisu';
$string['noparticipants'] = 'Sellele kursusele ei leitud osalejaid';
$string['noparticipatorycms'] = 'Vabandust, kuid sul pole ühtegi osaluskursuse moodulit, millest saaksid aru anda';
$string['nopermissions'] = 'Kahjuks pole teil praegu selleks ({$a}) õigusi';
$string['nopermissiontocomment'] = 'Te ei saa kommentaare lisada';
$string['nopermissiontodelentry'] = 'Te ei saa teiste kasutajate sissekandeid kustutada.';
$string['nopermissiontoeditcomment'] = 'Sa ei saa muuta teiste inimeste kommentaare!';
$string['nopermissiontohide'] = 'Peitmisõigust pole.';
$string['nopermissiontoimportact'] = 'Teil pole sellesse kursusesse tegevuste importimiseks vajalikke õigusi';
$string['nopermissiontolock'] = 'Pole lukustamisõigusi.';
$string['nopermissiontomanagegroup'] = 'Sul ei ole vajalikke õigusi rühmade haldamiseks';
$string['nopermissiontorate'] = 'Kirjete hindamine ei ole lubatud!';
$string['nopermissiontoshow'] = 'Pole õigusi selle kuvamiseks.';
$string['nopermissiontounlock'] = 'Pole lukust avamise õigusi.';
$string['nopermissiontoupdatecalendar'] = 'Kahjuks pole teil  kalendrisündmuse värskendamise õigusi';
$string['nopermissiontoviewgrades'] = 'Hindeid ei saa kuvada.';
$string['nopermissiontoviewletergrade'] = 'Puudub õigus täheliste hinnete kuvamiseks';
$string['nopermissiontoviewpage'] = 'Sul ei ole õigut seda lehte vaadata';
$string['nosite'] = 'Ülemise taseme kursust ei leitud.';
$string['nositeid'] = 'Saidi ID puudub';
$string['nostartdatenoenddate'] = 'Kursuse lõppkuupäeva saab määrata ainult juhul, kui on määratud alguskuupäev.';
$string['nostatstodisplay'] = 'Kahjuks pole kuvamiseks andmeid saadaval';
$string['notallowedtoupdateprefremotely'] = 'Teil pole lubatud selle kasutaja eelistusi kaugühenduse kaudu värskendada';
$string['notavailable'] = 'See pole praegu saadaval';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Te pole selle kursuserühma liige';
$string['notownerofkey'] = 'Te pole selle võtme omanik';
$string['nousers'] = 'Sellist kasutajat pole';
$string['oauth1accesstoken'] = 'OAuth 1.0 tõrge: me ei saanud juurdepääsuluba.';
$string['oauth1requesttoken'] = 'OAuth 1.0 tõrge: me ei saanud päringu märki - teenusepakkuja võib ajutiselt olla seiskunud.';
$string['onlyadmins'] = 'Ainult administraatorid saavad seda teha';
$string['onlyeditingteachers'] = 'Ainult redigeerivad õpetajad saavad seda teha';
$string['onlyeditown'] = 'Sa saad muuta ainult iseenda andmeid';
$string['orderidnotfound'] = 'Tellimuse ID-d {$a} ei leitud';
$string['pagenotexist'] = 'Ilmnes ebatavaline tõrge (prooviti jõuda leheni, mida pole olemas)';
$string['pagenotexisttitle'] = '404 Viga: faili ei leitud';
$string['pathdoesnotstartslash'] = 'Sobivaid argumente ei esitatud, rada ei alga kaldkriipsuga.';
$string['pleasereport'] = 'Kui aega on, siis andke meile teada, mis toimingu ajal tõrge tekkis:';
$string['pluginrequirementsnotmet'] = 'Lisandmoodulit „{$a->pluginname}“ ({$a->pluginversion}) ei saanud installida. See vajab uuemat Moodle’i versiooni (praegu kasutate versiooni {$a->currentmoodle}, vajate versiooni {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Plugin "{$a-> pluginname}" {$a-> pluginversion} ei toeta seda Moodle\'i versiooni {$ a-> moodleversion}. Toetatud versioonide otsimiseks tuvuge pluina infoga.';
$string['prefixcannotbeempty'] = '<p>Tõrge: andmebaasitabeli eesliide ei saa olla tühi ({$a})</p>
<p>Õpikeskkonna administraator peab selle probleemi lahendama.</p>';
$string['privatefilesupload'] = 'Kasutaja privaatsete failide alasse ei saa enam faile üles laadida. Laadige failid üles mustandialasse ja seejärel teisaldage need käsuga core_user::add_user_private_files.';
$string['processingstops'] = 'Töötlemine lõpeb siin. Allesjäänud kirjeid ignoreeritakse.';
$string['protected_cc_not_supported'] = 'Kaitstud kassette ei toetata.';
$string['querystringcannotbeempty'] = 'Päringustring ei saa olla tühi.';
$string['redirecterrordetected'] = 'Tuvastati mittetoetatud ümbersuunamine, skripti käivitamine katkestati';
$string['refoundto'] = 'Võib tagastada {$a}-le';
$string['refoundtoorigi'] = 'Tagastatud algses koguses: {$a}';
$string['registrationdisabled'] = 'Sellel saidil on registreerimine keelatud';
$string['remotedownloaderror'] = '<p>Komponendi teie serverisse allalaadimine nurjus. Kontrollige puhvri sätteid; PHP laiend cURL on tungivalt soovitatav.</p>
<p>Peate faili <a href="{$a->url}">{$a->url}</a> käsitsi alla laadima, kopeerima selle oma serveris asukohta „{$a->dest}“ ja seal lahti pakkima.</p>';
$string['remotedownloadnotallowed'] = 'Komponentide alla tõmbamine ei ole Sinu serverisse lubatud (sest allow_url_fopen keelatud).<br /><br />Sa pead tõmbama alla faili <a href="{$a->url}">{$a->url}</a> käsitsti, kopeerima "{$a->dest}" oma serveris ja sinna lahti pakkima.';
$string['reportnotavailable'] = 'See aruandetüüp on saadaval ainult õpikeskkonna kursusele';
$string['requirecorrectaccess'] = 'URL või port ei sobi.';
$string['requireloginerror'] = 'Kursus või tegevus pole juurdepääsetav.';
$string['restore_path_element_missingmethod'] = 'Taastamisviis {$a} on puudu. Arendaja peab olema selle määratlenud.';
$string['restore_path_element_noobject'] = 'Taasta objekt {$a} pole objekt.';
$string['restorechecksumfailed'] = 'Teie seansi salvestatud taastamisteabe osas ilmnes probleem. Palun kontrolli oma PHP mälu / DB paketi suuruse piiranguid. Taastamine peatati.';
$string['restrictedcontextexception'] = 'Kahjuks rikub välise funktsiooni käivitamine konteksti piirangut.';
$string['restricteduser'] = 'Kahjuks on teie praegune konto „{$a}“ piirangutega ja teil pole õigust seda teha.';
$string['reverseproxyabused'] = 'Pöördpuhverserver on lubatud, kahjuks ei saa serveri poole otse pöörduda.<br />Pöörduge serveri administraatori poole.';
$string['rpcerror'] = 'Vabandust! Teie MNET-i ühendus nurjus. Siin on veateade administraatorile edastamiseks: {$a}';
$string['scheduledbackupsdisabled'] = 'Serveri administraator on plaanilised varundused keelanud';
$string['secretalreadyused'] = 'Parooli muutmise kinnituslinki oli juba kasutatud, parooli ei muudetud';
$string['sectionnotexist'] = 'Seda jaotist pole olemas';
$string['sendmessage'] = 'Saada sõnum';
$string['sendmessagesent'] = 'Täname tagasiside eest:<br>{$a}';
$string['serverconnection'] = 'Serveriga ühenduse loomisel ilmnes tõrge.';
$string['servicedonotexist'] = 'Teenust ei eksisteeri';
$string['sessioncookiesdisable'] = 'Vale parameetri require_key_login() kasutus – seansi küpsised peavad olema keelatud.';
$string['sessiondiskfull'] = 'Seansisektsioon on täis. Praegu ei saa sisse logida. Pöörduge serveri administraatori poole.';
$string['sessionerroruser'] = 'Teie seanss on aegunud. Palun logige uuesti sisse.';
$string['sessionerroruser2'] = 'Tuvastati serveri viga, mis mõjutab sinu sisselogimisseanssi. Logi uuesti sisse või taaskäivita oma brauser.';
$string['sessionexpired'] = 'Sessioon on aegunud';
$string['sessionhandlerproblem'] = 'Seansiohjur on valesti konfigureeritud';
$string['sessionipnomatch'] = 'Vabandame, aga sinu IP aadress on peale viimast sisenemist muutunud. Selline turvalisuse vahend takistab kräkkereid varastamast sinu identiteeti. Tavalised kasutajad ei tohiks seda teadet näha. Palun pöördu abi saamiseks õpikeskkonna administraatori poole.';
$string['sessionipnomatch2'] = '<p>Kahjuks on teie IP-aadress pärast esimest sisselogimist muutunud. See turbefunktsioon takistab kräkkeritel teie identiteeti varastada, kui olete siia õpikeskkonda sisse logitud. Teile võidakse kuvada see tõrketeade, kui kasutate raadiovõrku või võrkudevahelist rändlusteenust. Lisateavet küsige õpikeskkonna administraatorilt.</p>
<p>Kui soovite jätkata, vajutage lehe värskendamiseks klahvi F5.</p>';
$string['sessionwaiterr'] = 'Seansi luku ootamisel ilmnes ajalõpp.<br />Oodake, kuni teie praegused taotlused viiakse lõpule, ja proovige hiljem uuesti.';
$string['shortnametaken'] = 'See lühinimi on juba mõne muu kursuse puhul kasutusel ({$a})';
$string['sitepolicynotagreed'] = 'Saidipoliitika pole kokku lepitud. <a href="{$a}">Saidipoliitika avamiseks klõpsake siin.</a>';
$string['socksnotsupported'] = 'SOCKS5 puhverserverit ei toetata PHP4-s';
$string['spellcheckernotconf'] = 'Õigekirjakontroll on konfigureerimata';
$string['sslonlyaccess'] = 'Kahjuks on turbekaalutlustel lubatud ainult HTTPS-ühendused.';
$string['statscatchupmode'] = 'Statistika on praegu järelvaatamisrežiimis. Seni on {$a->daysdone} päev(a) töödeldud ja {$a->dayspending} veel ootel. Vaadake varsti uuesti.';
$string['statsdisable'] = 'Statistika pole lubatud.';
$string['statsnodata'] = 'Selle kursuse ja ajaperioodi kombinatsiooni kohta pole andmeid saadaval.';
$string['storedfilecannotcreatefile'] = 'Kohaliku faili varamufaili ei saa luua. Kontrollige õigusi andmete juurkataloogis ja vaba kettaruumi.';
$string['storedfilecannotcreatefiledirs'] = 'Kohalike failide laokatalooge ei saa luua, kontrollige õigusi andmete juurkataloogis (dataroot).';
$string['storedfilecannotread'] = 'Faili ei saa lugeda. Faili pole olemas või on tekkinud õigustega seotud probleem.';
$string['storedfilecannotreadfile'] = 'Faili \'{$a}\' ei saa lugeda. Faili ei eksisteeri või on probleem õigustega.';
$string['storedfilenotcreated'] = 'Faili {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename} ei saa luua';
$string['storedfileproblem'] = 'Tundmatu erand seoses kohalike failidega ({$a})';
$string['tagdisabled'] = 'Sildid on keelatud.';
$string['tagnotfound'] = 'Andmebaasist ei leitud määratud silti.';
$string['targetdatabasenotempty'] = 'Sihtandmebaas ei ole tühi. Ülekanne katkestati turvalisusega seotud põhjustel.';
$string['textconditionsnotallowed'] = 'Tekstiveergude tingimuste võrdlemine pole lubatud. Kasutage oma päringus funktsiooni sql_compare_text().';
$string['themenotinstall'] = 'See teema pole installitud!';
$string['tokengenerationfailed'] = 'Uut tõendit ei saa genereerida.';
$string['transactionvoid'] = 'Tehingut ei saa tühistada, sest see on juba tühistatud';
$string['unenrolerror'] = 'Selle isiku registreerimise tühistamisel tekkis viga!';
$string['unicodeupgradeerror'] = 'Vabandust, kuid sinu andmebaas ei ole juba Unicode vormingus, ja praegune Moodle\'i versioon ei ole võimeline sinu andmebaasi Unicode vormingusse migreerima. Palun uuenda kõigepealt Moodle\'i versiooni 1.7.x ja teosta administreerimise lehel Unicode migreerimine. Peale seda peaksid saama migreerida Moodle\'i versiooni {$a}.';
$string['unknowaction'] = 'Tundmatu toiming.';
$string['unknowcategory'] = 'Tundmatu kategooria.';
$string['unknowcontext'] = 'See on tundmatu kontekst ({$a}) kontekstis get_child_contexts.';
$string['unknowformat'] = 'Tundmatu vorming ({$a})';
$string['unknownbackupexporterror'] = 'Teabe importimisel ilmnes tundmatu tõrge';
$string['unknownblockregion'] = 'Ploki regioon „{$a}“ pole sellel lehel tuntud.';
$string['unknowncontext'] = 'See on tundmatu kontekst.';
$string['unknowncourse'] = 'Tundmatu kursus „{$a}“';
$string['unknowncourseidnumber'] = 'Tundmatu kursuse ID „{$a}“';
$string['unknowncourserequest'] = 'Tundmatu kursusepäring';
$string['unknowncoursesection'] = 'Kursusel {$a} on tundmatu jaotis';
$string['unknownevent'] = 'Tundmatu sündmus';
$string['unknownfiletype'] = 'Viga -  tundmatu filtritüüp';
$string['unknowngroup'] = 'Tundmatu rühm {$a}';
$string['unknownjsinrequirejs'] = 'JS-i teeki ei leia: {$a}';
$string['unknownmodulename'] = 'Tundmatu mooduli nimi vormile';
$string['unknownrole'] = 'Tundmatu roll „{$a}“';
$string['unknownsortcolumn'] = 'Tundmatu sortimisveerg {$a}';
$string['unknownuseraction'] = 'Kahjuks ei saa ma sellest kasutajatoimingust aru';
$string['unknownuserselector'] = 'Tundmatu kasutajaselektor';
$string['unknoworder'] = 'Tundmatu järjestus';
$string['unknowparamtype'] = 'Tundmatu parameetri tüüp: {$a}';
$string['unknowquestiontype'] = 'Mitte toetatav küsimuse tüüp {$a}';
$string['unknowuploadaction'] = 'Tõrge. Tundmatu üleslaadimistoiming ({$a})';
$string['unspecifycourseid'] = 'Peate määrama kursuse ID, lühinime või ID-numbri';
$string['unsupportedevent'] = 'Mittetoetatud sündmuse tüüp';
$string['unsupportedstate'] = 'Toetamata lõpuleviimisolek';
$string['unsupportedwebserver'] = 'Kahjuks ei toetata veebiserveri tarkvara ({$a}).';
$string['upgraderequires19'] = 'Tõrge: Serverisse installiti uus Moodle’i versioon, kahjuks üleminekut vanalt versioonilt ei toetata.<br />Täiendage esmalt uusimaks versiooni 1.9.x väljaandeks. Samuti saate naasta eelmisele versioonile, installides uuesti algsed failid.';
$string['upgraderunning'] = 'Õpikeskkonda uuendatakse, proovige hiljem uuesti.';
$string['urlnotdefinerss'] = 'URL pole RSS-voo jaoks määratletud';
$string['useradmineditadmin'] = 'Ainult administraatoritel on lubatud muuta teiste administraatorite kontosid';
$string['useradminodelete'] = 'Administraatorikontot ei saa kustutada';
$string['userautherror'] = 'Tundmatu autentimislisandmoodul';
$string['userauthunsupported'] = 'Autentimislisandmoodul pole siin toetatud';
$string['useremailduplicate'] = 'Duplikaataadress';
$string['userisfilteredout'] = 'See kasutaja ei vasta filtritele ja tabelieelistustele!';
$string['usermustbemnet'] = 'Kasutajad MNET-i juurdepääsukontrolli loendis peavad olema MNET-i kaugkasutajad';
$string['usernamelowercase'] = 'Kasutajanimi peab olema väikete tähtedega.';
$string['usernotaddederror'] = 'Kasutajat ei lisatud – tõrge';
$string['usernotaddedregistered'] = 'Kasutajat ei lisatud – selline kasutaja on juba registreeritud';
$string['usernotavailable'] = 'Selle kasutaja üksikasjad ei ole teile saadaval';
$string['usernotdeletedadmin'] = 'Kasutajat ei kustutatud – administraatorikontosid ei saa kustutada';
$string['usernotdeleteddeleted'] = 'See kasutaja on juba kustutatud.';
$string['usernotdeletederror'] = 'Kasutajat ei kustutatud – tõrge';
$string['usernotdeletedmissing'] = 'Kasutajat ei kustutatud – kasutajanime ei leitud';
$string['usernotdeletedoff'] = 'Kasutajat ei kustutatud – kustutamine polnud lubatud';
$string['usernotfullysetup'] = 'Kasutaja häälestamine pole lõpule viidud';
$string['usernotincourse'] = 'Seda kasutajat pole sellel kursusel.';
$string['usernotrenamedadmin'] = 'Administraatorikontosid ei saa ümber nimetada';
$string['usernotrenamedexists'] = 'Kasutajat ei nimetatud ümber – uus kasutajanimi on juba kasutusel';
$string['usernotrenamedmissing'] = 'Kasutajat ei nimetatud ümber – vana kasutajanime ei leitud';
$string['usernotrenamedoff'] = 'Kasutajat ei nimetatud ümber – ümbernimetamine pole lubatud';
$string['usernotupdatedadmin'] = 'Administraatorikontosid ei saa värskendada';
$string['usernotupdatederror'] = 'Kasutajat ei värskendatud – tõrge';
$string['usernotupdatednotexists'] = 'Kasutajat ei värskendatud – pole olemas';
$string['userquotalimit'] = 'Teie kasutatav ruum sai otsa.';
$string['userselectortoomany'] = 'user_selector sai rohkem kui ühe valitud kasutaja, kuigi mitmikvalik oli väär.';
$string['verifyagedigitalconsentnotpossible'] = 'Vabandust, Vanuse alampiiri digivahendite kasutamiseks ei saa kontrollida.';
$string['wrongcall'] = 'See skript on kutsutud valesti';
$string['wrongcontextid'] = 'Konteksti ID oli vale (ei suuda seda leida)';
$string['wrongdestpath'] = 'Vale sihtkohatee';
$string['wrongroleid'] = 'Vigane rolli ID';
$string['wrongsourcebase'] = 'Vale allika URL-i baas';
$string['wrongusernamepassword'] = 'Vale kasutaja/parool';
$string['wrongzipfilename'] = 'Vale ZIP-faili nimi';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Ei saanud kursust luua - Puudub õigus';
$string['wwwrootmismatch'] = 'Tuvastati vale pöördus, kahjuks saab selle serveri poole pöörduda ainult aadressi „{$a}“ kaudu.<br />Teavitage serveri administraatorit.';
$string['wwwrootslash'] = 'Tuvastati vale $CFG->wwwroot failis config.php, see ei tohi sisaldada lõpukaldkriipsu.<br />Teavitage serveri administraatorit.';
$string['xmldberror'] = 'XMLDB tõrge.';
$string['youcannotdeletecategory'] = 'Kategooriat „{$a}“ ei saa kustutada, sest selle sisu ei saa ei kustutada ega teisaldada.';
