
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `nextcloud3204`
--

-- --------------------------------------------------------

--
-- Table structure for table `oc_accounts`
--

CREATE TABLE `oc_accounts` (
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `data` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_accounts_data`
--

CREATE TABLE `oc_accounts_data` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `value` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `accounts_data_uid` (`uid`),
  KEY `accounts_data_name` (`name`),
  KEY `accounts_data_value` (`value`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_activity`
--

CREATE TABLE `oc_activity` (
  `activity_id` bigint NOT NULL AUTO_INCREMENT,
  `timestamp` int NOT NULL DEFAULT '0',
  `priority` int NOT NULL DEFAULT '0',
  `type` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `user` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `affecteduser` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `app` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `subject` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `subjectparams` longtext COLLATE [[utf8]]_bin NOT NULL,
  `message` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `messageparams` longtext COLLATE [[utf8]]_bin,
  `file` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `link` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `object_type` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `object_id` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`activity_id`),
  KEY `activity_user_time` (`affecteduser`,`timestamp`),
  KEY `activity_filter_by` (`affecteduser`,`user`,`timestamp`),
  KEY `activity_filter` (`affecteduser`,`type`,`app`,`timestamp`),
  KEY `activity_object` (`object_type`,`object_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_activity_mq`
--

CREATE TABLE `oc_activity_mq` (
  `mail_id` bigint NOT NULL AUTO_INCREMENT,
  `amq_timestamp` int NOT NULL DEFAULT '0',
  `amq_latest_send` int NOT NULL DEFAULT '0',
  `amq_type` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `amq_affecteduser` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `amq_appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `amq_subject` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `amq_subjectparams` longtext COLLATE [[utf8]]_bin,
  `object_type` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `object_id` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`mail_id`),
  KEY `amp_user` (`amq_affecteduser`),
  KEY `amp_latest_send_time` (`amq_latest_send`),
  KEY `amp_timestamp_time` (`amq_timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_addressbookchanges`
--

CREATE TABLE `oc_addressbookchanges` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `synctoken` int unsigned NOT NULL DEFAULT '1',
  `addressbookid` bigint NOT NULL,
  `operation` smallint NOT NULL,
  `created_at` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `addressbookid_synctoken` (`addressbookid`,`synctoken`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_addressbooks`
--

CREATE TABLE `oc_addressbooks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `description` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `synctoken` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `addressbook_index` (`principaluri`,`uri`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin AUTO_INCREMENT=1 ;
-- --------------------------------------------------------

--
-- Table structure for table `oc_appconfig`
--

CREATE TABLE `oc_appconfig` (
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `configkey` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `configvalue` longtext COLLATE [[utf8]]_bin,
  `type` int unsigned NOT NULL DEFAULT '2',
  `lazy` smallint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`appid`,`configkey`),
  KEY `ac_lazy_i` (`lazy`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_appconfig`
--

INSERT INTO `oc_appconfig` VALUES
('activity', 'enabled', 'yes', 2, 0),
('activity', 'installed_version', '5.0.0-dev.0', 2, 0),
('activity', 'types', 'filesystem', 2, 0),
('app_api', 'enabled', 'yes', 2, 0),
('app_api', 'installed_version', '32.0.0', 2, 0),
('app_api', 'types', '', 2, 0),
('backgroundjob', 'lastjob', '2', 2, 0),
('bruteforcesettings', 'enabled', 'yes', 2, 0),
('bruteforcesettings', 'installed_version', '5.0.0-dev.0', 2, 0),
('bruteforcesettings', 'types', '', 2, 0),
('circles', 'enabled', 'yes', 2, 0),
('circles', 'installed_version', '32.0.0', 2, 0),
('circles', 'loopback_tmp_path', '[[relativeurl]]', 2, 0),
('circles', 'loopback_tmp_scheme', '[[protocol]]', 2, 0),
('circles', 'types', 'filesystem,dav', 2, 0),
('cloud_federation_api', 'enabled', 'yes', 2, 0),
('cloud_federation_api', 'installed_version', '1.16.0', 2, 0),
('cloud_federation_api', 'types', 'filesystem', 2, 0),
('comments', 'enabled', 'yes', 2, 0),
('comments', 'installed_version', '1.22.0', 2, 0),
('comments', 'types', 'logging', 2, 0),
('contactsinteraction', 'enabled', 'yes', 2, 0),
('contactsinteraction', 'installed_version', '1.13.1', 2, 0),
('contactsinteraction', 'types', 'dav', 2, 0),
('core', 'files_metadata', '{"photos-original_date_time":{"value":null,"type":"int","etag":"","indexed":true,"editPermission":0},"photos-size":{"value":null,"type":"array","etag":"","indexed":false,"editPermission":0},"photos-exif":{"value":null,"type":"array","etag":"","indexed":false,"editPermission":0},"photos-ifd0":{"value":null,"type":"array","etag":"","indexed":false,"editPermission":0}}', 64, 1),
('core', 'installedat', '[[timestamp]].8766', 2, 0),
('core', 'lastcron', '[[timestamp]]', 8, 0),
('core', 'lastupdatedat', '[[timestamp]]', 8, 0),
('core', 'oc.integritycheck.checker', '[]', 64, 1),
('core', 'public_files', 'files_sharing/public.php', 2, 0),
('core', 'vendor', 'nextcloud', 2, 0),
('dashboard', 'enabled', 'yes', 2, 0),
('dashboard', 'installed_version', '7.12.0', 2, 0),
('dashboard', 'types', '', 2, 0),
('dav', 'enabled', 'yes', 2, 0),
('dav', 'hasCustomDefaultContact', '0', 32, 0),
('dav', 'installed_version', '1.34.2', 2, 0),
('dav', 'types', 'filesystem', 2, 0),
('federatedfilesharing', 'enabled', 'yes', 2, 0),
('federatedfilesharing', 'installed_version', '1.22.0', 2, 0),
('federatedfilesharing', 'types', '', 2, 0),
('federation', 'enabled', 'yes', 2, 0),
('federation', 'installed_version', '1.22.0', 2, 0),
('federation', 'types', 'authentication', 2, 0),
('files', 'enabled', 'yes', 2, 0),
('files', 'installed_version', '2.4.0', 2, 0),
('files', 'types', 'filesystem', 2, 0),
('files_downloadlimit', 'enabled', 'yes', 2, 0),
('files_downloadlimit', 'installed_version', '5.0.0-dev.0', 2, 0),
('files_downloadlimit', 'types', '', 2, 0),
('files_pdfviewer', 'enabled', 'yes', 2, 0),
('files_pdfviewer', 'installed_version', '5.0.0-dev.0', 2, 0),
('files_pdfviewer', 'types', '', 2, 0),
('files_reminders', 'enabled', 'yes', 2, 0),
('files_reminders', 'installed_version', '1.5.0', 2, 0),
('files_reminders', 'types', '', 2, 0),
('files_sharing', 'enabled', 'yes', 2, 0),
('files_sharing', 'installed_version', '1.24.1', 2, 0),
('files_sharing', 'types', 'filesystem', 2, 0),
('files_trashbin', 'enabled', 'yes', 2, 0),
('files_trashbin', 'installed_version', '1.22.0', 2, 0),
('files_trashbin', 'types', 'filesystem,dav', 2, 0),
('files_versions', 'enabled', 'yes', 2, 0),
('files_versions', 'installed_version', '1.25.0', 2, 0),
('files_versions', 'types', 'filesystem,dav', 2, 0),
('firstrunwizard', 'enabled', 'yes', 2, 0),
('firstrunwizard', 'installed_version', '5.0.0-dev.0', 2, 0),
('firstrunwizard', 'types', '', 2, 0),
('logreader', 'enabled', 'yes', 2, 0),
('logreader', 'installed_version', '5.0.0-dev.0', 2, 0),
('logreader', 'types', 'logging', 2, 0),
('lookup_server_connector', 'enabled', 'yes', 2, 0),
('lookup_server_connector', 'installed_version', '1.20.0', 2, 0),
('lookup_server_connector', 'types', 'authentication', 2, 0),
('nextcloud_announcements', 'enabled', 'yes', 2, 0),
('nextcloud_announcements', 'installed_version', '4.0.0-dev.0', 2, 0),
('nextcloud_announcements', 'types', 'logging', 2, 0),
('notifications', 'enabled', 'yes', 2, 0),
('notifications', 'installed_version', '5.0.0-dev.0', 2, 0),
('notifications', 'types', 'logging', 2, 0),
('oauth2', 'enabled', 'yes', 2, 0),
('oauth2', 'installed_version', '1.20.0', 2, 0),
('oauth2', 'types', 'authentication', 2, 0),
('password_policy', 'enabled', 'yes', 2, 0),
('password_policy', 'installed_version', '4.0.0-dev.0', 2, 0),
('password_policy', 'types', 'authentication', 2, 0),
('photos', 'enabled', 'yes', 2, 0),
('photos', 'installed_version', '5.0.0-dev.1', 2, 0),
('photos', 'types', 'dav,authentication', 2, 0),
('privacy', 'enabled', 'yes', 2, 0),
('privacy', 'installed_version', '4.0.0-dev.0', 2, 0),
('privacy', 'types', '', 2, 0),
('profile', 'enabled', 'yes', 2, 0),
('profile', 'installed_version', '1.1.0', 2, 0),
('profile', 'types', '', 2, 0),
('provisioning_api', 'enabled', 'yes', 2, 0),
('provisioning_api', 'installed_version', '1.22.0', 2, 0),
('provisioning_api', 'types', 'prevent_group_restriction', 2, 0),
('recommendations', 'enabled', 'yes', 2, 0),
('recommendations', 'installed_version', '5.0.0-dev.0', 2, 0),
('recommendations', 'types', '', 2, 0),
('related_resources', 'enabled', 'yes', 2, 0),
('related_resources', 'installed_version', '3.0.0-dev.0', 2, 0),
('related_resources', 'types', '', 2, 0),
('serverinfo', 'enabled', 'yes', 2, 0),
('serverinfo', 'installed_version', '4.0.0-dev.0', 2, 0),
('serverinfo', 'types', '', 2, 0),
('settings', 'enabled', 'yes', 2, 0),
('settings', 'installed_version', '1.15.1', 2, 0),
('settings', 'types', '', 2, 0),
('sharebymail', 'enabled', 'yes', 2, 0),
('sharebymail', 'installed_version', '1.22.0', 2, 0),
('sharebymail', 'types', 'filesystem', 2, 0),
('support', 'enabled', 'yes', 2, 0),
('support', 'installed_version', '4.0.0-dev.0', 2, 0),
('support', 'types', 'session', 2, 0),
('survey_client', 'enabled', 'yes', 2, 0),
('survey_client', 'installed_version', '4.0.0-dev.0', 2, 0),
('survey_client', 'types', '', 2, 0),
('systemtags', 'enabled', 'yes', 2, 0),
('systemtags', 'installed_version', '1.22.0', 2, 0),
('systemtags', 'types', 'logging', 2, 0),
('text', 'enabled', 'yes', 2, 0),
('text', 'installed_version', '6.0.1', 2, 0),
('text', 'types', 'dav', 2, 0),
('theming', 'enabled', 'yes', 2, 0),
('theming', 'installed_version', '2.7.0', 2, 0),
('theming', 'types', 'logging', 2, 0),
('twofactor_backupcodes', 'enabled', 'yes', 2, 0),
('twofactor_backupcodes', 'installed_version', '1.21.0', 2, 0),
('twofactor_backupcodes', 'types', '', 2, 0),
('updatenotification', 'enabled', 'yes', 2, 0),
('updatenotification', 'installed_version', '1.22.0', 2, 0),
('updatenotification', 'types', '', 2, 0),
('user_status', 'enabled', 'yes', 2, 0),
('user_status', 'installed_version', '1.12.0', 2, 0),
('user_status', 'types', '', 2, 0),
('viewer', 'enabled', 'yes', 2, 0),
('viewer', 'installed_version', '5.0.0-dev.0', 2, 0),
('viewer', 'types', '', 2, 0),
('weather_status', 'enabled', 'yes', 2, 0),
('weather_status', 'installed_version', '1.12.0', 2, 0),
('weather_status', 'types', '', 2, 0),
('webhook_listeners', 'enabled', 'yes', 2, 0),
('webhook_listeners', 'installed_version', '1.3.0', 2, 0),
('webhook_listeners', 'types', 'filesystem', 2, 0),
('workflowengine', 'enabled', 'yes', 2, 0),
('workflowengine', 'installed_version', '2.14.0', 2, 0),
('workflowengine', 'types', 'filesystem', 2, 0);

-- --------------------------------------------------------

--
-- Table structure for table `oc_appconfig_ex`
--

CREATE TABLE `oc_appconfig_ex` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `configkey` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `configvalue` longtext COLLATE [[utf8]]_bin,
  `sensitive` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `appconfig_ex__idx` (`appid`,`configkey`),
  KEY `appconfig_ex__configkey` (`configkey`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_authorized_groups`
--

CREATE TABLE `oc_authorized_groups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `group_id` varchar(200) COLLATE [[utf8]]_bin NOT NULL,
  `class` varchar(200) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `admindel_groupid_idx` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_authtoken`
--

CREATE TABLE `oc_authtoken` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `login_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `password` longtext COLLATE [[utf8]]_bin,
  `name` longtext COLLATE [[utf8]]_bin NOT NULL,
  `token` varchar(200) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `type` smallint unsigned DEFAULT '0',
  `remember` smallint unsigned DEFAULT '0',
  `last_activity` int unsigned DEFAULT '0',
  `last_check` int unsigned DEFAULT '0',
  `scope` longtext COLLATE [[utf8]]_bin,
  `expires` int unsigned DEFAULT NULL,
  `private_key` longtext COLLATE [[utf8]]_bin,
  `public_key` longtext COLLATE [[utf8]]_bin,
  `version` smallint unsigned NOT NULL DEFAULT '1',
  `password_invalid` tinyint(1) DEFAULT '0',
  `password_hash` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `authtoken_token_index` (`token`),
  KEY `authtoken_last_activity_idx` (`last_activity`),
  KEY `authtoken_uid_index` (`uid`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_authtoken`
--


-- --------------------------------------------------------

--
-- Table structure for table `oc_bruteforce_attempts`
--

CREATE TABLE `oc_bruteforce_attempts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `occurred` int unsigned NOT NULL DEFAULT '0',
  `ip` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `subnet` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `metadata` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `bruteforce_attempts_ip` (`ip`),
  KEY `bruteforce_attempts_subnet` (`subnet`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendarchanges`
--

CREATE TABLE `oc_calendarchanges` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `synctoken` int unsigned NOT NULL DEFAULT '1',
  `calendarid` bigint NOT NULL,
  `operation` smallint NOT NULL,
  `calendartype` int NOT NULL DEFAULT '0',
  `created_at` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `calid_type_synctoken` (`calendarid`,`calendartype`,`synctoken`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendarobjects`
--

CREATE TABLE `oc_calendarobjects` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `calendardata` longblob,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendarid` bigint unsigned NOT NULL,
  `lastmodified` int unsigned DEFAULT NULL,
  `etag` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `size` bigint unsigned NOT NULL,
  `componenttype` varchar(8) COLLATE [[utf8]]_bin DEFAULT NULL,
  `firstoccurence` bigint unsigned DEFAULT NULL,
  `lastoccurence` bigint unsigned DEFAULT NULL,
  `uid` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `classification` int DEFAULT '0',
  `calendartype` int NOT NULL DEFAULT '0',
  `deleted_at` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `calobjects_index` (`calendarid`,`calendartype`,`uri`),
  UNIQUE KEY `calobjects_by_uid_index` (`calendarid`,`calendartype`,`uid`),
  KEY `calobj_clssfction_index` (`classification`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendarobjects_props`
--

CREATE TABLE `oc_calendarobjects_props` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `calendarid` bigint NOT NULL DEFAULT '0',
  `objectid` bigint unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `parameter` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `value` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendartype` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `calendarobject_index` (`objectid`,`calendartype`),
  KEY `calendarobject_name_index` (`name`,`calendartype`),
  KEY `calendarobject_value_index` (`value`,`calendartype`),
  KEY `calendarobject_calid_index` (`calendarid`,`calendartype`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendars`
--

CREATE TABLE `oc_calendars` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `synctoken` int unsigned NOT NULL DEFAULT '1',
  `description` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendarorder` int unsigned NOT NULL DEFAULT '0',
  `calendarcolor` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `timezone` longtext COLLATE [[utf8]]_bin,
  `components` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `transparent` smallint NOT NULL DEFAULT '0',
  `deleted_at` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `calendars_index` (`principaluri`,`uri`),
  KEY `cals_princ_del_idx` (`principaluri`,`deleted_at`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendarsubscriptions`
--

CREATE TABLE `oc_calendarsubscriptions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(100) COLLATE [[utf8]]_bin DEFAULT NULL,
  `refreshrate` varchar(10) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendarorder` int unsigned NOT NULL DEFAULT '0',
  `calendarcolor` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `striptodos` smallint DEFAULT NULL,
  `stripalarms` smallint DEFAULT NULL,
  `stripattachments` smallint DEFAULT NULL,
  `lastmodified` int unsigned DEFAULT NULL,
  `synctoken` int unsigned NOT NULL DEFAULT '1',
  `source` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`id`),
  UNIQUE KEY `calsub_index` (`principaluri`,`uri`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendars_federated`
--

CREATE TABLE `oc_calendars_federated` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `display_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `color` varchar(7) COLLATE [[utf8]]_bin DEFAULT NULL,
  `uri` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `remote_Url` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `token` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `sync_token` int unsigned NOT NULL DEFAULT '0',
  `last_sync` bigint unsigned DEFAULT NULL,
  `shared_by` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `shared_by_display_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `components` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `permissions` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fedcals_uris_index` (`principaluri`,`uri`),
  KEY `fedcals_last_sync_index` (`last_sync`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_invitations`
--

CREATE TABLE `oc_calendar_invitations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uid` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `recurrenceid` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `attendee` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `organizer` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `sequence` bigint unsigned DEFAULT NULL,
  `token` varchar(60) COLLATE [[utf8]]_bin NOT NULL,
  `expiration` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_invitation_tokens` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_reminders`
--

CREATE TABLE `oc_calendar_reminders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `calendar_id` bigint NOT NULL,
  `object_id` bigint NOT NULL,
  `is_recurring` smallint DEFAULT NULL,
  `uid` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `recurrence_id` bigint unsigned DEFAULT NULL,
  `is_recurrence_exception` smallint NOT NULL,
  `event_hash` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `alarm_hash` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `type` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `is_relative` smallint NOT NULL,
  `notification_date` bigint unsigned NOT NULL,
  `is_repeat_based` smallint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_reminder_objid` (`object_id`),
  KEY `calendar_reminder_uidrec` (`uid`,`recurrence_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_resources`
--

CREATE TABLE `oc_calendar_resources` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `backend_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `resource_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `email` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `group_restrictions` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_resources_bkdrsc` (`backend_id`,`resource_id`),
  KEY `calendar_resources_email` (`email`),
  KEY `calendar_resources_name` (`displayname`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_resources_md`
--

CREATE TABLE `oc_calendar_resources_md` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `resource_id` bigint unsigned NOT NULL,
  `key` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `value` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_resources_md_idk` (`resource_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_rooms`
--

CREATE TABLE `oc_calendar_rooms` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `backend_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `resource_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `email` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `displayname` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `group_restrictions` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_rooms_bkdrsc` (`backend_id`,`resource_id`),
  KEY `calendar_rooms_email` (`email`),
  KEY `calendar_rooms_name` (`displayname`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_calendar_rooms_md`
--

CREATE TABLE `oc_calendar_rooms_md` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `room_id` bigint unsigned NOT NULL,
  `key` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `value` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `calendar_rooms_md_idk` (`room_id`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_cards`
--

CREATE TABLE `oc_cards` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `addressbookid` bigint NOT NULL DEFAULT '0',
  `carddata` longblob,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `lastmodified` bigint unsigned DEFAULT NULL,
  `etag` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `size` bigint unsigned NOT NULL,
  `uid` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cards_abiduri` (`addressbookid`,`uri`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_cards_properties`
--

CREATE TABLE `oc_cards_properties` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `addressbookid` bigint NOT NULL DEFAULT '0',
  `cardid` bigint unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `value` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `preferred` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `card_contactid_index` (`cardid`),
  KEY `card_name_index` (`name`),
  KEY `card_value_index` (`value`),
  KEY `cards_prop_abid_name_value` (`addressbookid`,`name`,`value`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_circle`
--

CREATE TABLE `oc_circles_circle` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `unique_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(127) COLLATE [[utf8]]_bin NOT NULL,
  `display_name` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `sanitized_name` varchar(127) COLLATE [[utf8]]_bin DEFAULT '',
  `instance` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `config` int unsigned DEFAULT NULL,
  `source` int unsigned DEFAULT NULL,
  `settings` longtext COLLATE [[utf8]]_bin,
  `description` longtext COLLATE [[utf8]]_bin,
  `creation` datetime DEFAULT NULL,
  `contact_addressbook` int unsigned DEFAULT NULL,
  `contact_groupname` varchar(127) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_8195F548E3C68343` (`unique_id`),
  KEY `IDX_8195F548D48A2F7C` (`config`),
  KEY `IDX_8195F5484230B1DE` (`instance`),
  KEY `IDX_8195F5485F8A7F73` (`source`),
  KEY `IDX_8195F548C317B362` (`sanitized_name`),
  KEY `dname` (`display_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_event`
--

CREATE TABLE `oc_circles_event` (
  `token` varchar(63) COLLATE [[utf8]]_bin NOT NULL,
  `instance` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `event` longtext COLLATE [[utf8]]_bin,
  `result` longtext COLLATE [[utf8]]_bin,
  `interface` int NOT NULL DEFAULT '0',
  `severity` int DEFAULT NULL,
  `retry` int DEFAULT NULL,
  `status` int DEFAULT NULL,
  `updated` datetime DEFAULT NULL,
  `creation` bigint DEFAULT NULL,
  PRIMARY KEY (`token`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_member`
--

CREATE TABLE `oc_circles_member` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `single_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `circle_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `member_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `user_id` varchar(127) COLLATE [[utf8]]_bin NOT NULL,
  `user_type` smallint NOT NULL DEFAULT '1',
  `instance` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `invited_by` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `level` smallint NOT NULL,
  `status` varchar(15) COLLATE [[utf8]]_bin DEFAULT NULL,
  `note` longtext COLLATE [[utf8]]_bin,
  `cached_name` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `cached_update` datetime DEFAULT NULL,
  `contact_id` varchar(127) COLLATE [[utf8]]_bin DEFAULT NULL,
  `contact_meta` longtext COLLATE [[utf8]]_bin,
  `joined` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `circles_member_cisiuiutil` (`circle_id`,`single_id`,`user_id`,`user_type`,`instance`,`level`),
  KEY `circles_member_cisi` (`circle_id`,`single_id`),
  KEY `IDX_25C66A49E7A1254A` (`contact_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_membership`
--

CREATE TABLE `oc_circles_membership` (
  `circle_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `single_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `level` int unsigned NOT NULL,
  `inheritance_first` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `inheritance_last` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `inheritance_depth` int unsigned NOT NULL,
  `inheritance_path` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`single_id`,`circle_id`),
  KEY `IDX_8FC816EAE7C1D92B` (`single_id`),
  KEY `circles_membership_ifilci` (`inheritance_first`,`inheritance_last`,`circle_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_mount`
--

CREATE TABLE `oc_circles_mount` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `mount_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `circle_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `single_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `token` varchar(63) COLLATE [[utf8]]_bin DEFAULT NULL,
  `parent` int DEFAULT NULL,
  `mountpoint` longtext COLLATE [[utf8]]_bin,
  `mountpoint_hash` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `remote` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `remote_id` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `circles_mount_cimipt` (`circle_id`,`mount_id`,`parent`,`token`),
  KEY `m_sid_rmt_rid` (`circle_id`,`remote`,`remote_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_mountpoint`
--

CREATE TABLE `oc_circles_mountpoint` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `mount_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `single_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `mountpoint` longtext COLLATE [[utf8]]_bin,
  `mountpoint_hash` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mp_sid_hash` (`single_id`,`mountpoint_hash`),
  KEY `circles_mountpoint_ms` (`mount_id`,`single_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_remote`
--

CREATE TABLE `oc_circles_remote` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(15) COLLATE [[utf8]]_bin NOT NULL DEFAULT 'Unknown',
  `interface` int NOT NULL DEFAULT '0',
  `uid` varchar(20) COLLATE [[utf8]]_bin DEFAULT NULL,
  `instance` varchar(127) COLLATE [[utf8]]_bin DEFAULT NULL,
  `href` varchar(254) COLLATE [[utf8]]_bin DEFAULT NULL,
  `item` longtext COLLATE [[utf8]]_bin,
  `creation` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_F94EF834230B1DE` (`instance`),
  KEY `IDX_F94EF83539B0606` (`uid`),
  KEY `IDX_F94EF8334F8E741` (`href`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_share_lock`
--

CREATE TABLE `oc_circles_share_lock` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `item_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `circle_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `instance` varchar(127) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_337F52F8126F525E70EE2FF6` (`item_id`,`circle_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_circles_token`
--

CREATE TABLE `oc_circles_token` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `share_id` int DEFAULT NULL,
  `circle_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `single_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `member_id` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `token` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `password` varchar(127) COLLATE [[utf8]]_bin DEFAULT NULL,
  `accepted` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sicisimit` (`share_id`,`circle_id`,`single_id`,`member_id`,`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_collres_accesscache`
--

CREATE TABLE `oc_collres_accesscache` (
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `collection_id` bigint NOT NULL DEFAULT '0',
  `resource_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `resource_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `access` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`user_id`,`collection_id`,`resource_type`,`resource_id`),
  KEY `collres_user_res` (`user_id`,`resource_type`,`resource_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_collres_collections`
--

CREATE TABLE `oc_collres_collections` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_collres_resources`
--

CREATE TABLE `oc_collres_resources` (
  `collection_id` bigint NOT NULL,
  `resource_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `resource_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`collection_id`,`resource_type`,`resource_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_comments`
--

CREATE TABLE `oc_comments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `topmost_parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `children_count` int unsigned NOT NULL DEFAULT '0',
  `actor_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `actor_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `message` longtext COLLATE [[utf8]]_bin,
  `verb` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `creation_timestamp` datetime DEFAULT NULL,
  `latest_child_timestamp` datetime DEFAULT NULL,
  `object_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `object_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `reference_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `reactions` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `expire_date` datetime DEFAULT NULL,
  `meta_data` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`id`),
  KEY `comments_parent_id_index` (`parent_id`),
  KEY `comments_topmost_parent_id_idx` (`topmost_parent_id`),
  KEY `comments_object_index` (`object_type`,`object_id`,`creation_timestamp`),
  KEY `comments_actor_index` (`actor_type`,`actor_id`),
  KEY `expire_date` (`expire_date`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_comments_read_markers`
--

CREATE TABLE `oc_comments_read_markers` (
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `object_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `object_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `marker_datetime` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`,`object_type`,`object_id`),
  KEY `comments_marker_object_index` (`object_type`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_dav_absence`
--

CREATE TABLE `oc_dav_absence` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `first_day` varchar(10) COLLATE [[utf8]]_bin NOT NULL,
  `last_day` varchar(10) COLLATE [[utf8]]_bin NOT NULL,
  `status` varchar(100) COLLATE [[utf8]]_bin NOT NULL,
  `message` longtext COLLATE [[utf8]]_bin NOT NULL,
  `replacement_user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  `replacement_user_display_name` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `dav_absence_uid_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_dav_cal_proxy`
--

CREATE TABLE `oc_dav_cal_proxy` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `owner_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `proxy_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `permissions` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dav_cal_proxy_uidx` (`owner_id`,`proxy_id`,`permissions`),
  KEY `dav_cal_proxy_ipid` (`proxy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_dav_shares`
--

CREATE TABLE `oc_dav_shares` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `type` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `access` smallint DEFAULT NULL,
  `resourceid` bigint unsigned NOT NULL,
  `publicuri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `token` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dav_shares_index` (`principaluri`,`resourceid`,`type`,`publicuri`),
  KEY `dav_shares_resourceid_type` (`resourceid`,`type`),
  KEY `dav_shares_resourceid_access` (`resourceid`,`access`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_directlink`
--

CREATE TABLE `oc_directlink` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `file_id` bigint unsigned NOT NULL,
  `token` varchar(60) COLLATE [[utf8]]_bin DEFAULT NULL,
  `expiration` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `directlink_token_idx` (`token`),
  KEY `directlink_expiration_idx` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_direct_edit`
--

CREATE TABLE `oc_direct_edit` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `editor_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `token` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `file_id` bigint NOT NULL,
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `share_id` bigint DEFAULT NULL,
  `timestamp` bigint unsigned NOT NULL,
  `accessed` tinyint(1) DEFAULT '0',
  `file_path` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `IDX_4D5AFECA5F37A13B` (`token`),
  KEY `direct_edit_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_apps`
--

CREATE TABLE `oc_ex_apps` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `version` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `daemon_config_name` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '0',
  `port` smallint unsigned NOT NULL,
  `secret` varchar(256) COLLATE [[utf8]]_bin NOT NULL,
  `status` json NOT NULL,
  `enabled` smallint NOT NULL DEFAULT '0',
  `created_time` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ex_apps__appid` (`appid`),
  UNIQUE KEY `ex_apps_c_port__idx` (`daemon_config_name`,`port`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_apps_daemons`
--

CREATE TABLE `oc_ex_apps_daemons` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `display_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `accepts_deploy_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `protocol` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `host` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `deploy_config` json NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ex_apps_daemons__name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_apps_routes`
--

CREATE TABLE `oc_ex_apps_routes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `url` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `verb` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `access_level` int NOT NULL DEFAULT '0',
  `headers_to_exclude` varchar(512) COLLATE [[utf8]]_bin DEFAULT NULL,
  `bruteforce_protection` varchar(512) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ex_apps_routes_appid` (`appid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_deploy_options`
--

CREATE TABLE `oc_ex_deploy_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `type` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `value` json NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `deploy_options__idx` (`appid`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_occ_commands`
--

CREATE TABLE `oc_ex_occ_commands` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `description` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `hidden` smallint NOT NULL DEFAULT '0',
  `arguments` json NOT NULL,
  `options` json NOT NULL,
  `usages` json NOT NULL,
  `execute_handler` varchar(410) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ex_occ_commands__idx` (`appid`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_settings_forms`
--

CREATE TABLE `oc_ex_settings_forms` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `formid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `scheme` json NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ex_settings_forms__idx` (`appid`,`formid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_task_processing`
--

CREATE TABLE `oc_ex_task_processing` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `app_id` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `display_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `task_type` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `custom_task_type` longtext COLLATE [[utf8]]_bin,
  `provider` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `task_processing_idx` (`app_id`,`name`,`task_type`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_ui_files_actions`
--

CREATE TABLE `oc_ex_ui_files_actions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `display_name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `mime` longtext COLLATE [[utf8]]_bin NOT NULL,
  `permissions` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `order` bigint NOT NULL DEFAULT '0',
  `icon` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `action_handler` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `version` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '1.0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ex_ui_files_actions__idx` (`appid`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_ui_scripts`
--

CREATE TABLE `oc_ex_ui_scripts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `type` varchar(16) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `path` varchar(410) COLLATE [[utf8]]_bin NOT NULL,
  `after_app_id` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ui_script__idx` (`appid`,`type`,`name`,`path`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_ui_states`
--

CREATE TABLE `oc_ex_ui_states` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `type` varchar(16) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `key` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `value` json NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ui_state__idx` (`appid`,`type`,`name`,`key`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_ui_styles`
--

CREATE TABLE `oc_ex_ui_styles` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `type` varchar(16) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `path` varchar(410) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ui_style__idx` (`appid`,`type`,`name`,`path`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ex_ui_top_menu`
--

CREATE TABLE `oc_ex_ui_top_menu` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `display_name` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `icon` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `admin_required` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `ui_top_menu__idx` (`appid`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_federated_invites`
--

CREATE TABLE `oc_federated_invites` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `recipient_provider` varchar(2083) COLLATE [[utf8]]_bin DEFAULT NULL,
  `recipient_user_id` varchar(1024) COLLATE [[utf8]]_bin DEFAULT NULL,
  `recipient_name` varchar(1024) COLLATE [[utf8]]_bin DEFAULT NULL,
  `recipient_email` varchar(320) COLLATE [[utf8]]_bin DEFAULT NULL,
  `token` varchar(60) COLLATE [[utf8]]_bin NOT NULL,
  `accepted` tinyint(1) DEFAULT '0',
  `created_at` bigint NOT NULL,
  `expired_at` bigint DEFAULT NULL,
  `accepted_at` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `UNIQ_A2C17D5A5F37A13B` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_federated_reshares`
--

CREATE TABLE `oc_federated_reshares` (
  `share_id` bigint NOT NULL,
  `remote_id` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`share_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_filecache`
--

CREATE TABLE `oc_filecache` (
  `fileid` bigint NOT NULL AUTO_INCREMENT,
  `storage` bigint NOT NULL DEFAULT '0',
  `path` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `path_hash` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `parent` bigint NOT NULL DEFAULT '0',
  `name` varchar(250) COLLATE [[utf8]]_bin DEFAULT NULL,
  `mimetype` bigint NOT NULL DEFAULT '0',
  `mimepart` bigint NOT NULL DEFAULT '0',
  `size` bigint NOT NULL DEFAULT '0',
  `mtime` bigint NOT NULL DEFAULT '0',
  `storage_mtime` bigint NOT NULL DEFAULT '0',
  `encrypted` int NOT NULL DEFAULT '0',
  `unencrypted_size` bigint NOT NULL DEFAULT '0',
  `etag` varchar(40) COLLATE [[utf8]]_bin DEFAULT NULL,
  `permissions` int DEFAULT '0',
  `checksum` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`fileid`),
  UNIQUE KEY `fs_storage_path_hash` (`storage`,`path_hash`),
  KEY `fs_parent_name_hash` (`parent`,`name`),
  KEY `fs_storage_mimetype` (`storage`,`mimetype`),
  KEY `fs_storage_mimepart` (`storage`,`mimepart`),
  KEY `fs_storage_size` (`storage`,`size`,`fileid`),
  KEY `fs_parent` (`parent`),
  KEY `fs_name_hash` (`name`),
  KEY `fs_mtime` (`mtime`),
  KEY `fs_size` (`size`),
  KEY `fs_storage_path_prefix` (`storage`,`path`(64))
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_filecache`
--

-- --------------------------------------------------------

--
-- Table structure for table `oc_filecache_extended`
--

CREATE TABLE `oc_filecache_extended` (
  `fileid` bigint unsigned NOT NULL,
  `metadata_etag` varchar(40) COLLATE [[utf8]]_bin DEFAULT NULL,
  `creation_time` bigint NOT NULL DEFAULT '0',
  `upload_time` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`fileid`),
  KEY `fce_ctime_idx` (`creation_time`),
  KEY `fce_utime_idx` (`upload_time`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_files_metadata`
--

CREATE TABLE `oc_files_metadata` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `file_id` bigint NOT NULL,
  `json` longtext COLLATE [[utf8]]_bin NOT NULL,
  `sync_token` varchar(15) COLLATE [[utf8]]_bin NOT NULL,
  `last_update` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `files_meta_fileid` (`file_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_files_metadata`
--

INSERT INTO `oc_files_metadata` VALUES
(1, 11, '{"photos-size":{"value":{"width":500,"height":500},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-original_date_time":{"value":[[timestamp]],"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token1]]', '[[regtime]]'),
(2, 12, '{"photos-original_date_time":{"value":[[timestamp]],"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token2]]', '[[regtime]]'),
(3, 15, '{"photos-exif":{"value":{"ExposureTime":"1\\/320","FNumber":"4\\/1","ExposureProgram":3,"ISOSpeedRatings":640,"UndefinedTag__x____":640,"ExifVersion":"0230","DateTimeOriginal":"2015:10:15 11:07:44","DateTimeDigitized":"2015:10:15 11:07:44","ShutterSpeedValue":"27970\\/3361","ApertureValue":"4\\/1","ExposureBiasValue":"1\\/3","MaxApertureValue":"4\\/1","MeteringMode":5,"Flash":16,"FocalLength":"200\\/1","SubSecTimeOriginal":"63","SubSecTimeDigitized":"63","ColorSpace":1,"ExifImageWidth":1600,"ExifImageLength":1067,"FocalPlaneXResolution":"1600\\/1","FocalPlaneYResolution":"1600\\/1","FocalPlaneResolutionUnit":3,"CustomRendered":0,"ExposureMode":0,"WhiteBalance":0,"SceneCaptureType":0,"UndefinedTag__xA___":"000084121f"},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-ifd0":{"value":{"Make":"Canon","Model":"Canon EOS 5D Mark III","Orientation":1,"XResolution":"240\\/1","YResolution":"240\\/1","ResolutionUnit":2,"Software":"Adobe Photoshop Lightroom 6.2.1 (Macintosh)","DateTime":"2015:10:16 14:40:21","Exif_IFD_Pointer":230},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-size":{"value":{"width":1600,"height":1067},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-original_date_time":{"value":1444907264,"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token3]]', '[[regtime]]'),
(4, 16, '{"photos-size":{"value":{"width":3000,"height":2000},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-original_date_time":{"value":[[timestamp]],"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token4]]', '[[regtime]]'),
(5, 17, '{"photos-exif":{"value":{"ExposureTime":"1\\/160","FNumber":"4\\/1","ExposureProgram":3,"ISOSpeedRatings":100,"ExifVersion":"0230","DateTimeOriginal":"2013:06:27 07:51:09","DateTimeDigitized":"2013:06:27 07:51:09","ComponentsConfiguration":"","ShutterSpeedValue":"59\\/8","ApertureValue":"4\\/1","ExposureBiasValue":"2\\/3","MaxApertureValue":"4\\/1","MeteringMode":5,"Flash":16,"FocalLength":"45\\/1","SubSecTime":"00","SubSecTimeOriginal":"00","SubSecTimeDigitized":"00","FlashPixVersion":"0100","ColorSpace":1,"ExifImageWidth":1200,"ExifImageLength":1800,"FocalPlaneXResolution":"382423\\/97","FocalPlaneYResolution":"185679\\/47","FocalPlaneResolutionUnit":2,"CustomRendered":0,"ExposureMode":0,"WhiteBalance":0,"SceneCaptureType":0,"UndefinedTag__xA___":"000052602c"},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-ifd0":{"value":{"Make":"Canon","Model":"Canon EOS 5D Mark III","Orientation":1,"XResolution":"72\\/1","YResolution":"72\\/1","ResolutionUnit":2,"Software":"Aperture 3.4.5","DateTime":"2013:06:27 07:51:09","Exif_IFD_Pointer":202},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-size":{"value":{"width":1200,"height":1800},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-original_date_time":{"value":1372319469,"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token5]]', '[[regtime]]'),
(6, 18, '{"photos-exif":{"value":{"ExposureTime":"10\\/12500","FNumber":"35\\/10","ExposureProgram":3,"ISOSpeedRatings":100,"DateTimeOriginal":"2018:05:16 20:03:00","DateTimeDigitized":"2018:05:16 20:03:00","ExposureBiasValue":"0\\/6","MaxApertureValue":"30\\/10","MeteringMode":5,"LightSource":0,"Flash":16,"FocalLength":"700\\/10","MakerNote":"Nikon","UserComment":"Christoph WurstCC-SA 4.0","SubSecTime":"30","SubSecTimeOriginal":"30","SubSecTimeDigitized":"30","ColorSpace":1,"SensingMethod":2,"FileSource":"","SceneType":"","CustomRendered":0,"ExposureMode":0,"WhiteBalance":0,"DigitalZoomRatio":"1\\/1","FocalLengthIn__mmFilm":70,"SceneCaptureType":0,"GainControl":0,"Contrast":1,"Saturation":0,"Sharpness":1,"SubjectDistanceRange":0},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-ifd0":{"value":{"ImageDescription":"Christoph WurstCC-SA 4.0","Make":"NIKON CORPORATION","Model":"NIKON D610","Orientation":1,"XResolution":"72\\/1","YResolution":"72\\/1","ResolutionUnit":2,"Software":"GIMP 2.10.14","DateTime":"2019:12:10 08:51:16","Artist":"Christoph Wurst                     ","Copyright":"Christoph Wurst                                       ","Exif_IFD_Pointer":402,"GPS_IFD_Pointer":13738,"DateTimeOriginal":"2018:05:16 20:03:00"},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-size":{"value":{"width":1920,"height":1281},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-original_date_time":{"value":1526500980,"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token6]]', '[[regtime]]'),
(7, 19, '{"photos-exif":{"value":{"ExposureTime":"1\\/125","FNumber":"28\\/5","ExposureProgram":3,"ISOSpeedRatings":320,"UndefinedTag__x____":320,"ExifVersion":"0230","DateTimeOriginal":"2012:06:30 12:32:11","DateTimeDigitized":"2012:06:30 12:32:11","ComponentsConfiguration":"","ShutterSpeedValue":"7\\/1","ApertureValue":"5\\/1","ExposureBiasValue":"0\\/1","MaxApertureValue":"189284\\/33461","MeteringMode":5,"Flash":16,"FocalLength":"280\\/1","SubSecTime":"83","SubSecTimeOriginal":"83","SubSecTimeDigitized":"83","FlashPixVersion":"0100","ColorSpace":1,"ExifImageWidth":1600,"ExifImageLength":1067,"FocalPlaneXResolution":"1920000\\/487","FocalPlaneYResolution":"320000\\/81","FocalPlaneResolutionUnit":2,"CustomRendered":0,"ExposureMode":0,"WhiteBalance":0,"SceneCaptureType":0,"UndefinedTag__xA___":"0000000000"},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-ifd0":{"value":{"Make":"Canon","Model":"Canon EOS 5D Mark III","Orientation":1,"XResolution":"72\\/1","YResolution":"72\\/1","ResolutionUnit":2,"DateTime":"2012:06:30 12:32:11","Exif_IFD_Pointer":174},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-size":{"value":{"width":1600,"height":1067},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-original_date_time":{"value":1341059531,"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token7]]', '[[regtime]]'),
(8, 20, '{"photos-exif":{"value":{"ExposureTime":"1\\/80","FNumber":"4\\/1","ExposureProgram":3,"ISOSpeedRatings":400,"ExifVersion":"0230","DateTimeOriginal":"2012:07:02 19:50:36","DateTimeDigitized":"2012:07:02 19:50:36","ComponentsConfiguration":"","ShutterSpeedValue":"51\\/8","ApertureValue":"4\\/1","ExposureBiasValue":"0\\/1","MaxApertureValue":"4\\/1","MeteringMode":5,"Flash":16,"FocalLength":"32\\/1","SubSecTime":"00","SubSecTimeOriginal":"00","SubSecTimeDigitized":"00","FlashPixVersion":"0100","ColorSpace":1,"ExifImageWidth":1600,"ExifImageLength":1066,"FocalPlaneXResolution":"382423\\/97","FocalPlaneYResolution":"185679\\/47","FocalPlaneResolutionUnit":2,"CustomRendered":0,"ExposureMode":0,"WhiteBalance":0,"SceneCaptureType":0},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-ifd0":{"value":{"Make":"Canon","Model":"Canon EOS 5D Mark III","Orientation":1,"XResolution":"72\\/1","YResolution":"72\\/1","ResolutionUnit":2,"Software":"GIMP 2.8.0","DateTime":"2012:07:02 22:06:14","Exif_IFD_Pointer":198},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-size":{"value":{"width":1600,"height":1066},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-original_date_time":{"value":1341258636,"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token8]]', '[[regtime]]'),
(9, 21, '{"photos-exif":{"value":{"ExposureTime":"1\\/500","FNumber":"28\\/5","ExposureProgram":1,"ISOSpeedRatings":8000,"ExifVersion":"0230","DateTimeOriginal":"2012:06:30 16:15:15","DateTimeDigitized":"2012:06:30 16:15:15","ComponentsConfiguration":"","ShutterSpeedValue":"9\\/1","ApertureValue":"5\\/1","ExposureBiasValue":"0\\/1","MaxApertureValue":"6149\\/1087","MeteringMode":5,"Flash":16,"FocalLength":"280\\/1","SubSecTime":"00","SubSecTimeOriginal":"00","SubSecTimeDigitized":"00","FlashPixVersion":"0100","ColorSpace":1,"ExifImageWidth":1600,"ExifImageLength":1067,"FocalPlaneXResolution":"382423\\/97","FocalPlaneYResolution":"134321\\/34","FocalPlaneResolutionUnit":2,"CustomRendered":0,"ExposureMode":1,"WhiteBalance":0,"SceneCaptureType":0},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-ifd0":{"value":{"Make":"Canon","Model":"Canon EOS 5D Mark III","Orientation":1,"XResolution":"72\\/1","YResolution":"72\\/1","ResolutionUnit":2,"Software":"Aperture 3.3.1","DateTime":"2012:06:30 16:15:15","Exif_IFD_Pointer":202},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-size":{"value":{"width":1600,"height":1067},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-original_date_time":{"value":1341072915,"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token9]]', '[[regtime]]'),
(10, 23, '{"photos-exif":{"value":{"ExposureTime":"1\\/640","FNumber":"28\\/5","ExposureProgram":1,"ISOSpeedRatings":12800,"ExifVersion":"0230","DateTimeOriginal":"2012:06:30 13:47:40","DateTimeDigitized":"2012:06:30 13:47:40","ComponentsConfiguration":"","ShutterSpeedValue":"75\\/8","ApertureValue":"5\\/1","ExposureBiasValue":"0\\/1","MaxApertureValue":"6149\\/1087","MeteringMode":5,"Flash":16,"FocalLength":"235\\/1","SubSecTime":"00","SubSecTimeOriginal":"00","SubSecTimeDigitized":"00","FlashPixVersion":"0100","ExifImageWidth":1600,"ExifImageLength":1067,"FocalPlaneXResolution":"382423\\/97","FocalPlaneYResolution":"134321\\/34","FocalPlaneResolutionUnit":2,"CustomRendered":0,"ExposureMode":1,"WhiteBalance":0,"SceneCaptureType":0},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-ifd0":{"value":{"Make":"Canon","Model":"Canon EOS 5D Mark III","Orientation":1,"XResolution":"72\\/1","YResolution":"72\\/1","ResolutionUnit":2,"Software":"Aperture 3.3.1","DateTime":"2012:06:30 13:47:40","Exif_IFD_Pointer":202},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-size":{"value":{"width":1600,"height":1067},"type":"array","etag":"","indexed":false,"editPermission":0},"photos-original_date_time":{"value":1341064060,"type":"int","etag":"","indexed":true,"editPermission":0}}', '[[sync_token10]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `oc_files_metadata_index`
--

CREATE TABLE `oc_files_metadata_index` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `file_id` bigint NOT NULL,
  `meta_key` varchar(31) COLLATE [[utf8]]_bin DEFAULT NULL,
  `meta_value_string` varchar(63) COLLATE [[utf8]]_bin DEFAULT NULL,
  `meta_value_int` bigint DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `f_meta_index` (`file_id`,`meta_key`,`meta_value_string`),
  KEY `f_meta_index_i` (`file_id`,`meta_key`,`meta_value_int`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_files_metadata_index`
--

INSERT INTO `oc_files_metadata_index` VALUES
(1, 11, 'photos-original_date_time', NULL, [[timestamp]]),
(2, 12, 'photos-original_date_time', NULL, [[timestamp]]),
(3, 15, 'photos-original_date_time', NULL, 1444907264),
(4, 16, 'photos-original_date_time', NULL, [[timestamp]]),
(5, 17, 'photos-original_date_time', NULL, 1372319469),
(6, 18, 'photos-original_date_time', NULL, 1526500980),
(7, 19, 'photos-original_date_time', NULL, 1341059531),
(8, 20, 'photos-original_date_time', NULL, 1341258636),
(9, 21, 'photos-original_date_time', NULL, 1341072915),
(10, 23, 'photos-original_date_time', NULL, 1341064060);

-- --------------------------------------------------------

--
-- Table structure for table `oc_files_reminders`
--

CREATE TABLE `oc_files_reminders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `file_id` bigint unsigned NOT NULL,
  `due_date` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `notified` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `reminders_uniq_idx` (`user_id`,`file_id`,`due_date`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_files_trash`
--

CREATE TABLE `oc_files_trash` (
  `auto_id` bigint NOT NULL AUTO_INCREMENT,
  `id` varchar(250) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `user` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `timestamp` varchar(12) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `location` varchar(512) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `type` varchar(4) COLLATE [[utf8]]_bin DEFAULT NULL,
  `mime` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `deleted_by` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`auto_id`),
  KEY `id_index` (`id`),
  KEY `timestamp_index` (`timestamp`),
  KEY `user_index` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_files_versions`
--

CREATE TABLE `oc_files_versions` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `file_id` bigint NOT NULL,
  `timestamp` bigint NOT NULL,
  `size` bigint NOT NULL,
  `mimetype` bigint NOT NULL,
  `metadata` json NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `files_versions_uniq_index` (`file_id`,`timestamp`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_files_versions`
--

INSERT INTO `oc_files_versions` VALUES
(1, 4, [[timestamp]], 23876, 4, '{"author": "[[admin_username]]"}'),
(2, 5, [[timestamp]], 1095, 6, '{"author": "[[admin_username]]"}'),
(3, 6, [[timestamp]], 136, 6, '{"author": "[[admin_username]]"}'),
(4, 7, [[timestamp]], 1083339, 7, '{"author": "[[admin_username]]"}'),
(5, 8, [[timestamp]], 22209309, 7, '{"author": "[[admin_username]]"}'),
(6, 9, [[timestamp]], 3168, 6, '{"author": "[[admin_username]]"}'),
(7, 10, [[timestamp]], 976625, 7, '{"author": "[[admin_username]]"}'),
(8, 11, [[timestamp]], 50598, 9, '{"author": "[[admin_username]]"}'),
(9, 12, [[timestamp]], 3963036, 11, '{"author": "[[admin_username]]"}'),
(10, 13, [[timestamp]], 197, 6, '{"author": "[[admin_username]]"}'),
(11, 15, [[timestamp]], 167989, 12, '{"author": "[[admin_username]]"}'),
(12, 16, [[timestamp]], 797325, 12, '{"author": "[[admin_username]]"}'),
(13, 17, [[timestamp]], 567689, 12, '{"author": "[[admin_username]]"}'),
(14, 18, [[timestamp]], 427030, 12, '{"author": "[[admin_username]]"}'),
(15, 19, [[timestamp]], 593508, 12, '{"author": "[[admin_username]]"}'),
(16, 20, [[timestamp]], 2170375, 12, '{"author": "[[admin_username]]"}'),
(17, 21, [[timestamp]], 457744, 12, '{"author": "[[admin_username]]"}'),
(18, 22, [[timestamp]], 150, 6, '{"author": "[[admin_username]]"}'),
(19, 23, [[timestamp]], 474653, 12, '{"author": "[[admin_username]]"}'),
(20, 25, [[timestamp]], 35454, 13, '{"author": "[[admin_username]]"}'),
(21, 26, [[timestamp]], 16988, 14, '{"author": "[[admin_username]]"}'),
(22, 27, [[timestamp]], 868111, 15, '{"author": "[[admin_username]]"}'),
(23, 28, [[timestamp]], 22675, 15, '{"author": "[[admin_username]]"}'),
(24, 29, [[timestamp]], 32323, 15, '{"author": "[[admin_username]]"}'),
(25, 30, [[timestamp]], 81196, 13, '{"author": "[[admin_username]]"}'),
(26, 31, [[timestamp]], 31132, 16, '{"author": "[[admin_username]]"}'),
(27, 32, [[timestamp]], 340061, 15, '{"author": "[[admin_username]]"}'),
(28, 33, [[timestamp]], 14810, 13, '{"author": "[[admin_username]]"}'),
(29, 34, [[timestamp]], 29055, 17, '{"author": "[[admin_username]]"}'),
(30, 35, [[timestamp]], 33441, 15, '{"author": "[[admin_username]]"}'),
(31, 36, [[timestamp]], 31325, 16, '{"author": "[[admin_username]]"}'),
(32, 37, [[timestamp]], 17331, 15, '{"author": "[[admin_username]]"}'),
(33, 38, [[timestamp]], 25621, 16, '{"author": "[[admin_username]]"}'),
(34, 39, [[timestamp]], 33089, 15, '{"author": "[[admin_username]]"}'),
(35, 40, [[timestamp]], 15961, 15, '{"author": "[[admin_username]]"}'),
(36, 41, [[timestamp]], 30290, 16, '{"author": "[[admin_username]]"}'),
(37, 42, [[timestamp]], 256849, 17, '{"author": "[[admin_username]]"}'),
(38, 43, [[timestamp]], 190107, 13, '{"author": "[[admin_username]]"}'),
(39, 44, [[timestamp]], 23359, 16, '{"author": "[[admin_username]]"}'),
(40, 45, [[timestamp]], 13653, 14, '{"author": "[[admin_username]]"}'),
(41, 46, [[timestamp]], 317015, 13, '{"author": "[[admin_username]]"}'),
(42, 47, [[timestamp]], 11836, 14, '{"author": "[[admin_username]]"}'),
(43, 48, [[timestamp]], 17276, 15, '{"author": "[[admin_username]]"}'),
(44, 49, [[timestamp]], 14316, 13, '{"author": "[[admin_username]]"}'),
(45, 50, [[timestamp]], 5155877, 15, '{"author": "[[admin_username]]"}'),
(46, 51, [[timestamp]], 1441424, 13, '{"author": "[[admin_username]]"}'),
(47, 52, [[timestamp]], 9904434, 13, '{"author": "[[admin_username]]"}'),
(48, 53, [[timestamp]], 13378, 17, '{"author": "[[admin_username]]"}'),
(49, 54, [[timestamp]], 19026, 17, '{"author": "[[admin_username]]"}'),
(50, 55, [[timestamp]], 45778, 16, '{"author": "[[admin_username]]"}'),
(51, 56, [[timestamp]], 554, 6, '{"author": "[[admin_username]]"}'),
(52, 57, [[timestamp]], 3509628, 13, '{"author": "[[admin_username]]"}'),
(53, 58, [[timestamp]], 560887, 13, '{"author": "[[admin_username]]"}'),
(54, 59, [[timestamp]], 30780, 16, '{"author": "[[admin_username]]"}'),
(55, 60, [[timestamp]], 27629, 16, '{"author": "[[admin_username]]"}'),
(56, 61, [[timestamp]], 30671, 16, '{"author": "[[admin_username]]"}'),
(57, 62, [[timestamp]], 90170, 17, '{"author": "[[admin_username]]"}'),
(58, 63, [[timestamp]], 22002, 17, '{"author": "[[admin_username]]"}'),
(59, 64, [[timestamp]], 35657, 16, '{"author": "[[admin_username]]"}'),
(60, 65, [[timestamp]], 573, 6, '{"author": "[[admin_username]]"}'),
(61, 66, [[timestamp]], 13878, 14, '{"author": "[[admin_username]]"}'),
(62, 67, [[timestamp]], 326, 6, '{"author": "[[admin_username]]"}'),
(63, 68, [[timestamp]], 35963, 13, '{"author": "[[admin_username]]"}'),
(64, 69, [[timestamp]], 34163, 15, '{"author": "[[admin_username]]"}');

-- --------------------------------------------------------

--
-- Table structure for table `oc_file_locks`
--

CREATE TABLE `oc_file_locks` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lock` int NOT NULL DEFAULT '0',
  `key` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `ttl` int NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `lock_key_index` (`key`),
  KEY `lock_ttl_index` (`ttl`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;


-- --------------------------------------------------------

--
-- Table structure for table `oc_flow_checks`
--

CREATE TABLE `oc_flow_checks` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class` varchar(256) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `operator` varchar(16) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `value` longtext COLLATE [[utf8]]_bin,
  `hash` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `flow_unique_hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_flow_operations`
--

CREATE TABLE `oc_flow_operations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `class` varchar(256) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `name` varchar(256) COLLATE [[utf8]]_bin DEFAULT '',
  `checks` longtext COLLATE [[utf8]]_bin,
  `operation` longtext COLLATE [[utf8]]_bin,
  `entity` varchar(256) COLLATE [[utf8]]_bin NOT NULL DEFAULT 'OCA\\WorkflowEngine\\Entity\\File',
  `events` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_flow_operations_scope`
--

CREATE TABLE `oc_flow_operations_scope` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `operation_id` int NOT NULL DEFAULT '0',
  `type` int NOT NULL DEFAULT '0',
  `value` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `flow_unique_scope` (`operation_id`,`type`,`value`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_groups`
--

CREATE TABLE `oc_groups` (
  `gid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `displayname` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT 'name',
  PRIMARY KEY (`gid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_groups`
--

INSERT INTO `oc_groups` VALUES
('admin', 'admin');

-- --------------------------------------------------------

--
-- Table structure for table `oc_group_admin`
--

CREATE TABLE `oc_group_admin` (
  `gid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`gid`,`uid`),
  KEY `group_admin_uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_group_user`
--

CREATE TABLE `oc_group_user` (
  `gid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`gid`,`uid`),
  KEY `gu_uid_index` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_group_user`
--

INSERT INTO `oc_group_user` VALUES
('admin', '[[admin_username]]');

-- --------------------------------------------------------

--
-- Table structure for table `oc_jobs`
--

CREATE TABLE `oc_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `argument` varchar(4000) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `last_run` int DEFAULT '0',
  `last_checked` int DEFAULT '0',
  `reserved_at` int DEFAULT '0',
  `execution_duration` int DEFAULT '0',
  `argument_hash` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `time_sensitive` smallint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `job_class_index` (`class`),
  KEY `job_lastcheck_reserved` (`last_checked`,`reserved_at`),
  KEY `job_argument_hash` (`class`,`argument_hash`),
  KEY `jobs_time_sensitive` (`time_sensitive`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_jobs`
--

INSERT INTO `oc_jobs` VALUES
(1, 'OCA\\Activity\\BackgroundJob\\EmailNotification', 'null', [[timestamp]], [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(2, 'OCA\\Activity\\BackgroundJob\\ExpireActivities', 'null', [[timestamp]], [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 0),
(3, 'OCA\\Activity\\BackgroundJob\\DigestMail', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(4, 'OCA\\Activity\\BackgroundJob\\RemoveFormerActivitySettings', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(5, 'OCA\\ServerInfo\\Jobs\\UpdateStorageStats', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(6, 'OCA\\ContactsInteraction\\BackgroundJob\\CleanupJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(7, 'OCA\\OAuth2\\BackgroundJob\\CleanupExpiredAuthorizationCode', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(8, 'OCA\\Notifications\\BackgroundJob\\GenerateUserSettings', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(9, 'OCA\\Notifications\\BackgroundJob\\SendNotificationMails', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(10, 'OCA\\AppAPI\\BackgroundJob\\ExAppInitStatusCheckJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(11, 'OCA\\WorkflowEngine\\BackgroundJobs\\Rotate', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(12, 'OCA\\UserStatus\\BackgroundJob\\ClearOldStatusesBackgroundJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(13, 'OCA\\NextcloudAnnouncements\\Cron\\Crawler', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(14, 'OCA\\UpdateNotification\\BackgroundJob\\UpdateAvailableNotifications', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(15, 'OCA\\Files_Sharing\\DeleteOrphanedSharesJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(16, 'OCA\\Files_Sharing\\ExpireSharesJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(17, 'OCA\\Files_Sharing\\SharesReminderJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(18, 'OCA\\Files_Sharing\\BackgroundJob\\FederatedSharesDiscoverJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(19, 'OCA\\Support\\BackgroundJobs\\CheckSubscription', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(20, 'OCA\\DAV\\BackgroundJob\\CleanupDirectLinksJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(21, 'OCA\\DAV\\BackgroundJob\\UpdateCalendarResourcesRoomsBackgroundJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(22, 'OCA\\DAV\\BackgroundJob\\CleanupInvitationTokenJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(23, 'OCA\\DAV\\BackgroundJob\\EventReminderJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(24, 'OCA\\DAV\\BackgroundJob\\CalendarRetentionJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(25, 'OCA\\DAV\\BackgroundJob\\PruneOutdatedSyncTokensJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(26, 'OCA\\DAV\\BackgroundJob\\FederatedCalendarPeriodicSyncJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(27, 'OCA\\Files\\BackgroundJob\\ScanFiles', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(28, 'OCA\\Files\\BackgroundJob\\DeleteOrphanedItems', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(29, 'OCA\\Files\\BackgroundJob\\CleanupFileLocks', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(30, 'OCA\\Files\\BackgroundJob\\CleanupDirectEditingTokens', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(31, 'OCA\\Files\\BackgroundJob\\DeleteExpiredOpenLocalEditor', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(32, 'OCA\\Files_Versions\\BackgroundJob\\ExpireVersions', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(33, 'OCA\\Federation\\SyncJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(34, 'OCA\\Text\\Cron\\Cleanup', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(35, 'OCA\\FilesReminders\\BackgroundJob\\CleanUpReminders', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(36, 'OCA\\FilesReminders\\BackgroundJob\\ScheduledNotifications', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(37, 'OCA\\Photos\\Jobs\\AutomaticPlaceMapperJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(38, 'OCA\\Files_Trashbin\\BackgroundJob\\ExpireTrash', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(39, 'OCA\\Circles\\Cron\\Maintenance', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(40, 'OC\\Authentication\\Token\\TokenCleanupJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(41, 'OC\\Log\\Rotate', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(42, 'OC\\Preview\\BackgroundCleanupJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(43, 'OC\\TextProcessing\\RemoveOldTasksBackgroundJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(44, 'OC\\User\\BackgroundJobs\\CleanupDeletedUsers', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(45, 'OC\\Core\\BackgroundJobs\\GenerateMetadataJob', 'null', 0, [[timestamp]], 0, 0, '74234e98afe7498fb5daf1f36ac2d78acc339464f950703b8c019892f982b90b', 1),
(46, 'OCA\\FirstRunWizard\\Notification\\BackgroundJob', '{"uid":"[[admin_username]]"}', 0, [[timestamp]], 0, 0, 'ed1cbe38683040ba735f2ac7d5e5783105ec8b5d13e6855e8da42a3454adb0c9', 1),
(47, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",4]', 0, [[timestamp]], 0, 0, 'f588e8eeaff62265baf2d8f6aa795f136066ac564b02ca93ea7a441d8fb82284', 1),
(48, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",5]', 0, [[timestamp]], 0, 0, '8b35c08d91cb539471c71692c934b08c0338fc2a5e9fec4efb436b0df925cea1', 1),
(49, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",6]', 0, [[timestamp]], 0, 0, '0d8b45e9f114117060b67f4c0ffbf40656805fb9b2bba425847e61c1b613b959', 1),
(50, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",7]', 0, [[timestamp]], 0, 0, '0303e2b31d94b4259e254be4bbea2c864ffaf8a9a51f4825e42a15e883442dab', 1),
(51, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",8]', 0, [[timestamp]], 0, 0, '5dcf1fc4bc35feb6839b4145ae45e3194dcaa61365221ea2b412de567da8cbbc', 1),
(52, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",9]', 0, [[timestamp]], 0, 0, '0ef54b3dba11c241bc477cd1903cb033dc87edabfcac714af1b436a8f94ada6c', 1),
(53, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",10]', 0, [[timestamp]], 0, 0, '46f5110363c64ea262ad77bd56b481edaa28960aaccd985fb9a1be49b2aefdbf', 1),
(54, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",11]', 0, [[timestamp]], 0, 0, 'f94b75fced4aa7c934ad48b8c7b1a151e7bdb3c75befbd0909660da8f5105e35', 1),
(55, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",12]', 0, [[timestamp]], 0, 0, 'a84f02f449b504d6bd0729d8168d460f5bc7c8f7ba972ae7f73d31502f79d93d', 1),
(56, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",13]', 0, [[timestamp]], 0, 0, 'db6c9234620f69e4b58e6197bc91ae021381b39f5e3ce48015e139ca26a2ab63', 1),
(57, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",15]', 0, [[timestamp]], 0, 0, '4e5099be54ea7b64c4f2b4814cda25ca77523f678457803beef75640f0bbd9da', 1),
(58, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",16]', 0, [[timestamp]], 0, 0, '32c8cd9086bd3ad9eb6414e2aee8c83e5a3cc9648a828c320d8982948356687b', 1),
(59, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",17]', 0, [[timestamp]], 0, 0, '51f2e1f3e610d1de56e3b53aeb9e00ef3d388ab7a01901b8078f8db3fba83a0b', 1),
(60, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",18]', 0, [[timestamp]], 0, 0, '33798b5393b5e51717a9bf418bc67ca7bb410e5d0e6d56e324b558b29513068e', 1),
(61, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",19]', 0, [[timestamp]], 0, 0, 'ba0a0ed151c84dac3b7c48fb1fd7514793ea28f4e81c55fd194f9dab7d62a300', 1),
(62, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",20]', 0, [[timestamp]], 0, 0, 'fb37f6858f9cd83799da315106f065b455703d4a2686df13df8f2e901ce3a362', 1),
(63, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",21]', 0, [[timestamp]], 0, 0, '1d5a4f2d5d6fcb9aca5b87769912049844b82319863f53c97f484043fd5e58cb', 1),
(64, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",22]', 0, [[timestamp]], 0, 0, '314087acf3de957c95b385be8c6139f2c0253c2a5100d9b91e89e4305ad48746', 1),
(65, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",23]', 0, [[timestamp]], 0, 0, '54ba9f8d5478447b4fee13a377e1878d089bfc6ec2091d121c12c33f88bbf710', 1),
(66, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",25]', 0, [[timestamp]], 0, 0, 'f7b16bcf3310ff37f4f8208941b68402abd1359230546ce68fd004c4a8b0948e', 1),
(67, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",26]', 0, [[timestamp]], 0, 0, '005dec9ea82ed6049bb276b169790c10dad98ced49df55bde5bba7f60ae25f0f', 1),
(68, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",27]', 0, [[timestamp]], 0, 0, '78a608b2897ae2a116e9c80641abec371ebd9eea4a454630f1119710558381a1', 1),
(69, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",28]', 0, [[timestamp]], 0, 0, '55189359302c77e930896626563301ae275ce6a53a5c567bad6905aae3783063', 1),
(70, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",29]', 0, [[timestamp]], 0, 0, 'ef22b15f63e04b485f7f31a0c3e38674e6b875051f394f8d01d57007edbb3dd4', 1),
(71, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",30]', 0, [[timestamp]], 0, 0, '9aa8a289578fd2a7b5680ad902aed53a4ceed649f5918fc9bc11ac2e7b8948c7', 1),
(72, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",31]', 0, [[timestamp]], 0, 0, '05ab1203293e55367ebc114ac4a8a16a2f1244bf7459caeaf24cf47598e1a7e7', 1),
(73, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",32]', 0, [[timestamp]], 0, 0, 'dfaa1d229412ad151b5d05a2b840ecadf7c5e7dc47c0448342f3081f43b83f32', 1),
(74, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",33]', 0, [[timestamp]], 0, 0, '6c30b17298a457f6b465869f9afeb69fd3e8a2eeb5348de9fad485e755c4fd6f', 1),
(75, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",34]', 0, [[timestamp]], 0, 0, 'd1e3e0d6008b733328e7787e5a26b8c14e60e883f21c28f4e968fc27a760c2b9', 1),
(76, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",35]', 0, [[timestamp]], 0, 0, 'adbdaf064b915813d9c52337d3bcd1f028f16710c2879e5d9bd2b4f376fcd0f5', 1),
(77, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",36]', 0, [[timestamp]], 0, 0, '12ef6a6751a28809fd03f07a1220104b1e724defa6f90d5b3969868280217560', 1),
(78, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",37]', 0, [[timestamp]], 0, 0, '6637a6e73d9add61216bc11bbcca9cbfe31c3d9678e95a74a67bc0e31d7ea58c', 1),
(79, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",38]', 0, [[timestamp]], 0, 0, 'fb470daa5e7696d8fc8f9a52433de70de233deedba66b5589404975b5d50d0ba', 1),
(80, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",39]', 0, [[timestamp]], 0, 0, '7c93da13554feed5f341cc3a5d107a2ed72f5958bb2e2a0f7dff7b5a33f08690', 1),
(81, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",40]', 0, [[timestamp]], 0, 0, '2627221314e3d0b6a356c01b1bb17b20a0c0880075540313570bfe9419f3f8ad', 1),
(82, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",41]', 0, [[timestamp]], 0, 0, '243c551c4843c53a30a643753dced6bfd6a9fe9cb7614889bea621ceb24ca7b2', 1),
(83, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",42]', 0, [[timestamp]], 0, 0, 'cad2cda3789e8a0076498ef350711a576ffe0b0ef2f5642ca90e2aba45d130c7', 1),
(84, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",43]', 0, [[timestamp]], 0, 0, '0926e7398bdd5ef043f3b9abbba2824eacdad1ebb3bab95e1050b976a045e98a', 1),
(85, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",44]', 0, [[timestamp]], 0, 0, 'cf5118f364a60cfbbae54cffcd80141ac043fdb31e3551441e235e5de53cfcd0', 1),
(86, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",45]', 0, [[timestamp]], 0, 0, 'e431fcd38f478a34e22ea69807a89fad02f69d157925461d58c56c2bdb5c3d43', 1),
(87, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",46]', 0, [[timestamp]], 0, 0, 'ecf57fa6426a4d43b979bc4f05115e5623ddc3887a3635af8fd7aea383b95539', 1),
(88, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",47]', 0, [[timestamp]], 0, 0, '257dd9702987e3ac77bb744e320362233df18730ff8f7128b6e58b964e8b96ab', 1),
(89, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",48]', 0, [[timestamp]], 0, 0, '2f5572f636a6cdd5eea74dba63a9a1ceb0ff6ceafb8048c8581e92227f27586a', 1),
(90, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",49]', 0, [[timestamp]], 0, 0, 'ab493bb0dcbda0f7c5a5ca0c505b3b7c65a89b93751ecaa115668876177082b2', 1),
(91, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",50]', 0, [[timestamp]], 0, 0, 'e39a8034ec45d8d090c5cd67cfbe4c290722f172006f419e855f80fc721c85df', 1),
(92, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",51]', 0, [[timestamp]], 0, 0, '041ff683391d644e2eda34d912378c557d917f8aff202829c60fcaeb585ec189', 1),
(93, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",52]', 0, [[timestamp]], 0, 0, 'bbc9248fef254e9b2956ae427201173b4862ec071a05a5ae2495ef51fcc29156', 1),
(94, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",53]', 0, [[timestamp]], 0, 0, 'cc7b6a8728540ba67535170e4308d1b0fe5d9df81362355719e5fc2d36d8e619', 1),
(95, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",54]', 0, [[timestamp]], 0, 0, '255037f7af38912b42c3000ab63bbcae26b9bc402bf8b9b1a5de3c86af8ba481', 1),
(96, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",55]', 0, [[timestamp]], 0, 0, '52444e35d728948af4bcfa2e5ec624915c8c02613a4458b41ff1dac4454f32b1', 1),
(97, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",56]', 0, [[timestamp]], 0, 0, 'dbdbeae2d135b3093313ab978375e901f5e1e5ac7619e4d92f86e6da435168a0', 1),
(98, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",57]', 0, [[timestamp]], 0, 0, '6548c6a15b9641b46b25ab421e90a5876eebf2b46408f98e484c624e8e64081d', 1),
(99, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",58]', 0, [[timestamp]], 0, 0, '7903b785c36984c32432c9683ff4366f6400f6512a2cfe99b5657ea34fae35f4', 1),
(100, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",59]', 0, [[timestamp]], 0, 0, '15b0e744846d7748db69f7886c2abdb55b13b783bd6eacd2de8b9957e2207e15', 1),
(101, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",60]', 0, [[timestamp]], 0, 0, '5e5118860eca4668c05bac4461d423651469bf35a1bddfde650659809a1c2c9a', 1),
(102, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",61]', 0, [[timestamp]], 0, 0, '443d52aac8a9ffd4496911163307a60e1e620527b1940b23844d73a773915f17', 1),
(103, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",62]', 0, [[timestamp]], 0, 0, '25c52e63066d85dfe8d80a50abfa0394469be1bec95c5d9e8e0eaea48181fbb7', 1),
(104, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",63]', 0, [[timestamp]], 0, 0, '57c563f5f058ddc63009f74d6f8d0a820a109f80d3fca5e54c2c8235148f272e', 1),
(105, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",64]', 0, [[timestamp]], 0, 0, '8cda3958a8280a428c35b66a21ba5d17077ae762dece8a4a37da50f3e51924f1', 1),
(106, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",65]', 0, [[timestamp]], 0, 0, 'cb9e048cfb94ea572f055b3caab6480fb08b109554b6e91efa2a825e2708ee59', 1),
(107, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",66]', 0, [[timestamp]], 0, 0, '9d725d00c54a8b6f8571c1b5c38ac39107be14c2c042010495dac337512a8023', 1),
(108, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",67]', 0, [[timestamp]], 0, 0, '193f608e1cf40adf040cf4811b060504550f5f5afafedc2c174ac2810e626017', 1),
(109, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",68]', 0, [[timestamp]], 0, 0, 'cc188d1435ffdf91b2b20e0af7b4fab97f289545724e5a2244ce21e4e819bbd2', 1),
(110, 'OC\\FilesMetadata\\Job\\UpdateSingleMetadata', '["[[admin_username]]",69]', 0, [[timestamp]], 0, 0, '7166bc63d8ecffea256bf43c37e45cb2399c2b653da2fb1cfbe298c2b3da96f4', 1);

-- --------------------------------------------------------

--
-- Table structure for table `oc_known_users`
--

CREATE TABLE `oc_known_users` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `known_to` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `known_user` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ku_known_to` (`known_to`),
  KEY `ku_known_user` (`known_user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_login_flow_v2`
--

CREATE TABLE `oc_login_flow_v2` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` bigint unsigned NOT NULL,
  `started` smallint unsigned NOT NULL DEFAULT '0',
  `poll_token` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `login_token` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `public_key` text COLLATE [[utf8]]_bin NOT NULL,
  `private_key` text COLLATE [[utf8]]_bin NOT NULL,
  `client_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `login_name` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `server` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `app_password` varchar(1024) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `poll_token` (`poll_token`),
  UNIQUE KEY `login_token` (`login_token`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_migrations`
--

CREATE TABLE `oc_migrations` (
  `app` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `version` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`app`,`version`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_migrations`
--

INSERT INTO `oc_migrations` VALUES
('activity', '2006Date20170808154933'),
('activity', '2006Date20170808155040'),
('activity', '2006Date20170919095939'),
('activity', '2007Date20181107114613'),
('activity', '2008Date20181011095117'),
('activity', '2010Date20190416112817'),
('activity', '2011Date20201006132544'),
('activity', '2011Date20201006132545'),
('activity', '2011Date20201006132546'),
('activity', '2011Date20201006132547'),
('activity', '2011Date20201207091915'),
('app_api', '032000Date20250109162434'),
('app_api', '032001Date20250115164140'),
('app_api', '032002Date20250527174907'),
('app_api', '1000Date202305221555'),
('app_api', '1004Date202311061844'),
('app_api', '2000Date20240120094952'),
('app_api', '2005Date20240209094951'),
('app_api', '2201Date20240221124152'),
('app_api', '2203Date20240325124149'),
('app_api', '2204Date20240403125002'),
('app_api', '2205Date20240411124836'),
('app_api', '2206Date20240502145029'),
('app_api', '2207Date20240502145029'),
('app_api', '2700Date20240515092246'),
('app_api', '2800Date20240710220000'),
('app_api', '2800Date20240711080316'),
('app_api', '3000Date20240715170800'),
('app_api', '3000Date20240807085759'),
('app_api', '3100Date20240822080316'),
('app_api', '3200Date20240905080316'),
('app_api', '5000Date20241120135411'),
('circles', '0022Date20220526111723'),
('circles', '0022Date20220526113601'),
('circles', '0022Date20220703115023'),
('circles', '0023Date20211216113101'),
('circles', '0024Date20220203123901'),
('circles', '0024Date20220203123902'),
('circles', '0024Date20220317190331'),
('circles', '0028Date20230705222601'),
('circles', '0031Date20241105133904'),
('circles', '0032Date20250623120204'),
('cloud_federation_api', '1016Date202502262004'),
('contactsinteraction', '010000Date20200304152605'),
('core', '13000Date20170705121758'),
('core', '13000Date20170718121200'),
('core', '13000Date20170814074715'),
('core', '13000Date20170919121250'),
('core', '13000Date20170926101637'),
('core', '14000Date20180129121024'),
('core', '14000Date20180404140050'),
('core', '14000Date20180516101403'),
('core', '14000Date20180518120534'),
('core', '14000Date20180522074438'),
('core', '14000Date20180626223656'),
('core', '14000Date20180710092004'),
('core', '14000Date20180712153140'),
('core', '15000Date20180926101451'),
('core', '15000Date20181015062942'),
('core', '15000Date20181029084625'),
('core', '16000Date20190207141427'),
('core', '16000Date20190212081545'),
('core', '16000Date20190427105638'),
('core', '16000Date20190428150708'),
('core', '17000Date20190514105811'),
('core', '18000Date20190920085628'),
('core', '18000Date20191014105105'),
('core', '18000Date20191204114856'),
('core', '19000Date20200211083441'),
('core', '20000Date20201109081915'),
('core', '20000Date20201109081918'),
('core', '20000Date20201109081919'),
('core', '20000Date20201111081915'),
('core', '21000Date20201120141228'),
('core', '21000Date20201202095923'),
('core', '21000Date20210119195004'),
('core', '21000Date20210309185126'),
('core', '21000Date20210309185127'),
('core', '22000Date20210216080825'),
('core', '23000Date20210721100600'),
('core', '23000Date20210906132259'),
('core', '23000Date20210930122352'),
('core', '23000Date20211203110726'),
('core', '23000Date20211213203940'),
('core', '24000Date20211210141942'),
('core', '24000Date20211213081506'),
('core', '24000Date20211213081604'),
('core', '24000Date20211222112246'),
('core', '24000Date20211230140012'),
('core', '24000Date20220131153041'),
('core', '24000Date20220202150027'),
('core', '24000Date20220404230027'),
('core', '24000Date20220425072957'),
('core', '25000Date20220515204012'),
('core', '25000Date20220602190540'),
('core', '25000Date20220905140840'),
('core', '25000Date20221007010957'),
('core', '27000Date20220613163520'),
('core', '27000Date20230309104325'),
('core', '27000Date20230309104802'),
('core', '28000Date20230616104802'),
('core', '28000Date20230728104802'),
('core', '28000Date20230803221055'),
('core', '28000Date20230906104802'),
('core', '28000Date20231004103301'),
('core', '28000Date20231103104802'),
('core', '28000Date20231126110901'),
('core', '28000Date20240828142927'),
('core', '29000Date20231126110901'),
('core', '29000Date20231213104850'),
('core', '29000Date20240124132201'),
('core', '29000Date20240124132202'),
('core', '29000Date20240131122720'),
('core', '30000Date20240429122720'),
('core', '30000Date20240708160048'),
('core', '30000Date20240717111406'),
('core', '30000Date20240814180800'),
('core', '30000Date20240815080800'),
('core', '30000Date20240906095113'),
('core', '31000Date20240101084401'),
('core', '31000Date20240814184402'),
('core', '31000Date20250213102442'),
('core', '32000Date20250620081925'),
('core', '32000Date20250731062008'),
('core', '32000Date20250806110519'),
('core', '33000Date20251209123503'),
('dav', '1004Date20170825134824'),
('dav', '1004Date20170919104507'),
('dav', '1004Date20170924124212'),
('dav', '1004Date20170926103422'),
('dav', '1005Date20180413093149'),
('dav', '1005Date20180530124431'),
('dav', '1006Date20180619154313'),
('dav', '1006Date20180628111625'),
('dav', '1008Date20181030113700'),
('dav', '1008Date20181105104826'),
('dav', '1008Date20181105104833'),
('dav', '1008Date20181105110300'),
('dav', '1008Date20181105112049'),
('dav', '1008Date20181114084440'),
('dav', '1011Date20190725113607'),
('dav', '1011Date20190806104428'),
('dav', '1012Date20190808122342'),
('dav', '1016Date20201109085907'),
('dav', '1017Date20210216083742'),
('dav', '1018Date20210312100735'),
('dav', '1024Date20211221144219'),
('dav', '1025Date20240308063933'),
('dav', '1027Date20230504122946'),
('dav', '1029Date20221114151721'),
('dav', '1029Date20231004091403'),
('dav', '1030Date20240205103243'),
('dav', '1031Date20240610134258'),
('dav', '1034Date20250605132605'),
('dav', '1034Date20250813093701'),
('federatedfilesharing', '1010Date20200630191755'),
('federatedfilesharing', '1011Date20201120125158'),
('federation', '1010Date20200630191302'),
('files', '11301Date20191205150729'),
('files', '12101Date20221011153334'),
('files', '2003Date20241021095629'),
('files_downloadlimit', '000000Date20210910094923'),
('files_reminders', '10000Date20230725162149'),
('files_sharing', '11300Date20201120141438'),
('files_sharing', '21000Date20201223143245'),
('files_sharing', '22000Date20210216084241'),
('files_sharing', '24000Date20220208195521'),
('files_sharing', '24000Date20220404142216'),
('files_sharing', '31000Date20240821142813'),
('files_sharing', '32000Date20251017081948'),
('files_trashbin', '1010Date20200630192639'),
('files_trashbin', '1020Date20240403003535'),
('files_versions', '1020Date20221114144058'),
('notifications', '2004Date20190107135757'),
('notifications', '2010Date20210218082811'),
('notifications', '2010Date20210218082855'),
('notifications', '2011Date20210930134607'),
('notifications', '2011Date20220826074907'),
('oauth2', '010401Date20181207190718'),
('oauth2', '010402Date20190107124745'),
('oauth2', '011601Date20230522143227'),
('oauth2', '011602Date20230613160650'),
('oauth2', '011603Date20230620111039'),
('oauth2', '011901Date20240829164356'),
('photos', '20000Date20220727125801'),
('photos', '20001Date20220830131446'),
('photos', '20003Date20221102170153'),
('photos', '20003Date20221103094628'),
('photos', '30000Date20240417075405'),
('photos', '32000Date20250507132617'),
('privacy', '100Date20190217131943'),
('systemtags', '31000Date20241018063111'),
('systemtags', '31000Date20241114171300'),
('text', '010000Date20190617184535'),
('text', '030001Date20200402075029'),
('text', '030201Date20201116110353'),
('text', '030201Date20201116123153'),
('text', '030501Date20220202101853'),
('text', '030701Date20230207131313'),
('text', '030901Date20231114150437'),
('text', '040100Date20240611165300'),
('text', '070000Date20250925110024'),
('theming', '2006Date20240905111627'),
('twofactor_backupcodes', '1002Date20170607104347'),
('twofactor_backupcodes', '1002Date20170607113030'),
('twofactor_backupcodes', '1002Date20170919123342'),
('twofactor_backupcodes', '1002Date20170926101419'),
('twofactor_backupcodes', '1002Date20180821043638'),
('user_status', '0001Date20200602134824'),
('user_status', '0002Date20200902144824'),
('user_status', '1000Date20201111130204'),
('user_status', '1003Date20210809144824'),
('user_status', '1008Date20230921144701'),
('webhook_listeners', '1000Date20240527153425'),
('webhook_listeners', '1001Date20240716184935'),
('workflowengine', '2000Date20190808074233'),
('workflowengine', '2200Date20210805101925');

-- --------------------------------------------------------

--
-- Table structure for table `oc_mimetypes`
--

CREATE TABLE `oc_mimetypes` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `mimetype` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mimetype_id_index` (`mimetype`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_mimetypes`
--

INSERT INTO `oc_mimetypes` VALUES
(3, 'application'),
(21, 'application/gzip'),
(19, 'application/javascript'),
(20, 'application/octet-stream'),
(7, 'application/pdf'),
(16, 'application/vnd.excalidraw+json'),
(14, 'application/vnd.oasis.opendocument.graphics'),
(13, 'application/vnd.oasis.opendocument.presentation'),
(17, 'application/vnd.oasis.opendocument.spreadsheet'),
(15, 'application/vnd.oasis.opendocument.text'),
(4, 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'),
(1, 'httpd'),
(2, 'httpd/unix-directory'),
(8, 'image'),
(12, 'image/jpeg'),
(9, 'image/png'),
(22, 'image/svg+xml'),
(5, 'text'),
(6, 'text/markdown'),
(18, 'text/vcard'),
(10, 'video'),
(11, 'video/mp4');

-- --------------------------------------------------------

--
-- Table structure for table `oc_mounts`
--

CREATE TABLE `oc_mounts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `storage_id` bigint NOT NULL,
  `root_id` bigint NOT NULL,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `mount_point` varchar(4000) COLLATE [[utf8]]_bin NOT NULL,
  `mount_id` bigint DEFAULT NULL,
  `mount_provider_class` varchar(128) COLLATE [[utf8]]_bin DEFAULT NULL,
  `mount_point_hash` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mounts_user_root_path_index` (`user_id`,`root_id`,`mount_point_hash`),
  KEY `mounts_storage_index` (`storage_id`),
  KEY `mounts_root_index` (`root_id`),
  KEY `mounts_mount_id_index` (`mount_id`),
  KEY `mounts_class_index` (`mount_provider_class`),
  KEY `mount_user_storage` (`storage_id`,`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_mounts`
--

INSERT INTO `oc_mounts` VALUES
(1, 1, 1, '[[admin_username]]', '/[[admin_username]]/', NULL, 'OC\\Files\\Mount\\LocalHomeMountProvider', '');

-- --------------------------------------------------------

--
-- Table structure for table `oc_notifications`
--

CREATE TABLE `oc_notifications` (
  `notification_id` int NOT NULL AUTO_INCREMENT,
  `app` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `user` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `timestamp` int NOT NULL DEFAULT '0',
  `object_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `object_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `subject` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `subject_parameters` longtext COLLATE [[utf8]]_bin,
  `message` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `message_parameters` longtext COLLATE [[utf8]]_bin,
  `link` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `icon` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `actions` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`notification_id`),
  KEY `oc_notifications_app` (`app`),
  KEY `oc_notifications_user` (`user`),
  KEY `oc_notifications_timestamp` (`timestamp`),
  KEY `oc_notifications_object` (`object_type`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_notifications_pushhash`
--

CREATE TABLE `oc_notifications_pushhash` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `token` int NOT NULL DEFAULT '0',
  `deviceidentifier` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `devicepublickey` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `devicepublickeyhash` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `pushtokenhash` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `proxyserver` varchar(256) COLLATE [[utf8]]_bin NOT NULL,
  `apptype` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  UNIQUE KEY `oc_npushhash_uid` (`uid`,`token`),
  KEY `oc_npushhash_di` (`deviceidentifier`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_notifications_settings`
--

CREATE TABLE `oc_notifications_settings` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `batch_time` int NOT NULL DEFAULT '0',
  `last_send_id` bigint NOT NULL DEFAULT '0',
  `next_send_time` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `notset_user` (`user_id`),
  KEY `notset_nextsend` (`next_send_time`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_oauth2_access_tokens`
--

CREATE TABLE `oc_oauth2_access_tokens` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `token_id` int NOT NULL,
  `client_id` int NOT NULL,
  `hashed_code` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `encrypted_token` varchar(786) COLLATE [[utf8]]_bin NOT NULL,
  `code_created_at` bigint unsigned NOT NULL DEFAULT '0',
  `token_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `oauth2_access_hash_idx` (`hashed_code`),
  KEY `oauth2_access_client_id_idx` (`client_id`),
  KEY `oauth2_tk_c_created_idx` (`token_count`,`code_created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_oauth2_clients`
--

CREATE TABLE `oc_oauth2_clients` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `redirect_uri` varchar(2000) COLLATE [[utf8]]_bin NOT NULL,
  `client_identifier` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `secret` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `oauth2_client_id_idx` (`client_identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_open_local_editor`
--

CREATE TABLE `oc_open_local_editor` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `path_hash` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `expiration_time` bigint unsigned NOT NULL,
  `token` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `openlocal_user_path_token` (`user_id`,`path_hash`,`token`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_photos_albums`
--

CREATE TABLE `oc_photos_albums` (
  `album_id` bigint NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `user` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `created` bigint NOT NULL,
  `location` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `last_added_photo` bigint NOT NULL,
  `filters` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`album_id`),
  KEY `pa_user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_photos_albums_collabs`
--

CREATE TABLE `oc_photos_albums_collabs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `album_id` bigint NOT NULL,
  `collaborator_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `collaborator_type` int NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `album_collabs_uniq_collab` (`album_id`,`collaborator_id`,`collaborator_type`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_photos_albums_files`
--

CREATE TABLE `oc_photos_albums_files` (
  `album_file_id` bigint NOT NULL AUTO_INCREMENT,
  `album_id` bigint NOT NULL,
  `file_id` bigint NOT NULL,
  `added` bigint NOT NULL,
  `owner` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`album_file_id`),
  UNIQUE KEY `paf_album_file` (`album_id`,`file_id`),
  KEY `paf_folder` (`album_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_preferences`
--

CREATE TABLE `oc_preferences` (
  `userid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `configkey` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `configvalue` longtext COLLATE [[utf8]]_bin,
  `lazy` smallint unsigned NOT NULL DEFAULT '0',
  `type` smallint unsigned NOT NULL DEFAULT '0',
  `flags` int unsigned NOT NULL DEFAULT '0',
  `indexed` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`userid`,`appid`,`configkey`),
  KEY `prefs_uid_lazy_i` (`userid`,`lazy`),
  KEY `prefs_app_key_ind_fl_i` (`appid`,`configkey`,`indexed`,`flags`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_preferences`
--

INSERT INTO `oc_preferences` VALUES
('[[admin_username]]', 'core', 'lang', '[[language]]', 0, 1, 0, ''),
('[[admin_username]]', 'core', 'templateDirectory', 'Templates/', 0, 0, 0, ''),
('[[admin_username]]', 'login', 'lastLogin', '[[timestamp]]', 0, 0, 0, '');
-- --------------------------------------------------------

--
-- Table structure for table `oc_preferences_ex`
--

CREATE TABLE `oc_preferences_ex` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `appid` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `configkey` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `configvalue` longtext COLLATE [[utf8]]_bin,
  `sensitive` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `preferences_ex__idx` (`userid`,`appid`,`configkey`),
  KEY `preferences_ex__configkey` (`configkey`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_privacy_admins`
--

CREATE TABLE `oc_privacy_admins` (
  `id` int NOT NULL AUTO_INCREMENT,
  `displayname` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_profile_config`
--

CREATE TABLE `oc_profile_config` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `config` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `profile_config_user_id_idx` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_properties`
--

CREATE TABLE `oc_properties` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `userid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `propertypath` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `propertyname` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `propertyvalue` longtext COLLATE [[utf8]]_bin NOT NULL,
  `valuetype` smallint DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `properties_path_index` (`userid`,`propertypath`),
  KEY `properties_pathonly_index` (`propertypath`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_ratelimit_entries`
--

CREATE TABLE `oc_ratelimit_entries` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `hash` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `delete_after` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ratelimit_hash` (`hash`),
  KEY `ratelimit_delete_after` (`delete_after`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_reactions`
--

CREATE TABLE `oc_reactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` bigint unsigned NOT NULL,
  `message_id` bigint unsigned NOT NULL,
  `actor_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `actor_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `reaction` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `comment_reaction_unique` (`parent_id`,`actor_type`,`actor_id`,`reaction`),
  KEY `comment_reaction` (`reaction`),
  KEY `comment_reaction_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_recent_contact`
--

CREATE TABLE `oc_recent_contact` (
  `id` int NOT NULL AUTO_INCREMENT,
  `actor_uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `uid` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `email` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `federated_cloud_id` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `card` longblob NOT NULL,
  `last_contact` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `recent_contact_actor_uid` (`actor_uid`),
  KEY `recent_contact_id_uid` (`id`,`actor_uid`),
  KEY `recent_contact_uid` (`uid`),
  KEY `recent_contact_email` (`email`),
  KEY `recent_contact_fed_id` (`federated_cloud_id`),
  KEY `recent_contact_last_contact` (`last_contact`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_schedulingobjects`
--

CREATE TABLE `oc_schedulingobjects` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `principaluri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `calendardata` longblob,
  `uri` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `lastmodified` int unsigned DEFAULT NULL,
  `etag` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `size` bigint unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `schedulobj_principuri_index` (`principaluri`),
  KEY `schedulobj_lastmodified_idx` (`lastmodified`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_sec_signatory`
--

CREATE TABLE `oc_sec_signatory` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key_id_sum` varchar(127) COLLATE [[utf8]]_bin NOT NULL,
  `key_id` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `host` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `provider_id` varchar(31) COLLATE [[utf8]]_bin NOT NULL,
  `account` varchar(127) COLLATE [[utf8]]_bin DEFAULT '',
  `public_key` longtext COLLATE [[utf8]]_bin NOT NULL,
  `metadata` longtext COLLATE [[utf8]]_bin NOT NULL,
  `type` smallint NOT NULL DEFAULT '9',
  `status` smallint NOT NULL DEFAULT '0',
  `creation` int unsigned DEFAULT '0',
  `last_updated` int unsigned DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sec_sig_unic` (`provider_id`,`host`,`account`),
  KEY `sec_sig_key` (`key_id_sum`,`provider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_share`
--

CREATE TABLE `oc_share` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `share_type` smallint NOT NULL DEFAULT '0',
  `share_with` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `password` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `uid_owner` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `uid_initiator` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `parent` bigint DEFAULT NULL,
  `item_type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `item_source` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `item_target` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `file_source` bigint DEFAULT NULL,
  `file_target` varchar(512) COLLATE [[utf8]]_bin DEFAULT NULL,
  `permissions` smallint NOT NULL DEFAULT '0',
  `stime` bigint NOT NULL DEFAULT '0',
  `accepted` smallint NOT NULL DEFAULT '0',
  `expiration` datetime DEFAULT NULL,
  `token` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `mail_send` smallint NOT NULL DEFAULT '0',
  `share_name` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `password_by_talk` tinyint(1) DEFAULT '0',
  `note` longtext COLLATE [[utf8]]_bin,
  `hide_download` smallint DEFAULT '0',
  `label` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `attributes` json DEFAULT NULL,
  `password_expiration_time` datetime DEFAULT NULL,
  `reminder_sent` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `item_share_type_index` (`item_type`,`share_type`),
  KEY `file_source_index` (`file_source`),
  KEY `token_index` (`token`),
  KEY `share_with_index` (`share_with`),
  KEY `parent_index` (`parent`),
  KEY `owner_index` (`uid_owner`),
  KEY `initiator_index` (`uid_initiator`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_shares_limits`
--

CREATE TABLE `oc_shares_limits` (
  `id` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `limit` bigint NOT NULL,
  `downloads` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_share_external`
--

CREATE TABLE `oc_share_external` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `parent` bigint DEFAULT '-1',
  `share_type` int DEFAULT NULL,
  `remote` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `remote_id` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `share_token` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `password` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `name` varchar(4000) COLLATE [[utf8]]_bin NOT NULL,
  `owner` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `user` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `mountpoint` varchar(4000) COLLATE [[utf8]]_bin NOT NULL,
  `mountpoint_hash` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `accepted` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sh_external_mp` (`user`,`mountpoint_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_storages`
--

CREATE TABLE `oc_storages` (
  `numeric_id` bigint NOT NULL AUTO_INCREMENT,
  `id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `available` int NOT NULL DEFAULT '1',
  `last_checked` int DEFAULT NULL,
  PRIMARY KEY (`numeric_id`),
  UNIQUE KEY `storages_id_index` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_storages`
--

INSERT INTO `oc_storages` VALUES
(1, 'home::[[admin_username]]', 1, NULL),
(2, 'local::[[softdatadir]]/', 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `oc_storages_credentials`
--

CREATE TABLE `oc_storages_credentials` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `identifier` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `credentials` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`id`),
  UNIQUE KEY `stocred_ui` (`user`,`identifier`),
  KEY `stocred_user` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_systemtag`
--

CREATE TABLE `oc_systemtag` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `visibility` smallint NOT NULL DEFAULT '1',
  `editable` smallint NOT NULL DEFAULT '1',
  `etag` varchar(32) COLLATE [[utf8]]_bin DEFAULT NULL,
  `color` varchar(6) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tag_ident` (`name`,`visibility`,`editable`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_systemtag_group`
--

CREATE TABLE `oc_systemtag_group` (
  `systemtagid` bigint unsigned NOT NULL DEFAULT '0',
  `gid` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`gid`,`systemtagid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_systemtag_object_mapping`
--

CREATE TABLE `oc_systemtag_object_mapping` (
  `objectid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `objecttype` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `systemtagid` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`objecttype`,`objectid`,`systemtagid`),
  KEY `systag_by_tagid` (`systemtagid`,`objecttype`),
  KEY `systag_by_objectid` (`objectid`),
  KEY `systag_objecttype` (`objecttype`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_taskprocessing_tasks`
--

CREATE TABLE `oc_taskprocessing_tasks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `input` longtext COLLATE [[utf8]]_bin NOT NULL,
  `output` longtext COLLATE [[utf8]]_bin,
  `status` int DEFAULT '0',
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `app_id` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `custom_id` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `last_updated` int unsigned DEFAULT '0',
  `completion_expected_at` datetime DEFAULT NULL,
  `progress` double DEFAULT '0',
  `error_message` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `scheduled_at` int unsigned DEFAULT NULL,
  `started_at` int unsigned DEFAULT NULL,
  `ended_at` int unsigned DEFAULT NULL,
  `webhook_uri` varchar(4000) COLLATE [[utf8]]_bin DEFAULT NULL,
  `webhook_method` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `allow_cleanup` smallint unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `taskp_tasks_status_type` (`status`,`type`),
  KEY `taskp_tasks_updated` (`last_updated`),
  KEY `taskp_tasks_uid_appid_cid` (`user_id`,`app_id`,`custom_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_text2image_tasks`
--

CREATE TABLE `oc_text2image_tasks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `input` longtext COLLATE [[utf8]]_bin NOT NULL,
  `status` int DEFAULT '0',
  `number_of_images` int NOT NULL DEFAULT '1',
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `app_id` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `identifier` varchar(255) COLLATE [[utf8]]_bin DEFAULT '',
  `last_updated` datetime DEFAULT NULL,
  `completion_expected_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `t2i_tasks_updated` (`last_updated`),
  KEY `t2i_tasks_status` (`status`),
  KEY `t2i_tasks_uid_appid_ident` (`user_id`,`app_id`,`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_textprocessing_tasks`
--

CREATE TABLE `oc_textprocessing_tasks` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `input` longtext COLLATE [[utf8]]_bin NOT NULL,
  `output` longtext COLLATE [[utf8]]_bin,
  `status` int DEFAULT '0',
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `app_id` varchar(32) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `identifier` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `last_updated` int unsigned DEFAULT '0',
  `completion_expected_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tp_tasks_updated` (`last_updated`),
  KEY `tp_tasks_status_type_nonunique` (`status`,`type`),
  KEY `tp_tasks_uid_appid_ident` (`user_id`,`app_id`,`identifier`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_text_documents`
--

CREATE TABLE `oc_text_documents` (
  `id` bigint unsigned NOT NULL,
  `current_version` bigint unsigned DEFAULT '0',
  `last_saved_version` bigint unsigned DEFAULT '0',
  `last_saved_version_time` bigint unsigned NOT NULL,
  `last_saved_version_etag` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  `base_version_etag` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  `checksum` varchar(8) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_text_sessions`
--

CREATE TABLE `oc_text_sessions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `guest_name` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `color` varchar(7) COLLATE [[utf8]]_bin DEFAULT NULL,
  `token` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `document_id` bigint NOT NULL,
  `last_contact` bigint unsigned NOT NULL,
  `last_awareness_message` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`id`),
  KEY `rd_session_token_idx` (`token`),
  KEY `ts_lastcontact` (`last_contact`),
  KEY `ts_docid_lastcontact` (`document_id`,`last_contact`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_text_steps`
--

CREATE TABLE `oc_text_steps` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `document_id` bigint unsigned NOT NULL,
  `session_id` bigint unsigned NOT NULL,
  `data` longtext COLLATE [[utf8]]_bin NOT NULL,
  `version` bigint unsigned DEFAULT '0',
  `timestamp` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `rd_steps_did_idx` (`document_id`),
  KEY `rd_steps_version_idx` (`version`),
  KEY `textstep_session` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_trusted_servers`
--

CREATE TABLE `oc_trusted_servers` (
  `id` int NOT NULL AUTO_INCREMENT,
  `url` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `url_hash` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `token` varchar(128) COLLATE [[utf8]]_bin DEFAULT NULL,
  `shared_secret` varchar(256) COLLATE [[utf8]]_bin DEFAULT NULL,
  `status` int NOT NULL DEFAULT '2',
  `sync_token` varchar(512) COLLATE [[utf8]]_bin DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `url_hash` (`url_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_twofactor_backupcodes`
--

CREATE TABLE `oc_twofactor_backupcodes` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `user_id` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `code` varchar(128) COLLATE [[utf8]]_bin NOT NULL,
  `used` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `twofactor_backupcodes_uid` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_twofactor_providers`
--

CREATE TABLE `oc_twofactor_providers` (
  `provider_id` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `enabled` smallint NOT NULL,
  PRIMARY KEY (`provider_id`,`uid`),
  KEY `twofactor_providers_uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_users`
--

CREATE TABLE `oc_users` (
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `displayname` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `password` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `uid_lower` varchar(64) COLLATE [[utf8]]_bin DEFAULT '',
  PRIMARY KEY (`uid`),
  KEY `user_uid_lower` (`uid_lower`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

--
-- Dumping data for table `oc_users`
--

INSERT INTO `oc_users` VALUES
('[[admin_username]]', NULL, '[[admin_pass]]', '[[admin_username_lower]]');

-- --------------------------------------------------------

--
-- Table structure for table `oc_user_status`
--

CREATE TABLE `oc_user_status` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `status` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  `status_timestamp` int unsigned NOT NULL,
  `is_user_defined` tinyint(1) DEFAULT NULL,
  `message_id` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `custom_icon` varchar(255) COLLATE [[utf8]]_bin DEFAULT NULL,
  `custom_message` longtext COLLATE [[utf8]]_bin,
  `clear_at` int unsigned DEFAULT NULL,
  `is_backup` tinyint(1) DEFAULT '0',
  `status_message_timestamp` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_status_uid_ix` (`user_id`),
  KEY `user_status_clr_ix` (`clear_at`),
  KEY `user_status_tstmp_ix` (`status_timestamp`),
  KEY `user_status_iud_ix` (`is_user_defined`,`status`),
  KEY `user_status_mtstmp_ix` (`status_message_timestamp`)
) ENGINE=InnoDB  DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_user_transfer_owner`
--

CREATE TABLE `oc_user_transfer_owner` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `source_user` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `target_user` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `file_id` bigint NOT NULL,
  `node_name` varchar(255) COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_vcategory`
--

CREATE TABLE `oc_vcategory` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `category` varchar(255) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_category_per_user` (`uid`,`type`,`category`),
  KEY `uid_index` (`uid`),
  KEY `type_index` (`type`),
  KEY `category_index` (`category`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_vcategory_to_object`
--

CREATE TABLE `oc_vcategory_to_object` (
  `objid` bigint unsigned NOT NULL DEFAULT '0',
  `categoryid` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  PRIMARY KEY (`categoryid`,`objid`,`type`),
  KEY `vcategory_objectd_index` (`objid`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_webauthn`
--

CREATE TABLE `oc_webauthn` (
  `id` int NOT NULL AUTO_INCREMENT,
  `uid` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `name` varchar(64) COLLATE [[utf8]]_bin NOT NULL,
  `public_key_credential_id` varchar(512) COLLATE [[utf8]]_bin NOT NULL,
  `data` longtext COLLATE [[utf8]]_bin NOT NULL,
  `user_verification` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `webauthn_uid` (`uid`),
  KEY `webauthn_publicKeyCredentialId` (`public_key_credential_id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_webhook_listeners`
--

CREATE TABLE `oc_webhook_listeners` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `app_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `user_id` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `http_method` varchar(32) COLLATE [[utf8]]_bin NOT NULL,
  `uri` varchar(4000) COLLATE [[utf8]]_bin NOT NULL,
  `event` varchar(4000) COLLATE [[utf8]]_bin NOT NULL,
  `event_filter` longtext COLLATE [[utf8]]_bin,
  `user_id_filter` varchar(64) COLLATE [[utf8]]_bin DEFAULT NULL,
  `headers` longtext COLLATE [[utf8]]_bin,
  `auth_method` varchar(16) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `auth_data` longtext COLLATE [[utf8]]_bin,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

-- --------------------------------------------------------

--
-- Table structure for table `oc_whats_new`
--

CREATE TABLE `oc_whats_new` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '11',
  `etag` varchar(64) COLLATE [[utf8]]_bin NOT NULL DEFAULT '',
  `last_check` int unsigned NOT NULL DEFAULT '0',
  `data` longtext COLLATE [[utf8]]_bin NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `version` (`version`),
  KEY `version_etag_idx` (`version`,`etag`)
) ENGINE=InnoDB DEFAULT CHARSET=[[utf8]] COLLATE=[[utf8]]_bin;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
