<?php

/**
 * Invoice Ninja (https://invoiceninja.com).
 *
 * @link https://github.com/invoiceninja/invoiceninja source repository
 *
 * @copyright Copyright (c) 2025. Invoice Ninja LLC (https://invoiceninja.com)
 *
 * @license https://www.elastic.co/licensing/elastic-license
 */

namespace App\Services\Template;

use App\Models\Company;
use App\Services\Pdf\PdfMock;

class TemplateMock
{
    protected ?object $settings;

    public array $engines = [];

    public array $variables = [];

    public string $credit_data = '[{"id":1,"client_id":1,"user_id":1,"assigned_user_id":null,"company_id":1,"status_id":2,"project_id":null,"vendor_id":null,"recurring_id":null,"design_id":2,"invoice_id":null,"number":"0001","discount":1,"is_amount_discount":false,"po_number":"Molestias.","date":"2025-01-24","last_sent_date":null,"due_date":"2025-02-13","next_send_date":null,"is_deleted":false,"line_items":[{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$935.00","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$0.00","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":935,"tax_amount_raw":0,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"GST","tax_rate1":10,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,028.50","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$93.50","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1028.5,"tax_amount_raw":93.5,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"VAT","tax_rate1":17.5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,098.63","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$163.63","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1098.63,"tax_amount_raw":163.63,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"GST","tax_rate1":10,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,028.50","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$93.50","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1028.5,"tax_amount_raw":93.5,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10}],"backup":null,"footer":null,"public_notes":null,"private_notes":null,"terms":null,"tax_name1":"GST","tax_rate1":"10.000000","tax_name2":"VAT","tax_rate2":"17.500000","tax_name3":"THIRDTAX","tax_rate3":"5.000000","total_taxes":"1797.280000","uses_inclusive_taxes":0,"custom_value1":null,"custom_value2":null,"custom_value3":null,"custom_value4":null,"custom_surcharge1":null,"custom_surcharge2":null,"custom_surcharge3":null,"custom_surcharge4":null,"custom_surcharge_tax1":0,"custom_surcharge_tax2":0,"custom_surcharge_tax3":0,"custom_surcharge_tax4":0,"exchange_rate":"1.000000","amount":"6211.690000","balance":"0.000000","partial":10,"partial_due_date":"2025-02-03","last_viewed":null,"created_at":"2025-01-24","updated_at":"2025-01-24","deleted_at":null,"reminder1_sent":null,"reminder2_sent":null,"reminder3_sent":null,"reminder_last_sent":null,"paid_to_date":"0.000000","subscription_id":null,"hashed_id":"VolejRejNm","client":{"name":"Kilback-Stoltenberg","balance":"0.000000","payment_balance":"0.000000","credit_balance":"2084.140000","vat_number":"428950405","address1":"5 Wallaby Way","address2":"Apt 1","phone":"555 123-1321","city":"Sydney","state":"NSW","postal_code":"2113","country_id":"840","group":"Special Orders Bolts","location":{"location_name":"Billy","address":"44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":"USA"}}},{"id":2,"client_id":1,"user_id":1,"assigned_user_id":null,"company_id":1,"status_id":2,"project_id":null,"vendor_id":null,"recurring_id":null,"design_id":2,"invoice_id":null,"number":"0002","discount":9,"is_amount_discount":true,"po_number":"Omnis.","date":"2025-01-24","last_sent_date":null,"due_date":"2025-02-13","next_send_date":null,"is_deleted":false,"line_items":[{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$935.00","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$0.00","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":935,"tax_amount_raw":0,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"GST","tax_rate1":10,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,028.50","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$93.50","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1028.5,"tax_amount_raw":93.5,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"VAT","tax_rate1":17.5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,098.63","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$163.63","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1098.63,"tax_amount_raw":163.63,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"GST","tax_rate1":10,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,028.50","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$93.50","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1028.5,"tax_amount_raw":93.5,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10}],"backup":null,"footer":null,"public_notes":null,"private_notes":null,"terms":null,"tax_name1":"GST","tax_rate1":"10.000000","tax_name2":"VAT","tax_rate2":"17.500000","tax_name3":"THIRDTAX","tax_rate3":"5.000000","total_taxes":"1381.560000","uses_inclusive_taxes":0,"custom_value1":null,"custom_value2":null,"custom_value3":null,"custom_value4":null,"custom_surcharge1":null,"custom_surcharge2":null,"custom_surcharge3":null,"custom_surcharge4":null,"custom_surcharge_tax1":0,"custom_surcharge_tax2":0,"custom_surcharge_tax3":0,"custom_surcharge_tax4":0,"exchange_rate":"1.000000","amount":"4557.560000","balance":"0.000000","partial":10,"partial_due_date":"2025-02-03","last_viewed":null,"created_at":"2025-01-24","updated_at":"2025-01-24","deleted_at":null,"reminder1_sent":null,"reminder2_sent":null,"reminder3_sent":null,"reminder_last_sent":null,"paid_to_date":"0.000000","subscription_id":null,"hashed_id":"Wpmbk5ezJn","client":{"name":"Kilback-Stoltenberg","balance":"0.000000","payment_balance":"0.000000","credit_balance":"2084.140000","vat_number":"428950405","address1":"5 Wallaby Way","address2":"Apt 1","phone":"555 123-1321","city":"Sydney","state":"NSW","postal_code":"2113","country_id":"840","group":"Special Orders Nuts","location":{"location_name":"Billy","address":"44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":"USA"}}}]';

    public string $expense_data = '[{"category":"Desire","amount":"\u20ac8,00","amount_raw":"8.000000","date":"12\/Jul\/1999","private_notes":"Architecto non voluptatem sit aut rem animi.","public_notes":"Id excepturi eligendi suscipit qui sed aut.","exchange_rate":1,"tax_name1":"GST","tax_rate1":10,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"Quia.","custom_value1":"In culpa.","custom_value2":"Quaerat.","custom_value3":"Provident.","custom_value4":"Nisi.","number":"0001","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]},{"category":"Desire","amount":"\u20ac1,00","amount_raw":"1.000000","date":"29\/Mar\/2022","private_notes":"Ea culpa quaerat eum qui.","public_notes":"Aut quis commodi dolores natus.","exchange_rate":0.31,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"Qui.","custom_value1":"Et.","custom_value2":"Illum.","custom_value3":"Molestiae.","custom_value4":"Odit enim.","number":"0002","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]},{"category":"Fire","amount":"\u20ac8,00","amount_raw":"8.000000","date":"11\/Oct\/1973","private_notes":"Quo necessitatibus inventore quo est.","public_notes":"Nobis ut voluptatem dolorum quia.","exchange_rate":1,"tax_name1":"SG","tax_rate1":-12,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"Ut.","custom_value1":"Minus rem.","custom_value2":"Totam eos.","custom_value3":"Fuga.","custom_value4":"Eligendi.","number":"0003","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]},{"category":"Fuel","amount":"\u20ac2,00","amount_raw":"2.000000","date":"18\/Oct\/1983","private_notes":"Dolorem est et et maiores nesciunt maiores.","public_notes":"Et placeat cumque nemo id nemo quia.","exchange_rate":0.11,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"Vel.","custom_value1":"Possimus.","custom_value2":"Magni.","custom_value3":"Et cumque.","custom_value4":"Nemo.","number":"0004","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]},{"category":"Desire","amount":"\u20ac3,00","amount_raw":"3.000000","date":"31\/May\/2003","private_notes":"Sequi omnis vero doloribus quis dolore ipsam ut.","public_notes":"Laboriosam officiis occaecati quis est.","exchange_rate":0.15,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"At.","custom_value1":"Animi.","custom_value2":"Et magni.","custom_value3":"Et rerum.","custom_value4":"Aliquid.","number":"0005","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]},{"category":"Fire","amount":"\u20ac10,00","amount_raw":"10.000000","date":"31\/Jul\/1978","private_notes":"Voluptatum vel corporis et et.","public_notes":"Deserunt saepe cupiditate est.","exchange_rate":0.4,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"Eos.","custom_value1":"Quia.","custom_value2":"Enim.","custom_value3":"Eos.","custom_value4":"Repellat.","number":"0006","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]},{"category":"Fuel","amount":"\u20ac4,00","amount_raw":"4.000000","date":"12\/Aug\/1993","private_notes":"Ut hic sequi dolore nam nihil.","public_notes":"Maiores ut aut et quae sunt.","exchange_rate":0.29,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"Est.","custom_value1":"Quibusdam.","custom_value2":"Qui ex.","custom_value3":"Doloribus.","custom_value4":"Quibusdam.","number":"0007","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]},{"category":"Desire","amount":"\u20ac7,00","amount_raw":"7.000000","date":"17\/Jul\/2009","private_notes":"Dicta aut quia aut qui eos veniam.","public_notes":"Voluptatibus id esse et illum rerum et sunt.","exchange_rate":1,"tax_name1":"VAT","tax_rate1":17.5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"Et.","custom_value1":"Dolor et.","custom_value2":"Est.","custom_value3":"Suscipit.","custom_value4":"Quos quae.","number":"0008","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]},{"category":"Fuel","amount":"\u20ac7,00","amount_raw":"7.000000","date":"25\/Jun\/1996","private_notes":"Id quia qui sit et hic.","public_notes":"Ut ipsum eos sapiente quos ut et.","exchange_rate":0.27,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"Sunt.","custom_value1":"Voluptas.","custom_value2":"Et.","custom_value3":"Possimus.","custom_value4":"Quo vel.","number":"0009","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]},{"category":"Fire","amount":"\u20ac9,00","amount_raw":"9.000000","date":"10\/Jan\/2023","private_notes":"Vel qui consequatur at ea ab fuga eligendi.","public_notes":"Est voluptate officia ut optio quia ex impedit.","exchange_rate":0.15,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"tax_amount1":1,"tax_amount2":1,"tax_amount3":1,"payment_date":"","transaction_reference":"Eos.","custom_value1":"Tempore.","custom_value2":"Ea.","custom_value3":"Qui vitae.","custom_value4":"Debitis.","number":"0010","calculate_tax_by_amount":false,"uses_inclusive_taxes":false,"client":{"name":"cypress","balance":"6774.280000","address1":"98391","address2":"1509 Carter Roads Apt. 534","phone":"","group":"plans","city":"Ortizville","state":"District of Columbia","postal_code":"03983-7445","country_id":"56","payment_balance":"5000.000000","credit_balance":"71.400000","number":"0006","id_number":"FR026021842983XE2LL87B1E330","vat_number":"BE877543764","currency":"EUR","custom_value1":"1WSw71REgEn1fr3h84OD5FeFDlW30Qrd","custom_value2":"zuqrlW93yxX4K5KmQqOKZMMK8Qs4eS4X","custom_value3":"voluptatem","custom_value4":"hodkiewicz.janis@stoltenberg.org","address":"98391<br\/>1509 Carter Roads Apt. 534<br\/>03983-7445 Ortizville, District of Columbia<br\/>Belgium<br\/>","shipping_address":"75578<br\/>34879 Janie Centers<br\/>East Rylee, Washington 14117-2761<br\/>Afghanistan<br\/>","locale":"en","location":[]},"vendor":[],"project":[],"invoice":[]}]';

    public string $purchase_order_data = '[{"vendor":{"name":"Venny the Vendor","vat_number":"VAT:DE3384577","currency":"USD","group":"Special Orders"},"amount":138944.4,"balance":138944.4,"client":{"name":"John Doe","balance":"538385585.680000","payment_balance":"500.000000","credit_balance":"5635.270000","number":"0009","id_number":"","vat_number":"DE1233211233","currency":"EUR","custom_value1":"tL6BpToNjjjPdSJvZgNfmSYhE1dOzJWn","custom_value2":"lLyXLoVHsQdeSiPQJ8TUgMWyaC2IWSip","custom_value3":"","custom_value4":"","address":"Frau Maria Schmidt<br\/>10115 Bergstra\u00dfe 15, Berlin<br\/>Germany<br\/>","shipping_address":"1341<br\/>Beverly Hills, 143134 90210<br\/>Afghanistan<br\/>","group":"Special Orders","locale":"en","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"status_id":"4","status":"Sent","is_deleted":false,"number":"0004","discount":5,"po_number":"","date":"2. December 2024","last_sent_date":"15. January 2025","next_send_date":"","reminder1_sent":"","reminder2_sent":"","reminder3_sent":"","reminder_last_sent":"","due_date":"","terms":"<p>Delivery within 14 days<\/p>","public_notes":"","private_notes":"","uses_inclusive_taxes":false,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"total_taxes":22184.4,"is_amount_discount":true,"footer":"","partial":0,"partial_due_date":"","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","has_tasks":false,"has_expenses":false,"custom_surcharge1":0,"custom_surcharge2":0,"custom_surcharge3":0,"custom_surcharge4":0,"custom_surcharge_tax1":false,"custom_surcharge_tax2":false,"custom_surcharge_tax3":false,"custom_surcharge_tax4":false,"line_items":[{"_id":"646e91e9-e50e-432b-96f9-e59adf7760d2","quantity":3,"cost":"3.00 USD","product_key":"3","product_cost":"0.00 USD","notes":"Hard drive parts","discount":"0.00 USD","is_amount_discount":true,"tax_name1":"MwSt.","tax_rate1":19,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":"0","line_total":"9.00 USD","tax_amount":"1.71 USD","gross_line_total":"10.71 USD","date":"","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","type_id":"1","tax_id":"1","task_id":"","expense_id":"","unit_code":"C62","net_cost":"0.00 USD","cost_raw":3,"discount_raw":0,"line_total_raw":9,"gross_line_total_raw":10.71,"tax_amount_raw":1.71,"product_cost_raw":0,"net_cost_raw":0,"task":[]},{"_id":"c93ccb03-a91d-4e81-89fc-5a5610d6c5ca","quantity":34,"cost":"3,434.00 USD","product_key":"434","product_cost":"0.00 USD","notes":"Monitor screens","discount":"0.00 USD","is_amount_discount":true,"tax_name1":"MwSt.","tax_rate1":19,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":"0","line_total":"116,756.00 USD","tax_amount":"22,182.69 USD","gross_line_total":"138,938.69 USD","date":"","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","type_id":"1","tax_id":"1","task_id":"","expense_id":"","unit_code":"C62","net_cost":"0.00 USD","cost_raw":3434,"discount_raw":0,"line_total_raw":116756,"gross_line_total_raw":138938.69,"tax_amount_raw":22182.69,"product_cost_raw":0,"net_cost_raw":0,"task":[]}],"exchange_rate":1,"currency_id":""},{"vendor":{"name":"Wagnui","vat_number":"","currency":"AUD"},"amount":444,"balance":888,"client":{"name":"Kilback-Stoltenberg","balance":"0.000000","payment_balance":"0.000000","credit_balance":"2084.140000","vat_number":"428950405","address1":"5 Wallaby Way","address2":"Apt 1","phone":"555 123-1321","city":"Sydney","state":"NSW","postal_code":"2113","country_id":"840","group":"Special Orders","location":{"location_name":"Billy","address":"44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":"USA"}},"status_id":"2","status":"Sent","is_deleted":false,"number":"0005","discount":0,"po_number":"","date":"16. January 2025","last_sent_date":"","next_send_date":"","reminder1_sent":"","reminder2_sent":"","reminder3_sent":"","reminder_last_sent":"","due_date":"","terms":"<p><strong>Terms:<\/strong> This purchase order confirms the agreed terms and pricing for the goods or services listed. Delivery is expected by [delivery date] unless otherwise communicated. Any changes to this order must be approved in writing.<\/p>","public_notes":"","private_notes":"","uses_inclusive_taxes":false,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"total_taxes":0,"is_amount_discount":true,"footer":"<p><strong>Footer:<\/strong> For queries or updates regarding this purchase order, please contact us at [email\/phone number]. Thank you for partnering with [Company Name]. We look forward to fulfilling your order efficiently!<\/p>","partial":0,"partial_due_date":"","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","has_tasks":false,"has_expenses":false,"custom_surcharge1":0,"custom_surcharge2":0,"custom_surcharge3":0,"custom_surcharge4":0,"custom_surcharge_tax1":false,"custom_surcharge_tax2":false,"custom_surcharge_tax3":false,"custom_surcharge_tax4":false,"line_items":[{"_id":"ba30e748-1abf-48cd-9434-6314621634d2","quantity":1,"cost":"444.00 AUD","product_key":"","product_cost":"0.00 AUD","notes":"","discount":"0.00 AUD","is_amount_discount":true,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":"0","line_total":"444.00 AUD","tax_amount":"0.00 AUD","gross_line_total":"444.00 AUD","date":"","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","type_id":"1","tax_id":"1","net_cost":"0.00 AUD","task_id":"","expense_id":"","unit_code":"C62","cost_raw":444,"discount_raw":0,"line_total_raw":444,"gross_line_total_raw":444,"tax_amount_raw":0,"product_cost_raw":0,"net_cost_raw":0,"task":[]}],"exchange_rate":1,"currency_id":""},{"vendor":{"name":"Venny the Vendor","vat_number":"VAT:DE3384577","currency":"USD","group":"Special Orders"},"amount":2711,"balance":5422,"client":{"name":"Kilback-Stoltenberg","balance":"0.000000","payment_balance":"0.000000","credit_balance":"2084.140000","vat_number":"428950405","address1":"5 Wallaby Way","address2":"Apt 1","phone":"555 123-1321","city":"Sydney","state":"NSW","postal_code":"2113","country_id":"840","group":"Special Orders","location":{"location_name":"Billy","address":"44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":"USA"}},"status_id":"2","status":"Sent","is_deleted":false,"number":"0001","discount":0,"po_number":"","date":"24. January 2025","last_sent_date":"","next_send_date":"","reminder1_sent":"","reminder2_sent":"","reminder3_sent":"","reminder_last_sent":"","due_date":"26. January 2025","terms":"<p><strong>Terms:<\/strong> This purchase order confirms the agreed terms and pricing for the goods or services listed. Delivery is expected by [delivery date] unless otherwise communicated. Any changes to this order must be approved in writing.<\/p>","public_notes":"","private_notes":"","uses_inclusive_taxes":false,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"total_taxes":0,"is_amount_discount":true,"footer":"<p><strong>Footer:<\/strong> For queries or updates regarding this purchase order, please contact us at [email\/phone number]. Thank you for partnering with [Company Name]. We look forward to fulfilling your order efficiently!<\/p>","partial":0,"partial_due_date":"","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","has_tasks":false,"has_expenses":false,"custom_surcharge1":0,"custom_surcharge2":0,"custom_surcharge3":0,"custom_surcharge4":0,"custom_surcharge_tax1":false,"custom_surcharge_tax2":false,"custom_surcharge_tax3":false,"custom_surcharge_tax4":false,"line_items":[{"_id":"6462ce8b-6259-48aa-a53b-a82c16a9d349","quantity":1,"cost":"444.00 USD","product_key":"","product_cost":"0.00 USD","notes":"55 NVME drives 4tb","discount":"0.00 USD","is_amount_discount":true,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":"0","line_total":"444.00 USD","tax_amount":"0.00 USD","gross_line_total":"444.00 USD","date":"","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","type_id":"1","tax_id":"1","net_cost":"0.00 USD","task_id":"","expense_id":"","unit_code":"C62","cost_raw":444,"discount_raw":0,"line_total_raw":444,"gross_line_total_raw":444,"tax_amount_raw":0,"product_cost_raw":0,"net_cost_raw":0,"task":[]},{"_id":"071f3468-a525-4522-aeef-f0701773b6ec","quantity":1,"cost":"33.00 USD","product_key":"","product_cost":"0.00 USD","notes":"10 Monitors","discount":"0.00 USD","is_amount_discount":true,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":"0","line_total":"33.00 USD","tax_amount":"0.00 USD","gross_line_total":"33.00 USD","date":"","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","type_id":"1","tax_id":"1","net_cost":"0.00 USD","task_id":"","expense_id":"","unit_code":"C62","cost_raw":33,"discount_raw":0,"line_total_raw":33,"gross_line_total_raw":33,"tax_amount_raw":0,"product_cost_raw":0,"net_cost_raw":0,"task":[]},{"_id":"329f259e-cea3-4135-9453-03338e2b5094","quantity":1,"cost":"2,234.00 USD","product_key":"","product_cost":"0.00 USD","notes":"20 CPUs","discount":"0.00 USD","is_amount_discount":true,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":"0","line_total":"2,234.00 USD","tax_amount":"0.00 USD","gross_line_total":"2,234.00 USD","date":"","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","type_id":"1","tax_id":"1","net_cost":"0.00 USD","task_id":"","expense_id":"","unit_code":"C62","cost_raw":2234,"discount_raw":0,"line_total_raw":2234,"gross_line_total_raw":2234,"tax_amount_raw":0,"product_cost_raw":0,"net_cost_raw":0,"task":[]}],"exchange_rate":1,"currency_id":""}]';

    public string $payment_data = '[{"status":"Refunded","badge":"<h6><span class=\"badge badge-primary\">Refunded<\/span><\/h6>","amount":"$6,077.51","applied":"$6,077.51","balance":"-$6,077.51","refunded":"$6,077.51","amount_raw":"6077.510000","applied_raw":"6077.510000","refunded_raw":"6077.510000","balance_raw":-6077.51,"date":"30\/Sep\/2023","method":"EuroCard","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0001","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"cypress","balance":"0.000000","payment_balance":"0.000000","credit_balance":"11661.820000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0019","amount_raw":"6077.5100","refunded_raw":"6077.5100","net_raw":0,"amount":"$6,077.51","refunded":"$6,077.51","net":"$0.00","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696150843}]},{"status":"Refunded","badge":"<h6><span class=\"badge badge-primary\">Refunded<\/span><\/h6>","amount":"$4,090.64","applied":"$4,090.64","balance":"-$4,090.64","refunded":"$4,090.64","amount_raw":"4090.640000","applied_raw":"4090.640000","refunded_raw":"4090.640000","balance_raw":-4090.64,"date":"30\/Sep\/2023","method":"Discover Card","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0002","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"cypress","balance":"0.000000","payment_balance":"0.000000","credit_balance":"11661.820000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0020","amount_raw":"4090.6400","refunded_raw":"4090.6400","net_raw":0,"amount":"$4,090.64","refunded":"$4,090.64","net":"$0.00","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696150843}]},{"status":"Refunded","badge":"<h6><span class=\"badge badge-primary\">Refunded<\/span><\/h6>","amount":"$2,197.26","applied":"$2,197.26","balance":"-$2,197.26","refunded":"$2,197.26","amount_raw":"2197.260000","applied_raw":"2197.260000","refunded_raw":"2197.260000","balance_raw":-2197.26,"date":"30\/Sep\/2023","method":"Diners Card","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0003","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"Jakubowski Group","balance":"28296.170000","payment_balance":"0.000000","credit_balance":"1084.840000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0021","amount_raw":"2197.2600","refunded_raw":"2197.2600","net_raw":0,"amount":"$2,197.26","refunded":"$2,197.26","net":"$0.00","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696150843}]},{"status":"Partially Refunded","badge":"<h6><span class=\"badge badge-success\">Partially Refunded<\/span><\/h6>","amount":"$4,955.50","applied":"$4,955.50","balance":"-$66.00","refunded":"$66.00","amount_raw":"4955.500000","applied_raw":"4955.500000","refunded_raw":"66.000000","balance_raw":-66,"date":"30\/Sep\/2023","method":"Maestro","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0004","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"Jakubowski Group","balance":"28296.170000","payment_balance":"0.000000","credit_balance":"1084.840000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0022","amount_raw":"4955.5000","refunded_raw":"66.0000","net_raw":4889.5,"amount":"$4,955.50","refunded":"$66.00","net":"$4,889.50","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696150843}]},{"status":"Partially Refunded","badge":"<h6><span class=\"badge badge-success\">Partially Refunded<\/span><\/h6>","amount":"$2,290.75","applied":"$2,290.75","balance":"-$34.00","refunded":"$34.00","amount_raw":"2290.750000","applied_raw":"2290.750000","refunded_raw":"34.000000","balance_raw":-34,"date":"30\/Sep\/2023","method":"Diners Card","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0005","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"Jakubowski Group","balance":"28296.170000","payment_balance":"0.000000","credit_balance":"1084.840000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0023","amount_raw":"2290.7500","refunded_raw":"34.0000","net_raw":2256.75,"amount":"$2,290.75","refunded":"$34.00","net":"$2,256.75","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696150843}]},{"status":"Partially Refunded","badge":"<h6><span class=\"badge badge-success\">Partially Refunded<\/span><\/h6>","amount":"$6,802.13","applied":"$6,802.13","balance":"-$444.00","refunded":"$444.00","amount_raw":"6802.130000","applied_raw":"6802.130000","refunded_raw":"444.000000","balance_raw":-444,"date":"30\/Sep\/2023","method":"Maestro","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0006","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"Jakubowski Group","balance":"28296.170000","payment_balance":"0.000000","credit_balance":"1084.840000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0024","amount_raw":"6802.1300","refunded_raw":"444.0000","net_raw":6358.13,"amount":"$6,802.13","refunded":"$444.00","net":"$6,358.13","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696150843}]},{"status":"Partially Refunded","badge":"<h6><span class=\"badge badge-success\">Partially Refunded<\/span><\/h6>","amount":"$10,986.26","applied":"$10,986.26","balance":"-$146.26","refunded":"$146.26","amount_raw":"10986.260000","applied_raw":"10986.260000","refunded_raw":"146.260000","balance_raw":-146.26000000000022,"date":"30\/Sep\/2023","method":"UnionPay","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0007","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"Jakubowski Group","balance":"28296.170000","payment_balance":"0.000000","credit_balance":"1084.840000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0025","amount_raw":"10986.2600","refunded_raw":"146.2600","net_raw":10840,"amount":"$10,986.26","refunded":"$146.26","net":"$10,840.00","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696150843}]},{"status":"Completed","badge":"<h6><span class=\"badge badge-info\">Completed<\/span><\/h6>","amount":"$6,054.13","applied":"$6,054.13","balance":"$0.00","refunded":"$0.00","amount_raw":"6054.130000","applied_raw":"6054.130000","refunded_raw":"0.000000","balance_raw":0,"date":"30\/Sep\/2023","method":"","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0008","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"Lowe-Paucek","balance":"38124.670000","payment_balance":"0.000000","credit_balance":"2270.590000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0015","amount_raw":"6054.1300","refunded_raw":"0.0000","net_raw":6054.13,"amount":"$6,054.13","refunded":"$0.00","net":"$6,054.13","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696151008}]},{"status":"Completed","badge":"<h6><span class=\"badge badge-info\">Completed<\/span><\/h6>","amount":"$3,132.25","applied":"$3,132.25","balance":"$0.00","refunded":"$0.00","amount_raw":"3132.250000","applied_raw":"3132.250000","refunded_raw":"0.000000","balance_raw":0,"date":"30\/Sep\/2023","method":"","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0009","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"cypress","balance":"0.000000","payment_balance":"0.000000","credit_balance":"11661.820000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0016","amount_raw":"3132.2500","refunded_raw":"0.0000","net_raw":3132.25,"amount":"$3,132.25","refunded":"$0.00","net":"$3,132.25","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696151008}]},{"status":"Completed","badge":"<h6><span class=\"badge badge-info\">Completed<\/span><\/h6>","amount":"$9,396.77","applied":"$9,396.77","balance":"$0.00","refunded":"$0.00","amount_raw":"9396.770000","applied_raw":"9396.770000","refunded_raw":"0.000000","balance_raw":0,"date":"30\/Sep\/2023","method":"","currency":"USD","exchange_rate":1,"transaction_reference":"Manual entry","is_manual":1,"number":"0010","custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","client":{"name":"cypress","balance":"0.000000","payment_balance":"0.000000","credit_balance":"11661.820000","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"paymentables":[{"invoice":"0017","amount_raw":"9396.7700","refunded_raw":"0.0000","net_raw":9396.77,"amount":"$9,396.77","refunded":"$0.00","net":"$9,396.77","is_credit":false,"created_at":"01\/Oct\/2023","updated_at":"01\/Oct\/2023","timestamp":1696151008}]}]';

    public string $project_data = '[{"name":"Haleigh Mills","number":"0001","created_at":"01\/Aug\/2024","updated_at":"02\/Aug\/2024","task_rate":"$102.00","task_rate_raw":"102.000000","due_date":"12\/Aug\/2024","private_notes":"","public_notes":"Quisquam adipisci animi ex.","budgeted_hours":970,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":148,"tasks":[{"number":"0002","description":"Culpa sequi est enim minus dignissimos. Nisi dignissimos amet nobis beatae ducimus consequatur magnam. Non ut praesentium delectus autem aliquid minima.","duration":401319,"rate":"$143.00","rate_raw":"143.000000","created_at":"01\/Aug\/2024","updated_at":"02\/Aug\/2024","date":"01\/Aug\/2024","project":[],"time_log":[{"start_date_raw":1722560932,"start_date":"01\/Aug\/2024 14:08:52","end_date_raw":1722594811,"end_date":"01\/Aug\/2024 23:33:31","description":"Eos perferendis harum consequuntur neque.","billable":true,"duration_raw":33879,"duration":"09:24:39"},{"start_date_raw":1722595111,"start_date":"01\/Aug\/2024 23:38:31","end_date_raw":1722670240,"end_date":"02\/Aug\/2024 20:30:40","description":"Saepe ut iste id.","billable":false,"duration_raw":75129,"duration":"20:52:09"},{"start_date_raw":1722670540,"start_date":"02\/Aug\/2024 20:35:40","end_date_raw":1722739180,"end_date":"03\/Aug\/2024 15:39:40","description":"Ea reiciendis voluptatum necessitatibus alias tempora debitis eligendi.","billable":true,"duration_raw":68640,"duration":"19:04:00"},{"start_date_raw":1722739480,"start_date":"03\/Aug\/2024 15:44:40","end_date_raw":1722811869,"end_date":"04\/Aug\/2024 11:51:09","description":"Aut molestiae nisi beatae reprehenderit.","billable":false,"duration_raw":72389,"duration":"20:06:29"},{"start_date_raw":1722812169,"start_date":"04\/Aug\/2024 11:56:09","end_date_raw":1722885015,"end_date":"05\/Aug\/2024 08:10:15","description":"Dignissimos deleniti dolor consectetur fugiat necessitatibus asperiores.","billable":false,"duration_raw":72846,"duration":"20:14:06"},{"start_date_raw":1722885315,"start_date":"05\/Aug\/2024 08:15:15","end_date_raw":1722963751,"end_date":"06\/Aug\/2024 06:02:31","description":"Id repellat consectetur pariatur eaque et exercitationem facere quia.","billable":false,"duration_raw":78436,"duration":"21:47:16"}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Done","user":{"name":"Sven Schuster Concepcion Runolfsdottir PhD","email":"small@example.com"},"client":{"name":"Turcotte, Tromp and Hickle","balance":"3333.000000","payment_balance":"0.000000","credit_balance":"331.990000","vat_number":"455233120","currency":"CAD","custom_value1":"2019-10-29 09:56:21","custom_value2":"Indigo","custom_value3":"laboriosam","custom_value4":"hjones@windler.com","address":"47072<br\/>8227 Hoeger Prairie Suite 088<br\/>Dinatown, Idaho 92489<br\/>Canada<br\/>","shipping_address":"48390<br\/>661 Cremin Meadow Suite 797<br\/>Lake Eriberto, Pennsylvania 50868-8763<br\/>Afghanistan<br\/>","group":"Special Orders","locale":"en"}},{"number":"0003","description":"Hic reprehenderit sed eum et porro. Nesciunt aperiam quia voluptatem inventore ut. Iste corrupti qui dolor ipsam ut.","duration":132254,"rate":"$19.00","rate_raw":"19.000000","created_at":"01\/Aug\/2024","updated_at":"02\/Aug\/2024","date":"31\/Jul\/2024","project":[],"time_log":[{"start_date_raw":1722479429,"start_date":"31\/Jul\/2024 15:30:29","end_date_raw":1722496601,"end_date":"31\/Jul\/2024 20:16:41","description":"Sit voluptas explicabo tempora nesciunt architecto et.","billable":true,"duration_raw":17172,"duration":"04:46:12"},{"start_date_raw":1722496901,"start_date":"31\/Jul\/2024 20:21:41","end_date_raw":1722519879,"end_date":"01\/Aug\/2024 02:44:39","description":"Atque laborum qui praesentium fuga.","billable":true,"duration_raw":22978,"duration":"06:22:58"},{"start_date_raw":1722520179,"start_date":"01\/Aug\/2024 02:49:39","end_date_raw":1722536827,"end_date":"01\/Aug\/2024 07:27:07","description":"Tempore sed quae voluptates officiis doloremque sit ex.","billable":true,"duration_raw":16648,"duration":"04:37:28"},{"start_date_raw":1722537127,"start_date":"01\/Aug\/2024 07:32:07","end_date_raw":1722612560,"end_date":"02\/Aug\/2024 04:29:20","description":"In aut similique quidem aut sit provident.","billable":true,"duration_raw":75433,"duration":"20:57:13"},{"start_date_raw":1722634488,"start_date":"02\/Aug\/2024 10:34:48","end_date_raw":1722634511,"end_date":"02\/Aug\/2024 10:35:11","description":"","billable":false,"duration_raw":23,"duration":"00:00:23"}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Ready to do","user":{"name":"Sven Schuster Concepcion Runolfsdottir PhD","email":"small@example.com"},"client":{"name":"Turcotte, Tromp and Hickle","balance":"3333.000000","payment_balance":"0.000000","credit_balance":"331.990000","vat_number":"455233120","currency":"CAD","custom_value1":"2019-10-29 09:56:21","custom_value2":"Indigo","custom_value3":"laboriosam","custom_value4":"hjones@windler.com","address":"47072<br\/>8227 Hoeger Prairie Suite 088<br\/>Dinatown, Idaho 92489<br\/>Canada<br\/>","shipping_address":"48390<br\/>661 Cremin Meadow Suite 797<br\/>Lake Eriberto, Pennsylvania 50868-8763<br\/>Afghanistan<br\/>","group":"Special Orders","locale":"en"}}],"client":{"name":"Turcotte, Tromp and Hickle","balance":"3333.000000","payment_balance":"0.000000","credit_balance":"331.990000","vat_number":"455233120","currency":"CAD","custom_value1":"2019-10-29 09:56:21","custom_value2":"Indigo","custom_value3":"laboriosam","custom_value4":"hjones@windler.com","address":"47072<br\/>8227 Hoeger Prairie Suite 088<br\/>Dinatown, Idaho 92489<br\/>Canada<br\/>","shipping_address":"48390<br\/>661 Cremin Meadow Suite 797<br\/>Lake Eriberto, Pennsylvania 50868-8763<br\/>Afghanistan<br\/>","group":"Special Orders","locale":"en","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}},"user":{"name":"Sven Schuster Concepcion Runolfsdottir PhD","email":"small@example.com"},"invoices":[]}]';

    public string $task_data = '[{"number":"0001","description":"Reiciendis itaque molestias blanditiis cupiditate ea. Minus officiis natus itaque. Consectetur et aut veritatis quae ut esse ut. Accusantium dolore quaerat sit qui. Magni quia sunt corporis.","duration":149031,"rate":"$71.00","rate_raw":"71.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":[],"time_log":[{"start_date_raw":1700428466,"start_date":"19\/Nov\/2023 21:11:26","end_date_raw":1700470150,"end_date":"20\/Nov\/2023 08:11:10","description":"Assumenda nihil vitae odio voluptatem iusto ipsam repellendus.","billable":false,"duration":41684},{"start_date_raw":1700470450,"start_date":"20\/Nov\/2023 08:11:10","end_date_raw":1700485036,"end_date":"20\/Nov\/2023 12:11:16","description":"Adipisci amet optio tempore et.","billable":true,"duration":14586},{"start_date_raw":1700485336,"start_date":"20\/Nov\/2023 13:11:16","end_date_raw":1700572291,"end_date":"21\/Nov\/2023 13:11:31","description":"Ratione repellat saepe mollitia perspiciatis optio.","billable":false,"duration":86955},{"start_date_raw":1700572591,"start_date":"21\/Nov\/2023 13:11:31","end_date_raw":1700578397,"end_date":"21\/Nov\/2023 14:11:17","description":"Molestias perferendis ipsa odit id aut sunt.","billable":true,"duration":5806}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Done","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Medhurst Inc","balance":"37633.780000","payment_balance":"0.000000","credit_balance":"1025.100000","vat_number":"VAT123","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0002","description":"Et dolorem nihil qui quas asperiores nulla aut praesentium. Ea quasi porro facere eligendi. Et assumenda illum nostrum natus repellat eveniet. Sequi odio nulla perspiciatis doloremque.","duration":966982,"rate":"$76.00","rate_raw":"76.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Abel Moore","number":"0001","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$107.00","task_rate_raw":"107.000000","due_date":"25\/Nov\/2023","private_notes":"","public_notes":"Omnis modi optio maxime ut inventore.","budgeted_hours":339,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":390,"tasks":[],"client":{"name":"Hoeger, Hahn and Cole","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1022.550000","vat_number":"VAT123","currency":"USD","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428466,"start_date":"19\/Nov\/2023 21:11:26","end_date_raw":1700492035,"end_date":"20\/Nov\/2023 14:11:55","description":"Nihil voluptas et sint et.","billable":true,"duration":63569},{"start_date_raw":1700492335,"start_date":"20\/Nov\/2023 14:11:55","end_date_raw":1700554011,"end_date":"21\/Nov\/2023 08:11:51","description":"Aut consequuntur aliquam earum aut reiciendis.","billable":false,"duration":61676},{"start_date_raw":1700554311,"start_date":"21\/Nov\/2023 08:11:51","end_date_raw":1700586651,"end_date":"21\/Nov\/2023 17:11:51","description":"Occaecati consectetur temporibus neque rerum sed rem iure.","billable":true,"duration":32340},{"start_date_raw":1700586951,"start_date":"21\/Nov\/2023 17:11:51","end_date_raw":1700644903,"end_date":"22\/Nov\/2023 09:11:43","description":"Ducimus voluptate aliquid aliquam nobis.","billable":true,"duration":57952},{"start_date_raw":1700645203,"start_date":"22\/Nov\/2023 09:11:43","end_date_raw":1700724132,"end_date":"23\/Nov\/2023 07:11:12","description":"Non ipsam consequatur voluptatem illum.","billable":true,"duration":78929},{"start_date_raw":1700724432,"start_date":"23\/Nov\/2023 07:11:12","end_date_raw":1700790596,"end_date":"24\/Nov\/2023 01:11:56","description":"Aspernatur quia voluptate molestias non.","billable":false,"duration":66164},{"start_date_raw":1700790896,"start_date":"24\/Nov\/2023 01:11:56","end_date_raw":1700812808,"end_date":"24\/Nov\/2023 08:11:08","description":"Sed quod omnis officiis asperiores natus facere minus nemo.","billable":false,"duration":21912},{"start_date_raw":1700813108,"start_date":"24\/Nov\/2023 08:11:08","end_date_raw":1700865275,"end_date":"24\/Nov\/2023 22:11:35","description":"Tenetur quaerat ea magni placeat.","billable":false,"duration":52167},{"start_date_raw":1700865575,"start_date":"24\/Nov\/2023 22:11:35","end_date_raw":1700888516,"end_date":"25\/Nov\/2023 05:11:56","description":"Sequi dolor laborum deserunt rerum.","billable":true,"duration":22941},{"start_date_raw":1700888816,"start_date":"25\/Nov\/2023 05:11:56","end_date_raw":1700933259,"end_date":"25\/Nov\/2023 17:11:39","description":"Est qui velit ipsum et nesciunt qui ut.","billable":true,"duration":44443},{"start_date_raw":1700933559,"start_date":"25\/Nov\/2023 17:11:39","end_date_raw":1700979107,"end_date":"26\/Nov\/2023 06:11:47","description":"Sint et quo quo.","billable":false,"duration":45548},{"start_date_raw":1700979407,"start_date":"26\/Nov\/2023 06:11:47","end_date_raw":1701002669,"end_date":"26\/Nov\/2023 12:11:29","description":"Omnis unde sit similique dolor fugit totam.","billable":true,"duration":23262},{"start_date_raw":1701002969,"start_date":"26\/Nov\/2023 12:11:29","end_date_raw":1701071339,"end_date":"27\/Nov\/2023 07:11:59","description":"Ducimus qui voluptas accusamus.","billable":true,"duration":68370},{"start_date_raw":1701071639,"start_date":"27\/Nov\/2023 07:11:59","end_date_raw":1701100825,"end_date":"27\/Nov\/2023 16:11:25","description":"Soluta sit non nobis ab et ad libero sint.","billable":false,"duration":29186},{"start_date_raw":1701101125,"start_date":"27\/Nov\/2023 16:11:25","end_date_raw":1701157799,"end_date":"28\/Nov\/2023 07:11:59","description":"Cumque dignissimos error qui ut.","billable":true,"duration":56674},{"start_date_raw":1701158099,"start_date":"28\/Nov\/2023 07:11:59","end_date_raw":1701214020,"end_date":"28\/Nov\/2023 23:11:00","description":"Molestias omnis aliquid voluptatem cupiditate ut.","billable":true,"duration":55921},{"start_date_raw":1701214320,"start_date":"28\/Nov\/2023 23:11:00","end_date_raw":1701286375,"end_date":"29\/Nov\/2023 19:11:55","description":"Distinctio commodi est ab.","billable":true,"duration":72055},{"start_date_raw":1701286675,"start_date":"29\/Nov\/2023 19:11:55","end_date_raw":1701330081,"end_date":"30\/Nov\/2023 07:11:21","description":"Nisi dolores omnis veritatis.","billable":false,"duration":43406},{"start_date_raw":1701330381,"start_date":"30\/Nov\/2023 07:11:21","end_date_raw":1701398228,"end_date":"01\/Dec\/2023 02:12:08","description":"Qui aut velit quam dolore qui asperiores.","billable":false,"duration":67847},{"start_date_raw":1701398528,"start_date":"01\/Dec\/2023 02:12:08","end_date_raw":1701401148,"end_date":"01\/Dec\/2023 03:12:48","description":"Laudantium est laudantium ea ut repellendus.","billable":true,"duration":2620}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Backlog","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Hoeger, Hahn and Cole","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1022.550000","vat_number":"VAT123","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0003","description":"Qui excepturi et aut et voluptates eius perferendis. Repellat eum illo quis aliquid occaecati reprehenderit officia. Est earum nihil similique recusandae aut ut est error. Enim molestiae assumenda quaerat neque unde. Consequatur vel placeat commodi molestiae.","duration":259657,"rate":"$9.00","rate_raw":"9.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Abel Moore","number":"0001","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$107.00","task_rate_raw":"107.000000","due_date":"25\/Nov\/2023","private_notes":"","public_notes":"Omnis modi optio maxime ut inventore.","budgeted_hours":339,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":390,"tasks":[],"client":{"name":"Hoeger, Hahn and Cole","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1022.550000","vat_number":"VAT123","currency":"USD","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428466,"start_date":"19\/Nov\/2023 21:11:26","end_date_raw":1700498928,"end_date":"20\/Nov\/2023 16:11:48","description":"Animi asperiores velit quaerat sapiente dolorem officiis.","billable":false,"duration":70462},{"start_date_raw":1700499228,"start_date":"20\/Nov\/2023 16:11:48","end_date_raw":1700516753,"end_date":"20\/Nov\/2023 21:11:53","description":"Et facere ut tempora similique et sunt culpa.","billable":false,"duration":17525},{"start_date_raw":1700517053,"start_date":"20\/Nov\/2023 21:11:53","end_date_raw":1700523921,"end_date":"20\/Nov\/2023 23:11:21","description":"Consequatur enim non reprehenderit quia.","billable":false,"duration":6868},{"start_date_raw":1700524221,"start_date":"20\/Nov\/2023 23:11:21","end_date_raw":1700609374,"end_date":"21\/Nov\/2023 23:11:34","description":"Nobis non nesciunt ut reprehenderit at.","billable":false,"duration":85153},{"start_date_raw":1700609674,"start_date":"21\/Nov\/2023 23:11:34","end_date_raw":1700689323,"end_date":"22\/Nov\/2023 21:11:03","description":"Blanditiis repellendus quo voluptatum eveniet iste.","billable":false,"duration":79649}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Ready to do","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Hoeger, Hahn and Cole","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1022.550000","vat_number":"VAT123","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0004","description":"Ipsam tempora id vero perferendis. Nulla laudantium iste qui quod et voluptatem. Aliquam et vel est minus ratione.","duration":179131,"rate":"$146.00","rate_raw":"146.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Abel Moore","number":"0001","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$107.00","task_rate_raw":"107.000000","due_date":"25\/Nov\/2023","private_notes":"","public_notes":"Omnis modi optio maxime ut inventore.","budgeted_hours":339,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":390,"tasks":[],"client":{"name":"Hoeger, Hahn and Cole","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1022.550000","vat_number":"VAT123","currency":"USD","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428466,"start_date":"19\/Nov\/2023 21:11:26","end_date_raw":1700446786,"end_date":"20\/Nov\/2023 02:11:46","description":"Ipsam voluptatum sed officiis eos quo.","billable":true,"duration":18320},{"start_date_raw":1700447086,"start_date":"20\/Nov\/2023 02:11:46","end_date_raw":1700520087,"end_date":"20\/Nov\/2023 22:11:27","description":"Et maxime rem provident veritatis.","billable":true,"duration":73001},{"start_date_raw":1700520387,"start_date":"20\/Nov\/2023 22:11:27","end_date_raw":1700603783,"end_date":"21\/Nov\/2023 21:11:23","description":"Deserunt soluta dolorem harum voluptas necessitatibus eum laborum omnis.","billable":false,"duration":83396},{"start_date_raw":1700604083,"start_date":"21\/Nov\/2023 22:11:23","end_date_raw":1700608497,"end_date":"21\/Nov\/2023 23:11:57","description":"Esse et aperiam nobis dolor voluptas.","billable":true,"duration":4414}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Backlog","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Hoeger, Hahn and Cole","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1022.550000","vat_number":"VAT123","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0005","description":"Enim fugiat at excepturi voluptate debitis ea. Hic officiis quaerat molestiae ullam minus consequuntur ut. Officiis quas consequatur error quae eveniet. Dolorum aliquam provident aperiam asperiores alias modi quae a.","duration":3230,"rate":"$78.00","rate_raw":"78.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":[],"time_log":[{"start_date_raw":1700428467,"start_date":"19\/Nov\/2023 21:11:27","end_date_raw":1700431697,"end_date":"19\/Nov\/2023 22:11:17","description":"Repudiandae nam et consequatur consequatur.","billable":false,"duration":3230}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Done","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Schroeder-Beahan","balance":"60576.340000","payment_balance":"0.000000","credit_balance":"0.000000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0006","description":"Dolor quidem aperiam rerum. Voluptates aut vel ut consequatur. Nam et unde cupiditate qui voluptates voluptatum. Temporibus assumenda enim nam neque.","duration":156986,"rate":"$92.00","rate_raw":"92.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Prof. Noah Jaskolski II","number":"0002","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$52.00","task_rate_raw":"52.000000","due_date":"25\/Nov\/2023","private_notes":"","public_notes":"Mollitia ut vel quam. Quia et aut minus.","budgeted_hours":660,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":57,"tasks":[],"client":{"name":"cypress","balance":"13866.150000","payment_balance":"0.000000","credit_balance":"1013.630000","currency":"USD","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428467,"start_date":"19\/Nov\/2023 21:11:27","end_date_raw":1700443047,"end_date":"20\/Nov\/2023 01:11:27","description":"Unde sequi dicta corporis odio.","billable":true,"duration":14580},{"start_date_raw":1700443347,"start_date":"20\/Nov\/2023 01:11:27","end_date_raw":1700489146,"end_date":"20\/Nov\/2023 14:11:46","description":"Qui rem id inventore velit corporis vitae.","billable":false,"duration":45799},{"start_date_raw":1700489446,"start_date":"20\/Nov\/2023 14:11:46","end_date_raw":1700514655,"end_date":"20\/Nov\/2023 21:11:55","description":"Rerum repellat unde et blanditiis sunt animi aliquid accusantium.","billable":false,"duration":25209},{"start_date_raw":1700514955,"start_date":"20\/Nov\/2023 21:11:55","end_date_raw":1700515449,"end_date":"20\/Nov\/2023 21:11:09","description":"Quasi velit sit et explicabo quibusdam nam.","billable":true,"duration":494},{"start_date_raw":1700515749,"start_date":"20\/Nov\/2023 21:11:09","end_date_raw":1700586653,"end_date":"21\/Nov\/2023 17:11:53","description":"Numquam eos aut eum est corrupti dolorem et.","billable":false,"duration":70904}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Ready to do","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"cypress","balance":"13866.150000","payment_balance":"0.000000","credit_balance":"1013.630000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0007","description":"Omnis totam eum sed dolores quod rerum. Ducimus voluptate iste quia dolorum consequatur sint. Velit vitae sint qui molestias. Dolores ea rerum voluptates iusto qui natus beatae.","duration":47670,"rate":"$88.00","rate_raw":"88.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Prof. Noah Jaskolski II","number":"0002","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$52.00","task_rate_raw":"52.000000","due_date":"25\/Nov\/2023","private_notes":"","public_notes":"Mollitia ut vel quam. Quia et aut minus.","budgeted_hours":660,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":57,"tasks":[],"client":{"name":"cypress","balance":"13866.150000","payment_balance":"0.000000","credit_balance":"1013.630000","currency":"USD","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428467,"start_date":"19\/Nov\/2023 21:11:27","end_date_raw":1700476137,"end_date":"20\/Nov\/2023 10:11:57","description":"Sint laudantium quia eveniet quod nobis occaecati nihil.","billable":false,"duration":47670}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Backlog","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"cypress","balance":"13866.150000","payment_balance":"0.000000","credit_balance":"1013.630000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0008","description":"Molestiae dolor explicabo et in commodi eveniet. Expedita voluptatibus nihil ut. Et porro cumque nisi omnis maxime accusantium earum.","duration":638322,"rate":"$130.00","rate_raw":"130.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":[],"time_log":[{"start_date_raw":1700428468,"start_date":"19\/Nov\/2023 21:11:28","end_date_raw":1700504838,"end_date":"20\/Nov\/2023 18:11:18","description":"Delectus consequatur esse quaerat vel.","billable":false,"duration":76370},{"start_date_raw":1700505138,"start_date":"20\/Nov\/2023 18:11:18","end_date_raw":1700579924,"end_date":"21\/Nov\/2023 15:11:44","description":"Eveniet culpa qui quo architecto recusandae ut occaecati aut.","billable":true,"duration":74786},{"start_date_raw":1700580224,"start_date":"21\/Nov\/2023 15:11:44","end_date_raw":1700646586,"end_date":"22\/Nov\/2023 09:11:46","description":"Delectus quia officiis vero quia corporis.","billable":true,"duration":66362},{"start_date_raw":1700646886,"start_date":"22\/Nov\/2023 09:11:46","end_date_raw":1700732597,"end_date":"23\/Nov\/2023 09:11:17","description":"Non ut placeat dolorum et.","billable":true,"duration":85711},{"start_date_raw":1700732897,"start_date":"23\/Nov\/2023 09:11:17","end_date_raw":1700740803,"end_date":"23\/Nov\/2023 12:11:03","description":"Numquam natus accusantium voluptatem aliquam maxime fugiat voluptatem.","billable":true,"duration":7906},{"start_date_raw":1700741103,"start_date":"23\/Nov\/2023 12:11:03","end_date_raw":1700807283,"end_date":"24\/Nov\/2023 06:11:03","description":"Quae est ut optio atque fugit non.","billable":false,"duration":66180},{"start_date_raw":1700807583,"start_date":"24\/Nov\/2023 06:11:03","end_date_raw":1700889007,"end_date":"25\/Nov\/2023 05:11:07","description":"Natus voluptas quo id nam iure neque eveniet id.","billable":false,"duration":81424},{"start_date_raw":1700889307,"start_date":"25\/Nov\/2023 05:11:07","end_date_raw":1700949728,"end_date":"25\/Nov\/2023 22:11:08","description":"Sed suscipit voluptatem officia reprehenderit qui occaecati saepe veniam.","billable":false,"duration":60421},{"start_date_raw":1700950028,"start_date":"25\/Nov\/2023 22:11:08","end_date_raw":1700972964,"end_date":"26\/Nov\/2023 04:11:24","description":"Officiis sequi aut natus sapiente.","billable":true,"duration":22936},{"start_date_raw":1700973264,"start_date":"26\/Nov\/2023 04:11:24","end_date_raw":1700986155,"end_date":"26\/Nov\/2023 08:11:15","description":"Et similique odit quasi eaque harum.","billable":false,"duration":12891},{"start_date_raw":1700986455,"start_date":"26\/Nov\/2023 08:11:15","end_date_raw":1701069790,"end_date":"27\/Nov\/2023 07:11:10","description":"Qui magnam vero unde nam dolorem qui.","billable":true,"duration":83335}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Ready to do","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Medhurst Inc","balance":"37633.780000","payment_balance":"0.000000","credit_balance":"1025.100000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0009","description":"Ipsam numquam nesciunt corporis veritatis vitae porro maiores. Delectus sit itaque dolores. Atque et dolorem nisi est.","duration":439161,"rate":"$120.00","rate_raw":"120.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Mr. Easton Streich","number":"0003","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$153.00","task_rate_raw":"153.000000","due_date":"28\/Nov\/2023","private_notes":"","public_notes":"Debitis sit ut voluptatem eaque veritatis.","budgeted_hours":216,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":496,"tasks":[],"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428468,"start_date":"19\/Nov\/2023 21:11:28","end_date_raw":1700434593,"end_date":"19\/Nov\/2023 22:11:33","description":"At unde dolores quasi quia.","billable":true,"duration":6125},{"start_date_raw":1700434893,"start_date":"19\/Nov\/2023 23:11:33","end_date_raw":1700498703,"end_date":"20\/Nov\/2023 16:11:03","description":"Et quae non voluptatum nam quia velit suscipit.","billable":false,"duration":63810},{"start_date_raw":1700499003,"start_date":"20\/Nov\/2023 16:11:03","end_date_raw":1700548104,"end_date":"21\/Nov\/2023 06:11:24","description":"Quidem delectus sed et.","billable":true,"duration":49101},{"start_date_raw":1700548404,"start_date":"21\/Nov\/2023 06:11:24","end_date_raw":1700629022,"end_date":"22\/Nov\/2023 04:11:02","description":"Soluta velit enim explicabo dolorem commodi.","billable":false,"duration":80618},{"start_date_raw":1700629322,"start_date":"22\/Nov\/2023 05:11:02","end_date_raw":1700647716,"end_date":"22\/Nov\/2023 10:11:36","description":"Est magni qui quis.","billable":false,"duration":18394},{"start_date_raw":1700648016,"start_date":"22\/Nov\/2023 10:11:36","end_date_raw":1700731147,"end_date":"23\/Nov\/2023 09:11:07","description":"Saepe aspernatur non molestias dolor ea quos in.","billable":false,"duration":83131},{"start_date_raw":1700731447,"start_date":"23\/Nov\/2023 09:11:07","end_date_raw":1700782753,"end_date":"23\/Nov\/2023 23:11:13","description":"Alias id nihil laboriosam aliquam odio qui excepturi.","billable":true,"duration":51306},{"start_date_raw":1700783053,"start_date":"23\/Nov\/2023 23:11:13","end_date_raw":1700795456,"end_date":"24\/Nov\/2023 03:11:56","description":"Eos numquam et atque quia a qui nesciunt.","billable":false,"duration":12403},{"start_date_raw":1700795756,"start_date":"24\/Nov\/2023 03:11:56","end_date_raw":1700812488,"end_date":"24\/Nov\/2023 07:11:48","description":"Ut voluptas in natus qui.","billable":false,"duration":16732},{"start_date_raw":1700812788,"start_date":"24\/Nov\/2023 07:11:48","end_date_raw":1700842826,"end_date":"24\/Nov\/2023 16:11:26","description":"Est aut magnam ratione.","billable":false,"duration":30038},{"start_date_raw":1700843126,"start_date":"24\/Nov\/2023 16:11:26","end_date_raw":1700870629,"end_date":"25\/Nov\/2023 00:11:49","description":"Exercitationem non odio quasi ut saepe.","billable":true,"duration":27503}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Backlog","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0010","description":"Quo recusandae optio est saepe consectetur optio. Accusantium eum quia eaque. Voluptatum eligendi similique velit dolor eos rerum cumque quaerat.","duration":425934,"rate":"$98.00","rate_raw":"98.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Mr. Easton Streich","number":"0003","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$153.00","task_rate_raw":"153.000000","due_date":"28\/Nov\/2023","private_notes":"","public_notes":"Debitis sit ut voluptatem eaque veritatis.","budgeted_hours":216,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":496,"tasks":[],"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","currency":"USD","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428468,"start_date":"19\/Nov\/2023 21:11:28","end_date_raw":1700463790,"end_date":"20\/Nov\/2023 07:11:10","description":"Culpa aut consequatur earum ut.","billable":false,"duration":35322},{"start_date_raw":1700464090,"start_date":"20\/Nov\/2023 07:11:10","end_date_raw":1700536862,"end_date":"21\/Nov\/2023 03:11:02","description":"Reprehenderit et esse qui hic quia est iusto.","billable":false,"duration":72772},{"start_date_raw":1700537162,"start_date":"21\/Nov\/2023 03:11:02","end_date_raw":1700592394,"end_date":"21\/Nov\/2023 18:11:34","description":"In est enim dolore nesciunt distinctio magni qui.","billable":true,"duration":55232},{"start_date_raw":1700592694,"start_date":"21\/Nov\/2023 18:11:34","end_date_raw":1700635771,"end_date":"22\/Nov\/2023 06:11:31","description":"Est saepe quasi alias aut odit officiis corporis.","billable":true,"duration":43077},{"start_date_raw":1700636071,"start_date":"22\/Nov\/2023 06:11:31","end_date_raw":1700637953,"end_date":"22\/Nov\/2023 07:11:53","description":"Consequuntur ipsa ut voluptate accusamus quibusdam sint sed.","billable":false,"duration":1882},{"start_date_raw":1700638253,"start_date":"22\/Nov\/2023 07:11:53","end_date_raw":1700687668,"end_date":"22\/Nov\/2023 21:11:28","description":"Sunt similique error et nostrum reprehenderit dolor.","billable":false,"duration":49415},{"start_date_raw":1700687968,"start_date":"22\/Nov\/2023 21:11:28","end_date_raw":1700712068,"end_date":"23\/Nov\/2023 04:11:08","description":"Aut rerum quis fugiat nostrum facilis ut.","billable":false,"duration":24100},{"start_date_raw":1700712368,"start_date":"23\/Nov\/2023 04:11:08","end_date_raw":1700783951,"end_date":"23\/Nov\/2023 23:11:11","description":"Aut culpa omnis sint et quos quisquam sint.","billable":true,"duration":71583},{"start_date_raw":1700784251,"start_date":"24\/Nov\/2023 00:11:11","end_date_raw":1700845166,"end_date":"24\/Nov\/2023 16:11:26","description":"Voluptas ut ratione porro eaque iste voluptas.","billable":true,"duration":60915},{"start_date_raw":1700845466,"start_date":"24\/Nov\/2023 17:11:26","end_date_raw":1700857102,"end_date":"24\/Nov\/2023 20:11:22","description":"Qui ipsa minus sed saepe maiores necessitatibus.","billable":true,"duration":11636}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Done","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0011","description":"Eligendi molestiae et quis et tempora esse ut. Sed ut est possimus et minus aut incidunt. Quibusdam rerum incidunt molestias est qui quam temporibus fuga.","duration":637522,"rate":"$120.00","rate_raw":"120.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Mr. Easton Streich","number":"0003","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$153.00","task_rate_raw":"153.000000","due_date":"28\/Nov\/2023","private_notes":"","public_notes":"Debitis sit ut voluptatem eaque veritatis.","budgeted_hours":216,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":496,"tasks":[],"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","currency":"USD","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428468,"start_date":"19\/Nov\/2023 21:11:28","end_date_raw":1700499282,"end_date":"20\/Nov\/2023 16:11:42","description":"Quasi temporibus doloremque consequatur minus pariatur facere.","billable":true,"duration":70814},{"start_date_raw":1700499582,"start_date":"20\/Nov\/2023 16:11:42","end_date_raw":1700584386,"end_date":"21\/Nov\/2023 16:11:06","description":"Id distinctio sed eos qui.","billable":true,"duration":84804},{"start_date_raw":1700584686,"start_date":"21\/Nov\/2023 16:11:06","end_date_raw":1700635554,"end_date":"22\/Nov\/2023 06:11:54","description":"Facere explicabo non nostrum.","billable":true,"duration":50868},{"start_date_raw":1700635854,"start_date":"22\/Nov\/2023 06:11:54","end_date_raw":1700672533,"end_date":"22\/Nov\/2023 17:11:13","description":"Numquam sit labore facere voluptatibus quibusdam reiciendis et.","billable":true,"duration":36679},{"start_date_raw":1700672833,"start_date":"22\/Nov\/2023 17:11:13","end_date_raw":1700678587,"end_date":"22\/Nov\/2023 18:11:07","description":"Perspiciatis ad hic nostrum et.","billable":true,"duration":5754},{"start_date_raw":1700678887,"start_date":"22\/Nov\/2023 18:11:07","end_date_raw":1700708730,"end_date":"23\/Nov\/2023 03:11:30","description":"Qui culpa iure eos quaerat voluptatum numquam inventore.","billable":true,"duration":29843},{"start_date_raw":1700709030,"start_date":"23\/Nov\/2023 03:11:30","end_date_raw":1700765439,"end_date":"23\/Nov\/2023 18:11:39","description":"Similique molestiae atque voluptatem debitis dolorem quos quis et.","billable":false,"duration":56409},{"start_date_raw":1700765739,"start_date":"23\/Nov\/2023 18:11:39","end_date_raw":1700831780,"end_date":"24\/Nov\/2023 13:11:20","description":"Nam dolorum optio et omnis.","billable":true,"duration":66041},{"start_date_raw":1700832080,"start_date":"24\/Nov\/2023 13:11:20","end_date_raw":1700844498,"end_date":"24\/Nov\/2023 16:11:18","description":"Non eos amet repellat tempore id.","billable":false,"duration":12418},{"start_date_raw":1700844798,"start_date":"24\/Nov\/2023 16:11:18","end_date_raw":1700899153,"end_date":"25\/Nov\/2023 07:11:13","description":"Iste neque nostrum laudantium officia.","billable":false,"duration":54355},{"start_date_raw":1700899453,"start_date":"25\/Nov\/2023 08:11:13","end_date_raw":1700971949,"end_date":"26\/Nov\/2023 04:11:29","description":"Ut quia ratione sed et.","billable":true,"duration":72496},{"start_date_raw":1700972249,"start_date":"26\/Nov\/2023 04:11:29","end_date_raw":1700984833,"end_date":"26\/Nov\/2023 07:11:13","description":"Sapiente quia magni quisquam eos rerum rem.","billable":false,"duration":12584},{"start_date_raw":1700985133,"start_date":"26\/Nov\/2023 07:11:13","end_date_raw":1701069590,"end_date":"27\/Nov\/2023 07:11:50","description":"Nulla et ducimus doloribus est.","billable":true,"duration":84457}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Done","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0012","description":"Ea cumque amet quas et suscipit. Voluptatum libero enim minus necessitatibus qui voluptatem. Voluptates soluta quae in et aut possimus veniam.","duration":283580,"rate":"$78.00","rate_raw":"78.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Mr. Easton Streich","number":"0003","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$153.00","task_rate_raw":"153.000000","due_date":"28\/Nov\/2023","private_notes":"","public_notes":"Debitis sit ut voluptatem eaque veritatis.","budgeted_hours":216,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":496,"tasks":[],"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428468,"start_date":"19\/Nov\/2023 21:11:28","end_date_raw":1700469690,"end_date":"20\/Nov\/2023 08:11:30","description":"Placeat vel sit voluptas architecto sed.","billable":true,"duration":41222},{"start_date_raw":1700469990,"start_date":"20\/Nov\/2023 08:11:30","end_date_raw":1700483859,"end_date":"20\/Nov\/2023 12:11:39","description":"Voluptatem est quo est dolorem.","billable":true,"duration":13869},{"start_date_raw":1700484159,"start_date":"20\/Nov\/2023 12:11:39","end_date_raw":1700541376,"end_date":"21\/Nov\/2023 04:11:16","description":"Perferendis nulla quos omnis inventore sint.","billable":false,"duration":57217},{"start_date_raw":1700541676,"start_date":"21\/Nov\/2023 04:11:16","end_date_raw":1700609280,"end_date":"21\/Nov\/2023 23:11:00","description":"Quia quae ad cum neque.","billable":true,"duration":67604},{"start_date_raw":1700609580,"start_date":"21\/Nov\/2023 23:11:00","end_date_raw":1700668490,"end_date":"22\/Nov\/2023 15:11:50","description":"Pariatur et ipsa cumque consequatur voluptatum nemo.","billable":true,"duration":58910},{"start_date_raw":1700668790,"start_date":"22\/Nov\/2023 15:11:50","end_date_raw":1700690815,"end_date":"22\/Nov\/2023 22:11:55","description":"Officia explicabo illo ex tenetur.","billable":true,"duration":22025},{"start_date_raw":1700691115,"start_date":"22\/Nov\/2023 22:11:55","end_date_raw":1700713848,"end_date":"23\/Nov\/2023 04:11:48","description":"Quasi neque tempore aut at.","billable":true,"duration":22733}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Ready to do","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0013","description":"Enim eveniet rem illo sed voluptatem vero dolorem. Sed consequatur quia autem culpa. Sed perspiciatis ullam non.","duration":512814,"rate":"$145.00","rate_raw":"145.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":[],"time_log":[{"start_date_raw":1700428468,"start_date":"19\/Nov\/2023 21:11:28","end_date_raw":1700442008,"end_date":"20\/Nov\/2023 01:11:08","description":"Et et delectus in rerum fuga et ipsam.","billable":true,"duration":13540},{"start_date_raw":1700442308,"start_date":"20\/Nov\/2023 01:11:08","end_date_raw":1700488304,"end_date":"20\/Nov\/2023 13:11:44","description":"In porro et sed eos.","billable":true,"duration":45996},{"start_date_raw":1700488604,"start_date":"20\/Nov\/2023 13:11:44","end_date_raw":1700529328,"end_date":"21\/Nov\/2023 01:11:28","description":"Eveniet similique sint minima voluptatibus voluptatem sunt.","billable":false,"duration":40724},{"start_date_raw":1700529628,"start_date":"21\/Nov\/2023 01:11:28","end_date_raw":1700560989,"end_date":"21\/Nov\/2023 10:11:09","description":"Ut est fuga id qui ut.","billable":false,"duration":31361},{"start_date_raw":1700561289,"start_date":"21\/Nov\/2023 10:11:09","end_date_raw":1700635644,"end_date":"22\/Nov\/2023 06:11:24","description":"Est consequatur nisi itaque.","billable":false,"duration":74355},{"start_date_raw":1700635944,"start_date":"22\/Nov\/2023 06:11:24","end_date_raw":1700650878,"end_date":"22\/Nov\/2023 11:11:18","description":"Ut vitae et velit magnam aut sed ut.","billable":true,"duration":14934},{"start_date_raw":1700651178,"start_date":"22\/Nov\/2023 11:11:18","end_date_raw":1700672376,"end_date":"22\/Nov\/2023 16:11:36","description":"Id odio laudantium quae similique.","billable":false,"duration":21198},{"start_date_raw":1700672676,"start_date":"22\/Nov\/2023 17:11:36","end_date_raw":1700734868,"end_date":"23\/Nov\/2023 10:11:08","description":"Saepe non vel reiciendis autem quidem quos.","billable":true,"duration":62192},{"start_date_raw":1700735168,"start_date":"23\/Nov\/2023 10:11:08","end_date_raw":1700772446,"end_date":"23\/Nov\/2023 20:11:26","description":"Occaecati commodi cupiditate esse molestiae velit.","billable":true,"duration":37278},{"start_date_raw":1700772746,"start_date":"23\/Nov\/2023 20:11:26","end_date_raw":1700785864,"end_date":"24\/Nov\/2023 00:11:04","description":"Quia et cupiditate expedita cumque quas.","billable":true,"duration":13118},{"start_date_raw":1700786164,"start_date":"24\/Nov\/2023 00:11:04","end_date_raw":1700806681,"end_date":"24\/Nov\/2023 06:11:01","description":"Eos consequatur soluta labore soluta ut.","billable":true,"duration":20517},{"start_date_raw":1700806981,"start_date":"24\/Nov\/2023 06:11:01","end_date_raw":1700839054,"end_date":"24\/Nov\/2023 15:11:34","description":"Impedit vel pariatur dicta necessitatibus at harum eius.","billable":true,"duration":32073},{"start_date_raw":1700839354,"start_date":"24\/Nov\/2023 15:11:34","end_date_raw":1700866888,"end_date":"24\/Nov\/2023 23:11:28","description":"Laboriosam nihil veritatis voluptatum qui laboriosam iusto.","billable":true,"duration":27534},{"start_date_raw":1700867188,"start_date":"24\/Nov\/2023 23:11:28","end_date_raw":1700875021,"end_date":"25\/Nov\/2023 01:11:01","description":"Error accusamus sapiente reiciendis.","billable":true,"duration":7833},{"start_date_raw":1700875321,"start_date":"25\/Nov\/2023 01:11:01","end_date_raw":1700886769,"end_date":"25\/Nov\/2023 04:11:49","description":"Impedit eius consequatur quod qui quod expedita quis.","billable":false,"duration":11448},{"start_date_raw":1700887069,"start_date":"25\/Nov\/2023 04:11:49","end_date_raw":1700945782,"end_date":"25\/Nov\/2023 20:11:22","description":"Tempora omnis nesciunt placeat omnis architecto quis.","billable":true,"duration":58713}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Done","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Hoeger, Hahn and Cole","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1022.550000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0014","description":"In soluta aliquid et eius. Molestiae veritatis animi culpa et amet porro modi ut. Id sequi nobis itaque modi explicabo voluptatem quam. Non ex voluptatem error aspernatur odit.","duration":346244,"rate":"$70.00","rate_raw":"70.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Elenor Orn","number":"0004","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$39.00","task_rate_raw":"39.000000","due_date":"27\/Nov\/2023","private_notes":"","public_notes":"Distinctio ut voluptas deleniti est sed quae.","budgeted_hours":372,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":331,"tasks":[],"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428468,"start_date":"19\/Nov\/2023 21:11:28","end_date_raw":1700458211,"end_date":"20\/Nov\/2023 05:11:11","description":"Voluptate aut dicta recusandae consectetur est ducimus.","billable":false,"duration":29743},{"start_date_raw":1700458511,"start_date":"20\/Nov\/2023 05:11:11","end_date_raw":1700516247,"end_date":"20\/Nov\/2023 21:11:27","description":"Dolores incidunt praesentium rerum.","billable":false,"duration":57736},{"start_date_raw":1700516547,"start_date":"20\/Nov\/2023 21:11:27","end_date_raw":1700549251,"end_date":"21\/Nov\/2023 06:11:31","description":"Perspiciatis consequatur et alias praesentium placeat modi aut.","billable":true,"duration":32704},{"start_date_raw":1700549551,"start_date":"21\/Nov\/2023 06:11:31","end_date_raw":1700618445,"end_date":"22\/Nov\/2023 02:11:45","description":"Esse libero incidunt non rem sunt quisquam repudiandae nisi.","billable":true,"duration":68894},{"start_date_raw":1700618745,"start_date":"22\/Nov\/2023 02:11:45","end_date_raw":1700698086,"end_date":"23\/Nov\/2023 00:11:06","description":"Earum consectetur esse fugit sint autem tempore.","billable":true,"duration":79341},{"start_date_raw":1700698386,"start_date":"23\/Nov\/2023 00:11:06","end_date_raw":1700776212,"end_date":"23\/Nov\/2023 21:11:12","description":"Saepe sit consequatur vel eos ad iusto nobis.","billable":true,"duration":77826}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Ready to do","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0015","description":"Minus accusamus illum quia nihil voluptatum qui mollitia vel. Natus fugiat sequi quod eius occaecati non. Minus rerum ut eos est eveniet quae iure.","duration":410859,"rate":"$13.00","rate_raw":"13.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Elenor Orn","number":"0004","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$39.00","task_rate_raw":"39.000000","due_date":"27\/Nov\/2023","private_notes":"","public_notes":"Distinctio ut voluptas deleniti est sed quae.","budgeted_hours":372,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":331,"tasks":[],"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428468,"start_date":"19\/Nov\/2023 21:11:28","end_date_raw":1700506053,"end_date":"20\/Nov\/2023 18:11:33","description":"Iste neque officiis eum maiores.","billable":true,"duration":77585},{"start_date_raw":1700506353,"start_date":"20\/Nov\/2023 18:11:33","end_date_raw":1700572042,"end_date":"21\/Nov\/2023 13:11:22","description":"Minus perferendis quia amet.","billable":true,"duration":65689},{"start_date_raw":1700572342,"start_date":"21\/Nov\/2023 13:11:22","end_date_raw":1700637291,"end_date":"22\/Nov\/2023 07:11:51","description":"Commodi quaerat hic minus et voluptas velit.","billable":true,"duration":64949},{"start_date_raw":1700637591,"start_date":"22\/Nov\/2023 07:11:51","end_date_raw":1700649610,"end_date":"22\/Nov\/2023 10:11:10","description":"Vitae rerum natus aperiam quia explicabo.","billable":false,"duration":12019},{"start_date_raw":1700649910,"start_date":"22\/Nov\/2023 10:11:10","end_date_raw":1700693674,"end_date":"22\/Nov\/2023 22:11:34","description":"Quos sunt dolorum eveniet provident ut.","billable":false,"duration":43764},{"start_date_raw":1700693974,"start_date":"22\/Nov\/2023 22:11:34","end_date_raw":1700775335,"end_date":"23\/Nov\/2023 21:11:35","description":"Animi quibusdam quisquam ea error earum consectetur.","billable":true,"duration":81361},{"start_date_raw":1700775635,"start_date":"23\/Nov\/2023 21:11:35","end_date_raw":1700808126,"end_date":"24\/Nov\/2023 06:11:06","description":"Ratione ipsam molestiae dolorem sit architecto voluptas.","billable":true,"duration":32491},{"start_date_raw":1700808426,"start_date":"24\/Nov\/2023 06:11:06","end_date_raw":1700817758,"end_date":"24\/Nov\/2023 09:11:38","description":"Maxime reprehenderit voluptates culpa.","billable":false,"duration":9332},{"start_date_raw":1700818058,"start_date":"24\/Nov\/2023 09:11:38","end_date_raw":1700841727,"end_date":"24\/Nov\/2023 16:11:07","description":"Atque deleniti et laboriosam molestias repellat accusamus omnis.","billable":false,"duration":23669}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Backlog","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0016","description":"Temporibus illum voluptatibus molestias quia omnis illo molestias corporis. Hic et hic quia dolores quas sint dolorem. Repellendus minus quae fuga illum amet in voluptatum. Rerum mollitia est eum voluptatum architecto non nisi qui. Est et dolores omnis placeat repellat sed facilis.","duration":435319,"rate":"$89.00","rate_raw":"89.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Elenor Orn","number":"0004","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$39.00","task_rate_raw":"39.000000","due_date":"27\/Nov\/2023","private_notes":"","public_notes":"Distinctio ut voluptas deleniti est sed quae.","budgeted_hours":372,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":331,"tasks":[],"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428469,"start_date":"19\/Nov\/2023 21:11:29","end_date_raw":1700496403,"end_date":"20\/Nov\/2023 16:11:43","description":"Sunt unde repellat reiciendis quos porro et dolores.","billable":true,"duration":67934},{"start_date_raw":1700496703,"start_date":"20\/Nov\/2023 16:11:43","end_date_raw":1700551129,"end_date":"21\/Nov\/2023 07:11:49","description":"Voluptatem laborum repudiandae enim asperiores.","billable":false,"duration":54426},{"start_date_raw":1700551429,"start_date":"21\/Nov\/2023 07:11:49","end_date_raw":1700631865,"end_date":"22\/Nov\/2023 05:11:25","description":"Placeat numquam magnam occaecati.","billable":false,"duration":80436},{"start_date_raw":1700632165,"start_date":"22\/Nov\/2023 05:11:25","end_date_raw":1700695854,"end_date":"22\/Nov\/2023 23:11:54","description":"Qui quo et est vero autem reprehenderit.","billable":false,"duration":63689},{"start_date_raw":1700696154,"start_date":"22\/Nov\/2023 23:11:54","end_date_raw":1700736857,"end_date":"23\/Nov\/2023 10:11:17","description":"Et voluptatem distinctio dolor fuga hic ea.","billable":false,"duration":40703},{"start_date_raw":1700737157,"start_date":"23\/Nov\/2023 10:11:17","end_date_raw":1700790692,"end_date":"24\/Nov\/2023 01:11:32","description":"Quo expedita quidem ab dolor quam expedita porro.","billable":true,"duration":53535},{"start_date_raw":1700790992,"start_date":"24\/Nov\/2023 01:11:32","end_date_raw":1700817527,"end_date":"24\/Nov\/2023 09:11:47","description":"Adipisci voluptatem officiis quaerat ut quos facilis.","billable":false,"duration":26535},{"start_date_raw":1700817827,"start_date":"24\/Nov\/2023 09:11:47","end_date_raw":1700865888,"end_date":"24\/Nov\/2023 22:11:48","description":"Tenetur ut dolorem vero.","billable":true,"duration":48061}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Done","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Walsh-Considine","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1960.450000","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0017","description":"Repudiandae nam labore dolores nihil sunt dolorem recusandae rerum. Ut consequatur vel et aut facilis. Sapiente distinctio cupiditate qui repellat ipsum harum.","duration":835159,"rate":"$65.00","rate_raw":"65.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":[],"time_log":[{"start_date_raw":1700428469,"start_date":"19\/Nov\/2023 21:11:29","end_date_raw":1700448921,"end_date":"20\/Nov\/2023 02:11:21","description":"Veniam iusto aperiam quis sunt nihil qui neque.","billable":true,"duration":20452},{"start_date_raw":1700449221,"start_date":"20\/Nov\/2023 03:11:21","end_date_raw":1700480544,"end_date":"20\/Nov\/2023 11:11:24","description":"Molestiae vero ea quis numquam et dicta reprehenderit.","billable":true,"duration":31323},{"start_date_raw":1700480844,"start_date":"20\/Nov\/2023 11:11:24","end_date_raw":1700513241,"end_date":"20\/Nov\/2023 20:11:21","description":"Qui id accusantium eius esse pariatur qui.","billable":false,"duration":32397},{"start_date_raw":1700513541,"start_date":"20\/Nov\/2023 20:11:21","end_date_raw":1700579256,"end_date":"21\/Nov\/2023 15:11:36","description":"Unde porro perspiciatis dolor praesentium dolor.","billable":true,"duration":65715},{"start_date_raw":1700579556,"start_date":"21\/Nov\/2023 15:11:36","end_date_raw":1700631702,"end_date":"22\/Nov\/2023 05:11:42","description":"Laboriosam eligendi deserunt veritatis impedit ipsum rerum voluptas.","billable":false,"duration":52146},{"start_date_raw":1700632002,"start_date":"22\/Nov\/2023 05:11:42","end_date_raw":1700687284,"end_date":"22\/Nov\/2023 21:11:04","description":"Molestiae sint a facere.","billable":true,"duration":55282},{"start_date_raw":1700687584,"start_date":"22\/Nov\/2023 21:11:04","end_date_raw":1700731618,"end_date":"23\/Nov\/2023 09:11:58","description":"Asperiores in repudiandae eligendi sed eveniet sequi quae.","billable":false,"duration":44034},{"start_date_raw":1700731918,"start_date":"23\/Nov\/2023 09:11:58","end_date_raw":1700785496,"end_date":"24\/Nov\/2023 00:11:56","description":"Ratione quia rem odit ea doloremque et.","billable":true,"duration":53578},{"start_date_raw":1700785796,"start_date":"24\/Nov\/2023 00:11:56","end_date_raw":1700814699,"end_date":"24\/Nov\/2023 08:11:39","description":"Deserunt quam alias incidunt sit placeat tenetur.","billable":true,"duration":28903},{"start_date_raw":1700814999,"start_date":"24\/Nov\/2023 08:11:39","end_date_raw":1700889011,"end_date":"25\/Nov\/2023 05:11:11","description":"Libero sed numquam quidem vel esse magni vel laudantium.","billable":false,"duration":74012},{"start_date_raw":1700889311,"start_date":"25\/Nov\/2023 05:11:11","end_date_raw":1700943511,"end_date":"25\/Nov\/2023 20:11:31","description":"Rerum aliquid aliquam error deleniti quo eaque.","billable":true,"duration":54200},{"start_date_raw":1700943811,"start_date":"25\/Nov\/2023 20:11:31","end_date_raw":1701013647,"end_date":"26\/Nov\/2023 15:11:27","description":"Quos vel est rerum nihil id.","billable":false,"duration":69836},{"start_date_raw":1701013947,"start_date":"26\/Nov\/2023 15:11:27","end_date_raw":1701099520,"end_date":"27\/Nov\/2023 15:11:40","description":"Cum quia maxime dignissimos quo.","billable":true,"duration":85573},{"start_date_raw":1701099820,"start_date":"27\/Nov\/2023 15:11:40","end_date_raw":1701163104,"end_date":"28\/Nov\/2023 09:11:24","description":"Amet ea exercitationem quo sed eos corporis.","billable":false,"duration":63284},{"start_date_raw":1701163404,"start_date":"28\/Nov\/2023 09:11:24","end_date_raw":1701220140,"end_date":"29\/Nov\/2023 01:11:00","description":"Sunt voluptas atque odio nesciunt aliquam in earum.","billable":true,"duration":56736},{"start_date_raw":1701220440,"start_date":"29\/Nov\/2023 01:11:00","end_date_raw":1701268128,"end_date":"29\/Nov\/2023 14:11:48","description":"Odio voluptatibus rerum non.","billable":false,"duration":47688}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Backlog","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Hoeger, Hahn and Cole","balance":"0.000000","payment_balance":"0.000000","credit_balance":"1022.550000","vat_number":"VAT123","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0018","description":"Odit rerum iusto quibusdam. A mollitia cupiditate enim consequatur omnis qui voluptas quibusdam. Recusandae et non ut ipsum asperiores non iusto.","duration":312865,"rate":"$95.00","rate_raw":"95.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Maryjane Macejkovic","number":"0005","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$78.00","task_rate_raw":"78.000000","due_date":"26\/Nov\/2023","private_notes":"","public_notes":"Nesciunt est sit ea explicabo.","budgeted_hours":405,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":194,"tasks":[],"client":{"name":"Medhurst Inc","balance":"37633.780000","payment_balance":"0.000000","credit_balance":"1025.100000","currency":"USD","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428469,"start_date":"19\/Nov\/2023 21:11:29","end_date_raw":1700476677,"end_date":"20\/Nov\/2023 10:11:57","description":"Quam dolores ut dolorem quo sint atque.","billable":true,"duration":48208},{"start_date_raw":1700476977,"start_date":"20\/Nov\/2023 10:11:57","end_date_raw":1700520944,"end_date":"20\/Nov\/2023 22:11:44","description":"Unde minus veniam corporis qui laboriosam suscipit quas.","billable":true,"duration":43967},{"start_date_raw":1700521244,"start_date":"20\/Nov\/2023 23:11:44","end_date_raw":1700602639,"end_date":"21\/Nov\/2023 21:11:19","description":"Beatae molestiae molestias sed dolor recusandae et id eligendi.","billable":false,"duration":81395},{"start_date_raw":1700602939,"start_date":"21\/Nov\/2023 21:11:19","end_date_raw":1700682077,"end_date":"22\/Nov\/2023 19:11:17","description":"Repellendus nam perspiciatis exercitationem in iste officia.","billable":true,"duration":79138},{"start_date_raw":1700682377,"start_date":"22\/Nov\/2023 19:11:17","end_date_raw":1700692054,"end_date":"22\/Nov\/2023 22:11:34","description":"Consequatur quaerat dolor consequuntur aperiam enim reiciendis.","billable":true,"duration":9677},{"start_date_raw":1700692354,"start_date":"22\/Nov\/2023 22:11:34","end_date_raw":1700742834,"end_date":"23\/Nov\/2023 12:11:54","description":"Qui quia ut sed accusantium odit reprehenderit quaerat.","billable":true,"duration":50480}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Backlog","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Medhurst Inc","balance":"37633.780000","payment_balance":"0.000000","credit_balance":"1025.100000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}},{"number":"0019","description":"Eius et dolor libero repellendus iste. Nemo sit error sed necessitatibus architecto et. Aspernatur omnis doloremque animi quas sed.","duration":387217,"rate":"$87.00","rate_raw":"87.000000","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","date":"19\/Nov\/2023","project":{"name":"Maryjane Macejkovic","number":"0005","created_at":"19\/Nov\/2023","updated_at":"19\/Nov\/2023","task_rate":"$78.00","task_rate_raw":"78.000000","due_date":"26\/Nov\/2023","private_notes":"","public_notes":"Nesciunt est sit ea explicabo.","budgeted_hours":405,"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","color":"#fff","current_hours":194,"tasks":[],"client":{"name":"Medhurst Inc","balance":"37633.780000","payment_balance":"0.000000","credit_balance":"1025.100000","currency":"USD","group":"Special Orders"},"user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"}},"time_log":[{"start_date_raw":1700428469,"start_date":"19\/Nov\/2023 21:11:29","end_date_raw":1700434042,"end_date":"19\/Nov\/2023 22:11:22","description":"Aut aliquam totam in reprehenderit sint suscipit earum.","billable":false,"duration":5573},{"start_date_raw":1700434342,"start_date":"19\/Nov\/2023 22:11:22","end_date_raw":1700467844,"end_date":"20\/Nov\/2023 08:11:44","description":"Hic aliquid natus est.","billable":false,"duration":33502},{"start_date_raw":1700468144,"start_date":"20\/Nov\/2023 08:11:44","end_date_raw":1700532877,"end_date":"21\/Nov\/2023 02:11:37","description":"Illo atque dolores eligendi minus et ut consequuntur.","billable":false,"duration":64733},{"start_date_raw":1700533177,"start_date":"21\/Nov\/2023 02:11:37","end_date_raw":1700619369,"end_date":"22\/Nov\/2023 02:11:09","description":"Libero ipsa eligendi sit dolor eligendi quibusdam dicta tenetur.","billable":false,"duration":86192},{"start_date_raw":1700619669,"start_date":"22\/Nov\/2023 02:11:09","end_date_raw":1700646879,"end_date":"22\/Nov\/2023 09:11:39","description":"Dolor unde assumenda blanditiis tenetur blanditiis ipsam quis.","billable":true,"duration":27210},{"start_date_raw":1700647179,"start_date":"22\/Nov\/2023 09:11:39","end_date_raw":1700704537,"end_date":"23\/Nov\/2023 01:11:37","description":"Reprehenderit possimus nisi recusandae.","billable":true,"duration":57358},{"start_date_raw":1700704837,"start_date":"23\/Nov\/2023 02:11:37","end_date_raw":1700733175,"end_date":"23\/Nov\/2023 09:11:55","description":"Aut saepe sint qui magni.","billable":false,"duration":28338},{"start_date_raw":1700733475,"start_date":"23\/Nov\/2023 09:11:55","end_date_raw":1700735626,"end_date":"23\/Nov\/2023 10:11:46","description":"Facere repellendus voluptas illo a.","billable":true,"duration":2151},{"start_date_raw":1700735926,"start_date":"23\/Nov\/2023 10:11:46","end_date_raw":1700769798,"end_date":"23\/Nov\/2023 20:11:18","description":"Voluptatem praesentium ipsum soluta earum.","billable":false,"duration":33872},{"start_date_raw":1700770098,"start_date":"23\/Nov\/2023 20:11:18","end_date_raw":1700818386,"end_date":"24\/Nov\/2023 09:11:06","description":"Dicta eum quis dicta quae.","billable":true,"duration":48288}],"custom_value1":"","custom_value2":"","custom_value3":"","custom_value4":"","status":"Backlog","user":{"name":"Laron Weissnat Danika Flatley","email":"small@example.com"},"client":{"name":"Medhurst Inc","balance":"37633.780000","payment_balance":"0.000000","credit_balance":"1025.100000","currency":"USD","group":"Special Orders","location":{"location_name":"Billy","address":" 44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":{"id":"840","capital":"Washington DC","citizenship":"American","country_code":"840","currency":"US dollar","currency_code":"USD","currency_sub_unit":"cent","full_name":"United States of America","iso_3166_2":"US","iso_3166_3":"USA","name":"United States","region_code":"019","sub_region_code":"021","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":",","decimal_separator":"."},"country_name":"United States","country_code":"US","shipping_location_name":"","shipping_address":" 9359<br\/>4450 Logan Gardens Apt. 326<br\/>Port Corrine, Nebraska 86973<br\/>Afghanistan<br\/>","shipping_address1":"9359","shipping_address2":"4450 Logan Gardens Apt. 326","shipping_city":"Port Corrine","shipping_state":"Nebraska","shipping_postal_code":"86973","shipping_country":{"id":"4","capital":"Kabul","citizenship":"Afghan","country_code":"004","currency":"afghani","currency_code":"AFN","currency_sub_unit":"pul","full_name":"Islamic Republic of Afghanistan","iso_3166_2":"AF","iso_3166_3":"AFG","name":"Afghanistan","region_code":"142","sub_region_code":"034","eea":false,"swap_postal_code":false,"swap_currency_symbol":false,"thousand_separator":"","decimal_separator":""},"shipping_country_name":"Afghanistan","shipping_country_code":"AF","shipping_exists":true}}}]';

    public string $invoice_data = '[{"amount": "$6,054.13", "balance": "$0.00", "amount_raw": "6054.13", "balance_raw": "0.000000", "number": "0015", "discount": 1, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "total_taxes": "$444.13", "total_taxes_raw": "444.130000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "1984-10-01", "custom_value2": "no", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "2", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "2", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "2", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$935.00", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$0.00", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 935, "tax_amount_raw": 0, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,028.50", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$93.50", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1028.5, "tax_amount_raw": 93.5, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,028.50", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$93.50", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1028.5, "tax_amount_raw": 93.5, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$6,054.13", "auto_bill_enabled": false, "client": {"name": "Lowe-Paucek", "balance": "38124.670000", "payment_balance": "0.000000", "credit_balance": "2270.590000", "currency": "USD", "group": "Special Orders Bolts", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Completed", "badge": "<h6><span class=\"badge badge-info\">Completed</span></h6>", "amount": "$6,054.13", "applied": "$6,054.13", "balance": "$0.00", "refunded": "$0.00", "amount_raw": "6054.130000", "applied_raw": "6054.130000", "refunded_raw": "0.000000", "balance_raw": 0, "date": "2025-02-24", "method": "", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0008", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "Lowe-Paucek", "balance": "38124.670000", "payment_balance": "0.000000", "credit_balance": "2270.590000", "currency": "USD", "group": "Special Orders Nuts"}, "paymentables": [{"invoice": "0015", "amount_raw": "6054.1300", "refunded_raw": "0.0000", "net_raw": 6054.13, "amount": "$6,054.13", "refunded": "$0.00", "net": "$6,054.13", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696151008}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "sent"}, {"amount": "$3,132.25", "amount_raw": "3132.25", "balance": "$0.00", "balance_raw": "0.000000", "number": "0016", "discount": 0, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "CA Sales Tax", "tax_rate3": 5, "total_taxes": "$327.25", "total_taxes_raw": "327.250000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "1990-05-13", "custom_value2": "yes", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,028.50", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$93.50", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1028.5, "tax_amount_raw": 93.5, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$3,132.25", "auto_bill_enabled": false, "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders Spanners", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Completed", "badge": "<h6><span class=\"badge badge-info\">Completed</span></h6>", "amount": "$3,132.25", "applied": "$3,132.25", "balance": "$0.00", "refunded": "$0.00", "amount_raw": "3132.250000", "applied_raw": "3132.250000", "refunded_raw": "0.000000", "balance_raw": 0, "date": "2025-02-24", "method": "", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0009", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders Driver"}, "paymentables": [{"invoice": "0016", "amount_raw": "3132.2500", "refunded_raw": "0.0000", "net_raw": 3132.25, "amount": "$3,132.25", "refunded": "$0.00", "net": "$3,132.25", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696151008}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "draft"}, {"amount": "$9,396.77", "amount_raw": "9396.77", "balance": "$0.00", "balance_raw": "0.000000", "number": "0017", "discount": 0, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "VAT", "tax_rate2": 17.5, "tax_name3": "CA Sales Tax", "tax_rate3": 5, "total_taxes": "$2,851.77", "total_taxes_raw": "2851.770000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "1989-04-20", "custom_value2": "yes", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$935.00", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$0.00", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 935, "tax_amount_raw": 0, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,028.50", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$93.50", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1028.5, "tax_amount_raw": 93.5, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,028.50", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$93.50", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1028.5, "tax_amount_raw": 93.5, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$9,396.77", "auto_bill_enabled": false, "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders Torque", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Completed", "badge": "<h6><span class=\"badge badge-info\">Completed</span></h6>", "amount": "$9,396.77", "applied": "$9,396.77", "balance": "$0.00", "refunded": "$0.00", "amount_raw": "9396.770000", "applied_raw": "9396.770000", "refunded_raw": "0.000000", "balance_raw": 0, "date": "2025-02-24", "method": "", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0010", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders Wrench"}, "paymentables": [{"invoice": "0017", "amount_raw": "9396.7700", "refunded_raw": "0.0000", "net_raw": 9396.77, "amount": "$9,396.77", "refunded": "$0.00", "net": "$9,396.77", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696151008}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "cancelled"}, {"amount": "$6,077.51", "balance": "$0.00", "amount_raw": "6077.51", "balance_raw": "0.000000", "number": "0019", "discount": 0, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "", "tax_rate1": 0, "tax_name2": "VAT", "tax_rate2": 17.5, "tax_name3": "CA Sales Tax", "tax_rate3": 5, "total_taxes": "$1,402.51", "total_taxes_raw": "1402.510000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "1992-08-20", "custom_value2": "no", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,028.50", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$93.50", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1028.5, "tax_amount_raw": 93.5, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$935.00", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$0.00", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 935, "tax_amount_raw": 0, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$6,077.51", "auto_bill_enabled": false, "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders Pliers", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Refunded", "badge": "<h6><span class=\"badge badge-primary\">Refunded</span></h6>", "amount": "$6,077.51", "applied": "$6,077.51", "balance": "-$6,077.51", "refunded": "$6,077.51", "amount_raw": "6077.510000", "applied_raw": "6077.510000", "refunded_raw": "6077.510000", "balance_raw": -6077.51, "date": "2025-02-24", "method": "EuroCard", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0001", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0019", "amount_raw": "6077.5100", "refunded_raw": "6077.5100", "net_raw": 0, "amount": "$6,077.51", "refunded": "$6,077.51", "net": "$0.00", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696150843}]}, {"status": "Completed", "badge": "<h6><span class=\"badge badge-info\">Completed</span></h6>", "amount": "$6,077.51", "applied": "$6,077.51", "balance": "$0.00", "refunded": "$0.00", "amount_raw": "6077.510000", "applied_raw": "6077.510000", "refunded_raw": "0.000000", "balance_raw": 0, "date": "2025-02-24", "method": "", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0011", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0019", "amount_raw": "6077.5100", "refunded_raw": "0.0000", "net_raw": 6077.51, "amount": "$6,077.51", "refunded": "$0.00", "net": "$6,077.51", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696151008}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "paid"}, {"amount": "$4,090.64", "amount_raw": "4090.64", "balance": "$0.00", "balance_raw": "0.000000", "number": "0020", "discount": 0, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "VAT", "tax_rate2": 17.5, "tax_name3": "CA Sales Tax", "tax_rate3": 5, "total_taxes": "$1,285.64", "total_taxes_raw": "1285.640000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "1979-06-26", "custom_value2": "yes", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$4,090.64", "auto_bill_enabled": false, "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Refunded", "badge": "<h6><span class=\"badge badge-primary\">Refunded</span></h6>", "amount": "$4,090.64", "applied": "$4,090.64", "balance": "-$4,090.64", "refunded": "$4,090.64", "amount_raw": "4090.640000", "applied_raw": "4090.640000", "refunded_raw": "4090.640000", "balance_raw": -4090.64, "date": "2025-02-24", "method": "Discover Card", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0002", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0020", "amount_raw": "4090.6400", "refunded_raw": "4090.6400", "net_raw": 0, "amount": "$4,090.64", "refunded": "$4,090.64", "net": "$0.00", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696150843}]}, {"status": "Completed", "badge": "<h6><span class=\"badge badge-info\">Completed</span></h6>", "amount": "$4,090.64", "applied": "$4,090.64", "balance": "$0.00", "refunded": "$0.00", "amount_raw": "4090.640000", "applied_raw": "4090.640000", "refunded_raw": "0.000000", "balance_raw": 0, "date": "2025-02-24", "method": "", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0012", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "cypress", "balance": "0.000000", "payment_balance": "0.000000", "credit_balance": "11661.820000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0020", "amount_raw": "4090.6400", "refunded_raw": "0.0000", "net_raw": 4090.64, "amount": "$4,090.64", "refunded": "$0.00", "net": "$4,090.64", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696151008}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "paid"}, {"amount": "$2,197.26", "amount_raw": "2197.26", "balance": "$0.00", "balance_raw": "0.000000", "number": "0021", "discount": 0, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "total_taxes": "$327.26", "total_taxes_raw": "327.260000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "1980-11-12", "custom_value2": "no", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$2,197.26", "auto_bill_enabled": false, "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Refunded", "badge": "<h6><span class=\"badge badge-primary\">Refunded</span></h6>", "amount": "$2,197.26", "applied": "$2,197.26", "balance": "-$2,197.26", "refunded": "$2,197.26", "amount_raw": "2197.260000", "applied_raw": "2197.260000", "refunded_raw": "2197.260000", "balance_raw": -2197.26, "date": "2025-02-24", "method": "Diners Card", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0003", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0021", "amount_raw": "2197.2600", "refunded_raw": "2197.2600", "net_raw": 0, "amount": "$2,197.26", "refunded": "$2,197.26", "net": "$0.00", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696150843}]}, {"status": "Completed", "badge": "<h6><span class=\"badge badge-info\">Completed</span></h6>", "amount": "$2,197.26", "applied": "$2,197.26", "balance": "$0.00", "refunded": "$0.00", "amount_raw": "2197.260000", "applied_raw": "2197.260000", "refunded_raw": "0.000000", "balance_raw": 0, "date": "2025-02-24", "method": "", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0013", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0021", "amount_raw": "2197.2600", "refunded_raw": "0.0000", "net_raw": 2197.26, "amount": "$2,197.26", "refunded": "$0.00", "net": "$2,197.26", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696151008}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "sent"}, {"amount": "$4,955.50", "amount_raw": "4955.50", "balance": "$66.00", "balance_raw": "66.000000", "number": "0022", "discount": 0, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "VAT", "tax_rate2": 17.5, "tax_name3": "", "tax_rate3": 0, "total_taxes": "$1,215.50", "total_taxes_raw": "1215.500000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "1999-08-20", "custom_value2": "yes", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$4,889.50", "auto_bill_enabled": false, "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Partially Refunded", "badge": "<h6><span class=\"badge badge-success\">Partially Refunded</span></h6>", "amount": "$4,955.50", "applied": "$4,955.50", "balance": "-$66.00", "refunded": "$66.00", "amount_raw": "4955.500000", "applied_raw": "4955.500000", "refunded_raw": "66.000000", "balance_raw": -66, "date": "2025-02-24", "method": "Maestro", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0004", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0022", "amount_raw": "4955.5000", "refunded_raw": "66.0000", "net_raw": 4889.5, "amount": "$4,955.50", "refunded": "$66.00", "net": "$4,889.50", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696150843}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "cancelled"}, {"amount": "$2,290.75", "amount_raw": "2290.75", "balance": "$34.00", "balance_raw": "34.000000", "number": "0023", "discount": 0, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "", "tax_rate1": 0, "tax_name2": "VAT", "tax_rate2": 17.5, "tax_name3": "CA Sales Tax", "tax_rate3": 5, "total_taxes": "$420.75", "total_taxes_raw": "420.750000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "2015-12-15", "custom_value2": "no", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$935.00", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$0.00", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 935, "tax_amount_raw": 0, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$935.00", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$0.00", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 935, "tax_amount_raw": 0, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$2,256.75", "auto_bill_enabled": false, "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Partially Refunded", "badge": "<h6><span class=\"badge badge-success\">Partially Refunded</span></h6>", "amount": "$2,290.75", "applied": "$2,290.75", "balance": "-$34.00", "refunded": "$34.00", "amount_raw": "2290.750000", "applied_raw": "2290.750000", "refunded_raw": "34.000000", "balance_raw": -34, "date": "2025-02-24", "method": "Diners Card", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0005", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0023", "amount_raw": "2290.7500", "refunded_raw": "34.0000", "net_raw": 2256.75, "amount": "$2,290.75", "refunded": "$34.00", "net": "$2,256.75", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696150843}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "paid"}, {"amount": "$6,802.13", "amount_raw": "6802.13", "balance": "$444.00", "balance_raw": "444.000000", "number": "0024", "discount": 0, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "CA Sales Tax", "tax_rate3": 5, "total_taxes": "$1,192.13", "total_taxes_raw": "1192.130000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "1990-07-11", "custom_value2": "no", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$935.00", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$0.00", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 935, "tax_amount_raw": 0, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$935.00", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$0.00", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 935, "tax_amount_raw": 0, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,028.50", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$93.50", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1028.5, "tax_amount_raw": 93.5, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$6,358.13", "auto_bill_enabled": false, "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Partially Refunded", "badge": "<h6><span class=\"badge badge-success\">Partially Refunded</span></h6>", "amount": "$6,802.13", "applied": "$6,802.13", "balance": "-$444.00", "refunded": "$444.00", "amount_raw": "6802.130000", "applied_raw": "6802.130000", "refunded_raw": "444.000000", "balance_raw": -444, "date": "2025-02-24", "method": "Maestro", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0006", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0024", "amount_raw": "6802.1300", "refunded_raw": "444.0000", "net_raw": 6358.13, "amount": "$6,802.13", "refunded": "$444.00", "net": "$6,358.13", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696150843}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "paid"}, {"amount": "$10,986.26", "amount_raw": "10986.26", "balance": "$146.26", "balance_raw": "146.260000", "number": "0025", "discount": 0, "po_number": "", "date": "2025-01-24", "last_sent_date": "", "next_send_date": "", "due_date": "2025-02-13", "terms": "", "public_notes": "", "private_notes": "", "uses_inclusive_taxes": false, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "total_taxes": "$1,636.26", "total_taxes_raw": "1636.260000", "is_amount_discount": true, "footer": "", "partial": 10, "partial_due_date": "2025-02-03", "custom_value1": "1975-02-18", "custom_value2": "no", "custom_value3": "", "custom_value4": "", "custom_surcharge1": 0, "custom_surcharge2": 0, "custom_surcharge3": 0, "custom_surcharge4": 0, "exchange_rate": 1, "custom_surcharge_tax1": false, "custom_surcharge_tax2": false, "custom_surcharge_tax3": false, "custom_surcharge_tax4": false, "line_items": [{"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,028.50", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$93.50", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1028.5, "tax_amount_raw": 93.5, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$935.00", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$0.00", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 935, "tax_amount_raw": 0, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "", "tax_rate1": 0, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$935.00", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$0.00", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 935, "tax_amount_raw": 0, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "VAT", "tax_rate1": 17.5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,098.63", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$163.63", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1098.63, "tax_amount_raw": 163.63, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "Sales Tax", "tax_rate1": 5, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$981.75", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$46.75", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 981.75, "tax_amount_raw": 46.75, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}, {"quantity": 1, "cost": "$935.00", "product_key": "Et.", "notes": "Illum similique.", "discount": "$0.00", "is_amount_discount": true, "tax_name1": "GST", "tax_rate1": 10, "tax_name2": "", "tax_rate2": 0, "tax_name3": "", "tax_rate3": 0, "sort_id": 0, "line_total": "$935.00", "gross_line_total": "$1,028.50", "custom_value1": "https://picsum.photos/200", "custom_value2": "78", "custom_value3": "Itaque laudantium.", "custom_value4": "Qui voluptatem ea a.", "type_id": "1", "product_cost": "$0.00", "tax_amount": "$93.50", "date": "", "tax_id": "", "task_id": "", "expense_id": "", "cost_raw": 935, "discount_raw": 0, "line_total_raw": 935, "gross_line_total_raw": 1028.5, "tax_amount_raw": 93.5, "product_cost_raw": 0, "net_cost": "$10.00", "net_cost_raw": 10}], "reminder1_sent": "", "reminder2_sent": "", "reminder3_sent": "", "reminder_last_sent": "", "paid_to_date": "$10,840.00", "auto_bill_enabled": false, "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders", "location": {"location_name": "Billy", "address": " 44 Nice Street<br/>Apt 5<br/>Nicest City, Best State 90210<br/>United States<br/>", "address1": "44 Nice Street", "address2": "Apt 5", "city": "Nicest City", "state": "Best State", "postal_code": "90210", "country": {"id": "840", "capital": "Washington DC", "citizenship": "American", "country_code": "840", "currency": "US dollar", "currency_code": "USD", "currency_sub_unit": "cent", "full_name": "United States of America", "iso_3166_2": "US", "iso_3166_3": "USA", "name": "United States", "region_code": "019", "sub_region_code": "021", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": ",", "decimal_separator": "."}, "country_name": "United States", "country_code": "US", "shipping_location_name": "", "shipping_address": " 9359<br/>4450 Logan Gardens Apt. 326<br/>Port Corrine, Nebraska 86973<br/>Afghanistan<br/>", "shipping_address1": "9359", "shipping_address2": "4450 Logan Gardens Apt. 326", "shipping_city": "Port Corrine", "shipping_state": "Nebraska", "shipping_postal_code": "86973", "shipping_country": {"id": "4", "capital": "Kabul", "citizenship": "Afghan", "country_code": "004", "currency": "afghani", "currency_code": "AFN", "currency_sub_unit": "pul", "full_name": "Islamic Republic of Afghanistan", "iso_3166_2": "AF", "iso_3166_3": "AFG", "name": "Afghanistan", "region_code": "142", "sub_region_code": "034", "eea": false, "swap_postal_code": false, "swap_currency_symbol": false, "thousand_separator": "", "decimal_separator": ""}, "shipping_country_name": "Afghanistan", "shipping_country_code": "AF", "shipping_exists": true}}, "payments": [{"status": "Partially Refunded", "badge": "<h6><span class=\"badge badge-success\">Partially Refunded</span></h6>", "amount": "$10,986.26", "applied": "$10,986.26", "balance": "-$146.26", "refunded": "$146.26", "amount_raw": "10986.260000", "applied_raw": "10986.260000", "refunded_raw": "146.260000", "balance_raw": -146.26000000000022, "date": "2025-02-24", "method": "UnionPay", "currency": "USD", "exchange_rate": 1, "transaction_reference": "Manual entry", "is_manual": 1, "number": "0007", "custom_value1": "", "custom_value2": "", "custom_value3": "", "custom_value4": "", "client": {"name": "Jakubowski Group", "balance": "28296.170000", "payment_balance": "0.000000", "credit_balance": "1084.840000", "currency": "USD", "group": "Special Orders"}, "paymentables": [{"invoice": "0025", "amount_raw": "10986.2600", "refunded_raw": "146.2600", "net_raw": 10840, "amount": "$10,986.26", "refunded": "$146.26", "net": "$10,840.00", "is_credit": false, "created_at": "2025-01-24", "updated_at": "2025-01-24", "timestamp": 1696150843}]}], "total_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "line_tax_map": [{"name": "CA Sales Tax 5%", "total": "$141.90", "total_raw": 141.9}], "updated_at": "2025-01-24", "created_at": "2025-01-24", "status": "draft"}]';

    public string $quote_data = '[{"id":1,"client_id":1,"user_id":1,"assigned_user_id":null,"company_id":1,"status_id":2,"project_id":null,"vendor_id":null,"recurring_id":null,"design_id":2,"invoice_id":null,"number":"0001","discount":1,"is_amount_discount":false,"po_number":"Molestias.","date":"2025-01-24","last_sent_date":null,"due_date":"2025-02-13","next_send_date":null,"is_deleted":false,"line_items":[{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$935.00","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$0.00","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":935,"tax_amount_raw":0,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"GST","tax_rate1":10,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,028.50","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$93.50","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1028.5,"tax_amount_raw":93.5,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"VAT","tax_rate1":17.5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,098.63","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$163.63","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1098.63,"tax_amount_raw":163.63,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"GST","tax_rate1":10,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,028.50","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$93.50","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1028.5,"tax_amount_raw":93.5,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10}],"backup":null,"footer":null,"public_notes":null,"private_notes":null,"terms":null,"tax_name1":"GST","tax_rate1":"10.000000","tax_name2":"VAT","tax_rate2":"17.500000","tax_name3":"THIRDTAX","tax_rate3":"5.000000","total_taxes":"1797.280000","uses_inclusive_taxes":0,"custom_value1":null,"custom_value2":null,"custom_value3":null,"custom_value4":null,"custom_surcharge1":null,"custom_surcharge2":null,"custom_surcharge3":null,"custom_surcharge4":null,"custom_surcharge_tax1":0,"custom_surcharge_tax2":0,"custom_surcharge_tax3":0,"custom_surcharge_tax4":0,"exchange_rate":"1.000000","amount":"6211.690000","balance":"0.000000","partial":10,"partial_due_date":"2025-02-03","last_viewed":null,"created_at":"2025-01-24","updated_at":"2025-01-24","deleted_at":null,"reminder1_sent":null,"reminder2_sent":null,"reminder3_sent":null,"reminder_last_sent":null,"paid_to_date":"0.000000","subscription_id":null,"hashed_id":"VolejRejNm","client":{"name":"Kilback-Stoltenberg","balance":"0.000000","payment_balance":"0.000000","credit_balance":"2084.140000","vat_number":"428950405","address1":"5 Wallaby Way","address2":"Apt 1","phone":"555 123-1321","city":"Sydney","state":"NSW","postal_code":"2113","country_id":"840","group":"Special Orders","location":{"location_name":"Billy","address":"44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":"USA"}}},{"id":2,"client_id":1,"user_id":1,"assigned_user_id":null,"company_id":1,"status_id":2,"project_id":null,"vendor_id":null,"recurring_id":null,"design_id":2,"invoice_id":null,"number":"0002","discount":9,"is_amount_discount":true,"po_number":"Omnis.","date":"2025-01-24","last_sent_date":null,"due_date":"2025-02-13","next_send_date":null,"is_deleted":false,"line_items":[{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"2","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"","tax_rate1":0,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$935.00","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$0.00","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":935,"tax_amount_raw":0,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"GST","tax_rate1":10,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,028.50","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$93.50","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1028.5,"tax_amount_raw":93.5,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"VAT","tax_rate1":17.5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,098.63","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$163.63","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1098.63,"tax_amount_raw":163.63,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"GST","tax_rate1":10,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$1,028.50","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$93.50","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":1028.5,"tax_amount_raw":93.5,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10},{"quantity":1,"cost":"$935.00","product_key":"Et.","notes":"Illum similique.","discount":"$0.00","is_amount_discount":true,"tax_name1":"Sales Tax","tax_rate1":5,"tax_name2":"","tax_rate2":0,"tax_name3":"","tax_rate3":0,"sort_id":0,"line_total":"$935.00","gross_line_total":"$981.75","custom_value1":"https:\/\/picsum.photos\/200","custom_value2":"78","custom_value3":"Itaque laudantium.","custom_value4":"Qui voluptatem ea a.","type_id":"1","product_cost":"$0.00","tax_amount":"$46.75","date":"","tax_id":"","task_id":"","expense_id":"","cost_raw":935,"discount_raw":0,"line_total_raw":935,"gross_line_total_raw":981.75,"tax_amount_raw":46.75,"product_cost_raw":0,"net_cost":"$10.00","net_cost_raw":10}],"backup":null,"footer":null,"public_notes":null,"private_notes":null,"terms":null,"tax_name1":"GST","tax_rate1":"10.000000","tax_name2":"VAT","tax_rate2":"17.500000","tax_name3":"THIRDTAX","tax_rate3":"5.000000","total_taxes":"1381.560000","uses_inclusive_taxes":0,"custom_value1":null,"custom_value2":null,"custom_value3":null,"custom_value4":null,"custom_surcharge1":null,"custom_surcharge2":null,"custom_surcharge3":null,"custom_surcharge4":null,"custom_surcharge_tax1":0,"custom_surcharge_tax2":0,"custom_surcharge_tax3":0,"custom_surcharge_tax4":0,"exchange_rate":"1.000000","amount":"4557.560000","balance":"0.000000","partial":10,"partial_due_date":"2025-02-03","last_viewed":null,"created_at":"2025-01-24","updated_at":"2025-01-24","deleted_at":null,"reminder1_sent":null,"reminder2_sent":null,"reminder3_sent":null,"reminder_last_sent":null,"paid_to_date":"0.000000","subscription_id":null,"hashed_id":"Wpmbk5ezJn","client":{"name":"Kilback-Stoltenberg","balance":"0.000000","payment_balance":"0.000000","credit_balance":"2084.140000","vat_number":"428950405","address1":"5 Wallaby Way","address2":"Apt 1","phone":"555 123-1321","city":"Sydney","state":"NSW","postal_code":"2113","country_id":"840","group":"Special Orders","location":{"location_name":"Billy","address":"44 Nice Street<br\/>Apt 5<br\/>Nicest City, Best State 90210<br\/>United States<br\/>","address1":"44 Nice Street","address2":"Apt 5","city":"Nicest City","state":"Best State","postal_code":"90210","country":"USA"}}}]';

    public function __construct(public Company $company)
    {
        // Initialize expense_data from file if property was truncated (PHP limit on single-line property assignments)
        if (empty($this->expense_data) || strlen($this->expense_data) < 200000) {
            $this->loadExpenseDataFromFile();
        }
    }

    private function loadExpenseDataFromFile(): void
    {
        $content = file_get_contents(__FILE__);
        $lines = explode("\n", $content);
        $expense_line = $lines[27]; // Line 28 (0-indexed)
        if (preg_match("/expense_data = '(.+)';/s", $expense_line, $matches)) {
            $this->expense_data = $matches[1];
        }
    }

    public function init(): self
    {

        $this->variables = collect(['invoices', 'quotes', 'credits', 'purchase_orders','expenses'])->map(function ($type) {
            return $this->createVariables($type);
        })->toArray();

        $this->engines['invoices'] = json_decode($this->invoice_data, true);
        $this->engines['quotes'] = json_decode($this->quote_data, true);
        $this->engines['credits'] = json_decode($this->credit_data, true);
        $this->engines['tasks'] = json_decode($this->task_data, true);
        $this->engines['projects'] = json_decode($this->project_data, true);
        $this->engines['payments'] = json_decode($this->payment_data, true);
        $this->engines['purchase_orders'] = json_decode($this->purchase_order_data, true);

        // Check if expense_data property was actually set (may fail if property definition is too long)
        if (!isset($this->expense_data) || empty($this->expense_data)) {
            nlog('expense_data property is empty or not set - property definition may be too long for PHP to parse');
            $this->engines['expenses'] = null;
        } else {
            $this->engines['expenses'] = json_decode($this->expense_data, true);

            if (json_last_error() !== JSON_ERROR_NONE) {
                nlog('expense_data json_decode error: ' . json_last_error_msg());
                nlog('expense_data length: ' . strlen($this->expense_data));
                $this->engines['expenses'] = null;
            }
        }

        return $this;

    }

    /**
     * ['entity_type','design','settings_type','settings']
     *
     * @param string $type
     * @return array
     */
    private function createVariables(string $type): array
    {
        $data = [
            'entity_type' => rtrim($type, "s"),
            'design' => '',
            'settings_type' => 'company',
            'settings' =>  $this->settings ?? $this->company->settings,
        ];

        $mock = (new PdfMock($data, $this->company));
        $mock->settings = $this->settings ?? $this->company->settings;
        $mock->build(); //2025-07-11 unnecessary to generate the build here as it stubs a PDF preview each time!

        return [$type => $mock->getStubVariables()];
    }

    public function setSettings($settings): self
    {
        $this->settings = $settings;

        return $this;
    }

}
