/**
 * @licstart The following is the entire license notice for the
 * Javascript code in this page
 *
 * Copyright 2020 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * @licend The above is the entire license notice for the
 * Javascript code in this page
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("pdfjs-dist/build/pdf.worker",[],t):"object"==typeof exports?exports["pdfjs-dist/build/pdf.worker"]=t():e["pdfjs-dist/build/pdf.worker"]=e.pdfjsWorker=t()}(this,(function(){return function(e){var t={};function a(r){if(t[r])return t[r].exports;var i=t[r]={i:r,l:!1,exports:{}};e[r].call(i.exports,i,i.exports,a);i.l=!0;return i.exports}a.m=e;a.c=t;a.d=function(e,t,r){a.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:r})};a.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"});Object.defineProperty(e,"__esModule",{value:!0})};a.t=function(e,t){1&t&&(e=a(e));if(8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var r=Object.create(null);a.r(r);Object.defineProperty(r,"default",{enumerable:!0,value:e});if(2&t&&"string"!=typeof e)for(var i in e)a.d(r,i,function(t){return e[t]}.bind(null,i));return r};a.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};a.d(t,"a",t);return t};a.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)};a.p="";return a(a.s=0)}([function(e,t,a){"use strict";const r=a(1);t.WorkerMessageHandler=r.WorkerMessageHandler},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.WorkerMessageHandler=t.WorkerTask=void 0;var r=a(2),i=a(4),n=a(5),s=a(44),o=a(45),c=a(46),l=a(7),h=function(){function e(e){this.name=e;this.terminated=!1;this._capability=(0,r.createPromiseCapability)()}e.prototype={get finished(){return this._capability.promise},finish(){this._capability.resolve()},terminate(){this.terminated=!0},ensureNotTerminated(){if(this.terminated)throw new Error("Worker task was terminated")}};return e}();t.WorkerTask=h;var u,d={setup(e,t){var a=!1;e.on("test",(function(t){if(a)return;a=!0;if(!(t instanceof Uint8Array)){e.send("test",null);return}const r=255===t[0];e.postMessageTransfers=r;e.send("test",{supportTransfers:r})}));e.on("configure",(function(e){(0,r.setVerbosityLevel)(e.verbosity)}));e.on("GetDocRequest",(function(e){return d.createDocumentHandler(e,t)}))},createDocumentHandler(e,t){var a,s=!1,u=null,d=[];const f=(0,r.getVerbosityLevel)(),g=e.apiVersion;if("2.4.456"!==g)throw new Error(`The API version "${g}" does not match `+'the Worker version "2.4.456".');const m=[];for(const e in[])m.push(e);if(m.length)throw new Error("The `Array.prototype` contains unexpected enumerable properties: "+m.join(", ")+"; thus breaking e.g. `for...in` iteration of `Array`s.");var p=e.docId,b=e.docBaseUrl,y=e.docId+"_worker",v=new o.MessageHandler(y,p,t);v.postMessageTransfers=e.postMessageTransfers;function w(){if(s)throw new Error("Worker was terminated")}function k(e){d.push(e)}function S(e){e.finish();var t=d.indexOf(e);d.splice(t,1)}async function C(e){await a.ensureDoc("checkHeader");await a.ensureDoc("parseStartXRef");await a.ensureDoc("parse",[e]);e||await a.ensureDoc("checkFirstPage");const[t,r]=await Promise.all([a.ensureDoc("numPages"),a.ensureDoc("fingerprint")]);return{numPages:t,fingerprint:r}}function x(e,t){var a,i=(0,r.createPromiseCapability)(),s=e.source;if(s.data){try{a=new n.LocalPdfManager(p,s.data,s.password,t,b);i.resolve(a)}catch(e){i.reject(e)}return i.promise}var o,l=[];try{o=new c.PDFWorkerStream(v)}catch(e){i.reject(e);return i.promise}var h=o.getFullReader();h.headersReady.then((function(){if(h.isRangeSupported){var e=s.disableAutoFetch||h.isStreamingSupported;a=new n.NetworkPdfManager(p,o,{msgHandler:v,password:s.password,length:h.contentLength,disableAutoFetch:e,rangeChunkSize:s.rangeChunkSize},t,b);for(let e=0;e<l.length;e++)a.sendProgressiveData(l[e]);l=[];i.resolve(a);u=null}})).catch((function(e){i.reject(e);u=null}));var d=0;new Promise((function(e,o){var c=function(e){try{w();if(e.done){a||function(){var e=(0,r.arraysToBytes)(l);s.length&&e.length!==s.length&&(0,r.warn)("reported HTTP length is different from actual");try{a=new n.LocalPdfManager(p,e,s.password,t,b);i.resolve(a)}catch(e){i.reject(e)}l=[]}();u=null;return}var f=e.value;d+=(0,r.arrayByteLength)(f);h.isStreamingSupported||v.send("DocProgress",{loaded:d,total:Math.max(d,h.contentLength||0)});a?a.sendProgressiveData(f):l.push(f);h.read().then(c,o)}catch(e){o(e)}};h.read().then(c,o)})).catch((function(e){i.reject(e);u=null}));u=function(e){o.cancelAllRequests(e)};return i.promise}v.on("GetPage",(function(e){return a.getPage(e.pageIndex).then((function(e){return Promise.all([a.ensure(e,"rotate"),a.ensure(e,"ref"),a.ensure(e,"userUnit"),a.ensure(e,"view")]).then((function([e,t,a,r]){return{rotate:e,ref:t,userUnit:a,view:r}}))}))}));v.on("GetPageIndex",(function(e){var t=i.Ref.get(e.ref.num,e.ref.gen);return a.pdfDocument.catalog.getPageIndex(t)}));v.on("GetDestinations",(function(e){return a.ensureCatalog("destinations")}));v.on("GetDestination",(function(e){return a.ensureCatalog("getDestination",[e.id])}));v.on("GetPageLabels",(function(e){return a.ensureCatalog("pageLabels")}));v.on("GetPageLayout",(function(e){return a.ensureCatalog("pageLayout")}));v.on("GetPageMode",(function(e){return a.ensureCatalog("pageMode")}));v.on("GetViewerPreferences",(function(e){return a.ensureCatalog("viewerPreferences")}));v.on("GetOpenAction",(function(e){return a.ensureCatalog("openAction")}));v.on("GetAttachments",(function(e){return a.ensureCatalog("attachments")}));v.on("GetJavaScript",(function(e){return a.ensureCatalog("javaScript")}));v.on("GetOutline",(function(e){return a.ensureCatalog("documentOutline")}));v.on("GetPermissions",(function(e){return a.ensureCatalog("permissions")}));v.on("GetMetadata",(function(e){return Promise.all([a.ensureDoc("documentInfo"),a.ensureCatalog("metadata")])}));v.on("GetData",(function(e){a.requestLoadedStream();return a.onLoadedStream().then((function(e){return e.bytes}))}));v.on("GetStats",(function(e){return a.pdfDocument.xref.stats}));v.on("GetAnnotations",(function({pageIndex:e,intent:t}){return a.getPage(e).then((function(e){return e.getAnnotationsData(t)}))}));v.on("GetOperatorList",(function(e,t){var i=e.pageIndex;a.getPage(i).then((function(a){var n=new h(`GetOperatorList: page ${i}`);k(n);const s=f>=r.VerbosityLevel.INFOS?Date.now():0;a.getOperatorList({handler:v,sink:t,task:n,intent:e.intent,renderInteractiveForms:e.renderInteractiveForms}).then((function(e){S(n);s&&(0,r.info)(`page=${i+1} - getOperatorList: time=`+`${Date.now()-s}ms, len=${e.length}`);t.close()}),(function(e){S(n);if(!n.terminated){v.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.unknown});t.error(e)}}))}))}),this);v.on("GetTextContent",(function(e,t){var i=e.pageIndex;t.onPull=function(e){};t.onCancel=function(e){};a.getPage(i).then((function(a){var n=new h("GetTextContent: page "+i);k(n);const s=f>=r.VerbosityLevel.INFOS?Date.now():0;a.extractTextContent({handler:v,task:n,sink:t,normalizeWhitespace:e.normalizeWhitespace,combineTextItems:e.combineTextItems}).then((function(){S(n);s&&(0,r.info)(`page=${i+1} - getTextContent: time=`+`${Date.now()-s}ms`);t.close()}),(function(e){S(n);n.terminated||t.error(e)}))}))}));v.on("FontFallback",(function(e){return a.fontFallback(e.id,v)}));v.on("Cleanup",(function(e){return a.cleanup()}));v.on("Terminate",(function(e){s=!0;const t=[];if(a){a.terminate(new r.AbortException("Worker was terminated."));const e=a.cleanup();t.push(e);a=null}else(0,i.clearPrimitiveCaches)();u&&u(new r.AbortException("Worker was terminated."));d.forEach((function(e){t.push(e.finished);e.terminate()}));return Promise.all(t).then((function(){v.destroy();v=null}))}));v.on("Ready",(function(t){!function(e){function t(e){w();v.send("GetDoc",{pdfInfo:e})}function i(e){w();if(e instanceof r.PasswordException){var t=new h(`PasswordException: response ${e.code}`);k(t);v.sendWithPromise("PasswordRequest",e).then((function(e){S(t);a.updatePassword(e.password);n()})).catch((function(){S(t);v.send("DocException",e)}))}else e instanceof r.InvalidPDFException||e instanceof r.MissingPDFException||e instanceof r.UnexpectedResponseException||e instanceof r.UnknownErrorException?v.send("DocException",e):v.send("DocException",new r.UnknownErrorException(e.message,e.toString()))}function n(){w();C(!1).then(t,(function(e){w();if(e instanceof l.XRefParseException){a.requestLoadedStream();a.onLoadedStream().then((function(){w();C(!0).then(t,i)}))}else i(e)}),i)}w();x(e,{forceDataSchema:e.disableCreateObjectURL,maxImageSize:e.maxImageSize,disableFontFace:e.disableFontFace,nativeImageDecoderSupport:e.nativeImageDecoderSupport,ignoreErrors:e.ignoreErrors,isEvalSupported:e.isEvalSupported}).then((function(e){if(s){e.terminate(new r.AbortException("Worker was terminated."));throw new Error("Worker was terminated")}(a=e).onLoadedStream().then((function(e){v.send("DataLoaded",{length:e.bytes.byteLength})}))})).then(n,i)}(e);e=null}));return y},initializeFromPort(e){var t=new o.MessageHandler("worker","main",e);d.setup(t,e);t.send("ready",null)}};t.WorkerMessageHandler=d;"undefined"==typeof window&&!s.isNodeJS&&"undefined"!=typeof self&&("function"==typeof(u=self).postMessage&&"onmessage"in u)&&d.initializeFromPort(self)},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.arrayByteLength=d;t.arraysToBytes=function(e){const t=e.length;if(1===t&&e[0]instanceof Uint8Array)return e[0];let a=0;for(let r=0;r<t;r++)a+=d(e[r]);let r=0;const i=new Uint8Array(a);for(let a=0;a<t;a++){let t=e[a];t instanceof Uint8Array||(t="string"==typeof t?u(t):new Uint8Array(t));const n=t.byteLength;i.set(t,r);r+=n}return i};t.assert=o;t.bytesToString=function(e){o(null!==e&&"object"==typeof e&&void 0!==e.length,"Invalid argument for bytesToString");const t=e.length;if(t<8192)return String.fromCharCode.apply(null,e);const a=[];for(let r=0;r<t;r+=8192){const i=Math.min(r+8192,t),n=e.subarray(r,i);a.push(String.fromCharCode.apply(null,n))}return a.join("")};t.createPromiseCapability=function(){const e=Object.create(null);let t=!1;Object.defineProperty(e,"settled",{get:()=>t});e.promise=new Promise((function(a,r){e.resolve=function(e){t=!0;a(e)};e.reject=function(e){t=!0;r(e)}}));return e};t.getVerbosityLevel=function(){return i};t.info=function(e){i>=r.INFOS&&console.log(`Info: ${e}`)};t.isArrayBuffer=function(e){return"object"==typeof e&&null!==e&&void 0!==e.byteLength};t.isArrayEqual=function(e,t){if(e.length!==t.length)return!1;return e.every((function(e,a){return e===t[a]}))};t.isBool=function(e){return"boolean"==typeof e};t.isEmptyObj=function(e){for(const t in e)return!1;return!0};t.isNum=function(e){return"number"==typeof e};t.isString=function(e){return"string"==typeof e};t.isSameOrigin=function(e,t){let a;try{a=new URL(e);if(!a.origin||"null"===a.origin)return!1}catch(e){return!1}const r=new URL(t,a);return a.origin===r.origin};t.createValidAbsoluteUrl=function(e,t){if(!e)return null;try{const a=t?new URL(e,t):new URL(e);if(function(e){if(!e)return!1;switch(e.protocol){case"http:":case"https:":case"ftp:":case"mailto:":case"tel:":return!0;default:return!1}}(a))return a}catch(e){}return null};t.removeNullCharacters=function(e){if("string"!=typeof e){n("The argument for removeNullCharacters must be a string.");return e}return e.replace(h,"")};t.setVerbosityLevel=function(e){Number.isInteger(e)&&(i=e)};t.shadow=c;t.string32=function(e){return String.fromCharCode(e>>24&255,e>>16&255,e>>8&255,255&e)};t.stringToBytes=u;t.stringToPDFString=function(e){const t=e.length,a=[];if("þ"===e[0]&&"ÿ"===e[1])for(let r=2;r<t;r+=2)a.push(String.fromCharCode(e.charCodeAt(r)<<8|e.charCodeAt(r+1)));else if("ÿ"===e[0]&&"þ"===e[1])for(let r=2;r<t;r+=2)a.push(String.fromCharCode(e.charCodeAt(r+1)<<8|e.charCodeAt(r)));else for(let r=0;r<t;++r){const t=b[e.charCodeAt(r)];a.push(t?String.fromCharCode(t):e.charAt(r))}return a.join("")};t.stringToUTF8String=function(e){return decodeURIComponent(escape(e))};t.utf8StringToString=function(e){return unescape(encodeURIComponent(e))};t.warn=n;t.unreachable=s;t.IsEvalSupportedCached=t.IsLittleEndianCached=t.createObjectURL=t.FormatError=t.Util=t.UnknownErrorException=t.UnexpectedResponseException=t.TextRenderingMode=t.StreamType=t.PermissionFlag=t.PasswordResponses=t.PasswordException=t.NativeImageDecoding=t.MissingPDFException=t.InvalidPDFException=t.AbortException=t.CMapCompressionType=t.ImageKind=t.FontType=t.AnnotationType=t.AnnotationStateModelType=t.AnnotationReviewState=t.AnnotationReplyType=t.AnnotationMarkedState=t.AnnotationFlag=t.AnnotationFieldFlag=t.AnnotationBorderStyleType=t.UNSUPPORTED_FEATURES=t.VerbosityLevel=t.OPS=t.IDENTITY_MATRIX=t.FONT_IDENTITY_MATRIX=t.BaseException=void 0;a(3);t.IDENTITY_MATRIX=[1,0,0,1,0,0];t.FONT_IDENTITY_MATRIX=[.001,0,0,.001,0,0];t.NativeImageDecoding={NONE:"none",DECODE:"decode",DISPLAY:"display"};t.PermissionFlag={PRINT:4,MODIFY_CONTENTS:8,COPY:16,MODIFY_ANNOTATIONS:32,FILL_INTERACTIVE_FORMS:256,COPY_FOR_ACCESSIBILITY:512,ASSEMBLE:1024,PRINT_HIGH_QUALITY:2048};t.TextRenderingMode={FILL:0,STROKE:1,FILL_STROKE:2,INVISIBLE:3,FILL_ADD_TO_PATH:4,STROKE_ADD_TO_PATH:5,FILL_STROKE_ADD_TO_PATH:6,ADD_TO_PATH:7,FILL_STROKE_MASK:3,ADD_TO_PATH_FLAG:4};t.ImageKind={GRAYSCALE_1BPP:1,RGB_24BPP:2,RGBA_32BPP:3};t.AnnotationType={TEXT:1,LINK:2,FREETEXT:3,LINE:4,SQUARE:5,CIRCLE:6,POLYGON:7,POLYLINE:8,HIGHLIGHT:9,UNDERLINE:10,SQUIGGLY:11,STRIKEOUT:12,STAMP:13,CARET:14,INK:15,POPUP:16,FILEATTACHMENT:17,SOUND:18,MOVIE:19,WIDGET:20,SCREEN:21,PRINTERMARK:22,TRAPNET:23,WATERMARK:24,THREED:25,REDACT:26};t.AnnotationStateModelType={MARKED:"Marked",REVIEW:"Review"};t.AnnotationMarkedState={MARKED:"Marked",UNMARKED:"Unmarked"};t.AnnotationReviewState={ACCEPTED:"Accepted",REJECTED:"Rejected",CANCELLED:"Cancelled",COMPLETED:"Completed",NONE:"None"};t.AnnotationReplyType={GROUP:"Group",REPLY:"R"};t.AnnotationFlag={INVISIBLE:1,HIDDEN:2,PRINT:4,NOZOOM:8,NOROTATE:16,NOVIEW:32,READONLY:64,LOCKED:128,TOGGLENOVIEW:256,LOCKEDCONTENTS:512};t.AnnotationFieldFlag={READONLY:1,REQUIRED:2,NOEXPORT:4,MULTILINE:4096,PASSWORD:8192,NOTOGGLETOOFF:16384,RADIO:32768,PUSHBUTTON:65536,COMBO:131072,EDIT:262144,SORT:524288,FILESELECT:1048576,MULTISELECT:2097152,DONOTSPELLCHECK:4194304,DONOTSCROLL:8388608,COMB:16777216,RICHTEXT:33554432,RADIOSINUNISON:33554432,COMMITONSELCHANGE:67108864};t.AnnotationBorderStyleType={SOLID:1,DASHED:2,BEVELED:3,INSET:4,UNDERLINE:5};t.StreamType={UNKNOWN:"UNKNOWN",FLATE:"FLATE",LZW:"LZW",DCT:"DCT",JPX:"JPX",JBIG:"JBIG",A85:"A85",AHX:"AHX",CCF:"CCF",RLX:"RLX"};t.FontType={UNKNOWN:"UNKNOWN",TYPE1:"TYPE1",TYPE1C:"TYPE1C",CIDFONTTYPE0:"CIDFONTTYPE0",CIDFONTTYPE0C:"CIDFONTTYPE0C",TRUETYPE:"TRUETYPE",CIDFONTTYPE2:"CIDFONTTYPE2",TYPE3:"TYPE3",OPENTYPE:"OPENTYPE",TYPE0:"TYPE0",MMTYPE1:"MMTYPE1"};const r={ERRORS:0,WARNINGS:1,INFOS:5};t.VerbosityLevel=r;t.CMapCompressionType={NONE:0,BINARY:1,STREAM:2};t.OPS={dependency:1,setLineWidth:2,setLineCap:3,setLineJoin:4,setMiterLimit:5,setDash:6,setRenderingIntent:7,setFlatness:8,setGState:9,save:10,restore:11,transform:12,moveTo:13,lineTo:14,curveTo:15,curveTo2:16,curveTo3:17,closePath:18,rectangle:19,stroke:20,closeStroke:21,fill:22,eoFill:23,fillStroke:24,eoFillStroke:25,closeFillStroke:26,closeEOFillStroke:27,endPath:28,clip:29,eoClip:30,beginText:31,endText:32,setCharSpacing:33,setWordSpacing:34,setHScale:35,setLeading:36,setFont:37,setTextRenderingMode:38,setTextRise:39,moveText:40,setLeadingMoveText:41,setTextMatrix:42,nextLine:43,showText:44,showSpacedText:45,nextLineShowText:46,nextLineSetSpacingShowText:47,setCharWidth:48,setCharWidthAndBounds:49,setStrokeColorSpace:50,setFillColorSpace:51,setStrokeColor:52,setStrokeColorN:53,setFillColor:54,setFillColorN:55,setStrokeGray:56,setFillGray:57,setStrokeRGBColor:58,setFillRGBColor:59,setStrokeCMYKColor:60,setFillCMYKColor:61,shadingFill:62,beginInlineImage:63,beginImageData:64,endInlineImage:65,paintXObject:66,markPoint:67,markPointProps:68,beginMarkedContent:69,beginMarkedContentProps:70,endMarkedContent:71,beginCompat:72,endCompat:73,paintFormXObjectBegin:74,paintFormXObjectEnd:75,beginGroup:76,endGroup:77,beginAnnotations:78,endAnnotations:79,beginAnnotation:80,endAnnotation:81,paintJpegXObject:82,paintImageMaskXObject:83,paintImageMaskXObjectGroup:84,paintImageXObject:85,paintInlineImageXObject:86,paintInlineImageXObjectGroup:87,paintImageXObjectRepeat:88,paintImageMaskXObjectRepeat:89,paintSolidColorImageMask:90,constructPath:91};t.UNSUPPORTED_FEATURES={unknown:"unknown",forms:"forms",javaScript:"javaScript",smask:"smask",shadingPattern:"shadingPattern",font:"font"};t.PasswordResponses={NEED_PASSWORD:1,INCORRECT_PASSWORD:2};let i=r.WARNINGS;function n(e){i>=r.WARNINGS&&console.log(`Warning: ${e}`)}function s(e){throw new Error(e)}function o(e,t){e||s(t)}function c(e,t,a){Object.defineProperty(e,t,{value:a,enumerable:!0,configurable:!0,writable:!1});return a}const l=function(){function e(t){this.constructor===e&&s("Cannot initialize BaseException.");this.message=t;this.name=this.constructor.name}e.prototype=new Error;e.constructor=e;return e}();t.BaseException=l;t.PasswordException=class extends l{constructor(e,t){super(e);this.code=t}};t.UnknownErrorException=class extends l{constructor(e,t){super(e);this.details=t}};t.InvalidPDFException=class extends l{};t.MissingPDFException=class extends l{};t.UnexpectedResponseException=class extends l{constructor(e,t){super(e);this.status=t}};t.FormatError=class extends l{};t.AbortException=class extends l{};const h=/\x00/g;function u(e){o("string"==typeof e,"Invalid argument for stringToBytes");const t=e.length,a=new Uint8Array(t);for(let r=0;r<t;++r)a[r]=255&e.charCodeAt(r);return a}function d(e){if(void 0!==e.length)return e.length;o(void 0!==e.byteLength);return e.byteLength}const f={get value(){return c(this,"value",function(){const e=new Uint8Array(4);e[0]=1;return 1===new Uint32Array(e.buffer,0,1)[0]}())}};t.IsLittleEndianCached=f;const g={get value(){return c(this,"value",function(){try{new Function("");return!0}catch(e){return!1}}())}};t.IsEvalSupportedCached=g;const m=["rgb(",0,",",0,",",0,")"];class p{static makeCssRgb(e,t,a){m[1]=e;m[3]=t;m[5]=a;return m.join("")}static transform(e,t){return[e[0]*t[0]+e[2]*t[1],e[1]*t[0]+e[3]*t[1],e[0]*t[2]+e[2]*t[3],e[1]*t[2]+e[3]*t[3],e[0]*t[4]+e[2]*t[5]+e[4],e[1]*t[4]+e[3]*t[5]+e[5]]}static applyTransform(e,t){return[e[0]*t[0]+e[1]*t[2]+t[4],e[0]*t[1]+e[1]*t[3]+t[5]]}static applyInverseTransform(e,t){const a=t[0]*t[3]-t[1]*t[2];return[(e[0]*t[3]-e[1]*t[2]+t[2]*t[5]-t[4]*t[3])/a,(-e[0]*t[1]+e[1]*t[0]+t[4]*t[1]-t[5]*t[0])/a]}static getAxialAlignedBoundingBox(e,t){const a=p.applyTransform(e,t),r=p.applyTransform(e.slice(2,4),t),i=p.applyTransform([e[0],e[3]],t),n=p.applyTransform([e[2],e[1]],t);return[Math.min(a[0],r[0],i[0],n[0]),Math.min(a[1],r[1],i[1],n[1]),Math.max(a[0],r[0],i[0],n[0]),Math.max(a[1],r[1],i[1],n[1])]}static inverseTransform(e){const t=e[0]*e[3]-e[1]*e[2];return[e[3]/t,-e[1]/t,-e[2]/t,e[0]/t,(e[2]*e[5]-e[4]*e[3])/t,(e[4]*e[1]-e[5]*e[0])/t]}static apply3dTransform(e,t){return[e[0]*t[0]+e[1]*t[1]+e[2]*t[2],e[3]*t[0]+e[4]*t[1]+e[5]*t[2],e[6]*t[0]+e[7]*t[1]+e[8]*t[2]]}static singularValueDecompose2dScale(e){const t=[e[0],e[2],e[1],e[3]],a=e[0]*t[0]+e[1]*t[2],r=e[0]*t[1]+e[1]*t[3],i=e[2]*t[0]+e[3]*t[2],n=e[2]*t[1]+e[3]*t[3],s=(a+n)/2,o=Math.sqrt((a+n)*(a+n)-4*(a*n-i*r))/2,c=s+o||1,l=s-o||1;return[Math.sqrt(c),Math.sqrt(l)]}static normalizeRect(e){const t=e.slice(0);if(e[0]>e[2]){t[0]=e[2];t[2]=e[0]}if(e[1]>e[3]){t[1]=e[3];t[3]=e[1]}return t}static intersect(e,t){function a(e,t){return e-t}const r=[e[0],e[2],t[0],t[2]].sort(a),i=[e[1],e[3],t[1],t[3]].sort(a),n=[];e=p.normalizeRect(e);t=p.normalizeRect(t);if(!(r[0]===e[0]&&r[1]===t[0]||r[0]===t[0]&&r[1]===e[0]))return null;n[0]=r[1];n[2]=r[2];if(!(i[0]===e[1]&&i[1]===t[1]||i[0]===t[1]&&i[1]===e[1]))return null;n[1]=i[1];n[3]=i[2];return n}}t.Util=p;const b=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,728,711,710,729,733,731,730,732,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8226,8224,8225,8230,8212,8211,402,8260,8249,8250,8722,8240,8222,8220,8221,8216,8217,8218,8482,64257,64258,321,338,352,376,381,305,322,339,353,382,0,8364];const y=function(){const e="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";return function(t,a,r=!1){if(!r&&URL.createObjectURL){const e=new Blob([t],{type:a});return URL.createObjectURL(e)}let i=`data:${a};base64,`;for(let a=0,r=t.length;a<r;a+=3){const n=255&t[a],s=255&t[a+1],o=255&t[a+2];i+=e[n>>2]+e[(3&n)<<4|s>>4]+e[a+1<r?(15&s)<<2|o>>6:64]+e[a+2<r?63&o:64]}return i}}();t.createObjectURL=y},function(e,t,a){},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.clearPrimitiveCaches=function(){n._clearCache();i._clearCache();o._clearCache()};t.isEOF=function(e){return e===r};t.isCmd=function(e,t){return e instanceof n&&(void 0===t||e.cmd===t)};t.isDict=u;t.isName=h;t.isRef=function(e){return e instanceof o};t.isRefsEqual=function(e,t){return e.num===t.num&&e.gen===t.gen};t.isStream=function(e){return"object"==typeof e&&null!==e&&void 0!==e.getBytes};t.RefSetCache=t.RefSet=t.Ref=t.Name=t.Dict=t.Cmd=t.EOF=void 0;a(2);var r={};t.EOF=r;var i=function(){let e=Object.create(null);function t(e){this.name=e}t.prototype={};t.get=function(a){var r=e[a];return r||(e[a]=new t(a))};t._clearCache=function(){e=Object.create(null)};return t}();t.Name=i;var n=function(){let e=Object.create(null);function t(e){this.cmd=e}t.prototype={};t.get=function(a){var r=e[a];return r||(e[a]=new t(a))};t._clearCache=function(){e=Object.create(null)};return t}();t.Cmd=n;var s=function(){var e=function(){return e};function t(t){this._map=Object.create(null);this.xref=t;this.objId=null;this.suppressEncryption=!1;this.__nonSerializable__=e}t.prototype={assignXref:function(e){this.xref=e},get(e,t,a){let r=this._map[e];if(void 0===r&&void 0!==t){r=this._map[t];void 0===r&&void 0!==a&&(r=this._map[a])}return r instanceof o&&this.xref?this.xref.fetch(r,this.suppressEncryption):r},async getAsync(e,t,a){let r=this._map[e];if(void 0===r&&void 0!==t){r=this._map[t];void 0===r&&void 0!==a&&(r=this._map[a])}return r instanceof o&&this.xref?this.xref.fetchAsync(r,this.suppressEncryption):r},getArray(e,t,a){let r=this.get(e,t,a);if(!Array.isArray(r)||!this.xref)return r;r=r.slice();for(let e=0,t=r.length;e<t;e++)r[e]instanceof o&&(r[e]=this.xref.fetch(r[e],this.suppressEncryption));return r},getRaw:function(e){return this._map[e]},getKeys:function(){return Object.keys(this._map)},set:function(e,t){this._map[e]=t},has:function(e){return void 0!==this._map[e]},forEach:function(e){for(var t in this._map)e(t,this.get(t))}};t.empty=new t(null);t.merge=function(e,a){const r=new t(e);for(let e=0,t=a.length;e<t;e++){const t=a[e];if(u(t))for(const e in t._map)void 0===r._map[e]&&(r._map[e]=t._map[e])}return r};return t}();t.Dict=s;var o=function(){let e=Object.create(null);function t(e,t){this.num=e;this.gen=t}t.prototype={toString:function(){return 0===this.gen?`${this.num}R`:`${this.num}R${this.gen}`}};t.get=function(a,r){const i=0===r?`${a}R`:`${a}R${r}`,n=e[i];return n||(e[i]=new t(a,r))};t._clearCache=function(){e=Object.create(null)};return t}();t.Ref=o;var c=function(){function e(){this.dict=Object.create(null)}e.prototype={has:function(e){return e.toString()in this.dict},put:function(e){this.dict[e.toString()]=!0},remove:function(e){delete this.dict[e.toString()]}};return e}();t.RefSet=c;var l=function(){function e(){this.dict=Object.create(null)}e.prototype={get:function(e){return this.dict[e.toString()]},has:function(e){return e.toString()in this.dict},put:function(e,t){this.dict[e.toString()]=t},putAlias:function(e,t){this.dict[e.toString()]=this.get(t)},forEach:function(e){for(const t in this.dict)e(this.dict[t])},clear:function(){this.dict=Object.create(null)}};return e}();t.RefSetCache=l;function h(e,t){return e instanceof i&&(void 0===t||e.name===t)}function u(e,t){return e instanceof s&&(void 0===t||h(e.get("Type"),t))}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.NetworkPdfManager=t.LocalPdfManager=void 0;var r=a(2),i=a(6),n=a(7),s=a(8),o=a(11);class c{constructor(){this.constructor===c&&(0,r.unreachable)("Cannot initialize BasePdfManager.")}get docId(){return this._docId}get password(){return this._password}get docBaseUrl(){let e=null;if(this._docBaseUrl){const t=(0,r.createValidAbsoluteUrl)(this._docBaseUrl);t?e=t.href:(0,r.warn)(`Invalid absolute docBaseUrl: "${this._docBaseUrl}".`)}return(0,r.shadow)(this,"docBaseUrl",e)}onLoadedStream(){(0,r.unreachable)("Abstract method `onLoadedStream` called")}ensureDoc(e,t){return this.ensure(this.pdfDocument,e,t)}ensureXRef(e,t){return this.ensure(this.pdfDocument.xref,e,t)}ensureCatalog(e,t){return this.ensure(this.pdfDocument.catalog,e,t)}getPage(e){return this.pdfDocument.getPage(e)}fontFallback(e,t){return this.pdfDocument.fontFallback(e,t)}cleanup(){return this.pdfDocument.cleanup()}async ensure(e,t,a){(0,r.unreachable)("Abstract method `ensure` called")}requestRange(e,t){(0,r.unreachable)("Abstract method `requestRange` called")}requestLoadedStream(){(0,r.unreachable)("Abstract method `requestLoadedStream` called")}sendProgressiveData(e){(0,r.unreachable)("Abstract method `sendProgressiveData` called")}updatePassword(e){this._password=e}terminate(e){(0,r.unreachable)("Abstract method `terminate` called")}}t.LocalPdfManager=class extends c{constructor(e,t,a,r,i){super();this._docId=e;this._password=a;this._docBaseUrl=i;this.evaluatorOptions=r;const n=new o.Stream(t);this.pdfDocument=new s.PDFDocument(this,n);this._loadedStreamPromise=Promise.resolve(n)}async ensure(e,t,a){const r=e[t];return"function"==typeof r?r.apply(e,a):r}requestRange(e,t){return Promise.resolve()}requestLoadedStream(){}onLoadedStream(){return this._loadedStreamPromise}terminate(e){}};t.NetworkPdfManager=class extends c{constructor(e,t,a,r,n){super();this._docId=e;this._password=a.password;this._docBaseUrl=n;this.msgHandler=a.msgHandler;this.evaluatorOptions=r;this.streamManager=new i.ChunkedStreamManager(t,{msgHandler:a.msgHandler,length:a.length,disableAutoFetch:a.disableAutoFetch,rangeChunkSize:a.rangeChunkSize});this.pdfDocument=new s.PDFDocument(this,this.streamManager.getStream())}async ensure(e,t,a){try{const r=e[t];return"function"==typeof r?r.apply(e,a):r}catch(r){if(!(r instanceof n.MissingDataException))throw r;await this.requestRange(r.begin,r.end);return this.ensure(e,t,a)}}requestRange(e,t){return this.streamManager.requestRange(e,t)}requestLoadedStream(){this.streamManager.requestAllChunks()}sendProgressiveData(e){this.streamManager.onReceiveData({chunk:e})}onLoadedStream(){return this.streamManager.onLoadedStream()}terminate(e){this.streamManager.abort(e)}}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.ChunkedStreamManager=t.ChunkedStream=void 0;var r=a(2),i=a(7);class n{constructor(e,t,a){this.bytes=new Uint8Array(e);this.start=0;this.pos=0;this.end=e;this.chunkSize=t;this.loadedChunks=[];this.numChunksLoaded=0;this.numChunks=Math.ceil(e/t);this.manager=a;this.progressiveDataLength=0;this.lastSuccessfulEnsureByteChunk=-1}getMissingChunks(){const e=[];for(let t=0,a=this.numChunks;t<a;++t)this.loadedChunks[t]||e.push(t);return e}getBaseStreams(){return[this]}allChunksLoaded(){return this.numChunksLoaded===this.numChunks}onReceiveData(e,t){const a=this.chunkSize;if(e%a!=0)throw new Error(`Bad begin offset: ${e}`);const r=e+t.byteLength;if(r%a!=0&&r!==this.bytes.length)throw new Error(`Bad end offset: ${r}`);this.bytes.set(new Uint8Array(t),e);const i=Math.floor(e/a),n=Math.floor((r-1)/a)+1;for(let e=i;e<n;++e)if(!this.loadedChunks[e]){this.loadedChunks[e]=!0;++this.numChunksLoaded}}onReceiveProgressiveData(e){let t=this.progressiveDataLength;const a=Math.floor(t/this.chunkSize);this.bytes.set(new Uint8Array(e),t);t+=e.byteLength;this.progressiveDataLength=t;const r=t>=this.end?this.numChunks:Math.floor(t/this.chunkSize);for(let e=a;e<r;++e)if(!this.loadedChunks[e]){this.loadedChunks[e]=!0;++this.numChunksLoaded}}ensureByte(e){if(e<this.progressiveDataLength)return;const t=Math.floor(e/this.chunkSize);if(t!==this.lastSuccessfulEnsureByteChunk){if(!this.loadedChunks[t])throw new i.MissingDataException(e,e+1);this.lastSuccessfulEnsureByteChunk=t}}ensureRange(e,t){if(e>=t)return;if(t<=this.progressiveDataLength)return;const a=this.chunkSize,r=Math.floor(e/a),n=Math.floor((t-1)/a)+1;for(let a=r;a<n;++a)if(!this.loadedChunks[a])throw new i.MissingDataException(e,t)}nextEmptyChunk(e){const t=this.numChunks;for(let a=0;a<t;++a){const r=(e+a)%t;if(!this.loadedChunks[r])return r}return null}hasChunk(e){return!!this.loadedChunks[e]}get length(){return this.end-this.start}get isEmpty(){return 0===this.length}getByte(){const e=this.pos;if(e>=this.end)return-1;e>=this.progressiveDataLength&&this.ensureByte(e);return this.bytes[this.pos++]}getUint16(){const e=this.getByte(),t=this.getByte();return-1===e||-1===t?-1:(e<<8)+t}getInt32(){return(this.getByte()<<24)+(this.getByte()<<16)+(this.getByte()<<8)+this.getByte()}getBytes(e,t=!1){const a=this.bytes,r=this.pos,i=this.end;if(!e){i>this.progressiveDataLength&&this.ensureRange(r,i);const e=a.subarray(r,i);return t?new Uint8ClampedArray(e):e}let n=r+e;n>i&&(n=i);n>this.progressiveDataLength&&this.ensureRange(r,n);this.pos=n;const s=a.subarray(r,n);return t?new Uint8ClampedArray(s):s}peekByte(){const e=this.getByte();-1!==e&&this.pos--;return e}peekBytes(e,t=!1){const a=this.getBytes(e,t);this.pos-=a.length;return a}getByteRange(e,t){e<0&&(e=0);t>this.end&&(t=this.end);t>this.progressiveDataLength&&this.ensureRange(e,t);return this.bytes.subarray(e,t)}skip(e){e||(e=1);this.pos+=e}reset(){this.pos=this.start}moveStart(){this.start=this.pos}makeSubStream(e,t,a){t?e+t>this.progressiveDataLength&&this.ensureRange(e,e+t):e>=this.progressiveDataLength&&this.ensureByte(e);function r(){}r.prototype=Object.create(this);r.prototype.getMissingChunks=function(){const e=this.chunkSize,t=Math.floor(this.start/e),a=Math.floor((this.end-1)/e)+1,r=[];for(let e=t;e<a;++e)this.loadedChunks[e]||r.push(e);return r};r.prototype.allChunksLoaded=function(){return this.numChunksLoaded===this.numChunks||0===this.getMissingChunks().length};const i=new r;i.pos=i.start=e;i.end=e+t||this.end;i.dict=a;return i}}t.ChunkedStream=n;t.ChunkedStreamManager=class{constructor(e,t){this.length=t.length;this.chunkSize=t.rangeChunkSize;this.stream=new n(this.length,this.chunkSize,this);this.pdfNetworkStream=e;this.disableAutoFetch=t.disableAutoFetch;this.msgHandler=t.msgHandler;this.currRequestId=0;this.chunksNeededByRequest=Object.create(null);this.requestsByChunk=Object.create(null);this.promisesByRequest=Object.create(null);this.progressiveDataLength=0;this.aborted=!1;this._loadedStreamCapability=(0,r.createPromiseCapability)()}onLoadedStream(){return this._loadedStreamCapability.promise}sendRequest(e,t){const a=this.pdfNetworkStream.getRangeReader(e,t);a.isStreamingSupported||(a.onProgress=this.onProgress.bind(this));let i=[],n=0;new Promise((e,t)=>{const s=o=>{try{if(!o.done){const e=o.value;i.push(e);n+=(0,r.arrayByteLength)(e);a.isStreamingSupported&&this.onProgress({loaded:n});a.read().then(s,t);return}const c=(0,r.arraysToBytes)(i);i=null;e(c)}catch(e){t(e)}};a.read().then(s,t)}).then(t=>{this.aborted||this.onReceiveData({chunk:t,begin:e})})}requestAllChunks(){const e=this.stream.getMissingChunks();this._requestChunks(e);return this._loadedStreamCapability.promise}_requestChunks(e){const t=this.currRequestId++,a=Object.create(null);this.chunksNeededByRequest[t]=a;for(const t of e)this.stream.hasChunk(t)||(a[t]=!0);if((0,r.isEmptyObj)(a))return Promise.resolve();const i=(0,r.createPromiseCapability)();this.promisesByRequest[t]=i;const n=[];for(let e in a){e|=0;if(!(e in this.requestsByChunk)){this.requestsByChunk[e]=[];n.push(e)}this.requestsByChunk[e].push(t)}if(!n.length)return i.promise;const s=this.groupChunks(n);for(const e of s){const t=e.beginChunk*this.chunkSize,a=Math.min(e.endChunk*this.chunkSize,this.length);this.sendRequest(t,a)}return i.promise}getStream(){return this.stream}requestRange(e,t){t=Math.min(t,this.length);const a=this.getBeginChunk(e),r=this.getEndChunk(t),i=[];for(let e=a;e<r;++e)i.push(e);return this._requestChunks(i)}requestRanges(e=[]){const t=[];for(const a of e){const e=this.getBeginChunk(a.begin),r=this.getEndChunk(a.end);for(let a=e;a<r;++a)t.includes(a)||t.push(a)}t.sort((function(e,t){return e-t}));return this._requestChunks(t)}groupChunks(e){const t=[];let a=-1,r=-1;for(let i=0,n=e.length;i<n;++i){const n=e[i];a<0&&(a=n);if(r>=0&&r+1!==n){t.push({beginChunk:a,endChunk:r+1});a=n}i+1===e.length&&t.push({beginChunk:a,endChunk:n+1});r=n}return t}onProgress(e){this.msgHandler.send("DocProgress",{loaded:this.stream.numChunksLoaded*this.chunkSize+e.loaded,total:this.length})}onReceiveData(e){const t=e.chunk,a=void 0===e.begin,i=a?this.progressiveDataLength:e.begin,n=i+t.byteLength,s=Math.floor(i/this.chunkSize),o=n<this.length?Math.floor(n/this.chunkSize):Math.ceil(n/this.chunkSize);if(a){this.stream.onReceiveProgressiveData(t);this.progressiveDataLength=n}else this.stream.onReceiveData(i,t);this.stream.allChunksLoaded()&&this._loadedStreamCapability.resolve(this.stream);const c=[];for(let e=s;e<o;++e){const t=this.requestsByChunk[e]||[];delete this.requestsByChunk[e];for(const a of t){const t=this.chunksNeededByRequest[a];e in t&&delete t[e];(0,r.isEmptyObj)(t)&&c.push(a)}}if(!this.disableAutoFetch&&(0,r.isEmptyObj)(this.requestsByChunk)){let e;if(1===this.stream.numChunksLoaded){const t=this.stream.numChunks-1;this.stream.hasChunk(t)||(e=t)}else e=this.stream.nextEmptyChunk(o);Number.isInteger(e)&&this._requestChunks([e])}for(const e of c){const t=this.promisesByRequest[e];delete this.promisesByRequest[e];t.resolve()}this.msgHandler.send("DocProgress",{loaded:this.stream.numChunksLoaded*this.chunkSize,total:this.length})}onError(e){this._loadedStreamCapability.reject(e)}getBeginChunk(e){return Math.floor(e/this.chunkSize)}getEndChunk(e){return Math.floor((e-1)/this.chunkSize)+1}abort(e){this.aborted=!0;this.pdfNetworkStream&&this.pdfNetworkStream.cancelAllRequests(e);for(const t in this.promisesByRequest)this.promisesByRequest[t].reject(e)}}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.getLookupTableFactory=function(e){let t;return function(){if(e){t=Object.create(null);e(t);e=null}return t}};t.getInheritableProperty=function({dict:e,key:t,getArray:a=!1,stopWhenFound:i=!0}){let n,s=0;for(;e;){const o=a?e.getArray(t):e.get(t);if(void 0!==o){if(i)return o;n||(n=[]);n.push(o)}if(++s>100){(0,r.warn)(`getInheritableProperty: maximum loop count exceeded for "${t}"`);break}e=e.get("Parent")}return n};t.toRomanNumerals=function(e,t=!1){(0,r.assert)(Number.isInteger(e)&&e>0,"The number should be a positive integer.");const a=[];let i;for(;e>=1e3;){e-=1e3;a.push("M")}i=e/100|0;e%=100;a.push(o[i]);i=e/10|0;e%=10;a.push(o[10+i]);a.push(o[20+e]);const n=a.join("");return t?n.toLowerCase():n};t.log2=function(e){if(e<=0)return 0;return Math.ceil(Math.log2(e))};t.readInt8=function(e,t){return e[t]<<24>>24};t.readUint16=function(e,t){return e[t]<<8|e[t+1]};t.readUint32=function(e,t){return(e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3])>>>0};t.isWhiteSpace=function(e){return 32===e||9===e||13===e||10===e};t.XRefParseException=t.XRefEntryException=t.MissingDataException=void 0;var r=a(2);class i extends r.BaseException{constructor(e,t){super(`Missing data [${e}, ${t})`);this.begin=e;this.end=t}}t.MissingDataException=i;class n extends r.BaseException{}t.XRefEntryException=n;class s extends r.BaseException{}t.XRefParseException=s;const o=["","C","CC","CCC","CD","D","DC","DCC","DCCC","CM","","X","XX","XXX","XL","L","LX","LXX","LXXX","XC","","I","II","III","IV","V","VI","VII","VIII","IX"]},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.PDFDocument=t.Page=void 0;var r=a(2),i=a(9),n=a(4),s=a(7),o=a(11),c=a(23),l=a(21),h=a(10),u=a(24),d=a(25),f=a(39);const g=[0,0,612,792];function m(e,t){return"display"===t&&e.viewable||"print"===t&&e.printable}class p{constructor({pdfManager:e,xref:t,pageIndex:a,pageDict:r,ref:i,fontCache:n,builtInCMapCache:s,pdfFunctionFactory:o}){this.pdfManager=e;this.pageIndex=a;this.pageDict=r;this.xref=t;this.ref=i;this.fontCache=n;this.builtInCMapCache=s;this.pdfFunctionFactory=o;this.evaluatorOptions=e.evaluatorOptions;this.resourcesPromise=null;const c={obj:0};this.idFactory={createObjId:()=>`p${a}_${++c.obj}`,getDocId:()=>`g_${e.docId}`}}_getInheritableProperty(e,t=!1){const a=(0,s.getInheritableProperty)({dict:this.pageDict,key:e,getArray:t,stopWhenFound:!1});return Array.isArray(a)?1!==a.length&&(0,n.isDict)(a[0])?n.Dict.merge(this.xref,a):a[0]:a}get content(){return this.pageDict.get("Contents")}get resources(){return(0,r.shadow)(this,"resources",this._getInheritableProperty("Resources")||n.Dict.empty)}_getBoundingBox(e){const t=this._getInheritableProperty(e,!0);if(Array.isArray(t)&&4===t.length){if(t[2]-t[0]!=0&&t[3]-t[1]!=0)return t;(0,r.warn)(`Empty /${e} entry.`)}return null}get mediaBox(){return(0,r.shadow)(this,"mediaBox",this._getBoundingBox("MediaBox")||g)}get cropBox(){return(0,r.shadow)(this,"cropBox",this._getBoundingBox("CropBox")||this.mediaBox)}get userUnit(){let e=this.pageDict.get("UserUnit");(!(0,r.isNum)(e)||e<=0)&&(e=1);return(0,r.shadow)(this,"userUnit",e)}get view(){const{cropBox:e,mediaBox:t}=this;let a;if(e===t||(0,r.isArrayEqual)(e,t))a=t;else{const i=r.Util.intersect(e,t);i&&i[2]-i[0]!=0&&i[3]-i[1]!=0?a=i:(0,r.warn)("Empty /CropBox and /MediaBox intersection.")}return(0,r.shadow)(this,"view",a||t)}get rotate(){let e=this._getInheritableProperty("Rotate")||0;e%90!=0?e=0:e>=360?e%=360:e<0&&(e=(e%360+360)%360);return(0,r.shadow)(this,"rotate",e)}getContentStream(){const e=this.content;let t;if(Array.isArray(e)){const a=this.xref,r=[];for(const t of e)r.push(a.fetchIfRef(t));t=new o.StreamsSequenceStream(r)}else t=(0,n.isStream)(e)?e:new o.NullStream;return t}loadResources(e){this.resourcesPromise||(this.resourcesPromise=this.pdfManager.ensure(this,"resources"));return this.resourcesPromise.then(()=>new i.ObjectLoader(this.resources,e,this.xref).load())}getOperatorList({handler:e,sink:t,task:a,intent:i,renderInteractiveForms:n}){const s=this.pdfManager.ensure(this,"getContentStream"),o=this.loadResources(["ExtGState","ColorSpace","Pattern","Shading","XObject","Font"]),c=new d.PartialEvaluator({xref:this.xref,handler:e,pageIndex:this.pageIndex,idFactory:this.idFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,options:this.evaluatorOptions,pdfFunctionFactory:this.pdfFunctionFactory}),l=Promise.all([s,o]).then(([r])=>{const n=new u.OperatorList(i,t,this.pageIndex);e.send("StartRenderPage",{transparency:c.hasBlendModes(this.resources),pageIndex:this.pageIndex,intent:i});return c.getOperatorList({stream:r,task:a,resources:this.resources,operatorList:n}).then((function(){return n}))});return Promise.all([l,this._parsedAnnotations]).then((function([e,t]){if(0===t.length){e.flush(!0);return{length:e.totalLength}}const s=[];for(const e of t)m(e,i)&&s.push(e.getOperatorList(c,a,n));return Promise.all(s).then((function(t){e.addOp(r.OPS.beginAnnotations,[]);for(const a of t)e.addOpList(a);e.addOp(r.OPS.endAnnotations,[]);e.flush(!0);return{length:e.totalLength}}))}))}extractTextContent({handler:e,task:t,normalizeWhitespace:a,sink:r,combineTextItems:i}){const n=this.pdfManager.ensure(this,"getContentStream"),s=this.loadResources(["ExtGState","XObject","Font"]);return Promise.all([n,s]).then(([n])=>new d.PartialEvaluator({xref:this.xref,handler:e,pageIndex:this.pageIndex,idFactory:this.idFactory,fontCache:this.fontCache,builtInCMapCache:this.builtInCMapCache,options:this.evaluatorOptions,pdfFunctionFactory:this.pdfFunctionFactory}).getTextContent({stream:n,task:t,resources:this.resources,normalizeWhitespace:a,combineTextItems:i,sink:r}))}getAnnotationsData(e){return this._parsedAnnotations.then((function(t){const a=[];for(let r=0,i=t.length;r<i;r++)e&&!m(t[r],e)||a.push(t[r].data);return a}))}get annotations(){return(0,r.shadow)(this,"annotations",this._getInheritableProperty("Annots")||[])}get _parsedAnnotations(){const e=this.pdfManager.ensure(this,"annotations").then(()=>{const e=this.annotations,t=[];for(let a=0,r=e.length;a<r;a++)t.push(c.AnnotationFactory.create(this.xref,e[a],this.pdfManager,this.idFactory));return Promise.all(t).then((function(e){return e.filter((function(e){return!!e}))}),(function(e){(0,r.warn)(`_parsedAnnotations: "${e}".`);return[]}))});return(0,r.shadow)(this,"_parsedAnnotations",e)}}t.Page=p;const b=new Uint8Array([37,80,68,70,45]),y=new Uint8Array([115,116,97,114,116,120,114,101,102]),v=new Uint8Array([101,110,100,111,98,106]),w=/^[1-9]\.[0-9]$/;function k(e,t,a=1024,r=!1){const i=t.length,n=e.peekBytes(a),s=n.length-i;if(s<=0)return!1;if(r){const a=i-1;let r=n.length-1;for(;r>=a;){let s=0;for(;s<i&&n[r-s]===t[a-s];)s++;if(s>=i){e.pos+=r-a;return!0}r--}}else{let a=0;for(;a<=s;){let r=0;for(;r<i&&n[a+r]===t[r];)r++;if(r>=i){e.pos+=a;return!0}a++}}return!1}t.PDFDocument=class{constructor(e,t){let a;if((0,n.isStream)(t))a=t;else{if(!(0,r.isArrayBuffer)(t))throw new Error("PDFDocument: Unknown argument type");a=new o.Stream(t)}if(a.length<=0)throw new r.InvalidPDFException("The PDF file is empty, i.e. its size is zero bytes.");this.pdfManager=e;this.stream=a;this.xref=new i.XRef(a,e);this.pdfFunctionFactory=new f.PDFFunctionFactory({xref:this.xref,isEvalSupported:e.evaluatorOptions.isEvalSupported});this._pagePromises=[]}parse(e){this.setup(e);const t=this.catalog.catDict.get("Version");(0,n.isName)(t)&&(this.pdfFormatVersion=t.name);try{this.acroForm=this.catalog.catDict.get("AcroForm");if(this.acroForm){this.xfa=this.acroForm.get("XFA");const e=this.acroForm.get("Fields");Array.isArray(e)&&0!==e.length||this.xfa||(this.acroForm=null)}}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.info)("Cannot fetch AcroForm entry; assuming no AcroForms are present");this.acroForm=null}try{const e=this.catalog.catDict.get("Collection");(0,n.isDict)(e)&&e.getKeys().length>0&&(this.collection=e)}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.info)("Cannot fetch Collection dictionary.")}}get linearization(){let e=null;try{e=h.Linearization.create(this.stream)}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.info)(e)}return(0,r.shadow)(this,"linearization",e)}get startXRef(){const e=this.stream;let t=0;if(this.linearization){e.reset();k(e,v)&&(t=e.pos+6-e.start)}else{const a=1024,r=y.length;let i=!1,n=e.end;for(;!i&&n>0;){n-=a-r;n<0&&(n=0);e.pos=n;i=k(e,y,a,!0)}if(i){e.skip(9);let a;do{a=e.getByte()}while((0,s.isWhiteSpace)(a));let r="";for(;a>=32&&a<=57;){r+=String.fromCharCode(a);a=e.getByte()}t=parseInt(r,10);isNaN(t)&&(t=0)}}return(0,r.shadow)(this,"startXRef",t)}checkHeader(){const e=this.stream;e.reset();if(!k(e,b))return;e.moveStart();let t,a="";for(;(t=e.getByte())>32&&!(a.length>=12);)a+=String.fromCharCode(t);this.pdfFormatVersion||(this.pdfFormatVersion=a.substring(5))}parseStartXRef(){this.xref.setStartXRef(this.startXRef)}setup(e){this.xref.parse(e);this.catalog=new i.Catalog(this.pdfManager,this.xref)}get numPages(){const e=this.linearization,t=e?e.numPages:this.catalog.numPages;return(0,r.shadow)(this,"numPages",t)}get documentInfo(){const e={Title:r.isString,Author:r.isString,Subject:r.isString,Keywords:r.isString,Creator:r.isString,Producer:r.isString,CreationDate:r.isString,ModDate:r.isString,Trapped:n.isName};let t=this.pdfFormatVersion;if("string"!=typeof t||!w.test(t)){(0,r.warn)(`Invalid PDF header version number: ${t}`);t=null}const a={PDFFormatVersion:t,IsLinearized:!!this.linearization,IsAcroFormPresent:!!this.acroForm,IsXFAPresent:!!this.xfa,IsCollectionPresent:!!this.collection};let i;try{i=this.xref.trailer.get("Info")}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.info)("The document information dictionary is invalid.")}if((0,n.isDict)(i))for(const t of i.getKeys()){const s=i.get(t);if(e[t])e[t](s)?a[t]="string"!=typeof s?s:(0,r.stringToPDFString)(s):(0,r.info)(`Bad value in document info for "${t}".`);else if("string"==typeof t){let e;if((0,r.isString)(s))e=(0,r.stringToPDFString)(s);else{if(!((0,n.isName)(s)||(0,r.isNum)(s)||(0,r.isBool)(s))){(0,r.info)(`Unsupported value in document info for (custom) "${t}".`);continue}e=s}a.Custom||(a.Custom=Object.create(null));a.Custom[t]=e}}return(0,r.shadow)(this,"documentInfo",a)}get fingerprint(){let e;const t=this.xref.trailer.get("ID");e=Array.isArray(t)&&t[0]&&(0,r.isString)(t[0])&&"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"!==t[0]?(0,r.stringToBytes)(t[0]):(0,l.calculateMD5)(this.stream.getByteRange(0,1024),0,1024);const a=[];for(let t=0,r=e.length;t<r;t++){const r=e[t].toString(16);a.push(r.padStart(2,"0"))}return(0,r.shadow)(this,"fingerprint",a.join(""))}_getLinearizationPage(e){const{catalog:t,linearization:a}=this;(0,r.assert)(a&&a.pageFirst===e);const i=n.Ref.get(a.objectNumberFirst,0);return this.xref.fetchAsync(i).then(e=>{if((0,n.isDict)(e,"Page")||(0,n.isDict)(e)&&!e.has("Type")&&e.has("Contents")){i&&!t.pageKidsCountCache.has(i)&&t.pageKidsCountCache.put(i,1);return[e,i]}throw new r.FormatError("The Linearization dictionary doesn't point to a valid Page dictionary.")}).catch(a=>{(0,r.info)(a);return t.getPageDict(e)})}getPage(e){if(void 0!==this._pagePromises[e])return this._pagePromises[e];const{catalog:t,linearization:a}=this,r=a&&a.pageFirst===e?this._getLinearizationPage(e):t.getPageDict(e);return this._pagePromises[e]=r.then(([a,r])=>new p({pdfManager:this.pdfManager,xref:this.xref,pageIndex:e,pageDict:a,ref:r,fontCache:t.fontCache,builtInCMapCache:t.builtInCMapCache,pdfFunctionFactory:this.pdfFunctionFactory}))}checkFirstPage(){return this.getPage(0).catch(async e=>{if(e instanceof s.XRefEntryException){this._pagePromises.length=0;await this.cleanup();throw new s.XRefParseException}})}fontFallback(e,t){return this.catalog.fontFallback(e,t)}async cleanup(){return this.catalog?this.catalog.cleanup():(0,n.clearPrimitiveCaches)()}}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.FileSpec=t.XRef=t.ObjectLoader=t.Catalog=void 0;var r=a(2),i=a(4),n=a(10),s=a(7),o=a(21),c=a(22);function l(e){return(0,i.isDict)(e)?e.get("D"):e}class h{constructor(e,t){this.pdfManager=e;this.xref=t;this.catDict=t.getCatalogObj();if(!(0,i.isDict)(this.catDict))throw new r.FormatError("Catalog object is not a dictionary.");this.fontCache=new i.RefSetCache;this.builtInCMapCache=new Map;this.pageKidsCountCache=new i.RefSetCache}get metadata(){const e=this.catDict.getRaw("Metadata");if(!(0,i.isRef)(e))return(0,r.shadow)(this,"metadata",null);const t=!(this.xref.encrypt&&this.xref.encrypt.encryptMetadata),a=this.xref.fetch(e,t);let n;if(a&&(0,i.isDict)(a.dict)){const e=a.dict.get("Type"),t=a.dict.get("Subtype");if((0,i.isName)(e,"Metadata")&&(0,i.isName)(t,"XML"))try{n=(0,r.stringToUTF8String)((0,r.bytesToString)(a.getBytes()))}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.info)("Skipping invalid metadata.")}}return(0,r.shadow)(this,"metadata",n)}get toplevelPagesDict(){const e=this.catDict.get("Pages");if(!(0,i.isDict)(e))throw new r.FormatError("Invalid top-level pages dictionary.");return(0,r.shadow)(this,"toplevelPagesDict",e)}get documentOutline(){let e=null;try{e=this._readDocumentOutline()}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.warn)("Unable to read document outline.")}return(0,r.shadow)(this,"documentOutline",e)}_readDocumentOutline(){let e=this.catDict.get("Outlines");if(!(0,i.isDict)(e))return null;e=e.getRaw("First");if(!(0,i.isRef)(e))return null;const t={items:[]},a=[{obj:e,parent:t}],n=new i.RefSet;n.put(e);const s=this.xref,o=new Uint8ClampedArray(3);for(;a.length>0;){const t=a.shift(),l=s.fetchIfRef(t.obj);if(null===l)continue;if(!l.has("Title"))throw new r.FormatError("Invalid outline item encountered.");const u={url:null,dest:null};h.parseDestDictionary({destDict:l,resultObj:u,docBaseUrl:this.pdfManager.docBaseUrl});const d=l.get("Title"),f=l.get("F")||0,g=l.getArray("C"),m=l.get("Count");let p=o;!Array.isArray(g)||3!==g.length||0===g[0]&&0===g[1]&&0===g[2]||(p=c.ColorSpace.singletons.rgb.getRgb(g,0));const b={dest:u.dest,url:u.url,unsafeUrl:u.unsafeUrl,newWindow:u.newWindow,title:(0,r.stringToPDFString)(d),color:p,count:Number.isInteger(m)?m:void 0,bold:!!(2&f),italic:!!(1&f),items:[]};t.parent.items.push(b);e=l.getRaw("First");if((0,i.isRef)(e)&&!n.has(e)){a.push({obj:e,parent:b});n.put(e)}e=l.getRaw("Next");if((0,i.isRef)(e)&&!n.has(e)){a.push({obj:e,parent:t.parent});n.put(e)}}return t.items.length>0?t.items:null}get permissions(){let e=null;try{e=this._readPermissions()}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.warn)("Unable to read permissions.")}return(0,r.shadow)(this,"permissions",e)}_readPermissions(){const e=this.xref.trailer.get("Encrypt");if(!(0,i.isDict)(e))return null;let t=e.get("P");if(!(0,r.isNum)(t))return null;t+=2**32;const a=[];for(const e in r.PermissionFlag){const i=r.PermissionFlag[e];t&i&&a.push(i)}return a}get numPages(){const e=this.toplevelPagesDict.get("Count");if(!Number.isInteger(e))throw new r.FormatError("Page count in top-level pages dictionary is not an integer.");return(0,r.shadow)(this,"numPages",e)}get destinations(){const e=this._readDests(),t=Object.create(null);if(e instanceof f){const a=e.getAll();for(const e in a)t[e]=l(a[e])}else e instanceof i.Dict&&e.forEach((function(e,a){a&&(t[e]=l(a))}));return(0,r.shadow)(this,"destinations",t)}getDestination(e){const t=this._readDests();return t instanceof f||t instanceof i.Dict?l(t.get(e)||null):null}_readDests(){const e=this.catDict.get("Names");return e&&e.has("Dests")?new f(e.getRaw("Dests"),this.xref):this.catDict.has("Dests")?this.catDict.get("Dests"):void 0}get pageLabels(){let e=null;try{e=this._readPageLabels()}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.warn)("Unable to read page labels.")}return(0,r.shadow)(this,"pageLabels",e)}_readPageLabels(){const e=this.catDict.getRaw("PageLabels");if(!e)return null;const t=new Array(this.numPages);let a=null,n="";const o=new g(e,this.xref).getAll();let c="",l=1;for(let e=0,h=this.numPages;e<h;e++){if(e in o){const t=o[e];if(!(0,i.isDict)(t))throw new r.FormatError("PageLabel is not a dictionary.");if(t.has("Type")&&!(0,i.isName)(t.get("Type"),"PageLabel"))throw new r.FormatError("Invalid type in PageLabel dictionary.");if(t.has("S")){const e=t.get("S");if(!(0,i.isName)(e))throw new r.FormatError("Invalid style in PageLabel dictionary.");a=e.name}else a=null;if(t.has("P")){const e=t.get("P");if(!(0,r.isString)(e))throw new r.FormatError("Invalid prefix in PageLabel dictionary.");n=(0,r.stringToPDFString)(e)}else n="";if(t.has("St")){const e=t.get("St");if(!(Number.isInteger(e)&&e>=1))throw new r.FormatError("Invalid start in PageLabel dictionary.");l=e}else l=1}switch(a){case"D":c=l;break;case"R":case"r":c=(0,s.toRomanNumerals)(l,"r"===a);break;case"A":case"a":const e=26,t=65,i=97,n="a"===a?i:t,o=l-1,h=String.fromCharCode(n+o%e),u=[];for(let t=0,a=o/e|0;t<=a;t++)u.push(h);c=u.join("");break;default:if(a)throw new r.FormatError(`Invalid style "${a}" in PageLabel dictionary.`);c=""}t[e]=n+c;l++}return t}get pageLayout(){const e=this.catDict.get("PageLayout");let t="";if((0,i.isName)(e))switch(e.name){case"SinglePage":case"OneColumn":case"TwoColumnLeft":case"TwoColumnRight":case"TwoPageLeft":case"TwoPageRight":t=e.name}return(0,r.shadow)(this,"pageLayout",t)}get pageMode(){const e=this.catDict.get("PageMode");let t="UseNone";if((0,i.isName)(e))switch(e.name){case"UseNone":case"UseOutlines":case"UseThumbs":case"FullScreen":case"UseOC":case"UseAttachments":t=e.name}return(0,r.shadow)(this,"pageMode",t)}get viewerPreferences(){const e={HideToolbar:r.isBool,HideMenubar:r.isBool,HideWindowUI:r.isBool,FitWindow:r.isBool,CenterWindow:r.isBool,DisplayDocTitle:r.isBool,NonFullScreenPageMode:i.isName,Direction:i.isName,ViewArea:i.isName,ViewClip:i.isName,PrintArea:i.isName,PrintClip:i.isName,PrintScaling:i.isName,Duplex:i.isName,PickTrayByPDFSize:r.isBool,PrintPageRange:Array.isArray,NumCopies:Number.isInteger},t=this.catDict.get("ViewerPreferences"),a=Object.create(null);if((0,i.isDict)(t))for(const i in e){if(!t.has(i))continue;const n=t.get(i);if(!e[i](n)){(0,r.info)(`Bad value in ViewerPreferences for "${i}".`);continue}let s;switch(i){case"NonFullScreenPageMode":switch(n.name){case"UseNone":case"UseOutlines":case"UseThumbs":case"UseOC":s=n.name;break;default:s="UseNone"}break;case"Direction":switch(n.name){case"L2R":case"R2L":s=n.name;break;default:s="L2R"}break;case"ViewArea":case"ViewClip":case"PrintArea":case"PrintClip":switch(n.name){case"MediaBox":case"CropBox":case"BleedBox":case"TrimBox":case"ArtBox":s=n.name;break;default:s="CropBox"}break;case"PrintScaling":switch(n.name){case"None":case"AppDefault":s=n.name;break;default:s="AppDefault"}break;case"Duplex":switch(n.name){case"Simplex":case"DuplexFlipShortEdge":case"DuplexFlipLongEdge":s=n.name;break;default:s="None"}break;case"PrintPageRange":if(n.length%2!=0)break;n.every((e,t,a)=>Number.isInteger(e)&&e>0&&(0===t||e>=a[t-1])&&e<=this.numPages)&&(s=n);break;case"NumCopies":n>0&&(s=n);break;default:(0,r.assert)("boolean"==typeof n);s=n}void 0!==s?a[i]=s:(0,r.info)(`Bad value in ViewerPreferences for "${i}".`)}return(0,r.shadow)(this,"viewerPreferences",a)}get openAction(){const e=this.catDict.get("OpenAction");let t=null;if((0,i.isDict)(e)){const a=new i.Dict(this.xref);a.set("A",e);const r={url:null,dest:null,action:null};h.parseDestDictionary({destDict:a,resultObj:r});if(Array.isArray(r.dest)){t||(t=Object.create(null));t.dest=r.dest}else if(r.action){t||(t=Object.create(null));t.action=r.action}}else if(Array.isArray(e)){t||(t=Object.create(null));t.dest=e}return(0,r.shadow)(this,"openAction",t)}get attachments(){const e=this.catDict.get("Names");let t=null;if(e&&e.has("EmbeddedFiles")){const a=new f(e.getRaw("EmbeddedFiles"),this.xref).getAll();for(const e in a){const i=new m(a[e],this.xref);t||(t=Object.create(null));t[(0,r.stringToPDFString)(e)]=i.serializable}}return(0,r.shadow)(this,"attachments",t)}get javaScript(){const e=this.catDict.get("Names");let t=null;function a(e){const a=e.get("S");if(!(0,i.isName)(a,"JavaScript"))return;let n=e.get("JS");if((0,i.isStream)(n))n=(0,r.bytesToString)(n.getBytes());else if(!(0,r.isString)(n))return;t||(t=[]);t.push((0,r.stringToPDFString)(n))}if(e&&e.has("JavaScript")){const t=new f(e.getRaw("JavaScript"),this.xref).getAll();for(const e in t){const r=t[e];(0,i.isDict)(r)&&a(r)}}const n=this.catDict.get("OpenAction");(0,i.isDict)(n)&&(0,i.isName)(n.get("S"),"JavaScript")&&a(n);return(0,r.shadow)(this,"javaScript",t)}fontFallback(e,t){const a=[];this.fontCache.forEach((function(e){a.push(e)}));return Promise.all(a).then(a=>{for(const r of a)if(r.loadedName===e){r.fallback(t);return}})}cleanup(){(0,i.clearPrimitiveCaches)();this.pageKidsCountCache.clear();const e=[];this.fontCache.forEach((function(t){e.push(t)}));return Promise.all(e).then(e=>{for(const{dict:t}of e)delete t.translated;this.fontCache.clear();this.builtInCMapCache.clear()})}getPageDict(e){const t=(0,r.createPromiseCapability)(),a=[this.catDict.getRaw("Pages")],n=new i.RefSet,s=this.xref,o=this.pageKidsCountCache;let c,l=0;!function h(){for(;a.length;){const u=a.pop();if((0,i.isRef)(u)){c=o.get(u);if(c>0&&l+c<e){l+=c;continue}if(n.has(u)){t.reject(new r.FormatError("Pages tree contains circular reference."));return}n.put(u);s.fetchAsync(u).then((function(r){if((0,i.isDict)(r,"Page")||(0,i.isDict)(r)&&!r.has("Kids"))if(e===l){u&&!o.has(u)&&o.put(u,1);t.resolve([r,u])}else{l++;h()}else{a.push(r);h()}}),t.reject);return}if(!(0,i.isDict)(u)){t.reject(new r.FormatError("Page dictionary kid reference points to wrong type of object."));return}c=u.get("Count");if(Number.isInteger(c)&&c>=0){const t=u.objId;t&&!o.has(t)&&o.put(t,c);if(l+c<=e){l+=c;continue}}const d=u.get("Kids");if(!Array.isArray(d)){if((0,i.isName)(u.get("Type"),"Page")||!u.has("Type")&&u.has("Contents")){if(l===e){t.resolve([u,null]);return}l++;continue}t.reject(new r.FormatError("Page dictionary kids object is not an array."));return}for(let e=d.length-1;e>=0;e--)a.push(d[e])}t.reject(new Error(`Page index ${e} not found.`))}();return t.promise}getPageIndex(e){const t=this.xref;let a=0;return function n(s){return function(a){let n,s=0;return t.fetchAsync(a).then((function(t){if((0,i.isRefsEqual)(a,e)&&!(0,i.isDict)(t,"Page")&&(!(0,i.isDict)(t)||t.has("Type")||!t.has("Contents")))throw new r.FormatError("The reference does not point to a /Page dictionary.");if(!t)return null;if(!(0,i.isDict)(t))throw new r.FormatError("Node must be a dictionary.");n=t.getRaw("Parent");return t.getAsync("Parent")})).then((function(e){if(!e)return null;if(!(0,i.isDict)(e))throw new r.FormatError("Parent must be a dictionary.");return e.getAsync("Kids")})).then((function(e){if(!e)return null;const o=[];let c=!1;for(let n=0,l=e.length;n<l;n++){const l=e[n];if(!(0,i.isRef)(l))throw new r.FormatError("Kid must be a reference.");if((0,i.isRefsEqual)(l,a)){c=!0;break}o.push(t.fetchAsync(l).then((function(e){if(!(0,i.isDict)(e))throw new r.FormatError("Kid node must be a dictionary.");e.has("Count")?s+=e.get("Count"):s++})))}if(!c)throw new r.FormatError("Kid reference not found in parent's kids.");return Promise.all(o).then((function(){return[s,n]}))}))}(s).then((function(e){if(!e)return a;const[t,r]=e;a+=t;return n(r)}))}(e)}static parseDestDictionary(e){const t=e.destDict;if(!(0,i.isDict)(t)){(0,r.warn)("parseDestDictionary: `destDict` must be a dictionary.");return}const a=e.resultObj;if("object"!=typeof a){(0,r.warn)("parseDestDictionary: `resultObj` must be an object.");return}const n=e.docBaseUrl||null;let s,o,c=t.get("A");!(0,i.isDict)(c)&&t.has("Dest")&&(c=t.get("Dest"));if((0,i.isDict)(c)){const e=c.get("S");if(!(0,i.isName)(e)){(0,r.warn)("parseDestDictionary: Invalid type in Action dictionary.");return}const t=e.name;switch(t){case"URI":s=c.get("URI");(0,i.isName)(s)?s="/"+s.name:(0,r.isString)(s)&&(s=function(e){return e.startsWith("www.")?`http://${e}`:e}(s));break;case"GoTo":o=c.get("D");break;case"Launch":case"GoToR":const e=c.get("F");(0,i.isDict)(e)?s=e.get("F")||null:(0,r.isString)(e)&&(s=e);let n=c.get("D");if(n){(0,i.isName)(n)&&(n=n.name);if((0,r.isString)(s)){const e=s.split("#")[0];(0,r.isString)(n)?s=e+"#"+n:Array.isArray(n)&&(s=e+"#"+JSON.stringify(n))}}const l=c.get("NewWindow");(0,r.isBool)(l)&&(a.newWindow=l);break;case"Named":const h=c.get("N");(0,i.isName)(h)&&(a.action=h.name);break;case"JavaScript":const u=c.get("JS");let d;(0,i.isStream)(u)?d=(0,r.bytesToString)(u.getBytes()):(0,r.isString)(u)&&(d=u);if(d){const e=new RegExp("^\\s*("+["app.launchURL","window.open"].join("|").split(".").join("\\.")+")\\((?:'|\")([^'\"]*)(?:'|\")(?:,\\s*(\\w+)\\)|\\))","i").exec((0,r.stringToPDFString)(d));if(e&&e[2]){s=e[2];"true"===e[3]&&"app.launchURL"===e[1]&&(a.newWindow=!0);break}}default:(0,r.warn)(`parseDestDictionary: unsupported action type "${t}".`)}}else t.has("Dest")&&(o=t.get("Dest"));if((0,r.isString)(s)){s=function(e){try{return(0,r.stringToUTF8String)(e)}catch(t){return e}}(s);const e=(0,r.createValidAbsoluteUrl)(s,n);e&&(a.url=e.href);a.unsafeUrl=s}if(o){(0,i.isName)(o)&&(o=o.name);((0,r.isString)(o)||Array.isArray(o))&&(a.dest=o)}}}t.Catalog=h;var u=function(){function e(e,t){this.stream=e;this.pdfManager=t;this.entries=[];this.xrefstms=Object.create(null);this._cacheMap=new Map;this.stats={streamTypes:Object.create(null),fontTypes:Object.create(null)}}e.prototype={setStartXRef:function(e){this.startXRefQueue=[e]},parse:function(e){var t;if(e){(0,r.warn)("Indexing all PDF objects");t=this.indexObjects()}else t=this.readXRef();t.assignXref(this);this.trailer=t;let a,n;try{a=t.get("Encrypt")}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.warn)(`XRef.parse - Invalid "Encrypt" reference: "${e}".`)}if((0,i.isDict)(a)){var c=t.get("ID"),l=c&&c.length?c[0]:"";a.suppressEncryption=!0;this.encrypt=new o.CipherTransformFactory(a,l,this.pdfManager.password)}try{n=t.get("Root")}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.warn)(`XRef.parse - Invalid "Root" reference: "${e}".`)}if(!(0,i.isDict)(n)||!n.has("Pages")){if(!e)throw new s.XRefParseException;throw new r.FormatError("Invalid root reference")}this.root=n},processXRefTable:function(e){"tableState"in this||(this.tableState={entryNum:0,streamPos:e.lexer.stream.pos,parserBuf1:e.buf1,parserBuf2:e.buf2});var t=this.readXRefTable(e);if(!(0,i.isCmd)(t,"trailer"))throw new r.FormatError("Invalid XRef table: could not find trailer dictionary");var a=e.getObj();!(0,i.isDict)(a)&&a.dict&&(a=a.dict);if(!(0,i.isDict)(a))throw new r.FormatError("Invalid XRef table: could not parse trailer dictionary");delete this.tableState;return a},readXRefTable:function(e){var t,a=e.lexer.stream,n=this.tableState;a.pos=n.streamPos;e.buf1=n.parserBuf1;e.buf2=n.parserBuf2;for(;;){if(!("firstEntryNum"in n)||!("entryCount"in n)){if((0,i.isCmd)(t=e.getObj(),"trailer"))break;n.firstEntryNum=t;n.entryCount=e.getObj()}var s=n.firstEntryNum,o=n.entryCount;if(!Number.isInteger(s)||!Number.isInteger(o))throw new r.FormatError("Invalid XRef table: wrong types in subsection header");for(var c=n.entryNum;c<o;c++){n.streamPos=a.pos;n.entryNum=c;n.parserBuf1=e.buf1;n.parserBuf2=e.buf2;var l={};l.offset=e.getObj();l.gen=e.getObj();var h=e.getObj();if(h instanceof i.Cmd)switch(h.cmd){case"f":l.free=!0;break;case"n":l.uncompressed=!0}if(!Number.isInteger(l.offset)||!Number.isInteger(l.gen)||!l.free&&!l.uncompressed)throw new r.FormatError(`Invalid entry in XRef subsection: ${s}, ${o}`);0===c&&l.free&&1===s&&(s=0);this.entries[c+s]||(this.entries[c+s]=l)}n.entryNum=0;n.streamPos=a.pos;n.parserBuf1=e.buf1;n.parserBuf2=e.buf2;delete n.firstEntryNum;delete n.entryCount}if(this.entries[0]&&!this.entries[0].free)throw new r.FormatError("Invalid XRef table: unexpected first object");return t},processXRefStream:function(e){if(!("streamState"in this)){var t=e.dict,a=t.get("W"),r=t.get("Index");r||(r=[0,t.get("Size")]);this.streamState={entryRanges:r,byteWidths:a,entryNum:0,streamPos:e.pos}}this.readXRefStream(e);delete this.streamState;return e.dict},readXRefStream:function(e){var t,a,i=this.streamState;e.pos=i.streamPos;for(var n=i.byteWidths,s=n[0],o=n[1],c=n[2],l=i.entryRanges;l.length>0;){var h=l[0],u=l[1];if(!Number.isInteger(h)||!Number.isInteger(u))throw new r.FormatError(`Invalid XRef range fields: ${h}, ${u}`);if(!Number.isInteger(s)||!Number.isInteger(o)||!Number.isInteger(c))throw new r.FormatError(`Invalid XRef entry fields length: ${h}, ${u}`);for(t=i.entryNum;t<u;++t){i.entryNum=t;i.streamPos=e.pos;var d=0,f=0,g=0;for(a=0;a<s;++a)d=d<<8|e.getByte();0===s&&(d=1);for(a=0;a<o;++a)f=f<<8|e.getByte();for(a=0;a<c;++a)g=g<<8|e.getByte();var m={};m.offset=f;m.gen=g;switch(d){case 0:m.free=!0;break;case 1:m.uncompressed=!0;break;case 2:break;default:throw new r.FormatError(`Invalid XRef entry type: ${d}`)}this.entries[h+t]||(this.entries[h+t]=m)}i.entryNum=0;i.streamPos=e.pos;l.splice(0,2)}},indexObjects:function(){function e(e,t){for(var a="",r=e[t];10!==r&&13!==r&&60!==r&&!(++t>=e.length);){a+=String.fromCharCode(r);r=e[t]}return a}function t(e,t,a){for(var r=a.length,i=e.length,n=0;t<i;){for(var s=0;s<r&&e[t+s]===a[s];)++s;if(s>=r)break;t++;n++}return n}var a=/^(\d+)\s+(\d+)\s+obj\b/;const o=/\bendobj[\b\s]$/,c=/\s+(\d+\s+\d+\s+obj[\b\s<])$/;var l=new Uint8Array([116,114,97,105,108,101,114]),h=new Uint8Array([115,116,97,114,116,120,114,101,102]);const u=new Uint8Array([111,98,106]);var d=new Uint8Array([47,88,82,101,102]);this.entries.length=0;var f=this.stream;f.pos=0;for(var g,m,p=f.getBytes(),b=f.start,y=p.length,v=[],w=[];b<y;){var k=p[b];if(9!==k&&10!==k&&13!==k&&32!==k)if(37!==k){var S,C=e(p,b);if(C.startsWith("xref")&&(4===C.length||/\s/.test(C[4]))){b+=t(p,b,l);v.push(b);b+=t(p,b,h)}else if(S=a.exec(C)){const e=0|S[1],a=0|S[2];this.entries[e]&&this.entries[e].gen!==a||(this.entries[e]={offset:b-f.start,gen:a,uncompressed:!0});let i,n=b+C.length;for(;n<p.length;){const e=n+t(p,n,u)+4;i=e-b;const a=Math.max(e-25,n),s=(0,r.bytesToString)(p.subarray(a,e));if(o.test(s))break;{const e=c.exec(s);if(e&&e[1]){(0,r.warn)('indexObjects: Found new "obj" inside of another "obj", caused by missing "endobj" -- trying to recover.');i-=e[1].length;break}}n=e}const s=p.subarray(b,b+i);var x=t(s,0,d);if(x<i&&s[x+5]<64){w.push(b-f.start);this.xrefstms[b-f.start]=1}b+=i}else if(C.startsWith("trailer")&&(7===C.length||/\s/.test(C[7]))){v.push(b);b+=t(p,b,h)}else b+=C.length+1}else do{if(++b>=y)break;k=p[b]}while(10!==k&&13!==k);else++b}for(g=0,m=w.length;g<m;++g){this.startXRefQueue.push(w[g]);this.readXRef(!0)}let A;for(g=0,m=v.length;g<m;++g){f.pos=v[g];const e=new n.Parser({lexer:new n.Lexer(f),xref:this,allowStreams:!0,recoveryMode:!0});var I=e.getObj();if(!(0,i.isCmd)(I,"trailer"))continue;const t=e.getObj();if(!(0,i.isDict)(t))continue;let a;try{a=t.get("Root")}catch(e){if(e instanceof s.MissingDataException)throw e;continue}if((0,i.isDict)(a)&&a.has("Pages")){if(t.has("ID"))return t;A=t}}if(A)return A;throw new r.InvalidPDFException("Invalid PDF structure.")},readXRef:function(e){var t=this.stream;const a=Object.create(null);try{for(;this.startXRefQueue.length;){var o=this.startXRefQueue[0];if(a[o]){(0,r.warn)("readXRef - skipping XRef table since it was already parsed.");this.startXRefQueue.shift();continue}a[o]=!0;t.pos=o+t.start;const e=new n.Parser({lexer:new n.Lexer(t),xref:this,allowStreams:!0});var c,l=e.getObj();if((0,i.isCmd)(l,"xref")){c=this.processXRefTable(e);this.topDict||(this.topDict=c);l=c.get("XRefStm");if(Number.isInteger(l)){var h=l;if(!(h in this.xrefstms)){this.xrefstms[h]=1;this.startXRefQueue.push(h)}}}else{if(!Number.isInteger(l))throw new r.FormatError("Invalid XRef stream header");if(!Number.isInteger(e.getObj())||!(0,i.isCmd)(e.getObj(),"obj")||!(0,i.isStream)(l=e.getObj()))throw new r.FormatError("Invalid XRef stream");c=this.processXRefStream(l);this.topDict||(this.topDict=c);if(!c)throw new r.FormatError("Failed to read XRef stream")}l=c.get("Prev");Number.isInteger(l)?this.startXRefQueue.push(l):(0,i.isRef)(l)&&this.startXRefQueue.push(l.num);this.startXRefQueue.shift()}return this.topDict}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.info)("(while reading XRef): "+e)}if(!e)throw new s.XRefParseException},getEntry:function(e){var t=this.entries[e];return t&&!t.free&&t.offset?t:null},fetchIfRef:function(e,t){return e instanceof i.Ref?this.fetch(e,t):e},fetch:function(e,t){if(!(e instanceof i.Ref))throw new Error("ref object is not a reference");const a=e.num,r=this._cacheMap.get(a);if(void 0!==r){r instanceof i.Dict&&!r.objId&&(r.objId=e.toString());return r}let n=this.getEntry(a);if(null===n){this._cacheMap.set(a,n);return n}n=n.uncompressed?this.fetchUncompressed(e,n,t):this.fetchCompressed(e,n,t);(0,i.isDict)(n)?n.objId=e.toString():(0,i.isStream)(n)&&(n.dict.objId=e.toString());return n},fetchUncompressed(e,t,a=!1){var r=e.gen,o=e.num;if(t.gen!==r)throw new s.XRefEntryException(`Inconsistent generation in XRef: ${e}`);var c=this.stream.makeSubStream(t.offset+this.stream.start);const l=new n.Parser({lexer:new n.Lexer(c),xref:this,allowStreams:!0});var h=l.getObj(),u=l.getObj(),d=l.getObj();if(h!==o||u!==r||!(d instanceof i.Cmd))throw new s.XRefEntryException(`Bad (uncompressed) XRef entry: ${e}`);if("obj"!==d.cmd){if(d.cmd.startsWith("obj")){o=parseInt(d.cmd.substring(3),10);if(!Number.isNaN(o))return o}throw new s.XRefEntryException(`Bad (uncompressed) XRef entry: ${e}`)}t=this.encrypt&&!a?l.getObj(this.encrypt.createCipherTransform(o,r)):l.getObj();(0,i.isStream)(t)||this._cacheMap.set(o,t);return t},fetchCompressed(e,t,a=!1){const o=t.offset,c=this.fetch(i.Ref.get(o,0));if(!(0,i.isStream)(c))throw new r.FormatError("bad ObjStm stream");const l=c.dict.get("First"),h=c.dict.get("N");if(!Number.isInteger(l)||!Number.isInteger(h))throw new r.FormatError("invalid first and n parameters for ObjStm stream");const u=new n.Parser({lexer:new n.Lexer(c),xref:this,allowStreams:!0}),d=new Array(h);for(let e=0;e<h;++e){const t=u.getObj();if(!Number.isInteger(t))throw new r.FormatError(`invalid object number in the ObjStm stream: ${t}`);const a=u.getObj();if(!Number.isInteger(a))throw new r.FormatError(`invalid object offset in the ObjStm stream: ${a}`);d[e]=t}const f=new Array(h);for(let e=0;e<h;++e){const t=u.getObj();f[e]=t;u.buf1 instanceof i.Cmd&&"endobj"===u.buf1.cmd&&u.shift();if((0,i.isStream)(t))continue;const a=d[e],r=this.entries[a];r&&r.offset===o&&r.gen===e&&this._cacheMap.set(a,t)}if(void 0===(t=f[t.gen]))throw new s.XRefEntryException(`Bad (compressed) XRef entry: ${e}`);return t},async fetchIfRefAsync(e,t){return e instanceof i.Ref?this.fetchAsync(e,t):e},async fetchAsync(e,t){try{return this.fetch(e,t)}catch(a){if(!(a instanceof s.MissingDataException))throw a;await this.pdfManager.requestRange(a.begin,a.end);return this.fetchAsync(e,t)}},getCatalogObj:function(){return this.root}};return e}();t.XRef=u;class d{constructor(e,t,a){this.constructor===d&&(0,r.unreachable)("Cannot initialize NameOrNumberTree.");this.root=e;this.xref=t;this._type=a}getAll(){const e=Object.create(null);if(!this.root)return e;const t=this.xref,a=new i.RefSet;a.put(this.root);const n=[this.root];for(;n.length>0;){const s=t.fetchIfRef(n.shift());if(!(0,i.isDict)(s))continue;if(s.has("Kids")){const e=s.get("Kids");for(let t=0,i=e.length;t<i;t++){const i=e[t];if(a.has(i))throw new r.FormatError(`Duplicate entry in "${this._type}" tree.`);n.push(i);a.put(i)}continue}const o=s.get(this._type);if(Array.isArray(o))for(let a=0,r=o.length;a<r;a+=2)e[t.fetchIfRef(o[a])]=t.fetchIfRef(o[a+1])}return e}get(e){if(!this.root)return null;const t=this.xref;let a=t.fetchIfRef(this.root),i=0;for(;a.has("Kids");){if(++i>10){(0,r.warn)(`Search depth limit reached for "${this._type}" tree.`);return null}const n=a.get("Kids");if(!Array.isArray(n))return null;let s=0,o=n.length-1;for(;s<=o;){const r=s+o>>1,i=t.fetchIfRef(n[r]).get("Limits");if(e<t.fetchIfRef(i[0]))o=r-1;else{if(!(e>t.fetchIfRef(i[1]))){a=t.fetchIfRef(n[r]);break}s=r+1}}if(s>o)return null}const n=a.get(this._type);if(Array.isArray(n)){let a=0,i=n.length-2;for(;a<=i;){const r=a+i>>1,s=r+(1&r),o=t.fetchIfRef(n[s]);if(e<o)i=s-2;else{if(!(e>o))return t.fetchIfRef(n[s+1]);a=s+2}}(0,r.info)(`Falling back to an exhaustive search, for key "${e}", `+`in "${this._type}" tree.`);for(let a=0,i=n.length;a<i;a+=2){if(t.fetchIfRef(n[a])===e){(0,r.warn)(`The "${e}" key was found at an incorrect, `+`i.e. out-of-order, position in "${this._type}" tree.`);return t.fetchIfRef(n[a+1])}}}return null}}class f extends d{constructor(e,t){super(e,t,"Names")}}class g extends d{constructor(e,t){super(e,t,"Nums")}}var m=function(){function e(e,t){if(e&&(0,i.isDict)(e)){this.xref=t;this.root=e;e.has("FS")&&(this.fs=e.get("FS"));this.description=e.has("Desc")?(0,r.stringToPDFString)(e.get("Desc")):"";e.has("RF")&&(0,r.warn)("Related file specifications are not supported");this.contentAvailable=!0;if(!e.has("EF")){this.contentAvailable=!1;(0,r.warn)("Non-embedded file specifications are not supported")}}}function t(e){return e.has("UF")?e.get("UF"):e.has("F")?e.get("F"):e.has("Unix")?e.get("Unix"):e.has("Mac")?e.get("Mac"):e.has("DOS")?e.get("DOS"):null}e.prototype={get filename(){if(!this._filename&&this.root){var e=t(this.root)||"unnamed";this._filename=(0,r.stringToPDFString)(e).replace(/\\\\/g,"\\").replace(/\\\//g,"/").replace(/\\/g,"/")}return this._filename},get content(){if(!this.contentAvailable)return null;!this.contentRef&&this.root&&(this.contentRef=t(this.root.get("EF")));var e=null;if(this.contentRef){var a=this.xref.fetchIfRef(this.contentRef);a&&(0,i.isStream)(a)?e=a.getBytes():(0,r.warn)("Embedded file specification points to non-existing/invalid content")}else(0,r.warn)("Embedded file specification does not have a content");return e},get serializable(){return{filename:this.filename,content:this.content}}};return e}();t.FileSpec=m;const p=function(){function e(e){return e instanceof i.Ref||e instanceof i.Dict||Array.isArray(e)||(0,i.isStream)(e)}function t(t,a){if(t instanceof i.Dict||(0,i.isStream)(t)){const r=t instanceof i.Dict?t:t.dict,n=r.getKeys();for(let t=0,i=n.length;t<i;t++){const i=r.getRaw(n[t]);e(i)&&a.push(i)}}else if(Array.isArray(t))for(let r=0,i=t.length;r<i;r++){const i=t[r];e(i)&&a.push(i)}}function a(e,t,a){this.dict=e;this.keys=t;this.xref=a;this.refSet=null}a.prototype={async load(){if(!this.xref.stream.allChunksLoaded||this.xref.stream.allChunksLoaded())return;const{keys:e,dict:t}=this;this.refSet=new i.RefSet;const a=[];for(let r=0,i=e.length;r<i;r++){const i=t.getRaw(e[r]);void 0!==i&&a.push(i)}return this._walk(a)},async _walk(e){const a=[],r=[];for(;e.length;){let n=e.pop();if(n instanceof i.Ref){if(this.refSet.has(n))continue;try{this.refSet.put(n);n=this.xref.fetch(n)}catch(e){if(!(e instanceof s.MissingDataException))throw e;a.push(n);r.push({begin:e.begin,end:e.end})}}if(n&&n.getBaseStreams){const e=n.getBaseStreams();let t=!1;for(let a=0,i=e.length;a<i;a++){const i=e[a];if(i.allChunksLoaded&&!i.allChunksLoaded()){t=!0;r.push({begin:i.start,end:i.end})}}t&&a.push(n)}t(n,e)}if(r.length){await this.xref.stream.manager.requestRanges(r);for(let e=0,t=a.length;e<t;e++){const t=a[e];t instanceof i.Ref&&this.refSet.remove(t)}return this._walk(a)}this.refSet=null}};return a}();t.ObjectLoader=p},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.Parser=t.Linearization=t.Lexer=void 0;var r=a(11),i=a(2),n=a(4),s=a(7),o=a(12),c=a(14),l=a(17),h=a(19);function u(e){const t=e.length;let a=1,r=0;for(let i=0;i<t;++i){a+=255&e[i];r+=a}return r%65521<<16|a%65521}class d{constructor({lexer:e,xref:t,allowStreams:a=!1,recoveryMode:r=!1}){this.lexer=e;this.xref=t;this.allowStreams=a;this.recoveryMode=r;this.imageCache=Object.create(null);this.refill()}refill(){this.buf1=this.lexer.getObj();this.buf2=this.lexer.getObj()}shift(){if(this.buf2 instanceof n.Cmd&&"ID"===this.buf2.cmd){this.buf1=this.buf2;this.buf2=null}else{this.buf1=this.buf2;this.buf2=this.lexer.getObj()}}tryShift(){try{this.shift();return!0}catch(e){if(e instanceof s.MissingDataException)throw e;return!1}}getObj(e=null){const t=this.buf1;this.shift();if(t instanceof n.Cmd)switch(t.cmd){case"BI":return this.makeInlineImage(e);case"[":const a=[];for(;!(0,n.isCmd)(this.buf1,"]")&&!(0,n.isEOF)(this.buf1);)a.push(this.getObj(e));if((0,n.isEOF)(this.buf1)){if(!this.recoveryMode)throw new i.FormatError("End of file inside array");return a}this.shift();return a;case"<<":const r=new n.Dict(this.xref);for(;!(0,n.isCmd)(this.buf1,">>")&&!(0,n.isEOF)(this.buf1);){if(!(0,n.isName)(this.buf1)){(0,i.info)("Malformed dictionary: key must be a name object");this.shift();continue}const t=this.buf1.name;this.shift();if((0,n.isEOF)(this.buf1))break;r.set(t,this.getObj(e))}if((0,n.isEOF)(this.buf1)){if(!this.recoveryMode)throw new i.FormatError("End of file inside dictionary");return r}if((0,n.isCmd)(this.buf2,"stream"))return this.allowStreams?this.makeStream(r,e):r;this.shift();return r;default:return t}if(Number.isInteger(t)){if(Number.isInteger(this.buf1)&&(0,n.isCmd)(this.buf2,"R")){const e=n.Ref.get(t,this.buf1);this.shift();this.shift();return e}return t}return"string"==typeof t&&e?e.decryptString(t):t}findDefaultInlineStreamEnd(e){const t=e.pos;let a,r,n=0;for(;-1!==(a=e.getByte());)if(0===n)n=69===a?1:0;else if(1===n)n=73===a?2:0;else{(0,i.assert)(2===n);if(32===a||10===a||13===a){r=e.pos;const t=e.peekBytes(10);for(let e=0,r=t.length;e<r;e++){a=t[e];if((0!==a||0===t[e+1])&&(10!==a&&13!==a&&(a<32||a>127))){n=0;break}}if(2===n)break}else n=0}if(-1===a){(0,i.warn)("findDefaultInlineStreamEnd: Reached the end of the stream without finding a valid EI marker");if(r){(0,i.warn)('... trying to recover by using the last "EI" occurrence.');e.skip(-(e.pos-r))}}let o=4;e.skip(-o);a=e.peekByte();e.skip(o);(0,s.isWhiteSpace)(a)||o--;return e.pos-o-t}findDCTDecodeInlineStreamEnd(e){const t=e.pos;let a,r,n=!1;for(;-1!==(a=e.getByte());)if(255===a){switch(e.getByte()){case 0:break;case 255:e.skip(-1);break;case 217:n=!0;break;case 192:case 193:case 194:case 195:case 197:case 198:case 199:case 201:case 202:case 203:case 205:case 206:case 207:case 196:case 204:case 218:case 219:case 220:case 221:case 222:case 223:case 224:case 225:case 226:case 227:case 228:case 229:case 230:case 231:case 232:case 233:case 234:case 235:case 236:case 237:case 238:case 239:case 254:r=e.getUint16();r>2?e.skip(r-2):e.skip(-2)}if(n)break}const s=e.pos-t;if(-1===a){(0,i.warn)("Inline DCTDecode image stream: EOI marker not found, searching for /EI/ instead.");e.skip(-s);return this.findDefaultInlineStreamEnd(e)}this.inlineStreamSkipEI(e);return s}findASCII85DecodeInlineStreamEnd(e){const t=e.pos;let a;for(;-1!==(a=e.getByte());)if(126===a){const t=e.pos;a=e.peekByte();for(;(0,s.isWhiteSpace)(a);){e.skip();a=e.peekByte()}if(62===a){e.skip();break}if(e.pos>t){const t=e.peekBytes(2);if(69===t[0]&&73===t[1])break}}const r=e.pos-t;if(-1===a){(0,i.warn)("Inline ASCII85Decode image stream: EOD marker not found, searching for /EI/ instead.");e.skip(-r);return this.findDefaultInlineStreamEnd(e)}this.inlineStreamSkipEI(e);return r}findASCIIHexDecodeInlineStreamEnd(e){const t=e.pos;let a;for(;-1!==(a=e.getByte())&&62!==a;);const r=e.pos-t;if(-1===a){(0,i.warn)("Inline ASCIIHexDecode image stream: EOD marker not found, searching for /EI/ instead.");e.skip(-r);return this.findDefaultInlineStreamEnd(e)}this.inlineStreamSkipEI(e);return r}inlineStreamSkipEI(e){let t,a=0;for(;-1!==(t=e.getByte());)if(0===a)a=69===t?1:0;else if(1===a)a=73===t?2:0;else if(2===a)break}makeInlineImage(e){const t=this.lexer,a=t.stream,r=new n.Dict(this.xref);let s;for(;!(0,n.isCmd)(this.buf1,"ID")&&!(0,n.isEOF)(this.buf1);){if(!(0,n.isName)(this.buf1))throw new i.FormatError("Dictionary key must be a name object");const t=this.buf1.name;this.shift();if((0,n.isEOF)(this.buf1))break;r.set(t,this.getObj(e))}-1!==t.beginInlineImagePos&&(s=a.pos-t.beginInlineImagePos);const o=r.get("Filter","F");let c;if((0,n.isName)(o))c=o.name;else if(Array.isArray(o)){const e=this.xref.fetchIfRef(o[0]);(0,n.isName)(e)&&(c=e.name)}const l=a.pos;let h;h="DCTDecode"===c||"DCT"===c?this.findDCTDecodeInlineStreamEnd(a):"ASCII85Decode"===c||"A85"===c?this.findASCII85DecodeInlineStreamEnd(a):"ASCIIHexDecode"===c||"AHx"===c?this.findASCIIHexDecodeInlineStreamEnd(a):this.findDefaultInlineStreamEnd(a);let d,f=a.makeSubStream(l,h,r);if(h<1e3&&s<5552){const e=f.getBytes();f.reset();const r=a.pos;a.pos=t.beginInlineImagePos;const i=a.getBytes(s);a.pos=r;d=u(e)+"_"+u(i);const o=this.imageCache[d];if(void 0!==o){this.buf2=n.Cmd.get("EI");this.shift();o.reset();return o}}e&&(f=e.createStream(f,h));f=this.filter(f,r,h);f.dict=r;if(void 0!==d){f.cacheKey=`inline_${h}_${d}`;this.imageCache[d]=f}this.buf2=n.Cmd.get("EI");this.shift();return f}_findStreamLength(e,t){const{stream:a}=this.lexer;a.pos=e;const r=t.length;for(;a.pos<a.end;){const i=a.peekBytes(2048),n=i.length-r;if(n<=0)break;let s=0;for(;s<n;){let n=0;for(;n<r&&i[s+n]===t[n];)n++;if(n>=r){a.pos+=s;return a.pos-e}s++}a.pos+=n}return-1}makeStream(e,t){const a=this.lexer;let r=a.stream;a.skipToNextLine();const o=r.pos-1;let c=e.get("Length");if(!Number.isInteger(c)){(0,i.info)(`Bad length "${c}" in stream`);c=0}r.pos=o+c;a.nextChar();if(this.tryShift()&&(0,n.isCmd)(this.buf2,"endstream"))this.shift();else{const e=new Uint8Array([101,110,100,115,116,114,101,97,109]);let t=this._findStreamLength(o,e);if(t<0){const a=1;for(let n=1;n<=a;n++){const a=e.length-n,c=e.slice(0,a),l=this._findStreamLength(o,c);if(l>=0){const e=r.peekBytes(a+1)[a];if(!(0,s.isWhiteSpace)(e))break;(0,i.info)(`Found "${(0,i.bytesToString)(c)}" when `+"searching for endstream command.");t=l;break}}if(t<0)throw new i.FormatError("Missing endstream command.")}c=t;a.nextChar();this.shift();this.shift()}this.shift();r=r.makeSubStream(o,c,e);t&&(r=t.createStream(r,c));r=this.filter(r,e,c);r.dict=e;return r}filter(e,t,a){let r=t.get("Filter","F"),s=t.get("DecodeParms","DP");if((0,n.isName)(r)){Array.isArray(s)&&(0,i.warn)("/DecodeParms should not contain an Array, when /Filter contains a Name.");return this.makeFilter(e,r.name,a,s)}let o=a;if(Array.isArray(r)){const t=r,a=s;for(let c=0,l=t.length;c<l;++c){r=this.xref.fetchIfRef(t[c]);if(!(0,n.isName)(r))throw new i.FormatError(`Bad filter name "${r}"`);s=null;Array.isArray(a)&&c in a&&(s=this.xref.fetchIfRef(a[c]));e=this.makeFilter(e,r.name,o,s);o=null}}return e}makeFilter(e,t,a,n){if(0===a){(0,i.warn)(`Empty "${t}" stream.`);return new r.NullStream}try{const s=this.xref.stats.streamTypes;if("FlateDecode"===t||"Fl"===t){s[i.StreamType.FLATE]=!0;return n?new r.PredictorStream(new r.FlateStream(e,a),a,n):new r.FlateStream(e,a)}if("LZWDecode"===t||"LZW"===t){s[i.StreamType.LZW]=!0;let t=1;if(n){n.has("EarlyChange")&&(t=n.get("EarlyChange"));return new r.PredictorStream(new r.LZWStream(e,a,t),a,n)}return new r.LZWStream(e,a,t)}if("DCTDecode"===t||"DCT"===t){s[i.StreamType.DCT]=!0;return new l.JpegStream(e,a,e.dict,n)}if("JPXDecode"===t||"JPX"===t){s[i.StreamType.JPX]=!0;return new h.JpxStream(e,a,e.dict,n)}if("ASCII85Decode"===t||"A85"===t){s[i.StreamType.A85]=!0;return new r.Ascii85Stream(e,a)}if("ASCIIHexDecode"===t||"AHx"===t){s[i.StreamType.AHX]=!0;return new r.AsciiHexStream(e,a)}if("CCITTFaxDecode"===t||"CCF"===t){s[i.StreamType.CCF]=!0;return new o.CCITTFaxStream(e,a,n)}if("RunLengthDecode"===t||"RL"===t){s[i.StreamType.RLX]=!0;return new r.RunLengthStream(e,a)}if("JBIG2Decode"===t){s[i.StreamType.JBIG]=!0;return new c.Jbig2Stream(e,a,e.dict,n)}(0,i.warn)(`Filter "${t}" is not supported.`);return e}catch(e){if(e instanceof s.MissingDataException)throw e;(0,i.warn)(`Invalid stream: "${e}"`);return new r.NullStream}}}t.Parser=d;const f=[1,0,0,0,0,0,0,0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,2,0,0,2,2,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];function g(e){return e>=48&&e<=57?15&e:e>=65&&e<=70||e>=97&&e<=102?9+(15&e):-1}class m{constructor(e,t=null){this.stream=e;this.nextChar();this.strBuf=[];this.knownCommands=t;this._hexStringNumWarn=0;this.beginInlineImagePos=-1}nextChar(){return this.currentChar=this.stream.getByte()}peekChar(){return this.stream.peekByte()}getNumber(){let e=this.currentChar,t=!1,a=0,r=0;if(45===e){r=-1;e=this.nextChar();45===e&&(e=this.nextChar())}else if(43===e){r=1;e=this.nextChar()}if(10===e||13===e)do{e=this.nextChar()}while(10===e||13===e);if(46===e){a=10;e=this.nextChar()}if(e<48||e>57){if(10===a&&0===r&&((0,s.isWhiteSpace)(e)||-1===e)){(0,i.warn)("Lexer.getNumber - treating a single decimal point as zero.");return 0}throw new i.FormatError(`Invalid number: ${String.fromCharCode(e)} (charCode ${e})`)}r=r||1;let n=e-48,o=0,c=1;for(;(e=this.nextChar())>=0;)if(e>=48&&e<=57){const r=e-48;if(t)o=10*o+r;else{0!==a&&(a*=10);n=10*n+r}}else if(46===e){if(0!==a)break;a=1}else if(45===e)(0,i.warn)("Badly formatted number: minus sign in the middle");else{if(69!==e&&101!==e)break;e=this.peekChar();if(43===e||45===e){c=45===e?-1:1;this.nextChar()}else if(e<48||e>57)break;t=!0}0!==a&&(n/=a);t&&(n*=10**(c*o));return r*n}getString(){let e=1,t=!1;const a=this.strBuf;a.length=0;let r=this.nextChar();for(;;){let n=!1;switch(0|r){case-1:(0,i.warn)("Unterminated string");t=!0;break;case 40:++e;a.push("(");break;case 41:if(0==--e){this.nextChar();t=!0}else a.push(")");break;case 92:r=this.nextChar();switch(r){case-1:(0,i.warn)("Unterminated string");t=!0;break;case 110:a.push("\n");break;case 114:a.push("\r");break;case 116:a.push("\t");break;case 98:a.push("\b");break;case 102:a.push("\f");break;case 92:case 40:case 41:a.push(String.fromCharCode(r));break;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:let e=15&r;r=this.nextChar();n=!0;if(r>=48&&r<=55){e=(e<<3)+(15&r);r=this.nextChar();if(r>=48&&r<=55){n=!1;e=(e<<3)+(15&r)}}a.push(String.fromCharCode(e));break;case 13:10===this.peekChar()&&this.nextChar();break;case 10:break;default:a.push(String.fromCharCode(r))}break;default:a.push(String.fromCharCode(r))}if(t)break;n||(r=this.nextChar())}return a.join("")}getName(){let e,t;const a=this.strBuf;a.length=0;for(;(e=this.nextChar())>=0&&!f[e];)if(35===e){e=this.nextChar();if(f[e]){(0,i.warn)("Lexer_getName: NUMBER SIGN (#) should be followed by a hexadecimal number.");a.push("#");break}const r=g(e);if(-1!==r){t=e;e=this.nextChar();const n=g(e);if(-1===n){(0,i.warn)(`Lexer_getName: Illegal digit (${String.fromCharCode(e)}) `+"in hexadecimal number.");a.push("#",String.fromCharCode(t));if(f[e])break;a.push(String.fromCharCode(e));continue}a.push(String.fromCharCode(r<<4|n))}else a.push("#",String.fromCharCode(e))}else a.push(String.fromCharCode(e));a.length>127&&(0,i.warn)(`Name token is longer than allowed by the spec: ${a.length}`);return n.Name.get(a.join(""))}_hexStringWarn(e){5!=this._hexStringNumWarn++?this._hexStringNumWarn>5||(0,i.warn)(`getHexString - ignoring invalid character: ${e}`):(0,i.warn)("getHexString - ignoring additional invalid characters.")}getHexString(){const e=this.strBuf;e.length=0;let t,a,r=this.currentChar,n=!0;this._hexStringNumWarn=0;for(;;){if(r<0){(0,i.warn)("Unterminated hex string");break}if(62===r){this.nextChar();break}if(1!==f[r]){if(n){t=g(r);if(-1===t){this._hexStringWarn(r);r=this.nextChar();continue}}else{a=g(r);if(-1===a){this._hexStringWarn(r);r=this.nextChar();continue}e.push(String.fromCharCode(t<<4|a))}n=!n;r=this.nextChar()}else r=this.nextChar()}return e.join("")}getObj(){let e=!1,t=this.currentChar;for(;;){if(t<0)return n.EOF;if(e)10!==t&&13!==t||(e=!1);else if(37===t)e=!0;else if(1!==f[t])break;t=this.nextChar()}switch(0|t){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 43:case 45:case 46:return this.getNumber();case 40:return this.getString();case 47:return this.getName();case 91:this.nextChar();return n.Cmd.get("[");case 93:this.nextChar();return n.Cmd.get("]");case 60:t=this.nextChar();if(60===t){this.nextChar();return n.Cmd.get("<<")}return this.getHexString();case 62:t=this.nextChar();if(62===t){this.nextChar();return n.Cmd.get(">>")}return n.Cmd.get(">");case 123:this.nextChar();return n.Cmd.get("{");case 125:this.nextChar();return n.Cmd.get("}");case 41:this.nextChar();throw new i.FormatError(`Illegal character: ${t}`)}let a=String.fromCharCode(t);const r=this.knownCommands;let s=r&&void 0!==r[a];for(;(t=this.nextChar())>=0&&!f[t];){const e=a+String.fromCharCode(t);if(s&&void 0===r[e])break;if(128===a.length)throw new i.FormatError(`Command token too long: ${a.length}`);a=e;s=r&&void 0!==r[a]}if("true"===a)return!0;if("false"===a)return!1;if("null"===a)return null;"BI"===a&&(this.beginInlineImagePos=this.stream.pos);return n.Cmd.get(a)}skipToNextLine(){let e=this.currentChar;for(;e>=0;){if(13===e){e=this.nextChar();10===e&&this.nextChar();break}if(10===e){this.nextChar();break}e=this.nextChar()}}}t.Lexer=m;t.Linearization=class{static create(e){function t(e,t,a=!1){const r=e.get(t);if(Number.isInteger(r)&&(a?r>=0:r>0))return r;throw new Error(`The "${t}" parameter in the linearization `+"dictionary is invalid.")}const a=new d({lexer:new m(e),xref:null}),r=a.getObj(),s=a.getObj(),o=a.getObj(),c=a.getObj();let l,h;if(!(Number.isInteger(r)&&Number.isInteger(s)&&(0,n.isCmd)(o,"obj")&&(0,n.isDict)(c)&&(0,i.isNum)(l=c.get("Linearized"))&&l>0))return null;if((h=t(c,"L"))!==e.length)throw new Error('The "L" parameter in the linearization dictionary does not equal the stream length.');return{length:h,hints:function(e){const t=e.get("H");let a;if(Array.isArray(t)&&(2===(a=t.length)||4===a)){for(let e=0;e<a;e++){const a=t[e];if(!(Number.isInteger(a)&&a>0))throw new Error(`Hint (${e}) in the linearization dictionary is invalid.`)}return t}throw new Error("Hint array in the linearization dictionary is invalid.")}(c),objectNumberFirst:t(c,"O"),endFirst:t(c,"E"),numPages:t(c,"N"),mainXRefEntriesOffset:t(c,"T"),pageFirst:c.has("P")?t(c,"P",!0):0}}}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.LZWStream=t.StringStream=t.StreamsSequenceStream=t.Stream=t.RunLengthStream=t.PredictorStream=t.NullStream=t.FlateStream=t.DecodeStream=t.DecryptStream=t.AsciiHexStream=t.Ascii85Stream=void 0;var r=a(2),i=a(4),n=a(7),s=function(){function e(e,t,a,r){this.bytes=e instanceof Uint8Array?e:new Uint8Array(e);this.start=t||0;this.pos=this.start;this.end=t+a||this.bytes.length;this.dict=r}e.prototype={get length(){return this.end-this.start},get isEmpty(){return 0===this.length},getByte:function(){return this.pos>=this.end?-1:this.bytes[this.pos++]},getUint16:function(){var e=this.getByte(),t=this.getByte();return-1===e||-1===t?-1:(e<<8)+t},getInt32:function(){return(this.getByte()<<24)+(this.getByte()<<16)+(this.getByte()<<8)+this.getByte()},getBytes(e,t=!1){var a=this.bytes,r=this.pos,i=this.end;if(!e){const e=a.subarray(r,i);return t?new Uint8ClampedArray(e):e}var n=r+e;n>i&&(n=i);this.pos=n;const s=a.subarray(r,n);return t?new Uint8ClampedArray(s):s},peekByte:function(){var e=this.getByte();-1!==e&&this.pos--;return e},peekBytes(e,t=!1){var a=this.getBytes(e,t);this.pos-=a.length;return a},getByteRange(e,t){e<0&&(e=0);t>this.end&&(t=this.end);return this.bytes.subarray(e,t)},skip:function(e){e||(e=1);this.pos+=e},reset:function(){this.pos=this.start},moveStart:function(){this.start=this.pos},makeSubStream:function(t,a,r){return new e(this.bytes.buffer,t,a,r)}};return e}();t.Stream=s;var o=function(){function e(e){const t=(0,r.stringToBytes)(e);s.call(this,t)}e.prototype=s.prototype;return e}();t.StringStream=o;var c=function(){var e=new Uint8Array(0);function t(t){this._rawMinBufferLength=t||0;this.pos=0;this.bufferLength=0;this.eof=!1;this.buffer=e;this.minBufferLength=512;if(t)for(;this.minBufferLength<t;)this.minBufferLength*=2}t.prototype={get isEmpty(){for(;!this.eof&&0===this.bufferLength;)this.readBlock();return 0===this.bufferLength},ensureBuffer:function(e){var t=this.buffer;if(e<=t.byteLength)return t;for(var a=this.minBufferLength;a<e;)a*=2;var r=new Uint8Array(a);r.set(t);return this.buffer=r},getByte:function(){for(var e=this.pos;this.bufferLength<=e;){if(this.eof)return-1;this.readBlock()}return this.buffer[this.pos++]},getUint16:function(){var e=this.getByte(),t=this.getByte();return-1===e||-1===t?-1:(e<<8)+t},getInt32:function(){return(this.getByte()<<24)+(this.getByte()<<16)+(this.getByte()<<8)+this.getByte()},getBytes(e,t=!1){var a,r=this.pos;if(e){this.ensureBuffer(r+e);a=r+e;for(;!this.eof&&this.bufferLength<a;)this.readBlock();var i=this.bufferLength;a>i&&(a=i)}else{for(;!this.eof;)this.readBlock();a=this.bufferLength}this.pos=a;const n=this.buffer.subarray(r,a);return!t||n instanceof Uint8ClampedArray?n:new Uint8ClampedArray(n)},peekByte:function(){var e=this.getByte();-1!==e&&this.pos--;return e},peekBytes(e,t=!1){var a=this.getBytes(e,t);this.pos-=a.length;return a},makeSubStream:function(e,t,a){for(var r=e+t;this.bufferLength<=r&&!this.eof;)this.readBlock();return new s(this.buffer,e,t,a)},getByteRange(e,t){(0,r.unreachable)("Should not call DecodeStream.getByteRange")},skip:function(e){e||(e=1);this.pos+=e},reset:function(){this.pos=0},getBaseStreams:function(){return this.str&&this.str.getBaseStreams?this.str.getBaseStreams():[]}};return t}();t.DecodeStream=c;var l=function(){function e(e){this.streams=e;let t=0;for(let a=0,r=e.length;a<r;a++){const r=e[a];t+=r instanceof c?r._rawMinBufferLength:r.length}c.call(this,t)}e.prototype=Object.create(c.prototype);e.prototype.readBlock=function(){var e=this.streams;if(0!==e.length){var t=e.shift().getBytes(),a=this.bufferLength,r=a+t.length;this.ensureBuffer(r).set(t,a);this.bufferLength=r}else this.eof=!0};e.prototype.getBaseStreams=function(){for(var e=[],t=0,a=this.streams.length;t<a;t++){var r=this.streams[t];r.getBaseStreams&&e.push(...r.getBaseStreams())}return e};return e}();t.StreamsSequenceStream=l;var h=function(){var e=new Int32Array([16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]),t=new Int32Array([3,4,5,6,7,8,9,10,65547,65549,65551,65553,131091,131095,131099,131103,196643,196651,196659,196667,262211,262227,262243,262259,327811,327843,327875,327907,258,258,258]),a=new Int32Array([1,2,3,4,65541,65543,131081,131085,196625,196633,262177,262193,327745,327777,393345,393409,459009,459137,524801,525057,590849,591361,657409,658433,724993,727041,794625,798721,868353,876545]),i=[new Int32Array([459008,524368,524304,524568,459024,524400,524336,590016,459016,524384,524320,589984,524288,524416,524352,590048,459012,524376,524312,589968,459028,524408,524344,590032,459020,524392,524328,59e4,524296,524424,524360,590064,459010,524372,524308,524572,459026,524404,524340,590024,459018,524388,524324,589992,524292,524420,524356,590056,459014,524380,524316,589976,459030,524412,524348,590040,459022,524396,524332,590008,524300,524428,524364,590072,459009,524370,524306,524570,459025,524402,524338,590020,459017,524386,524322,589988,524290,524418,524354,590052,459013,524378,524314,589972,459029,524410,524346,590036,459021,524394,524330,590004,524298,524426,524362,590068,459011,524374,524310,524574,459027,524406,524342,590028,459019,524390,524326,589996,524294,524422,524358,590060,459015,524382,524318,589980,459031,524414,524350,590044,459023,524398,524334,590012,524302,524430,524366,590076,459008,524369,524305,524569,459024,524401,524337,590018,459016,524385,524321,589986,524289,524417,524353,590050,459012,524377,524313,589970,459028,524409,524345,590034,459020,524393,524329,590002,524297,524425,524361,590066,459010,524373,524309,524573,459026,524405,524341,590026,459018,524389,524325,589994,524293,524421,524357,590058,459014,524381,524317,589978,459030,524413,524349,590042,459022,524397,524333,590010,524301,524429,524365,590074,459009,524371,524307,524571,459025,524403,524339,590022,459017,524387,524323,589990,524291,524419,524355,590054,459013,524379,524315,589974,459029,524411,524347,590038,459021,524395,524331,590006,524299,524427,524363,590070,459011,524375,524311,524575,459027,524407,524343,590030,459019,524391,524327,589998,524295,524423,524359,590062,459015,524383,524319,589982,459031,524415,524351,590046,459023,524399,524335,590014,524303,524431,524367,590078,459008,524368,524304,524568,459024,524400,524336,590017,459016,524384,524320,589985,524288,524416,524352,590049,459012,524376,524312,589969,459028,524408,524344,590033,459020,524392,524328,590001,524296,524424,524360,590065,459010,524372,524308,524572,459026,524404,524340,590025,459018,524388,524324,589993,524292,524420,524356,590057,459014,524380,524316,589977,459030,524412,524348,590041,459022,524396,524332,590009,524300,524428,524364,590073,459009,524370,524306,524570,459025,524402,524338,590021,459017,524386,524322,589989,524290,524418,524354,590053,459013,524378,524314,589973,459029,524410,524346,590037,459021,524394,524330,590005,524298,524426,524362,590069,459011,524374,524310,524574,459027,524406,524342,590029,459019,524390,524326,589997,524294,524422,524358,590061,459015,524382,524318,589981,459031,524414,524350,590045,459023,524398,524334,590013,524302,524430,524366,590077,459008,524369,524305,524569,459024,524401,524337,590019,459016,524385,524321,589987,524289,524417,524353,590051,459012,524377,524313,589971,459028,524409,524345,590035,459020,524393,524329,590003,524297,524425,524361,590067,459010,524373,524309,524573,459026,524405,524341,590027,459018,524389,524325,589995,524293,524421,524357,590059,459014,524381,524317,589979,459030,524413,524349,590043,459022,524397,524333,590011,524301,524429,524365,590075,459009,524371,524307,524571,459025,524403,524339,590023,459017,524387,524323,589991,524291,524419,524355,590055,459013,524379,524315,589975,459029,524411,524347,590039,459021,524395,524331,590007,524299,524427,524363,590071,459011,524375,524311,524575,459027,524407,524343,590031,459019,524391,524327,589999,524295,524423,524359,590063,459015,524383,524319,589983,459031,524415,524351,590047,459023,524399,524335,590015,524303,524431,524367,590079]),9],n=[new Int32Array([327680,327696,327688,327704,327684,327700,327692,327708,327682,327698,327690,327706,327686,327702,327694,0,327681,327697,327689,327705,327685,327701,327693,327709,327683,327699,327691,327707,327687,327703,327695,0]),5];function s(e,t){this.str=e;this.dict=e.dict;var a=e.getByte(),i=e.getByte();if(-1===a||-1===i)throw new r.FormatError(`Invalid header in flate stream: ${a}, ${i}`);if(8!=(15&a))throw new r.FormatError(`Unknown compression method in flate stream: ${a}, ${i}`);if(((a<<8)+i)%31!=0)throw new r.FormatError(`Bad FCHECK in flate stream: ${a}, ${i}`);if(32&i)throw new r.FormatError(`FDICT bit set in flate stream: ${a}, ${i}`);this.codeSize=0;this.codeBuf=0;c.call(this,t)}s.prototype=Object.create(c.prototype);s.prototype.getBits=function(e){for(var t,a=this.str,i=this.codeSize,n=this.codeBuf;i<e;){if(-1===(t=a.getByte()))throw new r.FormatError("Bad encoding in flate stream");n|=t<<i;i+=8}t=n&(1<<e)-1;this.codeBuf=n>>e;this.codeSize=i-=e;return t};s.prototype.getCode=function(e){for(var t,a=this.str,i=e[0],n=e[1],s=this.codeSize,o=this.codeBuf;s<n&&-1!==(t=a.getByte());){o|=t<<s;s+=8}var c=i[o&(1<<n)-1],l=c>>16,h=65535&c;if(l<1||s<l)throw new r.FormatError("Bad encoding in flate stream");this.codeBuf=o>>l;this.codeSize=s-l;return h};s.prototype.generateHuffmanTable=function(e){var t,a=e.length,r=0;for(t=0;t<a;++t)e[t]>r&&(r=e[t]);for(var i=1<<r,n=new Int32Array(i),s=1,o=0,c=2;s<=r;++s,o<<=1,c<<=1)for(var l=0;l<a;++l)if(e[l]===s){var h=0,u=o;for(t=0;t<s;++t){h=h<<1|1&u;u>>=1}for(t=h;t<i;t+=c)n[t]=s<<16|l;++o}return[n,r]};s.prototype.readBlock=function(){var s,o,c=this.str,l=this.getBits(3);1&l&&(this.eof=!0);if(0!==(l>>=1)){var h,u;if(1===l){h=i;u=n}else{if(2!==l)throw new r.FormatError("Unknown block type in flate stream");var d,f=this.getBits(5)+257,g=this.getBits(5)+1,m=this.getBits(4)+4,p=new Uint8Array(e.length);for(d=0;d<m;++d)p[e[d]]=this.getBits(3);var b=this.generateHuffmanTable(p);o=0;d=0;for(var y,v,w,k=f+g,S=new Uint8Array(k);d<k;){var C=this.getCode(b);if(16===C){y=2;v=3;w=o}else if(17===C){y=3;v=3;w=o=0}else{if(18!==C){S[d++]=o=C;continue}y=7;v=11;w=o=0}for(var x=this.getBits(y)+v;x-- >0;)S[d++]=w}h=this.generateHuffmanTable(S.subarray(0,f));u=this.generateHuffmanTable(S.subarray(f,k))}for(var A=(s=this.buffer)?s.length:0,I=this.bufferLength;;){var F=this.getCode(h);if(F<256){I+1>=A&&(A=(s=this.ensureBuffer(I+1)).length);s[I++]=F}else{if(256===F){this.bufferLength=I;return}var T=(F=t[F-=257])>>16;T>0&&(T=this.getBits(T));o=(65535&F)+T;F=this.getCode(u);(T=(F=a[F])>>16)>0&&(T=this.getBits(T));var E=(65535&F)+T;I+o>=A&&(A=(s=this.ensureBuffer(I+o)).length);for(var O=0;O<o;++O,++I)s[I]=s[I-E]}}}else{var P;if(-1===(P=c.getByte()))throw new r.FormatError("Bad block header in flate stream");var B=P;if(-1===(P=c.getByte()))throw new r.FormatError("Bad block header in flate stream");B|=P<<8;if(-1===(P=c.getByte()))throw new r.FormatError("Bad block header in flate stream");var D=P;if(-1===(P=c.getByte()))throw new r.FormatError("Bad block header in flate stream");if((D|=P<<8)!==(65535&~B)&&(0!==B||0!==D))throw new r.FormatError("Bad uncompressed block length in flate stream");this.codeBuf=0;this.codeSize=0;const e=this.bufferLength,t=e+B;s=this.ensureBuffer(t);this.bufferLength=t;if(0===B)-1===c.peekByte()&&(this.eof=!0);else{const t=c.getBytes(B);s.set(t,e);t.length<B&&(this.eof=!0)}}};return s}();t.FlateStream=h;var u=function(){function e(e,t,a){if(!(0,i.isDict)(a))return e;var n=this.predictor=a.get("Predictor")||1;if(n<=1)return e;if(2!==n&&(n<10||n>15))throw new r.FormatError(`Unsupported predictor: ${n}`);this.readBlock=2===n?this.readBlockTiff:this.readBlockPng;this.str=e;this.dict=e.dict;var s=this.colors=a.get("Colors")||1,o=this.bits=a.get("BitsPerComponent")||8,l=this.columns=a.get("Columns")||1;this.pixBytes=s*o+7>>3;this.rowBytes=l*s*o+7>>3;c.call(this,t);return this}e.prototype=Object.create(c.prototype);e.prototype.readBlockTiff=function(){var e=this.rowBytes,t=this.bufferLength,a=this.ensureBuffer(t+e),r=this.bits,i=this.colors,n=this.str.getBytes(e);this.eof=!n.length;if(!this.eof){var s,o=0,c=0,l=0,h=0,u=t;if(1===r&&1===i)for(s=0;s<e;++s){var d=n[s]^o;d^=d>>1;d^=d>>2;o=(1&(d^=d>>4))<<7;a[u++]=d}else if(8===r){for(s=0;s<i;++s)a[u++]=n[s];for(;s<e;++s){a[u]=a[u-i]+n[s];u++}}else if(16===r){var f=2*i;for(s=0;s<f;++s)a[u++]=n[s];for(;s<e;s+=2){var g=((255&n[s])<<8)+(255&n[s+1])+((255&a[u-f])<<8)+(255&a[u-f+1]);a[u++]=g>>8&255;a[u++]=255&g}}else{var m=new Uint8Array(i+1),p=(1<<r)-1,b=0,y=t,v=this.columns;for(s=0;s<v;++s)for(var w=0;w<i;++w){if(l<r){o=o<<8|255&n[b++];l+=8}m[w]=m[w]+(o>>l-r)&p;l-=r;c=c<<r|m[w];if((h+=r)>=8){a[y++]=c>>h-8&255;h-=8}}h>0&&(a[y++]=(c<<8-h)+(o&(1<<8-h)-1))}this.bufferLength+=e}};e.prototype.readBlockPng=function(){var e=this.rowBytes,t=this.pixBytes,a=this.str.getByte(),i=this.str.getBytes(e);this.eof=!i.length;if(!this.eof){var n=this.bufferLength,s=this.ensureBuffer(n+e),o=s.subarray(n-e,n);0===o.length&&(o=new Uint8Array(e));var c,l,h,u=n;switch(a){case 0:for(c=0;c<e;++c)s[u++]=i[c];break;case 1:for(c=0;c<t;++c)s[u++]=i[c];for(;c<e;++c){s[u]=s[u-t]+i[c]&255;u++}break;case 2:for(c=0;c<e;++c)s[u++]=o[c]+i[c]&255;break;case 3:for(c=0;c<t;++c)s[u++]=(o[c]>>1)+i[c];for(;c<e;++c){s[u]=(o[c]+s[u-t]>>1)+i[c]&255;u++}break;case 4:for(c=0;c<t;++c){l=o[c];h=i[c];s[u++]=l+h}for(;c<e;++c){l=o[c];var d=o[c-t],f=s[u-t],g=f+l-d,m=g-f;m<0&&(m=-m);var p=g-l;p<0&&(p=-p);var b=g-d;b<0&&(b=-b);h=i[c];s[u++]=m<=p&&m<=b?f+h:p<=b?l+h:d+h}break;default:throw new r.FormatError(`Unsupported predictor: ${a}`)}this.bufferLength+=e}};return e}();t.PredictorStream=u;var d=function(){function e(e,t,a){this.str=e;this.dict=e.dict;this.decrypt=a;this.nextChunk=null;this.initialized=!1;c.call(this,t)}e.prototype=Object.create(c.prototype);e.prototype.readBlock=function(){var e;if(this.initialized)e=this.nextChunk;else{e=this.str.getBytes(512);this.initialized=!0}if(e&&0!==e.length){this.nextChunk=this.str.getBytes(512);var t=this.nextChunk&&this.nextChunk.length>0;e=(0,this.decrypt)(e,!t);var a,r=this.bufferLength,i=e.length,n=this.ensureBuffer(r+i);for(a=0;a<i;a++)n[r++]=e[a];this.bufferLength=r}else this.eof=!0};return e}();t.DecryptStream=d;var f=function(){function e(e,t){this.str=e;this.dict=e.dict;this.input=new Uint8Array(5);t&&(t*=.8);c.call(this,t)}e.prototype=Object.create(c.prototype);e.prototype.readBlock=function(){for(var e=this.str,t=e.getByte();(0,n.isWhiteSpace)(t);)t=e.getByte();if(-1!==t&&126!==t){var a,r,i=this.bufferLength;if(122===t){a=this.ensureBuffer(i+4);for(r=0;r<4;++r)a[i+r]=0;this.bufferLength+=4}else{var s=this.input;s[0]=t;for(r=1;r<5;++r){t=e.getByte();for(;(0,n.isWhiteSpace)(t);)t=e.getByte();s[r]=t;if(-1===t||126===t)break}a=this.ensureBuffer(i+r-1);this.bufferLength+=r-1;if(r<5){for(;r<5;++r)s[r]=117;this.eof=!0}var o=0;for(r=0;r<5;++r)o=85*o+(s[r]-33);for(r=3;r>=0;--r){a[i+r]=255&o;o>>=8}}}else this.eof=!0};return e}();t.Ascii85Stream=f;var g=function(){function e(e,t){this.str=e;this.dict=e.dict;this.firstDigit=-1;t&&(t*=.5);c.call(this,t)}e.prototype=Object.create(c.prototype);e.prototype.readBlock=function(){var e=this.str.getBytes(8e3);if(e.length){for(var t=e.length+1>>1,a=this.ensureBuffer(this.bufferLength+t),r=this.bufferLength,i=this.firstDigit,n=0,s=e.length;n<s;n++){var o,c=e[n];if(c>=48&&c<=57)o=15&c;else{if(!(c>=65&&c<=70||c>=97&&c<=102)){if(62===c){this.eof=!0;break}continue}o=9+(15&c)}if(i<0)i=o;else{a[r++]=i<<4|o;i=-1}}if(i>=0&&this.eof){a[r++]=i<<4;i=-1}this.firstDigit=i;this.bufferLength=r}else this.eof=!0};return e}();t.AsciiHexStream=g;var m=function(){function e(e,t){this.str=e;this.dict=e.dict;c.call(this,t)}e.prototype=Object.create(c.prototype);e.prototype.readBlock=function(){var e=this.str.getBytes(2);if(!e||e.length<2||128===e[0])this.eof=!0;else{var t,a=this.bufferLength,r=e[0];if(r<128){(t=this.ensureBuffer(a+r+1))[a++]=e[1];if(r>0){var i=this.str.getBytes(r);t.set(i,a);a+=r}}else{r=257-r;var n=e[1];t=this.ensureBuffer(a+r+1);for(var s=0;s<r;s++)t[a++]=n}this.bufferLength=a}};return e}();t.RunLengthStream=m;var p=function(){function e(e,t,a){this.str=e;this.dict=e.dict;this.cachedData=0;this.bitsCached=0;for(var r={earlyChange:a,codeLength:9,nextCode:258,dictionaryValues:new Uint8Array(4096),dictionaryLengths:new Uint16Array(4096),dictionaryPrevCodes:new Uint16Array(4096),currentSequence:new Uint8Array(4096),currentSequenceLength:0},i=0;i<256;++i){r.dictionaryValues[i]=i;r.dictionaryLengths[i]=1}this.lzwState=r;c.call(this,t)}e.prototype=Object.create(c.prototype);e.prototype.readBits=function(e){for(var t=this.bitsCached,a=this.cachedData;t<e;){var r=this.str.getByte();if(-1===r){this.eof=!0;return null}a=a<<8|r;t+=8}this.bitsCached=t-=e;this.cachedData=a;this.lastCode=null;return a>>>t&(1<<e)-1};e.prototype.readBlock=function(){var e,t,a,r=1024,i=this.lzwState;if(i){var n=i.earlyChange,s=i.nextCode,o=i.dictionaryValues,c=i.dictionaryLengths,l=i.dictionaryPrevCodes,h=i.codeLength,u=i.prevCode,d=i.currentSequence,f=i.currentSequenceLength,g=0,m=this.bufferLength,p=this.ensureBuffer(this.bufferLength+r);for(e=0;e<512;e++){var b=this.readBits(h),y=f>0;if(b<256){d[0]=b;f=1}else{if(!(b>=258)){if(256===b){h=9;s=258;f=0;continue}this.eof=!0;delete this.lzwState;break}if(b<s)for(t=(f=c[b])-1,a=b;t>=0;t--){d[t]=o[a];a=l[a]}else d[f++]=d[0]}if(y){l[s]=u;c[s]=c[u]+1;o[s]=d[0];h=++s+n&s+n-1?h:0|Math.min(Math.log(s+n)/.6931471805599453+1,12)}u=b;if(r<(g+=f)){do{r+=512}while(r<g);p=this.ensureBuffer(this.bufferLength+r)}for(t=0;t<f;t++)p[m++]=d[t]}i.nextCode=s;i.codeLength=h;i.prevCode=u;i.currentSequenceLength=f;this.bufferLength=m}};return e}();t.LZWStream=p;var b=function(){function e(){s.call(this,new Uint8Array(0))}e.prototype=s.prototype;return e}();t.NullStream=b},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.CCITTFaxStream=void 0;var r=a(4),i=a(13),n=a(11),s=function(){function e(e,t,a){this.str=e;this.dict=e.dict;(0,r.isDict)(a)||(a=r.Dict.empty);const s={next:()=>e.getByte()};this.ccittFaxDecoder=new i.CCITTFaxDecoder(s,{K:a.get("K"),EndOfLine:a.get("EndOfLine"),EncodedByteAlign:a.get("EncodedByteAlign"),Columns:a.get("Columns"),Rows:a.get("Rows"),EndOfBlock:a.get("EndOfBlock"),BlackIs1:a.get("BlackIs1")});n.DecodeStream.call(this,t)}e.prototype=Object.create(n.DecodeStream.prototype);e.prototype.readBlock=function(){for(;!this.eof;){const e=this.ccittFaxDecoder.readNextChar();if(-1===e){this.eof=!0;return}this.ensureBuffer(this.bufferLength+1);this.buffer[this.bufferLength++]=e}};return e}();t.CCITTFaxStream=s},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.CCITTFaxDecoder=void 0;var r=a(2);const i=function(){const e=[[-1,-1],[-1,-1],[7,8],[7,7],[6,6],[6,6],[6,5],[6,5],[4,0],[4,0],[4,0],[4,0],[4,0],[4,0],[4,0],[4,0],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[3,3],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2],[1,2]],t=[[-1,-1],[12,-2],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[11,1792],[11,1792],[12,1984],[12,2048],[12,2112],[12,2176],[12,2240],[12,2304],[11,1856],[11,1856],[11,1920],[11,1920],[12,2368],[12,2432],[12,2496],[12,2560]],a=[[-1,-1],[-1,-1],[-1,-1],[-1,-1],[8,29],[8,29],[8,30],[8,30],[8,45],[8,45],[8,46],[8,46],[7,22],[7,22],[7,22],[7,22],[7,23],[7,23],[7,23],[7,23],[8,47],[8,47],[8,48],[8,48],[6,13],[6,13],[6,13],[6,13],[6,13],[6,13],[6,13],[6,13],[7,20],[7,20],[7,20],[7,20],[8,33],[8,33],[8,34],[8,34],[8,35],[8,35],[8,36],[8,36],[8,37],[8,37],[8,38],[8,38],[7,19],[7,19],[7,19],[7,19],[8,31],[8,31],[8,32],[8,32],[6,1],[6,1],[6,1],[6,1],[6,1],[6,1],[6,1],[6,1],[6,12],[6,12],[6,12],[6,12],[6,12],[6,12],[6,12],[6,12],[8,53],[8,53],[8,54],[8,54],[7,26],[7,26],[7,26],[7,26],[8,39],[8,39],[8,40],[8,40],[8,41],[8,41],[8,42],[8,42],[8,43],[8,43],[8,44],[8,44],[7,21],[7,21],[7,21],[7,21],[7,28],[7,28],[7,28],[7,28],[8,61],[8,61],[8,62],[8,62],[8,63],[8,63],[8,0],[8,0],[8,320],[8,320],[8,384],[8,384],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,10],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[5,11],[7,27],[7,27],[7,27],[7,27],[8,59],[8,59],[8,60],[8,60],[9,1472],[9,1536],[9,1600],[9,1728],[7,18],[7,18],[7,18],[7,18],[7,24],[7,24],[7,24],[7,24],[8,49],[8,49],[8,50],[8,50],[8,51],[8,51],[8,52],[8,52],[7,25],[7,25],[7,25],[7,25],[8,55],[8,55],[8,56],[8,56],[8,57],[8,57],[8,58],[8,58],[6,192],[6,192],[6,192],[6,192],[6,192],[6,192],[6,192],[6,192],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[6,1664],[8,448],[8,448],[8,512],[8,512],[9,704],[9,768],[8,640],[8,640],[8,576],[8,576],[9,832],[9,896],[9,960],[9,1024],[9,1088],[9,1152],[9,1216],[9,1280],[9,1344],[9,1408],[7,256],[7,256],[7,256],[7,256],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,2],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[4,3],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,128],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,8],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[5,9],[6,16],[6,16],[6,16],[6,16],[6,16],[6,16],[6,16],[6,16],[6,17],[6,17],[6,17],[6,17],[6,17],[6,17],[6,17],[6,17],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,4],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[4,5],[6,14],[6,14],[6,14],[6,14],[6,14],[6,14],[6,14],[6,14],[6,15],[6,15],[6,15],[6,15],[6,15],[6,15],[6,15],[6,15],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[5,64],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,6],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7],[4,7]],i=[[-1,-1],[-1,-1],[12,-2],[12,-2],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[-1,-1],[11,1792],[11,1792],[11,1792],[11,1792],[12,1984],[12,1984],[12,2048],[12,2048],[12,2112],[12,2112],[12,2176],[12,2176],[12,2240],[12,2240],[12,2304],[12,2304],[11,1856],[11,1856],[11,1856],[11,1856],[11,1920],[11,1920],[11,1920],[11,1920],[12,2368],[12,2368],[12,2432],[12,2432],[12,2496],[12,2496],[12,2560],[12,2560],[10,18],[10,18],[10,18],[10,18],[10,18],[10,18],[10,18],[10,18],[12,52],[12,52],[13,640],[13,704],[13,768],[13,832],[12,55],[12,55],[12,56],[12,56],[13,1280],[13,1344],[13,1408],[13,1472],[12,59],[12,59],[12,60],[12,60],[13,1536],[13,1600],[11,24],[11,24],[11,24],[11,24],[11,25],[11,25],[11,25],[11,25],[13,1664],[13,1728],[12,320],[12,320],[12,384],[12,384],[12,448],[12,448],[13,512],[13,576],[12,53],[12,53],[12,54],[12,54],[13,896],[13,960],[13,1024],[13,1088],[13,1152],[13,1216],[10,64],[10,64],[10,64],[10,64],[10,64],[10,64],[10,64],[10,64]],n=[[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[8,13],[11,23],[11,23],[12,50],[12,51],[12,44],[12,45],[12,46],[12,47],[12,57],[12,58],[12,61],[12,256],[10,16],[10,16],[10,16],[10,16],[10,17],[10,17],[10,17],[10,17],[12,48],[12,49],[12,62],[12,63],[12,30],[12,31],[12,32],[12,33],[12,40],[12,41],[11,22],[11,22],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[8,14],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,10],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[7,11],[9,15],[9,15],[9,15],[9,15],[9,15],[9,15],[9,15],[9,15],[12,128],[12,192],[12,26],[12,27],[12,28],[12,29],[11,19],[11,19],[11,20],[11,20],[12,34],[12,35],[12,36],[12,37],[12,38],[12,39],[11,21],[11,21],[12,42],[12,43],[10,0],[10,0],[10,0],[10,0],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12],[7,12]],s=[[-1,-1],[-1,-1],[-1,-1],[-1,-1],[6,9],[6,8],[5,7],[5,7],[4,6],[4,6],[4,6],[4,6],[4,5],[4,5],[4,5],[4,5],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,1],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[3,4],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,3],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2],[2,2]];function o(e,t={}){if(!e||"function"!=typeof e.next)throw new Error('CCITTFaxDecoder - invalid "source" parameter.');this.source=e;this.eof=!1;this.encoding=t.K||0;this.eoline=t.EndOfLine||!1;this.byteAlign=t.EncodedByteAlign||!1;this.columns=t.Columns||1728;this.rows=t.Rows||0;let a,r=t.EndOfBlock;null==r&&(r=!0);this.eoblock=r;this.black=t.BlackIs1||!1;this.codingLine=new Uint32Array(this.columns+1);this.refLine=new Uint32Array(this.columns+2);this.codingLine[0]=this.columns;this.codingPos=0;this.row=0;this.nextLine2D=this.encoding<0;this.inputBits=0;this.inputBuf=0;this.outputBits=0;this.rowsDone=!1;for(;0===(a=this._lookBits(12));)this._eatBits(1);1===a&&this._eatBits(12);if(this.encoding>0){this.nextLine2D=!this._lookBits(1);this._eatBits(1)}}o.prototype={readNextChar(){if(this.eof)return-1;const e=this.refLine,t=this.codingLine,a=this.columns;let i,n,s,o,c;if(0===this.outputBits){this.rowsDone&&(this.eof=!0);if(this.eof)return-1;this.err=!1;let s,c,l;if(this.nextLine2D){for(o=0;t[o]<a;++o)e[o]=t[o];e[o++]=a;e[o]=a;t[0]=0;this.codingPos=0;i=0;n=0;for(;t[this.codingPos]<a;){s=this._getTwoDimCode();switch(s){case 0:this._addPixels(e[i+1],n);e[i+1]<a&&(i+=2);break;case 1:s=c=0;if(n){do{s+=l=this._getBlackCode()}while(l>=64);do{c+=l=this._getWhiteCode()}while(l>=64)}else{do{s+=l=this._getWhiteCode()}while(l>=64);do{c+=l=this._getBlackCode()}while(l>=64)}this._addPixels(t[this.codingPos]+s,n);t[this.codingPos]<a&&this._addPixels(t[this.codingPos]+c,1^n);for(;e[i]<=t[this.codingPos]&&e[i]<a;)i+=2;break;case 7:this._addPixels(e[i]+3,n);n^=1;if(t[this.codingPos]<a){++i;for(;e[i]<=t[this.codingPos]&&e[i]<a;)i+=2}break;case 5:this._addPixels(e[i]+2,n);n^=1;if(t[this.codingPos]<a){++i;for(;e[i]<=t[this.codingPos]&&e[i]<a;)i+=2}break;case 3:this._addPixels(e[i]+1,n);n^=1;if(t[this.codingPos]<a){++i;for(;e[i]<=t[this.codingPos]&&e[i]<a;)i+=2}break;case 2:this._addPixels(e[i],n);n^=1;if(t[this.codingPos]<a){++i;for(;e[i]<=t[this.codingPos]&&e[i]<a;)i+=2}break;case 8:this._addPixelsNeg(e[i]-3,n);n^=1;if(t[this.codingPos]<a){i>0?--i:++i;for(;e[i]<=t[this.codingPos]&&e[i]<a;)i+=2}break;case 6:this._addPixelsNeg(e[i]-2,n);n^=1;if(t[this.codingPos]<a){i>0?--i:++i;for(;e[i]<=t[this.codingPos]&&e[i]<a;)i+=2}break;case 4:this._addPixelsNeg(e[i]-1,n);n^=1;if(t[this.codingPos]<a){i>0?--i:++i;for(;e[i]<=t[this.codingPos]&&e[i]<a;)i+=2}break;case-1:this._addPixels(a,0);this.eof=!0;break;default:(0,r.info)("bad 2d code");this._addPixels(a,0);this.err=!0}}}else{t[0]=0;this.codingPos=0;n=0;for(;t[this.codingPos]<a;){s=0;if(n)do{s+=l=this._getBlackCode()}while(l>=64);else do{s+=l=this._getWhiteCode()}while(l>=64);this._addPixels(t[this.codingPos]+s,n);n^=1}}let h=!1;this.byteAlign&&(this.inputBits&=-8);if(this.eoblock||this.row!==this.rows-1){s=this._lookBits(12);if(this.eoline)for(;-1!==s&&1!==s;){this._eatBits(1);s=this._lookBits(12)}else for(;0===s;){this._eatBits(1);s=this._lookBits(12)}if(1===s){this._eatBits(12);h=!0}else-1===s&&(this.eof=!0)}else this.rowsDone=!0;if(!this.eof&&this.encoding>0&&!this.rowsDone){this.nextLine2D=!this._lookBits(1);this._eatBits(1)}if(this.eoblock&&h&&this.byteAlign){s=this._lookBits(12);if(1===s){this._eatBits(12);if(this.encoding>0){this._lookBits(1);this._eatBits(1)}if(this.encoding>=0)for(o=0;o<4;++o){s=this._lookBits(12);1!==s&&(0,r.info)("bad rtc code: "+s);this._eatBits(12);if(this.encoding>0){this._lookBits(1);this._eatBits(1)}}this.eof=!0}}else if(this.err&&this.eoline){for(;;){s=this._lookBits(13);if(-1===s){this.eof=!0;return-1}if(s>>1==1)break;this._eatBits(1)}this._eatBits(12);if(this.encoding>0){this._eatBits(1);this.nextLine2D=!(1&s)}}t[0]>0?this.outputBits=t[this.codingPos=0]:this.outputBits=t[this.codingPos=1];this.row++}if(this.outputBits>=8){c=1&this.codingPos?0:255;this.outputBits-=8;if(0===this.outputBits&&t[this.codingPos]<a){this.codingPos++;this.outputBits=t[this.codingPos]-t[this.codingPos-1]}}else{s=8;c=0;do{if(this.outputBits>s){c<<=s;1&this.codingPos||(c|=255>>8-s);this.outputBits-=s;s=0}else{c<<=this.outputBits;1&this.codingPos||(c|=255>>8-this.outputBits);s-=this.outputBits;this.outputBits=0;if(t[this.codingPos]<a){this.codingPos++;this.outputBits=t[this.codingPos]-t[this.codingPos-1]}else if(s>0){c<<=s;s=0}}}while(s)}this.black&&(c^=255);return c},_addPixels(e,t){const a=this.codingLine;let i=this.codingPos;if(e>a[i]){if(e>this.columns){(0,r.info)("row is wrong length");this.err=!0;e=this.columns}1&i^t&&++i;a[i]=e}this.codingPos=i},_addPixelsNeg(e,t){const a=this.codingLine;let i=this.codingPos;if(e>a[i]){if(e>this.columns){(0,r.info)("row is wrong length");this.err=!0;e=this.columns}1&i^t&&++i;a[i]=e}else if(e<a[i]){if(e<0){(0,r.info)("invalid code");this.err=!0;e=0}for(;i>0&&e<a[i-1];)--i;a[i]=e}this.codingPos=i},_findTableCode(e,t,a,r){const i=r||0;for(let r=e;r<=t;++r){let e=this._lookBits(r);if(-1===e)return[!0,1,!1];r<t&&(e<<=t-r);if(!i||e>=i){const t=a[e-i];if(t[0]===r){this._eatBits(r);return[!0,t[1],!0]}}}return[!1,0,!1]},_getTwoDimCode(){let t,a=0;if(this.eoblock){a=this._lookBits(7);t=e[a];if(t&&t[0]>0){this._eatBits(t[0]);return t[1]}}else{const t=this._findTableCode(1,7,e);if(t[0]&&t[2])return t[1]}(0,r.info)("Bad two dim code");return-1},_getWhiteCode(){let e,i=0;if(this.eoblock){i=this._lookBits(12);if(-1===i)return 1;e=i>>5==0?t[i]:a[i>>3];if(e[0]>0){this._eatBits(e[0]);return e[1]}}else{let e=this._findTableCode(1,9,a);if(e[0])return e[1];e=this._findTableCode(11,12,t);if(e[0])return e[1]}(0,r.info)("bad white code");this._eatBits(1);return 1},_getBlackCode(){let e,t;if(this.eoblock){e=this._lookBits(13);if(-1===e)return 1;t=e>>7==0?i[e]:e>>9==0&&e>>7!=0?n[(e>>1)-64]:s[e>>7];if(t[0]>0){this._eatBits(t[0]);return t[1]}}else{let e=this._findTableCode(2,6,s);if(e[0])return e[1];e=this._findTableCode(7,12,n,64);if(e[0])return e[1];e=this._findTableCode(10,13,i);if(e[0])return e[1]}(0,r.info)("bad black code");this._eatBits(1);return 1},_lookBits(e){let t;for(;this.inputBits<e;){if(-1===(t=this.source.next()))return 0===this.inputBits?-1:this.inputBuf<<e-this.inputBits&65535>>16-e;this.inputBuf=this.inputBuf<<8|t;this.inputBits+=8}return this.inputBuf>>this.inputBits-e&65535>>16-e},_eatBits(e){(this.inputBits-=e)<0&&(this.inputBits=0)}};return o}();t.CCITTFaxDecoder=i},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.Jbig2Stream=void 0;var r=a(4),i=a(11),n=a(15),s=a(2);const o=function(){function e(e,t,a,r){this.stream=e;this.maybeLength=t;this.dict=a;this.params=r;i.DecodeStream.call(this,t)}e.prototype=Object.create(i.DecodeStream.prototype);Object.defineProperty(e.prototype,"bytes",{get(){return(0,s.shadow)(this,"bytes",this.stream.getBytes(this.maybeLength))},configurable:!0});e.prototype.ensureBuffer=function(e){};e.prototype.readBlock=function(){if(this.eof)return;const e=new n.Jbig2Image,t=[];if((0,r.isDict)(this.params)){const e=this.params.get("JBIG2Globals");if((0,r.isStream)(e)){const a=e.getBytes();t.push({data:a,start:0,end:a.length})}}t.push({data:this.bytes,start:0,end:this.bytes.length});const a=e.parseChunks(t),i=a.length;for(let e=0;e<i;e++)a[e]^=255;this.buffer=a;this.bufferLength=i;this.eof=!0};return e}();t.Jbig2Stream=o},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.Jbig2Image=void 0;var r=a(2),i=a(7),n=a(16),s=a(13);class o extends r.BaseException{constructor(e){super(`JBIG2 error: ${e}`)}}var c=function(){function e(){}e.prototype={getContexts(e){return e in this?this[e]:this[e]=new Int8Array(65536)}};function t(e,t,a){this.data=e;this.start=t;this.end=a}t.prototype={get decoder(){var e=new n.ArithmeticDecoder(this.data,this.start,this.end);return(0,r.shadow)(this,"decoder",e)},get contextCache(){var t=new e;return(0,r.shadow)(this,"contextCache",t)}};function a(e,t,a){var r=e.getContexts(t),i=1;function n(e){for(var t=0,n=0;n<e;n++){var s=a.readBit(r,i);i=i<256?i<<1|s:511&(i<<1|s)|256;t=t<<1|s}return t>>>0}var s=n(1),o=n(1)?n(1)?n(1)?n(1)?n(1)?n(32)+4436:n(12)+340:n(8)+84:n(6)+20:n(4)+4:n(2);return 0===s?o:o>0?-o:null}function c(e,t,a){for(var r=e.getContexts("IAID"),i=1,n=0;n<a;n++){i=i<<1|t.readBit(r,i)}return a<31?i&(1<<a)-1:2147483647&i}var l=["SymbolDictionary",null,null,null,"IntermediateTextRegion",null,"ImmediateTextRegion","ImmediateLosslessTextRegion",null,null,null,null,null,null,null,null,"PatternDictionary",null,null,null,"IntermediateHalftoneRegion",null,"ImmediateHalftoneRegion","ImmediateLosslessHalftoneRegion",null,null,null,null,null,null,null,null,null,null,null,null,"IntermediateGenericRegion",null,"ImmediateGenericRegion","ImmediateLosslessGenericRegion","IntermediateGenericRefinementRegion",null,"ImmediateGenericRefinementRegion","ImmediateLosslessGenericRefinementRegion",null,null,null,null,"PageInformation","EndOfPage","EndOfStripe","EndOfFile","Profiles","Tables",null,null,null,null,null,null,null,null,"Extension"],h=[[{x:-1,y:-2},{x:0,y:-2},{x:1,y:-2},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:2,y:-1},{x:-4,y:0},{x:-3,y:0},{x:-2,y:0},{x:-1,y:0}],[{x:-1,y:-2},{x:0,y:-2},{x:1,y:-2},{x:2,y:-2},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:2,y:-1},{x:-3,y:0},{x:-2,y:0},{x:-1,y:0}],[{x:-1,y:-2},{x:0,y:-2},{x:1,y:-2},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:-2,y:0},{x:-1,y:0}],[{x:-3,y:-1},{x:-2,y:-1},{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:-4,y:0},{x:-3,y:0},{x:-2,y:0},{x:-1,y:0}]],u=[{coding:[{x:0,y:-1},{x:1,y:-1},{x:-1,y:0}],reference:[{x:0,y:-1},{x:1,y:-1},{x:-1,y:0},{x:0,y:0},{x:1,y:0},{x:-1,y:1},{x:0,y:1},{x:1,y:1}]},{coding:[{x:-1,y:-1},{x:0,y:-1},{x:1,y:-1},{x:-1,y:0}],reference:[{x:0,y:-1},{x:-1,y:0},{x:0,y:0},{x:1,y:0},{x:0,y:1},{x:1,y:1}]}],d=[39717,1941,229,405],f=[32,8];function g(e,t,a,r,i,n,s,o){if(e){return B(new E(o.data,o.start,o.end),t,a,!1)}if(0===r&&!n&&!i&&4===s.length&&3===s[0].x&&-1===s[0].y&&-3===s[1].x&&-1===s[1].y&&2===s[2].x&&-2===s[2].y&&-2===s[3].x&&-2===s[3].y)return function(e,t,a){var r,i,n,s,o,c,l,h=a.decoder,u=a.contextCache.getContexts("GB"),d=[];for(i=0;i<t;i++){o=d[i]=new Uint8Array(e);c=i<1?o:d[i-1];r=(l=i<2?o:d[i-2])[0]<<13|l[1]<<12|l[2]<<11|c[0]<<7|c[1]<<6|c[2]<<5|c[3]<<4;for(n=0;n<e;n++){o[n]=s=h.readBit(u,r);r=(31735&r)<<1|(n+3<e?l[n+3]<<11:0)|(n+4<e?c[n+4]<<4:0)|s}}return d}(t,a,o);var c=!!n,l=h[r].concat(s);l.sort((function(e,t){return e.y-t.y||e.x-t.x}));var u,f,g=l.length,m=new Int8Array(g),p=new Int8Array(g),b=[],y=0,v=0,w=0,k=0;for(f=0;f<g;f++){m[f]=l[f].x;p[f]=l[f].y;v=Math.min(v,l[f].x);w=Math.max(w,l[f].x);k=Math.min(k,l[f].y);f<g-1&&l[f].y===l[f+1].y&&l[f].x===l[f+1].x-1?y|=1<<g-1-f:b.push(f)}var S=b.length,C=new Int8Array(S),x=new Int8Array(S),A=new Uint16Array(S);for(u=0;u<S;u++){f=b[u];C[u]=l[f].x;x[u]=l[f].y;A[u]=1<<g-1-f}for(var I,F,T,O,P,D=-v,N=-k,M=t-w,L=d[r],R=new Uint8Array(t),U=[],q=o.decoder,j=o.contextCache.getContexts("GB"),_=0,z=0,H=0;H<a;H++){if(i){if(_^=q.readBit(j,L)){U.push(R);continue}}R=new Uint8Array(R);U.push(R);for(I=0;I<t;I++)if(c&&n[H][I])R[I]=0;else{if(I>=D&&I<M&&H>=N){z=z<<1&y;for(f=0;f<S;f++){F=H+x[f];T=I+C[f];(O=U[F][T])&&(z|=O=A[f])}}else{z=0;P=g-1;for(f=0;f<g;f++,P--)(T=I+m[f])>=0&&T<t&&(F=H+p[f])>=0&&(O=U[F][T])&&(z|=O<<P)}var G=q.readBit(j,z);R[I]=G}}return U}function m(e,t,a,r,i,n,s,c,l){var h=u[a].coding;0===a&&(h=h.concat([c[0]]));var d,g=h.length,m=new Int32Array(g),p=new Int32Array(g);for(d=0;d<g;d++){m[d]=h[d].x;p[d]=h[d].y}var b=u[a].reference;0===a&&(b=b.concat([c[1]]));var y=b.length,v=new Int32Array(y),w=new Int32Array(y);for(d=0;d<y;d++){v[d]=b[d].x;w[d]=b[d].y}for(var k=r[0].length,S=r.length,C=f[a],x=[],A=l.decoder,I=l.contextCache.getContexts("GR"),F=0,T=0;T<t;T++){if(s){if(F^=A.readBit(I,C))throw new o("prediction is not supported")}var E=new Uint8Array(e);x.push(E);for(var O=0;O<e;O++){var P,B,D=0;for(d=0;d<g;d++){P=T+p[d];B=O+m[d];P<0||B<0||B>=e?D<<=1:D=D<<1|x[P][B]}for(d=0;d<y;d++){P=T+w[d]-n;B=O+v[d]-i;P<0||P>=S||B<0||B>=k?D<<=1:D=D<<1|r[P][B]}var N=A.readBit(I,D);E[O]=N}}return x}function p(e,t,r,i,n,s,l,h,u,d,f,g,p,b,y,v,w,k,S){if(e&&t)throw new o("refinement with Huffman is not supported");var C,x,A=[];for(C=0;C<i;C++){x=new Uint8Array(r);if(n)for(var I=0;I<r;I++)x[I]=n;A.push(x)}var F=w.decoder,T=w.contextCache,E=e?-b.tableDeltaT.decode(S):-a(T,"IADT",F),O=0;C=0;for(;C<s;){E+=e?b.tableDeltaT.decode(S):a(T,"IADT",F);for(var P=O+=e?b.tableFirstS.decode(S):a(T,"IAFS",F);;){let i=0;l>1&&(i=e?S.readBits(k):a(T,"IAIT",F));var B=l*E+i,D=e?b.symbolIDTable.decode(S):c(T,F,u),N=t&&(e?S.readBit():a(T,"IARI",F)),M=h[D],L=M[0].length,R=M.length;if(N){var U=a(T,"IARDW",F),q=a(T,"IARDH",F);M=m(L+=U,R+=q,y,M,(U>>1)+a(T,"IARDX",F),(q>>1)+a(T,"IARDY",F),!1,v,w)}var j,_,z,H=B-(1&g?0:R-1),G=P-(2&g?L-1:0);if(d){for(j=0;j<R;j++)if(x=A[G+j]){z=M[j];var W=Math.min(r-H,L);switch(p){case 0:for(_=0;_<W;_++)x[H+_]|=z[_];break;case 2:for(_=0;_<W;_++)x[H+_]^=z[_];break;default:throw new o(`operator ${p} is not supported`)}}P+=R-1}else{for(_=0;_<R;_++)if(x=A[H+_]){z=M[_];switch(p){case 0:for(j=0;j<L;j++)x[G+j]|=z[j];break;case 2:for(j=0;j<L;j++)x[G+j]^=z[j];break;default:throw new o(`operator ${p} is not supported`)}}P+=L-1}C++;var X=e?b.tableDeltaS.decode(S):a(T,"IADS",F);if(null===X)break;P+=X+f}}return A}function b(e,t){var a={};a.number=(0,i.readUint32)(e,t);var r=e[t+4],n=63&r;if(!l[n])throw new o("invalid segment type: "+n);a.type=n;a.typeName=l[n];a.deferredNonRetain=!!(128&r);var s=!!(64&r),c=e[t+5],h=c>>5&7,u=[31&c],d=t+6;if(7===c){h=536870911&(0,i.readUint32)(e,d-1);d+=3;var f=h+7>>3;u[0]=e[d++];for(;--f>0;)u.push(e[d++])}else if(5===c||6===c)throw new o("invalid referred-to flags");a.retainBits=u;let g=4;a.number<=256?g=1:a.number<=65536&&(g=2);var m,p,b=[];for(m=0;m<h;m++){let t;t=1===g?e[d]:2===g?(0,i.readUint16)(e,d):(0,i.readUint32)(e,d);b.push(t);d+=g}a.referredTo=b;if(s){a.pageAssociation=(0,i.readUint32)(e,d);d+=4}else a.pageAssociation=e[d++];a.length=(0,i.readUint32)(e,d);d+=4;if(4294967295===a.length){if(38!==n)throw new o("invalid unknown segment length");var y=v(e,d),k=!!(1&e[d+w]),S=new Uint8Array(6);if(!k){S[0]=255;S[1]=172}S[2]=y.height>>>24&255;S[3]=y.height>>16&255;S[4]=y.height>>8&255;S[5]=255&y.height;for(m=d,p=e.length;m<p;m++){for(var C=0;C<6&&S[C]===e[m+C];)C++;if(6===C){a.length=m+6;break}}if(4294967295===a.length)throw new o("segment end was not found")}a.headerEnd=d;return a}function y(e,t,a,r){for(var i=[],n=a;n<r;){var s=b(t,n);n=s.headerEnd;var o={header:s,data:t};if(!e.randomAccess){o.start=n;n+=s.length;o.end=n}i.push(o);if(51===s.type)break}if(e.randomAccess)for(var c=0,l=i.length;c<l;c++){i[c].start=n;n+=i[c].header.length;i[c].end=n}return i}function v(e,t){return{width:(0,i.readUint32)(e,t),height:(0,i.readUint32)(e,t+4),x:(0,i.readUint32)(e,t+8),y:(0,i.readUint32)(e,t+12),combinationOperator:7&e[t+16]}}var w=17;function k(e,t){var a,r,n,s,c=e.header,l=e.data,h=e.start,u=e.end;switch(c.type){case 0:var d={},f=(0,i.readUint16)(l,h);d.huffman=!!(1&f);d.refinement=!!(2&f);d.huffmanDHSelector=f>>2&3;d.huffmanDWSelector=f>>4&3;d.bitmapSizeSelector=f>>6&1;d.aggregationInstancesSelector=f>>7&1;d.bitmapCodingContextUsed=!!(256&f);d.bitmapCodingContextRetained=!!(512&f);d.template=f>>10&3;d.refinementTemplate=f>>12&1;h+=2;if(!d.huffman){s=0===d.template?4:1;r=[];for(n=0;n<s;n++){r.push({x:(0,i.readInt8)(l,h),y:(0,i.readInt8)(l,h+1)});h+=2}d.at=r}if(d.refinement&&!d.refinementTemplate){r=[];for(n=0;n<2;n++){r.push({x:(0,i.readInt8)(l,h),y:(0,i.readInt8)(l,h+1)});h+=2}d.refinementAt=r}d.numberOfExportedSymbols=(0,i.readUint32)(l,h);h+=4;d.numberOfNewSymbols=(0,i.readUint32)(l,h);h+=4;a=[d,c.number,c.referredTo,l,h,u];break;case 6:case 7:var g={};g.info=v(l,h);h+=w;var m=(0,i.readUint16)(l,h);h+=2;g.huffman=!!(1&m);g.refinement=!!(2&m);g.logStripSize=m>>2&3;g.stripSize=1<<g.logStripSize;g.referenceCorner=m>>4&3;g.transposed=!!(64&m);g.combinationOperator=m>>7&3;g.defaultPixelValue=m>>9&1;g.dsOffset=m<<17>>27;g.refinementTemplate=m>>15&1;if(g.huffman){var p=(0,i.readUint16)(l,h);h+=2;g.huffmanFS=3&p;g.huffmanDS=p>>2&3;g.huffmanDT=p>>4&3;g.huffmanRefinementDW=p>>6&3;g.huffmanRefinementDH=p>>8&3;g.huffmanRefinementDX=p>>10&3;g.huffmanRefinementDY=p>>12&3;g.huffmanRefinementSizeSelector=!!(16384&p)}if(g.refinement&&!g.refinementTemplate){r=[];for(n=0;n<2;n++){r.push({x:(0,i.readInt8)(l,h),y:(0,i.readInt8)(l,h+1)});h+=2}g.refinementAt=r}g.numberOfSymbolInstances=(0,i.readUint32)(l,h);h+=4;a=[g,c.referredTo,l,h,u];break;case 16:const e={},t=l[h++];e.mmr=!!(1&t);e.template=t>>1&3;e.patternWidth=l[h++];e.patternHeight=l[h++];e.maxPatternIndex=(0,i.readUint32)(l,h);h+=4;a=[e,c.number,l,h,u];break;case 22:case 23:const C={};C.info=v(l,h);h+=w;const x=l[h++];C.mmr=!!(1&x);C.template=x>>1&3;C.enableSkip=!!(8&x);C.combinationOperator=x>>4&7;C.defaultPixelValue=x>>7&1;C.gridWidth=(0,i.readUint32)(l,h);h+=4;C.gridHeight=(0,i.readUint32)(l,h);h+=4;C.gridOffsetX=4294967295&(0,i.readUint32)(l,h);h+=4;C.gridOffsetY=4294967295&(0,i.readUint32)(l,h);h+=4;C.gridVectorX=(0,i.readUint16)(l,h);h+=2;C.gridVectorY=(0,i.readUint16)(l,h);h+=2;a=[C,c.referredTo,l,h,u];break;case 38:case 39:var b={};b.info=v(l,h);h+=w;var y=l[h++];b.mmr=!!(1&y);b.template=y>>1&3;b.prediction=!!(8&y);if(!b.mmr){s=0===b.template?4:1;r=[];for(n=0;n<s;n++){r.push({x:(0,i.readInt8)(l,h),y:(0,i.readInt8)(l,h+1)});h+=2}b.at=r}a=[b,l,h,u];break;case 48:var k={width:(0,i.readUint32)(l,h),height:(0,i.readUint32)(l,h+4),resolutionX:(0,i.readUint32)(l,h+8),resolutionY:(0,i.readUint32)(l,h+12)};4294967295===k.height&&delete k.height;var S=l[h+16];(0,i.readUint16)(l,h+17);k.lossless=!!(1&S);k.refinement=!!(2&S);k.defaultPixelValue=S>>2&1;k.combinationOperator=S>>3&3;k.requiresBuffer=!!(32&S);k.combinationOperatorOverride=!!(64&S);a=[k];break;case 49:case 50:case 51:break;case 53:a=[c.number,l,h,u];break;case 62:break;default:throw new o(`segment type ${c.typeName}(${c.type})`+" is not implemented")}var C="on"+c.typeName;C in t&&t[C].apply(t,a)}function S(e,t){for(var a=0,r=e.length;a<r;a++)k(e[a],t)}function C(){}C.prototype={onPageInformation:function(e){this.currentPageInfo=e;var t=e.width+7>>3,a=new Uint8ClampedArray(t*e.height);if(e.defaultPixelValue)for(var r=0,i=a.length;r<i;r++)a[r]=255;this.buffer=a},drawBitmap:function(e,t){var a,r,i,n,s=this.currentPageInfo,c=e.width,l=e.height,h=s.width+7>>3,u=s.combinationOperatorOverride?e.combinationOperator:s.combinationOperator,d=this.buffer,f=128>>(7&e.x),g=e.y*h+(e.x>>3);switch(u){case 0:for(a=0;a<l;a++){i=f;n=g;for(r=0;r<c;r++){t[a][r]&&(d[n]|=i);if(!(i>>=1)){i=128;n++}}g+=h}break;case 2:for(a=0;a<l;a++){i=f;n=g;for(r=0;r<c;r++){t[a][r]&&(d[n]^=i);if(!(i>>=1)){i=128;n++}}g+=h}break;default:throw new o(`operator ${u} is not supported`)}},onImmediateGenericRegion:function(e,a,r,i){var n=e.info,s=new t(a,r,i),o=g(e.mmr,n.width,n.height,e.template,e.prediction,null,e.at,s);this.drawBitmap(n,o)},onImmediateLosslessGenericRegion:function(){this.onImmediateGenericRegion.apply(this,arguments)},onSymbolDictionary:function(e,r,n,s,l,h){let u,d;if(e.huffman){u=function(e,t,a){let r,i,n,s,c=0;switch(e.huffmanDHSelector){case 0:case 1:r=T(e.huffmanDHSelector+4);break;case 3:r=O(c,t,a);c++;break;default:throw new o("invalid Huffman DH selector")}switch(e.huffmanDWSelector){case 0:case 1:i=T(e.huffmanDWSelector+2);break;case 3:i=O(c,t,a);c++;break;default:throw new o("invalid Huffman DW selector")}if(e.bitmapSizeSelector){n=O(c,t,a);c++}else n=T(1);s=e.aggregationInstancesSelector?O(c,t,a):T(1);return{tableDeltaHeight:r,tableDeltaWidth:i,tableBitmapSize:n,tableAggregateInstances:s}}(e,n,this.customTables);d=new E(s,l,h)}var f=this.symbols;f||(this.symbols=f={});for(var b=[],y=0,v=n.length;y<v;y++){const e=f[n[y]];e&&(b=b.concat(e))}var w=new t(s,l,h);f[r]=function(e,t,r,n,s,l,h,u,d,f,b,y){if(e&&t)throw new o("symbol refinement with Huffman is not supported");var v=[],w=0,k=(0,i.log2)(r.length+n),S=b.decoder,C=b.contextCache;let x,A;if(e){x=T(1);A=[];k=Math.max(k,1)}for(;v.length<n;){w+=e?l.tableDeltaHeight.decode(y):a(C,"IADH",S);let i=0,n=0;const s=e?A.length:0;for(;;){var I,F=e?l.tableDeltaWidth.decode(y):a(C,"IADW",S);if(null===F)break;i+=F;n+=i;if(t){var E=a(C,"IAAI",S);if(E>1)I=p(e,t,i,w,0,E,1,r.concat(v),k,0,0,1,0,l,d,f,b,0,y);else{var O=c(C,S,k),D=a(C,"IARDX",S),N=a(C,"IARDY",S);I=m(i,w,d,O<r.length?r[O]:v[O-r.length],D,N,!1,f,b)}v.push(I)}else if(e)A.push(i);else{I=g(!1,i,w,h,!1,null,u,b);v.push(I)}}if(e&&!t){const e=l.tableBitmapSize.decode(y);y.byteAlign();let t;if(0===e)t=P(y,n,w);else{const a=y.end,r=y.position+e;y.end=r;t=B(y,n,w,!1);y.end=a;y.position=r}const a=A.length;if(s===a-1)v.push(t);else{let e,r,i,n,o,c=0;for(e=s;e<a;e++){n=A[e];i=c+n;o=[];for(r=0;r<w;r++)o.push(t[r].subarray(c,i));v.push(o);c=i}}}}for(var M=[],L=[],R=!1,U=r.length+n;L.length<U;){for(var q=e?x.decode(y):a(C,"IAEX",S);q--;)L.push(R);R=!R}for(var j=0,_=r.length;j<_;j++)L[j]&&M.push(r[j]);for(var z=0;z<n;j++,z++)L[j]&&M.push(v[z]);return M}(e.huffman,e.refinement,b,e.numberOfNewSymbols,e.numberOfExportedSymbols,u,e.template,e.at,e.refinementTemplate,e.refinementAt,w,d)},onImmediateTextRegion:function(e,a,r,n,s){var c=e.info;let l,h;for(var u=this.symbols,d=[],f=0,g=a.length;f<g;f++){const e=u[a[f]];e&&(d=d.concat(e))}var m=(0,i.log2)(d.length);if(e.huffman){h=new E(r,n,s);l=function(e,t,a,r,i){const n=[];for(let e=0;e<=34;e++){const t=i.readBits(4);n.push(new x([e,t,0,0]))}const s=new I(n,!1);n.length=0;for(let e=0;e<r;){const t=s.decode(i);if(t>=32){let a,r,s;switch(t){case 32:if(0===e)throw new o("no previous value in symbol ID table");r=i.readBits(2)+3;a=n[e-1].prefixLength;break;case 33:r=i.readBits(3)+3;a=0;break;case 34:r=i.readBits(7)+11;a=0;break;default:throw new o("invalid code length in symbol ID table")}for(s=0;s<r;s++){n.push(new x([e,a,0,0]));e++}}else{n.push(new x([e,t,0,0]));e++}}i.byteAlign();const c=new I(n,!1);let l,h,u,d=0;switch(e.huffmanFS){case 0:case 1:l=T(e.huffmanFS+6);break;case 3:l=O(d,t,a);d++;break;default:throw new o("invalid Huffman FS selector")}switch(e.huffmanDS){case 0:case 1:case 2:h=T(e.huffmanDS+8);break;case 3:h=O(d,t,a);d++;break;default:throw new o("invalid Huffman DS selector")}switch(e.huffmanDT){case 0:case 1:case 2:u=T(e.huffmanDT+11);break;case 3:u=O(d,t,a);d++;break;default:throw new o("invalid Huffman DT selector")}if(e.refinement)throw new o("refinement with Huffman is not supported");return{symbolIDTable:c,tableFirstS:l,tableDeltaS:h,tableDeltaT:u}}(e,a,this.customTables,d.length,h)}var b=new t(r,n,s),y=p(e.huffman,e.refinement,c.width,c.height,e.defaultPixelValue,e.numberOfSymbolInstances,e.stripSize,d,m,e.transposed,e.dsOffset,e.referenceCorner,e.combinationOperator,l,e.refinementTemplate,e.refinementAt,b,e.logStripSize,h);this.drawBitmap(c,y)},onImmediateLosslessTextRegion:function(){this.onImmediateTextRegion.apply(this,arguments)},onPatternDictionary(e,a,r,i,n){let s=this.patterns;s||(this.patterns=s={});const o=new t(r,i,n);s[a]=function(e,t,a,r,i,n){const s=[];if(!e){s.push({x:-t,y:0});if(0===i){s.push({x:-3,y:-1});s.push({x:2,y:-2});s.push({x:-2,y:-2})}}const o=g(e,(r+1)*t,a,i,!1,null,s,n),c=[];for(let e=0;e<=r;e++){const r=[],i=t*e,n=i+t;for(let e=0;e<a;e++)r.push(o[e].subarray(i,n));c.push(r)}return c}(e.mmr,e.patternWidth,e.patternHeight,e.maxPatternIndex,e.template,o)},onImmediateHalftoneRegion(e,a,r,n,s){const c=this.patterns[a[0]],l=e.info,h=new t(r,n,s),u=function(e,t,a,r,n,s,c,l,h,u,d,f,m,p,b){if(c)throw new o("skip is not supported");if(0!==l)throw new o("operator "+l+" is not supported in halftone region");const y=[];let v,w,k;for(v=0;v<n;v++){k=new Uint8Array(r);if(s)for(w=0;w<r;w++)k[w]=s;y.push(k)}const S=t.length,C=t[0],x=C[0].length,A=C.length,I=(0,i.log2)(S),F=[];if(!e){F.push({x:a<=1?3:2,y:-1});if(0===a){F.push({x:-3,y:-1});F.push({x:2,y:-2});F.push({x:-2,y:-2})}}const T=[];let O,P,D,N,M,L,R,U,q,j,_;e&&(O=new E(b.data,b.start,b.end));for(v=I-1;v>=0;v--){P=e?B(O,h,u,!0):g(!1,h,u,a,!1,null,F,b);T[v]=P}for(D=0;D<u;D++)for(N=0;N<h;N++){M=0;L=0;for(w=I-1;w>=0;w--){M=T[w][D][N]^M;L|=M<<w}R=t[L];U=d+D*p+N*m>>8;q=f+D*m-N*p>>8;if(U>=0&&U+x<=r&&q>=0&&q+A<=n)for(v=0;v<A;v++){_=y[q+v];j=R[v];for(w=0;w<x;w++)_[U+w]|=j[w]}else{let e,t;for(v=0;v<A;v++){t=q+v;if(!(t<0||t>=n)){_=y[t];j=R[v];for(w=0;w<x;w++){e=U+w;e>=0&&e<r&&(_[e]|=j[w])}}}}}return y}(e.mmr,c,e.template,l.width,l.height,e.defaultPixelValue,e.enableSkip,e.combinationOperator,e.gridWidth,e.gridHeight,e.gridOffsetX,e.gridOffsetY,e.gridVectorX,e.gridVectorY,h);this.drawBitmap(l,u)},onImmediateLosslessHalftoneRegion(){this.onImmediateHalftoneRegion.apply(this,arguments)},onTables(e,t,a,r){let n=this.customTables;n||(this.customTables=n={});n[e]=function(e,t,a){const r=e[t],n=4294967295&(0,i.readUint32)(e,t+1),s=4294967295&(0,i.readUint32)(e,t+5),o=new E(e,t+9,a),c=1+(r>>1&7),l=1+(r>>4&7),h=[];let u,d,f=n;do{u=o.readBits(c);d=o.readBits(l);h.push(new x([f,u,d,0]));f+=1<<d}while(f<s);u=o.readBits(c);h.push(new x([n-1,u,32,0,"lower"]));u=o.readBits(c);h.push(new x([s,u,32,0]));if(1&r){u=o.readBits(c);h.push(new x([u,0]))}return new I(h,!1)}(t,a,r)}};function x(e){if(2===e.length){this.isOOB=!0;this.rangeLow=0;this.prefixLength=e[0];this.rangeLength=0;this.prefixCode=e[1];this.isLowerRange=!1}else{this.isOOB=!1;this.rangeLow=e[0];this.prefixLength=e[1];this.rangeLength=e[2];this.prefixCode=e[3];this.isLowerRange="lower"===e[4]}}function A(e){this.children=[];if(e){this.isLeaf=!0;this.rangeLength=e.rangeLength;this.rangeLow=e.rangeLow;this.isLowerRange=e.isLowerRange;this.isOOB=e.isOOB}else this.isLeaf=!1}A.prototype={buildTree(e,t){const a=e.prefixCode>>t&1;if(t<=0)this.children[a]=new A(e);else{let r=this.children[a];r||(this.children[a]=r=new A(null));r.buildTree(e,t-1)}},decodeNode(e){if(this.isLeaf){if(this.isOOB)return null;const t=e.readBits(this.rangeLength);return this.rangeLow+(this.isLowerRange?-t:t)}const t=this.children[e.readBit()];if(!t)throw new o("invalid Huffman data");return t.decodeNode(e)}};function I(e,t){t||this.assignPrefixCodes(e);this.rootNode=new A(null);for(let t=0,a=e.length;t<a;t++){const a=e[t];a.prefixLength>0&&this.rootNode.buildTree(a,a.prefixLength-1)}}I.prototype={decode(e){return this.rootNode.decodeNode(e)},assignPrefixCodes(e){const t=e.length;let a=0;for(let r=0;r<t;r++)a=Math.max(a,e[r].prefixLength);const r=new Uint32Array(a+1);for(let a=0;a<t;a++)r[e[a].prefixLength]++;let i,n,s,o=1,c=0;r[0]=0;for(;o<=a;){c=c+r[o-1]<<1;i=c;n=0;for(;n<t;){s=e[n];if(s.prefixLength===o){s.prefixCode=i;i++}n++}o++}}};const F={};function T(e){let t,a=F[e];if(a)return a;switch(e){case 1:t=[[0,1,4,0],[16,2,8,2],[272,3,16,6],[65808,3,32,7]];break;case 2:t=[[0,1,0,0],[1,2,0,2],[2,3,0,6],[3,4,3,14],[11,5,6,30],[75,6,32,62],[6,63]];break;case 3:t=[[-256,8,8,254],[0,1,0,0],[1,2,0,2],[2,3,0,6],[3,4,3,14],[11,5,6,30],[-257,8,32,255,"lower"],[75,7,32,126],[6,62]];break;case 4:t=[[1,1,0,0],[2,2,0,2],[3,3,0,6],[4,4,3,14],[12,5,6,30],[76,5,32,31]];break;case 5:t=[[-255,7,8,126],[1,1,0,0],[2,2,0,2],[3,3,0,6],[4,4,3,14],[12,5,6,30],[-256,7,32,127,"lower"],[76,6,32,62]];break;case 6:t=[[-2048,5,10,28],[-1024,4,9,8],[-512,4,8,9],[-256,4,7,10],[-128,5,6,29],[-64,5,5,30],[-32,4,5,11],[0,2,7,0],[128,3,7,2],[256,3,8,3],[512,4,9,12],[1024,4,10,13],[-2049,6,32,62,"lower"],[2048,6,32,63]];break;case 7:t=[[-1024,4,9,8],[-512,3,8,0],[-256,4,7,9],[-128,5,6,26],[-64,5,5,27],[-32,4,5,10],[0,4,5,11],[32,5,5,28],[64,5,6,29],[128,4,7,12],[256,3,8,1],[512,3,9,2],[1024,3,10,3],[-1025,5,32,30,"lower"],[2048,5,32,31]];break;case 8:t=[[-15,8,3,252],[-7,9,1,508],[-5,8,1,253],[-3,9,0,509],[-2,7,0,124],[-1,4,0,10],[0,2,1,0],[2,5,0,26],[3,6,0,58],[4,3,4,4],[20,6,1,59],[22,4,4,11],[38,4,5,12],[70,5,6,27],[134,5,7,28],[262,6,7,60],[390,7,8,125],[646,6,10,61],[-16,9,32,510,"lower"],[1670,9,32,511],[2,1]];break;case 9:t=[[-31,8,4,252],[-15,9,2,508],[-11,8,2,253],[-7,9,1,509],[-5,7,1,124],[-3,4,1,10],[-1,3,1,2],[1,3,1,3],[3,5,1,26],[5,6,1,58],[7,3,5,4],[39,6,2,59],[43,4,5,11],[75,4,6,12],[139,5,7,27],[267,5,8,28],[523,6,8,60],[779,7,9,125],[1291,6,11,61],[-32,9,32,510,"lower"],[3339,9,32,511],[2,0]];break;case 10:t=[[-21,7,4,122],[-5,8,0,252],[-4,7,0,123],[-3,5,0,24],[-2,2,2,0],[2,5,0,25],[3,6,0,54],[4,7,0,124],[5,8,0,253],[6,2,6,1],[70,5,5,26],[102,6,5,55],[134,6,6,56],[198,6,7,57],[326,6,8,58],[582,6,9,59],[1094,6,10,60],[2118,7,11,125],[-22,8,32,254,"lower"],[4166,8,32,255],[2,2]];break;case 11:t=[[1,1,0,0],[2,2,1,2],[4,4,0,12],[5,4,1,13],[7,5,1,28],[9,5,2,29],[13,6,2,60],[17,7,2,122],[21,7,3,123],[29,7,4,124],[45,7,5,125],[77,7,6,126],[141,7,32,127]];break;case 12:t=[[1,1,0,0],[2,2,0,2],[3,3,1,6],[5,5,0,28],[6,5,1,29],[8,6,1,60],[10,7,0,122],[11,7,1,123],[13,7,2,124],[17,7,3,125],[25,7,4,126],[41,8,5,254],[73,8,32,255]];break;case 13:t=[[1,1,0,0],[2,3,0,4],[3,4,0,12],[4,5,0,28],[5,4,1,13],[7,3,3,5],[15,6,1,58],[17,6,2,59],[21,6,3,60],[29,6,4,61],[45,6,5,62],[77,7,6,126],[141,7,32,127]];break;case 14:t=[[-2,3,0,4],[-1,3,0,5],[0,1,0,0],[1,3,0,6],[2,3,0,7]];break;case 15:t=[[-24,7,4,124],[-8,6,2,60],[-4,5,1,28],[-2,4,0,12],[-1,3,0,4],[0,1,0,0],[1,3,0,5],[2,4,0,13],[3,5,1,29],[5,6,2,61],[9,7,4,125],[-25,7,32,126,"lower"],[25,7,32,127]];break;default:throw new o(`standard table B.${e} does not exist`)}for(let e=0,a=t.length;e<a;e++)t[e]=new x(t[e]);a=new I(t,!0);F[e]=a;return a}function E(e,t,a){this.data=e;this.start=t;this.end=a;this.position=t;this.shift=-1;this.currentByte=0}E.prototype={readBit(){if(this.shift<0){if(this.position>=this.end)throw new o("end of data while reading bit");this.currentByte=this.data[this.position++];this.shift=7}const e=this.currentByte>>this.shift&1;this.shift--;return e},readBits(e){let t,a=0;for(t=e-1;t>=0;t--)a|=this.readBit()<<t;return a},byteAlign(){this.shift=-1},next(){return this.position>=this.end?-1:this.data[this.position++]}};function O(e,t,a){let r=0;for(let i=0,n=t.length;i<n;i++){const n=a[t[i]];if(n){if(e===r)return n;r++}}throw new o("can't find custom Huffman table")}function P(e,t,a){const r=[];for(let i=0;i<a;i++){const a=new Uint8Array(t);r.push(a);for(let r=0;r<t;r++)a[r]=e.readBit();e.byteAlign()}return r}function B(e,t,a,r){const i={K:-1,Columns:t,Rows:a,BlackIs1:!0,EndOfBlock:r},n=new s.CCITTFaxDecoder(e,i),o=[];let c,l=!1;for(let e=0;e<a;e++){const e=new Uint8Array(t);o.push(e);let a=-1;for(let r=0;r<t;r++){if(a<0){c=n.readNextChar();if(-1===c){c=0;l=!0}a=7}e[r]=c>>a&1;a--}}if(r&&!l){const e=5;for(let t=0;t<e&&-1!==n.readNextChar();t++);}return o}function D(){}D.prototype={parseChunks:e=>function(e){for(var t=new C,a=0,r=e.length;a<r;a++){var i=e[a];S(y({},i.data,i.start,i.end),t)}return t.buffer}(e),parse(e){const{imgData:t,width:a,height:r}=function(e){const t=e.length;let a=0;if(151!==e[a]||74!==e[a+1]||66!==e[a+2]||50!==e[a+3]||13!==e[a+4]||10!==e[a+5]||26!==e[a+6]||10!==e[a+7])throw new o("parseJbig2 - invalid header.");const r=Object.create(null);a+=8;const n=e[a++];r.randomAccess=!(1&n);if(!(2&n)){r.numberOfPages=(0,i.readUint32)(e,a);a+=4}const s=y(r,e,a,t),c=new C;S(s,c);const{width:l,height:h}=c.currentPageInfo,u=c.buffer,d=new Uint8ClampedArray(l*h);let f=0,g=0;for(let e=0;e<h;e++){let e,t=0;for(let a=0;a<l;a++){if(!t){t=128;e=u[g++]}d[f++]=e&t?0:255;t>>=1}}return{imgData:d,width:l,height:h}}(e);this.width=a;this.height=r;return t}};return D}();t.Jbig2Image=c},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.ArithmeticDecoder=void 0;const r=[{qe:22017,nmps:1,nlps:1,switchFlag:1},{qe:13313,nmps:2,nlps:6,switchFlag:0},{qe:6145,nmps:3,nlps:9,switchFlag:0},{qe:2753,nmps:4,nlps:12,switchFlag:0},{qe:1313,nmps:5,nlps:29,switchFlag:0},{qe:545,nmps:38,nlps:33,switchFlag:0},{qe:22017,nmps:7,nlps:6,switchFlag:1},{qe:21505,nmps:8,nlps:14,switchFlag:0},{qe:18433,nmps:9,nlps:14,switchFlag:0},{qe:14337,nmps:10,nlps:14,switchFlag:0},{qe:12289,nmps:11,nlps:17,switchFlag:0},{qe:9217,nmps:12,nlps:18,switchFlag:0},{qe:7169,nmps:13,nlps:20,switchFlag:0},{qe:5633,nmps:29,nlps:21,switchFlag:0},{qe:22017,nmps:15,nlps:14,switchFlag:1},{qe:21505,nmps:16,nlps:14,switchFlag:0},{qe:20737,nmps:17,nlps:15,switchFlag:0},{qe:18433,nmps:18,nlps:16,switchFlag:0},{qe:14337,nmps:19,nlps:17,switchFlag:0},{qe:13313,nmps:20,nlps:18,switchFlag:0},{qe:12289,nmps:21,nlps:19,switchFlag:0},{qe:10241,nmps:22,nlps:19,switchFlag:0},{qe:9217,nmps:23,nlps:20,switchFlag:0},{qe:8705,nmps:24,nlps:21,switchFlag:0},{qe:7169,nmps:25,nlps:22,switchFlag:0},{qe:6145,nmps:26,nlps:23,switchFlag:0},{qe:5633,nmps:27,nlps:24,switchFlag:0},{qe:5121,nmps:28,nlps:25,switchFlag:0},{qe:4609,nmps:29,nlps:26,switchFlag:0},{qe:4353,nmps:30,nlps:27,switchFlag:0},{qe:2753,nmps:31,nlps:28,switchFlag:0},{qe:2497,nmps:32,nlps:29,switchFlag:0},{qe:2209,nmps:33,nlps:30,switchFlag:0},{qe:1313,nmps:34,nlps:31,switchFlag:0},{qe:1089,nmps:35,nlps:32,switchFlag:0},{qe:673,nmps:36,nlps:33,switchFlag:0},{qe:545,nmps:37,nlps:34,switchFlag:0},{qe:321,nmps:38,nlps:35,switchFlag:0},{qe:273,nmps:39,nlps:36,switchFlag:0},{qe:133,nmps:40,nlps:37,switchFlag:0},{qe:73,nmps:41,nlps:38,switchFlag:0},{qe:37,nmps:42,nlps:39,switchFlag:0},{qe:21,nmps:43,nlps:40,switchFlag:0},{qe:9,nmps:44,nlps:41,switchFlag:0},{qe:5,nmps:45,nlps:42,switchFlag:0},{qe:1,nmps:45,nlps:43,switchFlag:0},{qe:22017,nmps:46,nlps:46,switchFlag:0}];t.ArithmeticDecoder=class{constructor(e,t,a){this.data=e;this.bp=t;this.dataEnd=a;this.chigh=e[t];this.clow=0;this.byteIn();this.chigh=this.chigh<<7&65535|this.clow>>9&127;this.clow=this.clow<<7&65535;this.ct-=7;this.a=32768}byteIn(){const e=this.data;let t=this.bp;if(255===e[t])if(e[t+1]>143){this.clow+=65280;this.ct=8}else{t++;this.clow+=e[t]<<9;this.ct=7;this.bp=t}else{t++;this.clow+=t<this.dataEnd?e[t]<<8:65280;this.ct=8;this.bp=t}if(this.clow>65535){this.chigh+=this.clow>>16;this.clow&=65535}}readBit(e,t){let a=e[t]>>1,i=1&e[t];const n=r[a],s=n.qe;let o,c=this.a-s;if(this.chigh<s)if(c<s){c=s;o=i;a=n.nmps}else{c=s;o=1^i;1===n.switchFlag&&(i=o);a=n.nlps}else{this.chigh-=s;if(0!=(32768&c)){this.a=c;return i}if(c<s){o=1^i;1===n.switchFlag&&(i=o);a=n.nlps}else{o=i;a=n.nmps}}do{0===this.ct&&this.byteIn();c<<=1;this.chigh=this.chigh<<1&65535|this.clow>>15&1;this.clow=this.clow<<1&65535;this.ct--}while(0==(32768&c));this.a=c;e[t]=a<<1|i;return o}}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.JpegStream=void 0;var r=a(2),i=a(11),n=a(4),s=a(18);const o=function(){function e(e,t,a,r){let n;for(;-1!==(n=e.getByte());)if(255===n){e.skip(-1);break}this.stream=e;this.maybeLength=t;this.dict=a;this.params=r;i.DecodeStream.call(this,t)}e.prototype=Object.create(i.DecodeStream.prototype);Object.defineProperty(e.prototype,"bytes",{get:function(){return(0,r.shadow)(this,"bytes",this.stream.getBytes(this.maybeLength))},configurable:!0});e.prototype.ensureBuffer=function(e){};e.prototype.readBlock=function(){if(this.eof)return;const e={decodeTransform:void 0,colorTransform:void 0},t=this.dict.getArray("Decode","D");if(this.forceRGB&&Array.isArray(t)){const a=this.dict.get("BitsPerComponent")||8,r=t.length,i=new Int32Array(r);let n=!1;const s=(1<<a)-1;for(let e=0;e<r;e+=2){i[e]=256*(t[e+1]-t[e])|0;i[e+1]=t[e]*s|0;256===i[e]&&0===i[e+1]||(n=!0)}n&&(e.decodeTransform=i)}if((0,n.isDict)(this.params)){const t=this.params.get("ColorTransform");Number.isInteger(t)&&(e.colorTransform=t)}const a=new s.JpegImage(e);a.parse(this.bytes);const r=a.getData({width:this.drawWidth,height:this.drawHeight,forceRGB:this.forceRGB,isSourcePDF:!0});this.buffer=r;this.bufferLength=r.length;this.eof=!0};Object.defineProperty(e.prototype,"maybeValidDimensions",{get:function(){const{dict:e,stream:t}=this,a=e.get("Height","H"),i=t.pos;let n,s=!0,o=!1;for(;-1!==(n=t.getByte());)if(255===n){switch(t.getByte()){case 192:case 193:case 194:o=!0;t.pos+=2;t.pos+=1;const e=t.getUint16();if(e===a)break;if(0===e){s=!1;break}if(e>10*a){s=!1;break}break;case 195:case 197:case 198:case 199:case 201:case 202:case 203:case 205:case 206:case 207:o=!0;break;case 196:case 204:case 218:case 219:case 220:case 221:case 222:case 223:case 224:case 225:case 226:case 227:case 228:case 229:case 230:case 231:case 232:case 233:case 234:case 235:case 236:case 237:case 238:case 239:case 254:const r=t.getUint16();r>2?t.skip(r-2):t.skip(-2);break;case 255:t.skip(-1);break;case 217:o=!0}if(o)break}t.pos=i;return(0,r.shadow)(this,"maybeValidDimensions",s)},configurable:!0});e.prototype.getIR=function(e=!1){return(0,r.createObjectURL)(this.bytes,"image/jpeg",e)};return e}();t.JpegStream=o},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.JpegImage=void 0;var r=a(2),i=a(7);class n extends r.BaseException{constructor(e){super(`JPEG error: ${e}`)}}class s extends r.BaseException{constructor(e,t){super(e);this.scanLines=t}}class o extends r.BaseException{}var c=function(){var e=new Uint8Array([0,1,8,16,9,2,3,10,17,24,32,25,18,11,4,5,12,19,26,33,40,48,41,34,27,20,13,6,7,14,21,28,35,42,49,56,57,50,43,36,29,22,15,23,30,37,44,51,58,59,52,45,38,31,39,46,53,60,61,54,47,55,62,63]);function t({decodeTransform:e=null,colorTransform:t=-1}={}){this._decodeTransform=e;this._colorTransform=t}function a(e,t){for(var a,r,i=0,n=[],s=16;s>0&&!e[s-1];)s--;n.push({children:[],index:0});var o,c=n[0];for(a=0;a<s;a++){for(r=0;r<e[a];r++){(c=n.pop()).children[c.index]=t[i];for(;c.index>0;)c=n.pop();c.index++;n.push(c);for(;n.length<=a;){n.push(o={children:[],index:0});c.children[c.index]=o.children;c=o}i++}if(a+1<s){n.push(o={children:[],index:0});c.children[c.index]=o.children;c=o}}return n[0].children}function c(e,t,a){return 64*((e.blocksPerLine+1)*t+a)}function l(t,a,l,h,u,f,g,m,p,b=!1){var y=l.mcusPerLine,v=l.progressive,w=a,k=0,S=0;function C(){if(S>0){S--;return k>>S&1}if(255===(k=t[a++])){var e=t[a++];if(e){if(220===e&&b){a+=2;const e=(0,i.readUint16)(t,a);a+=2;if(e>0&&e!==l.scanLines)throw new s("Found DNL marker (0xFFDC) while parsing scan data",e)}else if(217===e){if(b){const e=8*O;if(e>0&&e<l.scanLines/10)throw new s("Found EOI marker (0xFFD9) while parsing scan data, possibly caused by incorrect `scanLines` parameter",e)}throw new o("Found EOI marker (0xFFD9) while parsing scan data")}throw new n(`unexpected marker ${(k<<8|e).toString(16)}`)}}S=7;return k>>>7}function x(e){for(var t=e;;){switch(typeof(t=t[C()])){case"number":return t;case"object":continue}throw new n("invalid huffman sequence")}}function A(e){for(var t=0;e>0;){t=t<<1|C();e--}return t}function I(e){if(1===e)return 1===C()?1:-1;var t=A(e);return t>=1<<e-1?t:t+(-1<<e)+1}var F=0;var T,E=0;let O=0;function P(e,t,a,r,i){var n=a%y;O=(a/y|0)*e.v+r;var s=n*e.h+i;t(e,c(e,O,s))}function B(e,t,a){O=a/e.blocksPerLine|0;var r=a%e.blocksPerLine;t(e,c(e,O,r))}var D,N,M,L,R,U,q=h.length;U=v?0===f?0===m?function(e,t){var a=x(e.huffmanTableDC),r=0===a?0:I(a)<<p;e.blockData[t]=e.pred+=r}:function(e,t){e.blockData[t]|=C()<<p}:0===m?function(t,a){if(F>0)F--;else for(var r=f,i=g;r<=i;){var n=x(t.huffmanTableAC),s=15&n,o=n>>4;if(0!==s){var c=e[r+=o];t.blockData[a+c]=I(s)*(1<<p);r++}else{if(o<15){F=A(o)+(1<<o)-1;break}r+=16}}}:function(t,a){for(var r,i,s=f,o=g,c=0;s<=o;){const o=a+e[s],l=t.blockData[o]<0?-1:1;switch(E){case 0:c=(i=x(t.huffmanTableAC))>>4;if(0===(r=15&i))if(c<15){F=A(c)+(1<<c);E=4}else{c=16;E=1}else{if(1!==r)throw new n("invalid ACn encoding");T=I(r);E=c?2:3}continue;case 1:case 2:t.blockData[o]?t.blockData[o]+=l*(C()<<p):0===--c&&(E=2===E?3:0);break;case 3:if(t.blockData[o])t.blockData[o]+=l*(C()<<p);else{t.blockData[o]=T<<p;E=0}break;case 4:t.blockData[o]&&(t.blockData[o]+=l*(C()<<p))}s++}4===E&&0===--F&&(E=0)}:function(t,a){var r=x(t.huffmanTableDC),i=0===r?0:I(r);t.blockData[a]=t.pred+=i;for(var n=1;n<64;){var s=x(t.huffmanTableAC),o=15&s,c=s>>4;if(0!==o){var l=e[n+=c];t.blockData[a+l]=I(o);n++}else{if(c<15)break;n+=16}}};var j,_,z,H,G=0;_=1===q?h[0].blocksPerLine*h[0].blocksPerColumn:y*l.mcusPerColumn;for(;G<_;){var W=u?Math.min(_-G,u):_;for(N=0;N<q;N++)h[N].pred=0;F=0;if(1===q){D=h[0];for(R=0;R<W;R++){B(D,U,G);G++}}else for(R=0;R<W;R++){for(N=0;N<q;N++){z=(D=h[N]).h;H=D.v;for(M=0;M<H;M++)for(L=0;L<z;L++)P(D,U,G,M,L)}G++}S=0;if(!(j=d(t,a)))break;if(j.invalid){(0,r.warn)("decodeScan - unexpected MCU data, current marker is: "+j.invalid);a=j.offset}var X=j&&j.marker;if(!X||X<=65280)throw new n("decodeScan - a valid marker was not found.");if(!(X>=65488&&X<=65495))break;a+=2}if((j=d(t,a))&&j.invalid){(0,r.warn)("decodeScan - unexpected Scan data, current marker is: "+j.invalid);a=j.offset}return a-w}function h(e,t,a){var r,i,s,o,c,l,h,u,d,f,g,m,p,b,y,v,w,k=e.quantizationTable,S=e.blockData;if(!k)throw new n("missing required Quantization Table.");for(var C=0;C<64;C+=8){d=S[t+C];f=S[t+C+1];g=S[t+C+2];m=S[t+C+3];p=S[t+C+4];b=S[t+C+5];y=S[t+C+6];v=S[t+C+7];d*=k[C];if(0!=(f|g|m|p|b|y|v)){f*=k[C+1];g*=k[C+2];m*=k[C+3];p*=k[C+4];b*=k[C+5];i=(r=(r=5793*d+128>>8)+(i=5793*p+128>>8)+1>>1)-i;w=3784*(s=g)+1567*(o=y*=k[C+6])+128>>8;s=1567*s-3784*o+128>>8;h=(c=(c=2896*(f-(v*=k[C+7]))+128>>8)+(h=b<<4)+1>>1)-h;l=(u=(u=2896*(f+v)+128>>8)+(l=m<<4)+1>>1)-l;o=(r=r+(o=w)+1>>1)-o;s=(i=i+s+1>>1)-s;w=2276*c+3406*u+2048>>12;c=3406*c-2276*u+2048>>12;u=w;w=799*l+4017*h+2048>>12;l=4017*l-799*h+2048>>12;h=w;a[C]=r+u;a[C+7]=r-u;a[C+1]=i+h;a[C+6]=i-h;a[C+2]=s+l;a[C+5]=s-l;a[C+3]=o+c;a[C+4]=o-c}else{w=5793*d+512>>10;a[C]=w;a[C+1]=w;a[C+2]=w;a[C+3]=w;a[C+4]=w;a[C+5]=w;a[C+6]=w;a[C+7]=w}}for(var x=0;x<8;++x){d=a[x];if(0!=((f=a[x+8])|(g=a[x+16])|(m=a[x+24])|(p=a[x+32])|(b=a[x+40])|(y=a[x+48])|(v=a[x+56]))){i=(r=4112+((r=5793*d+2048>>12)+(i=5793*p+2048>>12)+1>>1))-i;w=3784*(s=g)+1567*(o=y)+2048>>12;s=1567*s-3784*o+2048>>12;o=w;h=(c=(c=2896*(f-v)+2048>>12)+(h=b)+1>>1)-h;l=(u=(u=2896*(f+v)+2048>>12)+(l=m)+1>>1)-l;w=2276*c+3406*u+2048>>12;c=3406*c-2276*u+2048>>12;u=w;w=799*l+4017*h+2048>>12;l=4017*l-799*h+2048>>12;(d=(r=r+o+1>>1)+u)<16?d=0:d>=4080?d=255:d>>=4;(f=(i=i+s+1>>1)+(h=w))<16?f=0:f>=4080?f=255:f>>=4;(g=(s=i-s)+l)<16?g=0:g>=4080?g=255:g>>=4;(m=(o=r-o)+c)<16?m=0:m>=4080?m=255:m>>=4;(p=o-c)<16?p=0:p>=4080?p=255:p>>=4;(b=s-l)<16?b=0:b>=4080?b=255:b>>=4;(y=i-h)<16?y=0:y>=4080?y=255:y>>=4;(v=r-u)<16?v=0:v>=4080?v=255:v>>=4;S[t+x]=d;S[t+x+8]=f;S[t+x+16]=g;S[t+x+24]=m;S[t+x+32]=p;S[t+x+40]=b;S[t+x+48]=y;S[t+x+56]=v}else{w=(w=5793*d+8192>>14)<-2040?0:w>=2024?255:w+2056>>4;S[t+x]=w;S[t+x+8]=w;S[t+x+16]=w;S[t+x+24]=w;S[t+x+32]=w;S[t+x+40]=w;S[t+x+48]=w;S[t+x+56]=w}}}function u(e,t){for(var a=t.blocksPerLine,r=t.blocksPerColumn,i=new Int16Array(64),n=0;n<r;n++)for(var s=0;s<a;s++){h(t,c(t,n,s),i)}return t.blockData}function d(e,t,a=t){const r=e.length-1;var n=a<t?a:t;if(t>=r)return null;var s=(0,i.readUint16)(e,t);if(s>=65472&&s<=65534)return{invalid:null,marker:s,offset:t};for(var o=(0,i.readUint16)(e,n);!(o>=65472&&o<=65534);){if(++n>=r)return null;o=(0,i.readUint16)(e,n)}return{invalid:s.toString(16),marker:o,offset:n}}t.prototype={parse(t,{dnlScanLines:c=null}={}){function h(){const e=(0,i.readUint16)(t,p);let a=(p+=2)+e-2;var n=d(t,a,p);if(n&&n.invalid){(0,r.warn)("readDataBlock - incorrect length, current marker is: "+n.invalid);a=n.offset}var s=t.subarray(p,a);p+=s.length;return s}function f(e){for(var t=Math.ceil(e.samplesPerLine/8/e.maxH),a=Math.ceil(e.scanLines/8/e.maxV),r=0;r<e.components.length;r++){z=e.components[r];var i=Math.ceil(Math.ceil(e.samplesPerLine/8)*z.h/e.maxH),n=Math.ceil(Math.ceil(e.scanLines/8)*z.v/e.maxV),s=t*z.h,o=64*(a*z.v)*(s+1);z.blockData=new Int16Array(o);z.blocksPerLine=i;z.blocksPerColumn=n}e.mcusPerLine=t;e.mcusPerColumn=a}var g,m,p=0,b=null,y=null;let v=0;var w=[],k=[],S=[];let C=(0,i.readUint16)(t,p);p+=2;if(65496!==C)throw new n("SOI not found");C=(0,i.readUint16)(t,p);p+=2;e:for(;65497!==C;){var x,A,I;switch(C){case 65504:case 65505:case 65506:case 65507:case 65508:case 65509:case 65510:case 65511:case 65512:case 65513:case 65514:case 65515:case 65516:case 65517:case 65518:case 65519:case 65534:var F=h();65504===C&&74===F[0]&&70===F[1]&&73===F[2]&&70===F[3]&&0===F[4]&&(b={version:{major:F[5],minor:F[6]},densityUnits:F[7],xDensity:F[8]<<8|F[9],yDensity:F[10]<<8|F[11],thumbWidth:F[12],thumbHeight:F[13],thumbData:F.subarray(14,14+3*F[12]*F[13])});65518===C&&65===F[0]&&100===F[1]&&111===F[2]&&98===F[3]&&101===F[4]&&(y={version:F[5]<<8|F[6],flags0:F[7]<<8|F[8],flags1:F[9]<<8|F[10],transformCode:F[11]});break;case 65499:for(var T=(0,i.readUint16)(t,p)+(p+=2)-2;p<T;){var E=t[p++],O=new Uint16Array(64);if(E>>4==0)for(A=0;A<64;A++)O[e[A]]=t[p++];else{if(E>>4!=1)throw new n("DQT - invalid table spec");for(A=0;A<64;A++){O[e[A]]=(0,i.readUint16)(t,p);p+=2}}w[15&E]=O}break;case 65472:case 65473:case 65474:if(g)throw new n("Only single frame JPEGs supported");p+=2;(g={}).extended=65473===C;g.progressive=65474===C;g.precision=t[p++];const u=(0,i.readUint16)(t,p);p+=2;g.scanLines=c||u;g.samplesPerLine=(0,i.readUint16)(t,p);p+=2;g.components=[];g.componentIds={};var P,B=t[p++],D=0,N=0;for(x=0;x<B;x++){P=t[p];var M=t[p+1]>>4,L=15&t[p+1];D<M&&(D=M);N<L&&(N=L);var R=t[p+2];I=g.components.push({h:M,v:L,quantizationId:R,quantizationTable:null});g.componentIds[P]=I-1;p+=3}g.maxH=D;g.maxV=N;f(g);break;case 65476:const J=(0,i.readUint16)(t,p);p+=2;for(x=2;x<J;){var U=t[p++],q=new Uint8Array(16),j=0;for(A=0;A<16;A++,p++)j+=q[A]=t[p];var _=new Uint8Array(j);for(A=0;A<j;A++,p++)_[A]=t[p];x+=17+j;(U>>4==0?S:k)[15&U]=a(q,_)}break;case 65501:p+=2;m=(0,i.readUint16)(t,p);p+=2;break;case 65498:const Z=1==++v&&!c;p+=2;var z,H=t[p++],G=[];for(x=0;x<H;x++){var W=g.componentIds[t[p++]];z=g.components[W];var X=t[p++];z.huffmanTableDC=S[X>>4];z.huffmanTableAC=k[15&X];G.push(z)}var V=t[p++],K=t[p++],Y=t[p++];try{var $=l(t,p,g,G,m,V,K,Y>>4,15&Y,Z);p+=$}catch(e){if(e instanceof s){(0,r.warn)(`${e.message} -- attempting to re-parse the JPEG image.`);return this.parse(t,{dnlScanLines:e.scanLines})}if(e instanceof o){(0,r.warn)(`${e.message} -- ignoring the rest of the image data.`);break e}throw e}break;case 65500:p+=4;break;case 65535:255!==t[p]&&p--;break;default:const Q=d(t,p-2,p-3);if(Q&&Q.invalid){(0,r.warn)("JpegImage.parse - unexpected data, current marker is: "+Q.invalid);p=Q.offset;break}if(p>=t.length-1){(0,r.warn)("JpegImage.parse - reached the end of the image data without finding an EOI marker (0xFFD9).");break e}throw new n("JpegImage.parse - unknown marker: "+C.toString(16))}C=(0,i.readUint16)(t,p);p+=2}this.width=g.samplesPerLine;this.height=g.scanLines;this.jfif=b;this.adobe=y;this.components=[];for(x=0;x<g.components.length;x++){var J=w[(z=g.components[x]).quantizationId];J&&(z.quantizationTable=J);this.components.push({output:u(0,z),scaleX:z.h/g.maxH,scaleY:z.v/g.maxV,blocksPerLine:z.blocksPerLine,blocksPerColumn:z.blocksPerColumn})}this.numComponents=this.components.length},_getLinearizedBlockData(e,t,a=!1){var r,i,n,s,o,c,l,h,u,d,f,g=this.width/e,m=this.height/t,p=0,b=this.components.length,y=e*t*b,v=new Uint8ClampedArray(y),w=new Uint32Array(e);let k;for(l=0;l<b;l++){i=(r=this.components[l]).scaleX*g;n=r.scaleY*m;p=l;f=r.output;s=r.blocksPerLine+1<<3;if(i!==k){for(o=0;o<e;o++){h=0|o*i;w[o]=(4294967288&h)<<3|7&h}k=i}for(c=0;c<t;c++){d=s*(4294967288&(h=0|c*n))|(7&h)<<3;for(o=0;o<e;o++){v[p]=f[d+w[o]];p+=b}}}let S=this._decodeTransform;a||4!==b||S||(S=new Int32Array([-256,255,-256,255,-256,255,-256,255]));if(S)for(l=0;l<y;)for(h=0,u=0;h<b;h++,l++,u+=2)v[l]=(v[l]*S[u]>>8)+S[u+1];return v},get _isColorConversionNeeded(){return this.adobe?!!this.adobe.transformCode:3===this.numComponents?0!==this._colorTransform:1===this._colorTransform},_convertYccToRgb:function(e){for(var t,a,r,i=0,n=e.length;i<n;i+=3){t=e[i];a=e[i+1];r=e[i+2];e[i]=t-179.456+1.402*r;e[i+1]=t+135.459-.344*a-.714*r;e[i+2]=t-226.816+1.772*a}return e},_convertYcckToRgb:function(e){for(var t,a,r,i,n=0,s=0,o=e.length;s<o;s+=4){t=e[s];a=e[s+1];r=e[s+2];i=e[s+3];e[n++]=a*(-660635669420364e-19*a+.000437130475926232*r-54080610064599e-18*t+.00048449797120281*i-.154362151871126)-122.67195406894+r*(-.000957964378445773*r+.000817076911346625*t-.00477271405408747*i+1.53380253221734)+t*(.000961250184130688*t-.00266257332283933*i+.48357088451265)+i*(-.000336197177618394*i+.484791561490776);e[n++]=107.268039397724+a*(219927104525741e-19*a-.000640992018297945*r+.000659397001245577*t+.000426105652938837*i-.176491792462875)+r*(-.000778269941513683*r+.00130872261408275*t+.000770482631801132*i-.151051492775562)+t*(.00126935368114843*t-.00265090189010898*i+.25802910206845)+i*(-.000318913117588328*i-.213742400323665);e[n++]=a*(-.000570115196973677*a-263409051004589e-19*r+.0020741088115012*t-.00288260236853442*i+.814272968359295)-20.810012546947+r*(-153496057440975e-19*r-.000132689043961446*t+.000560833691242812*i-.195152027534049)+t*(.00174418132927582*t-.00255243321439347*i+.116935020465145)+i*(-.000343531996510555*i+.24165260232407)}return e.subarray(0,n)},_convertYcckToCmyk:function(e){for(var t,a,r,i=0,n=e.length;i<n;i+=4){t=e[i];a=e[i+1];r=e[i+2];e[i]=434.456-t-1.402*r;e[i+1]=119.541-t+.344*a+.714*r;e[i+2]=481.816-t-1.772*a}return e},_convertCmykToRgb:function(e){for(var t,a,r,i,n=0,s=0,o=e.length;s<o;s+=4){t=e[s];a=e[s+1];r=e[s+2];i=e[s+3];e[n++]=255+t*(-6747147073602441e-20*t+.0008379262121013727*a+.0002894718188643294*r+.003264231057537806*i-1.1185611867203937)+a*(26374107616089405e-21*a-8626949158638572e-20*r-.0002748769067499491*i-.02155688794978967)+r*(-3878099212869363e-20*r-.0003267808279485286*i+.0686742238595345)-i*(.0003361971776183937*i+.7430659151342254);e[n++]=255+t*(.00013596372813588848*t+.000924537132573585*a+.00010567359618683593*r+.0004791864687436512*i-.3109689587515875)+a*(-.00023545346108370344*a+.0002702845253534714*r+.0020200308977307156*i-.7488052167015494)+r*(6834815998235662e-20*r+.00015168452363460973*i-.09751927774728933)-i*(.0003189131175883281*i+.7364883807733168);e[n++]=255+t*(13598650411385307e-21*t+.00012423956175490851*a+.0004751985097583589*r-36729317476630422e-22*i-.05562186980264034)+a*(.00016141380598724676*a+.0009692239130725186*r+.0007782692450036253*i-.44015232367526463)+r*(5.068882914068769e-7*r+.0017778369011375071*i-.7591454649749609)-i*(.0003435319965105553*i+.7063770186160144)}return e.subarray(0,n)},getData({width:e,height:t,forceRGB:a=!1,isSourcePDF:r=!1}){if(this.numComponents>4)throw new n("Unsupported color mode");var i=this._getLinearizedBlockData(e,t,r);if(1===this.numComponents&&a){for(var s=i.length,o=new Uint8ClampedArray(3*s),c=0,l=0;l<s;l++){var h=i[l];o[c++]=h;o[c++]=h;o[c++]=h}return o}if(3===this.numComponents&&this._isColorConversionNeeded)return this._convertYccToRgb(i);if(4===this.numComponents){if(this._isColorConversionNeeded)return a?this._convertYcckToRgb(i):this._convertYcckToCmyk(i);if(a)return this._convertCmykToRgb(i)}return i}};return t}();t.JpegImage=c},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.JpxStream=void 0;var r=a(11),i=a(20),n=a(2);const s=function(){function e(e,t,a,i){this.stream=e;this.maybeLength=t;this.dict=a;this.params=i;r.DecodeStream.call(this,t)}e.prototype=Object.create(r.DecodeStream.prototype);Object.defineProperty(e.prototype,"bytes",{get:function(){return(0,n.shadow)(this,"bytes",this.stream.getBytes(this.maybeLength))},configurable:!0});e.prototype.ensureBuffer=function(e){};e.prototype.readBlock=function(){if(this.eof)return;const e=new i.JpxImage;e.parse(this.bytes);const t=e.width,a=e.height,r=e.componentsCount,n=e.tiles.length;if(1===n)this.buffer=e.tiles[0].items;else{const i=new Uint8ClampedArray(t*a*r);for(let a=0;a<n;a++){const n=e.tiles[a],s=n.width,o=n.height,c=n.left,l=n.top,h=n.items;let u=0,d=(t*l+c)*r;const f=t*r,g=s*r;for(let e=0;e<o;e++){const e=h.subarray(u,u+g);i.set(e,d);u+=g;d+=f}}this.buffer=i}this.bufferLength=this.buffer.length;this.eof=!0};return e}();t.JpxStream=s},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.JpxImage=void 0;var r=a(2),i=a(7),n=a(16);class s extends r.BaseException{constructor(e){super(`JPX error: ${e}`)}}var o=function(){var e={LL:0,LH:1,HL:1,HH:2};function t(){this.failOnCorruptedImage=!1}t.prototype={parse:function(e){if(65359!==(0,i.readUint16)(e,0))for(var t=0,a=e.length;t<a;){var n=8,o=(0,i.readUint32)(e,t),c=(0,i.readUint32)(e,t+4);t+=n;if(1===o){o=4294967296*(0,i.readUint32)(e,t)+(0,i.readUint32)(e,t+4);t+=8;n+=8}0===o&&(o=a-t+n);if(o<n)throw new s("Invalid box field size");var l=o-n,h=!0;switch(c){case 1785737832:h=!1;break;case 1668246642:var u=e[t];if(1===u){var d=(0,i.readUint32)(e,t+3);switch(d){case 16:case 17:case 18:break;default:(0,r.warn)("Unknown colorspace "+d)}}else 2===u&&(0,r.info)("ICC profile not supported");break;case 1785737827:this.parseCodestream(e,t,t+l);break;case 1783636e3:218793738!==(0,i.readUint32)(e,t)&&(0,r.warn)("Invalid JP2 signature");break;case 1783634458:case 1718909296:case 1920099697:case 1919251232:case 1768449138:break;default:var f=String.fromCharCode(c>>24&255,c>>16&255,c>>8&255,255&c);(0,r.warn)("Unsupported header type "+c+" ("+f+")")}h&&(t+=l)}else this.parseCodestream(e,0,e.length)},parseImageProperties:function(e){for(var t=e.getByte();t>=0;){if(65361===(t<<8|(t=e.getByte()))){e.skip(4);var a=e.getInt32()>>>0,r=e.getInt32()>>>0,i=e.getInt32()>>>0,n=e.getInt32()>>>0;e.skip(16);var o=e.getUint16();this.width=a-i;this.height=r-n;this.componentsCount=o;this.bitsPerComponent=8;return}}throw new s("No size marker found in JPX stream")},parseCodestream:function(e,t,n){var c={},l=!1;try{for(var h=t;h+1<n;){var u=(0,i.readUint16)(e,h);h+=2;var d,f,g,m,p,b,y=0;switch(u){case 65359:c.mainHeader=!0;break;case 65497:break;case 65361:y=(0,i.readUint16)(e,h);var k={};k.Xsiz=(0,i.readUint32)(e,h+4);k.Ysiz=(0,i.readUint32)(e,h+8);k.XOsiz=(0,i.readUint32)(e,h+12);k.YOsiz=(0,i.readUint32)(e,h+16);k.XTsiz=(0,i.readUint32)(e,h+20);k.YTsiz=(0,i.readUint32)(e,h+24);k.XTOsiz=(0,i.readUint32)(e,h+28);k.YTOsiz=(0,i.readUint32)(e,h+32);var x=(0,i.readUint16)(e,h+36);k.Csiz=x;var A=[];d=h+38;for(var I=0;I<x;I++){var F={precision:1+(127&e[d]),isSigned:!!(128&e[d]),XRsiz:e[d+1],YRsiz:e[d+2]};d+=3;a(F,k);A.push(F)}c.SIZ=k;c.components=A;o(c,A);c.QCC=[];c.COC=[];break;case 65372:y=(0,i.readUint16)(e,h);var T={};d=h+2;switch(31&(f=e[d++])){case 0:m=8;p=!0;break;case 1:m=16;p=!1;break;case 2:m=16;p=!0;break;default:throw new Error("Invalid SQcd value "+f)}T.noQuantization=8===m;T.scalarExpounded=p;T.guardBits=f>>5;g=[];for(;d<y+h;){var E={};if(8===m){E.epsilon=e[d++]>>3;E.mu=0}else{E.epsilon=e[d]>>3;E.mu=(7&e[d])<<8|e[d+1];d+=2}g.push(E)}T.SPqcds=g;if(c.mainHeader)c.QCD=T;else{c.currentTile.QCD=T;c.currentTile.QCC=[]}break;case 65373:y=(0,i.readUint16)(e,h);var O,P={};d=h+2;if(c.SIZ.Csiz<257)O=e[d++];else{O=(0,i.readUint16)(e,d);d+=2}switch(31&(f=e[d++])){case 0:m=8;p=!0;break;case 1:m=16;p=!1;break;case 2:m=16;p=!0;break;default:throw new Error("Invalid SQcd value "+f)}P.noQuantization=8===m;P.scalarExpounded=p;P.guardBits=f>>5;g=[];for(;d<y+h;){E={};if(8===m){E.epsilon=e[d++]>>3;E.mu=0}else{E.epsilon=e[d]>>3;E.mu=(7&e[d])<<8|e[d+1];d+=2}g.push(E)}P.SPqcds=g;c.mainHeader?c.QCC[O]=P:c.currentTile.QCC[O]=P;break;case 65362:y=(0,i.readUint16)(e,h);var B={};d=h+2;var D=e[d++];B.entropyCoderWithCustomPrecincts=!!(1&D);B.sopMarkerUsed=!!(2&D);B.ephMarkerUsed=!!(4&D);B.progressionOrder=e[d++];B.layersCount=(0,i.readUint16)(e,d);d+=2;B.multipleComponentTransform=e[d++];B.decompositionLevelsCount=e[d++];B.xcb=2+(15&e[d++]);B.ycb=2+(15&e[d++]);var N=e[d++];B.selectiveArithmeticCodingBypass=!!(1&N);B.resetContextProbabilities=!!(2&N);B.terminationOnEachCodingPass=!!(4&N);B.verticallyStripe=!!(8&N);B.predictableTermination=!!(16&N);B.segmentationSymbolUsed=!!(32&N);B.reversibleTransformation=e[d++];if(B.entropyCoderWithCustomPrecincts){for(var M=[];d<y+h;){var L=e[d++];M.push({PPx:15&L,PPy:L>>4})}B.precinctsSizes=M}var R=[];B.selectiveArithmeticCodingBypass&&R.push("selectiveArithmeticCodingBypass");B.resetContextProbabilities&&R.push("resetContextProbabilities");B.terminationOnEachCodingPass&&R.push("terminationOnEachCodingPass");B.verticallyStripe&&R.push("verticallyStripe");B.predictableTermination&&R.push("predictableTermination");if(R.length>0){l=!0;throw new Error("Unsupported COD options ("+R.join(", ")+")")}if(c.mainHeader)c.COD=B;else{c.currentTile.COD=B;c.currentTile.COC=[]}break;case 65424:y=(0,i.readUint16)(e,h);(b={}).index=(0,i.readUint16)(e,h+2);b.length=(0,i.readUint32)(e,h+4);b.dataEnd=b.length+h-2;b.partIndex=e[h+8];b.partsCount=e[h+9];c.mainHeader=!1;if(0===b.partIndex){b.COD=c.COD;b.COC=c.COC.slice(0);b.QCD=c.QCD;b.QCC=c.QCC.slice(0)}c.currentTile=b;break;case 65427:if(0===(b=c.currentTile).partIndex){C(c,b.index);v(c)}w(c,e,h,y=b.dataEnd-h);break;case 65365:case 65367:case 65368:case 65380:y=(0,i.readUint16)(e,h);break;case 65363:throw new Error("Codestream code 0xFF53 (COC) is not implemented");default:throw new Error("Unknown codestream code: "+u.toString(16))}h+=y}}catch(e){if(l||this.failOnCorruptedImage)throw new s(e.message);(0,r.warn)("JPX: Trying to recover from: "+e.message)}this.tiles=function(e){for(var t=e.SIZ,a=e.components,r=t.Csiz,i=[],n=0,s=e.tiles.length;n<s;n++){var o,c=e.tiles[n],l=[];for(o=0;o<r;o++)l[o]=S(e,c,o);var h,u,d,f,g,m,p,b=l[0],y=new Uint8ClampedArray(b.items.length*r),v={left:b.left,top:b.top,width:b.width,height:b.height,items:y},w=0;if(c.codingStyleDefaultParameters.multipleComponentTransform){var k=4===r,C=l[0].items,x=l[1].items,A=l[2].items,I=k?l[3].items:null;h=a[0].precision-8;u=.5+(128<<h);var F=c.components[0],T=r-3;f=C.length;if(F.codingStyleParameters.reversibleTransformation)for(d=0;d<f;d++,w+=T){g=C[d]+u;m=x[d];p=A[d];const e=g-(p+m>>2);y[w++]=e+p>>h;y[w++]=e>>h;y[w++]=e+m>>h}else for(d=0;d<f;d++,w+=T){g=C[d]+u;m=x[d];p=A[d];y[w++]=g+1.402*p>>h;y[w++]=g-.34413*m-.71414*p>>h;y[w++]=g+1.772*m>>h}if(k)for(d=0,w=3;d<f;d++,w+=4)y[w]=I[d]+u>>h}else for(o=0;o<r;o++){var E=l[o].items;h=a[o].precision-8;u=.5+(128<<h);for(w=o,d=0,f=E.length;d<f;d++){y[w]=E[d]+u>>h;w+=r}}i.push(v)}return i}(c);this.width=c.SIZ.Xsiz-c.SIZ.XOsiz;this.height=c.SIZ.Ysiz-c.SIZ.YOsiz;this.componentsCount=c.SIZ.Csiz}};function a(e,t){e.x0=Math.ceil(t.XOsiz/e.XRsiz);e.x1=Math.ceil(t.Xsiz/e.XRsiz);e.y0=Math.ceil(t.YOsiz/e.YRsiz);e.y1=Math.ceil(t.Ysiz/e.YRsiz);e.width=e.x1-e.x0;e.height=e.y1-e.y0}function o(e,t){for(var a,r=e.SIZ,i=[],n=Math.ceil((r.Xsiz-r.XTOsiz)/r.XTsiz),s=Math.ceil((r.Ysiz-r.YTOsiz)/r.YTsiz),o=0;o<s;o++)for(var c=0;c<n;c++){(a={}).tx0=Math.max(r.XTOsiz+c*r.XTsiz,r.XOsiz);a.ty0=Math.max(r.YTOsiz+o*r.YTsiz,r.YOsiz);a.tx1=Math.min(r.XTOsiz+(c+1)*r.XTsiz,r.Xsiz);a.ty1=Math.min(r.YTOsiz+(o+1)*r.YTsiz,r.Ysiz);a.width=a.tx1-a.tx0;a.height=a.ty1-a.ty0;a.components=[];i.push(a)}e.tiles=i;for(var l=0,h=r.Csiz;l<h;l++)for(var u=t[l],d=0,f=i.length;d<f;d++){var g={};a=i[d];g.tcx0=Math.ceil(a.tx0/u.XRsiz);g.tcy0=Math.ceil(a.ty0/u.YRsiz);g.tcx1=Math.ceil(a.tx1/u.XRsiz);g.tcy1=Math.ceil(a.ty1/u.YRsiz);g.width=g.tcx1-g.tcx0;g.height=g.tcy1-g.tcy0;a.components[l]=g}}function c(e,t,a){var r=t.codingStyleParameters,i={};if(r.entropyCoderWithCustomPrecincts){i.PPx=r.precinctsSizes[a].PPx;i.PPy=r.precinctsSizes[a].PPy}else{i.PPx=15;i.PPy=15}i.xcb_=a>0?Math.min(r.xcb,i.PPx-1):Math.min(r.xcb,i.PPx);i.ycb_=a>0?Math.min(r.ycb,i.PPy-1):Math.min(r.ycb,i.PPy);return i}function l(e,t,a){var r=1<<a.PPx,i=1<<a.PPy,n=0===t.resLevel,s=1<<a.PPx+(n?0:-1),o=1<<a.PPy+(n?0:-1),c=t.trx1>t.trx0?Math.ceil(t.trx1/r)-Math.floor(t.trx0/r):0,l=t.try1>t.try0?Math.ceil(t.try1/i)-Math.floor(t.try0/i):0,h=c*l;t.precinctParameters={precinctWidth:r,precinctHeight:i,numprecinctswide:c,numprecinctshigh:l,numprecincts:h,precinctWidthInSubband:s,precinctHeightInSubband:o}}function h(e,t,a){var r,i,n,s,o=a.xcb_,c=a.ycb_,l=1<<o,h=1<<c,u=t.tbx0>>o,d=t.tby0>>c,f=t.tbx1+l-1>>o,g=t.tby1+h-1>>c,m=t.resolution.precinctParameters,p=[],b=[];for(i=d;i<g;i++)for(r=u;r<f;r++){(n={cbx:r,cby:i,tbx0:l*r,tby0:h*i,tbx1:l*(r+1),tby1:h*(i+1)}).tbx0_=Math.max(t.tbx0,n.tbx0);n.tby0_=Math.max(t.tby0,n.tby0);n.tbx1_=Math.min(t.tbx1,n.tbx1);n.tby1_=Math.min(t.tby1,n.tby1);s=Math.floor((n.tbx0_-t.tbx0)/m.precinctWidthInSubband)+Math.floor((n.tby0_-t.tby0)/m.precinctHeightInSubband)*m.numprecinctswide;n.precinctNumber=s;n.subbandType=t.type;n.Lblock=3;if(!(n.tbx1_<=n.tbx0_||n.tby1_<=n.tby0_)){p.push(n);var y=b[s];if(void 0!==y){r<y.cbxMin?y.cbxMin=r:r>y.cbxMax&&(y.cbxMax=r);i<y.cbyMin?y.cbxMin=i:i>y.cbyMax&&(y.cbyMax=i)}else b[s]=y={cbxMin:r,cbyMin:i,cbxMax:r,cbyMax:i};n.precinct=y}}t.codeblockParameters={codeblockWidth:o,codeblockHeight:c,numcodeblockwide:f-u+1,numcodeblockhigh:g-d+1};t.codeblocks=p;t.precincts=b}function u(e,t,a){for(var r=[],i=e.subbands,n=0,s=i.length;n<s;n++)for(var o=i[n].codeblocks,c=0,l=o.length;c<l;c++){var h=o[c];h.precinctNumber===t&&r.push(h)}return{layerNumber:a,codeblocks:r}}function d(e){for(var t=e.SIZ,a=e.currentTile.index,r=e.tiles[a],i=r.codingStyleDefaultParameters.layersCount,n=t.Csiz,o=0,c=0;c<n;c++)o=Math.max(o,r.components[c].codingStyleParameters.decompositionLevelsCount);var l=0,h=0,d=0,f=0;this.nextPacket=function(){for(;l<i;l++){for(;h<=o;h++){for(;d<n;d++){var e=r.components[d];if(!(h>e.codingStyleParameters.decompositionLevelsCount)){for(var t=e.resolutions[h],a=t.precinctParameters.numprecincts;f<a;){var c=u(t,f,l);f++;return c}f=0}}d=0}h=0}throw new s("Out of packets")}}function f(e){for(var t=e.SIZ,a=e.currentTile.index,r=e.tiles[a],i=r.codingStyleDefaultParameters.layersCount,n=t.Csiz,o=0,c=0;c<n;c++)o=Math.max(o,r.components[c].codingStyleParameters.decompositionLevelsCount);var l=0,h=0,d=0,f=0;this.nextPacket=function(){for(;l<=o;l++){for(;h<i;h++){for(;d<n;d++){var e=r.components[d];if(!(l>e.codingStyleParameters.decompositionLevelsCount)){for(var t=e.resolutions[l],a=t.precinctParameters.numprecincts;f<a;){var c=u(t,f,h);f++;return c}f=0}}d=0}h=0}throw new s("Out of packets")}}function g(e){var t,a,r,i,n=e.SIZ,o=e.currentTile.index,c=e.tiles[o],l=c.codingStyleDefaultParameters.layersCount,h=n.Csiz,d=0;for(r=0;r<h;r++){var f=c.components[r];d=Math.max(d,f.codingStyleParameters.decompositionLevelsCount)}var g=new Int32Array(d+1);for(a=0;a<=d;++a){var m=0;for(r=0;r<h;++r){var p=c.components[r].resolutions;a<p.length&&(m=Math.max(m,p[a].precinctParameters.numprecincts))}g[a]=m}t=0;a=0;r=0;i=0;this.nextPacket=function(){for(;a<=d;a++){for(;i<g[a];i++){for(;r<h;r++){var e=c.components[r];if(!(a>e.codingStyleParameters.decompositionLevelsCount)){var n=e.resolutions[a],o=n.precinctParameters.numprecincts;if(!(i>=o)){for(;t<l;){var f=u(n,i,t);t++;return f}t=0}}}r=0}i=0}throw new s("Out of packets")}}function m(e){var t=e.SIZ,a=e.currentTile.index,r=e.tiles[a],i=r.codingStyleDefaultParameters.layersCount,n=t.Csiz,o=y(r),c=o,l=0,h=0,d=0,f=0,g=0;this.nextPacket=function(){for(;g<c.maxNumHigh;g++){for(;f<c.maxNumWide;f++){for(;d<n;d++){for(var e=r.components[d],t=e.codingStyleParameters.decompositionLevelsCount;h<=t;h++){var a=e.resolutions[h],m=o.components[d].resolutions[h],p=b(f,g,m,c,a);if(null!==p){for(;l<i;){var y=u(a,p,l);l++;return y}l=0}}h=0}d=0}f=0}throw new s("Out of packets")}}function p(e){var t=e.SIZ,a=e.currentTile.index,r=e.tiles[a],i=r.codingStyleDefaultParameters.layersCount,n=t.Csiz,o=y(r),c=0,l=0,h=0,d=0,f=0;this.nextPacket=function(){for(;h<n;++h){for(var e=r.components[h],t=o.components[h],a=e.codingStyleParameters.decompositionLevelsCount;f<t.maxNumHigh;f++){for(;d<t.maxNumWide;d++){for(;l<=a;l++){var g=e.resolutions[l],m=t.resolutions[l],p=b(d,f,m,t,g);if(null!==p){for(;c<i;){var y=u(g,p,c);c++;return y}c=0}}l=0}d=0}f=0}throw new s("Out of packets")}}function b(e,t,a,r,i){var n=e*r.minWidth,s=t*r.minHeight;if(n%a.width!=0||s%a.height!=0)return null;var o=s/a.width*i.precinctParameters.numprecinctswide;return n/a.height+o}function y(e){for(var t=e.components.length,a=Number.MAX_VALUE,r=Number.MAX_VALUE,i=0,n=0,s=new Array(t),o=0;o<t;o++){for(var c=e.components[o],l=c.codingStyleParameters.decompositionLevelsCount,h=new Array(l+1),u=Number.MAX_VALUE,d=Number.MAX_VALUE,f=0,g=0,m=1,p=l;p>=0;--p){var b=c.resolutions[p],y=m*b.precinctParameters.precinctWidth,v=m*b.precinctParameters.precinctHeight;u=Math.min(u,y);d=Math.min(d,v);f=Math.max(f,b.precinctParameters.numprecinctswide);g=Math.max(g,b.precinctParameters.numprecinctshigh);h[p]={width:y,height:v};m<<=1}a=Math.min(a,u);r=Math.min(r,d);i=Math.max(i,f);n=Math.max(n,g);s[o]={resolutions:h,minWidth:u,minHeight:d,maxNumWide:f,maxNumHigh:g}}return{components:s,minWidth:a,minHeight:r,maxNumWide:i,maxNumHigh:n}}function v(e){for(var t=e.SIZ,a=e.currentTile.index,r=e.tiles[a],i=t.Csiz,n=0;n<i;n++){for(var o=r.components[n],u=o.codingStyleParameters.decompositionLevelsCount,b=[],y=[],v=0;v<=u;v++){var w,k=c(0,o,v),S={},C=1<<u-v;S.trx0=Math.ceil(o.tcx0/C);S.try0=Math.ceil(o.tcy0/C);S.trx1=Math.ceil(o.tcx1/C);S.try1=Math.ceil(o.tcy1/C);S.resLevel=v;l(0,S,k);b.push(S);if(0===v){(w={}).type="LL";w.tbx0=Math.ceil(o.tcx0/C);w.tby0=Math.ceil(o.tcy0/C);w.tbx1=Math.ceil(o.tcx1/C);w.tby1=Math.ceil(o.tcy1/C);w.resolution=S;h(0,w,k);y.push(w);S.subbands=[w]}else{var x=1<<u-v+1,A=[];(w={}).type="HL";w.tbx0=Math.ceil(o.tcx0/x-.5);w.tby0=Math.ceil(o.tcy0/x);w.tbx1=Math.ceil(o.tcx1/x-.5);w.tby1=Math.ceil(o.tcy1/x);w.resolution=S;h(0,w,k);y.push(w);A.push(w);(w={}).type="LH";w.tbx0=Math.ceil(o.tcx0/x);w.tby0=Math.ceil(o.tcy0/x-.5);w.tbx1=Math.ceil(o.tcx1/x);w.tby1=Math.ceil(o.tcy1/x-.5);w.resolution=S;h(0,w,k);y.push(w);A.push(w);(w={}).type="HH";w.tbx0=Math.ceil(o.tcx0/x-.5);w.tby0=Math.ceil(o.tcy0/x-.5);w.tbx1=Math.ceil(o.tcx1/x-.5);w.tby1=Math.ceil(o.tcy1/x-.5);w.resolution=S;h(0,w,k);y.push(w);A.push(w);S.subbands=A}}o.resolutions=b;o.subbands=y}var I=r.codingStyleDefaultParameters.progressionOrder;switch(I){case 0:r.packetsIterator=new d(e);break;case 1:r.packetsIterator=new f(e);break;case 2:r.packetsIterator=new g(e);break;case 3:r.packetsIterator=new m(e);break;case 4:r.packetsIterator=new p(e);break;default:throw new s(`Unsupported progression order ${I}`)}}function w(e,t,a,r){var n,s=0,o=0,c=!1;function l(e){for(;o<e;){var r=t[a+s];s++;if(c){n=n<<7|r;o+=7;c=!1}else{n=n<<8|r;o+=8}255===r&&(c=!0)}return n>>>(o-=e)&(1<<e)-1}function h(e){if(255===t[a+s-1]&&t[a+s]===e){u(1);return!0}if(255===t[a+s]&&t[a+s+1]===e){u(2);return!0}return!1}function u(e){s+=e}function d(){o=0;if(c){s++;c=!1}}function f(){if(0===l(1))return 1;if(0===l(1))return 2;var e=l(2);return e<3?e+3:(e=l(5))<31?e+6:(e=l(7))+37}for(var g=e.currentTile.index,m=e.tiles[g],p=e.COD.sopMarkerUsed,b=e.COD.ephMarkerUsed,y=m.packetsIterator;s<r;){d();p&&h(145)&&u(4);var v=y.nextPacket();if(l(1)){for(var w,k=v.layerNumber,S=[],C=0,I=v.codeblocks.length;C<I;C++){var F=(w=v.codeblocks[C]).precinct,T=w.cbx-F.cbxMin,E=w.cby-F.cbyMin,O=!1,P=!1;if(void 0!==w.included)O=!!l(1);else{var B,D;if(void 0!==(F=w.precinct).inclusionTree)B=F.inclusionTree;else{var N=F.cbxMax-F.cbxMin+1,M=F.cbyMax-F.cbyMin+1;B=new A(N,M,k);D=new x(N,M);F.inclusionTree=B;F.zeroBitPlanesTree=D}if(B.reset(T,E,k))for(;;){if(!l(1)){B.incrementValue(k);break}if(!B.nextLevel()){w.included=!0;O=P=!0;break}}}if(O){if(P){(D=F.zeroBitPlanesTree).reset(T,E);for(;;)if(l(1)){if(!D.nextLevel())break}else D.incrementValue();w.zeroBitPlanes=D.value}for(var L=f();l(1);)w.Lblock++;var R=(0,i.log2)(L),U=l((L<1<<R?R-1:R)+w.Lblock);S.push({codeblock:w,codingpasses:L,dataLength:U})}}d();b&&h(146);for(;S.length>0;){var q=S.shift();void 0===(w=q.codeblock).data&&(w.data=[]);w.data.push({data:t,start:a+s,end:a+s+q.dataLength,codingpasses:q.codingpasses});s+=q.dataLength}}}return s}function k(e,t,a,r,i,s,o,c){for(var l=r.tbx0,h=r.tby0,u=r.tbx1-r.tbx0,d=r.codeblocks,f="H"===r.type.charAt(0)?1:0,g="H"===r.type.charAt(1)?t:0,m=0,p=d.length;m<p;++m){var b=d[m],y=b.tbx1_-b.tbx0_,v=b.tby1_-b.tby0_;if(0!==y&&0!==v&&void 0!==b.data){var w,k;w=new I(y,v,b.subbandType,b.zeroBitPlanes,s);k=2;var S,C,x,A=b.data,F=0,T=0;for(S=0,C=A.length;S<C;S++){F+=(x=A[S]).end-x.start;T+=x.codingpasses}var E=new Uint8Array(F),O=0;for(S=0,C=A.length;S<C;S++){var P=(x=A[S]).data.subarray(x.start,x.end);E.set(P,O);O+=P.length}var B=new n.ArithmeticDecoder(E,0,F);w.setDecoder(B);for(S=0;S<T;S++){switch(k){case 0:w.runSignificancePropagationPass();break;case 1:w.runMagnitudeRefinementPass();break;case 2:w.runCleanupPass();c&&w.checkSegmentationSymbol()}k=(k+1)%3}var D,N,M,L=b.tbx0_-l+(b.tby0_-h)*u,R=w.coefficentsSign,U=w.coefficentsMagnitude,q=w.bitsDecoded,j=o?0:.5;O=0;var _="LL"!==r.type;for(S=0;S<v;S++){var z=2*(L/u|0)*(t-u)+f+g;for(D=0;D<y;D++){if(0!==(N=U[O])){N=(N+j)*i;0!==R[O]&&(N=-N);M=q[O];var H=_?z+(L<<1):L;e[H]=o&&M>=s?N:N*(1<<s-M)}L++;O++}L+=u-y}}}}function S(t,a,r){for(var i=a.components[r],n=i.codingStyleParameters,s=i.quantizationParameters,o=n.decompositionLevelsCount,c=s.SPqcds,l=s.scalarExpounded,h=s.guardBits,u=n.segmentationSymbolUsed,d=t.components[r].precision,f=n.reversibleTransformation,g=f?new E:new T,m=[],p=0,b=0;b<=o;b++){for(var y=i.resolutions[b],v=y.trx1-y.trx0,w=y.try1-y.try0,S=new Float32Array(v*w),C=0,x=y.subbands.length;C<x;C++){var A,I;if(l){A=c[p].mu;I=c[p].epsilon;p++}else{A=c[0].mu;I=c[0].epsilon+(b>0?1-b:0)}var F=y.subbands[C],O=e[F.type];k(S,v,0,F,f?1:2**(d+O-I)*(1+A/2048),h+I-1,f,u)}m.push({width:v,height:w,items:S})}var P=g.calculate(m,i.tcx0,i.tcy0);return{left:i.tcx0,top:i.tcy0,width:P.width,height:P.height,items:P.items}}function C(e,t){for(var a=e.SIZ.Csiz,r=e.tiles[t],i=0;i<a;i++){var n=r.components[i],s=void 0!==e.currentTile.QCC[i]?e.currentTile.QCC[i]:e.currentTile.QCD;n.quantizationParameters=s;var o=void 0!==e.currentTile.COC[i]?e.currentTile.COC[i]:e.currentTile.COD;n.codingStyleParameters=o}r.codingStyleDefaultParameters=e.currentTile.COD}var x=function(){function e(e,t){var a=(0,i.log2)(Math.max(e,t))+1;this.levels=[];for(var r=0;r<a;r++){var n={width:e,height:t,items:[]};this.levels.push(n);e=Math.ceil(e/2);t=Math.ceil(t/2)}}e.prototype={reset:function(e,t){for(var a,r=0,i=0;r<this.levels.length;){var n=e+t*(a=this.levels[r]).width;if(void 0!==a.items[n]){i=a.items[n];break}a.index=n;e>>=1;t>>=1;r++}r--;(a=this.levels[r]).items[a.index]=i;this.currentLevel=r;delete this.value},incrementValue:function(){var e=this.levels[this.currentLevel];e.items[e.index]++},nextLevel:function(){var e=this.currentLevel,t=this.levels[e],a=t.items[t.index];if(--e<0){this.value=a;return!1}this.currentLevel=e;(t=this.levels[e]).items[t.index]=a;return!0}};return e}(),A=function(){function e(e,t,a){var r=(0,i.log2)(Math.max(e,t))+1;this.levels=[];for(var n=0;n<r;n++){for(var s=new Uint8Array(e*t),o=0,c=s.length;o<c;o++)s[o]=a;var l={width:e,height:t,items:s};this.levels.push(l);e=Math.ceil(e/2);t=Math.ceil(t/2)}}e.prototype={reset:function(e,t,a){for(var r=0;r<this.levels.length;){var i=this.levels[r],n=e+t*i.width;i.index=n;var s=i.items[n];if(255===s)break;if(s>a){this.currentLevel=r;this.propagateValues();return!1}e>>=1;t>>=1;r++}this.currentLevel=r-1;return!0},incrementValue:function(e){var t=this.levels[this.currentLevel];t.items[t.index]=e+1;this.propagateValues()},propagateValues:function(){for(var e=this.currentLevel,t=this.levels[e],a=t.items[t.index];--e>=0;)(t=this.levels[e]).items[t.index]=a},nextLevel:function(){var e=this.currentLevel,t=this.levels[e],a=t.items[t.index];t.items[t.index]=255;if(--e<0)return!1;this.currentLevel=e;(t=this.levels[e]).items[t.index]=a;return!0}};return e}(),I=function(){var e=new Uint8Array([0,5,8,0,3,7,8,0,4,7,8,0,0,0,0,0,1,6,8,0,3,7,8,0,4,7,8,0,0,0,0,0,2,6,8,0,3,7,8,0,4,7,8,0,0,0,0,0,2,6,8,0,3,7,8,0,4,7,8,0,0,0,0,0,2,6,8,0,3,7,8,0,4,7,8]),t=new Uint8Array([0,3,4,0,5,7,7,0,8,8,8,0,0,0,0,0,1,3,4,0,6,7,7,0,8,8,8,0,0,0,0,0,2,3,4,0,6,7,7,0,8,8,8,0,0,0,0,0,2,3,4,0,6,7,7,0,8,8,8,0,0,0,0,0,2,3,4,0,6,7,7,0,8,8,8]),a=new Uint8Array([0,1,2,0,1,2,2,0,2,2,2,0,0,0,0,0,3,4,5,0,4,5,5,0,5,5,5,0,0,0,0,0,6,7,7,0,7,7,7,0,7,7,7,0,0,0,0,0,8,8,8,0,8,8,8,0,8,8,8,0,0,0,0,0,8,8,8,0,8,8,8,0,8,8,8]);function r(r,i,n,s,o){this.width=r;this.height=i;let c;c="HH"===n?a:"HL"===n?t:e;this.contextLabelTable=c;var l=r*i;this.neighborsSignificance=new Uint8Array(l);this.coefficentsSign=new Uint8Array(l);let h;h=o>14?new Uint32Array(l):o>6?new Uint16Array(l):new Uint8Array(l);this.coefficentsMagnitude=h;this.processingFlags=new Uint8Array(l);var u=new Uint8Array(l);if(0!==s)for(var d=0;d<l;d++)u[d]=s;this.bitsDecoded=u;this.reset()}r.prototype={setDecoder:function(e){this.decoder=e},reset:function(){this.contexts=new Int8Array(19);this.contexts[0]=8;this.contexts[17]=92;this.contexts[18]=6},setNeighborsSignificance:function(e,t,a){var r,i=this.neighborsSignificance,n=this.width,s=this.height,o=t>0,c=t+1<n;if(e>0){r=a-n;o&&(i[r-1]+=16);c&&(i[r+1]+=16);i[r]+=4}if(e+1<s){r=a+n;o&&(i[r-1]+=16);c&&(i[r+1]+=16);i[r]+=4}o&&(i[a-1]+=1);c&&(i[a+1]+=1);i[a]|=128},runSignificancePropagationPass:function(){for(var e=this.decoder,t=this.width,a=this.height,r=this.coefficentsMagnitude,i=this.coefficentsSign,n=this.neighborsSignificance,s=this.processingFlags,o=this.contexts,c=this.contextLabelTable,l=this.bitsDecoded,h=0;h<a;h+=4)for(var u=0;u<t;u++)for(var d=h*t+u,f=0;f<4;f++,d+=t){var g=h+f;if(g>=a)break;s[d]&=-2;if(!r[d]&&n[d]){var m=c[n[d]];if(e.readBit(o,m)){var p=this.decodeSignBit(g,u,d);i[d]=p;r[d]=1;this.setNeighborsSignificance(g,u,d);s[d]|=2}l[d]++;s[d]|=1}}},decodeSignBit:function(e,t,a){var r,i,n,s,o,c,l=this.width,h=this.height,u=this.coefficentsMagnitude,d=this.coefficentsSign;s=t>0&&0!==u[a-1];if(t+1<l&&0!==u[a+1]){n=d[a+1];r=s?1-n-(i=d[a-1]):1-n-n}else r=s?1-(i=d[a-1])-i:0;var f=3*r;s=e>0&&0!==u[a-l];if(e+1<h&&0!==u[a+l]){n=d[a+l];r=s?1-n-(i=d[a-l])+f:1-n-n+f}else r=s?1-(i=d[a-l])-i+f:f;if(r>=0){o=9+r;c=this.decoder.readBit(this.contexts,o)}else{o=9-r;c=1^this.decoder.readBit(this.contexts,o)}return c},runMagnitudeRefinementPass:function(){for(var e,t=this.decoder,a=this.width,r=this.height,i=this.coefficentsMagnitude,n=this.neighborsSignificance,s=this.contexts,o=this.bitsDecoded,c=this.processingFlags,l=a*r,h=4*a,u=0;u<l;u=e){e=Math.min(l,u+h);for(var d=0;d<a;d++)for(var f=u+d;f<e;f+=a)if(i[f]&&0==(1&c[f])){var g=16;if(0!=(2&c[f])){c[f]^=2;g=0===(127&n[f])?15:14}var m=t.readBit(s,g);i[f]=i[f]<<1|m;o[f]++;c[f]|=1}}},runCleanupPass:function(){for(var e,t=this.decoder,a=this.width,r=this.height,i=this.neighborsSignificance,n=this.coefficentsMagnitude,s=this.coefficentsSign,o=this.contexts,c=this.contextLabelTable,l=this.bitsDecoded,h=this.processingFlags,u=a,d=2*a,f=3*a,g=0;g<r;g=e){e=Math.min(g+4,r);for(var m=g*a,p=g+3<r,b=0;b<a;b++){var y,v=m+b,w=0,k=v,S=g;if(p&&0===h[v]&&0===h[v+u]&&0===h[v+d]&&0===h[v+f]&&0===i[v]&&0===i[v+u]&&0===i[v+d]&&0===i[v+f]){if(!t.readBit(o,18)){l[v]++;l[v+u]++;l[v+d]++;l[v+f]++;continue}if(0!==(w=t.readBit(o,17)<<1|t.readBit(o,17))){S=g+w;k+=w*a}y=this.decodeSignBit(S,b,k);s[k]=y;n[k]=1;this.setNeighborsSignificance(S,b,k);h[k]|=2;k=v;for(var C=g;C<=S;C++,k+=a)l[k]++;w++}for(S=g+w;S<e;S++,k+=a)if(!n[k]&&0==(1&h[k])){var x=c[i[k]];if(1===t.readBit(o,x)){y=this.decodeSignBit(S,b,k);s[k]=y;n[k]=1;this.setNeighborsSignificance(S,b,k);h[k]|=2}l[k]++}}}},checkSegmentationSymbol:function(){var e=this.decoder,t=this.contexts;if(10!==(e.readBit(t,17)<<3|e.readBit(t,17)<<2|e.readBit(t,17)<<1|e.readBit(t,17)))throw new s("Invalid segmentation symbol")}};return r}(),F=function(){function e(){}e.prototype.calculate=function(e,t,a){for(var r=e[0],i=1,n=e.length;i<n;i++)r=this.iterate(r,e[i],t,a);return r};e.prototype.extend=function(e,t,a){var r=t-1,i=t+1,n=t+a-2,s=t+a;e[r--]=e[i++];e[s++]=e[n--];e[r--]=e[i++];e[s++]=e[n--];e[r--]=e[i++];e[s++]=e[n--];e[r]=e[i];e[s]=e[n]};e.prototype.iterate=function(e,t,a,r){var i,n,s,o,c,l,h=e.width,u=e.height,d=e.items,f=t.width,g=t.height,m=t.items;for(s=0,i=0;i<u;i++){o=2*i*f;for(n=0;n<h;n++,s++,o+=2)m[o]=d[s]}d=e.items=null;var p=new Float32Array(f+8);if(1===f){if(0!=(1&a))for(l=0,s=0;l<g;l++,s+=f)m[s]*=.5}else for(l=0,s=0;l<g;l++,s+=f){p.set(m.subarray(s,s+f),4);this.extend(p,4,f);this.filter(p,4,f);m.set(p.subarray(4,4+f),s)}var b=16,y=[];for(i=0;i<b;i++)y.push(new Float32Array(g+8));var v,w=0;e=4+g;if(1===g){if(0!=(1&r))for(c=0;c<f;c++)m[c]*=.5}else for(c=0;c<f;c++){if(0===w){b=Math.min(f-c,b);for(s=c,o=4;o<e;s+=f,o++)for(v=0;v<b;v++)y[v][o]=m[s+v];w=b}var k=y[--w];this.extend(k,4,g);this.filter(k,4,g);if(0===w){s=c-b+1;for(o=4;o<e;s+=f,o++)for(v=0;v<b;v++)m[s+v]=y[v][o]}}return{width:f,height:g,items:m}};return e}(),T=function(){function e(){F.call(this)}e.prototype=Object.create(F.prototype);e.prototype.filter=function(e,t,a){var r,i,n,s,o=a>>1,c=-1.586134342059924,l=-.052980118572961,h=.882911075530934,u=.443506852043971,d=1.230174104914001;r=(t|=0)-3;for(i=o+4;i--;r+=2)e[r]*=.8128930661159609;n=u*e[(r=t-2)-1];for(i=o+3;i--;r+=2){s=u*e[r+1];e[r]=d*e[r]-n-s;if(!i--)break;n=u*e[(r+=2)+1];e[r]=d*e[r]-n-s}n=h*e[(r=t-1)-1];for(i=o+2;i--;r+=2){s=h*e[r+1];e[r]-=n+s;if(!i--)break;n=h*e[(r+=2)+1];e[r]-=n+s}n=l*e[(r=t)-1];for(i=o+1;i--;r+=2){s=l*e[r+1];e[r]-=n+s;if(!i--)break;n=l*e[(r+=2)+1];e[r]-=n+s}if(0!==o){n=c*e[(r=t+1)-1];for(i=o;i--;r+=2){s=c*e[r+1];e[r]-=n+s;if(!i--)break;n=c*e[(r+=2)+1];e[r]-=n+s}}};return e}(),E=function(){function e(){F.call(this)}e.prototype=Object.create(F.prototype);e.prototype.filter=function(e,t,a){var r,i,n=a>>1;for(r=t|=0,i=n+1;i--;r+=2)e[r]-=e[r-1]+e[r+1]+2>>2;for(r=t+1,i=n;i--;r+=2)e[r]+=e[r-1]+e[r+1]>>1};return e}();return t}();t.JpxImage=o},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.calculateSHA512=t.calculateSHA384=t.calculateSHA256=t.calculateMD5=t.PDF20=t.PDF17=t.CipherTransformFactory=t.ARCFourCipher=t.AES256Cipher=t.AES128Cipher=void 0;var r=a(2),i=a(4),n=a(11),s=function(){function e(e){this.a=0;this.b=0;var t,a,r=new Uint8Array(256),i=0,n=e.length;for(t=0;t<256;++t)r[t]=t;for(t=0;t<256;++t){i=i+(a=r[t])+e[t%n]&255;r[t]=r[i];r[i]=a}this.s=r}e.prototype={encryptBlock:function(e){var t,a,r,i=e.length,n=this.a,s=this.b,o=this.s,c=new Uint8Array(i);for(t=0;t<i;++t){r=o[s=s+(a=o[n=n+1&255])&255];o[n]=r;o[s]=a;c[t]=e[t]^o[a+r&255]}this.a=n;this.b=s;return c}};e.prototype.decryptBlock=e.prototype.encryptBlock;return e}();t.ARCFourCipher=s;var o,c,l=(o=new Uint8Array([7,12,17,22,7,12,17,22,7,12,17,22,7,12,17,22,5,9,14,20,5,9,14,20,5,9,14,20,5,9,14,20,4,11,16,23,4,11,16,23,4,11,16,23,4,11,16,23,6,10,15,21,6,10,15,21,6,10,15,21,6,10,15,21]),c=new Int32Array([-680876936,-389564586,606105819,-1044525330,-176418897,1200080426,-1473231341,-45705983,1770035416,-1958414417,-42063,-1990404162,1804603682,-40341101,-1502002290,1236535329,-165796510,-1069501632,643717713,-373897302,-701558691,38016083,-660478335,-405537848,568446438,-1019803690,-187363961,1163531501,-1444681467,-51403784,1735328473,-1926607734,-378558,-2022574463,1839030562,-35309556,-1530992060,1272893353,-155497632,-1094730640,681279174,-358537222,-722521979,76029189,-640364487,-421815835,530742520,-995338651,-198630844,1126891415,-1416354905,-57434055,1700485571,-1894986606,-1051523,-2054922799,1873313359,-30611744,-1560198380,1309151649,-145523070,-1120210379,718787259,-343485551]),function(e,t,a){var r,i,n,s=1732584193,l=-271733879,h=-1732584194,u=271733878,d=a+72&-64,f=new Uint8Array(d);for(r=0;r<a;++r)f[r]=e[t++];f[r++]=128;n=d-8;for(;r<n;)f[r++]=0;f[r++]=a<<3&255;f[r++]=a>>5&255;f[r++]=a>>13&255;f[r++]=a>>21&255;f[r++]=a>>>29&255;f[r++]=0;f[r++]=0;f[r++]=0;var g=new Int32Array(16);for(r=0;r<d;){for(i=0;i<16;++i,r+=4)g[i]=f[r]|f[r+1]<<8|f[r+2]<<16|f[r+3]<<24;var m,p,b=s,y=l,v=h,w=u;for(i=0;i<64;++i){if(i<16){m=y&v|~y&w;p=i}else if(i<32){m=w&y|~w&v;p=5*i+1&15}else if(i<48){m=y^v^w;p=3*i+5&15}else{m=v^(y|~w);p=7*i&15}var k=w,S=b+m+c[i]+g[p]|0,C=o[i];w=v;v=y;y=y+(S<<C|S>>>32-C)|0;b=k}s=s+b|0;l=l+y|0;h=h+v|0;u=u+w|0}return new Uint8Array([255&s,s>>8&255,s>>16&255,s>>>24&255,255&l,l>>8&255,l>>16&255,l>>>24&255,255&h,h>>8&255,h>>16&255,h>>>24&255,255&u,u>>8&255,u>>16&255,u>>>24&255])});t.calculateMD5=l;var h=function(){function e(e,t){this.high=0|e;this.low=0|t}e.prototype={and:function(e){this.high&=e.high;this.low&=e.low},xor:function(e){this.high^=e.high;this.low^=e.low},or:function(e){this.high|=e.high;this.low|=e.low},shiftRight:function(e){if(e>=32){this.low=this.high>>>e-32|0;this.high=0}else{this.low=this.low>>>e|this.high<<32-e;this.high=this.high>>>e|0}},shiftLeft:function(e){if(e>=32){this.high=this.low<<e-32;this.low=0}else{this.high=this.high<<e|this.low>>>32-e;this.low=this.low<<e}},rotateRight:function(e){var t,a;if(32&e){a=this.low;t=this.high}else{t=this.low;a=this.high}e&=31;this.low=t>>>e|a<<32-e;this.high=a>>>e|t<<32-e},not:function(){this.high=~this.high;this.low=~this.low},add:function(e){var t=(this.low>>>0)+(e.low>>>0),a=(this.high>>>0)+(e.high>>>0);t>4294967295&&(a+=1);this.low=0|t;this.high=0|a},copyTo:function(e,t){e[t]=this.high>>>24&255;e[t+1]=this.high>>16&255;e[t+2]=this.high>>8&255;e[t+3]=255&this.high;e[t+4]=this.low>>>24&255;e[t+5]=this.low>>16&255;e[t+6]=this.low>>8&255;e[t+7]=255&this.low},assign:function(e){this.high=e.high;this.low=e.low}};return e}(),u=function(){function e(e,t){return e>>>t|e<<32-t}function t(e,t,a){return e&t^~e&a}function a(e,t,a){return e&t^e&a^t&a}function r(t){return e(t,2)^e(t,13)^e(t,22)}function i(t){return e(t,6)^e(t,11)^e(t,25)}function n(t){return e(t,7)^e(t,18)^t>>>3}var s=[1116352408,1899447441,3049323471,3921009573,961987163,1508970993,2453635748,2870763221,3624381080,310598401,607225278,1426881987,1925078388,2162078206,2614888103,3248222580,3835390401,4022224774,264347078,604807628,770255983,1249150122,1555081692,1996064986,2554220882,2821834349,2952996808,3210313671,3336571891,3584528711,113926993,338241895,666307205,773529912,1294757372,1396182291,1695183700,1986661051,2177026350,2456956037,2730485921,2820302411,3259730800,3345764771,3516065817,3600352804,4094571909,275423344,430227734,506948616,659060556,883997877,958139571,1322822218,1537002063,1747873779,1955562222,2024104815,2227730452,2361852424,2428436474,2756734187,3204031479,3329325298];return function(o,c,l){var h,u,d,f=1779033703,g=3144134277,m=1013904242,p=2773480762,b=1359893119,y=2600822924,v=528734635,w=1541459225,k=64*Math.ceil((l+9)/64),S=new Uint8Array(k);for(h=0;h<l;++h)S[h]=o[c++];S[h++]=128;d=k-8;for(;h<d;)S[h++]=0;S[h++]=0;S[h++]=0;S[h++]=0;S[h++]=l>>>29&255;S[h++]=l>>21&255;S[h++]=l>>13&255;S[h++]=l>>5&255;S[h++]=l<<3&255;var C,x=new Uint32Array(64);for(h=0;h<k;){for(u=0;u<16;++u){x[u]=S[h]<<24|S[h+1]<<16|S[h+2]<<8|S[h+3];h+=4}for(u=16;u<64;++u)x[u]=(e(C=x[u-2],17)^e(C,19)^C>>>10)+x[u-7]+n(x[u-15])+x[u-16]|0;var A,I,F=f,T=g,E=m,O=p,P=b,B=y,D=v,N=w;for(u=0;u<64;++u){A=N+i(P)+t(P,B,D)+s[u]+x[u];I=r(F)+a(F,T,E);N=D;D=B;B=P;P=O+A|0;O=E;E=T;T=F;F=A+I|0}f=f+F|0;g=g+T|0;m=m+E|0;p=p+O|0;b=b+P|0;y=y+B|0;v=v+D|0;w=w+N|0}return new Uint8Array([f>>24&255,f>>16&255,f>>8&255,255&f,g>>24&255,g>>16&255,g>>8&255,255&g,m>>24&255,m>>16&255,m>>8&255,255&m,p>>24&255,p>>16&255,p>>8&255,255&p,b>>24&255,b>>16&255,b>>8&255,255&b,y>>24&255,y>>16&255,y>>8&255,255&y,v>>24&255,v>>16&255,v>>8&255,255&v,w>>24&255,w>>16&255,w>>8&255,255&w])}}();t.calculateSHA256=u;var d=function(){function e(e,t,a,r,i){e.assign(t);e.and(a);i.assign(t);i.not();i.and(r);e.xor(i)}function t(e,t,a,r,i){e.assign(t);e.and(a);i.assign(t);i.and(r);e.xor(i);i.assign(a);i.and(r);e.xor(i)}function a(e,t,a){e.assign(t);e.rotateRight(28);a.assign(t);a.rotateRight(34);e.xor(a);a.assign(t);a.rotateRight(39);e.xor(a)}function r(e,t,a){e.assign(t);e.rotateRight(14);a.assign(t);a.rotateRight(18);e.xor(a);a.assign(t);a.rotateRight(41);e.xor(a)}function i(e,t,a){e.assign(t);e.rotateRight(1);a.assign(t);a.rotateRight(8);e.xor(a);a.assign(t);a.shiftRight(7);e.xor(a)}function n(e,t,a){e.assign(t);e.rotateRight(19);a.assign(t);a.rotateRight(61);e.xor(a);a.assign(t);a.shiftRight(6);e.xor(a)}var s=[new h(1116352408,3609767458),new h(1899447441,602891725),new h(3049323471,3964484399),new h(3921009573,2173295548),new h(961987163,4081628472),new h(1508970993,3053834265),new h(2453635748,2937671579),new h(2870763221,3664609560),new h(3624381080,2734883394),new h(310598401,1164996542),new h(607225278,1323610764),new h(1426881987,3590304994),new h(1925078388,4068182383),new h(2162078206,991336113),new h(2614888103,633803317),new h(3248222580,3479774868),new h(3835390401,2666613458),new h(4022224774,944711139),new h(264347078,2341262773),new h(604807628,2007800933),new h(770255983,1495990901),new h(1249150122,1856431235),new h(1555081692,3175218132),new h(1996064986,2198950837),new h(2554220882,3999719339),new h(2821834349,766784016),new h(2952996808,2566594879),new h(3210313671,3203337956),new h(3336571891,1034457026),new h(3584528711,2466948901),new h(113926993,3758326383),new h(338241895,168717936),new h(666307205,1188179964),new h(773529912,1546045734),new h(1294757372,1522805485),new h(1396182291,2643833823),new h(1695183700,2343527390),new h(1986661051,1014477480),new h(2177026350,1206759142),new h(2456956037,344077627),new h(2730485921,1290863460),new h(2820302411,3158454273),new h(3259730800,3505952657),new h(3345764771,106217008),new h(3516065817,3606008344),new h(3600352804,1432725776),new h(4094571909,1467031594),new h(275423344,851169720),new h(430227734,3100823752),new h(506948616,1363258195),new h(659060556,3750685593),new h(883997877,3785050280),new h(958139571,3318307427),new h(1322822218,3812723403),new h(1537002063,2003034995),new h(1747873779,3602036899),new h(1955562222,1575990012),new h(2024104815,1125592928),new h(2227730452,2716904306),new h(2361852424,442776044),new h(2428436474,593698344),new h(2756734187,3733110249),new h(3204031479,2999351573),new h(3329325298,3815920427),new h(3391569614,3928383900),new h(3515267271,566280711),new h(3940187606,3454069534),new h(4118630271,4000239992),new h(116418474,1914138554),new h(174292421,2731055270),new h(289380356,3203993006),new h(460393269,320620315),new h(685471733,587496836),new h(852142971,1086792851),new h(1017036298,365543100),new h(1126000580,2618297676),new h(1288033470,3409855158),new h(1501505948,4234509866),new h(1607167915,987167468),new h(1816402316,1246189591)];return function(o,c,l,u){var d,f,g,m,p,b,y,v;if(u=!!u){d=new h(3418070365,3238371032);f=new h(1654270250,914150663);g=new h(2438529370,812702999);m=new h(355462360,4144912697);p=new h(1731405415,4290775857);b=new h(2394180231,1750603025);y=new h(3675008525,1694076839);v=new h(1203062813,3204075428)}else{d=new h(1779033703,4089235720);f=new h(3144134277,2227873595);g=new h(1013904242,4271175723);m=new h(2773480762,1595750129);p=new h(1359893119,2917565137);b=new h(2600822924,725511199);y=new h(528734635,4215389547);v=new h(1541459225,327033209)}var w,k,S,C=128*Math.ceil((l+17)/128),x=new Uint8Array(C);for(w=0;w<l;++w)x[w]=o[c++];x[w++]=128;S=C-16;for(;w<S;)x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=0;x[w++]=l>>>29&255;x[w++]=l>>21&255;x[w++]=l>>13&255;x[w++]=l>>5&255;x[w++]=l<<3&255;var A=new Array(80);for(w=0;w<80;w++)A[w]=new h(0,0);var I,F,T=new h(0,0),E=new h(0,0),O=new h(0,0),P=new h(0,0),B=new h(0,0),D=new h(0,0),N=new h(0,0),M=new h(0,0),L=new h(0,0),R=new h(0,0),U=new h(0,0),q=new h(0,0);for(w=0;w<C;){for(k=0;k<16;++k){A[k].high=x[w]<<24|x[w+1]<<16|x[w+2]<<8|x[w+3];A[k].low=x[w+4]<<24|x[w+5]<<16|x[w+6]<<8|x[w+7];w+=8}for(k=16;k<80;++k){n(I=A[k],A[k-2],q);I.add(A[k-7]);i(U,A[k-15],q);I.add(U);I.add(A[k-16])}T.assign(d);E.assign(f);O.assign(g);P.assign(m);B.assign(p);D.assign(b);N.assign(y);M.assign(v);for(k=0;k<80;++k){L.assign(M);r(U,B,q);L.add(U);e(U,B,D,N,q);L.add(U);L.add(s[k]);L.add(A[k]);a(R,T,q);t(U,T,E,O,q);R.add(U);I=M;M=N;N=D;D=B;P.add(L);B=P;P=O;O=E;E=T;I.assign(L);I.add(R);T=I}d.add(T);f.add(E);g.add(O);m.add(P);p.add(B);b.add(D);y.add(N);v.add(M)}if(u){F=new Uint8Array(48);d.copyTo(F,0);f.copyTo(F,8);g.copyTo(F,16);m.copyTo(F,24);p.copyTo(F,32);b.copyTo(F,40)}else{F=new Uint8Array(64);d.copyTo(F,0);f.copyTo(F,8);g.copyTo(F,16);m.copyTo(F,24);p.copyTo(F,32);b.copyTo(F,40);y.copyTo(F,48);v.copyTo(F,56)}return F}}();t.calculateSHA512=d;var f=function(e,t,a){return d(e,t,a,!0)};t.calculateSHA384=f;var g=function(){function e(){}e.prototype={decryptBlock:function(e){return e}};return e}();class m{constructor(){this.constructor===m&&(0,r.unreachable)("Cannot initialize AESBaseCipher.");this._s=new Uint8Array([99,124,119,123,242,107,111,197,48,1,103,43,254,215,171,118,202,130,201,125,250,89,71,240,173,212,162,175,156,164,114,192,183,253,147,38,54,63,247,204,52,165,229,241,113,216,49,21,4,199,35,195,24,150,5,154,7,18,128,226,235,39,178,117,9,131,44,26,27,110,90,160,82,59,214,179,41,227,47,132,83,209,0,237,32,252,177,91,106,203,190,57,74,76,88,207,208,239,170,251,67,77,51,133,69,249,2,127,80,60,159,168,81,163,64,143,146,157,56,245,188,182,218,33,16,255,243,210,205,12,19,236,95,151,68,23,196,167,126,61,100,93,25,115,96,129,79,220,34,42,144,136,70,238,184,20,222,94,11,219,224,50,58,10,73,6,36,92,194,211,172,98,145,149,228,121,231,200,55,109,141,213,78,169,108,86,244,234,101,122,174,8,186,120,37,46,28,166,180,198,232,221,116,31,75,189,139,138,112,62,181,102,72,3,246,14,97,53,87,185,134,193,29,158,225,248,152,17,105,217,142,148,155,30,135,233,206,85,40,223,140,161,137,13,191,230,66,104,65,153,45,15,176,84,187,22]);this._inv_s=new Uint8Array([82,9,106,213,48,54,165,56,191,64,163,158,129,243,215,251,124,227,57,130,155,47,255,135,52,142,67,68,196,222,233,203,84,123,148,50,166,194,35,61,238,76,149,11,66,250,195,78,8,46,161,102,40,217,36,178,118,91,162,73,109,139,209,37,114,248,246,100,134,104,152,22,212,164,92,204,93,101,182,146,108,112,72,80,253,237,185,218,94,21,70,87,167,141,157,132,144,216,171,0,140,188,211,10,247,228,88,5,184,179,69,6,208,44,30,143,202,63,15,2,193,175,189,3,1,19,138,107,58,145,17,65,79,103,220,234,151,242,207,206,240,180,230,115,150,172,116,34,231,173,53,133,226,249,55,232,28,117,223,110,71,241,26,113,29,41,197,137,111,183,98,14,170,24,190,27,252,86,62,75,198,210,121,32,154,219,192,254,120,205,90,244,31,221,168,51,136,7,199,49,177,18,16,89,39,128,236,95,96,81,127,169,25,181,74,13,45,229,122,159,147,201,156,239,160,224,59,77,174,42,245,176,200,235,187,60,131,83,153,97,23,43,4,126,186,119,214,38,225,105,20,99,85,33,12,125]);this._mix=new Uint32Array([0,235474187,470948374,303765277,941896748,908933415,607530554,708780849,1883793496,2118214995,1817866830,1649639237,1215061108,1181045119,1417561698,1517767529,3767586992,4003061179,4236429990,4069246893,3635733660,3602770327,3299278474,3400528769,2430122216,2664543715,2362090238,2193862645,2835123396,2801107407,3035535058,3135740889,3678124923,3576870512,3341394285,3374361702,3810496343,3977675356,4279080257,4043610186,2876494627,2776292904,3076639029,3110650942,2472011535,2640243204,2403728665,2169303058,1001089995,899835584,666464733,699432150,59727847,226906860,530400753,294930682,1273168787,1172967064,1475418501,1509430414,1942435775,2110667444,1876241833,1641816226,2910219766,2743034109,2976151520,3211623147,2505202138,2606453969,2302690252,2269728455,3711829422,3543599269,3240894392,3475313331,3843699074,3943906441,4178062228,4144047775,1306967366,1139781709,1374988112,1610459739,1975683434,2076935265,1775276924,1742315127,1034867998,866637845,566021896,800440835,92987698,193195065,429456164,395441711,1984812685,2017778566,1784663195,1683407248,1315562145,1080094634,1383856311,1551037884,101039829,135050206,437757123,337553864,1042385657,807962610,573804783,742039012,2531067453,2564033334,2328828971,2227573024,2935566865,2700099354,3001755655,3168937228,3868552805,3902563182,4203181171,4102977912,3736164937,3501741890,3265478751,3433712980,1106041591,1340463100,1576976609,1408749034,2043211483,2009195472,1708848333,1809054150,832877231,1068351396,766945465,599762354,159417987,126454664,361929877,463180190,2709260871,2943682380,3178106961,3009879386,2572697195,2538681184,2236228733,2336434550,3509871135,3745345300,3441850377,3274667266,3910161971,3877198648,4110568485,4211818798,2597806476,2497604743,2261089178,2295101073,2733856160,2902087851,3202437046,2968011453,3936291284,3835036895,4136440770,4169408201,3535486456,3702665459,3467192302,3231722213,2051518780,1951317047,1716890410,1750902305,1113818384,1282050075,1584504582,1350078989,168810852,67556463,371049330,404016761,841739592,1008918595,775550814,540080725,3969562369,3801332234,4035489047,4269907996,3569255213,3669462566,3366754619,3332740144,2631065433,2463879762,2160117071,2395588676,2767645557,2868897406,3102011747,3069049960,202008497,33778362,270040487,504459436,875451293,975658646,675039627,641025152,2084704233,1917518562,1615861247,1851332852,1147550661,1248802510,1484005843,1451044056,933301370,967311729,733156972,632953703,260388950,25965917,328671808,496906059,1206477858,1239443753,1543208500,1441952575,2144161806,1908694277,1675577880,1842759443,3610369226,3644379585,3408119516,3307916247,4011190502,3776767469,4077384432,4245618683,2809771154,2842737049,3144396420,3043140495,2673705150,2438237621,2203032232,2370213795]);this._mixCol=new Uint8Array(256);for(let e=0;e<256;e++)this._mixCol[e]=e<128?e<<1:e<<1^27;this.buffer=new Uint8Array(16);this.bufferPosition=0}_expandKey(e){(0,r.unreachable)("Cannot call `_expandKey` on the base class")}_decrypt(e,t){let a,r,i;const n=new Uint8Array(16);n.set(e);for(let e=0,a=this._keySize;e<16;++e,++a)n[e]^=t[a];for(let e=this._cyclesOfRepetition-1;e>=1;--e){a=n[13];n[13]=n[9];n[9]=n[5];n[5]=n[1];n[1]=a;a=n[14];r=n[10];n[14]=n[6];n[10]=n[2];n[6]=a;n[2]=r;a=n[15];r=n[11];i=n[7];n[15]=n[3];n[11]=a;n[7]=r;n[3]=i;for(let e=0;e<16;++e)n[e]=this._inv_s[n[e]];for(let a=0,r=16*e;a<16;++a,++r)n[a]^=t[r];for(let e=0;e<16;e+=4){const t=this._mix[n[e]],r=this._mix[n[e+1]],i=this._mix[n[e+2]],s=this._mix[n[e+3]];a=t^r>>>8^r<<24^i>>>16^i<<16^s>>>24^s<<8;n[e]=a>>>24&255;n[e+1]=a>>16&255;n[e+2]=a>>8&255;n[e+3]=255&a}}a=n[13];n[13]=n[9];n[9]=n[5];n[5]=n[1];n[1]=a;a=n[14];r=n[10];n[14]=n[6];n[10]=n[2];n[6]=a;n[2]=r;a=n[15];r=n[11];i=n[7];n[15]=n[3];n[11]=a;n[7]=r;n[3]=i;for(let e=0;e<16;++e){n[e]=this._inv_s[n[e]];n[e]^=t[e]}return n}_encrypt(e,t){const a=this._s;let r,i,n;const s=new Uint8Array(16);s.set(e);for(let e=0;e<16;++e)s[e]^=t[e];for(let e=1;e<this._cyclesOfRepetition;e++){for(let e=0;e<16;++e)s[e]=a[s[e]];n=s[1];s[1]=s[5];s[5]=s[9];s[9]=s[13];s[13]=n;n=s[2];i=s[6];s[2]=s[10];s[6]=s[14];s[10]=n;s[14]=i;n=s[3];i=s[7];r=s[11];s[3]=s[15];s[7]=n;s[11]=i;s[15]=r;for(let e=0;e<16;e+=4){const t=s[e+0],a=s[e+1],i=s[e+2],n=s[e+3];r=t^a^i^n;s[e+0]^=r^this._mixCol[t^a];s[e+1]^=r^this._mixCol[a^i];s[e+2]^=r^this._mixCol[i^n];s[e+3]^=r^this._mixCol[n^t]}for(let a=0,r=16*e;a<16;++a,++r)s[a]^=t[r]}for(let e=0;e<16;++e)s[e]=a[s[e]];n=s[1];s[1]=s[5];s[5]=s[9];s[9]=s[13];s[13]=n;n=s[2];i=s[6];s[2]=s[10];s[6]=s[14];s[10]=n;s[14]=i;n=s[3];i=s[7];r=s[11];s[3]=s[15];s[7]=n;s[11]=i;s[15]=r;for(let e=0,a=this._keySize;e<16;++e,++a)s[e]^=t[a];return s}_decryptBlock2(e,t){const a=e.length;let r=this.buffer,i=this.bufferPosition;const n=[];let s=this.iv;for(let t=0;t<a;++t){r[i]=e[t];++i;if(i<16)continue;const a=this._decrypt(r,this._key);for(let e=0;e<16;++e)a[e]^=s[e];s=r;n.push(a);r=new Uint8Array(16);i=0}this.buffer=r;this.bufferLength=i;this.iv=s;if(0===n.length)return new Uint8Array(0);let o=16*n.length;if(t){const e=n[n.length-1];let t=e[15];if(t<=16){for(let a=15,r=16-t;a>=r;--a)if(e[a]!==t){t=0;break}o-=t;n[n.length-1]=e.subarray(0,16-t)}}const c=new Uint8Array(o);for(let e=0,t=0,a=n.length;e<a;++e,t+=16)c.set(n[e],t);return c}decryptBlock(e,t,a=null){const r=e.length,i=this.buffer;let n=this.bufferPosition;if(a)this.iv=a;else{for(let t=0;n<16&&t<r;++t,++n)i[n]=e[t];if(n<16){this.bufferLength=n;return new Uint8Array(0)}this.iv=i;e=e.subarray(16)}this.buffer=new Uint8Array(16);this.bufferLength=0;this.decryptBlock=this._decryptBlock2;return this.decryptBlock(e,t)}encrypt(e,t){const a=e.length;let r=this.buffer,i=this.bufferPosition;const n=[];t||(t=new Uint8Array(16));for(let s=0;s<a;++s){r[i]=e[s];++i;if(i<16)continue;for(let e=0;e<16;++e)r[e]^=t[e];const a=this._encrypt(r,this._key);t=a;n.push(a);r=new Uint8Array(16);i=0}this.buffer=r;this.bufferLength=i;this.iv=t;if(0===n.length)return new Uint8Array(0);const s=16*n.length,o=new Uint8Array(s);for(let e=0,t=0,a=n.length;e<a;++e,t+=16)o.set(n[e],t);return o}}class p extends m{constructor(e){super();this._cyclesOfRepetition=10;this._keySize=160;this._rcon=new Uint8Array([141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141,1,2,4,8,16,32,64,128,27,54,108,216,171,77,154,47,94,188,99,198,151,53,106,212,179,125,250,239,197,145,57,114,228,211,189,97,194,159,37,74,148,51,102,204,131,29,58,116,232,203,141]);this._key=this._expandKey(e)}_expandKey(e){const t=this._s,a=this._rcon,r=new Uint8Array(176);r.set(e);for(let e=16,i=1;e<176;++i){let n=r[e-3],s=r[e-2],o=r[e-1],c=r[e-4];n=t[n];s=t[s];o=t[o];c=t[c];n^=a[i];for(let t=0;t<4;++t){r[e]=n^=r[e-16];e++;r[e]=s^=r[e-16];e++;r[e]=o^=r[e-16];e++;r[e]=c^=r[e-16];e++}}return r}}t.AES128Cipher=p;class b extends m{constructor(e){super();this._cyclesOfRepetition=14;this._keySize=224;this._key=this._expandKey(e)}_expandKey(e){const t=this._s,a=new Uint8Array(240);a.set(e);let r,i,n,s,o=1;for(let e=32,c=1;e<240;++c){if(e%32==16){r=t[r];i=t[i];n=t[n];s=t[s]}else if(e%32==0){r=a[e-3];i=a[e-2];n=a[e-1];s=a[e-4];r=t[r];i=t[i];n=t[n];s=t[s];r^=o;(o<<=1)>=256&&(o=255&(27^o))}for(let t=0;t<4;++t){a[e]=r^=a[e-32];e++;a[e]=i^=a[e-32];e++;a[e]=n^=a[e-32];e++;a[e]=s^=a[e-32];e++}}return a}}t.AES256Cipher=b;var y=function(){function e(e,t){if(e.length!==t.length)return!1;for(var a=0;a<e.length;a++)if(e[a]!==t[a])return!1;return!0}function t(){}t.prototype={checkOwnerPassword:function(t,a,r,i){var n=new Uint8Array(t.length+56);n.set(t,0);n.set(a,t.length);n.set(r,t.length+a.length);return e(u(n,0,n.length),i)},checkUserPassword:function(t,a,r){var i=new Uint8Array(t.length+8);i.set(t,0);i.set(a,t.length);return e(u(i,0,i.length),r)},getOwnerKey:function(e,t,a,r){var i=new Uint8Array(e.length+56);i.set(e,0);i.set(t,e.length);i.set(a,e.length+t.length);var n=u(i,0,i.length);return new b(n).decryptBlock(r,!1,new Uint8Array(16))},getUserKey:function(e,t,a){var r=new Uint8Array(e.length+8);r.set(e,0);r.set(t,e.length);var i=u(r,0,r.length);return new b(i).decryptBlock(a,!1,new Uint8Array(16))}};return t}();t.PDF17=y;var v=function(){function e(e,t){var a=new Uint8Array(e.length+t.length);a.set(e,0);a.set(t,e.length);return a}function t(t,a,r){for(var i=u(a,0,a.length).subarray(0,32),n=[0],s=0;s<64||n[n.length-1]>s-32;){var o=t.length+i.length+r.length,c=new Uint8Array(64*o),l=e(t,i);l=e(l,r);for(var h=0,g=0;h<64;h++,g+=o)c.set(l,g);n=new p(i.subarray(0,16)).encrypt(c,i.subarray(16,32));for(var m=0,b=0;b<16;b++){m*=1;m%=3;m+=(n[b]>>>0)%3;m%=3}0===m?i=u(n,0,n.length):1===m?i=f(n,0,n.length):2===m&&(i=d(n,0,n.length));s++}return i.subarray(0,32)}function a(){}function r(e,t){if(e.length!==t.length)return!1;for(var a=0;a<e.length;a++)if(e[a]!==t[a])return!1;return!0}a.prototype={hash:function(e,a,r){return t(e,a,r)},checkOwnerPassword:function(e,a,i,n){var s=new Uint8Array(e.length+56);s.set(e,0);s.set(a,e.length);s.set(i,e.length+a.length);return r(t(e,s,i),n)},checkUserPassword:function(e,a,i){var n=new Uint8Array(e.length+8);n.set(e,0);n.set(a,e.length);return r(t(e,n,[]),i)},getOwnerKey:function(e,a,r,i){var n=new Uint8Array(e.length+56);n.set(e,0);n.set(a,e.length);n.set(r,e.length+a.length);var s=t(e,n,r);return new b(s).decryptBlock(i,!1,new Uint8Array(16))},getUserKey:function(e,a,r){var i=new Uint8Array(e.length+8);i.set(e,0);i.set(a,e.length);var n=t(e,i,[]);return new b(n).decryptBlock(r,!1,new Uint8Array(16))}};return a}();t.PDF20=v;var w=function(){function e(e,t){this.StringCipherConstructor=e;this.StreamCipherConstructor=t}e.prototype={createStream:function(e,t){var a=new this.StreamCipherConstructor;return new n.DecryptStream(e,t,(function(e,t){return a.decryptBlock(e,t)}))},decryptString:function(e){var t=new this.StringCipherConstructor,a=(0,r.stringToBytes)(e);a=t.decryptBlock(a,!0);return(0,r.bytesToString)(a)}};return e}(),k=function(){var e=new Uint8Array([40,191,78,94,78,117,138,65,100,0,78,86,255,250,1,8,46,46,0,182,208,104,62,128,47,12,169,254,100,83,105,122]);function t(t,a,r,i,n,o,c,h){var u,d,f=40+r.length+t.length,g=new Uint8Array(f),m=0;if(a){d=Math.min(32,a.length);for(;m<d;++m)g[m]=a[m]}u=0;for(;m<32;)g[m++]=e[u++];for(u=0,d=r.length;u<d;++u)g[m++]=r[u];g[m++]=255&n;g[m++]=n>>8&255;g[m++]=n>>16&255;g[m++]=n>>>24&255;for(u=0,d=t.length;u<d;++u)g[m++]=t[u];if(o>=4&&!h){g[m++]=255;g[m++]=255;g[m++]=255;g[m++]=255}var p=l(g,0,m),b=c>>3;if(o>=3)for(u=0;u<50;++u)p=l(p,0,b);var y,v=p.subarray(0,b);if(o>=3){for(m=0;m<32;++m)g[m]=e[m];for(u=0,d=t.length;u<d;++u)g[m++]=t[u];y=new s(v).encryptBlock(l(g,0,m));d=v.length;var w,k=new Uint8Array(d);for(u=1;u<=19;++u){for(w=0;w<d;++w)k[w]=v[w]^u;y=new s(k).encryptBlock(y)}for(u=0,d=y.length;u<d;++u)if(i[u]!==y[u])return null}else for(u=0,d=(y=new s(v).encryptBlock(e)).length;u<d;++u)if(i[u]!==y[u])return null;return v}var a=i.Name.get("Identity");function n(n,o,c){var h=n.get("Filter");if(!(0,i.isName)(h,"Standard"))throw new r.FormatError("unknown encryption method");this.dict=n;var u=n.get("V");if(!Number.isInteger(u)||1!==u&&2!==u&&4!==u&&5!==u)throw new r.FormatError("unsupported encryption algorithm");this.algorithm=u;var d=n.get("Length");if(!d)if(u<=3)d=40;else{var f=n.get("CF"),g=n.get("StmF");if((0,i.isDict)(f)&&(0,i.isName)(g)){f.suppressEncryption=!0;var m=f.get(g.name);(d=m&&m.get("Length")||128)<40&&(d<<=3)}}if(!Number.isInteger(d)||d<40||d%8!=0)throw new r.FormatError("invalid key length");var p=(0,r.stringToBytes)(n.get("O")).subarray(0,32),b=(0,r.stringToBytes)(n.get("U")).subarray(0,32),w=n.get("P"),k=n.get("R"),S=(4===u||5===u)&&!1!==n.get("EncryptMetadata");this.encryptMetadata=S;var C,x,A=(0,r.stringToBytes)(o);if(c){if(6===k)try{c=(0,r.utf8StringToString)(c)}catch(e){(0,r.warn)("CipherTransformFactory: Unable to convert UTF8 encoded password.")}C=(0,r.stringToBytes)(c)}if(5!==u)x=t(A,C,p,b,w,k,d,S);else{var I=(0,r.stringToBytes)(n.get("O")).subarray(32,40),F=(0,r.stringToBytes)(n.get("O")).subarray(40,48),T=(0,r.stringToBytes)(n.get("U")).subarray(0,48),E=(0,r.stringToBytes)(n.get("U")).subarray(32,40),O=(0,r.stringToBytes)(n.get("U")).subarray(40,48),P=(0,r.stringToBytes)(n.get("OE")),B=(0,r.stringToBytes)(n.get("UE"));(0,r.stringToBytes)(n.get("Perms"));x=function(e,t,a,r,i,n,s,o,c,l,h,u){if(t){var d=Math.min(127,t.length);t=t.subarray(0,d)}else t=[];var f;return(f=6===e?new v:new y).checkUserPassword(t,o,s)?f.getUserKey(t,c,h):t.length&&f.checkOwnerPassword(t,r,n,a)?f.getOwnerKey(t,i,n,l):null}(k,C,p,I,F,T,b,E,O,P,B)}if(!x&&!c)throw new r.PasswordException("No password given",r.PasswordResponses.NEED_PASSWORD);if(!x&&c){x=t(A,function(t,a,r,i){var n,o,c=new Uint8Array(32),h=0;o=Math.min(32,t.length);for(;h<o;++h)c[h]=t[h];n=0;for(;h<32;)c[h++]=e[n++];var u,d=l(c,0,h),f=i>>3;if(r>=3)for(n=0;n<50;++n)d=l(d,0,d.length);if(r>=3){u=a;var g,m=new Uint8Array(f);for(n=19;n>=0;n--){for(g=0;g<f;++g)m[g]=d[g]^n;u=new s(m).encryptBlock(u)}}else u=new s(d.subarray(0,f)).encryptBlock(a);return u}(C,p,k,d),p,b,w,k,d,S)}if(!x)throw new r.PasswordException("Incorrect Password",r.PasswordResponses.INCORRECT_PASSWORD);this.encryptionKey=x;if(u>=4){var D=n.get("CF");(0,i.isDict)(D)&&(D.suppressEncryption=!0);this.cf=D;this.stmf=n.get("StmF")||a;this.strf=n.get("StrF")||a;this.eff=n.get("EFF")||this.stmf}}function o(e,t,a,r){var i,n,s=new Uint8Array(a.length+9);for(i=0,n=a.length;i<n;++i)s[i]=a[i];s[i++]=255&e;s[i++]=e>>8&255;s[i++]=e>>16&255;s[i++]=255&t;s[i++]=t>>8&255;if(r){s[i++]=115;s[i++]=65;s[i++]=108;s[i++]=84}return l(s,0,i).subarray(0,Math.min(a.length+5,16))}function c(e,t,a,n,c){if(!(0,i.isName)(t))throw new r.FormatError("Invalid crypt filter name.");var l,h=e.get(t.name);null!=h&&(l=h.get("CFM"));if(!l||"None"===l.name)return function(){return new g};if("V2"===l.name)return function(){return new s(o(a,n,c,!1))};if("AESV2"===l.name)return function(){return new p(o(a,n,c,!0))};if("AESV3"===l.name)return function(){return new b(c)};throw new r.FormatError("Unknown crypto method")}n.prototype={createCipherTransform:function(e,t){if(4===this.algorithm||5===this.algorithm)return new w(c(this.cf,this.stmf,e,t,this.encryptionKey),c(this.cf,this.strf,e,t,this.encryptionKey));var a=o(e,t,this.encryptionKey,!1),r=function(){return new s(a)};return new w(r,r)}};return n}();t.CipherTransformFactory=k},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.ColorSpace=void 0;var r=a(2),i=a(4);class n{constructor(e,t){this.constructor===n&&(0,r.unreachable)("Cannot initialize ColorSpace.");this.name=e;this.numComps=t}getRgb(e,t){const a=new Uint8ClampedArray(3);this.getRgbItem(e,t,a,0);return a}getRgbItem(e,t,a,i){(0,r.unreachable)("Should not call ColorSpace.getRgbItem")}getRgbBuffer(e,t,a,i,n,s,o){(0,r.unreachable)("Should not call ColorSpace.getRgbBuffer")}getOutputLength(e,t){(0,r.unreachable)("Should not call ColorSpace.getOutputLength")}isPassthrough(e){return!1}isDefaultDecode(e,t){return n.isDefaultDecode(e,this.numComps)}fillRgb(e,t,a,r,i,n,s,o,c){const l=t*a;let h=null;const u=1<<s,d=a!==i||t!==r;if(this.isPassthrough(s))h=o;else if(1===this.numComps&&l>u&&"DeviceGray"!==this.name&&"DeviceRGB"!==this.name){const t=s<=8?new Uint8Array(u):new Uint16Array(u);for(let e=0;e<u;e++)t[e]=e;const a=new Uint8ClampedArray(3*u);this.getRgbBuffer(t,0,u,a,0,s,0);if(d){h=new Uint8Array(3*l);let e=0;for(let t=0;t<l;++t){const r=3*o[t];h[e++]=a[r];h[e++]=a[r+1];h[e++]=a[r+2]}}else{let t=0;for(let r=0;r<l;++r){const i=3*o[r];e[t++]=a[i];e[t++]=a[i+1];e[t++]=a[i+2];t+=c}}}else if(d){h=new Uint8ClampedArray(3*l);this.getRgbBuffer(o,0,l,h,0,s,0)}else this.getRgbBuffer(o,0,r*n,e,0,s,c);if(h)if(d)!function(e,t,a,r,i,n,s){s=1!==s?0:s;const o=a/i,c=r/n;let l,h=0;const u=new Uint16Array(i),d=3*a;for(let e=0;e<i;e++)u[e]=3*Math.floor(e*o);for(let a=0;a<n;a++){const r=Math.floor(a*c)*d;for(let a=0;a<i;a++){l=r+u[a];t[h++]=e[l++];t[h++]=e[l++];t[h++]=e[l++];h+=s}}}(h,e,t,a,r,i,c);else{let t=0,a=0;for(let i=0,s=r*n;i<s;i++){e[t++]=h[a++];e[t++]=h[a++];e[t++]=h[a++];t+=c}}}get usesZeroToOneRange(){return(0,r.shadow)(this,"usesZeroToOneRange",!0)}static parse(e,t,a,r){const i=this.parseToIR(e,t,a,r);return this.fromIR(i)}static fromIR(e){const t=Array.isArray(e)?e[0]:e;let a,i,n;switch(t){case"DeviceGrayCS":return this.singletons.gray;case"DeviceRgbCS":return this.singletons.rgb;case"DeviceCmykCS":return this.singletons.cmyk;case"CalGrayCS":a=e[1];i=e[2];n=e[3];return new d(a,i,n);case"CalRGBCS":a=e[1];i=e[2];n=e[3];const l=e[4];return new f(a,i,n,l);case"PatternCS":let h=e[1];h&&(h=this.fromIR(h));return new o(h);case"IndexedCS":const u=e[1],m=e[2],p=e[3];return new c(this.fromIR(u),m,p);case"AlternateCS":const b=e[1],y=e[2],v=e[3];return new s(b,this.fromIR(y),v);case"LabCS":a=e[1];i=e[2];const w=e[3];return new g(a,i,w);default:throw new r.FormatError(`Unknown colorspace name: ${t}`)}}static parseToIR(e,t,a=null,n){e=t.fetchIfRef(e);if((0,i.isName)(e))switch(e.name){case"DeviceGray":case"G":return"DeviceGrayCS";case"DeviceRGB":case"RGB":return"DeviceRgbCS";case"DeviceCMYK":case"CMYK":return"DeviceCmykCS";case"Pattern":return["PatternCS",null];default:if((0,i.isDict)(a)){const r=a.get("ColorSpace");if((0,i.isDict)(r)){const s=r.get(e.name);if(s){if((0,i.isName)(s))return this.parseToIR(s,t,a,n);e=s;break}}}throw new r.FormatError(`unrecognized colorspace ${e.name}`)}if(Array.isArray(e)){const s=t.fetchIfRef(e[0]).name;let o,c,l,h,u,d;switch(s){case"DeviceGray":case"G":return"DeviceGrayCS";case"DeviceRGB":case"RGB":return"DeviceRgbCS";case"DeviceCMYK":case"CMYK":return"DeviceCmykCS";case"CalGray":c=t.fetchIfRef(e[1]);h=c.getArray("WhitePoint");u=c.getArray("BlackPoint");d=c.get("Gamma");return["CalGrayCS",h,u,d];case"CalRGB":c=t.fetchIfRef(e[1]);h=c.getArray("WhitePoint");u=c.getArray("BlackPoint");d=c.getArray("Gamma");return["CalRGBCS",h,u,d,c.getArray("Matrix")];case"ICCBased":const f=t.fetchIfRef(e[1]).dict;o=f.get("N");l=f.get("Alternate");if(l){const e=this.parseToIR(l,t,a,n);if(this.fromIR(e,n).numComps===o)return e;(0,r.warn)("ICCBased color space: Ignoring incorrect /Alternate entry.")}if(1===o)return"DeviceGrayCS";if(3===o)return"DeviceRgbCS";if(4===o)return"DeviceCmykCS";break;case"Pattern":let g=e[1]||null;g&&(g=this.parseToIR(g,t,a,n));return["PatternCS",g];case"Indexed":case"I":const m=this.parseToIR(e[1],t,a,n),p=t.fetchIfRef(e[2])+1;let b=t.fetchIfRef(e[3]);(0,i.isStream)(b)&&(b=b.getBytes());return["IndexedCS",m,p,b];case"Separation":case"DeviceN":const y=t.fetchIfRef(e[1]);o=Array.isArray(y)?y.length:1;l=this.parseToIR(e[2],t,a,n);return["AlternateCS",o,l,n.create(t.fetchIfRef(e[3]))];case"Lab":c=t.fetchIfRef(e[1]);h=c.getArray("WhitePoint");u=c.getArray("BlackPoint");return["LabCS",h,u,c.getArray("Range")];default:throw new r.FormatError(`unimplemented color space object "${s}"`)}}throw new r.FormatError(`unrecognized color space object: "${e}"`)}static isDefaultDecode(e,t){if(!Array.isArray(e))return!0;if(2*t!==e.length){(0,r.warn)("The decode map is not the correct length");return!0}for(let t=0,a=e.length;t<a;t+=2)if(0!==e[t]||1!==e[t+1])return!1;return!0}static get singletons(){return(0,r.shadow)(this,"singletons",{get gray(){return(0,r.shadow)(this,"gray",new l)},get rgb(){return(0,r.shadow)(this,"rgb",new h)},get cmyk(){return(0,r.shadow)(this,"cmyk",new u)}})}}t.ColorSpace=n;class s extends n{constructor(e,t,a){super("Alternate",e);this.base=t;this.tintFn=a;this.tmpBuf=new Float32Array(t.numComps)}getRgbItem(e,t,a,r){const i=this.tmpBuf;this.tintFn(e,t,i,0);this.base.getRgbItem(i,0,a,r)}getRgbBuffer(e,t,a,r,i,n,s){const o=this.tintFn,c=this.base,l=1/((1<<n)-1),h=c.numComps,u=c.usesZeroToOneRange,d=(c.isPassthrough(8)||!u)&&0===s;let f=d?i:0;const g=d?r:new Uint8ClampedArray(h*a),m=this.numComps,p=new Float32Array(m),b=new Float32Array(h);let y,v;for(y=0;y<a;y++){for(v=0;v<m;v++)p[v]=e[t++]*l;o(p,0,b,0);if(u)for(v=0;v<h;v++)g[f++]=255*b[v];else{c.getRgbItem(b,0,g,f);f+=h}}d||c.getRgbBuffer(g,0,a,r,i,8,s)}getOutputLength(e,t){return this.base.getOutputLength(e*this.base.numComps/this.numComps,t)}}class o extends n{constructor(e){super("Pattern",null);this.base=e}isDefaultDecode(e,t){(0,r.unreachable)("Should not call PatternCS.isDefaultDecode")}}class c extends n{constructor(e,t,a){super("Indexed",1);this.base=e;this.highVal=t;const n=e.numComps*t;if((0,i.isStream)(a)){this.lookup=new Uint8Array(n);const e=a.getBytes(n);this.lookup.set(e)}else if((0,r.isString)(a)){this.lookup=new Uint8Array(n);for(let e=0;e<n;++e)this.lookup[e]=a.charCodeAt(e)}else{if(!(a instanceof Uint8Array))throw new r.FormatError(`Unrecognized lookup table: ${a}`);this.lookup=a}}getRgbItem(e,t,a,r){const i=this.base.numComps,n=e[t]*i;this.base.getRgbBuffer(this.lookup,n,1,a,r,8,0)}getRgbBuffer(e,t,a,r,i,n,s){const o=this.base,c=o.numComps,l=o.getOutputLength(c,s),h=this.lookup;for(let n=0;n<a;++n){const a=e[t++]*c;o.getRgbBuffer(h,a,1,r,i,8,s);i+=l}}getOutputLength(e,t){return this.base.getOutputLength(e*this.base.numComps,t)}isDefaultDecode(e,t){if(!Array.isArray(e))return!0;if(2!==e.length){(0,r.warn)("Decode map length is not correct");return!0}if(!Number.isInteger(t)||t<1){(0,r.warn)("Bits per component is not correct");return!0}return 0===e[0]&&e[1]===(1<<t)-1}}class l extends n{constructor(){super("DeviceGray",1)}getRgbItem(e,t,a,r){const i=255*e[t];a[r]=a[r+1]=a[r+2]=i}getRgbBuffer(e,t,a,r,i,n,s){const o=255/((1<<n)-1);let c=t,l=i;for(let t=0;t<a;++t){const t=o*e[c++];r[l++]=t;r[l++]=t;r[l++]=t;l+=s}}getOutputLength(e,t){return e*(3+t)}}class h extends n{constructor(){super("DeviceRGB",3)}getRgbItem(e,t,a,r){a[r]=255*e[t];a[r+1]=255*e[t+1];a[r+2]=255*e[t+2]}getRgbBuffer(e,t,a,r,i,n,s){if(8===n&&0===s){r.set(e.subarray(t,t+3*a),i);return}const o=255/((1<<n)-1);let c=t,l=i;for(let t=0;t<a;++t){r[l++]=o*e[c++];r[l++]=o*e[c++];r[l++]=o*e[c++];l+=s}}getOutputLength(e,t){return e*(3+t)/3|0}isPassthrough(e){return 8===e}}const u=function(){function e(e,t,a,r,i){const n=e[t]*a,s=e[t+1]*a,o=e[t+2]*a,c=e[t+3]*a;r[i]=255+n*(-4.387332384609988*n+54.48615194189176*s+18.82290502165302*o+212.25662451639585*c-285.2331026137004)+s*(1.7149763477362134*s-5.6096736904047315*o+-17.873870861415444*c-5.497006427196366)+o*(-2.5217340131683033*o-21.248923337353073*c+17.5119270841813)+c*(-21.86122147463605*c-189.48180835922747);r[i+1]=255+n*(8.841041422036149*n+60.118027045597366*s+6.871425592049007*o+31.159100130055922*c-79.2970844816548)+s*(-15.310361306967817*s+17.575251261109482*o+131.35250912493976*c-190.9453302588951)+o*(4.444339102852739*o+9.8632861493405*c-24.86741582555878)+c*(-20.737325471181034*c-187.80453709719578);r[i+2]=255+n*(.8842522430003296*n+8.078677503112928*s+30.89978309703729*o-.23883238689178934*c-14.183576799673286)+s*(10.49593273432072*s+63.02378494754052*o+50.606957656360734*c-112.23884253719248)+o*(.03296041114873217*o+115.60384449646641*c-193.58209356861505)+c*(-22.33816807309886*c-180.12613974708367)}return class extends n{constructor(){super("DeviceCMYK",4)}getRgbItem(t,a,r,i){e(t,a,1,r,i)}getRgbBuffer(t,a,r,i,n,s,o){const c=1/((1<<s)-1);for(let s=0;s<r;s++){e(t,a,c,i,n);a+=4;n+=3+o}}getOutputLength(e,t){return e/4*(3+t)|0}}}(),d=function(){function e(e,t,a,r,i,n){const s=(t[a]*n)**e.G,o=e.YW*s,c=Math.max(295.8*o**.3333333333333333-40.8,0);r[i]=c;r[i+1]=c;r[i+2]=c}return class extends n{constructor(e,t,a){super("CalGray",1);if(!e)throw new r.FormatError("WhitePoint missing - required for color space CalGray");t=t||[0,0,0];a=a||1;this.XW=e[0];this.YW=e[1];this.ZW=e[2];this.XB=t[0];this.YB=t[1];this.ZB=t[2];this.G=a;if(this.XW<0||this.ZW<0||1!==this.YW)throw new r.FormatError(`Invalid WhitePoint components for ${this.name}`+", no fallback available");if(this.XB<0||this.YB<0||this.ZB<0){(0,r.info)(`Invalid BlackPoint for ${this.name}, falling back to default.`);this.XB=this.YB=this.ZB=0}0===this.XB&&0===this.YB&&0===this.ZB||(0,r.warn)(`${this.name}, BlackPoint: XB: ${this.XB}, YB: ${this.YB}, `+`ZB: ${this.ZB}, only default values are supported.`);if(this.G<1){(0,r.info)(`Invalid Gamma: ${this.G} for ${this.name}, `+"falling back to default.");this.G=1}}getRgbItem(t,a,r,i){e(this,t,a,r,i,1)}getRgbBuffer(t,a,r,i,n,s,o){const c=1/((1<<s)-1);for(let s=0;s<r;++s){e(this,t,a,i,n,c);a+=1;n+=3+o}}getOutputLength(e,t){return e*(3+t)}}}(),f=function(){const e=new Float32Array([.8951,.2664,-.1614,-.7502,1.7135,.0367,.0389,-.0685,1.0296]),t=new Float32Array([.9869929,-.1470543,.1599627,.4323053,.5183603,.0492912,-.0085287,.0400428,.9684867]),a=new Float32Array([3.2404542,-1.5371385,-.4985314,-.969266,1.8760108,.041556,.0556434,-.2040259,1.0572252]),i=new Float32Array([1,1,1]),s=new Float32Array(3),o=new Float32Array(3),c=new Float32Array(3);function l(e,t,a){a[0]=e[0]*t[0]+e[1]*t[1]+e[2]*t[2];a[1]=e[3]*t[0]+e[4]*t[1]+e[5]*t[2];a[2]=e[6]*t[0]+e[7]*t[1]+e[8]*t[2]}function h(e){return u(0,1,e<=.0031308?12.92*e:1.055*e**(1/2.4)-.055)}function u(e,t,a){return Math.max(e,Math.min(t,a))}function d(e){return e<0?-d(-e):e>8?((e+16)/116)**3:e*((24/116)**3/8)}function f(r,n,f,g,m,p){const b=u(0,1,n[f]*p),y=u(0,1,n[f+1]*p),v=u(0,1,n[f+2]*p),w=b**r.GR,k=y**r.GG,S=v**r.GB,C=r.MXA*w+r.MXB*k+r.MXC*S,x=r.MYA*w+r.MYB*k+r.MYC*S,A=r.MZA*w+r.MZB*k+r.MZC*S,I=o;I[0]=C;I[1]=x;I[2]=A;const F=c;!function(a,r,i){if(1===a[0]&&1===a[2]){i[0]=r[0];i[1]=r[1];i[2]=r[2];return}const n=i;l(e,r,n);const o=s;!function(e,t,a){a[0]=1*t[0]/e[0];a[1]=1*t[1]/e[1];a[2]=1*t[2]/e[2]}(a,n,o);l(t,o,i)}(r.whitePoint,I,F);const T=o;!function(e,t,a){if(0===e[0]&&0===e[1]&&0===e[2]){a[0]=t[0];a[1]=t[1];a[2]=t[2];return}const r=d(0),i=(1-r)/(1-d(e[0])),n=1-i,s=(1-r)/(1-d(e[1])),o=1-s,c=(1-r)/(1-d(e[2])),l=1-c;a[0]=t[0]*i+n;a[1]=t[1]*s+o;a[2]=t[2]*c+l}(r.blackPoint,F,T);const E=c;!function(a,r,i){const n=i;l(e,r,n);const o=s;!function(e,t,a){a[0]=.95047*t[0]/e[0];a[1]=1*t[1]/e[1];a[2]=1.08883*t[2]/e[2]}(a,n,o);l(t,o,i)}(i,T,E);const O=o;l(a,E,O);g[m]=255*h(O[0]);g[m+1]=255*h(O[1]);g[m+2]=255*h(O[2])}return class extends n{constructor(e,t,a,i){super("CalRGB",3);if(!e)throw new r.FormatError("WhitePoint missing - required for color space CalRGB");t=t||new Float32Array(3);a=a||new Float32Array([1,1,1]);i=i||new Float32Array([1,0,0,0,1,0,0,0,1]);const n=e[0],s=e[1],o=e[2];this.whitePoint=e;const c=t[0],l=t[1],h=t[2];this.blackPoint=t;this.GR=a[0];this.GG=a[1];this.GB=a[2];this.MXA=i[0];this.MYA=i[1];this.MZA=i[2];this.MXB=i[3];this.MYB=i[4];this.MZB=i[5];this.MXC=i[6];this.MYC=i[7];this.MZC=i[8];if(n<0||o<0||1!==s)throw new r.FormatError(`Invalid WhitePoint components for ${this.name}`+", no fallback available");if(c<0||l<0||h<0){(0,r.info)(`Invalid BlackPoint for ${this.name} [${c}, ${l}, ${h}], `+"falling back to default.");this.blackPoint=new Float32Array(3)}if(this.GR<0||this.GG<0||this.GB<0){(0,r.info)(`Invalid Gamma [${this.GR}, ${this.GG}, ${this.GB}] for `+`${this.name}, falling back to default.`);this.GR=this.GG=this.GB=1}}getRgbItem(e,t,a,r){f(this,e,t,a,r,1)}getRgbBuffer(e,t,a,r,i,n,s){const o=1/((1<<n)-1);for(let n=0;n<a;++n){f(this,e,t,r,i,o);t+=3;i+=3+s}}getOutputLength(e,t){return e*(3+t)/3|0}}}(),g=function(){function e(e){let t;t=e>=6/29?e*e*e:108/841*(e-4/29);return t}function t(e,t,a,r){return a+e*(r-a)/t}function a(a,r,i,n,s,o){let c=r[i],l=r[i+1],h=r[i+2];if(!1!==n){c=t(c,n,0,100);l=t(l,n,a.amin,a.amax);h=t(h,n,a.bmin,a.bmax)}l>a.amax?l=a.amax:l<a.amin&&(l=a.amin);h>a.bmax?h=a.bmax:h<a.bmin&&(h=a.bmin);const u=(c+16)/116,d=u+l/500,f=u-h/200,g=a.XW*e(d),m=a.YW*e(u),p=a.ZW*e(f);let b,y,v;if(a.ZW<1){b=3.1339*g+-1.617*m+-.4906*p;y=-.9785*g+1.916*m+.0333*p;v=.072*g+-.229*m+1.4057*p}else{b=3.2406*g+-1.5372*m+-.4986*p;y=-.9689*g+1.8758*m+.0415*p;v=.0557*g+-.204*m+1.057*p}s[o]=255*Math.sqrt(b);s[o+1]=255*Math.sqrt(y);s[o+2]=255*Math.sqrt(v)}return class extends n{constructor(e,t,a){super("Lab",3);if(!e)throw new r.FormatError("WhitePoint missing - required for color space Lab");t=t||[0,0,0];a=a||[-100,100,-100,100];this.XW=e[0];this.YW=e[1];this.ZW=e[2];this.amin=a[0];this.amax=a[1];this.bmin=a[2];this.bmax=a[3];this.XB=t[0];this.YB=t[1];this.ZB=t[2];if(this.XW<0||this.ZW<0||1!==this.YW)throw new r.FormatError("Invalid WhitePoint components, no fallback available");if(this.XB<0||this.YB<0||this.ZB<0){(0,r.info)("Invalid BlackPoint, falling back to default");this.XB=this.YB=this.ZB=0}if(this.amin>this.amax||this.bmin>this.bmax){(0,r.info)("Invalid Range, falling back to defaults");this.amin=-100;this.amax=100;this.bmin=-100;this.bmax=100}}getRgbItem(e,t,r,i){a(this,e,t,!1,r,i)}getRgbBuffer(e,t,r,i,n,s,o){const c=(1<<s)-1;for(let s=0;s<r;s++){a(this,e,t,c,i,n);t+=3;n+=3+o}}getOutputLength(e,t){return e*(3+t)/3|0}isDefaultDecode(e,t){return!0}get usesZeroToOneRange(){return(0,r.shadow)(this,"usesZeroToOneRange",!1)}}}()},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.getQuadPoints=h;t.MarkupAnnotation=t.AnnotationFactory=t.AnnotationBorderStyle=t.Annotation=void 0;var r=a(2),i=a(9),n=a(4),s=a(22),o=a(7),c=a(24),l=a(11);t.AnnotationFactory=class{static create(e,t,a,r){return a.ensure(this,"_create",[e,t,a,r])}static _create(e,t,a,i){const s=e.fetchIfRef(t);if(!(0,n.isDict)(s))return;const c=(0,n.isRef)(t)?t.toString():`annot_${i.createObjId()}`;let l=s.get("Subtype");l=(0,n.isName)(l)?l.name:null;const h={xref:e,dict:s,subtype:l,id:c,pdfManager:a};switch(l){case"Link":return new v(h);case"Text":return new y(h);case"Widget":let e=(0,o.getInheritableProperty)({dict:s,key:"FT"});e=(0,n.isName)(e)?e.name:null;switch(e){case"Tx":return new m(h);case"Btn":return new p(h);case"Ch":return new b(h)}(0,r.warn)('Unimplemented widget field type "'+e+'", falling back to base field type.');return new g(h);case"Popup":return new w(h);case"FreeText":return new k(h);case"Line":return new S(h);case"Square":return new C(h);case"Circle":return new x(h);case"PolyLine":return new A(h);case"Polygon":return new I(h);case"Caret":return new F(h);case"Ink":return new T(h);case"Highlight":return new E(h);case"Underline":return new O(h);case"Squiggly":return new P(h);case"StrikeOut":return new B(h);case"Stamp":return new D(h);case"FileAttachment":return new N(h);default:l?(0,r.warn)('Unimplemented annotation type "'+l+'", falling back to base annotation.'):(0,r.warn)("Annotation is missing the required /Subtype.");return new u(h)}}};function h(e,t){if(!e.has("QuadPoints"))return null;const a=e.getArray("QuadPoints");if(!Array.isArray(a)||a.length%8>0)return null;const r=[];for(let e=0,i=a.length/8;e<i;e++){r.push([]);for(let i=8*e,n=8*e+8;i<n;i+=2){const n=a[i],s=a[i+1];if(n<t[0]||n>t[2]||s<t[1]||s>t[3])return null;r[e].push({x:n,y:s})}}return r}class u{constructor(e){const t=e.dict;this.setContents(t.get("Contents"));this.setModificationDate(t.get("M"));this.setFlags(t.get("F"));this.setRectangle(t.getArray("Rect"));this.setColor(t.getArray("C"));this.setBorderStyle(t);this.setAppearance(t);this.data={annotationFlags:this.flags,borderStyle:this.borderStyle,color:this.color,contents:this.contents,hasAppearance:!!this.appearance,id:e.id,modificationDate:this.modificationDate,rect:this.rectangle,subtype:e.subtype}}_hasFlag(e,t){return!!(e&t)}_isViewable(e){return!this._hasFlag(e,r.AnnotationFlag.INVISIBLE)&&!this._hasFlag(e,r.AnnotationFlag.HIDDEN)&&!this._hasFlag(e,r.AnnotationFlag.NOVIEW)}_isPrintable(e){return this._hasFlag(e,r.AnnotationFlag.PRINT)&&!this._hasFlag(e,r.AnnotationFlag.INVISIBLE)&&!this._hasFlag(e,r.AnnotationFlag.HIDDEN)}get viewable(){return 0===this.flags||this._isViewable(this.flags)}get printable(){return 0!==this.flags&&this._isPrintable(this.flags)}setContents(e){this.contents=(0,r.stringToPDFString)(e||"")}setModificationDate(e){this.modificationDate=(0,r.isString)(e)?e:null}setFlags(e){this.flags=Number.isInteger(e)&&e>0?e:0}hasFlag(e){return this._hasFlag(this.flags,e)}setRectangle(e){Array.isArray(e)&&4===e.length?this.rectangle=r.Util.normalizeRect(e):this.rectangle=[0,0,0,0]}setColor(e){const t=new Uint8ClampedArray(3);if(Array.isArray(e))switch(e.length){case 0:this.color=null;break;case 1:s.ColorSpace.singletons.gray.getRgbItem(e,0,t,0);this.color=t;break;case 3:s.ColorSpace.singletons.rgb.getRgbItem(e,0,t,0);this.color=t;break;case 4:s.ColorSpace.singletons.cmyk.getRgbItem(e,0,t,0);this.color=t;break;default:this.color=t}else this.color=t}setBorderStyle(e){this.borderStyle=new d;if((0,n.isDict)(e))if(e.has("BS")){const t=e.get("BS"),a=t.get("Type");if(!a||(0,n.isName)(a,"Border")){this.borderStyle.setWidth(t.get("W"),this.rectangle);this.borderStyle.setStyle(t.get("S"));this.borderStyle.setDashArray(t.getArray("D"))}}else if(e.has("Border")){const t=e.getArray("Border");if(Array.isArray(t)&&t.length>=3){this.borderStyle.setHorizontalCornerRadius(t[0]);this.borderStyle.setVerticalCornerRadius(t[1]);this.borderStyle.setWidth(t[2],this.rectangle);4===t.length&&this.borderStyle.setDashArray(t[3])}}else this.borderStyle.setWidth(0)}setAppearance(e){this.appearance=null;const t=e.get("AP");if(!(0,n.isDict)(t))return;const a=t.get("N");if((0,n.isStream)(a)){this.appearance=a;return}if(!(0,n.isDict)(a))return;const r=e.get("AS");(0,n.isName)(r)&&a.has(r.name)&&(this.appearance=a.get(r.name))}loadResources(e){return this.appearance.dict.getAsync("Resources").then(t=>{if(!t)return;return new i.ObjectLoader(t,e,t.xref).load().then((function(){return t}))})}getOperatorList(e,t,a){if(!this.appearance)return Promise.resolve(new c.OperatorList);const i=this.data,n=this.appearance.dict,s=this.loadResources(["ExtGState","ColorSpace","Pattern","Shading","XObject","Font"]),o=n.getArray("BBox")||[0,0,1,1],l=n.getArray("Matrix")||[1,0,0,1,0,0],h=function(e,t,a){const[i,n,s,o]=r.Util.getAxialAlignedBoundingBox(t,a);if(i===s||n===o)return[1,0,0,1,e[0],e[1]];const c=(e[2]-e[0])/(s-i),l=(e[3]-e[1])/(o-n);return[c,0,0,l,e[0]-i*c,e[1]-n*l]}(i.rect,o,l);return s.then(a=>{const n=new c.OperatorList;n.addOp(r.OPS.beginAnnotation,[i.rect,h,l]);return e.getOperatorList({stream:this.appearance,task:t,resources:a,operatorList:n}).then(()=>{n.addOp(r.OPS.endAnnotation,[]);this.appearance.reset();return n})})}}t.Annotation=u;class d{constructor(){this.width=1;this.style=r.AnnotationBorderStyleType.SOLID;this.dashArray=[3];this.horizontalCornerRadius=0;this.verticalCornerRadius=0}setWidth(e,t=[0,0,0,0]){if((0,n.isName)(e))this.width=0;else if(Number.isInteger(e)){if(e>0){const a=(t[2]-t[0])/2,i=(t[3]-t[1])/2;if(a>0&&i>0&&(e>a||e>i)){(0,r.warn)(`AnnotationBorderStyle.setWidth - ignoring width: ${e}`);e=1}}this.width=e}}setStyle(e){if((0,n.isName)(e))switch(e.name){case"S":this.style=r.AnnotationBorderStyleType.SOLID;break;case"D":this.style=r.AnnotationBorderStyleType.DASHED;break;case"B":this.style=r.AnnotationBorderStyleType.BEVELED;break;case"I":this.style=r.AnnotationBorderStyleType.INSET;break;case"U":this.style=r.AnnotationBorderStyleType.UNDERLINE}}setDashArray(e){if(Array.isArray(e)&&e.length>0){let t=!0,a=!0;for(const r of e){if(!(+r>=0)){t=!1;break}r>0&&(a=!1)}t&&!a?this.dashArray=e:this.width=0}else e&&(this.width=0)}setHorizontalCornerRadius(e){Number.isInteger(e)&&(this.horizontalCornerRadius=e)}setVerticalCornerRadius(e){Number.isInteger(e)&&(this.verticalCornerRadius=e)}}t.AnnotationBorderStyle=d;class f extends u{constructor(e){super(e);const t=e.dict;if(t.has("IRT")){const e=t.getRaw("IRT");this.data.inReplyTo=(0,n.isRef)(e)?e.toString():null;const a=t.get("RT");this.data.replyType=(0,n.isName)(a)?a.name:r.AnnotationReplyType.REPLY}if(this.data.replyType===r.AnnotationReplyType.GROUP){const e=t.get("IRT");this.data.title=(0,r.stringToPDFString)(e.get("T")||"");this.setContents(e.get("Contents"));this.data.contents=this.contents;if(e.has("CreationDate")){this.setCreationDate(e.get("CreationDate"));this.data.creationDate=this.creationDate}else this.data.creationDate=null;if(e.has("M")){this.setModificationDate(e.get("M"));this.data.modificationDate=this.modificationDate}else this.data.modificationDate=null;this.data.hasPopup=e.has("Popup");if(e.has("C")){this.setColor(e.getArray("C"));this.data.color=this.color}else this.data.color=null}else{this.data.title=(0,r.stringToPDFString)(t.get("T")||"");this.setCreationDate(t.get("CreationDate"));this.data.creationDate=this.creationDate;this.data.hasPopup=t.has("Popup");t.has("C")||(this.data.color=null)}}setCreationDate(e){this.creationDate=(0,r.isString)(e)?e:null}}t.MarkupAnnotation=f;class g extends u{constructor(e){super(e);const t=e.dict,a=this.data;a.annotationType=r.AnnotationType.WIDGET;a.fieldName=this._constructFieldName(t);a.fieldValue=(0,o.getInheritableProperty)({dict:t,key:"V",getArray:!0});a.alternativeText=(0,r.stringToPDFString)(t.get("TU")||"");a.defaultAppearance=(0,o.getInheritableProperty)({dict:t,key:"DA"})||"";const i=(0,o.getInheritableProperty)({dict:t,key:"FT"});a.fieldType=(0,n.isName)(i)?i.name:null;this.fieldResources=(0,o.getInheritableProperty)({dict:t,key:"DR"})||n.Dict.empty;a.fieldFlags=(0,o.getInheritableProperty)({dict:t,key:"Ff"});(!Number.isInteger(a.fieldFlags)||a.fieldFlags<0)&&(a.fieldFlags=0);a.readOnly=this.hasFieldFlag(r.AnnotationFieldFlag.READONLY);if("Sig"===a.fieldType){a.fieldValue=null;this.setFlags(r.AnnotationFlag.HIDDEN)}}_constructFieldName(e){if(!e.has("T")&&!e.has("Parent")){(0,r.warn)("Unknown field name, falling back to empty field name.");return""}if(!e.has("Parent"))return(0,r.stringToPDFString)(e.get("T"));const t=[];e.has("T")&&t.unshift((0,r.stringToPDFString)(e.get("T")));let a=e;for(;a.has("Parent");){a=a.get("Parent");if(!(0,n.isDict)(a))break;a.has("T")&&t.unshift((0,r.stringToPDFString)(a.get("T")))}return t.join(".")}hasFieldFlag(e){return!!(this.data.fieldFlags&e)}getOperatorList(e,t,a){return a?Promise.resolve(new c.OperatorList):super.getOperatorList(e,t,a)}}class m extends g{constructor(e){super(e);const t=e.dict;this.data.fieldValue=(0,r.stringToPDFString)(this.data.fieldValue||"");let a=(0,o.getInheritableProperty)({dict:t,key:"Q"});(!Number.isInteger(a)||a<0||a>2)&&(a=null);this.data.textAlignment=a;let i=(0,o.getInheritableProperty)({dict:t,key:"MaxLen"});(!Number.isInteger(i)||i<0)&&(i=null);this.data.maxLen=i;this.data.multiLine=this.hasFieldFlag(r.AnnotationFieldFlag.MULTILINE);this.data.comb=this.hasFieldFlag(r.AnnotationFieldFlag.COMB)&&!this.hasFieldFlag(r.AnnotationFieldFlag.MULTILINE)&&!this.hasFieldFlag(r.AnnotationFieldFlag.PASSWORD)&&!this.hasFieldFlag(r.AnnotationFieldFlag.FILESELECT)&&null!==this.data.maxLen}getOperatorList(e,t,a){if(a||this.appearance)return super.getOperatorList(e,t,a);const i=new c.OperatorList;if(!this.data.defaultAppearance)return Promise.resolve(i);const n=new l.Stream((0,r.stringToBytes)(this.data.defaultAppearance));return e.getOperatorList({stream:n,task:t,resources:this.fieldResources,operatorList:i}).then((function(){return i}))}}class p extends g{constructor(e){super(e);this.data.checkBox=!this.hasFieldFlag(r.AnnotationFieldFlag.RADIO)&&!this.hasFieldFlag(r.AnnotationFieldFlag.PUSHBUTTON);this.data.radioButton=this.hasFieldFlag(r.AnnotationFieldFlag.RADIO)&&!this.hasFieldFlag(r.AnnotationFieldFlag.PUSHBUTTON);this.data.pushButton=this.hasFieldFlag(r.AnnotationFieldFlag.PUSHBUTTON);this.data.checkBox?this._processCheckBox(e):this.data.radioButton?this._processRadioButton(e):this.data.pushButton?this._processPushButton(e):(0,r.warn)("Invalid field flags for button widget annotation")}_processCheckBox(e){(0,n.isName)(this.data.fieldValue)&&(this.data.fieldValue=this.data.fieldValue.name);const t=e.dict.get("AP");if(!(0,n.isDict)(t))return;const a=t.get("D");if(!(0,n.isDict)(a))return;const r=a.getKeys();2===r.length&&(this.data.exportValue="Off"===r[0]?r[1]:r[0])}_processRadioButton(e){this.data.fieldValue=this.data.buttonValue=null;const t=e.dict.get("Parent");if((0,n.isDict)(t)&&t.has("V")){const e=t.get("V");(0,n.isName)(e)&&(this.data.fieldValue=e.name)}const a=e.dict.get("AP");if(!(0,n.isDict)(a))return;const r=a.get("N");if((0,n.isDict)(r))for(const e of r.getKeys())if("Off"!==e){this.data.buttonValue=e;break}}_processPushButton(e){e.dict.has("A")?i.Catalog.parseDestDictionary({destDict:e.dict,resultObj:this.data,docBaseUrl:e.pdfManager.docBaseUrl}):(0,r.warn)("Push buttons without action dictionaries are not supported")}}class b extends g{constructor(e){super(e);this.data.options=[];const t=(0,o.getInheritableProperty)({dict:e.dict,key:"Opt"});if(Array.isArray(t)){const a=e.xref;for(let e=0,i=t.length;e<i;e++){const i=a.fetchIfRef(t[e]),n=Array.isArray(i);this.data.options[e]={exportValue:n?a.fetchIfRef(i[0]):i,displayValue:(0,r.stringToPDFString)(n?a.fetchIfRef(i[1]):i)}}}Array.isArray(this.data.fieldValue)||(this.data.fieldValue=[this.data.fieldValue]);this.data.combo=this.hasFieldFlag(r.AnnotationFieldFlag.COMBO);this.data.multiSelect=this.hasFieldFlag(r.AnnotationFieldFlag.MULTISELECT)}}class y extends f{constructor(e){super(e);const t=e.dict;this.data.annotationType=r.AnnotationType.TEXT;if(this.data.hasAppearance)this.data.name="NoIcon";else{this.data.rect[1]=this.data.rect[3]-22;this.data.rect[2]=this.data.rect[0]+22;this.data.name=t.has("Name")?t.get("Name").name:"Note"}if(t.has("State")){this.data.state=t.get("State")||null;this.data.stateModel=t.get("StateModel")||null}else{this.data.state=null;this.data.stateModel=null}}}class v extends u{constructor(e){super(e);this.data.annotationType=r.AnnotationType.LINK;const t=h(e.dict,this.rectangle);t&&(this.data.quadPoints=t);i.Catalog.parseDestDictionary({destDict:e.dict,resultObj:this.data,docBaseUrl:e.pdfManager.docBaseUrl})}}class w extends u{constructor(e){super(e);this.data.annotationType=r.AnnotationType.POPUP;let t=e.dict.get("Parent");if(!t){(0,r.warn)("Popup annotation has a missing or invalid parent annotation.");return}const a=t.get("Subtype");this.data.parentType=(0,n.isName)(a)?a.name:null;const i=e.dict.getRaw("Parent");this.data.parentId=(0,n.isRef)(i)?i.toString():null;const s=t.get("RT");(0,n.isName)(s,r.AnnotationReplyType.GROUP)&&(t=t.get("IRT"));if(t.has("M")){this.setModificationDate(t.get("M"));this.data.modificationDate=this.modificationDate}else this.data.modificationDate=null;if(t.has("C")){this.setColor(t.getArray("C"));this.data.color=this.color}else this.data.color=null;if(!this.viewable){const e=t.get("F");this._isViewable(e)&&this.setFlags(e)}this.data.title=(0,r.stringToPDFString)(t.get("T")||"");this.data.contents=(0,r.stringToPDFString)(t.get("Contents")||"")}}class k extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.FREETEXT}}class S extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.LINE;this.data.lineCoordinates=r.Util.normalizeRect(e.dict.getArray("L"))}}class C extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.SQUARE}}class x extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.CIRCLE}}class A extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.POLYLINE;const t=e.dict.getArray("Vertices");this.data.vertices=[];for(let e=0,a=t.length;e<a;e+=2)this.data.vertices.push({x:t[e],y:t[e+1]})}}class I extends A{constructor(e){super(e);this.data.annotationType=r.AnnotationType.POLYGON}}class F extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.CARET}}class T extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.INK;const t=e.xref,a=e.dict.getArray("InkList");this.data.inkLists=[];for(let e=0,r=a.length;e<r;++e){this.data.inkLists.push([]);for(let r=0,i=a[e].length;r<i;r+=2)this.data.inkLists[e].push({x:t.fetchIfRef(a[e][r]),y:t.fetchIfRef(a[e][r+1])})}}}class E extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.HIGHLIGHT;const t=h(e.dict,this.rectangle);t&&(this.data.quadPoints=t)}}class O extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.UNDERLINE;const t=h(e.dict,this.rectangle);t&&(this.data.quadPoints=t)}}class P extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.SQUIGGLY;const t=h(e.dict,this.rectangle);t&&(this.data.quadPoints=t)}}class B extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.STRIKEOUT;const t=h(e.dict,this.rectangle);t&&(this.data.quadPoints=t)}}class D extends f{constructor(e){super(e);this.data.annotationType=r.AnnotationType.STAMP}}class N extends f{constructor(e){super(e);const t=new i.FileSpec(e.dict.get("FS"),e.xref);this.data.annotationType=r.AnnotationType.FILEATTACHMENT;this.data.file=t.serializable}}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.OperatorList=void 0;var r=a(2),i=function(){function e(e,t,a,r,i){for(var n=e,s=0,o=t.length-1;s<o;s++){var c=t[s];n=n[c]||(n[c]=[])}n[t[t.length-1]]={checkFn:a,iterateFn:r,processFn:i}}var t=[];e(t,[r.OPS.save,r.OPS.transform,r.OPS.paintInlineImageXObject,r.OPS.restore],null,(function(e,t){var a=e.fnArray,i=(t-(e.iCurr-3))%4;switch(i){case 0:return a[t]===r.OPS.save;case 1:return a[t]===r.OPS.transform;case 2:return a[t]===r.OPS.paintInlineImageXObject;case 3:return a[t]===r.OPS.restore}throw new Error(`iterateInlineImageGroup - invalid pos: ${i}`)}),(function(e,t){var a=e.fnArray,i=e.argsArray,n=e.iCurr,s=n-3,o=n-2,c=n-1,l=Math.min(Math.floor((t-s)/4),200);if(l<10)return t-(t-s)%4;var h,u=0,d=[],f=0,g=1,m=1;for(h=0;h<l;h++){var p=i[o+(h<<2)],b=i[c+(h<<2)][0];if(g+b.width>1e3){u=Math.max(u,g);m+=f+2;g=0;f=0}d.push({transform:p,x:g,y:m,w:b.width,h:b.height});g+=b.width+2;f=Math.max(f,b.height)}var y=Math.max(u,g)+1,v=m+f+1,w=new Uint8ClampedArray(y*v*4),k=y<<2;for(h=0;h<l;h++){var S=i[c+(h<<2)][0].data,C=d[h].w<<2,x=0,A=d[h].x+d[h].y*y<<2;w.set(S.subarray(0,C),A-k);for(var I=0,F=d[h].h;I<F;I++){w.set(S.subarray(x,x+C),A);x+=C;A+=k}w.set(S.subarray(x-C,x),A);for(;A>=0;){S[A-4]=S[A];S[A-3]=S[A+1];S[A-2]=S[A+2];S[A-1]=S[A+3];S[A+C]=S[A+C-4];S[A+C+1]=S[A+C-3];S[A+C+2]=S[A+C-2];S[A+C+3]=S[A+C-1];A-=k}}a.splice(s,4*l,r.OPS.paintInlineImageXObjectGroup);i.splice(s,4*l,[{width:y,height:v,kind:r.ImageKind.RGBA_32BPP,data:w},d]);return s+1}));e(t,[r.OPS.save,r.OPS.transform,r.OPS.paintImageMaskXObject,r.OPS.restore],null,(function(e,t){var a=e.fnArray,i=(t-(e.iCurr-3))%4;switch(i){case 0:return a[t]===r.OPS.save;case 1:return a[t]===r.OPS.transform;case 2:return a[t]===r.OPS.paintImageMaskXObject;case 3:return a[t]===r.OPS.restore}throw new Error(`iterateImageMaskGroup - invalid pos: ${i}`)}),(function(e,t){var a,i=e.fnArray,n=e.argsArray,s=e.iCurr,o=s-3,c=s-2,l=s-1,h=Math.floor((t-o)/4);if((h=function(e,t,a,i){for(var n=e+2,s=0;s<t;s++){var o=i[n+4*s],c=1===o.length&&o[0];if(!c||1!==c.width||1!==c.height||c.data.length&&(1!==c.data.length||0!==c.data[0]))break;a[n+4*s]=r.OPS.paintSolidColorImageMask}return t-s}(o,h,i,n))<10)return t-(t-o)%4;var u,d,f=!1,g=n[l][0];if(0===n[c][1]&&0===n[c][2]){f=!0;var m=n[c][0],p=n[c][3];u=c+4;var b=l+4;for(a=1;a<h;a++,u+=4,b+=4){d=n[u];if(n[b][0]!==g||d[0]!==m||0!==d[1]||0!==d[2]||d[3]!==p){a<10?f=!1:h=a;break}}}if(f){h=Math.min(h,1e3);var y=new Float32Array(2*h);u=c;for(a=0;a<h;a++,u+=4){d=n[u];y[a<<1]=d[4];y[1+(a<<1)]=d[5]}i.splice(o,4*h,r.OPS.paintImageMaskXObjectRepeat);n.splice(o,4*h,[g,m,p,y])}else{h=Math.min(h,100);var v=[];for(a=0;a<h;a++){d=n[c+(a<<2)];var w=n[l+(a<<2)][0];v.push({data:w.data,width:w.width,height:w.height,transform:d})}i.splice(o,4*h,r.OPS.paintImageMaskXObjectGroup);n.splice(o,4*h,[v])}return o+1}));e(t,[r.OPS.save,r.OPS.transform,r.OPS.paintImageXObject,r.OPS.restore],(function(e){var t=e.argsArray,a=e.iCurr-2;return 0===t[a][1]&&0===t[a][2]}),(function(e,t){var a=e.fnArray,i=e.argsArray,n=(t-(e.iCurr-3))%4;switch(n){case 0:return a[t]===r.OPS.save;case 1:if(a[t]!==r.OPS.transform)return!1;var s=e.iCurr-2,o=i[s][0],c=i[s][3];return i[t][0]===o&&0===i[t][1]&&0===i[t][2]&&i[t][3]===c;case 2:if(a[t]!==r.OPS.paintImageXObject)return!1;var l=i[e.iCurr-1][0];return i[t][0]===l;case 3:return a[t]===r.OPS.restore}throw new Error(`iterateImageGroup - invalid pos: ${n}`)}),(function(e,t){var a=e.fnArray,i=e.argsArray,n=e.iCurr,s=n-3,o=n-2,c=i[n-1][0],l=i[o][0],h=i[o][3],u=Math.min(Math.floor((t-s)/4),1e3);if(u<3)return t-(t-s)%4;for(var d=new Float32Array(2*u),f=o,g=0;g<u;g++,f+=4){var m=i[f];d[g<<1]=m[4];d[1+(g<<1)]=m[5]}var p=[c,l,h,d];a.splice(s,4*u,r.OPS.paintImageXObjectRepeat);i.splice(s,4*u,p);return s+1}));e(t,[r.OPS.beginText,r.OPS.setFont,r.OPS.setTextMatrix,r.OPS.showText,r.OPS.endText],null,(function(e,t){var a=e.fnArray,i=e.argsArray,n=(t-(e.iCurr-4))%5;switch(n){case 0:return a[t]===r.OPS.beginText;case 1:return a[t]===r.OPS.setFont;case 2:return a[t]===r.OPS.setTextMatrix;case 3:if(a[t]!==r.OPS.showText)return!1;var s=e.iCurr-3,o=i[s][0],c=i[s][1];return i[t][0]===o&&i[t][1]===c;case 4:return a[t]===r.OPS.endText}throw new Error(`iterateShowTextGroup - invalid pos: ${n}`)}),(function(e,t){var a=e.fnArray,r=e.argsArray,i=e.iCurr,n=i-4,s=i-3,o=i-2,c=i-1,l=i,h=r[s][0],u=r[s][1],d=Math.min(Math.floor((t-n)/5),1e3);if(d<3)return t-(t-n)%5;var f=n;if(n>=4&&a[n-4]===a[s]&&a[n-3]===a[o]&&a[n-2]===a[c]&&a[n-1]===a[l]&&r[n-4][0]===h&&r[n-4][1]===u){d++;f-=5}for(var g=f+4,m=1;m<d;m++){a.splice(g,3);r.splice(g,3);g+=2}return g+1}));function a(e){this.queue=e;this.state=null;this.context={iCurr:0,fnArray:e.fnArray,argsArray:e.argsArray};this.match=null;this.lastProcessed=0}a.prototype={_optimize(){const e=this.queue.fnArray;let a=this.lastProcessed,r=e.length,i=this.state,n=this.match;if(!i&&!n&&a+1===r&&!t[e[a]]){this.lastProcessed=r;return}const s=this.context;for(;a<r;){if(n){if((0,n.iterateFn)(s,a)){a++;continue}a=(0,n.processFn)(s,a+1);r=e.length;n=null;i=null;if(a>=r)break}i=(i||t)[e[a]];if(i&&!Array.isArray(i)){s.iCurr=a;a++;if(!i.checkFn||(0,i.checkFn)(s)){n=i;i=null}else i=null}else a++}this.state=i;this.match=n;this.lastProcessed=a},push(e,t){this.queue.fnArray.push(e);this.queue.argsArray.push(t);this._optimize()},flush(){for(;this.match;){const e=this.queue.fnArray.length;this.lastProcessed=(0,this.match.processFn)(this.context,e);this.match=null;this.state=null;this._optimize()}},reset(){this.state=null;this.match=null;this.lastProcessed=0}};return a}(),n=function(){function e(e){this.queue=e}e.prototype={push(e,t){this.queue.fnArray.push(e);this.queue.argsArray.push(t)},flush(){},reset(){}};return e}(),s=function(){function e(e,t,a){this._streamSink=t;this.fnArray=[];this.argsArray=[];this.optimizer=t&&"oplist"!==e?new i(this):new n(this);this.dependencies=Object.create(null);this._totalLength=0;this.pageIndex=a;this.intent=e;this.weight=0;this._resolved=t?null:Promise.resolve()}e.prototype={get length(){return this.argsArray.length},get ready(){return this._resolved||this._streamSink.ready},get totalLength(){return this._totalLength+this.length},addOp(e,t){this.optimizer.push(e,t);this.weight++;this._streamSink&&(this.weight>=1e3||this.weight>=995&&(e===r.OPS.restore||e===r.OPS.endText))&&this.flush()},addDependency(e){if(!(e in this.dependencies)){this.dependencies[e]=!0;this.addOp(r.OPS.dependency,[e])}},addDependencies(e){for(var t in e)this.addDependency(t)},addOpList(e){Object.assign(this.dependencies,e.dependencies);for(var t=0,a=e.length;t<a;t++)this.addOp(e.fnArray[t],e.argsArray[t])},getIR(){return{fnArray:this.fnArray,argsArray:this.argsArray,length:this.length}},get _transfers(){const e=[],{fnArray:t,argsArray:a,length:i}=this;for(let n=0;n<i;n++)switch(t[n]){case r.OPS.paintInlineImageXObject:case r.OPS.paintInlineImageXObjectGroup:case r.OPS.paintImageMaskXObject:const t=a[n][0];t.cached||e.push(t.data.buffer)}return e},flush(e=!1){this.optimizer.flush();const t=this.length;this._totalLength+=t;this._streamSink.enqueue({fnArray:this.fnArray,argsArray:this.argsArray,lastChunk:e,length:t},1,this._transfers);this.dependencies=Object.create(null);this.fnArray.length=0;this.argsArray.length=0;this.weight=0;this.optimizer.reset()}};return e}();t.OperatorList=s},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.PartialEvaluator=void 0;var r=a(2),i=a(26),n=a(4),s=a(27),o=a(30),c=a(7),l=a(33),h=a(32),u=a(36),d=a(10),f=a(37),g=a(22),m=a(11),p=a(31),b=a(38),y=a(39),v=a(17),w=a(41),k=a(42),S=a(24),C=a(43),x=function(){const e={forceDataSchema:!1,maxImageSize:-1,disableFontFace:!1,nativeImageDecoderSupport:r.NativeImageDecoding.DECODE,ignoreErrors:!1,isEvalSupported:!0};function t({xref:t,handler:a,pageIndex:i,idFactory:n,fontCache:s,builtInCMapCache:o,options:c=null,pdfFunctionFactory:l}){this.xref=t;this.handler=a;this.pageIndex=i;this.idFactory=n;this.fontCache=s;this.builtInCMapCache=o;this.options=c||e;this.pdfFunctionFactory=l;this.parsingType3Font=!1;this.fetchBuiltInCMap=async e=>{if(this.builtInCMapCache.has(e))return this.builtInCMapCache.get(e);const t=this.handler.sendWithStream("FetchBuiltInCMap",{name:e}).getReader(),a=await new Promise((function(e,a){!function r(){t.read().then((function({value:t,done:a}){if(!a){e(t);r()}}),a)}()}));a.compressionType!==r.CMapCompressionType.NONE&&this.builtInCMapCache.set(e,a);return a}}function a(){this.reset()}a.prototype={check:function(){if(++this.checked<100)return!1;this.checked=0;return this.endTime<=Date.now()},reset:function(){this.endTime=Date.now()+20;this.checked=0}};function d(e,t=!1){if(Array.isArray(e)){for(let t=0,a=e.length;t<a;t++){const a=d(e[t],!0);if(a)return a}(0,r.warn)(`Unsupported blend mode Array: ${e}`);return"source-over"}if(!(0,n.isName)(e))return t?null:"source-over";switch(e.name){case"Normal":case"Compatible":return"source-over";case"Multiply":return"multiply";case"Screen":return"screen";case"Overlay":return"overlay";case"Darken":return"darken";case"Lighten":return"lighten";case"ColorDodge":return"color-dodge";case"ColorBurn":return"color-burn";case"HardLight":return"hard-light";case"SoftLight":return"soft-light";case"Difference":return"difference";case"Exclusion":return"exclusion";case"Hue":return"hue";case"Saturation":return"saturation";case"Color":return"color";case"Luminosity":return"luminosity"}if(t)return null;(0,r.warn)(`Unsupported blend mode: ${e.name}`);return"source-over"}var x=Promise.resolve();t.prototype={clone(t=e){var a=Object.create(this);a.options=t;return a},hasBlendModes:function(e){if(!(e instanceof n.Dict))return!1;var t=Object.create(null);e.objId&&(t[e.objId]=!0);for(var a=[e],i=this.xref;a.length;){var s=a.shift(),o=s.get("ExtGState");if(o instanceof n.Dict){var l=o.getKeys();for(let e=0,a=l.length;e<a;e++){const a=l[e];let s=o.getRaw(a);if(s instanceof n.Ref){if(t[s.toString()])continue;try{s=i.fetch(s)}catch(e){if(e instanceof c.MissingDataException)throw e;if(this.options.ignoreErrors){s instanceof n.Ref&&(t[s.toString()]=!0);this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.unknown});(0,r.warn)(`hasBlendModes - ignoring ExtGState: "${e}".`);continue}throw e}}if(!(s instanceof n.Dict))continue;s.objId&&(t[s.objId]=!0);const h=s.get("BM");if(h instanceof n.Name){if("Normal"!==h.name)return!0}else if(void 0!==h&&Array.isArray(h))for(let e=0,t=h.length;e<t;e++)if(h[e]instanceof n.Name&&"Normal"!==h[e].name)return!0}}var h=s.get("XObject");if(h instanceof n.Dict){var u=h.getKeys();for(let e=0,s=u.length;e<s;e++){const s=u[e];var d=h.getRaw(s);if(d instanceof n.Ref){if(t[d.toString()])continue;try{d=i.fetch(d)}catch(e){if(e instanceof c.MissingDataException)throw e;if(this.options.ignoreErrors){d instanceof n.Ref&&(t[d.toString()]=!0);this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.unknown});(0,r.warn)(`hasBlendModes - ignoring XObject: "${e}".`);continue}throw e}}if((0,n.isStream)(d)){if(d.dict.objId){if(t[d.dict.objId])continue;t[d.dict.objId]=!0}var f=d.dict.get("Resources");if(f instanceof n.Dict&&(!f.objId||!t[f.objId])){a.push(f);f.objId&&(t[f.objId]=!0)}}}}}return!1},async buildFormXObject(e,t,a,i,s,o){var c=t.dict,l=c.getArray("Matrix"),h=c.getArray("BBox");h=Array.isArray(h)&&4===h.length?r.Util.normalizeRect(h):null;var u=c.get("Group");if(u){var d={matrix:l,bbox:h,smask:a,isolated:!1,knockout:!1},f=u.get("S"),m=null;if((0,n.isName)(f,"Transparency")){d.isolated=u.get("I")||!1;d.knockout=u.get("K")||!1;u.has("CS")&&(m=await this.parseColorSpace({cs:u.get("CS"),resources:e}))}if(a&&a.backdrop){m=m||g.ColorSpace.singletons.rgb;a.backdrop=m.getRgb(a.backdrop,0)}i.addOp(r.OPS.beginGroup,[d])}i.addOp(r.OPS.paintFormXObjectBegin,[l,h]);return this.getOperatorList({stream:t,task:s,resources:c.get("Resources")||e,operatorList:i,initialState:o}).then((function(){i.addOp(r.OPS.paintFormXObjectEnd,[]);u&&i.addOp(r.OPS.endGroup,[d])}))},async buildPaintImageXObject({resources:e,image:t,isInline:a=!1,operatorList:i,cacheKey:n,imageCache:s,forceDisableNativeImageDecoder:o=!1}){var c=t.dict,l=c.get("Width","W"),h=c.get("Height","H");if(!(l&&(0,r.isNum)(l)&&h&&(0,r.isNum)(h))){(0,r.warn)("Image dimensions are missing, or not numbers.");return}var u,d,f=this.options.maxImageSize;if(-1!==f&&l*h>f){(0,r.warn)("Image exceeded maximum allowed size and was removed.");return}if(c.get("ImageMask","IM")||!1){var g=c.get("Width","W"),p=c.get("Height","H"),b=g+7>>3,y=t.getBytes(b*p,!0),w=c.getArray("Decode","D");(u=C.PDFImage.createMask({imgArray:y,width:g,height:p,imageIsFromDecodeStream:t instanceof m.DecodeStream,inverseDecode:!!w&&w[0]>0})).cached=!!n;d=[u];i.addOp(r.OPS.paintImageMaskXObject,d);n&&(s[n]={fn:r.OPS.paintImageMaskXObject,args:d});return}var S=c.get("SMask","SM")||!1,x=c.get("Mask")||!1;if(a&&!S&&!x&&!(t instanceof v.JpegStream)&&l+h<200){u=new C.PDFImage({xref:this.xref,res:e,image:t,isInline:a,pdfFunctionFactory:this.pdfFunctionFactory}).createImageData(!0);i.addOp(r.OPS.paintInlineImageXObject,[u]);return}const A=o?r.NativeImageDecoding.NONE:this.options.nativeImageDecoderSupport;let I=`img_${this.idFactory.createObjId()}`;if(this.parsingType3Font){(0,r.assert)(A===r.NativeImageDecoding.NONE,"Type3 image resources should be completely decoded in the worker.");I=`${this.idFactory.getDocId()}_type3res_${I}`}if(A!==r.NativeImageDecoding.NONE&&!S&&!x&&t instanceof v.JpegStream&&k.NativeImageDecoder.isSupported(t,this.xref,e,this.pdfFunctionFactory)&&t.maybeValidDimensions)return this.handler.sendWithPromise("obj",[I,this.pageIndex,"JpegStream",t.getIR(this.options.forceDataSchema)]).then((function(){i.addDependency(I);d=[I,l,h];i.addOp(r.OPS.paintJpegXObject,d);n&&(s[n]={fn:r.OPS.paintJpegXObject,args:d})}),o=>{(0,r.warn)("Native JPEG decoding failed -- trying to recover: "+(o&&o.message));return this.buildPaintImageXObject({resources:e,image:t,isInline:a,operatorList:i,cacheKey:n,imageCache:s,forceDisableNativeImageDecoder:!0})});var F=null;A===r.NativeImageDecoding.DECODE&&(t instanceof v.JpegStream||x instanceof v.JpegStream||S instanceof v.JpegStream)&&(F=new k.NativeImageDecoder({xref:this.xref,resources:e,handler:this.handler,forceDataSchema:this.options.forceDataSchema,pdfFunctionFactory:this.pdfFunctionFactory}));i.addDependency(I);d=[I,l,h];const T=C.PDFImage.buildImage({handler:this.handler,xref:this.xref,res:e,image:t,isInline:a,nativeDecoder:F,pdfFunctionFactory:this.pdfFunctionFactory}).then(e=>{var t=e.createImageData(!1);if(this.parsingType3Font)return this.handler.sendWithPromise("commonobj",[I,"FontType3Res",t],[t.data.buffer]);this.handler.send("obj",[I,this.pageIndex,"Image",t],[t.data.buffer])}).catch(e=>{(0,r.warn)("Unable to decode image: "+e);if(this.parsingType3Font)return this.handler.sendWithPromise("commonobj",[I,"FontType3Res",null]);this.handler.send("obj",[I,this.pageIndex,"Image",null])});this.parsingType3Font&&await T;i.addOp(r.OPS.paintImageXObject,d);n&&(s[n]={fn:r.OPS.paintImageXObject,args:d})},handleSMask:function(e,t,a,r,i){var n=e.get("G"),s={subtype:e.get("S").name,backdrop:e.get("BC")},o=e.get("TR");if((0,y.isPDFFunction)(o)){const e=this.pdfFunctionFactory.create(o);for(var c=new Uint8Array(256),l=new Float32Array(1),h=0;h<256;h++){l[0]=h/255;e(l,0,l,0);c[h]=255*l[0]|0}s.transferMap=c}return this.buildFormXObject(t,n,s,a,r,i.state.clone())},handleTilingType(e,t,a,i,s,o,c){const l=new S.OperatorList,h=[s.get("Resources"),a],d=n.Dict.merge(this.xref,h);return this.getOperatorList({stream:i,task:c,resources:d,operatorList:l}).then((function(){return(0,u.getTilingPatternIR)({fnArray:l.fnArray,argsArray:l.argsArray},s,t)})).then((function(t){o.addDependencies(l.dependencies);o.addOp(e,t)}),e=>{if(!(e instanceof r.AbortException)){if(!this.options.ignoreErrors)throw e;this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.unknown});(0,r.warn)(`handleTilingType - ignoring pattern: "${e}".`)}})},handleSetFont:function(e,t,a,i,n,o){var c;t&&(c=(t=t.slice())[0].name);return this.loadFont(c,a,e).then(t=>t.font.isType3Font?t.loadType3Data(this,e,i,n).then((function(){return t})).catch(e=>{this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.font});return new A("g_font_error",new s.ErrorFont("Type3 font load error: "+e),t.font)}):t).then(e=>{o.font=e.font;e.send(this.handler);return e.loadedName})},handleText(e,a){const i=a.font,n=i.charsToGlyphs(e);if(i.data){(!!(a.textRenderingMode&r.TextRenderingMode.ADD_TO_PATH_FLAG)||"Pattern"===a.fillColorSpace.name||i.disableFontFace||this.options.disableFontFace)&&t.buildFontPaths(i,n,this.handler)}return n},ensureStateFont(e){if(e.font)return;const t=new r.FormatError("Missing setFont (Tf) operator before text rendering operator.");if(!this.options.ignoreErrors)throw t;this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.font});(0,r.warn)(`ensureStateFont: "${t}".`)},setGState:function(e,t,a,i,s){for(var o=[],c=t.getKeys(),l=Promise.resolve(),h=0,u=c.length;h<u;h++){const u=c[h],f=t.get(u);switch(u){case"Type":break;case"LW":case"LC":case"LJ":case"ML":case"D":case"RI":case"FL":case"CA":case"ca":o.push([u,f]);break;case"Font":l=l.then(()=>this.handleSetFont(e,null,f[0],a,i,s.state).then((function(e){a.addDependency(e);o.push([u,[e,f[1]]])})));break;case"BM":o.push([u,d(f)]);break;case"SMask":if((0,n.isName)(f,"None")){o.push([u,!1]);break}if((0,n.isDict)(f)){l=l.then(()=>this.handleSMask(f,e,a,i,s));o.push([u,!0])}else(0,r.warn)("Unsupported SMask type");break;case"OP":case"op":case"OPM":case"BG":case"BG2":case"UCR":case"UCR2":case"TR":case"TR2":case"HT":case"SM":case"SA":case"AIS":case"TK":(0,r.info)("graphic state operator "+u);break;default:(0,r.info)("Unknown graphic state operator "+u)}}return l.then((function(){o.length>0&&a.addOp(r.OPS.setGState,[o])}))},loadFont:function(e,a,i){function o(){return Promise.resolve(new A("g_font_error",new s.ErrorFont("Font "+e+" is not available"),a))}var c,l=this.xref;if(a){if(!(0,n.isRef)(a))throw new r.FormatError('The "font" object should be a reference.');c=a}else{var h=i.get("Font");h&&(c=h.getRaw(e))}if(!c){const i=`Font "${e||a&&a.toString()}" is not available`;if(!this.options.ignoreErrors&&!this.parsingType3Font){(0,r.warn)(`${i}.`);return o()}this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.font});(0,r.warn)(`${i} -- attempting to fallback to a default font.`);c=t.getFallbackFontDict()}if(this.fontCache.has(c))return this.fontCache.get(c);a=l.fetchIfRef(c);if(!(0,n.isDict)(a))return o();if(a.translated)return a.translated;var u=(0,r.createPromiseCapability)(),d=this.preEvaluateFont(a);const{descriptor:f,hash:g}=d;var m,p,b=(0,n.isRef)(c);b&&(m=c.toString());if(g&&(0,n.isDict)(f)){f.fontAliases||(f.fontAliases=Object.create(null));var y=f.fontAliases;if(y[g]){var v=y[g].aliasRef;if(b&&v&&this.fontCache.has(v)){this.fontCache.putAlias(c,v);return this.fontCache.get(c)}}else y[g]={fontID:s.Font.getFontID()};b&&(y[g].aliasRef=c);m=y[g].fontID}if(b)this.fontCache.put(c,u.promise);else{m||(m=this.idFactory.createObjId());this.fontCache.put(`id_${m}`,u.promise)}(0,r.assert)(m,'The "fontID" must be defined.');a.loadedName=`${this.idFactory.getDocId()}_f${m}`;a.translated=u.promise;try{p=this.translateFont(d)}catch(e){p=Promise.reject(e)}p.then((function(e){if(void 0!==e.fontType){l.stats.fontTypes[e.fontType]=!0}u.resolve(new A(a.loadedName,e,a))})).catch(e=>{this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.font});try{var t=f&&f.get("FontFile3"),i=t&&t.get("Subtype"),n=(0,s.getFontType)(d.type,i&&i.name);l.stats.fontTypes[n]=!0}catch(e){}u.resolve(new A(a.loadedName,new s.ErrorFont(e instanceof Error?e.message:e),a))});return u.promise},buildPath(e,t,a,i=!1){var n=e.length-1;a||(a=[]);if(n<0||e.fnArray[n]!==r.OPS.constructPath){if(i){(0,r.warn)(`Encountered path operator "${t}" inside of a text object.`);e.addOp(r.OPS.save,null)}e.addOp(r.OPS.constructPath,[[t],a]);i&&e.addOp(r.OPS.restore,null)}else{var s=e.argsArray[n];s[0].push(t);Array.prototype.push.apply(s[1],a)}},parseColorSpace({cs:e,resources:t}){return new Promise(a=>{a(g.ColorSpace.parse(e,this.xref,t,this.pdfFunctionFactory))}).catch(e=>{if(e instanceof r.AbortException)return null;if(this.options.ignoreErrors){this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.unknown});(0,r.warn)(`parseColorSpace - ignoring ColorSpace: "${e}".`);return null}throw e})},async handleColorN(e,t,a,i,s,o,c){var l,h=a[a.length-1];if((0,n.isName)(h)&&(l=s.get(h.name))){var d=(0,n.isStream)(l)?l.dict:l,f=d.get("PatternType");if(1===f){var g=i.base?i.base.getRgb(a,0):null;return this.handleTilingType(t,g,o,l,d,e,c)}if(2===f){var m=d.get("Shading"),p=d.getArray("Matrix");l=u.Pattern.parseShading(m,p,this.xref,o,this.handler,this.pdfFunctionFactory);e.addOp(t,l.getIR());return}throw new r.FormatError(`Unknown PatternType: ${f}`)}throw new r.FormatError(`Unknown PatternName: ${h}`)},getOperatorList({stream:e,task:t,resources:i,operatorList:s,initialState:o=null}){i=i||n.Dict.empty;o=o||new T;if(!s)throw new Error('getOperatorList: missing "operatorList" parameter');var c=this,l=this.xref;let h=!1;var d=Object.create(null),f=i.get("XObject")||n.Dict.empty,m=i.get("Pattern")||n.Dict.empty,p=new I(o),b=new E(e,l,p),y=new a;function v(e){for(var t=0,a=b.savedStatesDepth;t<a;t++)s.addOp(r.OPS.restore,[])}return new Promise((function e(a,o){const w=function(t){Promise.all([t,s.ready]).then((function(){try{e(a,o)}catch(e){o(e)}}),o)};t.ensureNotTerminated();y.reset();for(var k,S,C,A,I={};!(k=y.check());){I.args=null;if(!b.read(I))break;var F=I.args,T=I.fn;switch(0|T){case r.OPS.paintXObject:var E=F[0].name;if(E&&void 0!==d[E]){s.addOp(d[E].fn,d[E].args);F=null;continue}w(new Promise((function(e,a){if(!E)throw new r.FormatError("XObject must be referred to by name.");const o=f.get(E);if(!o){s.addOp(T,F);e();return}if(!(0,n.isStream)(o))throw new r.FormatError("XObject should be a stream");const l=o.dict.get("Subtype");if(!(0,n.isName)(l))throw new r.FormatError("XObject should have a Name subtype");if("Form"!==l.name)if("Image"!==l.name){if("PS"!==l.name)throw new r.FormatError(`Unhandled XObject subtype ${l.name}`);(0,r.info)("Ignored XObject subtype PS");e()}else c.buildPaintImageXObject({resources:i,image:o,operatorList:s,cacheKey:E,imageCache:d}).then(e,a);else{p.save();c.buildFormXObject(i,o,null,s,t,p.state.clone()).then((function(){p.restore();e()}),a)}})).catch((function(e){if(!(e instanceof r.AbortException)){if(!c.options.ignoreErrors)throw e;c.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.unknown});(0,r.warn)(`getOperatorList - ignoring XObject: "${e}".`)}})));return;case r.OPS.setFont:var O=F[1];w(c.handleSetFont(i,F,null,s,t,p.state).then((function(e){s.addDependency(e);s.addOp(r.OPS.setFont,[e,O])})));return;case r.OPS.beginText:h=!0;break;case r.OPS.endText:h=!1;break;case r.OPS.endInlineImage:var P=F[0].cacheKey;if(P){var B=d[P];if(void 0!==B){s.addOp(B.fn,B.args);F=null;continue}}w(c.buildPaintImageXObject({resources:i,image:F[0],isInline:!0,operatorList:s,cacheKey:P,imageCache:d}));return;case r.OPS.showText:if(!p.state.font){c.ensureStateFont(p.state);continue}F[0]=c.handleText(F[0],p.state);break;case r.OPS.showSpacedText:if(!p.state.font){c.ensureStateFont(p.state);continue}var D=F[0],N=[],M=D.length,L=p.state;for(S=0;S<M;++S){var R=D[S];(0,r.isString)(R)?Array.prototype.push.apply(N,c.handleText(R,L)):(0,r.isNum)(R)&&N.push(R)}F[0]=N;T=r.OPS.showText;break;case r.OPS.nextLineShowText:if(!p.state.font){c.ensureStateFont(p.state);continue}s.addOp(r.OPS.nextLine);F[0]=c.handleText(F[0],p.state);T=r.OPS.showText;break;case r.OPS.nextLineSetSpacingShowText:if(!p.state.font){c.ensureStateFont(p.state);continue}s.addOp(r.OPS.nextLine);s.addOp(r.OPS.setWordSpacing,[F.shift()]);s.addOp(r.OPS.setCharSpacing,[F.shift()]);F[0]=c.handleText(F[0],p.state);T=r.OPS.showText;break;case r.OPS.setTextRenderingMode:p.state.textRenderingMode=F[0];break;case r.OPS.setFillColorSpace:w(c.parseColorSpace({cs:F[0],resources:i}).then((function(e){e&&(p.state.fillColorSpace=e)})));return;case r.OPS.setStrokeColorSpace:w(c.parseColorSpace({cs:F[0],resources:i}).then((function(e){e&&(p.state.strokeColorSpace=e)})));return;case r.OPS.setFillColor:A=p.state.fillColorSpace;F=A.getRgb(F,0);T=r.OPS.setFillRGBColor;break;case r.OPS.setStrokeColor:A=p.state.strokeColorSpace;F=A.getRgb(F,0);T=r.OPS.setStrokeRGBColor;break;case r.OPS.setFillGray:p.state.fillColorSpace=g.ColorSpace.singletons.gray;F=g.ColorSpace.singletons.gray.getRgb(F,0);T=r.OPS.setFillRGBColor;break;case r.OPS.setStrokeGray:p.state.strokeColorSpace=g.ColorSpace.singletons.gray;F=g.ColorSpace.singletons.gray.getRgb(F,0);T=r.OPS.setStrokeRGBColor;break;case r.OPS.setFillCMYKColor:p.state.fillColorSpace=g.ColorSpace.singletons.cmyk;F=g.ColorSpace.singletons.cmyk.getRgb(F,0);T=r.OPS.setFillRGBColor;break;case r.OPS.setStrokeCMYKColor:p.state.strokeColorSpace=g.ColorSpace.singletons.cmyk;F=g.ColorSpace.singletons.cmyk.getRgb(F,0);T=r.OPS.setStrokeRGBColor;break;case r.OPS.setFillRGBColor:p.state.fillColorSpace=g.ColorSpace.singletons.rgb;F=g.ColorSpace.singletons.rgb.getRgb(F,0);break;case r.OPS.setStrokeRGBColor:p.state.strokeColorSpace=g.ColorSpace.singletons.rgb;F=g.ColorSpace.singletons.rgb.getRgb(F,0);break;case r.OPS.setFillColorN:if("Pattern"===(A=p.state.fillColorSpace).name){w(c.handleColorN(s,r.OPS.setFillColorN,F,A,m,i,t));return}F=A.getRgb(F,0);T=r.OPS.setFillRGBColor;break;case r.OPS.setStrokeColorN:if("Pattern"===(A=p.state.strokeColorSpace).name){w(c.handleColorN(s,r.OPS.setStrokeColorN,F,A,m,i,t));return}F=A.getRgb(F,0);T=r.OPS.setStrokeRGBColor;break;case r.OPS.shadingFill:var U=i.get("Shading");if(!U)throw new r.FormatError("No shading resource found");var q=U.get(F[0].name);if(!q)throw new r.FormatError("No shading object found");var j=u.Pattern.parseShading(q,null,l,i,c.handler,c.pdfFunctionFactory).getIR();F=[j];T=r.OPS.shadingFill;break;case r.OPS.setGState:var _=F[0],z=i.get("ExtGState");if(!(0,n.isDict)(z)||!z.has(_.name))break;var H=z.get(_.name);w(c.setGState(i,H,s,t,p));return;case r.OPS.moveTo:case r.OPS.lineTo:case r.OPS.curveTo:case r.OPS.curveTo2:case r.OPS.curveTo3:case r.OPS.closePath:case r.OPS.rectangle:c.buildPath(s,T,F,h);continue;case r.OPS.markPoint:case r.OPS.markPointProps:case r.OPS.beginMarkedContent:case r.OPS.beginMarkedContentProps:case r.OPS.endMarkedContent:case r.OPS.beginCompat:case r.OPS.endCompat:continue;default:if(null!==F){for(S=0,C=F.length;S<C&&!(F[S]instanceof n.Dict);S++);if(S<C){(0,r.warn)("getOperatorList - ignoring operator: "+T);continue}}}s.addOp(T,F)}if(k)w(x);else{v();a()}})).catch(e=>{if(!(e instanceof r.AbortException)){if(!this.options.ignoreErrors)throw e;this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.unknown});(0,r.warn)(`getOperatorList - ignoring errors during "${t.name}" `+`task: "${e}".`);v()}})},getTextContent({stream:e,task:t,resources:i,stateManager:s=null,normalizeWhitespace:o=!1,combineTextItems:c=!1,sink:h,seenStyles:u=Object.create(null)}){i=i||n.Dict.empty;s=s||new I(new F);var d,g=/\s/g,m={items:[],styles:Object.create(null)},p={initialized:!1,str:[],width:0,height:0,vertical:!1,lastAdvanceWidth:0,lastAdvanceHeight:0,textAdvanceScale:0,spaceWidth:0,fakeSpaceMin:1/0,fakeMultiSpaceMin:1/0,fakeMultiSpaceMax:-0,textRunBreakAllowed:!1,transform:null,fontName:null},b=this,y=this.xref,v=null,w=Object.create(null),k=new E(e,y,s);function S(){if(p.initialized)return p;var e=d.font;if(!(e.loadedName in u)){u[e.loadedName]=!0;m.styles[e.loadedName]={fontFamily:e.fallbackName,ascent:e.ascent,descent:e.descent,vertical:!!e.vertical}}p.fontName=e.loadedName;var t=[d.fontSize*d.textHScale,0,0,d.fontSize,0,d.textRise];if(e.isType3Font&&d.fontSize<=1&&!(0,r.isArrayEqual)(d.fontMatrix,r.FONT_IDENTITY_MATRIX)){const a=e.bbox[3]-e.bbox[1];a>0&&(t[3]*=a*d.fontMatrix[3])}var a=r.Util.transform(d.ctm,r.Util.transform(d.textMatrix,t));p.transform=a;if(e.vertical){p.width=Math.sqrt(a[0]*a[0]+a[1]*a[1]);p.height=0;p.vertical=!0}else{p.width=0;p.height=Math.sqrt(a[2]*a[2]+a[3]*a[3]);p.vertical=!1}var i=d.textLineMatrix[0],n=d.textLineMatrix[1],s=Math.sqrt(i*i+n*n);i=d.ctm[0];n=d.ctm[1];var o=Math.sqrt(i*i+n*n);p.textAdvanceScale=o*s;p.lastAdvanceWidth=0;p.lastAdvanceHeight=0;var c=e.spaceWidth/1e3*d.fontSize;if(c){p.spaceWidth=c;p.fakeSpaceMin=.3*c;p.fakeMultiSpaceMin=1.5*c;p.fakeMultiSpaceMax=4*c;p.textRunBreakAllowed=!e.isMonospace}else{p.spaceWidth=0;p.fakeSpaceMin=1/0;p.fakeMultiSpaceMin=1/0;p.fakeMultiSpaceMax=0;p.textRunBreakAllowed=!1}p.initialized=!0;return p}function C(e){for(var t,a=0,r=e.length;a<r&&(t=e.charCodeAt(a))>=32&&t<=127;)a++;return a<r?e.replace(g," "):e}function A(e,t){return b.loadFont(e,t,i).then((function(e){d.font=e.font;d.fontMatrix=e.font.fontMatrix||r.FONT_IDENTITY_MATRIX}))}function T(e){for(var t=d.font,a=S(),r=0,i=0,n=t.charsToGlyphs(e),s=0;s<n.length;s++){var o=n[s],c=null;c=t.vertical&&o.vmetric?o.vmetric[0]:o.width;var h=o.unicode,u=(0,l.getNormalizedUnicodes)();void 0!==u[h]&&(h=u[h]);h=(0,l.reverseIfRtl)(h);var f=d.charSpacing;if(o.isSpace){var g=d.wordSpacing;f+=g;g>0&&O(g,a.str)}var m=0,p=0;if(t.vertical){i+=p=c*d.fontMatrix[0]*d.fontSize+f}else{r+=m=(c*d.fontMatrix[0]*d.fontSize+f)*d.textHScale}d.translateTextMatrix(m,p);a.str.push(h)}if(t.vertical){a.lastAdvanceHeight=i;a.height+=Math.abs(i)}else{a.lastAdvanceWidth=r;a.width+=r}return a}function O(e,t){if(!(e<p.fakeSpaceMin))if(e<p.fakeMultiSpaceMin)t.push(" ");else for(var a=Math.round(e/p.spaceWidth);a-- >0;)t.push(" ")}function P(){if(p.initialized){p.vertical?p.height*=p.textAdvanceScale:p.width*=p.textAdvanceScale;m.items.push((t=(e=p).str.join(""),a=(0,f.bidi)(t,-1,e.vertical),{str:o?C(a.str):a.str,dir:a.dir,width:e.width,height:e.height,transform:e.transform,fontName:e.fontName}));var e,t,a;p.initialized=!1;p.str.length=0}}function B(){const e=m.items.length;if(e>0){h.enqueue(m,e);m.items=[];m.styles=Object.create(null)}}var D=new a;return new Promise((function e(a,l){const f=function(t){B();Promise.all([t,h.ready]).then((function(){try{e(a,l)}catch(e){l(e)}}),l)};t.ensureNotTerminated();D.reset();for(var g,y={},C=[];!(g=D.check());){C.length=0;y.args=C;if(!k.read(y))break;d=s.state;var F,E=y.fn;C=y.args;switch(0|E){case r.OPS.setFont:var N=C[0].name,M=C[1];if(d.font&&N===d.fontName&&M===d.fontSize)break;P();d.fontName=N;d.fontSize=M;f(A(N,null));return;case r.OPS.setTextRise:P();d.textRise=C[0];break;case r.OPS.setHScale:P();d.textHScale=C[0]/100;break;case r.OPS.setLeading:P();d.leading=C[0];break;case r.OPS.moveText:var L=!!d.font&&0===(d.font.vertical?C[0]:C[1]);F=C[0]-C[1];if(c&&L&&p.initialized&&F>0&&F<=p.fakeMultiSpaceMax){d.translateTextLineMatrix(C[0],C[1]);p.width+=C[0]-p.lastAdvanceWidth;p.height+=C[1]-p.lastAdvanceHeight;O(C[0]-p.lastAdvanceWidth-(C[1]-p.lastAdvanceHeight),p.str);break}P();d.translateTextLineMatrix(C[0],C[1]);d.textMatrix=d.textLineMatrix.slice();break;case r.OPS.setLeadingMoveText:P();d.leading=-C[1];d.translateTextLineMatrix(C[0],C[1]);d.textMatrix=d.textLineMatrix.slice();break;case r.OPS.nextLine:P();d.carriageReturn();break;case r.OPS.setTextMatrix:F=d.calcTextLineMatrixAdvance(C[0],C[1],C[2],C[3],C[4],C[5]);if(c&&null!==F&&p.initialized&&F.value>0&&F.value<=p.fakeMultiSpaceMax){d.translateTextLineMatrix(F.width,F.height);p.width+=F.width-p.lastAdvanceWidth;p.height+=F.height-p.lastAdvanceHeight;O(F.width-p.lastAdvanceWidth-(F.height-p.lastAdvanceHeight),p.str);break}P();d.setTextMatrix(C[0],C[1],C[2],C[3],C[4],C[5]);d.setTextLineMatrix(C[0],C[1],C[2],C[3],C[4],C[5]);break;case r.OPS.setCharSpacing:d.charSpacing=C[0];break;case r.OPS.setWordSpacing:d.wordSpacing=C[0];break;case r.OPS.beginText:P();d.textMatrix=r.IDENTITY_MATRIX.slice();d.textLineMatrix=r.IDENTITY_MATRIX.slice();break;case r.OPS.showSpacedText:if(!s.state.font){b.ensureStateFont(s.state);continue}for(var R,U=C[0],q=0,j=U.length;q<j;q++)if("string"==typeof U[q])T(U[q]);else if((0,r.isNum)(U[q])){S();F=U[q]*d.fontSize/1e3;var _=!1;if(d.font.vertical){R=F;d.translateTextMatrix(0,R);(_=p.textRunBreakAllowed&&F>p.fakeMultiSpaceMax)||(p.height+=R)}else{R=(F=-F)*d.textHScale;d.translateTextMatrix(R,0);(_=p.textRunBreakAllowed&&F>p.fakeMultiSpaceMax)||(p.width+=R)}_?P():F>0&&O(F,p.str)}break;case r.OPS.showText:if(!s.state.font){b.ensureStateFont(s.state);continue}T(C[0]);break;case r.OPS.nextLineShowText:if(!s.state.font){b.ensureStateFont(s.state);continue}P();d.carriageReturn();T(C[0]);break;case r.OPS.nextLineSetSpacingShowText:if(!s.state.font){b.ensureStateFont(s.state);continue}P();d.wordSpacing=C[0];d.charSpacing=C[1];d.carriageReturn();T(C[2]);break;case r.OPS.paintXObject:P();v||(v=i.get("XObject")||n.Dict.empty);var z=C[0].name;if(z&&void 0!==w[z])break;f(new Promise((function(e,a){if(!z)throw new r.FormatError("XObject must be referred to by name.");const l=v.get(z);if(!l){e();return}if(!(0,n.isStream)(l))throw new r.FormatError("XObject should be a stream");const d=l.dict.get("Subtype");if(!(0,n.isName)(d))throw new r.FormatError("XObject should have a Name subtype");if("Form"!==d.name){w[z]=!0;e();return}const f=s.state.clone(),g=new I(f),m=l.dict.getArray("Matrix");Array.isArray(m)&&6===m.length&&g.transform(m);B();const p={enqueueInvoked:!1,enqueue(e,t){this.enqueueInvoked=!0;h.enqueue(e,t)},get desiredSize(){return h.desiredSize},get ready(){return h.ready}};b.getTextContent({stream:l,task:t,resources:l.dict.get("Resources")||i,stateManager:g,normalizeWhitespace:o,combineTextItems:c,sink:p,seenStyles:u}).then((function(){p.enqueueInvoked||(w[z]=!0);e()}),a)})).catch((function(e){if(!(e instanceof r.AbortException)){if(!b.options.ignoreErrors)throw e;(0,r.warn)(`getTextContent - ignoring XObject: "${e}".`)}})));return;case r.OPS.setGState:P();var H=C[0],G=i.get("ExtGState");if(!(0,n.isDict)(G)||!(0,n.isName)(H))break;var W=G.get(H.name);if(!(0,n.isDict)(W))break;var X=W.get("Font");if(X){d.fontName=null;d.fontSize=X[1];f(A(null,X[0]));return}}if(m.items.length>=h.desiredSize){g=!0;break}}if(g)f(x);else{P();B();a()}})).catch(e=>{if(!(e instanceof r.AbortException)){if(!this.options.ignoreErrors)throw e;(0,r.warn)(`getTextContent - ignoring errors during "${t.name}" `+`task: "${e}".`);P();B()}})},extractDataStructures:function(e,t,a){const i=this.xref;let c;var l=e.get("ToUnicode")||t.get("ToUnicode"),h=l?this.readToUnicode(l):Promise.resolve(void 0);if(a.composite){var u=e.get("CIDSystemInfo");(0,n.isDict)(u)&&(a.cidSystemInfo={registry:(0,r.stringToPDFString)(u.get("Registry")),ordering:(0,r.stringToPDFString)(u.get("Ordering")),supplement:u.get("Supplement")});var d=e.get("CIDToGIDMap");(0,n.isStream)(d)&&(c=d.getBytes())}var f,g=[],m=null;if(e.has("Encoding")){f=e.get("Encoding");if((0,n.isDict)(f)){m=f.get("BaseEncoding");m=(0,n.isName)(m)?m.name:null;if(f.has("Differences"))for(var p=f.get("Differences"),b=0,y=0,v=p.length;y<v;y++){var w=i.fetchIfRef(p[y]);if((0,r.isNum)(w))b=w;else{if(!(0,n.isName)(w))throw new r.FormatError(`Invalid entry in 'Differences' array: ${w}`);g[b++]=w.name}}}else{if(!(0,n.isName)(f))throw new r.FormatError("Encoding is not a Name nor a Dict");m=f.name}"MacRomanEncoding"!==m&&"MacExpertEncoding"!==m&&"WinAnsiEncoding"!==m&&(m=null)}if(m)a.defaultEncoding=(0,o.getEncoding)(m).slice();else{var k=!!(a.flags&s.FontFlags.Symbolic),S=!!(a.flags&s.FontFlags.Nonsymbolic);f=o.StandardEncoding;"TrueType"!==a.type||S||(f=o.WinAnsiEncoding);if(k){f=o.MacRomanEncoding;a.file||(/Symbol/i.test(a.name)?f=o.SymbolSetEncoding:/Dingbats|Wingdings/i.test(a.name)&&(f=o.ZapfDingbatsEncoding))}a.defaultEncoding=f}a.differences=g;a.baseEncodingName=m;a.hasEncoding=!!m||g.length>0;a.dict=e;return h.then(e=>{a.toUnicode=e;return this.buildToUnicode(a)}).then(e=>{a.toUnicode=e;c&&(a.cidToGidMap=this.readCidToGidMap(c,e));return a})},_buildSimpleFontToUnicode(e,t=!1){(0,r.assert)(!e.composite,"Must be a simple font.");const a=[],i=e.defaultEncoding.slice(),n=e.baseEncodingName,c=e.differences;for(const e in c){const t=c[e];".notdef"!==t&&(i[e]=t)}const h=(0,p.getGlyphsUnicode)();for(const r in i){let s=i[r];if(""!==s)if(void 0!==h[s])a[r]=String.fromCharCode(h[s]);else{let i=0;switch(s[0]){case"G":3===s.length&&(i=parseInt(s.substring(1),16));break;case"g":5===s.length&&(i=parseInt(s.substring(1),16));break;case"C":case"c":if(s.length>=3&&s.length<=4){const a=s.substring(1);if(t){i=parseInt(a,16);break}i=+a;if(Number.isNaN(i)&&Number.isInteger(parseInt(a,16)))return this._buildSimpleFontToUnicode(e,!0)}break;default:const a=(0,l.getUnicodeForGlyph)(s,h);-1!==a&&(i=a)}if(i>0&&Number.isInteger(i)){if(n&&i===+r){const e=(0,o.getEncoding)(n);if(e&&(s=e[r])){a[r]=String.fromCharCode(h[s]);continue}}a[r]=String.fromCodePoint(i)}}}return new s.ToUnicodeMap(a)},buildToUnicode(e){e.hasIncludedToUnicodeMap=!!e.toUnicode&&e.toUnicode.length>0;if(e.hasIncludedToUnicodeMap){!e.composite&&e.hasEncoding&&(e.fallbackToUnicode=this._buildSimpleFontToUnicode(e));return Promise.resolve(e.toUnicode)}if(!e.composite)return Promise.resolve(this._buildSimpleFontToUnicode(e));if(e.composite&&(e.cMap.builtInCMap&&!(e.cMap instanceof i.IdentityCMap)||"Adobe"===e.cidSystemInfo.registry&&("GB1"===e.cidSystemInfo.ordering||"CNS1"===e.cidSystemInfo.ordering||"Japan1"===e.cidSystemInfo.ordering||"Korea1"===e.cidSystemInfo.ordering))){const t=e.cidSystemInfo.registry,a=e.cidSystemInfo.ordering,o=n.Name.get(t+"-"+a+"-UCS2");return i.CMapFactory.create({encoding:o,fetchBuiltInCMap:this.fetchBuiltInCMap,useCMap:null}).then((function(t){const a=e.cMap,i=[];a.forEach((function(e,a){if(a>65535)throw new r.FormatError("Max size of CID is 65,535");const n=t.lookup(a);n&&(i[e]=String.fromCharCode((n.charCodeAt(0)<<8)+n.charCodeAt(1)))}));return new s.ToUnicodeMap(i)}))}return Promise.resolve(new s.IdentityToUnicodeMap(e.firstChar,e.lastChar))},readToUnicode:function(e){var t=e;return(0,n.isName)(t)?i.CMapFactory.create({encoding:t,fetchBuiltInCMap:this.fetchBuiltInCMap,useCMap:null}).then((function(e){return e instanceof i.IdentityCMap?new s.IdentityToUnicodeMap(0,65535):new s.ToUnicodeMap(e.getMap())})):(0,n.isStream)(t)?i.CMapFactory.create({encoding:t,fetchBuiltInCMap:this.fetchBuiltInCMap,useCMap:null}).then((function(e){if(e instanceof i.IdentityCMap)return new s.IdentityToUnicodeMap(0,65535);var t=new Array(e.length);e.forEach((function(e,a){for(var r=[],i=0;i<a.length;i+=2){var n=a.charCodeAt(i)<<8|a.charCodeAt(i+1);if(55296==(63488&n)){i+=2;var s=a.charCodeAt(i)<<8|a.charCodeAt(i+1);r.push(((1023&n)<<10)+(1023&s)+65536)}else r.push(n)}t[e]=String.fromCodePoint.apply(String,r)}));return new s.ToUnicodeMap(t)}),e=>{if(e instanceof r.AbortException)return null;if(this.options.ignoreErrors){this.handler.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.font});(0,r.warn)(`readToUnicode - ignoring ToUnicode data: "${e}".`);return null}throw e}):Promise.resolve(null)},readCidToGidMap(e,t){for(var a=[],r=0,i=e.length;r<i;r++){var n=e[r++]<<8|e[r];const i=r>>1;(0!==n||t.has(i))&&(a[i]=n)}return a},extractWidths:function(e,t,a){var r,i,o,c,l,h,u,d,f=this.xref,g=[],m=0,p=[];if(a.composite){m=e.has("DW")?e.get("DW"):1e3;if(d=e.get("W"))for(i=0,o=d.length;i<o;i++){h=f.fetchIfRef(d[i++]);u=f.fetchIfRef(d[i]);if(Array.isArray(u))for(c=0,l=u.length;c<l;c++)g[h++]=f.fetchIfRef(u[c]);else{var b=f.fetchIfRef(d[++i]);for(c=h;c<=u;c++)g[c]=b}}if(a.vertical){var y=e.getArray("DW2")||[880,-1e3];r=[y[1],.5*m,y[0]];if(y=e.get("W2"))for(i=0,o=y.length;i<o;i++){h=f.fetchIfRef(y[i++]);u=f.fetchIfRef(y[i]);if(Array.isArray(u))for(c=0,l=u.length;c<l;c++)p[h++]=[f.fetchIfRef(u[c++]),f.fetchIfRef(u[c++]),f.fetchIfRef(u[c])];else{var v=[f.fetchIfRef(y[++i]),f.fetchIfRef(y[++i]),f.fetchIfRef(y[++i])];for(c=h;c<=u;c++)p[c]=v}}}}else{var w=a.firstChar;if(d=e.get("Widths")){c=w;for(i=0,o=d.length;i<o;i++)g[c++]=f.fetchIfRef(d[i]);m=parseFloat(t.get("MissingWidth"))||0}else{var k=e.get("BaseFont");if((0,n.isName)(k)){var S=this.getBaseFontMetrics(k.name);g=this.buildCharCodeToWidth(S.widths,a);m=S.defaultWidth}}}var C=!0,x=m;for(var A in g){var I=g[A];if(I)if(x){if(x!==I){C=!1;break}}else x=I}C&&(a.flags|=s.FontFlags.FixedPitch);a.defaultWidth=m;a.widths=g;a.defaultVMetrics=r;a.vmetrics=p},isSerifFont:function(e){var t=e.split("-")[0];return t in(0,h.getSerifFonts)()||-1!==t.search(/serif/gi)},getBaseFontMetrics:function(e){var t=0,a=[],i=!1,n=(0,h.getStdFontMap)()[e]||e,s=(0,b.getMetrics)();n in s||(n=this.isSerifFont(e)?"Times-Roman":"Helvetica");var o=s[n];if((0,r.isNum)(o)){t=o;i=!0}else a=o();return{defaultWidth:t,monospace:i,widths:a}},buildCharCodeToWidth:function(e,t){for(var a=Object.create(null),r=t.differences,i=t.defaultEncoding,n=0;n<256;n++)n in r&&e[r[n]]?a[n]=e[r[n]]:n in i&&e[i[n]]&&(a[n]=e[i[n]]);return a},preEvaluateFont:function(e){var t=e,a=e.get("Subtype");if(!(0,n.isName)(a))throw new r.FormatError("invalid font Subtype");var i,s=!1;if("Type0"===a.name){var o=e.get("DescendantFonts");if(!o)throw new r.FormatError("Descendant fonts are not specified");a=(e=Array.isArray(o)?this.xref.fetchIfRef(o[0]):o).get("Subtype");if(!(0,n.isName)(a))throw new r.FormatError("invalid font Subtype");s=!0}var c=e.get("FontDescriptor");if(c){var l=new w.MurmurHash3_64,h=t.getRaw("Encoding");if((0,n.isName)(h))l.update(h.name);else if((0,n.isRef)(h))l.update(h.toString());else if((0,n.isDict)(h))for(var u=h.getKeys(),d=0,f=u.length;d<f;d++){var g=h.getRaw(u[d]);if((0,n.isName)(g))l.update(g.name);else if((0,n.isRef)(g))l.update(g.toString());else if(Array.isArray(g)){for(var m=g.length,p=new Array(m),b=0;b<m;b++){var y=g[b];(0,n.isName)(y)?p[b]=y.name:((0,r.isNum)(y)||(0,n.isRef)(y))&&(p[b]=y.toString())}l.update(p.join())}}const a=e.get("FirstChar")||0,o=e.get("LastChar")||(s?65535:255);l.update(`${a}-${o}`);var v=e.get("ToUnicode")||t.get("ToUnicode");if((0,n.isStream)(v)){var k=v.str||v;i=k.buffer?new Uint8Array(k.buffer.buffer,0,k.bufferLength):new Uint8Array(k.bytes.buffer,k.start,k.end-k.start);l.update(i)}else(0,n.isName)(v)&&l.update(v.name);var S=e.get("Widths")||t.get("Widths");if(S){i=new Uint8Array(new Uint32Array(S).buffer);l.update(i)}}return{descriptor:c,dict:e,baseDict:t,composite:s,type:a.name,hash:l?l.hexdigest():""}},translateFont:function(e){var t,a=e.baseDict,o=e.dict,c=e.composite,l=e.descriptor,u=e.type,d=c?65535:255;const f=o.get("FirstChar")||0,g=o.get("LastChar")||d;if(!l){if("Type3"!==u){var m=o.get("BaseFont");if(!(0,n.isName)(m))throw new r.FormatError("Base font is not specified");m=m.name.replace(/[,_]/g,"-");var p=this.getBaseFontMetrics(m),b=m.split("-")[0],y=(this.isSerifFont(b)?s.FontFlags.Serif:0)|(p.monospace?s.FontFlags.FixedPitch:0)|((0,h.getSymbolsFonts)()[b]?s.FontFlags.Symbolic:s.FontFlags.Nonsymbolic);t={type:u,name:m,widths:p.widths,defaultWidth:p.defaultWidth,flags:y,firstChar:f,lastChar:g};const e=o.get("Widths");return this.extractDataStructures(o,o,t).then(t=>{if(e){const a=[];let r=f;for(let t=0,i=e.length;t<i;t++)a[r++]=this.xref.fetchIfRef(e[t]);t.widths=a}else t.widths=this.buildCharCodeToWidth(p.widths,t);return new s.Font(m,null,t)})}(l=new n.Dict(null)).set("FontName",n.Name.get(u));l.set("FontBBox",o.getArray("FontBBox")||[0,0,0,0])}var v=l.get("FontName"),w=o.get("BaseFont");(0,r.isString)(v)&&(v=n.Name.get(v));(0,r.isString)(w)&&(w=n.Name.get(w));if("Type3"!==u){var k=v&&v.name,S=w&&w.name;if(k!==S){(0,r.info)(`The FontDescriptor's FontName is "${k}" but `+`should be the same as the Font's BaseFont "${S}".`);k&&S&&S.startsWith(k)&&(v=w)}}v=v||w;if(!(0,n.isName)(v))throw new r.FormatError("invalid font name");var C,x=l.get("FontFile","FontFile2","FontFile3");if(x&&x.dict){var A=x.dict.get("Subtype");A&&(A=A.name);var I=x.dict.get("Length1"),F=x.dict.get("Length2"),T=x.dict.get("Length3")}t={type:u,name:v.name,subtype:A,file:x,length1:I,length2:F,length3:T,loadedName:a.loadedName,composite:c,wideChars:c,fixedPitch:!1,fontMatrix:o.getArray("FontMatrix")||r.FONT_IDENTITY_MATRIX,firstChar:f||0,lastChar:g||d,bbox:l.getArray("FontBBox"),ascent:l.get("Ascent"),descent:l.get("Descent"),xHeight:l.get("XHeight"),capHeight:l.get("CapHeight"),flags:l.get("Flags"),italicAngle:l.get("ItalicAngle"),isType3Font:!1};if(c){var E=a.get("Encoding");(0,n.isName)(E)&&(t.cidEncoding=E.name);C=i.CMapFactory.create({encoding:E,fetchBuiltInCMap:this.fetchBuiltInCMap,useCMap:null}).then((function(e){t.cMap=e;t.vertical=t.cMap.vertical}))}else C=Promise.resolve(void 0);return C.then(()=>this.extractDataStructures(o,a,t)).then(e=>{this.extractWidths(o,l,e);"Type3"===u&&(e.isType3Font=!0);return new s.Font(v.name,x,e)})}};t.buildFontPaths=function(e,t,a){function r(t){e.renderer.hasBuiltPath(t)||a.send("commonobj",[`${e.loadedName}_path_${t}`,"FontPath",e.renderer.getPathJs(t)])}for(const e of t){r(e.fontChar);const t=e.accent;t&&t.fontChar&&r(t.fontChar)}};t.getFallbackFontDict=function(){if(this._fallbackFontDict)return this._fallbackFontDict;const e=new n.Dict;e.set("BaseFont",n.Name.get("PDFJS-FallbackFont"));e.set("Type",n.Name.get("FallbackType"));e.set("Subtype",n.Name.get("FallbackType"));e.set("Encoding",n.Name.get("WinAnsiEncoding"));return this._fallbackFontDict=e};return t}();t.PartialEvaluator=x;var A=function(){function e(e,t,a){this.loadedName=e;this.font=t;this.dict=a;this.type3Loaded=null;this.sent=!1}e.prototype={send(e){if(!this.sent){this.sent=!0;e.send("commonobj",[this.loadedName,"Font",this.font.exportData()])}},fallback(e){if(!this.font.data)return;this.font.disableFontFace=!0;const t=this.font.glyphCacheValues;x.buildFontPaths(this.font,t,e)},loadType3Data(e,t,a,i){if(!this.font.isType3Font)throw new Error("Must be a Type3 font.");if(this.type3Loaded)return this.type3Loaded;var n=Object.create(e.options);n.ignoreErrors=!1;n.nativeImageDecoderSupport=r.NativeImageDecoding.NONE;var s=e.clone(n);s.parsingType3Font=!0;for(var o=this.font,c=Promise.resolve(),l=this.dict.get("CharProcs"),h=this.dict.get("Resources")||t,u=l.getKeys(),d=Object.create(null),f=0,g=u.length;f<g;++f){const e=u[f];c=c.then((function(){var t=l.get(e),n=new S.OperatorList;return s.getOperatorList({stream:t,task:i,resources:h,operatorList:n}).then((function(){d[e]=n.getIR();a.addDependencies(n.dependencies)})).catch((function(t){(0,r.warn)(`Type3 font resource "${e}" is not available.`);var a=new S.OperatorList;d[e]=a.getIR()}))}))}this.type3Loaded=c.then((function(){o.charProcOperatorList=d}));return this.type3Loaded}};return e}(),I=function(){function e(e){this.state=e;this.stateStack=[]}e.prototype={save(){var e=this.state;this.stateStack.push(this.state);this.state=e.clone()},restore(){var e=this.stateStack.pop();e&&(this.state=e)},transform(e){this.state.ctm=r.Util.transform(this.state.ctm,e)}};return e}(),F=function(){function e(){this.ctm=new Float32Array(r.IDENTITY_MATRIX);this.fontName=null;this.fontSize=0;this.font=null;this.fontMatrix=r.FONT_IDENTITY_MATRIX;this.textMatrix=r.IDENTITY_MATRIX.slice();this.textLineMatrix=r.IDENTITY_MATRIX.slice();this.charSpacing=0;this.wordSpacing=0;this.leading=0;this.textHScale=1;this.textRise=0}e.prototype={setTextMatrix:function(e,t,a,r,i,n){var s=this.textMatrix;s[0]=e;s[1]=t;s[2]=a;s[3]=r;s[4]=i;s[5]=n},setTextLineMatrix:function(e,t,a,r,i,n){var s=this.textLineMatrix;s[0]=e;s[1]=t;s[2]=a;s[3]=r;s[4]=i;s[5]=n},translateTextMatrix:function(e,t){var a=this.textMatrix;a[4]=a[0]*e+a[2]*t+a[4];a[5]=a[1]*e+a[3]*t+a[5]},translateTextLineMatrix:function(e,t){var a=this.textLineMatrix;a[4]=a[0]*e+a[2]*t+a[4];a[5]=a[1]*e+a[3]*t+a[5]},calcTextLineMatrixAdvance:function(e,t,a,r,i,n){var s=this.font;if(!s)return null;var o=this.textLineMatrix;if(e!==o[0]||t!==o[1]||a!==o[2]||r!==o[3])return null;var c=i-o[4],l=n-o[5];if(s.vertical&&0!==c||!s.vertical&&0!==l)return null;var h,u,d=e*r-t*a;if(s.vertical){h=-l*a/d;u=l*e/d}else{h=c*r/d;u=-c*t/d}return{width:h,height:u,value:s.vertical?u:h}},calcRenderMatrix:function(e){var t=[this.fontSize*this.textHScale,0,0,this.fontSize,0,this.textRise];return r.Util.transform(e,r.Util.transform(this.textMatrix,t))},carriageReturn:function(){this.translateTextLineMatrix(0,-this.leading);this.textMatrix=this.textLineMatrix.slice()},clone:function(){var e=Object.create(this);e.textMatrix=this.textMatrix.slice();e.textLineMatrix=this.textLineMatrix.slice();e.fontMatrix=this.fontMatrix.slice();return e}};return e}(),T=function(){function e(){this.ctm=new Float32Array(r.IDENTITY_MATRIX);this.font=null;this.textRenderingMode=r.TextRenderingMode.FILL;this.fillColorSpace=g.ColorSpace.singletons.gray;this.strokeColorSpace=g.ColorSpace.singletons.gray}e.prototype={clone:function(){return Object.create(this)}};return e}(),E=function(){var e=(0,c.getLookupTableFactory)((function(e){e.w={id:r.OPS.setLineWidth,numArgs:1,variableArgs:!1};e.J={id:r.OPS.setLineCap,numArgs:1,variableArgs:!1};e.j={id:r.OPS.setLineJoin,numArgs:1,variableArgs:!1};e.M={id:r.OPS.setMiterLimit,numArgs:1,variableArgs:!1};e.d={id:r.OPS.setDash,numArgs:2,variableArgs:!1};e.ri={id:r.OPS.setRenderingIntent,numArgs:1,variableArgs:!1};e.i={id:r.OPS.setFlatness,numArgs:1,variableArgs:!1};e.gs={id:r.OPS.setGState,numArgs:1,variableArgs:!1};e.q={id:r.OPS.save,numArgs:0,variableArgs:!1};e.Q={id:r.OPS.restore,numArgs:0,variableArgs:!1};e.cm={id:r.OPS.transform,numArgs:6,variableArgs:!1};e.m={id:r.OPS.moveTo,numArgs:2,variableArgs:!1};e.l={id:r.OPS.lineTo,numArgs:2,variableArgs:!1};e.c={id:r.OPS.curveTo,numArgs:6,variableArgs:!1};e.v={id:r.OPS.curveTo2,numArgs:4,variableArgs:!1};e.y={id:r.OPS.curveTo3,numArgs:4,variableArgs:!1};e.h={id:r.OPS.closePath,numArgs:0,variableArgs:!1};e.re={id:r.OPS.rectangle,numArgs:4,variableArgs:!1};e.S={id:r.OPS.stroke,numArgs:0,variableArgs:!1};e.s={id:r.OPS.closeStroke,numArgs:0,variableArgs:!1};e.f={id:r.OPS.fill,numArgs:0,variableArgs:!1};e.F={id:r.OPS.fill,numArgs:0,variableArgs:!1};e["f*"]={id:r.OPS.eoFill,numArgs:0,variableArgs:!1};e.B={id:r.OPS.fillStroke,numArgs:0,variableArgs:!1};e["B*"]={id:r.OPS.eoFillStroke,numArgs:0,variableArgs:!1};e.b={id:r.OPS.closeFillStroke,numArgs:0,variableArgs:!1};e["b*"]={id:r.OPS.closeEOFillStroke,numArgs:0,variableArgs:!1};e.n={id:r.OPS.endPath,numArgs:0,variableArgs:!1};e.W={id:r.OPS.clip,numArgs:0,variableArgs:!1};e["W*"]={id:r.OPS.eoClip,numArgs:0,variableArgs:!1};e.BT={id:r.OPS.beginText,numArgs:0,variableArgs:!1};e.ET={id:r.OPS.endText,numArgs:0,variableArgs:!1};e.Tc={id:r.OPS.setCharSpacing,numArgs:1,variableArgs:!1};e.Tw={id:r.OPS.setWordSpacing,numArgs:1,variableArgs:!1};e.Tz={id:r.OPS.setHScale,numArgs:1,variableArgs:!1};e.TL={id:r.OPS.setLeading,numArgs:1,variableArgs:!1};e.Tf={id:r.OPS.setFont,numArgs:2,variableArgs:!1};e.Tr={id:r.OPS.setTextRenderingMode,numArgs:1,variableArgs:!1};e.Ts={id:r.OPS.setTextRise,numArgs:1,variableArgs:!1};e.Td={id:r.OPS.moveText,numArgs:2,variableArgs:!1};e.TD={id:r.OPS.setLeadingMoveText,numArgs:2,variableArgs:!1};e.Tm={id:r.OPS.setTextMatrix,numArgs:6,variableArgs:!1};e["T*"]={id:r.OPS.nextLine,numArgs:0,variableArgs:!1};e.Tj={id:r.OPS.showText,numArgs:1,variableArgs:!1};e.TJ={id:r.OPS.showSpacedText,numArgs:1,variableArgs:!1};e["'"]={id:r.OPS.nextLineShowText,numArgs:1,variableArgs:!1};e['"']={id:r.OPS.nextLineSetSpacingShowText,numArgs:3,variableArgs:!1};e.d0={id:r.OPS.setCharWidth,numArgs:2,variableArgs:!1};e.d1={id:r.OPS.setCharWidthAndBounds,numArgs:6,variableArgs:!1};e.CS={id:r.OPS.setStrokeColorSpace,numArgs:1,variableArgs:!1};e.cs={id:r.OPS.setFillColorSpace,numArgs:1,variableArgs:!1};e.SC={id:r.OPS.setStrokeColor,numArgs:4,variableArgs:!0};e.SCN={id:r.OPS.setStrokeColorN,numArgs:33,variableArgs:!0};e.sc={id:r.OPS.setFillColor,numArgs:4,variableArgs:!0};e.scn={id:r.OPS.setFillColorN,numArgs:33,variableArgs:!0};e.G={id:r.OPS.setStrokeGray,numArgs:1,variableArgs:!1};e.g={id:r.OPS.setFillGray,numArgs:1,variableArgs:!1};e.RG={id:r.OPS.setStrokeRGBColor,numArgs:3,variableArgs:!1};e.rg={id:r.OPS.setFillRGBColor,numArgs:3,variableArgs:!1};e.K={id:r.OPS.setStrokeCMYKColor,numArgs:4,variableArgs:!1};e.k={id:r.OPS.setFillCMYKColor,numArgs:4,variableArgs:!1};e.sh={id:r.OPS.shadingFill,numArgs:1,variableArgs:!1};e.BI={id:r.OPS.beginInlineImage,numArgs:0,variableArgs:!1};e.ID={id:r.OPS.beginImageData,numArgs:0,variableArgs:!1};e.EI={id:r.OPS.endInlineImage,numArgs:1,variableArgs:!1};e.Do={id:r.OPS.paintXObject,numArgs:1,variableArgs:!1};e.MP={id:r.OPS.markPoint,numArgs:1,variableArgs:!1};e.DP={id:r.OPS.markPointProps,numArgs:2,variableArgs:!1};e.BMC={id:r.OPS.beginMarkedContent,numArgs:1,variableArgs:!1};e.BDC={id:r.OPS.beginMarkedContentProps,numArgs:2,variableArgs:!1};e.EMC={id:r.OPS.endMarkedContent,numArgs:0,variableArgs:!1};e.BX={id:r.OPS.beginCompat,numArgs:0,variableArgs:!1};e.EX={id:r.OPS.endCompat,numArgs:0,variableArgs:!1};e.BM=null;e.BD=null;e.true=null;e.fa=null;e.fal=null;e.fals=null;e.false=null;e.nu=null;e.nul=null;e.null=null}));function t(t,a,r){this.opMap=e();this.parser=new d.Parser({lexer:new d.Lexer(t,this.opMap),xref:a});this.stateManager=r;this.nonProcessedArgs=[];this._numInvalidPathOPS=0}t.prototype={get savedStatesDepth(){return this.stateManager.stateStack.length},read:function(e){for(var t=e.args;;){var a=this.parser.getObj();if(a instanceof n.Cmd){var i=a.cmd,s=this.opMap[i];if(!s){(0,r.warn)(`Unknown command "${i}".`);continue}var o=s.id,c=s.numArgs,l=null!==t?t.length:0;if(s.variableArgs)l>c&&(0,r.info)(`Command ${i}: expected [0, ${c}] args, `+`but received ${l} args.`);else{if(l!==c){for(var h=this.nonProcessedArgs;l>c;){h.push(t.shift());l--}for(;l<c&&0!==h.length;){null===t&&(t=[]);t.unshift(h.pop());l++}}if(l<c){const e=`command ${i}: expected ${c} args, `+`but received ${l} args.`;if(o>=r.OPS.moveTo&&o<=r.OPS.endPath&&++this._numInvalidPathOPS>20)throw new r.FormatError(`Invalid ${e}`);(0,r.warn)(`Skipping ${e}`);null!==t&&(t.length=0);continue}}this.preprocessCommand(o,t);e.fn=o;e.args=t;return!0}if(a===n.EOF)return!1;if(null!==a){null===t&&(t=[]);t.push(a);if(t.length>33)throw new r.FormatError("Too many arguments")}}},preprocessCommand:function(e,t){switch(0|e){case r.OPS.save:this.stateManager.save();break;case r.OPS.restore:this.stateManager.restore();break;case r.OPS.transform:this.stateManager.transform(t)}}};return t}()},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.CMapFactory=t.IdentityCMap=t.CMap=void 0;var r=a(2),i=a(4),n=a(10),s=a(7),o=a(11),c=["Adobe-GB1-UCS2","Adobe-CNS1-UCS2","Adobe-Japan1-UCS2","Adobe-Korea1-UCS2","78-EUC-H","78-EUC-V","78-H","78-RKSJ-H","78-RKSJ-V","78-V","78ms-RKSJ-H","78ms-RKSJ-V","83pv-RKSJ-H","90ms-RKSJ-H","90ms-RKSJ-V","90msp-RKSJ-H","90msp-RKSJ-V","90pv-RKSJ-H","90pv-RKSJ-V","Add-H","Add-RKSJ-H","Add-RKSJ-V","Add-V","Adobe-CNS1-0","Adobe-CNS1-1","Adobe-CNS1-2","Adobe-CNS1-3","Adobe-CNS1-4","Adobe-CNS1-5","Adobe-CNS1-6","Adobe-GB1-0","Adobe-GB1-1","Adobe-GB1-2","Adobe-GB1-3","Adobe-GB1-4","Adobe-GB1-5","Adobe-Japan1-0","Adobe-Japan1-1","Adobe-Japan1-2","Adobe-Japan1-3","Adobe-Japan1-4","Adobe-Japan1-5","Adobe-Japan1-6","Adobe-Korea1-0","Adobe-Korea1-1","Adobe-Korea1-2","B5-H","B5-V","B5pc-H","B5pc-V","CNS-EUC-H","CNS-EUC-V","CNS1-H","CNS1-V","CNS2-H","CNS2-V","ETHK-B5-H","ETHK-B5-V","ETen-B5-H","ETen-B5-V","ETenms-B5-H","ETenms-B5-V","EUC-H","EUC-V","Ext-H","Ext-RKSJ-H","Ext-RKSJ-V","Ext-V","GB-EUC-H","GB-EUC-V","GB-H","GB-V","GBK-EUC-H","GBK-EUC-V","GBK2K-H","GBK2K-V","GBKp-EUC-H","GBKp-EUC-V","GBT-EUC-H","GBT-EUC-V","GBT-H","GBT-V","GBTpc-EUC-H","GBTpc-EUC-V","GBpc-EUC-H","GBpc-EUC-V","H","HKdla-B5-H","HKdla-B5-V","HKdlb-B5-H","HKdlb-B5-V","HKgccs-B5-H","HKgccs-B5-V","HKm314-B5-H","HKm314-B5-V","HKm471-B5-H","HKm471-B5-V","HKscs-B5-H","HKscs-B5-V","Hankaku","Hiragana","KSC-EUC-H","KSC-EUC-V","KSC-H","KSC-Johab-H","KSC-Johab-V","KSC-V","KSCms-UHC-H","KSCms-UHC-HW-H","KSCms-UHC-HW-V","KSCms-UHC-V","KSCpc-EUC-H","KSCpc-EUC-V","Katakana","NWP-H","NWP-V","RKSJ-H","RKSJ-V","Roman","UniCNS-UCS2-H","UniCNS-UCS2-V","UniCNS-UTF16-H","UniCNS-UTF16-V","UniCNS-UTF32-H","UniCNS-UTF32-V","UniCNS-UTF8-H","UniCNS-UTF8-V","UniGB-UCS2-H","UniGB-UCS2-V","UniGB-UTF16-H","UniGB-UTF16-V","UniGB-UTF32-H","UniGB-UTF32-V","UniGB-UTF8-H","UniGB-UTF8-V","UniJIS-UCS2-H","UniJIS-UCS2-HW-H","UniJIS-UCS2-HW-V","UniJIS-UCS2-V","UniJIS-UTF16-H","UniJIS-UTF16-V","UniJIS-UTF32-H","UniJIS-UTF32-V","UniJIS-UTF8-H","UniJIS-UTF8-V","UniJIS2004-UTF16-H","UniJIS2004-UTF16-V","UniJIS2004-UTF32-H","UniJIS2004-UTF32-V","UniJIS2004-UTF8-H","UniJIS2004-UTF8-V","UniJISPro-UCS2-HW-V","UniJISPro-UCS2-V","UniJISPro-UTF8-V","UniJISX0213-UTF32-H","UniJISX0213-UTF32-V","UniJISX02132004-UTF32-H","UniJISX02132004-UTF32-V","UniKS-UCS2-H","UniKS-UCS2-V","UniKS-UTF16-H","UniKS-UTF16-V","UniKS-UTF32-H","UniKS-UTF32-V","UniKS-UTF8-H","UniKS-UTF8-V","V","WP-Symbol"];class l{constructor(e=!1){this.codespaceRanges=[[],[],[],[]];this.numCodespaceRanges=0;this._map=[];this.name="";this.vertical=!1;this.useCMap=null;this.builtInCMap=e}addCodespaceRange(e,t,a){this.codespaceRanges[e-1].push(t,a);this.numCodespaceRanges++}mapCidRange(e,t,a){for(;e<=t;)this._map[e++]=a++}mapBfRange(e,t,a){for(var r=a.length-1;e<=t;){this._map[e++]=a;a=a.substring(0,r)+String.fromCharCode(a.charCodeAt(r)+1)}}mapBfRangeToArray(e,t,a){const r=a.length;let i=0;for(;e<=t&&i<r;){this._map[e]=a[i++];++e}}mapOne(e,t){this._map[e]=t}lookup(e){return this._map[e]}contains(e){return void 0!==this._map[e]}forEach(e){const t=this._map,a=t.length;if(a<=65536)for(let r=0;r<a;r++)void 0!==t[r]&&e(r,t[r]);else for(const a in t)e(a,t[a])}charCodeOf(e){const t=this._map;if(t.length<=65536)return t.indexOf(e);for(const a in t)if(t[a]===e)return 0|a;return-1}getMap(){return this._map}readCharCode(e,t,a){let r=0;const i=this.codespaceRanges;for(let n=0,s=i.length;n<s;n++){r=(r<<8|e.charCodeAt(t+n))>>>0;const s=i[n];for(let e=0,t=s.length;e<t;){const t=s[e++],i=s[e++];if(r>=t&&r<=i){a.charcode=r;a.length=n+1;return}}}a.charcode=0;a.length=1}get length(){return this._map.length}get isIdentityCMap(){if("Identity-H"!==this.name&&"Identity-V"!==this.name)return!1;if(65536!==this._map.length)return!1;for(let e=0;e<65536;e++)if(this._map[e]!==e)return!1;return!0}}t.CMap=l;class h extends l{constructor(e,t){super();this.vertical=e;this.addCodespaceRange(t,0,65535)}mapCidRange(e,t,a){(0,r.unreachable)("should not call mapCidRange")}mapBfRange(e,t,a){(0,r.unreachable)("should not call mapBfRange")}mapBfRangeToArray(e,t,a){(0,r.unreachable)("should not call mapBfRangeToArray")}mapOne(e,t){(0,r.unreachable)("should not call mapCidOne")}lookup(e){return Number.isInteger(e)&&e<=65535?e:void 0}contains(e){return Number.isInteger(e)&&e<=65535}forEach(e){for(let t=0;t<=65535;t++)e(t,t)}charCodeOf(e){return Number.isInteger(e)&&e<=65535?e:-1}getMap(){const e=new Array(65536);for(let t=0;t<=65535;t++)e[t]=t;return e}get length(){return 65536}get isIdentityCMap(){(0,r.unreachable)("should not access .isIdentityCMap")}}t.IdentityCMap=h;var u=function(){function e(e,t){for(var a=0,r=0;r<=t;r++)a=a<<8|e[r];return a>>>0}function t(e,t){return 1===t?String.fromCharCode(e[0],e[1]):3===t?String.fromCharCode(e[0],e[1],e[2],e[3]):String.fromCharCode.apply(null,e.subarray(0,t+1))}function a(e,t,a){for(var r=0,i=a;i>=0;i--){r+=e[i]+t[i];e[i]=255&r;r>>=8}}function i(e,t){for(var a=1,r=t;r>=0&&a>0;r--){a+=e[r];e[r]=255&a;a>>=8}}function n(e){this.buffer=e;this.pos=0;this.end=e.length;this.tmpBuf=new Uint8Array(19)}n.prototype={readByte(){return this.pos>=this.end?-1:this.buffer[this.pos++]},readNumber(){var e,t=0;do{var a=this.readByte();if(a<0)throw new r.FormatError("unexpected EOF in bcmap");e=!(128&a);t=t<<7|127&a}while(!e);return t},readSigned(){var e=this.readNumber();return 1&e?~(e>>>1):e>>>1},readHex(e,t){e.set(this.buffer.subarray(this.pos,this.pos+t+1));this.pos+=t+1},readHexNumber(e,t){var a,i=this.tmpBuf,n=0;do{var s=this.readByte();if(s<0)throw new r.FormatError("unexpected EOF in bcmap");a=!(128&s);i[n++]=127&s}while(!a);for(var o=t,c=0,l=0;o>=0;){for(;l<8&&i.length>0;){c=i[--n]<<l|c;l+=7}e[o]=255&c;o--;c>>=8;l-=8}},readHexSigned(e,t){this.readHexNumber(e,t);for(var a=1&e[t]?255:0,r=0,i=0;i<=t;i++){r=(1&r)<<8|e[i];e[i]=r>>1^a}},readString(){for(var e=this.readNumber(),t="",a=0;a<e;a++)t+=String.fromCharCode(this.readNumber());return t}};function s(){}s.prototype={process:function(r,s,o){return new Promise((function(c,l){var h=new n(r),u=h.readByte();s.vertical=!!(1&u);for(var d,f,g=null,m=new Uint8Array(16),p=new Uint8Array(16),b=new Uint8Array(16),y=new Uint8Array(16),v=new Uint8Array(16);(f=h.readByte())>=0;){var w=f>>5;if(7!==w){var k=!!(16&f),S=15&f;if(S+1>16)throw new Error("processBinaryCMap: Invalid dataSize.");var C,x=h.readNumber();switch(w){case 0:h.readHex(m,S);h.readHexNumber(p,S);a(p,m,S);s.addCodespaceRange(S+1,e(m,S),e(p,S));for(C=1;C<x;C++){i(p,S);h.readHexNumber(m,S);a(m,p,S);h.readHexNumber(p,S);a(p,m,S);s.addCodespaceRange(S+1,e(m,S),e(p,S))}break;case 1:h.readHex(m,S);h.readHexNumber(p,S);a(p,m,S);h.readNumber();for(C=1;C<x;C++){i(p,S);h.readHexNumber(m,S);a(m,p,S);h.readHexNumber(p,S);a(p,m,S);h.readNumber()}break;case 2:h.readHex(b,S);d=h.readNumber();s.mapOne(e(b,S),d);for(C=1;C<x;C++){i(b,S);if(!k){h.readHexNumber(v,S);a(b,v,S)}d=h.readSigned()+(d+1);s.mapOne(e(b,S),d)}break;case 3:h.readHex(m,S);h.readHexNumber(p,S);a(p,m,S);d=h.readNumber();s.mapCidRange(e(m,S),e(p,S),d);for(C=1;C<x;C++){i(p,S);if(k)m.set(p);else{h.readHexNumber(m,S);a(m,p,S)}h.readHexNumber(p,S);a(p,m,S);d=h.readNumber();s.mapCidRange(e(m,S),e(p,S),d)}break;case 4:h.readHex(b,1);h.readHex(y,S);s.mapOne(e(b,1),t(y,S));for(C=1;C<x;C++){i(b,1);if(!k){h.readHexNumber(v,1);a(b,v,1)}i(y,S);h.readHexSigned(v,S);a(y,v,S);s.mapOne(e(b,1),t(y,S))}break;case 5:h.readHex(m,1);h.readHexNumber(p,1);a(p,m,1);h.readHex(y,S);s.mapBfRange(e(m,1),e(p,1),t(y,S));for(C=1;C<x;C++){i(p,1);if(k)m.set(p);else{h.readHexNumber(m,1);a(m,p,1)}h.readHexNumber(p,1);a(p,m,1);h.readHex(y,S);s.mapBfRange(e(m,1),e(p,1),t(y,S))}break;default:l(new Error("processBinaryCMap: Unknown type: "+w));return}}else switch(31&f){case 0:h.readString();break;case 1:g=h.readString()}}c(g?o(g):s)}))}};return s}(),d=function(){function e(e){for(var t=0,a=0;a<e.length;a++)t=t<<8|e.charCodeAt(a);return t>>>0}function t(e){if(!(0,r.isString)(e))throw new r.FormatError("Malformed CMap: expected string.")}function a(e){if(!Number.isInteger(e))throw new r.FormatError("Malformed CMap: expected int.")}function d(a,r){for(;;){var n=r.getObj();if((0,i.isEOF)(n))break;if((0,i.isCmd)(n,"endbfchar"))return;t(n);var s=e(n);t(n=r.getObj());var o=n;a.mapOne(s,o)}}function f(a,n){for(;;){var s=n.getObj();if((0,i.isEOF)(s))break;if((0,i.isCmd)(s,"endbfrange"))return;t(s);var o=e(s);t(s=n.getObj());var c=e(s);s=n.getObj();if(Number.isInteger(s)||(0,r.isString)(s)){var l=Number.isInteger(s)?String.fromCharCode(s):s;a.mapBfRange(o,c,l)}else{if(!(0,i.isCmd)(s,"["))break;s=n.getObj();for(var h=[];!(0,i.isCmd)(s,"]")&&!(0,i.isEOF)(s);){h.push(s);s=n.getObj()}a.mapBfRangeToArray(o,c,h)}}throw new r.FormatError("Invalid bf range.")}function g(r,n){for(;;){var s=n.getObj();if((0,i.isEOF)(s))break;if((0,i.isCmd)(s,"endcidchar"))return;t(s);var o=e(s);a(s=n.getObj());var c=s;r.mapOne(o,c)}}function m(r,n){for(;;){var s=n.getObj();if((0,i.isEOF)(s))break;if((0,i.isCmd)(s,"endcidrange"))return;t(s);var o=e(s);t(s=n.getObj());var c=e(s);a(s=n.getObj());var l=s;r.mapCidRange(o,c,l)}}function p(t,a){for(;;){var n=a.getObj();if((0,i.isEOF)(n))break;if((0,i.isCmd)(n,"endcodespacerange"))return;if(!(0,r.isString)(n))break;var s=e(n);n=a.getObj();if(!(0,r.isString)(n))break;var o=e(n);t.addCodespaceRange(n.length,s,o)}throw new r.FormatError("Invalid codespace range.")}function b(e,t){var a=t.getObj();Number.isInteger(a)&&(e.vertical=!!a)}function y(e,t){var a=t.getObj();(0,i.isName)(a)&&(0,r.isString)(a.name)&&(e.name=a.name)}function v(e,t,a,n){var o,c;e:for(;;)try{var l=t.getObj();if((0,i.isEOF)(l))break;if((0,i.isName)(l)){"WMode"===l.name?b(e,t):"CMapName"===l.name&&y(e,t);o=l}else if((0,i.isCmd)(l))switch(l.cmd){case"endcmap":break e;case"usecmap":(0,i.isName)(o)&&(c=o.name);break;case"begincodespacerange":p(e,t);break;case"beginbfchar":d(e,t);break;case"begincidchar":g(e,t);break;case"beginbfrange":f(e,t);break;case"begincidrange":m(e,t)}}catch(e){if(e instanceof s.MissingDataException)throw e;(0,r.warn)("Invalid cMap data: "+e);continue}!n&&c&&(n=c);return n?w(e,a,n):Promise.resolve(e)}function w(e,t,a){return k(a,t).then((function(t){e.useCMap=t;if(0===e.numCodespaceRanges){for(var a=e.useCMap.codespaceRanges,r=0;r<a.length;r++)e.codespaceRanges[r]=a[r].slice();e.numCodespaceRanges=e.useCMap.numCodespaceRanges}e.useCMap.forEach((function(t,a){e.contains(t)||e.mapOne(t,e.useCMap.lookup(t))}));return e}))}function k(e,t){return"Identity-H"===e?Promise.resolve(new h(!1,2)):"Identity-V"===e?Promise.resolve(new h(!0,2)):c.includes(e)?t?t(e).then((function(e){var a=e.cMapData,i=e.compressionType,s=new l(!0);if(i===r.CMapCompressionType.BINARY)return(new u).process(a,s,(function(e){return w(s,t,e)}));if(i===r.CMapCompressionType.NONE){var c=new n.Lexer(new o.Stream(a));return v(s,c,t,null)}return Promise.reject(new Error("TODO: Only BINARY/NONE CMap compression is currently supported."))})):Promise.reject(new Error("Built-in CMap parameters are not provided.")):Promise.reject(new Error("Unknown CMap name: "+e))}return{async create(e){var t=e.encoding,a=e.fetchBuiltInCMap,r=e.useCMap;if((0,i.isName)(t))return k(t.name,a);if((0,i.isStream)(t)){return v(new l,new n.Lexer(t),a,r).then((function(e){return e.isIdentityCMap?k(e.name,a):e}))}throw new Error("Encoding required.")}}}();t.CMapFactory=d},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.getFontType=y;t.IdentityToUnicodeMap=t.ToUnicodeMap=t.FontFlags=t.Font=t.ErrorFont=t.SEAC_ANALYSIS_ENABLED=void 0;var r=a(2),i=a(28),n=a(31),s=a(30),o=a(32),c=a(33),l=a(7),h=a(34),u=a(26),d=a(11),f=a(35);const g=[[57344,63743],[1048576,1114109]];t.SEAC_ANALYSIS_ENABLED=!0;var m={FixedPitch:1,Serif:2,Symbolic:4,Script:8,Nonsymbolic:32,Italic:64,AllCap:65536,SmallCap:131072,ForceBold:262144};t.FontFlags=m;var p=[".notdef",".null","nonmarkingreturn","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","Adieresis","Aring","Ccedilla","Eacute","Ntilde","Odieresis","Udieresis","aacute","agrave","acircumflex","adieresis","atilde","aring","ccedilla","eacute","egrave","ecircumflex","edieresis","iacute","igrave","icircumflex","idieresis","ntilde","oacute","ograve","ocircumflex","odieresis","otilde","uacute","ugrave","ucircumflex","udieresis","dagger","degree","cent","sterling","section","bullet","paragraph","germandbls","registered","copyright","trademark","acute","dieresis","notequal","AE","Oslash","infinity","plusminus","lessequal","greaterequal","yen","mu","partialdiff","summation","product","pi","integral","ordfeminine","ordmasculine","Omega","ae","oslash","questiondown","exclamdown","logicalnot","radical","florin","approxequal","Delta","guillemotleft","guillemotright","ellipsis","nonbreakingspace","Agrave","Atilde","Otilde","OE","oe","endash","emdash","quotedblleft","quotedblright","quoteleft","quoteright","divide","lozenge","ydieresis","Ydieresis","fraction","currency","guilsinglleft","guilsinglright","fi","fl","daggerdbl","periodcentered","quotesinglbase","quotedblbase","perthousand","Acircumflex","Ecircumflex","Aacute","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Oacute","Ocircumflex","apple","Ograve","Uacute","Ucircumflex","Ugrave","dotlessi","circumflex","tilde","macron","breve","dotaccent","ring","cedilla","hungarumlaut","ogonek","caron","Lslash","lslash","Scaron","scaron","Zcaron","zcaron","brokenbar","Eth","eth","Yacute","yacute","Thorn","thorn","minus","multiply","onesuperior","twosuperior","threesuperior","onehalf","onequarter","threequarters","franc","Gbreve","gbreve","Idotaccent","Scedilla","scedilla","Cacute","cacute","Ccaron","ccaron","dcroat"];function b(e){if(e.fontMatrix&&e.fontMatrix[0]!==r.FONT_IDENTITY_MATRIX[0]){var t=.001/e.fontMatrix[0],a=e.widths;for(var i in a)a[i]*=t;e.defaultWidth*=t}}function y(e,t){switch(e){case"Type1":return"Type1C"===t?r.FontType.TYPE1C:r.FontType.TYPE1;case"CIDFontType0":return"CIDFontType0C"===t?r.FontType.CIDFONTTYPE0C:r.FontType.CIDFONTTYPE0;case"OpenType":return r.FontType.OPENTYPE;case"TrueType":return r.FontType.TRUETYPE;case"CIDFontType2":return r.FontType.CIDFONTTYPE2;case"MMType1":return r.FontType.MMTYPE1;case"Type0":return r.FontType.TYPE0;default:return r.FontType.UNKNOWN}}function v(e,t){if(void 0!==t[e])return e;var a=(0,c.getUnicodeForGlyph)(e,t);if(-1!==a)for(var i in t)if(t[i]===a)return i;(0,r.info)("Unable to recover a standard glyph name for: "+e);return e}var w=function(){function e(e,t,a,r,i,n,s,o){this.fontChar=e;this.unicode=t;this.accent=a;this.width=r;this.vmetric=i;this.operatorListId=n;this.isSpace=s;this.isInFont=o}e.prototype.matchesForCache=function(e,t,a,r,i,n,s,o){return this.fontChar===e&&this.unicode===t&&this.accent===a&&this.width===r&&this.vmetric===i&&this.operatorListId===n&&this.isSpace===s&&this.isInFont===o};return e}(),k=function(){function e(e=[]){this._map=e}e.prototype={get length(){return this._map.length},forEach(e){for(var t in this._map)e(t,this._map[t].charCodeAt(0))},has(e){return void 0!==this._map[e]},get(e){return this._map[e]},charCodeOf(e){const t=this._map;if(t.length<=65536)return t.indexOf(e);for(const a in t)if(t[a]===e)return 0|a;return-1},amend(e){for(var t in e)this._map[t]=e[t]}};return e}();t.ToUnicodeMap=k;var S=function(){function e(e,t){this.firstChar=e;this.lastChar=t}e.prototype={get length(){return this.lastChar+1-this.firstChar},forEach(e){for(var t=this.firstChar,a=this.lastChar;t<=a;t++)e(t,t)},has(e){return this.firstChar<=e&&e<=this.lastChar},get(e){if(this.firstChar<=e&&e<=this.lastChar)return String.fromCharCode(e)},charCodeOf(e){return Number.isInteger(e)&&e>=this.firstChar&&e<=this.lastChar?e:-1},amend(e){(0,r.unreachable)("Should not call amend()")}};return e}();t.IdentityToUnicodeMap=S;var C=function(){function e(e,t,a){e[t]=a>>8&255;e[t+1]=255&a}function t(e,t,a){e[t]=a>>24&255;e[t+1]=a>>16&255;e[t+2]=a>>8&255;e[t+3]=255&a}function a(e,t,a){var r,i;if(a instanceof Uint8Array)e.set(a,t);else if("string"==typeof a)for(r=0,i=a.length;r<i;r++)e[t++]=255&a.charCodeAt(r);else for(r=0,i=a.length;r<i;r++)e[t++]=255&a[r]}function i(e){this.sfnt=e;this.tables=Object.create(null)}i.getSearchParams=function(e,t){for(var a=1,r=0;(a^e)>a;){a<<=1;r++}var i=a*t;return{range:i,entry:r,rangeShift:t*e-i}};i.prototype={toArray:function(){var n=this.sfnt,s=this.tables,o=Object.keys(s);o.sort();var c,h,u,d,f,g=o.length,m=12+16*g,p=[m];for(c=0;c<g;c++){m+=((d=s[o[c]]).length+3&-4)>>>0;p.push(m)}var b=new Uint8Array(m);for(c=0;c<g;c++){d=s[o[c]];a(b,p[c],d)}"true"===n&&(n=(0,r.string32)(65536));b[0]=255&n.charCodeAt(0);b[1]=255&n.charCodeAt(1);b[2]=255&n.charCodeAt(2);b[3]=255&n.charCodeAt(3);e(b,4,g);var y=i.getSearchParams(g,16);e(b,6,y.range);e(b,8,y.entry);e(b,10,y.rangeShift);m=12;for(c=0;c<g;c++){f=o[c];b[m]=255&f.charCodeAt(0);b[m+1]=255&f.charCodeAt(1);b[m+2]=255&f.charCodeAt(2);b[m+3]=255&f.charCodeAt(3);var v=0;for(h=p[c],u=p[c+1];h<u;h+=4){v=v+(0,l.readUint32)(b,h)>>>0}t(b,m+4,v);t(b,m+8,p[c]);t(b,m+12,s[f].length);m+=16}return b},addTable:function(e,t){if(e in this.tables)throw new Error("Table "+e+" already exists");this.tables[e]=t}};return i}(),x=function(){function e(e,t,a){var i;this.name=e;this.loadedName=a.loadedName;this.isType3Font=a.isType3Font;this.sizes=[];this.missingFile=!1;this.glyphCache=Object.create(null);this.isSerifFont=!!(a.flags&m.Serif);this.isSymbolicFont=!!(a.flags&m.Symbolic);this.isMonospace=!!(a.flags&m.FixedPitch);var n=a.type,s=a.subtype;this.type=n;this.subtype=s;let o="sans-serif";this.isMonospace?o="monospace":this.isSerifFont&&(o="serif");this.fallbackName=o;this.differences=a.differences;this.widths=a.widths;this.defaultWidth=a.defaultWidth;this.composite=a.composite;this.wideChars=a.wideChars;this.cMap=a.cMap;this.ascent=a.ascent/1e3;this.descent=a.descent/1e3;this.fontMatrix=a.fontMatrix;this.bbox=a.bbox;this.defaultEncoding=a.defaultEncoding;this.toUnicode=a.toUnicode;this.fallbackToUnicode=a.fallbackToUnicode||new k;this.toFontChar=[];if("Type3"!==a.type){this.cidEncoding=a.cidEncoding;this.vertical=a.vertical;if(this.vertical){this.vmetrics=a.vmetrics;this.defaultVMetrics=a.defaultVMetrics}if(t&&!t.isEmpty){[n,s]=function(e,{type:t,subtype:a,composite:i}){let n,s;if(function(e){var t=e.peekBytes(4);return 65536===(0,l.readUint32)(t,0)||"true"===(0,r.bytesToString)(t)}(e)||I(e))n=i?"CIDFontType2":"TrueType";else if(function(e){var t=e.peekBytes(4);return"OTTO"===(0,r.bytesToString)(t)}(e))n=i?"CIDFontType2":"OpenType";else if(function(e){var t=e.peekBytes(2);if(37===t[0]&&33===t[1])return!0;if(128===t[0]&&1===t[1])return!0;return!1}(e))n=i?"CIDFontType0":"MMType1"===t?"MMType1":"Type1";else if(function(e){const t=e.peekBytes(4);if(t[0]>=1&&t[3]>=1&&t[3]<=4)return!0;return!1}(e))if(i){n="CIDFontType0";s="CIDFontType0C"}else{n="MMType1"===t?"MMType1":"Type1";s="Type1C"}else{(0,r.warn)("getFontFileType: Unable to detect correct font file Type/Subtype.");n=t;s=a}return[n,s]}(t,a);n===this.type&&s===this.subtype||(0,r.info)("Inconsistent font file Type/SubType, expected: "+`${this.type}/${this.subtype} but found: ${n}/${s}.`);try{var c;switch(n){case"MMType1":(0,r.info)("MMType1 font ("+e+"), falling back to Type1.");case"Type1":case"CIDFontType0":this.mimetype="font/opentype";var h="Type1C"===s||"CIDFontType0C"===s?new T(t,a):new F(e,t,a);b(a);c=this.convert(e,h,a);break;case"OpenType":case"TrueType":case"CIDFontType2":this.mimetype="font/opentype";c=this.checkAndRepair(e,t,a);if(this.isOpenType){b(a);n="OpenType"}break;default:throw new r.FormatError(`Font ${n} is not supported`)}}catch(e){(0,r.warn)(e);this.fallbackToSystemFont();return}this.data=c;this.fontType=y(n,s);this.fontMatrix=a.fontMatrix;this.widths=a.widths;this.defaultWidth=a.defaultWidth;this.toUnicode=a.toUnicode;this.encoding=a.baseEncoding;this.seacMap=a.seacMap}else{t&&(0,r.warn)('Font file is empty in "'+e+'" ('+this.loadedName+")");this.fallbackToSystemFont()}}else{for(i=0;i<256;i++)this.toFontChar[i]=this.differences[i]||a.defaultEncoding[i];this.fontType=r.FontType.TYPE3}}e.getFontID=(t=1,function(){return String(t++)});var t;function a(e,t){return(e<<8)+t}function f(e,t){var a=(e<<8)+t;return 32768&a?a-65536:a}function x(e){return String.fromCharCode(e>>8&255,255&e)}function A(e){e>32767?e=32767:e<-32768&&(e=-32768);return String.fromCharCode(e>>8&255,255&e)}function I(e){const t=e.peekBytes(4);return"ttcf"===(0,r.bytesToString)(t)}function E(e,t,a){for(var r,i=[],n=0,s=e.length;n<s;n++)-1!==(r=(0,c.getUnicodeForGlyph)(e[n],t))&&(i[n]=r);for(var o in a)-1!==(r=(0,c.getUnicodeForGlyph)(a[o],t))&&(i[+o]=r);return i}function O(e,t,a){var i=Object.create(null),n=[],s=0,o=g[s][0],c=g[s][1];for(var l in e){var h=e[l|=0];if(t(h)){if(o>c){if(++s>=g.length){(0,r.warn)("Ran out of space in font private use area.");break}o=g[s][0];c=g[s][1]}var u=o++;0===h&&(h=a);i[u]=h;n[l]=u}}return{toFontChar:n,charCodeToGlyphId:i,nextAvailableFontCharCode:o}}function P(e,t){var a,i,n,s,o=function(e,t){var a=[];for(var r in e)e[r]>=t||a.push({fontCharCode:0|r,glyphId:e[r]});0===a.length&&a.push({fontCharCode:0,glyphId:0});a.sort((function(e,t){return e.fontCharCode-t.fontCharCode}));for(var i=[],n=a.length,s=0;s<n;){var o=a[s].fontCharCode,c=[a[s].glyphId];++s;for(var l=o;s<n&&l+1===a[s].fontCharCode;){c.push(a[s].glyphId);++s;if(65535===++l)break}i.push([o,l,c])}return i}(e,t),c=o[o.length-1][1]>65535?2:1,l="\0\0"+x(c)+"\0\0"+(0,r.string32)(4+8*c);for(a=o.length-1;a>=0&&!(o[a][0]<=65535);--a);var h=a+1;o[a][0]<65535&&65535===o[a][1]&&(o[a][1]=65534);var u,d,f,g,m=o[a][1]<65535?1:0,p=h+m,b=C.getSearchParams(p,2),y="",v="",w="",k="",S="",A=0;for(a=0,i=h;a<i;a++){d=(u=o[a])[0];f=u[1];y+=x(d);v+=x(f);var I=!0;for(n=1,s=(g=u[2]).length;n<s;++n)if(g[n]!==g[n-1]+1){I=!1;break}if(I){w+=x(g[0]-d&65535);k+=x(0)}else{var F=2*(p-a)+2*A;A+=f-d+1;w+=x(0);k+=x(F);for(n=0,s=g.length;n<s;++n)S+=x(g[n])}}if(m>0){v+="ÿÿ";y+="ÿÿ";w+="\0";k+="\0\0"}var T="\0\0"+x(2*p)+x(b.range)+x(b.entry)+x(b.rangeShift)+v+"\0\0"+y+w+k+S,E="",O="";if(c>1){l+="\0\0\n"+(0,r.string32)(4+8*c+4+T.length);E="";for(a=0,i=o.length;a<i;a++){d=(u=o[a])[0];var P=(g=u[2])[0];for(n=1,s=g.length;n<s;++n)if(g[n]!==g[n-1]+1){f=u[0]+n-1;E+=(0,r.string32)(d)+(0,r.string32)(f)+(0,r.string32)(P);d=f+1;P=g[n]}E+=(0,r.string32)(d)+(0,r.string32)(u[1])+(0,r.string32)(P)}O="\0\f\0\0"+(0,r.string32)(E.length+16)+"\0\0\0\0"+(0,r.string32)(E.length/12)}return l+"\0"+x(T.length+4)+T+O+E}function B(e,t,a){a=a||{unitsPerEm:0,yMax:0,yMin:0,ascent:0,descent:0};var i=0,n=0,s=0,o=0,l=null,h=0;if(t){for(var u in t){(l>(u|=0)||!l)&&(l=u);h<u&&(h=u);var d=(0,c.getUnicodeRangeFor)(u);if(d<32)i|=1<<d;else if(d<64)n|=1<<d-32;else if(d<96)s|=1<<d-64;else{if(!(d<123))throw new r.FormatError("Unicode ranges Bits > 123 are reserved for internal usage");o|=1<<d-96}}h>65535&&(h=65535)}else{l=0;h=255}var f=e.bbox||[0,0,0,0],g=a.unitsPerEm||1/(e.fontMatrix||r.FONT_IDENTITY_MATRIX)[0],m=e.ascentScaled?1:g/1e3,p=a.ascent||Math.round(m*(e.ascent||f[3])),b=a.descent||Math.round(m*(e.descent||f[1]));b>0&&e.descent>0&&f[1]<0&&(b=-b);var y=a.yMax||p,v=-a.yMin||-b;return"\0$ô\0\0\0»\0\0\0»\0\0ß\x001\0\0\0\0"+String.fromCharCode(e.fixedPitch?9:0)+"\0\0\0\0\0\0"+(0,r.string32)(i)+(0,r.string32)(n)+(0,r.string32)(s)+(0,r.string32)(o)+"*21*"+x(e.italicAngle?1:0)+x(l||e.firstChar)+x(h||e.lastChar)+x(p)+x(b)+"\0d"+x(y)+x(v)+"\0\0\0\0\0\0\0\0"+x(e.xHeight)+x(e.capHeight)+x(0)+x(l||e.firstChar)+"\0"}function D(e){var t=Math.floor(65536*e.italicAngle);return"\0\0\0"+(0,r.string32)(t)+"\0\0\0\0"+(0,r.string32)(e.fixedPitch)+"\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"}function N(e,t){t||(t=[[],[]]);var a,r,i,n,s,o=[t[0][0]||"Original licence",t[0][1]||e,t[0][2]||"Unknown",t[0][3]||"uniqueID",t[0][4]||e,t[0][5]||"Version 0.11",t[0][6]||"",t[0][7]||"Unknown",t[0][8]||"Unknown",t[0][9]||"Unknown"],c=[];for(a=0,r=o.length;a<r;a++){var l=[];for(i=0,n=(s=t[1][a]||o[a]).length;i<n;i++)l.push(x(s.charCodeAt(i)));c.push(l.join(""))}var h=[o,c],u=["\0","\0"],d=["\0\0","\0"],f=["\0\0","\t"],g=o.length*u.length,m="\0\0"+x(g)+x(12*g+6),p=0;for(a=0,r=u.length;a<r;a++){var b=h[a];for(i=0,n=b.length;i<n;i++){s=b[i];m+=u[a]+d[a]+f[a]+x(i)+x(s.length)+x(p);p+=s.length}}return m+=o.join("")+c.join("")}e.prototype={name:null,font:null,mimetype:null,encoding:null,disableFontFace:!1,get renderer(){var e=h.FontRendererFactory.create(this,!0);return(0,r.shadow)(this,"renderer",e)},exportData:function(){var e={};for(var t in this)this.hasOwnProperty(t)&&(e[t]=this[t]);return e},fallbackToSystemFont:function(){this.missingFile=!0;var e,t,a=this.name,i=this.type,l=this.subtype;let h=a.replace(/[,_]/g,"-").replace(/\s/g,"");var u=(0,o.getStdFontMap)(),d=(0,o.getNonStdFontMap)(),f=!!u[h]||!(!d[h]||!u[d[h]]);h=u[h]||d[h]||h;this.bold=-1!==h.search(/bold/gi);this.italic=-1!==h.search(/oblique/gi)||-1!==h.search(/italic/gi);this.black=-1!==a.search(/Black/g);this.remeasure=Object.keys(this.widths).length>0;if(f&&"CIDFontType2"===i&&this.cidEncoding.startsWith("Identity-")){const t=(0,o.getGlyphMapForStandardFonts)(),r=[];for(e in t)r[+e]=t[e];if(/Arial-?Black/i.test(a)){var g=(0,o.getSupplementalGlyphMapForArialBlack)();for(e in g)r[+e]=g[e]}else if(/Calibri/i.test(a)){const t=(0,o.getSupplementalGlyphMapForCalibri)();for(e in t)r[+e]=t[e]}this.toUnicode instanceof S||this.toUnicode.forEach((function(e,t){r[+e]=t}));this.toFontChar=r;this.toUnicode=new k(r)}else if(/Symbol/i.test(h))this.toFontChar=E(s.SymbolSetEncoding,(0,n.getGlyphsUnicode)(),this.differences);else if(/Dingbats/i.test(h)){/Wingdings/i.test(a)&&(0,r.warn)("Non-embedded Wingdings font, falling back to ZapfDingbats.");this.toFontChar=E(s.ZapfDingbatsEncoding,(0,n.getDingbatsGlyphsUnicode)(),this.differences)}else if(f)this.toFontChar=E(this.defaultEncoding,(0,n.getGlyphsUnicode)(),this.differences);else{const r=(0,n.getGlyphsUnicode)(),i=[];this.toUnicode.forEach((e,a)=>{if(!this.composite){var n=this.differences[e]||this.defaultEncoding[e];-1!==(t=(0,c.getUnicodeForGlyph)(n,r))&&(a=t)}i[+e]=a});if(this.composite&&this.toUnicode instanceof S&&/Verdana/i.test(a)){const t=(0,o.getGlyphMapForStandardFonts)();for(e in t)i[+e]=t[e]}this.toFontChar=i}this.loadedName=h.split("-")[0];this.fontType=y(i,l)},checkAndRepair:function(e,t,o){const c=["OS/2","cmap","head","hhea","hmtx","maxp","name","post","loca","glyf","fpgm","prep","cvt ","CFF "];function l(e,a){const r=Object.create(null);r["OS/2"]=null;r.cmap=null;r.head=null;r.hhea=null;r.hmtx=null;r.maxp=null;r.name=null;r.post=null;for(let e=0;e<a;e++){const e=h(t);c.includes(e.tag)&&(0!==e.length&&(r[e.tag]=e))}return r}function h(e){var t=(0,r.bytesToString)(e.getBytes(4)),a=e.getInt32()>>>0,i=e.getInt32()>>>0,n=e.getInt32()>>>0,s=e.pos;e.pos=e.start?e.start:0;e.skip(i);var o=e.getBytes(n);e.pos=s;if("head"===t){o[8]=o[9]=o[10]=o[11]=0;o[17]|=32}return{tag:t,checksum:a,length:n,offset:i,data:o}}function g(e){return{version:(0,r.bytesToString)(e.getBytes(4)),numTables:e.getUint16(),searchRange:e.getUint16(),entrySelector:e.getUint16(),rangeShift:e.getUint16()}}function m(e,t,a,r,i,n){var s={length:0,sizeOfInstructions:0};if(a-t<=12)return s;var o=e.subarray(t,a),c=f(o[0],o[1]);if(c<0){!function(e,t,a){e[t+1]=a;e[t]=a>>>8}(o,0,c=-1);r.set(o,i);s.length=o.length;return s}var l,h=10,u=0;for(l=0;l<c;l++){u=(o[h]<<8|o[h+1])+1;h+=2}var d=h,g=o[h]<<8|o[h+1];s.sizeOfInstructions=g;var m=h+=2+g,p=0;for(l=0;l<u;l++){var b=o[h++];192&b&&(o[h-1]=63&b);let e=2;2&b?e=1:16&b&&(e=0);let t=2;4&b?t=1:32&b&&(t=0);const a=e+t;p+=a;if(8&b){var y=o[h++];l+=y;p+=y*a}}if(0===p)return s;var v=h+p;if(v>o.length)return s;if(!n&&g>0){r.set(o.subarray(0,d),i);r.set([0,0],i+d);r.set(o.subarray(m,v),i+d+2);v-=g;o.length-v>3&&(v=v+3&-4);s.length=v;return s}if(o.length-v>3){v=v+3&-4;r.set(o.subarray(0,v),i);s.length=v;return s}r.set(o,i);s.length=o.length;return s}function y(e){var a=(t.start?t.start:0)+e.offset;t.pos=a;var i=[[],[]],n=e.length,s=a+n;if(0!==t.getUint16()||n<6)return i;var o,c,l=t.getUint16(),h=t.getUint16(),u=[];for(o=0;o<l&&t.pos+12<=s;o++){var d={platform:t.getUint16(),encoding:t.getUint16(),language:t.getUint16(),name:t.getUint16(),length:t.getUint16(),offset:t.getUint16()};(1===d.platform&&0===d.encoding&&0===d.language||3===d.platform&&1===d.encoding&&1033===d.language)&&u.push(d)}for(o=0,c=u.length;o<c;o++){var f=u[o];if(!(f.length<=0)){var g=a+h+f.offset;if(!(g+f.length>s)){t.pos=g;var m=f.name;if(f.encoding){for(var p="",b=0,y=f.length;b<y;b+=2)p+=String.fromCharCode(t.getUint16());i[1][m]=p}else i[0][m]=(0,r.bytesToString)(t.getBytes(f.length))}}}return i}var w=[0,0,0,0,0,0,0,0,-2,-2,-2,-2,0,0,-2,-5,-1,-1,-1,-1,-1,-1,-1,-1,0,0,-1,0,-1,-1,-1,-1,1,-1,-999,0,1,0,-1,-2,0,-1,-2,-1,-1,0,-1,-1,0,0,-999,-999,-1,-1,-1,-1,-2,-999,-2,-2,-999,0,-2,-2,0,0,-2,0,-2,0,0,0,-2,-1,-1,1,1,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,-1,0,-1,-1,0,-999,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,-2,-999,-999,-999,-999,-999,-1,-1,-2,-2,0,0,0,0,-1,-1,-999,-2,-2,0,0,-1,-2,-2,0,0,0,-1,-1,-1,-2];function k(e,t){for(var a,i,n,s,o,c=e.data,l=0,h=0,u=0,d=[],f=[],g=[],m=t.tooComplexToFollowFunctions,p=!1,b=0,y=0,v=c.length;l<v;){var k=c[l++];if(64===k){i=c[l++];if(p||y)l+=i;else for(a=0;a<i;a++)d.push(c[l++])}else if(65===k){i=c[l++];if(p||y)l+=2*i;else for(a=0;a<i;a++){n=c[l++];d.push(n<<8|c[l++])}}else if(176==(248&k)){i=k-176+1;if(p||y)l+=i;else for(a=0;a<i;a++)d.push(c[l++])}else if(184==(248&k)){i=k-184+1;if(p||y)l+=2*i;else for(a=0;a<i;a++){n=c[l++];d.push(n<<8|c[l++])}}else if(43!==k||m)if(44!==k||m){if(45===k)if(p){p=!1;h=l}else{if(!(o=f.pop())){(0,r.warn)("TT: ENDF bad stack");t.hintsValid=!1;return}s=g.pop();c=o.data;l=o.i;t.functionsStackDeltas[s]=d.length-o.stackTop}else if(137===k){if(p||y){(0,r.warn)("TT: nested IDEFs not allowed");m=!0}p=!0;u=l}else if(88===k)++b;else if(27===k)y=b;else if(89===k){y===b&&(y=0);--b}else if(28===k&&!p&&!y){var S=d[d.length-1];S>0&&(l+=S-1)}}else{if(p||y){(0,r.warn)("TT: nested FDEFs not allowed");m=!0}p=!0;u=l;s=d.pop();t.functionsDefined[s]={data:c,i:l}}else if(!p&&!y){s=d[d.length-1];if(isNaN(s))(0,r.info)("TT: CALL empty stack (or invalid entry).");else{t.functionsUsed[s]=!0;if(s in t.functionsStackDeltas){const e=d.length+t.functionsStackDeltas[s];if(e<0){(0,r.warn)("TT: CALL invalid functions stack delta.");t.hintsValid=!1;return}d.length=e}else if(s in t.functionsDefined&&!g.includes(s)){f.push({data:c,i:l,stackTop:d.length-1});g.push(s);if(!(o=t.functionsDefined[s])){(0,r.warn)("TT: CALL non-existent function");t.hintsValid=!1;return}c=o.data;l=o.i}}}if(!p&&!y){let e=0;k<=142?e=w[k]:k>=192&&k<=223?e=-1:k>=224&&(e=-2);if(k>=113&&k<=117){i=d.pop();isNaN(i)||(e=2*-i)}for(;e<0&&d.length>0;){d.pop();e++}for(;e>0;){d.push(NaN);e--}}}t.tooComplexToFollowFunctions=m;var C=[c];l>c.length&&C.push(new Uint8Array(l-c.length));if(u>h){(0,r.warn)("TT: complementing a missing function tail");C.push(new Uint8Array([34,45]))}!function(e,t){if(t.length>1){var a,r,i=0;for(a=0,r=t.length;a<r;a++)i+=t[a].length;i=i+3&-4;var n=new Uint8Array(i),s=0;for(a=0,r=t.length;a<r;a++){n.set(t[a],s);s+=t[a].length}e.data=n;e.length=i}}(e,C)}let S,x,A,F;if(I(t=new d.Stream(new Uint8Array(t.getBytes())))){const e=function(e,t){const{numFonts:a,offsetTable:i}=function(e){const t=(0,r.bytesToString)(e.getBytes(4));(0,r.assert)("ttcf"===t,"Must be a TrueType Collection font.");const a=e.getUint16(),i=e.getUint16(),n=e.getInt32()>>>0,s=[];for(let t=0;t<n;t++)s.push(e.getInt32()>>>0);const o={ttcTag:t,majorVersion:a,minorVersion:i,numFonts:n,offsetTable:s};switch(a){case 1:return o;case 2:o.dsigTag=e.getInt32()>>>0;o.dsigLength=e.getInt32()>>>0;o.dsigOffset=e.getInt32()>>>0;return o}throw new r.FormatError(`Invalid TrueType Collection majorVersion: ${a}.`)}(e);for(let n=0;n<a;n++){e.pos=(e.start||0)+i[n];const a=g(e),s=l(0,a.numTables);if(!s.name)throw new r.FormatError('TrueType Collection font must contain a "name" table.');const o=y(s.name);for(let e=0,r=o.length;e<r;e++)for(let r=0,i=o[e].length;r<i;r++){const i=o[e][r];if(i&&i.replace(/\s/g,"")===t)return{header:a,tables:s}}}throw new r.FormatError(`TrueType Collection does not contain "${t}" font.`)}(t,this.name);S=e.header;x=e.tables}else{S=g(t);x=l(0,S.numTables)}var E=!x["CFF "];if(E){if(!x.loca)throw new r.FormatError('Required "loca" table is not found');if(!x.glyf){(0,r.warn)('Required "glyf" table is not found -- trying to recover.');x.glyf={tag:"glyf",data:new Uint8Array(0)}}this.isOpenType=!1}else{const t=o.composite&&((o.cidToGidMap||[]).length>0||!(o.cMap instanceof u.IdentityCMap));if("OTTO"===S.version&&!t||!x.head||!x.hhea||!x.maxp||!x.post){F=new d.Stream(x["CFF "].data);A=new T(F,o);b(o);return this.convert(e,A,o)}delete x.glyf;delete x.loca;delete x.fpgm;delete x.prep;delete x["cvt "];this.isOpenType=!0}if(!x.maxp)throw new r.FormatError('Required "maxp" table is not found');t.pos=(t.start||0)+x.maxp.offset;var M=t.getInt32();const L=t.getUint16();let R=L+1,U=!0;if(R>65535){U=!1;R=L;(0,r.warn)("Not enough space in glyfs to duplicate first glyph.")}var q=0,j=0;if(M>=65536&&x.maxp.length>=22){t.pos+=8;if(t.getUint16()>2){x.maxp.data[14]=0;x.maxp.data[15]=2}t.pos+=4;q=t.getUint16();t.pos+=4;j=t.getUint16()}x.maxp.data[4]=R>>8;x.maxp.data[5]=255&R;var _=function(e,t,a,i){var n={functionsDefined:[],functionsUsed:[],functionsStackDeltas:[],tooComplexToFollowFunctions:!1,hintsValid:!0};e&&k(e,n);t&&k(t,n);e&&function(e,t){if(!e.tooComplexToFollowFunctions)if(e.functionsDefined.length>t){(0,r.warn)("TT: more functions defined than expected");e.hintsValid=!1}else for(var a=0,i=e.functionsUsed.length;a<i;a++){if(a>t){(0,r.warn)("TT: invalid function id: "+a);e.hintsValid=!1;return}if(e.functionsUsed[a]&&!e.functionsDefined[a]){(0,r.warn)("TT: undefined function: "+a);e.hintsValid=!1;return}}}(n,i);if(a&&1&a.length){var s=new Uint8Array(a.length+1);s.set(a.data);a.data=s}return n.hintsValid}(x.fpgm,x.prep,x["cvt "],q);if(!_){delete x.fpgm;delete x.prep;delete x["cvt "]}!function(e,t,a,i,n){if(t){e.pos=(e.start?e.start:0)+t.offset;e.pos+=4;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=2;e.pos+=8;e.pos+=2;var s=e.getUint16();if(s>i){(0,r.info)("The numOfMetrics ("+s+") should not be greater than the numGlyphs ("+i+")");s=i;t.data[34]=(65280&s)>>8;t.data[35]=255&s}var o=i-s-(a.length-4*s>>1);if(o>0){var c=new Uint8Array(a.length+2*o);c.set(a.data);if(n){c[a.length]=a.data[2];c[a.length+1]=a.data[3]}a.data=c}}else a&&(a.data=null)}(t,x.hhea,x.hmtx,R,U);if(!x.head)throw new r.FormatError('Required "head" table is not found');!function(e,t,i){var n,s,o,c,l=e.data,h=(n=l[0],s=l[1],o=l[2],c=l[3],(n<<24)+(s<<16)+(o<<8)+c);if(h>>16!=1){(0,r.info)("Attempting to fix invalid version in head table: "+h);l[0]=0;l[1]=1;l[2]=0;l[3]=0}var u=a(l[50],l[51]);if(u<0||u>1){(0,r.info)("Attempting to fix invalid indexToLocFormat in head table: "+u);var d=t+1;if(i===d<<1){l[50]=0;l[51]=0}else{if(i!==d<<2)throw new r.FormatError("Could not fix indexToLocFormat: "+u);l[50]=0;l[51]=1}}}(x.head,L,E?x.loca.length:0);var z=Object.create(null);if(E){var H=a(x.head.data[50],x.head.data[51]),G=function(e,t,a,r,i,n,s){var o,c,l;if(r){o=4;c=function(e,t){return e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3]};l=function(e,t,a){e[t]=a>>>24&255;e[t+1]=a>>16&255;e[t+2]=a>>8&255;e[t+3]=255&a}}else{o=2;c=function(e,t){return e[t]<<9|e[t+1]<<1};l=function(e,t,a){e[t]=a>>9&255;e[t+1]=a>>1&255}}var h=n?a+1:a,u=o*(1+h),d=new Uint8Array(u);d.set(e.data.subarray(0,u));e.data=d;var f,g,p=t.data,b=p.length,y=new Uint8Array(b),v=c(d,0),w=0,k=Object.create(null);l(d,0,w);for(f=0,g=o;f<a;f++,g+=o){var S=c(d,g);0===S&&(S=v);S>b&&(b+3&-4)===S&&(S=b);S>b&&(v=S);var C=m(p,v,S,y,w,i),x=C.length;0===x&&(k[f]=!0);C.sizeOfInstructions>s&&(s=C.sizeOfInstructions);l(d,g,w+=x);v=S}if(0===w){var A=new Uint8Array([0,1,0,0,0,0,0,0,0,0,0,0,0,0,49,0]);for(f=0,g=o;f<h;f++,g+=o)l(d,g,A.length);t.data=A}else if(n){var I=c(d,o);if(y.length>I+w)t.data=y.subarray(0,I+w);else{t.data=new Uint8Array(I+w);t.data.set(y.subarray(0,w))}t.data.set(y.subarray(0,I),w);l(e.data,d.length-o,w+I)}else t.data=y.subarray(0,w);return{missingGlyphs:k,maxSizeOfInstructions:s}}(x.loca,x.glyf,L,H,_,U,j);z=G.missingGlyphs;if(M>=65536&&x.maxp.length>=22){x.maxp.data[26]=G.maxSizeOfInstructions>>8;x.maxp.data[27]=255&G.maxSizeOfInstructions}}if(!x.hhea)throw new r.FormatError('Required "hhea" table is not found');if(0===x.hhea.data[10]&&0===x.hhea.data[11]){x.hhea.data[10]=255;x.hhea.data[11]=255}var W={unitsPerEm:a(x.head.data[18],x.head.data[19]),yMax:a(x.head.data[42],x.head.data[43]),yMin:f(x.head.data[38],x.head.data[39]),ascent:a(x.hhea.data[4],x.hhea.data[5]),descent:f(x.hhea.data[6],x.hhea.data[7])};this.ascent=W.ascent/W.unitsPerEm;this.descent=W.descent/W.unitsPerEm;x.post&&function(e,a,i){var n=(t.start?t.start:0)+e.offset;t.pos=n;var s,o=n+e.length,c=t.getInt32();t.getBytes(28);var l,h=!0;switch(c){case 65536:s=p;break;case 131072:var u=t.getUint16();if(u!==i){h=!1;break}var d=[];for(l=0;l<u;++l){var f=t.getUint16();if(f>=32768){h=!1;break}d.push(f)}if(!h)break;for(var g=[],m=[];t.pos<o;){var b=t.getByte();m.length=b;for(l=0;l<b;++l)m[l]=String.fromCharCode(t.getByte());g.push(m.join(""))}s=[];for(l=0;l<u;++l){var y=d[l];y<258?s.push(p[y]):s.push(g[y-258])}break;case 196608:break;default:(0,r.warn)("Unknown/unsupported post table version "+c);h=!1;a.defaultEncoding&&(s=a.defaultEncoding)}a.glyphNames=s}(x.post,o,L);x.post={tag:"post",data:D(o)};var X,V=[];function K(e){return!z[e]}if(o.composite){var Y=o.cidToGidMap||[],$=0===Y.length;o.cMap.forEach((function(e,t){if(t>65535)throw new r.FormatError("Max size of CID is 65,535");var a=-1;$?a=t:void 0!==Y[t]&&(a=Y[t]);a>=0&&a<L&&K(a)&&(V[e]=a)}))}else{var J=function(e,t,a,i){if(!e){(0,r.warn)("No cmap table available.");return{platformId:-1,encodingId:-1,mappings:[],hasShortCmap:!1}}var n,s=(t.start?t.start:0)+e.offset;t.pos=s;t.getUint16();for(var o,c=t.getUint16(),l=!1,h=0;h<c;h++){var u=t.getUint16(),d=t.getUint16(),f=t.getInt32()>>>0,g=!1;if(!o||o.platformId!==u||o.encodingId!==d){if(0===u&&0===d)g=!0;else if(1===u&&0===d)g=!0;else if(3!==u||1!==d||!i&&o){if(a&&3===u&&0===d){g=!0;l=!0}}else{g=!0;a||(l=!0)}g&&(o={platformId:u,encodingId:d,offset:f});if(l)break}}o&&(t.pos=s+o.offset);if(!o||-1===t.peekByte()){(0,r.warn)("Could not find a preferred cmap table.");return{platformId:-1,encodingId:-1,mappings:[],hasShortCmap:!1}}var m=t.getUint16();t.getUint16();t.getUint16();var p,b,y=!1,v=[];if(0===m){for(p=0;p<256;p++){var w=t.getByte();w&&v.push({charCode:p,glyphId:w})}y=!0}else if(4===m){var k=t.getUint16()>>1;t.getBytes(6);var S,C=[];for(S=0;S<k;S++)C.push({end:t.getUint16()});t.getUint16();for(S=0;S<k;S++)C[S].start=t.getUint16();for(S=0;S<k;S++)C[S].delta=t.getUint16();var x=0;for(S=0;S<k;S++){n=C[S];var A=t.getUint16();if(A){var I=(A>>1)-(k-S);n.offsetIndex=I;x=Math.max(x,I+n.end-n.start+1)}else n.offsetIndex=-1}var F=[];for(p=0;p<x;p++)F.push(t.getUint16());for(S=0;S<k;S++){s=(n=C[S]).start;var T=n.end,E=n.delta;I=n.offsetIndex;for(p=s;p<=T;p++)if(65535!==p){b=(b=I<0?p:F[I+p-s])+E&65535;v.push({charCode:p,glyphId:b})}}}else{if(6!==m){(0,r.warn)("cmap table has unsupported format: "+m);return{platformId:-1,encodingId:-1,mappings:[],hasShortCmap:!1}}var O=t.getUint16(),P=t.getUint16();for(p=0;p<P;p++){b=t.getUint16();var B=O+p;v.push({charCode:B,glyphId:b})}}v.sort((function(e,t){return e.charCode-t.charCode}));for(h=1;h<v.length;h++)if(v[h-1].charCode===v[h].charCode){v.splice(h,1);h--}return{platformId:o.platformId,encodingId:o.encodingId,mappings:v,hasShortCmap:y}}(x.cmap,t,this.isSymbolicFont,o.hasEncoding),Z=J.platformId,Q=J.encodingId,ee=J.mappings,te=ee.length;if(o.hasEncoding&&(3===Z&&1===Q||1===Z&&0===Q)||-1===Z&&-1===Q&&(0,s.getEncoding)(o.baseEncodingName)){var ae=[];"MacRomanEncoding"!==o.baseEncodingName&&"WinAnsiEncoding"!==o.baseEncodingName||(ae=(0,s.getEncoding)(o.baseEncodingName));var re=(0,n.getGlyphsUnicode)();for(X=0;X<256;X++){var ie,ne;if(ie=this.differences&&X in this.differences?this.differences[X]:X in ae&&""!==ae[X]?ae[X]:s.StandardEncoding[X]){ne=v(ie,re);var se;3===Z&&1===Q?se=re[ne]:1===Z&&0===Q&&(se=s.MacRomanEncoding.indexOf(ne));var oe=!1;for(let e=0;e<te;++e)if(ee[e].charCode===se){V[X]=ee[e].glyphId;oe=!0;break}if(!oe&&o.glyphNames){var ce=o.glyphNames.indexOf(ie);-1===ce&&ne!==ie&&(ce=o.glyphNames.indexOf(ne));ce>0&&K(ce)&&(V[X]=ce)}}}}else if(0===Z&&0===Q)for(let e=0;e<te;++e)V[ee[e].charCode]=ee[e].glyphId;else for(let e=0;e<te;++e){X=ee[e].charCode;3===Z&&X>=61440&&X<=61695&&(X&=255);V[X]=ee[e].glyphId}}0===V.length&&(V[0]=0);let le=R-1;U||(le=0);var he=O(V,K,le);this.toFontChar=he.toFontChar;x.cmap={tag:"cmap",data:P(he.charCodeToGlyphId,R)};x["OS/2"]&&function(e){var t=new d.Stream(e.data),a=t.getUint16();t.getBytes(60);var r=t.getUint16();if(a<4&&768&r)return!1;if(t.getUint16()>t.getUint16())return!1;t.getBytes(6);if(0===t.getUint16())return!1;e.data[8]=e.data[9]=0;return!0}(x["OS/2"])||(x["OS/2"]={tag:"OS/2",data:B(o,he.charCodeToGlyphId,W)});if(!E)try{F=new d.Stream(x["CFF "].data);A=new i.CFFParser(F,o,!0).parse();A.duplicateFirstGlyph();var ue=new i.CFFCompiler(A);x["CFF "].data=ue.compile()}catch(e){(0,r.warn)("Failed to compile font "+o.loadedName)}if(x.name){var de=y(x.name);x.name.data=N(e,de)}else x.name={tag:"name",data:N(this.name)};var fe=new C(S.version);for(var ge in x)fe.addTable(ge,x[ge].data);return fe.toArray()},convert:function(e,t,a){a.fixedPitch=!1;a.builtInEncoding&&function(e,t){if(!e.hasIncludedToUnicodeMap&&!(e.hasEncoding||t===e.defaultEncoding||e.toUnicode instanceof S)){var a=[],r=(0,n.getGlyphsUnicode)();for(var i in t){var s=t[i],o=(0,c.getUnicodeForGlyph)(s,r);-1!==o&&(a[i]=String.fromCharCode(o))}e.toUnicode.amend(a)}}(a,a.builtInEncoding);let i=1;t instanceof T&&(i=t.numGlyphs-1);var o=t.getGlyphMapping(a),l=O(o,t.hasGlyphId.bind(t),i);this.toFontChar=l.toFontChar;var h=t.numGlyphs;function u(e,t){var a=null;for(var r in e)if(t===e[r]){a||(a=[]);a.push(0|r)}return a}function d(e,t){for(var a in e)if(t===e[a])return 0|a;l.charCodeToGlyphId[l.nextAvailableFontCharCode]=t;return l.nextAvailableFontCharCode++}var f=t.seacs;if(f&&f.length){var g=a.fontMatrix||r.FONT_IDENTITY_MATRIX,m=t.getCharset(),p=Object.create(null);for(var b in f){var y=f[b|=0],v=s.StandardEncoding[y[2]],w=s.StandardEncoding[y[3]],k=m.indexOf(v),I=m.indexOf(w);if(!(k<0||I<0)){var F={x:y[0]*g[0]+y[1]*g[2]+g[4],y:y[0]*g[1]+y[1]*g[3]+g[5]},E=u(o,b);if(E)for(var M=0,L=E.length;M<L;M++){var R=E[M],U=l.charCodeToGlyphId,q=d(U,k),j=d(U,I);p[R]={baseFontCharCode:q,accentFontCharCode:j,accentOffset:F}}}}a.seacMap=p}var _=1/(a.fontMatrix||r.FONT_IDENTITY_MATRIX)[0],z=new C("OTTO");z.addTable("CFF ",t.data);z.addTable("OS/2",B(a,l.charCodeToGlyphId));z.addTable("cmap",P(l.charCodeToGlyphId,h));z.addTable("head","\0\0\0\0\0\0\0\0\0\0_<õ\0\0"+A(_)+"\0\0\0\0\v~'\0\0\0\0\v~'\0\0"+A(a.descent)+"ÿ"+A(a.ascent)+x(a.italicAngle?2:0)+"\0\0\0\0\0\0\0");z.addTable("hhea","\0\0\0"+A(a.ascent)+A(a.descent)+"\0\0ÿÿ\0\0\0\0\0\0"+A(a.capHeight)+A(Math.tan(a.italicAngle)*a.xHeight)+"\0\0\0\0\0\0\0\0\0\0\0\0"+x(h));z.addTable("hmtx",function(){for(var e=t.charstrings,a=t.cff?t.cff.widths:null,r="\0\0\0\0",i=1,n=h;i<n;i++){var s=0;if(e){var o=e[i-1];s="width"in o?o.width:0}else a&&(s=Math.ceil(a[i]||0));r+=x(s)+x(0)}return r}());z.addTable("maxp","\0\0P\0"+x(h));z.addTable("name",N(e));z.addTable("post",D(a));return z.toArray()},get spaceWidth(){if("_shadowWidth"in this)return this._shadowWidth;for(var e,t=["space","minus","one","i","I"],a=0,r=t.length;a<r;a++){var i=t[a];if(i in this.widths){e=this.widths[i];break}var s=(0,n.getGlyphsUnicode)()[i],o=0;this.composite&&this.cMap.contains(s)&&(o=this.cMap.lookup(s));!o&&this.toUnicode&&(o=this.toUnicode.charCodeOf(s));o<=0&&(o=s);if(e=this.widths[o])break}e=e||this.defaultWidth;this._shadowWidth=e;return e},charToGlyph:function(e,t){var a,i,n,s=e;this.cMap&&this.cMap.contains(e)&&(s=this.cMap.lookup(e));i=this.widths[s];i=(0,r.isNum)(i)?i:this.defaultWidth;var o=this.vmetrics&&this.vmetrics[s];let l=this.toUnicode.get(e)||this.fallbackToUnicode.get(e)||e;"number"==typeof l&&(l=String.fromCharCode(l));var h=e in this.toFontChar;a=this.toFontChar[e]||e;if(this.missingFile){const t=this.differences[e]||this.defaultEncoding[e];".notdef"!==t&&""!==t||"Type1"!==this.type||(a=32);a=(0,c.mapSpecialUnicodeValues)(a)}this.isType3Font&&(n=a);var u=null;if(this.seacMap&&this.seacMap[e]){h=!0;var d=this.seacMap[e];a=d.baseFontCharCode;u={fontChar:String.fromCodePoint(d.accentFontCharCode),offset:d.accentOffset}}var f="number"==typeof a?String.fromCodePoint(a):"",g=this.glyphCache[e];if(!g||!g.matchesForCache(f,l,u,i,o,n,t,h)){g=new w(f,l,u,i,o,n,t,h);this.glyphCache[e]=g}return g},charsToGlyphs:function(e){var t,a,r,i=this.charsCache;if(i&&(t=i[e]))return t;i||(i=this.charsCache=Object.create(null));t=[];var n,s=e,o=0;if(this.cMap)for(var c=Object.create(null);o<e.length;){this.cMap.readCharCode(e,o,c);r=c.charcode;var l=c.length;o+=l;var h=1===l&&32===e.charCodeAt(o-1);a=this.charToGlyph(r,h);t.push(a)}else for(o=0,n=e.length;o<n;++o){r=e.charCodeAt(o);a=this.charToGlyph(r,32===r);t.push(a)}return i[s]=t},get glyphCacheValues(){return Object.values(this.glyphCache)}};return e}();t.Font=x;var A=function(){function e(e){this.error=e;this.loadedName="g_font_error";this.missingFile=!0}e.prototype={charsToGlyphs:function(){return[]},exportData:function(){return{error:this.error}}};return e}();t.ErrorFont=A;function I(e,t,a){var r,i,o,c=Object.create(null),l=!!(e.flags&m.Symbolic);if(e.baseEncodingName){o=(0,s.getEncoding)(e.baseEncodingName);for(i=0;i<o.length;i++){r=a.indexOf(o[i]);c[i]=r>=0?r:0}}else if(l)for(i in t)c[i]=t[i];else{o=s.StandardEncoding;for(i=0;i<o.length;i++){r=a.indexOf(o[i]);c[i]=r>=0?r:0}}var h,u=e.differences;if(u)for(i in u){var d=u[i];if(-1===(r=a.indexOf(d))){h||(h=(0,n.getGlyphsUnicode)());var f=v(d,h);f!==d&&(r=a.indexOf(f))}c[i]=r>=0?r:0}return c}var F=function(){function e(e,t,a){for(var r,i=e.length,n=t.length,s=i-n,o=a,c=!1;o<s;){r=0;for(;r<n&&e[o+r]===t[r];)r++;if(r>=n){o+=r;for(;o<i&&(0,l.isWhiteSpace)(e[o]);)o++;c=!0;break}o++}return{found:c,length:o}}function t(t,a,i){var n=i.length1,s=(i.length2,a.peekBytes(6)),o=128===s[0]&&1===s[1];if(o){a.skip(6);n=s[5]<<24|s[4]<<16|s[3]<<8|s[2]}var c=function(t,a){var i,n,s,o,c=[101,101,120,101,99],h=t.pos;try{n=(i=t.getBytes(a)).length}catch(e){if(e instanceof l.MissingDataException)throw e}if(n===a&&(s=e(i,c,a-2*c.length)).found&&s.length===a)return{stream:new d.Stream(i),length:a};(0,r.warn)('Invalid "Length1" property in Type1 font -- trying to recover.');t.pos=h;for(;;){if(0===(s=e(t.peekBytes(2048),c,0)).length)break;t.pos+=s.length;if(s.found){o=t.pos-h;break}}t.pos=h;if(o)return{stream:new d.Stream(t.getBytes(o)),length:o};(0,r.warn)('Unable to recover "Length1" property in Type1 font -- using as is.');return{stream:new d.Stream(t.getBytes(a)),length:a}}(a,n);new f.Type1Parser(c.stream,!1,!0).extractFontHeader(i);o&&(s=a.getBytes(6))[5]<<24|s[4]<<16|s[3]<<8|s[2];var h,u=(h=a.getBytes(),{stream:new d.Stream(h),length:h.length}),g=new f.Type1Parser(u.stream,!0,!0).extractFontProgram(i);for(var m in g.properties)i[m]=g.properties[m];var p=g.charstrings,b=this.getType2Charstrings(p),y=this.getType2Subrs(g.subrs);this.charstrings=p;this.data=this.wrap(t,b,this.charstrings,y,i);this.seacs=this.getSeacs(g.charstrings)}t.prototype={get numGlyphs(){return this.charstrings.length+1},getCharset:function(){for(var e=[".notdef"],t=this.charstrings,a=0;a<t.length;a++)e.push(t[a].glyphName);return e},getGlyphMapping:function(e){var t,a=this.charstrings,r=[".notdef"];for(t=0;t<a.length;t++)r.push(a[t].glyphName);var i=e.builtInEncoding;if(i){var n=Object.create(null);for(var s in i)(t=r.indexOf(i[s]))>=0&&(n[s]=t)}return I(e,n,r)},hasGlyphId:function(e){return!(e<0||e>=this.numGlyphs)&&(0===e||this.charstrings[e-1].charstring.length>0)},getSeacs:function(e){var t,a,r=[];for(t=0,a=e.length;t<a;t++){var i=e[t];i.seac&&(r[t+1]=i.seac)}return r},getType2Charstrings:function(e){for(var t=[],a=0,r=e.length;a<r;a++)t.push(e[a].charstring);return t},getType2Subrs:function(e){var t=0,a=e.length;t=a<1133?107:a<33769?1131:32768;var r,i=[];for(r=0;r<t;r++)i.push([11]);for(r=0;r<a;r++)i.push(e[r]);return i},wrap:function(e,t,a,r,n){var s=new i.CFF;s.header=new i.CFFHeader(1,0,4,4);s.names=[e];var o=new i.CFFTopDict;o.setByName("version",391);o.setByName("Notice",392);o.setByName("FullName",393);o.setByName("FamilyName",394);o.setByName("Weight",395);o.setByName("Encoding",null);o.setByName("FontMatrix",n.fontMatrix);o.setByName("FontBBox",n.bbox);o.setByName("charset",null);o.setByName("CharStrings",null);o.setByName("Private",null);s.topDict=o;var c=new i.CFFStrings;c.add("Version 0.11");c.add("See original notice");c.add(e);c.add(e);c.add("Medium");s.strings=c;s.globalSubrIndex=new i.CFFIndex;var l,h,u=t.length,d=[".notdef"];for(l=0;l<u;l++){const e=a[l].glyphName;-1===i.CFFStandardStrings.indexOf(e)&&c.add(e);d.push(e)}s.charset=new i.CFFCharset(!1,0,d);var f=new i.CFFIndex;f.add([139,14]);for(l=0;l<u;l++)f.add(t[l]);s.charStrings=f;var g=new i.CFFPrivateDict;g.setByName("Subrs",null);var m=["BlueValues","OtherBlues","FamilyBlues","FamilyOtherBlues","StemSnapH","StemSnapV","BlueShift","BlueFuzz","BlueScale","LanguageGroup","ExpansionFactor","ForceBold","StdHW","StdVW"];for(l=0,h=m.length;l<h;l++){var p=m[l];if(p in n.privateData){var b=n.privateData[p];if(Array.isArray(b))for(var y=b.length-1;y>0;y--)b[y]-=b[y-1];g.setByName(p,b)}}s.topDict.privateDict=g;var v=new i.CFFIndex;for(l=0,h=r.length;l<h;l++)v.add(r[l]);g.subrsIndex=v;return new i.CFFCompiler(s).compile()}};return t}(),T=function(){function e(e,t){this.properties=t;var a=new i.CFFParser(e,t,!0);this.cff=a.parse();this.cff.duplicateFirstGlyph();var n=new i.CFFCompiler(this.cff);this.seacs=this.cff.seacs;try{this.data=n.compile()}catch(a){(0,r.warn)("Failed to compile font "+t.loadedName);this.data=e}}e.prototype={get numGlyphs(){return this.cff.charStrings.count},getCharset:function(){return this.cff.charset.charset},getGlyphMapping:function(){var e,t,a=this.cff,r=this.properties,i=a.charset.charset;if(r.composite){e=Object.create(null);let s;if(a.isCIDFont)for(t=0;t<i.length;t++){var n=i[t];s=r.cMap.charCodeOf(n);e[s]=t}else for(t=0;t<a.charStrings.count;t++){s=r.cMap.charCodeOf(t);e[s]=t}return e}return e=I(r,a.encoding?a.encoding.encoding:null,i)},hasGlyphId:function(e){return this.cff.hasGlyphId(e)}};return e}()},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.CFFFDSelect=t.CFFCompiler=t.CFFPrivateDict=t.CFFTopDict=t.CFFCharset=t.CFFIndex=t.CFFStrings=t.CFFHeader=t.CFF=t.CFFParser=t.CFFStandardStrings=void 0;var r=a(2),i=a(29),n=a(30),s=[".notdef","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quoteright","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","exclamdown","cent","sterling","fraction","yen","florin","section","currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft","guilsinglright","fi","fl","endash","dagger","daggerdbl","periodcentered","paragraph","bullet","quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis","perthousand","questiondown","grave","acute","circumflex","tilde","macron","breve","dotaccent","dieresis","ring","cedilla","hungarumlaut","ogonek","caron","emdash","AE","ordfeminine","Lslash","Oslash","OE","ordmasculine","ae","dotlessi","lslash","oslash","oe","germandbls","onesuperior","logicalnot","mu","trademark","Eth","onehalf","plusminus","Thorn","onequarter","divide","brokenbar","degree","thorn","threequarters","twosuperior","registered","minus","eth","multiply","threesuperior","copyright","Aacute","Acircumflex","Adieresis","Agrave","Aring","Atilde","Ccedilla","Eacute","Ecircumflex","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Ntilde","Oacute","Ocircumflex","Odieresis","Ograve","Otilde","Scaron","Uacute","Ucircumflex","Udieresis","Ugrave","Yacute","Ydieresis","Zcaron","aacute","acircumflex","adieresis","agrave","aring","atilde","ccedilla","eacute","ecircumflex","edieresis","egrave","iacute","icircumflex","idieresis","igrave","ntilde","oacute","ocircumflex","odieresis","ograve","otilde","scaron","uacute","ucircumflex","udieresis","ugrave","yacute","ydieresis","zcaron","exclamsmall","Hungarumlautsmall","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","commasuperior","threequartersemdash","periodsuperior","questionsmall","asuperior","bsuperior","centsuperior","dsuperior","esuperior","isuperior","lsuperior","msuperior","nsuperior","osuperior","rsuperior","ssuperior","tsuperior","ff","ffi","ffl","parenleftinferior","parenrightinferior","Circumflexsmall","hyphensuperior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","exclamdownsmall","centoldstyle","Lslashsmall","Scaronsmall","Zcaronsmall","Dieresissmall","Brevesmall","Caronsmall","Dotaccentsmall","Macronsmall","figuredash","hypheninferior","Ogoneksmall","Ringsmall","Cedillasmall","questiondownsmall","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","zerosuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior","Agravesmall","Aacutesmall","Acircumflexsmall","Atildesmall","Adieresissmall","Aringsmall","AEsmall","Ccedillasmall","Egravesmall","Eacutesmall","Ecircumflexsmall","Edieresissmall","Igravesmall","Iacutesmall","Icircumflexsmall","Idieresissmall","Ethsmall","Ntildesmall","Ogravesmall","Oacutesmall","Ocircumflexsmall","Otildesmall","Odieresissmall","OEsmall","Oslashsmall","Ugravesmall","Uacutesmall","Ucircumflexsmall","Udieresissmall","Yacutesmall","Thornsmall","Ydieresissmall","001.000","001.001","001.002","001.003","Black","Bold","Book","Light","Medium","Regular","Roman","Semibold"];t.CFFStandardStrings=s;var o=function(){var e=[null,{id:"hstem",min:2,stackClearing:!0,stem:!0},null,{id:"vstem",min:2,stackClearing:!0,stem:!0},{id:"vmoveto",min:1,stackClearing:!0},{id:"rlineto",min:2,resetStack:!0},{id:"hlineto",min:1,resetStack:!0},{id:"vlineto",min:1,resetStack:!0},{id:"rrcurveto",min:6,resetStack:!0},null,{id:"callsubr",min:1,undefStack:!0},{id:"return",min:0,undefStack:!0},null,null,{id:"endchar",min:0,stackClearing:!0},null,null,null,{id:"hstemhm",min:2,stackClearing:!0,stem:!0},{id:"hintmask",min:0,stackClearing:!0},{id:"cntrmask",min:0,stackClearing:!0},{id:"rmoveto",min:2,stackClearing:!0},{id:"hmoveto",min:1,stackClearing:!0},{id:"vstemhm",min:2,stackClearing:!0,stem:!0},{id:"rcurveline",min:8,resetStack:!0},{id:"rlinecurve",min:8,resetStack:!0},{id:"vvcurveto",min:4,resetStack:!0},{id:"hhcurveto",min:4,resetStack:!0},null,{id:"callgsubr",min:1,undefStack:!0},{id:"vhcurveto",min:4,resetStack:!0},{id:"hvcurveto",min:4,resetStack:!0}],t=[null,null,null,{id:"and",min:2,stackDelta:-1},{id:"or",min:2,stackDelta:-1},{id:"not",min:1,stackDelta:0},null,null,null,{id:"abs",min:1,stackDelta:0},{id:"add",min:2,stackDelta:-1,stackFn:function(e,t){e[t-2]=e[t-2]+e[t-1]}},{id:"sub",min:2,stackDelta:-1,stackFn:function(e,t){e[t-2]=e[t-2]-e[t-1]}},{id:"div",min:2,stackDelta:-1,stackFn:function(e,t){e[t-2]=e[t-2]/e[t-1]}},null,{id:"neg",min:1,stackDelta:0,stackFn:function(e,t){e[t-1]=-e[t-1]}},{id:"eq",min:2,stackDelta:-1},null,null,{id:"drop",min:1,stackDelta:-1},null,{id:"put",min:2,stackDelta:-2},{id:"get",min:1,stackDelta:0},{id:"ifelse",min:4,stackDelta:-3},{id:"random",min:0,stackDelta:1},{id:"mul",min:2,stackDelta:-1,stackFn:function(e,t){e[t-2]=e[t-2]*e[t-1]}},null,{id:"sqrt",min:1,stackDelta:0},{id:"dup",min:1,stackDelta:1},{id:"exch",min:2,stackDelta:0},{id:"index",min:2,stackDelta:0},{id:"roll",min:3,stackDelta:-2},null,null,null,{id:"hflex",min:7,resetStack:!0},{id:"flex",min:13,resetStack:!0},{id:"hflex1",min:9,resetStack:!0},{id:"flex1",min:11,resetStack:!0}];function a(e,t,a){this.bytes=e.getBytes();this.properties=t;this.seacAnalysisEnabled=!!a}a.prototype={parse:function(){var e=this.properties,t=new c;this.cff=t;var a=this.parseHeader(),r=this.parseIndex(a.endPos),i=this.parseIndex(r.endPos),n=this.parseIndex(i.endPos),s=this.parseIndex(n.endPos),o=this.parseDict(i.obj.get(0)),l=this.createDict(f,o,t.strings);t.header=a.obj;t.names=this.parseNameIndex(r.obj);t.strings=this.parseStringIndex(n.obj);t.topDict=l;t.globalSubrIndex=s.obj;this.parsePrivateDict(t.topDict);t.isCIDFont=l.hasName("ROS");var h=l.getByName("CharStrings"),u=this.parseIndex(h).obj,d=l.getByName("FontMatrix");d&&(e.fontMatrix=d);var g,m,p=l.getByName("FontBBox");if(p){e.ascent=Math.max(p[3],p[1]);e.descent=Math.min(p[1],p[3]);e.ascentScaled=!0}if(t.isCIDFont){for(var b=this.parseIndex(l.getByName("FDArray")).obj,y=0,v=b.count;y<v;++y){var w=b.get(y),k=this.createDict(f,this.parseDict(w),t.strings);this.parsePrivateDict(k);t.fdArray.push(k)}m=null;g=this.parseCharsets(l.getByName("charset"),u.count,t.strings,!0);t.fdSelect=this.parseFDSelect(l.getByName("FDSelect"),u.count)}else{g=this.parseCharsets(l.getByName("charset"),u.count,t.strings,!1);m=this.parseEncoding(l.getByName("Encoding"),e,t.strings,g.charset)}t.charset=g;t.encoding=m;var S=this.parseCharStrings({charStrings:u,localSubrIndex:l.privateDict.subrsIndex,globalSubrIndex:s.obj,fdSelect:t.fdSelect,fdArray:t.fdArray,privateDict:l.privateDict});t.charStrings=S.charStrings;t.seacs=S.seacs;t.widths=S.widths;return t},parseHeader:function(){for(var e=this.bytes,t=e.length,a=0;a<t&&1!==e[a];)++a;if(a>=t)throw new r.FormatError("Invalid CFF header");if(0!==a){(0,r.info)("cff data is shifted");e=e.subarray(a);this.bytes=e}var i=e[0],n=e[1],s=e[2],o=e[3];return{obj:new l(i,n,s,o),endPos:s}},parseDict:function(e){var t=0;function a(){var a=e[t++];if(30===a)return function(){var a="";const r=["0","1","2","3","4","5","6","7","8","9",".","E","E-",null,"-"];var i=e.length;for(;t<i;){var n=e[t++],s=n>>4,o=15&n;if(15===s)break;a+=r[s];if(15===o)break;a+=r[o]}return parseFloat(a)}();if(28===a)return a=((a=e[t++])<<24|e[t++]<<16)>>16;if(29===a)return a=(a=(a=(a=e[t++])<<8|e[t++])<<8|e[t++])<<8|e[t++];if(a>=32&&a<=246)return a-139;if(a>=247&&a<=250)return 256*(a-247)+e[t++]+108;if(a>=251&&a<=254)return-256*(a-251)-e[t++]-108;(0,r.warn)('CFFParser_parseDict: "'+a+'" is a reserved command.');return NaN}var i=[],n=[];t=0;for(var s=e.length;t<s;){var o=e[t];if(o<=21){12===o&&(o=o<<8|e[++t]);n.push([o,i]);i=[];++t}else i.push(a())}return n},parseIndex:function(e){var t,a,r=new u,i=this.bytes,n=i[e++]<<8|i[e++],s=[],o=e;if(0!==n){var c=i[e++],l=e+(n+1)*c-1;for(t=0,a=n+1;t<a;++t){for(var h=0,d=0;d<c;++d){h<<=8;h+=i[e++]}s.push(l+h)}o=s[n]}for(t=0,a=s.length-1;t<a;++t){var f=s[t],g=s[t+1];r.add(i.subarray(f,g))}return{obj:r,endPos:o}},parseNameIndex:function(e){for(var t=[],a=0,i=e.count;a<i;++a){var n=e.get(a);t.push((0,r.bytesToString)(n))}return t},parseStringIndex:function(e){for(var t=new h,a=0,i=e.count;a<i;++a){var n=e.get(a);t.add((0,r.bytesToString)(n))}return t},createDict:function(e,t,a){for(var r=new e(a),i=0,n=t.length;i<n;++i){var s=t[i],o=s[0],c=s[1];r.setByKey(o,c)}return r},parseCharString:function(a,i,n,s){if(!i||a.callDepth>10)return!1;for(var o=a.stackSize,c=a.stack,l=i.length,h=0;h<l;){var u=i[h++],d=null;if(12===u){var f=i[h++];if(0===f){i[h-2]=139;i[h-1]=22;o=0}else d=t[f]}else if(28===u){c[o]=(i[h]<<24|i[h+1]<<16)>>16;h+=2;o++}else if(14===u){if(o>=4){o-=4;if(this.seacAnalysisEnabled){a.seac=c.slice(o,o+4);return!1}}d=e[u]}else if(u>=32&&u<=246){c[o]=u-139;o++}else if(u>=247&&u<=254){c[o]=u<251?(u-247<<8)+i[h]+108:-(u-251<<8)-i[h]-108;h++;o++}else if(255===u){c[o]=(i[h]<<24|i[h+1]<<16|i[h+2]<<8|i[h+3])/65536;h+=4;o++}else if(19===u||20===u){a.hints+=o>>1;h+=a.hints+7>>3;o%=2;d=e[u]}else{if(10===u||29===u){var g;if(!(g=10===u?n:s)){d=e[u];(0,r.warn)("Missing subrsIndex for "+d.id);return!1}var m=32768;g.count<1240?m=107:g.count<33900&&(m=1131);var p=c[--o]+m;if(p<0||p>=g.count||isNaN(p)){d=e[u];(0,r.warn)("Out of bounds subrIndex for "+d.id);return!1}a.stackSize=o;a.callDepth++;if(!this.parseCharString(a,g.get(p),n,s))return!1;a.callDepth--;o=a.stackSize;continue}if(11===u){a.stackSize=o;return!0}d=e[u]}if(d){if(d.stem){a.hints+=o>>1;if(3===u||23===u)a.hasVStems=!0;else if(a.hasVStems&&(1===u||18===u)){(0,r.warn)("CFF stem hints are in wrong order");i[h-1]=1===u?3:23}}if("min"in d&&!a.undefStack&&o<d.min){(0,r.warn)("Not enough parameters for "+d.id+"; actual: "+o+", expected: "+d.min);return!1}if(a.firstStackClearing&&d.stackClearing){a.firstStackClearing=!1;(o-=d.min)>=2&&d.stem?o%=2:o>1&&(0,r.warn)("Found too many parameters for stack-clearing command");o>0&&c[o-1]>=0&&(a.width=c[o-1])}if("stackDelta"in d){"stackFn"in d&&d.stackFn(c,o);o+=d.stackDelta}else if(d.stackClearing)o=0;else if(d.resetStack){o=0;a.undefStack=!1}else if(d.undefStack){o=0;a.undefStack=!0;a.firstStackClearing=!1}}}a.stackSize=o;return!0},parseCharStrings({charStrings:e,localSubrIndex:t,globalSubrIndex:a,fdSelect:i,fdArray:n,privateDict:s}){for(var o=[],c=[],l=e.count,h=0;h<l;h++){var u=e.get(h),d={callDepth:0,stackSize:0,stack:[],undefStack:!0,hints:0,firstStackClearing:!0,seac:null,width:null,hasVStems:!1},f=!0,g=null,m=s;if(i&&n.length){var p=i.getFDIndex(h);if(-1===p){(0,r.warn)("Glyph index is not in fd select.");f=!1}if(p>=n.length){(0,r.warn)("Invalid fd index for glyph index.");f=!1}f&&(g=(m=n[p].privateDict).subrsIndex)}else t&&(g=t);f&&(f=this.parseCharString(d,u,g,a));if(null!==d.width){const e=m.getByName("nominalWidthX");c[h]=e+d.width}else{const e=m.getByName("defaultWidthX");c[h]=e}null!==d.seac&&(o[h]=d.seac);f||e.set(h,new Uint8Array([14]))}return{charStrings:e,seacs:o,widths:c}},emptyPrivateDictionary:function(e){var t=this.createDict(g,[],e.strings);e.setByKey(18,[0,0]);e.privateDict=t},parsePrivateDict:function(e){if(e.hasName("Private")){var t=e.getByName("Private");if(Array.isArray(t)&&2===t.length){var a=t[0],r=t[1];if(0===a||r>=this.bytes.length)this.emptyPrivateDictionary(e);else{var i=r+a,n=this.bytes.subarray(r,i),s=this.parseDict(n),o=this.createDict(g,s,e.strings);e.privateDict=o;if(o.getByName("Subrs")){var c=o.getByName("Subrs"),l=r+c;if(0===c||l>=this.bytes.length)this.emptyPrivateDictionary(e);else{var h=this.parseIndex(l);o.subrsIndex=h.obj}}}}else e.removeByName("Private")}else this.emptyPrivateDictionary(e)},parseCharsets:function(e,t,a,n){if(0===e)return new p(!0,m.ISO_ADOBE,i.ISOAdobeCharset);if(1===e)return new p(!0,m.EXPERT,i.ExpertCharset);if(2===e)return new p(!0,m.EXPERT_SUBSET,i.ExpertSubsetCharset);var s,o,c,l=this.bytes,h=e,u=l[e++],d=[".notdef"];t-=1;switch(u){case 0:for(c=0;c<t;c++){s=l[e++]<<8|l[e++];d.push(n?s:a.get(s))}break;case 1:for(;d.length<=t;){s=l[e++]<<8|l[e++];o=l[e++];for(c=0;c<=o;c++)d.push(n?s++:a.get(s++))}break;case 2:for(;d.length<=t;){s=l[e++]<<8|l[e++];o=l[e++]<<8|l[e++];for(c=0;c<=o;c++)d.push(n?s++:a.get(s++))}break;default:throw new r.FormatError("Unknown charset format")}var f=e,g=l.subarray(h,f);return new p(!1,u,d,g)},parseEncoding:function(e,t,a,i){var s,o,c,l=Object.create(null),h=this.bytes,u=!1,d=null;if(0===e||1===e){u=!0;s=e;var f=e?n.ExpertEncoding:n.StandardEncoding;for(o=0,c=i.length;o<c;o++){var g=f.indexOf(i[o]);-1!==g&&(l[g]=o)}}else{var m=e;switch(127&(s=h[e++])){case 0:var p=h[e++];for(o=1;o<=p;o++)l[h[e++]]=o;break;case 1:var y=h[e++],v=1;for(o=0;o<y;o++)for(var w=h[e++],k=h[e++],S=w;S<=w+k;S++)l[S]=v++;break;default:throw new r.FormatError(`Unknown encoding format: ${s} in CFF`)}var C=e;if(128&s){h[m]&=127;!function(){var t=h[e++];for(o=0;o<t;o++){var r=h[e++],n=(h[e++]<<8)+(255&h[e++]);l[r]=i.indexOf(a.get(n))}}()}d=h.subarray(m,C)}return new b(u,s&=127,l,d)},parseFDSelect:function(e,t){var a,i=this.bytes,n=i[e++],s=[];switch(n){case 0:for(a=0;a<t;++a){var o=i[e++];s.push(o)}break;case 3:var c=i[e++]<<8|i[e++];for(a=0;a<c;++a){var l=i[e++]<<8|i[e++];if(0===a&&0!==l){(0,r.warn)("parseFDSelect: The first range must have a first GID of 0 -- trying to recover.");l=0}for(var h=i[e++],u=i[e]<<8|i[e+1],d=l;d<u;++d)s.push(h)}e+=2;break;default:throw new r.FormatError(`parseFDSelect: Unknown format "${n}".`)}if(s.length!==t)throw new r.FormatError("parseFDSelect: Invalid font data.");return new y(n,s)}};return a}();t.CFFParser=o;var c=function(){function e(){this.header=null;this.names=[];this.topDict=null;this.strings=new h;this.globalSubrIndex=null;this.encoding=null;this.charset=null;this.charStrings=null;this.fdArray=[];this.fdSelect=null;this.isCIDFont=!1}e.prototype={duplicateFirstGlyph:function(){if(this.charStrings.count>=65535)(0,r.warn)("Not enough space in charstrings to duplicate first glyph.");else{var e=this.charStrings.get(0);this.charStrings.add(e);this.isCIDFont&&this.fdSelect.fdSelect.push(this.fdSelect.fdSelect[0])}},hasGlyphId:function(e){return!(e<0||e>=this.charStrings.count)&&this.charStrings.get(e).length>0}};return e}();t.CFF=c;var l=function(e,t,a,r){this.major=e;this.minor=t;this.hdrSize=a;this.offSize=r};t.CFFHeader=l;var h=function(){function e(){this.strings=[]}e.prototype={get:function(e){return e>=0&&e<=390?s[e]:e-391<=this.strings.length?this.strings[e-391]:s[0]},getSID:function(e){let t=s.indexOf(e);if(-1!==t)return t;t=this.strings.indexOf(e);return-1!==t?t+391:-1},add:function(e){this.strings.push(e)},get count(){return this.strings.length}};return e}();t.CFFStrings=h;var u=function(){function e(){this.objects=[];this.length=0}e.prototype={add:function(e){this.length+=e.length;this.objects.push(e)},set:function(e,t){this.length+=t.length-this.objects[e].length;this.objects[e]=t},get:function(e){return this.objects[e]},get count(){return this.objects.length}};return e}();t.CFFIndex=u;var d=function(){function e(e,t){this.keyToNameMap=e.keyToNameMap;this.nameToKeyMap=e.nameToKeyMap;this.defaults=e.defaults;this.types=e.types;this.opcodes=e.opcodes;this.order=e.order;this.strings=t;this.values=Object.create(null)}e.prototype={setByKey:function(e,t){if(!(e in this.keyToNameMap))return!1;var a=t.length;if(0===a)return!0;for(var i=0;i<a;i++)if(isNaN(t[i])){(0,r.warn)('Invalid CFFDict value: "'+t+'" for key "'+e+'".');return!0}var n=this.types[e];"num"!==n&&"sid"!==n&&"offset"!==n||(t=t[0]);this.values[e]=t;return!0},setByName:function(e,t){if(!(e in this.nameToKeyMap))throw new r.FormatError(`Invalid dictionary name "${e}"`);this.values[this.nameToKeyMap[e]]=t},hasName:function(e){return this.nameToKeyMap[e]in this.values},getByName:function(e){if(!(e in this.nameToKeyMap))throw new r.FormatError(`Invalid dictionary name ${e}"`);var t=this.nameToKeyMap[e];return t in this.values?this.values[t]:this.defaults[t]},removeByName:function(e){delete this.values[this.nameToKeyMap[e]]}};e.createTables=function(e){for(var t={keyToNameMap:{},nameToKeyMap:{},defaults:{},types:{},opcodes:{},order:[]},a=0,r=e.length;a<r;++a){var i=e[a],n=Array.isArray(i[0])?(i[0][0]<<8)+i[0][1]:i[0];t.keyToNameMap[n]=i[1];t.nameToKeyMap[i[1]]=n;t.types[n]=i[2];t.defaults[n]=i[3];t.opcodes[n]=Array.isArray(i[0])?i[0]:[i[0]];t.order.push(n)}return t};return e}(),f=function(){var e=[[[12,30],"ROS",["sid","sid","num"],null],[[12,20],"SyntheticBase","num",null],[0,"version","sid",null],[1,"Notice","sid",null],[[12,0],"Copyright","sid",null],[2,"FullName","sid",null],[3,"FamilyName","sid",null],[4,"Weight","sid",null],[[12,1],"isFixedPitch","num",0],[[12,2],"ItalicAngle","num",0],[[12,3],"UnderlinePosition","num",-100],[[12,4],"UnderlineThickness","num",50],[[12,5],"PaintType","num",0],[[12,6],"CharstringType","num",2],[[12,7],"FontMatrix",["num","num","num","num","num","num"],[.001,0,0,.001,0,0]],[13,"UniqueID","num",null],[5,"FontBBox",["num","num","num","num"],[0,0,0,0]],[[12,8],"StrokeWidth","num",0],[14,"XUID","array",null],[15,"charset","offset",0],[16,"Encoding","offset",0],[17,"CharStrings","offset",0],[18,"Private",["offset","offset"],null],[[12,21],"PostScript","sid",null],[[12,22],"BaseFontName","sid",null],[[12,23],"BaseFontBlend","delta",null],[[12,31],"CIDFontVersion","num",0],[[12,32],"CIDFontRevision","num",0],[[12,33],"CIDFontType","num",0],[[12,34],"CIDCount","num",8720],[[12,35],"UIDBase","num",null],[[12,37],"FDSelect","offset",null],[[12,36],"FDArray","offset",null],[[12,38],"FontName","sid",null]],t=null;function a(a){null===t&&(t=d.createTables(e));d.call(this,t,a);this.privateDict=null}a.prototype=Object.create(d.prototype);return a}();t.CFFTopDict=f;var g=function(){var e=[[6,"BlueValues","delta",null],[7,"OtherBlues","delta",null],[8,"FamilyBlues","delta",null],[9,"FamilyOtherBlues","delta",null],[[12,9],"BlueScale","num",.039625],[[12,10],"BlueShift","num",7],[[12,11],"BlueFuzz","num",1],[10,"StdHW","num",null],[11,"StdVW","num",null],[[12,12],"StemSnapH","delta",null],[[12,13],"StemSnapV","delta",null],[[12,14],"ForceBold","num",0],[[12,17],"LanguageGroup","num",0],[[12,18],"ExpansionFactor","num",.06],[[12,19],"initialRandomSeed","num",0],[20,"defaultWidthX","num",0],[21,"nominalWidthX","num",0],[19,"Subrs","offset",null]],t=null;function a(a){null===t&&(t=d.createTables(e));d.call(this,t,a);this.subrsIndex=null}a.prototype=Object.create(d.prototype);return a}();t.CFFPrivateDict=g;var m={ISO_ADOBE:0,EXPERT:1,EXPERT_SUBSET:2},p=function(e,t,a,r){this.predefined=e;this.format=t;this.charset=a;this.raw=r};t.CFFCharset=p;var b=function(e,t,a,r){this.predefined=e;this.format=t;this.encoding=a;this.raw=r},y=function(){function e(e,t){this.format=e;this.fdSelect=t}e.prototype={getFDIndex:function(e){return e<0||e>=this.fdSelect.length?-1:this.fdSelect[e]}};return e}();t.CFFFDSelect=y;var v=function(){function e(){this.offsets=Object.create(null)}e.prototype={isTracking:function(e){return e in this.offsets},track:function(e,t){if(e in this.offsets)throw new r.FormatError(`Already tracking location of ${e}`);this.offsets[e]=t},offset:function(e){for(var t in this.offsets)this.offsets[t]+=e},setEntryLocation:function(e,t,a){if(!(e in this.offsets))throw new r.FormatError(`Not tracking location of ${e}`);for(var i=a.data,n=this.offsets[e],s=0,o=t.length;s<o;++s){var c=5*s+n,l=c+1,h=c+2,u=c+3,d=c+4;if(29!==i[c]||0!==i[l]||0!==i[h]||0!==i[u]||0!==i[d])throw new r.FormatError("writing to an offset that is not empty");var f=t[s];i[c]=29;i[l]=f>>24&255;i[h]=f>>16&255;i[u]=f>>8&255;i[d]=255&f}}};return e}(),w=function(){function e(e){this.cff=e}e.prototype={compile:function(){var e=this.cff,t={data:[],length:0,add:function(e){this.data=this.data.concat(e);this.length=this.data.length}},a=this.compileHeader(e.header);t.add(a);var i=this.compileNameIndex(e.names);t.add(i);if(e.isCIDFont&&e.topDict.hasName("FontMatrix")){var n=e.topDict.getByName("FontMatrix");e.topDict.removeByName("FontMatrix");for(var s=0,o=e.fdArray.length;s<o;s++){var c=e.fdArray[s],l=n.slice(0);c.hasName("FontMatrix")&&(l=r.Util.transform(l,c.getByName("FontMatrix")));c.setByName("FontMatrix",l)}}e.topDict.setByName("charset",0);var h=this.compileTopDicts([e.topDict],t.length,e.isCIDFont);t.add(h.output);var u=h.trackers[0],d=this.compileStringIndex(e.strings.strings);t.add(d);var f=this.compileIndex(e.globalSubrIndex);t.add(f);if(e.encoding&&e.topDict.hasName("Encoding"))if(e.encoding.predefined)u.setEntryLocation("Encoding",[e.encoding.format],t);else{var g=this.compileEncoding(e.encoding);u.setEntryLocation("Encoding",[t.length],t);t.add(g)}var m=this.compileCharset(e.charset,e.charStrings.count,e.strings,e.isCIDFont);u.setEntryLocation("charset",[t.length],t);t.add(m);var p=this.compileCharStrings(e.charStrings);u.setEntryLocation("CharStrings",[t.length],t);t.add(p);if(e.isCIDFont){u.setEntryLocation("FDSelect",[t.length],t);var b=this.compileFDSelect(e.fdSelect);t.add(b);h=this.compileTopDicts(e.fdArray,t.length,!0);u.setEntryLocation("FDArray",[t.length],t);t.add(h.output);var y=h.trackers;this.compilePrivateDicts(e.fdArray,y,t)}this.compilePrivateDicts([e.topDict],[u],t);t.add([0]);return t.data},encodeNumber:function(e){return parseFloat(e)!==parseInt(e,10)||isNaN(e)?this.encodeFloat(e):this.encodeInteger(e)},encodeFloat:function(e){var t=e.toString(),a=/\.(\d*?)(?:9{5,20}|0{5,20})\d{0,2}(?:e(.+)|$)/.exec(t);if(a){var r=parseFloat("1e"+((a[2]?+a[2]:0)+a[1].length));t=(Math.round(e*r)/r).toString()}var i,n,s="";for(i=0,n=t.length;i<n;++i){var o=t[i];s+="e"===o?"-"===t[++i]?"c":"b":"."===o?"a":"-"===o?"e":o}var c=[30];for(i=0,n=(s+=1&s.length?"f":"ff").length;i<n;i+=2)c.push(parseInt(s.substring(i,i+2),16));return c},encodeInteger:function(e){return e>=-107&&e<=107?[e+139]:e>=108&&e<=1131?[247+((e-=108)>>8),255&e]:e>=-1131&&e<=-108?[251+((e=-e-108)>>8),255&e]:e>=-32768&&e<=32767?[28,e>>8&255,255&e]:[29,e>>24&255,e>>16&255,e>>8&255,255&e]},compileHeader:function(e){return[e.major,e.minor,e.hdrSize,e.offSize]},compileNameIndex:function(e){for(var t=new u,a=0,i=e.length;a<i;++a){for(var n=e[a],s=Math.min(n.length,127),o=new Array(s),c=0;c<s;c++){var l=n[c];(l<"!"||l>"~"||"["===l||"]"===l||"("===l||")"===l||"{"===l||"}"===l||"<"===l||">"===l||"/"===l||"%"===l)&&(l="_");o[c]=l}""===(o=o.join(""))&&(o="Bad_Font_Name");t.add((0,r.stringToBytes)(o))}return this.compileIndex(t)},compileTopDicts:function(e,t,a){for(var r=[],i=new u,n=0,s=e.length;n<s;++n){var o=e[n];if(a){o.removeByName("CIDFontVersion");o.removeByName("CIDFontRevision");o.removeByName("CIDFontType");o.removeByName("CIDCount");o.removeByName("UIDBase")}var c=new v,l=this.compileDict(o,c);r.push(c);i.add(l);c.offset(t)}return{trackers:r,output:i=this.compileIndex(i,r)}},compilePrivateDicts:function(e,t,a){for(var i=0,n=e.length;i<n;++i){var s=e[i],o=s.privateDict;if(!o||!s.hasName("Private"))throw new r.FormatError("There must be a private dictionary.");var c=new v,l=this.compileDict(o,c),h=a.length;c.offset(h);l.length||(h=0);t[i].setEntryLocation("Private",[l.length,h],a);a.add(l);if(o.subrsIndex&&o.hasName("Subrs")){var u=this.compileIndex(o.subrsIndex);c.setEntryLocation("Subrs",[l.length],a);a.add(u)}}},compileDict:function(e,t){for(var a=[],i=e.order,n=0;n<i.length;++n){var s=i[n];if(s in e.values){var o=e.values[s],c=e.types[s];Array.isArray(c)||(c=[c]);Array.isArray(o)||(o=[o]);if(0!==o.length){for(var l=0,h=c.length;l<h;++l){var u=c[l],d=o[l];switch(u){case"num":case"sid":a=a.concat(this.encodeNumber(d));break;case"offset":var f=e.keyToNameMap[s];t.isTracking(f)||t.track(f,a.length);a=a.concat([29,0,0,0,0]);break;case"array":case"delta":a=a.concat(this.encodeNumber(d));for(var g=1,m=o.length;g<m;++g)a=a.concat(this.encodeNumber(o[g]));break;default:throw new r.FormatError(`Unknown data type of ${u}`)}}a=a.concat(e.opcodes[s])}}}return a},compileStringIndex:function(e){for(var t=new u,a=0,i=e.length;a<i;++a)t.add((0,r.stringToBytes)(e[a]));return this.compileIndex(t)},compileGlobalSubrIndex:function(){var e=this.cff.globalSubrIndex;this.out.writeByteArray(this.compileIndex(e))},compileCharStrings:function(e){for(var t=new u,a=0;a<e.count;a++){var r=e.get(a);0!==r.length?t.add(r):t.add(new Uint8Array([139,14]))}return this.compileIndex(t)},compileCharset:function(e,t,a,i){let n;const s=t-1;if(i)n=new Uint8Array([2,0,0,s>>8&255,255&s]);else{n=new Uint8Array(1+2*s);n[0]=0;let t=0;const i=e.charset.length;let o=!1;for(let s=1;s<n.length;s+=2){let c=0;if(t<i){const i=e.charset[t++];c=a.getSID(i);if(-1===c){c=0;if(!o){o=!0;(0,r.warn)(`Couldn't find ${i} in CFF strings`)}}}n[s]=c>>8&255;n[s+1]=255&c}}return this.compileTypedArray(n)},compileEncoding:function(e){return this.compileTypedArray(e.raw)},compileFDSelect:function(e){const t=e.format;let a,r;switch(t){case 0:a=new Uint8Array(1+e.fdSelect.length);a[0]=t;for(r=0;r<e.fdSelect.length;r++)a[r+1]=e.fdSelect[r];break;case 3:const i=0;let n=e.fdSelect[0];const s=[t,0,0,i>>8&255,255&i,n];for(r=1;r<e.fdSelect.length;r++){const t=e.fdSelect[r];if(t!==n){s.push(r>>8&255,255&r,t);n=t}}const o=(s.length-3)/3;s[1]=o>>8&255;s[2]=255&o;s.push(r>>8&255,255&r);a=new Uint8Array(s)}return this.compileTypedArray(a)},compileTypedArray:function(e){for(var t=[],a=0,r=e.length;a<r;++a)t[a]=e[a];return t},compileIndex:function(e,t){t=t||[];var a=e.objects,r=a.length;if(0===r)return[0,0,0];var i,n,s=[r>>8&255,255&r],o=1;for(i=0;i<r;++i)o+=a[i].length;n=o<256?1:o<65536?2:o<16777216?3:4;s.push(n);var c=1;for(i=0;i<r+1;i++){1===n?s.push(255&c):2===n?s.push(c>>8&255,255&c):3===n?s.push(c>>16&255,c>>8&255,255&c):s.push(c>>>24&255,c>>16&255,c>>8&255,255&c);a[i]&&(c+=a[i].length)}for(i=0;i<r;i++){t[i]&&t[i].offset(s.length);for(var l=0,h=a[i].length;l<h;l++)s.push(a[i][l])}return s}};return e}();t.CFFCompiler=w},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.ExpertSubsetCharset=t.ExpertCharset=t.ISOAdobeCharset=void 0;t.ISOAdobeCharset=[".notdef","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quoteright","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","exclamdown","cent","sterling","fraction","yen","florin","section","currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft","guilsinglright","fi","fl","endash","dagger","daggerdbl","periodcentered","paragraph","bullet","quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis","perthousand","questiondown","grave","acute","circumflex","tilde","macron","breve","dotaccent","dieresis","ring","cedilla","hungarumlaut","ogonek","caron","emdash","AE","ordfeminine","Lslash","Oslash","OE","ordmasculine","ae","dotlessi","lslash","oslash","oe","germandbls","onesuperior","logicalnot","mu","trademark","Eth","onehalf","plusminus","Thorn","onequarter","divide","brokenbar","degree","thorn","threequarters","twosuperior","registered","minus","eth","multiply","threesuperior","copyright","Aacute","Acircumflex","Adieresis","Agrave","Aring","Atilde","Ccedilla","Eacute","Ecircumflex","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Ntilde","Oacute","Ocircumflex","Odieresis","Ograve","Otilde","Scaron","Uacute","Ucircumflex","Udieresis","Ugrave","Yacute","Ydieresis","Zcaron","aacute","acircumflex","adieresis","agrave","aring","atilde","ccedilla","eacute","ecircumflex","edieresis","egrave","iacute","icircumflex","idieresis","igrave","ntilde","oacute","ocircumflex","odieresis","ograve","otilde","scaron","uacute","ucircumflex","udieresis","ugrave","yacute","ydieresis","zcaron"];t.ExpertCharset=[".notdef","space","exclamsmall","Hungarumlautsmall","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","commasuperior","threequartersemdash","periodsuperior","questionsmall","asuperior","bsuperior","centsuperior","dsuperior","esuperior","isuperior","lsuperior","msuperior","nsuperior","osuperior","rsuperior","ssuperior","tsuperior","ff","fi","fl","ffi","ffl","parenleftinferior","parenrightinferior","Circumflexsmall","hyphensuperior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","exclamdownsmall","centoldstyle","Lslashsmall","Scaronsmall","Zcaronsmall","Dieresissmall","Brevesmall","Caronsmall","Dotaccentsmall","Macronsmall","figuredash","hypheninferior","Ogoneksmall","Ringsmall","Cedillasmall","onequarter","onehalf","threequarters","questiondownsmall","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","zerosuperior","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior","Agravesmall","Aacutesmall","Acircumflexsmall","Atildesmall","Adieresissmall","Aringsmall","AEsmall","Ccedillasmall","Egravesmall","Eacutesmall","Ecircumflexsmall","Edieresissmall","Igravesmall","Iacutesmall","Icircumflexsmall","Idieresissmall","Ethsmall","Ntildesmall","Ogravesmall","Oacutesmall","Ocircumflexsmall","Otildesmall","Odieresissmall","OEsmall","Oslashsmall","Ugravesmall","Uacutesmall","Ucircumflexsmall","Udieresissmall","Yacutesmall","Thornsmall","Ydieresissmall"];t.ExpertSubsetCharset=[".notdef","space","dollaroldstyle","dollarsuperior","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","commasuperior","threequartersemdash","periodsuperior","asuperior","bsuperior","centsuperior","dsuperior","esuperior","isuperior","lsuperior","msuperior","nsuperior","osuperior","rsuperior","ssuperior","tsuperior","ff","fi","fl","ffi","ffl","parenleftinferior","parenrightinferior","hyphensuperior","colonmonetary","onefitted","rupiah","centoldstyle","figuredash","hypheninferior","onequarter","onehalf","threequarters","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","zerosuperior","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior"]},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.getEncoding=function(e){switch(e){case"WinAnsiEncoding":return o;case"StandardEncoding":return s;case"MacRomanEncoding":return n;case"SymbolSetEncoding":return c;case"ZapfDingbatsEncoding":return l;case"ExpertEncoding":return r;case"MacExpertEncoding":return i;default:return null}};t.ExpertEncoding=t.ZapfDingbatsEncoding=t.SymbolSetEncoding=t.MacRomanEncoding=t.StandardEncoding=t.WinAnsiEncoding=void 0;const r=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclamsmall","Hungarumlautsmall","","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","commasuperior","threequartersemdash","periodsuperior","questionsmall","","asuperior","bsuperior","centsuperior","dsuperior","esuperior","","","","isuperior","","","lsuperior","msuperior","nsuperior","osuperior","","","rsuperior","ssuperior","tsuperior","","ff","fi","fl","ffi","ffl","parenleftinferior","","parenrightinferior","Circumflexsmall","hyphensuperior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","exclamdownsmall","centoldstyle","Lslashsmall","","","Scaronsmall","Zcaronsmall","Dieresissmall","Brevesmall","Caronsmall","","Dotaccentsmall","","","Macronsmall","","","figuredash","hypheninferior","","","Ogoneksmall","Ringsmall","Cedillasmall","","","","onequarter","onehalf","threequarters","questiondownsmall","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","","","zerosuperior","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","eightsuperior","ninesuperior","zeroinferior","oneinferior","twoinferior","threeinferior","fourinferior","fiveinferior","sixinferior","seveninferior","eightinferior","nineinferior","centinferior","dollarinferior","periodinferior","commainferior","Agravesmall","Aacutesmall","Acircumflexsmall","Atildesmall","Adieresissmall","Aringsmall","AEsmall","Ccedillasmall","Egravesmall","Eacutesmall","Ecircumflexsmall","Edieresissmall","Igravesmall","Iacutesmall","Icircumflexsmall","Idieresissmall","Ethsmall","Ntildesmall","Ogravesmall","Oacutesmall","Ocircumflexsmall","Otildesmall","Odieresissmall","OEsmall","Oslashsmall","Ugravesmall","Uacutesmall","Ucircumflexsmall","Udieresissmall","Yacutesmall","Thornsmall","Ydieresissmall"];t.ExpertEncoding=r;const i=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclamsmall","Hungarumlautsmall","centoldstyle","dollaroldstyle","dollarsuperior","ampersandsmall","Acutesmall","parenleftsuperior","parenrightsuperior","twodotenleader","onedotenleader","comma","hyphen","period","fraction","zerooldstyle","oneoldstyle","twooldstyle","threeoldstyle","fouroldstyle","fiveoldstyle","sixoldstyle","sevenoldstyle","eightoldstyle","nineoldstyle","colon","semicolon","","threequartersemdash","","questionsmall","","","","","Ethsmall","","","onequarter","onehalf","threequarters","oneeighth","threeeighths","fiveeighths","seveneighths","onethird","twothirds","","","","","","","ff","fi","fl","ffi","ffl","parenleftinferior","","parenrightinferior","Circumflexsmall","hypheninferior","Gravesmall","Asmall","Bsmall","Csmall","Dsmall","Esmall","Fsmall","Gsmall","Hsmall","Ismall","Jsmall","Ksmall","Lsmall","Msmall","Nsmall","Osmall","Psmall","Qsmall","Rsmall","Ssmall","Tsmall","Usmall","Vsmall","Wsmall","Xsmall","Ysmall","Zsmall","colonmonetary","onefitted","rupiah","Tildesmall","","","asuperior","centsuperior","","","","","Aacutesmall","Agravesmall","Acircumflexsmall","Adieresissmall","Atildesmall","Aringsmall","Ccedillasmall","Eacutesmall","Egravesmall","Ecircumflexsmall","Edieresissmall","Iacutesmall","Igravesmall","Icircumflexsmall","Idieresissmall","Ntildesmall","Oacutesmall","Ogravesmall","Ocircumflexsmall","Odieresissmall","Otildesmall","Uacutesmall","Ugravesmall","Ucircumflexsmall","Udieresissmall","","eightsuperior","fourinferior","threeinferior","sixinferior","eightinferior","seveninferior","Scaronsmall","","centinferior","twoinferior","","Dieresissmall","","Caronsmall","osuperior","fiveinferior","","commainferior","periodinferior","Yacutesmall","","dollarinferior","","","Thornsmall","","nineinferior","zeroinferior","Zcaronsmall","AEsmall","Oslashsmall","questiondownsmall","oneinferior","Lslashsmall","","","","","","","Cedillasmall","","","","","","OEsmall","figuredash","hyphensuperior","","","","","exclamdownsmall","","Ydieresissmall","","onesuperior","twosuperior","threesuperior","foursuperior","fivesuperior","sixsuperior","sevensuperior","ninesuperior","zerosuperior","","esuperior","rsuperior","tsuperior","","","isuperior","ssuperior","dsuperior","","","","","","lsuperior","Ogoneksmall","Brevesmall","Macronsmall","bsuperior","nsuperior","msuperior","commasuperior","periodsuperior","Dotaccentsmall","Ringsmall","","","",""],n=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","","Adieresis","Aring","Ccedilla","Eacute","Ntilde","Odieresis","Udieresis","aacute","agrave","acircumflex","adieresis","atilde","aring","ccedilla","eacute","egrave","ecircumflex","edieresis","iacute","igrave","icircumflex","idieresis","ntilde","oacute","ograve","ocircumflex","odieresis","otilde","uacute","ugrave","ucircumflex","udieresis","dagger","degree","cent","sterling","section","bullet","paragraph","germandbls","registered","copyright","trademark","acute","dieresis","notequal","AE","Oslash","infinity","plusminus","lessequal","greaterequal","yen","mu","partialdiff","summation","product","pi","integral","ordfeminine","ordmasculine","Omega","ae","oslash","questiondown","exclamdown","logicalnot","radical","florin","approxequal","Delta","guillemotleft","guillemotright","ellipsis","space","Agrave","Atilde","Otilde","OE","oe","endash","emdash","quotedblleft","quotedblright","quoteleft","quoteright","divide","lozenge","ydieresis","Ydieresis","fraction","currency","guilsinglleft","guilsinglright","fi","fl","daggerdbl","periodcentered","quotesinglbase","quotedblbase","perthousand","Acircumflex","Ecircumflex","Aacute","Edieresis","Egrave","Iacute","Icircumflex","Idieresis","Igrave","Oacute","Ocircumflex","apple","Ograve","Uacute","Ucircumflex","Ugrave","dotlessi","circumflex","tilde","macron","breve","dotaccent","ring","cedilla","hungarumlaut","ogonek","caron"];t.MacRomanEncoding=n;const s=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quoteright","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","quoteleft","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","exclamdown","cent","sterling","fraction","yen","florin","section","currency","quotesingle","quotedblleft","guillemotleft","guilsinglleft","guilsinglright","fi","fl","","endash","dagger","daggerdbl","periodcentered","","paragraph","bullet","quotesinglbase","quotedblbase","quotedblright","guillemotright","ellipsis","perthousand","","questiondown","","grave","acute","circumflex","tilde","macron","breve","dotaccent","dieresis","","ring","cedilla","","hungarumlaut","ogonek","caron","emdash","","","","","","","","","","","","","","","","","AE","","ordfeminine","","","","","Lslash","Oslash","OE","ordmasculine","","","","","","ae","","","","dotlessi","","","lslash","oslash","oe","germandbls","","","",""];t.StandardEncoding=s;const o=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","quotedbl","numbersign","dollar","percent","ampersand","quotesingle","parenleft","parenright","asterisk","plus","comma","hyphen","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","at","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","bracketleft","backslash","bracketright","asciicircum","underscore","grave","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","braceleft","bar","braceright","asciitilde","bullet","Euro","bullet","quotesinglbase","florin","quotedblbase","ellipsis","dagger","daggerdbl","circumflex","perthousand","Scaron","guilsinglleft","OE","bullet","Zcaron","bullet","bullet","quoteleft","quoteright","quotedblleft","quotedblright","bullet","endash","emdash","tilde","trademark","scaron","guilsinglright","oe","bullet","zcaron","Ydieresis","space","exclamdown","cent","sterling","currency","yen","brokenbar","section","dieresis","copyright","ordfeminine","guillemotleft","logicalnot","hyphen","registered","macron","degree","plusminus","twosuperior","threesuperior","acute","mu","paragraph","periodcentered","cedilla","onesuperior","ordmasculine","guillemotright","onequarter","onehalf","threequarters","questiondown","Agrave","Aacute","Acircumflex","Atilde","Adieresis","Aring","AE","Ccedilla","Egrave","Eacute","Ecircumflex","Edieresis","Igrave","Iacute","Icircumflex","Idieresis","Eth","Ntilde","Ograve","Oacute","Ocircumflex","Otilde","Odieresis","multiply","Oslash","Ugrave","Uacute","Ucircumflex","Udieresis","Yacute","Thorn","germandbls","agrave","aacute","acircumflex","atilde","adieresis","aring","ae","ccedilla","egrave","eacute","ecircumflex","edieresis","igrave","iacute","icircumflex","idieresis","eth","ntilde","ograve","oacute","ocircumflex","otilde","odieresis","divide","oslash","ugrave","uacute","ucircumflex","udieresis","yacute","thorn","ydieresis"];t.WinAnsiEncoding=o;const c=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","exclam","universal","numbersign","existential","percent","ampersand","suchthat","parenleft","parenright","asteriskmath","plus","comma","minus","period","slash","zero","one","two","three","four","five","six","seven","eight","nine","colon","semicolon","less","equal","greater","question","congruent","Alpha","Beta","Chi","Delta","Epsilon","Phi","Gamma","Eta","Iota","theta1","Kappa","Lambda","Mu","Nu","Omicron","Pi","Theta","Rho","Sigma","Tau","Upsilon","sigma1","Omega","Xi","Psi","Zeta","bracketleft","therefore","bracketright","perpendicular","underscore","radicalex","alpha","beta","chi","delta","epsilon","phi","gamma","eta","iota","phi1","kappa","lambda","mu","nu","omicron","pi","theta","rho","sigma","tau","upsilon","omega1","omega","xi","psi","zeta","braceleft","bar","braceright","similar","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","Euro","Upsilon1","minute","lessequal","fraction","infinity","florin","club","diamond","heart","spade","arrowboth","arrowleft","arrowup","arrowright","arrowdown","degree","plusminus","second","greaterequal","multiply","proportional","partialdiff","bullet","divide","notequal","equivalence","approxequal","ellipsis","arrowvertex","arrowhorizex","carriagereturn","aleph","Ifraktur","Rfraktur","weierstrass","circlemultiply","circleplus","emptyset","intersection","union","propersuperset","reflexsuperset","notsubset","propersubset","reflexsubset","element","notelement","angle","gradient","registerserif","copyrightserif","trademarkserif","product","radical","dotmath","logicalnot","logicaland","logicalor","arrowdblboth","arrowdblleft","arrowdblup","arrowdblright","arrowdbldown","lozenge","angleleft","registersans","copyrightsans","trademarksans","summation","parenlefttp","parenleftex","parenleftbt","bracketlefttp","bracketleftex","bracketleftbt","bracelefttp","braceleftmid","braceleftbt","braceex","","angleright","integral","integraltp","integralex","integralbt","parenrighttp","parenrightex","parenrightbt","bracketrighttp","bracketrightex","bracketrightbt","bracerighttp","bracerightmid","bracerightbt",""];t.SymbolSetEncoding=c;const l=["","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","space","a1","a2","a202","a3","a4","a5","a119","a118","a117","a11","a12","a13","a14","a15","a16","a105","a17","a18","a19","a20","a21","a22","a23","a24","a25","a26","a27","a28","a6","a7","a8","a9","a10","a29","a30","a31","a32","a33","a34","a35","a36","a37","a38","a39","a40","a41","a42","a43","a44","a45","a46","a47","a48","a49","a50","a51","a52","a53","a54","a55","a56","a57","a58","a59","a60","a61","a62","a63","a64","a65","a66","a67","a68","a69","a70","a71","a72","a73","a74","a203","a75","a204","a76","a77","a78","a79","a81","a82","a83","a84","a97","a98","a99","a100","","a89","a90","a93","a94","a91","a92","a205","a85","a206","a86","a87","a88","a95","a96","","","","","","","","","","","","","","","","","","","","a101","a102","a103","a104","a106","a107","a108","a112","a111","a110","a109","a120","a121","a122","a123","a124","a125","a126","a127","a128","a129","a130","a131","a132","a133","a134","a135","a136","a137","a138","a139","a140","a141","a142","a143","a144","a145","a146","a147","a148","a149","a150","a151","a152","a153","a154","a155","a156","a157","a158","a159","a160","a161","a163","a164","a196","a165","a192","a166","a167","a168","a169","a170","a171","a172","a173","a162","a174","a175","a176","a177","a178","a179","a193","a180","a199","a181","a200","a182","","a201","a183","a184","a197","a185","a194","a198","a186","a195","a187","a188","a189","a190","a191",""];t.ZapfDingbatsEncoding=l},function(e,t,a){var r=a(7).getLookupTableFactory,i=r((function(e){e.A=65;e.AE=198;e.AEacute=508;e.AEmacron=482;e.AEsmall=63462;e.Aacute=193;e.Aacutesmall=63457;e.Abreve=258;e.Abreveacute=7854;e.Abrevecyrillic=1232;e.Abrevedotbelow=7862;e.Abrevegrave=7856;e.Abrevehookabove=7858;e.Abrevetilde=7860;e.Acaron=461;e.Acircle=9398;e.Acircumflex=194;e.Acircumflexacute=7844;e.Acircumflexdotbelow=7852;e.Acircumflexgrave=7846;e.Acircumflexhookabove=7848;e.Acircumflexsmall=63458;e.Acircumflextilde=7850;e.Acute=63177;e.Acutesmall=63412;e.Acyrillic=1040;e.Adblgrave=512;e.Adieresis=196;e.Adieresiscyrillic=1234;e.Adieresismacron=478;e.Adieresissmall=63460;e.Adotbelow=7840;e.Adotmacron=480;e.Agrave=192;e.Agravesmall=63456;e.Ahookabove=7842;e.Aiecyrillic=1236;e.Ainvertedbreve=514;e.Alpha=913;e.Alphatonos=902;e.Amacron=256;e.Amonospace=65313;e.Aogonek=260;e.Aring=197;e.Aringacute=506;e.Aringbelow=7680;e.Aringsmall=63461;e.Asmall=63329;e.Atilde=195;e.Atildesmall=63459;e.Aybarmenian=1329;e.B=66;e.Bcircle=9399;e.Bdotaccent=7682;e.Bdotbelow=7684;e.Becyrillic=1041;e.Benarmenian=1330;e.Beta=914;e.Bhook=385;e.Blinebelow=7686;e.Bmonospace=65314;e.Brevesmall=63220;e.Bsmall=63330;e.Btopbar=386;e.C=67;e.Caarmenian=1342;e.Cacute=262;e.Caron=63178;e.Caronsmall=63221;e.Ccaron=268;e.Ccedilla=199;e.Ccedillaacute=7688;e.Ccedillasmall=63463;e.Ccircle=9400;e.Ccircumflex=264;e.Cdot=266;e.Cdotaccent=266;e.Cedillasmall=63416;e.Chaarmenian=1353;e.Cheabkhasiancyrillic=1212;e.Checyrillic=1063;e.Chedescenderabkhasiancyrillic=1214;e.Chedescendercyrillic=1206;e.Chedieresiscyrillic=1268;e.Cheharmenian=1347;e.Chekhakassiancyrillic=1227;e.Cheverticalstrokecyrillic=1208;e.Chi=935;e.Chook=391;e.Circumflexsmall=63222;e.Cmonospace=65315;e.Coarmenian=1361;e.Csmall=63331;e.D=68;e.DZ=497;e.DZcaron=452;e.Daarmenian=1332;e.Dafrican=393;e.Dcaron=270;e.Dcedilla=7696;e.Dcircle=9401;e.Dcircumflexbelow=7698;e.Dcroat=272;e.Ddotaccent=7690;e.Ddotbelow=7692;e.Decyrillic=1044;e.Deicoptic=1006;e.Delta=8710;e.Deltagreek=916;e.Dhook=394;e.Dieresis=63179;e.DieresisAcute=63180;e.DieresisGrave=63181;e.Dieresissmall=63400;e.Digammagreek=988;e.Djecyrillic=1026;e.Dlinebelow=7694;e.Dmonospace=65316;e.Dotaccentsmall=63223;e.Dslash=272;e.Dsmall=63332;e.Dtopbar=395;e.Dz=498;e.Dzcaron=453;e.Dzeabkhasiancyrillic=1248;e.Dzecyrillic=1029;e.Dzhecyrillic=1039;e.E=69;e.Eacute=201;e.Eacutesmall=63465;e.Ebreve=276;e.Ecaron=282;e.Ecedillabreve=7708;e.Echarmenian=1333;e.Ecircle=9402;e.Ecircumflex=202;e.Ecircumflexacute=7870;e.Ecircumflexbelow=7704;e.Ecircumflexdotbelow=7878;e.Ecircumflexgrave=7872;e.Ecircumflexhookabove=7874;e.Ecircumflexsmall=63466;e.Ecircumflextilde=7876;e.Ecyrillic=1028;e.Edblgrave=516;e.Edieresis=203;e.Edieresissmall=63467;e.Edot=278;e.Edotaccent=278;e.Edotbelow=7864;e.Efcyrillic=1060;e.Egrave=200;e.Egravesmall=63464;e.Eharmenian=1335;e.Ehookabove=7866;e.Eightroman=8551;e.Einvertedbreve=518;e.Eiotifiedcyrillic=1124;e.Elcyrillic=1051;e.Elevenroman=8554;e.Emacron=274;e.Emacronacute=7702;e.Emacrongrave=7700;e.Emcyrillic=1052;e.Emonospace=65317;e.Encyrillic=1053;e.Endescendercyrillic=1186;e.Eng=330;e.Enghecyrillic=1188;e.Enhookcyrillic=1223;e.Eogonek=280;e.Eopen=400;e.Epsilon=917;e.Epsilontonos=904;e.Ercyrillic=1056;e.Ereversed=398;e.Ereversedcyrillic=1069;e.Escyrillic=1057;e.Esdescendercyrillic=1194;e.Esh=425;e.Esmall=63333;e.Eta=919;e.Etarmenian=1336;e.Etatonos=905;e.Eth=208;e.Ethsmall=63472;e.Etilde=7868;e.Etildebelow=7706;e.Euro=8364;e.Ezh=439;e.Ezhcaron=494;e.Ezhreversed=440;e.F=70;e.Fcircle=9403;e.Fdotaccent=7710;e.Feharmenian=1366;e.Feicoptic=996;e.Fhook=401;e.Fitacyrillic=1138;e.Fiveroman=8548;e.Fmonospace=65318;e.Fourroman=8547;e.Fsmall=63334;e.G=71;e.GBsquare=13191;e.Gacute=500;e.Gamma=915;e.Gammaafrican=404;e.Gangiacoptic=1002;e.Gbreve=286;e.Gcaron=486;e.Gcedilla=290;e.Gcircle=9404;e.Gcircumflex=284;e.Gcommaaccent=290;e.Gdot=288;e.Gdotaccent=288;e.Gecyrillic=1043;e.Ghadarmenian=1346;e.Ghemiddlehookcyrillic=1172;e.Ghestrokecyrillic=1170;e.Gheupturncyrillic=1168;e.Ghook=403;e.Gimarmenian=1331;e.Gjecyrillic=1027;e.Gmacron=7712;e.Gmonospace=65319;e.Grave=63182;e.Gravesmall=63328;e.Gsmall=63335;e.Gsmallhook=667;e.Gstroke=484;e.H=72;e.H18533=9679;e.H18543=9642;e.H18551=9643;e.H22073=9633;e.HPsquare=13259;e.Haabkhasiancyrillic=1192;e.Hadescendercyrillic=1202;e.Hardsigncyrillic=1066;e.Hbar=294;e.Hbrevebelow=7722;e.Hcedilla=7720;e.Hcircle=9405;e.Hcircumflex=292;e.Hdieresis=7718;e.Hdotaccent=7714;e.Hdotbelow=7716;e.Hmonospace=65320;e.Hoarmenian=1344;e.Horicoptic=1e3;e.Hsmall=63336;e.Hungarumlaut=63183;e.Hungarumlautsmall=63224;e.Hzsquare=13200;e.I=73;e.IAcyrillic=1071;e.IJ=306;e.IUcyrillic=1070;e.Iacute=205;e.Iacutesmall=63469;e.Ibreve=300;e.Icaron=463;e.Icircle=9406;e.Icircumflex=206;e.Icircumflexsmall=63470;e.Icyrillic=1030;e.Idblgrave=520;e.Idieresis=207;e.Idieresisacute=7726;e.Idieresiscyrillic=1252;e.Idieresissmall=63471;e.Idot=304;e.Idotaccent=304;e.Idotbelow=7882;e.Iebrevecyrillic=1238;e.Iecyrillic=1045;e.Ifraktur=8465;e.Igrave=204;e.Igravesmall=63468;e.Ihookabove=7880;e.Iicyrillic=1048;e.Iinvertedbreve=522;e.Iishortcyrillic=1049;e.Imacron=298;e.Imacroncyrillic=1250;e.Imonospace=65321;e.Iniarmenian=1339;e.Iocyrillic=1025;e.Iogonek=302;e.Iota=921;e.Iotaafrican=406;e.Iotadieresis=938;e.Iotatonos=906;e.Ismall=63337;e.Istroke=407;e.Itilde=296;e.Itildebelow=7724;e.Izhitsacyrillic=1140;e.Izhitsadblgravecyrillic=1142;e.J=74;e.Jaarmenian=1345;e.Jcircle=9407;e.Jcircumflex=308;e.Jecyrillic=1032;e.Jheharmenian=1355;e.Jmonospace=65322;e.Jsmall=63338;e.K=75;e.KBsquare=13189;e.KKsquare=13261;e.Kabashkircyrillic=1184;e.Kacute=7728;e.Kacyrillic=1050;e.Kadescendercyrillic=1178;e.Kahookcyrillic=1219;e.Kappa=922;e.Kastrokecyrillic=1182;e.Kaverticalstrokecyrillic=1180;e.Kcaron=488;e.Kcedilla=310;e.Kcircle=9408;e.Kcommaaccent=310;e.Kdotbelow=7730;e.Keharmenian=1364;e.Kenarmenian=1343;e.Khacyrillic=1061;e.Kheicoptic=998;e.Khook=408;e.Kjecyrillic=1036;e.Klinebelow=7732;e.Kmonospace=65323;e.Koppacyrillic=1152;e.Koppagreek=990;e.Ksicyrillic=1134;e.Ksmall=63339;e.L=76;e.LJ=455;e.LL=63167;e.Lacute=313;e.Lambda=923;e.Lcaron=317;e.Lcedilla=315;e.Lcircle=9409;e.Lcircumflexbelow=7740;e.Lcommaaccent=315;e.Ldot=319;e.Ldotaccent=319;e.Ldotbelow=7734;e.Ldotbelowmacron=7736;e.Liwnarmenian=1340;e.Lj=456;e.Ljecyrillic=1033;e.Llinebelow=7738;e.Lmonospace=65324;e.Lslash=321;e.Lslashsmall=63225;e.Lsmall=63340;e.M=77;e.MBsquare=13190;e.Macron=63184;e.Macronsmall=63407;e.Macute=7742;e.Mcircle=9410;e.Mdotaccent=7744;e.Mdotbelow=7746;e.Menarmenian=1348;e.Mmonospace=65325;e.Msmall=63341;e.Mturned=412;e.Mu=924;e.N=78;e.NJ=458;e.Nacute=323;e.Ncaron=327;e.Ncedilla=325;e.Ncircle=9411;e.Ncircumflexbelow=7754;e.Ncommaaccent=325;e.Ndotaccent=7748;e.Ndotbelow=7750;e.Nhookleft=413;e.Nineroman=8552;e.Nj=459;e.Njecyrillic=1034;e.Nlinebelow=7752;e.Nmonospace=65326;e.Nowarmenian=1350;e.Nsmall=63342;e.Ntilde=209;e.Ntildesmall=63473;e.Nu=925;e.O=79;e.OE=338;e.OEsmall=63226;e.Oacute=211;e.Oacutesmall=63475;e.Obarredcyrillic=1256;e.Obarreddieresiscyrillic=1258;e.Obreve=334;e.Ocaron=465;e.Ocenteredtilde=415;e.Ocircle=9412;e.Ocircumflex=212;e.Ocircumflexacute=7888;e.Ocircumflexdotbelow=7896;e.Ocircumflexgrave=7890;e.Ocircumflexhookabove=7892;e.Ocircumflexsmall=63476;e.Ocircumflextilde=7894;e.Ocyrillic=1054;e.Odblacute=336;e.Odblgrave=524;e.Odieresis=214;e.Odieresiscyrillic=1254;e.Odieresissmall=63478;e.Odotbelow=7884;e.Ogoneksmall=63227;e.Ograve=210;e.Ogravesmall=63474;e.Oharmenian=1365;e.Ohm=8486;e.Ohookabove=7886;e.Ohorn=416;e.Ohornacute=7898;e.Ohorndotbelow=7906;e.Ohorngrave=7900;e.Ohornhookabove=7902;e.Ohorntilde=7904;e.Ohungarumlaut=336;e.Oi=418;e.Oinvertedbreve=526;e.Omacron=332;e.Omacronacute=7762;e.Omacrongrave=7760;e.Omega=8486;e.Omegacyrillic=1120;e.Omegagreek=937;e.Omegaroundcyrillic=1146;e.Omegatitlocyrillic=1148;e.Omegatonos=911;e.Omicron=927;e.Omicrontonos=908;e.Omonospace=65327;e.Oneroman=8544;e.Oogonek=490;e.Oogonekmacron=492;e.Oopen=390;e.Oslash=216;e.Oslashacute=510;e.Oslashsmall=63480;e.Osmall=63343;e.Ostrokeacute=510;e.Otcyrillic=1150;e.Otilde=213;e.Otildeacute=7756;e.Otildedieresis=7758;e.Otildesmall=63477;e.P=80;e.Pacute=7764;e.Pcircle=9413;e.Pdotaccent=7766;e.Pecyrillic=1055;e.Peharmenian=1354;e.Pemiddlehookcyrillic=1190;e.Phi=934;e.Phook=420;e.Pi=928;e.Piwrarmenian=1363;e.Pmonospace=65328;e.Psi=936;e.Psicyrillic=1136;e.Psmall=63344;e.Q=81;e.Qcircle=9414;e.Qmonospace=65329;e.Qsmall=63345;e.R=82;e.Raarmenian=1356;e.Racute=340;e.Rcaron=344;e.Rcedilla=342;e.Rcircle=9415;e.Rcommaaccent=342;e.Rdblgrave=528;e.Rdotaccent=7768;e.Rdotbelow=7770;e.Rdotbelowmacron=7772;e.Reharmenian=1360;e.Rfraktur=8476;e.Rho=929;e.Ringsmall=63228;e.Rinvertedbreve=530;e.Rlinebelow=7774;e.Rmonospace=65330;e.Rsmall=63346;e.Rsmallinverted=641;e.Rsmallinvertedsuperior=694;e.S=83;e.SF010000=9484;e.SF020000=9492;e.SF030000=9488;e.SF040000=9496;e.SF050000=9532;e.SF060000=9516;e.SF070000=9524;e.SF080000=9500;e.SF090000=9508;e.SF100000=9472;e.SF110000=9474;e.SF190000=9569;e.SF200000=9570;e.SF210000=9558;e.SF220000=9557;e.SF230000=9571;e.SF240000=9553;e.SF250000=9559;e.SF260000=9565;e.SF270000=9564;e.SF280000=9563;e.SF360000=9566;e.SF370000=9567;e.SF380000=9562;e.SF390000=9556;e.SF400000=9577;e.SF410000=9574;e.SF420000=9568;e.SF430000=9552;e.SF440000=9580;e.SF450000=9575;e.SF460000=9576;e.SF470000=9572;e.SF480000=9573;e.SF490000=9561;e.SF500000=9560;e.SF510000=9554;e.SF520000=9555;e.SF530000=9579;e.SF540000=9578;e.Sacute=346;e.Sacutedotaccent=7780;e.Sampigreek=992;e.Scaron=352;e.Scarondotaccent=7782;e.Scaronsmall=63229;e.Scedilla=350;e.Schwa=399;e.Schwacyrillic=1240;e.Schwadieresiscyrillic=1242;e.Scircle=9416;e.Scircumflex=348;e.Scommaaccent=536;e.Sdotaccent=7776;e.Sdotbelow=7778;e.Sdotbelowdotaccent=7784;e.Seharmenian=1357;e.Sevenroman=8550;e.Shaarmenian=1351;e.Shacyrillic=1064;e.Shchacyrillic=1065;e.Sheicoptic=994;e.Shhacyrillic=1210;e.Shimacoptic=1004;e.Sigma=931;e.Sixroman=8549;e.Smonospace=65331;e.Softsigncyrillic=1068;e.Ssmall=63347;e.Stigmagreek=986;e.T=84;e.Tau=932;e.Tbar=358;e.Tcaron=356;e.Tcedilla=354;e.Tcircle=9417;e.Tcircumflexbelow=7792;e.Tcommaaccent=354;e.Tdotaccent=7786;e.Tdotbelow=7788;e.Tecyrillic=1058;e.Tedescendercyrillic=1196;e.Tenroman=8553;e.Tetsecyrillic=1204;e.Theta=920;e.Thook=428;e.Thorn=222;e.Thornsmall=63486;e.Threeroman=8546;e.Tildesmall=63230;e.Tiwnarmenian=1359;e.Tlinebelow=7790;e.Tmonospace=65332;e.Toarmenian=1337;e.Tonefive=444;e.Tonesix=388;e.Tonetwo=423;e.Tretroflexhook=430;e.Tsecyrillic=1062;e.Tshecyrillic=1035;e.Tsmall=63348;e.Twelveroman=8555;e.Tworoman=8545;e.U=85;e.Uacute=218;e.Uacutesmall=63482;e.Ubreve=364;e.Ucaron=467;e.Ucircle=9418;e.Ucircumflex=219;e.Ucircumflexbelow=7798;e.Ucircumflexsmall=63483;e.Ucyrillic=1059;e.Udblacute=368;e.Udblgrave=532;e.Udieresis=220;e.Udieresisacute=471;e.Udieresisbelow=7794;e.Udieresiscaron=473;e.Udieresiscyrillic=1264;e.Udieresisgrave=475;e.Udieresismacron=469;e.Udieresissmall=63484;e.Udotbelow=7908;e.Ugrave=217;e.Ugravesmall=63481;e.Uhookabove=7910;e.Uhorn=431;e.Uhornacute=7912;e.Uhorndotbelow=7920;e.Uhorngrave=7914;e.Uhornhookabove=7916;e.Uhorntilde=7918;e.Uhungarumlaut=368;e.Uhungarumlautcyrillic=1266;e.Uinvertedbreve=534;e.Ukcyrillic=1144;e.Umacron=362;e.Umacroncyrillic=1262;e.Umacrondieresis=7802;e.Umonospace=65333;e.Uogonek=370;e.Upsilon=933;e.Upsilon1=978;e.Upsilonacutehooksymbolgreek=979;e.Upsilonafrican=433;e.Upsilondieresis=939;e.Upsilondieresishooksymbolgreek=980;e.Upsilonhooksymbol=978;e.Upsilontonos=910;e.Uring=366;e.Ushortcyrillic=1038;e.Usmall=63349;e.Ustraightcyrillic=1198;e.Ustraightstrokecyrillic=1200;e.Utilde=360;e.Utildeacute=7800;e.Utildebelow=7796;e.V=86;e.Vcircle=9419;e.Vdotbelow=7806;e.Vecyrillic=1042;e.Vewarmenian=1358;e.Vhook=434;e.Vmonospace=65334;e.Voarmenian=1352;e.Vsmall=63350;e.Vtilde=7804;e.W=87;e.Wacute=7810;e.Wcircle=9420;e.Wcircumflex=372;e.Wdieresis=7812;e.Wdotaccent=7814;e.Wdotbelow=7816;e.Wgrave=7808;e.Wmonospace=65335;e.Wsmall=63351;e.X=88;e.Xcircle=9421;e.Xdieresis=7820;e.Xdotaccent=7818;e.Xeharmenian=1341;e.Xi=926;e.Xmonospace=65336;e.Xsmall=63352;e.Y=89;e.Yacute=221;e.Yacutesmall=63485;e.Yatcyrillic=1122;e.Ycircle=9422;e.Ycircumflex=374;e.Ydieresis=376;e.Ydieresissmall=63487;e.Ydotaccent=7822;e.Ydotbelow=7924;e.Yericyrillic=1067;e.Yerudieresiscyrillic=1272;e.Ygrave=7922;e.Yhook=435;e.Yhookabove=7926;e.Yiarmenian=1349;e.Yicyrillic=1031;e.Yiwnarmenian=1362;e.Ymonospace=65337;e.Ysmall=63353;e.Ytilde=7928;e.Yusbigcyrillic=1130;e.Yusbigiotifiedcyrillic=1132;e.Yuslittlecyrillic=1126;e.Yuslittleiotifiedcyrillic=1128;e.Z=90;e.Zaarmenian=1334;e.Zacute=377;e.Zcaron=381;e.Zcaronsmall=63231;e.Zcircle=9423;e.Zcircumflex=7824;e.Zdot=379;e.Zdotaccent=379;e.Zdotbelow=7826;e.Zecyrillic=1047;e.Zedescendercyrillic=1176;e.Zedieresiscyrillic=1246;e.Zeta=918;e.Zhearmenian=1338;e.Zhebrevecyrillic=1217;e.Zhecyrillic=1046;e.Zhedescendercyrillic=1174;e.Zhedieresiscyrillic=1244;e.Zlinebelow=7828;e.Zmonospace=65338;e.Zsmall=63354;e.Zstroke=437;e.a=97;e.aabengali=2438;e.aacute=225;e.aadeva=2310;e.aagujarati=2694;e.aagurmukhi=2566;e.aamatragurmukhi=2622;e.aarusquare=13059;e.aavowelsignbengali=2494;e.aavowelsigndeva=2366;e.aavowelsigngujarati=2750;e.abbreviationmarkarmenian=1375;e.abbreviationsigndeva=2416;e.abengali=2437;e.abopomofo=12570;e.abreve=259;e.abreveacute=7855;e.abrevecyrillic=1233;e.abrevedotbelow=7863;e.abrevegrave=7857;e.abrevehookabove=7859;e.abrevetilde=7861;e.acaron=462;e.acircle=9424;e.acircumflex=226;e.acircumflexacute=7845;e.acircumflexdotbelow=7853;e.acircumflexgrave=7847;e.acircumflexhookabove=7849;e.acircumflextilde=7851;e.acute=180;e.acutebelowcmb=791;e.acutecmb=769;e.acutecomb=769;e.acutedeva=2388;e.acutelowmod=719;e.acutetonecmb=833;e.acyrillic=1072;e.adblgrave=513;e.addakgurmukhi=2673;e.adeva=2309;e.adieresis=228;e.adieresiscyrillic=1235;e.adieresismacron=479;e.adotbelow=7841;e.adotmacron=481;e.ae=230;e.aeacute=509;e.aekorean=12624;e.aemacron=483;e.afii00208=8213;e.afii08941=8356;e.afii10017=1040;e.afii10018=1041;e.afii10019=1042;e.afii10020=1043;e.afii10021=1044;e.afii10022=1045;e.afii10023=1025;e.afii10024=1046;e.afii10025=1047;e.afii10026=1048;e.afii10027=1049;e.afii10028=1050;e.afii10029=1051;e.afii10030=1052;e.afii10031=1053;e.afii10032=1054;e.afii10033=1055;e.afii10034=1056;e.afii10035=1057;e.afii10036=1058;e.afii10037=1059;e.afii10038=1060;e.afii10039=1061;e.afii10040=1062;e.afii10041=1063;e.afii10042=1064;e.afii10043=1065;e.afii10044=1066;e.afii10045=1067;e.afii10046=1068;e.afii10047=1069;e.afii10048=1070;e.afii10049=1071;e.afii10050=1168;e.afii10051=1026;e.afii10052=1027;e.afii10053=1028;e.afii10054=1029;e.afii10055=1030;e.afii10056=1031;e.afii10057=1032;e.afii10058=1033;e.afii10059=1034;e.afii10060=1035;e.afii10061=1036;e.afii10062=1038;e.afii10063=63172;e.afii10064=63173;e.afii10065=1072;e.afii10066=1073;e.afii10067=1074;e.afii10068=1075;e.afii10069=1076;e.afii10070=1077;e.afii10071=1105;e.afii10072=1078;e.afii10073=1079;e.afii10074=1080;e.afii10075=1081;e.afii10076=1082;e.afii10077=1083;e.afii10078=1084;e.afii10079=1085;e.afii10080=1086;e.afii10081=1087;e.afii10082=1088;e.afii10083=1089;e.afii10084=1090;e.afii10085=1091;e.afii10086=1092;e.afii10087=1093;e.afii10088=1094;e.afii10089=1095;e.afii10090=1096;e.afii10091=1097;e.afii10092=1098;e.afii10093=1099;e.afii10094=1100;e.afii10095=1101;e.afii10096=1102;e.afii10097=1103;e.afii10098=1169;e.afii10099=1106;e.afii10100=1107;e.afii10101=1108;e.afii10102=1109;e.afii10103=1110;e.afii10104=1111;e.afii10105=1112;e.afii10106=1113;e.afii10107=1114;e.afii10108=1115;e.afii10109=1116;e.afii10110=1118;e.afii10145=1039;e.afii10146=1122;e.afii10147=1138;e.afii10148=1140;e.afii10192=63174;e.afii10193=1119;e.afii10194=1123;e.afii10195=1139;e.afii10196=1141;e.afii10831=63175;e.afii10832=63176;e.afii10846=1241;e.afii299=8206;e.afii300=8207;e.afii301=8205;e.afii57381=1642;e.afii57388=1548;e.afii57392=1632;e.afii57393=1633;e.afii57394=1634;e.afii57395=1635;e.afii57396=1636;e.afii57397=1637;e.afii57398=1638;e.afii57399=1639;e.afii57400=1640;e.afii57401=1641;e.afii57403=1563;e.afii57407=1567;e.afii57409=1569;e.afii57410=1570;e.afii57411=1571;e.afii57412=1572;e.afii57413=1573;e.afii57414=1574;e.afii57415=1575;e.afii57416=1576;e.afii57417=1577;e.afii57418=1578;e.afii57419=1579;e.afii57420=1580;e.afii57421=1581;e.afii57422=1582;e.afii57423=1583;e.afii57424=1584;e.afii57425=1585;e.afii57426=1586;e.afii57427=1587;e.afii57428=1588;e.afii57429=1589;e.afii57430=1590;e.afii57431=1591;e.afii57432=1592;e.afii57433=1593;e.afii57434=1594;e.afii57440=1600;e.afii57441=1601;e.afii57442=1602;e.afii57443=1603;e.afii57444=1604;e.afii57445=1605;e.afii57446=1606;e.afii57448=1608;e.afii57449=1609;e.afii57450=1610;e.afii57451=1611;e.afii57452=1612;e.afii57453=1613;e.afii57454=1614;e.afii57455=1615;e.afii57456=1616;e.afii57457=1617;e.afii57458=1618;e.afii57470=1607;e.afii57505=1700;e.afii57506=1662;e.afii57507=1670;e.afii57508=1688;e.afii57509=1711;e.afii57511=1657;e.afii57512=1672;e.afii57513=1681;e.afii57514=1722;e.afii57519=1746;e.afii57534=1749;e.afii57636=8362;e.afii57645=1470;e.afii57658=1475;e.afii57664=1488;e.afii57665=1489;e.afii57666=1490;e.afii57667=1491;e.afii57668=1492;e.afii57669=1493;e.afii57670=1494;e.afii57671=1495;e.afii57672=1496;e.afii57673=1497;e.afii57674=1498;e.afii57675=1499;e.afii57676=1500;e.afii57677=1501;e.afii57678=1502;e.afii57679=1503;e.afii57680=1504;e.afii57681=1505;e.afii57682=1506;e.afii57683=1507;e.afii57684=1508;e.afii57685=1509;e.afii57686=1510;e.afii57687=1511;e.afii57688=1512;e.afii57689=1513;e.afii57690=1514;e.afii57694=64298;e.afii57695=64299;e.afii57700=64331;e.afii57705=64287;e.afii57716=1520;e.afii57717=1521;e.afii57718=1522;e.afii57723=64309;e.afii57793=1460;e.afii57794=1461;e.afii57795=1462;e.afii57796=1467;e.afii57797=1464;e.afii57798=1463;e.afii57799=1456;e.afii57800=1458;e.afii57801=1457;e.afii57802=1459;e.afii57803=1474;e.afii57804=1473;e.afii57806=1465;e.afii57807=1468;e.afii57839=1469;e.afii57841=1471;e.afii57842=1472;e.afii57929=700;e.afii61248=8453;e.afii61289=8467;e.afii61352=8470;e.afii61573=8236;e.afii61574=8237;e.afii61575=8238;e.afii61664=8204;e.afii63167=1645;e.afii64937=701;e.agrave=224;e.agujarati=2693;e.agurmukhi=2565;e.ahiragana=12354;e.ahookabove=7843;e.aibengali=2448;e.aibopomofo=12574;e.aideva=2320;e.aiecyrillic=1237;e.aigujarati=2704;e.aigurmukhi=2576;e.aimatragurmukhi=2632;e.ainarabic=1593;e.ainfinalarabic=65226;e.aininitialarabic=65227;e.ainmedialarabic=65228;e.ainvertedbreve=515;e.aivowelsignbengali=2504;e.aivowelsigndeva=2376;e.aivowelsigngujarati=2760;e.akatakana=12450;e.akatakanahalfwidth=65393;e.akorean=12623;e.alef=1488;e.alefarabic=1575;e.alefdageshhebrew=64304;e.aleffinalarabic=65166;e.alefhamzaabovearabic=1571;e.alefhamzaabovefinalarabic=65156;e.alefhamzabelowarabic=1573;e.alefhamzabelowfinalarabic=65160;e.alefhebrew=1488;e.aleflamedhebrew=64335;e.alefmaddaabovearabic=1570;e.alefmaddaabovefinalarabic=65154;e.alefmaksuraarabic=1609;e.alefmaksurafinalarabic=65264;e.alefmaksurainitialarabic=65267;e.alefmaksuramedialarabic=65268;e.alefpatahhebrew=64302;e.alefqamatshebrew=64303;e.aleph=8501;e.allequal=8780;e.alpha=945;e.alphatonos=940;e.amacron=257;e.amonospace=65345;e.ampersand=38;e.ampersandmonospace=65286;e.ampersandsmall=63270;e.amsquare=13250;e.anbopomofo=12578;e.angbopomofo=12580;e.angbracketleft=12296;e.angbracketright=12297;e.angkhankhuthai=3674;e.angle=8736;e.anglebracketleft=12296;e.anglebracketleftvertical=65087;e.anglebracketright=12297;e.anglebracketrightvertical=65088;e.angleleft=9001;e.angleright=9002;e.angstrom=8491;e.anoteleia=903;e.anudattadeva=2386;e.anusvarabengali=2434;e.anusvaradeva=2306;e.anusvaragujarati=2690;e.aogonek=261;e.apaatosquare=13056;e.aparen=9372;e.apostrophearmenian=1370;e.apostrophemod=700;e.apple=63743;e.approaches=8784;e.approxequal=8776;e.approxequalorimage=8786;e.approximatelyequal=8773;e.araeaekorean=12686;e.araeakorean=12685;e.arc=8978;e.arighthalfring=7834;e.aring=229;e.aringacute=507;e.aringbelow=7681;e.arrowboth=8596;e.arrowdashdown=8675;e.arrowdashleft=8672;e.arrowdashright=8674;e.arrowdashup=8673;e.arrowdblboth=8660;e.arrowdbldown=8659;e.arrowdblleft=8656;e.arrowdblright=8658;e.arrowdblup=8657;e.arrowdown=8595;e.arrowdownleft=8601;e.arrowdownright=8600;e.arrowdownwhite=8681;e.arrowheaddownmod=709;e.arrowheadleftmod=706;e.arrowheadrightmod=707;e.arrowheadupmod=708;e.arrowhorizex=63719;e.arrowleft=8592;e.arrowleftdbl=8656;e.arrowleftdblstroke=8653;e.arrowleftoverright=8646;e.arrowleftwhite=8678;e.arrowright=8594;e.arrowrightdblstroke=8655;e.arrowrightheavy=10142;e.arrowrightoverleft=8644;e.arrowrightwhite=8680;e.arrowtableft=8676;e.arrowtabright=8677;e.arrowup=8593;e.arrowupdn=8597;e.arrowupdnbse=8616;e.arrowupdownbase=8616;e.arrowupleft=8598;e.arrowupleftofdown=8645;e.arrowupright=8599;e.arrowupwhite=8679;e.arrowvertex=63718;e.asciicircum=94;e.asciicircummonospace=65342;e.asciitilde=126;e.asciitildemonospace=65374;e.ascript=593;e.ascriptturned=594;e.asmallhiragana=12353;e.asmallkatakana=12449;e.asmallkatakanahalfwidth=65383;e.asterisk=42;e.asteriskaltonearabic=1645;e.asteriskarabic=1645;e.asteriskmath=8727;e.asteriskmonospace=65290;e.asterisksmall=65121;e.asterism=8258;e.asuperior=63209;e.asymptoticallyequal=8771;e.at=64;e.atilde=227;e.atmonospace=65312;e.atsmall=65131;e.aturned=592;e.aubengali=2452;e.aubopomofo=12576;e.audeva=2324;e.augujarati=2708;e.augurmukhi=2580;e.aulengthmarkbengali=2519;e.aumatragurmukhi=2636;e.auvowelsignbengali=2508;e.auvowelsigndeva=2380;e.auvowelsigngujarati=2764;e.avagrahadeva=2365;e.aybarmenian=1377;e.ayin=1506;e.ayinaltonehebrew=64288;e.ayinhebrew=1506;e.b=98;e.babengali=2476;e.backslash=92;e.backslashmonospace=65340;e.badeva=2348;e.bagujarati=2732;e.bagurmukhi=2604;e.bahiragana=12400;e.bahtthai=3647;e.bakatakana=12496;e.bar=124;e.barmonospace=65372;e.bbopomofo=12549;e.bcircle=9425;e.bdotaccent=7683;e.bdotbelow=7685;e.beamedsixteenthnotes=9836;e.because=8757;e.becyrillic=1073;e.beharabic=1576;e.behfinalarabic=65168;e.behinitialarabic=65169;e.behiragana=12409;e.behmedialarabic=65170;e.behmeeminitialarabic=64671;e.behmeemisolatedarabic=64520;e.behnoonfinalarabic=64621;e.bekatakana=12505;e.benarmenian=1378;e.bet=1489;e.beta=946;e.betasymbolgreek=976;e.betdagesh=64305;e.betdageshhebrew=64305;e.bethebrew=1489;e.betrafehebrew=64332;e.bhabengali=2477;e.bhadeva=2349;e.bhagujarati=2733;e.bhagurmukhi=2605;e.bhook=595;e.bihiragana=12403;e.bikatakana=12499;e.bilabialclick=664;e.bindigurmukhi=2562;e.birusquare=13105;e.blackcircle=9679;e.blackdiamond=9670;e.blackdownpointingtriangle=9660;e.blackleftpointingpointer=9668;e.blackleftpointingtriangle=9664;e.blacklenticularbracketleft=12304;e.blacklenticularbracketleftvertical=65083;e.blacklenticularbracketright=12305;e.blacklenticularbracketrightvertical=65084;e.blacklowerlefttriangle=9699;e.blacklowerrighttriangle=9698;e.blackrectangle=9644;e.blackrightpointingpointer=9658;e.blackrightpointingtriangle=9654;e.blacksmallsquare=9642;e.blacksmilingface=9787;e.blacksquare=9632;e.blackstar=9733;e.blackupperlefttriangle=9700;e.blackupperrighttriangle=9701;e.blackuppointingsmalltriangle=9652;e.blackuppointingtriangle=9650;e.blank=9251;e.blinebelow=7687;e.block=9608;e.bmonospace=65346;e.bobaimaithai=3610;e.bohiragana=12412;e.bokatakana=12508;e.bparen=9373;e.bqsquare=13251;e.braceex=63732;e.braceleft=123;e.braceleftbt=63731;e.braceleftmid=63730;e.braceleftmonospace=65371;e.braceleftsmall=65115;e.bracelefttp=63729;e.braceleftvertical=65079;e.braceright=125;e.bracerightbt=63742;e.bracerightmid=63741;e.bracerightmonospace=65373;e.bracerightsmall=65116;e.bracerighttp=63740;e.bracerightvertical=65080;e.bracketleft=91;e.bracketleftbt=63728;e.bracketleftex=63727;e.bracketleftmonospace=65339;e.bracketlefttp=63726;e.bracketright=93;e.bracketrightbt=63739;e.bracketrightex=63738;e.bracketrightmonospace=65341;e.bracketrighttp=63737;e.breve=728;e.brevebelowcmb=814;e.brevecmb=774;e.breveinvertedbelowcmb=815;e.breveinvertedcmb=785;e.breveinverteddoublecmb=865;e.bridgebelowcmb=810;e.bridgeinvertedbelowcmb=826;e.brokenbar=166;e.bstroke=384;e.bsuperior=63210;e.btopbar=387;e.buhiragana=12406;e.bukatakana=12502;e.bullet=8226;e.bulletinverse=9688;e.bulletoperator=8729;e.bullseye=9678;e.c=99;e.caarmenian=1390;e.cabengali=2458;e.cacute=263;e.cadeva=2330;e.cagujarati=2714;e.cagurmukhi=2586;e.calsquare=13192;e.candrabindubengali=2433;e.candrabinducmb=784;e.candrabindudeva=2305;e.candrabindugujarati=2689;e.capslock=8682;e.careof=8453;e.caron=711;e.caronbelowcmb=812;e.caroncmb=780;e.carriagereturn=8629;e.cbopomofo=12568;e.ccaron=269;e.ccedilla=231;e.ccedillaacute=7689;e.ccircle=9426;e.ccircumflex=265;e.ccurl=597;e.cdot=267;e.cdotaccent=267;e.cdsquare=13253;e.cedilla=184;e.cedillacmb=807;e.cent=162;e.centigrade=8451;e.centinferior=63199;e.centmonospace=65504;e.centoldstyle=63394;e.centsuperior=63200;e.chaarmenian=1401;e.chabengali=2459;e.chadeva=2331;e.chagujarati=2715;e.chagurmukhi=2587;e.chbopomofo=12564;e.cheabkhasiancyrillic=1213;e.checkmark=10003;e.checyrillic=1095;e.chedescenderabkhasiancyrillic=1215;e.chedescendercyrillic=1207;e.chedieresiscyrillic=1269;e.cheharmenian=1395;e.chekhakassiancyrillic=1228;e.cheverticalstrokecyrillic=1209;e.chi=967;e.chieuchacirclekorean=12919;e.chieuchaparenkorean=12823;e.chieuchcirclekorean=12905;e.chieuchkorean=12618;e.chieuchparenkorean=12809;e.chochangthai=3594;e.chochanthai=3592;e.chochingthai=3593;e.chochoethai=3596;e.chook=392;e.cieucacirclekorean=12918;e.cieucaparenkorean=12822;e.cieuccirclekorean=12904;e.cieuckorean=12616;e.cieucparenkorean=12808;e.cieucuparenkorean=12828;e.circle=9675;e.circlecopyrt=169;e.circlemultiply=8855;e.circleot=8857;e.circleplus=8853;e.circlepostalmark=12342;e.circlewithlefthalfblack=9680;e.circlewithrighthalfblack=9681;e.circumflex=710;e.circumflexbelowcmb=813;e.circumflexcmb=770;e.clear=8999;e.clickalveolar=450;e.clickdental=448;e.clicklateral=449;e.clickretroflex=451;e.club=9827;e.clubsuitblack=9827;e.clubsuitwhite=9831;e.cmcubedsquare=13220;e.cmonospace=65347;e.cmsquaredsquare=13216;e.coarmenian=1409;e.colon=58;e.colonmonetary=8353;e.colonmonospace=65306;e.colonsign=8353;e.colonsmall=65109;e.colontriangularhalfmod=721;e.colontriangularmod=720;e.comma=44;e.commaabovecmb=787;e.commaaboverightcmb=789;e.commaaccent=63171;e.commaarabic=1548;e.commaarmenian=1373;e.commainferior=63201;e.commamonospace=65292;e.commareversedabovecmb=788;e.commareversedmod=701;e.commasmall=65104;e.commasuperior=63202;e.commaturnedabovecmb=786;e.commaturnedmod=699;e.compass=9788;e.congruent=8773;e.contourintegral=8750;e.control=8963;e.controlACK=6;e.controlBEL=7;e.controlBS=8;e.controlCAN=24;e.controlCR=13;e.controlDC1=17;e.controlDC2=18;e.controlDC3=19;e.controlDC4=20;e.controlDEL=127;e.controlDLE=16;e.controlEM=25;e.controlENQ=5;e.controlEOT=4;e.controlESC=27;e.controlETB=23;e.controlETX=3;e.controlFF=12;e.controlFS=28;e.controlGS=29;e.controlHT=9;e.controlLF=10;e.controlNAK=21;e.controlNULL=0;e.controlRS=30;e.controlSI=15;e.controlSO=14;e.controlSOT=2;e.controlSTX=1;e.controlSUB=26;e.controlSYN=22;e.controlUS=31;e.controlVT=11;e.copyright=169;e.copyrightsans=63721;e.copyrightserif=63193;e.cornerbracketleft=12300;e.cornerbracketlefthalfwidth=65378;e.cornerbracketleftvertical=65089;e.cornerbracketright=12301;e.cornerbracketrighthalfwidth=65379;e.cornerbracketrightvertical=65090;e.corporationsquare=13183;e.cosquare=13255;e.coverkgsquare=13254;e.cparen=9374;e.cruzeiro=8354;e.cstretched=663;e.curlyand=8911;e.curlyor=8910;e.currency=164;e.cyrBreve=63185;e.cyrFlex=63186;e.cyrbreve=63188;e.cyrflex=63189;e.d=100;e.daarmenian=1380;e.dabengali=2470;e.dadarabic=1590;e.dadeva=2342;e.dadfinalarabic=65214;e.dadinitialarabic=65215;e.dadmedialarabic=65216;e.dagesh=1468;e.dageshhebrew=1468;e.dagger=8224;e.daggerdbl=8225;e.dagujarati=2726;e.dagurmukhi=2598;e.dahiragana=12384;e.dakatakana=12480;e.dalarabic=1583;e.dalet=1491;e.daletdagesh=64307;e.daletdageshhebrew=64307;e.dalethebrew=1491;e.dalfinalarabic=65194;e.dammaarabic=1615;e.dammalowarabic=1615;e.dammatanaltonearabic=1612;e.dammatanarabic=1612;e.danda=2404;e.dargahebrew=1447;e.dargalefthebrew=1447;e.dasiapneumatacyrilliccmb=1157;e.dblGrave=63187;e.dblanglebracketleft=12298;e.dblanglebracketleftvertical=65085;e.dblanglebracketright=12299;e.dblanglebracketrightvertical=65086;e.dblarchinvertedbelowcmb=811;e.dblarrowleft=8660;e.dblarrowright=8658;e.dbldanda=2405;e.dblgrave=63190;e.dblgravecmb=783;e.dblintegral=8748;e.dbllowline=8215;e.dbllowlinecmb=819;e.dbloverlinecmb=831;e.dblprimemod=698;e.dblverticalbar=8214;e.dblverticallineabovecmb=782;e.dbopomofo=12553;e.dbsquare=13256;e.dcaron=271;e.dcedilla=7697;e.dcircle=9427;e.dcircumflexbelow=7699;e.dcroat=273;e.ddabengali=2465;e.ddadeva=2337;e.ddagujarati=2721;e.ddagurmukhi=2593;e.ddalarabic=1672;e.ddalfinalarabic=64393;e.dddhadeva=2396;e.ddhabengali=2466;e.ddhadeva=2338;e.ddhagujarati=2722;e.ddhagurmukhi=2594;e.ddotaccent=7691;e.ddotbelow=7693;e.decimalseparatorarabic=1643;e.decimalseparatorpersian=1643;e.decyrillic=1076;e.degree=176;e.dehihebrew=1453;e.dehiragana=12391;e.deicoptic=1007;e.dekatakana=12487;e.deleteleft=9003;e.deleteright=8998;e.delta=948;e.deltaturned=397;e.denominatorminusonenumeratorbengali=2552;e.dezh=676;e.dhabengali=2471;e.dhadeva=2343;e.dhagujarati=2727;e.dhagurmukhi=2599;e.dhook=599;e.dialytikatonos=901;e.dialytikatonoscmb=836;e.diamond=9830;e.diamondsuitwhite=9826;e.dieresis=168;e.dieresisacute=63191;e.dieresisbelowcmb=804;e.dieresiscmb=776;e.dieresisgrave=63192;e.dieresistonos=901;e.dihiragana=12386;e.dikatakana=12482;e.dittomark=12291;e.divide=247;e.divides=8739;e.divisionslash=8725;e.djecyrillic=1106;e.dkshade=9619;e.dlinebelow=7695;e.dlsquare=13207;e.dmacron=273;e.dmonospace=65348;e.dnblock=9604;e.dochadathai=3598;e.dodekthai=3604;e.dohiragana=12393;e.dokatakana=12489;e.dollar=36;e.dollarinferior=63203;e.dollarmonospace=65284;e.dollaroldstyle=63268;e.dollarsmall=65129;e.dollarsuperior=63204;e.dong=8363;e.dorusquare=13094;e.dotaccent=729;e.dotaccentcmb=775;e.dotbelowcmb=803;e.dotbelowcomb=803;e.dotkatakana=12539;e.dotlessi=305;e.dotlessj=63166;e.dotlessjstrokehook=644;e.dotmath=8901;e.dottedcircle=9676;e.doubleyodpatah=64287;e.doubleyodpatahhebrew=64287;e.downtackbelowcmb=798;e.downtackmod=725;e.dparen=9375;e.dsuperior=63211;e.dtail=598;e.dtopbar=396;e.duhiragana=12389;e.dukatakana=12485;e.dz=499;e.dzaltone=675;e.dzcaron=454;e.dzcurl=677;e.dzeabkhasiancyrillic=1249;e.dzecyrillic=1109;e.dzhecyrillic=1119;e.e=101;e.eacute=233;e.earth=9793;e.ebengali=2447;e.ebopomofo=12572;e.ebreve=277;e.ecandradeva=2317;e.ecandragujarati=2701;e.ecandravowelsigndeva=2373;e.ecandravowelsigngujarati=2757;e.ecaron=283;e.ecedillabreve=7709;e.echarmenian=1381;e.echyiwnarmenian=1415;e.ecircle=9428;e.ecircumflex=234;e.ecircumflexacute=7871;e.ecircumflexbelow=7705;e.ecircumflexdotbelow=7879;e.ecircumflexgrave=7873;e.ecircumflexhookabove=7875;e.ecircumflextilde=7877;e.ecyrillic=1108;e.edblgrave=517;e.edeva=2319;e.edieresis=235;e.edot=279;e.edotaccent=279;e.edotbelow=7865;e.eegurmukhi=2575;e.eematragurmukhi=2631;e.efcyrillic=1092;e.egrave=232;e.egujarati=2703;e.eharmenian=1383;e.ehbopomofo=12573;e.ehiragana=12360;e.ehookabove=7867;e.eibopomofo=12575;e.eight=56;e.eightarabic=1640;e.eightbengali=2542;e.eightcircle=9319;e.eightcircleinversesansserif=10129;e.eightdeva=2414;e.eighteencircle=9329;e.eighteenparen=9349;e.eighteenperiod=9369;e.eightgujarati=2798;e.eightgurmukhi=2670;e.eighthackarabic=1640;e.eighthangzhou=12328;e.eighthnotebeamed=9835;e.eightideographicparen=12839;e.eightinferior=8328;e.eightmonospace=65304;e.eightoldstyle=63288;e.eightparen=9339;e.eightperiod=9359;e.eightpersian=1784;e.eightroman=8567;e.eightsuperior=8312;e.eightthai=3672;e.einvertedbreve=519;e.eiotifiedcyrillic=1125;e.ekatakana=12456;e.ekatakanahalfwidth=65396;e.ekonkargurmukhi=2676;e.ekorean=12628;e.elcyrillic=1083;e.element=8712;e.elevencircle=9322;e.elevenparen=9342;e.elevenperiod=9362;e.elevenroman=8570;e.ellipsis=8230;e.ellipsisvertical=8942;e.emacron=275;e.emacronacute=7703;e.emacrongrave=7701;e.emcyrillic=1084;e.emdash=8212;e.emdashvertical=65073;e.emonospace=65349;e.emphasismarkarmenian=1371;e.emptyset=8709;e.enbopomofo=12579;e.encyrillic=1085;e.endash=8211;e.endashvertical=65074;e.endescendercyrillic=1187;e.eng=331;e.engbopomofo=12581;e.enghecyrillic=1189;e.enhookcyrillic=1224;e.enspace=8194;e.eogonek=281;e.eokorean=12627;e.eopen=603;e.eopenclosed=666;e.eopenreversed=604;e.eopenreversedclosed=606;e.eopenreversedhook=605;e.eparen=9376;e.epsilon=949;e.epsilontonos=941;e.equal=61;e.equalmonospace=65309;e.equalsmall=65126;e.equalsuperior=8316;e.equivalence=8801;e.erbopomofo=12582;e.ercyrillic=1088;e.ereversed=600;e.ereversedcyrillic=1101;e.escyrillic=1089;e.esdescendercyrillic=1195;e.esh=643;e.eshcurl=646;e.eshortdeva=2318;e.eshortvowelsigndeva=2374;e.eshreversedloop=426;e.eshsquatreversed=645;e.esmallhiragana=12359;e.esmallkatakana=12455;e.esmallkatakanahalfwidth=65386;e.estimated=8494;e.esuperior=63212;e.eta=951;e.etarmenian=1384;e.etatonos=942;e.eth=240;e.etilde=7869;e.etildebelow=7707;e.etnahtafoukhhebrew=1425;e.etnahtafoukhlefthebrew=1425;e.etnahtahebrew=1425;e.etnahtalefthebrew=1425;e.eturned=477;e.eukorean=12641;e.euro=8364;e.evowelsignbengali=2503;e.evowelsigndeva=2375;e.evowelsigngujarati=2759;e.exclam=33;e.exclamarmenian=1372;e.exclamdbl=8252;e.exclamdown=161;e.exclamdownsmall=63393;e.exclammonospace=65281;e.exclamsmall=63265;e.existential=8707;e.ezh=658;e.ezhcaron=495;e.ezhcurl=659;e.ezhreversed=441;e.ezhtail=442;e.f=102;e.fadeva=2398;e.fagurmukhi=2654;e.fahrenheit=8457;e.fathaarabic=1614;e.fathalowarabic=1614;e.fathatanarabic=1611;e.fbopomofo=12552;e.fcircle=9429;e.fdotaccent=7711;e.feharabic=1601;e.feharmenian=1414;e.fehfinalarabic=65234;e.fehinitialarabic=65235;e.fehmedialarabic=65236;e.feicoptic=997;e.female=9792;e.ff=64256;e.f_f=64256;e.ffi=64259;e.ffl=64260;e.fi=64257;e.fifteencircle=9326;e.fifteenparen=9346;e.fifteenperiod=9366;e.figuredash=8210;e.filledbox=9632;e.filledrect=9644;e.finalkaf=1498;e.finalkafdagesh=64314;e.finalkafdageshhebrew=64314;e.finalkafhebrew=1498;e.finalmem=1501;e.finalmemhebrew=1501;e.finalnun=1503;e.finalnunhebrew=1503;e.finalpe=1507;e.finalpehebrew=1507;e.finaltsadi=1509;e.finaltsadihebrew=1509;e.firsttonechinese=713;e.fisheye=9673;e.fitacyrillic=1139;e.five=53;e.fivearabic=1637;e.fivebengali=2539;e.fivecircle=9316;e.fivecircleinversesansserif=10126;e.fivedeva=2411;e.fiveeighths=8541;e.fivegujarati=2795;e.fivegurmukhi=2667;e.fivehackarabic=1637;e.fivehangzhou=12325;e.fiveideographicparen=12836;e.fiveinferior=8325;e.fivemonospace=65301;e.fiveoldstyle=63285;e.fiveparen=9336;e.fiveperiod=9356;e.fivepersian=1781;e.fiveroman=8564;e.fivesuperior=8309;e.fivethai=3669;e.fl=64258;e.florin=402;e.fmonospace=65350;e.fmsquare=13209;e.fofanthai=3615;e.fofathai=3613;e.fongmanthai=3663;e.forall=8704;e.four=52;e.fourarabic=1636;e.fourbengali=2538;e.fourcircle=9315;e.fourcircleinversesansserif=10125;e.fourdeva=2410;e.fourgujarati=2794;e.fourgurmukhi=2666;e.fourhackarabic=1636;e.fourhangzhou=12324;e.fourideographicparen=12835;e.fourinferior=8324;e.fourmonospace=65300;e.fournumeratorbengali=2551;e.fouroldstyle=63284;e.fourparen=9335;e.fourperiod=9355;e.fourpersian=1780;e.fourroman=8563;e.foursuperior=8308;e.fourteencircle=9325;e.fourteenparen=9345;e.fourteenperiod=9365;e.fourthai=3668;e.fourthtonechinese=715;e.fparen=9377;e.fraction=8260;e.franc=8355;e.g=103;e.gabengali=2455;e.gacute=501;e.gadeva=2327;e.gafarabic=1711;e.gaffinalarabic=64403;e.gafinitialarabic=64404;e.gafmedialarabic=64405;e.gagujarati=2711;e.gagurmukhi=2583;e.gahiragana=12364;e.gakatakana=12460;e.gamma=947;e.gammalatinsmall=611;e.gammasuperior=736;e.gangiacoptic=1003;e.gbopomofo=12557;e.gbreve=287;e.gcaron=487;e.gcedilla=291;e.gcircle=9430;e.gcircumflex=285;e.gcommaaccent=291;e.gdot=289;e.gdotaccent=289;e.gecyrillic=1075;e.gehiragana=12370;e.gekatakana=12466;e.geometricallyequal=8785;e.gereshaccenthebrew=1436;e.gereshhebrew=1523;e.gereshmuqdamhebrew=1437;e.germandbls=223;e.gershayimaccenthebrew=1438;e.gershayimhebrew=1524;e.getamark=12307;e.ghabengali=2456;e.ghadarmenian=1394;e.ghadeva=2328;e.ghagujarati=2712;e.ghagurmukhi=2584;e.ghainarabic=1594;e.ghainfinalarabic=65230;e.ghaininitialarabic=65231;e.ghainmedialarabic=65232;e.ghemiddlehookcyrillic=1173;e.ghestrokecyrillic=1171;e.gheupturncyrillic=1169;e.ghhadeva=2394;e.ghhagurmukhi=2650;e.ghook=608;e.ghzsquare=13203;e.gihiragana=12366;e.gikatakana=12462;e.gimarmenian=1379;e.gimel=1490;e.gimeldagesh=64306;e.gimeldageshhebrew=64306;e.gimelhebrew=1490;e.gjecyrillic=1107;e.glottalinvertedstroke=446;e.glottalstop=660;e.glottalstopinverted=662;e.glottalstopmod=704;e.glottalstopreversed=661;e.glottalstopreversedmod=705;e.glottalstopreversedsuperior=740;e.glottalstopstroke=673;e.glottalstopstrokereversed=674;e.gmacron=7713;e.gmonospace=65351;e.gohiragana=12372;e.gokatakana=12468;e.gparen=9378;e.gpasquare=13228;e.gradient=8711;e.grave=96;e.gravebelowcmb=790;e.gravecmb=768;e.gravecomb=768;e.gravedeva=2387;e.gravelowmod=718;e.gravemonospace=65344;e.gravetonecmb=832;e.greater=62;e.greaterequal=8805;e.greaterequalorless=8923;e.greatermonospace=65310;e.greaterorequivalent=8819;e.greaterorless=8823;e.greateroverequal=8807;e.greatersmall=65125;e.gscript=609;e.gstroke=485;e.guhiragana=12368;e.guillemotleft=171;e.guillemotright=187;e.guilsinglleft=8249;e.guilsinglright=8250;e.gukatakana=12464;e.guramusquare=13080;e.gysquare=13257;e.h=104;e.haabkhasiancyrillic=1193;e.haaltonearabic=1729;e.habengali=2489;e.hadescendercyrillic=1203;e.hadeva=2361;e.hagujarati=2745;e.hagurmukhi=2617;e.haharabic=1581;e.hahfinalarabic=65186;e.hahinitialarabic=65187;e.hahiragana=12399;e.hahmedialarabic=65188;e.haitusquare=13098;e.hakatakana=12495;e.hakatakanahalfwidth=65418;e.halantgurmukhi=2637;e.hamzaarabic=1569;e.hamzalowarabic=1569;e.hangulfiller=12644;e.hardsigncyrillic=1098;e.harpoonleftbarbup=8636;e.harpoonrightbarbup=8640;e.hasquare=13258;e.hatafpatah=1458;e.hatafpatah16=1458;e.hatafpatah23=1458;e.hatafpatah2f=1458;e.hatafpatahhebrew=1458;e.hatafpatahnarrowhebrew=1458;e.hatafpatahquarterhebrew=1458;e.hatafpatahwidehebrew=1458;e.hatafqamats=1459;e.hatafqamats1b=1459;e.hatafqamats28=1459;e.hatafqamats34=1459;e.hatafqamatshebrew=1459;e.hatafqamatsnarrowhebrew=1459;e.hatafqamatsquarterhebrew=1459;e.hatafqamatswidehebrew=1459;e.hatafsegol=1457;e.hatafsegol17=1457;e.hatafsegol24=1457;e.hatafsegol30=1457;e.hatafsegolhebrew=1457;e.hatafsegolnarrowhebrew=1457;e.hatafsegolquarterhebrew=1457;e.hatafsegolwidehebrew=1457;e.hbar=295;e.hbopomofo=12559;e.hbrevebelow=7723;e.hcedilla=7721;e.hcircle=9431;e.hcircumflex=293;e.hdieresis=7719;e.hdotaccent=7715;e.hdotbelow=7717;e.he=1492;e.heart=9829;e.heartsuitblack=9829;e.heartsuitwhite=9825;e.hedagesh=64308;e.hedageshhebrew=64308;e.hehaltonearabic=1729;e.heharabic=1607;e.hehebrew=1492;e.hehfinalaltonearabic=64423;e.hehfinalalttwoarabic=65258;e.hehfinalarabic=65258;e.hehhamzaabovefinalarabic=64421;e.hehhamzaaboveisolatedarabic=64420;e.hehinitialaltonearabic=64424;e.hehinitialarabic=65259;e.hehiragana=12408;e.hehmedialaltonearabic=64425;e.hehmedialarabic=65260;e.heiseierasquare=13179;e.hekatakana=12504;e.hekatakanahalfwidth=65421;e.hekutaarusquare=13110;e.henghook=615;e.herutusquare=13113;e.het=1495;e.hethebrew=1495;e.hhook=614;e.hhooksuperior=689;e.hieuhacirclekorean=12923;e.hieuhaparenkorean=12827;e.hieuhcirclekorean=12909;e.hieuhkorean=12622;e.hieuhparenkorean=12813;e.hihiragana=12402;e.hikatakana=12498;e.hikatakanahalfwidth=65419;e.hiriq=1460;e.hiriq14=1460;e.hiriq21=1460;e.hiriq2d=1460;e.hiriqhebrew=1460;e.hiriqnarrowhebrew=1460;e.hiriqquarterhebrew=1460;e.hiriqwidehebrew=1460;e.hlinebelow=7830;e.hmonospace=65352;e.hoarmenian=1392;e.hohipthai=3627;e.hohiragana=12411;e.hokatakana=12507;e.hokatakanahalfwidth=65422;e.holam=1465;e.holam19=1465;e.holam26=1465;e.holam32=1465;e.holamhebrew=1465;e.holamnarrowhebrew=1465;e.holamquarterhebrew=1465;e.holamwidehebrew=1465;e.honokhukthai=3630;e.hookabovecomb=777;e.hookcmb=777;e.hookpalatalizedbelowcmb=801;e.hookretroflexbelowcmb=802;e.hoonsquare=13122;e.horicoptic=1001;e.horizontalbar=8213;e.horncmb=795;e.hotsprings=9832;e.house=8962;e.hparen=9379;e.hsuperior=688;e.hturned=613;e.huhiragana=12405;e.huiitosquare=13107;e.hukatakana=12501;e.hukatakanahalfwidth=65420;e.hungarumlaut=733;e.hungarumlautcmb=779;e.hv=405;e.hyphen=45;e.hypheninferior=63205;e.hyphenmonospace=65293;e.hyphensmall=65123;e.hyphensuperior=63206;e.hyphentwo=8208;e.i=105;e.iacute=237;e.iacyrillic=1103;e.ibengali=2439;e.ibopomofo=12583;e.ibreve=301;e.icaron=464;e.icircle=9432;e.icircumflex=238;e.icyrillic=1110;e.idblgrave=521;e.ideographearthcircle=12943;e.ideographfirecircle=12939;e.ideographicallianceparen=12863;e.ideographiccallparen=12858;e.ideographiccentrecircle=12965;e.ideographicclose=12294;e.ideographiccomma=12289;e.ideographiccommaleft=65380;e.ideographiccongratulationparen=12855;e.ideographiccorrectcircle=12963;e.ideographicearthparen=12847;e.ideographicenterpriseparen=12861;e.ideographicexcellentcircle=12957;e.ideographicfestivalparen=12864;e.ideographicfinancialcircle=12950;e.ideographicfinancialparen=12854;e.ideographicfireparen=12843;e.ideographichaveparen=12850;e.ideographichighcircle=12964;e.ideographiciterationmark=12293;e.ideographiclaborcircle=12952;e.ideographiclaborparen=12856;e.ideographicleftcircle=12967;e.ideographiclowcircle=12966;e.ideographicmedicinecircle=12969;e.ideographicmetalparen=12846;e.ideographicmoonparen=12842;e.ideographicnameparen=12852;e.ideographicperiod=12290;e.ideographicprintcircle=12958;e.ideographicreachparen=12867;e.ideographicrepresentparen=12857;e.ideographicresourceparen=12862;e.ideographicrightcircle=12968;e.ideographicsecretcircle=12953;e.ideographicselfparen=12866;e.ideographicsocietyparen=12851;e.ideographicspace=12288;e.ideographicspecialparen=12853;e.ideographicstockparen=12849;e.ideographicstudyparen=12859;e.ideographicsunparen=12848;e.ideographicsuperviseparen=12860;e.ideographicwaterparen=12844;e.ideographicwoodparen=12845;e.ideographiczero=12295;e.ideographmetalcircle=12942;e.ideographmooncircle=12938;e.ideographnamecircle=12948;e.ideographsuncircle=12944;e.ideographwatercircle=12940;e.ideographwoodcircle=12941;e.ideva=2311;e.idieresis=239;e.idieresisacute=7727;e.idieresiscyrillic=1253;e.idotbelow=7883;e.iebrevecyrillic=1239;e.iecyrillic=1077;e.ieungacirclekorean=12917;e.ieungaparenkorean=12821;e.ieungcirclekorean=12903;e.ieungkorean=12615;e.ieungparenkorean=12807;e.igrave=236;e.igujarati=2695;e.igurmukhi=2567;e.ihiragana=12356;e.ihookabove=7881;e.iibengali=2440;e.iicyrillic=1080;e.iideva=2312;e.iigujarati=2696;e.iigurmukhi=2568;e.iimatragurmukhi=2624;e.iinvertedbreve=523;e.iishortcyrillic=1081;e.iivowelsignbengali=2496;e.iivowelsigndeva=2368;e.iivowelsigngujarati=2752;e.ij=307;e.ikatakana=12452;e.ikatakanahalfwidth=65394;e.ikorean=12643;e.ilde=732;e.iluyhebrew=1452;e.imacron=299;e.imacroncyrillic=1251;e.imageorapproximatelyequal=8787;e.imatragurmukhi=2623;e.imonospace=65353;e.increment=8710;e.infinity=8734;e.iniarmenian=1387;e.integral=8747;e.integralbottom=8993;e.integralbt=8993;e.integralex=63733;e.integraltop=8992;e.integraltp=8992;e.intersection=8745;e.intisquare=13061;e.invbullet=9688;e.invcircle=9689;e.invsmileface=9787;e.iocyrillic=1105;e.iogonek=303;e.iota=953;e.iotadieresis=970;e.iotadieresistonos=912;e.iotalatin=617;e.iotatonos=943;e.iparen=9380;e.irigurmukhi=2674;e.ismallhiragana=12355;e.ismallkatakana=12451;e.ismallkatakanahalfwidth=65384;e.issharbengali=2554;e.istroke=616;e.isuperior=63213;e.iterationhiragana=12445;e.iterationkatakana=12541;e.itilde=297;e.itildebelow=7725;e.iubopomofo=12585;e.iucyrillic=1102;e.ivowelsignbengali=2495;e.ivowelsigndeva=2367;e.ivowelsigngujarati=2751;e.izhitsacyrillic=1141;e.izhitsadblgravecyrillic=1143;e.j=106;e.jaarmenian=1393;e.jabengali=2460;e.jadeva=2332;e.jagujarati=2716;e.jagurmukhi=2588;e.jbopomofo=12560;e.jcaron=496;e.jcircle=9433;e.jcircumflex=309;e.jcrossedtail=669;e.jdotlessstroke=607;e.jecyrillic=1112;e.jeemarabic=1580;e.jeemfinalarabic=65182;e.jeeminitialarabic=65183;e.jeemmedialarabic=65184;e.jeharabic=1688;e.jehfinalarabic=64395;e.jhabengali=2461;e.jhadeva=2333;e.jhagujarati=2717;e.jhagurmukhi=2589;e.jheharmenian=1403;e.jis=12292;e.jmonospace=65354;e.jparen=9381;e.jsuperior=690;e.k=107;e.kabashkircyrillic=1185;e.kabengali=2453;e.kacute=7729;e.kacyrillic=1082;e.kadescendercyrillic=1179;e.kadeva=2325;e.kaf=1499;e.kafarabic=1603;e.kafdagesh=64315;e.kafdageshhebrew=64315;e.kaffinalarabic=65242;e.kafhebrew=1499;e.kafinitialarabic=65243;e.kafmedialarabic=65244;e.kafrafehebrew=64333;e.kagujarati=2709;e.kagurmukhi=2581;e.kahiragana=12363;e.kahookcyrillic=1220;e.kakatakana=12459;e.kakatakanahalfwidth=65398;e.kappa=954;e.kappasymbolgreek=1008;e.kapyeounmieumkorean=12657;e.kapyeounphieuphkorean=12676;e.kapyeounpieupkorean=12664;e.kapyeounssangpieupkorean=12665;e.karoriisquare=13069;e.kashidaautoarabic=1600;e.kashidaautonosidebearingarabic=1600;e.kasmallkatakana=12533;e.kasquare=13188;e.kasraarabic=1616;e.kasratanarabic=1613;e.kastrokecyrillic=1183;e.katahiraprolongmarkhalfwidth=65392;e.kaverticalstrokecyrillic=1181;e.kbopomofo=12558;e.kcalsquare=13193;e.kcaron=489;e.kcedilla=311;e.kcircle=9434;e.kcommaaccent=311;e.kdotbelow=7731;e.keharmenian=1412;e.kehiragana=12369;e.kekatakana=12465;e.kekatakanahalfwidth=65401;e.kenarmenian=1391;e.kesmallkatakana=12534;e.kgreenlandic=312;e.khabengali=2454;e.khacyrillic=1093;e.khadeva=2326;e.khagujarati=2710;e.khagurmukhi=2582;e.khaharabic=1582;e.khahfinalarabic=65190;e.khahinitialarabic=65191;e.khahmedialarabic=65192;e.kheicoptic=999;e.khhadeva=2393;e.khhagurmukhi=2649;e.khieukhacirclekorean=12920;e.khieukhaparenkorean=12824;e.khieukhcirclekorean=12906;e.khieukhkorean=12619;e.khieukhparenkorean=12810;e.khokhaithai=3586;e.khokhonthai=3589;e.khokhuatthai=3587;e.khokhwaithai=3588;e.khomutthai=3675;e.khook=409;e.khorakhangthai=3590;e.khzsquare=13201;e.kihiragana=12365;e.kikatakana=12461;e.kikatakanahalfwidth=65399;e.kiroguramusquare=13077;e.kiromeetorusquare=13078;e.kirosquare=13076;e.kiyeokacirclekorean=12910;e.kiyeokaparenkorean=12814;e.kiyeokcirclekorean=12896;e.kiyeokkorean=12593;e.kiyeokparenkorean=12800;e.kiyeoksioskorean=12595;e.kjecyrillic=1116;e.klinebelow=7733;e.klsquare=13208;e.kmcubedsquare=13222;e.kmonospace=65355;e.kmsquaredsquare=13218;e.kohiragana=12371;e.kohmsquare=13248;e.kokaithai=3585;e.kokatakana=12467;e.kokatakanahalfwidth=65402;e.kooposquare=13086;e.koppacyrillic=1153;e.koreanstandardsymbol=12927;e.koroniscmb=835;e.kparen=9382;e.kpasquare=13226;e.ksicyrillic=1135;e.ktsquare=13263;e.kturned=670;e.kuhiragana=12367;e.kukatakana=12463;e.kukatakanahalfwidth=65400;e.kvsquare=13240;e.kwsquare=13246;e.l=108;e.labengali=2482;e.lacute=314;e.ladeva=2354;e.lagujarati=2738;e.lagurmukhi=2610;e.lakkhangyaothai=3653;e.lamaleffinalarabic=65276;e.lamalefhamzaabovefinalarabic=65272;e.lamalefhamzaaboveisolatedarabic=65271;e.lamalefhamzabelowfinalarabic=65274;e.lamalefhamzabelowisolatedarabic=65273;e.lamalefisolatedarabic=65275;e.lamalefmaddaabovefinalarabic=65270;e.lamalefmaddaaboveisolatedarabic=65269;e.lamarabic=1604;e.lambda=955;e.lambdastroke=411;e.lamed=1500;e.lameddagesh=64316;e.lameddageshhebrew=64316;e.lamedhebrew=1500;e.lamfinalarabic=65246;e.lamhahinitialarabic=64714;e.laminitialarabic=65247;e.lamjeeminitialarabic=64713;e.lamkhahinitialarabic=64715;e.lamlamhehisolatedarabic=65010;e.lammedialarabic=65248;e.lammeemhahinitialarabic=64904;e.lammeeminitialarabic=64716;e.largecircle=9711;e.lbar=410;e.lbelt=620;e.lbopomofo=12556;e.lcaron=318;e.lcedilla=316;e.lcircle=9435;e.lcircumflexbelow=7741;e.lcommaaccent=316;e.ldot=320;e.ldotaccent=320;e.ldotbelow=7735;e.ldotbelowmacron=7737;e.leftangleabovecmb=794;e.lefttackbelowcmb=792;e.less=60;e.lessequal=8804;e.lessequalorgreater=8922;e.lessmonospace=65308;e.lessorequivalent=8818;e.lessorgreater=8822;e.lessoverequal=8806;e.lesssmall=65124;e.lezh=622;e.lfblock=9612;e.lhookretroflex=621;e.lira=8356;e.liwnarmenian=1388;e.lj=457;e.ljecyrillic=1113;e.ll=63168;e.lladeva=2355;e.llagujarati=2739;e.llinebelow=7739;e.llladeva=2356;e.llvocalicbengali=2529;e.llvocalicdeva=2401;e.llvocalicvowelsignbengali=2531;e.llvocalicvowelsigndeva=2403;e.lmiddletilde=619;e.lmonospace=65356;e.lmsquare=13264;e.lochulathai=3628;e.logicaland=8743;e.logicalnot=172;e.logicalnotreversed=8976;e.logicalor=8744;e.lolingthai=3621;e.longs=383;e.lowlinecenterline=65102;e.lowlinecmb=818;e.lowlinedashed=65101;e.lozenge=9674;e.lparen=9383;e.lslash=322;e.lsquare=8467;e.lsuperior=63214;e.ltshade=9617;e.luthai=3622;e.lvocalicbengali=2444;e.lvocalicdeva=2316;e.lvocalicvowelsignbengali=2530;e.lvocalicvowelsigndeva=2402;e.lxsquare=13267;e.m=109;e.mabengali=2478;e.macron=175;e.macronbelowcmb=817;e.macroncmb=772;e.macronlowmod=717;e.macronmonospace=65507;e.macute=7743;e.madeva=2350;e.magujarati=2734;e.magurmukhi=2606;e.mahapakhhebrew=1444;e.mahapakhlefthebrew=1444;e.mahiragana=12414;e.maichattawalowleftthai=63637;e.maichattawalowrightthai=63636;e.maichattawathai=3659;e.maichattawaupperleftthai=63635;e.maieklowleftthai=63628;e.maieklowrightthai=63627;e.maiekthai=3656;e.maiekupperleftthai=63626;e.maihanakatleftthai=63620;e.maihanakatthai=3633;e.maitaikhuleftthai=63625;e.maitaikhuthai=3655;e.maitholowleftthai=63631;e.maitholowrightthai=63630;e.maithothai=3657;e.maithoupperleftthai=63629;e.maitrilowleftthai=63634;e.maitrilowrightthai=63633;e.maitrithai=3658;e.maitriupperleftthai=63632;e.maiyamokthai=3654;e.makatakana=12510;e.makatakanahalfwidth=65423;e.male=9794;e.mansyonsquare=13127;e.maqafhebrew=1470;e.mars=9794;e.masoracirclehebrew=1455;e.masquare=13187;e.mbopomofo=12551;e.mbsquare=13268;e.mcircle=9436;e.mcubedsquare=13221;e.mdotaccent=7745;e.mdotbelow=7747;e.meemarabic=1605;e.meemfinalarabic=65250;e.meeminitialarabic=65251;e.meemmedialarabic=65252;e.meemmeeminitialarabic=64721;e.meemmeemisolatedarabic=64584;e.meetorusquare=13133;e.mehiragana=12417;e.meizierasquare=13182;e.mekatakana=12513;e.mekatakanahalfwidth=65426;e.mem=1502;e.memdagesh=64318;e.memdageshhebrew=64318;e.memhebrew=1502;e.menarmenian=1396;e.merkhahebrew=1445;e.merkhakefulahebrew=1446;e.merkhakefulalefthebrew=1446;e.merkhalefthebrew=1445;e.mhook=625;e.mhzsquare=13202;e.middledotkatakanahalfwidth=65381;e.middot=183;e.mieumacirclekorean=12914;e.mieumaparenkorean=12818;e.mieumcirclekorean=12900;e.mieumkorean=12609;e.mieumpansioskorean=12656;e.mieumparenkorean=12804;e.mieumpieupkorean=12654;e.mieumsioskorean=12655;e.mihiragana=12415;e.mikatakana=12511;e.mikatakanahalfwidth=65424;e.minus=8722;e.minusbelowcmb=800;e.minuscircle=8854;e.minusmod=727;e.minusplus=8723;e.minute=8242;e.miribaarusquare=13130;e.mirisquare=13129;e.mlonglegturned=624;e.mlsquare=13206;e.mmcubedsquare=13219;e.mmonospace=65357;e.mmsquaredsquare=13215;e.mohiragana=12418;e.mohmsquare=13249;e.mokatakana=12514;e.mokatakanahalfwidth=65427;e.molsquare=13270;e.momathai=3617;e.moverssquare=13223;e.moverssquaredsquare=13224;e.mparen=9384;e.mpasquare=13227;e.mssquare=13235;e.msuperior=63215;e.mturned=623;e.mu=181;e.mu1=181;e.muasquare=13186;e.muchgreater=8811;e.muchless=8810;e.mufsquare=13196;e.mugreek=956;e.mugsquare=13197;e.muhiragana=12416;e.mukatakana=12512;e.mukatakanahalfwidth=65425;e.mulsquare=13205;e.multiply=215;e.mumsquare=13211;e.munahhebrew=1443;e.munahlefthebrew=1443;e.musicalnote=9834;e.musicalnotedbl=9835;e.musicflatsign=9837;e.musicsharpsign=9839;e.mussquare=13234;e.muvsquare=13238;e.muwsquare=13244;e.mvmegasquare=13241;e.mvsquare=13239;e.mwmegasquare=13247;e.mwsquare=13245;e.n=110;e.nabengali=2472;e.nabla=8711;e.nacute=324;e.nadeva=2344;e.nagujarati=2728;e.nagurmukhi=2600;e.nahiragana=12394;e.nakatakana=12490;e.nakatakanahalfwidth=65413;e.napostrophe=329;e.nasquare=13185;e.nbopomofo=12555;e.nbspace=160;e.ncaron=328;e.ncedilla=326;e.ncircle=9437;e.ncircumflexbelow=7755;e.ncommaaccent=326;e.ndotaccent=7749;e.ndotbelow=7751;e.nehiragana=12397;e.nekatakana=12493;e.nekatakanahalfwidth=65416;e.newsheqelsign=8362;e.nfsquare=13195;e.ngabengali=2457;e.ngadeva=2329;e.ngagujarati=2713;e.ngagurmukhi=2585;e.ngonguthai=3591;e.nhiragana=12435;e.nhookleft=626;e.nhookretroflex=627;e.nieunacirclekorean=12911;e.nieunaparenkorean=12815;e.nieuncieuckorean=12597;e.nieuncirclekorean=12897;e.nieunhieuhkorean=12598;e.nieunkorean=12596;e.nieunpansioskorean=12648;e.nieunparenkorean=12801;e.nieunsioskorean=12647;e.nieuntikeutkorean=12646;e.nihiragana=12395;e.nikatakana=12491;e.nikatakanahalfwidth=65414;e.nikhahitleftthai=63641;e.nikhahitthai=3661;e.nine=57;e.ninearabic=1641;e.ninebengali=2543;e.ninecircle=9320;e.ninecircleinversesansserif=10130;e.ninedeva=2415;e.ninegujarati=2799;e.ninegurmukhi=2671;e.ninehackarabic=1641;e.ninehangzhou=12329;e.nineideographicparen=12840;e.nineinferior=8329;e.ninemonospace=65305;e.nineoldstyle=63289;e.nineparen=9340;e.nineperiod=9360;e.ninepersian=1785;e.nineroman=8568;e.ninesuperior=8313;e.nineteencircle=9330;e.nineteenparen=9350;e.nineteenperiod=9370;e.ninethai=3673;e.nj=460;e.njecyrillic=1114;e.nkatakana=12531;e.nkatakanahalfwidth=65437;e.nlegrightlong=414;e.nlinebelow=7753;e.nmonospace=65358;e.nmsquare=13210;e.nnabengali=2467;e.nnadeva=2339;e.nnagujarati=2723;e.nnagurmukhi=2595;e.nnnadeva=2345;e.nohiragana=12398;e.nokatakana=12494;e.nokatakanahalfwidth=65417;e.nonbreakingspace=160;e.nonenthai=3603;e.nonuthai=3609;e.noonarabic=1606;e.noonfinalarabic=65254;e.noonghunnaarabic=1722;e.noonghunnafinalarabic=64415;e.nooninitialarabic=65255;e.noonjeeminitialarabic=64722;e.noonjeemisolatedarabic=64587;e.noonmedialarabic=65256;e.noonmeeminitialarabic=64725;e.noonmeemisolatedarabic=64590;e.noonnoonfinalarabic=64653;e.notcontains=8716;e.notelement=8713;e.notelementof=8713;e.notequal=8800;e.notgreater=8815;e.notgreaternorequal=8817;e.notgreaternorless=8825;e.notidentical=8802;e.notless=8814;e.notlessnorequal=8816;e.notparallel=8742;e.notprecedes=8832;e.notsubset=8836;e.notsucceeds=8833;e.notsuperset=8837;e.nowarmenian=1398;e.nparen=9385;e.nssquare=13233;e.nsuperior=8319;e.ntilde=241;e.nu=957;e.nuhiragana=12396;e.nukatakana=12492;e.nukatakanahalfwidth=65415;e.nuktabengali=2492;e.nuktadeva=2364;e.nuktagujarati=2748;e.nuktagurmukhi=2620;e.numbersign=35;e.numbersignmonospace=65283;e.numbersignsmall=65119;e.numeralsigngreek=884;e.numeralsignlowergreek=885;e.numero=8470;e.nun=1504;e.nundagesh=64320;e.nundageshhebrew=64320;e.nunhebrew=1504;e.nvsquare=13237;e.nwsquare=13243;e.nyabengali=2462;e.nyadeva=2334;e.nyagujarati=2718;e.nyagurmukhi=2590;e.o=111;e.oacute=243;e.oangthai=3629;e.obarred=629;e.obarredcyrillic=1257;e.obarreddieresiscyrillic=1259;e.obengali=2451;e.obopomofo=12571;e.obreve=335;e.ocandradeva=2321;e.ocandragujarati=2705;e.ocandravowelsigndeva=2377;e.ocandravowelsigngujarati=2761;e.ocaron=466;e.ocircle=9438;e.ocircumflex=244;e.ocircumflexacute=7889;e.ocircumflexdotbelow=7897;e.ocircumflexgrave=7891;e.ocircumflexhookabove=7893;e.ocircumflextilde=7895;e.ocyrillic=1086;e.odblacute=337;e.odblgrave=525;e.odeva=2323;e.odieresis=246;e.odieresiscyrillic=1255;e.odotbelow=7885;e.oe=339;e.oekorean=12634;e.ogonek=731;e.ogonekcmb=808;e.ograve=242;e.ogujarati=2707;e.oharmenian=1413;e.ohiragana=12362;e.ohookabove=7887;e.ohorn=417;e.ohornacute=7899;e.ohorndotbelow=7907;e.ohorngrave=7901;e.ohornhookabove=7903;e.ohorntilde=7905;e.ohungarumlaut=337;e.oi=419;e.oinvertedbreve=527;e.okatakana=12458;e.okatakanahalfwidth=65397;e.okorean=12631;e.olehebrew=1451;e.omacron=333;e.omacronacute=7763;e.omacrongrave=7761;e.omdeva=2384;e.omega=969;e.omega1=982;e.omegacyrillic=1121;e.omegalatinclosed=631;e.omegaroundcyrillic=1147;e.omegatitlocyrillic=1149;e.omegatonos=974;e.omgujarati=2768;e.omicron=959;e.omicrontonos=972;e.omonospace=65359;e.one=49;e.onearabic=1633;e.onebengali=2535;e.onecircle=9312;e.onecircleinversesansserif=10122;e.onedeva=2407;e.onedotenleader=8228;e.oneeighth=8539;e.onefitted=63196;e.onegujarati=2791;e.onegurmukhi=2663;e.onehackarabic=1633;e.onehalf=189;e.onehangzhou=12321;e.oneideographicparen=12832;e.oneinferior=8321;e.onemonospace=65297;e.onenumeratorbengali=2548;e.oneoldstyle=63281;e.oneparen=9332;e.oneperiod=9352;e.onepersian=1777;e.onequarter=188;e.oneroman=8560;e.onesuperior=185;e.onethai=3665;e.onethird=8531;e.oogonek=491;e.oogonekmacron=493;e.oogurmukhi=2579;e.oomatragurmukhi=2635;e.oopen=596;e.oparen=9386;e.openbullet=9702;e.option=8997;e.ordfeminine=170;e.ordmasculine=186;e.orthogonal=8735;e.oshortdeva=2322;e.oshortvowelsigndeva=2378;e.oslash=248;e.oslashacute=511;e.osmallhiragana=12361;e.osmallkatakana=12457;e.osmallkatakanahalfwidth=65387;e.ostrokeacute=511;e.osuperior=63216;e.otcyrillic=1151;e.otilde=245;e.otildeacute=7757;e.otildedieresis=7759;e.oubopomofo=12577;e.overline=8254;e.overlinecenterline=65098;e.overlinecmb=773;e.overlinedashed=65097;e.overlinedblwavy=65100;e.overlinewavy=65099;e.overscore=175;e.ovowelsignbengali=2507;e.ovowelsigndeva=2379;e.ovowelsigngujarati=2763;e.p=112;e.paampssquare=13184;e.paasentosquare=13099;e.pabengali=2474;e.pacute=7765;e.padeva=2346;e.pagedown=8671;e.pageup=8670;e.pagujarati=2730;e.pagurmukhi=2602;e.pahiragana=12401;e.paiyannoithai=3631;e.pakatakana=12497;e.palatalizationcyrilliccmb=1156;e.palochkacyrillic=1216;e.pansioskorean=12671;e.paragraph=182;e.parallel=8741;e.parenleft=40;e.parenleftaltonearabic=64830;e.parenleftbt=63725;e.parenleftex=63724;e.parenleftinferior=8333;e.parenleftmonospace=65288;e.parenleftsmall=65113;e.parenleftsuperior=8317;e.parenlefttp=63723;e.parenleftvertical=65077;e.parenright=41;e.parenrightaltonearabic=64831;e.parenrightbt=63736;e.parenrightex=63735;e.parenrightinferior=8334;e.parenrightmonospace=65289;e.parenrightsmall=65114;e.parenrightsuperior=8318;e.parenrighttp=63734;e.parenrightvertical=65078;e.partialdiff=8706;e.paseqhebrew=1472;e.pashtahebrew=1433;e.pasquare=13225;e.patah=1463;e.patah11=1463;e.patah1d=1463;e.patah2a=1463;e.patahhebrew=1463;e.patahnarrowhebrew=1463;e.patahquarterhebrew=1463;e.patahwidehebrew=1463;e.pazerhebrew=1441;e.pbopomofo=12550;e.pcircle=9439;e.pdotaccent=7767;e.pe=1508;e.pecyrillic=1087;e.pedagesh=64324;e.pedageshhebrew=64324;e.peezisquare=13115;e.pefinaldageshhebrew=64323;e.peharabic=1662;e.peharmenian=1402;e.pehebrew=1508;e.pehfinalarabic=64343;e.pehinitialarabic=64344;e.pehiragana=12410;e.pehmedialarabic=64345;e.pekatakana=12506;e.pemiddlehookcyrillic=1191;e.perafehebrew=64334;e.percent=37;e.percentarabic=1642;e.percentmonospace=65285;e.percentsmall=65130;e.period=46;e.periodarmenian=1417;e.periodcentered=183;e.periodhalfwidth=65377;e.periodinferior=63207;e.periodmonospace=65294;e.periodsmall=65106;e.periodsuperior=63208;e.perispomenigreekcmb=834;e.perpendicular=8869;e.perthousand=8240;e.peseta=8359;e.pfsquare=13194;e.phabengali=2475;e.phadeva=2347;e.phagujarati=2731;e.phagurmukhi=2603;e.phi=966;e.phi1=981;e.phieuphacirclekorean=12922;e.phieuphaparenkorean=12826;e.phieuphcirclekorean=12908;e.phieuphkorean=12621;e.phieuphparenkorean=12812;e.philatin=632;e.phinthuthai=3642;e.phisymbolgreek=981;e.phook=421;e.phophanthai=3614;e.phophungthai=3612;e.phosamphaothai=3616;e.pi=960;e.pieupacirclekorean=12915;e.pieupaparenkorean=12819;e.pieupcieuckorean=12662;e.pieupcirclekorean=12901;e.pieupkiyeokkorean=12658;e.pieupkorean=12610;e.pieupparenkorean=12805;e.pieupsioskiyeokkorean=12660;e.pieupsioskorean=12612;e.pieupsiostikeutkorean=12661;e.pieupthieuthkorean=12663;e.pieuptikeutkorean=12659;e.pihiragana=12404;e.pikatakana=12500;e.pisymbolgreek=982;e.piwrarmenian=1411;e.plus=43;e.plusbelowcmb=799;e.pluscircle=8853;e.plusminus=177;e.plusmod=726;e.plusmonospace=65291;e.plussmall=65122;e.plussuperior=8314;e.pmonospace=65360;e.pmsquare=13272;e.pohiragana=12413;e.pointingindexdownwhite=9759;e.pointingindexleftwhite=9756;e.pointingindexrightwhite=9758;e.pointingindexupwhite=9757;e.pokatakana=12509;e.poplathai=3611;e.postalmark=12306;e.postalmarkface=12320;e.pparen=9387;e.precedes=8826;e.prescription=8478;e.primemod=697;e.primereversed=8245;e.product=8719;e.projective=8965;e.prolongedkana=12540;e.propellor=8984;e.propersubset=8834;e.propersuperset=8835;e.proportion=8759;e.proportional=8733;e.psi=968;e.psicyrillic=1137;e.psilipneumatacyrilliccmb=1158;e.pssquare=13232;e.puhiragana=12407;e.pukatakana=12503;e.pvsquare=13236;e.pwsquare=13242;e.q=113;e.qadeva=2392;e.qadmahebrew=1448;e.qafarabic=1602;e.qaffinalarabic=65238;e.qafinitialarabic=65239;e.qafmedialarabic=65240;e.qamats=1464;e.qamats10=1464;e.qamats1a=1464;e.qamats1c=1464;e.qamats27=1464;e.qamats29=1464;e.qamats33=1464;e.qamatsde=1464;e.qamatshebrew=1464;e.qamatsnarrowhebrew=1464;e.qamatsqatanhebrew=1464;e.qamatsqatannarrowhebrew=1464;e.qamatsqatanquarterhebrew=1464;e.qamatsqatanwidehebrew=1464;e.qamatsquarterhebrew=1464;e.qamatswidehebrew=1464;e.qarneyparahebrew=1439;e.qbopomofo=12561;e.qcircle=9440;e.qhook=672;e.qmonospace=65361;e.qof=1511;e.qofdagesh=64327;e.qofdageshhebrew=64327;e.qofhebrew=1511;e.qparen=9388;e.quarternote=9833;e.qubuts=1467;e.qubuts18=1467;e.qubuts25=1467;e.qubuts31=1467;e.qubutshebrew=1467;e.qubutsnarrowhebrew=1467;e.qubutsquarterhebrew=1467;e.qubutswidehebrew=1467;e.question=63;e.questionarabic=1567;e.questionarmenian=1374;e.questiondown=191;e.questiondownsmall=63423;e.questiongreek=894;e.questionmonospace=65311;e.questionsmall=63295;e.quotedbl=34;e.quotedblbase=8222;e.quotedblleft=8220;e.quotedblmonospace=65282;e.quotedblprime=12318;e.quotedblprimereversed=12317;e.quotedblright=8221;e.quoteleft=8216;e.quoteleftreversed=8219;e.quotereversed=8219;e.quoteright=8217;e.quoterightn=329;e.quotesinglbase=8218;e.quotesingle=39;e.quotesinglemonospace=65287;e.r=114;e.raarmenian=1404;e.rabengali=2480;e.racute=341;e.radeva=2352;e.radical=8730;e.radicalex=63717;e.radoverssquare=13230;e.radoverssquaredsquare=13231;e.radsquare=13229;e.rafe=1471;e.rafehebrew=1471;e.ragujarati=2736;e.ragurmukhi=2608;e.rahiragana=12425;e.rakatakana=12521;e.rakatakanahalfwidth=65431;e.ralowerdiagonalbengali=2545;e.ramiddlediagonalbengali=2544;e.ramshorn=612;e.ratio=8758;e.rbopomofo=12566;e.rcaron=345;e.rcedilla=343;e.rcircle=9441;e.rcommaaccent=343;e.rdblgrave=529;e.rdotaccent=7769;e.rdotbelow=7771;e.rdotbelowmacron=7773;e.referencemark=8251;e.reflexsubset=8838;e.reflexsuperset=8839;e.registered=174;e.registersans=63720;e.registerserif=63194;e.reharabic=1585;e.reharmenian=1408;e.rehfinalarabic=65198;e.rehiragana=12428;e.rekatakana=12524;e.rekatakanahalfwidth=65434;e.resh=1512;e.reshdageshhebrew=64328;e.reshhebrew=1512;e.reversedtilde=8765;e.reviahebrew=1431;e.reviamugrashhebrew=1431;e.revlogicalnot=8976;e.rfishhook=638;e.rfishhookreversed=639;e.rhabengali=2525;e.rhadeva=2397;e.rho=961;e.rhook=637;e.rhookturned=635;e.rhookturnedsuperior=693;e.rhosymbolgreek=1009;e.rhotichookmod=734;e.rieulacirclekorean=12913;e.rieulaparenkorean=12817;e.rieulcirclekorean=12899;e.rieulhieuhkorean=12608;e.rieulkiyeokkorean=12602;e.rieulkiyeoksioskorean=12649;e.rieulkorean=12601;e.rieulmieumkorean=12603;e.rieulpansioskorean=12652;e.rieulparenkorean=12803;e.rieulphieuphkorean=12607;e.rieulpieupkorean=12604;e.rieulpieupsioskorean=12651;e.rieulsioskorean=12605;e.rieulthieuthkorean=12606;e.rieultikeutkorean=12650;e.rieulyeorinhieuhkorean=12653;e.rightangle=8735;e.righttackbelowcmb=793;e.righttriangle=8895;e.rihiragana=12426;e.rikatakana=12522;e.rikatakanahalfwidth=65432;e.ring=730;e.ringbelowcmb=805;e.ringcmb=778;e.ringhalfleft=703;e.ringhalfleftarmenian=1369;e.ringhalfleftbelowcmb=796;e.ringhalfleftcentered=723;e.ringhalfright=702;e.ringhalfrightbelowcmb=825;e.ringhalfrightcentered=722;e.rinvertedbreve=531;e.rittorusquare=13137;e.rlinebelow=7775;e.rlongleg=636;e.rlonglegturned=634;e.rmonospace=65362;e.rohiragana=12429;e.rokatakana=12525;e.rokatakanahalfwidth=65435;e.roruathai=3619;e.rparen=9389;e.rrabengali=2524;e.rradeva=2353;e.rragurmukhi=2652;e.rreharabic=1681;e.rrehfinalarabic=64397;e.rrvocalicbengali=2528;e.rrvocalicdeva=2400;e.rrvocalicgujarati=2784;e.rrvocalicvowelsignbengali=2500;e.rrvocalicvowelsigndeva=2372;e.rrvocalicvowelsigngujarati=2756;e.rsuperior=63217;e.rtblock=9616;e.rturned=633;e.rturnedsuperior=692;e.ruhiragana=12427;e.rukatakana=12523;e.rukatakanahalfwidth=65433;e.rupeemarkbengali=2546;e.rupeesignbengali=2547;e.rupiah=63197;e.ruthai=3620;e.rvocalicbengali=2443;e.rvocalicdeva=2315;e.rvocalicgujarati=2699;e.rvocalicvowelsignbengali=2499;e.rvocalicvowelsigndeva=2371;e.rvocalicvowelsigngujarati=2755;e.s=115;e.sabengali=2488;e.sacute=347;e.sacutedotaccent=7781;e.sadarabic=1589;e.sadeva=2360;e.sadfinalarabic=65210;e.sadinitialarabic=65211;e.sadmedialarabic=65212;e.sagujarati=2744;e.sagurmukhi=2616;e.sahiragana=12373;e.sakatakana=12469;e.sakatakanahalfwidth=65403;e.sallallahoualayhewasallamarabic=65018;e.samekh=1505;e.samekhdagesh=64321;e.samekhdageshhebrew=64321;e.samekhhebrew=1505;e.saraaathai=3634;e.saraaethai=3649;e.saraaimaimalaithai=3652;e.saraaimaimuanthai=3651;e.saraamthai=3635;e.saraathai=3632;e.saraethai=3648;e.saraiileftthai=63622;e.saraiithai=3637;e.saraileftthai=63621;e.saraithai=3636;e.saraothai=3650;e.saraueeleftthai=63624;e.saraueethai=3639;e.saraueleftthai=63623;e.sarauethai=3638;e.sarauthai=3640;e.sarauuthai=3641;e.sbopomofo=12569;e.scaron=353;e.scarondotaccent=7783;e.scedilla=351;e.schwa=601;e.schwacyrillic=1241;e.schwadieresiscyrillic=1243;e.schwahook=602;e.scircle=9442;e.scircumflex=349;e.scommaaccent=537;e.sdotaccent=7777;e.sdotbelow=7779;e.sdotbelowdotaccent=7785;e.seagullbelowcmb=828;e.second=8243;e.secondtonechinese=714;e.section=167;e.seenarabic=1587;e.seenfinalarabic=65202;e.seeninitialarabic=65203;e.seenmedialarabic=65204;e.segol=1462;e.segol13=1462;e.segol1f=1462;e.segol2c=1462;e.segolhebrew=1462;e.segolnarrowhebrew=1462;e.segolquarterhebrew=1462;e.segoltahebrew=1426;e.segolwidehebrew=1462;e.seharmenian=1405;e.sehiragana=12379;e.sekatakana=12475;e.sekatakanahalfwidth=65406;e.semicolon=59;e.semicolonarabic=1563;e.semicolonmonospace=65307;e.semicolonsmall=65108;e.semivoicedmarkkana=12444;e.semivoicedmarkkanahalfwidth=65439;e.sentisquare=13090;e.sentosquare=13091;e.seven=55;e.sevenarabic=1639;e.sevenbengali=2541;e.sevencircle=9318;e.sevencircleinversesansserif=10128;e.sevendeva=2413;e.seveneighths=8542;e.sevengujarati=2797;e.sevengurmukhi=2669;e.sevenhackarabic=1639;e.sevenhangzhou=12327;e.sevenideographicparen=12838;e.seveninferior=8327;e.sevenmonospace=65303;e.sevenoldstyle=63287;e.sevenparen=9338;e.sevenperiod=9358;e.sevenpersian=1783;e.sevenroman=8566;e.sevensuperior=8311;e.seventeencircle=9328;e.seventeenparen=9348;e.seventeenperiod=9368;e.seventhai=3671;e.sfthyphen=173;e.shaarmenian=1399;e.shabengali=2486;e.shacyrillic=1096;e.shaddaarabic=1617;e.shaddadammaarabic=64609;e.shaddadammatanarabic=64606;e.shaddafathaarabic=64608;e.shaddakasraarabic=64610;e.shaddakasratanarabic=64607;e.shade=9618;e.shadedark=9619;e.shadelight=9617;e.shademedium=9618;e.shadeva=2358;e.shagujarati=2742;e.shagurmukhi=2614;e.shalshelethebrew=1427;e.shbopomofo=12565;e.shchacyrillic=1097;e.sheenarabic=1588;e.sheenfinalarabic=65206;e.sheeninitialarabic=65207;e.sheenmedialarabic=65208;e.sheicoptic=995;e.sheqel=8362;e.sheqelhebrew=8362;e.sheva=1456;e.sheva115=1456;e.sheva15=1456;e.sheva22=1456;e.sheva2e=1456;e.shevahebrew=1456;e.shevanarrowhebrew=1456;e.shevaquarterhebrew=1456;e.shevawidehebrew=1456;e.shhacyrillic=1211;e.shimacoptic=1005;e.shin=1513;e.shindagesh=64329;e.shindageshhebrew=64329;e.shindageshshindot=64300;e.shindageshshindothebrew=64300;e.shindageshsindot=64301;e.shindageshsindothebrew=64301;e.shindothebrew=1473;e.shinhebrew=1513;e.shinshindot=64298;e.shinshindothebrew=64298;e.shinsindot=64299;e.shinsindothebrew=64299;e.shook=642;e.sigma=963;e.sigma1=962;e.sigmafinal=962;e.sigmalunatesymbolgreek=1010;e.sihiragana=12375;e.sikatakana=12471;e.sikatakanahalfwidth=65404;e.siluqhebrew=1469;e.siluqlefthebrew=1469;e.similar=8764;e.sindothebrew=1474;e.siosacirclekorean=12916;e.siosaparenkorean=12820;e.sioscieuckorean=12670;e.sioscirclekorean=12902;e.sioskiyeokkorean=12666;e.sioskorean=12613;e.siosnieunkorean=12667;e.siosparenkorean=12806;e.siospieupkorean=12669;e.siostikeutkorean=12668;e.six=54;e.sixarabic=1638;e.sixbengali=2540;e.sixcircle=9317;e.sixcircleinversesansserif=10127;e.sixdeva=2412;e.sixgujarati=2796;e.sixgurmukhi=2668;e.sixhackarabic=1638;e.sixhangzhou=12326;e.sixideographicparen=12837;e.sixinferior=8326;e.sixmonospace=65302;e.sixoldstyle=63286;e.sixparen=9337;e.sixperiod=9357;e.sixpersian=1782;e.sixroman=8565;e.sixsuperior=8310;e.sixteencircle=9327;e.sixteencurrencydenominatorbengali=2553;e.sixteenparen=9347;e.sixteenperiod=9367;e.sixthai=3670;e.slash=47;e.slashmonospace=65295;e.slong=383;e.slongdotaccent=7835;e.smileface=9786;e.smonospace=65363;e.sofpasuqhebrew=1475;e.softhyphen=173;e.softsigncyrillic=1100;e.sohiragana=12381;e.sokatakana=12477;e.sokatakanahalfwidth=65407;e.soliduslongoverlaycmb=824;e.solidusshortoverlaycmb=823;e.sorusithai=3625;e.sosalathai=3624;e.sosothai=3595;e.sosuathai=3626;e.space=32;e.spacehackarabic=32;e.spade=9824;e.spadesuitblack=9824;e.spadesuitwhite=9828;e.sparen=9390;e.squarebelowcmb=827;e.squarecc=13252;e.squarecm=13213;e.squarediagonalcrosshatchfill=9641;e.squarehorizontalfill=9636;e.squarekg=13199;e.squarekm=13214;e.squarekmcapital=13262;e.squareln=13265;e.squarelog=13266;e.squaremg=13198;e.squaremil=13269;e.squaremm=13212;e.squaremsquared=13217;e.squareorthogonalcrosshatchfill=9638;e.squareupperlefttolowerrightfill=9639;e.squareupperrighttolowerleftfill=9640;e.squareverticalfill=9637;e.squarewhitewithsmallblack=9635;e.srsquare=13275;e.ssabengali=2487;e.ssadeva=2359;e.ssagujarati=2743;e.ssangcieuckorean=12617;e.ssanghieuhkorean=12677;e.ssangieungkorean=12672;e.ssangkiyeokkorean=12594;e.ssangnieunkorean=12645;e.ssangpieupkorean=12611;e.ssangsioskorean=12614;e.ssangtikeutkorean=12600;e.ssuperior=63218;e.sterling=163;e.sterlingmonospace=65505;e.strokelongoverlaycmb=822;e.strokeshortoverlaycmb=821;e.subset=8834;e.subsetnotequal=8842;e.subsetorequal=8838;e.succeeds=8827;e.suchthat=8715;e.suhiragana=12377;e.sukatakana=12473;e.sukatakanahalfwidth=65405;e.sukunarabic=1618;e.summation=8721;e.sun=9788;e.superset=8835;e.supersetnotequal=8843;e.supersetorequal=8839;e.svsquare=13276;e.syouwaerasquare=13180;e.t=116;e.tabengali=2468;e.tackdown=8868;e.tackleft=8867;e.tadeva=2340;e.tagujarati=2724;e.tagurmukhi=2596;e.taharabic=1591;e.tahfinalarabic=65218;e.tahinitialarabic=65219;e.tahiragana=12383;e.tahmedialarabic=65220;e.taisyouerasquare=13181;e.takatakana=12479;e.takatakanahalfwidth=65408;e.tatweelarabic=1600;e.tau=964;e.tav=1514;e.tavdages=64330;e.tavdagesh=64330;e.tavdageshhebrew=64330;e.tavhebrew=1514;e.tbar=359;e.tbopomofo=12554;e.tcaron=357;e.tccurl=680;e.tcedilla=355;e.tcheharabic=1670;e.tchehfinalarabic=64379;e.tchehinitialarabic=64380;e.tchehmedialarabic=64381;e.tcircle=9443;e.tcircumflexbelow=7793;e.tcommaaccent=355;e.tdieresis=7831;e.tdotaccent=7787;e.tdotbelow=7789;e.tecyrillic=1090;e.tedescendercyrillic=1197;e.teharabic=1578;e.tehfinalarabic=65174;e.tehhahinitialarabic=64674;e.tehhahisolatedarabic=64524;e.tehinitialarabic=65175;e.tehiragana=12390;e.tehjeeminitialarabic=64673;e.tehjeemisolatedarabic=64523;e.tehmarbutaarabic=1577;e.tehmarbutafinalarabic=65172;e.tehmedialarabic=65176;e.tehmeeminitialarabic=64676;e.tehmeemisolatedarabic=64526;e.tehnoonfinalarabic=64627;e.tekatakana=12486;e.tekatakanahalfwidth=65411;e.telephone=8481;e.telephoneblack=9742;e.telishagedolahebrew=1440;e.telishaqetanahebrew=1449;e.tencircle=9321;e.tenideographicparen=12841;e.tenparen=9341;e.tenperiod=9361;e.tenroman=8569;e.tesh=679;e.tet=1496;e.tetdagesh=64312;e.tetdageshhebrew=64312;e.tethebrew=1496;e.tetsecyrillic=1205;e.tevirhebrew=1435;e.tevirlefthebrew=1435;e.thabengali=2469;e.thadeva=2341;e.thagujarati=2725;e.thagurmukhi=2597;e.thalarabic=1584;e.thalfinalarabic=65196;e.thanthakhatlowleftthai=63640;e.thanthakhatlowrightthai=63639;e.thanthakhatthai=3660;e.thanthakhatupperleftthai=63638;e.theharabic=1579;e.thehfinalarabic=65178;e.thehinitialarabic=65179;e.thehmedialarabic=65180;e.thereexists=8707;e.therefore=8756;e.theta=952;e.theta1=977;e.thetasymbolgreek=977;e.thieuthacirclekorean=12921;e.thieuthaparenkorean=12825;e.thieuthcirclekorean=12907;e.thieuthkorean=12620;e.thieuthparenkorean=12811;e.thirteencircle=9324;e.thirteenparen=9344;e.thirteenperiod=9364;e.thonangmonthothai=3601;e.thook=429;e.thophuthaothai=3602;e.thorn=254;e.thothahanthai=3607;e.thothanthai=3600;e.thothongthai=3608;e.thothungthai=3606;e.thousandcyrillic=1154;e.thousandsseparatorarabic=1644;e.thousandsseparatorpersian=1644;e.three=51;e.threearabic=1635;e.threebengali=2537;e.threecircle=9314;e.threecircleinversesansserif=10124;e.threedeva=2409;e.threeeighths=8540;e.threegujarati=2793;e.threegurmukhi=2665;e.threehackarabic=1635;e.threehangzhou=12323;e.threeideographicparen=12834;e.threeinferior=8323;e.threemonospace=65299;e.threenumeratorbengali=2550;e.threeoldstyle=63283;e.threeparen=9334;e.threeperiod=9354;e.threepersian=1779;e.threequarters=190;e.threequartersemdash=63198;e.threeroman=8562;e.threesuperior=179;e.threethai=3667;e.thzsquare=13204;e.tihiragana=12385;e.tikatakana=12481;e.tikatakanahalfwidth=65409;e.tikeutacirclekorean=12912;e.tikeutaparenkorean=12816;e.tikeutcirclekorean=12898;e.tikeutkorean=12599;e.tikeutparenkorean=12802;e.tilde=732;e.tildebelowcmb=816;e.tildecmb=771;e.tildecomb=771;e.tildedoublecmb=864;e.tildeoperator=8764;e.tildeoverlaycmb=820;e.tildeverticalcmb=830;e.timescircle=8855;e.tipehahebrew=1430;e.tipehalefthebrew=1430;e.tippigurmukhi=2672;e.titlocyrilliccmb=1155;e.tiwnarmenian=1407;e.tlinebelow=7791;e.tmonospace=65364;e.toarmenian=1385;e.tohiragana=12392;e.tokatakana=12488;e.tokatakanahalfwidth=65412;e.tonebarextrahighmod=741;e.tonebarextralowmod=745;e.tonebarhighmod=742;e.tonebarlowmod=744;e.tonebarmidmod=743;e.tonefive=445;e.tonesix=389;e.tonetwo=424;e.tonos=900;e.tonsquare=13095;e.topatakthai=3599;e.tortoiseshellbracketleft=12308;e.tortoiseshellbracketleftsmall=65117;e.tortoiseshellbracketleftvertical=65081;e.tortoiseshellbracketright=12309;e.tortoiseshellbracketrightsmall=65118;e.tortoiseshellbracketrightvertical=65082;e.totaothai=3605;e.tpalatalhook=427;e.tparen=9391;e.trademark=8482;e.trademarksans=63722;e.trademarkserif=63195;e.tretroflexhook=648;e.triagdn=9660;e.triaglf=9668;e.triagrt=9658;e.triagup=9650;e.ts=678;e.tsadi=1510;e.tsadidagesh=64326;e.tsadidageshhebrew=64326;e.tsadihebrew=1510;e.tsecyrillic=1094;e.tsere=1461;e.tsere12=1461;e.tsere1e=1461;e.tsere2b=1461;e.tserehebrew=1461;e.tserenarrowhebrew=1461;e.tserequarterhebrew=1461;e.tserewidehebrew=1461;e.tshecyrillic=1115;e.tsuperior=63219;e.ttabengali=2463;e.ttadeva=2335;e.ttagujarati=2719;e.ttagurmukhi=2591;e.tteharabic=1657;e.ttehfinalarabic=64359;e.ttehinitialarabic=64360;e.ttehmedialarabic=64361;e.tthabengali=2464;e.tthadeva=2336;e.tthagujarati=2720;e.tthagurmukhi=2592;e.tturned=647;e.tuhiragana=12388;e.tukatakana=12484;e.tukatakanahalfwidth=65410;e.tusmallhiragana=12387;e.tusmallkatakana=12483;e.tusmallkatakanahalfwidth=65391;e.twelvecircle=9323;e.twelveparen=9343;e.twelveperiod=9363;e.twelveroman=8571;e.twentycircle=9331;e.twentyhangzhou=21316;e.twentyparen=9351;e.twentyperiod=9371;e.two=50;e.twoarabic=1634;e.twobengali=2536;e.twocircle=9313;e.twocircleinversesansserif=10123;e.twodeva=2408;e.twodotenleader=8229;e.twodotleader=8229;e.twodotleadervertical=65072;e.twogujarati=2792;e.twogurmukhi=2664;e.twohackarabic=1634;e.twohangzhou=12322;e.twoideographicparen=12833;e.twoinferior=8322;e.twomonospace=65298;e.twonumeratorbengali=2549;e.twooldstyle=63282;e.twoparen=9333;e.twoperiod=9353;e.twopersian=1778;e.tworoman=8561;e.twostroke=443;e.twosuperior=178;e.twothai=3666;e.twothirds=8532;e.u=117;e.uacute=250;e.ubar=649;e.ubengali=2441;e.ubopomofo=12584;e.ubreve=365;e.ucaron=468;e.ucircle=9444;e.ucircumflex=251;e.ucircumflexbelow=7799;e.ucyrillic=1091;e.udattadeva=2385;e.udblacute=369;e.udblgrave=533;e.udeva=2313;e.udieresis=252;e.udieresisacute=472;e.udieresisbelow=7795;e.udieresiscaron=474;e.udieresiscyrillic=1265;e.udieresisgrave=476;e.udieresismacron=470;e.udotbelow=7909;e.ugrave=249;e.ugujarati=2697;e.ugurmukhi=2569;e.uhiragana=12358;e.uhookabove=7911;e.uhorn=432;e.uhornacute=7913;e.uhorndotbelow=7921;e.uhorngrave=7915;e.uhornhookabove=7917;e.uhorntilde=7919;e.uhungarumlaut=369;e.uhungarumlautcyrillic=1267;e.uinvertedbreve=535;e.ukatakana=12454;e.ukatakanahalfwidth=65395;e.ukcyrillic=1145;e.ukorean=12636;e.umacron=363;e.umacroncyrillic=1263;e.umacrondieresis=7803;e.umatragurmukhi=2625;e.umonospace=65365;e.underscore=95;e.underscoredbl=8215;e.underscoremonospace=65343;e.underscorevertical=65075;e.underscorewavy=65103;e.union=8746;e.universal=8704;e.uogonek=371;e.uparen=9392;e.upblock=9600;e.upperdothebrew=1476;e.upsilon=965;e.upsilondieresis=971;e.upsilondieresistonos=944;e.upsilonlatin=650;e.upsilontonos=973;e.uptackbelowcmb=797;e.uptackmod=724;e.uragurmukhi=2675;e.uring=367;e.ushortcyrillic=1118;e.usmallhiragana=12357;e.usmallkatakana=12453;e.usmallkatakanahalfwidth=65385;e.ustraightcyrillic=1199;e.ustraightstrokecyrillic=1201;e.utilde=361;e.utildeacute=7801;e.utildebelow=7797;e.uubengali=2442;e.uudeva=2314;e.uugujarati=2698;e.uugurmukhi=2570;e.uumatragurmukhi=2626;e.uuvowelsignbengali=2498;e.uuvowelsigndeva=2370;e.uuvowelsigngujarati=2754;e.uvowelsignbengali=2497;e.uvowelsigndeva=2369;e.uvowelsigngujarati=2753;e.v=118;e.vadeva=2357;e.vagujarati=2741;e.vagurmukhi=2613;e.vakatakana=12535;e.vav=1493;e.vavdagesh=64309;e.vavdagesh65=64309;e.vavdageshhebrew=64309;e.vavhebrew=1493;e.vavholam=64331;e.vavholamhebrew=64331;e.vavvavhebrew=1520;e.vavyodhebrew=1521;e.vcircle=9445;e.vdotbelow=7807;e.vecyrillic=1074;e.veharabic=1700;e.vehfinalarabic=64363;e.vehinitialarabic=64364;e.vehmedialarabic=64365;e.vekatakana=12537;e.venus=9792;e.verticalbar=124;e.verticallineabovecmb=781;e.verticallinebelowcmb=809;e.verticallinelowmod=716;e.verticallinemod=712;e.vewarmenian=1406;e.vhook=651;e.vikatakana=12536;e.viramabengali=2509;e.viramadeva=2381;e.viramagujarati=2765;e.visargabengali=2435;e.visargadeva=2307;e.visargagujarati=2691;e.vmonospace=65366;e.voarmenian=1400;e.voicediterationhiragana=12446;e.voicediterationkatakana=12542;e.voicedmarkkana=12443;e.voicedmarkkanahalfwidth=65438;e.vokatakana=12538;e.vparen=9393;e.vtilde=7805;e.vturned=652;e.vuhiragana=12436;e.vukatakana=12532;e.w=119;e.wacute=7811;e.waekorean=12633;e.wahiragana=12431;e.wakatakana=12527;e.wakatakanahalfwidth=65436;e.wakorean=12632;e.wasmallhiragana=12430;e.wasmallkatakana=12526;e.wattosquare=13143;e.wavedash=12316;e.wavyunderscorevertical=65076;e.wawarabic=1608;e.wawfinalarabic=65262;e.wawhamzaabovearabic=1572;e.wawhamzaabovefinalarabic=65158;e.wbsquare=13277;e.wcircle=9446;e.wcircumflex=373;e.wdieresis=7813;e.wdotaccent=7815;e.wdotbelow=7817;e.wehiragana=12433;e.weierstrass=8472;e.wekatakana=12529;e.wekorean=12638;e.weokorean=12637;e.wgrave=7809;e.whitebullet=9702;e.whitecircle=9675;e.whitecircleinverse=9689;e.whitecornerbracketleft=12302;e.whitecornerbracketleftvertical=65091;e.whitecornerbracketright=12303;e.whitecornerbracketrightvertical=65092;e.whitediamond=9671;e.whitediamondcontainingblacksmalldiamond=9672;e.whitedownpointingsmalltriangle=9663;e.whitedownpointingtriangle=9661;e.whiteleftpointingsmalltriangle=9667;e.whiteleftpointingtriangle=9665;e.whitelenticularbracketleft=12310;e.whitelenticularbracketright=12311;e.whiterightpointingsmalltriangle=9657;e.whiterightpointingtriangle=9655;e.whitesmallsquare=9643;e.whitesmilingface=9786;e.whitesquare=9633;e.whitestar=9734;e.whitetelephone=9743;e.whitetortoiseshellbracketleft=12312;e.whitetortoiseshellbracketright=12313;e.whiteuppointingsmalltriangle=9653;e.whiteuppointingtriangle=9651;e.wihiragana=12432;e.wikatakana=12528;e.wikorean=12639;e.wmonospace=65367;e.wohiragana=12434;e.wokatakana=12530;e.wokatakanahalfwidth=65382;e.won=8361;e.wonmonospace=65510;e.wowaenthai=3623;e.wparen=9394;e.wring=7832;e.wsuperior=695;e.wturned=653;e.wynn=447;e.x=120;e.xabovecmb=829;e.xbopomofo=12562;e.xcircle=9447;e.xdieresis=7821;e.xdotaccent=7819;e.xeharmenian=1389;e.xi=958;e.xmonospace=65368;e.xparen=9395;e.xsuperior=739;e.y=121;e.yaadosquare=13134;e.yabengali=2479;e.yacute=253;e.yadeva=2351;e.yaekorean=12626;e.yagujarati=2735;e.yagurmukhi=2607;e.yahiragana=12420;e.yakatakana=12516;e.yakatakanahalfwidth=65428;e.yakorean=12625;e.yamakkanthai=3662;e.yasmallhiragana=12419;e.yasmallkatakana=12515;e.yasmallkatakanahalfwidth=65388;e.yatcyrillic=1123;e.ycircle=9448;e.ycircumflex=375;e.ydieresis=255;e.ydotaccent=7823;e.ydotbelow=7925;e.yeharabic=1610;e.yehbarreearabic=1746;e.yehbarreefinalarabic=64431;e.yehfinalarabic=65266;e.yehhamzaabovearabic=1574;e.yehhamzaabovefinalarabic=65162;e.yehhamzaaboveinitialarabic=65163;e.yehhamzaabovemedialarabic=65164;e.yehinitialarabic=65267;e.yehmedialarabic=65268;e.yehmeeminitialarabic=64733;e.yehmeemisolatedarabic=64600;e.yehnoonfinalarabic=64660;e.yehthreedotsbelowarabic=1745;e.yekorean=12630;e.yen=165;e.yenmonospace=65509;e.yeokorean=12629;e.yeorinhieuhkorean=12678;e.yerahbenyomohebrew=1450;e.yerahbenyomolefthebrew=1450;e.yericyrillic=1099;e.yerudieresiscyrillic=1273;e.yesieungkorean=12673;e.yesieungpansioskorean=12675;e.yesieungsioskorean=12674;e.yetivhebrew=1434;e.ygrave=7923;e.yhook=436;e.yhookabove=7927;e.yiarmenian=1397;e.yicyrillic=1111;e.yikorean=12642;e.yinyang=9775;e.yiwnarmenian=1410;e.ymonospace=65369;e.yod=1497;e.yoddagesh=64313;e.yoddageshhebrew=64313;e.yodhebrew=1497;e.yodyodhebrew=1522;e.yodyodpatahhebrew=64287;e.yohiragana=12424;e.yoikorean=12681;e.yokatakana=12520;e.yokatakanahalfwidth=65430;e.yokorean=12635;e.yosmallhiragana=12423;e.yosmallkatakana=12519;e.yosmallkatakanahalfwidth=65390;e.yotgreek=1011;e.yoyaekorean=12680;e.yoyakorean=12679;e.yoyakthai=3618;e.yoyingthai=3597;e.yparen=9396;e.ypogegrammeni=890;e.ypogegrammenigreekcmb=837;e.yr=422;e.yring=7833;e.ysuperior=696;e.ytilde=7929;e.yturned=654;e.yuhiragana=12422;e.yuikorean=12684;e.yukatakana=12518;e.yukatakanahalfwidth=65429;e.yukorean=12640;e.yusbigcyrillic=1131;e.yusbigiotifiedcyrillic=1133;e.yuslittlecyrillic=1127;e.yuslittleiotifiedcyrillic=1129;e.yusmallhiragana=12421;e.yusmallkatakana=12517;e.yusmallkatakanahalfwidth=65389;e.yuyekorean=12683;e.yuyeokorean=12682;e.yyabengali=2527;e.yyadeva=2399;e.z=122;e.zaarmenian=1382;e.zacute=378;e.zadeva=2395;e.zagurmukhi=2651;e.zaharabic=1592;e.zahfinalarabic=65222;e.zahinitialarabic=65223;e.zahiragana=12374;e.zahmedialarabic=65224;e.zainarabic=1586;e.zainfinalarabic=65200;e.zakatakana=12470;e.zaqefgadolhebrew=1429;e.zaqefqatanhebrew=1428;e.zarqahebrew=1432;e.zayin=1494;e.zayindagesh=64310;e.zayindageshhebrew=64310;e.zayinhebrew=1494;e.zbopomofo=12567;e.zcaron=382;e.zcircle=9449;e.zcircumflex=7825;e.zcurl=657;e.zdot=380;e.zdotaccent=380;e.zdotbelow=7827;e.zecyrillic=1079;e.zedescendercyrillic=1177;e.zedieresiscyrillic=1247;e.zehiragana=12380;e.zekatakana=12476;e.zero=48;e.zeroarabic=1632;e.zerobengali=2534;e.zerodeva=2406;e.zerogujarati=2790;e.zerogurmukhi=2662;e.zerohackarabic=1632;e.zeroinferior=8320;e.zeromonospace=65296;e.zerooldstyle=63280;e.zeropersian=1776;e.zerosuperior=8304;e.zerothai=3664;e.zerowidthjoiner=65279;e.zerowidthnonjoiner=8204;e.zerowidthspace=8203;e.zeta=950;e.zhbopomofo=12563;e.zhearmenian=1386;e.zhebrevecyrillic=1218;e.zhecyrillic=1078;e.zhedescendercyrillic=1175;e.zhedieresiscyrillic=1245;e.zihiragana=12376;e.zikatakana=12472;e.zinorhebrew=1454;e.zlinebelow=7829;e.zmonospace=65370;e.zohiragana=12382;e.zokatakana=12478;e.zparen=9397;e.zretroflexhook=656;e.zstroke=438;e.zuhiragana=12378;e.zukatakana=12474;e[".notdef"]=0;e.angbracketleftbig=9001;e.angbracketleftBig=9001;e.angbracketleftbigg=9001;e.angbracketleftBigg=9001;e.angbracketrightBig=9002;e.angbracketrightbig=9002;e.angbracketrightBigg=9002;e.angbracketrightbigg=9002;e.arrowhookleft=8618;e.arrowhookright=8617;e.arrowlefttophalf=8636;e.arrowleftbothalf=8637;e.arrownortheast=8599;e.arrownorthwest=8598;e.arrowrighttophalf=8640;e.arrowrightbothalf=8641;e.arrowsoutheast=8600;e.arrowsouthwest=8601;e.backslashbig=8726;e.backslashBig=8726;e.backslashBigg=8726;e.backslashbigg=8726;e.bardbl=8214;e.bracehtipdownleft=65079;e.bracehtipdownright=65079;e.bracehtipupleft=65080;e.bracehtipupright=65080;e.braceleftBig=123;e.braceleftbig=123;e.braceleftbigg=123;e.braceleftBigg=123;e.bracerightBig=125;e.bracerightbig=125;e.bracerightbigg=125;e.bracerightBigg=125;e.bracketleftbig=91;e.bracketleftBig=91;e.bracketleftbigg=91;e.bracketleftBigg=91;e.bracketrightBig=93;e.bracketrightbig=93;e.bracketrightbigg=93;e.bracketrightBigg=93;e.ceilingleftbig=8968;e.ceilingleftBig=8968;e.ceilingleftBigg=8968;e.ceilingleftbigg=8968;e.ceilingrightbig=8969;e.ceilingrightBig=8969;e.ceilingrightbigg=8969;e.ceilingrightBigg=8969;e.circledotdisplay=8857;e.circledottext=8857;e.circlemultiplydisplay=8855;e.circlemultiplytext=8855;e.circleplusdisplay=8853;e.circleplustext=8853;e.contintegraldisplay=8750;e.contintegraltext=8750;e.coproductdisplay=8720;e.coproducttext=8720;e.floorleftBig=8970;e.floorleftbig=8970;e.floorleftbigg=8970;e.floorleftBigg=8970;e.floorrightbig=8971;e.floorrightBig=8971;e.floorrightBigg=8971;e.floorrightbigg=8971;e.hatwide=770;e.hatwider=770;e.hatwidest=770;e.intercal=7488;e.integraldisplay=8747;e.integraltext=8747;e.intersectiondisplay=8898;e.intersectiontext=8898;e.logicalanddisplay=8743;e.logicalandtext=8743;e.logicalordisplay=8744;e.logicalortext=8744;e.parenleftBig=40;e.parenleftbig=40;e.parenleftBigg=40;e.parenleftbigg=40;e.parenrightBig=41;e.parenrightbig=41;e.parenrightBigg=41;e.parenrightbigg=41;e.prime=8242;e.productdisplay=8719;e.producttext=8719;e.radicalbig=8730;e.radicalBig=8730;e.radicalBigg=8730;e.radicalbigg=8730;e.radicalbt=8730;e.radicaltp=8730;e.radicalvertex=8730;e.slashbig=47;e.slashBig=47;e.slashBigg=47;e.slashbigg=47;e.summationdisplay=8721;e.summationtext=8721;e.tildewide=732;e.tildewider=732;e.tildewidest=732;e.uniondisplay=8899;e.unionmultidisplay=8846;e.unionmultitext=8846;e.unionsqdisplay=8852;e.unionsqtext=8852;e.uniontext=8899;e.vextenddouble=8741;e.vextendsingle=8739})),n=r((function(e){e.space=32;e.a1=9985;e.a2=9986;e.a202=9987;e.a3=9988;e.a4=9742;e.a5=9990;e.a119=9991;e.a118=9992;e.a117=9993;e.a11=9755;e.a12=9758;e.a13=9996;e.a14=9997;e.a15=9998;e.a16=9999;e.a105=1e4;e.a17=10001;e.a18=10002;e.a19=10003;e.a20=10004;e.a21=10005;e.a22=10006;e.a23=10007;e.a24=10008;e.a25=10009;e.a26=10010;e.a27=10011;e.a28=10012;e.a6=10013;e.a7=10014;e.a8=10015;e.a9=10016;e.a10=10017;e.a29=10018;e.a30=10019;e.a31=10020;e.a32=10021;e.a33=10022;e.a34=10023;e.a35=9733;e.a36=10025;e.a37=10026;e.a38=10027;e.a39=10028;e.a40=10029;e.a41=10030;e.a42=10031;e.a43=10032;e.a44=10033;e.a45=10034;e.a46=10035;e.a47=10036;e.a48=10037;e.a49=10038;e.a50=10039;e.a51=10040;e.a52=10041;e.a53=10042;e.a54=10043;e.a55=10044;e.a56=10045;e.a57=10046;e.a58=10047;e.a59=10048;e.a60=10049;e.a61=10050;e.a62=10051;e.a63=10052;e.a64=10053;e.a65=10054;e.a66=10055;e.a67=10056;e.a68=10057;e.a69=10058;e.a70=10059;e.a71=9679;e.a72=10061;e.a73=9632;e.a74=10063;e.a203=10064;e.a75=10065;e.a204=10066;e.a76=9650;e.a77=9660;e.a78=9670;e.a79=10070;e.a81=9687;e.a82=10072;e.a83=10073;e.a84=10074;e.a97=10075;e.a98=10076;e.a99=10077;e.a100=10078;e.a101=10081;e.a102=10082;e.a103=10083;e.a104=10084;e.a106=10085;e.a107=10086;e.a108=10087;e.a112=9827;e.a111=9830;e.a110=9829;e.a109=9824;e.a120=9312;e.a121=9313;e.a122=9314;e.a123=9315;e.a124=9316;e.a125=9317;e.a126=9318;e.a127=9319;e.a128=9320;e.a129=9321;e.a130=10102;e.a131=10103;e.a132=10104;e.a133=10105;e.a134=10106;e.a135=10107;e.a136=10108;e.a137=10109;e.a138=10110;e.a139=10111;e.a140=10112;e.a141=10113;e.a142=10114;e.a143=10115;e.a144=10116;e.a145=10117;e.a146=10118;e.a147=10119;e.a148=10120;e.a149=10121;e.a150=10122;e.a151=10123;e.a152=10124;e.a153=10125;e.a154=10126;e.a155=10127;e.a156=10128;e.a157=10129;e.a158=10130;e.a159=10131;e.a160=10132;e.a161=8594;e.a163=8596;e.a164=8597;e.a196=10136;e.a165=10137;e.a192=10138;e.a166=10139;e.a167=10140;e.a168=10141;e.a169=10142;e.a170=10143;e.a171=10144;e.a172=10145;e.a173=10146;e.a162=10147;e.a174=10148;e.a175=10149;e.a176=10150;e.a177=10151;e.a178=10152;e.a179=10153;e.a193=10154;e.a180=10155;e.a199=10156;e.a181=10157;e.a200=10158;e.a182=10159;e.a201=10161;e.a183=10162;e.a184=10163;e.a197=10164;e.a185=10165;e.a194=10166;e.a198=10167;e.a186=10168;e.a195=10169;e.a187=10170;e.a188=10171;e.a189=10172;e.a190=10173;e.a191=10174;e.a89=10088;e.a90=10089;e.a93=10090;e.a94=10091;e.a91=10092;e.a92=10093;e.a205=10094;e.a85=10095;e.a206=10096;e.a86=10097;e.a87=10098;e.a88=10099;e.a95=10100;e.a96=10101;e[".notdef"]=0}));t.getGlyphsUnicode=i;t.getDingbatsGlyphsUnicode=n},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.getSupplementalGlyphMapForCalibri=t.getSupplementalGlyphMapForArialBlack=t.getGlyphMapForStandardFonts=t.getSymbolsFonts=t.getSerifFonts=t.getNonStdFontMap=t.getStdFontMap=void 0;var r=a(7);const i=(0,r.getLookupTableFactory)((function(e){e.ArialNarrow="Helvetica";e["ArialNarrow-Bold"]="Helvetica-Bold";e["ArialNarrow-BoldItalic"]="Helvetica-BoldOblique";e["ArialNarrow-Italic"]="Helvetica-Oblique";e.ArialBlack="Helvetica";e["ArialBlack-Bold"]="Helvetica-Bold";e["ArialBlack-BoldItalic"]="Helvetica-BoldOblique";e["ArialBlack-Italic"]="Helvetica-Oblique";e["Arial-Black"]="Helvetica";e["Arial-Black-Bold"]="Helvetica-Bold";e["Arial-Black-BoldItalic"]="Helvetica-BoldOblique";e["Arial-Black-Italic"]="Helvetica-Oblique";e.Arial="Helvetica";e["Arial-Bold"]="Helvetica-Bold";e["Arial-BoldItalic"]="Helvetica-BoldOblique";e["Arial-Italic"]="Helvetica-Oblique";e["Arial-BoldItalicMT"]="Helvetica-BoldOblique";e["Arial-BoldMT"]="Helvetica-Bold";e["Arial-ItalicMT"]="Helvetica-Oblique";e.ArialMT="Helvetica";e["Courier-Bold"]="Courier-Bold";e["Courier-BoldItalic"]="Courier-BoldOblique";e["Courier-Italic"]="Courier-Oblique";e.CourierNew="Courier";e["CourierNew-Bold"]="Courier-Bold";e["CourierNew-BoldItalic"]="Courier-BoldOblique";e["CourierNew-Italic"]="Courier-Oblique";e["CourierNewPS-BoldItalicMT"]="Courier-BoldOblique";e["CourierNewPS-BoldMT"]="Courier-Bold";e["CourierNewPS-ItalicMT"]="Courier-Oblique";e.CourierNewPSMT="Courier";e.Helvetica="Helvetica";e["Helvetica-Bold"]="Helvetica-Bold";e["Helvetica-BoldItalic"]="Helvetica-BoldOblique";e["Helvetica-BoldOblique"]="Helvetica-BoldOblique";e["Helvetica-Italic"]="Helvetica-Oblique";e["Helvetica-Oblique"]="Helvetica-Oblique";e["Symbol-Bold"]="Symbol";e["Symbol-BoldItalic"]="Symbol";e["Symbol-Italic"]="Symbol";e.TimesNewRoman="Times-Roman";e["TimesNewRoman-Bold"]="Times-Bold";e["TimesNewRoman-BoldItalic"]="Times-BoldItalic";e["TimesNewRoman-Italic"]="Times-Italic";e.TimesNewRomanPS="Times-Roman";e["TimesNewRomanPS-Bold"]="Times-Bold";e["TimesNewRomanPS-BoldItalic"]="Times-BoldItalic";e["TimesNewRomanPS-BoldItalicMT"]="Times-BoldItalic";e["TimesNewRomanPS-BoldMT"]="Times-Bold";e["TimesNewRomanPS-Italic"]="Times-Italic";e["TimesNewRomanPS-ItalicMT"]="Times-Italic";e.TimesNewRomanPSMT="Times-Roman";e["TimesNewRomanPSMT-Bold"]="Times-Bold";e["TimesNewRomanPSMT-BoldItalic"]="Times-BoldItalic";e["TimesNewRomanPSMT-Italic"]="Times-Italic"}));t.getStdFontMap=i;const n=(0,r.getLookupTableFactory)((function(e){e.Calibri="Helvetica";e["Calibri-Bold"]="Helvetica-Bold";e["Calibri-BoldItalic"]="Helvetica-BoldOblique";e["Calibri-Italic"]="Helvetica-Oblique";e.CenturyGothic="Helvetica";e["CenturyGothic-Bold"]="Helvetica-Bold";e["CenturyGothic-BoldItalic"]="Helvetica-BoldOblique";e["CenturyGothic-Italic"]="Helvetica-Oblique";e.ComicSansMS="Comic Sans MS";e["ComicSansMS-Bold"]="Comic Sans MS-Bold";e["ComicSansMS-BoldItalic"]="Comic Sans MS-BoldItalic";e["ComicSansMS-Italic"]="Comic Sans MS-Italic";e.LucidaConsole="Courier";e["LucidaConsole-Bold"]="Courier-Bold";e["LucidaConsole-BoldItalic"]="Courier-BoldOblique";e["LucidaConsole-Italic"]="Courier-Oblique";e["LucidaSans-Demi"]="Helvetica-Bold";e["MS-Gothic"]="MS Gothic";e["MS-Gothic-Bold"]="MS Gothic-Bold";e["MS-Gothic-BoldItalic"]="MS Gothic-BoldItalic";e["MS-Gothic-Italic"]="MS Gothic-Italic";e["MS-Mincho"]="MS Mincho";e["MS-Mincho-Bold"]="MS Mincho-Bold";e["MS-Mincho-BoldItalic"]="MS Mincho-BoldItalic";e["MS-Mincho-Italic"]="MS Mincho-Italic";e["MS-PGothic"]="MS PGothic";e["MS-PGothic-Bold"]="MS PGothic-Bold";e["MS-PGothic-BoldItalic"]="MS PGothic-BoldItalic";e["MS-PGothic-Italic"]="MS PGothic-Italic";e["MS-PMincho"]="MS PMincho";e["MS-PMincho-Bold"]="MS PMincho-Bold";e["MS-PMincho-BoldItalic"]="MS PMincho-BoldItalic";e["MS-PMincho-Italic"]="MS PMincho-Italic";e.NuptialScript="Times-Italic";e.SegoeUISymbol="Helvetica";e.Wingdings="ZapfDingbats";e["Wingdings-Regular"]="ZapfDingbats"}));t.getNonStdFontMap=n;const s=(0,r.getLookupTableFactory)((function(e){e["Adobe Jenson"]=!0;e["Adobe Text"]=!0;e.Albertus=!0;e.Aldus=!0;e.Alexandria=!0;e.Algerian=!0;e["American Typewriter"]=!0;e.Antiqua=!0;e.Apex=!0;e.Arno=!0;e.Aster=!0;e.Aurora=!0;e.Baskerville=!0;e.Bell=!0;e.Bembo=!0;e["Bembo Schoolbook"]=!0;e.Benguiat=!0;e["Berkeley Old Style"]=!0;e["Bernhard Modern"]=!0;e["Berthold City"]=!0;e.Bodoni=!0;e["Bauer Bodoni"]=!0;e["Book Antiqua"]=!0;e.Bookman=!0;e["Bordeaux Roman"]=!0;e["Californian FB"]=!0;e.Calisto=!0;e.Calvert=!0;e.Capitals=!0;e.Cambria=!0;e.Cartier=!0;e.Caslon=!0;e.Catull=!0;e.Centaur=!0;e["Century Old Style"]=!0;e["Century Schoolbook"]=!0;e.Chaparral=!0;e["Charis SIL"]=!0;e.Cheltenham=!0;e["Cholla Slab"]=!0;e.Clarendon=!0;e.Clearface=!0;e.Cochin=!0;e.Colonna=!0;e["Computer Modern"]=!0;e["Concrete Roman"]=!0;e.Constantia=!0;e["Cooper Black"]=!0;e.Corona=!0;e.Ecotype=!0;e.Egyptienne=!0;e.Elephant=!0;e.Excelsior=!0;e.Fairfield=!0;e["FF Scala"]=!0;e.Folkard=!0;e.Footlight=!0;e.FreeSerif=!0;e["Friz Quadrata"]=!0;e.Garamond=!0;e.Gentium=!0;e.Georgia=!0;e.Gloucester=!0;e["Goudy Old Style"]=!0;e["Goudy Schoolbook"]=!0;e["Goudy Pro Font"]=!0;e.Granjon=!0;e["Guardian Egyptian"]=!0;e.Heather=!0;e.Hercules=!0;e["High Tower Text"]=!0;e.Hiroshige=!0;e["Hoefler Text"]=!0;e["Humana Serif"]=!0;e.Imprint=!0;e["Ionic No. 5"]=!0;e.Janson=!0;e.Joanna=!0;e.Korinna=!0;e.Lexicon=!0;e["Liberation Serif"]=!0;e["Linux Libertine"]=!0;e.Literaturnaya=!0;e.Lucida=!0;e["Lucida Bright"]=!0;e.Melior=!0;e.Memphis=!0;e.Miller=!0;e.Minion=!0;e.Modern=!0;e["Mona Lisa"]=!0;e["Mrs Eaves"]=!0;e["MS Serif"]=!0;e["Museo Slab"]=!0;e["New York"]=!0;e["Nimbus Roman"]=!0;e["NPS Rawlinson Roadway"]=!0;e.NuptialScript=!0;e.Palatino=!0;e.Perpetua=!0;e.Plantin=!0;e["Plantin Schoolbook"]=!0;e.Playbill=!0;e["Poor Richard"]=!0;e["Rawlinson Roadway"]=!0;e.Renault=!0;e.Requiem=!0;e.Rockwell=!0;e.Roman=!0;e["Rotis Serif"]=!0;e.Sabon=!0;e.Scala=!0;e.Seagull=!0;e.Sistina=!0;e.Souvenir=!0;e.STIX=!0;e["Stone Informal"]=!0;e["Stone Serif"]=!0;e.Sylfaen=!0;e.Times=!0;e.Trajan=!0;e["Trinité"]=!0;e["Trump Mediaeval"]=!0;e.Utopia=!0;e["Vale Type"]=!0;e["Bitstream Vera"]=!0;e["Vera Serif"]=!0;e.Versailles=!0;e.Wanted=!0;e.Weiss=!0;e["Wide Latin"]=!0;e.Windsor=!0;e.XITS=!0}));t.getSerifFonts=s;const o=(0,r.getLookupTableFactory)((function(e){e.Dingbats=!0;e.Symbol=!0;e.ZapfDingbats=!0}));t.getSymbolsFonts=o;const c=(0,r.getLookupTableFactory)((function(e){e[2]=10;e[3]=32;e[4]=33;e[5]=34;e[6]=35;e[7]=36;e[8]=37;e[9]=38;e[10]=39;e[11]=40;e[12]=41;e[13]=42;e[14]=43;e[15]=44;e[16]=45;e[17]=46;e[18]=47;e[19]=48;e[20]=49;e[21]=50;e[22]=51;e[23]=52;e[24]=53;e[25]=54;e[26]=55;e[27]=56;e[28]=57;e[29]=58;e[30]=894;e[31]=60;e[32]=61;e[33]=62;e[34]=63;e[35]=64;e[36]=65;e[37]=66;e[38]=67;e[39]=68;e[40]=69;e[41]=70;e[42]=71;e[43]=72;e[44]=73;e[45]=74;e[46]=75;e[47]=76;e[48]=77;e[49]=78;e[50]=79;e[51]=80;e[52]=81;e[53]=82;e[54]=83;e[55]=84;e[56]=85;e[57]=86;e[58]=87;e[59]=88;e[60]=89;e[61]=90;e[62]=91;e[63]=92;e[64]=93;e[65]=94;e[66]=95;e[67]=96;e[68]=97;e[69]=98;e[70]=99;e[71]=100;e[72]=101;e[73]=102;e[74]=103;e[75]=104;e[76]=105;e[77]=106;e[78]=107;e[79]=108;e[80]=109;e[81]=110;e[82]=111;e[83]=112;e[84]=113;e[85]=114;e[86]=115;e[87]=116;e[88]=117;e[89]=118;e[90]=119;e[91]=120;e[92]=121;e[93]=122;e[94]=123;e[95]=124;e[96]=125;e[97]=126;e[98]=196;e[99]=197;e[100]=199;e[101]=201;e[102]=209;e[103]=214;e[104]=220;e[105]=225;e[106]=224;e[107]=226;e[108]=228;e[109]=227;e[110]=229;e[111]=231;e[112]=233;e[113]=232;e[114]=234;e[115]=235;e[116]=237;e[117]=236;e[118]=238;e[119]=239;e[120]=241;e[121]=243;e[122]=242;e[123]=244;e[124]=246;e[125]=245;e[126]=250;e[127]=249;e[128]=251;e[129]=252;e[130]=8224;e[131]=176;e[132]=162;e[133]=163;e[134]=167;e[135]=8226;e[136]=182;e[137]=223;e[138]=174;e[139]=169;e[140]=8482;e[141]=180;e[142]=168;e[143]=8800;e[144]=198;e[145]=216;e[146]=8734;e[147]=177;e[148]=8804;e[149]=8805;e[150]=165;e[151]=181;e[152]=8706;e[153]=8721;e[154]=8719;e[156]=8747;e[157]=170;e[158]=186;e[159]=8486;e[160]=230;e[161]=248;e[162]=191;e[163]=161;e[164]=172;e[165]=8730;e[166]=402;e[167]=8776;e[168]=8710;e[169]=171;e[170]=187;e[171]=8230;e[210]=218;e[223]=711;e[224]=321;e[225]=322;e[227]=353;e[229]=382;e[234]=253;e[252]=263;e[253]=268;e[254]=269;e[258]=258;e[260]=260;e[261]=261;e[265]=280;e[266]=281;e[268]=283;e[269]=313;e[275]=323;e[276]=324;e[278]=328;e[284]=345;e[285]=346;e[286]=347;e[292]=367;e[295]=377;e[296]=378;e[298]=380;e[305]=963;e[306]=964;e[307]=966;e[308]=8215;e[309]=8252;e[310]=8319;e[311]=8359;e[312]=8592;e[313]=8593;e[337]=9552;e[493]=1039;e[494]=1040;e[705]=1524;e[706]=8362;e[710]=64288;e[711]=64298;e[759]=1617;e[761]=1776;e[763]=1778;e[775]=1652;e[777]=1764;e[778]=1780;e[779]=1781;e[780]=1782;e[782]=771;e[783]=64726;e[786]=8363;e[788]=8532;e[790]=768;e[791]=769;e[792]=768;e[795]=803;e[797]=64336;e[798]=64337;e[799]=64342;e[800]=64343;e[801]=64344;e[802]=64345;e[803]=64362;e[804]=64363;e[805]=64364;e[2424]=7821;e[2425]=7822;e[2426]=7823;e[2427]=7824;e[2428]=7825;e[2429]=7826;e[2430]=7827;e[2433]=7682;e[2678]=8045;e[2679]=8046;e[2830]=1552;e[2838]=686;e[2840]=751;e[2842]=753;e[2843]=754;e[2844]=755;e[2846]=757;e[2856]=767;e[2857]=848;e[2858]=849;e[2862]=853;e[2863]=854;e[2864]=855;e[2865]=861;e[2866]=862;e[2906]=7460;e[2908]=7462;e[2909]=7463;e[2910]=7464;e[2912]=7466;e[2913]=7467;e[2914]=7468;e[2916]=7470;e[2917]=7471;e[2918]=7472;e[2920]=7474;e[2921]=7475;e[2922]=7476;e[2924]=7478;e[2925]=7479;e[2926]=7480;e[2928]=7482;e[2929]=7483;e[2930]=7484;e[2932]=7486;e[2933]=7487;e[2934]=7488;e[2936]=7490;e[2937]=7491;e[2938]=7492;e[2940]=7494;e[2941]=7495;e[2942]=7496;e[2944]=7498;e[2946]=7500;e[2948]=7502;e[2950]=7504;e[2951]=7505;e[2952]=7506;e[2954]=7508;e[2955]=7509;e[2956]=7510;e[2958]=7512;e[2959]=7513;e[2960]=7514;e[2962]=7516;e[2963]=7517;e[2964]=7518;e[2966]=7520;e[2967]=7521;e[2968]=7522;e[2970]=7524;e[2971]=7525;e[2972]=7526;e[2974]=7528;e[2975]=7529;e[2976]=7530;e[2978]=1537;e[2979]=1538;e[2980]=1539;e[2982]=1549;e[2983]=1551;e[2984]=1552;e[2986]=1554;e[2987]=1555;e[2988]=1556;e[2990]=1623;e[2991]=1624;e[2995]=1775;e[2999]=1791;e[3002]=64290;e[3003]=64291;e[3004]=64292;e[3006]=64294;e[3007]=64295;e[3008]=64296;e[3011]=1900;e[3014]=8223;e[3015]=8244;e[3017]=7532;e[3018]=7533;e[3019]=7534;e[3075]=7590;e[3076]=7591;e[3079]=7594;e[3080]=7595;e[3083]=7598;e[3084]=7599;e[3087]=7602;e[3088]=7603;e[3091]=7606;e[3092]=7607;e[3095]=7610;e[3096]=7611;e[3099]=7614;e[3100]=7615;e[3103]=7618;e[3104]=7619;e[3107]=8337;e[3108]=8338;e[3116]=1884;e[3119]=1885;e[3120]=1885;e[3123]=1886;e[3124]=1886;e[3127]=1887;e[3128]=1887;e[3131]=1888;e[3132]=1888;e[3135]=1889;e[3136]=1889;e[3139]=1890;e[3140]=1890;e[3143]=1891;e[3144]=1891;e[3147]=1892;e[3148]=1892;e[3153]=580;e[3154]=581;e[3157]=584;e[3158]=585;e[3161]=588;e[3162]=589;e[3165]=891;e[3166]=892;e[3169]=1274;e[3170]=1275;e[3173]=1278;e[3174]=1279;e[3181]=7622;e[3182]=7623;e[3282]=11799;e[3316]=578;e[3379]=42785;e[3393]=1159;e[3416]=8377}));t.getGlyphMapForStandardFonts=c;const l=(0,r.getLookupTableFactory)((function(e){e[227]=322;e[264]=261;e[291]=346}));t.getSupplementalGlyphMapForArialBlack=l;const h=(0,r.getLookupTableFactory)((function(e){e[1]=32;e[4]=65;e[17]=66;e[18]=67;e[24]=68;e[28]=69;e[38]=70;e[39]=71;e[44]=72;e[47]=73;e[58]=74;e[60]=75;e[62]=76;e[68]=77;e[69]=78;e[75]=79;e[87]=80;e[89]=81;e[90]=82;e[94]=83;e[100]=84;e[104]=85;e[115]=86;e[116]=87;e[121]=88;e[122]=89;e[127]=90;e[258]=97;e[268]=261;e[271]=98;e[272]=99;e[273]=263;e[282]=100;e[286]=101;e[295]=281;e[296]=102;e[336]=103;e[346]=104;e[349]=105;e[361]=106;e[364]=107;e[367]=108;e[371]=322;e[373]=109;e[374]=110;e[381]=111;e[383]=243;e[393]=112;e[395]=113;e[396]=114;e[400]=115;e[401]=347;e[410]=116;e[437]=117;e[448]=118;e[449]=119;e[454]=120;e[455]=121;e[460]=122;e[463]=380;e[853]=44;e[855]=58;e[856]=46;e[876]=47;e[878]=45;e[882]=45;e[894]=40;e[895]=41;e[896]=91;e[897]=93;e[923]=64;e[1004]=48;e[1005]=49;e[1006]=50;e[1007]=51;e[1008]=52;e[1009]=53;e[1010]=54;e[1011]=55;e[1012]=56;e[1013]=57;e[1081]=37;e[1085]=43;e[1086]=45}));t.getSupplementalGlyphMapForCalibri=h},function(e,t,a){var r=a(7).getLookupTableFactory,i=r((function(e){e[63721]=169;e[63193]=169;e[63720]=174;e[63194]=174;e[63722]=8482;e[63195]=8482;e[63729]=9127;e[63730]=9128;e[63731]=9129;e[63740]=9131;e[63741]=9132;e[63742]=9133;e[63726]=9121;e[63727]=9122;e[63728]=9123;e[63737]=9124;e[63738]=9125;e[63739]=9126;e[63723]=9115;e[63724]=9116;e[63725]=9117;e[63734]=9118;e[63735]=9119;e[63736]=9120}));var n=[{begin:0,end:127},{begin:128,end:255},{begin:256,end:383},{begin:384,end:591},{begin:592,end:687},{begin:688,end:767},{begin:768,end:879},{begin:880,end:1023},{begin:11392,end:11519},{begin:1024,end:1279},{begin:1328,end:1423},{begin:1424,end:1535},{begin:42240,end:42559},{begin:1536,end:1791},{begin:1984,end:2047},{begin:2304,end:2431},{begin:2432,end:2559},{begin:2560,end:2687},{begin:2688,end:2815},{begin:2816,end:2943},{begin:2944,end:3071},{begin:3072,end:3199},{begin:3200,end:3327},{begin:3328,end:3455},{begin:3584,end:3711},{begin:3712,end:3839},{begin:4256,end:4351},{begin:6912,end:7039},{begin:4352,end:4607},{begin:7680,end:7935},{begin:7936,end:8191},{begin:8192,end:8303},{begin:8304,end:8351},{begin:8352,end:8399},{begin:8400,end:8447},{begin:8448,end:8527},{begin:8528,end:8591},{begin:8592,end:8703},{begin:8704,end:8959},{begin:8960,end:9215},{begin:9216,end:9279},{begin:9280,end:9311},{begin:9312,end:9471},{begin:9472,end:9599},{begin:9600,end:9631},{begin:9632,end:9727},{begin:9728,end:9983},{begin:9984,end:10175},{begin:12288,end:12351},{begin:12352,end:12447},{begin:12448,end:12543},{begin:12544,end:12591},{begin:12592,end:12687},{begin:43072,end:43135},{begin:12800,end:13055},{begin:13056,end:13311},{begin:44032,end:55215},{begin:55296,end:57343},{begin:67840,end:67871},{begin:19968,end:40959},{begin:57344,end:63743},{begin:12736,end:12783},{begin:64256,end:64335},{begin:64336,end:65023},{begin:65056,end:65071},{begin:65040,end:65055},{begin:65104,end:65135},{begin:65136,end:65279},{begin:65280,end:65519},{begin:65520,end:65535},{begin:3840,end:4095},{begin:1792,end:1871},{begin:1920,end:1983},{begin:3456,end:3583},{begin:4096,end:4255},{begin:4608,end:4991},{begin:5024,end:5119},{begin:5120,end:5759},{begin:5760,end:5791},{begin:5792,end:5887},{begin:6016,end:6143},{begin:6144,end:6319},{begin:10240,end:10495},{begin:40960,end:42127},{begin:5888,end:5919},{begin:66304,end:66351},{begin:66352,end:66383},{begin:66560,end:66639},{begin:118784,end:119039},{begin:119808,end:120831},{begin:1044480,end:1048573},{begin:65024,end:65039},{begin:917504,end:917631},{begin:6400,end:6479},{begin:6480,end:6527},{begin:6528,end:6623},{begin:6656,end:6687},{begin:11264,end:11359},{begin:11568,end:11647},{begin:19904,end:19967},{begin:43008,end:43055},{begin:65536,end:65663},{begin:65856,end:65935},{begin:66432,end:66463},{begin:66464,end:66527},{begin:66640,end:66687},{begin:66688,end:66735},{begin:67584,end:67647},{begin:68096,end:68191},{begin:119552,end:119647},{begin:73728,end:74751},{begin:119648,end:119679},{begin:7040,end:7103},{begin:7168,end:7247},{begin:7248,end:7295},{begin:43136,end:43231},{begin:43264,end:43311},{begin:43312,end:43359},{begin:43520,end:43615},{begin:65936,end:65999},{begin:66e3,end:66047},{begin:66208,end:66271},{begin:127024,end:127135}];var s=r((function(e){e["¨"]=" ̈";e["¯"]=" ̄";e["´"]=" ́";e["µ"]="μ";e["¸"]=" ̧";e["Ĳ"]="IJ";e["ĳ"]="ij";e["Ŀ"]="L·";e["ŀ"]="l·";e["ŉ"]="ʼn";e["ſ"]="s";e["Ǆ"]="DŽ";e["ǅ"]="Dž";e["ǆ"]="dž";e["Ǉ"]="LJ";e["ǈ"]="Lj";e["ǉ"]="lj";e["Ǌ"]="NJ";e["ǋ"]="Nj";e["ǌ"]="nj";e["Ǳ"]="DZ";e["ǲ"]="Dz";e["ǳ"]="dz";e["˘"]=" ̆";e["˙"]=" ̇";e["˚"]=" ̊";e["˛"]=" ̨";e["˜"]=" ̃";e["˝"]=" ̋";e["ͺ"]=" ͅ";e["΄"]=" ́";e["ϐ"]="β";e["ϑ"]="θ";e["ϒ"]="Υ";e["ϕ"]="φ";e["ϖ"]="π";e["ϰ"]="κ";e["ϱ"]="ρ";e["ϲ"]="ς";e["ϴ"]="Θ";e["ϵ"]="ε";e["Ϲ"]="Σ";e["և"]="եւ";e["ٵ"]="اٴ";e["ٶ"]="وٴ";e["ٷ"]="ۇٴ";e["ٸ"]="يٴ";e["ำ"]="ํา";e["ຳ"]="ໍາ";e["ໜ"]="ຫນ";e["ໝ"]="ຫມ";e["ཷ"]="ྲཱྀ";e["ཹ"]="ླཱྀ";e["ẚ"]="aʾ";e["᾽"]=" ̓";e["᾿"]=" ̓";e["῀"]=" ͂";e["῾"]=" ̔";e[" "]=" ";e[" "]=" ";e[" "]=" ";e[" "]=" ";e[" "]=" ";e[" "]=" ";e[" "]=" ";e[" "]=" ";e["‗"]=" ̳";e["․"]=".";e["‥"]="..";e["…"]="...";e["″"]="′′";e["‴"]="′′′";e["‶"]="‵‵";e["‷"]="‵‵‵";e["‼"]="!!";e["‾"]=" ̅";e["⁇"]="??";e["⁈"]="?!";e["⁉"]="!?";e["⁗"]="′′′′";e[" "]=" ";e["₨"]="Rs";e["℀"]="a/c";e["℁"]="a/s";e["℃"]="°C";e["℅"]="c/o";e["℆"]="c/u";e["ℇ"]="Ɛ";e["℉"]="°F";e["№"]="No";e["℡"]="TEL";e["ℵ"]="א";e["ℶ"]="ב";e["ℷ"]="ג";e["ℸ"]="ד";e["℻"]="FAX";e["Ⅰ"]="I";e["Ⅱ"]="II";e["Ⅲ"]="III";e["Ⅳ"]="IV";e["Ⅴ"]="V";e["Ⅵ"]="VI";e["Ⅶ"]="VII";e["Ⅷ"]="VIII";e["Ⅸ"]="IX";e["Ⅹ"]="X";e["Ⅺ"]="XI";e["Ⅻ"]="XII";e["Ⅼ"]="L";e["Ⅽ"]="C";e["Ⅾ"]="D";e["Ⅿ"]="M";e["ⅰ"]="i";e["ⅱ"]="ii";e["ⅲ"]="iii";e["ⅳ"]="iv";e["ⅴ"]="v";e["ⅵ"]="vi";e["ⅶ"]="vii";e["ⅷ"]="viii";e["ⅸ"]="ix";e["ⅹ"]="x";e["ⅺ"]="xi";e["ⅻ"]="xii";e["ⅼ"]="l";e["ⅽ"]="c";e["ⅾ"]="d";e["ⅿ"]="m";e["∬"]="∫∫";e["∭"]="∫∫∫";e["∯"]="∮∮";e["∰"]="∮∮∮";e["⑴"]="(1)";e["⑵"]="(2)";e["⑶"]="(3)";e["⑷"]="(4)";e["⑸"]="(5)";e["⑹"]="(6)";e["⑺"]="(7)";e["⑻"]="(8)";e["⑼"]="(9)";e["⑽"]="(10)";e["⑾"]="(11)";e["⑿"]="(12)";e["⒀"]="(13)";e["⒁"]="(14)";e["⒂"]="(15)";e["⒃"]="(16)";e["⒄"]="(17)";e["⒅"]="(18)";e["⒆"]="(19)";e["⒇"]="(20)";e["⒈"]="1.";e["⒉"]="2.";e["⒊"]="3.";e["⒋"]="4.";e["⒌"]="5.";e["⒍"]="6.";e["⒎"]="7.";e["⒏"]="8.";e["⒐"]="9.";e["⒑"]="10.";e["⒒"]="11.";e["⒓"]="12.";e["⒔"]="13.";e["⒕"]="14.";e["⒖"]="15.";e["⒗"]="16.";e["⒘"]="17.";e["⒙"]="18.";e["⒚"]="19.";e["⒛"]="20.";e["⒜"]="(a)";e["⒝"]="(b)";e["⒞"]="(c)";e["⒟"]="(d)";e["⒠"]="(e)";e["⒡"]="(f)";e["⒢"]="(g)";e["⒣"]="(h)";e["⒤"]="(i)";e["⒥"]="(j)";e["⒦"]="(k)";e["⒧"]="(l)";e["⒨"]="(m)";e["⒩"]="(n)";e["⒪"]="(o)";e["⒫"]="(p)";e["⒬"]="(q)";e["⒭"]="(r)";e["⒮"]="(s)";e["⒯"]="(t)";e["⒰"]="(u)";e["⒱"]="(v)";e["⒲"]="(w)";e["⒳"]="(x)";e["⒴"]="(y)";e["⒵"]="(z)";e["⨌"]="∫∫∫∫";e["⩴"]="::=";e["⩵"]="==";e["⩶"]="===";e["⺟"]="母";e["⻳"]="龟";e["⼀"]="一";e["⼁"]="丨";e["⼂"]="丶";e["⼃"]="丿";e["⼄"]="乙";e["⼅"]="亅";e["⼆"]="二";e["⼇"]="亠";e["⼈"]="人";e["⼉"]="儿";e["⼊"]="入";e["⼋"]="八";e["⼌"]="冂";e["⼍"]="冖";e["⼎"]="冫";e["⼏"]="几";e["⼐"]="凵";e["⼑"]="刀";e["⼒"]="力";e["⼓"]="勹";e["⼔"]="匕";e["⼕"]="匚";e["⼖"]="匸";e["⼗"]="十";e["⼘"]="卜";e["⼙"]="卩";e["⼚"]="厂";e["⼛"]="厶";e["⼜"]="又";e["⼝"]="口";e["⼞"]="囗";e["⼟"]="土";e["⼠"]="士";e["⼡"]="夂";e["⼢"]="夊";e["⼣"]="夕";e["⼤"]="大";e["⼥"]="女";e["⼦"]="子";e["⼧"]="宀";e["⼨"]="寸";e["⼩"]="小";e["⼪"]="尢";e["⼫"]="尸";e["⼬"]="屮";e["⼭"]="山";e["⼮"]="巛";e["⼯"]="工";e["⼰"]="己";e["⼱"]="巾";e["⼲"]="干";e["⼳"]="幺";e["⼴"]="广";e["⼵"]="廴";e["⼶"]="廾";e["⼷"]="弋";e["⼸"]="弓";e["⼹"]="彐";e["⼺"]="彡";e["⼻"]="彳";e["⼼"]="心";e["⼽"]="戈";e["⼾"]="戶";e["⼿"]="手";e["⽀"]="支";e["⽁"]="攴";e["⽂"]="文";e["⽃"]="斗";e["⽄"]="斤";e["⽅"]="方";e["⽆"]="无";e["⽇"]="日";e["⽈"]="曰";e["⽉"]="月";e["⽊"]="木";e["⽋"]="欠";e["⽌"]="止";e["⽍"]="歹";e["⽎"]="殳";e["⽏"]="毋";e["⽐"]="比";e["⽑"]="毛";e["⽒"]="氏";e["⽓"]="气";e["⽔"]="水";e["⽕"]="火";e["⽖"]="爪";e["⽗"]="父";e["⽘"]="爻";e["⽙"]="爿";e["⽚"]="片";e["⽛"]="牙";e["⽜"]="牛";e["⽝"]="犬";e["⽞"]="玄";e["⽟"]="玉";e["⽠"]="瓜";e["⽡"]="瓦";e["⽢"]="甘";e["⽣"]="生";e["⽤"]="用";e["⽥"]="田";e["⽦"]="疋";e["⽧"]="疒";e["⽨"]="癶";e["⽩"]="白";e["⽪"]="皮";e["⽫"]="皿";e["⽬"]="目";e["⽭"]="矛";e["⽮"]="矢";e["⽯"]="石";e["⽰"]="示";e["⽱"]="禸";e["⽲"]="禾";e["⽳"]="穴";e["⽴"]="立";e["⽵"]="竹";e["⽶"]="米";e["⽷"]="糸";e["⽸"]="缶";e["⽹"]="网";e["⽺"]="羊";e["⽻"]="羽";e["⽼"]="老";e["⽽"]="而";e["⽾"]="耒";e["⽿"]="耳";e["⾀"]="聿";e["⾁"]="肉";e["⾂"]="臣";e["⾃"]="自";e["⾄"]="至";e["⾅"]="臼";e["⾆"]="舌";e["⾇"]="舛";e["⾈"]="舟";e["⾉"]="艮";e["⾊"]="色";e["⾋"]="艸";e["⾌"]="虍";e["⾍"]="虫";e["⾎"]="血";e["⾏"]="行";e["⾐"]="衣";e["⾑"]="襾";e["⾒"]="見";e["⾓"]="角";e["⾔"]="言";e["⾕"]="谷";e["⾖"]="豆";e["⾗"]="豕";e["⾘"]="豸";e["⾙"]="貝";e["⾚"]="赤";e["⾛"]="走";e["⾜"]="足";e["⾝"]="身";e["⾞"]="車";e["⾟"]="辛";e["⾠"]="辰";e["⾡"]="辵";e["⾢"]="邑";e["⾣"]="酉";e["⾤"]="釆";e["⾥"]="里";e["⾦"]="金";e["⾧"]="長";e["⾨"]="門";e["⾩"]="阜";e["⾪"]="隶";e["⾫"]="隹";e["⾬"]="雨";e["⾭"]="靑";e["⾮"]="非";e["⾯"]="面";e["⾰"]="革";e["⾱"]="韋";e["⾲"]="韭";e["⾳"]="音";e["⾴"]="頁";e["⾵"]="風";e["⾶"]="飛";e["⾷"]="食";e["⾸"]="首";e["⾹"]="香";e["⾺"]="馬";e["⾻"]="骨";e["⾼"]="高";e["⾽"]="髟";e["⾾"]="鬥";e["⾿"]="鬯";e["⿀"]="鬲";e["⿁"]="鬼";e["⿂"]="魚";e["⿃"]="鳥";e["⿄"]="鹵";e["⿅"]="鹿";e["⿆"]="麥";e["⿇"]="麻";e["⿈"]="黃";e["⿉"]="黍";e["⿊"]="黑";e["⿋"]="黹";e["⿌"]="黽";e["⿍"]="鼎";e["⿎"]="鼓";e["⿏"]="鼠";e["⿐"]="鼻";e["⿑"]="齊";e["⿒"]="齒";e["⿓"]="龍";e["⿔"]="龜";e["⿕"]="龠";e["〶"]="〒";e["〸"]="十";e["〹"]="卄";e["〺"]="卅";e["゛"]=" ゙";e["゜"]=" ゚";e["ㄱ"]="ᄀ";e["ㄲ"]="ᄁ";e["ㄳ"]="ᆪ";e["ㄴ"]="ᄂ";e["ㄵ"]="ᆬ";e["ㄶ"]="ᆭ";e["ㄷ"]="ᄃ";e["ㄸ"]="ᄄ";e["ㄹ"]="ᄅ";e["ㄺ"]="ᆰ";e["ㄻ"]="ᆱ";e["ㄼ"]="ᆲ";e["ㄽ"]="ᆳ";e["ㄾ"]="ᆴ";e["ㄿ"]="ᆵ";e["ㅀ"]="ᄚ";e["ㅁ"]="ᄆ";e["ㅂ"]="ᄇ";e["ㅃ"]="ᄈ";e["ㅄ"]="ᄡ";e["ㅅ"]="ᄉ";e["ㅆ"]="ᄊ";e["ㅇ"]="ᄋ";e["ㅈ"]="ᄌ";e["ㅉ"]="ᄍ";e["ㅊ"]="ᄎ";e["ㅋ"]="ᄏ";e["ㅌ"]="ᄐ";e["ㅍ"]="ᄑ";e["ㅎ"]="ᄒ";e["ㅏ"]="ᅡ";e["ㅐ"]="ᅢ";e["ㅑ"]="ᅣ";e["ㅒ"]="ᅤ";e["ㅓ"]="ᅥ";e["ㅔ"]="ᅦ";e["ㅕ"]="ᅧ";e["ㅖ"]="ᅨ";e["ㅗ"]="ᅩ";e["ㅘ"]="ᅪ";e["ㅙ"]="ᅫ";e["ㅚ"]="ᅬ";e["ㅛ"]="ᅭ";e["ㅜ"]="ᅮ";e["ㅝ"]="ᅯ";e["ㅞ"]="ᅰ";e["ㅟ"]="ᅱ";e["ㅠ"]="ᅲ";e["ㅡ"]="ᅳ";e["ㅢ"]="ᅴ";e["ㅣ"]="ᅵ";e["ㅤ"]="ᅠ";e["ㅥ"]="ᄔ";e["ㅦ"]="ᄕ";e["ㅧ"]="ᇇ";e["ㅨ"]="ᇈ";e["ㅩ"]="ᇌ";e["ㅪ"]="ᇎ";e["ㅫ"]="ᇓ";e["ㅬ"]="ᇗ";e["ㅭ"]="ᇙ";e["ㅮ"]="ᄜ";e["ㅯ"]="ᇝ";e["ㅰ"]="ᇟ";e["ㅱ"]="ᄝ";e["ㅲ"]="ᄞ";e["ㅳ"]="ᄠ";e["ㅴ"]="ᄢ";e["ㅵ"]="ᄣ";e["ㅶ"]="ᄧ";e["ㅷ"]="ᄩ";e["ㅸ"]="ᄫ";e["ㅹ"]="ᄬ";e["ㅺ"]="ᄭ";e["ㅻ"]="ᄮ";e["ㅼ"]="ᄯ";e["ㅽ"]="ᄲ";e["ㅾ"]="ᄶ";e["ㅿ"]="ᅀ";e["ㆀ"]="ᅇ";e["ㆁ"]="ᅌ";e["ㆂ"]="ᇱ";e["ㆃ"]="ᇲ";e["ㆄ"]="ᅗ";e["ㆅ"]="ᅘ";e["ㆆ"]="ᅙ";e["ㆇ"]="ᆄ";e["ㆈ"]="ᆅ";e["ㆉ"]="ᆈ";e["ㆊ"]="ᆑ";e["ㆋ"]="ᆒ";e["ㆌ"]="ᆔ";e["ㆍ"]="ᆞ";e["ㆎ"]="ᆡ";e["㈀"]="(ᄀ)";e["㈁"]="(ᄂ)";e["㈂"]="(ᄃ)";e["㈃"]="(ᄅ)";e["㈄"]="(ᄆ)";e["㈅"]="(ᄇ)";e["㈆"]="(ᄉ)";e["㈇"]="(ᄋ)";e["㈈"]="(ᄌ)";e["㈉"]="(ᄎ)";e["㈊"]="(ᄏ)";e["㈋"]="(ᄐ)";e["㈌"]="(ᄑ)";e["㈍"]="(ᄒ)";e["㈎"]="(가)";e["㈏"]="(나)";e["㈐"]="(다)";e["㈑"]="(라)";e["㈒"]="(마)";e["㈓"]="(바)";e["㈔"]="(사)";e["㈕"]="(아)";e["㈖"]="(자)";e["㈗"]="(차)";e["㈘"]="(카)";e["㈙"]="(타)";e["㈚"]="(파)";e["㈛"]="(하)";e["㈜"]="(주)";e["㈝"]="(오전)";e["㈞"]="(오후)";e["㈠"]="(一)";e["㈡"]="(二)";e["㈢"]="(三)";e["㈣"]="(四)";e["㈤"]="(五)";e["㈥"]="(六)";e["㈦"]="(七)";e["㈧"]="(八)";e["㈨"]="(九)";e["㈩"]="(十)";e["㈪"]="(月)";e["㈫"]="(火)";e["㈬"]="(水)";e["㈭"]="(木)";e["㈮"]="(金)";e["㈯"]="(土)";e["㈰"]="(日)";e["㈱"]="(株)";e["㈲"]="(有)";e["㈳"]="(社)";e["㈴"]="(名)";e["㈵"]="(特)";e["㈶"]="(財)";e["㈷"]="(祝)";e["㈸"]="(労)";e["㈹"]="(代)";e["㈺"]="(呼)";e["㈻"]="(学)";e["㈼"]="(監)";e["㈽"]="(企)";e["㈾"]="(資)";e["㈿"]="(協)";e["㉀"]="(祭)";e["㉁"]="(休)";e["㉂"]="(自)";e["㉃"]="(至)";e["㋀"]="1月";e["㋁"]="2月";e["㋂"]="3月";e["㋃"]="4月";e["㋄"]="5月";e["㋅"]="6月";e["㋆"]="7月";e["㋇"]="8月";e["㋈"]="9月";e["㋉"]="10月";e["㋊"]="11月";e["㋋"]="12月";e["㍘"]="0点";e["㍙"]="1点";e["㍚"]="2点";e["㍛"]="3点";e["㍜"]="4点";e["㍝"]="5点";e["㍞"]="6点";e["㍟"]="7点";e["㍠"]="8点";e["㍡"]="9点";e["㍢"]="10点";e["㍣"]="11点";e["㍤"]="12点";e["㍥"]="13点";e["㍦"]="14点";e["㍧"]="15点";e["㍨"]="16点";e["㍩"]="17点";e["㍪"]="18点";e["㍫"]="19点";e["㍬"]="20点";e["㍭"]="21点";e["㍮"]="22点";e["㍯"]="23点";e["㍰"]="24点";e["㏠"]="1日";e["㏡"]="2日";e["㏢"]="3日";e["㏣"]="4日";e["㏤"]="5日";e["㏥"]="6日";e["㏦"]="7日";e["㏧"]="8日";e["㏨"]="9日";e["㏩"]="10日";e["㏪"]="11日";e["㏫"]="12日";e["㏬"]="13日";e["㏭"]="14日";e["㏮"]="15日";e["㏯"]="16日";e["㏰"]="17日";e["㏱"]="18日";e["㏲"]="19日";e["㏳"]="20日";e["㏴"]="21日";e["㏵"]="22日";e["㏶"]="23日";e["㏷"]="24日";e["㏸"]="25日";e["㏹"]="26日";e["㏺"]="27日";e["㏻"]="28日";e["㏼"]="29日";e["㏽"]="30日";e["㏾"]="31日";e["ﬀ"]="ff";e["ﬁ"]="fi";e["ﬂ"]="fl";e["ﬃ"]="ffi";e["ﬄ"]="ffl";e["ﬅ"]="ſt";e["ﬆ"]="st";e["ﬓ"]="մն";e["ﬔ"]="մե";e["ﬕ"]="մի";e["ﬖ"]="վն";e["ﬗ"]="մխ";e["ﭏ"]="אל";e["ﭐ"]="ٱ";e["ﭑ"]="ٱ";e["ﭒ"]="ٻ";e["ﭓ"]="ٻ";e["ﭔ"]="ٻ";e["ﭕ"]="ٻ";e["ﭖ"]="پ";e["ﭗ"]="پ";e["ﭘ"]="پ";e["ﭙ"]="پ";e["ﭚ"]="ڀ";e["ﭛ"]="ڀ";e["ﭜ"]="ڀ";e["ﭝ"]="ڀ";e["ﭞ"]="ٺ";e["ﭟ"]="ٺ";e["ﭠ"]="ٺ";e["ﭡ"]="ٺ";e["ﭢ"]="ٿ";e["ﭣ"]="ٿ";e["ﭤ"]="ٿ";e["ﭥ"]="ٿ";e["ﭦ"]="ٹ";e["ﭧ"]="ٹ";e["ﭨ"]="ٹ";e["ﭩ"]="ٹ";e["ﭪ"]="ڤ";e["ﭫ"]="ڤ";e["ﭬ"]="ڤ";e["ﭭ"]="ڤ";e["ﭮ"]="ڦ";e["ﭯ"]="ڦ";e["ﭰ"]="ڦ";e["ﭱ"]="ڦ";e["ﭲ"]="ڄ";e["ﭳ"]="ڄ";e["ﭴ"]="ڄ";e["ﭵ"]="ڄ";e["ﭶ"]="ڃ";e["ﭷ"]="ڃ";e["ﭸ"]="ڃ";e["ﭹ"]="ڃ";e["ﭺ"]="چ";e["ﭻ"]="چ";e["ﭼ"]="چ";e["ﭽ"]="چ";e["ﭾ"]="ڇ";e["ﭿ"]="ڇ";e["ﮀ"]="ڇ";e["ﮁ"]="ڇ";e["ﮂ"]="ڍ";e["ﮃ"]="ڍ";e["ﮄ"]="ڌ";e["ﮅ"]="ڌ";e["ﮆ"]="ڎ";e["ﮇ"]="ڎ";e["ﮈ"]="ڈ";e["ﮉ"]="ڈ";e["ﮊ"]="ژ";e["ﮋ"]="ژ";e["ﮌ"]="ڑ";e["ﮍ"]="ڑ";e["ﮎ"]="ک";e["ﮏ"]="ک";e["ﮐ"]="ک";e["ﮑ"]="ک";e["ﮒ"]="گ";e["ﮓ"]="گ";e["ﮔ"]="گ";e["ﮕ"]="گ";e["ﮖ"]="ڳ";e["ﮗ"]="ڳ";e["ﮘ"]="ڳ";e["ﮙ"]="ڳ";e["ﮚ"]="ڱ";e["ﮛ"]="ڱ";e["ﮜ"]="ڱ";e["ﮝ"]="ڱ";e["ﮞ"]="ں";e["ﮟ"]="ں";e["ﮠ"]="ڻ";e["ﮡ"]="ڻ";e["ﮢ"]="ڻ";e["ﮣ"]="ڻ";e["ﮤ"]="ۀ";e["ﮥ"]="ۀ";e["ﮦ"]="ہ";e["ﮧ"]="ہ";e["ﮨ"]="ہ";e["ﮩ"]="ہ";e["ﮪ"]="ھ";e["ﮫ"]="ھ";e["ﮬ"]="ھ";e["ﮭ"]="ھ";e["ﮮ"]="ے";e["ﮯ"]="ے";e["ﮰ"]="ۓ";e["ﮱ"]="ۓ";e["ﯓ"]="ڭ";e["ﯔ"]="ڭ";e["ﯕ"]="ڭ";e["ﯖ"]="ڭ";e["ﯗ"]="ۇ";e["ﯘ"]="ۇ";e["ﯙ"]="ۆ";e["ﯚ"]="ۆ";e["ﯛ"]="ۈ";e["ﯜ"]="ۈ";e["ﯝ"]="ٷ";e["ﯞ"]="ۋ";e["ﯟ"]="ۋ";e["ﯠ"]="ۅ";e["ﯡ"]="ۅ";e["ﯢ"]="ۉ";e["ﯣ"]="ۉ";e["ﯤ"]="ې";e["ﯥ"]="ې";e["ﯦ"]="ې";e["ﯧ"]="ې";e["ﯨ"]="ى";e["ﯩ"]="ى";e["ﯪ"]="ئا";e["ﯫ"]="ئا";e["ﯬ"]="ئە";e["ﯭ"]="ئە";e["ﯮ"]="ئو";e["ﯯ"]="ئو";e["ﯰ"]="ئۇ";e["ﯱ"]="ئۇ";e["ﯲ"]="ئۆ";e["ﯳ"]="ئۆ";e["ﯴ"]="ئۈ";e["ﯵ"]="ئۈ";e["ﯶ"]="ئې";e["ﯷ"]="ئې";e["ﯸ"]="ئې";e["ﯹ"]="ئى";e["ﯺ"]="ئى";e["ﯻ"]="ئى";e["ﯼ"]="ی";e["ﯽ"]="ی";e["ﯾ"]="ی";e["ﯿ"]="ی";e["ﰀ"]="ئج";e["ﰁ"]="ئح";e["ﰂ"]="ئم";e["ﰃ"]="ئى";e["ﰄ"]="ئي";e["ﰅ"]="بج";e["ﰆ"]="بح";e["ﰇ"]="بخ";e["ﰈ"]="بم";e["ﰉ"]="بى";e["ﰊ"]="بي";e["ﰋ"]="تج";e["ﰌ"]="تح";e["ﰍ"]="تخ";e["ﰎ"]="تم";e["ﰏ"]="تى";e["ﰐ"]="تي";e["ﰑ"]="ثج";e["ﰒ"]="ثم";e["ﰓ"]="ثى";e["ﰔ"]="ثي";e["ﰕ"]="جح";e["ﰖ"]="جم";e["ﰗ"]="حج";e["ﰘ"]="حم";e["ﰙ"]="خج";e["ﰚ"]="خح";e["ﰛ"]="خم";e["ﰜ"]="سج";e["ﰝ"]="سح";e["ﰞ"]="سخ";e["ﰟ"]="سم";e["ﰠ"]="صح";e["ﰡ"]="صم";e["ﰢ"]="ضج";e["ﰣ"]="ضح";e["ﰤ"]="ضخ";e["ﰥ"]="ضم";e["ﰦ"]="طح";e["ﰧ"]="طم";e["ﰨ"]="ظم";e["ﰩ"]="عج";e["ﰪ"]="عم";e["ﰫ"]="غج";e["ﰬ"]="غم";e["ﰭ"]="فج";e["ﰮ"]="فح";e["ﰯ"]="فخ";e["ﰰ"]="فم";e["ﰱ"]="فى";e["ﰲ"]="في";e["ﰳ"]="قح";e["ﰴ"]="قم";e["ﰵ"]="قى";e["ﰶ"]="قي";e["ﰷ"]="كا";e["ﰸ"]="كج";e["ﰹ"]="كح";e["ﰺ"]="كخ";e["ﰻ"]="كل";e["ﰼ"]="كم";e["ﰽ"]="كى";e["ﰾ"]="كي";e["ﰿ"]="لج";e["ﱀ"]="لح";e["ﱁ"]="لخ";e["ﱂ"]="لم";e["ﱃ"]="لى";e["ﱄ"]="لي";e["ﱅ"]="مج";e["ﱆ"]="مح";e["ﱇ"]="مخ";e["ﱈ"]="مم";e["ﱉ"]="مى";e["ﱊ"]="مي";e["ﱋ"]="نج";e["ﱌ"]="نح";e["ﱍ"]="نخ";e["ﱎ"]="نم";e["ﱏ"]="نى";e["ﱐ"]="ني";e["ﱑ"]="هج";e["ﱒ"]="هم";e["ﱓ"]="هى";e["ﱔ"]="هي";e["ﱕ"]="يج";e["ﱖ"]="يح";e["ﱗ"]="يخ";e["ﱘ"]="يم";e["ﱙ"]="يى";e["ﱚ"]="يي";e["ﱛ"]="ذٰ";e["ﱜ"]="رٰ";e["ﱝ"]="ىٰ";e["ﱞ"]=" ٌّ";e["ﱟ"]=" ٍّ";e["ﱠ"]=" َّ";e["ﱡ"]=" ُّ";e["ﱢ"]=" ِّ";e["ﱣ"]=" ّٰ";e["ﱤ"]="ئر";e["ﱥ"]="ئز";e["ﱦ"]="ئم";e["ﱧ"]="ئن";e["ﱨ"]="ئى";e["ﱩ"]="ئي";e["ﱪ"]="بر";e["ﱫ"]="بز";e["ﱬ"]="بم";e["ﱭ"]="بن";e["ﱮ"]="بى";e["ﱯ"]="بي";e["ﱰ"]="تر";e["ﱱ"]="تز";e["ﱲ"]="تم";e["ﱳ"]="تن";e["ﱴ"]="تى";e["ﱵ"]="تي";e["ﱶ"]="ثر";e["ﱷ"]="ثز";e["ﱸ"]="ثم";e["ﱹ"]="ثن";e["ﱺ"]="ثى";e["ﱻ"]="ثي";e["ﱼ"]="فى";e["ﱽ"]="في";e["ﱾ"]="قى";e["ﱿ"]="قي";e["ﲀ"]="كا";e["ﲁ"]="كل";e["ﲂ"]="كم";e["ﲃ"]="كى";e["ﲄ"]="كي";e["ﲅ"]="لم";e["ﲆ"]="لى";e["ﲇ"]="لي";e["ﲈ"]="ما";e["ﲉ"]="مم";e["ﲊ"]="نر";e["ﲋ"]="نز";e["ﲌ"]="نم";e["ﲍ"]="نن";e["ﲎ"]="نى";e["ﲏ"]="ني";e["ﲐ"]="ىٰ";e["ﲑ"]="ير";e["ﲒ"]="يز";e["ﲓ"]="يم";e["ﲔ"]="ين";e["ﲕ"]="يى";e["ﲖ"]="يي";e["ﲗ"]="ئج";e["ﲘ"]="ئح";e["ﲙ"]="ئخ";e["ﲚ"]="ئم";e["ﲛ"]="ئه";e["ﲜ"]="بج";e["ﲝ"]="بح";e["ﲞ"]="بخ";e["ﲟ"]="بم";e["ﲠ"]="به";e["ﲡ"]="تج";e["ﲢ"]="تح";e["ﲣ"]="تخ";e["ﲤ"]="تم";e["ﲥ"]="ته";e["ﲦ"]="ثم";e["ﲧ"]="جح";e["ﲨ"]="جم";e["ﲩ"]="حج";e["ﲪ"]="حم";e["ﲫ"]="خج";e["ﲬ"]="خم";e["ﲭ"]="سج";e["ﲮ"]="سح";e["ﲯ"]="سخ";e["ﲰ"]="سم";e["ﲱ"]="صح";e["ﲲ"]="صخ";e["ﲳ"]="صم";e["ﲴ"]="ضج";e["ﲵ"]="ضح";e["ﲶ"]="ضخ";e["ﲷ"]="ضم";e["ﲸ"]="طح";e["ﲹ"]="ظم";e["ﲺ"]="عج";e["ﲻ"]="عم";e["ﲼ"]="غج";e["ﲽ"]="غم";e["ﲾ"]="فج";e["ﲿ"]="فح";e["ﳀ"]="فخ";e["ﳁ"]="فم";e["ﳂ"]="قح";e["ﳃ"]="قم";e["ﳄ"]="كج";e["ﳅ"]="كح";e["ﳆ"]="كخ";e["ﳇ"]="كل";e["ﳈ"]="كم";e["ﳉ"]="لج";e["ﳊ"]="لح";e["ﳋ"]="لخ";e["ﳌ"]="لم";e["ﳍ"]="له";e["ﳎ"]="مج";e["ﳏ"]="مح";e["ﳐ"]="مخ";e["ﳑ"]="مم";e["ﳒ"]="نج";e["ﳓ"]="نح";e["ﳔ"]="نخ";e["ﳕ"]="نم";e["ﳖ"]="نه";e["ﳗ"]="هج";e["ﳘ"]="هم";e["ﳙ"]="هٰ";e["ﳚ"]="يج";e["ﳛ"]="يح";e["ﳜ"]="يخ";e["ﳝ"]="يم";e["ﳞ"]="يه";e["ﳟ"]="ئم";e["ﳠ"]="ئه";e["ﳡ"]="بم";e["ﳢ"]="به";e["ﳣ"]="تم";e["ﳤ"]="ته";e["ﳥ"]="ثم";e["ﳦ"]="ثه";e["ﳧ"]="سم";e["ﳨ"]="سه";e["ﳩ"]="شم";e["ﳪ"]="شه";e["ﳫ"]="كل";e["ﳬ"]="كم";e["ﳭ"]="لم";e["ﳮ"]="نم";e["ﳯ"]="نه";e["ﳰ"]="يم";e["ﳱ"]="يه";e["ﳲ"]="ـَّ";e["ﳳ"]="ـُّ";e["ﳴ"]="ـِّ";e["ﳵ"]="طى";e["ﳶ"]="طي";e["ﳷ"]="عى";e["ﳸ"]="عي";e["ﳹ"]="غى";e["ﳺ"]="غي";e["ﳻ"]="سى";e["ﳼ"]="سي";e["ﳽ"]="شى";e["ﳾ"]="شي";e["ﳿ"]="حى";e["ﴀ"]="حي";e["ﴁ"]="جى";e["ﴂ"]="جي";e["ﴃ"]="خى";e["ﴄ"]="خي";e["ﴅ"]="صى";e["ﴆ"]="صي";e["ﴇ"]="ضى";e["ﴈ"]="ضي";e["ﴉ"]="شج";e["ﴊ"]="شح";e["ﴋ"]="شخ";e["ﴌ"]="شم";e["ﴍ"]="شر";e["ﴎ"]="سر";e["ﴏ"]="صر";e["ﴐ"]="ضر";e["ﴑ"]="طى";e["ﴒ"]="طي";e["ﴓ"]="عى";e["ﴔ"]="عي";e["ﴕ"]="غى";e["ﴖ"]="غي";e["ﴗ"]="سى";e["ﴘ"]="سي";e["ﴙ"]="شى";e["ﴚ"]="شي";e["ﴛ"]="حى";e["ﴜ"]="حي";e["ﴝ"]="جى";e["ﴞ"]="جي";e["ﴟ"]="خى";e["ﴠ"]="خي";e["ﴡ"]="صى";e["ﴢ"]="صي";e["ﴣ"]="ضى";e["ﴤ"]="ضي";e["ﴥ"]="شج";e["ﴦ"]="شح";e["ﴧ"]="شخ";e["ﴨ"]="شم";e["ﴩ"]="شر";e["ﴪ"]="سر";e["ﴫ"]="صر";e["ﴬ"]="ضر";e["ﴭ"]="شج";e["ﴮ"]="شح";e["ﴯ"]="شخ";e["ﴰ"]="شم";e["ﴱ"]="سه";e["ﴲ"]="شه";e["ﴳ"]="طم";e["ﴴ"]="سج";e["ﴵ"]="سح";e["ﴶ"]="سخ";e["ﴷ"]="شج";e["ﴸ"]="شح";e["ﴹ"]="شخ";e["ﴺ"]="طم";e["ﴻ"]="ظم";e["ﴼ"]="اً";e["ﴽ"]="اً";e["ﵐ"]="تجم";e["ﵑ"]="تحج";e["ﵒ"]="تحج";e["ﵓ"]="تحم";e["ﵔ"]="تخم";e["ﵕ"]="تمج";e["ﵖ"]="تمح";e["ﵗ"]="تمخ";e["ﵘ"]="جمح";e["ﵙ"]="جمح";e["ﵚ"]="حمي";e["ﵛ"]="حمى";e["ﵜ"]="سحج";e["ﵝ"]="سجح";e["ﵞ"]="سجى";e["ﵟ"]="سمح";e["ﵠ"]="سمح";e["ﵡ"]="سمج";e["ﵢ"]="سمم";e["ﵣ"]="سمم";e["ﵤ"]="صحح";e["ﵥ"]="صحح";e["ﵦ"]="صمم";e["ﵧ"]="شحم";e["ﵨ"]="شحم";e["ﵩ"]="شجي";e["ﵪ"]="شمخ";e["ﵫ"]="شمخ";e["ﵬ"]="شمم";e["ﵭ"]="شمم";e["ﵮ"]="ضحى";e["ﵯ"]="ضخم";e["ﵰ"]="ضخم";e["ﵱ"]="طمح";e["ﵲ"]="طمح";e["ﵳ"]="طمم";e["ﵴ"]="طمي";e["ﵵ"]="عجم";e["ﵶ"]="عمم";e["ﵷ"]="عمم";e["ﵸ"]="عمى";e["ﵹ"]="غمم";e["ﵺ"]="غمي";e["ﵻ"]="غمى";e["ﵼ"]="فخم";e["ﵽ"]="فخم";e["ﵾ"]="قمح";e["ﵿ"]="قمم";e["ﶀ"]="لحم";e["ﶁ"]="لحي";e["ﶂ"]="لحى";e["ﶃ"]="لجج";e["ﶄ"]="لجج";e["ﶅ"]="لخم";e["ﶆ"]="لخم";e["ﶇ"]="لمح";e["ﶈ"]="لمح";e["ﶉ"]="محج";e["ﶊ"]="محم";e["ﶋ"]="محي";e["ﶌ"]="مجح";e["ﶍ"]="مجم";e["ﶎ"]="مخج";e["ﶏ"]="مخم";e["ﶒ"]="مجخ";e["ﶓ"]="همج";e["ﶔ"]="همم";e["ﶕ"]="نحم";e["ﶖ"]="نحى";e["ﶗ"]="نجم";e["ﶘ"]="نجم";e["ﶙ"]="نجى";e["ﶚ"]="نمي";e["ﶛ"]="نمى";e["ﶜ"]="يمم";e["ﶝ"]="يمم";e["ﶞ"]="بخي";e["ﶟ"]="تجي";e["ﶠ"]="تجى";e["ﶡ"]="تخي";e["ﶢ"]="تخى";e["ﶣ"]="تمي";e["ﶤ"]="تمى";e["ﶥ"]="جمي";e["ﶦ"]="جحى";e["ﶧ"]="جمى";e["ﶨ"]="سخى";e["ﶩ"]="صحي";e["ﶪ"]="شحي";e["ﶫ"]="ضحي";e["ﶬ"]="لجي";e["ﶭ"]="لمي";e["ﶮ"]="يحي";e["ﶯ"]="يجي";e["ﶰ"]="يمي";e["ﶱ"]="ممي";e["ﶲ"]="قمي";e["ﶳ"]="نحي";e["ﶴ"]="قمح";e["ﶵ"]="لحم";e["ﶶ"]="عمي";e["ﶷ"]="كمي";e["ﶸ"]="نجح";e["ﶹ"]="مخي";e["ﶺ"]="لجم";e["ﶻ"]="كمم";e["ﶼ"]="لجم";e["ﶽ"]="نجح";e["ﶾ"]="جحي";e["ﶿ"]="حجي";e["ﷀ"]="مجي";e["ﷁ"]="فمي";e["ﷂ"]="بحي";e["ﷃ"]="كمم";e["ﷄ"]="عجم";e["ﷅ"]="صمم";e["ﷆ"]="سخي";e["ﷇ"]="نجي";e["﹉"]="‾";e["﹊"]="‾";e["﹋"]="‾";e["﹌"]="‾";e["﹍"]="_";e["﹎"]="_";e["﹏"]="_";e["ﺀ"]="ء";e["ﺁ"]="آ";e["ﺂ"]="آ";e["ﺃ"]="أ";e["ﺄ"]="أ";e["ﺅ"]="ؤ";e["ﺆ"]="ؤ";e["ﺇ"]="إ";e["ﺈ"]="إ";e["ﺉ"]="ئ";e["ﺊ"]="ئ";e["ﺋ"]="ئ";e["ﺌ"]="ئ";e["ﺍ"]="ا";e["ﺎ"]="ا";e["ﺏ"]="ب";e["ﺐ"]="ب";e["ﺑ"]="ب";e["ﺒ"]="ب";e["ﺓ"]="ة";e["ﺔ"]="ة";e["ﺕ"]="ت";e["ﺖ"]="ت";e["ﺗ"]="ت";e["ﺘ"]="ت";e["ﺙ"]="ث";e["ﺚ"]="ث";e["ﺛ"]="ث";e["ﺜ"]="ث";e["ﺝ"]="ج";e["ﺞ"]="ج";e["ﺟ"]="ج";e["ﺠ"]="ج";e["ﺡ"]="ح";e["ﺢ"]="ح";e["ﺣ"]="ح";e["ﺤ"]="ح";e["ﺥ"]="خ";e["ﺦ"]="خ";e["ﺧ"]="خ";e["ﺨ"]="خ";e["ﺩ"]="د";e["ﺪ"]="د";e["ﺫ"]="ذ";e["ﺬ"]="ذ";e["ﺭ"]="ر";e["ﺮ"]="ر";e["ﺯ"]="ز";e["ﺰ"]="ز";e["ﺱ"]="س";e["ﺲ"]="س";e["ﺳ"]="س";e["ﺴ"]="س";e["ﺵ"]="ش";e["ﺶ"]="ش";e["ﺷ"]="ش";e["ﺸ"]="ش";e["ﺹ"]="ص";e["ﺺ"]="ص";e["ﺻ"]="ص";e["ﺼ"]="ص";e["ﺽ"]="ض";e["ﺾ"]="ض";e["ﺿ"]="ض";e["ﻀ"]="ض";e["ﻁ"]="ط";e["ﻂ"]="ط";e["ﻃ"]="ط";e["ﻄ"]="ط";e["ﻅ"]="ظ";e["ﻆ"]="ظ";e["ﻇ"]="ظ";e["ﻈ"]="ظ";e["ﻉ"]="ع";e["ﻊ"]="ع";e["ﻋ"]="ع";e["ﻌ"]="ع";e["ﻍ"]="غ";e["ﻎ"]="غ";e["ﻏ"]="غ";e["ﻐ"]="غ";e["ﻑ"]="ف";e["ﻒ"]="ف";e["ﻓ"]="ف";e["ﻔ"]="ف";e["ﻕ"]="ق";e["ﻖ"]="ق";e["ﻗ"]="ق";e["ﻘ"]="ق";e["ﻙ"]="ك";e["ﻚ"]="ك";e["ﻛ"]="ك";e["ﻜ"]="ك";e["ﻝ"]="ل";e["ﻞ"]="ل";e["ﻟ"]="ل";e["ﻠ"]="ل";e["ﻡ"]="م";e["ﻢ"]="م";e["ﻣ"]="م";e["ﻤ"]="م";e["ﻥ"]="ن";e["ﻦ"]="ن";e["ﻧ"]="ن";e["ﻨ"]="ن";e["ﻩ"]="ه";e["ﻪ"]="ه";e["ﻫ"]="ه";e["ﻬ"]="ه";e["ﻭ"]="و";e["ﻮ"]="و";e["ﻯ"]="ى";e["ﻰ"]="ى";e["ﻱ"]="ي";e["ﻲ"]="ي";e["ﻳ"]="ي";e["ﻴ"]="ي";e["ﻵ"]="لآ";e["ﻶ"]="لآ";e["ﻷ"]="لأ";e["ﻸ"]="لأ";e["ﻹ"]="لإ";e["ﻺ"]="لإ";e["ﻻ"]="لا";e["ﻼ"]="لا"}));t.mapSpecialUnicodeValues=function(e){return e>=65520&&e<=65535?0:e>=62976&&e<=63743?i()[e]||e:173===e?45:e};t.reverseIfRtl=function(e){var t,a,r=e.length;if(r<=1||!(t=e.charCodeAt(0),a=n[13],t>=a.begin&&t<a.end||t>=(a=n[11]).begin&&t<a.end))return e;for(var i="",s=r-1;s>=0;s--)i+=e[s];return i};t.getUnicodeRangeFor=function(e){for(var t=0,a=n.length;t<a;t++){var r=n[t];if(e>=r.begin&&e<r.end)return t}return-1};t.getNormalizedUnicodes=s;t.getUnicodeForGlyph=function(e,t){var a=t[e];if(void 0!==a)return a;if(!e)return-1;if("u"===e[0]){var r,i=e.length;if(7===i&&"n"===e[1]&&"i"===e[2])r=e.substring(3);else{if(!(i>=5&&i<=7))return-1;r=e.substring(1)}if(r===r.toUpperCase()&&(a=parseInt(r,16))>=0)return a}return-1}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.FontRendererFactory=void 0;var r=a(2),i=a(28),n=a(31),s=a(30),o=a(11),c=function(){function e(e,t){return e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3]}function t(e,t){return e[t]<<8|e[t+1]}function a(e){const t=e.length;let a=32768;t<1240?a=107:t<33900&&(a=1131);return a}function c(a,i,n){var s,o,c,l=1===t(a,i+2)?e(a,i+8):e(a,i+16),h=t(a,i+l);if(4===h){t(a,i+l+2);var u=t(a,i+l+6)>>1;o=i+l+14;s=[];for(c=0;c<u;c++,o+=2)s[c]={end:t(a,o)};o+=2;for(c=0;c<u;c++,o+=2)s[c].start=t(a,o);for(c=0;c<u;c++,o+=2)s[c].idDelta=t(a,o);for(c=0;c<u;c++,o+=2){var d=t(a,o);if(0!==d){s[c].ids=[];for(var f=0,g=s[c].end-s[c].start+1;f<g;f++){s[c].ids[f]=t(a,o+d);d+=2}}}return s}if(12===h){e(a,i+l+4);var m=e(a,i+l+12);o=i+l+16;s=[];for(c=0;c<m;c++){s.push({start:e(a,o),end:e(a,o+4),idDelta:e(a,o+8)-e(a,o)});o+=12}return s}throw new r.FormatError(`unsupported cmap: ${h}`)}function l(e,t,a,r){var n=new i.CFFParser(new o.Stream(e,t,a-t),{},r).parse();return{glyphs:n.charStrings.objects,subrs:n.topDict.privateDict&&n.topDict.privateDict.subrsIndex&&n.topDict.privateDict.subrsIndex.objects,gsubrs:n.globalSubrIndex&&n.globalSubrIndex.objects,isCFFCIDFont:n.isCIDFont,fdSelect:n.fdSelect,fdArray:n.fdArray}}function h(e,t){for(var a=t.codePointAt(0),r=0,i=0,n=e.length-1;i<n;){var s=i+n+1>>1;a<e[s].start?n=s-1:i=s}e[i].start<=a&&a<=e[i].end&&(r=e[i].idDelta+(e[i].ids?e[i].ids[a-e[i].start]:a)&65535);return{charCode:a,glyphId:r}}const u=[];class d{constructor(e){this.constructor===d&&(0,r.unreachable)("Cannot initialize CompiledFont.");this.fontMatrix=e;this.compiledGlyphs=Object.create(null);this.compiledCharCodeToGlyphId=Object.create(null)}getPathJs(e){const t=h(this.cmap,e);let a=this.compiledGlyphs[t.glyphId];if(!a){a=this.compileGlyph(this.glyphs[t.glyphId],t.glyphId);this.compiledGlyphs[t.glyphId]=a}void 0===this.compiledCharCodeToGlyphId[t.charCode]&&(this.compiledCharCodeToGlyphId[t.charCode]=t.glyphId);return a}compileGlyph(e,t){if(!e||0===e.length||14===e[0])return u;let a=this.fontMatrix;if(this.isCFFCIDFont){const e=this.fdSelect.getFDIndex(t);if(e>=0&&e<this.fdArray.length){a=this.fdArray[e].getByName("FontMatrix")||r.FONT_IDENTITY_MATRIX}else(0,r.warn)("Invalid fd index for glyph index.")}const i=[];i.push({cmd:"save"});i.push({cmd:"transform",args:a.slice()});i.push({cmd:"scale",args:["size","-size"]});this.compileGlyphImpl(e,i,t);i.push({cmd:"restore"});return i}compileGlyphImpl(){(0,r.unreachable)("Children classes should implement this.")}hasBuiltPath(e){const t=h(this.cmap,e);return void 0!==this.compiledGlyphs[t.glyphId]&&void 0!==this.compiledCharCodeToGlyphId[t.charCode]}}class f extends d{constructor(e,t,a){super(a||[488e-6,0,0,488e-6,0,0]);this.glyphs=e;this.cmap=t}compileGlyphImpl(e,t){!function e(t,a,r){function i(e,t){a.push({cmd:"moveTo",args:[e,t]})}function n(e,t){a.push({cmd:"lineTo",args:[e,t]})}function s(e,t,r,i){a.push({cmd:"quadraticCurveTo",args:[e,t,r,i]})}var o,c=0,l=(t[c]<<24|t[c+1]<<16)>>16,h=0,u=0;c+=10;if(l<0)do{o=t[c]<<8|t[c+1];var d,f,g=t[c+2]<<8|t[c+3];c+=4;if(1&o){d=(t[c]<<24|t[c+1]<<16)>>16;f=(t[c+2]<<24|t[c+3]<<16)>>16;c+=4}else{d=t[c++];f=t[c++]}if(2&o){h=d;u=f}else{h=0;u=0}var m=1,p=1,b=0,y=0;if(8&o){m=p=(t[c]<<24|t[c+1]<<16)/1073741824;c+=2}else if(64&o){m=(t[c]<<24|t[c+1]<<16)/1073741824;p=(t[c+2]<<24|t[c+3]<<16)/1073741824;c+=4}else if(128&o){m=(t[c]<<24|t[c+1]<<16)/1073741824;b=(t[c+2]<<24|t[c+3]<<16)/1073741824;y=(t[c+4]<<24|t[c+5]<<16)/1073741824;p=(t[c+6]<<24|t[c+7]<<16)/1073741824;c+=8}var v=r.glyphs[g];if(v){a.push({cmd:"save"});a.push({cmd:"transform",args:[m,b,y,p,h,u]});e(v,a,r);a.push({cmd:"restore"})}}while(32&o);else{var w,k,S=[];for(w=0;w<l;w++){S.push(t[c]<<8|t[c+1]);c+=2}c+=2+(t[c]<<8|t[c+1]);for(var C=S[S.length-1]+1,x=[];x.length<C;){var A=1;8&(o=t[c++])&&(A+=t[c++]);for(;A-- >0;)x.push({flags:o})}for(w=0;w<C;w++){switch(18&x[w].flags){case 0:h+=(t[c]<<24|t[c+1]<<16)>>16;c+=2;break;case 2:h-=t[c++];break;case 18:h+=t[c++]}x[w].x=h}for(w=0;w<C;w++){switch(36&x[w].flags){case 0:u+=(t[c]<<24|t[c+1]<<16)>>16;c+=2;break;case 4:u-=t[c++];break;case 36:u+=t[c++]}x[w].y=u}var I=0;for(c=0;c<l;c++){var F=S[c],T=x.slice(I,F+1);if(1&T[0].flags)T.push(T[0]);else if(1&T[T.length-1].flags)T.unshift(T[T.length-1]);else{var E={flags:1,x:(T[0].x+T[T.length-1].x)/2,y:(T[0].y+T[T.length-1].y)/2};T.unshift(E);T.push(E)}i(T[0].x,T[0].y);for(w=1,k=T.length;w<k;w++)if(1&T[w].flags)n(T[w].x,T[w].y);else if(1&T[w+1].flags){s(T[w].x,T[w].y,T[w+1].x,T[w+1].y);w++}else s(T[w].x,T[w].y,(T[w].x+T[w+1].x)/2,(T[w].y+T[w+1].y)/2);I=F+1}}}(e,t,this)}}class g extends d{constructor(e,t,r,i){super(r||[.001,0,0,.001,0,0]);this.glyphs=e.glyphs;this.gsubrs=e.gsubrs||[];this.subrs=e.subrs||[];this.cmap=t;this.glyphNameMap=i||(0,n.getGlyphsUnicode)();this.gsubrsBias=a(this.gsubrs);this.subrsBias=a(this.subrs);this.isCFFCIDFont=e.isCFFCIDFont;this.fdSelect=e.fdSelect;this.fdArray=e.fdArray}compileGlyphImpl(e,t,i){!function e(t,i,n,o){var c=[],l=0,u=0,d=0;function f(e,t){i.push({cmd:"moveTo",args:[e,t]})}function g(e,t){i.push({cmd:"lineTo",args:[e,t]})}function m(e,t,a,r,n,s){i.push({cmd:"bezierCurveTo",args:[e,t,a,r,n,s]})}!function t(p){for(var b=0;b<p.length;){var y,v,w,k,S,C,x,A,I=!1,F=p[b++];switch(F){case 1:case 3:d+=c.length>>1;I=!0;break;case 4:u+=c.pop();f(l,u);I=!0;break;case 5:for(;c.length>0;){l+=c.shift();u+=c.shift();g(l,u)}break;case 6:for(;c.length>0;){g(l+=c.shift(),u);if(0===c.length)break;u+=c.shift();g(l,u)}break;case 7:for(;c.length>0;){u+=c.shift();g(l,u);if(0===c.length)break;g(l+=c.shift(),u)}break;case 8:for(;c.length>0;){y=l+c.shift();w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v+c.shift();u=k+c.shift();m(y,w,v,k,l,u)}break;case 10:x=c.pop();A=null;if(n.isCFFCIDFont){const e=n.fdSelect.getFDIndex(o);if(e>=0&&e<n.fdArray.length){const t=n.fdArray[e];let r;t.privateDict&&t.privateDict.subrsIndex&&(r=t.privateDict.subrsIndex.objects);r&&(A=r[x+=a(r)])}else(0,r.warn)("Invalid fd index for glyph index.")}else A=n.subrs[x+n.subrsBias];A&&t(A);break;case 11:return;case 12:switch(F=p[b++]){case 34:v=(y=l+c.shift())+c.shift();S=u+c.shift();l=v+c.shift();m(y,u,v,S,l,S);v=(y=l+c.shift())+c.shift();l=v+c.shift();m(y,S,v,u,l,u);break;case 35:y=l+c.shift();w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v+c.shift();u=k+c.shift();m(y,w,v,k,l,u);y=l+c.shift();w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v+c.shift();u=k+c.shift();m(y,w,v,k,l,u);c.pop();break;case 36:m(y=l+c.shift(),S=u+c.shift(),v=y+c.shift(),C=S+c.shift(),l=v+c.shift(),C);m(y=l+c.shift(),C,v=y+c.shift(),C+c.shift(),l=v+c.shift(),u);break;case 37:var T=l,E=u;y=l+c.shift();w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v+c.shift();u=k+c.shift();m(y,w,v,k,l,u);y=l+c.shift();w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v;u=k;Math.abs(l-T)>Math.abs(u-E)?l+=c.shift():u+=c.shift();m(y,w,v,k,l,u);break;default:throw new r.FormatError(`unknown operator: 12 ${F}`)}break;case 14:if(c.length>=4){var O=c.pop(),P=c.pop();u=c.pop();l=c.pop();i.push({cmd:"save"});i.push({cmd:"translate",args:[l,u]});var B=h(n.cmap,String.fromCharCode(n.glyphNameMap[s.StandardEncoding[O]]));e(n.glyphs[B.glyphId],i,n,B.glyphId);i.push({cmd:"restore"});B=h(n.cmap,String.fromCharCode(n.glyphNameMap[s.StandardEncoding[P]]));e(n.glyphs[B.glyphId],i,n,B.glyphId)}return;case 18:d+=c.length>>1;I=!0;break;case 19:case 20:b+=(d+=c.length>>1)+7>>3;I=!0;break;case 21:u+=c.pop();f(l+=c.pop(),u);I=!0;break;case 22:f(l+=c.pop(),u);I=!0;break;case 23:d+=c.length>>1;I=!0;break;case 24:for(;c.length>2;){y=l+c.shift();w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v+c.shift();u=k+c.shift();m(y,w,v,k,l,u)}l+=c.shift();u+=c.shift();g(l,u);break;case 25:for(;c.length>6;){l+=c.shift();u+=c.shift();g(l,u)}y=l+c.shift();w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v+c.shift();u=k+c.shift();m(y,w,v,k,l,u);break;case 26:c.length%2&&(l+=c.shift());for(;c.length>0;){y=l;w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v;u=k+c.shift();m(y,w,v,k,l,u)}break;case 27:c.length%2&&(u+=c.shift());for(;c.length>0;)m(y=l+c.shift(),w=u,v=y+c.shift(),k=w+c.shift(),l=v+c.shift(),u=k);break;case 28:c.push((p[b]<<24|p[b+1]<<16)>>16);b+=2;break;case 29:x=c.pop()+n.gsubrsBias;(A=n.gsubrs[x])&&t(A);break;case 30:for(;c.length>0;){y=l;w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v+c.shift();u=k+(1===c.length?c.shift():0);m(y,w,v,k,l,u);if(0===c.length)break;y=l+c.shift();w=u;v=y+c.shift();k=w+c.shift();u=k+c.shift();m(y,w,v,k,l=v+(1===c.length?c.shift():0),u)}break;case 31:for(;c.length>0;){y=l+c.shift();w=u;v=y+c.shift();k=w+c.shift();u=k+c.shift();m(y,w,v,k,l=v+(1===c.length?c.shift():0),u);if(0===c.length)break;y=l;w=u+c.shift();v=y+c.shift();k=w+c.shift();l=v+c.shift();u=k+(1===c.length?c.shift():0);m(y,w,v,k,l,u)}break;default:if(F<32)throw new r.FormatError(`unknown operator: ${F}`);if(F<247)c.push(F-139);else if(F<251)c.push(256*(F-247)+p[b++]+108);else if(F<255)c.push(256*-(F-251)-p[b++]-108);else{c.push((p[b]<<24|p[b+1]<<16|p[b+2]<<8|p[b+3])/65536);b+=4}}I&&(c.length=0)}}(t)}(e,t,this,i)}}return{create:function(a,i){for(var n,s,o,h,u,d,m=new Uint8Array(a.data),p=t(m,4),b=0,y=12;b<p;b++,y+=16){var v=(0,r.bytesToString)(m.subarray(y,y+4)),w=e(m,y+8),k=e(m,y+12);switch(v){case"cmap":n=c(m,w);break;case"glyf":s=m.subarray(w,w+k);break;case"loca":o=m.subarray(w,w+k);break;case"head":d=t(m,w+18);u=t(m,w+50);break;case"CFF ":h=l(m,w,w+k,i)}}if(s){var S=d?[1/d,0,0,1/d,0,0]:a.fontMatrix;return new f(function(e,t,a){var r,i;if(a){r=4;i=function(e,t){return e[t]<<24|e[t+1]<<16|e[t+2]<<8|e[t+3]}}else{r=2;i=function(e,t){return e[t]<<9|e[t+1]<<1}}for(var n=[],s=i(t,0),o=r;o<t.length;o+=r){var c=i(t,o);n.push(e.subarray(s,c));s=c}return n}(s,o,u),n,S)}return new g(h,n,a.fontMatrix,a.glyphNameMap)}}}();t.FontRendererFactory=c},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.Type1Parser=void 0;var r=a(30),i=a(7),n=a(11),s=a(2),o=function(){var e=[4],t=[5],a=[6],r=[7],i=[8],n=[12,35],o=[14],c=[21],l=[22],h=[30],u=[31];function d(){this.width=0;this.lsb=0;this.flexing=!1;this.output=[];this.stack=[]}d.prototype={convert:function(d,f,g){for(var m,p,b,y=d.length,v=!1,w=0;w<y;w++){var k=d[w];if(k<32){12===k&&(k=(k<<8)+d[++w]);switch(k){case 1:case 3:this.stack=[];break;case 4:if(this.flexing){if(this.stack.length<1){v=!0;break}var S=this.stack.pop();this.stack.push(0,S);break}v=this.executeCommand(1,e);break;case 5:v=this.executeCommand(2,t);break;case 6:v=this.executeCommand(1,a);break;case 7:v=this.executeCommand(1,r);break;case 8:v=this.executeCommand(6,i);break;case 9:this.stack=[];break;case 10:if(this.stack.length<1){v=!0;break}if(!f[b=this.stack.pop()]){v=!0;break}v=this.convert(f[b],f,g);break;case 11:return v;case 13:if(this.stack.length<2){v=!0;break}m=this.stack.pop();p=this.stack.pop();this.lsb=p;this.width=m;this.stack.push(m,p);v=this.executeCommand(2,l);break;case 14:this.output.push(o[0]);break;case 21:if(this.flexing)break;v=this.executeCommand(2,c);break;case 22:if(this.flexing){this.stack.push(0);break}v=this.executeCommand(1,l);break;case 30:v=this.executeCommand(4,h);break;case 31:v=this.executeCommand(4,u);break;case 3072:case 3073:case 3074:this.stack=[];break;case 3078:if(g){this.seac=this.stack.splice(-4,4);v=this.executeCommand(0,o)}else v=this.executeCommand(4,o);break;case 3079:if(this.stack.length<4){v=!0;break}this.stack.pop();m=this.stack.pop();var C=this.stack.pop();p=this.stack.pop();this.lsb=p;this.width=m;this.stack.push(m,p,C);v=this.executeCommand(3,c);break;case 3084:if(this.stack.length<2){v=!0;break}var x=this.stack.pop(),A=this.stack.pop();this.stack.push(A/x);break;case 3088:if(this.stack.length<2){v=!0;break}b=this.stack.pop();var I=this.stack.pop();if(0===b&&3===I){var F=this.stack.splice(this.stack.length-17,17);this.stack.push(F[2]+F[0],F[3]+F[1],F[4],F[5],F[6],F[7],F[8],F[9],F[10],F[11],F[12],F[13],F[14]);v=this.executeCommand(13,n,!0);this.flexing=!1;this.stack.push(F[15],F[16])}else 1===b&&0===I&&(this.flexing=!0);break;case 3089:break;case 3105:this.stack=[];break;default:(0,s.warn)('Unknown type 1 charstring command of "'+k+'"')}if(v)break}else{k<=246?k-=139:k=k<=250?256*(k-247)+d[++w]+108:k<=254?-256*(k-251)-d[++w]-108:(255&d[++w])<<24|(255&d[++w])<<16|(255&d[++w])<<8|(255&d[++w])<<0;this.stack.push(k)}}return v},executeCommand(e,t,a){var r=this.stack.length;if(e>r)return!0;for(var i=r-e,n=i;n<r;n++){var s=this.stack[n];if(Number.isInteger(s))this.output.push(28,s>>8&255,255&s);else{s=65536*s|0;this.output.push(255,s>>24&255,s>>16&255,s>>8&255,255&s)}}this.output.push.apply(this.output,t);a?this.stack.splice(i,e):this.stack.length=0;return!1}};return d}(),c=function(){function e(e){return e>=48&&e<=57||e>=65&&e<=70||e>=97&&e<=102}function t(e,t,a){if(a>=e.length)return new Uint8Array(0);var r,i,n=0|t;for(r=0;r<a;r++)n=52845*(e[r]+n)+22719&65535;var s=e.length-a,o=new Uint8Array(s);for(r=a,i=0;i<s;r++,i++){var c=e[r];o[i]=c^n>>8;n=52845*(c+n)+22719&65535}return o}function a(e){return 47===e||91===e||93===e||123===e||125===e||40===e||41===e}function s(a,r,i){if(r){var s=a.getBytes(),o=!(e(s[0])&&e(s[1])&&e(s[2])&&e(s[3]));a=new n.Stream(o?t(s,55665,4):function(t,a,r){var i,n,s=0|a,o=t.length,c=new Uint8Array(o>>>1);for(i=0,n=0;i<o;i++){var l=t[i];if(e(l)){i++;for(var h;i<o&&!e(h=t[i]);)i++;if(i<o){var u=parseInt(String.fromCharCode(l,h),16);c[n++]=u^s>>8;s=52845*(u+s)+22719&65535}}}return Array.prototype.slice.call(c,r,n)}(s,55665,4))}this.seacAnalysisEnabled=!!i;this.stream=a;this.nextChar()}s.prototype={readNumberArray:function(){this.getToken();for(var e=[];;){var t=this.getToken();if(null===t||"]"===t||"}"===t)break;e.push(parseFloat(t||0))}return e},readNumber:function(){var e=this.getToken();return parseFloat(e||0)},readInt:function(){var e=this.getToken();return 0|parseInt(e||0,10)},readBoolean:function(){return"true"===this.getToken()?1:0},nextChar:function(){return this.currentChar=this.stream.getByte()},getToken:function(){for(var e=!1,t=this.currentChar;;){if(-1===t)return null;if(e)10!==t&&13!==t||(e=!1);else if(37===t)e=!0;else if(!(0,i.isWhiteSpace)(t))break;t=this.nextChar()}if(a(t)){this.nextChar();return String.fromCharCode(t)}var r="";do{r+=String.fromCharCode(t);t=this.nextChar()}while(t>=0&&!(0,i.isWhiteSpace)(t)&&!a(t));return r},readCharStrings:function(e,a){return-1===a?e:t(e,4330,a)},extractFontProgram:function(e){var t=this.stream,a=[],r=[],i=Object.create(null);i.lenIV=4;for(var n,s,c,l,h,u={subrs:[],charstrings:[],properties:{privateData:i}};null!==(n=this.getToken());)if("/"===n)switch(n=this.getToken()){case"CharStrings":this.getToken();this.getToken();this.getToken();this.getToken();for(;null!==(n=this.getToken())&&"end"!==n;)if("/"===n){var d=this.getToken();s=this.readInt();this.getToken();c=s>0?t.getBytes(s):new Uint8Array(0);l=u.properties.privateData.lenIV;h=this.readCharStrings(c,l);this.nextChar();"noaccess"===(n=this.getToken())&&this.getToken();r.push({glyph:d,encoded:h})}break;case"Subrs":this.readInt();this.getToken();for(;"dup"===this.getToken();){var f=this.readInt();s=this.readInt();this.getToken();c=s>0?t.getBytes(s):new Uint8Array(0);l=u.properties.privateData.lenIV;h=this.readCharStrings(c,l);this.nextChar();"noaccess"===(n=this.getToken())&&this.getToken();a[f]=h}break;case"BlueValues":case"OtherBlues":case"FamilyBlues":case"FamilyOtherBlues":var g=this.readNumberArray();g.length>0&&g.length,0;break;case"StemSnapH":case"StemSnapV":u.properties.privateData[n]=this.readNumberArray();break;case"StdHW":case"StdVW":u.properties.privateData[n]=this.readNumberArray()[0];break;case"BlueShift":case"lenIV":case"BlueFuzz":case"BlueScale":case"LanguageGroup":case"ExpansionFactor":u.properties.privateData[n]=this.readNumber();break;case"ForceBold":u.properties.privateData[n]=this.readBoolean()}for(var m=0;m<r.length;m++){d=r[m].glyph;h=r[m].encoded;var p=new o,b=p.convert(h,a,this.seacAnalysisEnabled),y=p.output;b&&(y=[14]);const t={glyphName:d,charstring:y,width:p.width,lsb:p.lsb,seac:p.seac};".notdef"===d?u.charstrings.unshift(t):u.charstrings.push(t);if(e.builtInEncoding){const t=e.builtInEncoding.indexOf(d);t>-1&&void 0===e.widths[t]&&t>=e.firstChar&&t<=e.lastChar&&(e.widths[t]=p.width)}}return u},extractFontHeader:function(e){for(var t;null!==(t=this.getToken());)if("/"===t)switch(t=this.getToken()){case"FontMatrix":var a=this.readNumberArray();e.fontMatrix=a;break;case"Encoding":var i,n=this.getToken();if(/^\d+$/.test(n)){i=[];var s=0|parseInt(n,10);this.getToken();for(var o=0;o<s;o++){t=this.getToken();for(;"dup"!==t&&"def"!==t;)if(null===(t=this.getToken()))return;if("def"===t)break;var c=this.readInt();this.getToken();var l=this.getToken();i[c]=l;this.getToken()}}else i=(0,r.getEncoding)(n);e.builtInEncoding=i;break;case"FontBBox":var h=this.readNumberArray();e.ascent=Math.max(h[3],h[1]);e.descent=Math.min(h[1],h[3]);e.ascentScaled=!0}}};return s}();t.Type1Parser=c},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.getTilingPatternIR=function(e,t,a){const i=t.getArray("Matrix"),n=r.Util.normalizeRect(t.getArray("BBox")),s=t.get("XStep"),o=t.get("YStep"),c=t.get("PaintType"),l=t.get("TilingType");if(n[2]-n[0]==0||n[3]-n[1]==0)throw new r.FormatError(`Invalid getTilingPatternIR /BBox array: [${n}].`);return["TilingPattern",a,e,i,n,s,o,c,l]};t.Pattern=void 0;var r=a(2),i=a(22),n=a(4),s=a(7),o=2,c=3,l=4,h=5,u=6,d=7,f=function(){function e(){(0,r.unreachable)("should not call Pattern constructor")}e.prototype={getPattern:function(e){(0,r.unreachable)(`Should not call Pattern.getStyle: ${e}`)}};e.parseShading=function(e,t,a,i,f,m){var p=(0,n.isStream)(e)?e.dict:e,b=p.get("ShadingType");try{switch(b){case o:case c:return new g.RadialAxial(p,t,a,i,m);case l:case h:case u:case d:return new g.Mesh(e,t,a,i,m);default:throw new r.FormatError("Unsupported ShadingType: "+b)}}catch(e){if(e instanceof s.MissingDataException)throw e;f.send("UnsupportedFeature",{featureId:r.UNSUPPORTED_FEATURES.shadingPattern});(0,r.warn)(e);return new g.Dummy}};return e}();t.Pattern=f;var g={SMALL_NUMBER:1e-6};g.RadialAxial=function(){function e(e,t,a,n,s){this.matrix=t;this.coordsArr=e.getArray("Coords");this.shadingType=e.get("ShadingType");this.type="Pattern";var o=e.get("ColorSpace","CS");o=i.ColorSpace.parse(o,a,n,s);this.cs=o;const l=e.getArray("BBox");Array.isArray(l)&&4===l.length?this.bbox=r.Util.normalizeRect(l):this.bbox=null;var h=0,u=1;if(e.has("Domain")){var d=e.getArray("Domain");h=d[0];u=d[1]}var f=!1,m=!1;if(e.has("Extend")){var p=e.getArray("Extend");f=p[0];m=p[1]}if(!(this.shadingType!==c||f&&m)){var b=this.coordsArr[0],y=this.coordsArr[1],v=this.coordsArr[2],w=this.coordsArr[3],k=this.coordsArr[4],S=this.coordsArr[5],C=Math.sqrt((b-w)*(b-w)+(y-k)*(y-k));v<=S+C&&S<=v+C&&(0,r.warn)("Unsupported radial gradient.")}this.extendStart=f;this.extendEnd=m;var x=e.get("Function"),A=s.createFromArray(x);const I=(u-h)/10;var F=this.colorStops=[];if(h>=u||I<=0)(0,r.info)("Bad shading domain.");else{var T,E=new Float32Array(o.numComps),O=new Float32Array(1);for(let e=0;e<=10;e++){O[0]=h+e*I;A(O,0,E,0);T=o.getRgb(E,0);var P=r.Util.makeCssRgb(T[0],T[1],T[2]);F.push([e/10,P])}var B="transparent";if(e.has("Background")){T=o.getRgb(e.get("Background"),0);B=r.Util.makeCssRgb(T[0],T[1],T[2])}if(!f){F.unshift([0,B]);F[1][0]+=g.SMALL_NUMBER}if(!m){F[F.length-1][0]-=g.SMALL_NUMBER;F.push([1,B])}this.colorStops=F}}e.prototype={getIR:function(){var e,t,a,i,n,s=this.coordsArr,l=this.shadingType;if(l===o){t=[s[0],s[1]];a=[s[2],s[3]];i=null;n=null;e="axial"}else if(l===c){t=[s[0],s[1]];a=[s[3],s[4]];i=s[2];n=s[5];e="radial"}else(0,r.unreachable)(`getPattern type unknown: ${l}`);var h=this.matrix;if(h){t=r.Util.applyTransform(t,h);a=r.Util.applyTransform(a,h);if(l===c){var u=r.Util.singularValueDecompose2dScale(h);i*=u[0];n*=u[1]}}return["RadialAxial",e,this.bbox,this.colorStops,t,a,i,n]}};return e}();g.Mesh=function(){function e(e,t){this.stream=e;this.context=t;this.buffer=0;this.bufferLength=0;var a=t.numComps;this.tmpCompsBuf=new Float32Array(a);var r=t.colorSpace.numComps;this.tmpCsCompsBuf=t.colorFn?new Float32Array(r):this.tmpCompsBuf}e.prototype={get hasData(){if(this.stream.end)return this.stream.pos<this.stream.end;if(this.bufferLength>0)return!0;var e=this.stream.getByte();if(e<0)return!1;this.buffer=e;this.bufferLength=8;return!0},readBits:function(e){var t=this.buffer,a=this.bufferLength;if(32===e){if(0===a)return(this.stream.getByte()<<24|this.stream.getByte()<<16|this.stream.getByte()<<8|this.stream.getByte())>>>0;t=t<<24|this.stream.getByte()<<16|this.stream.getByte()<<8|this.stream.getByte();var r=this.stream.getByte();this.buffer=r&(1<<a)-1;return(t<<8-a|(255&r)>>a)>>>0}if(8===e&&0===a)return this.stream.getByte();for(;a<e;){t=t<<8|this.stream.getByte();a+=8}a-=e;this.bufferLength=a;this.buffer=t&(1<<a)-1;return t>>a},align:function(){this.buffer=0;this.bufferLength=0},readFlag:function(){return this.readBits(this.context.bitsPerFlag)},readCoordinate:function(){var e=this.context.bitsPerCoordinate,t=this.readBits(e),a=this.readBits(e),r=this.context.decode,i=e<32?1/((1<<e)-1):2.3283064365386963e-10;return[t*i*(r[1]-r[0])+r[0],a*i*(r[3]-r[2])+r[2]]},readComponents:function(){for(var e=this.context.numComps,t=this.context.bitsPerComponent,a=t<32?1/((1<<t)-1):2.3283064365386963e-10,r=this.context.decode,i=this.tmpCompsBuf,n=0,s=4;n<e;n++,s+=2){var o=this.readBits(t);i[n]=o*a*(r[s+1]-r[s])+r[s]}var c=this.tmpCsCompsBuf;this.context.colorFn&&this.context.colorFn(i,0,c,0);return this.context.colorSpace.getRgb(c,0)}};var t,a=(t=[],function(e){t[e]||(t[e]=function(e){for(var t=[],a=0;a<=e;a++){var r=a/e,i=1-r;t.push(new Float32Array([i*i*i,3*r*i*i,3*r*r*i,r*r*r]))}return t}(e));return t[e]});function s(e,t){var i=e.figures[t];(0,r.assert)("patch"===i.type,"Unexpected patch mesh figure");var n=e.coords,s=e.colors,o=i.coords,c=i.colors,l=Math.min(n[o[0]][0],n[o[3]][0],n[o[12]][0],n[o[15]][0]),h=Math.min(n[o[0]][1],n[o[3]][1],n[o[12]][1],n[o[15]][1]),u=Math.max(n[o[0]][0],n[o[3]][0],n[o[12]][0],n[o[15]][0]),d=Math.max(n[o[0]][1],n[o[3]][1],n[o[12]][1],n[o[15]][1]),f=Math.ceil(20*(u-l)/(e.bounds[2]-e.bounds[0]));f=Math.max(3,Math.min(20,f));var g=Math.ceil(20*(d-h)/(e.bounds[3]-e.bounds[1]));g=Math.max(3,Math.min(20,g));for(var m=f+1,p=new Int32Array((g+1)*m),b=new Int32Array((g+1)*m),y=0,v=new Uint8Array(3),w=new Uint8Array(3),k=s[c[0]],S=s[c[1]],C=s[c[2]],x=s[c[3]],A=a(g),I=a(f),F=0;F<=g;F++){v[0]=(k[0]*(g-F)+C[0]*F)/g|0;v[1]=(k[1]*(g-F)+C[1]*F)/g|0;v[2]=(k[2]*(g-F)+C[2]*F)/g|0;w[0]=(S[0]*(g-F)+x[0]*F)/g|0;w[1]=(S[1]*(g-F)+x[1]*F)/g|0;w[2]=(S[2]*(g-F)+x[2]*F)/g|0;for(var T=0;T<=f;T++,y++)if(0!==F&&F!==g||0!==T&&T!==f){for(var E=0,O=0,P=0,B=0;B<=3;B++)for(var D=0;D<=3;D++,P++){var N=A[F][B]*I[T][D];E+=n[o[P]][0]*N;O+=n[o[P]][1]*N}p[y]=n.length;n.push([E,O]);b[y]=s.length;var M=new Uint8Array(3);M[0]=(v[0]*(f-T)+w[0]*T)/f|0;M[1]=(v[1]*(f-T)+w[1]*T)/f|0;M[2]=(v[2]*(f-T)+w[2]*T)/f|0;s.push(M)}}p[0]=o[0];b[0]=c[0];p[f]=o[3];b[f]=c[1];p[m*g]=o[12];b[m*g]=c[2];p[m*g+f]=o[15];b[m*g+f]=c[3];e.figures[t]={type:"lattice",coords:p,colors:b,verticesPerRow:m}}function o(e){for(var t=e.coords[0][0],a=e.coords[0][1],r=t,i=a,n=1,s=e.coords.length;n<s;n++){var o=e.coords[n][0],c=e.coords[n][1];t=t>o?o:t;a=a>c?c:a;r=r<o?o:r;i=i<c?c:i}e.bounds=[t,a,r,i]}function c(t,a,c,f,g){if(!(0,n.isStream)(t))throw new r.FormatError("Mesh data is not a stream");var m=t.dict;this.matrix=a;this.shadingType=m.get("ShadingType");this.type="Pattern";const p=m.getArray("BBox");Array.isArray(p)&&4===p.length?this.bbox=r.Util.normalizeRect(p):this.bbox=null;var b=m.get("ColorSpace","CS");b=i.ColorSpace.parse(b,c,f,g);this.cs=b;this.background=m.has("Background")?b.getRgb(m.get("Background"),0):null;var y=m.get("Function"),v=y?g.createFromArray(y):null;this.coords=[];this.colors=[];this.figures=[];var w=new e(t,{bitsPerCoordinate:m.get("BitsPerCoordinate"),bitsPerComponent:m.get("BitsPerComponent"),bitsPerFlag:m.get("BitsPerFlag"),decode:m.getArray("Decode"),colorFn:v,colorSpace:b,numComps:v?1:b.numComps}),k=!1;switch(this.shadingType){case l:!function(e,t){for(var a=e.coords,i=e.colors,n=[],s=[],o=0;t.hasData;){var c=t.readFlag(),l=t.readCoordinate(),h=t.readComponents();if(0===o){if(!(0<=c&&c<=2))throw new r.FormatError("Unknown type4 flag");switch(c){case 0:o=3;break;case 1:s.push(s[s.length-2],s[s.length-1]);o=1;break;case 2:s.push(s[s.length-3],s[s.length-1]);o=1}n.push(c)}s.push(a.length);a.push(l);i.push(h);o--;t.align()}e.figures.push({type:"triangles",coords:new Int32Array(s),colors:new Int32Array(s)})}(this,w);break;case h:var S=0|m.get("VerticesPerRow");if(S<2)throw new r.FormatError("Invalid VerticesPerRow");!function(e,t,a){for(var r=e.coords,i=e.colors,n=[];t.hasData;){var s=t.readCoordinate(),o=t.readComponents();n.push(r.length);r.push(s);i.push(o)}e.figures.push({type:"lattice",coords:new Int32Array(n),colors:new Int32Array(n),verticesPerRow:a})}(this,w,S);break;case u:!function(e,t){for(var a=e.coords,i=e.colors,n=new Int32Array(16),s=new Int32Array(4);t.hasData;){var o,c,l=t.readFlag();if(!(0<=l&&l<=3))throw new r.FormatError("Unknown type6 flag");var h=a.length;for(o=0,c=0!==l?8:12;o<c;o++)a.push(t.readCoordinate());var u,d,f,g,m=i.length;for(o=0,c=0!==l?2:4;o<c;o++)i.push(t.readComponents());switch(l){case 0:n[12]=h+3;n[13]=h+4;n[14]=h+5;n[15]=h+6;n[8]=h+2;n[11]=h+7;n[4]=h+1;n[7]=h+8;n[0]=h;n[1]=h+11;n[2]=h+10;n[3]=h+9;s[2]=m+1;s[3]=m+2;s[0]=m;s[1]=m+3;break;case 1:u=n[12];d=n[13];f=n[14];g=n[15];n[12]=g;n[13]=h+0;n[14]=h+1;n[15]=h+2;n[8]=f;n[11]=h+3;n[4]=d;n[7]=h+4;n[0]=u;n[1]=h+7;n[2]=h+6;n[3]=h+5;u=s[2];d=s[3];s[2]=d;s[3]=m;s[0]=u;s[1]=m+1;break;case 2:u=n[15];d=n[11];n[12]=n[3];n[13]=h+0;n[14]=h+1;n[15]=h+2;n[8]=n[7];n[11]=h+3;n[4]=d;n[7]=h+4;n[0]=u;n[1]=h+7;n[2]=h+6;n[3]=h+5;u=s[3];s[2]=s[1];s[3]=m;s[0]=u;s[1]=m+1;break;case 3:n[12]=n[0];n[13]=h+0;n[14]=h+1;n[15]=h+2;n[8]=n[1];n[11]=h+3;n[4]=n[2];n[7]=h+4;n[0]=n[3];n[1]=h+7;n[2]=h+6;n[3]=h+5;s[2]=s[0];s[3]=m;s[0]=s[1];s[1]=m+1}n[5]=a.length;a.push([(-4*a[n[0]][0]-a[n[15]][0]+6*(a[n[4]][0]+a[n[1]][0])-2*(a[n[12]][0]+a[n[3]][0])+3*(a[n[13]][0]+a[n[7]][0]))/9,(-4*a[n[0]][1]-a[n[15]][1]+6*(a[n[4]][1]+a[n[1]][1])-2*(a[n[12]][1]+a[n[3]][1])+3*(a[n[13]][1]+a[n[7]][1]))/9]);n[6]=a.length;a.push([(-4*a[n[3]][0]-a[n[12]][0]+6*(a[n[2]][0]+a[n[7]][0])-2*(a[n[0]][0]+a[n[15]][0])+3*(a[n[4]][0]+a[n[14]][0]))/9,(-4*a[n[3]][1]-a[n[12]][1]+6*(a[n[2]][1]+a[n[7]][1])-2*(a[n[0]][1]+a[n[15]][1])+3*(a[n[4]][1]+a[n[14]][1]))/9]);n[9]=a.length;a.push([(-4*a[n[12]][0]-a[n[3]][0]+6*(a[n[8]][0]+a[n[13]][0])-2*(a[n[0]][0]+a[n[15]][0])+3*(a[n[11]][0]+a[n[1]][0]))/9,(-4*a[n[12]][1]-a[n[3]][1]+6*(a[n[8]][1]+a[n[13]][1])-2*(a[n[0]][1]+a[n[15]][1])+3*(a[n[11]][1]+a[n[1]][1]))/9]);n[10]=a.length;a.push([(-4*a[n[15]][0]-a[n[0]][0]+6*(a[n[11]][0]+a[n[14]][0])-2*(a[n[12]][0]+a[n[3]][0])+3*(a[n[2]][0]+a[n[8]][0]))/9,(-4*a[n[15]][1]-a[n[0]][1]+6*(a[n[11]][1]+a[n[14]][1])-2*(a[n[12]][1]+a[n[3]][1])+3*(a[n[2]][1]+a[n[8]][1]))/9]);e.figures.push({type:"patch",coords:new Int32Array(n),colors:new Int32Array(s)})}}(this,w);k=!0;break;case d:!function(e,t){for(var a=e.coords,i=e.colors,n=new Int32Array(16),s=new Int32Array(4);t.hasData;){var o,c,l=t.readFlag();if(!(0<=l&&l<=3))throw new r.FormatError("Unknown type7 flag");var h=a.length;for(o=0,c=0!==l?12:16;o<c;o++)a.push(t.readCoordinate());var u,d,f,g,m=i.length;for(o=0,c=0!==l?2:4;o<c;o++)i.push(t.readComponents());switch(l){case 0:n[12]=h+3;n[13]=h+4;n[14]=h+5;n[15]=h+6;n[8]=h+2;n[9]=h+13;n[10]=h+14;n[11]=h+7;n[4]=h+1;n[5]=h+12;n[6]=h+15;n[7]=h+8;n[0]=h;n[1]=h+11;n[2]=h+10;n[3]=h+9;s[2]=m+1;s[3]=m+2;s[0]=m;s[1]=m+3;break;case 1:u=n[12];d=n[13];f=n[14];g=n[15];n[12]=g;n[13]=h+0;n[14]=h+1;n[15]=h+2;n[8]=f;n[9]=h+9;n[10]=h+10;n[11]=h+3;n[4]=d;n[5]=h+8;n[6]=h+11;n[7]=h+4;n[0]=u;n[1]=h+7;n[2]=h+6;n[3]=h+5;u=s[2];d=s[3];s[2]=d;s[3]=m;s[0]=u;s[1]=m+1;break;case 2:u=n[15];d=n[11];n[12]=n[3];n[13]=h+0;n[14]=h+1;n[15]=h+2;n[8]=n[7];n[9]=h+9;n[10]=h+10;n[11]=h+3;n[4]=d;n[5]=h+8;n[6]=h+11;n[7]=h+4;n[0]=u;n[1]=h+7;n[2]=h+6;n[3]=h+5;u=s[3];s[2]=s[1];s[3]=m;s[0]=u;s[1]=m+1;break;case 3:n[12]=n[0];n[13]=h+0;n[14]=h+1;n[15]=h+2;n[8]=n[1];n[9]=h+9;n[10]=h+10;n[11]=h+3;n[4]=n[2];n[5]=h+8;n[6]=h+11;n[7]=h+4;n[0]=n[3];n[1]=h+7;n[2]=h+6;n[3]=h+5;s[2]=s[0];s[3]=m;s[0]=s[1];s[1]=m+1}e.figures.push({type:"patch",coords:new Int32Array(n),colors:new Int32Array(s)})}}(this,w);k=!0;break;default:(0,r.unreachable)("Unsupported mesh type.")}if(k){o(this);for(var C=0,x=this.figures.length;C<x;C++)s(this,C)}o(this);!function(e){var t,a,r,i,n=e.coords,s=new Float32Array(2*n.length);for(t=0,r=0,a=n.length;t<a;t++){var o=n[t];s[r++]=o[0];s[r++]=o[1]}e.coords=s;var c=e.colors,l=new Uint8Array(3*c.length);for(t=0,r=0,a=c.length;t<a;t++){var h=c[t];l[r++]=h[0];l[r++]=h[1];l[r++]=h[2]}e.colors=l;var u=e.figures;for(t=0,a=u.length;t<a;t++){var d=u[t],f=d.coords,g=d.colors;for(r=0,i=f.length;r<i;r++){f[r]*=2;g[r]*=3}}}(this)}c.prototype={getIR:function(){return["Mesh",this.shadingType,this.coords,this.colors,this.figures,this.bounds,this.matrix,this.bbox,this.background]}};return c}();g.Dummy=function(){function e(){this.type="Pattern"}e.prototype={getIR:function(){return["Dummy"]}};return e}()},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.bidi=function(e,t,a){var g=!0,m=e.length;if(0===m||a)return u(e,g,a);d.length=m;f.length=m;var p,b,y=0;for(p=0;p<m;++p){d[p]=e.charAt(p);var v=e.charCodeAt(p),w="L";v<=255?w=i[v]:1424<=v&&v<=1524?w="R":1536<=v&&v<=1791?(w=n[255&v])||(0,r.warn)("Bidi: invalid Unicode character "+v.toString(16)):1792<=v&&v<=2220&&(w="AL");"R"!==w&&"AL"!==w&&"AN"!==w||y++;f[p]=w}if(0===y)return u(e,g=!0);if(-1===t)if(y/m<.3){g=!0;t=0}else{g=!1;t=1}var k=[];for(p=0;p<m;++p)k[p]=t;var S,C=s(t)?"R":"L",x=C,A=x,I=x;for(p=0;p<m;++p)"NSM"===f[p]?f[p]=I:I=f[p];I=x;for(p=0;p<m;++p)"EN"===(S=f[p])?f[p]="AL"===I?"AN":"EN":"R"!==S&&"L"!==S&&"AL"!==S||(I=S);for(p=0;p<m;++p)"AL"===(S=f[p])&&(f[p]="R");for(p=1;p<m-1;++p){"ES"===f[p]&&"EN"===f[p-1]&&"EN"===f[p+1]&&(f[p]="EN");"CS"!==f[p]||"EN"!==f[p-1]&&"AN"!==f[p-1]||f[p+1]!==f[p-1]||(f[p]=f[p-1])}for(p=0;p<m;++p)if("EN"===f[p]){var F;for(F=p-1;F>=0&&"ET"===f[F];--F)f[F]="EN";for(F=p+1;F<m&&"ET"===f[F];++F)f[F]="EN"}for(p=0;p<m;++p)"WS"!==(S=f[p])&&"ES"!==S&&"ET"!==S&&"CS"!==S||(f[p]="ON");I=x;for(p=0;p<m;++p)"EN"===(S=f[p])?f[p]="L"===I?"L":"EN":"R"!==S&&"L"!==S||(I=S);for(p=0;p<m;++p)if("ON"===f[p]){var T=c(f,p+1,"ON"),E=x;p>0&&(E=f[p-1]);var O=A;T+1<m&&(O=f[T+1]);"L"!==E&&(E="R");"L"!==O&&(O="R");E===O&&l(f,p,T,E);p=T-1}for(p=0;p<m;++p)"ON"===f[p]&&(f[p]=C);for(p=0;p<m;++p){S=f[p];o(k[p])?"R"===S?k[p]+=1:"AN"!==S&&"EN"!==S||(k[p]+=2):"L"!==S&&"AN"!==S&&"EN"!==S||(k[p]+=1)}var P,B=-1,D=99;for(p=0,b=k.length;p<b;++p){P=k[p];B<P&&(B=P);D>P&&s(P)&&(D=P)}for(P=B;P>=D;--P){var N=-1;for(p=0,b=k.length;p<b;++p)if(k[p]<P){if(N>=0){h(d,N,p);N=-1}}else N<0&&(N=p);N>=0&&h(d,N,k.length)}for(p=0,b=d.length;p<b;++p){var M=d[p];"<"!==M&&">"!==M||(d[p]="")}return u(d.join(""),g)};var r=a(2),i=["BN","BN","BN","BN","BN","BN","BN","BN","BN","S","B","S","WS","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","B","B","B","S","WS","ON","ON","ET","ET","ET","ON","ON","ON","ON","ON","ES","CS","ES","CS","CS","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","CS","ON","ON","ON","ON","ON","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","ON","ON","ON","ON","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","ON","ON","ON","BN","BN","BN","BN","BN","BN","B","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","BN","CS","ON","ET","ET","ET","ET","ON","ON","ON","ON","L","ON","ON","BN","ON","ON","ET","ET","EN","EN","ON","L","ON","ON","ON","EN","L","ON","ON","ON","ON","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","L","ON","L","L","L","L","L","L","L","L"],n=["AN","AN","AN","AN","AN","AN","ON","ON","AL","ET","ET","AL","CS","AL","ON","ON","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","AN","AN","AN","AN","AN","AN","AN","AN","AN","ET","AN","AN","AL","AL","AL","NSM","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","AL","NSM","NSM","NSM","NSM","NSM","NSM","NSM","AN","ON","NSM","NSM","NSM","NSM","NSM","NSM","AL","AL","NSM","NSM","ON","NSM","NSM","NSM","NSM","AL","AL","EN","EN","EN","EN","EN","EN","EN","EN","EN","EN","AL","AL","AL","AL","AL","AL"];function s(e){return 0!=(1&e)}function o(e){return 0==(1&e)}function c(e,t,a){for(var r=t,i=e.length;r<i;++r)if(e[r]!==a)return r;return r}function l(e,t,a,r){for(var i=t;i<a;++i)e[i]=r}function h(e,t,a){for(var r=t,i=a-1;r<i;++r,--i){var n=e[r];e[r]=e[i];e[i]=n}}function u(e,t,a=!1){let r="ltr";a?r="ttb":t||(r="rtl");return{str:e,dir:r}}var d=[],f=[]},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.getMetrics=void 0;var r=a(7),i=(0,r.getLookupTableFactory)((function(e){e.Courier=600;e["Courier-Bold"]=600;e["Courier-BoldOblique"]=600;e["Courier-Oblique"]=600;e.Helvetica=(0,r.getLookupTableFactory)((function(e){e.space=278;e.exclam=278;e.quotedbl=355;e.numbersign=556;e.dollar=556;e.percent=889;e.ampersand=667;e.quoteright=222;e.parenleft=333;e.parenright=333;e.asterisk=389;e.plus=584;e.comma=278;e.hyphen=333;e.period=278;e.slash=278;e.zero=556;e.one=556;e.two=556;e.three=556;e.four=556;e.five=556;e.six=556;e.seven=556;e.eight=556;e.nine=556;e.colon=278;e.semicolon=278;e.less=584;e.equal=584;e.greater=584;e.question=556;e.at=1015;e.A=667;e.B=667;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=722;e.I=278;e.J=500;e.K=667;e.L=556;e.M=833;e.N=722;e.O=778;e.P=667;e.Q=778;e.R=722;e.S=667;e.T=611;e.U=722;e.V=667;e.W=944;e.X=667;e.Y=667;e.Z=611;e.bracketleft=278;e.backslash=278;e.bracketright=278;e.asciicircum=469;e.underscore=556;e.quoteleft=222;e.a=556;e.b=556;e.c=500;e.d=556;e.e=556;e.f=278;e.g=556;e.h=556;e.i=222;e.j=222;e.k=500;e.l=222;e.m=833;e.n=556;e.o=556;e.p=556;e.q=556;e.r=333;e.s=500;e.t=278;e.u=556;e.v=500;e.w=722;e.x=500;e.y=500;e.z=500;e.braceleft=334;e.bar=260;e.braceright=334;e.asciitilde=584;e.exclamdown=333;e.cent=556;e.sterling=556;e.fraction=167;e.yen=556;e.florin=556;e.section=556;e.currency=556;e.quotesingle=191;e.quotedblleft=333;e.guillemotleft=556;e.guilsinglleft=333;e.guilsinglright=333;e.fi=500;e.fl=500;e.endash=556;e.dagger=556;e.daggerdbl=556;e.periodcentered=278;e.paragraph=537;e.bullet=350;e.quotesinglbase=222;e.quotedblbase=333;e.quotedblright=333;e.guillemotright=556;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=611;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=370;e.Lslash=556;e.Oslash=778;e.OE=1e3;e.ordmasculine=365;e.ae=889;e.dotlessi=278;e.lslash=222;e.oslash=611;e.oe=944;e.germandbls=611;e.Idieresis=278;e.eacute=556;e.abreve=556;e.uhungarumlaut=556;e.ecaron=556;e.Ydieresis=667;e.divide=584;e.Yacute=667;e.Acircumflex=667;e.aacute=556;e.Ucircumflex=722;e.yacute=500;e.scommaaccent=500;e.ecircumflex=556;e.Uring=722;e.Udieresis=722;e.aogonek=556;e.Uacute=722;e.uogonek=556;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=737;e.Emacron=667;e.ccaron=500;e.aring=556;e.Ncommaaccent=722;e.lacute=222;e.agrave=556;e.Tcommaaccent=611;e.Cacute=722;e.atilde=556;e.Edotaccent=667;e.scaron=500;e.scedilla=500;e.iacute=278;e.lozenge=471;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=556;e.acircumflex=556;e.Amacron=667;e.rcaron=333;e.ccedilla=500;e.Zdotaccent=611;e.Thorn=667;e.Omacron=778;e.Racute=722;e.Sacute=667;e.dcaron=643;e.Umacron=722;e.uring=556;e.threesuperior=333;e.Ograve=778;e.Agrave=667;e.Abreve=667;e.multiply=584;e.uacute=556;e.Tcaron=611;e.partialdiff=476;e.ydieresis=500;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=556;e.edieresis=556;e.cacute=500;e.nacute=556;e.umacron=556;e.Ncaron=722;e.Iacute=278;e.plusminus=584;e.brokenbar=260;e.registered=737;e.Gbreve=778;e.Idotaccent=278;e.summation=600;e.Egrave=667;e.racute=333;e.omacron=556;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=222;e.tcaron=317;e.eogonek=556;e.Uogonek=722;e.Aacute=667;e.Adieresis=667;e.egrave=556;e.zacute=500;e.iogonek=222;e.Oacute=778;e.oacute=556;e.amacron=556;e.sacute=500;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=556;e.twosuperior=333;e.Odieresis=778;e.mu=556;e.igrave=278;e.ohungarumlaut=556;e.Eogonek=667;e.dcroat=556;e.threequarters=834;e.Scedilla=667;e.lcaron=299;e.Kcommaaccent=667;e.Lacute=556;e.trademark=1e3;e.edotaccent=556;e.Igrave=278;e.Imacron=278;e.Lcaron=556;e.onehalf=834;e.lessequal=549;e.ocircumflex=556;e.ntilde=556;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=556;e.gbreve=556;e.onequarter=834;e.Scaron=667;e.Scommaaccent=667;e.Ohungarumlaut=778;e.degree=400;e.ograve=556;e.Ccaron=722;e.ugrave=556;e.radical=453;e.Dcaron=722;e.rcommaaccent=333;e.Ntilde=722;e.otilde=556;e.Rcommaaccent=722;e.Lcommaaccent=556;e.Atilde=667;e.Aogonek=667;e.Aring=667;e.Otilde=778;e.zdotaccent=500;e.Ecaron=667;e.Iogonek=278;e.kcommaaccent=500;e.minus=584;e.Icircumflex=278;e.ncaron=556;e.tcommaaccent=278;e.logicalnot=584;e.odieresis=556;e.udieresis=556;e.notequal=549;e.gcommaaccent=556;e.eth=556;e.zcaron=500;e.ncommaaccent=556;e.onesuperior=333;e.imacron=278;e.Euro=556}));e["Helvetica-Bold"]=(0,r.getLookupTableFactory)((function(e){e.space=278;e.exclam=333;e.quotedbl=474;e.numbersign=556;e.dollar=556;e.percent=889;e.ampersand=722;e.quoteright=278;e.parenleft=333;e.parenright=333;e.asterisk=389;e.plus=584;e.comma=278;e.hyphen=333;e.period=278;e.slash=278;e.zero=556;e.one=556;e.two=556;e.three=556;e.four=556;e.five=556;e.six=556;e.seven=556;e.eight=556;e.nine=556;e.colon=333;e.semicolon=333;e.less=584;e.equal=584;e.greater=584;e.question=611;e.at=975;e.A=722;e.B=722;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=722;e.I=278;e.J=556;e.K=722;e.L=611;e.M=833;e.N=722;e.O=778;e.P=667;e.Q=778;e.R=722;e.S=667;e.T=611;e.U=722;e.V=667;e.W=944;e.X=667;e.Y=667;e.Z=611;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=584;e.underscore=556;e.quoteleft=278;e.a=556;e.b=611;e.c=556;e.d=611;e.e=556;e.f=333;e.g=611;e.h=611;e.i=278;e.j=278;e.k=556;e.l=278;e.m=889;e.n=611;e.o=611;e.p=611;e.q=611;e.r=389;e.s=556;e.t=333;e.u=611;e.v=556;e.w=778;e.x=556;e.y=556;e.z=500;e.braceleft=389;e.bar=280;e.braceright=389;e.asciitilde=584;e.exclamdown=333;e.cent=556;e.sterling=556;e.fraction=167;e.yen=556;e.florin=556;e.section=556;e.currency=556;e.quotesingle=238;e.quotedblleft=500;e.guillemotleft=556;e.guilsinglleft=333;e.guilsinglright=333;e.fi=611;e.fl=611;e.endash=556;e.dagger=556;e.daggerdbl=556;e.periodcentered=278;e.paragraph=556;e.bullet=350;e.quotesinglbase=278;e.quotedblbase=500;e.quotedblright=500;e.guillemotright=556;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=611;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=370;e.Lslash=611;e.Oslash=778;e.OE=1e3;e.ordmasculine=365;e.ae=889;e.dotlessi=278;e.lslash=278;e.oslash=611;e.oe=944;e.germandbls=611;e.Idieresis=278;e.eacute=556;e.abreve=556;e.uhungarumlaut=611;e.ecaron=556;e.Ydieresis=667;e.divide=584;e.Yacute=667;e.Acircumflex=722;e.aacute=556;e.Ucircumflex=722;e.yacute=556;e.scommaaccent=556;e.ecircumflex=556;e.Uring=722;e.Udieresis=722;e.aogonek=556;e.Uacute=722;e.uogonek=611;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=737;e.Emacron=667;e.ccaron=556;e.aring=556;e.Ncommaaccent=722;e.lacute=278;e.agrave=556;e.Tcommaaccent=611;e.Cacute=722;e.atilde=556;e.Edotaccent=667;e.scaron=556;e.scedilla=556;e.iacute=278;e.lozenge=494;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=611;e.acircumflex=556;e.Amacron=722;e.rcaron=389;e.ccedilla=556;e.Zdotaccent=611;e.Thorn=667;e.Omacron=778;e.Racute=722;e.Sacute=667;e.dcaron=743;e.Umacron=722;e.uring=611;e.threesuperior=333;e.Ograve=778;e.Agrave=722;e.Abreve=722;e.multiply=584;e.uacute=611;e.Tcaron=611;e.partialdiff=494;e.ydieresis=556;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=556;e.edieresis=556;e.cacute=556;e.nacute=611;e.umacron=611;e.Ncaron=722;e.Iacute=278;e.plusminus=584;e.brokenbar=280;e.registered=737;e.Gbreve=778;e.Idotaccent=278;e.summation=600;e.Egrave=667;e.racute=389;e.omacron=611;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=278;e.tcaron=389;e.eogonek=556;e.Uogonek=722;e.Aacute=722;e.Adieresis=722;e.egrave=556;e.zacute=500;e.iogonek=278;e.Oacute=778;e.oacute=611;e.amacron=556;e.sacute=556;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=611;e.twosuperior=333;e.Odieresis=778;e.mu=611;e.igrave=278;e.ohungarumlaut=611;e.Eogonek=667;e.dcroat=611;e.threequarters=834;e.Scedilla=667;e.lcaron=400;e.Kcommaaccent=722;e.Lacute=611;e.trademark=1e3;e.edotaccent=556;e.Igrave=278;e.Imacron=278;e.Lcaron=611;e.onehalf=834;e.lessequal=549;e.ocircumflex=611;e.ntilde=611;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=556;e.gbreve=611;e.onequarter=834;e.Scaron=667;e.Scommaaccent=667;e.Ohungarumlaut=778;e.degree=400;e.ograve=611;e.Ccaron=722;e.ugrave=611;e.radical=549;e.Dcaron=722;e.rcommaaccent=389;e.Ntilde=722;e.otilde=611;e.Rcommaaccent=722;e.Lcommaaccent=611;e.Atilde=722;e.Aogonek=722;e.Aring=722;e.Otilde=778;e.zdotaccent=500;e.Ecaron=667;e.Iogonek=278;e.kcommaaccent=556;e.minus=584;e.Icircumflex=278;e.ncaron=611;e.tcommaaccent=333;e.logicalnot=584;e.odieresis=611;e.udieresis=611;e.notequal=549;e.gcommaaccent=611;e.eth=611;e.zcaron=500;e.ncommaaccent=611;e.onesuperior=333;e.imacron=278;e.Euro=556}));e["Helvetica-BoldOblique"]=(0,r.getLookupTableFactory)((function(e){e.space=278;e.exclam=333;e.quotedbl=474;e.numbersign=556;e.dollar=556;e.percent=889;e.ampersand=722;e.quoteright=278;e.parenleft=333;e.parenright=333;e.asterisk=389;e.plus=584;e.comma=278;e.hyphen=333;e.period=278;e.slash=278;e.zero=556;e.one=556;e.two=556;e.three=556;e.four=556;e.five=556;e.six=556;e.seven=556;e.eight=556;e.nine=556;e.colon=333;e.semicolon=333;e.less=584;e.equal=584;e.greater=584;e.question=611;e.at=975;e.A=722;e.B=722;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=722;e.I=278;e.J=556;e.K=722;e.L=611;e.M=833;e.N=722;e.O=778;e.P=667;e.Q=778;e.R=722;e.S=667;e.T=611;e.U=722;e.V=667;e.W=944;e.X=667;e.Y=667;e.Z=611;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=584;e.underscore=556;e.quoteleft=278;e.a=556;e.b=611;e.c=556;e.d=611;e.e=556;e.f=333;e.g=611;e.h=611;e.i=278;e.j=278;e.k=556;e.l=278;e.m=889;e.n=611;e.o=611;e.p=611;e.q=611;e.r=389;e.s=556;e.t=333;e.u=611;e.v=556;e.w=778;e.x=556;e.y=556;e.z=500;e.braceleft=389;e.bar=280;e.braceright=389;e.asciitilde=584;e.exclamdown=333;e.cent=556;e.sterling=556;e.fraction=167;e.yen=556;e.florin=556;e.section=556;e.currency=556;e.quotesingle=238;e.quotedblleft=500;e.guillemotleft=556;e.guilsinglleft=333;e.guilsinglright=333;e.fi=611;e.fl=611;e.endash=556;e.dagger=556;e.daggerdbl=556;e.periodcentered=278;e.paragraph=556;e.bullet=350;e.quotesinglbase=278;e.quotedblbase=500;e.quotedblright=500;e.guillemotright=556;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=611;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=370;e.Lslash=611;e.Oslash=778;e.OE=1e3;e.ordmasculine=365;e.ae=889;e.dotlessi=278;e.lslash=278;e.oslash=611;e.oe=944;e.germandbls=611;e.Idieresis=278;e.eacute=556;e.abreve=556;e.uhungarumlaut=611;e.ecaron=556;e.Ydieresis=667;e.divide=584;e.Yacute=667;e.Acircumflex=722;e.aacute=556;e.Ucircumflex=722;e.yacute=556;e.scommaaccent=556;e.ecircumflex=556;e.Uring=722;e.Udieresis=722;e.aogonek=556;e.Uacute=722;e.uogonek=611;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=737;e.Emacron=667;e.ccaron=556;e.aring=556;e.Ncommaaccent=722;e.lacute=278;e.agrave=556;e.Tcommaaccent=611;e.Cacute=722;e.atilde=556;e.Edotaccent=667;e.scaron=556;e.scedilla=556;e.iacute=278;e.lozenge=494;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=611;e.acircumflex=556;e.Amacron=722;e.rcaron=389;e.ccedilla=556;e.Zdotaccent=611;e.Thorn=667;e.Omacron=778;e.Racute=722;e.Sacute=667;e.dcaron=743;e.Umacron=722;e.uring=611;e.threesuperior=333;e.Ograve=778;e.Agrave=722;e.Abreve=722;e.multiply=584;e.uacute=611;e.Tcaron=611;e.partialdiff=494;e.ydieresis=556;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=556;e.edieresis=556;e.cacute=556;e.nacute=611;e.umacron=611;e.Ncaron=722;e.Iacute=278;e.plusminus=584;e.brokenbar=280;e.registered=737;e.Gbreve=778;e.Idotaccent=278;e.summation=600;e.Egrave=667;e.racute=389;e.omacron=611;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=278;e.tcaron=389;e.eogonek=556;e.Uogonek=722;e.Aacute=722;e.Adieresis=722;e.egrave=556;e.zacute=500;e.iogonek=278;e.Oacute=778;e.oacute=611;e.amacron=556;e.sacute=556;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=611;e.twosuperior=333;e.Odieresis=778;e.mu=611;e.igrave=278;e.ohungarumlaut=611;e.Eogonek=667;e.dcroat=611;e.threequarters=834;e.Scedilla=667;e.lcaron=400;e.Kcommaaccent=722;e.Lacute=611;e.trademark=1e3;e.edotaccent=556;e.Igrave=278;e.Imacron=278;e.Lcaron=611;e.onehalf=834;e.lessequal=549;e.ocircumflex=611;e.ntilde=611;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=556;e.gbreve=611;e.onequarter=834;e.Scaron=667;e.Scommaaccent=667;e.Ohungarumlaut=778;e.degree=400;e.ograve=611;e.Ccaron=722;e.ugrave=611;e.radical=549;e.Dcaron=722;e.rcommaaccent=389;e.Ntilde=722;e.otilde=611;e.Rcommaaccent=722;e.Lcommaaccent=611;e.Atilde=722;e.Aogonek=722;e.Aring=722;e.Otilde=778;e.zdotaccent=500;e.Ecaron=667;e.Iogonek=278;e.kcommaaccent=556;e.minus=584;e.Icircumflex=278;e.ncaron=611;e.tcommaaccent=333;e.logicalnot=584;e.odieresis=611;e.udieresis=611;e.notequal=549;e.gcommaaccent=611;e.eth=611;e.zcaron=500;e.ncommaaccent=611;e.onesuperior=333;e.imacron=278;e.Euro=556}));e["Helvetica-Oblique"]=(0,r.getLookupTableFactory)((function(e){e.space=278;e.exclam=278;e.quotedbl=355;e.numbersign=556;e.dollar=556;e.percent=889;e.ampersand=667;e.quoteright=222;e.parenleft=333;e.parenright=333;e.asterisk=389;e.plus=584;e.comma=278;e.hyphen=333;e.period=278;e.slash=278;e.zero=556;e.one=556;e.two=556;e.three=556;e.four=556;e.five=556;e.six=556;e.seven=556;e.eight=556;e.nine=556;e.colon=278;e.semicolon=278;e.less=584;e.equal=584;e.greater=584;e.question=556;e.at=1015;e.A=667;e.B=667;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=722;e.I=278;e.J=500;e.K=667;e.L=556;e.M=833;e.N=722;e.O=778;e.P=667;e.Q=778;e.R=722;e.S=667;e.T=611;e.U=722;e.V=667;e.W=944;e.X=667;e.Y=667;e.Z=611;e.bracketleft=278;e.backslash=278;e.bracketright=278;e.asciicircum=469;e.underscore=556;e.quoteleft=222;e.a=556;e.b=556;e.c=500;e.d=556;e.e=556;e.f=278;e.g=556;e.h=556;e.i=222;e.j=222;e.k=500;e.l=222;e.m=833;e.n=556;e.o=556;e.p=556;e.q=556;e.r=333;e.s=500;e.t=278;e.u=556;e.v=500;e.w=722;e.x=500;e.y=500;e.z=500;e.braceleft=334;e.bar=260;e.braceright=334;e.asciitilde=584;e.exclamdown=333;e.cent=556;e.sterling=556;e.fraction=167;e.yen=556;e.florin=556;e.section=556;e.currency=556;e.quotesingle=191;e.quotedblleft=333;e.guillemotleft=556;e.guilsinglleft=333;e.guilsinglright=333;e.fi=500;e.fl=500;e.endash=556;e.dagger=556;e.daggerdbl=556;e.periodcentered=278;e.paragraph=537;e.bullet=350;e.quotesinglbase=222;e.quotedblbase=333;e.quotedblright=333;e.guillemotright=556;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=611;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=370;e.Lslash=556;e.Oslash=778;e.OE=1e3;e.ordmasculine=365;e.ae=889;e.dotlessi=278;e.lslash=222;e.oslash=611;e.oe=944;e.germandbls=611;e.Idieresis=278;e.eacute=556;e.abreve=556;e.uhungarumlaut=556;e.ecaron=556;e.Ydieresis=667;e.divide=584;e.Yacute=667;e.Acircumflex=667;e.aacute=556;e.Ucircumflex=722;e.yacute=500;e.scommaaccent=500;e.ecircumflex=556;e.Uring=722;e.Udieresis=722;e.aogonek=556;e.Uacute=722;e.uogonek=556;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=737;e.Emacron=667;e.ccaron=500;e.aring=556;e.Ncommaaccent=722;e.lacute=222;e.agrave=556;e.Tcommaaccent=611;e.Cacute=722;e.atilde=556;e.Edotaccent=667;e.scaron=500;e.scedilla=500;e.iacute=278;e.lozenge=471;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=556;e.acircumflex=556;e.Amacron=667;e.rcaron=333;e.ccedilla=500;e.Zdotaccent=611;e.Thorn=667;e.Omacron=778;e.Racute=722;e.Sacute=667;e.dcaron=643;e.Umacron=722;e.uring=556;e.threesuperior=333;e.Ograve=778;e.Agrave=667;e.Abreve=667;e.multiply=584;e.uacute=556;e.Tcaron=611;e.partialdiff=476;e.ydieresis=500;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=556;e.edieresis=556;e.cacute=500;e.nacute=556;e.umacron=556;e.Ncaron=722;e.Iacute=278;e.plusminus=584;e.brokenbar=260;e.registered=737;e.Gbreve=778;e.Idotaccent=278;e.summation=600;e.Egrave=667;e.racute=333;e.omacron=556;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=222;e.tcaron=317;e.eogonek=556;e.Uogonek=722;e.Aacute=667;e.Adieresis=667;e.egrave=556;e.zacute=500;e.iogonek=222;e.Oacute=778;e.oacute=556;e.amacron=556;e.sacute=500;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=556;e.twosuperior=333;e.Odieresis=778;e.mu=556;e.igrave=278;e.ohungarumlaut=556;e.Eogonek=667;e.dcroat=556;e.threequarters=834;e.Scedilla=667;e.lcaron=299;e.Kcommaaccent=667;e.Lacute=556;e.trademark=1e3;e.edotaccent=556;e.Igrave=278;e.Imacron=278;e.Lcaron=556;e.onehalf=834;e.lessequal=549;e.ocircumflex=556;e.ntilde=556;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=556;e.gbreve=556;e.onequarter=834;e.Scaron=667;e.Scommaaccent=667;e.Ohungarumlaut=778;e.degree=400;e.ograve=556;e.Ccaron=722;e.ugrave=556;e.radical=453;e.Dcaron=722;e.rcommaaccent=333;e.Ntilde=722;e.otilde=556;e.Rcommaaccent=722;e.Lcommaaccent=556;e.Atilde=667;e.Aogonek=667;e.Aring=667;e.Otilde=778;e.zdotaccent=500;e.Ecaron=667;e.Iogonek=278;e.kcommaaccent=500;e.minus=584;e.Icircumflex=278;e.ncaron=556;e.tcommaaccent=278;e.logicalnot=584;e.odieresis=556;e.udieresis=556;e.notequal=549;e.gcommaaccent=556;e.eth=556;e.zcaron=500;e.ncommaaccent=556;e.onesuperior=333;e.imacron=278;e.Euro=556}));e.Symbol=(0,r.getLookupTableFactory)((function(e){e.space=250;e.exclam=333;e.universal=713;e.numbersign=500;e.existential=549;e.percent=833;e.ampersand=778;e.suchthat=439;e.parenleft=333;e.parenright=333;e.asteriskmath=500;e.plus=549;e.comma=250;e.minus=549;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=278;e.semicolon=278;e.less=549;e.equal=549;e.greater=549;e.question=444;e.congruent=549;e.Alpha=722;e.Beta=667;e.Chi=722;e.Delta=612;e.Epsilon=611;e.Phi=763;e.Gamma=603;e.Eta=722;e.Iota=333;e.theta1=631;e.Kappa=722;e.Lambda=686;e.Mu=889;e.Nu=722;e.Omicron=722;e.Pi=768;e.Theta=741;e.Rho=556;e.Sigma=592;e.Tau=611;e.Upsilon=690;e.sigma1=439;e.Omega=768;e.Xi=645;e.Psi=795;e.Zeta=611;e.bracketleft=333;e.therefore=863;e.bracketright=333;e.perpendicular=658;e.underscore=500;e.radicalex=500;e.alpha=631;e.beta=549;e.chi=549;e.delta=494;e.epsilon=439;e.phi=521;e.gamma=411;e.eta=603;e.iota=329;e.phi1=603;e.kappa=549;e.lambda=549;e.mu=576;e.nu=521;e.omicron=549;e.pi=549;e.theta=521;e.rho=549;e.sigma=603;e.tau=439;e.upsilon=576;e.omega1=713;e.omega=686;e.xi=493;e.psi=686;e.zeta=494;e.braceleft=480;e.bar=200;e.braceright=480;e.similar=549;e.Euro=750;e.Upsilon1=620;e.minute=247;e.lessequal=549;e.fraction=167;e.infinity=713;e.florin=500;e.club=753;e.diamond=753;e.heart=753;e.spade=753;e.arrowboth=1042;e.arrowleft=987;e.arrowup=603;e.arrowright=987;e.arrowdown=603;e.degree=400;e.plusminus=549;e.second=411;e.greaterequal=549;e.multiply=549;e.proportional=713;e.partialdiff=494;e.bullet=460;e.divide=549;e.notequal=549;e.equivalence=549;e.approxequal=549;e.ellipsis=1e3;e.arrowvertex=603;e.arrowhorizex=1e3;e.carriagereturn=658;e.aleph=823;e.Ifraktur=686;e.Rfraktur=795;e.weierstrass=987;e.circlemultiply=768;e.circleplus=768;e.emptyset=823;e.intersection=768;e.union=768;e.propersuperset=713;e.reflexsuperset=713;e.notsubset=713;e.propersubset=713;e.reflexsubset=713;e.element=713;e.notelement=713;e.angle=768;e.gradient=713;e.registerserif=790;e.copyrightserif=790;e.trademarkserif=890;e.product=823;e.radical=549;e.dotmath=250;e.logicalnot=713;e.logicaland=603;e.logicalor=603;e.arrowdblboth=1042;e.arrowdblleft=987;e.arrowdblup=603;e.arrowdblright=987;e.arrowdbldown=603;e.lozenge=494;e.angleleft=329;e.registersans=790;e.copyrightsans=790;e.trademarksans=786;e.summation=713;e.parenlefttp=384;e.parenleftex=384;e.parenleftbt=384;e.bracketlefttp=384;e.bracketleftex=384;e.bracketleftbt=384;e.bracelefttp=494;e.braceleftmid=494;e.braceleftbt=494;e.braceex=494;e.angleright=329;e.integral=274;e.integraltp=686;e.integralex=686;e.integralbt=686;e.parenrighttp=384;e.parenrightex=384;e.parenrightbt=384;e.bracketrighttp=384;e.bracketrightex=384;e.bracketrightbt=384;e.bracerighttp=494;e.bracerightmid=494;e.bracerightbt=494;e.apple=790}));e["Times-Roman"]=(0,r.getLookupTableFactory)((function(e){e.space=250;e.exclam=333;e.quotedbl=408;e.numbersign=500;e.dollar=500;e.percent=833;e.ampersand=778;e.quoteright=333;e.parenleft=333;e.parenright=333;e.asterisk=500;e.plus=564;e.comma=250;e.hyphen=333;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=278;e.semicolon=278;e.less=564;e.equal=564;e.greater=564;e.question=444;e.at=921;e.A=722;e.B=667;e.C=667;e.D=722;e.E=611;e.F=556;e.G=722;e.H=722;e.I=333;e.J=389;e.K=722;e.L=611;e.M=889;e.N=722;e.O=722;e.P=556;e.Q=722;e.R=667;e.S=556;e.T=611;e.U=722;e.V=722;e.W=944;e.X=722;e.Y=722;e.Z=611;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=469;e.underscore=500;e.quoteleft=333;e.a=444;e.b=500;e.c=444;e.d=500;e.e=444;e.f=333;e.g=500;e.h=500;e.i=278;e.j=278;e.k=500;e.l=278;e.m=778;e.n=500;e.o=500;e.p=500;e.q=500;e.r=333;e.s=389;e.t=278;e.u=500;e.v=500;e.w=722;e.x=500;e.y=500;e.z=444;e.braceleft=480;e.bar=200;e.braceright=480;e.asciitilde=541;e.exclamdown=333;e.cent=500;e.sterling=500;e.fraction=167;e.yen=500;e.florin=500;e.section=500;e.currency=500;e.quotesingle=180;e.quotedblleft=444;e.guillemotleft=500;e.guilsinglleft=333;e.guilsinglright=333;e.fi=556;e.fl=556;e.endash=500;e.dagger=500;e.daggerdbl=500;e.periodcentered=250;e.paragraph=453;e.bullet=350;e.quotesinglbase=333;e.quotedblbase=444;e.quotedblright=444;e.guillemotright=500;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=444;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=889;e.ordfeminine=276;e.Lslash=611;e.Oslash=722;e.OE=889;e.ordmasculine=310;e.ae=667;e.dotlessi=278;e.lslash=278;e.oslash=500;e.oe=722;e.germandbls=500;e.Idieresis=333;e.eacute=444;e.abreve=444;e.uhungarumlaut=500;e.ecaron=444;e.Ydieresis=722;e.divide=564;e.Yacute=722;e.Acircumflex=722;e.aacute=444;e.Ucircumflex=722;e.yacute=500;e.scommaaccent=389;e.ecircumflex=444;e.Uring=722;e.Udieresis=722;e.aogonek=444;e.Uacute=722;e.uogonek=500;e.Edieresis=611;e.Dcroat=722;e.commaaccent=250;e.copyright=760;e.Emacron=611;e.ccaron=444;e.aring=444;e.Ncommaaccent=722;e.lacute=278;e.agrave=444;e.Tcommaaccent=611;e.Cacute=667;e.atilde=444;e.Edotaccent=611;e.scaron=389;e.scedilla=389;e.iacute=278;e.lozenge=471;e.Rcaron=667;e.Gcommaaccent=722;e.ucircumflex=500;e.acircumflex=444;e.Amacron=722;e.rcaron=333;e.ccedilla=444;e.Zdotaccent=611;e.Thorn=556;e.Omacron=722;e.Racute=667;e.Sacute=556;e.dcaron=588;e.Umacron=722;e.uring=500;e.threesuperior=300;e.Ograve=722;e.Agrave=722;e.Abreve=722;e.multiply=564;e.uacute=500;e.Tcaron=611;e.partialdiff=476;e.ydieresis=500;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=611;e.adieresis=444;e.edieresis=444;e.cacute=444;e.nacute=500;e.umacron=500;e.Ncaron=722;e.Iacute=333;e.plusminus=564;e.brokenbar=200;e.registered=760;e.Gbreve=722;e.Idotaccent=333;e.summation=600;e.Egrave=611;e.racute=333;e.omacron=500;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=667;e.lcommaaccent=278;e.tcaron=326;e.eogonek=444;e.Uogonek=722;e.Aacute=722;e.Adieresis=722;e.egrave=444;e.zacute=444;e.iogonek=278;e.Oacute=722;e.oacute=500;e.amacron=444;e.sacute=389;e.idieresis=278;e.Ocircumflex=722;e.Ugrave=722;e.Delta=612;e.thorn=500;e.twosuperior=300;e.Odieresis=722;e.mu=500;e.igrave=278;e.ohungarumlaut=500;e.Eogonek=611;e.dcroat=500;e.threequarters=750;e.Scedilla=556;e.lcaron=344;e.Kcommaaccent=722;e.Lacute=611;e.trademark=980;e.edotaccent=444;e.Igrave=333;e.Imacron=333;e.Lcaron=611;e.onehalf=750;e.lessequal=549;e.ocircumflex=500;e.ntilde=500;e.Uhungarumlaut=722;e.Eacute=611;e.emacron=444;e.gbreve=500;e.onequarter=750;e.Scaron=556;e.Scommaaccent=556;e.Ohungarumlaut=722;e.degree=400;e.ograve=500;e.Ccaron=667;e.ugrave=500;e.radical=453;e.Dcaron=722;e.rcommaaccent=333;e.Ntilde=722;e.otilde=500;e.Rcommaaccent=667;e.Lcommaaccent=611;e.Atilde=722;e.Aogonek=722;e.Aring=722;e.Otilde=722;e.zdotaccent=444;e.Ecaron=611;e.Iogonek=333;e.kcommaaccent=500;e.minus=564;e.Icircumflex=333;e.ncaron=500;e.tcommaaccent=278;e.logicalnot=564;e.odieresis=500;e.udieresis=500;e.notequal=549;e.gcommaaccent=500;e.eth=500;e.zcaron=444;e.ncommaaccent=500;e.onesuperior=300;e.imacron=278;e.Euro=500}));e["Times-Bold"]=(0,r.getLookupTableFactory)((function(e){e.space=250;e.exclam=333;e.quotedbl=555;e.numbersign=500;e.dollar=500;e.percent=1e3;e.ampersand=833;e.quoteright=333;e.parenleft=333;e.parenright=333;e.asterisk=500;e.plus=570;e.comma=250;e.hyphen=333;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=333;e.semicolon=333;e.less=570;e.equal=570;e.greater=570;e.question=500;e.at=930;e.A=722;e.B=667;e.C=722;e.D=722;e.E=667;e.F=611;e.G=778;e.H=778;e.I=389;e.J=500;e.K=778;e.L=667;e.M=944;e.N=722;e.O=778;e.P=611;e.Q=778;e.R=722;e.S=556;e.T=667;e.U=722;e.V=722;e.W=1e3;e.X=722;e.Y=722;e.Z=667;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=581;e.underscore=500;e.quoteleft=333;e.a=500;e.b=556;e.c=444;e.d=556;e.e=444;e.f=333;e.g=500;e.h=556;e.i=278;e.j=333;e.k=556;e.l=278;e.m=833;e.n=556;e.o=500;e.p=556;e.q=556;e.r=444;e.s=389;e.t=333;e.u=556;e.v=500;e.w=722;e.x=500;e.y=500;e.z=444;e.braceleft=394;e.bar=220;e.braceright=394;e.asciitilde=520;e.exclamdown=333;e.cent=500;e.sterling=500;e.fraction=167;e.yen=500;e.florin=500;e.section=500;e.currency=500;e.quotesingle=278;e.quotedblleft=500;e.guillemotleft=500;e.guilsinglleft=333;e.guilsinglright=333;e.fi=556;e.fl=556;e.endash=500;e.dagger=500;e.daggerdbl=500;e.periodcentered=250;e.paragraph=540;e.bullet=350;e.quotesinglbase=333;e.quotedblbase=500;e.quotedblright=500;e.guillemotright=500;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=500;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=1e3;e.ordfeminine=300;e.Lslash=667;e.Oslash=778;e.OE=1e3;e.ordmasculine=330;e.ae=722;e.dotlessi=278;e.lslash=278;e.oslash=500;e.oe=722;e.germandbls=556;e.Idieresis=389;e.eacute=444;e.abreve=500;e.uhungarumlaut=556;e.ecaron=444;e.Ydieresis=722;e.divide=570;e.Yacute=722;e.Acircumflex=722;e.aacute=500;e.Ucircumflex=722;e.yacute=500;e.scommaaccent=389;e.ecircumflex=444;e.Uring=722;e.Udieresis=722;e.aogonek=500;e.Uacute=722;e.uogonek=556;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=747;e.Emacron=667;e.ccaron=444;e.aring=500;e.Ncommaaccent=722;e.lacute=278;e.agrave=500;e.Tcommaaccent=667;e.Cacute=722;e.atilde=500;e.Edotaccent=667;e.scaron=389;e.scedilla=389;e.iacute=278;e.lozenge=494;e.Rcaron=722;e.Gcommaaccent=778;e.ucircumflex=556;e.acircumflex=500;e.Amacron=722;e.rcaron=444;e.ccedilla=444;e.Zdotaccent=667;e.Thorn=611;e.Omacron=778;e.Racute=722;e.Sacute=556;e.dcaron=672;e.Umacron=722;e.uring=556;e.threesuperior=300;e.Ograve=778;e.Agrave=722;e.Abreve=722;e.multiply=570;e.uacute=556;e.Tcaron=667;e.partialdiff=494;e.ydieresis=500;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=500;e.edieresis=444;e.cacute=444;e.nacute=556;e.umacron=556;e.Ncaron=722;e.Iacute=389;e.plusminus=570;e.brokenbar=220;e.registered=747;e.Gbreve=778;e.Idotaccent=389;e.summation=600;e.Egrave=667;e.racute=444;e.omacron=500;e.Zacute=667;e.Zcaron=667;e.greaterequal=549;e.Eth=722;e.Ccedilla=722;e.lcommaaccent=278;e.tcaron=416;e.eogonek=444;e.Uogonek=722;e.Aacute=722;e.Adieresis=722;e.egrave=444;e.zacute=444;e.iogonek=278;e.Oacute=778;e.oacute=500;e.amacron=500;e.sacute=389;e.idieresis=278;e.Ocircumflex=778;e.Ugrave=722;e.Delta=612;e.thorn=556;e.twosuperior=300;e.Odieresis=778;e.mu=556;e.igrave=278;e.ohungarumlaut=500;e.Eogonek=667;e.dcroat=556;e.threequarters=750;e.Scedilla=556;e.lcaron=394;e.Kcommaaccent=778;e.Lacute=667;e.trademark=1e3;e.edotaccent=444;e.Igrave=389;e.Imacron=389;e.Lcaron=667;e.onehalf=750;e.lessequal=549;e.ocircumflex=500;e.ntilde=556;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=444;e.gbreve=500;e.onequarter=750;e.Scaron=556;e.Scommaaccent=556;e.Ohungarumlaut=778;e.degree=400;e.ograve=500;e.Ccaron=722;e.ugrave=556;e.radical=549;e.Dcaron=722;e.rcommaaccent=444;e.Ntilde=722;e.otilde=500;e.Rcommaaccent=722;e.Lcommaaccent=667;e.Atilde=722;e.Aogonek=722;e.Aring=722;e.Otilde=778;e.zdotaccent=444;e.Ecaron=667;e.Iogonek=389;e.kcommaaccent=556;e.minus=570;e.Icircumflex=389;e.ncaron=556;e.tcommaaccent=333;e.logicalnot=570;e.odieresis=500;e.udieresis=556;e.notequal=549;e.gcommaaccent=500;e.eth=500;e.zcaron=444;e.ncommaaccent=556;e.onesuperior=300;e.imacron=278;e.Euro=500}));e["Times-BoldItalic"]=(0,r.getLookupTableFactory)((function(e){e.space=250;e.exclam=389;e.quotedbl=555;e.numbersign=500;e.dollar=500;e.percent=833;e.ampersand=778;e.quoteright=333;e.parenleft=333;e.parenright=333;e.asterisk=500;e.plus=570;e.comma=250;e.hyphen=333;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=333;e.semicolon=333;e.less=570;e.equal=570;e.greater=570;e.question=500;e.at=832;e.A=667;e.B=667;e.C=667;e.D=722;e.E=667;e.F=667;e.G=722;e.H=778;e.I=389;e.J=500;e.K=667;e.L=611;e.M=889;e.N=722;e.O=722;e.P=611;e.Q=722;e.R=667;e.S=556;e.T=611;e.U=722;e.V=667;e.W=889;e.X=667;e.Y=611;e.Z=611;e.bracketleft=333;e.backslash=278;e.bracketright=333;e.asciicircum=570;e.underscore=500;e.quoteleft=333;e.a=500;e.b=500;e.c=444;e.d=500;e.e=444;e.f=333;e.g=500;e.h=556;e.i=278;e.j=278;e.k=500;e.l=278;e.m=778;e.n=556;e.o=500;e.p=500;e.q=500;e.r=389;e.s=389;e.t=278;e.u=556;e.v=444;e.w=667;e.x=500;e.y=444;e.z=389;e.braceleft=348;e.bar=220;e.braceright=348;e.asciitilde=570;e.exclamdown=389;e.cent=500;e.sterling=500;e.fraction=167;e.yen=500;e.florin=500;e.section=500;e.currency=500;e.quotesingle=278;e.quotedblleft=500;e.guillemotleft=500;e.guilsinglleft=333;e.guilsinglright=333;e.fi=556;e.fl=556;e.endash=500;e.dagger=500;e.daggerdbl=500;e.periodcentered=250;e.paragraph=500;e.bullet=350;e.quotesinglbase=333;e.quotedblbase=500;e.quotedblright=500;e.guillemotright=500;e.ellipsis=1e3;e.perthousand=1e3;e.questiondown=500;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=1e3;e.AE=944;e.ordfeminine=266;e.Lslash=611;e.Oslash=722;e.OE=944;e.ordmasculine=300;e.ae=722;e.dotlessi=278;e.lslash=278;e.oslash=500;e.oe=722;e.germandbls=500;e.Idieresis=389;e.eacute=444;e.abreve=500;e.uhungarumlaut=556;e.ecaron=444;e.Ydieresis=611;e.divide=570;e.Yacute=611;e.Acircumflex=667;e.aacute=500;e.Ucircumflex=722;e.yacute=444;e.scommaaccent=389;e.ecircumflex=444;e.Uring=722;e.Udieresis=722;e.aogonek=500;e.Uacute=722;e.uogonek=556;e.Edieresis=667;e.Dcroat=722;e.commaaccent=250;e.copyright=747;e.Emacron=667;e.ccaron=444;e.aring=500;e.Ncommaaccent=722;e.lacute=278;e.agrave=500;e.Tcommaaccent=611;e.Cacute=667;e.atilde=500;e.Edotaccent=667;e.scaron=389;e.scedilla=389;e.iacute=278;e.lozenge=494;e.Rcaron=667;e.Gcommaaccent=722;e.ucircumflex=556;e.acircumflex=500;e.Amacron=667;e.rcaron=389;e.ccedilla=444;e.Zdotaccent=611;e.Thorn=611;e.Omacron=722;e.Racute=667;e.Sacute=556;e.dcaron=608;e.Umacron=722;e.uring=556;e.threesuperior=300;e.Ograve=722;e.Agrave=667;e.Abreve=667;e.multiply=570;e.uacute=556;e.Tcaron=611;e.partialdiff=494;e.ydieresis=444;e.Nacute=722;e.icircumflex=278;e.Ecircumflex=667;e.adieresis=500;e.edieresis=444;e.cacute=444;e.nacute=556;e.umacron=556;e.Ncaron=722;e.Iacute=389;e.plusminus=570;e.brokenbar=220;e.registered=747;e.Gbreve=722;e.Idotaccent=389;e.summation=600;e.Egrave=667;e.racute=389;e.omacron=500;e.Zacute=611;e.Zcaron=611;e.greaterequal=549;e.Eth=722;e.Ccedilla=667;e.lcommaaccent=278;e.tcaron=366;e.eogonek=444;e.Uogonek=722;e.Aacute=667;e.Adieresis=667;e.egrave=444;e.zacute=389;e.iogonek=278;e.Oacute=722;e.oacute=500;e.amacron=500;e.sacute=389;e.idieresis=278;e.Ocircumflex=722;e.Ugrave=722;e.Delta=612;e.thorn=500;e.twosuperior=300;e.Odieresis=722;e.mu=576;e.igrave=278;e.ohungarumlaut=500;e.Eogonek=667;e.dcroat=500;e.threequarters=750;e.Scedilla=556;e.lcaron=382;e.Kcommaaccent=667;e.Lacute=611;e.trademark=1e3;e.edotaccent=444;e.Igrave=389;e.Imacron=389;e.Lcaron=611;e.onehalf=750;e.lessequal=549;e.ocircumflex=500;e.ntilde=556;e.Uhungarumlaut=722;e.Eacute=667;e.emacron=444;e.gbreve=500;e.onequarter=750;e.Scaron=556;e.Scommaaccent=556;e.Ohungarumlaut=722;e.degree=400;e.ograve=500;e.Ccaron=667;e.ugrave=556;e.radical=549;e.Dcaron=722;e.rcommaaccent=389;e.Ntilde=722;e.otilde=500;e.Rcommaaccent=667;e.Lcommaaccent=611;e.Atilde=667;e.Aogonek=667;e.Aring=667;e.Otilde=722;e.zdotaccent=389;e.Ecaron=667;e.Iogonek=389;e.kcommaaccent=500;e.minus=606;e.Icircumflex=389;e.ncaron=556;e.tcommaaccent=278;e.logicalnot=606;e.odieresis=500;e.udieresis=556;e.notequal=549;e.gcommaaccent=500;e.eth=500;e.zcaron=389;e.ncommaaccent=556;e.onesuperior=300;e.imacron=278;e.Euro=500}));e["Times-Italic"]=(0,r.getLookupTableFactory)((function(e){e.space=250;e.exclam=333;e.quotedbl=420;e.numbersign=500;e.dollar=500;e.percent=833;e.ampersand=778;e.quoteright=333;e.parenleft=333;e.parenright=333;e.asterisk=500;e.plus=675;e.comma=250;e.hyphen=333;e.period=250;e.slash=278;e.zero=500;e.one=500;e.two=500;e.three=500;e.four=500;e.five=500;e.six=500;e.seven=500;e.eight=500;e.nine=500;e.colon=333;e.semicolon=333;e.less=675;e.equal=675;e.greater=675;e.question=500;e.at=920;e.A=611;e.B=611;e.C=667;e.D=722;e.E=611;e.F=611;e.G=722;e.H=722;e.I=333;e.J=444;e.K=667;e.L=556;e.M=833;e.N=667;e.O=722;e.P=611;e.Q=722;e.R=611;e.S=500;e.T=556;e.U=722;e.V=611;e.W=833;e.X=611;e.Y=556;e.Z=556;e.bracketleft=389;e.backslash=278;e.bracketright=389;e.asciicircum=422;e.underscore=500;e.quoteleft=333;e.a=500;e.b=500;e.c=444;e.d=500;e.e=444;e.f=278;e.g=500;e.h=500;e.i=278;e.j=278;e.k=444;e.l=278;e.m=722;e.n=500;e.o=500;e.p=500;e.q=500;e.r=389;e.s=389;e.t=278;e.u=500;e.v=444;e.w=667;e.x=444;e.y=444;e.z=389;e.braceleft=400;e.bar=275;e.braceright=400;e.asciitilde=541;e.exclamdown=389;e.cent=500;e.sterling=500;e.fraction=167;e.yen=500;e.florin=500;e.section=500;e.currency=500;e.quotesingle=214;e.quotedblleft=556;e.guillemotleft=500;e.guilsinglleft=333;e.guilsinglright=333;e.fi=500;e.fl=500;e.endash=500;e.dagger=500;e.daggerdbl=500;e.periodcentered=250;e.paragraph=523;e.bullet=350;e.quotesinglbase=333;e.quotedblbase=556;e.quotedblright=556;e.guillemotright=500;e.ellipsis=889;e.perthousand=1e3;e.questiondown=500;e.grave=333;e.acute=333;e.circumflex=333;e.tilde=333;e.macron=333;e.breve=333;e.dotaccent=333;e.dieresis=333;e.ring=333;e.cedilla=333;e.hungarumlaut=333;e.ogonek=333;e.caron=333;e.emdash=889;e.AE=889;e.ordfeminine=276;e.Lslash=556;e.Oslash=722;e.OE=944;e.ordmasculine=310;e.ae=667;e.dotlessi=278;e.lslash=278;e.oslash=500;e.oe=667;e.germandbls=500;e.Idieresis=333;e.eacute=444;e.abreve=500;e.uhungarumlaut=500;e.ecaron=444;e.Ydieresis=556;e.divide=675;e.Yacute=556;e.Acircumflex=611;e.aacute=500;e.Ucircumflex=722;e.yacute=444;e.scommaaccent=389;e.ecircumflex=444;e.Uring=722;e.Udieresis=722;e.aogonek=500;e.Uacute=722;e.uogonek=500;e.Edieresis=611;e.Dcroat=722;e.commaaccent=250;e.copyright=760;e.Emacron=611;e.ccaron=444;e.aring=500;e.Ncommaaccent=667;e.lacute=278;e.agrave=500;e.Tcommaaccent=556;e.Cacute=667;e.atilde=500;e.Edotaccent=611;e.scaron=389;e.scedilla=389;e.iacute=278;e.lozenge=471;e.Rcaron=611;e.Gcommaaccent=722;e.ucircumflex=500;e.acircumflex=500;e.Amacron=611;e.rcaron=389;e.ccedilla=444;e.Zdotaccent=556;e.Thorn=611;e.Omacron=722;e.Racute=611;e.Sacute=500;e.dcaron=544;e.Umacron=722;e.uring=500;e.threesuperior=300;e.Ograve=722;e.Agrave=611;e.Abreve=611;e.multiply=675;e.uacute=500;e.Tcaron=556;e.partialdiff=476;e.ydieresis=444;e.Nacute=667;e.icircumflex=278;e.Ecircumflex=611;e.adieresis=500;e.edieresis=444;e.cacute=444;e.nacute=500;e.umacron=500;e.Ncaron=667;e.Iacute=333;e.plusminus=675;e.brokenbar=275;e.registered=760;e.Gbreve=722;e.Idotaccent=333;e.summation=600;e.Egrave=611;e.racute=389;e.omacron=500;e.Zacute=556;e.Zcaron=556;e.greaterequal=549;e.Eth=722;e.Ccedilla=667;e.lcommaaccent=278;e.tcaron=300;e.eogonek=444;e.Uogonek=722;e.Aacute=611;e.Adieresis=611;e.egrave=444;e.zacute=389;e.iogonek=278;e.Oacute=722;e.oacute=500;e.amacron=500;e.sacute=389;e.idieresis=278;e.Ocircumflex=722;e.Ugrave=722;e.Delta=612;e.thorn=500;e.twosuperior=300;e.Odieresis=722;e.mu=500;e.igrave=278;e.ohungarumlaut=500;e.Eogonek=611;e.dcroat=500;e.threequarters=750;e.Scedilla=500;e.lcaron=300;e.Kcommaaccent=667;e.Lacute=556;e.trademark=980;e.edotaccent=444;e.Igrave=333;e.Imacron=333;e.Lcaron=611;e.onehalf=750;e.lessequal=549;e.ocircumflex=500;e.ntilde=500;e.Uhungarumlaut=722;e.Eacute=611;e.emacron=444;e.gbreve=500;e.onequarter=750;e.Scaron=500;e.Scommaaccent=500;e.Ohungarumlaut=722;e.degree=400;e.ograve=500;e.Ccaron=667;e.ugrave=500;e.radical=453;e.Dcaron=722;e.rcommaaccent=389;e.Ntilde=667;e.otilde=500;e.Rcommaaccent=611;e.Lcommaaccent=556;e.Atilde=611;e.Aogonek=611;e.Aring=611;e.Otilde=722;e.zdotaccent=389;e.Ecaron=611;e.Iogonek=333;e.kcommaaccent=444;e.minus=675;e.Icircumflex=333;e.ncaron=500;e.tcommaaccent=278;e.logicalnot=675;e.odieresis=500;e.udieresis=500;e.notequal=549;e.gcommaaccent=500;e.eth=500;e.zcaron=389;e.ncommaaccent=500;e.onesuperior=300;e.imacron=278;e.Euro=500}));e.ZapfDingbats=(0,r.getLookupTableFactory)((function(e){e.space=278;e.a1=974;e.a2=961;e.a202=974;e.a3=980;e.a4=719;e.a5=789;e.a119=790;e.a118=791;e.a117=690;e.a11=960;e.a12=939;e.a13=549;e.a14=855;e.a15=911;e.a16=933;e.a105=911;e.a17=945;e.a18=974;e.a19=755;e.a20=846;e.a21=762;e.a22=761;e.a23=571;e.a24=677;e.a25=763;e.a26=760;e.a27=759;e.a28=754;e.a6=494;e.a7=552;e.a8=537;e.a9=577;e.a10=692;e.a29=786;e.a30=788;e.a31=788;e.a32=790;e.a33=793;e.a34=794;e.a35=816;e.a36=823;e.a37=789;e.a38=841;e.a39=823;e.a40=833;e.a41=816;e.a42=831;e.a43=923;e.a44=744;e.a45=723;e.a46=749;e.a47=790;e.a48=792;e.a49=695;e.a50=776;e.a51=768;e.a52=792;e.a53=759;e.a54=707;e.a55=708;e.a56=682;e.a57=701;e.a58=826;e.a59=815;e.a60=789;e.a61=789;e.a62=707;e.a63=687;e.a64=696;e.a65=689;e.a66=786;e.a67=787;e.a68=713;e.a69=791;e.a70=785;e.a71=791;e.a72=873;e.a73=761;e.a74=762;e.a203=762;e.a75=759;e.a204=759;e.a76=892;e.a77=892;e.a78=788;e.a79=784;e.a81=438;e.a82=138;e.a83=277;e.a84=415;e.a97=392;e.a98=392;e.a99=668;e.a100=668;e.a89=390;e.a90=390;e.a93=317;e.a94=317;e.a91=276;e.a92=276;e.a205=509;e.a85=509;e.a206=410;e.a86=410;e.a87=234;e.a88=234;e.a95=334;e.a96=334;e.a101=732;e.a102=544;e.a103=544;e.a104=910;e.a106=667;e.a107=760;e.a108=760;e.a112=776;e.a111=595;e.a110=694;e.a109=626;e.a120=788;e.a121=788;e.a122=788;e.a123=788;e.a124=788;e.a125=788;e.a126=788;e.a127=788;e.a128=788;e.a129=788;e.a130=788;e.a131=788;e.a132=788;e.a133=788;e.a134=788;e.a135=788;e.a136=788;e.a137=788;e.a138=788;e.a139=788;e.a140=788;e.a141=788;e.a142=788;e.a143=788;e.a144=788;e.a145=788;e.a146=788;e.a147=788;e.a148=788;e.a149=788;e.a150=788;e.a151=788;e.a152=788;e.a153=788;e.a154=788;e.a155=788;e.a156=788;e.a157=788;e.a158=788;e.a159=788;e.a160=894;e.a161=838;e.a163=1016;e.a164=458;e.a196=748;e.a165=924;e.a192=748;e.a166=918;e.a167=927;e.a168=928;e.a169=928;e.a170=834;e.a171=873;e.a172=828;e.a173=924;e.a162=924;e.a174=917;e.a175=930;e.a176=931;e.a177=463;e.a178=883;e.a179=836;e.a193=836;e.a180=867;e.a199=867;e.a181=696;e.a200=696;e.a182=874;e.a201=874;e.a183=760;e.a184=946;e.a197=771;e.a185=865;e.a194=771;e.a198=888;e.a186=967;e.a195=888;e.a187=831;e.a188=873;e.a189=927;e.a190=970;e.a191=918}))}));t.getMetrics=i},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.isPDFFunction=function(e){var t;if("object"!=typeof e)return!1;if((0,i.isDict)(e))t=e;else{if(!(0,i.isStream)(e))return!1;t=e.dict}return t.has("FunctionType")};t.PostScriptCompiler=t.PostScriptEvaluator=t.PDFFunctionFactory=void 0;var r=a(2),i=a(4),n=a(40);t.PDFFunctionFactory=class{constructor({xref:e,isEvalSupported:t=!0}){this.xref=e;this.isEvalSupported=!1!==t}create(e){return o.parse({xref:this.xref,isEvalSupported:this.isEvalSupported,fn:e})}createFromArray(e){return o.parseArray({xref:this.xref,isEvalSupported:this.isEvalSupported,fnObj:e})}};function s(e){if(!Array.isArray(e))return null;const t=e.length;for(let a=0;a<t;a++)if("number"!=typeof e[a]){const a=new Array(t);for(let r=0;r<t;r++)a[r]=+e[r];return a}return e}var o={getSampleArray(e,t,a,r){var i,n,s=1;for(i=0,n=e.length;i<n;i++)s*=e[i];s*=t;var o=new Array(s),c=0,l=0,h=1/(2**a-1),u=r.getBytes((s*a+7)/8),d=0;for(i=0;i<s;i++){for(;c<a;){l<<=8;l|=u[d++];c+=8}c-=a;o[i]=(l>>c)*h;l&=(1<<c)-1}return o},getIR({xref:e,isEvalSupported:t,fn:a}){var i=a.dict;i||(i=a);var n=[this.constructSampled,null,this.constructInterpolated,this.constructStiched,this.constructPostScript][i.get("FunctionType")];if(!n)throw new r.FormatError("Unknown type of function");return n.call(this,{xref:e,isEvalSupported:t,fn:a,dict:i})},fromIR({xref:e,isEvalSupported:t,IR:a}){switch(a[0]){case 0:return this.constructSampledFromIR({xref:e,isEvalSupported:t,IR:a});case 2:return this.constructInterpolatedFromIR({xref:e,isEvalSupported:t,IR:a});case 3:return this.constructStichedFromIR({xref:e,isEvalSupported:t,IR:a});default:return this.constructPostScriptFromIR({xref:e,isEvalSupported:t,IR:a})}},parse({xref:e,isEvalSupported:t,fn:a}){const r=this.getIR({xref:e,isEvalSupported:t,fn:a});return this.fromIR({xref:e,isEvalSupported:t,IR:r})},parseArray({xref:e,isEvalSupported:t,fnObj:a}){if(!Array.isArray(a))return this.parse({xref:e,isEvalSupported:t,fn:a});for(var r=[],i=0,n=a.length;i<n;i++)r.push(this.parse({xref:e,isEvalSupported:t,fn:e.fetchIfRef(a[i])}));return function(e,t,a,i){for(var n=0,s=r.length;n<s;n++)r[n](e,t,a,i+n)}},constructSampled({xref:e,isEvalSupported:t,fn:a,dict:i}){function n(e){for(var t=e.length,a=[],r=0,i=0;i<t;i+=2){a[r]=[e[i],e[i+1]];++r}return a}var o=s(i.getArray("Domain")),c=s(i.getArray("Range"));if(!o||!c)throw new r.FormatError("No domain or range");var l=o.length/2,h=c.length/2;o=n(o);c=n(c);var u=s(i.getArray("Size")),d=i.get("BitsPerSample"),f=i.get("Order")||1;1!==f&&(0,r.info)("No support for cubic spline interpolation: "+f);var g=s(i.getArray("Encode"));if(g)g=n(g);else{g=[];for(var m=0;m<l;++m)g.push([0,u[m]-1])}var p=s(i.getArray("Decode"));return[0,l,o,g,p=p?n(p):c,this.getSampleArray(u,h,d,a),u,h,2**d-1,c]},constructSampledFromIR({xref:e,isEvalSupported:t,IR:a}){function r(e,t,a,r,i){return r+(i-r)/(a-t)*(e-t)}return function(e,t,i,n){var s,o,c=a[1],l=a[2],h=a[3],u=a[4],d=a[5],f=a[6],g=a[7],m=a[9],p=1<<c,b=new Float64Array(p),y=new Uint32Array(p);for(o=0;o<p;o++)b[o]=1;var v=g,w=1;for(s=0;s<c;++s){var k=l[s][0],S=l[s][1],C=r(Math.min(Math.max(e[t+s],k),S),k,S,h[s][0],h[s][1]),x=f[s],A=(C=Math.min(Math.max(C,0),x-1))<x-1?Math.floor(C):C-1,I=A+1-C,F=C-A,T=A*v,E=T+v;for(o=0;o<p;o++)if(o&w){b[o]*=F;y[o]+=E}else{b[o]*=I;y[o]+=T}v*=x;w<<=1}for(o=0;o<g;++o){var O=0;for(s=0;s<p;s++)O+=d[y[s]+o]*b[s];O=r(O,0,1,u[o][0],u[o][1]);i[n+o]=Math.min(Math.max(O,m[o][0]),m[o][1])}}},constructInterpolated({xref:e,isEvalSupported:t,fn:a,dict:r}){for(var i=s(r.getArray("C0"))||[0],n=s(r.getArray("C1"))||[1],o=r.get("N"),c=i.length,l=[],h=0;h<c;++h)l.push(n[h]-i[h]);return[2,i,l,o]},constructInterpolatedFromIR({xref:e,isEvalSupported:t,IR:a}){var r=a[1],i=a[2],n=a[3],s=i.length;return function(e,t,a,o){for(var c=1===n?e[t]:e[t]**n,l=0;l<s;++l)a[o+l]=r[l]+c*i[l]}},constructStiched({xref:e,isEvalSupported:t,fn:a,dict:i}){var n=s(i.getArray("Domain"));if(!n)throw new r.FormatError("No domain");if(1!=n.length/2)throw new r.FormatError("Bad domain for stiched function");for(var o=i.get("Functions"),c=[],l=0,h=o.length;l<h;++l)c.push(this.parse({xref:e,isEvalSupported:t,fn:e.fetchIfRef(o[l])}));return[3,n,s(i.getArray("Bounds")),s(i.getArray("Encode")),c]},constructStichedFromIR({xref:e,isEvalSupported:t,IR:a}){var r=a[1],i=a[2],n=a[3],s=a[4],o=new Float32Array(1);return function(e,t,a,c){for(var l=function(e,t,a){e>a?e=a:e<t&&(e=t);return e}(e[t],r[0],r[1]),h=0,u=i.length;h<u&&!(l<i[h]);++h);var d=r[0];h>0&&(d=i[h-1]);var f=r[1];h<i.length&&(f=i[h]);var g=n[2*h],m=n[2*h+1];o[0]=d===f?g:g+(l-d)*(m-g)/(f-d);s[h](o,0,a,c)}},constructPostScript({xref:e,isEvalSupported:t,fn:a,dict:i}){var o=s(i.getArray("Domain")),c=s(i.getArray("Range"));if(!o)throw new r.FormatError("No domain.");if(!c)throw new r.FormatError("No range.");var l=new n.PostScriptLexer(a);return[4,o,c,new n.PostScriptParser(l).parse()]},constructPostScriptFromIR({xref:e,isEvalSupported:t,IR:a}){var i=a[1],n=a[2],s=a[3];if(t&&r.IsEvalSupportedCached.value){const e=(new h).compile(s,i,n);if(e)return new Function("src","srcOffset","dest","destOffset",e)}(0,r.info)("Unable to compile PS function");var o=n.length>>1,c=i.length>>1,u=new l(s),d=Object.create(null),f=8192,g=new Float32Array(c);return function(e,t,a,r){var i,s,l="",h=g;for(i=0;i<c;i++){s=e[t+i];h[i]=s;l+=s+"_"}var m=d[l];if(void 0===m){var p=new Float32Array(o),b=u.execute(h),y=b.length-o;for(i=0;i<o;i++){s=b[y+i];var v=n[2*i];(s<v||s>(v=n[2*i+1]))&&(s=v);p[i]=s}if(f>0){f--;d[l]=p}a.set(p,r)}else a.set(m,r)}}};var c=function(){function e(e){this.stack=e?Array.prototype.slice.call(e,0):[]}e.prototype={push:function(e){if(this.stack.length>=100)throw new Error("PostScript function stack overflow.");this.stack.push(e)},pop:function(){if(this.stack.length<=0)throw new Error("PostScript function stack underflow.");return this.stack.pop()},copy:function(e){if(this.stack.length+e>=100)throw new Error("PostScript function stack overflow.");for(var t=this.stack,a=t.length-e,r=e-1;r>=0;r--,a++)t.push(t[a])},index:function(e){this.push(this.stack[this.stack.length-e-1])},roll:function(e,t){var a,r,i,n=this.stack,s=n.length-e,o=n.length-1,c=s+(t-Math.floor(t/e)*e);for(a=s,r=o;a<r;a++,r--){i=n[a];n[a]=n[r];n[r]=i}for(a=s,r=c-1;a<r;a++,r--){i=n[a];n[a]=n[r];n[r]=i}for(a=c,r=o;a<r;a++,r--){i=n[a];n[a]=n[r];n[r]=i}}};return e}(),l=function(){function e(e){this.operators=e}e.prototype={execute:function(e){for(var t,a,i,n=new c(e),s=0,o=this.operators,l=o.length;s<l;)if("number"!=typeof(t=o[s++]))switch(t){case"jz":i=n.pop();(a=n.pop())||(s=i);break;case"j":s=a=n.pop();break;case"abs":a=n.pop();n.push(Math.abs(a));break;case"add":i=n.pop();a=n.pop();n.push(a+i);break;case"and":i=n.pop();a=n.pop();(0,r.isBool)(a)&&(0,r.isBool)(i)?n.push(a&&i):n.push(a&i);break;case"atan":a=n.pop();n.push(Math.atan(a));break;case"bitshift":i=n.pop();(a=n.pop())>0?n.push(a<<i):n.push(a>>i);break;case"ceiling":a=n.pop();n.push(Math.ceil(a));break;case"copy":a=n.pop();n.copy(a);break;case"cos":a=n.pop();n.push(Math.cos(a));break;case"cvi":a=0|n.pop();n.push(a);break;case"cvr":break;case"div":i=n.pop();a=n.pop();n.push(a/i);break;case"dup":n.copy(1);break;case"eq":i=n.pop();a=n.pop();n.push(a===i);break;case"exch":n.roll(2,1);break;case"exp":i=n.pop();a=n.pop();n.push(a**i);break;case"false":n.push(!1);break;case"floor":a=n.pop();n.push(Math.floor(a));break;case"ge":i=n.pop();a=n.pop();n.push(a>=i);break;case"gt":i=n.pop();a=n.pop();n.push(a>i);break;case"idiv":i=n.pop();a=n.pop();n.push(a/i|0);break;case"index":a=n.pop();n.index(a);break;case"le":i=n.pop();a=n.pop();n.push(a<=i);break;case"ln":a=n.pop();n.push(Math.log(a));break;case"log":a=n.pop();n.push(Math.log(a)/Math.LN10);break;case"lt":i=n.pop();a=n.pop();n.push(a<i);break;case"mod":i=n.pop();a=n.pop();n.push(a%i);break;case"mul":i=n.pop();a=n.pop();n.push(a*i);break;case"ne":i=n.pop();a=n.pop();n.push(a!==i);break;case"neg":a=n.pop();n.push(-a);break;case"not":a=n.pop();(0,r.isBool)(a)?n.push(!a):n.push(~a);break;case"or":i=n.pop();a=n.pop();(0,r.isBool)(a)&&(0,r.isBool)(i)?n.push(a||i):n.push(a|i);break;case"pop":n.pop();break;case"roll":i=n.pop();a=n.pop();n.roll(a,i);break;case"round":a=n.pop();n.push(Math.round(a));break;case"sin":a=n.pop();n.push(Math.sin(a));break;case"sqrt":a=n.pop();n.push(Math.sqrt(a));break;case"sub":i=n.pop();a=n.pop();n.push(a-i);break;case"true":n.push(!0);break;case"truncate":a=(a=n.pop())<0?Math.ceil(a):Math.floor(a);n.push(a);break;case"xor":i=n.pop();a=n.pop();(0,r.isBool)(a)&&(0,r.isBool)(i)?n.push(a!==i):n.push(a^i);break;default:throw new r.FormatError(`Unknown operator ${t}`)}else n.push(t);return n.stack}};return e}();t.PostScriptEvaluator=l;var h=function(){function e(e){this.type=e}e.prototype.visit=function(e){(0,r.unreachable)("abstract method")};function t(t,a,r){e.call(this,"args");this.index=t;this.min=a;this.max=r}t.prototype=Object.create(e.prototype);t.prototype.visit=function(e){e.visitArgument(this)};function a(t){e.call(this,"literal");this.number=t;this.min=t;this.max=t}a.prototype=Object.create(e.prototype);a.prototype.visit=function(e){e.visitLiteral(this)};function i(t,a,r,i,n){e.call(this,"binary");this.op=t;this.arg1=a;this.arg2=r;this.min=i;this.max=n}i.prototype=Object.create(e.prototype);i.prototype.visit=function(e){e.visitBinaryOperation(this)};function n(t,a){e.call(this,"max");this.arg=t;this.min=t.min;this.max=a}n.prototype=Object.create(e.prototype);n.prototype.visit=function(e){e.visitMin(this)};function s(t,a,r){e.call(this,"var");this.index=t;this.min=a;this.max=r}s.prototype=Object.create(e.prototype);s.prototype.visit=function(e){e.visitVariable(this)};function o(t,a){e.call(this,"definition");this.variable=t;this.arg=a}o.prototype=Object.create(e.prototype);o.prototype.visit=function(e){e.visitVariableDefinition(this)};function c(){this.parts=[]}c.prototype={visitArgument(e){this.parts.push("Math.max(",e.min,", Math.min(",e.max,", src[srcOffset + ",e.index,"]))")},visitVariable(e){this.parts.push("v",e.index)},visitLiteral(e){this.parts.push(e.number)},visitBinaryOperation(e){this.parts.push("(");e.arg1.visit(this);this.parts.push(" ",e.op," ");e.arg2.visit(this);this.parts.push(")")},visitVariableDefinition(e){this.parts.push("var ");e.variable.visit(this);this.parts.push(" = ");e.arg.visit(this);this.parts.push(";")},visitMin(e){this.parts.push("Math.min(");e.arg.visit(this);this.parts.push(", ",e.max,")")},toString(){return this.parts.join("")}};function l(e,t){return"literal"===t.type&&0===t.number?e:"literal"===e.type&&0===e.number?t:"literal"===t.type&&"literal"===e.type?new a(e.number+t.number):new i("+",e,t,e.min+t.min,e.max+t.max)}function h(e,t){if("literal"===t.type){if(0===t.number)return new a(0);if(1===t.number)return e;if("literal"===e.type)return new a(e.number*t.number)}if("literal"===e.type){if(0===e.number)return new a(0);if(1===e.number)return t}return new i("*",e,t,Math.min(e.min*t.min,e.min*t.max,e.max*t.min,e.max*t.max),Math.max(e.min*t.min,e.min*t.max,e.max*t.min,e.max*t.max))}function u(e,t){if("literal"===t.type){if(0===t.number)return e;if("literal"===e.type)return new a(e.number-t.number)}return"binary"===t.type&&"-"===t.op&&"literal"===e.type&&1===e.number&&"literal"===t.arg1.type&&1===t.arg1.number?t.arg2:new i("-",e,t,e.min-t.max,e.max-t.min)}function d(e,t){return e.min>=t?new a(t):e.max<=t?e:new n(e,t)}function f(){}f.prototype={compile:function(e,r,i){var n,f,g,m,p,b,y,v,w,k,S=[],C=[],x=r.length>>1,A=i.length>>1,I=0;for(n=0;n<x;n++)S.push(new t(n,r[2*n],r[2*n+1]));for(n=0,f=e.length;n<f;n++)if("number"!=typeof(k=e[n]))switch(k){case"add":if(S.length<2)return null;b=S.pop();p=S.pop();S.push(l(p,b));break;case"cvr":if(S.length<1)return null;break;case"mul":if(S.length<2)return null;b=S.pop();p=S.pop();S.push(h(p,b));break;case"sub":if(S.length<2)return null;b=S.pop();p=S.pop();S.push(u(p,b));break;case"exch":if(S.length<2)return null;y=S.pop();v=S.pop();S.push(y,v);break;case"pop":if(S.length<1)return null;S.pop();break;case"index":if(S.length<1)return null;if("literal"!==(p=S.pop()).type)return null;if((g=p.number)<0||!Number.isInteger(g)||S.length<g)return null;if("literal"===(y=S[S.length-g-1]).type||"var"===y.type){S.push(y);break}w=new s(I++,y.min,y.max);S[S.length-g-1]=w;S.push(w);C.push(new o(w,y));break;case"dup":if(S.length<1)return null;if("number"==typeof e[n+1]&&"gt"===e[n+2]&&e[n+3]===n+7&&"jz"===e[n+4]&&"pop"===e[n+5]&&e[n+6]===e[n+1]){p=S.pop();S.push(d(p,e[n+1]));n+=6;break}if("literal"===(y=S[S.length-1]).type||"var"===y.type){S.push(y);break}w=new s(I++,y.min,y.max);S[S.length-1]=w;S.push(w);C.push(new o(w,y));break;case"roll":if(S.length<2)return null;b=S.pop();p=S.pop();if("literal"!==b.type||"literal"!==p.type)return null;m=b.number;if((g=p.number)<=0||!Number.isInteger(g)||!Number.isInteger(m)||S.length<g)return null;if(0===(m=(m%g+g)%g))break;Array.prototype.push.apply(S,S.splice(S.length-g,g-m));break;default:return null}else S.push(new a(k));if(S.length!==A)return null;var F=[];C.forEach((function(e){var t=new c;e.visit(t);F.push(t.toString())}));S.forEach((function(e,t){var a=new c;e.visit(a);var r=i[2*t],n=i[2*t+1],s=[a.toString()];if(r>e.min){s.unshift("Math.max(",r,", ");s.push(")")}if(n<e.max){s.unshift("Math.min(",n,", ");s.push(")")}s.unshift("dest[destOffset + ",t,"] = ");s.push(";");F.push(s.join(""))}));return F.join("\n")}};return f}();t.PostScriptCompiler=h},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.PostScriptParser=t.PostScriptLexer=void 0;var r=a(2),i=a(4),n=a(7);t.PostScriptParser=class{constructor(e){this.lexer=e;this.operators=[];this.token=null;this.prev=null}nextToken(){this.prev=this.token;this.token=this.lexer.getToken()}accept(e){if(this.token.type===e){this.nextToken();return!0}return!1}expect(e){if(this.accept(e))return!0;throw new r.FormatError(`Unexpected symbol: found ${this.token.type} expected ${e}.`)}parse(){this.nextToken();this.expect(s.LBRACE);this.parseBlock();this.expect(s.RBRACE);return this.operators}parseBlock(){for(;;)if(this.accept(s.NUMBER))this.operators.push(this.prev.value);else if(this.accept(s.OPERATOR))this.operators.push(this.prev.value);else{if(!this.accept(s.LBRACE))return;this.parseCondition()}}parseCondition(){const e=this.operators.length;this.operators.push(null,null);this.parseBlock();this.expect(s.RBRACE);if(this.accept(s.IF)){this.operators[e]=this.operators.length;this.operators[e+1]="jz"}else{if(!this.accept(s.LBRACE))throw new r.FormatError("PS Function: error parsing conditional.");{const t=this.operators.length;this.operators.push(null,null);const a=this.operators.length;this.parseBlock();this.expect(s.RBRACE);this.expect(s.IFELSE);this.operators[t]=this.operators.length;this.operators[t+1]="j";this.operators[e]=a;this.operators[e+1]="jz"}}}};const s={LBRACE:0,RBRACE:1,NUMBER:2,OPERATOR:3,IF:4,IFELSE:5},o=function(){const e=Object.create(null);class t{constructor(e,t){this.type=e;this.value=t}static getOperator(a){const r=e[a];return r||(e[a]=new t(s.OPERATOR,a))}static get LBRACE(){return(0,r.shadow)(this,"LBRACE",new t(s.LBRACE,"{"))}static get RBRACE(){return(0,r.shadow)(this,"RBRACE",new t(s.RBRACE,"}"))}static get IF(){return(0,r.shadow)(this,"IF",new t(s.IF,"IF"))}static get IFELSE(){return(0,r.shadow)(this,"IFELSE",new t(s.IFELSE,"IFELSE"))}}return t}();t.PostScriptLexer=class{constructor(e){this.stream=e;this.nextChar();this.strBuf=[]}nextChar(){return this.currentChar=this.stream.getByte()}getToken(){let e=!1,t=this.currentChar;for(;;){if(t<0)return i.EOF;if(e)10!==t&&13!==t||(e=!1);else if(37===t)e=!0;else if(!(0,n.isWhiteSpace)(t))break;t=this.nextChar()}switch(0|t){case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 43:case 45:case 46:return new o(s.NUMBER,this.getNumber());case 123:this.nextChar();return o.LBRACE;case 125:this.nextChar();return o.RBRACE}const a=this.strBuf;a.length=0;a[0]=String.fromCharCode(t);for(;(t=this.nextChar())>=0&&(t>=65&&t<=90||t>=97&&t<=122);)a.push(String.fromCharCode(t));const r=a.join("");switch(r.toLowerCase()){case"if":return o.IF;case"ifelse":return o.IFELSE;default:return o.getOperator(r)}}getNumber(){let e=this.currentChar;const t=this.strBuf;t.length=0;t[0]=String.fromCharCode(e);for(;(e=this.nextChar())>=0&&(e>=48&&e<=57||45===e||46===e);)t.push(String.fromCharCode(e));const a=parseFloat(t.join(""));if(isNaN(a))throw new r.FormatError(`Invalid floating point number: ${a}`);return a}}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.MurmurHash3_64=void 0;var r=a(2);t.MurmurHash3_64=class{constructor(e){this.h1=e?4294967295&e:3285377520;this.h2=e?4294967295&e:3285377520}update(e){let t,a;if((0,r.isString)(e)){t=new Uint8Array(2*e.length);a=0;for(let r=0,i=e.length;r<i;r++){const i=e.charCodeAt(r);if(i<=255)t[a++]=i;else{t[a++]=i>>>8;t[a++]=255&i}}}else{if(!(0,r.isArrayBuffer)(e))throw new Error("Wrong data format in MurmurHash3_64_update. Input must be a string or array.");t=e;a=t.byteLength}const i=a>>2,n=a-4*i,s=new Uint32Array(t.buffer,0,i);let o=0,c=0,l=this.h1,h=this.h2;const u=3432918353,d=461845907;for(let e=0;e<i;e++)if(1&e){o=s[e];o=o*u&4294901760|11601*o&65535;o=o<<15|o>>>17;o=o*d&4294901760|13715*o&65535;l^=o;l=l<<13|l>>>19;l=5*l+3864292196}else{c=s[e];c=c*u&4294901760|11601*c&65535;c=c<<15|c>>>17;c=c*d&4294901760|13715*c&65535;h^=c;h=h<<13|h>>>19;h=5*h+3864292196}o=0;switch(n){case 3:o^=t[4*i+2]<<16;case 2:o^=t[4*i+1]<<8;case 1:o^=t[4*i];o=o*u&4294901760|11601*o&65535;o=o<<15|o>>>17;o=o*d&4294901760|13715*o&65535;1&i?l^=o:h^=o}this.h1=l;this.h2=h}hexdigest(){let e=this.h1,t=this.h2;e^=t>>>1;e=3981806797*e&4294901760|36045*e&65535;t=4283543511*t&4294901760|(2950163797*(t<<16|e>>>16)&4294901760)>>>16;e^=t>>>1;e=444984403*e&4294901760|60499*e&65535;t=3301882366*t&4294901760|(3120437893*(t<<16|e>>>16)&4294901760)>>>16;e^=t>>>1;const a=(e>>>0).toString(16),r=(t>>>0).toString(16);return a.padStart(8,"0")+r.padStart(8,"0")}}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.NativeImageDecoder=void 0;var r=a(22),i=a(17),n=a(11);class s{constructor({xref:e,resources:t,handler:a,forceDataSchema:r=!1,pdfFunctionFactory:i}){this.xref=e;this.resources=t;this.handler=a;this.forceDataSchema=r;this.pdfFunctionFactory=i}canDecode(e){return e instanceof i.JpegStream&&s.isDecodable(e,this.xref,this.resources,this.pdfFunctionFactory)&&e.maybeValidDimensions}decode(e){const t=e.dict;let a=t.get("ColorSpace","CS");a=r.ColorSpace.parse(a,this.xref,this.resources,this.pdfFunctionFactory);return this.handler.sendWithPromise("JpegDecode",[e.getIR(this.forceDataSchema),a.numComps]).then((function({data:e,width:a,height:r}){return new n.Stream(e,0,e.length,t)}))}static isSupported(e,t,a,i){const n=e.dict;if(n.has("DecodeParms")||n.has("DP"))return!1;const s=r.ColorSpace.parse(n.get("ColorSpace","CS"),t,a,i);return("DeviceGray"===s.name||"DeviceRGB"===s.name)&&s.isDefaultDecode(n.getArray("Decode","D"))}static isDecodable(e,t,a,i){const n=e.dict;if(n.has("DecodeParms")||n.has("DP"))return!1;const s=r.ColorSpace.parse(n.get("ColorSpace","CS"),t,a,i),o=n.get("BitsPerComponent","BPC")||1;return(1===s.numComps||3===s.numComps)&&s.isDefaultDecode(n.getArray("Decode","D"),o)}}t.NativeImageDecoder=s},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.PDFImage=void 0;var r=a(2),i=a(4),n=a(22),s=a(11),o=a(17),c=a(20),l=function(){function e(e,t){return t&&t.canDecode(e)?t.decode(e).catch(t=>{(0,r.warn)("Native image decoding failed -- trying to recover: "+(t&&t.message));return e}):Promise.resolve(e)}function t(e,t,a,r){(e=t+e*a)<0?e=0:e>r&&(e=r);return e}function a(e,t,a,r,i,n){var s=i*n;let o;o=t<=8?new Uint8Array(s):t<=16?new Uint16Array(s):new Uint32Array(s);var c,l,h,u,d=a/i,f=r/n,g=0,m=new Uint16Array(i),p=a;for(c=0;c<i;c++)m[c]=Math.floor(c*d);for(c=0;c<n;c++){h=Math.floor(c*f)*p;for(l=0;l<i;l++){u=h+m[l];o[g++]=e[u]}}return o}function l({xref:e,res:t,image:a,isInline:s=!1,smask:o=null,mask:h=null,isMask:u=!1,pdfFunctionFactory:d}){this.image=a;var f=a.dict;const g=f.get("Filter");if((0,i.isName)(g))switch(g.name){case"JPXDecode":var m=new c.JpxImage;m.parseImageProperties(a.stream);a.stream.reset();a.width=m.width;a.height=m.height;a.bitsPerComponent=m.bitsPerComponent;a.numComps=m.componentsCount;break;case"JBIG2Decode":a.bitsPerComponent=1;a.numComps=1}let p=f.get("Width","W"),b=f.get("Height","H");if(Number.isInteger(a.width)&&a.width>0&&Number.isInteger(a.height)&&a.height>0&&(a.width!==p||a.height!==b)){(0,r.warn)("PDFImage - using the Width/Height of the image data, rather than the image dictionary.");p=a.width;b=a.height}if(p<1||b<1)throw new r.FormatError(`Invalid image width: ${p} or height: ${b}`);this.width=p;this.height=b;this.interpolate=f.get("Interpolate","I")||!1;this.imageMask=f.get("ImageMask","IM")||!1;this.matte=f.get("Matte")||!1;var y=a.bitsPerComponent;if(!y&&!(y=f.get("BitsPerComponent","BPC"))){if(!this.imageMask)throw new r.FormatError(`Bits per component missing in image: ${this.imageMask}`);y=1}this.bpc=y;if(!this.imageMask){var v=f.get("ColorSpace","CS");if(!v){(0,r.info)("JPX images (which do not require color spaces)");switch(a.numComps){case 1:v=i.Name.get("DeviceGray");break;case 3:v=i.Name.get("DeviceRGB");break;case 4:v=i.Name.get("DeviceCMYK");break;default:throw new Error(`JPX images with ${a.numComps} `+"color components not supported.")}}const o=s?t:null;this.colorSpace=n.ColorSpace.parse(v,e,o,d);this.numComps=this.colorSpace.numComps}this.decode=f.getArray("Decode","D");this.needsDecode=!1;if(this.decode&&(this.colorSpace&&!this.colorSpace.isDefaultDecode(this.decode,y)||u&&!n.ColorSpace.isDefaultDecode(this.decode,1))){this.needsDecode=!0;var w=(1<<y)-1;this.decodeCoefficients=[];this.decodeAddends=[];const e=this.colorSpace&&"Indexed"===this.colorSpace.name;for(var k=0,S=0;k<this.decode.length;k+=2,++S){var C=this.decode[k],x=this.decode[k+1];this.decodeCoefficients[S]=e?(x-C)/w:x-C;this.decodeAddends[S]=e?C:w*C}}if(o)this.smask=new l({xref:e,res:t,image:o,isInline:s,pdfFunctionFactory:d});else if(h)if((0,i.isStream)(h)){h.dict.get("ImageMask","IM")?this.mask=new l({xref:e,res:t,image:h,isInline:s,isMask:!0,pdfFunctionFactory:d}):(0,r.warn)("Ignoring /Mask in image without /ImageMask.")}else this.mask=h}l.buildImage=function({handler:t,xref:a,res:n,image:s,isInline:o=!1,nativeDecoder:c=null,pdfFunctionFactory:h}){var u,d,f=e(s,c),g=s.dict.get("SMask"),m=s.dict.get("Mask");if(g){u=e(g,c);d=Promise.resolve(null)}else{u=Promise.resolve(null);if(m)if((0,i.isStream)(m))d=e(m,c);else if(Array.isArray(m))d=Promise.resolve(m);else{(0,r.warn)("Unsupported mask format.");d=Promise.resolve(null)}else d=Promise.resolve(null)}return Promise.all([f,u,d]).then((function([e,t,r]){return new l({xref:a,res:n,image:e,isInline:o,smask:t,mask:r,pdfFunctionFactory:h})}))};l.createMask=function({imgArray:e,width:t,height:a,imageIsFromDecodeStream:r,inverseDecode:i}){var n,s,o=(t+7>>3)*a,c=e.byteLength;if(!r||i&&!(o===c))if(i){(n=new Uint8ClampedArray(o)).set(e);for(s=c;s<o;s++)n[s]=255}else(n=new Uint8ClampedArray(c)).set(e);else n=e;if(i)for(s=0;s<c;s++)n[s]^=255;return{data:n,width:t,height:a}};l.prototype={get drawWidth(){return Math.max(this.width,this.smask&&this.smask.width||0,this.mask&&this.mask.width||0)},get drawHeight(){return Math.max(this.height,this.smask&&this.smask.height||0,this.mask&&this.mask.height||0)},decodeBuffer(e){var a,r,i=this.bpc,n=this.numComps,s=this.decodeAddends,o=this.decodeCoefficients,c=(1<<i)-1;if(1!==i){var l=0;for(a=0,r=this.width*this.height;a<r;a++)for(var h=0;h<n;h++){e[l]=t(e[l],s[h],o[h],c);l++}}else for(a=0,r=e.length;a<r;a++)e[a]=+!e[a]},getComponents(e){var t=this.bpc;if(8===t)return e;var a=this.width,r=this.height,i=this.numComps,n=a*r*i,s=0;let o;o=t<=8?new Uint8Array(n):t<=16?new Uint16Array(n):new Uint32Array(n);var c,l,h=a*i,u=(1<<t)-1,d=0;if(1===t)for(var f,g,m,p=0;p<r;p++){g=d+(-8&h);m=d+h;for(;d<g;){l=e[s++];o[d]=l>>7&1;o[d+1]=l>>6&1;o[d+2]=l>>5&1;o[d+3]=l>>4&1;o[d+4]=l>>3&1;o[d+5]=l>>2&1;o[d+6]=l>>1&1;o[d+7]=1&l;d+=8}if(d<m){l=e[s++];f=128;for(;d<m;){o[d++]=+!!(l&f);f>>=1}}}else{var b=0;l=0;for(d=0,c=n;d<c;++d){if(d%h==0){l=0;b=0}for(;b<t;){l=l<<8|e[s++];b+=8}var y=b-t;let a=l>>y;a<0?a=0:a>u&&(a=u);o[d]=a;l&=(1<<y)-1;b=y}}return o},fillOpacity(e,t,i,n,s){var o,c,h,u,d,f,g=this.smask,m=this.mask;if(g){c=g.width;h=g.height;o=new Uint8ClampedArray(c*h);g.fillGrayBuffer(o);c===t&&h===i||(o=a(o,g.bpc,c,h,t,i))}else if(m)if(m instanceof l){c=m.width;h=m.height;o=new Uint8ClampedArray(c*h);m.numComps=1;m.fillGrayBuffer(o);for(u=0,d=c*h;u<d;++u)o[u]=255-o[u];c===t&&h===i||(o=a(o,m.bpc,c,h,t,i))}else{if(!Array.isArray(m))throw new r.FormatError("Unknown mask format.");o=new Uint8ClampedArray(t*i);var p=this.numComps;for(u=0,d=t*i;u<d;++u){var b=0,y=u*p;for(f=0;f<p;++f){var v=s[y+f],w=2*f;if(v<m[w]||v>m[w+1]){b=255;break}}o[u]=b}}if(o)for(u=0,f=3,d=t*n;u<d;++u,f+=4)e[f]=o[u];else for(u=0,f=3,d=t*n;u<d;++u,f+=4)e[f]=255},undoPreblend(e,t,a){var r=this.smask&&this.smask.matte;if(r)for(var i=this.colorSpace.getRgb(r,0),n=i[0],s=i[1],o=i[2],c=t*a*4,l=0;l<c;l+=4){var h=e[l+3];if(0!==h){var u=255/h;e[l]=(e[l]-n)*u+n;e[l+1]=(e[l+1]-s)*u+s;e[l+2]=(e[l+2]-o)*u+o}else{e[l]=255;e[l+1]=255;e[l+2]=255}}},createImageData(e=!1){var t,a=this.drawWidth,i=this.drawHeight,n={width:a,height:i,kind:0,data:null},c=this.numComps,l=this.width,h=this.height,u=this.bpc,d=l*c*u+7>>3;if(!e){var f;"DeviceGray"===this.colorSpace.name&&1===u?f=r.ImageKind.GRAYSCALE_1BPP:"DeviceRGB"!==this.colorSpace.name||8!==u||this.needsDecode||(f=r.ImageKind.RGB_24BPP);if(f&&!this.smask&&!this.mask&&a===l&&i===h){n.kind=f;t=this.getImageBytes(h*d);if(this.image instanceof s.DecodeStream)n.data=t;else{var g=new Uint8ClampedArray(t.length);g.set(t);n.data=g}if(this.needsDecode){(0,r.assert)(f===r.ImageKind.GRAYSCALE_1BPP,"PDFImage.createImageData: The image must be grayscale.");for(var m=n.data,p=0,b=m.length;p<b;p++)m[p]^=255}return n}if(this.image instanceof o.JpegStream&&!this.smask&&!this.mask){let e=h*d;switch(this.colorSpace.name){case"DeviceGray":e*=3;case"DeviceRGB":case"DeviceCMYK":n.kind=r.ImageKind.RGB_24BPP;n.data=this.getImageBytes(e,a,i,!0);return n}}}var y,v,w=0|(t=this.getImageBytes(h*d)).length/d*i/h,k=this.getComponents(t);if(e||this.smask||this.mask){n.kind=r.ImageKind.RGBA_32BPP;n.data=new Uint8ClampedArray(a*i*4);y=1;v=!0;this.fillOpacity(n.data,a,i,w,k)}else{n.kind=r.ImageKind.RGB_24BPP;n.data=new Uint8ClampedArray(a*i*3);y=0;v=!1}this.needsDecode&&this.decodeBuffer(k);this.colorSpace.fillRgb(n.data,l,h,a,i,w,u,k,y);v&&this.undoPreblend(n.data,a,w);return n},fillGrayBuffer(e){var t=this.numComps;if(1!==t)throw new r.FormatError(`Reading gray scale from a color image: ${t}`);var a,i,n=this.width,s=this.height,o=this.bpc,c=n*t*o+7>>3,l=this.getImageBytes(s*c),h=this.getComponents(l);if(1!==o){this.needsDecode&&this.decodeBuffer(h);i=n*s;var u=255/((1<<o)-1);for(a=0;a<i;++a)e[a]=u*h[a]}else{i=n*s;if(this.needsDecode)for(a=0;a<i;++a)e[a]=h[a]-1&255;else for(a=0;a<i;++a)e[a]=255&-h[a]}},getImageBytes(e,t,a,r=!1){this.image.reset();this.image.drawWidth=t||this.width;this.image.drawHeight=a||this.height;this.image.forceRGB=!!r;return this.image.getBytes(e,!0)}};return l}();t.PDFImage=l},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.isNodeJS=void 0;const r="object"==typeof process&&process+""=="[object process]"&&!process.versions.nw&&!process.versions.electron;t.isNodeJS=r},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.MessageHandler=void 0;var r=a(2);const i=1,n=2,s=1,o=2,c=3,l=4,h=5,u=6,d=7,f=8;function g(e){if("object"!=typeof e||null===e)return e;switch(e.name){case"AbortException":return new r.AbortException(e.message);case"MissingPDFException":return new r.MissingPDFException(e.message);case"UnexpectedResponseException":return new r.UnexpectedResponseException(e.message,e.status);case"UnknownErrorException":return new r.UnknownErrorException(e.message,e.details);default:return new r.UnknownErrorException(e.message,e.toString())}}t.MessageHandler=class{constructor(e,t,a){this.sourceName=e;this.targetName=t;this.comObj=a;this.callbackId=1;this.streamId=1;this.postMessageTransfers=!0;this.streamSinks=Object.create(null);this.streamControllers=Object.create(null);this.callbackCapabilities=Object.create(null);this.actionHandler=Object.create(null);this._onComObjOnMessage=e=>{const t=e.data;if(t.targetName!==this.sourceName)return;if(t.stream){this._processStreamMessage(t);return}if(t.callback){const e=t.callbackId,a=this.callbackCapabilities[e];if(!a)throw new Error(`Cannot resolve callback ${e}`);delete this.callbackCapabilities[e];if(t.callback===i)a.resolve(t.data);else{if(t.callback!==n)throw new Error("Unexpected callback case");a.reject(g(t.reason))}return}const r=this.actionHandler[t.action];if(!r)throw new Error(`Unknown action from worker: ${t.action}`);if(t.callbackId){const e=this.sourceName,s=t.sourceName;new Promise((function(e){e(r(t.data))})).then((function(r){a.postMessage({sourceName:e,targetName:s,callback:i,callbackId:t.callbackId,data:r})}),(function(r){a.postMessage({sourceName:e,targetName:s,callback:n,callbackId:t.callbackId,reason:g(r)})}))}else t.streamId?this._createStreamSink(t):r(t.data)};a.addEventListener("message",this._onComObjOnMessage)}on(e,t){const a=this.actionHandler;if(a[e])throw new Error(`There is already an actionName called "${e}"`);a[e]=t}send(e,t,a){this._postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,data:t},a)}sendWithPromise(e,t,a){const i=this.callbackId++,n=(0,r.createPromiseCapability)();this.callbackCapabilities[i]=n;try{this._postMessage({sourceName:this.sourceName,targetName:this.targetName,action:e,callbackId:i,data:t},a)}catch(e){n.reject(e)}return n.promise}sendWithStream(e,t,a,i){const n=this.streamId++,o=this.sourceName,c=this.targetName,l=this.comObj;return new ReadableStream({start:a=>{const s=(0,r.createPromiseCapability)();this.streamControllers[n]={controller:a,startCall:s,pullCall:null,cancelCall:null,isClosed:!1};this._postMessage({sourceName:o,targetName:c,action:e,streamId:n,data:t,desiredSize:a.desiredSize},i);return s.promise},pull:e=>{const t=(0,r.createPromiseCapability)();this.streamControllers[n].pullCall=t;l.postMessage({sourceName:o,targetName:c,stream:u,streamId:n,desiredSize:e.desiredSize});return t.promise},cancel:e=>{(0,r.assert)(e instanceof Error,"cancel must have a valid reason");const t=(0,r.createPromiseCapability)();this.streamControllers[n].cancelCall=t;this.streamControllers[n].isClosed=!0;l.postMessage({sourceName:o,targetName:c,stream:s,streamId:n,reason:g(e)});return t.promise}},a)}_createStreamSink(e){const t=this,a=this.actionHandler[e.action],i=e.streamId,n=this.sourceName,s=e.sourceName,o=this.comObj,u={enqueue(e,a=1,o){if(this.isCancelled)return;const c=this.desiredSize;this.desiredSize-=a;if(c>0&&this.desiredSize<=0){this.sinkCapability=(0,r.createPromiseCapability)();this.ready=this.sinkCapability.promise}t._postMessage({sourceName:n,targetName:s,stream:l,streamId:i,chunk:e},o)},close(){if(!this.isCancelled){this.isCancelled=!0;o.postMessage({sourceName:n,targetName:s,stream:c,streamId:i});delete t.streamSinks[i]}},error(e){(0,r.assert)(e instanceof Error,"error must have a valid reason");if(!this.isCancelled){this.isCancelled=!0;o.postMessage({sourceName:n,targetName:s,stream:h,streamId:i,reason:g(e)})}},sinkCapability:(0,r.createPromiseCapability)(),onPull:null,onCancel:null,isCancelled:!1,desiredSize:e.desiredSize,ready:null};u.sinkCapability.resolve();u.ready=u.sinkCapability.promise;this.streamSinks[i]=u;new Promise((function(t){t(a(e.data,u))})).then((function(){o.postMessage({sourceName:n,targetName:s,stream:f,streamId:i,success:!0})}),(function(e){o.postMessage({sourceName:n,targetName:s,stream:f,streamId:i,reason:g(e)})}))}_processStreamMessage(e){const t=e.streamId,a=this.sourceName,i=e.sourceName,n=this.comObj;switch(e.stream){case f:e.success?this.streamControllers[t].startCall.resolve():this.streamControllers[t].startCall.reject(g(e.reason));break;case d:e.success?this.streamControllers[t].pullCall.resolve():this.streamControllers[t].pullCall.reject(g(e.reason));break;case u:if(!this.streamSinks[t]){n.postMessage({sourceName:a,targetName:i,stream:d,streamId:t,success:!0});break}this.streamSinks[t].desiredSize<=0&&e.desiredSize>0&&this.streamSinks[t].sinkCapability.resolve();this.streamSinks[t].desiredSize=e.desiredSize;const{onPull:m}=this.streamSinks[e.streamId];new Promise((function(e){e(m&&m())})).then((function(){n.postMessage({sourceName:a,targetName:i,stream:d,streamId:t,success:!0})}),(function(e){n.postMessage({sourceName:a,targetName:i,stream:d,streamId:t,reason:g(e)})}));break;case l:(0,r.assert)(this.streamControllers[t],"enqueue should have stream controller");if(this.streamControllers[t].isClosed)break;this.streamControllers[t].controller.enqueue(e.chunk);break;case c:(0,r.assert)(this.streamControllers[t],"close should have stream controller");if(this.streamControllers[t].isClosed)break;this.streamControllers[t].isClosed=!0;this.streamControllers[t].controller.close();this._deleteStreamController(t);break;case h:(0,r.assert)(this.streamControllers[t],"error should have stream controller");this.streamControllers[t].controller.error(g(e.reason));this._deleteStreamController(t);break;case o:e.success?this.streamControllers[t].cancelCall.resolve():this.streamControllers[t].cancelCall.reject(g(e.reason));this._deleteStreamController(t);break;case s:if(!this.streamSinks[t])break;const{onCancel:p}=this.streamSinks[e.streamId];new Promise((function(t){t(p&&p(g(e.reason)))})).then((function(){n.postMessage({sourceName:a,targetName:i,stream:o,streamId:t,success:!0})}),(function(e){n.postMessage({sourceName:a,targetName:i,stream:o,streamId:t,reason:g(e)})}));this.streamSinks[t].sinkCapability.reject(g(e.reason));this.streamSinks[t].isCancelled=!0;delete this.streamSinks[t];break;default:throw new Error("Unexpected stream case")}}async _deleteStreamController(e){await Promise.allSettled([this.streamControllers[e].startCall,this.streamControllers[e].pullCall,this.streamControllers[e].cancelCall].map((function(e){return e&&e.promise})));delete this.streamControllers[e]}_postMessage(e,t){t&&this.postMessageTransfers?this.comObj.postMessage(e,t):this.comObj.postMessage(e)}destroy(){this.comObj.removeEventListener("message",this._onComObjOnMessage)}}},function(e,t,a){"use strict";Object.defineProperty(t,"__esModule",{value:!0});t.PDFWorkerStream=void 0;var r=a(2);t.PDFWorkerStream=class{constructor(e){this._msgHandler=e;this._contentLength=null;this._fullRequestReader=null;this._rangeRequestReaders=[]}getFullReader(){(0,r.assert)(!this._fullRequestReader);this._fullRequestReader=new i(this._msgHandler);return this._fullRequestReader}getRangeReader(e,t){const a=new n(e,t,this._msgHandler);this._rangeRequestReaders.push(a);return a}cancelAllRequests(e){this._fullRequestReader&&this._fullRequestReader.cancel(e);this._rangeRequestReaders.slice(0).forEach((function(t){t.cancel(e)}))}};class i{constructor(e){this._msgHandler=e;this.onProgress=null;this._contentLength=null;this._isRangeSupported=!1;this._isStreamingSupported=!1;const t=this._msgHandler.sendWithStream("GetReader");this._reader=t.getReader();this._headersReady=this._msgHandler.sendWithPromise("ReaderHeadersReady").then(e=>{this._isStreamingSupported=e.isStreamingSupported;this._isRangeSupported=e.isRangeSupported;this._contentLength=e.contentLength})}get headersReady(){return this._headersReady}get contentLength(){return this._contentLength}get isStreamingSupported(){return this._isStreamingSupported}get isRangeSupported(){return this._isRangeSupported}async read(){const{value:e,done:t}=await this._reader.read();return t?{value:void 0,done:!0}:{value:e.buffer,done:!1}}cancel(e){this._reader.cancel(e)}}class n{constructor(e,t,a){this._msgHandler=a;this.onProgress=null;const r=this._msgHandler.sendWithStream("GetRangeReader",{begin:e,end:t});this._reader=r.getReader()}get isStreamingSupported(){return!1}async read(){const{value:e,done:t}=await this._reader.read();return t?{value:void 0,done:!0}:{value:e.buffer,done:!1}}cancel(e){this._reader.cancel(e)}}}])}));