<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class VerificationDetailsIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\VerificationDetail(array());
        $this->assertNotNull($obj);
    }
    
    public function testVerificationDetailsCreate()
    {
        $fixture = $this->loadJsonFixture('verification_details')->create;
        $this->stub_request($fixture);

        $service = $this->client->verificationDetails();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);

        $body = $fixture->body->verification_details;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\VerificationDetail', $response);

        $this->assertEquals($body->address_line1, $response->address_line1);
        $this->assertEquals($body->address_line2, $response->address_line2);
        $this->assertEquals($body->address_line3, $response->address_line3);
        $this->assertEquals($body->city, $response->city);
        $this->assertEquals($body->company_number, $response->company_number);
        $this->assertEquals($body->description, $response->description);
        $this->assertEquals($body->directors, $response->directors);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->name, $response->name);
        $this->assertEquals($body->postal_code, $response->postal_code);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testVerificationDetailsList()
    {
        $fixture = $this->loadJsonFixture('verification_details')->list;
        $this->stub_request($fixture);

        $service = $this->client->verificationDetails();
        $response = call_user_func_array(array($service, 'list'), (array)$fixture->url_params);

        $body = $fixture->body->verification_details;
    
        $records = $response->records;
        $this->assertInstanceOf('\GoCardlessPro\Core\ListResponse', $response);
        $this->assertInstanceOf('\GoCardlessPro\Resources\VerificationDetail', $records[0]);

        $this->assertEquals($fixture->body->meta->cursors->before, $response->before);
        $this->assertEquals($fixture->body->meta->cursors->after, $response->after);
    

    
        foreach (range(0, count($body) - 1) as $num) {
            $record = $records[$num];
            $this->assertEquals($body[$num]->address_line1, $record->address_line1);
            $this->assertEquals($body[$num]->address_line2, $record->address_line2);
            $this->assertEquals($body[$num]->address_line3, $record->address_line3);
            $this->assertEquals($body[$num]->city, $record->city);
            $this->assertEquals($body[$num]->company_number, $record->company_number);
            $this->assertEquals($body[$num]->description, $record->description);
            $this->assertEquals($body[$num]->directors, $record->directors);
            $this->assertEquals($body[$num]->links, $record->links);
            $this->assertEquals($body[$num]->name, $record->name);
            $this->assertEquals($body[$num]->postal_code, $record->postal_code);
            
        }

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
}
