<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\NetworkServices;

class WasmPluginLogConfig extends \Google\Model
{
  /**
   * Unspecified value. Defaults to `LogLevel.INFO`.
   */
  public const MIN_LOG_LEVEL_LOG_LEVEL_UNSPECIFIED = 'LOG_LEVEL_UNSPECIFIED';
  /**
   * Report logs with TRACE level and above.
   */
  public const MIN_LOG_LEVEL_TRACE = 'TRACE';
  /**
   * Report logs with DEBUG level and above.
   */
  public const MIN_LOG_LEVEL_DEBUG = 'DEBUG';
  /**
   * Report logs with INFO level and above.
   */
  public const MIN_LOG_LEVEL_INFO = 'INFO';
  /**
   * Report logs with WARN level and above.
   */
  public const MIN_LOG_LEVEL_WARN = 'WARN';
  /**
   * Report logs with ERROR level and above.
   */
  public const MIN_LOG_LEVEL_ERROR = 'ERROR';
  /**
   * Report logs with CRITICAL level only.
   */
  public const MIN_LOG_LEVEL_CRITICAL = 'CRITICAL';
  /**
   * Optional. Specifies whether to enable logging for activity by this plugin.
   * Defaults to `false`.
   *
   * @var bool
   */
  public $enable;
  /**
   * Non-empty default. Specifies the lowest level of the plugin logs that are
   * exported to Cloud Logging. This setting relates to the logs generated by
   * using logging statements in your Wasm code. This field is can be set only
   * if logging is enabled for the plugin. If the field is not provided when
   * logging is enabled, it is set to `INFO` by default.
   *
   * @var string
   */
  public $minLogLevel;
  /**
   * Non-empty default. Configures the sampling rate of activity logs, where
   * `1.0` means all logged activity is reported and `0.0` means no activity is
   * reported. A floating point value between `0.0` and `1.0` indicates that a
   * percentage of log messages is stored. The default value when logging is
   * enabled is `1.0`. The value of the field must be between `0` and `1`
   * (inclusive). This field can be specified only if logging is enabled for
   * this plugin.
   *
   * @var float
   */
  public $sampleRate;

  /**
   * Optional. Specifies whether to enable logging for activity by this plugin.
   * Defaults to `false`.
   *
   * @param bool $enable
   */
  public function setEnable($enable)
  {
    $this->enable = $enable;
  }
  /**
   * @return bool
   */
  public function getEnable()
  {
    return $this->enable;
  }
  /**
   * Non-empty default. Specifies the lowest level of the plugin logs that are
   * exported to Cloud Logging. This setting relates to the logs generated by
   * using logging statements in your Wasm code. This field is can be set only
   * if logging is enabled for the plugin. If the field is not provided when
   * logging is enabled, it is set to `INFO` by default.
   *
   * Accepted values: LOG_LEVEL_UNSPECIFIED, TRACE, DEBUG, INFO, WARN, ERROR,
   * CRITICAL
   *
   * @param self::MIN_LOG_LEVEL_* $minLogLevel
   */
  public function setMinLogLevel($minLogLevel)
  {
    $this->minLogLevel = $minLogLevel;
  }
  /**
   * @return self::MIN_LOG_LEVEL_*
   */
  public function getMinLogLevel()
  {
    return $this->minLogLevel;
  }
  /**
   * Non-empty default. Configures the sampling rate of activity logs, where
   * `1.0` means all logged activity is reported and `0.0` means no activity is
   * reported. A floating point value between `0.0` and `1.0` indicates that a
   * percentage of log messages is stored. The default value when logging is
   * enabled is `1.0`. The value of the field must be between `0` and `1`
   * (inclusive). This field can be specified only if logging is enabled for
   * this plugin.
   *
   * @param float $sampleRate
   */
  public function setSampleRate($sampleRate)
  {
    $this->sampleRate = $sampleRate;
  }
  /**
   * @return float
   */
  public function getSampleRate()
  {
    return $this->sampleRate;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(WasmPluginLogConfig::class, 'Google_Service_NetworkServices_WasmPluginLogConfig');
