
# Fulfillment

Contains details about how to fulfill this order.
Orders can only be created with at most one fulfillment using the API.
However, orders returned by the Orders API might contain multiple fulfillments because sellers can create multiple fulfillments using Square products such as Square Online.

## Structure

`Fulfillment`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `uid` | `?string` | Optional | A unique ID that identifies the fulfillment only within this order.<br>**Constraints**: *Maximum Length*: `60` | getUid(): ?string | setUid(?string uid): void |
| `type` | [`?string(FulfillmentType)`](../../doc/models/fulfillment-type.md) | Optional | The type of fulfillment. | getType(): ?string | setType(?string type): void |
| `state` | [`?string(FulfillmentState)`](../../doc/models/fulfillment-state.md) | Optional | The current state of this fulfillment. | getState(): ?string | setState(?string state): void |
| `lineItemApplication` | [`?string(FulfillmentFulfillmentLineItemApplication)`](../../doc/models/fulfillment-fulfillment-line-item-application.md) | Optional | The `line_item_application` describes what order line items this fulfillment applies<br>to. It can be `ALL` or `ENTRY_LIST` with a supplied list of fulfillment entries. | getLineItemApplication(): ?string | setLineItemApplication(?string lineItemApplication): void |
| `entries` | [`?(FulfillmentFulfillmentEntry[])`](../../doc/models/fulfillment-fulfillment-entry.md) | Optional | A list of entries pertaining to the fulfillment of an order. Each entry must reference<br>a valid `uid` for an order line item in the `line_item_uid` field, as well as a `quantity` to<br>fulfill.<br><br>Multiple entries can reference the same line item `uid`, as long as the total quantity among<br>all fulfillment entries referencing a single line item does not exceed the quantity of the<br>order's line item itself.<br><br>An order cannot be marked as `COMPLETED` before all fulfillments are `COMPLETED`,<br>`CANCELED`, or `FAILED`. Fulfillments can be created and completed independently<br>before order completion. | getEntries(): ?array | setEntries(?array entries): void |
| `metadata` | `?array<string,string>` | Optional | Application-defined data attached to this fulfillment. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (such as personally<br>identifiable information or card details).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries can also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a maximum length of 255 characters.<br><br>An application can have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>For more information, see [Metadata](https://developer.squareup.com/docs/build-basics/metadata). | getMetadata(): ?array | setMetadata(?array metadata): void |
| `pickupDetails` | [`?FulfillmentPickupDetails`](../../doc/models/fulfillment-pickup-details.md) | Optional | Contains details necessary to fulfill a pickup order. | getPickupDetails(): ?FulfillmentPickupDetails | setPickupDetails(?FulfillmentPickupDetails pickupDetails): void |
| `shipmentDetails` | [`?FulfillmentShipmentDetails`](../../doc/models/fulfillment-shipment-details.md) | Optional | Contains the details necessary to fulfill a shipment order. | getShipmentDetails(): ?FulfillmentShipmentDetails | setShipmentDetails(?FulfillmentShipmentDetails shipmentDetails): void |
| `deliveryDetails` | [`?FulfillmentDeliveryDetails`](../../doc/models/fulfillment-delivery-details.md) | Optional | Describes delivery details of an order fulfillment. | getDeliveryDetails(): ?FulfillmentDeliveryDetails | setDeliveryDetails(?FulfillmentDeliveryDetails deliveryDetails): void |

## Example (as JSON)

```json
{
  "uid": "uid0",
  "type": "DELIVERY",
  "state": "PREPARED",
  "line_item_application": "ALL",
  "entries": [
    {
      "uid": "uid5",
      "line_item_uid": "line_item_uid5",
      "quantity": "quantity1",
      "metadata": {
        "key0": "metadata8",
        "key1": "metadata9",
        "key2": "metadata0"
      }
    }
  ]
}
```

