<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DriveLabels;

class GoogleAppsDriveLabelsV2BadgeColors extends \Google\Model
{
  /**
   * @var GoogleTypeColor
   */
  public $backgroundColor;
  protected $backgroundColorType = GoogleTypeColor::class;
  protected $backgroundColorDataType = '';
  /**
   * @var GoogleTypeColor
   */
  public $foregroundColor;
  protected $foregroundColorType = GoogleTypeColor::class;
  protected $foregroundColorDataType = '';
  /**
   * @var GoogleTypeColor
   */
  public $soloColor;
  protected $soloColorType = GoogleTypeColor::class;
  protected $soloColorDataType = '';

  /**
   * @param GoogleTypeColor
   */
  public function setBackgroundColor(GoogleTypeColor $backgroundColor)
  {
    $this->backgroundColor = $backgroundColor;
  }
  /**
   * @return GoogleTypeColor
   */
  public function getBackgroundColor()
  {
    return $this->backgroundColor;
  }
  /**
   * @param GoogleTypeColor
   */
  public function setForegroundColor(GoogleTypeColor $foregroundColor)
  {
    $this->foregroundColor = $foregroundColor;
  }
  /**
   * @return GoogleTypeColor
   */
  public function getForegroundColor()
  {
    return $this->foregroundColor;
  }
  /**
   * @param GoogleTypeColor
   */
  public function setSoloColor(GoogleTypeColor $soloColor)
  {
    $this->soloColor = $soloColor;
  }
  /**
   * @return GoogleTypeColor
   */
  public function getSoloColor()
  {
    return $this->soloColor;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleAppsDriveLabelsV2BadgeColors::class, 'Google_Service_DriveLabels_GoogleAppsDriveLabelsV2BadgeColors');
