Criando seus próprios geradores
============================

Abra a pasta de qualquer gerador e você verá dois arquivos `form.php` e `Generator.php`.
O primeiro é o formulário, o segundo é a classe geradora. A fim de criar seu próprio gerador, você precisa criar ou
sobrescrever essas classes em qualquer pasta. Novamente personalizar a configuração:

```php
//config/web.php for basic app
//..
if (YII_ENV_DEV) {    
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',      
        'allowedIPs' => ['127.0.0.1', '::1', '192.168.0.*', '192.168.178.20', '172.16.0.0/12'],  
         'generators' => [
            'myCrud' => [
                'class' => 'app\myTemplates\crud\Generator',
                'templates' => [
                    'my' => '@app/myTemplates/crud/default',
                ]
            ]
        ],
    ];
}
```

```php
// @app/myTemplates/crud/Generator.php
<?php
namespace app\myTemplates\crud;

class Generator extends \yii\gii\Generator
{
    public function getName()
    {
        return 'MY CRUD Generator';
    }

    public function getDescription()
    {
        return 'My crud generator. The same as a native, but he is mine...';
    }
    
    // ...
}
```

Abra o gii e você verá que um novo gerador irá aparecer.
