Установка
=========

Установка состоит из двух частей: получение пакета расширения через Composer и конфигурирование приложения.

## Установка расширения

Предпочтительный способ установки расширения через [Composer](https://getcomposer.org/download/).

Для этого запустите команду

```
php composer.phar require --prefer-dist yiisoft/yii2-smarty
```

или добавьте

```
"yiisoft/yii2-smarty": "~2.0.0"
```

в секцию require вашего composer.json.

## Конфигурирование приложения

Чтобы использовать шаблонизатор Smarty, вам необходимо сконфигурировать компонент `view` следующим образом:

```php
return [
    //....
    'components' => [
        'view' => [
            'renderers' => [
                'tpl' => [
                    'class' => 'yii\smarty\ViewRenderer',
                    //'cachePath' => '@runtime/Smarty/cache',
                ],
            ],
        ],
    ],
];
```

После этого вы можете создавать шаблоны в файлах с расширением `.tpl` (или использовать другое расширение файла, 
предварительно переконфигурировав компонент). В отличие от стандартных файлов представления, при использовании шаблонизатора 
Smarty вы должны указывать расширение в вызове методов контроллера `$this->render()` или `$this->renderPartial()`:

```php
return $this->render('renderer.tpl', ['username' => 'Alex']);
```
