
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `oscticket1177`
--

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]api_key`
--

CREATE TABLE `[[dbprefix]]api_key` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isactive` tinyint(1) NOT NULL DEFAULT '1',
  `ipaddr` varchar(64) NOT NULL,
  `apikey` varchar(255) NOT NULL,
  `can_create_tickets` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `can_exec_cron` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `notes` text,
  `updated` datetime NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `apikey` (`apikey`),
  KEY `ipaddr` (`ipaddr`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]attachment`
--

CREATE TABLE `[[dbprefix]]attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(11) unsigned NOT NULL,
  `type` char(1) NOT NULL,
  `file_id` int(11) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `inline` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `lang` varchar(16) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file-type` (`object_id`,`file_id`,`type`),
  UNIQUE KEY `file_object` (`file_id`,`object_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `[[dbprefix]]attachment`
--

INSERT INTO `[[dbprefix]]attachment` VALUES
(1, 1, 'C', 2, NULL, 0, NULL),
(2, 8, 'T', 1, NULL, 1, NULL),
(3, 9, 'T', 1, NULL, 1, NULL),
(4, 10, 'T', 1, NULL, 1, NULL),
(5, 11, 'T', 1, NULL, 1, NULL),
(6, 12, 'T', 1, NULL, 1, NULL),
(7, 13, 'T', 1, NULL, 1, NULL),
(8, 14, 'T', 1, NULL, 1, NULL),
(9, 16, 'T', 1, NULL, 1, NULL),
(10, 17, 'T', 1, NULL, 1, NULL),
(11, 18, 'T', 1, NULL, 1, NULL),
(12, 19, 'T', 1, NULL, 1, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]canned_response`
--

CREATE TABLE `[[dbprefix]]canned_response` (
  `canned_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dept_id` int(10) unsigned NOT NULL DEFAULT '0',
  `isenabled` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `title` varchar(255) NOT NULL DEFAULT '',
  `response` text NOT NULL,
  `lang` varchar(16) NOT NULL DEFAULT 'en_US',
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`canned_id`),
  UNIQUE KEY `title` (`title`),
  KEY `dept_id` (`dept_id`),
  KEY `active` (`isenabled`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]canned_response`
--

INSERT INTO `[[dbprefix]]canned_response` VALUES
(1, 0, 1, 'What is osTicket (sample)?', 'osTicket is a widely-used open source support ticket system, an\nattractive alternative to higher-cost and complex customer support\nsystems - simple, lightweight, reliable, open source, web-based and easy\nto setup and use.', 'en_US', NULL, '[[regtime]]', '[[regtime]]'),
(2, 0, 1, 'Sample (with variables)', 'Hi %{ticket.name.first},\n<br>\n<br>\nYour ticket #%{ticket.number} created on %{ticket.create_date} is in\n%{ticket.dept.name} department.', 'en_US', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]config`
--

CREATE TABLE `[[dbprefix]]config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `namespace` varchar(64) NOT NULL,
  `key` varchar(64) NOT NULL,
  `value` text NOT NULL,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `namespace` (`namespace`,`key`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=99 ;

--
-- Dumping data for table `[[dbprefix]]config`
--

INSERT INTO `[[dbprefix]]config` VALUES
(1, 'core', 'admin_email', '[[admin_email]]', '[[regtime]]'),
(2, 'core', 'helpdesk_url', '[[softurl]]/', '[[regtime]]'),
(3, 'core', 'helpdesk_title', '[[site_name]]', '[[regtime]]'),
(4, 'core', 'schema_signature', '83a22ba22b1a6a624fcb1da03882ac1b', '[[regtime]]'),
(5, 'schedule.1', 'configuration', '{"holidays":[4]}', '[[regtime]]'),
(6, 'core', 'time_format', 'hh:mm a', '[[regtime]]'),
(7, 'core', 'date_format', 'MM/dd/y', '[[regtime]]'),
(8, 'core', 'datetime_format', 'MM/dd/y h:mm a', '[[regtime]]'),
(9, 'core', 'daydatetime_format', 'EEE, MMM d y h:mm a', '[[regtime]]'),
(10, 'core', 'default_priority_id', '2', '[[regtime]]'),
(11, 'core', 'enable_daylight_saving', '', '[[regtime]]'),
(12, 'core', 'reply_separator', '-- reply above this line --', '[[regtime]]'),
(13, 'core', 'isonline', '1', '[[regtime]]'),
(14, 'core', 'staff_ip_binding', '', '[[regtime]]'),
(15, 'core', 'staff_max_logins', '4', '[[regtime]]'),
(16, 'core', 'staff_login_timeout', '2', '[[regtime]]'),
(17, 'core', 'staff_session_timeout', '30', '[[regtime]]'),
(18, 'core', 'passwd_reset_period', '', '[[regtime]]'),
(19, 'core', 'client_max_logins', '4', '[[regtime]]'),
(20, 'core', 'client_login_timeout', '2', '[[regtime]]'),
(21, 'core', 'client_session_timeout', '30', '[[regtime]]'),
(22, 'core', 'max_page_size', '25', '[[regtime]]'),
(23, 'core', 'max_open_tickets', '', '[[regtime]]'),
(24, 'core', 'autolock_minutes', '3', '[[regtime]]'),
(25, 'core', 'default_smtp_id', '', '[[regtime]]'),
(26, 'core', 'use_email_priority', '', '[[regtime]]'),
(27, 'core', 'enable_kb', '', '[[regtime]]'),
(28, 'core', 'enable_premade', '1', '[[regtime]]'),
(29, 'core', 'enable_captcha', '', '[[regtime]]'),
(30, 'core', 'enable_auto_cron', '', '[[regtime]]'),
(31, 'core', 'enable_mail_polling', '', '[[regtime]]'),
(32, 'core', 'send_sys_errors', '1', '[[regtime]]'),
(33, 'core', 'send_sql_errors', '1', '[[regtime]]'),
(34, 'core', 'send_login_errors', '1', '[[regtime]]'),
(35, 'core', 'save_email_headers', '1', '[[regtime]]'),
(36, 'core', 'strip_quoted_reply', '1', '[[regtime]]'),
(37, 'core', 'ticket_autoresponder', '', '[[regtime]]'),
(38, 'core', 'message_autoresponder', '', '[[regtime]]'),
(39, 'core', 'ticket_notice_active', '1', '[[regtime]]'),
(40, 'core', 'ticket_alert_active', '1', '[[regtime]]'),
(41, 'core', 'ticket_alert_admin', '1', '[[regtime]]'),
(42, 'core', 'ticket_alert_dept_manager', '1', '[[regtime]]'),
(43, 'core', 'ticket_alert_dept_members', '', '[[regtime]]'),
(44, 'core', 'message_alert_active', '1', '[[regtime]]'),
(45, 'core', 'message_alert_laststaff', '1', '[[regtime]]'),
(46, 'core', 'message_alert_assigned', '1', '[[regtime]]'),
(47, 'core', 'message_alert_dept_manager', '', '[[regtime]]'),
(48, 'core', 'note_alert_active', '', '[[regtime]]'),
(49, 'core', 'note_alert_laststaff', '1', '[[regtime]]'),
(50, 'core', 'note_alert_assigned', '1', '[[regtime]]'),
(51, 'core', 'note_alert_dept_manager', '', '[[regtime]]'),
(52, 'core', 'transfer_alert_active', '', '[[regtime]]'),
(53, 'core', 'transfer_alert_assigned', '', '[[regtime]]'),
(54, 'core', 'transfer_alert_dept_manager', '1', '[[regtime]]'),
(55, 'core', 'transfer_alert_dept_members', '', '[[regtime]]'),
(56, 'core', 'overdue_alert_active', '1', '[[regtime]]'),
(57, 'core', 'overdue_alert_assigned', '1', '[[regtime]]'),
(58, 'core', 'overdue_alert_dept_manager', '1', '[[regtime]]'),
(59, 'core', 'overdue_alert_dept_members', '', '[[regtime]]'),
(60, 'core', 'assigned_alert_active', '1', '[[regtime]]'),
(61, 'core', 'assigned_alert_staff', '1', '[[regtime]]'),
(62, 'core', 'assigned_alert_team_lead', '', '[[regtime]]'),
(63, 'core', 'assigned_alert_team_members', '', '[[regtime]]'),
(64, 'core', 'auto_claim_tickets', '1', '[[regtime]]'),
(65, 'core', 'auto_refer_closed', '1', '[[regtime]]'),
(66, 'core', 'collaborator_ticket_visibility', '1', '[[regtime]]'),
(67, 'core', 'require_topic_to_close', '', '[[regtime]]'),
(68, 'core', 'show_related_tickets', '1', '[[regtime]]'),
(69, 'core', 'show_assigned_tickets', '1', '[[regtime]]'),
(70, 'core', 'show_answered_tickets', '', '[[regtime]]'),
(71, 'core', 'hide_staff_name', '', '[[regtime]]'),
(72, 'core', 'disable_agent_collabs', '', '[[regtime]]'),
(73, 'core', 'overlimit_notice_active', '', '[[regtime]]'),
(74, 'core', 'email_attachments', '1', '[[regtime]]'),
(75, 'core', 'ticket_number_format', '######', '[[regtime]]'),
(76, 'core', 'ticket_sequence_id', '', '[[regtime]]'),
(77, 'core', 'queue_bucket_counts', '', '[[regtime]]'),
(78, 'core', 'allow_external_images', '', '[[regtime]]'),
(79, 'core', 'task_number_format', '#', '[[regtime]]'),
(80, 'core', 'task_sequence_id', '2', '[[regtime]]'),
(81, 'core', 'log_level', '2', '[[regtime]]'),
(82, 'core', 'log_graceperiod', '12', '[[regtime]]'),
(83, 'core', 'client_registration', 'public', '[[regtime]]'),
(84, 'core', 'default_ticket_queue', '1', '[[regtime]]'),
(85, 'core', 'embedded_domain_whitelist', 'youtube.com, dailymotion.com, vimeo.com, player.vimeo.com, web.microsoftstream.com', '[[regtime]]'),
(86, 'core', 'max_file_size', '16777216', '[[regtime]]'),
(87, 'core', 'landing_page_id', '1', '[[regtime]]'),
(88, 'core', 'thank-you_page_id', '2', '[[regtime]]'),
(89, 'core', 'offline_page_id', '3', '[[regtime]]'),
(90, 'core', 'system_language', '[[language]]', '[[regtime]]'),
(91, 'mysqlsearch', 'reindex', '1', '[[regtime]]'),
(92, 'core', 'default_email_id', '1', '[[regtime]]'),
(93, 'core', 'alert_email_id', '2', '[[regtime]]'),
(94, 'core', 'default_dept_id', '1', '[[regtime]]'),
(95, 'core', 'default_sla_id', '1', '[[regtime]]'),
(96, 'core', 'schedule_id', '1', '[[regtime]]'),
(97, 'core', 'default_template_id', '1', '[[regtime]]'),
(98, 'core', 'default_timezone', 'Asia/Kolkata', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]content`
--

CREATE TABLE `[[dbprefix]]content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `isactive` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `type` varchar(32) NOT NULL DEFAULT 'other',
  `name` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

--
-- Dumping data for table `[[dbprefix]]content`
--

INSERT INTO `[[dbprefix]]content` VALUES
(1, 1, 'landing', 'Landing', '<h1>Welcome to the Support Center</h1> <p> In order to streamline support requests and better serve you, we utilize a support ticket system. Every support request is assigned a unique ticket number which you can use to track the progress and responses online. For your reference we provide complete archives and history of all your support requests. A valid email address is required to submit a ticket. </p>', 'The Landing Page refers to the content of the Customer Portal''s initial view. The template modifies the content seen above the two links <strong>Open a New Ticket</strong> and <strong>Check Ticket Status</strong>.', '[[regtime]]', '[[regtime]]'),
(2, 1, 'thank-you', 'Thank You', '<div>%{ticket.name},\n<br>\n<br>\nThank you for contacting us.\n<br>\n<br>\nA support ticket request has been created and a representative will be\ngetting back to you shortly if necessary.</p>\n<br>\n<br>\nSupport Team\n</div>', 'This template defines the content displayed on the Thank-You page after a\nClient submits a new ticket in the Client Portal.', '[[regtime]]', '[[regtime]]'),
(3, 1, 'offline', 'Offline', '<div><h1>\n<span style="font-size: medium">Support Ticket System Offline</span>\n</h1>\n<p>Thank you for your interest in contacting us.</p>\n<p>Our helpdesk is offline at the moment, please check back at a later\ntime.</p>\n</div>', 'The Offline Page appears in the Customer Portal when the Help Desk is offline.', '[[regtime]]', '[[regtime]]'),
(4, 1, 'registration-staff', 'Welcome to osTicket', '<h3><strong>Hi %{recipient.name.first},</strong></h3> <div> We''ve created an account for you at our help desk at %{url}.<br /> <br /> Please follow the link below to confirm your account and gain access to your tickets.<br /> <br /> <a href="%{link}">%{link}</a><br /> <br /> <em style="font-size: small">Your friendly Customer Support System<br /> %{company.name}</em> </div>', 'This template defines the initial email (optional) sent to Agents when an account is created on their behalf.', '[[regtime]]', '[[regtime]]'),
(5, 1, 'pwreset-staff', 'osTicket Staff Password Reset', '<h3><strong>Hi %{staff.name.first},</strong></h3> <div> A password reset request has been submitted on your behalf for the helpdesk at %{url}.<br /> <br /> If you feel that this has been done in error, delete and disregard this email. Your account is still secure and no one has been given access to it. It is not locked and your password has not been reset. Someone could have mistakenly entered your email address.<br /> <br /> Follow the link below to login to the help desk and change your password.<br /> <br /> <a href="%{link}">%{link}</a><br /> <br /> <em style="font-size: small">Your friendly Customer Support System</em> <br /> <img src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" alt="Powered by osTicket" width="126" height="19" style="width: 126px" /> </div>', 'This template defines the email sent to Staff who select the <strong>Forgot My Password</strong> link on the Staff Control Panel Log In page.', '[[regtime]]', '[[regtime]]'),
(6, 1, 'banner-staff', 'Authentication Required', '', 'This is the initial message and banner shown on the Staff Log In page. The first input field refers to the red-formatted text that appears at the top. The latter textarea is for the banner content which should serve as a disclaimer.', '[[regtime]]', '[[regtime]]'),
(7, 1, 'registration-client', 'Welcome to %{company.name}', '<h3><strong>Hi %{recipient.name.first},</strong></h3> <div> We''ve created an account for you at our help desk at %{url}.<br /> <br /> Please follow the link below to confirm your account and gain access to your tickets.<br /> <br /> <a href="%{link}">%{link}</a><br /> <br /> <em style="font-size: small">Your friendly Customer Support System <br /> %{company.name}</em> </div>', 'This template defines the email sent to Clients when their account has been created in the Client Portal or by an Agent on their behalf. This email serves as an email address verification. Please use %{link} somewhere in the body.', '[[regtime]]', '[[regtime]]'),
(8, 1, 'pwreset-client', '%{company.name} Help Desk Access', '<h3><strong>Hi %{user.name.first},</strong></h3> <div> A password reset request has been submitted on your behalf for the helpdesk at %{url}.<br /> <br /> If you feel that this has been done in error, delete and disregard this email. Your account is still secure and no one has been given access to it. It is not locked and your password has not been reset. Someone could have mistakenly entered your email address.<br /> <br /> Follow the link below to login to the help desk and change your password.<br /> <br /> <a href="%{link}">%{link}</a><br /> <br /> <em style="font-size: small">Your friendly Customer Support System <br /> %{company.name}</em> </div>', 'This template defines the email sent to Clients who select the <strong>Forgot My Password</strong> link on the Client Log In page.', '[[regtime]]', '[[regtime]]'),
(9, 1, 'banner-client', 'Sign in to %{company.name}', 'To better serve you, we encourage our Clients to register for an account.', 'This composes the header on the Client Log In page. It can be useful to inform your Clients about your log in and registration policies.', '[[regtime]]', '[[regtime]]'),
(10, 1, 'registration-confirm', 'Account registration', '<div><strong>Thanks for registering for an account.</strong><br/> <br /> We''ve just sent you an email to the address you entered. Please follow the link in the email to confirm your account and gain access to your tickets. </div>', 'This templates defines the page shown to Clients after completing the registration form. The template should mention that the system is sending them an email confirmation link and what is the next step in the registration process.', '[[regtime]]', '[[regtime]]'),
(11, 1, 'registration-thanks', 'Account Confirmed!', '<div> <strong>Thanks for registering for an account.</strong><br /> <br /> You''ve confirmed your email address and successfully activated your account. You may proceed to open a new ticket or manage existing tickets.<br /> <br /> <em>Your friendly support center</em><br /> %{company.name} </div>', 'This template defines the content displayed after Clients successfully register by confirming their account. This page should inform the user that registration is complete and that the Client can now submit a ticket or access existing tickets.', '[[regtime]]', '[[regtime]]'),
(12, 1, 'access-link', 'Ticket [#%{ticket.number}] Access Link', '<h3><strong>Hi %{recipient.name.first},</strong></h3> <div> An access link request for ticket #%{ticket.number} has been submitted on your behalf for the helpdesk at %{url}.<br /> <br /> Follow the link below to check the status of the ticket #%{ticket.number}.<br /> <br /> <a href="%{recipient.ticket_link}">%{recipient.ticket_link}</a><br /> <br /> If you <strong>did not</strong> make the request, please delete and disregard this email. Your account is still secure and no one has been given access to the ticket. Someone could have mistakenly entered your email address.<br /> <br /> --<br /> %{company.name} </div>', 'This template defines the notification for Clients that an access link was sent to their email. The ticket number and email address trigger the access link.', '[[regtime]]', '[[regtime]]'),
(13, 1, 'email2fa-staff', 'osTicket Two Factor Authentication', '<h3><strong>Hi %{staff.name.first},</strong></h3> <div> You have just logged into for the helpdesk at %{url}.<br /> <br /> Use the verification code below to finish logging into the helpdesk.<br /> <br /> %{otp}<br /> <br /> <em style="font-size: small">Your friendly Customer Support System</em> <br /> <img src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" alt="Powered by osTicket" width="126" height="19" style="width: 126px" /> </div>', 'This template defines the email sent to Staff who use Email for Two Factor Authentication', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]department`
--

CREATE TABLE `[[dbprefix]]department` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned DEFAULT NULL,
  `tpl_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sla_id` int(10) unsigned NOT NULL DEFAULT '0',
  `schedule_id` int(10) unsigned NOT NULL DEFAULT '0',
  `email_id` int(10) unsigned NOT NULL DEFAULT '0',
  `autoresp_email_id` int(10) unsigned NOT NULL DEFAULT '0',
  `manager_id` int(10) unsigned NOT NULL DEFAULT '0',
  `flags` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  `signature` text NOT NULL,
  `ispublic` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `group_membership` tinyint(1) NOT NULL DEFAULT '0',
  `ticket_auto_response` tinyint(1) NOT NULL DEFAULT '1',
  `message_auto_response` tinyint(1) NOT NULL DEFAULT '0',
  `path` varchar(128) NOT NULL DEFAULT '/',
  `updated` datetime NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`,`pid`),
  KEY `manager_id` (`manager_id`),
  KEY `autoresp_email_id` (`autoresp_email_id`),
  KEY `tpl_id` (`tpl_id`),
  KEY `flags` (`flags`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]department`
--

INSERT INTO `[[dbprefix]]department` VALUES
(1, NULL, 0, 0, 0, 0, 0, 0, 4, 'Support', 'Support Department', 1, 1, 1, 1, '/1/', '[[regtime]]', '[[regtime]]'),
(2, NULL, 0, 1, 0, 0, 0, 0, 4, 'Sales', 'Sales and Customer Retention', 1, 1, 1, 1, '/2/', '[[regtime]]', '[[regtime]]'),
(3, NULL, 0, 0, 0, 0, 0, 0, 4, 'Maintenance', 'Maintenance Department', 1, 0, 1, 1, '/3/', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]draft`
--

CREATE TABLE `[[dbprefix]]draft` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) unsigned NOT NULL,
  `namespace` varchar(32) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `extra` text,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `namespace` (`namespace`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email`
--

CREATE TABLE `[[dbprefix]]email` (
  `email_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `noautoresp` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `priority_id` int(11) unsigned NOT NULL DEFAULT '2',
  `dept_id` int(11) unsigned NOT NULL DEFAULT '0',
  `topic_id` int(11) unsigned NOT NULL DEFAULT '0',
  `email` varchar(255) NOT NULL DEFAULT '',
  `name` varchar(255) NOT NULL DEFAULT '',
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`email_id`),
  UNIQUE KEY `email` (`email`),
  KEY `priority_id` (`priority_id`),
  KEY `dept_id` (`dept_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `[[dbprefix]]email`
--

INSERT INTO `[[dbprefix]]email` VALUES
(1, 0, 2, 1, 0, '[[system_email]]', 'Support', NULL, '[[regtime]]', '[[regtime]]'),
(2, 0, 2, 1, 0, '[[alerts_email]]', 'osTicket Alerts', NULL, '[[regtime]]', '[[regtime]]'),
(3, 0, 2, 1, 0, '[[noreply_email]]', '', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_account`
--

CREATE TABLE `[[dbprefix]]email_account` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_id` int(11) unsigned NOT NULL,
  `type` enum('mailbox','smtp') NOT NULL DEFAULT 'mailbox',
  `auth_bk` varchar(128) NOT NULL,
  `auth_id` varchar(16) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `host` varchar(128) NOT NULL DEFAULT '',
  `port` int(11) NOT NULL,
  `folder` varchar(255) DEFAULT NULL,
  `protocol` enum('IMAP','POP','SMTP','OTHER') NOT NULL DEFAULT 'OTHER',
  `encryption` enum('NONE','AUTO','SSL') NOT NULL DEFAULT 'AUTO',
  `fetchfreq` tinyint(3) unsigned NOT NULL DEFAULT '5',
  `fetchmax` tinyint(4) unsigned DEFAULT '30',
  `postfetch` enum('archive','delete','nothing') NOT NULL DEFAULT 'nothing',
  `archivefolder` varchar(255) DEFAULT NULL,
  `allow_spoofing` tinyint(1) unsigned DEFAULT '0',
  `num_errors` int(11) unsigned NOT NULL DEFAULT '0',
  `last_error_msg` tinytext,
  `last_error` datetime DEFAULT NULL,
  `last_activity` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `email_id` (`email_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_template`
--

CREATE TABLE `[[dbprefix]]email_template` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tpl_id` int(11) unsigned NOT NULL,
  `code_name` varchar(32) NOT NULL,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `body` text NOT NULL,
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `template_lookup` (`tpl_id`,`code_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

--
-- Dumping data for table `[[dbprefix]]email_template`
--

INSERT INTO `[[dbprefix]]email_template` VALUES
(1, 1, 'ticket.autoresp', 'Support Ticket Opened [#%{ticket.number}]', '<h3><strong>Dear %{recipient.name.first},</strong></h3> <p>A request for support has been created and assigned #%{ticket.number}. A representative will follow-up with you as soon as possible. You can <a href="%%7Brecipient.ticket_link%7D">view this ticket''s progress online</a>. </p> <br /> <div style="color:rgb(127, 127, 127)">Your %{company.name} Team, <br /> %{signature} </div> <hr /> <div style="color:rgb(127, 127, 127);font-size:small"><em>If you wish to provide additional comments or information regarding the issue, please reply to this email or <a href="%%7Brecipient.ticket_link%7D"><span style="color:rgb(84, 141, 212)">login to your account</span></a> for a complete archive of your support requests.</em></div>', NULL, '[[regtime]]', '[[regtime]]'),
(2, 1, 'ticket.autoreply', 'Re: %{ticket.subject} [#%{ticket.number}]', '<h3><strong>Dear %{recipient.name.first},</strong></h3> A request for support has been created and assigned ticket <a href="%%7Brecipient.ticket_link%7D">#%{ticket.number}</a> with the following automatic reply <br /> <br /> Topic: <strong>%{ticket.topic.name}</strong> <br /> Subject: <strong>%{ticket.subject}</strong> <br /> <br /> %{response} <br /> <br /> <div style="color:rgb(127, 127, 127)">Your %{company.name} Team,<br /> %{signature}</div> <hr /> <div style="color:rgb(127, 127, 127);font-size:small"><em>We hope this response has sufficiently answered your questions. If you wish to provide additional comments or information, please reply to this email or <a href="%%7Brecipient.ticket_link%7D"><span style="color:rgb(84, 141, 212)">login to your account</span></a> for a complete archive of your support requests.</em></div>', NULL, '[[regtime]]', '[[regtime]]'),
(3, 1, 'message.autoresp', 'Message Confirmation', '<h3><strong>Dear %{recipient.name.first},</strong></h3> Your reply to support request <a href="%%7Brecipient.ticket_link%7D">#%{ticket.number}</a> has been noted <br /> <br /> <div style="color:rgb(127, 127, 127)">Your %{company.name} Team,<br /> %{signature} </div> <hr /> <div style="color:rgb(127, 127, 127);font-size:small;text-align:center"><em>You can view the support request progress <a href="%%7Brecipient.ticket_link%7D">online here</a></em> </div>', NULL, '[[regtime]]', '[[regtime]]'),
(4, 1, 'ticket.notice', '%{ticket.subject} [#%{ticket.number}]', '<h3><strong>Dear %{recipient.name.first},</strong></h3> Our customer care team has created a ticket, <a href="%%7Brecipient.ticket_link%7D">#%{ticket.number}</a> on your behalf, with the following details and summary: <br /> <br /> Topic: <strong>%{ticket.topic.name}</strong> <br /> Subject: <strong>%{ticket.subject}</strong> <br /> <br /> %{message} <br /> <br /> %{response} <br /> <br /> If need be, a representative will follow-up with you as soon as possible. You can also <a href="%%7Brecipient.ticket_link%7D">view this ticket''s progress online</a>. <br /> <br /> <div style="color:rgb(127, 127, 127)">Your %{company.name} Team,<br /> %{signature}</div> <hr /> <div style="color:rgb(127, 127, 127);font-size:small"><em>If you wish to provide additional comments or information regarding the issue, please reply to this email or <a href="%%7Brecipient.ticket_link%7D"><span style="color:rgb(84, 141, 212)">login to your account</span></a> for a complete archive of your support requests.</em></div>', NULL, '[[regtime]]', '[[regtime]]'),
(5, 1, 'ticket.overlimit', 'Open Tickets Limit Reached', '<h3><strong>Dear %{ticket.name.first},</strong></h3> You have reached the maximum number of open tickets allowed. To be able to open another ticket, one of your pending tickets must be closed. To update or add comments to an open ticket simply <a href="%%7Burl%7D/tickets.php?e=%%7Bticket.email%7D">login to our helpdesk</a>. <br /> <br /> Thank you,<br /> Support Ticket System', NULL, '[[regtime]]', '[[regtime]]'),
(6, 1, 'ticket.reply', 'Re: %{ticket.subject} [#%{ticket.number}]', '<h3><strong>Dear %{recipient.name.first},</strong></h3> %{response} <br /> <br /> <div style="color:rgb(127, 127, 127)">Your %{company.name} Team,<br /> %{signature} </div> <hr /> <div style="color:rgb(127, 127, 127);font-size:small;text-align:center"><em>We hope this response has sufficiently answered your questions. If not, please do not send another email. Instead, reply to this email or <a href="%%7Brecipient.ticket_link%7D" style="color:rgb(84, 141, 212)">login to your account</a> for a complete archive of all your support requests and responses.</em></div>', NULL, '[[regtime]]', '[[regtime]]'),
(7, 1, 'ticket.activity.notice', 'Re: %{ticket.subject} [#%{ticket.number}]', '<h3><strong>Dear %{recipient.name.first},</strong></h3> <div><em>%{poster.name}</em> just logged a message to a ticket in which you participate. </div> <br /> %{message} <br /> <br /> <hr /> <div style="color:rgb(127, 127, 127);font-size:small;text-align:center"><em>You''re getting this email because you are a collaborator on ticket <a href="%%7Brecipient.ticket_link%7D" style="color:rgb(84, 141, 212)">#%{ticket.number}</a>. To participate, simply reply to this email or <a href="%%7Brecipient.ticket_link%7D" style="color:rgb(84, 141, 212)">click here</a> for a complete archive of the ticket thread.</em> </div>', NULL, '[[regtime]]', '[[regtime]]'),
(8, 1, 'ticket.alert', 'New Ticket Alert', '<h2>Hi %{recipient.name},</h2> New ticket #%{ticket.number} created <br /> <br /> <table><tbody><tr><td><strong>From</strong>: </td> <td>%{ticket.name} </td> </tr> <tr><td><strong>Department</strong>: </td> <td>%{ticket.dept.name} </td> </tr> </tbody> </table> <br /> %{message} <br /> <br /> <hr /> <div>To view or respond to the ticket, please <a href="%%7Bticket.staff_link%7D">login</a> to the support ticket system</div> <em style="font-size:small">Your friendly Customer Support System</em> <br /> <a href="https://osticket.com/"><img width="126" height="19" style="width:126px" alt="Powered By osTicket" src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" /></a>', NULL, '[[regtime]]', '[[regtime]]'),
(9, 1, 'message.alert', 'New Message Alert', '<h3><strong>Hi %{recipient.name},</strong></h3> New message appended to ticket <a href="%%7Bticket.staff_link%7D">#%{ticket.number}</a> <br /> <br /> <table><tbody><tr><td><strong>From</strong>: </td> <td>%{poster.name} </td> </tr> <tr><td><strong>Department</strong>: </td> <td>%{ticket.dept.name} </td> </tr> </tbody> </table> <br /> %{message} <br /> <br /> <hr /> <div>To view or respond to the ticket, please <a href="%%7Bticket.staff_link%7D"><span style="color:rgb(84, 141, 212)">login</span></a> to the support ticket system</div> <em style="color:rgb(127,127,127);font-size:small">Your friendly Customer Support System</em><br /> <img src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" alt="Powered by osTicket" width="126" height="19" style="width:126px" />', NULL, '[[regtime]]', '[[regtime]]'),
(10, 1, 'note.alert', 'New Internal Activity Alert', '<h3><strong>Hi %{recipient.name},</strong></h3> An agent has logged activity on ticket <a href="%%7Bticket.staff_link%7D">#%{ticket.number}</a> <br /> <br /> <table><tbody><tr><td><strong>From</strong>: </td> <td>%{note.poster} </td> </tr> <tr><td><strong>Title</strong>: </td> <td>%{note.title} </td> </tr> </tbody> </table> <br /> %{note.message} <br /> <br /> <hr /> To view/respond to the ticket, please <a href="%%7Bticket.staff_link%7D">login</a> to the support ticket system <br /> <br /> <em style="font-size:small">Your friendly Customer Support System</em> <br /> <img src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" alt="Powered by osTicket" width="126" height="19" style="width:126px" />', NULL, '[[regtime]]', '[[regtime]]'),
(11, 1, 'assigned.alert', 'Ticket Assigned to you', '<h3><strong>Hi %{assignee.name.first},</strong></h3> Ticket <a href="%%7Bticket.staff_link%7D">#%{ticket.number}</a> has been assigned to you by %{assigner.name.short} <br /> <br /> <table><tbody><tr><td><strong>From</strong>: </td> <td>%{ticket.name} </td> </tr> <tr><td><strong>Subject</strong>: </td> <td>%{ticket.subject} </td> </tr> </tbody> </table> <br /> %{comments} <br /> <br /> <hr /> <div>To view/respond to the ticket, please <a href="%%7Bticket.staff_link%7D"><span style="color:rgb(84, 141, 212)">login</span></a> to the support ticket system</div> <em style="font-size:small">Your friendly Customer Support System</em> <br /> <img src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" alt="Powered by osTicket" width="126" height="19" style="width:126px" />', NULL, '[[regtime]]', '[[regtime]]'),
(12, 1, 'transfer.alert', 'Ticket #%{ticket.number} transfer - %{ticket.dept.name}', '<h3>Hi %{recipient.name},</h3> Ticket <a href="%%7Bticket.staff_link%7D">#%{ticket.number}</a> has been transferred to the %{ticket.dept.name} department by <strong>%{staff.name.short}</strong> <br /> <br /> <blockquote>%{comments} </blockquote> <hr /> <div>To view or respond to the ticket, please <a href="%%7Bticket.staff_link%7D">login</a> to the support ticket system. </div> <em style="font-size:small">Your friendly Customer Support System</em> <br /> <a href="https://osticket.com/"><img width="126" height="19" alt="Powered By osTicket" style="width:126px" src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" /></a>', NULL, '[[regtime]]', '[[regtime]]'),
(13, 1, 'ticket.overdue', 'Stale Ticket Alert', '<h3><strong>Hi %{recipient.name}</strong>,</h3> A ticket, <a href="%%7Bticket.staff_link%7D">#%{ticket.number}</a> is seriously overdue. <br /> <br /> We should all work hard to guarantee that all tickets are being addressed in a timely manner. <br /> <br /> Signed,<br /> %{ticket.dept.manager.name} <hr /> <div>To view or respond to the ticket, please <a href="%%7Bticket.staff_link%7D"><span style="color:rgb(84, 141, 212)">login</span></a> to the support ticket system. You''re receiving this notice because the ticket is assigned directly to you or to a team or department of which you''re a member.</div> <em style="font-size:small">Your friendly <span style="font-size:smaller">(although with limited patience)</span> Customer Support System</em><br /> <img src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" height="19" alt="Powered by osTicket" width="126" style="width:126px" />', NULL, '[[regtime]]', '[[regtime]]'),
(14, 1, 'task.alert', 'New Task Alert', '<h2>Hi %{recipient.name},</h2> New task <a href="%%7Btask.staff_link%7D">#%{task.number}</a> created <br /> <br /> <table><tbody><tr><td><strong>Department</strong>: </td> <td>%{task.dept.name} </td> </tr> </tbody> </table> <br /> %{task.description} <br /> <br /> <hr /> <div>To view or respond to the task, please <a href="%%7Btask.staff_link%7D">login</a> to the support system</div> <em style="font-size:small">Your friendly Customer Support System</em> <br /> <a href="https://osticket.com/"><img width="126" height="19" style="width:126px" alt="Powered By osTicket" src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" /></a>', NULL, '[[regtime]]', '[[regtime]]'),
(15, 1, 'task.activity.notice', 'Re: %{task.title} [#%{task.number}]', '<h3><strong>Dear %{recipient.name.first},</strong></h3> <div><em>%{poster.name}</em> just logged a message to a task in which you participate. </div> <br /> %{message} <br /> <br /> <hr /> <div style="color:rgb(127, 127, 127);font-size:small;text-align:center"><em>You''re getting this email because you are a collaborator on task #%{task.number}. To participate, simply reply to this email.</em> </div>', NULL, '[[regtime]]', '[[regtime]]'),
(16, 1, 'task.activity.alert', 'Task Activity [#%{task.number}] - %{activity.title}', '<h3><strong>Hi %{recipient.name},</strong></h3> Task <a href="%%7Btask.staff_link%7D">#%{task.number}</a> updated: %{activity.description} <br /> <br /> %{message} <br /> <br /> <hr /> <div>To view or respond to the task, please <a href="%%7Btask.staff_link%7D"><span style="color:rgb(84, 141, 212)">login</span></a> to the support system</div> <em style="color:rgb(127,127,127);font-size:small">Your friendly Customer Support System</em><br /> <img src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" alt="Powered by osTicket" width="126" height="19" style="width:126px" />', NULL, '[[regtime]]', '[[regtime]]'),
(17, 1, 'task.assignment.alert', 'Task Assigned to you', '<h3><strong>Hi %{assignee.name.first},</strong></h3> Task <a href="%%7Btask.staff_link%7D">#%{task.number}</a> has been assigned to you by %{assigner.name.short} <br /> <br /> %{comments} <br /> <br /> <hr /> <div>To view/respond to the task, please <a href="%%7Btask.staff_link%7D"><span style="color:rgb(84, 141, 212)">login</span></a> to the support system</div> <em style="font-size:small">Your friendly Customer Support System</em> <br /> <img src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" alt="Powered by osTicket" width="126" height="19" style="width:126px" />', NULL, '[[regtime]]', '[[regtime]]'),
(18, 1, 'task.transfer.alert', 'Task #%{task.number} transfer - %{task.dept.name}', '<h3>Hi %{recipient.name},</h3> Task <a href="%%7Btask.staff_link%7D">#%{task.number}</a> has been transferred to the %{task.dept.name} department by <strong>%{staff.name.short}</strong> <br /> <br /> <blockquote>%{comments} </blockquote> <hr /> <div>To view or respond to the task, please <a href="%%7Btask.staff_link%7D">login</a> to the support system. </div> <em style="font-size:small">Your friendly Customer Support System</em> <br /> <a href="https://osticket.com/"><img width="126" height="19" alt="Powered By osTicket" style="width:126px" src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" /></a>', NULL, '[[regtime]]', '[[regtime]]'),
(19, 1, 'task.overdue.alert', 'Stale Task Alert', '<h3><strong>Hi %{recipient.name}</strong>,</h3> A task, <a href="%%7Btask.staff_link%7D">#%{task.number}</a> is seriously overdue. <br /> <br /> We should all work hard to guarantee that all tasks are being addressed in a timely manner. <br /> <br /> Signed,<br /> %{task.dept.manager.name} <hr /> <div>To view or respond to the task, please <a href="%%7Btask.staff_link%7D"><span style="color:rgb(84, 141, 212)">login</span></a> to the support system. You''re receiving this notice because the task is assigned directly to you or to a team or department of which you''re a member.</div> <em style="font-size:small">Your friendly <span style="font-size:smaller">(although with limited patience)</span> Customer Support System</em><br /> <img src="cid:b56944cb4722cc5cda9d1e23a3ea7fbc" height="19" alt="Powered by osTicket" width="126" style="width:126px" />', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]email_template_group`
--

CREATE TABLE `[[dbprefix]]email_template_group` (
  `tpl_id` int(11) NOT NULL AUTO_INCREMENT,
  `isactive` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `name` varchar(32) NOT NULL DEFAULT '',
  `lang` varchar(16) NOT NULL DEFAULT 'en_US',
  `notes` text,
  `created` datetime NOT NULL,
  `updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`tpl_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]email_template_group`
--

INSERT INTO `[[dbprefix]]email_template_group` VALUES
(1, 1, 'osTicket Default Template (HTML)', 'en_US', 'Default osTicket templates', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]event`
--

CREATE TABLE `[[dbprefix]]event` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `description` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=22 ;

--
-- Dumping data for table `[[dbprefix]]event`
--

INSERT INTO `[[dbprefix]]event` VALUES
(1, 'created', NULL),
(2, 'closed', NULL),
(3, 'reopened', NULL),
(4, 'assigned', NULL),
(5, 'released', NULL),
(6, 'transferred', NULL),
(7, 'referred', NULL),
(8, 'overdue', NULL),
(9, 'edited', NULL),
(10, 'viewed', NULL),
(11, 'error', NULL),
(12, 'collab', NULL),
(13, 'resent', NULL),
(14, 'deleted', NULL),
(15, 'merged', NULL),
(16, 'unlinked', NULL),
(17, 'linked', NULL),
(18, 'login', NULL),
(19, 'logout', NULL),
(20, 'message', NULL),
(21, 'note', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faq`
--

CREATE TABLE `[[dbprefix]]faq` (
  `faq_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ispublished` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `question` varchar(255) NOT NULL,
  `answer` text NOT NULL,
  `keywords` tinytext,
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`faq_id`),
  UNIQUE KEY `question` (`question`),
  KEY `category_id` (`category_id`),
  KEY `ispublished` (`ispublished`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faq_category`
--

CREATE TABLE `[[dbprefix]]faq_category` (
  `category_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_pid` int(10) unsigned DEFAULT NULL,
  `ispublic` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `name` varchar(125) DEFAULT NULL,
  `description` text NOT NULL,
  `notes` tinytext NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `ispublic` (`ispublic`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]faq_topic`
--

CREATE TABLE `[[dbprefix]]faq_topic` (
  `faq_id` int(10) unsigned NOT NULL,
  `topic_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`faq_id`,`topic_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file`
--

CREATE TABLE `[[dbprefix]]file` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ft` char(1) NOT NULL DEFAULT 'T',
  `bk` char(1) NOT NULL DEFAULT 'D',
  `type` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '',
  `size` bigint(20) unsigned NOT NULL DEFAULT '0',
  `key` varchar(86) CHARACTER SET ascii NOT NULL,
  `signature` varchar(86) CHARACTER SET ascii COLLATE ascii_bin NOT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `attrs` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ft` (`ft`),
  KEY `key` (`key`),
  KEY `signature` (`signature`),
  KEY `type` (`type`),
  KEY `created` (`created`),
  KEY `size` (`size`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]file`
--

INSERT INTO `[[dbprefix]]file` VALUES
(1, 'T', 'D', 'image/png', 9452, 'b56944cb4722cc5cda9d1e23a3ea7fbc', 'gjMyblHhAxCQvzLfPBW3EjMUY1AmQQmz', 'powered-by-osticket.png', NULL, '[[regtime]]'),
(2, 'T', 'D', 'text/plain', 24, 'qzVGkMWtx86n3ccfeGGNagoRoTDtol7o', 'MWtx86n3ccfeGGNafaacpitTxmJ4h3Ls', 'osTicket.txt', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]file_chunk`
--

CREATE TABLE `[[dbprefix]]file_chunk` (
  `file_id` int(11) NOT NULL,
  `chunk_id` int(11) NOT NULL,
  `filedata` longblob NOT NULL,
  PRIMARY KEY (`file_id`,`chunk_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]file_chunk`
--

INSERT INTO `[[dbprefix]]file_chunk` VALUES
(1, 0, 'PNG\r\n\Z\n\0\0\0\rIHDR\0\0\0\0\0\0(\0\0\0G\0\0\nCiCCPICC profile\0\0xڝSwX>eVBl\0"#Y\0a@Ņ\nVHUĂ\nH(gAZU\\8ܧ}zy&j\09R<:OHɽH g\0\0yx~t?o\0\0p.$P&W\0 \0"R\0.T\0\0Sd\n\0\0\0ly|B"\0\r\0I>\0ة\0آ\0\0(G$@\0`UR,\0@".Y2G\0vX@`\0B,\0 8\0C L0ҿ_pH\0˕͗K3\Zw!lBa)f	"#HL\0\0\Z8?flŢko">!\0N_puk[\0V\0h]3	Z\nzy8@P<\n%b0>3o~@z\0q@qanvRB1n#ǅ)4\\,XP"MyRD!ɕ2	w\r\0ONl~Xv\0@~-\Z\0g42y\0\0@+\0͗\0\0\\L\0\0D*AaD@$<B\nAT:\Z18\r\\p`	Aa!:b""aH4 Q"rBj]H#-r9\\@ 2G1Qu@\ZƠst4]k\Z=Kut\0}c1fa\\E`X\Z&cX5V5cX7va$^lGXLXC%#W	1''"O%zxb:XF&!!%^''_H$ɒN\n!%2IIkHH-S>iL&m O:ňL	$RJ5e?2BQͩ:ZImvP/S4u%͛Cˤ-Кigih/t	݃EЗkw\r\rHb(k{/LӗT02goUX**|:V~TUsU?yTU^V}FUP	թU6RwRPQ__c\rFHTc!2eXBrV,kMb[Lvv/{LSCsfffqƱ9ٜJ!\r{--?-jf~7zھbrup@,:m:u	6Qu>cy	Gm7046l18c̐ckihhI''&g5x>fob4ek<abi2ۤĤ)͔kfѴt,ܬج9՜kaټEJ6ǖږ|MV>VyVV׬I\\,mWlPW:˶vm))Sn1\n9a%m;t;|rtuvlp4éĩWggs5KvSmnz˕\Zҵܭm=}M.]=AXq㝧/^v^Y^O&0m[{`:>=e>>z"=#~~~;yN`\Zk5/>B	\rYroc3g,Z0&L~oL̶Gli})*2.QStqt,֬Yg񏩌;jrvgjlRlc웸xEt$	=sl3Ttcܢ˞w<Y5Y|8? BP/OnM򄛅OEQJ<V8;}ChOFu3	OR+y#MVDެq-9R\ri+0(Of++\rym#slLѣRPL/+x[[xHHZ3f#|PظxY"E#Sw.1]Rdxi}h˲PXRUjyRҥC+W4nZcadUj[V*_pFWN_|ymJHnYJjAІ\r_mJtzjʹ5a5[̶6z]V&ֿw{;켵+xWkE}nݏ\Zb~ݸGwOŞ{{Ejtolܯ	mR6H:p囀oڛwpZ*A''ߦ|{PߙHy+:u-m=茣^G~1cu5W(=䂓dN?=ԙyLk]Q]gCϞ?tL_]p"b%K==G~pH[oeW<tM;js.]yn&%vw\nL]zxem``Y	ӇGG#F#\r\ZdΓ᧲~VysKXϿyr﫩:#y=}ǽ(@PcǧO>|/9%\0\0\0tEXtSoftware\0Adobe ImageReadyqe<\0\0(iTXtXML:com.adobe.xmp\0\0\0\0\0<?xpacket begin="﻿" id="W5M0MpCehiHzreSzNTczkc9d"?> <x:xmpmeta xmlns:x="adobe:ns:meta/" x:xmptk="Adobe XMP Core 5.6-c014 79.156797, 2014/08/20-09:53:02        "> <rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"> <rdf:Description rdf:about="" xmlns:xmp="http://ns.adobe.com/xap/1.0/" xmlns:xmpMM="http://ns.adobe.com/xap/1.0/mm/" xmlns:stRef="http://ns.adobe.com/xap/1.0/sType/ResourceRef#" xmp:CreatorTool="Adobe Photoshop CC 2014 (Macintosh)" xmpMM:InstanceID="xmp.iid:6E2C95DEA67311E4BDCDDF91FAF94DA5" xmpMM:DocumentID="xmp.did:6E2C95DFA67311E4BDCDDF91FAF94DA5"> <xmpMM:DerivedFrom stRef:instanceID="xmp.iid:CFA74E4FA67111E4BDCDDF91FAF94DA5" stRef:documentID="xmp.did:CFA74E50A67111E4BDCDDF91FAF94DA5"/> </rdf:Description> </rdf:RDF> </x:xmpmeta> <?xpacket end="r"?>\0\0IDATx]	S?/{2dfaq]67ϭ(*-\n.+օ nJSR:VDT,e2l3LݛosNPq$s1NY96tS/Q]k~Kz>%4ߤ5<,clmY''BhBLZM?\0]sG>Z(4W]h\r"Ҿ&F4]?JKD$F>Yd-}QZYe)*tӄ$\r	=(tBg	=_єQ\0mV+SvaDWgBBeBLH#tB	mFW\0;t _@њx.t![!#\\|W:\rGI9*ʍ6ˁJkSAqGN\09EBM~-4?홝~I}&yeYo\nu{.rBkiv?LGєj-+Q散\02%>|(^\nXrTR-*-R˅VBI:GT#5i\ZE"FlD;\\_psjdB"tB)2wϊ`Ф^MnA!<Y>\nktMJw%<.BU\\GBI?禓]\0o^eF&.aa5͚#ңo>=L^]FJN\0GㅾV\Z!q#!6=X9\\T2ﲨ{c捳,Ў)zakl@1{^MF_b(79+''J{hn[\\hiGc41''''M1>;kǐL݋$|~,ݕx l(4W.\ZAjՈrsrWMWr"zh>;Y窊E,0ތ\\\\1b"''xuLYȣx9)^[\0PXVNXͻT("YuWev݈RUC55ACGY6?@1kVS|9IX*rD"LΎ=*@4=NwZj9%p%a~yBe\rK;HTo+)Q_ŸtcIUȱB"VڪVg>LvWS1|XpѰyZxrR''#)WH[ ԍ	(#=B2C۲@JL,H$ݵ(N)2''䘮\Z/*''rZKDV((g	ś{P]aY jߊ=B\n"4~nVnwRXFUrQsΐJd\Zz7"y7ecV%BT`SO;]NNyXz7s}~j/߬\rnFz*fۉ洌5)EEK|j44\rI.x.j6GJG_ӘZz1`NxP<8^$6vhUY\nGjrެ/^DaSۚIm·L\Z^ fZA36ck{,\Z9Rܱ@WQ%ZdWmo''rKJU07YާD~&*1~&=PH:	eְȁ~|d4ş:҇\n{ţTǹ+h,9wwzX\0-KN/R\r3-Hh+apymv+gɧ7E#:*Z;x΁w*Kq8WQȶ<{X&ңxPTR;Pđ #%·''H/d&Ay?Ljȇ6="9t9\Z_2I$\0K,-"hg.v8߼a=ٞ]MV*D-zc0:z7yɣGϯ(/y=|ҧ^[Ӻcaq>ѺQj)bDkyJ@cKleh\rK)AxnvF8\rJBww*%Gl^͖̋*DLV )Qx1NT7o.|eSV>^B/\ZҽqSE>;-41tiD瓍8U}''"OBz#wv8;IF>:Թ㰀O4DrSm.F!%8䊛Iy"e*HNEft5K#LBE36P$V72;P"1Óȹڹ\\y (r"W>zS}|?A6Ny΋p9H\0616ʧPZ}i"R7%OčыkCU!j/@61z	''[~wף7V\0q_+}o^e4"6¨s!\\rkJNT$@QNS$yZ(_:{W,\r/u\ZsxѰqh.}	g(b[\ZsL7RF+%(G8"4r)5V6IF\r: XR>9Q;G)ڴ^LȰR#.c/ 5/dIzf9,}Og+>{8xq*k^Z`5ruuʠ"IE[uT\\\nqf-ϵͺ/I4%8{07"W+kTGa_dC:2v\0Y-{0ǟN6V!1y\0@LFy@::x:/+Eîu.^f=0	WV"bK53Ght#+>?ǽ=0}0tɼu\rV9)ftѼ~;W9XttƊ#)\n6Ex9r8_KgD+	ȸ\nZu-@GLM\Z`^N\r^Fȫ	` #bLFD~x֎@7:!l1l\Z''9@p)bPbNUPqt8"''\r\\&!ª&OGGׂbnf`]0N=m?kXF$?2bP\nؕp0{EAoh|dYE,qjQe0T`K|4bf.DfoNDÁ=l,uف1\\vUPwBG_)1\0NoC&ҁ痁<Pq~6cmZb>	\\U'' y>!ܶFG,GMOf uQnxHrL<4?f/qRJʿɤ%e"2s!֧!''~p\r#Je+R=um^JU|FopC(h_oI3]puB4+q.CI[IMgTm(FFg/"XA]\03#)I5rcӨ}ʪG@@Q|\0E(Nw̥uDK\0h*YC.1UrX4<y̐;_B@D1p~mxVޯg5Ze+xH''P\rD龬lwPdx>]hBGGR|`QvӠBC,EROg*/69p8!ĭ씯q"BZ45xH2Ţ-G:I83%$|aY\0<ܴZW0&aTnUâZtep\Zi#EF6*\\o&H''	=c6m"Ķ6WJVQSq*겨b,Qd{4{ru!ƲFn-赒7aL7i@{PL閮%$(''qcw``@5	e\Z9fգV%M(ëqasQw^w\nRZ0ǲEOtn`Ň藸eY=m.''2_CN`Ʈ(!kMč4u%4)H[/;}\\8*X=Mwh\r\Zt\n\\''"\nƄZ~M3-98R8g_@uWN4ꓚϹ5b5T^RcSVhb>b\0#5:,wcTPma'' E	e0XԎBIFx\\yU"8r[Er:!5dIAh''Z4Wtg4醲v<Q]-\\A(5`m,	皌V\ZXd*Pb<B%+#c.V*P,Vՙy(:\0F#"|Fu7l+\0(ŀb`xڗPR7՝*).^U(\\Μ;脫PЙ\0y\Z\0j8\ZydQeZ	EOhu)h3![SU''_q(.ROBbWѶhԋG\rN)|VFh&D]E4 ky6hw=?D''ub-TsGyy`8<\na+V\rh2	x1іMAy)lk$Hy7t\rjH/6-Ju&<}"Qĕn@{jK\Z.`-NBچӫhM/^\\߀1vS/GJP!6#9:CbDčR_9C\rSU]SE4;Bo"(Px)''̵pʲ	ޝӜ{P4	0,@:L\\j_g080c"!,x77\Z\nd"~h~P9I,FS;km@F2?\n%5z|:5hDCtGTET}-qz{\niIQ3#dt-!DWD#w#e&\ZQNDwݔjq{pk+܏{gZǫrХl"lm$lp$I?1`<:$BibBc]݀k8qvCdWxU''yQ.=o3V %|F=V+$E''^9O7KL轲ZȫI4xaA>gЏ\0`_c:\Z\rF(D~@3ѷ3)S: _?𵀓\\M)8~x/F!Pnp/ؽ%h[p݋Xes,ھđ\nieLDJKKruA)Jw"dx^W\np$\0D(-]]:hkid3+;Un4\nKɶP(Ph\n;^Ʋ,]|X˫Tw	Vv\0uྞbS(ٖZ?=g`xѡ5MY9\Z\\Sl3e:Y	jBnvJ5szS.''%jh̜\0Z=_\Zh`oe[)#2iM7יbVN@tS_]wfHu͙HemHk ZD۽''(NT|_;"VJLɔi/Bh8"/!wF5vT!+Q/AFOҘ4C\Zp0jC\nJ''6Q~7vD3/B5@Z p_\0௘s]J\0\0\0\0IENDB`'),
(2, 0, 'Canned Attachments Rock!');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter`
--

CREATE TABLE `[[dbprefix]]filter` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `execorder` int(10) unsigned NOT NULL DEFAULT '99',
  `isactive` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `flags` int(10) unsigned DEFAULT '0',
  `status` int(11) unsigned NOT NULL DEFAULT '0',
  `match_all_rules` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `stop_onmatch` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `target` enum('Any','Web','Email','API') NOT NULL DEFAULT 'Any',
  `email_id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(32) NOT NULL DEFAULT '',
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `target` (`target`),
  KEY `email_id` (`email_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]filter`
--

INSERT INTO `[[dbprefix]]filter` VALUES
(1, 99, 1, 0, 0, 0, 0, 'Email', 0, 'SYSTEM BAN LIST', 'Internal list for email banning. Do not remove', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_action`
--

CREATE TABLE `[[dbprefix]]filter_action` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `filter_id` int(10) unsigned NOT NULL,
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `type` varchar(24) NOT NULL,
  `configuration` text,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `filter_id` (`filter_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]filter_action`
--

INSERT INTO `[[dbprefix]]filter_action` VALUES
(1, 1, 1, 'reject', '[]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]filter_rule`
--

CREATE TABLE `[[dbprefix]]filter_rule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `filter_id` int(10) unsigned NOT NULL DEFAULT '0',
  `what` varchar(32) NOT NULL,
  `how` enum('equal','not_equal','contains','dn_contain','starts','ends','match','not_match') NOT NULL,
  `val` varchar(255) NOT NULL,
  `isactive` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `notes` tinytext NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `filter` (`filter_id`,`what`,`how`,`val`),
  KEY `filter_id` (`filter_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]filter_rule`
--

INSERT INTO `[[dbprefix]]filter_rule` VALUES
(1, 1, 'email', 'equal', 'test@example.com', 1, '', '0000-00-00 00:00:00', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form`
--

CREATE TABLE `[[dbprefix]]form` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned DEFAULT NULL,
  `type` varchar(8) NOT NULL DEFAULT 'G',
  `flags` int(10) unsigned NOT NULL DEFAULT '1',
  `title` varchar(255) NOT NULL,
  `instructions` varchar(512) DEFAULT NULL,
  `name` varchar(64) NOT NULL DEFAULT '',
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `[[dbprefix]]form`
--

INSERT INTO `[[dbprefix]]form` VALUES
(1, NULL, 'U', 1, 'Contact Information', NULL, '', NULL, '[[regtime]]', '[[regtime]]'),
(2, NULL, 'T', 1, 'Ticket Details', 'Please Describe Your Issue', '', 'This form will be attached to every ticket, regardless of its source.\nYou can add any fields to this form and they will be available to all\ntickets, and will be searchable with advanced search and filterable.', '[[regtime]]', '[[regtime]]'),
(3, NULL, 'C', 1, 'Company Information', 'Details available in email templates', '', NULL, '[[regtime]]', '[[regtime]]'),
(4, NULL, 'O', 1, 'Organization Information', 'Details on user organization', '', NULL, '[[regtime]]', '[[regtime]]'),
(5, NULL, 'A', 1, 'Task Details', 'Please Describe The Issue', '', 'This form is used to create a task.', '[[regtime]]', '[[regtime]]'),
(6, NULL, 'L1', 0, 'Ticket Status Properties', 'Properties that can be set on a ticket status.', '', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_entry`
--

CREATE TABLE `[[dbprefix]]form_entry` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) unsigned NOT NULL,
  `object_id` int(11) unsigned DEFAULT NULL,
  `object_type` char(1) NOT NULL DEFAULT 'T',
  `sort` int(11) unsigned NOT NULL DEFAULT '1',
  `extra` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_lookup` (`object_type`,`object_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]form_entry`
--

INSERT INTO `[[dbprefix]]form_entry` VALUES
(1, 4, 1, 'O', 1, NULL, '[[regtime]]', '[[regtime]]'),
(2, 3, NULL, 'C', 1, NULL, '[[regtime]]', '[[regtime]]'),
(3, 1, 1, 'U', 1, NULL, '[[regtime]]', '[[regtime]]'),
(4, 2, 1, 'T', 0, '{"disable":[]}', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_entry_values`
--

CREATE TABLE `[[dbprefix]]form_entry_values` (
  `entry_id` int(11) unsigned NOT NULL,
  `field_id` int(11) unsigned NOT NULL,
  `value` text,
  `value_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`entry_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]form_entry_values`
--

INSERT INTO `[[dbprefix]]form_entry_values` VALUES
(2, 23, '[[site_name]]', NULL),
(2, 24, NULL, NULL),
(2, 25, NULL, NULL),
(2, 26, NULL, NULL),
(4, 20, 'osTicket Installed!', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]form_field`
--

CREATE TABLE `[[dbprefix]]form_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) unsigned NOT NULL,
  `flags` int(10) unsigned DEFAULT '1',
  `type` varchar(255) NOT NULL DEFAULT 'text',
  `label` varchar(255) NOT NULL,
  `name` varchar(64) NOT NULL,
  `configuration` text,
  `sort` int(11) unsigned NOT NULL,
  `hint` varchar(512) DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `sort` (`sort`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=36 ;

--
-- Dumping data for table `[[dbprefix]]form_field`
--

INSERT INTO `[[dbprefix]]form_field` VALUES
(1, 1, 489395, 'text', 'Email Address', 'email', '{"size":40,"length":64,"validator":"email"}', 1, NULL, '[[regtime]]', '[[regtime]]'),
(2, 1, 489395, 'text', 'Full Name', 'name', '{"size":40,"length":64}', 2, NULL, '[[regtime]]', '[[regtime]]'),
(3, 1, 13057, 'phone', 'Phone Number', 'phone', NULL, 3, NULL, '[[regtime]]', '[[regtime]]'),
(4, 1, 12289, 'memo', 'Internal Notes', 'notes', '{"rows":4,"cols":40}', 4, NULL, '[[regtime]]', '[[regtime]]'),
(20, 2, 489265, 'text', 'Issue Summary', 'subject', '{"size":40,"length":50}', 1, NULL, '[[regtime]]', '[[regtime]]'),
(21, 2, 480547, 'thread', 'Issue Details', 'message', NULL, 2, 'Details on the reason(s) for opening the ticket.', '[[regtime]]', '[[regtime]]'),
(22, 2, 274609, 'priority', 'Priority Level', 'priority', NULL, 3, NULL, '[[regtime]]', '[[regtime]]'),
(23, 3, 291249, 'text', 'Company Name', 'name', '{"size":40,"length":64}', 1, NULL, '[[regtime]]', '[[regtime]]'),
(24, 3, 274705, 'text', 'Website', 'website', '{"size":40,"length":64}', 2, NULL, '[[regtime]]', '[[regtime]]'),
(25, 3, 274705, 'phone', 'Phone Number', 'phone', '{"ext":false}', 3, NULL, '[[regtime]]', '[[regtime]]'),
(26, 3, 12545, 'memo', 'Address', 'address', '{"rows":2,"cols":40,"html":false,"length":100}', 4, NULL, '[[regtime]]', '[[regtime]]'),
(27, 4, 489395, 'text', 'Name', 'name', '{"size":40,"length":64}', 1, NULL, '[[regtime]]', '[[regtime]]'),
(28, 4, 13057, 'memo', 'Address', 'address', '{"rows":2,"cols":40,"length":100,"html":false}', 2, NULL, '[[regtime]]', '[[regtime]]'),
(29, 4, 13057, 'phone', 'Phone', 'phone', NULL, 3, NULL, '[[regtime]]', '[[regtime]]'),
(30, 4, 13057, 'text', 'Website', 'website', '{"size":40,"length":0}', 4, NULL, '[[regtime]]', '[[regtime]]'),
(31, 4, 12289, 'memo', 'Internal Notes', 'notes', '{"rows":4,"cols":40}', 5, NULL, '[[regtime]]', '[[regtime]]'),
(32, 5, 487601, 'text', 'Title', 'title', '{"size":40,"length":50}', 1, NULL, '[[regtime]]', '[[regtime]]'),
(33, 5, 413939, 'thread', 'Description', 'description', NULL, 2, 'Details on the reason(s) for creating the task.', '[[regtime]]', '[[regtime]]'),
(34, 6, 487665, 'state', 'State', 'state', '{"prompt":"State of a ticket"}', 1, NULL, '[[regtime]]', '[[regtime]]'),
(35, 6, 471073, 'memo', 'Description', 'description', '{"rows":"2","cols":"40","html":"","length":"100"}', 3, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]group`
--

CREATE TABLE `[[dbprefix]]group` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(11) unsigned NOT NULL,
  `flags` int(11) unsigned NOT NULL DEFAULT '1',
  `name` varchar(120) NOT NULL DEFAULT '',
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `role_id` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]help_topic`
--

CREATE TABLE `[[dbprefix]]help_topic` (
  `topic_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `topic_pid` int(10) unsigned NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `noautoresp` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `flags` int(10) unsigned DEFAULT '0',
  `status_id` int(10) unsigned NOT NULL DEFAULT '0',
  `priority_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dept_id` int(10) unsigned NOT NULL DEFAULT '0',
  `staff_id` int(10) unsigned NOT NULL DEFAULT '0',
  `team_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sla_id` int(10) unsigned NOT NULL DEFAULT '0',
  `page_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sequence_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  `topic` varchar(128) NOT NULL DEFAULT '',
  `number_format` varchar(32) DEFAULT NULL,
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`topic_id`),
  UNIQUE KEY `topic` (`topic`,`topic_pid`),
  KEY `topic_pid` (`topic_pid`),
  KEY `priority_id` (`priority_id`),
  KEY `dept_id` (`dept_id`),
  KEY `staff_id` (`staff_id`,`team_id`),
  KEY `sla_id` (`sla_id`),
  KEY `page_id` (`page_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=12 ;

--
-- Dumping data for table `[[dbprefix]]help_topic`
--

INSERT INTO `[[dbprefix]]help_topic` VALUES
(1, 0, 1, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 1, 'General Inquiry', NULL, 'Questions about products or services', '[[regtime]]', '[[regtime]]'),
(2, 0, 1, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 'Feedback', NULL, 'Tickets that primarily concern the sales and billing departments', '[[regtime]]', '[[regtime]]'),
(10, 0, 1, 0, 2, 0, 2, 3, 0, 0, 0, 0, 0, 0, 'Report a Problem', NULL, 'Product, service, or equipment related issues', '[[regtime]]', '[[regtime]]'),
(11, 10, 1, 0, 2, 0, 3, 0, 0, 0, 1, 0, 0, 1, 'Access Issue', NULL, 'Report an inability access a physical or virtual asset', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]help_topic_form`
--

CREATE TABLE `[[dbprefix]]help_topic_form` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) unsigned NOT NULL DEFAULT '0',
  `form_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '1',
  `extra` text,
  PRIMARY KEY (`id`),
  KEY `topic-form` (`topic_id`,`form_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]help_topic_form`
--

INSERT INTO `[[dbprefix]]help_topic_form` VALUES
(1, 1, 2, 1, '{"disable":[]}'),
(2, 2, 2, 1, '{"disable":[]}'),
(3, 10, 2, 1, '{"disable":[]}'),
(4, 11, 2, 1, '{"disable":[]}');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]list`
--

CREATE TABLE `[[dbprefix]]list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `name_plural` varchar(255) DEFAULT NULL,
  `sort_mode` enum('Alpha','-Alpha','SortCol') NOT NULL DEFAULT 'Alpha',
  `masks` int(11) unsigned NOT NULL DEFAULT '0',
  `type` varchar(16) DEFAULT NULL,
  `configuration` text NOT NULL,
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]list`
--

INSERT INTO `[[dbprefix]]list` VALUES
(1, 'Ticket Status', 'Ticket Statuses', 'SortCol', 13, 'ticket-status', '{"handler":"TicketStatusList"}', 'Ticket statuses', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]list_items`
--

CREATE TABLE `[[dbprefix]]list_items` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `list_id` int(11) DEFAULT NULL,
  `status` int(11) unsigned NOT NULL DEFAULT '1',
  `value` varchar(255) NOT NULL,
  `extra` varchar(255) DEFAULT NULL,
  `sort` int(11) NOT NULL DEFAULT '1',
  `properties` text,
  PRIMARY KEY (`id`),
  KEY `list_item_lookup` (`list_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]lock`
--

CREATE TABLE `[[dbprefix]]lock` (
  `lock_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `staff_id` int(10) unsigned NOT NULL DEFAULT '0',
  `expire` datetime DEFAULT NULL,
  `code` varchar(20) DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`lock_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]note`
--

CREATE TABLE `[[dbprefix]]note` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned DEFAULT NULL,
  `staff_id` int(11) unsigned NOT NULL DEFAULT '0',
  `ext_id` varchar(10) DEFAULT NULL,
  `body` text,
  `status` int(11) unsigned NOT NULL DEFAULT '0',
  `sort` int(11) unsigned NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ext_id` (`ext_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]organization`
--

CREATE TABLE `[[dbprefix]]organization` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL DEFAULT '',
  `manager` varchar(16) NOT NULL DEFAULT '',
  `status` int(11) unsigned NOT NULL DEFAULT '0',
  `domain` varchar(256) NOT NULL DEFAULT '',
  `extra` text,
  `created` timestamp NULL DEFAULT NULL,
  `updated` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]organization`
--

INSERT INTO `[[dbprefix]]organization` VALUES
(1, 'osTicket', '', 8, '', NULL, '[[regtime]]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]organization__cdata`
--

CREATE TABLE `[[dbprefix]]organization__cdata` (
  `org_id` int(11) unsigned NOT NULL,
  `name` mediumtext,
  `address` mediumtext,
  `phone` mediumtext,
  `website` mediumtext,
  `notes` mediumtext,
  PRIMARY KEY (`org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugin`
--

CREATE TABLE `[[dbprefix]]plugin` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `install_path` varchar(60) NOT NULL,
  `isphar` tinyint(1) NOT NULL DEFAULT '0',
  `isactive` tinyint(1) NOT NULL DEFAULT '0',
  `version` varchar(64) DEFAULT NULL,
  `notes` text,
  `installed` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `install_path` (`install_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]plugin_instance`
--

CREATE TABLE `[[dbprefix]]plugin_instance` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `plugin_id` int(11) unsigned NOT NULL,
  `flags` int(10) NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL DEFAULT '',
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `plugin_id` (`plugin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue`
--

CREATE TABLE `[[dbprefix]]queue` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `columns_id` int(11) unsigned DEFAULT NULL,
  `sort_id` int(11) unsigned DEFAULT NULL,
  `flags` int(11) unsigned NOT NULL DEFAULT '0',
  `staff_id` int(11) unsigned NOT NULL DEFAULT '0',
  `sort` int(11) unsigned NOT NULL DEFAULT '0',
  `title` varchar(60) DEFAULT NULL,
  `config` text,
  `filter` varchar(64) DEFAULT NULL,
  `root` varchar(32) DEFAULT NULL,
  `path` varchar(80) NOT NULL DEFAULT '/',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]queue`
--

INSERT INTO `[[dbprefix]]queue` VALUES
(1, 0, NULL, 1, 3, 0, 1, 'Open', '[["status__state","includes",{"open":"Open"}]]', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(2, 1, NULL, 4, 43, 0, 1, 'Open', '{"criteria":[["isanswered","nset",null]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(3, 1, NULL, 4, 43, 0, 2, 'Answered', '{"criteria":[["isanswered","set",null]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(4, 1, NULL, 4, 43, 0, 3, 'Overdue', '{"criteria":[["isoverdue","set",null]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(5, 0, NULL, 3, 3, 0, 3, 'My Tickets', '{"criteria":[["assignee","includes",{"M":"Me","T":"One of my teams"}],["status__state","includes",{"open":"Open"}]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(6, 5, NULL, NULL, 43, 0, 1, 'Assigned to Me', '{"criteria":[["assignee","includes",{"M":"Me"}]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(7, 5, NULL, NULL, 43, 0, 2, 'Assigned to Teams', '{"criteria":[["assignee","!includes",{"M":"Me"}]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(8, 0, NULL, 5, 3, 0, 4, 'Closed', '{"criteria":[["status__state","includes",{"closed":"Closed"}]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(9, 8, NULL, 5, 43, 0, 1, 'Today', '{"criteria":[["closed","period","td"]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(10, 8, NULL, 5, 43, 0, 2, 'Yesterday', '{"criteria":[["closed","period","yd"]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(11, 8, NULL, 5, 43, 0, 3, 'This Week', '{"criteria":[["closed","period","tw"]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(12, 8, NULL, 5, 43, 0, 4, 'This Month', '{"criteria":[["closed","period","tm"]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(13, 8, NULL, 6, 43, 0, 5, 'This Quarter', '{"criteria":[["closed","period","tq"]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00'),
(14, 8, NULL, 7, 43, 0, 6, 'This Year', '{"criteria":[["closed","period","ty"]],"conditions":[]}', NULL, 'T', '/', '[[regtime]]', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue_column`
--

CREATE TABLE `[[dbprefix]]queue_column` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `flags` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) NOT NULL DEFAULT '',
  `primary` varchar(64) NOT NULL DEFAULT '',
  `secondary` varchar(64) DEFAULT NULL,
  `filter` varchar(32) DEFAULT NULL,
  `truncate` varchar(16) DEFAULT NULL,
  `annotations` text,
  `conditions` text,
  `extra` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- Dumping data for table `[[dbprefix]]queue_column`
--

INSERT INTO `[[dbprefix]]queue_column` VALUES
(1, 0, 'Ticket #', 'number', NULL, 'link:ticketP', 'wrap', '[{"c":"TicketSourceDecoration","p":"b"}]', '[{"crit":["isanswered","nset",null],"prop":{"font-weight":"bold"}}]', NULL),
(2, 0, 'Date Created', 'created', NULL, 'date:full', 'wrap', '[]', '[]', NULL),
(3, 0, 'Subject', 'cdata__subject', NULL, 'link:ticket', 'ellipsis', '[{"c":"TicketThreadCount","p":">"},{"c":"ThreadAttachmentCount","p":"a"},{"c":"OverdueFlagDecoration","p":"<"},{"c":"LockDecoration","p":"<"}]', '[{"crit":["isanswered","nset",null],"prop":{"font-weight":"bold"}}]', NULL),
(4, 0, 'User Name', 'user__name', NULL, NULL, 'wrap', '[{"c":"ThreadCollaboratorCount","p":">"}]', '[]', NULL),
(5, 0, 'Priority', 'cdata__priority', NULL, NULL, 'wrap', '[]', '[]', NULL),
(6, 0, 'Status', 'status__id', NULL, NULL, 'wrap', '[]', '[]', NULL),
(7, 0, 'Close Date', 'closed', NULL, 'date:full', 'wrap', '[]', '[]', NULL),
(8, 0, 'Assignee', 'assignee', NULL, NULL, 'wrap', '[]', '[]', NULL),
(9, 0, 'Due Date', 'duedate', 'est_duedate', 'date:human', 'wrap', '[]', '[]', NULL),
(10, 0, 'Last Updated', 'lastupdate', NULL, 'date:full', 'wrap', '[]', '[]', NULL),
(11, 0, 'Department', 'dept_id', NULL, NULL, 'wrap', '[]', '[]', NULL),
(12, 0, 'Last Message', 'thread__lastmessage', NULL, 'date:human', 'wrap', '[]', '[]', NULL),
(13, 0, 'Last Response', 'thread__lastresponse', NULL, 'date:human', 'wrap', '[]', '[]', NULL),
(14, 0, 'Team', 'team_id', NULL, NULL, 'wrap', '[]', '[]', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue_columns`
--

CREATE TABLE `[[dbprefix]]queue_columns` (
  `queue_id` int(11) unsigned NOT NULL,
  `column_id` int(11) unsigned NOT NULL,
  `staff_id` int(11) unsigned NOT NULL,
  `bits` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '1',
  `heading` varchar(64) DEFAULT NULL,
  `width` int(10) unsigned NOT NULL DEFAULT '100',
  PRIMARY KEY (`queue_id`,`column_id`,`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]queue_columns`
--

INSERT INTO `[[dbprefix]]queue_columns` VALUES
(1, 1, 0, 1, 1, 'Ticket', 100),
(1, 3, 0, 1, 3, 'Subject', 300),
(1, 4, 0, 1, 4, 'From', 185),
(1, 5, 0, 1, 5, 'Priority', 85),
(1, 8, 0, 1, 6, 'Assigned To', 160),
(1, 10, 0, 1, 2, 'Last Updated', 150),
(2, 1, 0, 1, 1, 'Ticket', 100),
(2, 3, 0, 1, 3, 'Subject', 300),
(2, 4, 0, 1, 4, 'From', 185),
(2, 5, 0, 1, 5, 'Priority', 85),
(2, 8, 0, 1, 6, 'Assigned To', 160),
(2, 10, 0, 1, 2, 'Last Updated', 150),
(3, 1, 0, 1, 1, 'Ticket', 100),
(3, 3, 0, 1, 3, 'Subject', 300),
(3, 4, 0, 1, 4, 'From', 185),
(3, 5, 0, 1, 5, 'Priority', 85),
(3, 8, 0, 1, 6, 'Assigned To', 160),
(3, 10, 0, 1, 2, 'Last Updated', 150),
(4, 1, 0, 1, 1, 'Ticket', 100),
(4, 3, 0, 1, 3, 'Subject', 300),
(4, 4, 0, 1, 4, 'From', 185),
(4, 5, 0, 1, 5, 'Priority', 85),
(4, 8, 0, 1, 6, 'Assigned To', 160),
(4, 9, 0, 1, 9, 'Due Date', 150),
(5, 1, 0, 1, 1, 'Ticket', 100),
(5, 3, 0, 1, 3, 'Subject', 300),
(5, 4, 0, 1, 4, 'From', 185),
(5, 5, 0, 1, 5, 'Priority', 85),
(5, 10, 0, 1, 2, 'Last Update', 150),
(5, 11, 0, 1, 6, 'Department', 160),
(6, 1, 0, 1, 1, 'Ticket', 100),
(6, 3, 0, 1, 3, 'Subject', 300),
(6, 4, 0, 1, 4, 'From', 185),
(6, 5, 0, 1, 5, 'Priority', 85),
(6, 10, 0, 1, 2, 'Last Update', 150),
(6, 11, 0, 1, 6, 'Department', 160),
(7, 1, 0, 1, 1, 'Ticket', 100),
(7, 3, 0, 1, 3, 'Subject', 300),
(7, 4, 0, 1, 4, 'From', 185),
(7, 5, 0, 1, 5, 'Priority', 85),
(7, 10, 0, 1, 2, 'Last Update', 150),
(7, 14, 0, 1, 6, 'Team', 160),
(8, 1, 0, 1, 1, 'Ticket', 100),
(8, 3, 0, 1, 3, 'Subject', 300),
(8, 4, 0, 1, 4, 'From', 185),
(8, 7, 0, 1, 2, 'Date Closed', 150),
(8, 8, 0, 1, 6, 'Closed By', 160),
(9, 1, 0, 1, 1, 'Ticket', 100),
(9, 3, 0, 1, 3, 'Subject', 300),
(9, 4, 0, 1, 4, 'From', 185),
(9, 7, 0, 1, 2, 'Date Closed', 150),
(9, 8, 0, 1, 6, 'Closed By', 160),
(10, 1, 0, 1, 1, 'Ticket', 100),
(10, 3, 0, 1, 3, 'Subject', 300),
(10, 4, 0, 1, 4, 'From', 185),
(10, 7, 0, 1, 2, 'Date Closed', 150),
(10, 8, 0, 1, 6, 'Closed By', 160),
(11, 1, 0, 1, 1, 'Ticket', 100),
(11, 3, 0, 1, 3, 'Subject', 300),
(11, 4, 0, 1, 4, 'From', 185),
(11, 7, 0, 1, 2, 'Date Closed', 150),
(11, 8, 0, 1, 6, 'Closed By', 160),
(12, 1, 0, 1, 1, 'Ticket', 100),
(12, 3, 0, 1, 3, 'Subject', 300),
(12, 4, 0, 1, 4, 'From', 185),
(12, 7, 0, 1, 2, 'Date Closed', 150),
(12, 8, 0, 1, 6, 'Closed By', 160),
(13, 1, 0, 1, 1, 'Ticket', 100),
(13, 3, 0, 1, 3, 'Subject', 300),
(13, 4, 0, 1, 4, 'From', 185),
(13, 7, 0, 1, 2, 'Date Closed', 150),
(13, 8, 0, 1, 6, 'Closed By', 160),
(14, 1, 0, 1, 1, 'Ticket', 100),
(14, 3, 0, 1, 3, 'Subject', 300),
(14, 4, 0, 1, 4, 'From', 185),
(14, 7, 0, 1, 2, 'Date Closed', 150),
(14, 8, 0, 1, 6, 'Closed By', 160);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue_config`
--

CREATE TABLE `[[dbprefix]]queue_config` (
  `queue_id` int(11) unsigned NOT NULL,
  `staff_id` int(11) unsigned NOT NULL,
  `setting` text,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`queue_id`,`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue_export`
--

CREATE TABLE `[[dbprefix]]queue_export` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `queue_id` int(11) unsigned NOT NULL,
  `path` varchar(64) NOT NULL DEFAULT '',
  `heading` varchar(64) DEFAULT NULL,
  `sort` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `queue_id` (`queue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue_sort`
--

CREATE TABLE `[[dbprefix]]queue_sort` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `root` varchar(32) DEFAULT NULL,
  `name` varchar(64) NOT NULL DEFAULT '',
  `columns` text,
  `updated` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

--
-- Dumping data for table `[[dbprefix]]queue_sort`
--

INSERT INTO `[[dbprefix]]queue_sort` VALUES
(1, NULL, 'Priority + Most Recently Updated', '["-cdata__priority","-lastupdate"]', '[[regtime]]'),
(2, NULL, 'Priority + Most Recently Created', '["-cdata__priority","-created"]', '[[regtime]]'),
(3, NULL, 'Priority + Due Date', '["-cdata__priority","-est_duedate"]', '[[regtime]]'),
(4, NULL, 'Due Date', '["-est_duedate"]', '[[regtime]]'),
(5, NULL, 'Closed Date', '["-closed"]', '[[regtime]]'),
(6, NULL, 'Create Date', '["-created"]', '[[regtime]]'),
(7, NULL, 'Update Date', '["-lastupdate"]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]queue_sorts`
--

CREATE TABLE `[[dbprefix]]queue_sorts` (
  `queue_id` int(11) unsigned NOT NULL,
  `sort_id` int(11) unsigned NOT NULL,
  `bits` int(11) unsigned NOT NULL DEFAULT '0',
  `sort` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`queue_id`,`sort_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]queue_sorts`
--

INSERT INTO `[[dbprefix]]queue_sorts` VALUES
(1, 1, 0, 0),
(1, 2, 0, 0),
(1, 3, 0, 0),
(1, 4, 0, 0),
(1, 6, 0, 0),
(1, 7, 0, 0),
(5, 1, 0, 0),
(5, 2, 0, 0),
(5, 3, 0, 0),
(5, 4, 0, 0),
(5, 6, 0, 0),
(5, 7, 0, 0),
(6, 1, 0, 0),
(6, 2, 0, 0),
(6, 3, 0, 0),
(6, 4, 0, 0),
(6, 6, 0, 0),
(6, 7, 0, 0),
(7, 1, 0, 0),
(7, 2, 0, 0),
(7, 3, 0, 0),
(7, 4, 0, 0),
(7, 6, 0, 0),
(7, 7, 0, 0),
(8, 1, 0, 0),
(8, 2, 0, 0),
(8, 3, 0, 0),
(8, 4, 0, 0),
(8, 5, 0, 0),
(8, 6, 0, 0),
(8, 7, 0, 0),
(9, 1, 0, 0),
(9, 2, 0, 0),
(9, 3, 0, 0),
(9, 4, 0, 0),
(9, 5, 0, 0),
(9, 6, 0, 0),
(9, 7, 0, 0),
(10, 1, 0, 0),
(10, 2, 0, 0),
(10, 3, 0, 0),
(10, 4, 0, 0),
(10, 5, 0, 0),
(10, 6, 0, 0),
(10, 7, 0, 0),
(11, 1, 0, 0),
(11, 2, 0, 0),
(11, 3, 0, 0),
(11, 4, 0, 0),
(11, 5, 0, 0),
(11, 6, 0, 0),
(11, 7, 0, 0),
(12, 1, 0, 0),
(12, 2, 0, 0),
(12, 3, 0, 0),
(12, 4, 0, 0),
(12, 5, 0, 0),
(12, 6, 0, 0),
(12, 7, 0, 0),
(13, 1, 0, 0),
(13, 2, 0, 0),
(13, 3, 0, 0),
(13, 4, 0, 0),
(13, 5, 0, 0),
(13, 6, 0, 0),
(13, 7, 0, 0),
(14, 1, 0, 0),
(14, 2, 0, 0),
(14, 3, 0, 0),
(14, 4, 0, 0),
(14, 5, 0, 0),
(14, 6, 0, 0),
(14, 7, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]role`
--

CREATE TABLE `[[dbprefix]]role` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `flags` int(10) unsigned NOT NULL DEFAULT '1',
  `name` varchar(64) DEFAULT NULL,
  `permissions` text,
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]role`
--

INSERT INTO `[[dbprefix]]role` VALUES
(1, 1, 'All Access', '{"ticket.assign":1,"ticket.close":1,"ticket.create":1,"ticket.delete":1,"ticket.edit":1,"thread.edit":1,"ticket.link":1,"ticket.markanswered":1,"ticket.merge":1,"ticket.reply":1,"ticket.refer":1,"ticket.release":1,"ticket.transfer":1,"task.assign":1,"task.close":1,"task.create":1,"task.delete":1,"task.edit":1,"task.reply":1,"task.transfer":1,"canned.manage":1}', 'Role with unlimited access', '[[regtime]]', '[[regtime]]'),
(2, 1, 'Expanded Access', '{"ticket.assign":1,"ticket.close":1,"ticket.create":1,"ticket.edit":1,"ticket.link":1,"ticket.merge":1,"ticket.reply":1,"ticket.refer":1,"ticket.release":1,"ticket.transfer":1,"task.assign":1,"task.close":1,"task.create":1,"task.edit":1,"task.reply":1,"task.transfer":1,"canned.manage":1}', 'Role with expanded access', '[[regtime]]', '[[regtime]]'),
(3, 1, 'Limited Access', '{"ticket.assign":1,"ticket.create":1,"ticket.link":1,"ticket.merge":1,"ticket.refer":1,"ticket.release":1,"ticket.transfer":1,"task.assign":1,"task.reply":1,"task.transfer":1}', 'Role with limited access', '[[regtime]]', '[[regtime]]'),
(4, 1, 'View only', NULL, 'Simple role with no permissions', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]schedule`
--

CREATE TABLE `[[dbprefix]]schedule` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `flags` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `timezone` varchar(64) DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]schedule`
--

INSERT INTO `[[dbprefix]]schedule` VALUES
(1, 1, 'Monday - Friday 8am - 5pm with U.S. Holidays', NULL, '', '[[regtime]]', '[[regtime]]'),
(2, 1, '24/7', NULL, '', '[[regtime]]', '[[regtime]]'),
(3, 1, '24/5', NULL, '', '[[regtime]]', '[[regtime]]'),
(4, 0, 'U.S. Holidays', NULL, '', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]schedule_entry`
--

CREATE TABLE `[[dbprefix]]schedule_entry` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` int(11) unsigned NOT NULL DEFAULT '0',
  `flags` int(11) unsigned NOT NULL DEFAULT '0',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `repeats` varchar(16) NOT NULL DEFAULT 'never',
  `starts_on` date DEFAULT NULL,
  `starts_at` time DEFAULT NULL,
  `ends_on` date DEFAULT NULL,
  `ends_at` time DEFAULT NULL,
  `stops_on` datetime DEFAULT NULL,
  `day` tinyint(4) DEFAULT NULL,
  `week` tinyint(4) DEFAULT NULL,
  `month` tinyint(4) DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `schedule_id` (`schedule_id`),
  KEY `repeats` (`repeats`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=17 ;

--
-- Dumping data for table `[[dbprefix]]schedule_entry`
--

INSERT INTO `[[dbprefix]]schedule_entry` VALUES
(1, 1, 0, 0, 'Monday', 'weekly', '2019-01-07', '08:00:00', '2019-01-07', '17:00:00', NULL, 1, NULL, NULL, '0000-00-00 00:00:00', '[[regtime]]'),
(2, 1, 0, 0, 'Tuesday', 'weekly', '2019-01-08', '08:00:00', '2019-01-08', '17:00:00', NULL, 2, NULL, NULL, '0000-00-00 00:00:00', '[[regtime]]'),
(3, 1, 0, 0, 'Wednesday', 'weekly', '2019-01-09', '08:00:00', '2019-01-09', '17:00:00', NULL, 3, NULL, NULL, '0000-00-00 00:00:00', '[[regtime]]'),
(4, 1, 0, 0, 'Thursday', 'weekly', '2019-01-10', '08:00:00', '2019-01-10', '17:00:00', NULL, 4, NULL, NULL, '0000-00-00 00:00:00', '[[regtime]]'),
(5, 1, 0, 0, 'Friday', 'weekly', '2019-01-11', '08:00:00', '2019-01-11', '17:00:00', NULL, 5, NULL, NULL, '0000-00-00 00:00:00', '[[regtime]]'),
(6, 2, 0, 0, 'Daily', 'daily', '2019-01-01', '00:00:00', '2019-01-01', '23:59:59', NULL, NULL, NULL, NULL, '0000-00-00 00:00:00', '[[regtime]]'),
(7, 3, 0, 0, 'Weekdays', 'weekdays', '2019-01-01', '00:00:00', '2019-01-01', '23:59:59', NULL, NULL, NULL, NULL, '0000-00-00 00:00:00', '[[regtime]]'),
(8, 4, 0, 0, 'New Year''s Day', 'yearly', '2019-01-01', '00:00:00', '2019-01-01', '23:59:59', NULL, 1, NULL, 1, '0000-00-00 00:00:00', '[[regtime]]'),
(9, 4, 0, 0, 'MLK Day', 'yearly', '2019-01-21', '00:00:00', '2019-01-21', '23:59:59', NULL, 1, 3, 1, '0000-00-00 00:00:00', '[[regtime]]'),
(10, 4, 0, 0, 'Memorial Day', 'yearly', '2019-05-27', '00:00:00', '2019-05-27', '23:59:59', NULL, 1, -1, 5, '0000-00-00 00:00:00', '[[regtime]]'),
(11, 4, 0, 0, 'Independence Day (4th of July)', 'yearly', '2019-07-04', '00:00:00', '2019-07-04', '23:59:59', NULL, 4, NULL, 7, '0000-00-00 00:00:00', '[[regtime]]'),
(12, 4, 0, 0, 'Labor Day', 'yearly', '2019-09-02', '00:00:00', '2019-09-02', '23:59:59', NULL, 1, 1, 9, '0000-00-00 00:00:00', '[[regtime]]'),
(13, 4, 0, 0, 'Indigenous Peoples'' Day (Whodat Columbus)', 'yearly', '2019-10-14', '00:00:00', '2019-10-14', '23:59:59', NULL, 1, 2, 10, '0000-00-00 00:00:00', '[[regtime]]'),
(14, 4, 0, 0, 'Veterans Day', 'yearly', '2019-11-11', '00:00:00', '2019-11-11', '23:59:59', NULL, 11, NULL, 11, '0000-00-00 00:00:00', '[[regtime]]'),
(15, 4, 0, 0, 'Thanksgiving Day', 'yearly', '2019-11-28', '00:00:00', '2019-11-28', '23:59:59', NULL, 4, 4, 11, '0000-00-00 00:00:00', '[[regtime]]'),
(16, 4, 0, 0, 'Christmas Day', 'yearly', '2019-11-25', '00:00:00', '2019-11-25', '23:59:59', NULL, 25, NULL, 12, '0000-00-00 00:00:00', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sequence`
--

CREATE TABLE `[[dbprefix]]sequence` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL,
  `flags` int(10) unsigned DEFAULT NULL,
  `next` bigint(20) unsigned NOT NULL DEFAULT '1',
  `increment` int(11) DEFAULT '1',
  `padding` char(1) DEFAULT '0',
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

--
-- Dumping data for table `[[dbprefix]]sequence`
--

INSERT INTO `[[dbprefix]]sequence` VALUES
(1, 'General Tickets', 1, 1, 1, '0', '0000-00-00 00:00:00'),
(2, 'Tasks Sequence', 1, 1, 1, '0', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]session`
--

CREATE TABLE `[[dbprefix]]session` (
  `session_id` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '',
  `session_data` blob,
  `session_expire` datetime DEFAULT NULL,
  `session_updated` datetime DEFAULT NULL,
  `user_id` varchar(16) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT 'osTicket staff/client ID',
  `user_ip` varchar(64) COLLATE utf8_unicode_ci NOT NULL,
  `user_agent` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `updated` (`session_updated`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]sla`
--

CREATE TABLE `[[dbprefix]]sla` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` int(10) unsigned NOT NULL DEFAULT '0',
  `flags` int(10) unsigned NOT NULL DEFAULT '3',
  `grace_period` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) NOT NULL DEFAULT '',
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]sla`
--

INSERT INTO `[[dbprefix]]sla` VALUES
(1, 0, 3, 18, 'Default SLA', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]staff`
--

CREATE TABLE `[[dbprefix]]staff` (
  `staff_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `dept_id` int(10) unsigned NOT NULL DEFAULT '0',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0',
  `username` varchar(32) NOT NULL DEFAULT '',
  `firstname` varchar(32) DEFAULT NULL,
  `lastname` varchar(32) DEFAULT NULL,
  `passwd` varchar(128) DEFAULT NULL,
  `backend` varchar(32) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(24) NOT NULL DEFAULT '',
  `phone_ext` varchar(6) DEFAULT NULL,
  `mobile` varchar(24) NOT NULL DEFAULT '',
  `signature` text NOT NULL,
  `lang` varchar(16) DEFAULT NULL,
  `timezone` varchar(64) DEFAULT NULL,
  `locale` varchar(16) DEFAULT NULL,
  `notes` text,
  `isactive` tinyint(1) NOT NULL DEFAULT '1',
  `isadmin` tinyint(1) NOT NULL DEFAULT '0',
  `isvisible` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `onvacation` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `assigned_only` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `show_assigned_tickets` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `change_passwd` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `max_page_size` int(11) unsigned NOT NULL DEFAULT '0',
  `auto_refresh_rate` int(10) unsigned NOT NULL DEFAULT '0',
  `default_signature_type` enum('none','mine','dept') NOT NULL DEFAULT 'none',
  `default_paper_size` enum('Letter','Legal','Ledger','A4','A3') NOT NULL DEFAULT 'Letter',
  `extra` text,
  `permissions` text,
  `created` datetime NOT NULL,
  `lastlogin` datetime DEFAULT NULL,
  `passwdreset` datetime DEFAULT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`staff_id`),
  UNIQUE KEY `username` (`username`),
  KEY `dept_id` (`dept_id`),
  KEY `issuperuser` (`isadmin`),
  KEY `isactive` (`isactive`),
  KEY `onvacation` (`onvacation`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]staff`
--

INSERT INTO `[[dbprefix]]staff` VALUES
(1, 1, 1, '[[admin_username]]', '[[admin_fname]]', '[[admin_lname]]', '[[admin_pass]]', NULL, '[[admin_email]]', '', NULL, '', '', NULL, NULL, NULL, NULL, 1, 1, 1, 0, 0, 0, 0, 25, 0, 'none', 'Letter', NULL, '{"user.create":1,"user.delete":1,"user.edit":1,"user.manage":1,"user.dir":1,"org.create":1,"org.delete":1,"org.edit":1,"faq.manage":1,"visibility.agents":1,"emails.banlist":1,"visibility.departments":1}', '[[regtime]]', NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]staff_dept_access`
--

CREATE TABLE `[[dbprefix]]staff_dept_access` (
  `staff_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dept_id` int(10) unsigned NOT NULL DEFAULT '0',
  `role_id` int(10) unsigned NOT NULL DEFAULT '0',
  `flags` int(10) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`staff_id`,`dept_id`),
  KEY `dept_id` (`dept_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]staff_dept_access`
--

INSERT INTO `[[dbprefix]]staff_dept_access` VALUES
(1, 2, 1, 1),
(1, 3, 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]syslog`
--

CREATE TABLE `[[dbprefix]]syslog` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` enum('Debug','Warning','Error') NOT NULL,
  `title` varchar(255) NOT NULL,
  `log` text NOT NULL,
  `logger` varchar(64) NOT NULL,
  `ip_address` varchar(64) NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]syslog`
--

INSERT INTO `[[dbprefix]]syslog` VALUES
(1, 'Debug', 'osTicket installed!', 'Congratulations osTicket basic installation completed!\n\nThank you for choosing osTicket!', '', '[[clientip]]', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task`
--

CREATE TABLE `[[dbprefix]]task` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(11) NOT NULL DEFAULT '0',
  `object_type` char(1) NOT NULL,
  `number` varchar(20) DEFAULT NULL,
  `dept_id` int(10) unsigned NOT NULL DEFAULT '0',
  `staff_id` int(10) unsigned NOT NULL DEFAULT '0',
  `team_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lock_id` int(11) unsigned NOT NULL DEFAULT '0',
  `flags` int(10) unsigned NOT NULL DEFAULT '0',
  `duedate` datetime DEFAULT NULL,
  `closed` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `dept_id` (`dept_id`),
  KEY `staff_id` (`staff_id`),
  KEY `team_id` (`team_id`),
  KEY `created` (`created`),
  KEY `object` (`object_id`,`object_type`),
  KEY `flags` (`flags`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]task__cdata`
--

CREATE TABLE `[[dbprefix]]task__cdata` (
  `task_id` int(11) unsigned NOT NULL,
  `title` mediumtext,
  PRIMARY KEY (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]team`
--

CREATE TABLE `[[dbprefix]]team` (
  `team_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int(10) unsigned NOT NULL DEFAULT '0',
  `flags` int(10) unsigned NOT NULL DEFAULT '1',
  `name` varchar(125) NOT NULL DEFAULT '',
  `notes` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`team_id`),
  UNIQUE KEY `name` (`name`),
  KEY `lead_id` (`lead_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]team`
--

INSERT INTO `[[dbprefix]]team` VALUES
(1, 0, 1, 'Level I Support', 'Tier 1 support, responsible for the initial iteraction with customers', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]team_member`
--

CREATE TABLE `[[dbprefix]]team_member` (
  `team_id` int(10) unsigned NOT NULL DEFAULT '0',
  `staff_id` int(10) unsigned NOT NULL,
  `flags` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`team_id`,`staff_id`),
  KEY `staff_id` (`staff_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]thread`
--

CREATE TABLE `[[dbprefix]]thread` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` int(11) unsigned NOT NULL,
  `object_type` char(1) NOT NULL,
  `extra` text,
  `lastresponse` datetime DEFAULT NULL,
  `lastmessage` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `object_id` (`object_id`),
  KEY `object_type` (`object_type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]thread`
--

INSERT INTO `[[dbprefix]]thread` VALUES
(1, 1, 'T', NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]thread_collaborator`
--

CREATE TABLE `[[dbprefix]]thread_collaborator` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `flags` int(10) unsigned NOT NULL DEFAULT '1',
  `thread_id` int(11) unsigned NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `role` char(1) NOT NULL DEFAULT 'M',
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `collab` (`thread_id`,`user_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]thread_entry`
--

CREATE TABLE `[[dbprefix]]thread_entry` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL DEFAULT '0',
  `thread_id` int(11) unsigned NOT NULL DEFAULT '0',
  `staff_id` int(11) unsigned NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `type` char(1) NOT NULL DEFAULT '',
  `flags` int(11) unsigned NOT NULL DEFAULT '0',
  `poster` varchar(128) NOT NULL DEFAULT '',
  `editor` int(10) unsigned DEFAULT NULL,
  `editor_type` char(1) DEFAULT NULL,
  `source` varchar(32) NOT NULL DEFAULT '',
  `title` varchar(255) DEFAULT NULL,
  `body` text NOT NULL,
  `format` varchar(16) NOT NULL DEFAULT 'html',
  `ip_address` varchar(64) NOT NULL DEFAULT '',
  `extra` text,
  `recipients` text,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `thread_id` (`thread_id`),
  KEY `staff_id` (`staff_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]thread_entry`
--

INSERT INTO `[[dbprefix]]thread_entry` VALUES
(1, 0, 1, 0, 1, 'M', 65, 'osTicket Team', NULL, NULL, 'Web', 'osTicket Installed!', ' <p>Thank you for choosing osTicket. </p> <p>Please make sure you join the <a href="https://forum.osticket.com">osTicket forums</a> and our <a href="https://osticket.com">mailing list</a> to stay up to date on the latest news, security alerts and updates. The osTicket forums are also a great place to get assistance, guidance, tips, and help from other osTicket users. In addition to the forums, the <a href="https://docs.osticket.com">osTicket Docs</a> provides a useful collection of educational materials, documentation, and notes from the community. We welcome your contributions to the osTicket community. </p> <p>If you are looking for a greater level of support, we provide professional services and commercial support with guaranteed response times, and access to the core development team. We can also help customize osTicket or even add new features to the system to meet your unique needs. </p> <p>If the idea of managing and upgrading this osTicket installation is daunting, you can try osTicket as a hosted service at <a href="https://supportsystem.com">https://supportsystem.com/</a> -- no installation required and we can import your data! With SupportSystem''s turnkey infrastructure, you get osTicket at its best, leaving you free to focus on your customers without the burden of making sure the application is stable, maintained, and secure. </p> <p>Cheers, </p> <p>-<br /> osTicket Team - https://osticket.com/ </p> <p><strong>PS.</strong> Don''t just make customers happy, make happy customers! </p>', 'html', '[[clientip]]', NULL, NULL, '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]thread_entry_email`
--

CREATE TABLE `[[dbprefix]]thread_entry_email` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `thread_entry_id` int(11) unsigned NOT NULL,
  `email_id` int(11) unsigned DEFAULT NULL,
  `mid` varchar(255) NOT NULL,
  `headers` text,
  PRIMARY KEY (`id`),
  KEY `thread_entry_id` (`thread_entry_id`),
  KEY `mid` (`mid`),
  KEY `email_id` (`email_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]thread_entry_merge`
--

CREATE TABLE `[[dbprefix]]thread_entry_merge` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `thread_entry_id` int(11) unsigned NOT NULL,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `thread_entry_id` (`thread_entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]thread_event`
--

CREATE TABLE `[[dbprefix]]thread_event` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `thread_id` int(11) unsigned NOT NULL DEFAULT '0',
  `thread_type` char(1) NOT NULL DEFAULT '',
  `event_id` int(11) unsigned DEFAULT NULL,
  `staff_id` int(11) unsigned NOT NULL,
  `team_id` int(11) unsigned NOT NULL,
  `dept_id` int(11) unsigned NOT NULL,
  `topic_id` int(11) unsigned NOT NULL,
  `data` varchar(1024) DEFAULT NULL COMMENT 'Encoded differences',
  `username` varchar(128) NOT NULL DEFAULT 'SYSTEM',
  `uid` int(11) unsigned DEFAULT NULL,
  `uid_type` char(1) NOT NULL DEFAULT 'S',
  `annulled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ticket_state` (`thread_id`,`event_id`,`timestamp`),
  KEY `ticket_stats` (`timestamp`,`event_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]thread_event`
--

INSERT INTO `[[dbprefix]]thread_event` VALUES
(1, 1, 'T', 1, 0, 0, 1, 1, NULL, 'SYSTEM', 1, 'U', 0, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]thread_referral`
--

CREATE TABLE `[[dbprefix]]thread_referral` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `thread_id` int(11) unsigned NOT NULL,
  `object_id` int(11) unsigned NOT NULL,
  `object_type` char(1) NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ref` (`object_id`,`object_type`,`thread_id`),
  KEY `thread_id` (`thread_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ticket`
--

CREATE TABLE `[[dbprefix]]ticket` (
  `ticket_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ticket_pid` int(11) unsigned DEFAULT NULL,
  `number` varchar(20) DEFAULT NULL,
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `user_email_id` int(11) unsigned NOT NULL DEFAULT '0',
  `status_id` int(10) unsigned NOT NULL DEFAULT '0',
  `dept_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sla_id` int(10) unsigned NOT NULL DEFAULT '0',
  `topic_id` int(10) unsigned NOT NULL DEFAULT '0',
  `staff_id` int(10) unsigned NOT NULL DEFAULT '0',
  `team_id` int(10) unsigned NOT NULL DEFAULT '0',
  `email_id` int(11) unsigned NOT NULL DEFAULT '0',
  `lock_id` int(11) unsigned NOT NULL DEFAULT '0',
  `flags` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(11) unsigned NOT NULL DEFAULT '0',
  `ip_address` varchar(64) NOT NULL DEFAULT '',
  `source` enum('Web','Email','Phone','API','Other') NOT NULL DEFAULT 'Other',
  `source_extra` varchar(40) DEFAULT NULL,
  `isoverdue` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `isanswered` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `duedate` datetime DEFAULT NULL,
  `est_duedate` datetime DEFAULT NULL,
  `reopened` datetime DEFAULT NULL,
  `closed` datetime DEFAULT NULL,
  `lastupdate` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `user_id` (`user_id`),
  KEY `dept_id` (`dept_id`),
  KEY `staff_id` (`staff_id`),
  KEY `team_id` (`team_id`),
  KEY `status_id` (`status_id`),
  KEY `created` (`created`),
  KEY `closed` (`closed`),
  KEY `duedate` (`duedate`),
  KEY `topic_id` (`topic_id`),
  KEY `sla_id` (`sla_id`),
  KEY `ticket_pid` (`ticket_pid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]ticket`
--

INSERT INTO `[[dbprefix]]ticket` VALUES
(1, NULL, '912473', 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, '[[clientip]]', 'Web', NULL, 0, 0, NULL, '2026-01-22 04:30:00', NULL, NULL, '[[regtime]]', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ticket_priority`
--

CREATE TABLE `[[dbprefix]]ticket_priority` (
  `priority_id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `priority` varchar(60) NOT NULL DEFAULT '',
  `priority_desc` varchar(30) NOT NULL DEFAULT '',
  `priority_color` varchar(7) NOT NULL DEFAULT '',
  `priority_urgency` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ispublic` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`priority_id`),
  UNIQUE KEY `priority` (`priority`),
  KEY `priority_urgency` (`priority_urgency`),
  KEY `ispublic` (`ispublic`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- Dumping data for table `[[dbprefix]]ticket_priority`
--

INSERT INTO `[[dbprefix]]ticket_priority` VALUES
(1, 'low', 'Low', '#DDFFDD', 4, 1),
(2, 'normal', 'Normal', '#FFFFF0', 3, 1),
(3, 'high', 'High', '#FEE7E7', 2, 1),
(4, 'emergency', 'Emergency', '#FEE7E7', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ticket_status`
--

CREATE TABLE `[[dbprefix]]ticket_status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `state` varchar(16) DEFAULT NULL,
  `mode` int(11) unsigned NOT NULL DEFAULT '0',
  `flags` int(11) unsigned NOT NULL DEFAULT '0',
  `sort` int(11) unsigned NOT NULL DEFAULT '0',
  `properties` text NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `state` (`state`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- Dumping data for table `[[dbprefix]]ticket_status`
--

INSERT INTO `[[dbprefix]]ticket_status` VALUES
(1, 'Open', 'open', 3, 0, 1, '{"description":"Open tickets."}', '[[regtime]]', '0000-00-00 00:00:00'),
(2, 'Resolved', 'closed', 1, 0, 2, '{"allowreopen":true,"reopenstatus":0,"description":"Resolved tickets"}', '[[regtime]]', '0000-00-00 00:00:00'),
(3, 'Closed', 'closed', 3, 0, 3, '{"allowreopen":true,"reopenstatus":0,"description":"Closed tickets. Tickets will still be accessible on client and staff panels."}', '[[regtime]]', '0000-00-00 00:00:00'),
(4, 'Archived', 'archived', 3, 0, 4, '{"description":"Tickets only adminstratively available but no longer accessible on ticket queues and client panel."}', '[[regtime]]', '0000-00-00 00:00:00'),
(5, 'Deleted', 'deleted', 3, 0, 5, '{"description":"Tickets queued for deletion. Not accessible on ticket queues."}', '[[regtime]]', '0000-00-00 00:00:00');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]ticket__cdata`
--

CREATE TABLE `[[dbprefix]]ticket__cdata` (
  `ticket_id` int(11) unsigned NOT NULL,
  `subject` mediumtext,
  `priority` mediumtext,
  PRIMARY KEY (`ticket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `[[dbprefix]]ticket__cdata`
--

INSERT INTO `[[dbprefix]]ticket__cdata` VALUES
(1, 'osTicket Installed!', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]translation`
--

CREATE TABLE `[[dbprefix]]translation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `object_hash` char(16) CHARACTER SET ascii DEFAULT NULL,
  `type` enum('phrase','article','override') DEFAULT NULL,
  `flags` int(10) unsigned NOT NULL DEFAULT '0',
  `revision` int(11) unsigned DEFAULT NULL,
  `agent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `lang` varchar(16) NOT NULL DEFAULT '',
  `text` mediumtext NOT NULL,
  `source_text` text,
  `updated` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type` (`type`,`lang`),
  KEY `object_hash` (`object_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user`
--

CREATE TABLE `[[dbprefix]]user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `org_id` int(10) unsigned NOT NULL,
  `default_email_id` int(10) NOT NULL,
  `status` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `org_id` (`org_id`),
  KEY `default_email_id` (`default_email_id`),
  KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]user`
--

INSERT INTO `[[dbprefix]]user` VALUES
(1, 1, 1, 0, 'osTicket Team', '[[regtime]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_account`
--

CREATE TABLE `[[dbprefix]]user_account` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `status` int(11) unsigned NOT NULL DEFAULT '0',
  `timezone` varchar(64) DEFAULT NULL,
  `lang` varchar(16) DEFAULT NULL,
  `username` varchar(64) DEFAULT NULL,
  `passwd` varchar(128) CHARACTER SET ascii COLLATE ascii_bin DEFAULT NULL,
  `backend` varchar(32) DEFAULT NULL,
  `extra` text,
  `registered` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user_email`
--

CREATE TABLE `[[dbprefix]]user_email` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `flags` int(10) unsigned NOT NULL DEFAULT '0',
  `address` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address` (`address`),
  KEY `user_email_lookup` (`user_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `[[dbprefix]]user_email`
--

INSERT INTO `[[dbprefix]]user_email` VALUES
(1, 1, 0, 'feedback@osticket.com');

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]user__cdata`
--

CREATE TABLE `[[dbprefix]]user__cdata` (
  `user_id` int(11) unsigned NOT NULL,
  `email` mediumtext,
  `name` mediumtext,
  `phone` mediumtext,
  `notes` mediumtext,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `[[dbprefix]]_search`
--

CREATE TABLE `[[dbprefix]]_search` (
  `object_type` varchar(8) NOT NULL,
  `object_id` int(11) unsigned NOT NULL,
  `title` text,
  `content` text,
  PRIMARY KEY (`object_type`,`object_id`),
  FULLTEXT KEY `search` (`title`,`content`)
) [[engine]] DEFAULT CHARSET=utf8;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
