# CE-PhoenixCart

<p align="center">
  <img src="https://raw.githubusercontent.com/CE-PhoenixCart/PhoenixCart/master/.github/ce-phoenix.png">
</p>

## Table of Contents

* [What is Phoenix](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#description)
  - [Demo Site](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#demo-sites)
* [Installation](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#installation)
  - [Requirements](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#requirements)
  - [One-click](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#one-click)
  - [User Checklist](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#user-checklist)  
  - [Language Packs](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#language-packs)
* [Certified Partners](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#certified-partners)
* [Supporting the Project](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#how-to-support-the-phoenix-project)
  - [Join the Phoenix Forum](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#join-the-phoenix-forum)
* [Links](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#helpful-links)
* [Credits](https://github.com/CE-PhoenixCart/PhoenixCart?tab=readme-ov-file#credits)

## Description

Phoenix is a powerful ecommerce shop ready to use out of the box, putting you online and in full control of your business right from the start.  Your customers will love the modern, responsive design that will not only make your website look great on all mobile viewing devices but also perform at speed whilst giving you the power to create an individual and unique look to your shop with just a few clicks!

Phoenix is packed with many first class utilities as standard but its modular software design lets you add many more with no programming skills required. The full suite of product, shipping and payment options included will let you sell thousands of products in any number of categories worldwide in any currency or language providing a seamless customer experience.

### Demo Sites

Version | URL
------- | ---
Core|https://phoenixcart.org/demo/  
Admin|https://phoenixcart.org/demo_admin/admin/

## Installation

Installation of Phoenix takes no more than a few minutes - you will need a hosting account that supports PHP (programming language) and has at least one SQL database.  Phoenix can even be installed on your home computer for testing purposes.

## One-click

Phoenix can now be installed with just `one click` via [Softaculous](http://www.softaculous.com/apps/ecommerce/CE_Phoenix) or [Installatron](https://installatron.com/cephoenixcart/)

### Requirements

Software | Minimum | Maximum (tested)
-------- | ------- | ----------------
PHP | 7.3 | 8.3
MariaDB | 10.2.2 | 10.5
MySQL | 5.7.7 | 8.0

Only one of MySQL or MariaDB is needed.  

Type | Name | Value
---- | ---- | -----
PHP setting | allow_url_fopen | ON
PHP extension | MySQLi | enabled
PHP extension | intl | enabled
PHP setting | session.use_trans_sid | OFF
PHP setting | session.auto_start | OFF
PHP setting | file_uploads | ON

Internationalization of date names will not work properly without intl enabled.

### User Checklist

- [x] read this README document
- [ ] download Phoenix & perform installation
- [ ] check security page in administrative area;  
      admin > tools > security checks
- [ ] join Phoenix Forum
- [ ] install modules;  
      admin > modules > navbar<br>
      admin > modules > content<br>
      admin > modules > boxes<br>
      admin > modules > shipping<br>
      admin > modules > payment
- [ ] perform a test checkout
- [ ] load your categories and products

### Language Packs

See the list at https://phoenixcart.org/forum/app.php/addons/free/language-23

Please be aware that most language packs are maintained by volunteers so may not be fully up to date.

## How to Support the Phoenix Project

Help Phoenix fly high...if you or your employer is commercially dependent on Phoenix (or a previous incarnation), please help to [sponsor](https://phoenixcart.org/phoenix_gopro.php) forward movement in the code-base. Phoenix needs you as much as you need Phoenix.

Thank you to all shopowners, developers, consultants and business owners who are supporting the Project by volunteering their time and/or by supporting the project financially.

### Certified Partners

[Certified Partners](https://phoenixcart.org/forum/viewforum.php?f=22) are those who are known to produce modern code, adhering as much as possible to the Phoenix core principle of `no core changes`. They also provide services such as SEO, [hosting](https://phoenixcart.org/forum/app.php/hosting), theme design and more.

* These partners are certified by the Core Team
* These partners support Phoenix by giving their time, code and financial support

If you are looking for a developer for a paid-for project, please consider one of those at https://phoenixcart.org/forum/app.php/developers

### Join the Phoenix Forum

If you wish to help steer the future direction of the software, join the [Forum](https://phoenixcart.org/forum/) and consider [sponsoring](https://phoenixcart.org/phoenix_gopro.php) Phoenix.

## Helpful Links

Channel | URL 
------------ | -------------
Phoenix (Forum) | https://phoenixcart.org/forum/
Phoenix (Youtube) | https://www.youtube.com/@PhoenixCart/
Zipurman Coding (Youtube) | https://www.youtube.com/user/zipurman/videos
User Guide (Phoenix Cart) | https://phoenixcart.org/phoenixcartwiki/index.php
Add-ons Library (Phoenix Cart) | https://phoenixcart.org/forum/addons/

## Credits

Images in the default installation are copyright their respective owners;

Image | Owner | Usage
------------ | ------------- | -------------
Phoenix Logos | Phoenix Cart | https://phoenixcart.org Phoenix Logos may not be used without prior written permission from the copyright owner.
Oranges, Lemons, Pears, Apples | [Eelffica](https://pixabay.com/users/eelffica-52436/) from Pixabay | https://pixabay.com/service/license/
Tomatoes | [Rocky_H](https://pixabay.com/users/rocky_h-11790006/) from Pixabay | https://pixabay.com/service/license/
Glasses | [Alexander Lesnitsky](https://pixabay.com/users/alles-2597842/) from Pixabay | https://pixabay.com/service/license/
Farm | [OpenClipart-Vectors](https://pixabay.com/users/openclipart-vectors-30363/) from Pixabay | https://pixabay.com/service/license/
Strawberries | [Gerd Altman](https://pixabay.com/users/geralt-9301/) from Pixabay | https://pixabay.com/service/license/
Fruit, Laptop | [Ylanite Koppens](https://pixabay.com/users/nietjuhart-30460544/) from Pixabay | https://pixabay.com/service/license/

Other fruit images are based on modified images from the named owners.
