<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* Ελληνική μετάφραση από την ομάδα του phpbbgr.com
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'ACP_PERMISSIONS_EXPLAIN'	=> '
		<p>Οι προσβάσεις είναι εξαιρετικά λεπτομερείς και ομαδοποιούνται σε τέσσερις κύριες ενότητες, οι οποίες είναι οι εξής:</p>

		<h2>Γενικές προσβάσεις</h2>
		<p>Αυτές χρησιμοποιούνται για να ελέγξουν την πρόσβαση σε ένα γενικό επίπεδο και ισχύουν για ολόκληρο το σύστημα συζητήσεων. Διαιρούνται περαιτέρω σε προσβάσεις μέλους, προσβάσεις ομάδας, διαχειριστές και καθολικοί συντονιστές Δ. Συζήτησης.</p>

		<h2>Προσβάσεις βασισμένες σε Δ. Συζήτηση</h2>
		<p>Αυτές χρησιμοποιούνται για τον έλεγχο της πρόσβασης σε μια Δ. Συζήτηση. Διαιρούνται περαιτέρω σε προσβάσεις Δ. Συζήτησης, συντονιστές Δ. Συζήτησης, προσβάσεις μέλους Δ. Συζήτησης και προσβάσεις ομάδας Δ. Συζήτησης.</p>

		<h2>Ρόλοι προσβάσεων</h2>
		<p>Αυτοί χρησιμοποιούνται για να δημιουργήσουν διαφορετικά σύνολα δικαιωμάτων πρόσβασης για τους διάφορους τύπους δικαιωμάτων που αργότερα να είναι σε θέση να ανατίθενται σε μια βασισμένη σε ρόλο βάση. Οι προεπιλεγμένοι ρόλοι θα πρέπει να καλύπτουν τη διαχείριση συστημάτων συζητήσεων μικρών και μεγάλων, αν και σε κάθε μια από τις τέσσερις ενότητες, μπορείτε να προσθέσετε, επεξεργαστείτε, διαγράψετε ρόλους, σύμφωνα την κρίση σας.</p>

		<h2>Αποτελεσματικά δικαιώματα</h2>
		<p>Αυτά χρησιμοποιούνται για να προβάλετε τις προσβάσεις που ισχύουν όπως ανατέθηκαν σε μέλη, συντονιστές (Δ. Συζητήσεων και καθολικούς), διαχειριστές ή Δ. Συζητήσεις.</p>

		<br />

		<p>Για περισσότερες πληροφορίες σχετικά με τη ρύθμιση και τη διαχείριση των δικαιωμάτων πρόσβασης στο σύστημα συζητήσεών σας phpBB3, παρακαλώ δείτε στην ενότητα <a href="https://www.phpbb.com/support/docs/en/3.3/ug/quickstart/permissions/">Setting permissions of our Quick Start Guide</a>.</p>
	',

	'ACL_NEVER'				=> 'Ποτέ ',
	'ACL_SET'				=> 'Ρυθμίσεις προσβάσεων',
	'ACL_SET_EXPLAIN'		=> 'Οι προσβάσεις βασίζονται σε ένα απλό σύστημα <strong>ΝΑΙ</strong>/<strong>ΟΧΙ</strong>. Η ρύθμιση μια επιλογής σε <strong>ΠΟΤΕ</strong> για ένα μέλος ή ομάδα μελών αντικαθιστά κάθε άλλη τιμή που έχει ανατεθεί σε αυτή. Εάν δεν επιθυμείτε για αναθέσετε μια τιμή σε μια επιλογή για αυτό το μέλος ή την ομάδα, επιλέξτε <strong>ΟΧΙ</strong>. Εάν ανατέθηκαν τιμές για αυτή την επιλογή κάπου αλλού, αυτές θα χρησιμοποιούνται κατά προτεραιότητα, διαφορετικά θεωρείται <strong>ΠΟΤΕ</strong>. Όλα τα αντικείμενα που επισημαίνονται (με το πλαίσιο επιλογής μπροστά τους) θα αντιγράψουν το σύνολο προσβάσεων που εσείς καθορίζετε. Παρακαλώ σημειώστε ότι επιλέγοντας προσβάσεις διαχειριστή σε λογαριασμούς ιδρυτών δε θα έχει κάποιο αποτέλεσμα καθώς οι προσβάσεις διαχειριστή είναι πάντα στην επιλογή <strong>ΝΑΙ</strong> για τους ιδρυτές.',
	'ACL_SETTING'			=> 'Ρυθμίσεις',

	'ACL_TYPE_A_'			=> 'Δικαιώματα διαχείρισης',
	'ACL_TYPE_F_'			=> 'Δικαιώματα Δ. Συζήτησης',
	'ACL_TYPE_M_'			=> 'Δικαιώματα συντονισμού',
	'ACL_TYPE_U_'			=> 'Δικαιώματα μέλους',

	'ACL_TYPE_GLOBAL_A_'	=> 'Δικαιώματα διαχείρισης',
	'ACL_TYPE_GLOBAL_U_'	=> 'Δικαιώματα μέλους',
	'ACL_TYPE_GLOBAL_M_'	=> 'Δικαιώματα καθολικών συντονιστών',
	'ACL_TYPE_LOCAL_M_'		=> 'Δικαιώματα συντονιστών Δ. Συζήτησης',
	'ACL_TYPE_LOCAL_F_'		=> 'Δικαιώματα Δ. Συζήτησης',

	'ACL_NO'				=> 'Όχι',
	'ACL_VIEW'				=> 'Προβολή προσβάσεων',
	'ACL_VIEW_EXPLAIN'		=> 'Εδώ μπορείτε να δείτε τις ισχύουσες προσβάσεις του μέλους/ομάδας. Ένα κόκκινο τετράγωνο υποδεικνύει ότι το μέλος/ομάδα δεν έχει τα δικαίωμα, ένα πράσινο τετράγωνο υποδεικνύει ότι το μέλος/ομάδα έχει το δικαίωμα.',
	'ACL_YES'				=> 'Ναι',

	'ACP_ADMINISTRATORS_EXPLAIN'				=> 'Εδώ μπορείτε να αναθέσετε δικαιώματα διαχειριστή σε μέλη ή ομάδες. Όλα τα μέλη με δικαιώματα διαχειριστή μπορούν να δουν τον πίνακα ελέγχου διαχειριστή.',
	'ACP_FORUM_MODERATORS_EXPLAIN'				=> 'Εδώ μπορείτε να αναθέσετε δικαιώματα συντονιστή σε μέλη και ομάδες ως συντονιστές Δ. Συζήτησης. Για να αναθέσετε σε μέλη πρόσβαση στις Δ. Συζητήσεις, για να καθορίσετε τα δικαιώματα καθολικού συντονισμού ή διαχειριστές παρακαλώ χρησιμοποιήστε την κατάλληλη σελίδα.',
	'ACP_FORUM_PERMISSIONS_EXPLAIN'				=> 'Εδώ μπορείτε να αλλάξετε το ποια μέλη και ομάδες μπορούν να έχουν πρόσβαση σε ποιες Δ. Συζητήσεις. Για να αναθέσετε συντονιστές ή να καθορίσετε τους διαχειριστές παρακαλώ χρησιμοποιήστε την κατάλληλη σελίδα.',
	'ACP_FORUM_PERMISSIONS_COPY_EXPLAIN'		=> 'Εδώ μπορείτε να αντιγράψετε προσβάσεις Δ. Συζήτησης από μία Δ. Συζήτηση σε μια ή περισσότερες άλλες Δ. Συζητήσεις.',
	'ACP_GLOBAL_MODERATORS_EXPLAIN'				=> 'Εδώ μπορείτε να αναθέσετε δικαιώματα προσβάσεων καθολικού συντονιστή σε μέλη ή ομάδες. Αυτοί οι συντονιστές είναι σαν τους συνηθισμένους συντονιστές με τη εξαίρεση ότι έχουν πρόσβαση σε κάθε Δ. Συζήτηση του συστήματος συζητήσεών σας.',
	'ACP_GROUPS_FORUM_PERMISSIONS_EXPLAIN'		=> 'Εδώ μπορείτε να αναθέσετε τα δικαιώματα προσβάσεων ομάδας Δ. Συζήτησης.',
	'ACP_GROUPS_PERMISSIONS_EXPLAIN'			=> 'Εδώ μπορείτε να αναθέσετε καθολικά δικαιώματα προσβάσεων σε ομάδες, δικαιώματα μέλους, δικαιώματα καθολικών συντονιστών και δικαιώματα διαχειριστών. Τα δικαιώματα μέλους περιλαμβάνουν δυνατότητες όπως η χρήση των άβαταρ, η αποστολή προσωπικών μηνυμάτων κλπ.,·τα δικαιώματα καθολικών συντονιστών όπως η έγκριση των δημοσιεύσεων, η διαχείριση θεμάτων, η διαχείριση αποκλεισμών, κλπ. και τέλος τα δικαιώματα των διαχειριστών όπως η αλλαγή προσβάσεων, ο καθορισμός προσαρμοσμένων BBCodes, η διαχείριση των Δ. Συζητήσεων κλπ. Δικαιώματα μεμονωμένου μέλους μέλους θα πρέπει να αλλάζουν μόνο σε σπάνιες περιπτώσεις, η προτιμώμενη μέθοδος είναι βάζοντας μέλη σε ομάδες και αναθέτοντας τα δικαιώματα ομάδας.',
	'ACP_ADMIN_ROLES_EXPLAIN'					=> 'Εδώ μπορείτε να διαχειριστείτε τους ρόλους για τα δικαιώματα διαχείρισης. Οι ρόλοι είναι αποτελεσματικά δικαιώματα, εάν αλλάξετε έναν ρόλο τα στοιχεία που τους έχει ανατεθεί αυτός ο ρόλος, θα αλλάξουν τα δικαιώματα τους επίσης.',
	'ACP_FORUM_ROLES_EXPLAIN'					=> 'Εδώ μπορείτε να διαχειριστείτε τους ρόλους για τα δικαιώματα στις Δ. Συζητήσεις. Οι ρόλοι είναι αποτελεσματικά δικαιώματα, εάν αλλάξετε έναν ρόλο τα στοιχεία που τους έχει ανατεθεί αυτός ο ρόλος, θα αλλάξουν τα δικαιώματα τους επίσης.',
	'ACP_MOD_ROLES_EXPLAIN'						=> 'Εδώ μπορείτε να διαχειριστείτε τους ρόλους για τα δικαιώματα συντονισμού. Οι ρόλοι είναι αποτελεσματικά δικαιώματα, εάν αλλάξετε έναν ρόλο τα στοιχεία που τους έχει ανατεθεί αυτός ο ρόλος, θα αλλάξουν τα δικαιώματα τους επίσης.',
	'ACP_USER_ROLES_EXPLAIN'					=> 'Εδώ μπορείτε να διαχειριστείτε τους ρόλους για τα δικαιώματα μέλους. Οι ρόλοι είναι αποτελεσματικά δικαιώματα, εάν αλλάξετε έναν ρόλο τα στοιχεία που τους έχει ανατεθεί αυτός ο ρόλος, θα αλλάξουν τα δικαιώματα τους επίσης.',
	'ACP_USERS_FORUM_PERMISSIONS_EXPLAIN'		=> 'Εδώ μπορείτε να αναθέσετε δικαιώματα προσβάσεων Δ. Συζητήσεων σε μέλη.',
	'ACP_USERS_PERMISSIONS_EXPLAIN'				=> 'Εδώ μπορείτε να αναθέσετε καθολικά δικαιώματα σε μέλη - δικαιώματα μέλους, δικαιώματα καθολικών συντονιστών και δικαιώματα των διαχειριστών. Τα δικαιώματα μέλους περιλαμβάνουν δυνατότητες όπως η χρήση των άβαταρ, η αποστολή προσωπικών μηνυμάτων, κλπ., τα δικαιώματα καθολικών συντονιστών όπως είναι η έγκριση δημοσιεύσεων, η διαχείριση θεμάτων, η διαχείριση απαγορεύσεων, κλπ. και τέλος τα δικαιώματα των διαχειριστών όπως η αλλαγή προσβάσεων, ο καθορισμός προσαρμοσμένων BBCodes, η διαχείριση Δ. Συζητήσεις, κλπ. Για αλλάξετε αυτές τις ρυθμίσεις για μεγάλο αριθμό μελών, το σύστημα προσβάσεις ομάδας είναι η προτιμώμενη μέθοδος. Τα δικαιώματα των μελών θα πρέπει να αλλάζουν μόνο σε σπάνιες περιπτώσεις, η προτιμώμενη μέθοδος είναι βάζοντας μέλη σε ομάδες και αναθέτοντας τα δικαιώματα ομάδας.',
	'ACP_VIEW_ADMIN_PERMISSIONS_EXPLAIN'		=> 'Εδώ μπορείτε να δείτε τα αποτελεσματικά δικαιώματα διαχείρισης που ανατέθηκαν στα επιλεγμένα μέλη/ομάδες.',
	'ACP_VIEW_GLOBAL_MOD_PERMISSIONS_EXPLAIN'	=> 'Εδώ μπορείτε να δείτε τα αποτελεσματικά δικαιώματα συντονισμού που ανατέθηκαν στα επιλεγμένα μέλη/ομάδες.',
	'ACP_VIEW_FORUM_PERMISSIONS_EXPLAIN'		=> 'Εδώ μπορείτε να δείτε τα δικαιώματα πρόσβασης των Δ. Συζητήσεων που ανατέθηκαν στα επιλεγμένα μέλη/ομάδες και Δ. Συζητήσεις.',
	'ACP_VIEW_FORUM_MOD_PERMISSIONS_EXPLAIN'	=> 'Εδώ μπορείτε να δείτε τα δικαιώματα συντονιστών Δ. Συζητήσεων που ανατέθηκαν στα επιλεγμένα μέλη/ομάδες και Δ. Συζητήσεις.',
	'ACP_VIEW_USER_PERMISSIONS_EXPLAIN'			=> 'Εδώ μπορείτε να δείτε τα αποτελεσματικά δικαιώματα μέλους που ανατέθηκαν στα επιλεγμένα μέλη/ομάδες.',

	'ADD_GROUPS'				=> 'Προσθήκη ομάδων',
	'ADD_PERMISSIONS'			=> 'Προσθήκη προσβάσεων',
	'ADD_USERS'					=> 'Προσθήκη μελών',
	'ADVANCED_PERMISSIONS'		=> 'Αναλυτικές προσβάσεις',
	'ALL_GROUPS'				=> 'Επιλογή όλων των ομάδων',
	'ALL_NEVER'					=> 'Όλα <strong>ΠΟΤΕ</strong>',
	'ALL_NO'					=> 'Όλα <strong>ΟΧΙ</strong>',
	'ALL_USERS'					=> 'Επιλογή όλων των μελών',
	'ALL_YES'					=> 'Όλα <strong>ΝΑΙ</strong>',
	'APPLY_ALL_PERMISSIONS'		=> 'Εφαρμόστε όλα τα δικαιώματα',
	'APPLY_PERMISSIONS'			=> 'Εφαρμόστε δικαιώματα',
	'APPLY_PERMISSIONS_EXPLAIN'	=> 'Τα δικαιώματα και ο ρόλος που καθορίζονται για αυτό το αντικείμενο θα εφαρμόζονται μόνο σε αυτό το αντικείμενο και όλα τα επιλεγμένα αντικείμενα.',
	'AUTH_UPDATED'				=> 'Τα δικαιώματα πρόσβασης ενημερώθηκαν με επιτυχία.',

	'COPY_PERMISSIONS_CONFIRM'				=> 'Είστε σίγουρος (-η) ότι επιθυμείτε να πραγματοποιήσετε αυτή τη λειτουργία; Παρακαλώ να λάβετε υπόψη ότι αυτό θα αντικαταστήσει τα υπάρχοντα δικαιώματα στους επιλεγμένους στόχους.',
	'COPY_PERMISSIONS_FORUM_FROM_EXPLAIN'	=> 'Η πηγή της Δ. Συζήτησης που θέλετε να αντιγράψετε προσβάσεις.',
	'COPY_PERMISSIONS_FORUM_TO_EXPLAIN'		=> 'Ο προορισμός της Δ. Συζήτησης που θέλετε να γίνει αντιγραφή προσβάσεων που εφαρμόζονται.',
	'COPY_PERMISSIONS_FROM'					=> 'Αντιγραφή προσβάσεων από',
	'COPY_PERMISSIONS_TO'					=> 'Εφαρμόστε προσβάσεις για',

	'CREATE_ROLE'				=> 'Δημιουργία ρόλου',
	'CREATE_ROLE_FROM'			=> 'Χρήση ρυθμίσεων από…',
	'CUSTOM'					=> 'Προσαρμογή…',

	'DEFAULT'					=> 'Προεπιλογή',
	'DELETE_ROLE'				=> 'Διαγραφή ρόλου',
	'DELETE_ROLE_CONFIRM'		=> 'Είστε σίγουρος (-η) ότι θέλετε να αφαιρέσετε αυτόν τον ρόλο; Τα στοιχεία που τους έχει ανατεθεί αυτός ο ρόλος <strong>δεν</strong> θα χάσουν τις ρυθμίσεις πρόσβασης τους.',
	'DISPLAY_ROLE_ITEMS'		=> 'Προβολή στοιχείων που χρησιμοποιούν αυτό τον ρόλο',

	'EDIT_PERMISSIONS'			=> 'Επεξεργασία δικαιωμάτων πρόσβασης',
	'EDIT_ROLE'					=> 'Επεξεργασία ρόλου',

	'GROUPS_NOT_ASSIGNED'		=> 'Καμία ομάδα δεν ανατέθηκε σε αυτό τον ρόλο',

	'LOOK_UP_GROUP'				=> 'Εμφάνιση ομάδας μελών',
	'LOOK_UP_USER'				=> 'Εμφάνιση μέλους',

	'MANAGE_GROUPS'		=> 'Διαχείριση ομάδων',
	'MANAGE_USERS'		=> 'Διαχείριση μελών',

	'NO_AUTH_SETTING_FOUND'		=> 'Δεν καθορίστηκαν ρυθμίσεις δικαιωμάτων.',
	'NO_ROLE_ASSIGNED'			=> 'Κανένας ρόλος δεν ανατέθηκε…',
	'NO_ROLE_ASSIGNED_EXPLAIN'	=> 'Ρύθμιση σε αυτό τον ρόλο δεν αλλάζει τα δικαιώματα στα δεξιά. Εάν θέλετε να αφαιρέσετε όλα τα δικαιώματα θα πρέπει να χρησιμοποιήσετε τον σύνδεσμο “ΟΛΑ <strong>ΟΧΙ</strong>”.',
	'NO_ROLE_AVAILABLE'			=> 'Κανένας διαθέσιμος ρόλος',
	'NO_ROLE_NAME_SPECIFIED'	=> 'Παρακαλώ δώστε ένα όνομα στον ρόλο.',
	'NO_ROLE_SELECTED'			=> 'Ο ρόλος δεν μπορεί να βρεθεί.',
	'NO_USER_GROUP_SELECTED'	=> 'Δεν έχετε επιλέξει κανένα μέλος ή ομάδα.',

	'ONLY_FORUM_DEFINED'	=> 'Καθορίσατε μόνο Δ. Συζητήσεις στην επιλογή σας. Παρακαλώ επιλέξτε επίσης τουλάχιστον ένα μέλος ή μια ομάδα.',

	'PERMISSION_APPLIED_TO_ALL'		=> 'Τα δικαιώματα πρόσβασης και ο ρόλος θα εφαρμοστούν επίσης σε όλα τα επιλεγμένα αντικείμενα ',
	'PLUS_SUBFORUMS'				=> '+Υπο-συζητήσεις',

	'REMOVE_PERMISSIONS'			=> 'Αφαίρεση δικαιωμάτων',
	'REMOVE_ROLE'					=> 'Αφαίρεση ρόλου',
	'RESULTING_PERMISSION'			=> 'Οι προσβάσεις που προκύπτουν',
	'ROLE'							=> 'Ρόλος',
	'ROLE_ADD_SUCCESS'				=> 'Ο ρόλος προστέθηκε με επιτυχία.',
	'ROLE_ASSIGNED_TO'				=> 'Μέλη/ομάδες που ανατέθηκαν σε %s',
	'ROLE_DELETED'					=> 'Ο ρόλος αφαιρέθηκε με επιτυχία.',
	'ROLE_DESCRIPTION'				=> 'Περιγραφή ρόλου',

	'ROLE_ADMIN_FORUM'			=> 'Διαχειριστής Δ. Συζήτησης',
	'ROLE_ADMIN_FULL'			=> 'Ολικός διαχειριστής',
	'ROLE_ADMIN_STANDARD'		=> 'Τυπικός διαχειριστής',
	'ROLE_ADMIN_USERGROUP'		=> 'Διαχειριστής μέλους και ομάδων',
	'ROLE_FORUM_BOT'			=> 'Πρόσβαση bot',
	'ROLE_FORUM_FULL'			=> 'Πλήρης πρόσβαση',
	'ROLE_FORUM_LIMITED'		=> 'Οριακή πρόσβαση',
	'ROLE_FORUM_LIMITED_POLLS'	=> 'Οριακή πρόσβαση + Δημοψηφίσματα',
	'ROLE_FORUM_NOACCESS'		=> 'Καμία πρόσβαση',
	'ROLE_FORUM_ONQUEUE'		=> 'Σε σειρά αναμονής συντονισμού',
	'ROLE_FORUM_POLLS'			=> 'Τυπική πρόσβαση + Δημοψηφίσματα',
	'ROLE_FORUM_READONLY'		=> 'Πρόσβαση μόνο για ανάγνωση',
	'ROLE_FORUM_STANDARD'		=> 'Τυπική πρόσβαση',
	'ROLE_FORUM_NEW_MEMBER'		=> 'Πρόσβαση πρόσφατα εγγραμμένου μέλους',
	'ROLE_MOD_FULL'				=> 'Πλήρης συντονιστής',
	'ROLE_MOD_QUEUE'			=> 'Σε αναμονή συντονιστής',
	'ROLE_MOD_SIMPLE'			=> 'Απλός συντονιστής',
	'ROLE_MOD_STANDARD'			=> 'Τυπικός συντονιστής',
	'ROLE_USER_FULL'			=> 'Όλα τα χαρακτηριστικά',
	'ROLE_USER_LIMITED'			=> 'Οριακά χαρακτηριστικά',
	'ROLE_USER_NOAVATAR'		=> 'Κανένα άβαταρ',
	'ROLE_USER_NOPM'			=> 'Χωρίς προσωπικά μηνύματα',
	'ROLE_USER_STANDARD'		=> 'Τυπικά χαρακτηριστικά',
	'ROLE_USER_NEW_MEMBER'		=> 'Χαρακτηριστικά πρόσφατα εγγραμμένου μέλους',

	'ROLE_DESCRIPTION_ADMIN_FORUM'			=> 'Μπορεί να έχει πρόσβαση στη διαχείριση και στις ρυθμίσεις δικαιωμάτων πρόσβασης της Δ. Συζήτησης.',
	'ROLE_DESCRIPTION_ADMIN_FULL'			=> 'Έχει πρόσβαση σε όλες τις διαχειριστικές λειτουργίες αυτού του συστήματος συζητήσεων.<br />Δεν προτείνεται.',
	'ROLE_DESCRIPTION_ADMIN_STANDARD'		=> 'Έχει πρόσβαση στις περισσότερες διαχειριστικές λειτουργίες, αλλά δεν επιτρέπεται να χρησιμοποιήσει εργαλεία σχετικά με το σύστημα και τον διακομιστή.',
	'ROLE_DESCRIPTION_ADMIN_USERGROUP'		=> 'Μπορεί να διαχειριστεί ομάδες και μέλη: Ικανός να αλλάξει τα δικαιώματα πρόσβασης, τις ρυθμίσεις, να διαχειριστεί αποκλεισμούς και να διαχειριστεί βαθμούς.',
	'ROLE_DESCRIPTION_FORUM_BOT'			=> 'Αυτός ο ρόλος προτείνεται για bots και τα spiders αναζήτησης.',
	'ROLE_DESCRIPTION_FORUM_FULL'			=> 'Μπορεί να χρησιμοποιήσει όλες τις δυνατότητες της Δ. Συζήτησης, συμπεριλαμβανομένων της δημοσίευσης ανακοινώσεων και σημειώσεων. Μπορεί επίσης να αγνοήσει το όριο αναμονής.<br />Δεν προτείνεται για κανονικά μέλη.',
	'ROLE_DESCRIPTION_FORUM_LIMITED'		=> 'Μπορεί να χρησιμοποιήσει μερικές δυνατότητες της Δ. Συζήτησης, αλλά δεν μπορεί να επισυνάψει αρχεία ή να χρησιμοποιήσει τα εικονίδια δημοσίευσης.',
	'ROLE_DESCRIPTION_FORUM_LIMITED_POLLS'	=> 'Όμοια με την οριακή πρόσβαση, αλλά μπορεί επίσης να δημιουργήσει δημοψηφίσματα.',
	'ROLE_DESCRIPTION_FORUM_NOACCESS'		=> 'Δεν μπορεί ούτε να δει ούτε να έχει πρόσβαση στη Δ. Συζήτηση.',
	'ROLE_DESCRIPTION_FORUM_ONQUEUE'		=> 'Μπορεί να χρησιμοποιήσει τις περισσότερες δυνατότητες της Δ. Συζήτησης συμπεριλαμβανομένων των συνημμένων, αλλά οι δημοσιεύσεις και τα θέματα πρέπει να εγκριθούν από έναν συντονιστή.',
	'ROLE_DESCRIPTION_FORUM_POLLS'			=> 'Όμοια με την τυπική πρόσβαση, αλλά μπορεί επίσης να δημιουργήσει δημοψηφίσματα.',
	'ROLE_DESCRIPTION_FORUM_READONLY'		=> 'Μπορεί να διαβάσει τη Δ. Συζήτηση, αλλά δεν μπορεί να δημιουργήσει νέα θέματα ή να απαντήσει σε δημοσιεύσεις.',
	'ROLE_DESCRIPTION_FORUM_STANDARD'		=> 'Μπορεί να χρησιμοποιήσει τις περισσότερες δυνατότητες της Δ. Συζήτησης συμπεριλαμβανομένων των συνημμένων και της διαγραφής των θεμάτων του, αλλά δεν μπορεί να κλειδώσει θέματα του και δεν μπορεί να δημιουργήσει δημοψηφίσματα.',
	'ROLE_DESCRIPTION_FORUM_NEW_MEMBER'		=> 'Ένας ρόλος για μέλη της ειδικής ομάδας “πρόσφατο εγγραμμένο μέλος” περιέχει <strong>ΠΟΤΕ</strong> δικαιώματα για να κλειδωθούν τα χαρακτηριστικά γνωρίσματα για νέα μέλη.',
	'ROLE_DESCRIPTION_MOD_FULL'				=> 'Μπορεί να χρησιμοποιήσει όλες τις δυνατότητες συντονισμού, συμπεριλαμβανομένου και του αποκλεισμού μέλους.',
	'ROLE_DESCRIPTION_MOD_QUEUE'			=> 'Μπορεί να χρησιμοποιήσει τη σειρά αναμονής για να επικυρώσει και να επεξεργαστεί δημοσιεύσεις, αλλά τίποτα άλλο.',
	'ROLE_DESCRIPTION_MOD_SIMPLE'			=> 'Μπορεί να χρησιμοποιήσει τις βασικές ενέργειες θέματος. Δεν μπορεί να στείλει προειδοποιήσεις ή να χρησιμοποιήσει τη σειρά αναμονής.',
	'ROLE_DESCRIPTION_MOD_STANDARD'			=> 'Μπορεί να χρησιμοποιήσει τα περισσότερα εργαλεία συντονισμού, αλλά δεν μπορεί να αποκλείσει μέλη ή να αλλάξει τον συγγραφέα δημοσίευσης.',
	'ROLE_DESCRIPTION_USER_FULL'			=> 'Μπορεί να χρησιμοποιήσει όλες τις δυνατότητες της Δ. Συζήτησης για τα μέλη, συμπεριλαμβανομένων της αλλαγής του ονόματος μέλους ή της αγνόησης του ορίου αναμονής.<br />Δεν προτείνεται.',
	'ROLE_DESCRIPTION_USER_LIMITED'			=> 'Μπορεί να έχει πρόσβαση σε μερικές από τις δυνατότητες μέλους. Τα συνημμένα, το ηλεκτρονικό ταχυδρομείο και τα στιγμιαία μηνύματα δεν επιτρέπονται.',
	'ROLE_DESCRIPTION_USER_NOAVATAR'		=> 'Έχει ένα περιορισμένο σύνολο δυνατοτήτων και δεν του επιτρέπεται η χρήση της δυνατότητας άβαταρ.',
	'ROLE_DESCRIPTION_USER_NOPM'			=> 'Έχει ένα περιορισμένο σύνολο δυνατοτήτων και δεν του επιτρέπεται να χρησιμοποιήσει προσωπικά μηνύματα.',
	'ROLE_DESCRIPTION_USER_STANDARD'		=> 'Μπορεί να έχει πρόσβαση όμως όχι σε όλες τις δυνατότητες μέλους. Δεν μπορεί να αλλάξει το όνομα μέλους ή να αγνοήσει το όριο αναμονής, για παράδειγμα.',
	'ROLE_DESCRIPTION_USER_NEW_MEMBER'		=> 'Ένας ρόλος για μέλη της ειδικής ομάδας “πρόσφατο εγγραμμένο μέλος” περιέχει <strong>ΠΟΤΕ</strong> δικαιώματα για να κλειδωθούν τα χαρακτηριστικά γνωρίσματα για νέα μέλη.',

	'ROLE_DESCRIPTION_EXPLAIN'		=> 'Εδώ μπορείτε να εισαγάγετε μια σύντομη εξήγηση του τι κάνει αυτός ο ρόλος ή για ποιο σκοπό έχει γίνει. Το κείμενο που εισάγετε εδώ θα εμφανιστεί μέσα στις οθόνες δικαιωμάτων επίσης.',
	'ROLE_DESCRIPTION_LONG'			=> 'Η περιγραφή ρόλου είναι πάρα πολύ μεγάλη, παρακαλώ περιορίστε τη στους 4000 χαρακτήρες.',
	'ROLE_DETAILS'					=> 'Λεπτομέρειες ρόλου',
	'ROLE_EDIT_SUCCESS'				=> 'Ο ρόλος επεξεργάστηκε με επιτυχία.',
	'ROLE_NAME'						=> 'Όνομα ρόλου',
	'ROLE_NAME_ALREADY_EXIST'		=> 'Ένας ρόλος με το όνομα <strong>%s</strong> υπάρχει ήδη για τον συγκεκριμένο τύπο δικαιωμάτων πρόσβασης.',
	'ROLE_NOT_ASSIGNED'				=> 'Ο ρόλος δεν έχει ανατεθεί ακόμη.',

	'SELECTED_FORUM_NOT_EXIST'		=> 'Η επιλεγμένη Δ. Συζήτηση (-εις) δεν υπάρχει.',
	'SELECTED_GROUP_NOT_EXIST'		=> 'Η επιλεγμένη ομάδα (-ες) δεν υπάρχει.',
	'SELECTED_USER_NOT_EXIST'		=> 'Το επιλεγμένος μέλος (-η) δεν υπάρχει.',
	'SELECT_FORUM_SUBFORUM_EXPLAIN'	=> 'Η Δ. Συζήτηση που επιλέξατε εδώ θα συμπεριλάβει όλες τις υπο-συζητήσεις στην επιλογή.',
	'SELECT_ROLE'					=> 'Επιλογή ρόλου…',
	'SELECT_TYPE'					=> 'Επιλογή τύπου',
	'SET_PERMISSIONS'				=> 'Καθορισμός δικαιωμάτων πρόσβασης',
	'SET_ROLE_PERMISSIONS'			=> 'Καθορισμός δικαιωμάτων ρόλου',
	'SET_USERS_PERMISSIONS'			=> 'Καθορισμός δικαιωμάτων πρόσβασης μέλους',
	'SET_USERS_FORUM_PERMISSIONS'	=> 'Καθορισμός δικαιωμάτων προσβάσεων Δ. Συζήτησης μέλους ',

	'TRACE_DEFAULT'					=> 'Από προεπιλογή κάθε πρόσβαση είναι <strong>ΟΧΙ</strong> (απενεργοποιημένο). Έτσι η πρόσβαση μπορεί να αντικατασταθεί από άλλες ρυθμίσεις.',
	'TRACE_FOR'						=> 'Ανίχνευση για',
	'TRACE_GLOBAL_SETTING'			=> '%s (καθολικό)',
	'TRACE_GROUP_NEVER_TOTAL_NEVER'	=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας έχουν τεθεί σε <strong>ΠΟΤΕ</strong> όπως και το αποτέλεσμα, έτσι το παλαιό αποτέλεσμα διατηρείται.',
	'TRACE_GROUP_NEVER_TOTAL_NEVER_LOCAL'	=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΠΟΤΕ</strong> όπως και το αποτέλεσμα συνόλου, έτσι το παλαιό αποτέλεσμα διατηρείται.',
	'TRACE_GROUP_NEVER_TOTAL_NO'	=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας έχουν τεθεί σε <strong>ΠΟΤΕ</strong> το οποίο γίνεται η νέα τιμή συνόλου, επειδή ακόμη δεν είχε τεθεί (θέστε σε<strong>ΟΧΙ</strong>).',
	'TRACE_GROUP_NEVER_TOTAL_NO_LOCAL'	=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΠΟΤΕ</strong> το οποίο γίνεται η νέα τιμή συνόλου, επειδή ακόμη δεν είχε τεθεί (θέστε σε <strong>ΟΧΙ</strong>).',
	'TRACE_GROUP_NEVER_TOTAL_YES'	=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας έχουν τεθεί σε <strong>ΠΟΤΕ</strong> το οποίο αντικαθιστά το σύνολο <strong>ΝΑΙ</strong> σε <strong>ΠΟΤΕ</strong> για αυτό το μέλος.',
	'TRACE_GROUP_NEVER_TOTAL_YES_LOCAL'	=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΠΟΤΕ</strong> το οποίο αντικαθιστά το σύνολο <strong>ΝΑΙ</strong> σε <strong>ΠΟΤΕ</strong> για αυτό το μέλος.',
	'TRACE_GROUP_NO'				=> 'Τα δικαιώματα πρόσβασης είναι <strong>ΟΧΙ</strong> για αυτή την ομάδα, έτσι η παλαιά τιμή συνόλου διατηρείται.',
	'TRACE_GROUP_NO_LOCAL'			=> 'Τα δικαιώματα πρόσβασης είναι <strong>ΟΧΙ</strong> για αυτή την ομάδα μέσα σε αυτή τη Δ. Συζήτηση, έτσι η παλαιά τιμή συνόλου διατηρείται.',
	'TRACE_GROUP_YES_TOTAL_NEVER'	=> 'Τα δικαιώματα πρόσβασης για αυτές τις ομάδες έχουν τεθεί σε <strong>ΝΑΙ</strong> όμως τα αποτελέσματα <strong>ΠΟΤΕ</strong> δεν μπορούν να αντικατασταθούν.',
	'TRACE_GROUP_YES_TOTAL_NEVER_LOCAL'	=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΝΑΙ</strong> όμως στο σύνολο <strong>ΠΟΤΕ</strong> δεν μπορεί να αντικατασταθεί.',
	'TRACE_GROUP_YES_TOTAL_NO'		=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας έχουν τεθεί σε <strong>ΝΑΙ</strong> το οποίο γίνεται η νέα τιμή συνόλου, επειδή ακόμη δεν είχε τεθεί (θέστε σε <strong>ΟΧΙ</strong>).',
	'TRACE_GROUP_YES_TOTAL_NO_LOCAL'	=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΝΑΙ</strong> το οποίο γίνεται η νέα τιμή συνόλου, επειδή ακόμη δεν είχε τεθεί (θέστε σε <strong>ΟΧΙ</strong>).',
	'TRACE_GROUP_YES_TOTAL_YES'		=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας έχουν τεθεί σε <strong>ΝΑΙ</strong> και η συνολική πρόσβαση έχει ήδη τεθεί <strong>ΟΧΙ</strong>, έτσι το αποτέλεσμα συνόλου διατηρείται.',
	'TRACE_GROUP_YES_TOTAL_YES_LOCAL'	=> 'Τα δικαιώματα πρόσβασης αυτής της ομάδας για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΝΑΙ</strong> και η συνολική πρόσβαση έχει ήδη τεθεί <strong>ΝΑΙ</strong>, έτσι το αποτέλεσμα συνόλου διατηρείται.',
	'TRACE_PERMISSION'				=> 'Εντοπισμός δικαιωμάτων - %s',
	'TRACE_RESULT'					=> 'Εντοπισμός αποτελεσμάτων',
	'TRACE_SETTING'					=> 'Εντοπισμός ρυθμίσεων',

	'TRACE_USER_GLOBAL_YES_TOTAL_YES'		=> 'Η ξεχωριστή πρόσβαση Δ. Συζήτησης μέλους αποτιμάται σε <strong>ΝΑΙ</strong> αλλά το σύνολο προσβάσεων έχει ήδη τεθεί σε <strong>ΝΑΙ</strong>, έτσι το συνολικό αποτέλεσμα διατηρείται. %sΕντοπισμός γενικών προσβάσεων%s',
	'TRACE_USER_GLOBAL_YES_TOTAL_NEVER'		=> 'Η ξεχωριστή πρόσβαση Δ. Συζήτησης μέλους αποτιμάται σε <strong>ΝΑΙ</strong>, η οποία αντικαθιστά το τρέχον τοπικό αποτέλεσμα <strong>ΠΟΤΕ</strong>. %sΕντοπισμός γενικών προσβάσεων%s',
	'TRACE_USER_GLOBAL_NEVER_TOTAL_KEPT'	=> 'Η ξεχωριστή πρόσβαση Δ. Συζήτησης μέλους αποτιμάται σε <strong>ΠΟΤΕ</strong>, η οποία δεν επηρεάζει τα τοπικά δικαιώματα πρόσβασης. %sΕντοπισμός γενικών προσβάσεων%s',

	'TRACE_USER_FOUNDER'					=> 'Το μέλος είναι ιδρυτής, ως εκ τούτου τα δικαιώματα πρόσβασης διαχειριστή έχουν τεθεί <strong>ΝΑΙ</strong>.',
	'TRACE_USER_KEPT'						=> 'Τα δικαιώματα πρόσβασης του μέλους είναι <strong>ΟΧΙ</strong>, έτσι η παλαιά τιμή συνόλου διατηρείται.',
	'TRACE_USER_KEPT_LOCAL'					=> 'Τα δικαιώματα πρόσβασης του μέλους για αυτή τη Δ. Συζήτηση είναι <strong>ΟΧΙ</strong>, έτσι η παλαιά τιμή συνόλου διατηρείται.',
	'TRACE_USER_NEVER_TOTAL_NEVER'			=> 'Τα δικαιώματα πρόσβασης του μέλους έχουν τεθεί σε <strong>ΠΟΤΕ</strong> και η τιμή συνόλου τιμή έχει τεθεί <strong>ΠΟΤΕ</strong>, έτσι τίποτα δεν αλλάζει.',
	'TRACE_USER_NEVER_TOTAL_NEVER_LOCAL'	=> 'Τα δικαιώματα πρόσβασης του μέλους είναι για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΠΟΤΕ</strong> και η τιμή συνόλου έχει τεθεί <strong>ΠΟΤΕ</strong>, έτσι τίποτα δεν αλλάζει.',
	'TRACE_USER_NEVER_TOTAL_NO'				=> 'Τα δικαιώματα πρόσβασης του μέλους έχουν τεθεί σε <strong>ΠΟΤΕ</strong> η οποία γίνεται η τιμή συνόλου, επειδή τέθηκε σε ΟΧΙ.',
	'TRACE_USER_NEVER_TOTAL_NO_LOCAL'		=> 'Τα δικαιώματα πρόσβασης του μέλους για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΠΟΤΕ</strong> η οποία γίνεται η τιμή συνόλου, επειδή τέθηκε σε ΟΧΙ.',
	'TRACE_USER_NEVER_TOTAL_YES'			=> 'Τα δικαιώματα πρόσβασης του μέλους έχουν τεθεί σε <strong>ΠΟΤΕ</strong> και αντικαθιστούν το προηγούμενο <strong>ΝΑΙ</strong>.',
	'TRACE_USER_NEVER_TOTAL_YES_LOCAL'		=> 'Τα δικαιώματα πρόσβασης του μέλους για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΠΟΤΕ</strong> και αντικαθιστά το προηγούμενο <strong>ΝΑΙ</strong>.',
	'TRACE_USER_NO_TOTAL_NO'				=> 'Τα δικαιώματα πρόσβασης του μέλους έχουν τεθεί σε <strong>ΟΧΙ</strong> και η τιμή συνόλου έχει τεθεί ΟΧΙ, έτσι προεπιλέγεται σε <strong>ΠΟΤΕ</strong>.',
	'TRACE_USER_NO_TOTAL_NO_LOCAL'			=> 'Τα δικαιώματα πρόσβασης του μέλους για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΟΧΙ</strong> και η τιμή συνόλου έχει τεθεί ΟΧΙ, έτσι προεπιλέγεται σε <strong>ΠΟΤΕ</strong>.',
	'TRACE_USER_YES_TOTAL_NEVER'			=> 'Τα δικαιώματα πρόσβασης του μέλους έχουν τεθεί σε <strong>ΝΑΙ</strong> όμως στο σύνολο <strong>ΠΟΤΕ</strong> δεν μπορεί να αντικατασταθεί.',
	'TRACE_USER_YES_TOTAL_NEVER_LOCAL'		=> 'Τα δικαιώματα πρόσβασης του μέλους για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΝΑΙ</strong> όμως στο σύνολο <strong>ΠΟΤΕ</strong> δεν μπορεί να αντικατασταθεί.',
	'TRACE_USER_YES_TOTAL_NO'				=> 'Τα δικαιώματα πρόσβασης του μέλους έχουν τεθεί σε <strong>ΝΑΙ</strong> η οποία γίνεται η τιμή συνόλου, επειδή τέθηκε σε <strong>ΟΧΙ</strong>.',
	'TRACE_USER_YES_TOTAL_NO_LOCAL'			=> 'Τα δικαιώματα πρόσβασης του μέλους για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΝΑΙ</strong> η οποία γίνεται η τιμή συνόλου, επειδή τέθηκε σε <strong>ΟΧΙ</strong>.',
	'TRACE_USER_YES_TOTAL_YES'				=> 'Τα δικαιώματα πρόσβασης του μέλους έχουν τεθεί σε <strong>ΝΑΙ</strong> και η τιμή συνόλου έχει τεθεί σε <strong>ΝΑΙ</strong>, έτσι τίποτα δεν αλλάζει.',
	'TRACE_USER_YES_TOTAL_YES_LOCAL'		=> 'Τα δικαιώματα πρόσβασης του μέλους για αυτή τη Δ. Συζήτηση έχουν τεθεί σε <strong>ΝΑΙ</strong> και η τιμή συνόλου έχει τεθεί σε <strong>ΝΑΙ</strong>, έτσι τίποτα δεν αλλάζει.',
	'TRACE_WHO'								=> 'Ποιοι ',
	'TRACE_TOTAL'							=> 'Σύνολο',

	'USERS_NOT_ASSIGNED'			=> 'Δεν υπάρχουν μέλη που ανατέθηκαν σε αυτό το ρόλο',
	'USER_IS_MEMBER_OF_DEFAULT'		=> 'είναι μέλος των παρακάτω προκαθορισμένων ομάδων',
	'USER_IS_MEMBER_OF_CUSTOM'		=> 'είναι μέλος των ακόλουθων καθορισμένων ομάδων',

	'VIEW_ASSIGNED_ITEMS'	=> 'Προβολή στοιχείων που ανατέθηκαν',
	'VIEW_LOCAL_PERMS'		=> 'Τοπικές προσβάσεις',
	'VIEW_GLOBAL_PERMS'		=> 'Γενικές προσβάσεις',
	'VIEW_PERMISSIONS'		=> 'Προβολή προσβάσεων',

	'WRONG_PERMISSION_TYPE'				=> 'Έχετε επιλέξει λάθος τύπο πρόσβασης.',
	'WRONG_PERMISSION_SETTING_FORMAT'	=> 'Οι ρυθμίσεις πρόσβασης είναι σε μια εσφαλμένη μορφή, το phpBB δεν είναι σε θέση να τις επεξεργαστεί σωστά.',
));
