<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
* @Polish locale 2014-11-29 18:24:32 Zespół Olympus.pl $
* @Polska wersja językowa phpBB 3.3.12 - 11.06.2024, Mateusz Dutko (vader) www.rnavspotters.pl
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » „ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Polski pakiet językowy dostarcza <a href="http://www.phpbb.pl/" title="Polska społeczność phpBB">phpBB.pl</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|d M Y, H:i|',	// 01 Jan 2007, 13:37 (with Relative days enabled)
	'USER_LANG'			=> 'pl',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 9,

	'1_DAY'			=> '1 dzień',
	'1_MONTH'		=> '1 miesiąc',
	'1_YEAR'		=> '1 rok',
	'2_WEEKS'		=> '2 tygodnie',
	'3_MONTHS'		=> '3 miesiące',
	'6_MONTHS'		=> '6 miesięcy',
	'7_DAYS'		=> '7 dni',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Twoje konto zostało już aktywowane.',
	'ACCOUNT_DEACTIVATED'			=> 'Twoje konto zostało ręcznie dezaktywowane i może zostać ponownie aktywowane tylko przez administratora.',
	'ACP'							=> 'Panel administracji',
	'ACP_SHORT'						=> 'Administracja',
	'ACTIVATION_ALREADY_SENT'		=> 'E-mail aktywacyjny został już wysłany na Twój adres e-mail. Możesz spróbować ponownie po 24 godzinach. Jeśli nadal masz problemy z aktywacją konta, skontaktuj się z administratorem forum.',
	'ACTIVE'						=> 'aktywny',
	'ACTIVE_ERROR'					=> 'Użytkownik o podanej nazwie jest nieaktywny. W przypadku problemów z aktywacją konta proszę skontaktować się z administratorem witryny.',
	'ADMINISTRATOR'					=> 'Administrator',
	'ADMINISTRATORS'				=> 'Administratorzy',
	'AGE'							=> 'Wiek',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'Błąd AJAX',
	'AJAX_ERROR_TEXT'				=> 'Twoje żądanie nie zostało przetworzone.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'Użytkownik usunął żądanie.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'Upłynął limit czasu żądania. Ponów próbę.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'Coś się stało podczas przetwarzania żądania i serwer zwrócił nieprawidłową odpowiedź.',
	'ALLOWED'						=> 'Dozwolone',
	'ALL_FILES'						=> 'Wszystkie pliki',
	'ALL_FORUMS'					=> 'Wszystkie fora',
	'ALL_MESSAGES'					=> 'Wszystkie wiadomości',
	'ALL_POSTS'						=> 'Wszystkie posty',
	'ALL_TIMES'						=> 'Strefa czasowa <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'					=> 'Wszystkie tematy',
	'ALT_TEXT'						=> 'Alternatywny tekst',
	'AND'							=> 'i',
	'ARE_WATCHING_FORUM'			=> 'Obserwujesz to forum. Będziesz otrzymywać powiadomienia o nowych postach.',
	'ARE_WATCHING_TOPIC'			=> 'Obserwujesz ten temat. Będziesz otrzymywać powiadomienia o nowych postach.',
	'ASCENDING'						=> 'Rosnąco',
	'ATTACHMENTS'					=> 'Załączniki',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Plik obrazka, który próbujesz załączyć jest nieprawidłowy.',
	'AUTHOR'						=> 'Autor',
	'AUTH_NO_PROFILE_CREATED'		=> 'Nie udało się utworzyć konta użytkownika.',
	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'				=> 'Wybrana zewnętrzna usługa została już połączona z innym użytkownikiem witryny.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'Nieprawidłowy wpis bazy danych.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'Do obsługi usługi OAuth dostarczono nieprawidłowy typ usługi.',
	'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'						=> 'Podczas przetwarzania żądania OAuth wystąpił błąd.',
	'AUTH_PROVIDER_OAUTH_RETURN_ERROR'						=> 'Zewnętrzna usługa zwróciła nieprawidłową wartość, dlatego żądanie nie może zostać przetworzone.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'Nie utworzono usługi OAuth',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'Token OAuth nie jest przechowywany.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'Token OAuth jest nieprawidłowo przechowywany.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Wysyłanie zostało przerwane, ponieważ przesyłany plik został zidentyfikowany jako potencjalnie niebezpieczny.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Nie można wyświetlić tego pliku, ponieważ rozszerzenie <strong>%s</strong> jest niedozwolone.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Nie można wysłać awatara, ponieważ dane ze zdalnego serwera są nieprawidłowe lub uszkodzone.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Wysłany plik awatara nie zawiera danych.',
	'AVATAR_INVALID_FILENAME'		=> '%s jest nieprawidłową nazwą pliku.',
	'AVATAR_NOT_UPLOADED'			=> 'Nie można wysłać awatara na serwer.',
	'AVATAR_NO_TEMP_DIR'			=> 'Folder tymczasowy nie został znaleziony lub jest niedostępny.',
	'AVATAR_NO_SIZE'				=> 'Nie można zidentyfikować wymiarów obrazka. Proszę wprowadzić je ręcznie.',
	'AVATAR_NO_UPLOAD_DIR'			=> 'Ścieżka do katalogu zapisu awatara nie istnieje lub jest niedostępna.',
	'AVATAR_NO_UPLOAD_PATH'			=> 'Wgrywanie awatarów jest włączone, ale ścieżka do katalogu nie została ustawiona.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Plik został wysłany częściowo.',
	'AVATAR_PHP_SIZE_NA'			=> 'Rozmiar pliku awatara jest za duży.<br />Nie można zidentyfikować maksymalnego rozmiaru pliku zdefiniowanego w ustawieniach witryny.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Rozmiar pliku awatara jest za duży. Maksymalny dozwolony rozmiar pliku to %1$d %2$s.<br />Wartość ta jest zdefiniowana w ustawieniach witryny i użytkownik nie może jej zmienić.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'		=> 'Nie można przesłać wybranego awatara, ponieważ upłynął czas żądania.',
	'AVATAR_PHP_UPLOAD_STOPPED'		=> 'Wysyłanie pliku zostało zatrzymane.',
	'AVATAR_URL_INVALID'			=> 'Nieprawidłowy adres URL awatara.',
	'AVATAR_URL_NOT_FOUND'			=> 'Nie znaleziono wybranego pliku.',
	'AVATAR_WRONG_FILESIZE'			=> 'Plik awatara musi mieć rozmiar mniejszy niż %1$d %2$s.',
	'AVATAR_WRONG_SIZE'				=> 'Wysłany awatar ma rozmiar %5$s x %6$s pikseli. Wymiary awatara nie mogą być mniejsze niż %1$s x %2$s i większe niż %3$s x %4$s pikseli.',

	'BACK_TO_TOP'			=> 'Na górę',
	'BACK_TO_PREV'			=> 'Wróć do poprzedniej strony',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Twój adres e-mail został zablokowany.',
	'BAN_TRIGGERED_BY_IP'	=> 'Twój adres IP został zablokowany.',
	'BAN_TRIGGERED_BY_USER'	=> 'Twoja nazwa użytkownika została zablokowana.',
	'BBCODE_GUIDE'			=> 'Przewodnik po BBCode',
	'BCC'					=> 'Ukryta kopia',
	'BIRTHDAYS'				=> 'Urodziny',
	'BOARD_BAN_PERM'		=> 'Masz <strong>całkowicie</strong> zabroniony dostęp do tej witryny.<br /><br />Aby uzyskać więcej informacji, proszę skontaktować się z %2$sadministratorem witryny%3$s.',
	'BOARD_BAN_REASON'		=> 'Powód zablokowania: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Na tej witrynie masz zabroniony dostęp do <strong>%1$s</strong>.<br /><br />Aby uzyskać więcej informacji, proszę skontaktować się z %2$sadministratorem witryny%3$s.',
	'BOARD_DISABLE'			=> 'Przepraszamy, ale ta witryna jest aktualnie niedostępna.',
	'BOARD_DISABLED'		=> 'Witryna jest wyłączona.',
	'BOARD_UNAVAILABLE'		=> 'Przepraszamy, ale witryna jest chwilowo niedostępna. Proszę spróbować ponownie za kilka minut.',
	'BROWSING_FORUM'		=> 'Użytkownicy przeglądający to forum: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Użytkownicy przeglądający to forum: %2$s i %1$d gość',
		2	=> 'Użytkownicy przeglądający to forum: %2$s i %1$d gości',
		3	=> 'Użytkownicy przeglądający to forum: %2$s i %1$d gości',
	),
	'BUTTON_DELETE'         => 'Usuń',
	'BUTTON_EDIT'			=> 'Edytuj',
	'BUTTON_FORUM_LOCKED'	=> 'Zablokowane',
	'BUTTON_INFORMATION'    => 'Informacje',
	'BUTTON_NEW_TOPIC'		=> 'NOWY TEMAT',
	'BUTTON_PM'				=> 'PW',
	'BUTTON_PM_FORWARD'		=> 'Przekaż',
	'BUTTON_PM_NEW'			=> 'Nowa PW',
	'BUTTON_PM_REPLY'		=> 'Odpowiedz',
	'BUTTON_PM_REPLY_ALL'	=> 'Odpowiedz wszystkim',
	'BUTTON_POST_REPLY'		=> 'ODPOWIEDZ',
	'BUTTON_QUOTE'			=> 'Cytuj',
	'BUTTON_REPORT'         => 'Zgłoś',
	'BUTTON_TOPIC_LOCKED'	=> 'Zablokowany',
	'BUTTON_WARN'           => 'Ostrzeż',
	'BYTES'					=> 'Bajtów',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'				=> 'Anuluj',
	'CHANGE'				=> 'Zmień',
	'CHANGE_FONT_SIZE'		=> 'Zmień rozmiar czcionki',
	'CHANGING_PREFERENCES'	=> 'Zmienia ustawienia witryny',
	'CHANGING_PROFILE'		=> 'Zmienia ustawienia profilu',
	'CHARACTERS'			=> array(
		1	=> '%d',
		2	=> '%d',
		3	=> '%d',
	),
	// Specjalna wersja do opisu zakresów  e.g. "min x znak i max y znaków"
	'CHARACTERS_XY'			=> array(
		1	=> '%d znak',
		2	=> '%d znaki',
		3	=> '%d znaków',
	),
	'COLLAPSE_VIEW'			=> 'Zwiń widok',
	'CLOSE_WINDOW'			=> 'Zamknij okno',
	'CODE'					=> 'Kod',
	'COLOUR_SWATCH'			=> 'Wybierz kolor',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Potwierdź',
	'CONFIRM_CODE'			=> 'Kod potwierdzający',
	'CONFIRM_CODE_EXPLAIN'	=> 'Wprowadź kod dokładnie tak, jak jest wyświetlony na obrazku. Wielkość znaków nie ma znaczenia.',
	'CONFIRM_CODE_WRONG'	=> 'Wprowadzony kod jest nieprawidłowy.',
	'CONFIRM_OPERATION'		=> 'Czy na pewno chcesz przeprowadzić tę operację?',
	'CONFIRM_AVATAR_DELETE' => 'Czy na pewno chcesz usunąć ten awatar?',
	'CONGRATULATIONS'		=> 'Wszystkiego najlepszego dla ',
	'CONNECTION_FAILED'		=> 'Nie połączono.',
	'CONNECTION_SUCCESS'	=> 'Połączono!',
	'CONTACT'				=> 'Kontakt',
	'CONTACT_USER'			=> 'Skontaktuj się z %s',
	'CONTACT_US'			=> 'Kontakt z nami',
	'COOKIE_CONSENT_INFO'	=> 'Dowiedz się więcej',
	'COOKIE_CONSENT_MSG'	=> 'Strona ta używa plików cookies (tzw. ciasteczka) w celach statystycznych, reklamowych oraz funkcjonalnych. Warunki przechowywania lub dostępu do plików cookies można określić w ustawieniach przeglądarki internetowej.',
	'COOKIE_CONSENT_OK'		=> 'Akceptuję!',
	'COOKIE_CONSENT_HREF'	=> 'http://wszystkoociasteczkach.pl/',
	'COOKIES_DELETED'		=> 'Usunięto wszystkie ciasteczka witryny.',
	'CURRENT_TIME'			=> 'Dzisiaj jest %s',

	'DAY'					=> 'Dzień',
	'DAYS'					=> 'dni',
	'DELETE'				=> 'Usuń',
	'DELETE_ALL'			=> 'Usuń wszystko',
	'DELETE_COOKIES'		=> 'Usuń ciasteczka witryny',
	'DELETE_MARKED'			=> 'Usuń zaznaczone',
	'DELETE_POST'			=> 'Usuń post',
	'DELIMITER'				=> 'Rozgranicznik',
	'DESCENDING'			=> 'Malejąco',
	'DISABLED'				=> 'Wyłączone',
	'DISPLAY'				=> 'Wyświetl',
	'DISPLAY_GUESTS'		=> 'Wyświetl gości',
	'DISPLAY_MESSAGES'		=> 'Wyświetl wiadomości nie starsze niż',
	'DISPLAY_POSTS'			=> 'Wyświetl posty nie starsze niż',
	'DISPLAY_TOPICS'		=> 'Wyświetl tematy nie starsze niż',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'Wprowadzona domena e-mail nie jest poprawna.',
	'DOWNLOADED'			=> 'Pobrane',
	'DOWNLOADING_FILE'		=> 'Pobieranie pliku',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'Nie pobierany',
		1	=> 'Pobrany %d raz',
		2	=> 'Pobrany %d razy',
		3	=> 'Pobrany %d razy',
	),

	'EDIT_POST'							=> 'Zmień treść posta',
	'ELLIPSIS'							=>	'…',
	'EMAIL'								=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Adres e-mail',
	'EMAIL_INVALID_EMAIL'				=> 'Wprowadzony adres e-mail jest nieprawidłowy.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Podczas wysyłania wiadomości napotkano problemy w <strong>wierszu %1$s</strong>. Odpowiedź: %2$s.',
	'EMPTY_SUBJECT'						=> 'Musi być określony tytuł tematu.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Przed wysłaniem wiadomości należy określić jej temat.',
	'ENABLED'							=> 'Włączone',
	'ENCLOSURE'							=> 'Załącznik',
	'ENTER_USERNAME'					=> 'Podaj nazwę użytkownika',
	'ERR_CHANGING_DIRECTORY'			=> 'Nie można zmienić katalogu.',
	'ERR_CONNECTING_SERVER'				=> 'Nie można połączyć się z serwerem.',
	'ERR_JAB_AUTH'						=> 'Nie można dokonać autoryzacji na serwerze Jabbera.',
	'ERR_JAB_CONNECT'					=> 'Nie można połączyć się z serwerem Jabbera.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Podana nazwa użytkownika lub hasło są nieprawidłowe.',
	'ERR_UNWATCHING'					=> 'Podczas rezygnowania z obserwacji wystąpił błąd.',
	'ERR_WATCHING'						=> 'Podczas ustanawiania obserwacji wystąpił błąd.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Podana ścieżka do phpBB jest nieprawidłowa.',
	'ERROR'									=> 'Błąd',
	'EXPAND_VIEW'						=> 'Rozwiń widok',
	'EXTENSION'							=> 'Rozszerzenie',
	'EXTENSION_DISABLED'				=> 'Rozszerzenie <strong>%s</strong> nie jest włączone.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Rozszerzenie <strong>%s</strong> zostało wyłączone i nie będzie dłużej wyświetlane.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'Nie ma rozszerzenia <strong>%s</strong>.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Często zadawane pytania',
	'FEATURE_NOT_AVAILABLE'		=> 'Żądana funkcjonalność nie jest dostępna na forum.',
	'FILENAME'				=> 'Nazwa',
	'FILESIZE'				=> 'Rozmiar',
	'FILEDATE'				=> 'Data',
	'FILE_COMMENT'			=> 'Komentarz',
	'FILE_CONTENT_ERR'		=> 'Nie można odczytać zawartości pliku: %s',
	'FILE_JSON_DECODE_ERR'	=> 'Nie udało się odkodować pliku JSON: %s',
	'FILE_NOT_FOUND'		=> 'Nie można odnaleźć żądanego pliku: %s',
	'FIND_USERNAME'			=> 'Znajdź użytkownika',
	'FOLDER'				=> 'Folder',
	'FORGOT_PASS'			=> 'Nie pamiętam hasła',
	'FORM_INVALID'			=> 'Wysyłany formularz był nieprawidłowy. Proszę spróbować ponownie.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Fora',
	'FORUMS_MARKED'			=> 'Fora zostały oznaczone jako przeczytane.',
	'FORUM_CAT'				=> 'Kategoria',
	'FORUM_INDEX'			=> 'Strona główna',
	'FORUM_LINK'			=> 'Odnośnik',
	'FORUM_LOCATION'		=> 'Lokalizacja',
	'FORUM_LOCKED'			=> 'Forum zablokowane',
	'FORUM_RULES'			=> 'Regulamin forum',
	'FORUM_RULES_LINK'		=> 'Kliknij, aby zapoznać się z regulaminem',
	'FROM'					=> 'z',
	'FSOCK_DISABLED'		=> 'Operacja nie mogła zostać zakończona, ponieważ funkcja <var>fsockopen</var> została wyłączona albo nie znaleziono szukanego serwera.',
	'FSOCK_TIMEOUT'			=> 'Przekroczono limit czasu.',
		
	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'	=> 'Nie można zmienić pliku grupy',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS'	=> 'Nie można zmienić uprawnień pliku',
	'FILESYSTEM_CANNOT_COPY_FILES'		=> 'Nie można skopiować plików',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'	=> 'Nie można utworzyć symlinku',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'	=> 'Nie można utworzyć katalogu',
	'FILESYSTEM_CANNOT_DELETE_FILES'	=> 'Nie można usunąć plików w systemie',
	'FILESYSTEM_CANNOT_DUMP_FILE'		=> 'Nie można zrzucić do pliku',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'	=> 'Nie można skopiować folderu',
	'FILESYSTEM_CANNOT_RENAME_FILE'	=> 'Nie można zmienić nazwy pliku w systemie',
	'FILESYSTEM_CANNOT_TOUCH_FILES'	=> 'Nie można stworzyć pliku lub zmienić znacznik czasu',	

	'FTP_FSOCK_HOST'				=> 'Serwer FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Serwer FTP używany do łączenia się z twoją witryną.',
	'FTP_FSOCK_PASSWORD'			=> 'Hasło',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Hasło do twojego konta FTP.',
	'FTP_FSOCK_PORT'				=> 'Port',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Port używany do połączenia z serwerem FTP.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Ścieżka do phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Ścieżka do katalogu twojej witryny phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'Czas oczekiwania',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Czas, w sekundach, przez jaki system będzie oczekiwał na odpowiedź serwera.',
	'FTP_FSOCK_USERNAME'			=> 'Nazwa użytkownika',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Nazwa użytkownika używana do połączenia z serwerem FTP.',

	'FTP_HOST'					=> 'Serwer',
	'FTP_HOST_EXPLAIN'			=> 'Serwer FTP używany do łączenia się z twoją witryną.',
	'FTP_PASSWORD'				=> 'Hasło',
	'FTP_PASSWORD_EXPLAIN'		=> 'Hasło do twojego konta FTP.',
	'FTP_PORT'					=> 'Port',
	'FTP_PORT_EXPLAIN'			=> 'Port używany do połączenia z serwerem FTP.',
	'FTP_ROOT_PATH'				=> 'Ścieżka do phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Ścieżka do katalogu twojej witryny phpBB.',
	'FTP_TIMEOUT'				=> 'Czas oczekiwania',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Czas, w sekundach, przez jaki system będzie oczekiwał na odpowiedź serwera.',
	'FTP_USERNAME'				=> 'Nazwa użytkownika',
	'FTP_USERNAME_EXPLAIN'		=> 'Nazwa użytkownika używana do połączenia z serwerem FTP.',

	'GENERAL_ERROR'				=> 'Błąd ogólny',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Wykonaj',
	'GOTO_FIRST_POST'			=> 'Przejdź do pierwszego posta',
	'GOTO_LAST_POST'			=> 'Przejdź do ostatniego posta',
	'GOTO_PAGE'					=> 'Przejdź na stronę',
	'GROUP'						=> 'Grupa',
	'GROUPS'					=> 'Grupy',
	'GROUP_ERR_TYPE'			=> 'Podano niewłaściwy typ grupy.',
	'GROUP_ERR_USERNAME'		=> 'Nie określono nazwy grupy.',
	'GROUP_ERR_USER_LONG'		=> 'Nazwa grupy jest za długa. Można użyć maksymalnie 60 znaków.',
	'GUEST'						=> 'Gość',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'Online jest %d gość',
		2	=> 'Online jest %d gości',
		3	=> 'Online jest %d gości',
	),
	'GUEST_USERS_TOTAL'			=> array(
		1	=> '%d gość',
		2	=> '%d gości',
		3	=> '%d gości',
	),
	'G_ADMINISTRATORS'			=> 'Administratorzy',
	'G_BOTS'					=> 'Boty',
	'G_GUESTS'					=> 'Goście',
	'G_REGISTERED'				=> 'Zarejestrowani użytkownicy',
	'G_REGISTERED_COPPA'		=> 'Zarejestrowani użytkownicy (COPPA)',
	'G_GLOBAL_MODERATORS'		=> 'Moderatorzy globalni',
	'G_NEWLY_REGISTERED'		=> 'Nowo zarejestrowani użytkownicy',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d ukryty użytkownik',
		2	=> '%d ukrytych użytkowników',
		3	=> '%d ukrytych użytkowników',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d ukryty',
		2	=> '%d ukrytych',
		3	=> '%d ukrytych',
	),
	'HIDE_GUESTS'					=> 'Ukryj gości',
	'HIDE_ME'						=> 'Ukryj mój status podczas tej sesji',
	'HOURS'							=> 'godz.',
	'HOME'							=> 'Strona domowa',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'Jeśli',
	'IMAGE'						=> 'Obrazek',
	'IMAGE_FILETYPE_INVALID'	=> 'Typ pliku obrazka – %d – nie jest prawidłowy dla typu MIME %s.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Niezgodność typów obrazków: oczekiwano rozszerzenia %1$s, otrzymano %2$s.',
	'IN'						=> 'w',
	'INACTIVE'					=> 'Nieaktywny',
	'INDEX'						=> 'Wykaz forów',
	'INFORMATION'				=> 'Informacje',
	'INSECURE_REDIRECT'			=> 'Próbowano przekierować do potencjalnie niebezpiecznego adresu.',
	'INTERESTS'					=> 'Zainteresowania',
	'INVALID_DIGEST_CHALLENGE'	=> 'Błędna próba uporządkowania MD5.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> możliwe, że jest to nieprawidłowy adres e-mail?',
	'INVALID_FEED_ATTACHMENTS'	=> 'Wybrany kanał informacyjny próbował pobrać załączniki z nieprawidłowymi ograniczeniami.',
	'INVALID_PLURAL_RULE'		=> 'Wybrana reguła liczby mnogiej jest nieprawidłowa. Prawidłowe wartości zawierają się w przedziale 0 - 15.',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Twój adres IP (%1$s) został zablokowany, ponieważ jest na liście niedozwolonych adresów. <a href="%2$s">Szczegóły</a>',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Rejestracja',
	'JUMP_PAGE'				=> 'Wprowadź numer strony, do której chcesz przejść',
	'JUMP_TO'				=> 'Przejdź do',
	'JUMP_TO_PAGE'			=> 'Przejdź do strony',
	'JUMP_TO_PAGE_CLICK'			=> 'Kliknij, aby przejść do strony…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Ostatni post',
	'LAST_UPDATED'						=> 'Ostatnio aktualizowano',
	'LAST_VISIT'						=> 'Ostatnia wizyta',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Rozszerzenie LDAP jest niedostępne.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Nie można połączyć się z serwerem LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Wystąpił błąd podczas przeszukiwania katalogu LDAP.',
	'LEGEND'							=> 'Legenda – kolory grup',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'Wyszukiwanie dynamiczne jest niedozwolone.',
	'LOADING'							=> 'Wczytywanie',
	'LOCATION'							=> 'Lokalizacja',
	'LOCK_POST'							=> 'Zamknij post',
	'LOCK_POST_EXPLAIN'					=> 'Zablokuj możliwość zmian posta',
	'LOCK_TOPIC'						=> 'Zamknij temat',
	'LOGIN'								=> 'Zaloguj się',
	'LOGIN_CHECK_PM'					=> 'Zaloguj się, by sprawdzić prywatne wiadomości.',
	'LOGIN_CONFIRMATION'				=> 'Potwierdzenie logowania',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Aby zapobiec włamaniom do kont użytkowników, witryna po przekroczeniu dozwolonej liczby prób logowania wymaga wprowadzenia kodu potwierdzającego. Kod jest wyświetlony na znajdującym się poniżej obrazku. Jeśli z jakichś przyczyn nie możesz odczytać poniższego kodu, skontaktuj się z %sadministratorem%s witryny.',
	'LOGIN_ERROR_ATTEMPTS'				=> 'Przekroczono limit prób logowania. Teraz, aby się zalogować, musisz oprócz nazwy użytkownika i hasła dodatkowo rozwiązać test reCAPTCHA.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Serwer Apache odmówił autoryzacji.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'Zażądano nieistniejącej usługi OAuth.',
	'LOGIN_ERROR_PASSWORD'				=> 'Podano nieprawidłowe hasło. Sprawdź je i spróbuj ponownie. Jeśli problem będzie nadal występował, skontaktuj się z %sadministratorem%s witryny.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Nie można było dokonać konwersji hasła w czasie aktualizacji skryptu witryny. %sPoproś o nowe hasło%s. Jeśli nadal będą występowały problemy, skontaktuj się z %sadministratorem%s witryny.',
	'LOGIN_ERROR_USERNAME'				=> 'Podano nieprawidłową nazwę użytkownika. Sprawdź ją i spróbuj ponownie. Jeśli problem nadal będzie się powtarzał, skontaktuj się z %sadministratorem%s witryny.',
	'LOGIN_FORUM'						=> 'Aby przeglądać lub pisać posty na tym forum trzeba podać hasło forum.',
	'LOGIN_INFO'						=> 'Aby zalogować się, musisz być zarejestrowanym użytkownikiem witryny. Rejestracja zajmuje tylko chwilę, a znacznie zwiększa możliwości korzystania z witryny. Administrator witryny może zarejestrowanym użytkownikom nadać wiele dodatkowych uprawnień. Przed rejestracją zapoznaj się z naszym regulaminem, zasadami ochrony danych osobowych oraz z odpowiedziami na często zadawane pytania (FAQ), gdzie jest wyjaśnionych wiele podstawowych zagadnień dotyczących funkcjonowania witryny.',
	'LOGIN_VIEWFORUM'					=> 'Aby przeglądać to forum, trzeba być zarejestrowanym i zalogowanym użytkownikiem.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Aby dokonywać zmian w postach na tym forum, trzeba być zarejestrowanym i zalogowanym użytkownikiem.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Aby sprawdzać kto przegląda forum, trzeba być zarejestrowanym i zalogowanym użytkownikiem.',
	'LOGIN_REQUIRED'					=> 'Aby wykonać tę czynność, trzeba się zalogować.',
	'LOGOUT'							=> 'Wyloguj',
	'LOGOUT_USER'						=> 'Wyloguj [ %s ]',
	'LOG_ME_IN'							=> 'Zapamiętaj mnie',

	'MAIN'					=> 'Główne',
	'MARK'					=> 'Zaznacz',
	'MARK_ALL'				=> 'Zaznacz wszystkie',
	'MARK_ALL_READ'			=> 'Oznacz wszystkie jako przeczytane',
	'MARK_FORUMS_READ'		=> 'Oznacz fora jako przeczytane',
	'MARK_READ'				=> 'Oznacz jako przeczytane',
	'MARK_SUBFORUMS_READ'	=> 'Oznacz jako przeczytane',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Panel moderacji',
	'MCP_SHORT'				=> 'Moderacja',
	'MEMBERLIST'			=> 'Użytkownicy',
	'MEMBERLIST_EXPLAIN'	=> 'Wyświetl pełną listę użytkowników',
	'MERGE'					=> 'Połącz',
	'MERGE_POSTS'			=> 'Przenieś posty',
	'MERGE_TOPIC'			=> 'Połącz tematy',
	'MESSAGE'				=> 'Wiadomość',
	'MESSAGES'				=> 'Wiadomości',
	'MESSAGES_COUNT'		=> array(
		0	=> 'nielimitowane wiadomości',
		1	=> '%d wiadomość',
		2	=> '%d wiadomości',
		3	=> '%d wiadomości',
	),
	'MESSAGE_BODY'			=> 'Treść wiadomości',
	'MINUTES'				=> 'min',
	'MODERATE'				=> 'Moderuj',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderatorzy',
	'MODULE_NOT_ACCESS'		=> 'Moduł jest niedostępny',
	'MODULE_NOT_FIND'		=> 'Nie można znaleźć modułu %s',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Plik modułu %s nie zawiera prawidłowej klasy [%s]',
	'MONTH'					=> 'Miesiąc',
	'MOVE'					=> 'Przenieś',

	'NA'						=> 'N/D',
	'NEWEST_USER'				=> 'Ostatnio zarejestrowany użytkownik: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Nowa wiadomość',
	'NEW_MESSAGES'				=> 'Nowe wiadomości',
	'NEW_POST'					=> 'Nowy post',
	'NEW_POSTS'					=> 'Nowe posty',
	'NEXT'						=> 'Następna',
	'NEXT_STEP'					=> 'Dalej',
	'NEVER'						=> 'Nigdy',
	'NO'						=> 'Nie',
	'NO_NOTIFICATIONS'			=> 'Nie masz powiadomień',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Nie masz uprawnień do zarządzania tą grupą.',
	'NOT_AUTHORISED'			=> 'Nie masz dostępu do tej części witryny.',
	'NOT_WATCHING_FORUM'		=> 'Nie obserwujesz już tego forum.',
	'NOT_WATCHING_TOPIC'		=> 'Nie obserwujesz już tego tematu.',
	'NOTIFICATIONS'				=> 'Powiadomienia',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Odpowiedź</strong> od %1$s w zaznaczonym temacie:',
	),
	'NOTIFICATION_FORUM'				=> '<em>Forum:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> 'Użytkownik %1$s <strong>poprosił o przyłączenie do grupy</strong> %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>Prośba o przyłączenie do grupy</strong> %1$s została zaakceptowana.',
	'NOTIFICATION_METHOD_INVALID'		=> 'Metoda "%s" nie odnosi się do poprawnego typu powiadomień na forum.',
	'NOTIFICATION_PM'					=> '<strong>Prywatna wiadomość</strong> od %1$s:',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Odpowiedź</strong> od %1$s w temacie:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Zaakceptowano</strong> post:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Został odrzucony</strong> post:',
	'NOTIFICATION_POST_IN_QUEUE'		=> 'Użytkownik %1$s <strong>poprosił o akceptację</strong> posta:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Zacytowano cię</strong> przez %1$s w:',
	),
	'NOTIFICATION_REFERENCE'			=> '„%1$s”',
	'NOTIFICATION_REASON'				=> '<em>Powód:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> 'Użytkownik %1$s zgłosił <strong>prywatną wiadomość</strong>:',
	'NOTIFICATION_REPORT_PM_CLOSED'		=> '<strong>Zgłoszenie prywatnej wiadomości zostało zamknięte</strong> przez %1$s:',
	'NOTIFICATION_REPORT_POST'			=> 'Użytkownik %1$s zgłosił <strong>post</strong>:',
	'NOTIFICATION_REPORT_CLOSED'		=> '%1$s <strong>zamknął zgłoszenie</strong> z powodu:',
	'NOTIFICATION_TOPIC'				=> 'Użytkownik %1$s założył <strong>nowy temat</strong>:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Zaakceptowano</strong> temat:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Nie zaakceptowano</strong> tematu:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> 'Użytkownik %1$s <strong>poprosił o akceptację</strong> tematu:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'W katalogu witryny brakuje powiadomienia typu „%s”.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Wymagana aktywacja</strong> dla nowo zarejestrowanego lub zdeaktywowanego użytkownika „%1$s”',
	// Used in conjuction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'inni',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d innych',
	),
	'NOTIFY_ADMIN'				=> 'Poinformuj administratora witryny lub webmastera.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Poinformuj administratora witryny lub webmastera: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Nie masz dostępu do tego pliku.',
	'NO_ACTION'					=> 'Nie wybrano czynności.',
	'NO_ADMINISTRATORS'			=> 'Ta witryna nie ma administratorów.',
	'NO_AUTH_ADMIN'				=> 'Nie masz uprawnień administratora, więc nie masz dostępu do panelu administracji.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Nie możesz ponownie zweryfikować się jako inny użytkownik.',
	'NO_AUTH_OPERATION'			=> 'Nie masz odpowiednich uprawnień, by kontynuować tę operację.',
	'NO_AVATARS'				=> 'Obecnie nie ma dostępnych awatarów',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Nie można połączyć się z serwerem SMTP : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Nikt dzisiaj nie obchodzi urodzin',
	'NO_EMAIL_MESSAGE'			=> 'Nie wpisano treści wiadomości.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Nie można otrzymać kodów odpowiedzi serwera.',
	'NO_EMAIL_SUBJECT'			=> 'Nie wpisano tematu wiadomości.',
	'NO_FORUM'					=> 'Wybrane forum nie istnieje.',
	'NO_FORUMS'					=> 'Na tej witrynie nie ma forów.',
	'NO_GROUP'					=> 'Wybrana grupa nie istnieje.',
	'NO_GROUP_MEMBERS'			=> 'Ta grupa nie ma jeszcze członków.',
	'NO_IPS_DEFINED'			=> 'Nie zdefiniowano żadnych adresów IP ani nazw serwerów.',
	'NO_MEMBERS'				=> 'Nie znaleziono użytkowników spełniających kryteria.',
	'NO_MESSAGES'				=> 'Brak wiadomości',
	'NO_MODE'					=> 'Nie wybrano trybu.',
	'NO_MODERATORS'				=> 'Ta witryna nie ma moderatorów.',
	'NO_NEW_MESSAGES'			=> 'Nie ma nowych wiadomości',
	'NO_NEW_POSTS'				=> 'Nie ma nowych postów',
	'NO_ONLINE_USERS'			=> 'Obecnie na forum nie ma żadnego zarejestrowanego użytkownika',
	'NO_POSTS'					=> 'Nie ma postów',
	'NO_POSTS_TIME_FRAME'		=> 'W tym temacie, w wybranym przedziale czasowym, nie ma żadnego posta.',
	'NO_FEED_ENABLED'			=> 'Kanały nie są dostępne na tej witrynie.',
	'NO_FEED'					=> 'Żądany kanał jest niedostępny.',
	'NO_STYLE_DATA'				=> 'Nie udało się uzyskać danych stylu %s dla użytkownika o ID = %s',
	'NO_STYLE_CFG'				=> 'Nie udało się uzyskać pliku konfiguracyjnego dla stylu: %s',
	'NO_SUBJECT'				=> 'Nie podano tytułu.',
	'NO_SUCH_SEARCH_MODULE'		=> 'Wybrany moduł wyszukiwania nie istnieje.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Nie istnieje żadna wspierana metoda uwierzytelniania.',
	'NO_TOPIC'					=> 'Żądany temat nie istnieje.',
	'NO_TOPIC_FORUM'			=> 'Temat lub forum już nie istnieje.',
	'NO_TOPICS'					=> 'Na tym forum nie ma żadnych tematów ani postów.',
	'NO_TOPICS_TIME_FRAME'		=> 'Na tym forum, w wybranym przedziale czasowym, nie ma żadnego tematu.',
	'NO_UNREAD_POSTS'			=> 'Nie ma nieprzeczytanych postów',
	'NO_UPLOAD_FORM_FOUND'		=> 'Wysyłanie zostało zainicjowane, ale nie znaleziono żadnego prawidłowego formularza wysyłania plików.',
	'NO_USER'					=> 'Żądany użytkownik nie istnieje.',
	'NO_USERS'					=> 'Żądani użytkownicy nie istnieją.',
	'NO_USER_SPECIFIED'			=> 'Nie podano nazwy użytkownika',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d załącznik',
		2	=> '%d załączniki',
		3	=> '%d załączników',
	),
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Nie ma postów w kolejce',		// 0
		1			=> 'W kolejce znajduje się 1 post',		// 1
		2			=> 'W kolejce znajdują się %d posty',		// 2-4
		3			=> 'W kolejce znajduje się %d postów',
	),

	'OCCUPATION'				=> 'Zawód',
	'OFFLINE'					=> 'Offline',
	'ONLINE'					=> 'Online',
	'ONLINE_BUDDIES'			=> 'Przyjaciele w trybie online',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'Jest <strong>%1$d</strong> użytkownik online :: %2$s i %3$s',
		2	=> 'Jest <strong>%1$d</strong> użytkowników online :: %2$s i %3$s',
		3	=> 'Jest <strong>%1$d</strong> użytkowników online :: %2$s i %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'Jest <strong>%1$d</strong> użytkownik online :: %2$s, %3$s i %4$s',
		2	=> 'Jest <strong>%1$d</strong> użytkowników online :: %2$s, %3$s i %4$s',
		3	=> 'Jest <strong>%1$d</strong> użytkowników online :: %2$s, %3$s i %4$s',
	),
	'OPTIONS'					=> 'Opcje',

	'PAGE_NOT_FOUND'		=> 'Nie znaleziono żądanej strony.',
	'PAGE_OF'				=> 'Strona <strong>%1$d</strong> z <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Strona %s',
	'PASSWORD'				=> 'Hasło',
	'PIXEL'					=> 'px',
	'PIXELS'				=> array(
		1	=> '%d piksel',
		2	=> '%d piksele',
		3	=> '%d pikseli',
	),
	'PLEASE_WAIT'			=> 'Proszę czekać.',
	'PM'					=> 'PW',
	'PM_REPORTED'			=> 'Kliknij, by zobaczyć zgłoszenie',
	'POSTING_MESSAGE'		=> 'Pisze wiadomość w %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Pisze prywatną wiadomość',
	'POST'					=> 'Post',
	'POST_ANNOUNCEMENT'		=> 'Ogłoszenie',
	'POST_STICKY'			=> 'Przyklejony',
	'POSTED'				=> '',
	'POSTED_IN_FORUM'		=> 'na forum',
	'POSTED_ON_DATE'		=> 'dodano:',
	'POSTS'					=> 'Posty',
	'POSTS_UNAPPROVED'		=> 'Co najmniej jeden post w tym temacie nie został zaakceptowany.',
	'POSTS_UNAPPROVED_FORUM'=> 'Co najmniej jeden post na tym forum nie został zaakceptowany.',
	'POST_BY_AUTHOR'		=> 'autor:',
	'POST_BY_FOE'			=> 'Ten post został napisany przez ignorowanego użytkownika – <strong>%1$s</strong>.',
	'POST_DISPLAY'			=> 'Wyświetlaj ten post.',
	'POST_DAY'				=> 'średnio dziennie: %.2f',
	'POST_DELETED_ACTION'	=> 'Usunięty post:',
	'POST_DELETED'			=> 'Ten post został usunięty.',
	'POST_DELETED_BY'		=> '<strong>%2$s</strong> usunął post autorstwa <strong>%1$s</strong> o %3$s.',
	'POST_DELETED_BY_REASON'=> '<strong>%2$s</strong> usunął post autorstwa <strong>%1$s</strong> o %3$s z następującego powodu: %4$s',
	'POST_DETAILS'			=> 'Szczegóły posta',
	'POST_NEW_TOPIC'		=> 'Nowy temat',
	'POST_PCT'				=> '%.2f%% wszystkich postów',
	'POST_PCT_ACTIVE'		=> '%.2f%% wszystkich postów użytkownika',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% wszystkich postów użytkownika',
	'POST_REPLY'			=> 'Odpowiedz',
	'POST_REPORTED'			=> 'Kliknij, by zobaczyć zgłoszenie.',
	'POST_SUBJECT'			=> 'Tytuł',
	'POST_TIME'				=> 'Data',
	'POST_TOPIC'			=> 'Nowy temat',
	'POST_UNAPPROVED_ACTION'	=> 'Post oczekujący na akceptację:',
	'POST_UNAPPROVED'		=> 'Ten post nie został zaakceptowany.',
	'POST_UNAPPROVED_EXPLAIN'	=> 'Ten post nie jest widoczny dla innych użytkowników, do czasu aż zostanie zaakceptowany przez moderatora.',
	'POWERED_BY'			=> 'Technologię dostarcza %s',
		
	'QUOTE'					=> 'Cytuj',
	
	'PREVIEW'				=> 'Podgląd',
	'PREVIOUS'				=> 'Poprzednia',
	'PREVIOUS_STEP'			=> 'Wstecz',
	'PRIVACY'				=> 'Zasady ochrony danych osobowych',
	'PRIVACY_LINK'			=> 'Zasady ochrony danych osobowych',
	'PRIVATE_MESSAGE'		=> 'Prywatna wiadomość',
	'PRIVATE_MESSAGES'		=> 'Prywatne wiadomości',
	'PRIVATE_MESSAGING'		=> 'Prywatne wiadomości',
	'PROFILE'				=> 'Twoje konto',

	'QUICK_LINKS'			=> 'Więcej…',

	'RANK'						=> 'Ranga',
	'READING_FORUM'				=> 'Przegląda tematy na forum %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Czyta ogłoszenie globalne',
	'READING_LINK'				=> 'Przechodzi do forum %s',
	'READING_TOPIC'				=> 'Czyta temat na forum %s',
	'READ_PROFILE'				=> 'Wyświetl profil',
	'REASON'					=> 'Powód',
	'RECORD_ONLINE_USERS'		=> 'Najwięcej użytkowników (<strong>%1$s</strong>) było online %2$s',
	'REDIRECT'					=> 'Przekierowanie',
	'REDIRECTS'					=> 'Liczba zrealizowanych przekierowań',
	'REGISTER'					=> 'Zarejestruj się',
	'REGISTERED_USERS'			=> 'Zarejestrowani użytkownicy:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'Online jest %1$d zarejestrowany użytkownik i %2$s',
		2	=> 'Online jest %1$d zarejestrowanych użytkowników i %2$s',
		3	=> 'Online jest %1$d zarejestrowanych użytkowników i %2$s',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d zarejestrowany',
		2	=> '%d zarejestrowanych',
		3	=> '%d zarejestrowanych',
	),
	'REMOVE'					=> 'Usuń',
	'REMOVE_INSTALL'			=> 'Przed rozpoczęciem korzystania z witryny, należy z katalogu głównego witryny usunąć, przenieść lub zmienić nazwę katalogu instalacyjnego „install/”). Jeśli to nie zostanie wykonane, będzie działał tylko panel administracji.',
	'REPLIES'					=> 'Odpowiedzi',
	'REPLY_WITH_QUOTE'			=> 'Odpowiedz z cytatem',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Odpowiada na ogłoszenie globalne',
	'REPLYING_MESSAGE'			=> 'Odpowiada na wiadomość w %s',
	'REPORT_BY'					=> 'Zgłoszone przez',
	'REPORT_POST'				=> 'Zgłoś ten post',
	'REPORTING_POST'			=> 'Zgłasza post',
	'RESEND_ACTIVATION'			=> 'Wyślij ponownie e-mail aktywacyjny',
	'RESET'						=> 'Wyczyść',
	'RESTORE_PERMISSIONS'		=> 'Przywróć uprawnienia',
	'RETURN_INDEX'				=> '%sWróć do wykazu forów%s',
	'RETURN_FORUM'				=> '%sWróć do ostatnio odwiedzonego forum%s',
	'RETURN_PAGE'				=> '%sWróć do poprzedniej strony%s',
	'RETURN_TOPIC'				=> '%sWróć do ostatnio przeglądanego tematu%s',
	'RETURN_TO'					=> 'Wróć do „%s”',
	'RETURN_TO_INDEX'			=> 'Wróć do wykazu forów',
	
	'ROUTE_NOT_FOUND'				=> 'Nie udało się znaleźć żądanej trasy "%s".',
	'ROUTE_INVALID_MISSING_PARAMS'	=> 'Przekazano niewłaściwe lub brakujące parametry trasy“%s”.',
	
	'FEED'						=> 'Kanał',
	'FEED_NEWS'					=> 'Wiadomości',
	'FEED_TOPICS_ACTIVE'		=> 'Aktywne tematy',
	'FEED_TOPICS_NEW'			=> 'Nowe tematy',
	'RULES_ATTACH_CAN'			=> '<strong>Możesz</strong> dodawać załączniki',
	'RULES_ATTACH_CANNOT'		=> '<strong>Nie możesz</strong> dodawać załączników',
	'RULES_DELETE_CAN'			=> '<strong>Możesz</strong> usuwać swoje posty',
	'RULES_DELETE_CANNOT'		=> '<strong>Nie możesz</strong> usuwać swoich postów',
	'RULES_DOWNLOAD_CAN'		=> '<strong>Możesz</strong> pobierać załączniki',
	'RULES_DOWNLOAD_CANNOT'		=> '<strong>Nie możesz</strong> pobierać załączników',
	'RULES_EDIT_CAN'			=> '<strong>Możesz</strong> zmieniać swoje posty',
	'RULES_EDIT_CANNOT'			=> '<strong>Nie możesz</strong> zmieniać swoich postów',
	'RULES_LOCK_CAN'			=> '<strong>Możesz</strong> zamykać swoje tematy',
	'RULES_LOCK_CANNOT'			=> '<strong>Nie możesz</strong> zamykać swoich tematów',
	'RULES_POST_CAN'			=> '<strong>Możesz</strong> tworzyć nowe tematy',
	'RULES_POST_CANNOT'			=> '<strong>Nie możesz</strong> tworzyć nowych tematów',
	'RULES_REPLY_CAN'			=> '<strong>Możesz</strong> odpowiadać w tematach',
	'RULES_REPLY_CANNOT'		=> '<strong>Nie możesz</strong> odpowiadać w tematach',
	'RULES_VOTE_CAN'			=> '<strong>Możesz</strong> głosować w ankietach',
	'RULES_VOTE_CANNOT'			=> '<strong>Nie możesz</strong> głosować w ankietach',

	'SEARCH'					=> 'Szukaj',
	'SEARCH_MINI'				=> 'Szukaj…',
	'SEARCH_ADV'				=> 'Wyszukiwanie zaawansowane',
	'SEARCH_ADV_EXPLAIN'		=> 'Wyświetla zaawansowane funkcje wyszukiwania',
	'SEARCH_KEYWORDS'			=> 'Szukaj wg słów kluczowych',
	'SEARCHING_FORUMS'			=> 'Przeszukiwanie forów',
	'SEARCH_ACTIVE_TOPICS'		=> 'Aktywne tematy',
	'SEARCH_FOR'				=> 'Szukaj',
	'SEARCH_FORUM'				=> 'Przeszukaj forum…',
	'SEARCH_NEW'				=> 'Nowe posty',
	'SEARCH_POSTS_BY'			=> 'Szukaj postów napisanych przez',
	'SEARCH_SELF'				=> 'Twoje posty',
	'SEARCH_TOPIC'				=> 'Przeszukaj ten temat…',
	'SEARCH_UNANSWERED'			=> 'Tematy bez odpowiedzi',
	'SEARCH_UNREAD'				=> 'Nieprzeczytane posty',
	'SEARCH_USER_POSTS'			=> 'Posty użytkownika',
	'SECONDS'					=> 's',
	'SEE_ALL'					=> 'Zobacz wszystkie',
	'SELECT'					=> 'Wybierz',
	'SELECT_ALL_CODE'			=> 'Zaznacz cały',
	'SELECT_DESTINATION_FORUM'	=> 'Wybierz docelowe forum',
	'SELECT_FORUM'				=> 'Wybierz forum',
	'SEND_EMAIL'				=> 'Wyślij e-mail',	// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Wyślij e-mail do %s',	// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Wyślij prywatną wiadomość',
	'SETTINGS'					=> 'Ustawienia',
	'SIGNATURE'					=> 'Podpis',
	'SKIP'						=> 'Przejdź do zawartości',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Serwer SMTP nie obsługuje uwierzytelniania.',
	'SORRY_AUTH_READ'		=> 'Nie masz uprawnień, aby przeglądać to forum.',
	'SORRY_AUTH_READ_TOPIC'		=> 'Nie masz uprawnień, aby przeglądać ten temat.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Nie masz uprawnień, aby pobrać ten załącznik.',
	'SORT_BY'					=> 'Sortuj wg',
	'SORT_DIRECTION'			=> 'Kierunek',
	'SORT_JOINED'				=> 'Data rejestracji',
	'SORT_LOCATION'				=> 'Lokalizacja',
	'SORT_OPTIONS'				=> 'Wyświetl opcje sortowania',
	'SORT_RANK'					=> 'Ranga',
	'SORT_POSTS'				=> 'Posty',
	'SORT_TOPIC_TITLE'			=> 'Tytuł tematu',
	'SORT_USERNAME'				=> 'Nazwa użytkownika',
	'SPLIT_TOPIC'				=> 'Podziel temat',
	'SQL_ERROR_OCCURRED'		=> 'Podczas pobierania tej strony wystąpił błąd bazy danych. Jeśli problem będzie się powtarzał, skontaktuj się z %sadministratorem%s witryny.',
	'STATISTICS'				=> 'Statystyki',
	'START_WATCHING_FORUM'		=> 'Obserwuj forum',
	'START_WATCHING_TOPIC'		=> 'Obserwuj temat',
	'STOP_WATCHING_FORUM'		=> 'Zaprzestań obserwacji forum',
	'STOP_WATCHING_TOPIC'		=> 'Zaprzestań obserwacji tematu',
	'STRING_LIST_MULTI'			=> '%1$s, i %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s i %2$s',
	'SUBFORUM'					=> 'Subforum',
	'SUBFORUMS'					=> 'Subfora',
	'SUBJECT'					=> 'Tytuł',
	'SUBMIT'					=> 'Wyślij',

	'TB'				=> 'TB',
	'TERMS_LINK'		=> 'Regulamin',
	'TERMS_USE'			=> 'Regulamin',
	'TEST_CONNECTION'	=> 'Testuj połączenie',
	'THE_TEAM'			=> 'Zespół administracyjny',
	'TIB'				=> 'TiB',
	'TIME'				=> 'Czas',
	'TIMEOUT_PROCESSING_REQ'			=> 'Upłynął limit czasu żądania.',

	'TOO_LARGE'						=> 'Podana wartość jest za duża.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'Podana wartość dla ustawienia <strong>Dozwolona maksymalna liczba odbiorców jednej prywatnej wiadomości</strong> jest za duża.',

	'TOO_LONG'						=> 'Podana wartość jest za długa.',

	'TOO_LONG_CONFIRM_CODE'			=> 'Kod potwierdzający jest za długi.',
	'TOO_LONG_DATEFORMAT'			=> 'Format daty jest za długi.',
	'TOO_LONG_JABBER'				=> 'Nazwa konta Jabber jest za długa.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Hasło jest za długie.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Potwierdzenie hasła jest za długie.',
	'TOO_LONG_USER_PASSWORD'		=> 'Hasło jest za długie.',
	'TOO_LONG_USERNAME'				=> 'Nazwa użytkownika jest za długa.',
	'TOO_LONG_EMAIL'				=> 'Adres e-mail jest za długi.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Wykonano próbę głosowania na zbyt dużo opcji.',

	'TOO_SHORT'						=> 'Wartość jest za krótka.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'Kod potwierdzający jest za krótki.',
	'TOO_SHORT_DATEFORMAT'			=> 'Format daty jest za krótki.',
	'TOO_SHORT_JABBER'				=> 'Nazwa konta Jabber jest za krótka.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Hasło jest za krótkie.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Potwierdzone hasło jest inne.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Hasło jest za krótkie.',
	'TOO_SHORT_USERNAME'			=> 'Nazwa użytkownika jest za krótka.',
	'TOO_SHORT_EMAIL'				=> 'Adres e-mail jest za krótki.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Potwierdzony adresu e-mail jest inny.',
	'TOO_SMALL'						=> 'Podana wartość jest za mała.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Podana wartość dla ustawienia <strong>Dozwolona maksymalna liczba odbiorców jednej prywatnej wiadomości</strong> jest za mała.',

	'TOPIC'				=> 'Temat',
	'TOPICS'			=> 'Tematy',
	'TOPICS_UNAPPROVED'	=> 'Co najmniej jeden temat nie został zaakceptowany na tym forum.',
	'TOPIC_ICON'		=> 'Ikona tematu',
	'TOPIC_LOCKED'		=> 'Ten temat jest zamknięty. Nie można w nim pisać ani edytować postów.',
	'TOPIC_LOCKED_SHORT'=> 'Temat zamknięty',
	'TOPIC_MOVED'		=> 'Temat przeniesiony',
	'TOPIC_REVIEW'		=> 'Przegląd tematu',
	'TOPIC_TITLE'		=> 'Tytuł tematu',
	'TOPIC_UNAPPROVED'	=> 'Ten temat nie został zaakceptowany.',
	'TOPIC_UNAPPROVED_FORUM'	=> array(
		1	=> 'Temat oczekujący na akceptację',
		2	=> 'Tematy oczekujące na akceptację',
	),
	'TOPIC_DELETED'		=> 'Ten temat został usunięty.',
	'TOTAL_ATTACHMENTS'	=> 'Załączniki',
	'TOTAL_LOGS'		=> array(
		1	=> 'Wpisy dziennika: %d',
		2	=> 'Wpisy dziennika: %d',
		3	=> 'Wpisy dziennika: %d',
	),
	'TOTAL_PMS'		=> array(
		1	=> 'Prywatne wiadomości: %d',
		2	=> 'Prywatne wiadomości: %d',
		3	=> 'Prywatne wiadomości: %d',
	),
	'TOPIC_POLL'		=> 'Ten temat zawiera ankietę.',
	'TOTAL_POSTS'		=> 'Liczba postów',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'Liczba postów: <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'Ten temat został zgłoszony',
	'TOTAL_TOPICS'		=> array(
		2	=> 'Liczba tematów: <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		2	=> 'Liczba użytkowników: <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'	=> 'Liczba zauważonych błędów PHP: %s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Nie można określić wymiarów obrazka. Sprawdź, czy podany adres URL jest poprawny.',
	'UNABLE_TO_DELIVER_FILE'=> 'Nie można dostarczyć pliku.',
	'UNKNOWN_BROWSER'		=> 'Nieznana przeglądarka',
	'UNMARK_ALL'			=> 'Usuń zaznaczenia',
	'UNREAD_MESSAGES'		=> 'Nieprzeczytane wiadomości',
	'UNREAD_POST'			=> 'Nieprzeczytany post',
	'UNREAD_POSTS'			=> 'Nieprzeczytane posty',
	'UNWATCH_FORUM_CONFIRM'		=> 'Czy na pewno chcesz zaprzestać obserwacji tego forum?',
	'UNWATCH_FORUM_DETAILED'	=> 'Czy na pewno chcesz zaprzestać obserwacji forum „%s”?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Czy na pewno chcesz zaprzestać obserwacji tego tematu?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Czy na pewno chcesz zaprzestać obserwacji tematu „%s”?',
	'UNWATCHED_FORUMS'			=> 'Nie obserwujesz już wybranych forów.',
	'UNWATCHED_TOPICS'			=> 'Nie obserwujesz już wybranych tematów.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Nie obserwujesz już wybranych pozycji.',
	'UPDATE'				=> 'Aktualizuj',
	'UPLOAD_IN_PROGRESS'	=> 'Trwa wysyłanie.',
	'URL_REDIRECT'			=> 'Jeśli twoja przeglądarka nie obsługuje przekierowań typu meta, %skliknij tutaj, aby wykonać przekierowanie%s.',
	'USERGROUPS'			=> 'Grupy',
	'USERNAME'				=> 'Nazwa użytkownika',
	'USERNAMES'				=> 'Nazwy użytkowników',
	'USER_AVATAR'			=> 'Awatar użytkownika',
	'USER_CANNOT_READ'		=> 'Nie możesz czytać postów na tym forum.',
	'USER_POSTS'			=> array(
		1	=> 'Posty: %d',
		2	=> 'Posty: %d',
		3	=> 'Posty: %d',
	),
	'USERS'					=> 'Użytkownicy',
	'USE_PERMISSIONS'		=> 'Testuj uprawnienia tego użytkownika',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Przepraszamy, ale nie masz uprawnień do używania tej funkcji. Aby używać tej i innych funkcji, musisz się zarejestrować lub brać udział w dyskusjach.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Przejrzane',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Nie przejrzano',
		1	=> 'Przejrzano %d raz',
		2	=> 'Przejrzano %d razy',
		3	=> 'Przejrzano %d razy',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'Przegląda stronę kontaktu',
	'VIEWING_FAQ'				=> 'Przegląda FAQ',
	'VIEWING_MEMBERS'			=> 'Przegląda informacje o użytkownikach',
	'VIEWING_ONLINE'			=> 'Sprawdza, kto jest online',
	'VIEWING_MCP'				=> 'Przegląda panel moderacji',
	'VIEWING_MEMBER_PROFILE'	=> 'Przegląda profil użytkownika',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Przegląda prywatne wiadomości',
	'VIEWING_REGISTER'			=> 'Rejestruje się',
	'VIEWING_UCP'				=> 'Przegląda panel zarządzania kontem',
	'VIEWS'						=> 'Odsłony',
	'VIEW_BOOKMARKS'			=> 'Wyświetl zakładki',
	'VIEW_FORUM_LOGS'			=> 'Zobacz zapisy dziennika',
	'VIEW_LATEST_POST'			=> 'Wyświetl najnowszy post',
	'VIEW_NEWEST_POST'			=> 'Wyświetl pierwszy nieprzeczytany post',
	'VIEW_NOTES'				=> 'Opinie o użytkowniku',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'wg danych z ostatniej minuty',
		2	=> 'wg danych z ostatnich %d minut',
		3	=> 'wg danych z ostatnich %d minut',
	),
	'VIEW_TOPIC'				=> 'Wyświetl temat',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Ogłoszenie: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Ogłoszenie globalne: ',
	'VIEW_TOPIC_LOCKED'			=> 'Zamknięty: ',
	'VIEW_TOPIC_LOGS'			=> 'Zobacz zapisy dziennika',
	'VIEW_TOPIC_MOVED'			=> 'Przeniesiony: ',
	'VIEW_TOPIC_POLL'			=> 'Ankieta: ',
	'VIEW_TOPIC_STICKY'			=> 'Przyklejony: ',
	'VISIT_WEBSITE'				=> 'Odwiedź witrynę WWW',

	'WARNINGS'			=> 'Ostrzeżenia',
	'WARN_USER'			=> 'Udziel ostrzeżenia',
	'WATCH_FORUM_CONFIRM'	=> 'Czy na pewno chcesz obserwować to forum?',
	'WATCH_FORUM_DETAILED'	=> 'Czy na pewno chcesz obserwować forum „%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Czy na pewno chcesz obserwować ten temat?',
	'WATCH_TOPIC_DETAILED'	=> 'Czy na pewno chcesz obserwować temat „%s”?',
	'WELCOME_SUBJECT'	=> 'Witamy na forum %s',
	'WEBSITE'			=> 'Strona WWW',
	'WHOIS'				=> 'Kto to?',
	'WHO_IS_ONLINE'		=> 'Kto jest online',
	'WRONG_PASSWORD'	=> 'Wprowadzono nieprawidłowe hasło.',

	'WRONG_DATA_COLOUR'			=> 'Wprowadzona wartość koloru jest nieprawidłowa.',
	'WRONG_DATA_JABBER'			=> 'Wprowadzona nazwa nie jest prawidłową nazwą konta Jabber.',
	'WRONG_DATA_LANG'			=> 'Wybrany język nie jest obsługiwany.',
	'WRONG_DATA_POST_SD'		=> 'Wybrano prawidłowy kierunek sortowania postów.',
	'WRONG_DATA_POST_SK'		=> 'Wybrano prawidłową opcję sortowania postów.',
	'WRONG_DATA_TOPIC_SD'		=> 'Wybrano prawidłowy kierunek sortowania tematów.',
	'WRONG_DATA_TOPIC_SK'		=> 'Wybrano prawidłową opcję sortowania tematów.',
	'WROTE'						=> 'pisze',

	'YAHOO'				=> 'Yahoo Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'Rok',
	'YEAR_MONTH_DAY'	=> '(RRRR-MM-DD)',
	'YES'				=> 'Tak',
	'YOU_LAST_VISIT'	=> 'Twoja ostatnia wizyta: %s',

	'datetime'			=> array(
		'TODAY'		=> 'dzisiaj',
		'TOMORROW'	=> 'jutro',
		'YESTERDAY'	=> 'wczoraj',
		'AGO'		=> array(
			0		=> 'niecałą minutę temu',
			1		=> '%d min temu',
			2		=> '%d min temu',
			3		=> '%d min temu',
		),

		'Sunday'	=> 'niedziela',
		'Monday'	=> 'poniedziałek',
		'Tuesday'	=> 'wtorek',
		'Wednesday'	=> 'środa',
		'Thursday'	=> 'czwartek',
		'Friday'	=> 'piątek',
		'Saturday'	=> 'sobota',

		'Sun'		=> 'ndz',
		'Mon'		=> 'pn',
		'Tue'		=> 'wt',
		'Wed'		=> 'śr',
		'Thu'		=> 'czw',
		'Fri'		=> 'pt',
		'Sat'		=> 'sob',

		'January'	=> 'stycznia',
		'February'	=> 'lutego',
		'March'		=> 'marca',
		'April'		=> 'kwietnia',
		'May'		=> 'maja',
		'June'		=> 'czerwca',
		'July'		=> 'lipca',
		'August'	=> 'sierpnia',
		'September' => 'września',
		'October'	=> 'października',
		'November'	=> 'listopada',
		'December'	=> 'grudnia',

		'Jan'		=> 'sty',
		'Feb'		=> 'lut',
		'Mar'		=> 'mar',
		'Apr'		=> 'kwie',
		'May_short'	=> 'maja',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'cze',
		'Jul'		=> 'lip',
		'Aug'		=> 'sie',
		'Sep'		=> 'wrz',
		'Oct'		=> 'paź',
		'Nov'		=> 'lis',
		'Dec'		=> 'gru',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'	=> 'Afryka/Abidżan',
		'Africa/Accra'		=> 'Afryka/Akra',
		'Africa/Addis_Ababa'	=> 'Afryka/Addis Abeba',
		'Africa/Algiers'	=> 'Afryka/Algier',
		'Africa/Asmara'		=> 'Afryka/Asmara',
		'Africa/Bamako'		=> 'Afryka/Bamako',
		'Africa/Bangui'		=> 'Afryka/Bangi',
		'Africa/Banjul'		=> 'Afryka/Bandżul',
		'Africa/Bissau'		=> 'Afryka/Bissau',
		'Africa/Blantyre'	=> 'Afryka/Blantyre',
		'Africa/Brazzaville'	=> 'Afryka/Brazzaville',
		'Africa/Bujumbura'	=> 'Afryka/Bużumbura',
		'Africa/Cairo'		=> 'Afryka/Kair',
		'Africa/Casablanca'	=> 'Afryka/Casablanca',
		'Africa/Ceuta'		=> 'Afryka/Ceuta',
		'Africa/Conakry'	=> 'Afryka/Konakry',
		'Africa/Dakar'		=> 'Afryka/Dakar',
		'Africa/Dar_es_Salaam'	=> 'Afryka/Dar es Salaam',
		'Africa/Djibouti'	=> 'Afryka/Dżibuti',
		'Africa/Douala'		=> 'Afryka/Douala',
		'Africa/El_Aaiun'	=> 'Afryka/El Aaiun',
		'Africa/Freetown'	=> 'Afryka/Freetown',
		'Africa/Gaborone'	=> 'Afryka/Gaborone',
		'Africa/Harare'		=> 'Afryka/Harare',
		'Africa/Johannesburg'	=> 'Afryka/Johannesburg',
		'Africa/Juba'		=> 'Afryka/Dżuba',
		'Africa/Kampala'	=> 'Afryka/Kampala',
		'Africa/Khartoum'	=> 'Afryka/Chartum',
		'Africa/Kigali'		=> 'Afryka/Kigali',
		'Africa/Kinshasa'	=> 'Afryka/Kinszasa',
		'Africa/Lagos'		=> 'Afryka/Lagos',
		'Africa/Libreville'	=> 'Afryka/Libreville',
		'Africa/Lome'		=> 'Afryka/Lome',
		'Africa/Luanda'		=> 'Afryka/Luanda',
		'Africa/Lubumbashi'	=> 'Afryka/Lubumbashi',
		'Africa/Lusaka'		=> 'Afryka/Lusaka',
		'Africa/Malabo'		=> 'Afryka/Malabo',
		'Africa/Maputo'		=> 'Afryka/Maputo',
		'Africa/Maseru'		=> 'Afryka/Maseru',
		'Africa/Mbabane'	=> 'Afryka/Mbabane',
		'Africa/Mogadishu'	=> 'Afryka/Mogadiszu',
		'Africa/Monrovia'	=> 'Afryka/Monrovia',
		'Africa/Nairobi'	=> 'Afryka/Nairobi',
		'Africa/Ndjamena'	=> 'Afryka/Ndżamena',
		'Africa/Niamey'		=> 'Afryka/Niamey',
		'Africa/Nouakchott'	=> 'Afryka/Nawakszut',
		'Africa/Ouagadougou'	=> 'Afryka/Wagadugu',
		'Africa/Porto-Novo'	=> 'Afryka/Porto-Novo',
		'Africa/Sao_Tome'	=> 'Afryka/Sao Tome',
		'Africa/Tripoli'	=> 'Afryka/Trypolis',
		'Africa/Tunis'		=> 'Afryka/Tunis',
		'Africa/Windhoek'	=> 'Afryka/Windhuk',

		'America/Adak'		=> 'Ameryka/Adak',
		'America/Anchorage'	=> 'Ameryka/Anchorage',
		'America/Anguilla'	=> 'Ameryka/Anguilla',
		'America/Antigua'	=> 'Ameryka/Antigua',
		'America/Araguaina'	=> 'Ameryka/Araguaina',

		'America/Argentina/Buenos_Aires'	=> 'Ameryka/Argentyna/Buenos Aires',
		'America/Argentina/Catamarca'	=> 'Ameryka/Argentyna/Catamarca',
		'America/Argentina/Cordoba'		=> 'Ameryka/Argentyna/Kordoba',
		'America/Argentina/Jujuy'		=> 'Ameryka/Argentyna/Jujuy',
		'America/Argentina/La_Rioja'	=> 'Ameryka/Argentyna/La Rioja',
		'America/Argentina/Mendoza'		=> 'Ameryka/Argentyna/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'Ameryka/Argentyna/Rio Gallegos',
		'America/Argentina/Salta'		=> 'Ameryka/Argentyna/Salta',
		'America/Argentina/San_Juan'	=> 'Ameryka/Argentyna/San Juan',
		'America/Argentina/San_Luis'	=> 'Ameryka/Argentyna/San Luis',
		'America/Argentina/Tucuman'		=> 'Ameryka/Argentyna/Tucumán',
		'America/Argentina/Ushuaia'		=> 'Ameryka/Argentyna/Ushuaia',

		'America/Aruba'			=> 'Ameryka/Aruba',
		'America/Asuncion'		=> 'Ameryka/Asunción',
		'America/Atikokan'		=> 'Ameryka/Atikokan',
		'America/Bahia'			=> 'Ameryka/Bahia',
		'America/Bahia_Banderas'	=> 'Ameryka/Bahia Banderas',
		'America/Barbados'		=> 'Ameryka/Barbados',
		'America/Belem'			=> 'Ameryka/Belem',
		'America/Belize'		=> 'Ameryka/Belize',
		'America/Blanc-Sablon'	=> 'Ameryka/Blanc-Sablon',
		'America/Boa_Vista'		=> 'Ameryka/Boa Vista',
		'America/Bogota'		=> 'Ameryka/Bogota',
		'America/Boise'			=> 'Ameryka/Boise',
		'America/Cambridge_Bay'	=> 'Ameryka/Cambridge Bay',
		'America/Campo_Grande'	=> 'Ameryka/Campo Grande',
		'America/Cancun'		=> 'Ameryka/Cancún',
		'America/Caracas'		=> 'Ameryka/Caracas',
		'America/Cayenne'		=> 'Ameryka/Kajenna',
		'America/Cayman'		=> 'Ameryka/Kajmany',
		'America/Chicago'		=> 'Ameryka/Chicago',
		'America/Chihuahua'		=> 'Ameryka/Chihuahua',
		'America/Costa_Rica'	=> 'Ameryka/Costa Rica',
		'America/Creston'		=> 'Ameryka/Creston',
		'America/Cuiaba'		=> 'Ameryka/Cuiaba',
		'America/Curacao'		=> 'Ameryka/Curacao',
		'America/Danmarkshavn'	=> 'Ameryka/Danmarkshavn',
		'America/Dawson'		=> 'Ameryka/Dawson',
		'America/Dawson_Creek'	=> 'Ameryka/Dawson Creek',
		'America/Denver'		=> 'Ameryka/Denver',
		'America/Detroit'		=> 'Ameryka/Detroit',
		'America/Dominica'		=> 'Ameryka/Dominica',
		'America/Edmonton'		=> 'Ameryka/Edmonton',
		'America/Eirunepe'		=> 'Ameryka/Eirunepe',
		'America/El_Salvador'	=> 'Ameryka/El Salvador',
		'America/Fortaleza'		=> 'Ameryka/Fortaleza',
		'America/Glace_Bay'		=> 'Ameryka/Glace Bay',
		'America/Godthab'		=> 'Ameryka/Godthab',
		'America/Goose_Bay'		=> 'Ameryka/Goose Bay',
		'America/Grand_Turk'	=> 'Ameryka/Grand Turk',
		'America/Grenada'		=> 'Ameryka/Grenada',
		'America/Guadeloupe'	=> 'Ameryka/Gwadelupa',
		'America/Guatemala'		=> 'Ameryka/Gwatemala',
		'America/Guayaquil'		=> 'Ameryka/Guayaquil',
		'America/Guyana'		=> 'Ameryka/Gujana',
		'America/Halifax'		=> 'Ameryka/Halifax',
		'America/Havana'		=> 'Ameryka/Hawana',
		'America/Hermosillo'		=> 'Ameryka/Hermosillo',
		'America/Indiana/Indianapolis'	=> 'Ameryka/Indiana/Indianapolis',
		'America/Indiana/Knox'		=> 'Ameryka/Indiana/Knox',
		'America/Indiana/Marengo'	=> 'Ameryka/Indiana/Marengo',
		'America/Indiana/Petersburg'	=> 'Ameryka/Indiana/Petersburg',
		'America/Indiana/Tell_City'	=> 'Ameryka/Indiana/Tell City',
		'America/Indiana/Vevay'		=> 'Ameryka/Indiana/Vevay',
		'America/Indiana/Vincennes'	=> 'Ameryka/Indiana/Vincennes',
		'America/Indiana/Winamac'	=> 'Ameryka/Indiana/Winamac',
		'America/Inuvik'		=> 'Ameryka/Inuvik',
		'America/Iqaluit'		=> 'Ameryka/Iqaluit',
		'America/Jamaica'		=> 'Ameryka/Jamajka',
		'America/Juneau'		=> 'Ameryka/Juneau',
		'America/Kentucky/Louisville'	=> 'Ameryka/Kentucky/Louisville',
		'America/Kentucky/Monticello'	=> 'Ameryka/Kentucky/Monticello',
		'America/Kralendijk'	=> 'Ameryka/Kralendijk',
		'America/La_Paz'		=> 'Ameryka/La Paz',
		'America/Lima'			=> 'Ameryka/Lima',
		'America/Los_Angeles'	=> 'Ameryka/Los Angeles',
		'America/Lower_Princes'	=> 'Ameryka/Lower Princes',
		'America/Maceio'		=> 'Ameryka/Maceio',
		'America/Managua'		=> 'Ameryka/Managua',
		'America/Manaus'		=> 'Ameryka/Manaus',
		'America/Marigot'		=> 'Ameryka/Marigot',
		'America/Martinique'	=> 'Ameryka/Martynika',
		'America/Matamoros'		=> 'Ameryka/Matamoros',
		'America/Mazatlan'		=> 'Ameryka/Mazatlán',
		'America/Menominee'		=> 'Ameryka/Menominee',
		'America/Merida'		=> 'Ameryka/Merida',
		'America/Metlakatla'	=> 'Ameryka/Metlakatla',
		'America/Mexico_City'	=> 'Ameryka/Meksyk',
		'America/Miquelon'		=> 'Ameryka/Miquelon',
		'America/Moncton'		=> 'Ameryka/Moncton',
		'America/Monterrey'		=> 'Ameryka/Monterrey',
		'America/Montevideo'	=> 'Ameryka/Montevideo',
		'America/Montreal'		=> 'Ameryka/Montreal',
		'America/Montserrat'	=> 'Ameryka/Montserrat',
		'America/Nassau'		=> 'Ameryka/Nassau',
		'America/New_York'		=> 'Ameryka/Nowy Jork',
		'America/Nipigon'		=> 'Ameryka/Nipigon',
		'America/Nome'			=> 'Ameryka/Nome',
		'America/Noronha'		=> 'Ameryka/Noronha',
		'America/North_Dakota/Beulah'		=> 'Ameryka/Północna Dakota/Beulah',
		'America/North_Dakota/Center'		=> 'Ameryka/Północna Dakota/Center',
		'America/North_Dakota/New_Salem'	=> 'Ameryka/Północna Dakota/New Salem',
		'America/Ojinaga'		=> 'Ameryka/Ojinaga',
		'America/Panama'		=> 'Ameryka/Panama',
		'America/Pangnirtung'	=> 'Ameryka/Pangnirtung',
		'America/Paramaribo'	=> 'Ameryka/Paramaribo',
		'America/Phoenix'		=> 'Ameryka/Phoenix',
		'America/Port-au-Prince'	=> 'Ameryka/Port-au-Prince',
		'America/Port_of_Spain'	=> 'Ameryka/Port of Spain',
		'America/Porto_Velho'	=> 'Ameryka/Porto Velho',
		'America/Puerto_Rico'	=> 'Ameryka/Portoryko',
		'America/Rainy_River'	=> 'Ameryka/Rainy River',
		'America/Rankin_Inlet'	=> 'Ameryka/Rankin Inlet',
		'America/Recife'		=> 'Ameryka/Recife',
		'America/Regina'		=> 'Ameryka/Regina',
		'America/Resolute'		=> 'Ameryka/Resolute',
		'America/Rio_Branco'	=> 'Ameryka/Rio Branco',
		'America/Santa_Isabel'	=> 'Ameryka/Santa Isabel',
		'America/Santarem'		=> 'Ameryka/Santarem',
		'America/Santiago'		=> 'Ameryka/Santiago',
		'America/Santo_Domingo'	=> 'Ameryka/Santo Domingo',
		'America/Sao_Paulo'		=> 'Ameryka/Sao Paulo',
		'America/Scoresbysund'	=> 'Ameryka/Scoresbysund',
		'America/Shiprock'		=> 'Ameryka/Shiprock',
		'America/Sitka'			=> 'Ameryka/Sitka',
		'America/St_Barthelemy'	=> 'Ameryka/St.Barthelemy',
		'America/St_Johns'		=> 'Ameryka/St.Johns',
		'America/St_Kitts'		=> 'Ameryka/St.Kitts',
		'America/St_Lucia'		=> 'Ameryka/St.Lucia',
		'America/St_Thomas'		=> 'Ameryka/St.Thomas',
		'America/St_Vincent'	=> 'Ameryka/St.Vincent',
		'America/Swift_Current'	=> 'Ameryka/Swift Current',
		'America/Tegucigalpa'	=> 'Ameryka/Tegucigalpa',
		'America/Thule'			=> 'Ameryka/Thule',
		'America/Thunder_Bay'	=> 'Ameryka/Thunder Bay',
		'America/Tijuana'		=> 'Ameryka/Tijuana',
		'America/Toronto'		=> 'Ameryka/Toronto',
		'America/Tortola'		=> 'Ameryka/Tortola',
		'America/Vancouver'		=> 'Ameryka/Vancouver',
		'America/Whitehorse'	=> 'Ameryka/Whitehorse',
		'America/Winnipeg'		=> 'Ameryka/Winnipeg',
		'America/Yakutat'		=> 'Ameryka/Yakutat',
		'America/Yellowknife'	=> 'Ameryka/Yellowknife',

		'Antarctica/Casey'		=> 'Antarktyda/Casey',
		'Antarctica/Davis'		=> 'Antarktyda/Davis',
		'Antarctica/DumontDUrville'	=> 'Antarktyda/DumontDUrville',
		'Antarctica/Macquarie'	=> 'Antarktyda/Macquarie',
		'Antarctica/Mawson'		=> 'Antarktyda/Mawson',
		'Antarctica/McMurdo'	=> 'Antarktyda/McMurdo',
		'Antarctica/Palmer'		=> 'Antarktyda/Palmer',
		'Antarctica/Rothera'	=> 'Antarktyda/Rothera',
		'Antarctica/South_Pole'	=> 'Antarktyda/South Pole',
		'Antarctica/Syowa'		=> 'Antarktyda/Syowa',
		'Antarctica/Vostok'		=> 'Antarktyda/Wostok',

		'Arctic/Longyearbyen'	=> 'Arktyka/Longyearbyen',

		'Asia/Aden'			=> 'Azja/Aden',
		'Asia/Almaty'		=> 'Azja/Almaty',
		'Asia/Amman'		=> 'Azja/Amman',
		'Asia/Anadyr'		=> 'Azja/Anadyr',
		'Asia/Aqtau'		=> 'Azja/Aktau',
		'Asia/Aqtobe'		=> 'Azja/Aktobe',
		'Asia/Ashgabat'		=> 'Azja/Aszchabad',
		'Asia/Baghdad'		=> 'Azja/Bagdad',
		'Asia/Bahrain'		=> 'Azja/Bahrajn',
		'Asia/Baku'			=> 'Azja/Baku',
		'Asia/Bangkok'		=> 'Azja/Bangkok',
		'Asia/Beirut'		=> 'Azja/Bejrut',
		'Asia/Bishkek'		=> 'Azja/Biszkek',
		'Asia/Brunei'		=> 'Azja/Brunei',
		'Asia/Choibalsan'	=> 'Azja/Czojbalsan',
		'Asia/Chongqing'	=> 'Azja/Chongqing',
		'Asia/Colombo'		=> 'Azja/Kolombo',
		'Asia/Damascus'		=> 'Azja/Damaszek',
		'Asia/Dhaka'		=> 'Azja/Daka',
		'Asia/Dili'			=> 'Azja/Dili',
		'Asia/Dubai'		=> 'Azja/Dubaj',
		'Asia/Dushanbe'		=> 'Azja/Duszanbe',
		'Asia/Gaza'			=> 'Azja/Gaza',
		'Asia/Harbin'		=> 'Azja/Harbin',
		'Asia/Hebron'		=> 'Azja/Hebron',
		'Asia/Ho_Chi_Minh'	=> 'Azja/Ho Chi Minh',
		'Asia/Hong_Kong'	=> 'Azja/Hong Kong',
		'Asia/Hovd'			=> 'Azja/Hovd',
		'Asia/Irkutsk'		=> 'Azja/Irkuck',
		'Asia/Jakarta'		=> 'Azja/Dżakarta',
		'Asia/Jayapura'		=> 'Azja/Jayapura',
		'Asia/Jerusalem'	=> 'Azja/Jerozolima',
		'Asia/Kabul'		=> 'Azja/Kabul',
		'Asia/Kamchatka'	=> 'Azja/Kamczatka',
		'Asia/Karachi'		=> 'Azja/Karaczi',
		'Asia/Kashgar'		=> 'Azja/Kaszgar',
		'Asia/Kathmandu'	=> 'Azja/Katmandu',
		'Asia/Khandyga'		=> 'Azja/Khandyga',
		'Asia/Kolkata'		=> 'Azja/Kolkata',
		'Asia/Krasnoyarsk'	=> 'Azja/Krasnojarsk',
		'Asia/Kuala_Lumpur'	=> 'Azja/Kuala Lumpur',
		'Asia/Kuching'		=> 'Azja/Kuching',
		'Asia/Kuwait'		=> 'Azja/Kuwejt',
		'Asia/Macau'		=> 'Azja/Makau',
		'Asia/Magadan'		=> 'Azja/Magadan',
		'Asia/Makassar'		=> 'Azja/Makasar',
		'Asia/Manila'		=> 'Azja/Manila',
		'Asia/Muscat'		=> 'Azja/Maskat',
		'Asia/Nicosia'		=> 'Azja/Nikozja',
		'Asia/Novokuznetsk'	=> 'Azja/Nowokuźnieck',
		'Asia/Novosibirsk'	=> 'Azja/Nowosybirsk',
		'Asia/Omsk'			=> 'Azja/Omsk',
		'Asia/Oral'			=> 'Azja/Oral',
		'Asia/Phnom_Penh'	=> 'Azja/Phnom Penh',
		'Asia/Pontianak'	=> 'Azja/Pontianak',
		'Asia/Pyongyang'	=> 'Azja/Pjongjang',
		'Asia/Qatar'		=> 'Azja/Katar',
		'Asia/Qyzylorda'	=> 'Azja/Kyzyłorda',
		'Asia/Rangoon'		=> 'Azja/Rangun',
		'Asia/Riyadh'		=> 'Azja/Rijad',
		'Asia/Sakhalin'		=> 'Azja/Sahalin',
		'Asia/Samarkand'	=> 'Azja/Samarkanda',
		'Asia/Seoul'		=> 'Azja/Seul',
		'Asia/Shanghai'		=> 'Azja/Szanghaj',
		'Asia/Singapore'	=> 'Azja/Singapur',
		'Asia/Taipei'		=> 'Azja/Tajpei',
		'Asia/Tashkent'		=> 'Azja/Taszkient',
		'Asia/Tbilisi'		=> 'Azja/Tbilisi',
		'Asia/Tehran'		=> 'Azja/Teheran',
		'Asia/Thimphu'		=> 'Azja/Thimphu',
		'Asia/Tokyo'		=> 'Azja/Tokjo',
		'Asia/Ulaanbaatar'	=> 'Azja/Ułanbator',
		'Asia/Urumqi'		=> 'Azja/Urumczi',
		'Asia/Ust-Nera'		=> 'Azja/Ust´-Niera',
		'Asia/Vientiane'	=> 'Azja/Wientian',
		'Asia/Vladivostok'	=> 'Azja/Władywostok',
		'Asia/Yakutsk'		=> 'Azja/Jakuck',
		'Asia/Yekaterinburg'	=> 'Azja/Jekaterinburg',
		'Asia/Yerevan'		=> 'Azja/Jerewań',

		'Atlantic/Azores'		=> 'Strefa Atlantyku/Azory',
		'Atlantic/Bermuda'		=> 'Strefa Atlantyku/Bermudy',
		'Atlantic/Canary'		=> 'Strefa Atlantyku/Wyspy Kanaryjskie',
		'Atlantic/Cape_Verde'	=> 'Strefa Atlantyku/Republika Zielonego Przylądka',
		'Atlantic/Faroe'		=> 'Strefa Atlantyku/Wyspy Owcze',
		'Atlantic/Madeira'		=> 'Strefa Atlantyku/Madera',
		'Atlantic/Reykjavik'	=> 'Strefa Atlantyku/Reykjavik',
		'Atlantic/South_Georgia'	=> 'Strefa Atlantyku/Georgia Południowa',
		'Atlantic/St_Helena'	=> 'Strefa Atlantyku/Wyspa Sw.Heleny',
		'Atlantic/Stanley'		=> 'Strefa Atlantyku/Stanley',

		'Australia/Adelaide'	=> 'Australia/Adelajda',
		'Australia/Brisbane'	=> 'Australia/Brisbane',
		'Australia/Broken_Hill'	=> 'Australia/Broken Hill',
		'Australia/Currie'		=> 'Australia/Currie',
		'Australia/Darwin'		=> 'Australia/Darwin',
		'Australia/Eucla'		=> 'Australia/Eucla',
		'Australia/Hobart'		=> 'Australia/Hobart',
		'Australia/Lindeman'	=> 'Australia/Lindeman',
		'Australia/Lord_Howe'	=> 'Australia/Lord Howe',
		'Australia/Melbourne'	=> 'Australia/Melbourne',
		'Australia/Perth'		=> 'Australia/Perth',
		'Australia/Sydney'		=> 'Australia/Sydney',

		'Europe/Amsterdam'	=> 'Europa/Amsterdam',
		'Europe/Andorra'	=> 'Europa/Andora',
		'Europe/Athens'		=> 'Europa/Ateny',
		'Europe/Belgrade'	=> 'Europa/Belgrad',
		'Europe/Berlin'		=> 'Europa/Berlin',
		'Europe/Bratislava'	=> 'Europa/Bratysława',
		'Europe/Brussels'	=> 'Europa/Bruksela',
		'Europe/Bucharest'	=> 'Europa/Bukareszt',
		'Europe/Budapest'	=> 'Europa/Budapeszt',
		'Europe/Busingen'	=> 'Europa/Büsingen',
		'Europe/Chisinau'	=> 'Europa/Kiszyniów',
		'Europe/Copenhagen'	=> 'Europa/Kopenhaga',
		'Europe/Dublin'		=> 'Europa/Dublin',
		'Europe/Gibraltar'	=> 'Europa/Gibraltar',
		'Europe/Guernsey'	=> 'Europa/Guernsey',
		'Europe/Helsinki'	=> 'Europa/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europa/Wyspa Man',
		'Europe/Istanbul'	=> 'Europa/Istambuł',
		'Europe/Jersey'		=> 'Europa/Jersey',
		'Europe/Kaliningrad'	=> 'Europa/Kaliningrad',
		'Europe/Kiev'		=> 'Europa/Kijów',
		'Europe/Lisbon'		=> 'Europa/Lizbona',
		'Europe/Ljubljana'	=> 'Europa/Ljubljana',
		'Europe/London'		=> 'Europa/Londyn',
		'Europe/Luxembourg'	=> 'Europa/Luksemburg',
		'Europe/Madrid'		=> 'Europa/Madryt',
		'Europe/Malta'		=> 'Europa/Malta',
		'Europe/Mariehamn'	=> 'Europa/Mariehamn',
		'Europe/Minsk'		=> 'Europa/Mińsk',
		'Europe/Monaco'		=> 'Europa/Monaco',
		'Europe/Moscow'		=> 'Europa/Moskwa',
		'Europe/Oslo'		=> 'Europa/Oslo',
		'Europe/Paris'		=> 'Europa/Paryż',
		'Europe/Podgorica'	=> 'Europa/Podgorica',
		'Europe/Prague'		=> 'Europa/Praga',
		'Europe/Riga'		=> 'Europa/Ryga',
		'Europe/Rome'		=> 'Europa/Rzym',
		'Europe/Samara'		=> 'Europa/Samara',
		'Europe/San_Marino'	=> 'Europa/San Marino',
		'Europe/Sarajevo'	=> 'Europa/Sarajewo',
		'Europe/Simferopol'	=> 'Europa/Symferopol',
		'Europe/Skopje'		=> 'Europa/Skopje',
		'Europe/Sofia'		=> 'Europa/Sofia',
		'Europe/Stockholm'	=> 'Europa/Sztokholm',
		'Europe/Tallinn'	=> 'Europa/Talin',
		'Europe/Tirane'		=> 'Europa/Tirana',
		'Europe/Uzhgorod'	=> 'Europa/Użgorod',
		'Europe/Vaduz'		=> 'Europa/Vaduz',
		'Europe/Vatican'	=> 'Europa/Watykan',
		'Europe/Vienna'		=> 'Europa/Wiedeń',
		'Europe/Vilnius'	=> 'Europa/Wilno',
		'Europe/Volgograd'	=> 'Europa/Wołgograd',
		'Europe/Warsaw'		=> 'Europa/Warszawa',
		'Europe/Zagreb'		=> 'Europa/Zagrzeb',
		'Europe/Zaporozhye'	=> 'Europa/Zaporoże',
		'Europe/Zurich'		=> 'Europa/Zurich',

		'Indian/Antananarivo'	=> 'Strefa Oceanu Indyjskiego/Antananarywa',
		'Indian/Chagos'		=> 'Strefa Oceanu Indyjskiego/Czagos',
		'Indian/Christmas'	=> 'Strefa Oceanu Indyjskiego/Wyspa Bożego Narodzenia',
		'Indian/Cocos'		=> 'Strefa Oceanu Indyjskiego/ Wyspa Kokosowa',
		'Indian/Comoro'		=> 'Strefa Oceanu Indyjskiego/Komory',
		'Indian/Kerguelen'	=> 'Strefa Oceanu Indyjskiego/Wyspy Kerguelena',
		'Indian/Mahe'		=> 'Strefa Oceanu Indyjskiego/Mahe',
		'Indian/Maldives'	=> 'Strefa Oceanu Indyjskiego/Malediwy',
		'Indian/Mauritius'	=> 'Strefa Oceanu Indyjskiego/Mauritius',
		'Indian/Mayotte'	=> 'Strefa Oceanu Indyjskiego/Majotta',
		'Indian/Reunion'	=> 'Strefa Oceanu Indyjskiego/Reunion',

		'Pacific/Apia'		=> 'Strefa Pacyfiku/Apia',
		'Pacific/Auckland'	=> 'Strefa Pacyfiku/Auckland',
		'Pacific/Chatham'	=> 'Strefa Pacyfiku/Wyspy Chatham',
		'Pacific/Chuuk'		=> 'Strefa Pacyfiku/Chuuk',
		'Pacific/Easter'	=> 'Strefa Pacyfiku/Wyspa Wielkanocna',
		'Pacific/Efate'		=> 'Strefa Pacyfiku/Wyspa Efate',
		'Pacific/Enderbury'	=> 'Strefa Pacyfiku/Enderbury',
		'Pacific/Fakaofo'	=> 'Strefa Pacyfiku/Fakaofo',
		'Pacific/Fiji'		=> 'Strefa Pacyfiku/Fidżi',
		'Pacific/Funafuti'	=> 'Strefa Pacyfiku/Funafuti',
		'Pacific/Galapagos'	=> 'Strefa Pacyfiku/Galapagos',
		'Pacific/Gambier'	=> 'Strefa Pacyfiku/Gambier',
		'Pacific/Guadalcanal'	=> 'Strefa Pacyfiku/Guadalcanal',
		'Pacific/Guam'		=> 'Strefa Pacyfiku/Guam',
		'Pacific/Honolulu'	=> 'Strefa Pacyfiku/Honolulu',
		'Pacific/Johnston'	=> 'Strefa Pacyfiku/Johnston',
		'Pacific/Kiritimati'	=> 'Strefa Pacyfiku/Kiritimati',
		'Pacific/Kosrae'	=> 'Strefa Pacyfiku/Kosrae',
		'Pacific/Kwajalein'	=> 'Strefa Pacyfiku/Atol Kwajalein',
		'Pacific/Majuro'	=> 'Strefa Pacyfiku/Majuro',
		'Pacific/Marquesas'	=> 'Strefa Pacyfiku/Markizy',
		'Pacific/Midway'	=> 'Strefa Pacyfiku/Midway',
		'Pacific/Nauru'		=> 'Strefa Pacyfiku/Nauru',
		'Pacific/Niue'		=> 'Strefa Pacyfiku/Niue',
		'Pacific/Norfolk'	=> 'Strefa Pacyfiku/Norfolk',
		'Pacific/Noumea'	=> 'Strefa Pacyfiku/Noumea',
		'Pacific/Pago_Pago'	=> 'Strefa Pacyfiku/Pago Pago',
		'Pacific/Palau'		=> 'Strefa Pacyfiku/Palau',
		'Pacific/Pitcairn'	=> 'Strefa Pacyfiku/Wyspy Pitcairn',
		'Pacific/Pohnpei'	=> 'Strefa Pacyfiku/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Strefa Pacyfiku/Port Moresby',
		'Pacific/Rarotonga'	=> 'Strefa Pacyfiku/Wyspa Rarotonga',
		'Pacific/Saipan'	=> 'Strefa Pacyfiku/WyspaSaipan',
		'Pacific/Tahiti'	=> 'Strefa Pacyfiku/Tahiti',
		'Pacific/Tarawa'	=> 'Strefa Pacyfiku/Atol Tarawa',
		'Pacific/Tongatapu'	=> 'Strefa Pacyfiku/Wyspa Tongatapu',
		'Pacific/Wake'		=> 'Strefa Pacyfiku/Wyspa Wake',
		'Pacific/Wallis'	=> 'Strefa Pacyfiku/Wyspy Wallis',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 sty 2014, 17:37',
		'|d M Y|, G:i'				=> 'dzisiaj, 13:37 / 01 sty 2014, 13:37',
		'd M Y, h:i a'			=> '01 sty 2014, 07:37 pm',
		'd M Y, g:i a'			=> '01 sty 2014, 7:37 pm',
		'd F Y, H:i'			=> '01 stycznia 2014, 17:37',
		'l d M Y, H:i'			=> 'poniedziałek 01 sty 2014, 17:37',
		'D d M Y, H:i'			=> 'pon 01 sty 2014, 17:37',
		'd F Y, H:i - D'		=> '01 stycznia 2014, 17:37 - pon'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'd M Y, G:i', // 01 sty 2014, 7:37

));
