<?php
/**
*
* phpBB 3.3.X Project - Persian Translation
* Translators: PHP-BB.IR Group Meis@M Nobari
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Privacy policy and T&C
$lang = array_merge($lang, array(
	'TERMS_OF_USE_CONTENT'	=> 'با دسترسی به “%1$s” (در سطور بعد “ما”, “%1$s”, “%2$s” را بیان دارد), پیروی از قوانین مقابل را قبول میکنید. اگر این قوانین را قبول ندارید لطفاً از “%1$s” استفاده نکنید. این قوانین در هر زمانی ممکن است تغییر کند و ما تمام سعی خودمان را خواهیم کرد که این تغییرات را به شما اطلاع دهیم، با این وجود باید قوانین موجود را در بازه های زمانی منظم کنترل کنید و از تغییرات آگاه شوید.اگر قوانین موجود در “%1$s” تغییر کند و شما به استفاده از آن ادامه دهید،این بدان معنا خواهد بود که شما این قوانین را پذیرفته اید.
	<br><br>
	انجمن‌های ما توسط phpBB ایجاد شده اند (در سطور بعدی “آن‌ها”, “نرم افزار phpBB”, “www.phpbb.com”, “گروه phpBB”, “تیم phpBB” را بیان میکند) که تحت لایسنس “<a href="http://opensource.org/licenses/gpl-2.0.php">General Public License</a>” فعالیت میکند (در سطور بعدی به عنوان “GPL” یاد خواهد شد) و از <a href="http://www.phpbb.com/">www.phpbb.com</a> قابل بارگیری است. نرم افزار phpBB تنها نرم افزاری است برای تسهیل بحث وگفتگو در اینترنت. گروه phpBB مسئول هیچگونه محتوا و یا رفتاری که مورد تأیید و یا عدم تأیید phpBB باشد،نیست برای اطلاعات بیشتر در مورد phpBB لطفاً به آدرس <a href="http://www.phpbb.com/">http://www.phpbb.com/</a> مراجعه کنید.
	<br><br>
	انجمن‌های ما توسط php-BB فارسی سازی شده اند. (در سطور بعدی “آن‌ها”,“www.php-bb.ir”,“تیم php-bb” را بیان میکند.) <a href="http://www.php-bb.ir">php-bb</a> تنها این نرم افزار را فارسی سازی کرده است و هیچ گونه مسئولیتی در قبال مطالب و محتوای موجود در سایت های استفاده کننده از آن را ندارد. برای اطلاعات بیشتر به<a href="http://www.php-pb.ir">www.php-bb.ir</a> مراجعه کنید. <br /> <br /> 
	شما موافقت میکنید که مطالب مستهجن،مبتذل،افترا آمیز،توهین آمیز،تهدید کننده و هرگونه مطلب مخالف با قوانین کشورتان و قوانینی که “%1$s” در آن کشور میزبان شده است و همچنین قوانین بین الملل، ارسال نکنید. در غیر این صورت به طور سریع و همیشگی تحریم خواهید شد،اگر از جانب سرویس خدمات دهی اینترنت شما،نامه ای مبنی بر تخلف شما دریافت کنیم این تالار حق تحریم شما را دارد. موافقت میکنید که “%1$s” حق ویرایش،حذف،انتقال و قفل کردن موضوعات را در هر زمانی داراست. طبق موافقت نامه تمامی اطلاعات وارد شده شما در تالار در پایگاه داده ما ذخیره خواهد شد. این اطلاعات به هیچ وجه با سایتی دیگر به اشتراک گذاشته نخواهد شد. با این وجود “%1 ندارد.
	',

	'PRIVACY_POLICY'		=> 'این سیاست توضیحی است برای “%1$s” همراه با شرکت وابسته (در سطور بعد به عنوان “ما”, “%1$s”, “%2$s” یاد خواهد شد) و phpBB (در سطور بعد “آن‌ها”, “phpBB نرم افزار”, “www.phpbb.com”, “phpBB گروه”, “phpBB تیم”) که چگونه اطلاعات شما را جمع آوری میکنند. .(در سطور بعدی به عنوان “اطلاعات شما” یاد خواهد شد)
	<br><br>
	اطلاعات شما به دو روش جمع آوری میشوند، اول،جست‌وجو در “%1$s” موجب ایجاد کوکی هایی میشود که فایل‌های کوچکی هستند و به به فایل‌های موجود مرورگرتان بارگیری میشوند. دو کوکی اول فقط حاوی هویت شما میباشند .(در سطور بعدی به عنوان “user-id” یاد خواهد شد) و هویت نشستی بی هویت. (در سطور بعدی به عنوان “session-id” یاد خواهد شد), به صورت خودکار توسط phpBB فراهم شده است. کوکی سوم هنگام جست‌وجوی موضوعات “%1$s”  ایجاد میشود و اطلاعاتی از قبیل مشخص کردن موضوعات خوانده شده را ذخیره میکنند.
	<br><br>
	ممکن است نرم افزار phpBB در حین جست‌وجوی “%1$s” ،کوکی های خارجی هم ایجاد کند. با این وجود این کوکی ها خارج از حوزه این سند که صفحات ایجاد شده توسط phpBB را پوشش میدهد،قرار دارند. راه دوم جمع آوری اطلاعات از شما،اطلاعاتی است که شما به ما ارسال میکنید. این اطلاعات ممکن است وجود نداشته باشد و همچنین محدود به این اطلاعات نیستند : ارسالات کاربران بی هویت (در سطور بعدی به عنوان “پست‌ها بی هویت” یاد خواهد شد), ثبت نام در “%1$s” (در سطور بعدی به عنوان “حساب شما” یاد خواهد شد.) و پست‌هایی که توسط شما و بعد از ثبت نام و ورود ایجاد میشوند. .(در سطور بعدی به عنوان “پست‌های شما” یاد خواهد شد)
	<br><br>
	حساب شما داری هویت منحصر به فردی است. (در سطور بعد به عنوان “نام کاربری شما” یاد خواهد شد.)، گذرواژه‌ای (در سطور بعدی به عنوان “yگذرواژه شما”یاد خواهد شد.) و ایمیلی شخصی و معتبر. (در سطور بعدی به عنوان “ایمیل شما” یاد خواهد شد) اطلاعات حساب شما در “%1$s” توسط نرم افزار حفاظت از اطلاعات شرکتی که ما را میزبانی میکند،حفاظت میشود. این حفاظت شامل نام کاربری،گذرواژه،ایمیل و سایر اطلاعات اجباری و اختیاری در حین ثبت نام در “%1$s” میشود. در هر موردی می‌توانید انتخاب کنید که کدام اطلاعات به عموم نمایش داده شود و کدام یک به عموم نمایش داده نشود. و همچنین می‌توانید از حساب خود ایمیل های تولید شده در نرم افزار phpBB را شخصی سازی کنید.
	<br><br>
	گذرواژه شما کدگذاری میشود. (هش(hash) یک طرفه) بنابر این گذرواژه وارد شده همواره امن می‌باشد. با این وجود،توصیه میشود که از یک گذرواژه در چند وبسایت استفاده نکنید. گذرواژه به معنی دسترسی به حسابتان در “%1$s” می‌باشد، بنابر این از گذرواژه خود محافظت کنید،هیچکس تحت هیچ شرایطی در “%1$s”, phpBB یا هر وبسایت دیگری مجاز به پرسیدن گذرواژه شما نیست. اگر گذرواژهتان را فراموش کردید،بر روی لینک “گذرواژه‌ام را فراموش کرده ام” که توسط نرم افزار phpBB تهیه شده است،کلیک کنید. این بخش از شما نام کاربری و ایمیلتان را خواهد خواست تا نرم افزار phpBB بتواند گذرواژه جدیدی به شما ارسال کند و حسابتان دوباره در دسترس قرار بگیرد.
	',
));

// Common language entries
$lang = array_merge($lang, array(
	'ACCOUNT_ACTIVE'			=> 'حساب شما فعال شد. ازعضویت شما متشکریم.',
	'ACCOUNT_ACTIVE_ADMIN'		=> 'این حساب فعال شده است.',
	'ACCOUNT_ACTIVE_PROFILE'	=> 'حساب شما با موفقیت دوباره فعال شد.',
	'ACCOUNT_ADDED'				=> 'حساب شما ایجاد شد، از عضویت شما متشکریم.',
	'ACCOUNT_COPPA'				=> 'حساب شما ایجاد شد ولی باید تأیید گردد، لطفاً دیگر اطلاعات را از ایمیل خود چک کنید.',
	'ACCOUNT_EMAIL_CHANGED'		=> 'حساب شما ایجاد شد. ولی ابتدا باید تأیید و فعال سازی شود. برای جزئیات به ایمیلتان مراجعه کنید.',
	'ACCOUNT_EMAIL_CHANGED_ADMIN'	=> 'حساب شما با موفقیت به‌روز رسانی شد.در این تالار برای تأیید به‌روز رسانی ایمیل،لینک فعال سازی دوباره به ایمیلتان ارسال میشود.لطفاً برای فعال کردن دوباره به ایمیل جدیدتان مراجعه کنید.',
	'ACCOUNT_INACTIVE'			=> 'حساب شما با موفقیت به‌روز رسانی شد.در این تالار برای تأیید به‌روز رسانی ایمیل،مدیر باید دوباره حساب شما را فعال کند.ایمیل مرتبطی به آن‌ها ارسال شد ، ضمنا اسپم باکس ایمیل خود را نیز بررسی کنید و ممکن است رسیدن پیام چند وقتی طول بکشد که بستگی به سرویس ایمیل شما دارد،اگر حسابتان فعال شود،به شما خبر داده خواهد شد.',
	'ACCOUNT_INACTIVE_ADMIN'	=> 'حساب شما ایجاد شد،با این وجود باید حسابتان را فعال کنید. کد فعالسازی به ایمیلتان ارسال شد. برای اطلاعات بیشتر به ایمیلتان مراجعه کنید.',
	'ACTIVATION_EMAIL_SENT'		=> 'ایمیل فعال سازی به آدرس ایمیلتان ارسال شد.',
	'ACTIVATION_EMAIL_SENT_ADMIN'	=> 'ایمیل فعال سازی به آدرس ایمیل مدیر ارسال شد.',
	'ADD'					=> 'افزودن',
	'ADD_BCC'				=> 'افزودن [BCC]',
	'ADD_FOES'				=> 'افزودن دشمنان جدید',
	'ADD_FOES_EXPLAIN'		=> 'درصورتی که می خواهید چندین نام کاربری وارد کنید، هر کدام را بصورت جداگانه در یک خط بنویسید.',
	'ADD_FOLDER'			=> 'افزودن پوشه',
	'ADD_FRIENDS'			=> 'افزودن دوستان جدید',
	'ADD_FRIENDS_EXPLAIN'	=> 'درصورتی که می خواهید چندین نام کاربری وارد کنید، هر کدام را بصورت جداگانه در یک خط بنویسید.',
	'ADD_NEW_RULE'			=> 'افزودن قانون جدید',
	'ADD_RULE'				=> 'افزودن قانون',
	'ADD_TO'				=> 'افزودن [به]',
	'ADD_USERS_UCP_EXPLAIN'	=> 'در این بخش می‌توانید کاربران جدید را به گروه اضافه کنید. همچنین می‌توانید این گروه را به عنوان گروه پیش‌فرض برای کاربران انتخاب شده تعیین کنید. لطفاً هر نام کاربری را در سطری جداگانه وارد کنید.',
	'ADMIN_EMAIL'	=> 'مدیران میتوانند اطلاعات را برای من ایمیل کنند.',
	'AGREE'			=> 'من این شرایط را قبول دارم',
	'ALLOW_PM'		=> 'کاربران اجازه ارسال پیام‌های خصوصی به من را داشته باشند.',
	'ALLOW_PM_EXPLAIN'		=> 'مدیران انجمن و مدیران سایت همیشه توانایی ارسال پیام برای شما را دارند.',
	'ALREADY_ACTIVATED'		=> 'حساب شما پیش از این فعال شده بود.',
	'ATTACHMENTS_EXPLAIN'	=> 'این محل لیست پیوست‌هایی را نشان می دهد که شما در پست‌ها ضمیمه کرده اید.',
	'ATTACHMENTS_DELETED'	=> 'پیوست‌ها با موفقیت حذف شدند.',
	'ATTACHMENT_DELETED'	=> 'پیوست با موفقیت حذف شد.',
	'ATTACHMENT_LOCKED'		=> 'موضوع مورد نظر قفل شده است، نمی‌توانید فایل پیوست را حذف کنید.',
	'AUTOLOGIN_SESSION_KEYS_DELETED'	=> 'کلیدهای ورودی "مرا به خاطر بسپار" که انتخاب شده بودند با موفقیت حذف شدند.',
	'AVATAR_CATEGORY'				=> 'دسته',
	'AVATAR_DRIVER_GRAVATAR_TITLE'	=> 'گراواتار',
	'AVATAR_DRIVER_GRAVATAR_EXPLAIN'	=> 'گراواتار سرویسی جهت انتخاب آواتار کاربر از سایت مذکور است. جهت اطلاعات بیشتر سایت <a href="http://www.gravatar.com/">Gravatar</a> را مشاهده فرمائید.',
	'AVATAR_DRIVER_LOCAL_TITLE'		=> 'گالری آواتار',
	'AVATAR_DRIVER_LOCAL_EXPLAIN'	=> 'شما می‌توانید آواتار دلخواه خود را از آواتار های محلی موجود انتخاب نمایید.',
	'AVATAR_DRIVER_REMOTE_TITLE'	=> 'آواتار از راه دور',
	'AVATAR_DRIVER_REMOTE_EXPLAIN'	=> 'پیوند به تصاویر آواتار از یک وب سایت دیگر.',
	'AVATAR_DRIVER_UPLOAD_TITLE'	=> 'بارگزاری آواتار',
	'AVATAR_DRIVER_UPLOAD_EXPLAIN'	=> 'آواتار سفارشی خود را بارگزاری کنید.',
	'AVATAR_EXPLAIN'				=> 'حداکثر ابعاد; عرض: %1$s, طول: %2$s, اندازه فایل: %3$.2f کیلوبایت.',
	'AVATAR_EXPLAIN_NO_FILESIZE'	=> 'حداکثر اندازه; عرض: %1$s, طول: %2$s.',
	'AVATAR_FEATURES_DISABLED'		=> 'قابلیت آواتار کاربر در حال حاضر غیرفعال است.',
	'AVATAR_GALLERY'		=> 'گالری محلی',
	'AVATAR_GENERAL_UPLOAD_ERROR'	=> 'آواتار به %s بارگذاری نشد',
	'AVATAR_NOT_ALLOWED'	=> 'آواتار کاربر قابل مشاهده نیست، زیرا قابلیت آن غیرفعال شده است',
	'AVATAR_PAGE'			=> 'صفحه',
	'AVATAR_SELECT'			=> 'آواتار خود را انتخاب کنید.',
	'AVATAR_TYPE'			=> 'نوع آواتار',
	'AVATAR_TYPE_NOT_ALLOWED'	=> 'آواتار انتخابی شما قابل مشاهده نیست، زیرا نوع آن مجاز نمی باشد.',

	'BACK_TO_DRAFTS'		=> 'بازگشت به پیش‌نویس‌های ذخیره شده',
	'BACK_TO_LOGIN'			=> 'بازگشت به صفحه ورود',
	'BIRTHDAY'				=> 'تاریخ تولد',
	'BIRTHDAY_EXPLAIN'		=> 'لطفاً روز، ماه و سال تولد خود را انتخاب کنید.',
	'BOARD_DATE_FORMAT'		=> 'فرمت تاریخ ها',
	'BOARD_DATE_FORMAT_EXPLAIN'	=> 'برای اطلاعات بیشتر از توابع تاریخ <a href="https://www.php.net/manual/datetime.format.php">date functions</a> را مشاهده فرمایید.',
	'BOARD_LANGUAGE'		=> 'زبان',
	'BOARD_STYLE'			=> 'قالب انجمن',
	'BOARD_TIMEZONE'		=> 'موقعیت زمانی',
	'BOOKMARKS'				=> 'نشانه‌گذاری ها',
	'BOOKMARKS_EXPLAIN'		=> 'شما می‌توانید موضوعات را نشانه‌گذاری کنید تا بعدا به آن‌ها مراجعه کنید، برای پاک کردن نشانک‌ها بر رو آن‌ها علامت گذاری کرده و سپس بر روی <em>حذف نشانک‌های انتخاب شده</em> کلیک کنید.',
	'BOOKMARKS_DISABLED'	=> 'نشانه‌گذاری در این انجمن غیرفعال است.',
	'BOOKMARKS_REMOVED'		=> 'نشانک‌ها با موفقیت حذف شدند.',

	'CANNOT_EDIT_MESSAGE_TIME'	=> 'شما دیگر نمی‌توانید پیام را ویرایش یا حذف کنید.',
	'CANNOT_MOVE_TO_SAME_FOLDER'	=> 'شما نمی‌توانید پیام‌ها را به پوشه ای که قصد حذفش را دارید ارسال نمایید.',
	'CANNOT_MOVE_FROM_SPECIAL'	=> 'پیام‌ها از صندوق ارسال جابجا نمی شوند',
	'CANNOT_RENAME_FOLDER'	=> 'این پوشه تغییر نام داده نمی شود.',
	'CANNOT_REMOVE_FOLDER'	=> 'این پوشه قابل حذف نمی باشد.',
	'CHANGE_DEFAULT_GROUP'	=> 'ویرایش گروه پیش‌فرض',
	'CHANGE_PASSWORD'		=> 'تغییر گذرواژه',
	'CLICK_GOTO_FOLDER'		=> '%1$sبه پوشه“%3$s” برو%2$s',
	'CLICK_RETURN_FOLDER'	=> '%1$sبازگشت به “%3$s” پوشه%2$s',
	'CONFIRMATION'			=> 'تأییدیه عضویت',
	'CONFIRM_CHANGES'		=> 'تأیید تغییرات',
	'CONFIRM_EXPLAIN'		=> 'برای جلوگیری از هرزنامه ها لطفاً کد تأیید را وارد کنید. کد را باید در تصویر نمایش داده شده ببینید. اگر مشکل بینایی دارید و یا در خواندن کد مشکلی دارید لطفاً با %sمدیر تالار%s تماس بگیرید.',
	'VC_REFRESH'			=> 'تازه سازی کد تأیید',
	'VC_REFRESH_EXPLAIN'	=> 'اگر نمی‌توانید کد را بخوانید، می‌توانید با کلیک بر روی دکمه، کد جدیدی را درخواست کنید.',

	'CONFIRM_PASSWORD'			=> 'تأیید گذرواژه',
	'CONFIRM_PASSWORD_EXPLAIN'	=> 'فقط در صورتی که گذرواژه را در بالا تغییر داده باشید، لازم است تأیید گذرواژه را وارد کنید.',
	'COPPA_BIRTHDAY'			=> 'برای ادامه ثبت نام، لطفاً تاریخ تولد خود را به ما بگویید؟',
	'COPPA_COMPLIANCE'			=> 'تطابق COPPA',
	'COPPA_EXPLAIN'				=> 'لطفاً توجه داشته باشید که اگر کلیک کنید، حسابتان ایجاد خواهد شد. ولی تا زمانی که خانواده و یا سرپرست شما آن را تأیید نکند، حسابتان فعال نخواهد شد. جزئیات فرم درخواست شده و نحوه ارسال آن‌ها به ما به ایمیلتان ارسال شد.',
	'CREATE_FOLDER'				=> 'اضافه کردن پوشه ...',
	'CURRENT_IMAGE'				=> 'تصویر کنونی',
	'CURRENT_PASSWORD'			=> 'گذرواژه کنونی',
	'CURRENT_PASSWORD_EXPLAIN'	=> 'برای تغییر ایمیل یا نام کاربری باید گذرواژه فعلی خود را وارد کنید.',
	'CURRENT_CHANGE_PASSWORD_EXPLAIN' => 'در هنگام تغییر گذرواژه، تغییر آدرس ایمیل یا تغییر نام کاربری باید گذرواژه فعلی خود را وارد کنید.',
	'CUR_PASSWORD_EMPTY'		=> 'گذرواژه فعلی خود را وارد نکردید.',
	'CUR_PASSWORD_ERROR'		=> 'گذرواژه فعلی شما که وارد کردید اشتباه است',
	'CUSTOM_DATEFORMAT'			=> 'سفارشی ...',

	'DEFAULT_ACTION'			=> 'اقدام پیش‌فرض',
	'DEFAULT_ACTION_EXPLAIN'	=> 'اگر هیچ یک از موارد فوق قابل اجرا نباشد، این عمل آغاز خواهد شد.',
	'DEFAULT_ADD_SIG'			=> 'امضای مرا به صورت پیش‌فرض ضمیمه کن',
	'DEFAULT_BBCODE'			=> 'فعال سازی BBCode به صورت پیش‌فرض',
	'DEFAULT_NOTIFY'			=> 'به صورت پیش‌فرض من را از پاسخ‌ها مطلع کن',
	'DEFAULT_SMILIES'			=> 'شکلک‌ها را به صورت پیش‌فرض فعال کن',
	'DEFINED_RULES'				=> 'قوانین مشخص شده',
	'DELETED_TOPIC'				=> 'موضوع حذف شد.',
	'DELETE_ATTACHMENT'			=> 'حذف پیوست',
	'DELETE_ATTACHMENTS'		=> 'حذف پیوست‌ها',
	'DELETE_ATTACHMENT_CONFIRM'	=> 'آیا شما مطمئنید که می خواهید این پیوست را حذف کنید؟',
	'DELETE_ATTACHMENTS_CONFIRM'	=> 'آیا از حذف پیوست‌ها مطمئنید؟',
	'DELETE_AVATAR'				=> 'حذف تصویر',
	'DELETE_COOKIES_CONFIRM'	=> 'آیا مطمئنید همه کوکی ها پاک شوند؟ این کار باعث خروج شما از انجمن می شود و باید دوباره وارد شوید.',
	'DELETE_MARKED_PM'			=> 'حذف پیام‌های نشانه‌گذاری شده',
	'DELETE_MARKED_PM_CONFIRM'	=> 'آیا از حذف پیام‌های نشانه‌گذاری شده مطمئنید؟',
	'DELETE_OLDEST_MESSAGES'	=> 'حذف پیام‌های قدیمی',
	'DELETE_MESSAGE'			=> 'حذف پیام',
	'DELETE_MESSAGE_CONFIRM'	=> 'آیا از حذف این پیام خصوصی مطمئنید؟',
	'DELETE_MESSAGES_IN_FOLDER'	=> 'تمام پیام‌های پوشه حذف شده ها را پاک کنید.',
	'DELETE_RULE'			=> 'حذف قانون',
	'DELETE_RULE_CONFIRM'	=> 'آیا از حذف این قانون مطمئنید؟',
	'DEMOTE_SELECTED'		=> 'تنزل دادن گزینه انتخاب شده',
	'DISABLE_CENSORS'		=> 'فعال بودن سانسور کلمات',
	'DISPLAY_GALLERY'		=> 'نمایش گالری',
	'DOWNLOADS'				=> 'دریافت ها',
	'DRAFTS_DELETED'		=> 'کل پیش‌نویس‌های انتخاب شده با موفقیت حذف شدند.',
	'DRAFTS_EXPLAIN'		=> 'شما می‌توانید پیش‌نویس‌های ذخیره شده خود را مشاهده، ویرایش یا حذف کنید.',
	'DRAFT_UPDATED'			=> 'پیش‌نویس با موفقیت به روز شد.',

	'EDIT_DRAFT_EXPLAIN'	=> 'اینجا می‌توانید پیش‌نویس‌هایی که شامل پیوست (ضمیمه) یا نظرسنجی نباشند را ویرایش کنید.',
	'EMAIL_BANNED_EMAIL'	=> 'نشانی e-mail وارد شده توسط شما برای استفاده مجاز نیست.',
	'EMAIL_REMIND'			=> 'در اینجا باید ایمیل موجود در حسابتان را وارد کنید، اگر ایمیلتان را از کنترل پنل کاربر تغییر نداده اید، پس همان ایمیلی است که در هنگام عضویت آن را وارد کرده اید.',
	'EMAIL_TAKEN_EMAIL'		=> 'آدرس ایمیل وارد شده پیش از این بکار گرفته شده است.',
	'EMPTY_DRAFT'			=> 'برای ارسال تغییرات باید پیامی وارد کنید.',
	'EMPTY_DRAFT_TITLE'		=> 'باید عنوان پیش‌نویس را وارد کنید.',
	'EXPORT_AS_XML'			=> 'خارج کردن بصورت XML',
	'EXPORT_AS_CSV'			=> 'خارج کردن بصورت CSV',
	'EXPORT_AS_CSV_EXCEL'	=> 'خارج کردن بصورت CSV (اکسل)',
	'EXPORT_AS_TXT'			=> 'خارج کردن بصورت TXT',
	'EXPORT_AS_MSG'			=> 'خارج کردن بصورت MSG',
	'EXPORT_FOLDER'			=> 'خارج کردن',

	'FIELD_REQUIRED'		=> 'قسمت “%s” باید کامل شود.',
	'FIELD_TOO_SHORT'		=> array(
		1	=> 'قسمت “%1$s” بسیار کوتاه است، باید حداقل %2$d نویسه وارد کنید.',
		2	=> 'قسمت “%1$s” بسیار کوتاه است، باید حداقل %2$d نویسه وارد کنید.',
	),
	'FIELD_TOO_LONG'		=> array(
		1	=> 'قسمت “%1$s” بسیار طولانی است، می‌توانید حداکثر %2$d نویسه وارد کنید.',
		2	=> 'قسمت “%1$s” بسیار طولانی است، می‌توانید حداکثر %2$d نویسه وارد کنید.',
	),
	'FIELD_TOO_SMALL'		=> 'اندازه “%1$s” بسیار کوچک است، مقدار %2$d مورد نیاز است.',
	'FIELD_TOO_LARGE'		=> 'اندازه “%1$s” بسیار کوچک است، مقدار %2$d مورد نیاز است.',
	'FIELD_INVALID_CHARS_INVALID'	=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است.',
	'FIELD_INVALID_CHARS_NUMBERS_ONLY'		=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است ، لطفاً مقادیر عددی وارد کنید.',
	'FIELD_INVALID_CHARS_ALPHA_DOTS'		=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، فقط حروف الفبا و اعداد مورد قبول هستند.',
	'FIELD_INVALID_CHARS_ALPHA_ONLY'		=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، فقط حروف الفبا و اعداد مورد قبول هستند.',
	'FIELD_INVALID_CHARS_ALPHA_PUNCTUATION'	=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، فقط حروف الفبا یا نویسه‌های _,-. مجاز است و اولین نویسه باید یک حرف باشد.',
	'FIELD_INVALID_CHARS_ALPHA_SPACERS'		=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، فقط حروف الفبا و خط فاصله یا نویسه‌های -+_[] مجاز است.',
	'FIELD_INVALID_CHARS_ALPHA_UNDERSCORE'	=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، تنها حروف الفبا یا نویسه _ مجاز است.',
	'FIELD_INVALID_CHARS_LETTER_NUM_DOTS'	=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، تنها حروف الفبا و اعداد و نقطه مجاز است.',
	'FIELD_INVALID_CHARS_LETTER_NUM_ONLY'  	=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، فقط حروف الفبا و اعداد مجاز است.',
	'FIELD_INVALID_CHARS_LETTER_NUM_PUNCTUATION'=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، فقط حروف الفبا و اعداد یا نویسه‌های _,-. مجاز است و اولین نویسه باید یک حرف باشد.',
	'FIELD_INVALID_CHARS_LETTER_NUM_SPACERS'	=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، فقط حروف الفبا و اعداد و خط فاصله و نویسه‌های -+_[] مجاز است.',
	'FIELD_INVALID_CHARS_LETTER_NUM_UNDERSCORE'	=> 'قسمت “%s” حاوی نویسه‌های غیر مجاز است، فقط حروف الفبا و اعداد و نویسه _ مجاز است.',


	'FIELD_INVALID_DATE'	=> 'قسمت “%s” حاوی تاریخ نامعتبری است.',
	'FIELD_INVALID_URL'		=> 'قسمت “%s” شامل لینک های نامعتبر است.',
	'FIELD_INVALID_VALUE'	=> 'قسمت “%s” حاوی مقادیر نامعتبر است.',

	'FOE_MESSAGE'			=> 'پیام از طرف دشمن',
	'FOES_EXPLAIN'			=> 'دشمنان، کاربرانی هستند که به طور پیش‌فرض نادیده گرفته خواهند شد. پستهای این کاربران برای شما قابل مشاهده نخواهد بود، ولی این قاعده در مورد پیامهای خصوصی جاری نیست. توجه داشته باشید که شما نمی‌توانید مدیرهای انجمن یا مدیران سایت را وارد این لیست کنید.',
	'FOES_UPDATED'			=> 'لیست دشمنان با موفقیت به روز شد.',
	'FOLDER_ADDED'			=> 'پوشه با موفقیت اضافه شد.',
	'FOLDER_MESSAGE_STATUS'	=> array(
		1	=> '%2$d از %1$s پیام ذخیره شده ',
		2	=> '%2$d از %1$s پیام ذخیره شده',
	),
	'FOLDER_NAME_EMPTY'		=> 'باید نامی را برای این پوشه انتخاب کنید.',
	'FOLDER_NAME_EXIST'		=> 'پوشه <strong>%s</strong> در حال حاضر موجود است.',
	'FOLDER_OPTIONS'		=> 'گزینه‌های پوشه',
	'FOLDER_RENAMED'		=> 'نام پوشه با موفقیت تغییر یافت.',
	'FOLDER_REMOVED'		=> 'پوشه با موفقیت حذف شد.',
	'FOLDER_STATUS_MSG'		=> array(
		1	=> '%3$d%% از پوشه پر است (%2$d از %1$s ذخیره شده)',
		2	=> '%3$d%% از پوشه پر است (%2$d از %1$s ذخیره شده)',
	),
	'FORWARD_PM'				=> 'ارسال پیام به دیگران',
	'FORCE_PASSWORD_EXPLAIN'	=> 'برای ادامه فعالیت در تالار، باید گذرواژهتان را تغییر دهید.',
	'FRIEND_MESSAGE'			=> 'پیام از طرف دوست',
	'FRIENDS'					=> 'دوستان',
	'FRIENDS_EXPLAIN'			=> 'دوستان به شما این امکان را میدهند تا به کاربرانی که با آن‌ها بیشتر سر و کار دارید، راحت تر دسترسی پیدا کنید. اگر قالب سایت پشتیبانی کند، ممکن است پست‌های دوستان برجسته نمایش داده شوند.',
	'FRIENDS_OFFLINE'			=> 'آفلاین',
	'FRIENDS_ONLINE'			=> 'آنلاین',
	'FRIENDS_UPDATED'			=> 'لیست دوستانتان با موفقیت به‌روز رسانی شد.',
	'FULL_FOLDER_OPTION_CHANGED'	=> 'اقدامی که هنگام پر شدن پوشه انجام می شود با موفقیت تغییر کرده است.',
	'FWD_ORIGINAL_MESSAGE'		=> '-------- پیام اصلی  --------',
	'FWD_SUBJECT'				=> 'عنوان: %s',
	'FWD_DATE'					=> 'تاریخ: %s',
	'FWD_FROM'					=> 'از طرف: %s',
	'FWD_TO'					=> 'به: %s',

	'GLOBAL_ANNOUNCEMENT'		=> 'اطلاعیه سراسری',

	'GRAVATAR_AVATAR_EMAIL'		=> 'ایمیل گراوتار',
	'GRAVATAR_AVATAR_EMAIL_EXPLAIN'	=> 'لطفاً آدرس ایمیل خود را برای ثبت نام در سایت <a href="http://www.gravatar.com/">گراوتار</a> وارد نمایید.',
	'GRAVATAR_AVATAR_SIZE'		=> 'اندازه گراواتار',
	'GRAVATAR_AVATAR_SIZE_EXPLAIN'	=> 'طول و عرض گراواتار خود را مشخص کنید یا می‌توانید با خالی گذاشتن آن به صورت خودکار تعیین شود.',

	'HIDE_ONLINE'				=> 'آنلاین بودن من را مخفی کن',
	'HIDE_ONLINE_EXPLAIN'		=> 'تنظیمات اعمال شده تا زمانی که بار دیگر به تالار رجوع کنید، اعمال نخواهند شد',
	'HOLD_NEW_MESSAGES'			=> 'پیام جدیدی را قبول نکن (پیام‌های جدید تا زمانی که فضای خالی وجود نداشته باشند، برگشت خواهند خورد)',
	'HOLD_NEW_MESSAGES_SHORT'	=> 'پیام جدید برگشت خواهد خورد',

	'IF_FOLDER_FULL'			=> 'اگر پوشه پر باشد',
	'IMPORTANT_NEWS'			=> 'اطلاعیه‌های مهم',
	'INVALID_USER_BIRTHDAY'		=> 'تاریخ تولد وارد شده معتبر نیست.',
	'INVALID_CHARS_USERNAME'	=> 'نام کاربری حاوی نویسه‌های غیرمجاز است.',
	'INVALID_EMOJIS_USERNAME'	=> 'نام کاربری حاوی نویسه‌های غیر مجاز (Emoji) است.',
	'INVALID_CHARS_NEW_PASSWORD'	=> 'گذرواژه حاوی نویسه‌های درخواست شده نیست.',
	'ITEMS_REQUIRED'			=> 'پر کردن قسمت هایی که با * مشخص شده اند، الزامی است.',

	'JOIN_SELECTED'				=> 'پیوستن به انتخاب شده',

	'LANGUAGE'					=> 'زبان',
	'LINK_REMOTE_AVATAR'		=> 'پیوند از خارج سایت',
	'LINK_REMOTE_AVATAR_EXPLAIN'	=> 'پیوند تصویر آواتار مورد نظرتان را وارد کنید.',
	'LINK_REMOTE_SIZE'			=> 'اندازه آواتار',
	'LINK_REMOTE_SIZE_EXPLAIN'	=> 'طول و عرض آواتار خود را مشخص کنید یا می‌توانید با خالی گذاشتن آن به صورت خودکار تعیین شود.',
	'LOGIN_EXPLAIN_UCP'			=> 'برای دسترسی به کنترل پنل کاربر وارد شوید.',
	'LOGIN_LINK'				=> 'لینک یا ثبت نام حساب کاربری خود از طرف سایر سرویس های خارجی',
	'LOGIN_LINK_EXPLAIN'		=> 'شما در حال تلاش برای ورود به انجمن توسط سرویس های خارجی هستید که هنوز به یک حساب در این صفحه متصل نیست. لطفاً با حساب کاربری واقعی وارد شده یا حساب جدیدی ایجاد نمایید.',
	'LOGIN_LINK_MISSING_DATA'	=> 'داده‌هایی که برای پیوند دادن حساب شما با یک سرویس خارجی ضروری است، در دسترس نیستند. لطفاً مراحل ورود را دوباره طی کنید',
	'LOGIN_LINK_NO_DATA_PROVIDED'	=> 'هیچ داده ای برای پیوند دادن حساب خارجی به حساب انجمن در این صفحه ارائه نشده است. اگر همچنان با مشکل مواجه شدید، با مدیرت انجمن تماس بگیرید.',
	'LOGIN_KEY'					=> 'کلید ورود',
	'LOGIN_TIME'				=> 'زمان ورود',
	'LOGIN_REDIRECT'			=> 'شما با موفقیت وارد شدید.',
	'LOGOUT_FAILED'				=> 'از تالار خارج نشدید، زیرا درخواست با جلسه شما مطابقت ندارد. اگر این مشکل ادامه داشت، لطفاً با مدیر تماس بگیرید.',
	'LOGOUT_REDIRECT'			=> 'با موفقیت خارج شدید.',

	'MARK_IMPORTANT'			=> 'گذاشتن/برداشتن علامت گذاری به عنوان مهم',
	'MARKED_MESSAGE'			=> 'پیام نشانه‌گذاری شده',
	'MAX_FOLDER_REACHED'		=> 'بیشترین مقدار پوشه را مشخص کرده اید.',
	'MESSAGE_BY_AUTHOR'			=> 'توسط',
	'MESSAGE_COLOURS'			=> 'رنگ پیام',
	'MESSAGE_DELETED'			=> 'پیام با موفقیت حذف شد.',
	'MESSAGE_EDITED'			=> 'پیام با موفقیت ویرایش شد.',
	'MESSAGE_HISTORY'			=> 'تاریخچه پیام',
	'MESSAGE_REMOVED_FROM_OUTBOX'	=> 'این پیام توسط نویسنده اش حذف شد',
	'MESSAGE_REPORTED_MESSAGE'	=> 'پیام گزارش شده',
	'MESSAGE_SENT_ON'			=> 'در',
	'MESSAGE_STORED'			=> 'این پیام با موفقیت ارسال شد.',
	'MESSAGE_TO'				=> 'به',
	'MESSAGES_DELETED'			=> 'پیام با موفقیت حذف شد.',
	'MOVE_DELETED_MESSAGES_TO'	=> 'انتقال پیام از پوشه حذف شده به',
	'MOVE_DOWN'					=> 'انتقال به پایین',
	'MOVE_MARKED_TO_FOLDER'		=> 'انتقال علامت گذاری شده به %s',
	'MOVE_PM_ERROR'				=> array(
		1	=> 'خطایی هنگام انتقال پیام‌ها به پوشه جدید بوجود آمده است, فقط  %2$d از پیام‌ها %1$s منتقل شد.',
		2	=> 'خطایی هنگام انتقال پیام‌ها به پوشه جدید بوجود آمده است, فقط %2$d از پیام‌ها  %1$s منتقل شد.',
	),
	'MOVE_TO_FOLDER'			=> 'انتقال به پوشه',
	'MOVE_UP'					=> 'انتقال به بالا',

	'NEW_FOLDER_NAME'			=> 'نام پوشه جدید',
	'NEW_PASSWORD'				=> 'گذرواژه جدید',
	'NEW_PASSWORD_CONFIRM_EMPTY'	=> 'گذرواژه تأیید را وارد نکرده اید.',
	'NEW_PASSWORD_ERROR'		=> 'کلمه های عبور وارد شده مطابق هم نیستند.',

	'NOTIFICATIONS_MARK_ALL_READ'				=> 'نشانه‌گذاری همه اعلانات به عنوان خوانده شده',
	'NOTIFICATIONS_MARK_ALL_READ_CONFIRM'		=> 'آیا از نشانه‌گذاری همه اعلانات به عنوان خوانده شده مطمئنید؟',
	'NOTIFICATIONS_MARK_ALL_READ_SUCCESS'		=> 'همه اعلانات به عنوان خوانده شده نشانه‌گذاری شد.',
	'NOTIFICATION_GROUP_MISCELLANEOUS'			=> 'اعلانات متفرقه',
	'NOTIFICATION_GROUP_MODERATION'				=> 'اعلانات مدیران',
	'NOTIFICATION_GROUP_ADMINISTRATION'			=> 'اعلانات مدیر کل',
	'NOTIFICATION_GROUP_POSTING'				=> 'اعلانات پست کردن',
	'NOTIFICATION_METHOD_BOARD'			=> 'اعلانات',
	'NOTIFICATION_METHOD_EMAIL'			=> 'ایمیل',
	'NOTIFICATION_METHOD_JABBER'		=> 'Jabber',
	'NOTIFICATION_TYPE'					=> 'نوع اعلان',
	'NOTIFICATION_TYPE_BOOKMARK'		=> 'شخصی به موضوع نشانه‌گذاری شده توسط شما، پاسخ داده است.',
	'NOTIFICATION_TYPE_GROUP_REQUEST'	=> 'شخصی برای عضویت در گروه، درخواست داده است.',
	'NOTIFICATION_TYPE_FORUM'			=> 'شخصی به یک موضوع در انجمنی که شما عضو آن بودید، جوابی ارسال کرده است',
	'NOTIFICATION_TYPE_IN_MODERATION_QUEUE'		=> 'پست یا موضوعی در انتظار پذیرش است.',
	'NOTIFICATION_TYPE_MODERATION_QUEUE'   	=> 'موضوع یا پست شما توسط مدیری تأیید یا رد شده است.',
	'NOTIFICATION_TYPE_PM'					=> 'شما پیام خصوصی دارید.',
	'NOTIFICATION_TYPE_POST'				=> 'شخصی در موضوعی که عضو آن بودید پاسخی ارسال کرده است.',
	'NOTIFICATION_TYPE_QUOTE'				=> 'شخصی پست شما را نقل قول کرده است.',
	'NOTIFICATION_TYPE_REPORT'				=> 'شخصی پستی را گزارش داده است.',
	'NOTIFICATION_TYPE_REPORT_CLOSED'		=> 'گزارش شما توسط مدیر بسته شد',
	'NOTIFICATION_TYPE_REPORT_PM'			=> 'شخصی پیام خصوصی گزارش کرده',
	'NOTIFICATION_TYPE_REPORT_PM_CLOSED'	=> 'گزارش پیام خصوصی شما توسط مدیریت بسته شد',
	'NOTIFICATION_TYPE_TOPIC'				=> 'شخصی در انجمنی که عضو آن بودید موضوع جدید ارسال کرده است.',
	'NOTIFICATION_TYPE_ADMIN_ACTIVATE_USER'	=> 'کاربر منتظر فعال سازی',

	'NOTIFY_METHOD'				=> 'روش "اعلان"',
	'NOTIFY_METHOD_BOTH'		=> 'هر دو',
	'NOTIFY_METHOD_EMAIL'		=> 'فقط ایمیل',
	'NOTIFY_METHOD_EXPLAIN'		=> 'روشی برای ارسال پیام در این انجمن',
	'NOTIFY_METHOD_IM'			=> 'Jabber فقط',
	'NOTIFY_ON_PM'				=> 'اگر پیام خصوصی جدیدی دریافت کردم، به من اطلاع بده',
	'NOT_ADDED_FRIENDS_ANONYMOUS'	=> 'نمی‌توانید کاربری ناشناس را به لیست دوستانتان اضافه کنید.',

	'NOT_ADDED_FRIENDS_BOTS'		=> 'نمی‌توانید ربات‌ها را به لیست دوستانتان اضافه کنید.',
	'NOT_ADDED_FRIENDS_FOES'		=> 'نمی‌توانید کاربرانی را که در لیست دشمنان شما موجود هستند، به لیست دوستانتان اضافه کنید.',
	'NOT_ADDED_FRIENDS_SELF'		=> 'نمی‌توانید خودتان را به لیست دوستانتان اضافه کنید.',
	'NOT_ADDED_FOES_MOD_ADMIN'		=> 'نمی‌توانید مدیران کل و مدیران انجمن را به لیست دشمنانتان اضافه کنید.',
	'NOT_ADDED_FOES_ANONYMOUS'		=> 'نمی‌توانید کاربری ناشناس را به لیست دشمنانتان اضافه کنید.',
	'NOT_ADDED_FOES_BOTS'			=> 'نمی‌توانید ربات‌ها را به لیست دشمنانتان اضافه کنید.',
	'NOT_ADDED_FOES_FRIENDS'		=> 'نمی‌توانید کاربرانی را که در لیست دوستان شما موجود هستند، به لیست دشمنانتان اضافه کنید.',
	'NOT_ADDED_FOES_SELF'			=> 'نمی‌توانید خودتان را به لیست دشمنانتان اضافه کنید.',
	'NOT_AGREE'			=> 'این قوانین را قبول ندارم',
	'NOT_ENOUGH_SPACE_FOLDER'	=> 'پوشه مقصد “%s” به نظر میرسد که پر باشد. عملیات درخواست شده صورت نگرفت.',
	'NOT_MOVED_MESSAGES'		=> array(
		1	=> '%d پیام خصوصی درحال انتظار، دارید چون پوشه موجود پر است.',
		2	=> '%d پیام خصوصی درحال انتظار، دارید چون پوشه موجود پر است.',
	),
	'NO_ACTION_MODE'		=> 'عملیاتی برای پیام مشخص نشده است.',
	'NO_AUTHOR'				=> 'نویسنده ای برای این پیام مشخص نشده است.',
	'NO_AVATAR'				=> 'آواتار ای انتخاب نشده',
	'NO_AVATAR_CATEGORY'	=> 'هیچکدام',

	'NO_AUTH_DELETE_MESSAGE'	=> 'اجازه حذف پیام‌های خصوصی را ندارید.',
	'NO_AUTH_EDIT_MESSAGE'		=> 'اجازه ویرایش پیام‌های خصوصی را ندارید.',
	'NO_AUTH_FORWARD_MESSAGE'	=> 'اجازه ارسال پیام خصوصی به دیگران را ندارید.',
	'NO_AUTH_GROUP_MESSAGE'		=> 'اجازه فرستادن پیام خصوصی به گروه‌ها را ندارید.',
	'NO_AUTH_PROFILEINFO'		=> 'اجازه تغییر اطلاعات حساب کاربری خود را ندارید.',
	'NO_AUTH_READ_HOLD_MESSAGE'	=> 'اجازه خواندن پیام‌های خصوصی درحال انتظار را ندارید.',
	'NO_AUTH_READ_MESSAGE'		=> 'اجازه خواندن پیام‌های خصوصی را ندارید.',
	'NO_AUTH_PRINT_MESSAGE'		=> 'اجازه پرینت گرفتن از پیام خصوصی را ندارید.',
	'NO_AUTH_READ_REMOVED_MESSAGE'	=> 'نمی‌توانید این پیام را بخوانید زیرا توسط نویسنده آن حذف شده است.',
	'NO_AUTH_SEND_MESSAGE'		=> 'اجازه ارسال پیام خصوصی را ندارید.',
	'NO_AUTH_SIGNATURE'			=> 'اجازه ایجاد امضا را ندارید.',

	'NO_BCC_RECIPIENT'		=> 'هیچکدام',
	'NO_BOOKMARKS'			=> 'هیچ نشانکی ندارید',
	'NO_BOOKMARKS_SELECTED'	=> 'هیچ نشانکی را انتخاب نکرده اید.',
	'NO_EDIT_READ_MESSAGE'	=> 'پیام خصوصی قابل ویرایش نیست، زیرا در حال حاضر خوانده شده است.',
	'NO_EMAIL_USER'			=> 'اطلاعات ارسال شده ایمیل/نام کاربری یافت نشد',
	'EMAIL_NOT_UNIQUE'		=> 'ایمیل مشخص شده توسط چندین کاربر استفاده شده است. باید نام کاربری را دقیقا وارد کنید.',
	'NO_FOES'				=> 'هیچ دشمنی مشخص نشده است',
	'NO_FRIENDS'			=> 'هیچ دشمنی مشخص نشده است',
	'NO_FRIENDS_OFFLINE'	=> 'هیچ دوستی آفلاین نیست',
	'NO_FRIENDS_ONLINE'		=> 'هیچ دوستی آنلاین نیست',
	'NO_GROUP_SELECTED'		=> 'گروهی مشخص نشده است.',
	'NO_IMPORTANT_NEWS'		=> 'اطلاعیه مهمی وجود ندارد.',
	'NO_MESSAGE'			=> 'پیام خصوصی یافت نشد.',
	'NO_NEW_FOLDER_NAME'	=> 'باید پوشه جدیدی را مشخص کنید.',
	'NO_NEWER_PM'			=> 'پیام جدیدتری وجود ندارد.',
	'NO_OLDER_PM'			=> 'پیام قدیمی تری وجود ندارد.',
	'NO_PASSWORD_SUPPLIED'	=> 'بدون گذرواژه نمی‌توانید وارد شوید.',
	'NO_RECIPIENT'			=> 'گیرنده ای مشخص نشده است.',
	'NO_RESET_TOKEN'		=> 'شما برای بازنشانی گذرواژه، نشانه ای ارائه نکردید.',
	'NO_RULES_DEFINED'		=> 'قوانینی مشخص نشده است.',
	'NO_SAVED_DRAFTS'		=> 'پیش‌نویسی ذخیره نشده است.',
	'NO_TO_RECIPIENT'		=> 'هیچکدام',
	'NO_WATCHED_FORUMS'		=> 'در انجمنی عضو نیستید.',
	'NO_WATCHED_SELECTED'	=> 'موضوع و یا انجمن عضو شده‌ای را انتخاب نکرده اید.',
	'NO_WATCHED_TOPICS'		=> 'در موضوعی عضو نیستید.',

	'PASS_TYPE_ALPHA_EXPLAIN'	=> 'گذرواژه باید حداقل  %1$s، شامل حروف مختلط و اعداد باشد.',
	'PASS_TYPE_ANY_EXPLAIN'		=> 'گذرواژه باید حداقل %1$s باشد.',
	'PASS_TYPE_CASE_EXPLAIN'	=> 'گذرواژه باید حداقل  %1$s، شامل حروف مختلط باشد.',
	'PASS_TYPE_SYMBOL_EXPLAIN'	=> 'گذرواژه باید حداقل %1$s، شامل حروف مختلط، اعداد و نمادها باشد.',
	'PASSWORD'			=> 'گذرواژه',
	'PASSWORD_ACTIVATED'		=> 'گذرواژه جدیدتان فعال شد.',
	'PASSWORD_RESET'			=> 'گذرواژه شما با موفقیت بازنشانی شد.',
	'PASSWORD_RESET_LINK_SENT'	=> 'چنانچه حساب شما وجود داشته باشد، لینک بازنشانی گذرواژه به ایمیل شما ارسال میشود. اگر ایمیلی دریافت نکردید، احتمالا حساب شما اخراج یا غیرفعال شده است. یا همچنین در یک بازه زمانی کوتاه چندین بار عملیات بازنشانی گذرواژه را انجام داده اید و یا اینکه مجوز تغییر گذرواژه را ندارید. در غیر این صورت می‌توانید با مدیرت تالار تماس بگیرید و ضمنا پوشه اسپم ایمیل خود را نیز بررسی کنید.',
	'PERMISSIONS_RESTORED'		=> 'سطوح دسترسی اصلی با موفقیت بازیابی شد.',
	'PERMISSIONS_TRANSFERRED'	=> 'سطوح دسترسی از <strong>%s</strong> با موفقیت واگذار شدند، هم‌اکنون میتوانید با سطوح دسترسی این کاربر در تالار فعالیت کنید.<br />توجه داشته باشید که سطوح دسترسی مدیر منتقل نشد، در هر زمانی می‌توانید به سطوح دسترسی خودتان بازگردید.',
	'PM_DISABLED'				=> 'بخش پیام خصوصی در این تالار غیرفعال شده است.',
	'PM_FROM'			=> 'از طرف',
	'PM_FROM_REMOVED_AUTHOR'	=> 'این پیام توسط کاربری ارسال شده است که دیگر در تالار عضو نیست.',
	'PM_ICON'			=> 'آیکون پیام خصوصی',
	'PM_INBOX'			=> 'صندوق ورودی',
	'PM_MARK_ALL_READ'		=> 'علامت گذاری همه به عنوان خوانده شده',
	'PM_MARK_ALL_READ_SUCCESS'	=> 'تمامی پیام‌های داخل این پوشه به عنوان خوانده شده در نظر گرفته شد.',
	'PM_NO_USERS'		=> 'کاربر مورد نظر وجود ندارد.',
	'PM_OUTBOX'			=> 'صندوق خروجی',
	'PM_SENTBOX'		=> 'صندوق ارسال ها',
	'PM_SUBJECT'		=> 'عنوان پیام',
	'PM_TO'				=> 'ارسال به',
	'PM_TOOLS'			=> 'ابزار پیام',
	'PM_USERS_REMOVED_NO_PERMISSION'	=> 'بعضی کاربران قادر به اضافه شدن نیستند، زیرا توانایی خواندن پیام خصوصی را ندارند.',
	'PM_USERS_REMOVED_NO_PM'	=> 'بعضی کاربران اضافه نشدند، زیرا آن‌ها دریافت پیام خصوصی را غیرفعال کرده اند.',
	'POST_EDIT_PM'		=> 'ویرایش پیام',
	'POST_FORWARD_PM'	=> 'فروارد پیام',
	'POST_NEW_PM'		=> 'ایجاد پیام',
	'POST_PM_LOCKED'	=> 'بخش پیام خصوصی قفل شده است.',
	'POST_PM_POST'		=> 'نقل قول پست',
	'POST_QUOTE_PM'		=> 'نقل قول پیام',
	'POST_REPLY_PM'		=> 'پاسخ به پیام',
	'PRINT_PM'			=> 'حالت چاپ',
	'PREFERENCES_UPDATED'		=> 'تنظیمات شما با موفقیت به‌روز رسانی شد.',
	'PROFILE_INFO_NOTICE'		=> 'توجه داشته باشید که این گزینه‌ها ممکن است برای سایر کاربران قابل مشاهده باشد. درحین وارد کردن اطلاعات شخصی دقت کنید. پر کردن فیلد هایی که با * مشخص شده اند، الزامی است.',
	'PROFILE_UPDATED'			=> 'حساب کاربری شما با موفقیت به‌روز رسانی شد.',
	'PROFILE_AUTOLOGIN_KEYS'	=> 'کلید ورودی "مرا به خاطر بسپار" به صورت خودکار شما را هنگامی که در انجمن هستید در داخل نگه میدارد. هنگامیکه شما خارج میشوید کلید ورود حذف میشود. در این قسمت می‌توانید کلید های ورودی مربوط به کامپیوتری که با آن وارد انجمن شده اید را مشاهده کنید.',
	'PROFILE_NO_AUTOLOGIN_KEYS'	=> 'هیچ کلید ورودی وجود ندارد.',

	'RECIPIENT'				=> 'گیرنده',
	'RECIPIENTS'			=> 'گیرندگان',
	'REGISTRATION'			=> 'ثبت نام',
	'OAUTH_REGISTRATION'	=> 'ثبت نام توسط سرویس های خارجی',
	'RELEASE_MESSAGES'		=> '%sانتشار همه پیام‌های درحال انتظار%s… اگر فضای کافی ایجاد شود، به پوشه مربوطه منتقل خواهند شد.',
	'REMOVE_ADDRESS'		=> 'حذف آدرس',
	'REMOVE_SELECTED_BOOKMARKS'	=> 'حذف نشانه‌گذاری های انتخاب شده',
	'REMOVE_SELECTED_BOOKMARKS_CONFIRM'	=> 'آیا از حذف نشانه‌گذاری های انتخاب شده مطمئنید؟',
	'REMOVE_BOOKMARK_MARKED'	=> 'حذف نشانه‌گذاری های انتخاب شده',
	'REMOVE_FOLDER'			=> 'حذف پوشه',
	'REMOVE_FOLDER_CONFIRM'	=> 'آیا از حذف این پوشه مطمئنید؟',
	'RENAME'				=> 'تغییر نام',
	'RENAME_FOLDER'			=> 'تغییر نام پوشه',
	'REPLIED_MESSAGE'		=> 'پیام پاسخ داده شده',
	'REPLY_TO_ALL'			=> 'پاسخ به فرستنده و تمامی گیرنده ها',
	'REPORT_PM'				=> 'گزارش پیام خصوصی',
	'RESET_PASSWORD'		=> 'بازنشانی گذرواژه',
	'RESET_TOKEN_EXPIRED_OR_INVALID'	=> 'مدت زمان بازنشانی گذرواژه شما منقضی شده است.',
	'RESIGN_SELECTED'		=> 'لغو انتخاب شده ها',
	'RETURN_FOLDER'			=> '%1$sبازگشت به پوشه قبلی%2$s',
	'RETURN_UCP'			=> '%sبازگشت به کنترل پنل کاربری%s',
	'RULE_ADDED'			=> 'قانون با موفقیت اضافه شد.',
	'RULE_ALREADY_DEFINED'	=> 'این قانون قبلا مشخص شده بود.',
	'RULE_DELETED'			=> 'قانون با موفقیت حذف شد.',
	'RULE_LIMIT_REACHED'	=> 'شما بیشتر از این توانایی ساخت قانون برای پیام خصوصی ندارید، زیرا از حداکثر تعداد تعیین شده استفاده کردید.',
	'RULE_NOT_DEFINED'		=> 'قانون بدرستی مشخص نشده است.',
	'RULE_REMOVED_MESSAGES'	=> array(
		2	=> '%d پیام خصوصی به دلیل عبور از فیلتر پیام‌ها حذف شد.',
		2	=> '%d پیام خصوصی به دلیل عبور از فیلتر پیام‌ها حذف شد.',
	),

	'SAME_PASSWORD_ERROR'	=> 'گذرواژه وارد شده با گذرواژه فعلی شما یکسان می‌باشد.',
	'SEARCH_YOUR_POSTS'		=> 'نمایش پست‌های شما',
	'SENT_AT'				=> 'فرستاده شده',			// Used before dates in private messages
	'SHOW_EMAIL'			=> 'کاربران میتوانند با ایمیل با من تماس بگیرند',
	'SIGNATURE_EXPLAIN'		=> 'امضا بلوکی از متن است که در هر پست شما نمایش داده میشود، محدودیت %d نویسه وجود است.',
	'SIGNATURE_PREVIEW'		=> 'امضایتان در پست‌ها مانند این نمایش داده خواهد شد.',
	'SIGNATURE_TOO_LONG'	=> 'امضای شما بسیار طولانی است',
	'SELECT_CURRENT_TIME'	=> 'انتخاب زمان حاضر',
	'SELECT_TIMEZONE'		=> 'انتخاب زمان محلی',
	'SORT'					=> 'مرتب کردن',
	'SORT_COMMENT'			=> 'نظرات فایل',
	'SORT_DOWNLOADS'		=> 'دانلود ها',
	'SORT_EXTENSION'		=> 'پسوند',
	'SORT_FILENAME'			=> 'نام فایل',
	'SORT_POST_TIME'		=> 'زمان پست',
	'SORT_SIZE'				=> 'حجم فایل',

	'TIMEZONE'				=> 'زمان محلی',
	'TIMEZONE_DATE_SUGGESTION'	=> 'پیشنهاد: %s',
	'TIMEZONE_INVALID'		=> 'زمان محلی انتخاب شده نامعتبر است.',
	'TO'			=> 'گیرنده',
	'TO_MASS'		=> 'گیرندگان',
	'TO_ADD'		=> 'اضافه کردن گیرنده',
	'TO_ADD_MASS'	=> 'اضافه کردن گیرندگان',
	'TO_ADD_GROUPS'	=> 'اضافه کردن گروه',
	'TOO_MANY_RECIPIENTS'	=> 'شما در حال تلاش برای ارسال پیام خصوصی برای گیرنده های زیادی هستید.',
	'TOO_MANY_REGISTERS'	=> 'شما بیش از حد مجاز برای ثبت نام تلاش کردید. به دلیل مسائل امنیتی فعلا نمی‌توانید ثبت نام کنید. لطفاً بعدا دوباره تلاش کنید.',

	'UCP'			=> 'کنترل پنل کاربری',
	'UCP_ACTIVATE'	=> 'فعال سازی حساب کاربری',
	'UCP_ADMIN_ACTIVATE'	=> 'توجه داشته باشید که قبل از ثبت نام باید ایمیل معتبری را وارد کنید. مدیر حساب شما را بررسی خواهد کرد و در صورت تأیید ایمیلی به آدرس ایمیلتان ارسال خواهد شد.',
	'UCP_ATTACHMENTS'		=> 'پیوست‌ها',
	'UCP_AUTH_LINK'			=> 'حساب کاربری خارجی',
	'UCP_AUTH_LINK_ASK'		=> 'شما حساب کاربری مرتبطی با سرویس خارجی ندارید. جهت استفاده از حساب کاربری خارجی روی دکمه پایین کلیک کنید.',
	'UCP_AUTH_LINK_ID'		=> 'شناسه منحصر به فرد',
	'UCP_AUTH_LINK_LINK'	=> 'ارتباط',
	'UCP_AUTH_LINK_MANAGE'	=> 'مدیریت حساب های خارجی مرتبط',
	'UCP_AUTH_LINK_NOT_SUPPORTED'	=> 'ارتباط با حساب کاربری خارجی مربوطه میسر نمی‌باشد. زیرا انجمن از این سرویس خارجی پشتیبانی نمی کند.',
	'UCP_AUTH_LINK_TITLE'	=> 'مدیریت حساب های کاربری خارجی',
	'UCP_AUTH_LINK_UNLINK'	=> 'بدون ارتباط',
	'UCP_COPPA_BEFORE'		=> 'قبل از %s',
	'UCP_COPPA_ON_AFTER'	=> 'در یا بعد از %s',
	'UCP_EMAIL_ACTIVATE'	=> 'توجه داشته باشید که باید قبل از فعال سازی حسابتان، ایمیل معتبری را وارد کنید. لینک فعال سازی حسابتان به آدرس ایمیل وارد شده ارسال خواهد شد.',
	'UCP_JABBER'			=> 'Jabber آدرس',
	'UCP_LOGIN_LINK'		=> 'راه اندازی یک حساب کاربری خارجی',

	'UCP_MAIN'				=> 'تنظیمات کلی',
	'UCP_MAIN_ATTACHMENTS'	=> 'مدیریت پیوست‌ها',
	'UCP_MAIN_BOOKMARKS'	=> 'مدیریت نشانه‌گذاری در انجمن‌ها',
	'UCP_MAIN_DRAFTS'		=> 'مدیریت پیش‌نویس‌ها',
	'UCP_MAIN_FRONT'		=> 'صفحه اصلی',
	'UCP_MAIN_SUBSCRIBED'	=> 'مدیریت عضویت در انجمن‌ها',

	'UCP_NO_ATTACHMENTS'	=> 'فایلی را ارسال نکرده اید',

	'UCP_NOTIFICATION_LIST'	=> 'مدیریت اعلانات',
	'UCP_NOTIFICATION_LIST_EXPLAIN'	=> 'در این قسمت می‌توانید تمام اعلانات را مشاهده کنید.',
	'UCP_NOTIFICATION_OPTIONS'		=> 'تنظیمات اعلانات',
	'UCP_NOTIFICATION_OPTIONS_EXPLAIN'	=> 'در این قسمت می‌توانید تنظیمات مربوط به اعلانات را انجام دهید.',

	'UCP_PREFS'			=> 'تنظیمات تالار',
	'UCP_PREFS_PERSONAL'=> 'تنظیمات سراسری',
	'UCP_PREFS_POST'	=> 'تنظیمات ارسال پست',
	'UCP_PREFS_VIEW'	=> 'تنظیمات ظاهری',

	'UCP_PM'			=> 'پیام‌های خصوصی',
	'UCP_PM_COMPOSE'	=> 'ارسال پیام',
	'UCP_PM_DRAFTS'		=> 'پیش‌نویس‌های پیام خصوصی',
	'UCP_PM_OPTIONS'	=> 'قوانین، پوشه ها و تنظیمات',
	'UCP_PM_UNREAD'		=> 'پیام‌های خوانده نشده',
	'UCP_PM_VIEW'		=> 'مشاهده پیام‌ها',

	'UCP_PROFILE'		=> 'حساب کاربری',
	'UCP_PROFILE_AVATAR'		=> 'ویرایش آواتار',
	'UCP_PROFILE_PROFILE_INFO'	=> 'ویرایش نمایه',
	'UCP_PROFILE_REG_DETAILS'	=> 'تنظیمات حساب کاربری',
	'UCP_PROFILE_SIGNATURE'		=> 'ویرایش امضا',
	'UCP_PROFILE_AUTOLOGIN_KEYS'	=> 'مدیریت کلید ورود',

	'UCP_USERGROUPS'			=> 'گروه‌های کاربری',
	'UCP_USERGROUPS_MEMBER'		=> 'ویرایش گروه کاربری',
	'UCP_USERGROUPS_MANAGE'		=> 'مدیریت گروه‌ها',

	'UCP_PASSWORD_RESET_DISABLED'	=> 'امکان بازنشانی گذرواژه غیرفعال شده است. چنانچه مشکلی در این رابطه دارید، لطفاً با %sمدیریت%s تماس بگیرید.',
	'UCP_REGISTER_DISABLE'	=> 'ایجاد حساب کاربری جدید ممکن نیست.',
	'UCP_RESEND'			=> 'ارسال ایمیل فعال سازی',
	'UCP_WELCOME'			=> 'به کنترل پنل کاربر خوش آمدید. در اینجا می‌توانید بر نمایه، ترجیحات و عضویت هایتان در موضوعات و انجمن‌های مختلف نظارت و به‌روز رسانی کنید. همچنین می‌توانید به سایر کاربران پیام خصوصی بفرستید(اگر این بخش فعال باشد). لطفاً قبل از هر اقدامی، اطلاعیه‌های موجود را بخوانید.',
	'UCP_ZEBRA'				=> 'دوستان و دشمنان',
	'UCP_ZEBRA_FOES'		=> 'مدیریت دشمنان',
	'UCP_ZEBRA_FRIENDS'		=> 'مدیریت دوستان',
	'UNDISCLOSED_RECIPIENT'		=> 'گیرنده نامشخص',
	'UNKNOWN_FOLDER'		=> 'پوشه بی نام',
	'UNWATCH_MARKED'		=> 'لغو نشانه‌گذاری ها',
	'UPLOAD_AVATAR_FILE'	=> 'بارگزاری از سیستم شما',
	'UPLOAD_AVATAR_URL'		=> 'بارگزاری توسط آدرس',
	'UPLOAD_AVATAR_URL_EXPLAIN'		=> 'لینک عکس موجود را در اینجا وارد کنید، این عکس به طور خودکار به سایت اضافه خواهد شد.',

	'USERNAME_ALPHA_ONLY_EXPLAIN'		=> 'نام کاربری باید بین %1$s تا %2$s باشد و فقط از حروف و اعداد استفاده شود.',
	'USERNAME_ALPHA_SPACERS_EXPLAIN'	=> 'نام کاربری باید بین %1$s تا %2$s باشد و باید از حروف، اعداد، فاصله یا -+_[] استفاده شود.',
	'USERNAME_ASCII_EXPLAIN'			=> 'نام کاربری باید بین %1$s تا %2$s باشد و از نویسه‌های ASCII استفاده شود، و نه نویسه‌های ویژه .',
	'USERNAME_LETTER_NUM_EXPLAIN'		=> 'نام کاربری باید بین %1$s تا %2$s باشد و فقط از حروف و اعداد استفاده شود.',
	'USERNAME_LETTER_NUM_SPACERS_EXPLAIN'	=> 'نام کاربری باید بین %1$s تا %2$s باشد و باید از حروف، اعداد، فاصله و -+_[] استفاده شود.',
	'USERNAME_CHARS_ANY_EXPLAIN'		=> 'نام کاربری باید بین %1$s تا %2$s باشد.',
	'USERNAME_TAKEN_USERNAME'			=> 'نام کاربری انتخاب شده موجود می‌باشد، لطفاً نام کاربری دیگری انتخاب کنید.',
	'USERNAME_DISALLOWED_USERNAME'		=> 'نام کاربری وارد شده تحریم شده است و یا دارای حروف ممنوعه است. لطفاً نام کاربری دیگری را انتخاب کنید.',
	'USER_NOT_FOUND_OR_INACTIVE'		=> 'نام کاربری وارد شده موجود نمی‌باشد و یا فعال نیست.',

	'VIEW_AVATARS'		=> 'نمایش آواتار ها',
	'VIEW_EDIT'			=> 'مشاهده/ویرایش',
	'VIEW_FLASH'		=> 'نمایش انیمیشن فلش',
	'VIEW_IMAGES'		=> 'نمایش تصاویر در پست‌ها',
	'VIEW_NEXT_HISTORY'	=> 'پیام خصوصی بعدی در تاریخچه',
	'VIEW_NEXT_PM'		=> 'پیام خصوصی بعدی',
	'VIEW_PM'			=> 'مشاهده پیام',
	'VIEW_PM_INFO'		=> 'جزئیات پیام',
	'VIEW_PM_MESSAGES'	=> array(
		1	=> '%d پیام',
		2	=> '%d پیام',
	),
	'VIEW_PREVIOUS_HISTORY'	=> 'پیام خصوصی قبلی در تاریخچه',
	'VIEW_PREVIOUS_PM'		=> 'پیام خصوصی قبلی',
	'VIEW_PROFILE'			=> 'مشاهده نمایه',
	'VIEW_SIGS'				=> 'نمایش امضاها',
	'VIEW_SMILIES'			=> 'نمایش شکلک‌ها به عنوان تصویر',
	'VIEW_TOPICS_DAYS'		=> 'نمایش موضوعات از روزهای قبلی',
	'VIEW_TOPICS_DIR'		=> 'نمایش موضوعات به ترتیب',
	'VIEW_TOPICS_KEY'		=> 'نمایش موضوعات به ترتیب',
	'VIEW_POSTS_DAYS'		=> 'نمایش پست‌ها از روزها قبلی',
	'VIEW_POSTS_DIR'		=> 'نمایش ترتیب پست‌ها',
	'VIEW_POSTS_KEY'		=> 'نمایش پست‌ها به ترتیب',


	'WATCHED_EXPLAIN'		=> 'این لیستی از انجمن‌ها و موضوعاتی می‌باشد که در آن عضو شده اید. از پست‌های جدید در این انجمن‌ها با خبر خواهید شد. برای لغو عضویت بر روی موضوع و یا انجمن علامت بگذارید و سپس بر روی <em>لغو عضویت در انتخاب شده ها</em> کلیک کنید.',
	'WATCHED_FORUMS'		=> 'انجمن‌های عضو شده',
	'WATCHED_TOPICS'		=> 'موضوعات عضو شده',
	'WRONG_ACTIVATION'		=> 'کد فعال سازی وارد شده، مطابق کدهای موجود در پایگاه داده ما نیست.',

	'YOUR_DETAILS'			=> 'فعالیت های شما',
	'YOUR_FOES'				=> 'دشمنان شما',
	'YOUR_FOES_EXPLAIN'		=> 'برای حذف نام های کاربری آن‌ها را انتخاب کرده و بر روی ارسال کلیک کنید.',
	'YOUR_FRIENDS'			=> 'دوستان شما',
	'YOUR_FRIENDS_EXPLAIN'	=> 'برای حذف نام های کاربری آن‌ها را انتخاب کرده و بر روی ارسال کلیک کنید.',
	'YOUR_WARNINGS'			=> 'درجه هشدار شما',

	'PM_ACTION' => array(
		'PLACE_INTO_FOLDER'	=> 'جایگذاری در پوشه',
		'MARK_AS_READ'		=> 'علامت گذاری به عنوان خوانده شده',
		'MARK_AS_IMPORTANT'	=> 'علامت گذاری پیام',
		'DELETE_MESSAGE'	=> 'حذف پیام'
	),
	'PM_CHECK' => array(
		'SUBJECT'		=> 'عنوان',
		'SENDER'		=> 'فرستنده',
		'MESSAGE'		=> 'پیام',
		'STATUS'		=> 'وضعیت پیام',
		'TO'			=> 'ارسال شده به'
	),
	'PM_RULE' => array(
		'IS_LIKE'		=> 'می پسندد',
		'IS_NOT_LIKE'	=> 'نمی پسندد',
		'IS'			=> 'است',
		'IS_NOT'		=> 'نیست',
		'BEGINS_WITH'	=> 'شروع میشود با',
		'ENDS_WITH'		=> 'پایان می یابد با',
		'IS_FRIEND'		=> 'دوست است',
		'IS_FOE'		=> 'دشمن است',
		'IS_USER'		=> 'کاربر است',
		'IS_GROUP'		=> 'در گروه کاربری :',
		'ANSWERED'		=> 'پاسخ داده شده',
		'FORWARDED'		=> 'پاسخ داده شده به دیگران',
		'TO_GROUP'		=> 'به گروه کاربری پیش‌فرض من',
		'TO_ME'			=> 'به من'
	),

	'GROUPS_EXPLAIN'	=> 'گروه‌های کاربری به مدیران کمک میکنند تا بهتر سایت را مدیریت کنند. به صورت پیش‌فرض در گروهی جای میگیرید، این گروه پیش‌فرض شما است. این گروه‌ها نحوه نمایش شما به دیگر کاربران را مشخص میکنند. برای مثال رنگ نام کاربری، نمایه، رتبه و ... . ممکن است مدیر به کاربران این اجازه را بدهد تا گروه کاربری خود را عوض کنند. ممکن است بتوانید به گروه‌ها بپیوندید. بعضی از گروه‌ها ممکن است به کاربران عضو در آن گروه، سطوح دسترسی ویژه ای بدهند.',
	'GROUP_LEADER'		=> 'رهبری',
	'GROUP_MEMBER'		=> 'کاربری',
	'GROUP_PENDING'		=> 'اعضای معلق',
	'GROUP_NONMEMBER'	=> 'غیر عضوها',
	'GROUP_DETAILS'		=> 'جزئیات گروه',

	'NO_LEADER'			=> 'هیچ گروه رهبری موجود نیست',
	'NO_MEMBER'			=> 'هیچ گروه کاربری موجود نیست',
	'NO_PENDING'		=> 'هیچ عضوی در انتظار تأیید نیست',
	'NO_NONMEMBER'		=> 'بدون کاربران عضو نشده',
));
