<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
* @Traduzido por: http://www.phpbb-pt.com - segundo as normas do Acordo Ortográfico
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'					=> 'Traduzido por: <a href="http://www.phpbb-pt.com">phpBB Portugal</a>',
	'DIRECTION'							=> 'ltr',
	'DATE_FORMAT'						=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'					=> '|d M Y, H:i|',	// 01 Jan 2007, 13:37 (with Relative days enabled)
	'USER_LANG'							=> 'pt',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'						=> 2,

	'1_DAY'								=> '1 Dia',
	'1_MONTH'							=> '1 Mês',
	'1_YEAR'							=> '1 Ano',
	'2_WEEKS'							=> '2 Semanas',
	'3_MONTHS'							=> '3 Meses',
	'6_MONTHS'							=> '6 Meses',
	'7_DAYS'							=> '7 Dias',

	'ACCOUNT_ALREADY_ACTIVATED'			=> 'O seu registo já se encontra ativo.',
	'ACCOUNT_DEACTIVATED'				=> 'O seu registo foi desativado manualmente e apenas pode ser reativado por um Administrador.',
	'ACP'								=> 'Painel de Administração',
	'ACP_SHORT'							=> 'ACP',
	'ACTIVATION_ALREADY_SENT'		=> 'O e-mail de ativação já foi enviado para o seu endereço de e-mail. Você pode tentar novamente após 24 horas. Se você continuar tendo problemas para ativar sua conta, entre em contato com um administrador do fórum.',
	'ACTIVE'							=> 'Ativo',
	'ACTIVE_ERROR'						=> 'Especificou um Utilizador inativo. Se continuar com problemas, contacte um Administrador.',
	'ADMINISTRATOR'						=> 'Administrador',
	'ADMINISTRATORS'					=> 'Administradores',
	'AGE'								=> 'Idade',
	'AIM'								=> 'AIM',
	'AJAX_ERROR_TITLE'					=> 'Erro AJAX',
	'AJAX_ERROR_TEXT'					=> 'Algo de errado ocorreu enquanto o seu pedido era processado.',
	'AJAX_ERROR_TEXT_ABORT'				=> 'Utilizador abortou pedido.',
	'AJAX_ERROR_TEXT_TIMEOUT'			=> 'O seu pedido expirou; tente novamente.',
	'AJAX_ERROR_TEXT_PARSERERROR'		=> 'Algo de errado ocorreu com o pedido e o servidor devolveu uma resposta inválida.',
	'ALLOWED'							=> 'Permitido',
	'ALL_FILES'							=> 'Todos os Ficheiros',
	'ALL_FORUMS'						=> 'Todos os Fóruns',
	'ALL_MESSAGES'						=> 'Todas as Mensagens',
	'ALL_POSTS'							=> 'Todas as Mensagens',
	'ALL_TIMES'							=> 'O Fuso Horário do Fórum é <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'						=> 'Todos os Tópicos',
	'ALT_TEXT'							=> 'Texto alternativo',
	'AND'								=> 'E',
	'ARE_WATCHING_FORUM'				=> 'Optou por receber atualizações deste Fórum.',
	'ARE_WATCHING_TOPIC'				=> 'Optou por receber atualizações deste Tópico.',
	'ASCENDING'							=> 'Crescente',
	'ATTACHMENTS'						=> 'Anexos',
	'ATTACHED_IMAGE_NOT_IMAGE'			=> 'O Ficheiro de imagem que anexou é inválido',
	'AUTHOR'							=> 'Autor',
	'AUTH_NO_PROFILE_CREATED'			=> 'Não foi possível criar o Perfil do Utilizador.',
	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'				=> 'Este serviço externo já está associado a outra conta do fórum.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'A entrada da Base de Dados é inválida.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'O tipo de serviço enviado à rotina de tratamento de serviços "OAuth" é inválido.',
	'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'						=> 'Ocorreu um erro ao processar a solicitação OAuth.',
	'AUTH_PROVIDER_OAUTH_RETURN_ERROR'						=> 'O serviço externo retornou um valor incorreto, portanto, a sua solicitação não pode ser processada.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'O serviço OAuth não foi criado',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'OAuth token não guardados.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'OAuth token guardados incorretamente.',
	'AVATAR_DISALLOWED_CONTENT'			=> 'O envio foi recusado porque o Ficheiro foi identificado como potencialmente malicioso.',
	'AVATAR_DISALLOWED_EXTENSION'		=> 'A extensão %s não é permitida.',
	'AVATAR_EMPTY_REMOTE_DATA'			=> 'Avatar não foi enviado, por favor, tente enviar o Ficheiro manualmente.',
	'AVATAR_EMPTY_FILEUPLOAD'			=> 'O Ficheiro de Avatar enviado está vazio.',
	'AVATAR_INVALID_FILENAME'			=> '%s é um nome de Ficheiro inválido.',
	'AVATAR_NOT_UPLOADED'				=> 'O Avatar não foi enviado.',
	'AVATAR_NO_TEMP_DIR'				=> 'A pasta temporária não pôde ser encontrada ou não tem permissões de escrita.',
	'AVATAR_NO_SIZE'					=> 'Não foi possível obter a largura e a altura do Avatar, por favor, indique-os manualmente.',
	'AVATAR_NO_UPLOAD_DIR'				=> 'O caminho de armazenamento do avatar não existe ou não pode ser escrito.',
	'AVATAR_NO_UPLOAD_PATH'				=> 'O envio do avatar está ativado, mas o caminho de armazenamento do avatar não está configurado.',
	'AVATAR_PARTIAL_UPLOAD'				=> 'O Ficheiro foi parcialmente enviado.',
	'AVATAR_PHP_SIZE_NA'				=> 'O Ficheiro do Avatar é demasiado grande.<br />Não foi possível determinar o tamanho máximo definido pelo PHP no php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'			=> 'O Ficheiro do Avatar é demasiado grande, sendo o máximo permitido de envio %1$d %2$s.<br />Por favor, note que isto é definido no php.ini e não pode ser alterado.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'		=> 'O Avatar especificado não pôde ser carregado porque o pedido excedeu o tempo.',
	'AVATAR_PHP_UPLOAD_STOPPED'			=> 'Uma extensão PHP parou o upload de ficheiros.',
	'AVATAR_URL_INVALID'				=> 'A URL que especificou é inválida.',
	'AVATAR_URL_NOT_FOUND'				=> 'O Ficheiro indicado não foi encontrado.',
	'AVATAR_WRONG_FILESIZE'				=> 'O tamanho do Avatar deve estar entre 0 e %1$d %2$s.',
	'AVATAR_WRONG_SIZE'					=> 'O avatar submetido tem %5$s de largura e %6$s de altura. Avatares devem ter pelo menos %1$s de largura e %2$s de altura, e não maiores do que %3$s de largura %4$s de altura.',

	'BACK_TO_TOP'						=> 'Topo',
	'BACK_TO_PREV'						=> 'Voltar à página anterior',
	'BAN_TRIGGERED_BY_EMAIL'			=> 'O seu endereço de email foi banido do Fórum.',
	'BAN_TRIGGERED_BY_IP'				=> 'O seu endereço IP foi banido do Fórum.',
	'BAN_TRIGGERED_BY_USER'				=> 'O seu Nome de Utilizador foi banido do Fórum.',
	'BBCODE_GUIDE'						=> 'Guia BBCode',
	'BCC'								=> 'Bcc',
	'BIRTHDAYS'							=> 'Aniversariantes',
	'BOARD_BAN_PERM'					=> 'Foi expulso permanentemente deste Fórum.<br /><br />Por favor, contacte o %2$sAdministrador%3$s para mais informações.',
	'BOARD_BAN_REASON'					=> 'Razão da expulsão: %s',
	'BOARD_BAN_TIME'					=> 'Foi expulso deste Fórum até %1$s.<br /><br />Por favor, contacte o %2$sAdministrador%3$s para mais informações.',
	'BOARD_DISABLE'						=> 'Este Fórum está, de momento, indisponível.',
	'BOARD_DISABLED'					=> 'Este Fórum está atualmente desativado.',
	'BOARD_UNAVAILABLE'					=> 'Este Fórum não se encontra disponível neste momento. Por Favor, tente novamente mais tarde.',
	'BROWSING_FORUM'					=> 'Utilizadores a ver este Fórum: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Utilizadores neste fórum: %2$s e %1$d visitante',
		2	=> 'Utilizadores neste fórum: %2$s e %1$d visitantes',
	),
	'BUTTON_DELETE'						=> 'Apagar',
	'BUTTON_EDIT'						=> 'Editar',
	'BUTTON_FORUM_LOCKED'				=> 'Fórum Bloqueado',
	'BUTTON_INFORMATION'				=> 'Informação',
	'BUTTON_NEW_TOPIC'					=> 'Novo Tópico',
	'BUTTON_PM'							=> 'MP',
	'BUTTON_PM_FORWARD'					=> 'Encaminhar',
	'BUTTON_PM_NEW'						=> 'Nova MP',
	'BUTTON_PM_REPLY'					=> 'Responder MP',
	'BUTTON_PM_REPLY_ALL'				=> 'Responder a todos',
	'BUTTON_POST_REPLY'					=> 'Responder',
	'BUTTON_QUOTE'						=> 'Citar',
	'BUTTON_REPORT'						=> 'Reportar',
	'BUTTON_TOPIC_LOCKED'				=> 'Bloqueado',
	'BUTTON_WARN'						=> 'Advertir',
	'BYTES'								=> 'Bytes',
	'BYTES_SHORT'						=> 'B',

	'CANCEL'							=> 'Cancelar',
	'CHANGE'							=> 'Alterar',
	'CHANGE_FONT_SIZE'					=> 'Alterar o tamanho do tipo de letra',
	'CHANGING_PREFERENCES'				=> 'Alterando as Preferências do Fórum',
	'CHANGING_PROFILE'					=> 'Alterando as Configurações de Perfil',
	'CHARACTERS'			=> array(
		1	=> '%d carácter',
		2	=> '%d caracteres',
	),
		// Versão especial a ser usada ao descrever intervalos, por ex. "min x caracteres e max y caracteres"
	'CHARACTERS_XY'			=> array(
		1	=> '%d character',
		2	=> '%d characters',
	),
	'COLLAPSE_VIEW'						=> 'Recolher vista',
	'CLOSE_WINDOW'						=> 'Fechar Janela',
	'CODE'								=> 'Código',	
	'COLOUR_SWATCH'						=> 'Paleta de Cores',
	'COLON'								=> ':',
	'COMMA_SEPARATOR'					=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'							=> 'Confirmar',
	'CONFIRM_CODE'						=> 'Código de Confirmação',
	'CONFIRM_CODE_EXPLAIN'				=> 'As letras são maiúsculas e minúsculas. Escreva-as exatamente como aparecem.',
	'CONFIRM_CODE_WRONG'				=> 'O Código de Confirmação está incorreto.',
	'CONFIRM_OPERATION'					=> 'Deseja continuar com esta operação?',
	'CONFIRM_AVATAR_DELETE' 			=> 'Tem a certeza que deseja apagar este avatar?',
	'CONGRATULATIONS'					=> 'Parabéns a',
	'CONNECTION_FAILED'					=> 'A ligação falhou.',
	'CONNECTION_SUCCESS'				=> 'A ligação foi efetuada!',
	'CONTACT'							=> 'Contacto',
	'CONTACT_USER'						=> 'Contacto %s',
	'CONTACT_US'						=> 'Contacte-nos',
	'COOKIE_CONSENT_INFO'				=> 'Saiba mais',
	'COOKIE_CONSENT_MSG'				=> 'Este site utiliza cookies para lhe proporcionar uma melhor experiência.',
	'COOKIE_CONSENT_OK'					=> 'Entendido!',
	'COOKIE_CONSENT_HREF'				=> 'http://cookiesandyou.com',
	'COOKIES_DELETED'					=> 'Todos os cookies deste Fórum foram apagados.',
	'CURRENT_TIME'						=> 'Data/Hora: %s',

	'DAY'								=> 'Dia',
	'DAYS'								=> 'Dias',
	'DELETE'							=> 'Apagar',
	'DELETE_ALL'						=> 'Apagar Todos',
	'DELETE_COOKIES'					=> 'Apagar cookies',
	'DELETE_MARKED'						=> 'Apagar Selecionados',
	'DELETE_POST'						=> 'Apagar esta Mensagem',
	'DELIMITER'							=> 'Delimitador',
	'DESCENDING'						=> 'Decrescente',
	'DISABLED'							=> 'Desativado',
	'DISPLAY'							=> 'Mostrar',
	'DISPLAY_GUESTS'					=> 'Mostrar Visitantes',
	'DISPLAY_MESSAGES'					=> 'Mostrar mensagens anteriores',
	'DISPLAY_POSTS'						=> 'Mostrar mensagens anteriores',
	'DISPLAY_TOPICS'					=> 'Mostrar Tópicos anteriores',
	'DOMAIN_NO_MX_RECORD_EMAIL'			=> 'O domínio de email inserido não é um registro  MX válido.',
	'DOWNLOADED'						=> 'Transferido',
	'DOWNLOADING_FILE'					=> 'A Transferir ficheiro',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'Não foi transferido ainda',
		1	=> 'Transferido %d vez',
		2	=> 'Transferido %d vezes',
	),

	'EDIT_POST'							=> 'Editar esta Mensagem',
	'ELLIPSIS'							=>	'...',
	'EMAIL'								=> 'Correio eletrónico', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Email',
	'EMAIL_INVALID_EMAIL'				=> 'O endereço de email que introduziu é inválido.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Ocorreu um problema ao enviar o email na <strong>Linha %1$s</strong>. Erro: %2$s.',
	'EMPTY_SUBJECT'						=> 'Quando se envia uma mensagem, deve ser especificado um assunto.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Precisa especificar um assunto quando escrever uma nova mensagem.',
	'ENABLED'							=> 'Ativado',
	'ENCLOSURE'							=> 'Documento anexo',
	'ENTER_USERNAME'					=> 'Introduza o Utilizador',
	'ERR_CHANGING_DIRECTORY'			=> 'Não foi possível alterar a pasta.',
	'ERR_CONNECTING_SERVER'				=> 'Erro ao ligar-se ao servidor.',
	'ERR_JAB_AUTH'						=> 'Não foi autorizado a entrar no servidor Jabber.',
	'ERR_JAB_CONNECT'					=> 'Não foi possível fazer a ligação ao servidor Jabber.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Ocorreu um erro no acesso. Nome de Utilizador ou Senha incorretos.',
	'ERR_UNWATCHING'					=> 'Um erro ocorreu durante o cancelamento da subscrição.',
	'ERR_WATCHING'						=> 'Um erro ocorreu durante a subscrição.',	
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'O local do script phpBB indicado parece não ser válido.',
	'ERROR'								=> 'Erro',
	'EXPAND_VIEW'						=> 'Ver mais detalhes',
	'EXTENSION'							=> 'Extensão',
	'EXTENSION_DISABLED'				=> 'A extensão <strong>%s</strong> não está ativada.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'A extensão %s foi desativada e não pode ser exibida.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'A extensão <strong>%s</strong> não existe.',

	'FACEBOOK'							=> 'Facebook',
	'FAQ'								=> 'FAQ',
	'FAQ_EXPLAIN'						=> 'Questões Mais Frequentes',
	'FEATURE_NOT_AVAILABLE'				=> 'A funcionalidade não está disponível neste fórum.',
	'FILENAME'							=> 'Nome do Ficheiro',
	'FILESIZE'							=> 'Tamanho do Ficheiro',
	'FILEDATE'							=> 'Data do Ficheiro',
	'FILE_COMMENT'						=> 'Comentário do Ficheiro',
	'FILE_CONTENT_ERR'					=> 'Não foi possível ler o conteúdo do ficheiro: %s',
	'FILE_JSON_DECODE_ERR'				=> 'Falha ao descodificar ficheiro json: %s',
	'FILE_NOT_FOUND'					=> 'Ficheiro não encontrado: %s',
	'FIND_USERNAME'						=> 'Procurar Utilizador',
	'FOLDER'							=> 'Pasta',
	'FORGOT_PASS'						=> 'Esqueci-me da senha',
	'FORM_INVALID'						=> 'O formulário apresentado não era válido. Tente enviar novamente.',
	'FORUM'								=> 'Fórum',
	'FORUMS'							=> 'Fóruns',
	'FORUMS_MARKED'						=> 'Os Fóruns foram marcados como lidos.',
	'FORUM_CAT'							=> 'Categoria do Fórum',
	'FORUM_INDEX'						=> 'Índice do Fórum',
	'FORUM_LINK'						=> 'Endereço do Fórum',
	'FORUM_LOCATION'					=> 'Local do Fórum',
	'FORUM_LOCKED'						=> 'Fórum Bloqueado',
	'FORUM_RULES'						=> 'Regras do Fórum',
	'FORUM_RULES_LINK'					=> 'Por Favor, clique aqui para ver as regras do Fórum',
	'FROM'								=> 'de',
	'FSOCK_DISABLED'					=> 'Não foi possível concluir esta operação, porque a função <var>fsockopen</var> está desativada ou o servidor solicitado não foi encontrado.',
	'FSOCK_TIMEOUT'						=> 'O tempo limite esgotou-se durante a leitura do fluxo de rede',
	
	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'		=> 'Não foi possível alterar o grupo do arquivo',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS'	=> 'Não foi possível alterar as permissões do arquivo',
	'FILESYSTEM_CANNOT_COPY_FILES'				=> 'Não foi possível copiar os arquivos',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'			=> 'Não foi possível criar um symlink',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'		=> 'Não foi possível criar o diretório',
	'FILESYSTEM_CANNOT_DELETE_FILES'			=> 'Não foi possível excluir os arquivos do sistema',
	'FILESYSTEM_CANNOT_DUMP_FILE'				=> 'Não foi possível descarregar o arquivo',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'		=> 'Não foi possível espelhar o diretório',
	'FILESYSTEM_CANNOT_RENAME_FILE'				=> 'Não foi possível renomear um arquivo do sistema',
	'FILESYSTEM_CANNOT_TOUCH_FILES'				=> 'Não foi possível criar ou alterar o registro de data e hora do arquivo',

	'FTP_FSOCK_HOST'					=> 'Servidor FTP',
	'FTP_FSOCK_HOST_EXPLAIN'			=> 'Servidor FTP utilizada para se ligar ao seu site.',
	'FTP_FSOCK_PASSWORD'				=> 'Senha do FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'		=> 'Senha para o seu Nome de Utilizador do FTP.',
	'FTP_FSOCK_PORT'					=> 'Porta FTP',
	'FTP_FSOCK_PORT_EXPLAIN'			=> 'Porta utilizada para se ligar ao seu servidor FTP.',
	'FTP_FSOCK_ROOT_PATH'				=> 'Local do phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'		=> 'Caminho desde a raiz até ao seu Fórum phpBB.',
	'FTP_FSOCK_TIMEOUT'					=> 'Intervalo do FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'			=> 'Tempo, em segundos, que o sistema irá aguardar por uma resposta do servidor.',
	'FTP_FSOCK_USERNAME'				=> 'Nome de utilizador FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'		=> 'Nome de utilizador utilizado para se ligar ao seu servidor.',

	'FTP_HOST'							=> 'Servidor FTP',
	'FTP_HOST_EXPLAIN'					=> 'Servidor FTP utilizado para se ligar ao seu site.',
	'FTP_PASSWORD'						=> 'Senha do FTP',
	'FTP_PASSWORD_EXPLAIN'				=> 'Senha para de Utilizador do seu FTP.',
	'FTP_PORT'							=> 'Porta FTP',
	'FTP_PORT_EXPLAIN'					=> 'Porta utilizada para ligar ao seu servidor FTP.',
	'FTP_ROOT_PATH'						=> 'Local do phpBB',
	'FTP_ROOT_PATH_EXPLAIN'				=> 'Local desde a raiz até ao seu Fórum phpBB.',
	'FTP_TIMEOUT'						=> 'Intervalo FTP',
	'FTP_TIMEOUT_EXPLAIN'				=> 'Tempo, em segundos, que o sistema irá aguardar por uma resposta do seu servidor.',
	'FTP_USERNAME'						=> 'Nome do Utilizador do FTP',
	'FTP_USERNAME_EXPLAIN'				=> 'Nome de Utilizador utilizado para se conectar ao seu servidor.',

	'GENERAL_ERROR'						=> 'Erro Geral',
	'GB'								=> 'GB',
	'GIB'								=> 'GiB',
	'GO'								=> 'Avançar',
	'GOTO_FIRST_POST'					=> 'Ir para a primeira página',
	'GOTO_LAST_POST'					=> 'Ir para a última página',
	'GOTO_PAGE'							=> 'Ir para a página',
	'GROUP'								=> 'Grupo',
	'GROUPS'							=> 'Grupos',
	'GROUP_ERR_TYPE'					=> 'O tipo de grupo especificado é inapropriado.',
	'GROUP_ERR_USERNAME'				=> 'Especifique um nome para o Grupo.',
	'GROUP_ERR_USER_LONG'				=> 'O Nome do Grupo é muito grande.',
	'GUEST'								=> 'Visitante',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'Há %d visite',
		2	=> 'Há %d visitantes',
	),
	'GUEST_USERS_TOTAL'			=> array(
		1	=> '%d visitante',
		2	=> '%d visitantes',
	),
	'G_ADMINISTRATORS'					=> 'Administrador',
	'G_BOTS'							=> 'Motores de Busca',
	'G_GUESTS'							=> 'Visitantes',
	'G_REGISTERED'						=> 'Utilizadores',
	'G_REGISTERED_COPPA'				=> 'Utilizadores COPPA Registados',
	'G_GLOBAL_MODERATORS'				=> 'Moderador Global',
	'G_NEWLY_REGISTERED'				=> 'Utilizadores Registados Recentemente',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d utilizador escondido',
		2	=> '%d utilizadores escondidos',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d escondido',
		2	=> '%d escondidos',
	),
	'HIDE_GUESTS'						=> 'Visitantes invisíveis',
	'HIDE_ME'							=> 'Ocultar o meu estado nesta sessão',
	'HOURS'								=> 'Horas',
	'HOME'								=> 'Página Principal',

	'ICQ'								=> 'ICQ',
	'IF'								=> 'Se',
	'IMAGE'								=> 'Imagem',
	'IMAGE_FILETYPE_INVALID'			=> 'O formato de imagem %d não é suportado para a miniatura %s.',
	'IMAGE_FILETYPE_MISMATCH'			=> 'Tipo de Ficheiro da imagem em desacordo: extensão esperada %1$s mas a extensão informada foi %2$s.',
	'IN'								=> 'em',
	'INACTIVE'							=> 'Inativo',
	'INDEX'								=> 'Índice',
	'INFORMATION'						=> 'Detalhes da mensagem',
	'INSECURE_REDIRECT'					=> 'Tentativa de redirecionamento para url potencialmente insegura.',
	'INTERESTS'							=> 'Interesses',
	'INVALID_DIGEST_CHALLENGE'			=> 'Desafio de Sumário Inválido.',
	'INVALID_EMAIL_LOG'					=> '%s é um endereço de email possivelmente incorreto?',
	'INVALID_FEED_ATTACHMENTS'			=> 'O Feed selecionado tentou processar anexos com restrições inválidas.',
	'INVALID_PLURAL_RULE'				=> 'A regra do plural escolhida é inválida. Os valores válidos são números inteiros entre 0 e 15.',
	'IP'								=> 'IP',
	'IP_BLACKLISTED'					=> 'O Seu endereço de IP %1$s foi expulso porque está na lista negra. Para mais detalhes leia <a href="%2$s">%2$s</a>.',

	'JABBER'							=> 'Jabber',
	'JOINED'							=> 'Registado',
	'JUMP_PAGE'							=> 'Número da página para onde deseja ir.',
	'JUMP_TO'							=> 'Ir para',
	'JUMP_TO_PAGE'						=> 'Ir para a página.',
	'JUMP_TO_PAGE_CLICK'				=> 'Clique para ir para a página…',

	'KB'								=> 'KB',
	'KIB'								=> 'KiB',

	'LAST_POST'							=> 'Última Mensagem',
	'LAST_UPDATED'						=> 'Última Atualização',
	'LAST_VISIT'						=> 'Última visita',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Extensão LDAP não disponível.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Não foi possível ligar-se ao servidor LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Ocorreu um erro durante a pesquisa na pasta LDAP.',
	'LEGEND'							=> 'Legenda',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'Não são permitidas pesquisas ativas.',
	'LOADING'							=> 'Carregando',
	'LOCATION'							=> 'Localização',
	'LOCK_POST'							=> 'Bloquear Mensagem',
	'LOCK_POST_EXPLAIN'					=> 'Edição Prévia',
	'LOCK_TOPIC'						=> 'Bloquear Tópico',
	'LOGIN'								=> 'Ligue-se',
	'LOGIN_CHECK_PM'					=> 'Ver Mensagens Privadas.',
	'LOGIN_CONFIRMATION'				=> 'Confirmação de acesso',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Para prevenir ataques "brute force" o Administrador exige o código de confirmação após sucessivas tentativas falhadas de acesso. O código é exibido na imagem abaixo. Se tiver problemas em ver esta imagem, por favor, contacte um %sAdministrador%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Excedeu o número máximo de tentativas de acesso. Além do seu nome de Utilizador e Senha tem de resolver o CAPTCHA ',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Não foi autenticado pelo Apache.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'O serviço OAuth inexistente foi solicitado.',
	'LOGIN_ERROR_PASSWORD'				=> 'A Senha introduzida não está correta, tente novamente. Se continuar com problemas, contacte um %sAdministrador do Fórum%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Não foi possível converter a sua Senha ao atualizar este Fórum. Por favor peça uma %snova senha%s. Se continuar com problemas, contacte um %sAdministrador do Fórum%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Especificou um nome de Utilizador incorreto. Confirme o seu nome de Utilizador e tente novamente. Se continuar com problemas, por favor, contacte um %sAdministrador do Fórum%s.',
	'LOGIN_FORUM'						=> 'Para ver ou enviar mensagens neste Fórum deve inserir a Senha.',
	'LOGIN_INFO'						=> 'O acesso completo ao Fórum necessita dum Registo que demora apenas alguns segundos. Antes de se Registar leia: FAQ - Condições de Utilização - Política de Privacidade Respeite as regras do Fórum.',
	'LOGIN_VIEWFORUM'					=> 'Para ver o conteúdo completo deste Fórum é necessário estar ligado.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Para editar Mensagens neste Fórum tem de estar registado e ligado.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Para aparecer na lista tem de estar registado e ligado.',
	'LOGIN_REQUIRED'					=> 'Tem que ligar-se para realizar esta ação.',
	'LOGOUT'							=> 'Desligar Sessão',
	'LOGOUT_USER'						=> 'Sair [ %s ]',
	'LOG_ME_IN'							=> 'Lembrar-me',

	'MAIN'								=> 'Principal',	
	'MARK'								=> 'Marcar',
	'MARK_ALL'							=> 'Marcar Todos',
	'MARK_ALL_READ'						=> 'Marcar todos como lidos',
	'MARK_FORUMS_READ'					=> 'Marcar todos os Fóruns como lidos',
	'MARK_READ'							=> 'Marcar como lido',
	'MARK_SUBFORUMS_READ'				=> 'Marcar todos os sub-fóruns como lidos',
	'MB'								=> 'MB',
	'MIB'								=> 'MiB',
	'MCP'								=> 'Painel de Moderação',
	'MCP_SHORT'							=> 'MCP',
	'MEMBERLIST'						=> 'Utilizadores',
	'MEMBERLIST_EXPLAIN'				=> 'Ver a lista completa de Utilizadores',
	'MERGE'								=> 'Fundir',
	'MERGE_POSTS'						=> 'Mover Mensagens',
	'MERGE_TOPIC'						=> 'Fundir Tópicos',
	'MESSAGE'							=> 'Mensagem',
	'MESSAGES'							=> 'Mensagens',
	'MESSAGES_COUNT'		=> array(
		0	=> 'mensagens ilimitadas',
		1	=> '%d mensagem',
		2	=> '%d mensagens',
	),
	'MESSAGE_BODY'						=> 'Corpo da Mensagem',
	'MINUTES'							=> 'Minutos',
	'MODERATE'							=> 'Moderado',
	'MODERATOR'							=> 'Moderador',
	'MODERATORS'						=> 'Moderadores',
	'MODULE_NOT_ACCESS'					=> 'Módulo não está acessível',
	'MODULE_NOT_FIND'					=> 'Não foi possível encontrar módulo %s',
	'MODULE_FILE_INCORRECT_CLASS'		=> 'O ficheiro do módulo %s não contém a classe correta [%s]',
	'MONTH'								=> 'Mês',
	'MOVE'								=> 'Mover',

	'NA'								=> 'N/A',
	'NEWEST_USER'						=> '%s é o(a) nosso(a) Utilizador(a) mais recente. Bem-vindo(a) ao Fórum',
	'NEW_MESSAGE'						=> 'Nova Mensagem',
	'NEW_MESSAGES'						=> 'Novas Mensagens',
	'NEW_POST'							=> 'Nova Mensagem',   // Not used anymore
	'NEW_POSTS'							=> 'Novas Mensagens',   // Not used anymore
	'NEXT'								=> 'Próximo',	  // Used in pagination
	'NEXT_STEP'							=> 'Próximo',
	'NEVER'								=> 'Nunca',
	'NO'								=> 'Não',
	'NO_NOTIFICATIONS'					=> 'Não tem notificações',
	'NOT_ALLOWED_MANAGE_GROUP'			=> 'Não está autorizado a administrar este grupo do “Painel de Administração”.',
	'NOT_AUTHORISED'					=> 'Não está autorizado a aceder esta área.',
	'NOT_WATCHING_FORUM'				=> 'Já não se encontra a receber atualizações deste Fórum.',
	'NOT_WATCHING_TOPIC'				=> 'Já não se encontra a receber atualizações deste Tópico.',
	'NOTIFICATIONS'						=> 'Notificações',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Resposta</strong> de %1$s no Tópico em observação:',
	),
	'NOTIFICATION_FORUM'				=> '<em>Fórum:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>Pedido de adesão</strong> de %1$s ao Grupo %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>Pedido de adesão aprovado</strong> ao Grupo %1$s.',
	'NOTIFICATION_METHOD_INVALID'		=> 'O método "%s" não se refere a um método de notificação válido.',
	'NOTIFICATION_PM'					=> '<strong>Mensagem Privada</strong> de %1$s:',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Resposta</strong> de %1$s ao Tópico:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Mensagem aprovada</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Mensagem não aprovada</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>Aprovação de Mensagem</strong> pedida por %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Citação</strong> de %1$s em:',
	),
	'NOTIFICATION_REFERENCE'			=> '"%1$s"',
	'NOTIFICATION_REASON'				=> '<em>Razão:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>Mensagem Privada denunciada</strong> por %1$s:',
	'NOTIFICATION_REPORT_PM_CLOSED'		=> '<strong>Denúncia de mensagem privada fechada</strong> por %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>Mensagem denunciada</strong> por %1$s:',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>Denúncia fechada</strong> por %1$s para:',
	'NOTIFICATION_TOPIC'				=> '<strong>Novo Tópico</strong> de %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Tópico aprovado</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Tópico não aprovado</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>Aprovação do Tópico</strong> pedida por %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'A notificação do tipo "%s" falta no sistema de ficheiros.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Aprovação necessária</strong> do Utilizador Registado Recentemente: “%1$s”',
	// Used in conjunction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'outros',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d outros',
	),
	'NOTIFY_ADMIN'						=> 'Por favor, notifique o Administrador ou webmaster deste Fórum.',
	'NOTIFY_ADMIN_EMAIL'				=> 'Por favor, notifique o Administrador ou webmaster deste Fórum: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'				=> 'Não está autorizado a aceder este Ficheiro.',
	'NO_ACTION'							=> 'Nenhuma ação especificada.',
	'NO_ADMINISTRATORS'					=> 'Este Fórum não tem Administradores.',
	'NO_AUTH_ADMIN'						=> 'Não tem permissões de Administrador, logo não pode aceder ao Painel de Administração.',
	'NO_AUTH_ADMIN_USER_DIFFER'			=> 'Não pode autenticar-se novamente com outro nome de utilizador.',
	'NO_AUTH_OPERATION'					=> 'Não tem as permissões necessárias para completar esta operação.',
	'NO_AVATARS'						=> 'Atualmente não há avatares disponíveis',
	'NO_CONNECT_TO_SMTP_HOST'			=> 'Não foi possível ligar ao servidor SMTP : %s : %s',
	'NO_BIRTHDAYS'						=> 'Hoje não há aniversariantes',
	'NO_EMAIL_MESSAGE'					=> 'Mensagem do email estava em branco.',
	'NO_EMAIL_RESPONSE_CODE'			=> 'Não foi possível receber os códigos de erro do servidor de email.',
	'NO_EMAIL_SUBJECT'					=> 'Não foi definido um assunto para este email',
	'NO_FORUM'							=> 'O Fórum selecionado não existe.',
	'NO_FORUMS'							=> 'Este Fórum não tem Tópicos.',
	'NO_GROUP'							=> 'Este Grupo não existe.',
	'NO_GROUP_MEMBERS'					=> 'Este Grupo não tem Utilizadores.',
	'NO_IPS_DEFINED'					=> 'Nenhum endereço de IP ou nome de Servidor definido',
	'NO_MEMBERS'						=> 'Nenhum Utilizador foi encontrado com estes critérios de pesquisa.',
	'NO_MESSAGES'						=> 'Sem Mensagens',
	'NO_MODE'							=> 'Nenhum modo foi especificado.',
	'NO_MODERATORS'						=> 'Este Fórum não tem Moderadores.',
	'NO_NEW_MESSAGES'					=> 'Sem novas mensagens',
	'NO_NEW_POSTS'						=> 'Sem mensagens novas',   // Not used anymore
	'NO_ONLINE_USERS'					=> 'Nenhum utilizador registado',
	'NO_POSTS'							=> 'Nenhuma mensagem',
	'NO_POSTS_TIME_FRAME'				=> 'Não existem mensagens neste Tópico no prazo selecionado.',
	'NO_FEED_ENABLED'					=> 'Os Feeds não estão disponíveis neste Fórum.',
	'NO_FEED'							=> 'O Feed solicitado não está disponível.',
	'NO_STYLE_DATA'						=> 'Não foi possível obter os dados de estilo para o user_style %s e definido para user_id %s',
	'NO_STYLE_CFG'						=> 'Não foi possível obter o arquivo de configuração de estilo para: %s',
	'NO_SUBJECT'						=> 'Sem assunto.',
	'NO_SUCH_SEARCH_MODULE'				=> 'A Pesquisa especificada não existe.',
	'NO_SUPPORTED_AUTH_METHODS'			=> 'Nenhum método de autenticação suportado.',
	'NO_TOPIC'							=> 'Este Tópico não existe.',
	'NO_TOPIC_FORUM'					=> 'Este Tópico ou Fórum não existem.',
	'NO_TOPICS'							=> 'Não há mensagens ou Tópicos neste Fórum.',
	'NO_TOPICS_TIME_FRAME'				=> 'Não há Tópicos neste Fórum no prazo selecionado.',
	'NO_UNREAD_POSTS'					=> 'Não há novas mensagens',
	'NO_UPLOAD_FORM_FOUND'				=> 'O envio do ficheiro foi iniciado, mas nenhuma forma de envio válida foi encontrada.',
	'NO_USER'							=> 'Este Utilizador não existe.',
	'NO_USERS'							=> 'Estes Utilizadores não existem.',
	'NO_USER_SPECIFIED'					=> 'Nenhum nome de Utilizador foi especificado.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d anexo',
		2	=> '%d anexos',
	),
	'NUM_POSTS_IN_QUEUE'				=> array(
		0								=> 'Nenhuma mensagem na lista',		// 0
		1								=> '1 mensagem na lista',		// 1
		2								=> '%d mensagens na lista',		// 2+
	),

	'OCCUPATION'							=> 'Ocupação',
	'OFFLINE'							=> 'Desligado',
	'ONLINE'							=> 'Ligado',
	'ONLINE_BUDDIES'					=> 'Amigos ligados',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'No total, há <strong>%1$d</strong> utilizador ligado :: %2$s 1 %3$s',
		2	=> 'No total, há <strong>%1$d</strong> utilizadores ligados :: %2$s e %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'No total, há <strong>%1$d</strong> utilizador ligado :: %2$s, %3$s e %4$s',
		2	=> 'No total, há <strong>%1$d</strong> utilizadores ligados :: %2$s, %3$s e %4$s',
	),
	'OPTIONS'					=> 'Opções',

	'PAGE_NOT_FOUND'		=> 'A página solicitada não foi encontrada.',
	'PAGE_OF'				=> 'Página <strong>%1$d</strong> de <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Página %s',
	'PASSWORD'				=> 'Senha',
	'PIXEL'					=> 'px',
	'PIXELS'				=> array(
		1	=> '%d píxel',
		2	=> '%d píxeis',
	),
	'PLEASE_WAIT'						=> 'Por favor, aguarde.',
	'PM'								=> 'MP',
	'PM_REPORTED'						=> 'Clique para ver relatório',
	'POSTING_MESSAGE'					=> 'Enviar mensagem para %s',
	'POSTING_PRIVATE_MESSAGE'			=> 'Escrevendo Mensagem Privada',
	'POST'								=> 'Mensagem',
	'POST_ANNOUNCEMENT'					=> 'Anúncio',
	'POST_STICKY'						=> 'Fixo',
	'POSTED'							=> 'Enviado',
	'POSTED_IN_FORUM'					=> 'no',
	'POSTED_ON_DATE'					=> 'em',
	'POSTS'								=> 'Mensagens',
	'POSTS_UNAPPROVED'					=> 'Pelo menos uma mensagem neste Tópico não foi aprovada.',
	'POSTS_UNAPPROVED_FORUM'			=> 'Pelo menos uma mensagem neste fórum não foi aprovada.',
	'POST_BY_AUTHOR'					=> 'por',
	'POST_BY_FOE'						=> '<strong>%1$s</strong>, que atualmente está em sua lista de ignorados, fez esta mensagem.',
	'POST_DISPLAY'						=> 'Mostrar esta mensagem',
	'POST_DAY'							=> '%.2f mensagens por dia',
	'POST_DELETED_ACTION'				=> 'Mensagem apagada:',
	'POST_DELETED'						=> 'Esta mensagem foi apagada.',
	'POST_DELETED_BY'					=> '<strong>%2$s</strong> excluiu a mensagem por <strong>%1$s</strong> em %3$s.',
	'POST_DELETED_BY_REASON'			=> '<strong>%2$s</strong> excluiu a mensagem por <strong>%1$s</strong> em %3$s pela seguinte razão: %4$s',
	'POST_DETAILS'						=> 'Detalhes da mensagem',
	'POST_NEW_TOPIC'					=> 'Criar Novo Tópico',
	'POST_PCT'							=> '%.2f%% de todas as mensagens',
	'POST_PCT_ACTIVE'					=> '%.2f%% das mensagens dos Utilizadores',
	'POST_PCT_ACTIVE_OWN'				=> '%.2f%% das suas mensagens',
	'POST_REPLY'						=> 'Responder',
	'POST_REPORTED'						=> 'Clique aqui para ver as denúncias',
	'POST_SUBJECT'						=> 'Assunto da Mensagem',
	'POST_TIME'							=> 'Data da Mensagem',
	'POST_TOPIC'						=> 'Criar um novo Tópico',
	'POST_UNAPPROVED_ACTION'			=> 'Mensagem a aguardar aprovação:',
	'POST_UNAPPROVED'					=> 'Esta mensagem não foi aprovada.',
	'POST_UNAPPROVED_EXPLAIN'			=> 'Esta mensagem não é visível para outros usuários até que tenha sido aprovada por um moderador.',
	'POWERED_BY'						=> 'Desenvolvido por %s',
	
	'QUOTE'								=> 'Citar',
	
	'PREVIEW'							=> 'Prever',
	'PREVIOUS'							=> 'Anterior',	  // Used in pagination
	'PREVIOUS_STEP'						=> 'Anterior',
	'PRIVACY'							=> 'Política de Privacidade',
	'PRIVACY_LINK'						=> 'Privacidade',
	'PRIVATE_MESSAGE'					=> 'Mensagem Privada',
	'PRIVATE_MESSAGES'					=> 'Mensagens Privadas',
	'PRIVATE_MESSAGING'					=> 'A enviar Mensagem Privada',
	'PROFILE'							=> 'Painel de Controlo do Utilizador',

	'QUICK_LINKS'						=> 'Links rápidos',

	'RANK'								=> 'Classificação',
	'READING_FORUM'						=> 'Ver Tópicos em %s',
	'READING_GLOBAL_ANNOUNCE'			=> 'A ler Anúncio Global',
	'READING_LINK'						=> 'Seguinte endereço do Fórum %s',
	'READING_TOPIC'						=> 'A ler Tópico em %s',
	'READ_PROFILE'						=> 'Perfil',
	'REASON'							=> 'Razão',
	'RECORD_ONLINE_USERS'				=> 'O recorde de utilizadores online foi de %1$s em %2$s',
	'REDIRECT'							=> 'Redirecionar',
	'REDIRECTS'							=> 'Total de redirecionamentos',
	'REGISTER'							=> 'Registe-se',
	'REGISTERED_USERS'					=> 'Membros ligados:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'Há %1$d utilizador registado e %2$s ligado',
		2	=> 'Há %1$d utilizadores registados e %2$s ligados',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d registado',
		2	=> '%d registados',
	),
	'REMOVE'							=> 'Remover',
	'REMOVE_INSTALL'					=> 'Apague, mova ou renomeie a pasta de instalação.',
	'REPLIES'							=> 'Respostas',
	'REPLY_WITH_QUOTE'					=> 'Responder citando esta mensagem',
	'REPLYING_GLOBAL_ANNOUNCE'			=> 'A responder a Anúncio Global',
	'REPLYING_MESSAGE'					=> 'A responder a mensagem em %s',
	'REPORT_BY'							=> 'Denunciada por',
	'REPORT_POST'						=> 'Denunciar esta mensagem',
	'REPORTING_POST'					=> 'A denunciar Mensagem',
	'RESEND_ACTIVATION'					=> 'Reenviar email de Ativação',
	'RESET'								=> 'Reiniciar',
	'RESTORE_PERMISSIONS'				=> 'Restaurar Permissões',
	'RETURN_INDEX'						=> 'Clique %saqui%s para voltar ao Índice',
	'RETURN_FORUM'						=> 'Clique %saqui%s para voltar ao Fórum',
	'RETURN_PAGE'						=> 'Clique %saqui%s para voltar à página anterior',
	'RETURN_TOPIC'						=> 'Clique %saqui%s para voltar ao Tópico',
	'RETURN_TO'							=> 'Voltar para “%s”',
	'RETURN_TO_INDEX'					=> 'Regressar ao índice do fórum',
	
	'ROUTE_NOT_FOUND'				=> 'A rota solicitada “%s” não foi encontrada.',
	'ROUTE_INVALID_MISSING_PARAMS'	=> 'Parâmetros inválidos ou ausentes foram passados ​​para a rota “%s”.',
	
	'FEED'								=> 'Feed',
	'FEED_NEWS'							=> 'Novidades',
	'FEED_TOPICS_ACTIVE'				=> 'Tópicos ativos',
	'FEED_TOPICS_NEW'					=> 'Novos Tópicos',
	'RULES_ATTACH_CAN'					=> 'Enviar anexos: Permitido',
	'RULES_ATTACH_CANNOT'				=> 'Enviar anexos: Proibido',
	'RULES_DELETE_CAN'					=> 'Apagar Mensagens: Permitido',
	'RULES_DELETE_CANNOT'				=> 'Apagar Mensagens: Proibido',
	'RULES_DOWNLOAD_CAN'				=> 'Transferir anexos: Permitido',
	'RULES_DOWNLOAD_CANNOT'				=> 'Transferir anexos: Proibido',
	'RULES_EDIT_CAN'					=> 'Editar Mensagens: Permitido',
	'RULES_EDIT_CANNOT'					=> 'Editar Mensagens: Proibido',
	'RULES_LOCK_CAN'					=> 'Bloquear Tópicos: Permitido',
	'RULES_LOCK_CANNOT'					=> 'Bloquear Tópicos: Proibido',
	'RULES_POST_CAN'					=> 'Criar Tópicos: Permitido',
	'RULES_POST_CANNOT'					=> 'Criar Tópicos: Proibido',
	'RULES_REPLY_CAN'					=> 'Responder Tópicos: Permitido',
	'RULES_REPLY_CANNOT'				=> 'Responder Tópicos: Proibido',
	'RULES_VOTE_CAN'					=> 'Votar em votações: Permitido',
	'RULES_VOTE_CANNOT'					=> 'Votar em votações: Proibido',

	'SEARCH'							=> 'Pesquisar',
	'SEARCH_MINI'						=> 'Pesquisar…',
	'SEARCH_ADV'						=> 'Pesquisa avançada',
	'SEARCH_ADV_EXPLAIN'				=> 'Ver opções avançadas de pesquisa',
	'SEARCH_KEYWORDS'					=> 'Palavra-Chave',
	'SEARCHING_FORUMS'					=> 'Pesquisando nos Fóruns',
	'SEARCH_ACTIVE_TOPICS'				=> 'Tópicos ativos',
	'SEARCH_FOR'						=> 'Pesquisar por',
	'SEARCH_FORUM'						=> 'Neste Fórum…',
	'SEARCH_NEW'						=> 'Mensagens novas',
	'SEARCH_POSTS_BY'					=> 'Pesquisar mensagens por',
	'SEARCH_SELF'						=> 'As minhas Mensagens',
	'SEARCH_TOPIC'						=> 'Pesquisar neste Tópico…',
	'SEARCH_UNANSWERED'					=> 'Tópicos sem resposta',
	'SEARCH_UNREAD'						=> 'Mensagens por ler',
	'SEARCH_USER_POSTS'					=> 'Pesquisar mensagens dos utilizadores',
	'SECONDS'							=> 'Segundos',
	'SEE_ALL'							=> 'Ver todos',
	'SELECT'							=> 'Selecionar',
	'SELECT_ALL_CODE'					=> 'Selecionar todos',
	'SELECT_DESTINATION_FORUM'			=> 'Selecione o Fórum de destino',
	'SELECT_FORUM'						=> 'Selecione o Fórum',
	'SEND_EMAIL'						=> 'Enviar email',				// Used for submit buttons
	'SEND_EMAIL_USER'					=> 'Enviar email para %s',
	'SEND_PRIVATE_MESSAGE'				=> 'Enviar Mensagem Privada',
	'SETTINGS'							=> 'Configurações',
	'SIGNATURE'							=> 'Assinatura',
	'SKIP'								=> 'Ir para o conteúdo',
	'SKYPE'								=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'				=> 'O Servidor SMTP não suporta autenticação.',
	'SORRY_AUTH_READ'					=> 'Não está autorizado a ver este Fórum.',
	'SORRY_AUTH_READ_TOPIC'				=> 'Não está autorizado a ler este Tópico.',
	'SORRY_AUTH_VIEW_ATTACH'			=> 'Não está autorizado a transferir este anexo.',
	'SORT_BY'							=> 'Ordenar por',
	'SORT_DIRECTION'					=> 'Direção',
	'SORT_JOINED'						=> 'Data de Registo',
	'SORT_LOCATION'						=> 'Localização',
	'SORT_OPTIONS'						=> 'Opções de visualização e ordenação',
	'SORT_RANK'							=> 'Classificação',
	'SORT_POSTS'						=> 'Mensagens',
	'SORT_TOPIC_TITLE'					=> 'Título do Tópico',
	'SORT_USERNAME'						=> 'Utilizador',
	'SPLIT_TOPIC'						=> 'Dividir Tópico',
	'SQL_ERROR_OCCURRED'				=> 'Ocorreu um erro SQL enquanto esta página era processada. Contacte um %sAdministrador do Fórum%s se o problema persistir',
	'STATISTICS'						=> 'Estatísticas do Fórum:',
	'START_WATCHING_FORUM'				=> 'Observar Fórum',
	'START_WATCHING_TOPIC'				=> 'Observar Tópico',
	'STOP_WATCHING_FORUM'				=> 'Parar de Observar Fórum',
	'STOP_WATCHING_TOPIC'				=> 'Parar de Observar Tópico',
	'STRING_LIST_MULTI'					=> '%1$s, e %2$s',
	'STRING_LIST_SIMPLE'				=> '%1$s e %2$s',
	'SUBFORUM'							=> 'Sub-fórum',
	'SUBFORUMS'							=> 'Sub-fóruns',
	'SUBJECT'							=> 'Assunto',
	'SUBMIT'							=> 'Enviar',

	'TB'								=> 'TB',
	'TERMS_LINK'						=> 'Termos',
	'TERMS_USE'							=> 'Condições de utilização',
	'TEST_CONNECTION'					=> 'Testar Ligação',
	'THE_TEAM'							=> 'Equipa',
	'TIB'								=> 'TiB',
	'TIME'								=> 'Data',
	'TIMEOUT_PROCESSING_REQ'			=> 'O pedido excedeu o tempo.',

	'TOO_LARGE'							=> 'O valor que inseriu é muito grande.',
	'TOO_LARGE_MAX_RECIPIENTS'			=> 'O valor definido para o <strong>número máximo de destinatários permitidos por Mensagem Privada</strong> é muito grande.',

	'TOO_LONG'							=> 'O valor definido é muito longo.',

	'TOO_LONG_CONFIRM_CODE'				=> 'O código de confirmação indicado é muito longo.',
	'TOO_LONG_DATEFORMAT'				=> 'O formato da data indicada é muito longa.',
	'TOO_LONG_JABBER'					=> 'A nome da conta Jabber indicada é muito longa.',
	'TOO_LONG_NEW_PASSWORD'				=> 'A Senha indicada é muito longa.',
	'TOO_LONG_PASSWORD_CONFIRM'			=> 'A confirmação da Senha indicada é muito longa.',
	'TOO_LONG_USER_PASSWORD'			=> 'A Senha é muito longa.',
	'TOO_LONG_USERNAME'					=> 'O nome de Utilizador indicado é muito longo.',
	'TOO_LONG_EMAIL'					=> 'O endereço de email indicado é muito longo.',

	'TOO_MANY_VOTE_OPTIONS'				=> 'Escolheu muitas opções.',

	'TOO_SHORT'							=> 'O valor definido é muito curto.',

	'TOO_SHORT_CONFIRM_CODE'			=> 'O Código de Confirmação indicado é muito curto.',
	'TOO_SHORT_DATEFORMAT'				=> 'O formato da data indicada é muito curta.',
	'TOO_SHORT_JABBER'					=> 'O nome da conta Jabber indicado é muito curto.',
	'TOO_SHORT_NEW_PASSWORD'			=> 'A senha é muito curta.',
	'TOO_SHORT_PASSWORD_CONFIRM'		=> 'A confirmação da senha é muito curta.',
	'TOO_SHORT_USER_PASSWORD'			=> 'A senha é muito curta.',
	'TOO_SHORT_USERNAME'				=> 'O nome de utilizador é muito curto.',
	'TOO_SHORT_EMAIL'					=> 'O endereço de email é muito curto.',
	'TOO_SHORT_EMAIL_CONFIRM'			=> 'A confirmação do endereço de email que digitou é muito curta.',
	'TOO_SMALL'							=> 'O valor que inseriu é muito pequeno.',
	'TOO_SMALL_MAX_RECIPIENTS'			=> 'O valor definido para o <strong>número máximo de destinatários permitidos por Mensagem Privada</strong> é muito pequeno.',

	'TOPIC'								=> 'Tópico',
	'TOPICS'							=> 'Tópicos',
	'TOPICS_UNAPPROVED'					=> 'Pelo menos um Tópico neste Fórum ainda não foi aprovado.',
	'TOPIC_ICON'						=> 'Ícone do Tópico',
	'TOPIC_LOCKED'						=> 'Este Tópico está bloqueado. Não pode editar mensagens ou responder.',
	'TOPIC_LOCKED_SHORT'				=> 'Tópico Bloqueado',
	'TOPIC_MOVED'						=> 'Tópico Movido',
	'TOPIC_REVIEW'						=> 'Rever o Tópico',
	'TOPIC_TITLE'						=> 'Título do Tópico',
	'TOPIC_UNAPPROVED'					=> 'Este Tópico ainda não foi aprovado.',
	'TOPIC_UNAPPROVED_FORUM'	=> array(
		1	=> 'Tópico aguarda por aprovação',
		2	=> 'Tópicos aguardam por aprovação',
	),
	'TOPIC_DELETED'						=> 'Este Tópico foi apagado.',
	'TOTAL_ATTACHMENTS'					=> 'Anexo(s)',
	'TOTAL_LOGS'		=> array(
		1	=> '%d log',
		2	=> '%d logs',
	),
	'TOTAL_PMS'		=> array(
		1	=> '%d mensagem privada no total',
		2	=> '%d mensagens privadas no total',
	),
	'TOPIC_POLL'		=> 'Este Tópico tem uma votação.',
	'TOTAL_POSTS'		=> 'Total de mensagens',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'Total de mensagens <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'Este tópico foi denunciado',
	'TOTAL_TOPICS'		=> array(
		2	=> 'Total de tópicos <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		2	=> 'Total de membros <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'					=> 'Erros PHP encontrados: %s',
	'TWITTER'							=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'				=> 'É impossível aceder ao Ficheiro de imagem, porque não é uma imagem válida. Por favor, verifique se o URL que inseriu está correto.',
	'UNABLE_TO_DELIVER_FILE'			=> 'Incapaz de entregar Ficheiro.',
	'UNKNOWN_BROWSER'					=> 'Navegador Desconhecido',
	'UNMARK_ALL'						=> 'Desmarcar todos',
	'UNREAD_MESSAGES'					=> 'Mensagens não lidas',
	'UNREAD_POST'						=> 'Mensagem não lida',
	'UNREAD_POSTS'						=> 'Mensagens não lidas',
	'UNWATCH_FORUM_CONFIRM'				=> 'Tem a certeza que deseja cancelar a assinatura deste fórum?',
	'UNWATCH_FORUM_DETAILED'			=> 'Tem a certeza que deseja cancelar a assinatura do fórum “%s”?',
	'UNWATCH_TOPIC_CONFIRM'				=> 'Tem a certeza que deseja cancelar a assinatura deste Tópico?',
	'UNWATCH_TOPIC_DETAILED'			=> 'Tem a certeza que deseja cancelar a assinatura do Tópico “%s”?',
	'UNWATCHED_FORUMS'					=> 'Já não se encontra a observar este Fórum.',
	'UNWATCHED_TOPICS'					=> 'Já não se encontra a observar este Tópico.',
	'UNWATCHED_FORUMS_TOPICS'			=> 'Já não se encontra a observar as entradas selecionadas.',
	'UPDATE'							=> 'Atualizar',
	'UPLOAD_IN_PROGRESS'				=> 'O envio está em progresso.',
	'URL_REDIRECT'						=> 'Se o seu navegador não suporta redirecionamentos, %sPor Favor, clique aqui para ser redirecionado%s.',
	'USERGROUPS'						=> 'Grupos',
	'USERNAME'							=> 'Utilizador',
	'USERNAMES'							=> 'Utilizadores',
	'USER_AVATAR'						=> 'Avatar do Utilizador',
	'USER_CANNOT_READ'					=> 'Não pode ler mensagens neste Fórum.',
	'USER_POSTS'			=> array(
		1	=> '%d Mensagem',
		2	=> '%d Mensagens',
	),
	'USERS'								=> 'Utilizadores',
	'USE_PERMISSIONS'					=> 'Testar permissões deste utilizador',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Pedimos desculpa, mas não está autorizado a utilizar esta funcionalidade. Pode ter que estar registado, e ter que participar mais para usar esta funcionalidade.',

	'VARIANT_DATE_SEPARATOR'			=> ' / ',
	'VIEWED'							=> 'Visto',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Não visto ainda',
		1	=> 'Visto %d vez',
		2	=> 'Visto %d vezes',
	),
	'VIEWING_CONTACT_ADMIN'				=> 'Vendo página de contacto',
	'VIEWING_FAQ'						=> 'A ver a FAQ',
	'VIEWING_MEMBERS'					=> 'A Ver detalhes dos Utilizadores',
	'VIEWING_ONLINE'					=> 'A Ver quem está online',
	'VIEWING_MCP'						=> 'A Ver Painel de Moderação',
	'VIEWING_MEMBER_PROFILE'			=> 'A Ver Perfil dos Utilizadores',
	'VIEWING_PRIVATE_MESSAGES'			=> 'A Ver Mensagens Privadas',
	'VIEWING_REGISTER'					=> 'Registar uma nova conta',
	'VIEWING_UCP'						=> 'A Ver o Painel de Controlo do Utilizador',
	'VIEWS'								=> 'Visualizações',
	'VIEW_BOOKMARKS'					=> 'Ver Favoritos',
	'VIEW_FORUM_LOGS'					=> 'Ver registos',
	'VIEW_LATEST_POST'					=> 'Veja a última Mensagem',
	'VIEW_NEWEST_POST'					=> 'A ver Mensagens Novas',
	'VIEW_NOTES'						=> 'Ver Notas do Utilizador',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'baseado nos utilizadores ativos no último %d minuto',
		2	=> 'baseado nos utilizadores ativos nos últimos %d minutos',
	),
	'VIEW_TOPIC'						=> 'Ver Tópico',
	'VIEW_TOPIC_ANNOUNCEMENT'			=> 'Anúncio: ',
	'VIEW_TOPIC_GLOBAL'					=> 'Anúncio Global: ',
	'VIEW_TOPIC_LOCKED'					=> 'Bloqueado: ',
	'VIEW_TOPIC_LOGS'					=> 'Ver registos',
	'VIEW_TOPIC_MOVED'					=> 'Movido: ',
	'VIEW_TOPIC_POLL'					=> 'Votação: ',
	'VIEW_TOPIC_STICKY'					=> 'Fixo: ',
	'VISIT_WEBSITE'						=> 'Visitar o sítio web',

	'WARNINGS'							=> 'Avisos',
	'WARN_USER'							=> 'Avisar Utilizador',
	'WATCH_FORUM_CONFIRM'				=> 'Tem a certeza que deseja subscrever este Fórum?',
	'WATCH_FORUM_DETAILED'				=> 'Tem a certeza que deseja subscrever o Fórum “%s”?',
	'WATCH_TOPIC_CONFIRM'				=> 'Tem a certeza que deseja subscrever este Tópico?',
	'WATCH_TOPIC_DETAILED'				=> 'Tem a certeza que deseja subscrever o Tópico “%s”?',
	'WELCOME_SUBJECT'					=> 'Bem-vindo ao %s Fóruns',
	'WEBSITE'							=> 'Sítio web',
	'WHOIS'								=> 'Quem',
	'WHO_IS_ONLINE'						=> 'Quem está ligado:',
	'WRONG_PASSWORD'					=> 'Senha errada.',

	'WRONG_DATA_COLOUR'					=> 'O valor da cor digitado é inválido.',
	'WRONG_DATA_JABBER'					=> 'O nome indicado não é um nome de conta Jabber válido.',
	'WRONG_DATA_LANG'					=> 'A linguagem indicada não é válida.',
	'WRONG_DATA_POST_SD'				=> 'A ordenação de mensagens especificada é inválida.',
	'WRONG_DATA_POST_SK'				=> 'A opção de ordenação de mensagens especificada é inválida.',
	'WRONG_DATA_TOPIC_SD'				=> 'A ordenação de tópicos especificada é inválida.',
	'WRONG_DATA_TOPIC_SK'				=> 'A opção de ordenação de tópicos especificada é inválida.',
	'WROTE'								=> 'Escreveu',

	'YAHOO'								=> 'Yahoo Messenger',
	'YOUTUBE'							=> 'YouTube',
	'YEAR'								=> 'Ano',
	'YEAR_MONTH_DAY'					=> '(DD-MM-YYYY)',
	'YES'								=> 'Sim',
	'YOU_LAST_VISIT'					=> 'Última visita: %s',

	'datetime'	=> array(
		'TODAY'							=> 'Hoje',
		'TOMORROW'						=> 'Amanhã',
		'YESTERDAY'						=> 'Ontem',
		'AGO'							=> array(
			0							=> 'menos de um minuto atrás',
			1							=> '%d minuto atrás',
			2							=> '%d minutos atrás',
		),

		'Sunday'						=> 'domingo',
		'Monday'						=> 'segunda-feira',
		'Tuesday'						=> 'terça-feira',
		'Wednesday'						=> 'quarta-feira',
		'Thursday'						=> 'quinta-feira',
		'Friday'						=> 'sexta-feira',
		'Saturday'						=> 'sábado',

		'Sun'							=> 'domingo',
		'Mon'							=> 'segunda',
		'Tue'							=> 'terça',
		'Wed'							=> 'quarta',
		'Thu'							=> 'quinta',
		'Fri'							=> 'sexta',
		'Sat'							=> 'sábado',

		'January'						=> 'janeiro',
		'February'						=> 'fevereiro',
		'March'							=> 'março',
		'April'							=> 'abril',
		'May'							=> 'maio',
		'June'							=> 'junho',
		'July'							=> 'julho',
		'August'						=> 'agosto',
		'September'						=> 'setembro',
		'October'						=> 'outubro',
		'November'						=> 'novembro',
		'December'						=> 'dezembro',

		'Jan'							=> 'jan',
		'Feb'							=> 'fev',
		'Mar'							=> 'mar',
		'Apr'							=> 'abr',
		'May_short'						=> 'mai',	// Short representation of "May". May_short used because in english the short and long date are the same for May.		 
		'Jun'							=> 'jun',
		'Jul'							=> 'jul',
		'Aug'							=> 'ago',
		'Sep'							=> 'set',
		'Oct'							=> 'out',
		'Nov'							=> 'nov',
		'Dec'							=> 'dez',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'UTC+12',
		'Etc/GMT-11'	=> 'UTC+11',
		'Etc/GMT-10'	=> 'UTC+10',
		'Etc/GMT-9'		=> 'UTC+9',
		'Etc/GMT-8'		=> 'UTC+8',
		'Etc/GMT-7'		=> 'UTC+7',
		'Etc/GMT-6'		=> 'UTC+6',
		'Etc/GMT-5'		=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3'		=> 'UTC+3',
		'Etc/GMT-2'		=> 'UTC+2',
		'Etc/GMT-1'		=> 'UTC+1',
		'Etc/GMT+1'		=> 'UTC-1',
		'Etc/GMT+2'		=> 'UTC-2',
		'Etc/GMT+3'		=> 'UTC-3',
		'Etc/GMT+4'		=> 'UTC-4',
		'Etc/GMT+5'		=> 'UTC-5',
		'Etc/GMT+6'		=> 'UTC-6',
		'Etc/GMT+7'		=> 'UTC-7',
		'Etc/GMT+8'		=> 'UTC-8',
		'Etc/GMT+9'		=> 'UTC-9',
		'Etc/GMT+10'	=> 'UTC-10',
		'Etc/GMT+11'	=> 'UTC-11',
		'Etc/GMT+12'	=> 'UTC-12',

		'Africa/Abidjan'	=> 'África/Abidjan',
		'Africa/Accra'		=> 'África/Accra',
		'Africa/Addis_Ababa'	=> 'África/Addis Ababa',
		'Africa/Algiers'	=> 'África/Algiers',
		'Africa/Asmara'		=> 'África/Asmara',
		'Africa/Bamako'		=> 'África/Bamako',
		'Africa/Bangui'		=> 'África/Bangui',
		'Africa/Banjul'		=> 'África/Banjul',
		'Africa/Bissau'		=> 'África/Bissau',
		'Africa/Blantyre'	=> 'África/Blantyre',
		'Africa/Brazzaville'	=> 'África/Brazzaville',
		'Africa/Bujumbura'	=> 'África/Bujumbura',
		'Africa/Cairo'		=> 'África/Cairo',
		'Africa/Casablanca'	=> 'África/Casablanca',
		'Africa/Ceuta'		=> 'África/Ceuta',
		'Africa/Conakry'	=> 'África/Conakry',
		'Africa/Dakar'		=> 'África/Dakar',
		'Africa/Dar_es_Salaam'	=> 'África/Dar es Salaam',
		'Africa/Djibouti'	=> 'África/Djibouti',
		'Africa/Douala'		=> 'África/Douala',
		'Africa/El_Aaiun'	=> 'África/El Aaiun',
		'Africa/Freetown'	=> 'África/Freetown',
		'Africa/Gaborone'	=> 'África/Gaborone',
		'Africa/Harare'		=> 'África/Harare',
		'Africa/Johannesburg'	=> 'África/Johannesburg',
		'Africa/Juba'		=> 'África/Juba',
		'Africa/Kampala'	=> 'África/Kampala',
		'Africa/Khartoum'	=> 'África/Khartoum',
		'Africa/Kigali'		=> 'África/Kigali',
		'Africa/Kinshasa'	=> 'África/Kinshasa',
		'Africa/Lagos'		=> 'África/Lagos',
		'Africa/Libreville'	=> 'África/Libreville',
		'Africa/Lome'		=> 'África/Lome',
		'Africa/Luanda'		=> 'África/Luanda',
		'Africa/Lubumbashi'	=> 'África/Lubumbashi',
		'Africa/Lusaka'		=> 'África/Lusaka',
		'Africa/Malabo'		=> 'África/Malabo',
		'Africa/Maputo'		=> 'África/Maputo',
		'Africa/Maseru'		=> 'África/Maseru',
		'Africa/Mbabane'	=> 'África/Mbabane',
		'Africa/Mogadishu'	=> 'África/Mogadishu',
		'Africa/Monrovia'	=> 'África/Monrovia',
		'Africa/Nairobi'	=> 'África/Nairobi',
		'Africa/Ndjamena'	=> 'África/Ndjamena',
		'Africa/Niamey'		=> 'África/Niamey',
		'Africa/Nouakchott'	=> 'África/Nouakchott',
		'Africa/Ouagadougou'	=> 'África/Ouagadougou',
		'Africa/Porto-Novo'	=> 'África/Porto-Novo',
		'Africa/Sao_Tome'	=> 'África/Sao Tome',
		'Africa/Tripoli'	=> 'África/Tripoli',
		'Africa/Tunis'		=> 'África/Tunis',
		'Africa/Windhoek'	=> 'África/Windhoek',

		'America/Adak'		=> 'América/Adak',
		'America/Anchorage'	=> 'América/Anchorage',
		'America/Anguilla'	=> 'América/Anguilla',
		'America/Antigua'	=> 'América/Antigua',
		'America/Araguaina'	=> 'América/Araguaina',

		'America/Argentina/Buenos_Aires'	=> 'América/Argentina/Buenos Aires',
		'America/Argentina/Catamarca'	=> 'América/Argentina/Catamarca',
		'America/Argentina/Cordoba'		=> 'América/Argentina/Cordoba',
		'America/Argentina/Jujuy'		=> 'América/Argentina/Jujuy',
		'America/Argentina/La_Rioja'	=> 'América/Argentina/La Rioja',
		'America/Argentina/Mendoza'		=> 'América/Argentina/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'América/Argentina/Rio Gallegos',
		'America/Argentina/Salta'		=> 'América/Argentina/Salta',
		'America/Argentina/San_Juan'	=> 'América/Argentina/San Juan',
		'America/Argentina/San_Luis'	=> 'América/Argentina/San Luis',
		'America/Argentina/Tucuman'		=> 'América/Argentina/Tucuman',
		'America/Argentina/Ushuaia'		=> 'América/Argentina/Ushuaia',

		'America/Aruba'			=> 'América/Aruba',
		'America/Asuncion'		=> 'América/Asuncion',
		'America/Atikokan'		=> 'América/Atikokan',
		'America/Bahia'			=> 'América/Bahia',
		'America/Bahia_Banderas'	=> 'América/Bahia Banderas',
		'America/Barbados'		=> 'América/Barbados',
		'America/Belem'			=> 'América/Belem',
		'America/Belize'		=> 'América/Belize',
		'America/Blanc-Sablon'	=> 'América/Blanc-Sablon',
		'America/Boa_Vista'		=> 'América/Boa Vista',
		'America/Bogota'		=> 'América/Bogota',
		'America/Boise'			=> 'América/Boise',
		'America/Cambridge_Bay'	=> 'América/Cambridge Bay',
		'America/Campo_Grande'	=> 'América/Campo Grande',
		'America/Cancun'		=> 'América/Cancun',
		'America/Caracas'		=> 'América/Caracas',
		'America/Cayenne'		=> 'América/Cayenne',
		'America/Cayman'		=> 'América/Cayman',
		'America/Chicago'		=> 'América/Chicago',
		'America/Chihuahua'		=> 'América/Chihuahua',
		'America/Costa_Rica'	=> 'América/Costa Rica',
		'America/Creston'		=> 'América/Creston',
		'America/Cuiaba'		=> 'América/Cuiaba',
		'America/Curacao'		=> 'América/Curacao',
		'America/Danmarkshavn'	=> 'América/Danmarkshavn',
		'America/Dawson'		=> 'América/Dawson',
		'America/Dawson_Creek'	=> 'América/Dawson Creek',
		'America/Denver'		=> 'América/Denver',
		'America/Detroit'		=> 'América/Detroit',
		'America/Dominica'		=> 'América/Dominica',
		'America/Edmonton'		=> 'América/Edmonton',
		'America/Eirunepe'		=> 'América/Eirunepe',
		'America/El_Salvador'	=> 'América/El Salvador',
		'America/Fortaleza'		=> 'América/Fortaleza',
		'America/Glace_Bay'		=> 'América/Glace Bay',
		'America/Godthab'		=> 'América/Godthab',
		'America/Goose_Bay'		=> 'América/Goose Bay',
		'America/Grand_Turk'	=> 'América/Grand Turk',
		'America/Grenada'		=> 'América/Grenada',
		'America/Guadeloupe'	=> 'América/Guadeloupe',
		'America/Guatemala'		=> 'América/Guatemala',
		'America/Guayaquil'		=> 'América/Guayaquil',
		'America/Guyana'		=> 'América/Guyana',
		'America/Halifax'		=> 'América/Halifax',
		'America/Havana'		=> 'América/Havana',
		'America/Hermosillo'		=> 'América/Hermosillo',
		'America/Indiana/Indianapolis'	=> 'América/Indiana/Indianapolis',
		'America/Indiana/Knox'		=> 'América/Indiana/Knox',
		'America/Indiana/Marengo'	=> 'América/Indiana/Marengo',
		'America/Indiana/Petersburg'	=> 'América/Indiana/Petersburg',
		'America/Indiana/Tell_City'	=> 'América/Indiana/Tell City',
		'America/Indiana/Vevay'		=> 'América/Indiana/Vevay',
		'America/Indiana/Vincennes'	=> 'América/Indiana/Vincennes',
		'America/Indiana/Winamac'	=> 'América/Indiana/Winamac',
		'America/Inuvik'		=> 'América/Inuvik',
		'America/Iqaluit'		=> 'América/Iqaluit',
		'America/Jamaica'		=> 'América/Jamaica',
		'America/Juneau'		=> 'América/Juneau',
		'America/Kentucky/Louisville'	=> 'América/Kentucky/Louisville',
		'America/Kentucky/Monticello'	=> 'América/Kentucky/Monticello',
		'America/Kralendijk'	=> 'América/Kralendijk',
		'America/La_Paz'		=> 'América/La Paz',
		'America/Lima'			=> 'América/Lima',
		'America/Los_Angeles'	=> 'América/Los Angeles',
		'America/Lower_Princes'	=> 'América/Lower Princes',
		'America/Maceio'		=> 'América/Maceio',
		'America/Managua'		=> 'América/Managua',
		'America/Manaus'		=> 'América/Manaus',
		'America/Marigot'		=> 'América/Marigot',
		'America/Martinique'	=> 'América/Martinique',
		'America/Matamoros'		=> 'América/Matamoros',
		'America/Mazatlan'		=> 'América/Mazatlan',
		'America/Menominee'		=> 'América/Menominee',
		'America/Merida'		=> 'América/Merida',
		'America/Metlakatla'	=> 'América/Metlakatla',
		'America/Mexico_City'	=> 'América/Mexico City',
		'America/Miquelon'		=> 'América/Miquelon',
		'America/Moncton'		=> 'América/Moncton',
		'America/Monterrey'		=> 'América/Monterrey',
		'America/Montevideo'	=> 'América/Montevideo',
		'America/Montreal'		=> 'América/Montreal',
		'America/Montserrat'	=> 'América/Montserrat',
		'America/Nassau'		=> 'América/Nassau',
		'America/New_York'		=> 'América/New York',
		'America/Nipigon'		=> 'América/Nipigon',
		'America/Nome'			=> 'América/Nome',
		'America/Noronha'		=> 'América/Noronha',
		'America/North_Dakota/Beulah'		=> 'América/North Dakota/Beulah',
		'America/North_Dakota/Center'		=> 'América/North Dakota/Center',
		'America/North_Dakota/New_Salem'	=> 'América/North Dakota/New Salem',
		'America/Ojinaga'		=> 'América/Ojinaga',
		'America/Panama'		=> 'América/Panama',
		'America/Pangnirtung'	=> 'América/Pangnirtung',
		'America/Paramaribo'	=> 'América/Paramaribo',
		'America/Phoenix'		=> 'América/Phoenix',
		'America/Port-au-Prince'	=> 'América/Port-au-Prince',
		'America/Port_of_Spain'	=> 'América/Port of Spain',
		'America/Porto_Velho'	=> 'América/Porto Velho',
		'America/Puerto_Rico'	=> 'América/Puerto Rico',
		'America/Rainy_River'	=> 'América/Rainy River',
		'America/Rankin_Inlet'	=> 'América/Rankin Inlet',
		'America/Recife'		=> 'América/Recife',
		'America/Regina'		=> 'América/Regina',
		'America/Resolute'		=> 'América/Resolute',
		'America/Rio_Branco'	=> 'América/Rio Branco',
		'America/Santa_Isabel'	=> 'América/Santa Isabel',
		'America/Santarem'		=> 'América/Santarem',
		'America/Santiago'		=> 'América/Santiago',
		'America/Santo_Domingo'	=> 'América/Santo Domingo',
		'America/Sao_Paulo'		=> 'América/Sao Paulo',
		'America/Scoresbysund'	=> 'América/Scoresbysund',
		'America/Shiprock'		=> 'América/Shiprock',
		'America/Sitka'			=> 'América/Sitka',
		'America/St_Barthelemy'	=> 'América/St. Barthelemy',
		'America/St_Johns'		=> 'América/St. Johns',
		'America/St_Kitts'		=> 'América/St. Kitts',
		'America/St_Lucia'		=> 'América/St. Lucia',
		'America/St_Thomas'		=> 'América/St. Thomas',
		'America/St_Vincent'	=> 'América/St. Vincent',
		'America/Swift_Current'	=> 'América/Swift Current',
		'America/Tegucigalpa'	=> 'América/Tegucigalpa',
		'America/Thule'			=> 'América/Thule',
		'America/Thunder_Bay'	=> 'América/Thunder Bay',
		'America/Tijuana'		=> 'América/Tijuana',
		'America/Toronto'		=> 'América/Toronto',
		'America/Tortola'		=> 'América/Tortola',
		'America/Vancouver'		=> 'América/Vancouver',
		'America/Whitehorse'	=> 'América/Whitehorse',
		'America/Winnipeg'		=> 'América/Winnipeg',
		'America/Yakutat'		=> 'América/Yakutat',
		'America/Yellowknife'	=> 'América/Yellowknife',

		'Antarctica/Casey'		=> 'Antártida/Casey',
		'Antarctica/Davis'		=> 'Antártida/Davis',
		'Antarctica/DumontDUrville'	=> 'Antártida/DumontDUrville',
		'Antarctica/Macquarie'	=> 'Antártida/Macquarie',
		'Antarctica/Mawson'		=> 'Antártida/Mawson',
		'Antarctica/McMurdo'	=> 'Antártida/McMurdo',
		'Antarctica/Palmer'		=> 'Antártida/Palmer',
		'Antarctica/Rothera'	=> 'Antártida/Rothera',
		'Antarctica/South_Pole'	=> 'Antártida/South Pole',
		'Antarctica/Syowa'		=> 'Antártida/Syowa',
		'Antarctica/Vostok'		=> 'Antártida/Vostok',

		'Arctic/Longyearbyen'	=> 'Ártico/Longyearbyen',

		'Asia/Aden'			=> 'Ásia/Aden',
		'Asia/Almaty'		=> 'Ásia/Almaty',
		'Asia/Amman'		=> 'Ásia/Amman',
		'Asia/Anadyr'		=> 'Ásia/Anadyr',
		'Asia/Aqtau'		=> 'Ásia/Aqtau',
		'Asia/Aqtobe'		=> 'Ásia/Aqtobe',
		'Asia/Ashgabat'		=> 'Ásia/Ashgabat',
		'Asia/Baghdad'		=> 'Ásia/Baghdad',
		'Asia/Bahrain'		=> 'Ásia/Bahrain',
		'Asia/Baku'			=> 'Ásia/Baku',
		'Asia/Bangkok'		=> 'Ásia/Bangkok',
		'Asia/Beirut'		=> 'Ásia/Beirut',
		'Asia/Bishkek'		=> 'Ásia/Bishkek',
		'Asia/Brunei'		=> 'Ásia/Brunei',
		'Asia/Choibalsan'	=> 'Ásia/Choibalsan',
		'Asia/Chongqing'	=> 'Ásia/Chongqing',
		'Asia/Colombo'		=> 'Ásia/Colombo',
		'Asia/Damascus'		=> 'Ásia/Damascus',
		'Asia/Dhaka'		=> 'Ásia/Dhaka',
		'Asia/Dili'			=> 'Ásia/Dili',
		'Asia/Dubai'		=> 'Ásia/Dubai',
		'Asia/Dushanbe'		=> 'Ásia/Dushanbe',
		'Asia/Gaza'			=> 'Ásia/Gaza',
		'Asia/Harbin'		=> 'Ásia/Harbin',
		'Asia/Hebron'		=> 'Ásia/Hebron',
		'Asia/Ho_Chi_Minh'	=> 'Ásia/Ho Chi Minh',
		'Asia/Hong_Kong'	=> 'Ásia/Hong Kong',
		'Asia/Hovd'			=> 'Ásia/Hovd',
		'Asia/Irkutsk'		=> 'Ásia/Irkutsk',
		'Asia/Jakarta'		=> 'Ásia/Jakarta',
		'Asia/Jayapura'		=> 'Ásia/Jayapura',
		'Asia/Jerusalem'	=> 'Ásia/Jerusalem',
		'Asia/Kabul'		=> 'Ásia/Kabul',
		'Asia/Kamchatka'	=> 'Ásia/Kamchatka',
		'Asia/Karachi'		=> 'Ásia/Karachi',
		'Asia/Kashgar'		=> 'Ásia/Kashgar',
		'Asia/Kathmandu'	=> 'Ásia/Kathmandu',
		'Asia/Khandyga'		=> 'Ásia/Khandyga',
		'Asia/Kolkata'		=> 'Ásia/Kolkata',
		'Asia/Krasnoyarsk'	=> 'Ásia/Krasnoyarsk',
		'Asia/Kuala_Lumpur'	=> 'Ásia/Kuala Lumpur',
		'Asia/Kuching'		=> 'Ásia/Kuching',
		'Asia/Kuwait'		=> 'Ásia/Kuwait',
		'Asia/Macau'		=> 'Ásia/Macau',
		'Asia/Magadan'		=> 'Ásia/Magadan',
		'Asia/Makassar'		=> 'Ásia/Makassar',
		'Asia/Manila'		=> 'Ásia/Manila',
		'Asia/Muscat'		=> 'Ásia/Muscat',
		'Asia/Nicosia'		=> 'Ásia/Nicosia',
		'Asia/Novokuznetsk'	=> 'Ásia/Novokuznetsk',
		'Asia/Novosibirsk'	=> 'Ásia/Novosibirsk',
		'Asia/Omsk'			=> 'Ásia/Omsk',
		'Asia/Oral'			=> 'Ásia/Oral',
		'Asia/Phnom_Penh'	=> 'Ásia/Phnom Penh',
		'Asia/Pontianak'	=> 'Ásia/Pontianak',
		'Asia/Pyongyang'	=> 'Ásia/Pyongyang',
		'Asia/Qatar'		=> 'Ásia/Qatar',
		'Asia/Qyzylorda'	=> 'Ásia/Qyzylorda',
		'Asia/Rangoon'		=> 'Ásia/Rangoon',
		'Asia/Riyadh'		=> 'Ásia/Riyadh',
		'Asia/Sakhalin'		=> 'Ásia/Sakhalin',
		'Asia/Samarkand'	=> 'Ásia/Samarkand',
		'Asia/Seoul'		=> 'Ásia/Seoul',
		'Asia/Shanghai'		=> 'Ásia/Shanghai',
		'Asia/Singapore'	=> 'Ásia/Singapore',
		'Asia/Taipei'		=> 'Ásia/Taipei',
		'Asia/Tashkent'		=> 'Ásia/Tashkent',
		'Asia/Tbilisi'		=> 'Ásia/Tbilisi',
		'Asia/Tehran'		=> 'Ásia/Tehran',
		'Asia/Thimphu'		=> 'Ásia/Thimphu',
		'Asia/Tokyo'		=> 'Ásia/Tokyo',
		'Asia/Ulaanbaatar'	=> 'Ásia/Ulaanbaatar',
		'Asia/Urumqi'		=> 'Ásia/Urumqi',
		'Asia/Ust-Nera'		=> 'Ásia/Ust-Nera',
		'Asia/Vientiane'	=> 'Ásia/Vientiane',
		'Asia/Vladivostok'	=> 'Ásia/Vladivostok',
		'Asia/Yakutsk'		=> 'Ásia/Yakutsk',
		'Asia/Yekaterinburg'	=> 'Ásia/Yekaterinburg',
		'Asia/Yerevan'		=> 'Ásia/Yerevan',

		'Atlantic/Azores'		=> 'Atlântico/Azores',
		'Atlantic/Bermuda'		=> 'Atlântico/Bermuda',
		'Atlantic/Canary'		=> 'Atlântico/Canary',
		'Atlantic/Cape_Verde'	=> 'Atlântico/Cape Verde',
		'Atlantic/Faroe'		=> 'Atlântico/Faroe',
		'Atlantic/Madeira'		=> 'Atlântico/Madeira',
		'Atlantic/Reykjavik'	=> 'Atlântico/Reykjavik',
		'Atlantic/South_Georgia'	=> 'Atlântico/South Georgia',
		'Atlantic/St_Helena'	=> 'Atlântico/St. Helena',
		'Atlantic/Stanley'		=> 'Atlântico/Stanley',

		'Australia/Adelaide'	=> 'Austrália/Adelaide',
		'Australia/Brisbane'	=> 'Austrália/Brisbane',
		'Australia/Broken_Hill'	=> 'Austrália/Broken Hill',
		'Australia/Currie'		=> 'Austrália/Currie',
		'Australia/Darwin'		=> 'Austrália/Darwin',
		'Australia/Eucla'		=> 'Austrália/Eucla',
		'Australia/Hobart'		=> 'Austrália/Hobart',
		'Australia/Lindeman'	=> 'Austrália/Lindeman',
		'Australia/Lord_Howe'	=> 'Austrália/Lord Howe',
		'Australia/Melbourne'	=> 'Austrália/Melbourne',
		'Australia/Perth'		=> 'Austrália/Perth',
		'Australia/Sydney'		=> 'Austrália/Sydney',

		'Europe/Amsterdam'	=> 'Europa/Amsterdam',
		'Europe/Andorra'	=> 'Europa/Andorra',
		'Europe/Athens'		=> 'Europa/Athens',
		'Europe/Belgrade'	=> 'Europa/Belgrade',
		'Europe/Berlin'		=> 'Europa/Berlin',
		'Europe/Bratislava'	=> 'Europa/Bratislava',
		'Europe/Brussels'	=> 'Europa/Brussels',
		'Europe/Bucharest'	=> 'Europa/Bucharest',
		'Europe/Budapest'	=> 'Europa/Budapest',
		'Europe/Busingen'	=> 'Europa/Busingen',
		'Europe/Chisinau'	=> 'Europa/Chisinau',
		'Europe/Copenhagen'	=> 'Europa/Copenhagen',
		'Europe/Dublin'		=> 'Europa/Dublin',
		'Europe/Gibraltar'	=> 'Europa/Gibraltar',
		'Europe/Guernsey'	=> 'Europa/Guernsey',
		'Europe/Helsinki'	=> 'Europa/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europa/Isle of Man',
		'Europe/Istanbul'	=> 'Europa/Istanbul',
		'Europe/Jersey'		=> 'Europa/Jersey',
		'Europe/Kaliningrad'	=> 'Europa/Kaliningrad',
		'Europe/Kiev'		=> 'Europa/Kiev',
		'Europe/Lisbon'		=> 'Europa/Lisbon',
		'Europe/Ljubljana'	=> 'Europa/Ljubljana',
		'Europe/London'		=> 'Europa/London',
		'Europe/Luxembourg'	=> 'Europa/Luxembourg',
		'Europe/Madrid'		=> 'Europa/Madrid',
		'Europe/Malta'		=> 'Europa/Malta',
		'Europe/Mariehamn'	=> 'Europa/Mariehamn',
		'Europe/Minsk'		=> 'Europa/Minsk',
		'Europe/Monaco'		=> 'Europa/Monaco',
		'Europe/Moscow'		=> 'Europa/Moscow',
		'Europe/Oslo'		=> 'Europa/Oslo',
		'Europe/Paris'		=> 'Europa/Paris',
		'Europe/Podgorica'	=> 'Europa/Podgorica',
		'Europe/Prague'		=> 'Europa/Prague',
		'Europe/Riga'		=> 'Europa/Riga',
		'Europe/Rome'		=> 'Europa/Rome',
		'Europe/Samara'		=> 'Europa/Samara',
		'Europe/San_Marino'	=> 'Europa/San Marino',
		'Europe/Sarajevo'	=> 'Europa/Sarajevo',
		'Europe/Simferopol'	=> 'Europa/Simferopol',
		'Europe/Skopje'		=> 'Europa/Skopje',
		'Europe/Sofia'		=> 'Europa/Sofia',
		'Europe/Stockholm'	=> 'Europa/Stockholm',
		'Europe/Tallinn'	=> 'Europa/Tallinn',
		'Europe/Tirane'		=> 'Europa/Tirane',
		'Europe/Uzhgorod'	=> 'Europa/Uzhgorod',
		'Europe/Vaduz'		=> 'Europa/Vaduz',
		'Europe/Vatican'	=> 'Europa/Vatican',
		'Europe/Vienna'		=> 'Europa/Vienna',
		'Europe/Vilnius'	=> 'Europa/Vilnius',
		'Europe/Volgograd'	=> 'Europa/Volgograd',
		'Europe/Warsaw'		=> 'Europa/Warsaw',
		'Europe/Zagreb'		=> 'Europa/Zagreb',
		'Europe/Zaporozhye'	=> 'Europa/Zaporozhye',
		'Europe/Zurich'		=> 'Europa/Zurich',

		'Indian/Antananarivo'	=> 'Índico/Antananarivo',
		'Indian/Chagos'		=> 'Índico/Chagos',
		'Indian/Christmas'	=> 'Índico/Christmas',
		'Indian/Cocos'		=> 'Índico/Cocos',
		'Indian/Comoro'		=> 'Índico/Comoro',
		'Indian/Kerguelen'	=> 'Índico/Kerguelen',
		'Indian/Mahe'		=> 'Índico/Mahe',
		'Indian/Maldives'	=> 'Índico/Maldives',
		'Indian/Mauritius'	=> 'Índico/Mauritius',
		'Indian/Mayotte'	=> 'Índico/Mayotte',
		'Indian/Reunion'	=> 'Índico/Reunion',

		'Pacific/Apia'		=> 'Pacífico/Apia',
		'Pacific/Auckland'	=> 'Pacífico/Auckland',
		'Pacific/Chatham'	=> 'Pacífico/Chatham',
		'Pacific/Chuuk'		=> 'Pacífico/Chuuk',
		'Pacific/Easter'	=> 'Pacífico/Easter',
		'Pacific/Efate'		=> 'Pacífico/Efate',
		'Pacific/Enderbury'	=> 'Pacífico/Enderbury',
		'Pacific/Fakaofo'	=> 'Pacífico/Fakaofo',
		'Pacific/Fiji'		=> 'Pacífico/Fiji',
		'Pacific/Funafuti'	=> 'Pacífico/Funafuti',
		'Pacific/Galapagos'	=> 'Pacífico/Galapagos',
		'Pacific/Gambier'	=> 'Pacífico/Gambier',
		'Pacific/Guadalcanal'	=> 'Pacífico/Guadalcanal',
		'Pacific/Guam'		=> 'Pacífico/Guam',
		'Pacific/Honolulu'	=> 'Pacífico/Honolulu',
		'Pacific/Johnston'	=> 'Pacífico/Johnston',
		'Pacific/Kiritimati'	=> 'Pacífico/Kiritimati',
		'Pacific/Kosrae'	=> 'Pacífico/Kosrae',
		'Pacific/Kwajalein'	=> 'Pacífico/Kwajalein',
		'Pacific/Majuro'	=> 'Pacífico/Majuro',
		'Pacific/Marquesas'	=> 'Pacífico/Marquesas',
		'Pacific/Midway'	=> 'Pacífico/Midway',
		'Pacific/Nauru'		=> 'Pacífico/Nauru',
		'Pacific/Niue'		=> 'Pacífico/Niue',
		'Pacific/Norfolk'	=> 'Pacífico/Norfolk',
		'Pacific/Noumea'	=> 'Pacífico/Noumea',
		'Pacific/Pago_Pago'	=> 'Pacífico/Pago Pago',
		'Pacific/Palau'		=> 'Pacífico/Palau',
		'Pacific/Pitcairn'	=> 'Pacífico/Pitcairn',
		'Pacific/Pohnpei'	=> 'Pacífico/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Pacífico/Port Moresby',
		'Pacific/Rarotonga'	=> 'Pacífico/Rarotonga',
		'Pacific/Saipan'	=> 'Pacífico/Saipan',
		'Pacific/Tahiti'	=> 'Pacífico/Tahiti',
		'Pacific/Tarawa'	=> 'Pacífico/Tarawa',
		'Pacific/Tongatapu'	=> 'Pacífico/Tongatapu',
		'Pacific/Wake'		=> 'Pacífico/Wake',
		'Pacific/Wallis'	=> 'Pacífico/Wallis',
	),

	// The value is only an example and will get replaced by the current time on view 
	'dateformats'						=> array( 
		'd M Y, H:i'					=> '01 Jan 2008, 17:37',
		'd M Y H:i'						=> '01 Jan 2008 17:37',
		'M jS, \'y, H:i'				=> 'Jan 1st, \'07, 17:37',
		'D M d, Y g:i a'				=> 'Seg Jan 01, 2008 5:37 pm',
		'F jS, Y, g:i a'				=> 'Janeiro 1st, 2008, 5:37 pm',
		'|d M Y|, H:i'					=> 'Hoje, 17:37 / 01 Jan 2008, 17:37',
		'|F jS, Y|, g:i a'				=> 'Hoje, 1:37 pm / 1º Janeiro, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language 
	// Translators should change this if a the usual date format is different 
	'default_dateformat'				=> 'd/M/Y, H:i', // 20/Abr/2009, 09:17

));
