<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
* @Traduzido por: http://www.phpbb-pt.com - segundo as normas do Acordo Ortográfico
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Privacy policy and T&C
$lang = array_merge($lang, array(
	'TERMS_OF_USE_CONTENT'	=> 'Ao entrar em “%1$s” (doravante “nós”, “nosso”, “%1$s”, “%2$s”), concorda sujeitar-se aos termos seguintes. Se não concorda em sujeitar-se aos termos seguintes, por favor não entre e/ou utilize “%1$s”. Nós podemos mudar estes termos a qualquer momento e vamos fazer o nosso melhor para mantê-lo informado. No entanto, seria prudente rever regularmente estes termos. O uso continuado de “%1$s” significa que concorda em ser legalmente sujeito a estes termos quando são atualizados e/ou alterados.
	<br><br>
	Os nossos Fóruns são desenvolvidos pelo phpBB (doravante “eles”, “software phpBB”, “www.phpbb.com”, “Grupo phpBB”, “Equipa phpBB”) que é um sistema de comunidades virtuais sujeito à “<a href="http://opensource.org/licenses/gpl-2.0.php">GNU General Public License v2</a>” (doravante “GPL”) que pode ser transferido a partir de <a href="https://www.phpbb.com/">www.phpbb.com</a>. O software phpBB apenas facilita discussões através da Internet. O Grupo phpBB não é responsável pelo conteúdo que nós permitimos e/ou impedimos e/ou pela conduta permitida. Para mais informações sobre o phpBB, consulte: <a href="https://www.phpbb.com/">https://www.phpbb.com/</a>.
	<br><br>
	Compromete-se a não colocar qualquer mensagem abusiva, obscena, vulgar, insultuosa, de ódio, ameaçadora, sexualmente tendenciosa ou qualquer outro material que possa violar qualquer lei seja do seu país, o país onde “%1$s” está alojado ou lei Internacional. Fazer isso pode levá-lo a ser banido de imediato e permanentemente, e, se for necessário, com notificação da nossa parte ao seu Provedor de Internet. O endereço IP de todas as mensagens são registados para ajudar a implementar estas condições. Concorda que “%1$s” tem o direito de remover, editar, mover ou encerrar qualquer tópico, a qualquer momento, caso este considere necessário. Como utilizador aceita que as informações que forneceu acima sejam guardadas numa Base de Dados. Apesar desta informação não ser divulgada a terceiros sem o seu consentimento, o “%1$s” ou o phpBB não podem ser responsabilizados por qualquer atentado Hacker, que possam expor essa informação.
	',

	'PRIVACY_POLICY'		=> 'Esta política explica em detalhe como “%1$s” juntamente com as suas empresas afiliadas (doravante "nós", "nosso", “%1$s”, “%2$s”) e o phpBB (doravante “eles”, “phpBB software”, “www.phpbb.com”, “Grupo phpBB”, “Equipas phpBB”) utilizam a informação recolhida durante as suas sessões online (doravante denominada “a sua informação”).
	<br><br>
	Recolheremos informações suas de duas formas. A primeira, ao navegar no “%1$s” fará com que o Software phpBB crie cookies que são pequenos ficheiros de texto, transferidos temporariamente pelos navegadores web para o seu computador. Os dois primeiros cookies têm a identificação do utilizador (doravante denominado “user-id”) e um identificador de sessão anónima (doravante “session-id”), assinado automaticamente para si pelo software phpBB. O terceiro cookie será criado sempre que tenha tópicos lidos em “%1$s” e é usado para registar os tópicos lidos, aumentando assim sua experiência como utilizador.
	<br><br>
	Podem também ser criados cookies externos ao software phpBB enquanto navegar no “%1$s”, ainda que estes sejam externos o âmbito destes cookies é proteger as páginas criadas pelo Software phpBB. A segunda maneira de recolher informações suas é através das mensagens que partilha connosco. Esta recolha pode fazer-se mas não está limitada a: mensagens enquanto utilizador anónimo (doravante “mensagens anónimas”), registando-se em “%1$s” (doravante denominado “a sua conta”) e através das mensagens enviadas por si depois do registo e quando ligado (doravante “as suas mensagens”).
	<br><br>
	A sua conta deverá ter no mínimo um nome único (doravante “o seu nome de utilizador”), uma senha pessoal utilizada para entrar na sua conta (doravante, “a sua senha”) e um endereço pessoal de email válido (doravante “o seu email”). As informações da sua conta em “%1$s” são protegidas pelas leis de proteção de dados aplicáveis no nosso país. Qualquer outra informação além do seu nome de utilizador, da sua senha e do seu endereço de email solicitados pelo “%1$s” durante o processo de registo, é obrigatória ou opcional, segundo o critério de “%1$s”. Em todo o caso, tem a opção de escolher as informações da sua conta que serão publicadas. Além disso, dentro da sua conta, pode optar por receber, ou não, os emails gerados automaticamente pelo software phpBB.
	<br><br>
	A sua senha é encriptada (via hash) para que seja segura. No entanto, recomendamos que não utilize a mesma senha em vários sítios diferentes. A senha é um meio para entrar na sua conta em “%1$s”, então por favor guarde-a com cuidado e em nenhuma circunstância alguém relacionado com “%1$s”, phpBB ou um terceiro, tem legitimidade para lhe pedir a senha. Se esquecer a senha da sua conta, pode usar a opção “Esqueci-me da senha” providenciada pelo software phpBB. Este processo pede-lhe o nome de utilizador e email, para o phpBB gerar uma nova senha e reativar o seu registo.
	',
));

// Common language entries
$lang = array_merge($lang, array(
	'ACCOUNT_ACTIVE'					=> 'A sua conta foi ativada. Obrigado por se registar.',
	'ACCOUNT_ACTIVE_ADMIN'				=> 'A conta foi ativada.',
	'ACCOUNT_ACTIVE_PROFILE'			=> 'A sua conta foi reativada com sucesso.',
	'ACCOUNT_ADDED'						=> 'Obrigado por se registar, a sua conta foi criada.',
	'ACCOUNT_COPPA'						=> 'A sua conta foi criada. Para ser Aprovada é necessário a autorização do seu Encarregado de Educação. Para mais detalhes verifique o seu endereço de email.',
	'ACCOUNT_EMAIL_CHANGED'				=> 'A sua conta foi atualizada. Neste Fórum as alterações de email requerem a reativação. A chave de ativação foi enviada para o seu novo endereço de email. Para mais detalhes verifique o seu endereço de email.',
	'ACCOUNT_EMAIL_CHANGED_ADMIN'		=> 'A sua conta foi atualizada. Neste Fórum as alterações de email requerem a reativação por um administrador. Receberá um email quando a sua conta for reativada.',
	'ACCOUNT_INACTIVE'					=> 'A sua conta foi criada com sucesso. A Chave de Ativação foi enviada para o endereço de email que indicou durante o seu Registo. Ao receber o email proceda à Ativação da sua conta. Só então poderá entrar no Fórum. Se não receber o email na sua caixa de entrada verifique a caixa de lixo eletrónico. Pode levar algum tempo para obter o e-mail , dependendo do seu provedor de e-mail.',
	'ACCOUNT_INACTIVE_ADMIN'			=> 'A sua conta foi criada. Neste Fórum a ativação da conta é realizada pelo Administrador. Foi-lhe enviado um email que o informará de Ativar a sua conta. Será informado após tal, mantenha-se atento ao seu email.',
	'ACTIVATION_EMAIL_SENT'				=> 'O email de ativação foi enviado para o seu endereço de email.',
	'ACTIVATION_EMAIL_SENT_ADMIN'		=> 'O email de ativação foi enviado para o Administrador.',
	'ADD'								=> 'Adicionar',
	'ADD_BCC'							=> 'Adicionar [Bcc]',
	'ADD_FOES'							=> 'Adicionar novo Inimigo',
	'ADD_FOES_EXPLAIN'					=> 'Pode introduzir vários Utilizadores, um por linha.',
	'ADD_FOLDER'						=> 'Adicionar Pasta',
	'ADD_FRIENDS'						=> 'Adicionar um novo Amigo',
	'ADD_FRIENDS_EXPLAIN'				=> 'Pode introduzir vários Utilizadores, um por linha.',
	'ADD_NEW_RULE'						=> 'Adicionar nova Regra',
	'ADD_RULE'							=> 'Adicionar Regra',
	'ADD_TO'							=> 'Adicionar [Para]',
	'ADD_USERS_UCP_EXPLAIN'				=> 'Aqui pode adicionar novos utilizadores ao grupo. Pode selecionar se este grupo se torna o novo padrão para os utilizadores selecionados. Por favor, digite um nome de utilizador por cada linha.',
	'ADMIN_EMAIL'						=> 'Autorizar os Administradores a enviarem-me emails',
	'AGREE'								=> 'Li e concordo com todas as condições',
	'ALLOW_PM'							=> 'Autorizar o envio de Mensagens Privadas',
	'ALLOW_PM_EXPLAIN'					=> 'Administradores/Moderadores podem sempre enviar-lhe Mensagens Privadas.',
	'ALREADY_ACTIVATED'					=> 'O seu registo já foi ativado.',
	'ATTACHMENTS_EXPLAIN'				=> 'Esta é uma lista dos anexos que enviou para este Fórum.',
	'ATTACHMENTS_DELETED'				=> 'Anexos Apagados.',
	'ATTACHMENT_DELETED'				=> 'Anexo Apagado.',
	'ATTACHMENT_LOCKED'					=> 'Este tópico está bloqueado. Não pode excluir o anexo.',
	'AUTOLOGIN_SESSION_KEYS_DELETED'	=> 'As chaves de acesso "Lembrar-me" selecionadas foram apagadas com sucesso.',
	'AVATAR_CATEGORY'					=> 'Categoria',
	'AVATAR_DRIVER_GRAVATAR_TITLE'		=> 'Gravatar',
	'AVATAR_DRIVER_GRAVATAR_EXPLAIN'	=> 'Gravatar é um serviço que permite que tenha o mesmo avatar em vários sites. Visite <a href="http://www.gravatar.com/">Gravatar</a> para mais informações.',
	'AVATAR_DRIVER_LOCAL_TITLE'			=> 'Galeria de avatar',
	'AVATAR_DRIVER_LOCAL_EXPLAIN'		=> 'Pode escolher o seu avatar a partir de um conjunto de avatares disponíveis localmente.',
	'AVATAR_DRIVER_REMOTE_TITLE'		=> 'Avatar remoto',
	'AVATAR_DRIVER_REMOTE_EXPLAIN'		=> 'Link para imagens Avatar de outro site.',
	'AVATAR_DRIVER_UPLOAD_TITLE'		=> 'Carregar avatar',
	'AVATAR_DRIVER_UPLOAD_EXPLAIN'		=> 'Carregue o seu próprio avatar personalizado.',
	'AVATAR_EXPLAIN'					=> 'Dimensões máximas; largura: %1$s, altura: %2$s, tamanho do ficheiro: %3$.2f KiB.',
	'AVATAR_EXPLAIN_NO_FILESIZE'		=> 'Dimensões máximas; largura: %1$s, altura: %2$s',
	'AVATAR_FEATURES_DISABLED'			=> 'A função de Avatar está desativada.',
	'AVATAR_GALLERY'					=> 'Galeria Local',
	'AVATAR_GENERAL_UPLOAD_ERROR'		=> 'Não foi possível enviar o Avatar para %s.',
	'AVATAR_NOT_ALLOWED'				=> 'O seu avatar não pode ser exibido porque os avatares foram desativados.',
	'AVATAR_PAGE'						=> 'Página',
	'AVATAR_SELECT'						=> 'Selecione o seu avatar',
	'AVATAR_TYPE'						=> 'Tipo de Avatar',
	'AVATAR_TYPE_NOT_ALLOWED'			=> 'O seu Avatar atual não pode ser exibido porque o seu tipo foi desativado.',

	'BACK_TO_DRAFTS'					=> 'Voltar aos rascunhos guardados',
	'BACK_TO_LOGIN'						=> 'Entrar',
	'BIRTHDAY'							=> 'Aniversário',
	'BIRTHDAY_EXPLAIN'					=> 'O seu aniversário será assinalado na data indicada.',
	'BOARD_DATE_FORMAT'					=> 'O meu formato de data',
	'BOARD_DATE_FORMAT_EXPLAIN'			=> 'A sintaxe usa o mesmo formato do PHP <a href="https://www.php.net/manual/datetime.format.php">função date</a>..',
	'BOARD_LANGUAGE'					=> 'O meu idioma',
	'BOARD_STYLE'						=> 'O Estilo do meu Painel',
	'BOARD_TIMEZONE'					=> 'Fuso Horário',
	'BOOKMARKS'							=> 'Favoritos',
	'BOOKMARKS_EXPLAIN'					=> 'Esta é a sua lista de Favoritos. Para remover da lista um Favorito, selecione a caixa correspondente e carregue no botão Apagar Favoritos Marcados.',
	'BOOKMARKS_DISABLED'				=> 'Favoritos foram desativados.',
	'BOOKMARKS_REMOVED'					=> 'Os Favoritos selecionados foram apagados com sucesso.',

	'CANNOT_EDIT_MESSAGE_TIME'			=> 'Não pode editar ou apagar a mensagem.',
	'CANNOT_MOVE_TO_SAME_FOLDER'		=> 'Não podem ser movidas mensagens da pasta que quer Apagar.',
	'CANNOT_MOVE_FROM_SPECIAL'			=> 'Não podem ser movidas mensagens da pasta de saída.',
	'CANNOT_RENAME_FOLDER'				=> 'Esta pasta não pode ser renomeada.',
	'CANNOT_REMOVE_FOLDER'				=> 'Esta pasta não pode ser apagada.',
	'CHANGE_DEFAULT_GROUP'				=> 'Alterar Grupo Padrão',
	'CHANGE_PASSWORD'					=> 'Alterar Senha',
	'CLICK_GOTO_FOLDER'					=> '%1$sIr para a pasta “%3$s”%2$s',
	'CLICK_RETURN_FOLDER'				=> 'Clique %1$sAqui%2$s para voltar para a pasta %3$s',
	'CONFIRMATION'						=> 'Confirmação de Registo',
	'CONFIRM_CHANGES'					=> 'Confirmar Alterações',
	'CONFIRM_EXPLAIN'					=> 'Para prevenir Registos automáticos de "espiões" é necessário introduzir um código de confirmação. O código é exibido na imagem que deverá ver em baixo. Se tem alguma deficiência visual, e não pode ler o código, por favor, contacte o %sAdministrador do Fórum%s.',
	'VC_REFRESH'						=> 'Alterar Código de Confirmação',
	'VC_REFRESH_EXPLAIN'				=> 'Se não consegue ler o código pode pedir um novo clicando no botão.',

	'CONFIRM_PASSWORD'					=> 'Confirme a sua Senha',
	'CONFIRM_PASSWORD_EXPLAIN'			=> 'Só se alterar a Senha atual.',
	'COPPA_BIRTHDAY'					=> 'Neste Fórum o Registo de Utilizadores menores de 13 anos necessita da Aprovação do Encarregado de Educação. Se tem menos de 13 anos o Registo só será Aprovado pelo Administrador do Fórum depois do seu Encarregado de Educação enviar a autorização para a sua participação. Para continuar com o Registo, selecione a opção correta, de acordo com a sua idade.',
	'COPPA_COMPLIANCE'					=> 'De acordo com a COPPA',
	'COPPA_EXPLAIN'						=> 'Ao clicar em enviar, criará a sua conta. No entanto, só será ativada quando o seu Encarregado de Educação ou o responsável legal autorizar a sua participação no Fórum. Para isso receberá um email com mais detalhes.',
	'CREATE_FOLDER'						=> 'Adicionar Pasta',
	'CURRENT_IMAGE'						=> 'Imagem Atual',
	'CURRENT_PASSWORD'					=> 'Senha Atual',
	'CURRENT_PASSWORD_EXPLAIN'			=> 'Para alterar o seu endereço de email ou nome de utilizador, tem que inserir a sua senha atual.',
	'CURRENT_CHANGE_PASSWORD_EXPLAIN'	=> 'Para alterar a senha, o endereço de email ou o seu nome de utilizador, tem que inserir a sua senha atual.',
	'CUR_PASSWORD_EMPTY'				=> 'Não digitou a senha atual.',
	'CUR_PASSWORD_ERROR'				=> 'A Senha atual que escreveu está incorreta.',
	'CUSTOM_DATEFORMAT'					=> 'Personalizar',

	'DEFAULT_ACTION'					=> 'Ação Padrão',
	'DEFAULT_ACTION_EXPLAIN'			=> 'Esta ação será ativada se nenhuma das anteriores forem aplicáveis.',
	'DEFAULT_ADD_SIG'					=> 'Ativar sempre a minha Assinatura',
	'DEFAULT_BBCODE'					=> 'Ativar sempre o BBCode',
	'DEFAULT_NOTIFY'					=> 'Avisar-me sempre que houver respostas novas',
	'DEFAULT_SMILIES'					=> 'Ativar sempre as Emoções',
	'DEFINED_RULES'						=> 'Regras Definidas',
	'DELETED_TOPIC'						=> 'O Tópico selecionado foi apagado com sucesso.',
	'DELETE_ATTACHMENT'					=> 'Apagar Anexo',
	'DELETE_ATTACHMENTS'				=> 'Apagar Anexos',
	'DELETE_ATTACHMENT_CONFIRM'			=> 'Tem a certeza que deseja remover este anexo?',
	'DELETE_ATTACHMENTS_CONFIRM'		=> 'Tem a certeza que deseja remover estes anexos?',
	'DELETE_AVATAR'						=> 'Apagar Imagem',
	'DELETE_COOKIES_CONFIRM'			=> 'Apagar todos os cookies?',
	'DELETE_MARKED_PM'					=> 'Apagar as Mensagens selecionadas',
	'DELETE_MARKED_PM_CONFIRM'			=> 'Tem a certeza que deseja apagar as Mensagens selecionadas?',
	'DELETE_OLDEST_MESSAGES'			=> 'Apagar as Mensagens antigas ',
	'DELETE_MESSAGE'					=> 'Apagar a Mensagem',
	'DELETE_MESSAGE_CONFIRM'			=> 'Tem a certeza que deseja apagar esta Mensagem Privada?',
	'DELETE_MESSAGES_IN_FOLDER'			=> 'Apagar todas as Mensagens dentro de pasta removida',
	'DELETE_RULE'						=> 'Apagar Regra',
	'DELETE_RULE_CONFIRM'				=> 'Tem a certeza que deseja Apagar está regra?',
	'DEMOTE_SELECTED'					=> 'Remover o selecionado',
	'DISABLE_CENSORS'					=> 'Permitir Palavras Censuradas',
	'DISPLAY_GALLERY'					=> 'Mostrar Galeria',
	'DOWNLOADS'							=> 'Transferências',
	'DRAFTS_DELETED'					=> 'Todos os rascunhos selecionadas foram apagados.',
	'DRAFTS_EXPLAIN'					=> 'Aqui pode ver, editar e apagar os rascunhos guardados.',
	'DRAFT_UPDATED'						=> 'Rascunhos atualizados.',

	'EDIT_DRAFT_EXPLAIN'				=> 'Aqui pode editar o seu rascunho. Os rascunhos não contêm anexos e informações de votações.',
	'EMAIL_BANNED_EMAIL'				=> 'Não é permitido utilizar o endereço de email indicado.',
	'EMAIL_REMIND'						=> 'Este deve ser o endereço de email que indicou ao registar-se.',
	'EMAIL_TAKEN_EMAIL'					=> 'Este endereço de email já está em uso.',
	'EMPTY_DRAFT'						=> 'Deve escrever uma mensagem antes de enviar as suas alterações.',
	'EMPTY_DRAFT_TITLE'					=> 'O Rascunho tem que ter um Título.',
	'EXPORT_AS_XML'						=> 'Exportar em XML',
	'EXPORT_AS_CSV'						=> 'Exportar em CSV',
	'EXPORT_AS_CSV_EXCEL'				=> 'Exportar em CSV (Excel)',
	'EXPORT_AS_TXT'						=> 'Exportar em TXT',
	'EXPORT_AS_MSG'						=> 'Exportar em MSG',
	'EXPORT_FOLDER'						=> 'Exportar Pasta',

	'FIELD_REQUIRED'					=> 'O Campo “%s” deve ser preenchido.',
	'FIELD_TOO_SHORT'					=> array(
		1	=> 'O campo “%2$s” é muito curto, é necessário um mínimo de %1$d carácter.',
		2	=> 'O campo “%2$s” é muito curto, é necessário um mínimo de %1$d caracteres.',
	),
	'FIELD_TOO_LONG'					=> array(
		1	=> 'O campo “%2$s” é muito extenso, o máximo permitido é %1$d carácter.',
		2	=> 'O campo “%2$s” é muito extenso, o máximo permitido são %1$d caracteres.',
	),
	'FIELD_TOO_SMALL'							=> 'O valor de “%2$s” é muito pequeno, o valor mínimo necessário é %1$d.',
	'FIELD_TOO_LARGE'							=> 'O valor de “%2$s” é muito grande, o valor máximo permitido é %1$d.',
	'FIELD_INVALID_CHARS_INVALID'				=> 'O Campo “%s” tem caracteres inválidos.',
	'FIELD_INVALID_CHARS_NUMBERS_ONLY'			=> 'O Campo “%s” tem caracteres inválidos. São permitidos apenas números.',
	'FIELD_INVALID_CHARS_ALPHA_DOTS'			=> 'O Campo “%s” tem caracteres inválidos. São permitidos apenas o . e caracteres alfanuméricos.',
	'FIELD_INVALID_CHARS_ALPHA_ONLY'			=> 'O Campo “%s” tem caracteres inválidos. São permitidos apenas caracteres alfanuméricos.',
	'FIELD_INVALID_CHARS_ALPHA_PUNCTUATION'			=> 'O Campo “%s” tem caracteres inválidos. São permitidos apenas os _,-. e caracteres alfanuméricos. O primeiro carácter tem que ser alfanumérico.',
	'FIELD_INVALID_CHARS_ALPHA_SPACERS'				=> 'O campo “%s” tem caracteres inválidos. São permitidos apenas o espaço ou -+_[] e caracteres alfanuméricos.',
	'FIELD_INVALID_CHARS_ALPHA_UNDERSCORE'			=> 'O campo “%s” tem caracteres inválidos. São permitidos apenas o _ e caracteres alfanuméricos.',
	'FIELD_INVALID_CHARS_LETTER_NUM_DOTS'			=> 'O campo “%s” tem caracteres inválidos. São permitidos apenas letras, números ou . (ponto).',
	'FIELD_INVALID_CHARS_LETTER_NUM_ONLY'			=> 'O campo “%s” tem caracteres inválidos. São permitidos apenas letras e números.',
	'FIELD_INVALID_CHARS_LETTER_NUM_PUNCTUATION'	=> 'O campo “%s” tem caracteres inválidos. São permitidos apenas letras, números ou _,-. e o primeiro carácter tem que ser alfabético.',
	'FIELD_INVALID_CHARS_LETTER_NUM_SPACERS'		=> 'O campo “%s” tem caracteres inválidos. São permitidos apenas letras, números, espaço ou -+_[].',
	'FIELD_INVALID_CHARS_LETTER_NUM_UNDERSCORE'		=> 'O campo “%s” tem caracteres inválidos. São permitidos apenas letras, números ou _.',
	'FIELD_INVALID_DATE'				=> 'O Campo “%s” tem uma data inválida.',
	'FIELD_INVALID_URL'					=> 'O Campo “%s” tem uma url inválida.',
	'FIELD_INVALID_VALUE'				=> 'O Campo “%s” tem um valor inválido.',

	'FOE_MESSAGE'						=> 'Mensagem de um Inimigo',
	'FOES_EXPLAIN'						=> 'Inimigos são Utilizadores que serão ignorados. As Mensagens destes Utilizadores não serão totalmente visíveis e as Mensagens Privadas não são autorizadas. No entanto não pode ignorar Administradores ou Moderadores.',
	'FOES_UPDATED'						=> 'A sua Lista de Inimigos foi atualizada com sucesso.',
	'FOLDER_ADDED'						=> 'A Pasta foi adicionada com sucesso.',
	'FOLDER_MESSAGE_STATUS'		=> array(
		1	=> '%2$d de %1$s guardada',
		2	=> '%2$d de %1$s guardadas',
	),
	'FOLDER_NAME_EMPTY'			=> 'Tem que atribuir um nome a esta pasta.',
	'FOLDER_NAME_EXIST'			=> 'A Pasta <strong>%s</strong> já existe.',
	'FOLDER_OPTIONS'			=> 'Opções da pasta',
	'FOLDER_RENAMED'			=> 'Pasta renomeada com sucesso.',
	'FOLDER_REMOVED'			=> 'Pasta apagada com sucesso.',
	'FOLDER_STATUS_MSG'			=> array(
		1	=> 'A pasta está %3$d%% preenchida (%2$d de %1$s guardada)',
		2	=> 'A pasta está %3$d%% preenchida (%2$d de %1$s guardadas)',
	),
	'FORWARD_PM'						=> 'Próxima MP',
	'FORCE_PASSWORD_EXPLAIN'			=> 'Antes de continuar, é necessário alterar a sua senha.',
	'FRIEND_MESSAGE'					=> 'Mensagem de um Amigo',
	'FRIENDS'							=> 'Amigos',
	'FRIENDS_EXPLAIN'					=> 'Os Amigos permitem o acesso rápido aos Utilizadores com quem comunica frequentemente. As Mensagens dos Amigos só serão destacadas se o Tema do Fórum o permitir.',
	'FRIENDS_OFFLINE'					=> 'Desligado',
	'FRIENDS_ONLINE'					=> 'Ligado',
	'FRIENDS_UPDATED'					=> 'A sua Lista de Amigos foi atualizada com sucesso.',
	'FULL_FOLDER_OPTION_CHANGED'		=> 'Opções de Pasta cheia alteradas com sucesso.',
	'FWD_ORIGINAL_MESSAGE'				=> '-------- Mensagem Original --------',
	'FWD_SUBJECT'						=> 'Título: %s',
	'FWD_DATE'							=> 'Data: %s',
	'FWD_FROM'							=> 'De: %s',
	'FWD_TO'							=> 'Para: %s',

	'GLOBAL_ANNOUNCEMENT'				=> 'Anúncio Global',

	'GRAVATAR_AVATAR_EMAIL'				=> 'Email Gravatar',
	'GRAVATAR_AVATAR_EMAIL_EXPLAIN'		=> 'Endereço de email que usou no registo da sua conta em <a href="http://www.gravatar.com/">Gravatar</a>.',
	'GRAVATAR_AVATAR_SIZE'				=> 'Dimensões do Avatar',
	'GRAVATAR_AVATAR_SIZE_EXPLAIN'		=> 'Especifique a largura e a altura do avatar, deixe em branco para tentar verificação automática.',

	'HIDE_ONLINE'						=> 'Ocultar o meu Estado Ligado',
	'HIDE_ONLINE_EXPLAIN'				=> 'Ficará invisível na próxima visita ao Fórum.',
	'HOLD_NEW_MESSAGES'					=> 'Não serão aceites novas Mensagens (As Mensagens novas serão mantidas até haver espaço disponível)',
	'HOLD_NEW_MESSAGES_SHORT'			=> 'Manter as Mensagens novas',

	'IF_FOLDER_FULL'					=> 'Se a Pasta estiver cheia',
	'IMPORTANT_NEWS'					=> 'Anúncios Importantes',
	'INVALID_USER_BIRTHDAY'				=> 'A data de nascimento não é válida.',
	'INVALID_CHARS_USERNAME'			=> 'O Nome de utilizador contém caracteres proibidos.',
	'INVALID_EMOJIS_USERNAME'			=> 'O Nome de utilizador contém caracteres proibidos (Emoji).',
	'INVALID_CHARS_NEW_PASSWORD'		=> 'A Senha não tem os caracteres exigidos.',
	'ITEMS_REQUIRED'					=> 'Os itens marcados com * são campos de preenchimento obrigatório.',

	'JOIN_SELECTED'						=> 'Aderir ao selecionado',

	'LANGUAGE'							=> 'Idioma',
	'LINK_REMOTE_AVATAR'				=> 'Atalho Remoto',
	'LINK_REMOTE_AVATAR_EXPLAIN'		=> 'Indique a URL do local que contém a imagem de Avatar que deseja.',
	'LINK_REMOTE_SIZE'					=> 'Dimensões do Avatar',
	'LINK_REMOTE_SIZE_EXPLAIN'			=> 'Especifique a Largura e Altura do Avatar. Deixe espaço em branco para tentar a verificação automática.',
	'LOGIN_EXPLAIN_UCP'					=> 'Tem que estar ligado para entrar no Painel de Controlo do Utilizador.',
	'LOGIN_LINK'						=> 'Entre ou registe-se, usando um serviço externo à sua conta, no Fórum',
	'LOGIN_LINK_EXPLAIN'				=> 'Tentou entrar usando um serviço externo que ainda não está associado a uma conta deste fórum. Associe-se a uma conta existente ou crie uma nova conta.',
	'LOGIN_LINK_MISSING_DATA'			=> 'Os dados necessários para associar a sua conta a um serviço externo não estão disponíveis. Reinicie o processo.',
	'LOGIN_LINK_NO_DATA_PROVIDED'		=> 'Não foi fornecido nenhum dado para associar a sua conta externa à conta do Fórum. Se o problema persistir contacte um administrador do Fórum.',
	'LOGIN_KEY'							=> 'Chave de acesso',
	'LOGIN_TIME'						=> 'Hora de acesso',
	'LOGIN_REDIRECT'					=> 'A sua sessão foi iniciada.',
	'LOGOUT_FAILED'						=> 'A sua sessão não foi encerrada. Se continuar tendo este problema contacte um Administrador.',
	'LOGOUT_REDIRECT'					=> 'A sua sessão foi encerrada.',

	'MARK_IMPORTANT'					=> 'Marcar/Desmarcar como Importante',
	'MARKED_MESSAGE'					=> 'Mensagem Selecionada',
	'MAX_FOLDER_REACHED'				=> 'Foi atingido o número máximo de pastas permitidas aos Utilizadores.',
	'MESSAGE_BY_AUTHOR'					=> 'por',
	'MESSAGE_COLOURS'					=> 'Cores da Mensagem',
	'MESSAGE_DELETED'					=> 'A Mensagem selecionada foi apagada com sucesso.',
	'MESSAGE_EDITED'					=> 'Mensagem editada com sucesso.',
	'MESSAGE_HISTORY'					=> 'Histórico de Mensagens',
	'MESSAGE_REMOVED_FROM_OUTBOX'		=> 'Esta mensagem foi apagada pelo autor.',
	'MESSAGE_REPORTED_MESSAGE'			=> 'Mensagem denunciada',
	'MESSAGE_SENT_ON'					=> 'em',
	'MESSAGE_STORED'					=> 'A Mensagem foi enviada com sucesso.',
	'MESSAGE_TO'						=> 'Para',
	'MESSAGES_DELETED'					=> 'Mensagens apagada',
	'MOVE_DELETED_MESSAGES_TO'			=> 'Mover mensagens da pasta apagada para',
	'MOVE_DOWN'							=> 'Mover - Baixo',
	'MOVE_MARKED_TO_FOLDER'				=> 'Mover selecionados para %s',
	'MOVE_PM_ERROR'					=> array(
		1	=> 'Ocorreu um erro enquanto eram as mensagens eram movidas para a nova pasta, apenas %2$d de %1$s foi movida.',
		2	=> 'Ocorreu um erro enquanto eram as mensagens eram movidas para a nova pasta, apenas %2$d de %1$s foram movidas.',
	),
	'MOVE_TO_FOLDER'				=> 'Mover para a pasta',
	'MOVE_UP'						=> 'Mover para cima',

	'NEW_FOLDER_NAME'					=> 'Nome da nova Pasta',
	'NEW_PASSWORD'						=> 'Nova Senha',
	'NEW_PASSWORD_CONFIRM_EMPTY'		=> 'Não digitou a Senha de confirmação.',
	'NEW_PASSWORD_ERROR'				=> 'As Senhas indicadas não coincidem.',

	'NOTIFICATIONS_MARK_ALL_READ'			=> 'Marcar todas as notificações como lidas',
	'NOTIFICATIONS_MARK_ALL_READ_CONFIRM'	=> 'Tem a certeza que quer marcar todas as notificações como lidas?',
	'NOTIFICATIONS_MARK_ALL_READ_SUCCESS'	=> 'Todas as notificações foram marcadas como lidas.',
	'NOTIFICATION_GROUP_MISCELLANEOUS'		=> 'Notificações diversas',
	'NOTIFICATION_GROUP_MODERATION'			=> 'Notificações de Moderação',
	'NOTIFICATION_GROUP_ADMINISTRATION'		=> 'Notificações da Administração',
	'NOTIFICATION_GROUP_POSTING'			=> 'Notificações de Mensagens',
	'NOTIFICATION_METHOD_BOARD'				=> 'Notificações',
	'NOTIFICATION_METHOD_EMAIL'				=> 'Email',
	'NOTIFICATION_METHOD_JABBER'			=> 'Jabber',
	'NOTIFICATION_TYPE'						=> 'Tipo de Notificação',
	'NOTIFICATION_TYPE_BOOKMARK'			=> 'Alguém respondeu a um tópico que adicionou aos seus favoritos',
	'NOTIFICATION_TYPE_GROUP_REQUEST'			=> 'Alguém pediu para se juntar ao grupo que lidera',
	'NOTIFICATION_TYPE_FORUM'							=> 'Alguém responde a um tópico em um fórum no qual está subscrito',
	'NOTIFICATION_TYPE_IN_MODERATION_QUEUE'		=> 'Uma mensagem ou tópico precisa de aprovação',
	'NOTIFICATION_TYPE_MODERATION_QUEUE'	=> 'Os teus tópicos/mensagens foram aprovados ou desaprovados por um moderador',
	'NOTIFICATION_TYPE_PM'					=> 'Alguém te mandou uma mensagem privada',
	'NOTIFICATION_TYPE_POST'				=> 'Alguém respondeu a um tópico que estás a observar',
	'NOTIFICATION_TYPE_QUOTE'				=> 'Alguém te citou numa mensagem',
	'NOTIFICATION_TYPE_REPORT'				=> 'Alguém denunciou uma mensagem',
	'NOTIFICATION_TYPE_REPORT_CLOSED'					=> 'A sua mensagem denunciada foi fechada por um moderador',
	'NOTIFICATION_TYPE_REPORT_PM'						=> 'Alguém denuncia uma mensagem privada',
	'NOTIFICATION_TYPE_REPORT_PM_CLOSED'				=> 'A sua mensagem privada denunciada foi fechada por um moderador',
	'NOTIFICATION_TYPE_TOPIC'				=> 'Alguém criou um tópico num fórum que estás a observar',
	'NOTIFICATION_TYPE_ADMIN_ACTIVATE_USER'	=> 'Há um novo utilizador que precisa de ativação',

	'NOTIFY_METHOD'						=> 'Método de Notificação',
	'NOTIFY_METHOD_BOTH'				=> 'Ambos',
	'NOTIFY_METHOD_EMAIL'				=> 'Apenas email',
	'NOTIFY_METHOD_EXPLAIN'				=> 'Método para enviar Mensagens enviadas por este painel.',
	'NOTIFY_METHOD_IM'					=> 'Apenas Jabber',
	'NOTIFY_ON_PM'						=> 'Avisar-me por email de novas Mensagens Privadas',
	'NOT_ADDED_FRIENDS_ANONYMOUS'		=> 'Não pode adicionar um Visitante à sua Lista de Amigos.',
	'NOT_ADDED_FRIENDS_BOTS'			=> 'Não pode adicionar Motores de Busca à sua lista de amigos.',
	'NOT_ADDED_FRIENDS_FOES'			=> 'Não pode adicionar Inimigos à sua Lista de Amigos.',
	'NOT_ADDED_FRIENDS_SELF'			=> 'Não pode auto adicionar-se à sua Lista de Amigos.',
	'NOT_ADDED_FOES_MOD_ADMIN'			=> 'Não pode adicionar Administradores ou Moderadores à sua Lista de Inimigos.',
	'NOT_ADDED_FOES_ANONYMOUS'			=> 'Não pode adicionar um Visitante à sua Lista de Inimigos.',
	'NOT_ADDED_FOES_BOTS'				=> 'Não pode adicionar Motores de Busca à sua Lista de Inimigos.',
	'NOT_ADDED_FOES_FRIENDS'			=> 'Não pode adicionar Amigos à sua Lista de Inimigos.',
	'NOT_ADDED_FOES_SELF'				=> 'Não pode auto adicionar-se à sua Lista de Inimigos.',
	'NOT_AGREE'							=> 'Li e não concordo com estas condições',
	'NOT_ENOUGH_SPACE_FOLDER'			=> 'A Pasta de Destino “%s” parece estar cheia. O seu pedido não foi executado.',
	'NOT_MOVED_MESSAGES'			=> array(
		1	=> 'Tem atualmente %d mensagem privada em espera porque tem a pasta cheia.',
		2	=> 'Tem atualmente %d mensagens privadas em espera porque tem a pasta cheia.',
	),
	'NO_ACTION_MODE'					=> 'Não foi selecionada uma ação para esta Mensagem.',
	'NO_AUTHOR'							=> 'Nenhum Autor definido para esta Mensagem',
	'NO_AVATAR'							=> 'Não há Avatar selecionado',
	'NO_AVATAR_CATEGORY'				=> 'Nenhum',

	'NO_AUTH_DELETE_MESSAGE'			=> 'Apagar Mensagens Privadas: Proibido.',
	'NO_AUTH_EDIT_MESSAGE'				=> 'Editar Mensagens Privadas: Proibido.',
	'NO_AUTH_FORWARD_MESSAGE'			=> 'Responder Mensagens Privadas: Proibido.',
	'NO_AUTH_GROUP_MESSAGE'				=> 'Enviar Mensagens Privadas para Grupos: Proibido.',
	'NO_AUTH_PRINT_MESSAGE'				=> 'Não está autorizado a imprimir mensagens privadas.',
	'NO_AUTH_PROFILEINFO'				=> 'Não está autorizado a alterar as informações do seu perfil.',
	'NO_AUTH_READ_HOLD_MESSAGE'			=> 'Não está autorizado a ler Mensagens Privadas que estejam em espera.',
	'NO_AUTH_READ_MESSAGE'				=> 'Ler Mensagens Privadas: Proibido.',
	'NO_AUTH_READ_REMOVED_MESSAGE'		=> 'Ler Mensagens Privadas apagadas pelo autor: Proibido.',
	'NO_AUTH_SEND_MESSAGE'				=> 'Enviar Mensagens Privadas: Proibido.',
	'NO_AUTH_SIGNATURE'					=> 'Definir a sua Assinatura: Proibido.',

	'NO_BCC_RECIPIENT'					=> 'Nenhum',
	'NO_BOOKMARKS'						=> 'Não tem Favoritos.',
	'NO_BOOKMARKS_SELECTED'				=> 'Não selecionou nenhum favorito.',
	'NO_EDIT_READ_MESSAGE'				=> 'A mensagem privada não pode ser editada porque já foi lida.',
	'NO_EMAIL_USER'						=> 'O Nome de Utilizador/Endereço de email indicados não foram encontrados.',
	'EMAIL_NOT_UNIQUE'					=> 'O E-mail especificado é usado por vários utilizadores. Também deve especificar o nome de utilizador.',
	'NO_FOES'							=> 'Não tem Inimigos definidos.',
	'NO_FRIENDS'						=> 'Não tem Amigos definidos.',
	'NO_FRIENDS_OFFLINE'				=> 'Nenhum Amigo Desligado',
	'NO_FRIENDS_ONLINE'					=> 'Nenhum Amigo Ligado',
	'NO_GROUP_SELECTED'					=> 'Nenhum Grupo especificado.',
	'NO_IMPORTANT_NEWS'					=> 'Nenhum Anúncio importante atual.',
	'NO_MESSAGE'						=> 'A Mensagem Privada selecionada não existe.',
	'NO_NEW_FOLDER_NAME'				=> 'Deve especificar um novo nome para a pasta.',
	'NO_NEWER_PM'						=> 'Nenhuma Mensagem Nova.',
	'NO_OLDER_PM'						=> 'Nenhuma Mensagem Antiga.',
	'NO_PASSWORD_SUPPLIED'				=> 'Não pode entrar sem uma senha.',
	'NO_RECIPIENT'						=> 'Nenhum Destinatário Definido.',
	'NO_RESET_TOKEN'					=> 'Você não solicitou o token para redefinição de senha.',
	'NO_RULES_DEFINED'					=> 'Não há Regras Definidas.',
	'NO_SAVED_DRAFTS'					=> 'Não há rascunhos guardados.',
	'NO_TO_RECIPIENT'					=> 'Nenhum',
	'NO_WATCHED_FORUMS'					=> 'Não está a observar nenhum Fórum.',
	'NO_WATCHED_SELECTED'				=> 'Não selecionou nenhum Tópico ou Fórum Observado.',
	'NO_WATCHED_TOPICS'					=> 'Não está a observar nenhum Tópico.',

	'PASS_TYPE_ALPHA_EXPLAIN'			=> 'A senha deve ter no minímo %1$s caracteres e possuir letras maiúsculas e minúsculas e números.',
	'PASS_TYPE_ANY_EXPLAIN'				=> 'Deve ter no minímo %1$s caracteres.',
	'PASS_TYPE_CASE_EXPLAIN'			=> 'A senha deve ter no minímo %1$s caracteres e possuir letras maiúsculas e minúsculas.',
	'PASS_TYPE_SYMBOL_EXPLAIN'			=> 'A senha deve ter no minímo %1$s caracteres e deve conter letras maiúsculas e minúsculas, números e símbolos.',
	'PASSWORD'							=> 'Senha',
	'PASSWORD_ACTIVATED'				=> 'A sua Nova Senha foi ativada.',
	'PASSWORD_RESET'					=> 'A sua senha foi redefinida com sucesso.',
	'PASSWORD_RESET_LINK_SENT'			=> 'Se a sua conta existir, um link para redefinição de senha foi enviado para o seu endereço de e-mail registrado. Se não receber um e-mail, pode ser porque esteja banido, sua conta não está ativada, solicitou várias redefinições de senha em um curto período de tempo ou não tem permissão para alterar sua senha. Entre em contato com o Administrador se algum desses motivos se aplicar. Além disso, verifique o seu filtro de spam',
	'PERMISSIONS_RESTORED'				=> 'As suas permissões originais foram restauradas com sucesso.',
	'PERMISSIONS_TRANSFERRED'			=> 'As Permissões foram transferidas do <strong>%s</strong> com sucesso. Agora, pode navegar com as Permissões do Utilizador. <br />As Permissões de Administrador não foram transferidas. Pode voltar as suas Permissões originais em qualquer momento.',
	'PM_DISABLED'						=> 'As Mensagens Privadas estão inativas.',
	'PM_FROM'							=> 'De',
	'PM_FROM_REMOVED_AUTHOR'			=> 'Esta Mensagem foi enviada por um utilizador não Registado.',
	'PM_ICON'							=> 'Ícone da Mensagem Privada',
	'PM_INBOX'							=> 'Caixa de Entrada',
	'PM_MARK_ALL_READ'					=> 'Marcar todas as mensagens como lidas',
	'PM_MARK_ALL_READ_SUCCESS'			=> 'Todas as mensagens privadas nesta pasta foram marcadas como lidas',
	'PM_NO_USERS'						=> 'O utilizador adicionado não existe.',
	'PM_OUTBOX'							=> 'Caixa de Saída',
	'PM_SENTBOX'						=> 'Mensagens enviadas',
	'PM_SUBJECT'						=> 'Título',
	'PM_TO'								=> 'Enviar para',
	'PM_TOOLS'							=> 'Ferramentas de Mensagens Privadas',
	'PM_USERS_REMOVED_NO_PERMISSION'	=> 'Alguns Utilizadores não podem ser adicionados porque não têm permissão para ler Mensagens Privadas.',
	'PM_USERS_REMOVED_NO_PM'			=> 'Alguns Utilizadores adicionados estão com a função de Mensagem Privada desativada e não poderão receber a Mensagem.',
	'POST_EDIT_PM'						=> 'Editar Mensagem',
	'POST_FORWARD_PM'					=> 'Encaminhar Mensagem',
	'POST_NEW_PM'						=> 'Criar Mensagem',
	'POST_PM_LOCKED'					=> 'Mensagem Privada bloqueada',
	'POST_PM_POST'						=> 'Citar Mensagem',
	'POST_QUOTE_PM'						=> 'Citar Mensagem Privada',
	'POST_REPLY_PM'						=> 'Responder à Mensagem',
	'PRINT_PM'							=> 'Imprimir Mensagem Privada',
	'PREFERENCES_UPDATED'				=> 'As suas Preferências foram atualizadas.',
	'PROFILE_INFO_NOTICE'				=> 'Estas informações serão visíveis por todos os Utilizadores. Verifique se deseja incluir os seus dados pessoais. Todos os campos marcados com (*) são de preenchimento obrigatório.',
	'PROFILE_UPDATED'					=> 'O seu Perfil foi atualizado.',
	'PROFILE_AUTOLOGIN_KEYS'			=> 'As chaves de acesso “Lembrar-me” permitem que entre automaticamente quando visita o fórum. Caso desligue, essa chave de acesso é apagada apenas no computador onde decidiu se desligar. Poderá ver aqui todas as chaves de acesso criadas noutros computadores.',
	'PROFILE_NO_AUTOLOGIN_KEYS'			=> 'Não existem chaves de acesso “Lembrar-me” guardadas.',

	'RECIPIENT'							=> 'Destinatário',
	'RECIPIENTS'						=> 'Destinatários',
	'REGISTRATION'						=> 'Registo',
	'OAUTH_REGISTRATION'				=> 'Registro usando serviços externos',
	'RELEASE_MESSAGES'					=> 'Clique %saqui%s para libertar as Mensagens em espera, as mesmas serão reorganizadas na pasta apropriada se houver espaço suficiente.',
	'REMOVE_ADDRESS'					=> 'Apagar endereço',
	'REMOVE_SELECTED_BOOKMARKS'			=> 'Apagar Favoritos selecionados',
	'REMOVE_SELECTED_BOOKMARKS_CONFIRM'	=> 'Tem a certeza que deseja remover todos os Favoritos selecionados?',
	'REMOVE_BOOKMARK_MARKED'			=> 'Apagar Favoritos selecionados ',
	'REMOVE_FOLDER'						=> 'Remover pasta',
	'REMOVE_FOLDER_CONFIRM'				=> 'Tem a certeza que deseja remover esta pasta?',
	'RENAME'							=> 'Renomear',
	'RENAME_FOLDER'						=> 'Renomear Pasta',
	'REPLIED_MESSAGE'					=> 'Mensagens Respondidas',
	'REPLY_TO_ALL'						=> 'Responder ao remetente e a todos os destinatários.',
	'REPORT_PM'							=> 'Denunciar mensagem privada',
	'RESET_PASSWORD'					=> 'Redefinir senha',
	'RESET_TOKEN_EXPIRED_OR_INVALID'	=> 'O token para redefinir a senha que você forneceu é inválido ou expirou.',
	'RESIGN_SELECTED'					=> 'Retirar selecionado',
	'RETURN_FOLDER'						=> 'Clique %1$sAqui%2$s para voltar à Pasta',
	'RETURN_UCP'						=> 'Clique %saqui%s para voltar ao Painel de Controlo do Utilizador',
	'RULE_ADDED'						=> 'A Regra foi adicionada com sucesso.',
	'RULE_ALREADY_DEFINED'				=> 'Esta Regra estava previamente definida.',
	'RULE_DELETED'						=> 'A Regra foi apagada com sucesso.',
	'RULE_LIMIT_REACHED'				=> 'Não pode adicionar mais regras para as mensagens privadas. Atingiu o número máximo.',
	'RULE_NOT_DEFINED'					=> 'Regra não especificada corretamente.',
	'RULE_REMOVED_MESSAGES'				=> array(
		1	=> '%d mensagem privada foi apagada pelo filtro de mensagens privadas.',
		2	=> '%d mensagens privadas foram apagadas pelo filtro de mensagens privadas.',
	),

	'SAME_PASSWORD_ERROR'				=> 'A nova Senha introduzida é igual à sua senha atual.',
	'SEARCH_YOUR_POSTS'					=> 'Mostrar todas as minhas Mensagens',
	'SENT_AT'							=> 'Enviado em',			// Used before dates in private messages
	'SHOW_EMAIL'						=> 'Os utilizadores podem contactar-me por email',
	'SIGNATURE_EXPLAIN'					=> 'Escreva aqui a Assinatura que por defeito será adicionada a todas a Mensagens. O limite é de %d caracteres.',
	'SIGNATURE_PREVIEW'					=> 'Previsão da Assinatura',
	'SIGNATURE_TOO_LONG'				=> 'A sua Assinatura é muito grande.',
	'SELECT_CURRENT_TIME'				=> 'Selecione a hora atual',
	'SELECT_TIMEZONE'					=> 'Selecione o fuso horário',
	'SORT'								=> 'Ordenar',
	'SORT_COMMENT'						=> 'Descrições do Ficheiro',
	'SORT_DOWNLOADS'					=> 'Transferências',
	'SORT_EXTENSION'					=> 'Extensão',
	'SORT_FILENAME'						=> 'Nome do Ficheiro',
	'SORT_POST_TIME'					=> 'Data do Anexo',
	'SORT_SIZE'							=> 'Tamanho do Ficheiro',

	'TIMEZONE'							=> 'Fuso Horário',
	'TIMEZONE_DATE_SUGGESTION'			=> 'Sugestão: %s',
	'TIMEZONE_INVALID'					=> 'O fuso horário que selecionou é inválido.',
	'TO'								=> 'Para',
	'TO_MASS'							=> 'Destinatários',
	'TO_ADD'							=> 'Adicionar destinatário',
	'TO_ADD_MASS'						=> 'Adicionar destinatários',
	'TO_ADD_GROUPS'						=> 'Adicionar grupos',
	'TOO_MANY_RECIPIENTS'				=> 'Tentou enviar uma mensagem privada a demasiados destinatários.',
	'TOO_MANY_REGISTERS'				=> 'Excedeu o número máximo de tentativas de Registo para esta sessão. Tente novamente mais tarde.',

	'UCP'							=> 'Painel de Controlo do Utilizador',
	'UCP_ACTIVATE'					=> 'Ativar Registo',
	'UCP_ADMIN_ACTIVATE'			=> 'Tem de introduzir um endereço de email válido para que o Registo seja ativado. O Administrador verificará o seu Registo, e, se for Aprovado, receberá um email para ativar a sua conta.',
	'UCP_ATTACHMENTS'				=> 'Anexos',
	'UCP_AUTH_LINK'					=> 'Contas externas',
	'UCP_AUTH_LINK_ASK'				=> 'Atualmente não tem nenhuma conta associada a este serviço externo. Clique no botão abaixo para vincular a sua conta no Fórum a uma conta neste serviço externo.',
	'UCP_AUTH_LINK_ID'				=> 'Identificador exclusivo',
	'UCP_AUTH_LINK_LINK'			=> 'Vincular',
	'UCP_AUTH_LINK_MANAGE'			=> 'Administrar associações a contas externas',
	'UCP_AUTH_LINK_NOT_SUPPORTED'	=> 'Associar contas a serviços externos não é suportado pelo método de autenticação usado atualmente por este fórum.',
	'UCP_AUTH_LINK_TITLE'			=> 'Administrar as suas associações a contas externas',
	'UCP_AUTH_LINK_UNLINK'			=> 'Desvincular',
	'UCP_COPPA_BEFORE'				=> 'Tenho mais de 13 anos. Nasci antes de %s.',
	'UCP_COPPA_ON_AFTER'			=> 'Tenho menos de 13 anos. Nasci depois de %s.',
	'UCP_EMAIL_ACTIVATE'			=> 'Use um email válido para receber o email que permitirá ativar a sua conta e entrar no Fórum.',
	'UCP_JABBER'					=> 'Endereço Jabber',
	'UCP_LOGIN_LINK'				=> 'Configurar a uma conta externa',

	'UCP_MAIN'							=> 'Geral',
	'UCP_MAIN_ATTACHMENTS'				=> 'Anexos',
	'UCP_MAIN_BOOKMARKS'				=> 'Administrar Favoritos',
	'UCP_MAIN_DRAFTS'					=> 'Rascunhos Guardados',
	'UCP_MAIN_FRONT'					=> 'Página Principal',
	'UCP_MAIN_SUBSCRIBED'				=> 'Administrar Observações',

	'UCP_NO_ATTACHMENTS'				=> 'Não enviou nenhum anexo.',

	'UCP_NOTIFICATION_LIST'				=> 'Gerir notificações',
	'UCP_NOTIFICATION_LIST_EXPLAIN'		=> 'Aqui pode ver todas as notificações prévias.',
	'UCP_NOTIFICATION_OPTIONS'			=> 'Editar opções de notificação',
	'UCP_NOTIFICATION_OPTIONS_EXPLAIN'	=> 'Aqui pode definir os seus métodos de notificação preferenciais do Fórum.',

	'UCP_PREFS'							=> 'Preferências',
	'UCP_PREFS_PERSONAL'				=> 'Configurações Pessoais',
	'UCP_PREFS_POST'					=> 'Mensagens enviadas',
	'UCP_PREFS_VIEW'					=> 'A ver Mensagens',

	'UCP_PM'							=> 'Mensagens Privadas',
	'UCP_PM_COMPOSE'					=> 'Criar Mensagem Privada',
	'UCP_PM_DRAFTS'						=> 'Rascunhos',
	'UCP_PM_OPTIONS'					=> 'Opções',
	'UCP_PM_UNREAD'						=> 'Mensagens não lidas',
	'UCP_PM_VIEW'						=> 'Ver Mensagens',

	'UCP_PROFILE'						=> 'Perfil',
	'UCP_PROFILE_AVATAR'				=> 'O seu Avatar',
	'UCP_PROFILE_PROFILE_INFO'			=> 'O seu Perfil',
	'UCP_PROFILE_REG_DETAILS'			=> 'Detalhes do seu Registo',
	'UCP_PROFILE_SIGNATURE'				=> 'A sua assinatura',
	'UCP_PROFILE_AUTOLOGIN_KEYS'		=> 'Gerir as chaves “Lembrar-me”',

	'UCP_USERGROUPS'					=> 'Grupos de Utilizadores',
	'UCP_USERGROUPS_MEMBER'				=> 'Editar Inscrições em Grupos',
	'UCP_USERGROUPS_MANAGE'				=> 'Administrar Grupos',

	'UCP_PASSWORD_RESET_DISABLED'		=> 'A funcionalidade de alteração da senha foi desativada. Se precisa de ajuda para entrar na sua conta, por favor contacte o %sAdministrador do Fórum%s',
	'UCP_REGISTER_DISABLE'				=> 'Não é possível criar novos Registos.',
	'UCP_RESEND'						=> 'Enviar email de Ativação',
	'UCP_WELCOME'						=> 'Bem-vindo ao Painel de Controlo do Utilizador. Aqui pode ver e atualizar o seu Perfil, as suas Preferências, observar Fóruns e Tópicos. Pode enviar Mensagens a outros Utilizadores (se permitido). Verifique se leu todos os anúncios.',
	'UCP_ZEBRA'							=> 'Amigos e Inimigos',
	'UCP_ZEBRA_FOES'					=> 'Inimigos',
	'UCP_ZEBRA_FRIENDS'					=> 'Amigos',
	'UNDISCLOSED_RECIPIENT'				=> 'Sem destinatário',
	'UNKNOWN_FOLDER'					=> 'Pasta Desconhecida',
	'UNWATCH_MARKED'					=> 'Parar de observar selecionados',
	'UPLOAD_AVATAR_FILE'				=> 'Enviar do seu Computador',
	'UPLOAD_AVATAR_URL'					=> 'Enviar de uma URL',
	'UPLOAD_AVATAR_URL_EXPLAIN'			=> 'Insira a URL da imagem que pretende usar no Fórum.',
	'USERNAME_ALPHA_ONLY_EXPLAIN'		=> 'Tem que ter entre %1$s e %2$s alfanuméricos.',
	'USERNAME_ALPHA_SPACERS_EXPLAIN'	=> 'Tem que ter entre %1$s e %2$s alfanuméricos, espaços ou -+_[].',
	'USERNAME_ASCII_EXPLAIN'			=> 'Tem que ter entre %1$s e %2$s ASCII, ou seja, sem símbolos especiais.',
	'USERNAME_LETTER_NUM_EXPLAIN'		=> 'Tem que ter entre %1$s e %2$s, apenas letras ou números.',
	'USERNAME_LETTER_NUM_SPACERS_EXPLAIN'	=> 'Tem que ter entre %1$s e %2$s, letras, números, espaço ou +-[].',
	'USERNAME_CHARS_ANY_EXPLAIN'		=> 'Tem que ter entre %1$s e %2$s.',
	'USERNAME_TAKEN_USERNAME'			=> 'O Nome de utilizador que escolheu já existe.',
	'USERNAME_DISALLOWED_USERNAME'		=> 'O Nome de Utilizador que escolheu foi proibido ou contém uma palavra censurada. Escolha um diferente.',
	'USER_NOT_FOUND_OR_INACTIVE'		=> 'O Nome de utilizador que escreveu não pode ser encontrado ou está inativo.',

	'VIEW_AVATARS'						=> 'Mostrar Avatares',
	'VIEW_EDIT'							=> 'Ver/Editar',
	'VIEW_FLASH'						=> 'Mostrar Animações em Flash',
	'VIEW_IMAGES'						=> 'Mostrar imagens nas Mensagens',
	'VIEW_NEXT_HISTORY'					=> 'Próxima MP no histórico',
	'VIEW_NEXT_PM'						=> 'Próxima MP',
	'VIEW_PM'							=> 'Ver Mensagem',
	'VIEW_PM_INFO'						=> 'Detalhes da Mensagem',
	'VIEW_PM_MESSAGES'			=> array(
		1	=> '%d mensagem',
		2	=> '%d mensagens',
	),
	'VIEW_PREVIOUS_HISTORY'				=> 'MP Anterior no histórico',
	'VIEW_PREVIOUS_PM'					=> 'MP Anterior',
	'VIEW_PROFILE'						=> 'Ver Perfil',
	'VIEW_SIGS'							=> 'Mostrar Assinaturas',
	'VIEW_SMILIES'						=> 'Mostrar Emoções como Imagens',
	'VIEW_TOPICS_DAYS'					=> 'Mostrar Tópicos do dia anterior',
	'VIEW_TOPICS_DIR'					=> 'Mostrar opções de ordenação de Tópicos',
	'VIEW_TOPICS_KEY'					=> 'Mostrar Tópicos Ordenados por',
	'VIEW_POSTS_DAYS'					=> 'Mostrar Mensagens do dia anterior',
	'VIEW_POSTS_DIR'					=> 'Mostrar opções de ordenação de Mensagens',
	'VIEW_POSTS_KEY'					=> 'Mostrar Mensagens Ordenadas por',

	'WATCHED_EXPLAIN'					=> 'Esta é a lista de Fóruns e Tópicos que está a observar. Será avisado de novas Mensagens em cada um deles. Para cancelar a observação, selecione o Fórum ou Tópico e pressione o botão <em>Parar de observar selecionados</em>.',
	'WATCHED_FORUMS'					=> 'Fóruns observados',
	'WATCHED_TOPICS'					=> 'Tópicos observados',
	'WRONG_ACTIVATION'					=> 'O código de Ativação que forneceu não coincide com o da Base de Dados.',

	'YOUR_DETAILS'						=> 'A sua Atividade',
	'YOUR_FOES'							=> 'Os seus Inimigos',
	'YOUR_FOES_EXPLAIN'					=> 'Para apagar Utilizadores, selecione-os e clique em enviar.',
	'YOUR_FRIENDS'						=> 'Os seus Amigos',
	'YOUR_FRIENDS_EXPLAIN'				=> 'Para apagar os Utilizadores, selecione-os e clique em enviar.',
	'YOUR_WARNINGS'						=> 'O seu número de Avisos',

	'PM_ACTION' => array(
		'PLACE_INTO_FOLDER'				=> 'Colocar na Pasta',
		'MARK_AS_READ'					=> 'Marcar como Lida',
		'MARK_AS_IMPORTANT'				=> 'Marcar como Importante',
		'DELETE_MESSAGE'				=> 'Apagar a Mensagem',
	),
	'PM_CHECK' => array(
		'SUBJECT'						=> 'Assunto',
		'SENDER'						=> 'De',
		'MESSAGE'						=> 'Mensagem',
		'STATUS'						=> 'Estado da Mensagem',
		'TO'							=> 'Para',
	),
	'PM_RULE' => array(
		'IS_LIKE'						=> 'Está como',
		'IS_NOT_LIKE'					=> 'Não está como',
		'IS'							=> 'é',
		'IS_NOT'						=> 'Não é',
		'BEGINS_WITH'					=> 'Inicia com',
		'ENDS_WITH'						=> 'Conclui com',
		'IS_FRIEND'						=> 'é Amigo',
		'IS_FOE'						=> 'é Inimigo',
		'IS_USER'						=> 'é Utilizador',
		'IS_GROUP'						=> 'Está no Grupo de Utilizadores',
		'ANSWERED'						=> 'Respondido',
		'FORWARDED'						=> 'Reencaminhado',
		'TO_GROUP'						=> 'Para Grupo',
		'TO_ME'							=> 'Para mim',
	),

	'GROUPS_EXPLAIN'					=> 'Os Grupos de Utilizadores permitem melhorar a gestão dos membros do Fórum. Logo de início será colocado num grupo específico, que será o seu Grupo Padrão. Este grupo define como poderá aparecer aos outros utilizadores, por exemplo a cor do seu Nome, Avatar, Classificação, etc. Dependendo de como o administrador o definiu, poderá ser-lhe permitido alterar o seu grupo Padrão. Poderá também ser mudado de Grupo ou ser-lhe permitido juntar-se a outros Grupos. Alguns grupos poderão dar-lhe permissões adicionais para ver outros conteúdos ou ter capacidades acrescidas.',
	'GROUP_LEADER'						=> 'Liderança',
	'GROUP_MEMBER'						=> 'Inscrito',
	'GROUP_PENDING'						=> 'Inscrição pendente',
	'GROUP_NONMEMBER'					=> 'Não Inscrito',
	'GROUP_DETAILS'						=> 'Informações do Grupo',

	'NO_LEADER'							=> 'Este Grupo não tem Líderes',
	'NO_MEMBER'							=> 'Este Grupo não tem Utilizadores',
	'NO_PENDING'						=> 'Este Grupo não tem Utilizadores Pendentes',
	'NO_NONMEMBER'						=> 'Nenhum Grupo de Visitantes',
));
