<?php
/**
*
* phpBB 3.3.X Project - Persian Translation
* Translators: PHP-BB.IR Group Meis@M Nobari
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

// Board Settings
$lang = array_merge($lang, array(
	'ACP_BOARD_SETTINGS_EXPLAIN'	=> 'در این بخش می‌توانید تنظیمات ابتدایی تالارتان را اعمال کرده، به آن نام و توضیحات مناسبی وارد کرده و تنظیمات وقت محلی و زبان را تغییر دهید.',
	'BOARD_INDEX_TEXT'				=> 'متن "صفحه اصلی انجمن"',
	'BOARD_INDEX_TEXT_EXPLAIN'		=> 'این متن به جای " صفحه اصلی انجمن" در بالای سایت قرار میگیرد.',
	'BOARD_STYLE'					=> 'قالب انجمن',
	'CUSTOM_DATEFORMAT'				=> 'سفارشی…',
	'DEFAULT_DATE_FORMAT'			=> 'فرمت تاریخ',
	'DEFAULT_DATE_FORMAT_EXPLAIN'	=> 'فرمت تاریخ همان تابع <a href="https://secure.php.net/manual/function.date.php">date()</a> PHP می باشد.',
	'DEFAULT_LANGUAGE'				=> 'زبان پیش‌فرض',
	'DEFAULT_STYLE'					=> 'قالب پیش‌فرض',
	'DEFAULT_STYLE_EXPLAIN'			=> 'قالب پیش‌فرض برای کاربران جدید',
	'DISABLE_BOARD'					=> 'غیرفعال کردن تالار',
	'DISABLE_BOARD_EXPLAIN'			=> 'این گزینه تالار را برای کاربران غیرفعال می کند، می‌توانید توضیحات کوتاهی (حداکثر 250 نویسه) وارد کنید تا به کاربران نمایش داده شود.',
	'DISPLAY_LAST_SUBJECT'			=> 'نمایش آخرین پست‌ها در صفحه اصلی انجمن',
	'DISPLAY_LAST_SUBJECT_EXPLAIN'	=> 'نمایش آخرین پست‌های ارسال شده در لیست انجمن‌ها در صفحه اصلی به عنوان لینک. عنوان هایی که در انجمن‌های دارای گذرواژه و یا کاربردسترسی خواندن به آن‌ها را نداشته باشد نمایش داده نمیشود.',
	'DISPLAY_UNAPPROVED_POSTS'		=> 'نمایش پست‌های تأیید نشده برای نویسنده',
	'DISPLAY_UNAPPROVED_POSTS_EXPLAIN'	=> 'پست‌های تأیید نشده برای نویسنده قابل نمایش است. اما برای مهمانان خیر',
	'GUEST_STYLE' 				=> 'قالب مهمان',
	'GUEST_STYLE_EXPLAIN' 			=> 'قالب انجمن برای مهمانان',
	'OVERRIDE_STYLE'				=> 'لغو قالب کاربر',
	'OVERRIDE_STYLE_EXPLAIN'		=> 'جایگزینی قالب کاربر و مهمان با قالبی که به عنوان پیش‌فرض انتخاب شده است.',
	'SITE_DESC'						=> 'توضیحات سایت',
	'SITE_HOME_TEXT'				=> 'متن صفحه اصلی سایت',
	'SITE_HOME_TEXT_EXPLAIN'		=> 'این متن برای صفحه اصلی سایت استفاده میشود ( پرتال سایت یا لینک های خارجی سایت (',
	'SITE_HOME_URL'					=> 'آدرس صفحه اصلی سایت',
	'SITE_HOME_URL_EXPLAIN'			=> 'آدرس صفحه اصلی سایت یا آدرس خارجی در این قسمت قرار میگیرد که قبل این آدرس قبل از آدرس صفحه اصلی انجمن در بالای سایت جا میگیرد. آدرس وارد شده باید کامل باشد مانند: <samp>http://www.phpbb.com</samp>',
	'SITE_NAME'						=> 'نام انجمن',
	'SYSTEM_TIMEZONE'				=> 'وقت محلی مهمان',
	'SYSTEM_TIMEZONE_EXPLAIN'		=> 'وقت محلی برای کاربران عضو نشده (مهمان ها و ربات ها) کاربران عضو شده هنگام عضویت وقت محلی را تنظیم می کنند.',
	'WARNINGS_EXPIRE'				=> 'تاریخ انقضای هشدار',
	'WARNINGS_EXPIRE_EXPLAIN'		=> 'تعداد روزی که بعد از آن به طور خودکار هشدار داده شده به کاربر حذف خواهد شد. برای دائمی کردن هشدار ها عدد 0 را وارد کنید.',
));

// Board Features
$lang = array_merge($lang, array(
	'ACP_BOARD_FEATURES_EXPLAIN'	=> 'در این بخش می‌توانید چندین ویژگی تالار را فعال و غیرفعال کنید.',

	'ALLOW_ATTACHMENTS'			=> 'پذیرفتن پیوست',
	'ALLOW_BIRTHDAYS'			=> 'پذیرفتن تاریخ تولد',
	'ALLOW_BIRTHDAYS_EXPLAIN'	=> 'پذیرفتن ورود تاریخ تولد و نمایش آن در نمایه. لطفا توجه داشته باشید که تنظیمات بلوک تاریخ تولد که در صفحه اول نمایش داده می شود، متفاوت است.',
	'ALLOW_BOOKMARKS'			=> 'پذیرفتن اضافه کردن موضوع به علایق',
	'ALLOW_BOOKMARKS_EXPLAIN'	=> 'کاربران می توانند موضوعات را به علایق شخصی خود اضافه کنند.',
	'ALLOW_BBCODE'				=> 'پذیرفتن BBCode',
	'ALLOW_FORUM_NOTIFY'		=> 'پذیرفتن عضویت در انجمن‌ها',
	'ALLOW_NAME_CHANGE'			=> 'پذیرفتن تغییر نام کاربری',
	'ALLOW_NO_CENSORS'			=> 'پذیرفتن غیرفعال سازی سانسور کلمات',
	'ALLOW_NO_CENSORS_EXPLAIN'	=> 'کاربران می تواند سانسور خودکار کلمات را در انجمن‌ها و پیام‌های خصوصی غیرفعال کنند.',
	'ALLOW_PM_ATTACHMENTS'		=> 'پذیرفتن پیوست در پیام‌های خصوصی',
	'ALLOW_PM_REPORT'			=> 'پذیرفتن گزارش پیام‌های خصوصی از جانب کاربران',
	'ALLOW_PM_REPORT_EXPLAIN'	=> 'اگر این گزینه فعال باشد کاربران می توانند پیام‌های خصوصی دریافت شده از جانب آن‌ها را به مدیر گزارش دهند،پغام های گزارش شده در کنترل پنل مدیریت برای مدیران قابل نمایش خواهند بود.',
	'ALLOW_QUICK_REPLY'			=> 'پذیرفتن پاسخ سریع',
	'ALLOW_QUICK_REPLY_EXPLAIN'	=> 'با این گزینه می‌توانید پاسخ سریع را غیرفعال کنید. با فعال سازی آن تنظیمات خاص انجمن وجود آن را تشخیص خواهد داد.',
	'ALLOW_QUICK_REPLY_BUTTON'	=> 'ارسال و فعال سازی پاسخ سریع در همه انجمن‌ها',
	'ALLOW_SIG'					=> 'پذیرفتن امضا',
	'ALLOW_SIG_BBCODE'			=> 'پذیرفتن BBCode در امضای کاربران',
	'ALLOW_SIG_FLASH'			=> 'پذیرفتن استفاده از BBCode <code>[FLASH]</code> در امضاها',
	'ALLOW_SIG_IMG'				=> 'پذیرفتن استفاده از BBCode <code>[IMG]</code> در امضاها',
	'ALLOW_SIG_LINKS'			=> 'پذیرفتن استفاده از لینک در امضاها',
	'ALLOW_SIG_LINKS_EXPLAIN'	=> 'اگر BBCode <code>[URL]</code> نمایش داده نشود و automatic/magic URLs غیرفعال باشد',
	'ALLOW_SIG_SMILIES'			=> 'پذیرفتن استفاده از شکلک در امضای کاربران',
	'ALLOW_SMILIES'				=> 'پذیرفتن شکلک',
	'ALLOW_TOPIC_NOTIFY'		=> 'پذیرفتن عضویت در موضوع',
	'BOARD_PM'					=> 'پیام خصوصی',
	'BOARD_PM_EXPLAIN'			=> 'فعال سازی پیام خصوصی برای همه کاربران',
	'ALLOW_BOARD_NOTIFICATIONS' => 'فعال سازی اعلانات تالار',
));

// Avatar Settings
$lang = array_merge($lang, array(
	'ACP_AVATAR_SETTINGS_EXPLAIN'	=> 'آواتار ها معمولا تصاویر کوچکی هستند که کاربران می توانند برای خود انتخاب کنند اندازه آن‌ها به قالب مورد استفاده در تالار بستگی دارد و معمولا زیر نام کاربری نمایش داده می شوند. در این بخش می‌توانید معیار های انتخاب آواتار را برای کاربران مشخص کنید. لطفا توجه داشته باشید که دایرکتوری های مشخص شده در قسمت پایین باید ایجاد شده و سطح دسترسی نوشتن بر روی آن‌ها اعمال شود. همچنین توجه داشته باشید که این تنظیمات فقط برای آواتار ها هستند و سایر تصاویر ربطی به این بخش ندارد.',

	'ALLOW_AVATARS'					=> 'فعال سازی آواتار',
	'ALLOW_AVATARS_EXPLAIN'			=> 'پذیرفتن استفاده عمومی از آواتار؛<br>اگر آواتار ها را به کلی و یا برای حالت خاص غیرفعال کنید، دیگر آواتار ها در تالار نمایش داده نخواهند شد ولی کاربران خواهند توانست که آواتار های خودشان را از کنترل پنل کاربر بارگیری کنند.',
	'ALLOW_GRAVATAR'				=> 'فعال سازی آواتار گراواتار',
	'ALLOW_LOCAL'					=> 'فعال سازی گالری آواتار',
	'ALLOW_REMOTE'					=> 'فعال سازی آواتار از راه دور',
	'ALLOW_REMOTE_EXPLAIN'			=> 'آواتار هایی که به سایر وب سایت های متصل می شوند<br><em><strong class="error">هشدار:</strong> با فعال سازی این گزینه کاربران میتوانند بررسی کنند فایل‌های موجود و قابل دسترسی که در شبکه های محلی وجود دارند.</em>',
	'ALLOW_REMOTE_UPLOAD'			=> 'فعال سازی بارگذاری از راه دور آواتار',
	'ALLOW_REMOTE_UPLOAD_EXPLAIN'	=> 'پذیرفتن بارگذاری آواتار از سایر وب سایت ها<br><em><strong class="error">هشدار:</strong>با فعال سازی این گزینه کاربران میتوانند بررسی کنند فایل‌های موجود و قابل دسترسی که در شبکه های محلی وجود دارند.</em>',
	'ALLOW_UPLOAD'					=> 'فعال سازی بارگذاری آواتار',
	'AVATAR_GALLERY_PATH'			=> 'مسیر گالری آواتار',
	'AVATAR_GALLERY_PATH_EXPLAIN'	=> 'مسیری در دایرکتوری روت phpBB برای تصاویر از پیش آماده شده. برای مثال <samp>images/avatars/gallery</samp>.',
	'AVATAR_STORAGE_PATH'			=> 'مسیر ذخیره آواتار',
	'AVATAR_STORAGE_PATH_EXPLAIN'	=> 'مسیری در دایرکتوری روت phpBB. برای مثال <samp>images/avatars/upload</samp>.',
	'MAX_AVATAR_SIZE'				=> 'حداکثر ابعاد آواتار',
	'MAX_AVATAR_SIZE_EXPLAIN'		=> 'عرض x ارتفاع در پیکسل',
	'MAX_FILESIZE'					=> 'حداکثر حجم آواتار',
	'MAX_FILESIZE_EXPLAIN'			=> 'برای فایل آواتار بارگذاری شده. اگر مقدار 0 تنظیم شود، حجم فایل بارگذاری فقط توسط پیکربندی PHP محدود میشود.',
	'MIN_AVATAR_SIZE'				=> 'حداقل ابعاد آواتار',
	'MIN_AVATAR_SIZE_EXPLAIN'		=> 'عرض x ارتفاع در پیکسل',
));

// Message Settings
$lang = array_merge($lang, array(
	'ACP_MESSAGE_SETTINGS_EXPLAIN'		=> 'در این بخش می‌توانید تنظیمات پیام خصوصی را اعمال کنید.',

	'ALLOW_BBCODE_PM'			=> 'پذیرفتن BBCode در پیام خصوصی.',
	'ALLOW_FLASH_PM'			=> 'پذیرفتن استفاده از BBCode <code>[FLASH]</code>',
	'ALLOW_FLASH_PM_EXPLAIN'	=> 'توجه داشته باشید که اگر استفاده از فلش در این بخش فعال شود، به سطوح دسترسی کاربران نیز بستگی دارد.',
	'ALLOW_FORWARD_PM'			=> 'پذیرفتن ارسال پیام خصوصی دریافت شده به دیگران',
	'ALLOW_IMG_PM'				=> 'پذیرفتن استفاده از BBCode <code>[IMG]</code>',
	'ALLOW_MASS_PM'				=> 'پدیرفتن ارسال پیام خصوصی به کاربران و گروه‌های متعدد.',
	'ALLOW_MASS_PM_EXPLAIN'		=> 'ارسال به گروه‌ها در تنظیمات گروه‌ها موجود است.',
	'ALLOW_PRINT_PM'			=> 'پذیرفتن نمایش حالت پرینت در پیام خصوصی',
	'ALLOW_QUOTE_PM'			=> 'پذیرفتن نقل قول در پیام خصوصی',
	'ALLOW_SIG_PM'				=> 'پذیرفتن امضا در پیام خصوصی',
	'ALLOW_SMILIES_PM'			=> 'پذیرفتن شکلک‌ها در پیام خصوصی',
	'BOXES_LIMIT'				=> 'حداکثر تعداد پیام خصوصی در هر جعبه',
	'BOXES_LIMIT_EXPLAIN'		=> 'کاربران نمی توانند بیشتر از این تعداد پیام خصوصی را ببینند، برای نا محدود کردن این ویژگی 0 را وارد کنید.',
	'BOXES_MAX'					=> 'حداکثر تعداد پوشه پیام خصوصی',
	'BOXES_MAX_EXPLAIN'			=> 'در حالت پیش‌فرض کاربران می توانند به این تعداد پوشه ایجاد کنند',
	'ENABLE_PM_ICONS'			=> 'فعال سازی استفاده از آیکون‌های موضوعات در پیام خصوصی',
	'FULL_FOLDER_ACTION'		=> 'عملکرد پیش‌فرض پوشه پر',
	'FULL_FOLDER_ACTION_EXPLAIN'=> 'عملکرد پیش‌فرضی که اگر پوشه پیام خصوصی پر شود، آن عمل روی خواهد داد. اگر در همه ی آن‌ها اعمال شود مناسب نخواهد بود. تنها استثنا در پوشه "پیام‌های ارسال شده" وجود دارد که در صورت پر شدن این پوشه، همیشه پیام‌های قدیمی تر حذف خواهند شد.',
	'HOLD_NEW_MESSAGES'			=> 'نگهداری پیام‌های جدید',
	'PM_EDIT_TIME'				=> 'محدودیت زمانی ویرایش',
	'PM_EDIT_TIME_EXPLAIN'		=> 'این محدودیت زمانی برای ویرایش پیام‌های خصوصی ای می باشند که هنوز تحویل داده نشده اند.برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'PM_MAX_RECIPIENTS'			=> 'حداکثر تعداد مورد قبول گیرنده',
	'PM_MAX_RECIPIENTS_EXPLAIN'	=> 'حداکثر تعداد مورد قبول گیرنده در هر پیام خصوصی می باشد. اگر 0 را وارد کنید،محدودیتی در تعداد گیرنده وجود نخواهد داشت. این تنظیم برای هر گروه، در بخش تنظیمات گروه موجود است.',
));

// Post Settings
$lang = array_merge($lang, array(
	'ACP_POST_SETTINGS_EXPLAIN'			=> 'در این بخش می‌توانید ارسالات تالارتان را تنظیم کنید.',
	'ALLOW_POST_LINKS'					=> 'پذیرفتن لینک در پست/پیام خصوصی',
	'ALLOW_POST_LINKS_EXPLAIN'			=> 'اگر <code>[URL]</code> غیرفعال شود و automatic/magic URL بسته شود.',
	'ALLOWED_SCHEMES_LINKS'				=> 'اجازه استفاده از طرح ها در لینک ها',
	'ALLOWED_SCHEMES_LINKS_EXPLAIN'		=> 'کاربران میتوانند از پست‌های حاوی لینکهای طرح دار استفاده نمایند و یا یکی از طرح های درون لیست مجوز داده شده ',
	'ALLOW_POST_FLASH'					=> 'پذیرفتن استفاده از تگ <code>[FLASH]</code> در پست‌ها',
	'ALLOW_POST_FLASH_EXPLAIN'			=> ' اگر تگ <code>[FLASH]</code> در پست‌ها پذیرفته نشود، در آن صورت سیستم سطوح دسترسی تنظیم استفاده از تگ <code>[FLASH]</code> را یر عهده خواهد داشت.',

	'BUMP_INTERVAL'					=> 'مدت زمان بامپ (bump)',
	'BUMP_INTERVAL_EXPLAIN'			=> 'مدت زمان مورد نیاز به دقیقه،ساعت،روز، که میتوان موضوع را در این مدت مشخص بعد از ارسال آن، بامپ (bump) کرد. برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'CHAR_LIMIT'					=> 'حداکثر تعداد نویسه در پست‌ها/پیام‌ها',
	'CHAR_LIMIT_EXPLAIN'			=> 'حداکثر تعداد نویسه مورد قبول در پست‌ها و پیام‌های خصوصی. برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'DELETE_TIME'					=> 'محدودیت زمانی حذف',
	'DELETE_TIME_EXPLAIN'			=> 'مدت زمان مورد نیاز برای حذف پست جدید بعد از ارسال. برای غیرفعال کردن این ویژگی 0 را وارد کنید',
	'DISPLAY_LAST_EDITED'			=> 'نمایش اطلاعات آخرین ویرایش',
	'DISPLAY_LAST_EDITED_EXPLAIN'	=> 'می‌توانید انتخاب کنید که می خواهید این اطلاعات نمایش داده شوند یا نه.',
	'EDIT_TIME'						=> 'محدودیت زمانی ویرایش',
	'EDIT_TIME_EXPLAIN'				=> 'مدت زمان موزد نیاز برای  برای ویرایش پست جدید بعد از ارسال.برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'FLOOD_INTERVAL'				=> 'زمان مورد برای ارسال پست جدید',
	'FLOOD_INTERVAL_EXPLAIN'		=> 'مدت زمانی (ثانیه) که کاربر باید صبر کند تا بتواند پست جدیدی ارسال کند.برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'HOT_THRESHOLD'					=> 'مرز محبوبیت موضوع',
	'HOT_THRESHOLD_EXPLAIN'			=> 'تعداد پست مورد نیاز در هر موضوع تا آن را به موضوع مهم تبدیل کند. برای حذف این ویژگی 0 را وارد کنید.',
	'MAX_POLL_OPTIONS'				=> 'حداکثر تعداد گزینه‌های نظرسنجی',
	'MAX_POST_FONT_SIZE'			=> 'حداکثر اندازه فونت در پست‌ها',
	'MAX_POST_FONT_SIZE_EXPLAIN'	=> 'حداکثر اندازه مورد قبول فونت در پست‌ها.برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'MAX_POST_IMG_HEIGHT'			=> 'حداکثر درازای تضاویر در هر پست',
	'MAX_POST_IMG_HEIGHT_EXPLAIN'	=> 'حداکثر درازای تصویر/فلش در هر پست. برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'MAX_POST_IMG_WIDTH'			=> 'حداکثر پهنای تصویر در هر پست',
	'MAX_POST_IMG_WIDTH_EXPLAIN'	=> 'حداکثر پهنای تصویر/فلش در هر پست. برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'MAX_POST_URLS'					=> 'حداکثر تعداد لینک در هر پست',
	'MAX_POST_URLS_EXPLAIN'			=> 'حداکثر تعداد URL در هر پست. برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'MIN_CHAR_LIMIT'				=> 'حداقل تعداد نویسه مورد نیاز در هر پست/پیام',
	'MIN_CHAR_LIMIT_EXPLAIN'		=> 'حداقل تعداد نویسه مورد نیاز در  هر پست و یا پیام خصوصی. حداقل داده برای این تابع 1 می باشد.',
	'POSTING'						=> 'ارسال',
	'POSTS_PER_PAGE'				=> 'تعداد پست در هر صفحه',
	'QUOTE_DEPTH_LIMIT'				=> 'حداکثر تودرتویی نقل قول در هر پست',
	'QUOTE_DEPTH_LIMIT_EXPLAIN'		=> 'حداکثر تودرتویی نقل قول در هر پست. برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'SMILIES_LIMIT'					=> 'حداکثر تعداد شکلک در هر پست',
	'SMILIES_LIMIT_EXPLAIN'			=> 'حداکثر تعداد شکلک در هر پست،برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'SMILIES_PER_PAGE'				=> 'تعداد شکلک‌ها در هر صفحه',
	'TOPICS_PER_PAGE'				=> 'تعداد موضوعات در هر صفحه',
));

// Signature Settings
$lang = array_merge($lang, array(
	'ACP_SIGNATURE_SETTINGS_EXPLAIN'	=> 'در این بخش می‌توانید امضاهای کاربران را تنظیم کنید',

	'MAX_SIG_FONT_SIZE'				=> 'حداکثر اندازه فونت امضا',
	'MAX_SIG_FONT_SIZE_EXPLAIN'		=> 'حداکثر قونت مورد قبول در امضا.برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'MAX_SIG_IMG_HEIGHT'			=> 'حداکثر درازای تصویر امضا',
	'MAX_SIG_IMG_HEIGHT_EXPLAIN'	=> 'حداکثر درازای تصویر/فلش مورد قبول در امضاها. برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'MAX_SIG_IMG_WIDTH'				=> 'حدامثر پهنای تصویر امضا',
	'MAX_SIG_IMG_WIDTH_EXPLAIN'		=> 'حداکثر پهنای تصویر/فلش مورد قبول در امضاها. برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'MAX_SIG_LENGTH'				=> 'حداکثر طول امضا',
	'MAX_SIG_LENGTH_EXPLAIN'		=> 'حداکثر تعداد نویسه‌ای که می توان در امضا استفاده کرد.',
	'MAX_SIG_SMILIES'				=> 'حداکثر تعداد شکلک در هر امضا',
	'MAX_SIG_SMILIES_EXPLAIN'		=> 'حداکثر تعداد مورد قبول شکلک در امضاها. برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
	'MAX_SIG_URLS'					=> 'حداکثر تعداد لینک در امضا',
	'MAX_SIG_URLS_EXPLAIN'			=> 'حداکثر تعداد لینک در امضای کاربران.برای غیرفعال کردن این ویژگی 0 را وارد کنید.',
));

// Registration Settings
$lang = array_merge($lang, array(
	'ACP_REGISTER_SETTINGS_EXPLAIN'	=> 'در این بخش می تواند ثبت نام ها و موارد مرتبط با آن در نمایه را تنظیم کنید.',

	'ACC_ACTIVATION'				=> 'فعال سازی حساب',
	'ACC_ACTIVATION_EXPLAIN'		=> 'می‌توانید مشخص کنید که آیا کاربران می توانند بعد از ثبت نام مستقیما به تالار دسترسی داشته باشند و یا باید ابتدا حساب خود را فعال کنند. همچنین می‌توانید به طور کلی ثبت نام های جدید را غیرفعال کنید. <em>“Board-wide ایمیل” بایستی فعال باشد تا بتوان فعال سازی حساب ها صورت پذیرد.</em>',
	'ACC_ACTIVATION_WARNING'		=> 'لطفا توجه داشته باشید روش فعال سازی انتخابی شما نیاز به فعال سازی ارسال ایمیل دارد ، در غیر این صورت ثبت نام کاربران غیرفعال می شود. توصیه میکنیم دو روش برای ثبت نام انتخاب کنید و یا ایمیل ها را فعال کنید.', 

	'NEW_MEMBER_POST_LIMIT'			=> 'محدودیت ارسال پست برای کاربران جدید',
	'NEW_MEMBER_POST_LIMIT_EXPLAIN'	=> 'کاربران جدید تا زمانی که پست‌هایی به این تعداد ارسال کنند، در گروه <em>کاربران تازه عضو شده</em> قرار می گیرند. با استفاده از این گروه می‌توانید کاربران عضو در آن را از فرستادن پیام خصوصی و یا آزمایش پست‌هایشان منع کنید. <strong>اگر 0 را وارد کنید، این ویژگی غیرفعال خواهد شد.</strong>',
	'NEW_MEMBER_GROUP_DEFAULT'		=> 'تنظیم گروه کاربران تازه عضو شده به پیش‌فرض',
	'NEW_MEMBER_GROUP_DEFAULT_EXPLAIN'	=> 'اگر بله انتخاب شود و محدودیت ارسال پست اعمال شود، کاربرانی که به تازگی عضو شده اند علاوه بر این که در گروه <em>کاربران تازه عضو شده</em> قرار می گیرند،بلکه این گروه،گروه پیش‌فرض آن‌ها نیز خواهد بود. اگر می خواهید برای یک گروه پیش‌فرض رتبه/و یا نمایه تعریف کنید، این گزینه میتواند سودمند باشد.',

	'ACC_ADMIN'					=> 'توسط مدیر',
	'ACC_DISABLE'				=> 'غیرفعال',
	'ACC_NONE'					=> 'هیچکدام',
	'ACC_USER'					=> 'توسط کاربر',
//	'ACC_USER_ADMIN'			=> 'کاربر + مدیر',
	'ALLOW_EMAIL_REUSE'			=> 'پذیرفتن استفاده دوباره از آدرس ایمیل',
	'ALLOW_EMAIL_REUSE_EXPLAIN'	=> 'کاربران مختلف می توانند از یک ایمیل واحد استفاده کنند.',
	'COPPA'						=> 'COPPA',
	'COPPA_FAX'					=> 'شماره فکس COPPA ',
	'COPPA_MAIL'				=> 'COPPA آدرس ایمیل ',
	'COPPA_MAIL_EXPLAIN'		=> 'این آدرس ایمیلی هست که خانواده ها فرم ثبت نام COPPA را به آن ارسال خواهند کرد.',
	'ENABLE_COPPA'				=> 'فعال سازی COPPA',
	'ENABLE_COPPA_EXPLAIN'		=> 'COPPA که در ایالت متحده ی آمریکا فعال است،از کاربران خواهد خواست تا اثبات کنند که بالای 13 سال هستند. اگر این گزینه غیرفعال باشد،گروه‌های مربوط به آن نیز نمایش داده نخواهند شد.',
	'MAX_CHARS'					=> 'حداکثر',
	'MIN_CHARS'					=> 'حداقل',
	'NO_AUTH_PLUGIN'			=> 'تأییدیه ای مناسب برای افزونه یافت نشد.',
	'PASSWORD_LENGTH'			=> 'طول گذرواژه',
	'PASSWORD_LENGTH_EXPLAIN'	=> 'حداقل تعداد نویسه برای گذرواژه. توجه کنید که این مقدار محدودیت ندارد',
	'REG_LIMIT'					=> 'محدودیت اقدام به ثبت نام',
	'REG_LIMIT_EXPLAIN'			=> 'حداکثر تعدادی که کاربران می توانند اقدام به وارد کردن کد تأیید کنند. بعد از این تعداد،بخش ثبت نام در یک بازه زمانی برای آن‌ها غیرفعال خواهد شد.',
	'USERNAME_ALPHA_ONLY'		=> 'فقط حروف و اعداد',
	'USERNAME_ALPHA_SPACERS'	=> 'حروف،اعداد و فاصله',
	'USERNAME_ASCII'			=> 'ASCII (بدون یونیکد بین المللی)',
	'USERNAME_LETTER_NUM'		=> 'هر حرف یا عددی',
	'USERNAME_LETTER_NUM_SPACERS'	=> 'هر حرف،عدد و یا فاصله',
	'USERNAME_CHARS'			=> 'محدودیت نویسه نام کاربری',
	'USERNAME_CHARS_ANY'		=> 'هرنوع کارکتری',
	'USERNAME_CHARS_EXPLAIN'	=> 'نویسه‌های محدود در نام های کاربری : فاضله, -, +, _, [ و ].',
	'USERNAME_LENGTH'			=> 'طول نام کاربری',
	'USERNAME_LENGTH_EXPLAIN'	=> 'حداکثر و حداقل نویسه مورد قبول در نام کاربری',
));

// Feeds
$lang = array_merge($lang, array(
	'ACP_FEED_MANAGEMENT'				=> 'تنظیمات عمومی خوراک ',
	'ACP_FEED_MANAGEMENT_EXPLAIN'		=> 'این ماژول خوراک های ATOM ایجاد کرده و با تجزیه BBCode های متن مطالب آن‌ها را قابل خواند در خوراک میکند.',

	'ACP_FEED_GENERAL'					=> 'تنظیمات عمومی خوراک',
	'ACP_FEED_POST_BASED'				=> 'تنظیمات خوراک در پست‌ها',
	'ACP_FEED_TOPIC_BASED'				=> 'تنظیمات خوراک در موضوعات',
	'ACP_FEED_SETTINGS_OTHER'			=> 'سایر خوراک و تنظیمات',

	'ACP_FEED_ENABLE'					=> 'فعال سازی خوراک',
	'ACP_FEED_ENABLE_EXPLAIN'			=> 'می‌توانید خوراک ATOM را در سرتاسر تالار فعال و یا غیرفعال کنید.<br>غیرفعال کردن خوراک در سرتاسر تالار تنظیمات زیر را بی اثر خواهد کرد.',
	'ACP_FEED_LIMIT'					=> 'تعداد موارد خوراک',
	'ACP_FEED_LIMIT_EXPLAIN'			=> 'حداکثر تعداد موارد خوراک برای نمایش.',

	'ACP_FEED_OVERALL'					=> 'فعال سازی خوراک در تالار',
	'ACP_FEED_OVERALL_EXPLAIN'			=> 'پست های جدید در سرتاسر تالار',
	'ACP_FEED_FORUM'					=> 'فعال سازی خوراک در هر انجمن',
	'ACP_FEED_FORUM_EXPLAIN'			=> 'پست‌های یک انجمن و زیرانجمن‌های آن',
	'ACP_FEED_TOPIC'					=> 'فعال سازی خورام در هر نوضوع',
	'ACP_FEED_TOPIC_EXPLAIN'			=> 'پست‌های جدید یک موضوع',

	'ACP_FEED_TOPICS_NEW'				=> 'فعال سازی خوراک موضوعات جدید',
	'ACP_FEED_TOPICS_NEW_EXPLAIN'		=> 'فعال سازی خوراک "موضوعات جدید" که شامل جدیدترین موضوعات همراه با موضوع اول است.',
	'ACP_FEED_TOPICS_ACTIVE'			=> 'فعال سازی خوراک موضوعات فعال',
	'ACP_FEED_TOPICS_ACTIVE_EXPLAIN'	=> 'فعال سازی خوراک "موضوعات فعال" که شامل فعال ترین موضوعات است.',
	'ACP_FEED_NEWS'						=> 'خوراک اخبار',
	'ACP_FEED_NEWS_EXPLAIN'				=> 'اولین پست این انجمن‌ها را جای دهید برای غیرفعال کردن،هیچ انجمنی را انتخاب نکنید.<br>با نگه داشتن <samp>CTRL</samp> و کلیک بر روی نام های انجمن‌ها می‌توانید به سادگی چند مورد را همزمان انتخاب و یا لغو انتخاب کنید.',
	'ACP_FEED_OVERALL_FORUMS'			=> 'فعال سازی خوراک انجمن‌ها',
	'ACP_FEED_OVERALL_FORUMS_EXPLAIN'	=> 'فعال سازی خوراک "همه انجمن‌ها" که لیستی از تمامی انجمن‌ها را نمایش می دهد.',

	'ACP_FEED_HTTP_AUTH'				=> 'پذیرفتن تأیید HTTP',
	'ACP_FEED_HTTP_AUTH_EXPLAIN'		=> 'ویژگی ای که به کاربران اجازه می دهد تا با اضافه کردن پارامتر <samp>auth=http</samp> به URL خوراک محتوایی را ببینند که برای مهمانان قابل مشاهده نیست. لطفا توجه داشته باشید که بعضی از نصب های PHP ممکن است برای اعمال این تنظیمات نیازمند تغییراتی در فایل .htaccess باشند.',
	'ACP_FEED_ITEM_STATISTICS'			=> 'آمار هر مورد',
	'ACP_FEED_ITEM_STATISTICS_EXPLAIN'	=> 'نمایش آمار مختلف در زیر هر مورد از خوراک<br>(برای مثال ارسال شده توسط، تاریخ و زمان، پاسخ‌ها، تعداد بازدید.)',
	'ACP_FEED_EXCLUDE_ID'				=> 'جداسازی این انجمن',
	'ACP_FEED_EXCLUDE_ID_EXPLAIN'		=> 'محتوای این انجمن‌ها .<strong>در خوراک نمایش داده نخواهند شد</strong> برای قراردادن اطلاعات تمامی انجمن‌ها،انجمنی را انتخاب نکنید.<br>با نگه داشتن <samp>CTRL</samp> و کلیک بر روی نام های انجمن‌ها می‌توانید به سادگی چند مورد را همزمان انتخاب و یا لغو انتخاب کنید.',
));

// Visual Confirmation Settings
$lang = array_merge($lang, array(
	'ACP_VC_SETTINGS_EXPLAIN'				=> 'در این بخش می‌توانید افزونه‌هایی را پیکربندی کنید که از ارسال هرزنامه های خودکار جلوگیری می کنند. این افزونه‌ها با به چالش کشاندن کاربران از طریق<em>CAPTCHA</em> کار می کنند، آمایشی که حل کردن آن برای کامپیوتر ها دشوار می باشد.',
	'ACP_VC_EXT_GET_MORE'					=> 'به علاوه (و احتمالا بهتر است) از پلاگین ضد هرزنامه استفاده کنید. جهت مشاهده به آدرس زیر رجوع کنید. <a href="https://www.phpbb.com/go/anti-spam-ext"><strong>phpBB.com Extensions Database</strong></a>. جهت مشاهده مقاله های ضد هرزنامه و اطلاعات بیشتر به آدرس زیر مراجعه فرمائید. <a href="https://www.phpbb.com/go/anti-spam"><strong>phpBB.com Knowledge Base</strong></a>.',
	'AVAILABLE_CAPTCHAS'					=> 'افزونه‌های در دسترس',
	'CAPTCHA_UNAVAILABLE'					=> 'انتخاب افزونه مقدور نمی باشد زیرا موارد خواسته شده توسط آن فرآهم نشده است.',
	'CAPTCHA_GD'							=> 'تصویر GD',
	'CAPTCHA_GD_3D'							=> 'تصویر سه بعدی GD',
	'CAPTCHA_GD_FOREGROUND_NOISE'			=> 'پارازیت پیش زمینه',
	'CAPTCHA_GD_EXPLAIN'					=> 'از GD برای ایجاد تصاویر پیشرفته تری در مقابله با هرزنامه ها،استفاده کنید.',
	'CAPTCHA_GD_FOREGROUND_NOISE_EXPLAIN'	=> 'با استفاده از پارازیت پیش زمینه خواندن تصاویر را دشوارتر کنید.',
	'CAPTCHA_GD_X_GRID'						=> 'پارازیت پس زمینه در محور x',
	'CAPTCHA_GD_X_GRID_EXPLAIN'				=> 'برای دشوارتر کردن خواندن تصویر،از داده‌های کمتری استفاده کنید،برای غیرفعال کردن پارازیت در محور x 0 را وارد کنید.',
	'CAPTCHA_GD_Y_GRID'						=> 'پارازیت پیش زمینه در محور y',
	'CAPTCHA_GD_Y_GRID_EXPLAIN'				=> 'برای دشوارتر کردن خواندن تصاویر از داده‌های کمتری استفاده کنید،برای غیرفعال کردن پارازیت در محور y 0 را وارد کنید.',
	'CAPTCHA_GD_WAVE'						=> 'پیچیدگی امواج',
	'CAPTCHA_GD_WAVE_EXPLAIN'				=> 'این گزینه امواج پیچیده ای را به تصویر اضافه خواهد کرد.',
	'CAPTCHA_GD_3D_NOISE'					=> 'اضافه کردن پارازیت های سه بعدی',
	'CAPTCHA_GD_3D_NOISE_EXPLAIN'			=> 'این گزینه پارازیت های سه بعدی ای را به تصاویر اضافه خواهد کرد.',
	'CAPTCHA_GD_FONTS'						=> 'استفاده از فونت های مختلف',
	'CAPTCHA_GD_FONTS_EXPLAIN'				=> 'این گزینه نحوه نمایش نویسه‌ها در تصویر را مشخص می کند. می‌توانید از اشکال پیش‌فرض استفاده کنید و یا این اشکال را تغییر دهید.اضافه کردن حروف کوچک هم ممکن است.',
	'CAPTCHA_FONT_DEFAULT'					=> 'پیش‌فرض',
	'CAPTCHA_FONT_NEW'						=> 'اشکال جدید',
	'CAPTCHA_FONT_LOWER'					=> 'از حروف کوچک هم استفاده کن',
	'CAPTCHA_NO_GD'							=> 'تصویر ساده',
	'CAPTCHA_PREVIEW_MSG'					=> 'تغییرات شما ذخیره نشد،این فقط یک آزمایش می باشد.',
	'CAPTCHA_PREVIEW_EXPLAIN'				=> 'به نظر می رسد افزونه از موارد انتخاب شده کنونی استفاده می کند.',

	'CAPTCHA_SELECT'						=> 'افزونه‌های نصب شده',
	'CAPTCHA_SELECT_EXPLAIN'				=> 'این لیستی از افزونه‌های شناسایی شده در تالار می باشد. موارد خاکستری رنگ در دسترس نیستند و احتمالا باید پیکربندی و تنظیم شوند.',
	'CAPTCHA_CONFIGURE'						=> 'پیکربندی افزونه‌ها',
	'CAPTCHA_CONFIGURE_EXPLAIN'				=> 'تغییر تنظیمات در افزونه انتخاب شده',
	'CONFIGURE'								=> 'پیکربندی',
	'CAPTCHA_NO_OPTIONS'					=> 'این افزونه گزینه ای برای پیکربندی ندارد.',

	'VISUAL_CONFIRM_POST'					=> 'فعال سازی کد تأیید در پست‌های ارسالی توسط مهمانان',
	'VISUAL_CONFIRM_POST_EXPLAIN'			=> 'از مهمانان خواسته می شود تا کد تأیید را برای مقابله با هرزنامه ها وارد کنند.',
	'VISUAL_CONFIRM_REG'					=> 'فعال سازی کد تأیید در ثبت نام',
	'VISUAL_CONFIRM_REG_EXPLAIN'			=> 'کاربران در حین ثبت نام باید کد تأیید را برای جلوگیری از هرزنامه ها وارد کنند.',
	'VISUAL_CONFIRM_REFRESH'				=> 'پذیرفتن بارگیری دوباره کد تأیید',
	'VISUAL_CONFIRM_REFRESH_EXPLAIN'		=> 'به کاربران این اجاره داده می شود که اگر نتوانستند کد تأیید موجود را بخوانند، بتوانند کد تأیید جدیدی را درخواست کنند. ممکن است بعضی از افزونه‌ها از این گزینه پشتیبانی نکنند.',
));

// Cookie Settings
$lang = array_merge($lang, array(
	'ACP_COOKIE_SETTINGS_EXPLAIN'		=> 'این گزینه‌ها جزئیات نحوه ارسال کوکی ها به مرورگر را تعیین می کنند. در اغلب موارد تنظیمات پیش‌فرض برای کوکی ها کافی است. اگر خواستار تغییر این تنظیمات باشید باید دقت کافی به عمل آورید زیرا تنظیمات نا درست از ورود کاربران جلوگیری خواهد کرد چنانچه مشکلاتی با ورود کاربران به تالار دارید به این لینک مراجعه کنید  <strong><a href="https://www.phpbb.com/support/go/cookie-settings">phpBB.com Knowledge Base - Fixing incorrect cookie settings</a></strong>',
	
	'COOKIE_DOMAIN'				=> 'دامنه کوکی',
	'COOKIE_DOMAIN_EXPLAIN'		=> 'در بیشتر مواقع دامنه کوکی تنظیم است. چنانچه مطمئن نیستید آن را خالی بگذارید.<br><br>اما اگر تالار شما با برنامه دیگری هماهنگ شده و یا از دامنه های بیشتری استفاده میکنید, آنگاه طبق دستور زیر تنظیمات کوکی را انجام دهید.ج. اگر چیزی شبیه این دارید <i>example.com</i> و <i>forums.example.com</i>,یا شاید <i>forums.example.com</i> و <i>blog.example.com</i>. زیردامنه ها را حذف کنید تا دامنه اصلی مشخص شود, <i>example.com</i>. حالا یک نقطه به جلو دامنه اضافه  کنید مانند .example.com توجه: نقطه در ابتدا است در این مثال).',
	'COOKIE_NAME'				=> 'نام کوکی',
	'COOKIE_NAME_EXPLAIN'		=> 'شما می‌توانید هر چیزی را به عنوان اصلی انتخاب کنید. هنگامیکه تنظیمات کوکی تغییر کند نام کوکی نیز باید تغییر کند. ',
	'COOKIE_NOTICE'				=> 'اطلاعیه کوکی',
	'COOKIE_NOTICE_EXPLAIN'		=> 'اگراطلاعیه کوکی را فعال کنید ، هنگام بازدید کاربران به آن‌ها نمایش داده میشود. این ممکن است بستگی به قوانین محتوی تعیین شده هیئت مدیره تالار باشد.',
	'COOKIE_PATH'				=> 'مسیر کوکی',
	'COOKIE_PATH_EXPLAIN'		=> 'معمولا آدرس اسکپریت شماست یا به صورت یک اسلش / برای در دسترس بودن دامنه شما خواهد بود',
	'COOKIE_SECURE'				=> 'کوکی امن',
	'COOKIE_SECURE_EXPLAIN'		=> 'اگر سرور شما با SSL اجرا می شود، این گزینه را فعال کنید در غیر این صورت، در آن تغییراتی ایجاد نکنید. اگر این گزینه را فعال کنید و سرور با SSL اجرا نشود در این صورت خطاهایی در انتقال کاربران رخ خواهد داد.',
	'ONLINE_LENGTH'				=> 'محدودیت زمانی آنلاین بودن کاربران',
	'ONLINE_LENGTH_EXPLAIN'		=> 'تعداد دقیقه هایی که اگر کاربر غیرفعال باشد،در لیست "چه کسی آنلاین است" نمایش داده نخواهد شد. هر چقدر این مقدار بیشتر باشد، عملکرد لیست افراد آنلاین بهتر خواهد بود.',
	'SESSION_LENGTH'			=> 'مدت نشست',
	'SESSION_LENGTH_EXPLAIN'	=> 'بعد از این مدت ثانیه،نشست بسته خواهد شد.',
));

// Contact Settings
$lang = array_merge($lang, array(
	'ACP_CONTACT_SETTINGS_EXPLAIN'		=> 'در این قسمت می‌توانید صفحه تماس با ما را فعال یا غیرفعال کنید که همراه با متنی برای آن خواهد بود.',

	'CONTACT_US_ENABLE'				=> 'فعال سازی تماس با ما',
	'CONTACT_US_ENABLE_EXPLAIN'		=> 'در این صفحه کاربران میتوانند با مدیریت کل سایت از طریق ایمیل ارتباط برقرار کنند لطفا توجه داشته باشید که باید تنظیمات ایمیل فعال باشد. تنظیمات مربوطه در بخش اصلی و تنظیمات ایمیل وجود دارد.',
	
	'CONTACT_US_INFO'				=> 'اطلاعات تماس',
	'CONTACT_US_INFO_EXPLAIN'		=> 'این متن در صفحه تماس با ما نمایش داده خواهد شد.',
	'CONTACT_US_INFO_PREVIEW'		=> 'اطلاعات و پیش نمایش صفحه تماس با ما',
	'CONTACT_US_INFO_UPDATED'		=> 'اطلاعات صفحه تماس با ما به‌روز رسانی شد.',
));

// Load Settings
$lang = array_merge($lang, array(
	'ACP_LOAD_SETTINGS_EXPLAIN'	=> 'در این بخش می‌توانید با تنظیم کردن گزینه‌ها مقدار درخواست از سرور را کاهش دهید. در اغلب سرور ها نیازی به غیرفعال کردن تابعی نیست. با این وجود در بعضی از سیستم ها و هاست های اشتراکی، غیرفعال کردن بعضی از تابع هایی که مورد نیازتان نیستند می تواند سودمند باشد. همچنین می‌توانید محدودیت هایی را برای تالار اعمال کنید که اگر  سرور بیشتر از حد تعیین شده بارگذاری شود، تالار موقتا بسته می شود.',

	'ALLOW_CDN'						=> 'مجوز استفاده از شبکه ثالث جهت دریافت محتوی',
    'ALLOW_CDN_EXPLAIN'				=> 'با فعال سازی این گزینه بعضی از فایل‌های به جای سرور شما از سرور ثالث دیگر دریافت میشود. که با عث مصرف کمتر پهنای باند سرور شما میشود., اما ممکن است باعث بوجود امدن بعضی مشکلات امنیتی در بعضی انجمن‌ها شود. با نصب phpBB به صورت پیش‌فرض, به عنوان مثال بارگزاری “jQuery”  و دریافت فونت Open Sans” از سرور گوگل انجام میشود. همچنین باعث لود “Font Awesome” نیز میشود که  phpBB و بعضی افزونه ها از آن استفاده میکنند.',
	'ALLOW_LIVE_SEARCHES'			=> 'دسترسی جست‌وجوی زنده',
	'ALLOW_LIVE_SEARCHES_EXPLAIN'	=> 'با فعال سازی این گزینه جست‌وجوی زنده قابل دسترس خواهد بود و کلمات کلیدی پیشنهادی برای جست‌وجو نمایش داده خواهد شد.',
	'CUSTOM_PROFILE_FIELDS'			=> 'فیلد های سفارشی نمایه',
	'LIMIT_LOAD'					=> 'محدودیت بارگذاری سیستم',
	'LIMIT_LOAD_EXPLAIN'			=> 'اگر بارگذاری سیستم از یک دقیقه گذشته باشد،تالار به طور خودکار بسته خواهد شد. داده 1.0 برابر ~100% مصرف پردازشگر می باشد. این عملکرد فقط در سرورهای UNIX based فعال است. اگر phpBB قادر به دریافت محدودیت های تالار نشود، این داده به طور خودکار 0 خواهد شد.',
	'LIMIT_SESSIONS'				=> 'محدودیت نشست',
	'LIMIT_SESSIONS_EXPLAIN'		=> 'اگر تعداد نشست از این داده عبور کرد،در عرض یک دقیقه سایت بسته خواهد شد. برای نامحدود کردن تعداد نشست 0 را وارد کنید.',
	'LOAD_CPF_MEMBERLIST'			=> 'پذیرفتن نمایش فیلد های سفارشی نمایه در قالب',
	'LOAD_CPF_PM'					=> 'نمایش فیلد های سفارشی کاربر در پیام خصوصی',
	'LOAD_CPF_VIEWPROFILE'			=> 'نمایش فیلد های سفارشی کاربر در نمایه',
	'LOAD_CPF_VIEWTOPIC'			=> 'نمایش فیلد های سفارشی در صفحات موضوع',
	'LOAD_USER_ACTIVITY'			=> 'نمایش فعالیت کاربران',
	'LOAD_USER_ACTIVITY_EXPLAIN'	=> 'نمایش موضوعات/انجمن‌های فعال در نمایه کاربر و کنترل پنل کاربر. این گزینه برای تالار هایی که بیش از یک میلیون پست دارند توصیه می شود.',
	'LOAD_USER_ACTIVITY_LIMIT'		=> 'محدودیت فعالیت کاربران در پست‌ها',
	'LOAD_USER_ACTIVITY_LIMIT_EXPLAIN'	=> 'موضوعات و انجمن‌های فعال نمایش داده نمیشود برای کاربرانی که بیشتر از این عدد داشته باشند برای غیرفعال سازی عدد 0 را وارد کنید',
	'READ_NOTIFICATION_EXPIRE_DAYS'	=> 'تاریخ انقضای  اعلانات خوانده شده',
	'READ_NOTIFICATION_EXPIRE_DAYS_EXPLAIN' => 'تعداد روزهای مشخص جهت حذف اعلانات خوانده شده به صورت خودکار، مقدار 0 باعث میشود هیچگاه اعلانات حذف نشوند.',
	'RECOMPILE_STYLES'				=> ' تألیف مجدد اجزای فرسوده ی قالب',
	'RECOMPILE_STYLES_EXPLAIN'		=> 'به‌روز رسانی های اجزای قالب را در سیتم های فایل کنترل کرده و آن‌ها را تألیف می کند.',
	'YES_ACCURATE_PM_BUTTON'			=> 'دسترسی نمایش دکمه پیام خصوصی در صفحه موضوعات',
	'YES_ACCURATE_PM_BUTTON_EXPLAIN'	=> 'با فعال سازی این گزینه ،در قسمت نمایه کاربر در پست‌ها ، دکمه ارسال پیام خصوصی به نمایش در خواهد آمد.',
	'YES_ANON_READ_MARKING'			=> 'فعال سازی علامت گذاری موضوعات برای مهمان ها',
	'YES_ANON_READ_MARKING_EXPLAIN'	=> 'اطلاعات خوانده شده/خوانده نشده را برای مهمان ها ذخیره می کند. اگر غیرفعال شوند،پست‌ها همیشه برای مهمان ها به عنوان خوانده شده علامت گذاری خواهند شد.',
	'YES_BIRTHDAYS'					=> 'فعال سازی لیست تولد ها',
	'YES_BIRTHDAYS_EXPLAIN'			=> 'اگر این گزینه غیرفعال شود، دیگر این لیست نمایش داده نمی شود. اگر این گزینه را فعال کنید، باید به همراه آن ویژگی تاریخ تولد نیز فعال باشد.',
	'YES_JUMPBOX'					=> 'فعال سازی نمایش جعبه ی پرش',
	'YES_MODERATORS'				=> 'فعال سازی نمایش مدیران انجمن',
	'YES_ONLINE'					=> 'فعال سازی لیست کاربران آنلاین',
	'YES_ONLINE_EXPLAIN'			=> 'نمایش اطلاعات کاربران در صفحه نخست و صفحات انجمن و موضوعات.',
	'YES_ONLINE_GUESTS'				=> 'فعال سازی لیست مهمانان آنلاین در مشاهده افراد آنلاین',
	'YES_ONLINE_GUESTS_EXPLAIN'		=> 'پذیرفتن نمایش اطلاعات کاربران مهمان در مشاهده افراد انلاین',
	'YES_ONLINE_TRACK'				=> 'فعال سازی نمایش آنلاین/آفلاین بودن کاربر',
	'YES_ONLINE_TRACK_EXPLAIN'		=> 'نمایش اطلاعات آنلاین بودن کاربران در نمایه‌ها و صفحات موضوعات',
	'YES_POST_MARKING'				=> 'فعال سازی موضوعات علامت گذاری شده',
	'YES_POST_MARKING_EXPLAIN'		=> 'مشخص میکند که آیا کاربر موضوعی را ارسال کرده است یا نه',
	'YES_READ_MARKING'				=> 'فعال سازی انتخاب موضوع در سرور',
	'YES_READ_MARKING_EXPLAIN'		=> 'اطلاعات خوانده و یا خوانده نشدن موضوعی را در پایگاه داده ذخیره می کند و نه در کوکی',
	'YES_UNREAD_SEARCH'				=> 'فعال سازی جست‌وجو در پست‌های خوانده نشده',
));

// Auth settings
$lang = array_merge($lang, array(
	'ACP_AUTH_SETTINGS_EXPLAIN'	=> 'phpBB از ماژول ها و افزونه‌های تأیید پشتیبانی می کند. این بخش به شما این اجازه را میدهد تا تصمیم بگیرید که روش تأیید ورود کاربران چگونه باشد. به صورت پیش‌فرض سه افزونه ی DB, LDAP و Apache موجود است. توجه داشته باشید که همه روش ها نیازمند اطلاعات جانبی نیستند پس فقط فیلد ها مربوط به افزونه انتخاب شده را پر کنید.',

	'AUTH_METHOD'				=> 'روش تأیید را انتخاب کنید',

	'AUTH_PROVIDER_OAUTH_ERROR_ELEMENT_MISSING'	=> 'Both the key and secret of each enabled OAuth service provider must be provided. Only one was provided for an OAuth service provider.',
	'AUTH_PROVIDER_OAUTH_EXPLAIN'				=> 'Each OAuth provider requires a unique secret and key in order to authenticate with the external server. These should be supplied by the OAuth service when you register your website with them and should be entered exactly as provided to you.<br>Any service that does not have both a key and a secret entered here will not be available for use by the forum users. Also note, that user can still register and login using the DB authentication plug-in.',
	'AUTH_PROVIDER_OAUTH_KEY'					=> 'کلید',
	'AUTH_PROVIDER_OAUTH_TITLE'					=> 'OAuth',
	'AUTH_PROVIDER_OAUTH_SECRET'				=> 'رمز',

	'APACHE_SETUP_BEFORE_USE'	=> 'قبل از تغییر روش به آپاچی، باید آپاچی در سرور شما نصب باشد. در نظر داشته باشید که نام کاربری استفاده شده در آپاچی باید با نام کاربری شما در phpBB یکی باشد. تأیید با آپاچی فقط با mod_php (همراه با نسخه CGI نباشد)',

	'LDAP'							=> 'LDAP',
	'LDAP_DN'						=> 'LDAP base <var>dn</var>',
	'LDAP_DN_EXPLAIN'				=> 'این گزینه مشخص کننده نام و محل اطلاعات کاربر می باشد، برای مثال <samp>o=My Company,c=IR</samp>.',
	'LDAP_EMAIL'					=> 'ویژگی ایمیل LDAP',
	'LDAP_EMAIL_EXPLAIN'			=> 'این را در نام مشخص کننده ایمیل وارد شده از جانب کاربر برای ایجاد ایمیل خودکار برای کاربر تنظیم کنید.(اگر وجوو داشته باشد) برای خالی بودن ایمیل کاربرانی که برای اولین بار وارد می شوند،این فیلد را خالی بگزارید.',
	'LDAP_INCORRECT_USER_PASSWORD'	=> 'ورود به سرور LDAP با گذرواژه و نام کاربری مشخص شده نا موفق بود.',
	'LDAP_NO_EMAIL'					=> 'ویژگی ایمیل وارد شده موجود نیست.',
	'LDAP_NO_IDENTITY'				=> 'هویت ورود برای %s یافت نشد.',
	'LDAP_PASSWORD'					=> 'گذرواژه LDAP',
	'LDAP_PASSWORD_EXPLAIN'			=> 'برای اتصال بی نام این فیلد را خالی بگذارید. در غیر این صورت برای نام کاربری ذکر شده در بالا گذرواژهی تعریف کنید. تا سرور های دایرکتوری فعال شود.<br><em><strong>هشدار :</strong> این گذرواژه در قالبی متن ساده در پایگاه داده ذخیره خواهد شد. و برای همین برای هرکسی که به پایگاه داده دسترسی پیدا کند و یا به این صفحه مراجعه کند،قابل بازدید خواهد بود.</em>',
	'LDAP_PORT'						=> 'پورت سرور LDAP',
	'LDAP_PORT_EXPLAIN'				=> 'می‌توانید پورتی را برای اتصال به سرور LDAP انتخاب کنید، این پورت به جای پورت پیش‌فرض 389 استفاده خواهد شد.',
	'LDAP_SERVER'					=> 'نام سرور LDAP',
	'LDAP_SERVER_EXPLAIN'			=> 'اگر از سرور LDAP اسفتفاده می کنید،نام هاست و یا آدرس IPرا وارد کنید. به عنوان جایگزین می‌توانید لینکی مانند ldap://hostname:port/ تعیین کنید.',
	'LDAP_UID'						=> 'LDAP <var>uid</var>',
	'LDAP_UID_EXPLAIN'				=> 'این گزینه کلیدی می باشد برای جست‌وجوی هویت ورود به LDAP برای مثال <var>uid</var>, <var>sn</var>, و یا غیره ... .',
	'LDAP_USER'						=> 'کاربر LDAP <var>dn</var>',
	'LDAP_USER_EXPLAIN'				=> 'برای اتصال بی نام این فیلد را خالی بگذارید اگر این فیلد وارد شود،phpBB از آن برای یافتن کاربر درست استفاده خواهد کرد. برای مثال : <samp>uid=Username,ou=MyUnit,o=MyCompany,c=US</samp>. برای دایرکتوری فعال سرور ها لازم است.',
	'LDAP_USER_FILTER'				=> 'فیلتر LDAP کاربران',
	'LDAP_USER_FILTER_EXPLAIN'		=> 'برای جست‌وجوی اشیاء مورد نظر می‌توانید از فیلتر های بیشتر جست‌وجو استفاده کنید. برای مثال در نتیجه جست‌وجوی <samp>objectClass=posixGroup</samp> ، <samp>(&amp;(uid=$username)(objectClass=posixGroup))</samp> ظاهر خواهد شد.',
));

// Server Settings
$lang = array_merge($lang, array(
	'ACP_SERVER_SETTINGS_EXPLAIN'	=> 'در این بخش می‌توانید تنظیمات مربوط به دامنه و سرور را تنظیم کنید. اطلاعات وارد شده باید دقیق باشند. در صورت نادرست بودن ایمیل خطا هایی ظاهر خواهد شد. در حین وارد کردن دامنه ای مطمئن باشید که از پروتکل http:// استفاده کرده اید. پورت را فقط هنگامی تغییر دهید که مطمئن باشید، سرورتان از آن پورت استفاده می کند،در اغلب موارد پورت اجرایی در سرور 80 می باشد.',

	'ENABLE_GZIP'				=> 'فعال سازی فشرده ساز GZip',
	'ENABLE_GZIP_EXPLAIN'		=> 'این گزینه اطلاعات ارسالی به کاربران را فشرده می کند، چنین حالتی ترافیک سایت را پایین می آورد ولی باعث افزایش استفاده از CPU سرور و بخش کاربری می شود. باید افزونه PHP، ZLip باگذاری شود.',
	'FORCE_SERVER_VARS'			=> 'اجبار در تنظیمات URL سرور',
	'FORCE_SERVER_VARS_EXPLAIN'	=> 'اگر بله انتخاب شود،سرور از اطلاعات اتوماتیک و وارد شده در این بخش استفاده خواهد کرد.',
	'ICONS_PATH'				=> 'مسیر ذخیره آیکون‌های پست',
	'ICONS_PATH_EXPLAIN'		=> 'مسیری در دایرکتوری phpBB شما. برای مثال <samp>images/icons</samp>.',
	'MOD_REWRITE_ENABLE'		=> 'فعال سازی URL Rewriting',
	'MOD_REWRITE_ENABLE_EXPLAIN' => 'هنگامیکه این گزینه فعال باشد فایل‌هایی مثل ’app.php’ آدرس آن‌ها تغییر پیدا میکند مثل ( app.php/foo که تبدیل میشود به /foo).  <strong>در سرورهای آپاچی عملگر mod_rewrite بایستی از طرف مدیر سرور فعال باشد; چنانچه این گزینه فعال باشد و و عملگر ذکر شده پشتیبانی نشود ممکن است لینک های شما به صورت نادرست به نمایش در آید.</strong>',
	'MOD_REWRITE_DISABLED'		=> 'عملگر <strong>mod_rewrite</strong> روی سرور شما غیرفعال است. جهت فعال سازی آن با مدیر سرور تماس بگیرید.',
	'MOD_REWRITE_INFORMATION_UNAVAILABLE' => 'ما قادر به فعال سازی عملگر URL rewriting در سرور شما نیستیم. ممکن است این گزینه فعال باشد ولی عملگر URL rewriting فعال نیست. و ممکن است آدرس ها به درستی نمایش داده نشوند.برای فعال سازی آن بایستی با مدیر سرور تماس بگیرید.',
	'PATH_SETTINGS'				=> 'تنظیمات مسیر',
	'RANKS_PATH'				=> 'مسیر ذخیره تصاویر رتبه‌ها',
	'RANKS_PATH_EXPLAIN'		=> 'مسیری در دایرکتوری phpBB شما. برای مثال <samp>images/ranks</samp>.',
	'SCRIPT_PATH'				=> 'مسیر اسکریپت',
	'SCRIPT_PATH_EXPLAIN'		=> 'مسیری که با توجه به دامنه، phpBB در آن قرار دارد. برای مثال <samp>/phpBB3</samp>.',
	'SERVER_NAME'				=> 'نام دامنه',
	'SERVER_NAME_EXPLAIN'		=> 'نام دامنه ای که این تالار در آن اجرا می شود (برای مثال : <samp>example.com</samp>).',
	'SERVER_PORT'				=> 'پورت سرور',
	'SERVER_PORT_EXPLAIN'		=> 'پورتی که سرور در ان اجرا می شود،اغلب 80 می باشد.',
	'SERVER_PROTOCOL'			=> 'پروتکل سرور',
	'SERVER_PROTOCOL_EXPLAIN'	=> 'اگر از این تنظیمات استفاده شود، در این گزینه می‌توانید پروتکل مورد استفاده را مشخص کنید. اگر این فیلد خالی باشد و یا مورد استفاده قرار نگیرد، تنظیمات امن کوکی این پروتکل را مشخص خواهد کرد. (<samp>htts://</samp> یا <samp>https://</samp>).',
	'SERVER_URL_SETTINGS'		=> 'تنظیمات URL سرور',
	'SMILIES_PATH'				=> 'مسیر ذخیره شکلک‌ها',
	'SMILIES_PATH_EXPLAIN'		=> 'مسیری در دایرکتوری phpBB شما. برای مثال <samp>images/smilies</samp>.',
	'UPLOAD_ICONS_PATH'			=> 'مسیر ذخیره افزونه آیکون‌های گروه',
	'UPLOAD_ICONS_PATH_EXPLAIN'	=> 'مسیری در دایرکتوری phpBBb شما.  برای مثال <samp>images/upload_icons</samp>.',
	'USE_SYSTEM_CRON'		=> 'اجرای دوره ای سیستم cron',
	'USE_SYSTEM_CRON_EXPLAIN'		=> 'هنگامیکه این گزینه غیرفعال باشد phpBB به صورت وظایف دوره ای را انجام میدهد. و هنگامیکه این گزینه فعال باشد phpBB هیچ وظیفه دوره را به تنهایی انجام نخواهد داد; و می‌توانید آنرا تنظیم کنید که وظیفه آن در فایل <code>bin/phpbbcli.php cron:run</code> خواهد بود. می‌توانید بر حسب دقیقه مثلا 5 دقیقه سیستم را به دلخواه تنظیم کنید.',
));

// Security Settings
$lang = array_merge($lang, array(
	'ACP_SECURITY_SETTINGS_EXPLAIN'		=> 'در این بخش می‌توانید تنظیمات مربوط به نشست و ورود را اعمال کنید.',

	'ALL'							=> 'All',
	'ALLOW_AUTOLOGIN'				=> 'مجوز استفاده از " مرا به خاطر بسپار"',
	'ALLOW_AUTOLOGIN_EXPLAIN'		=> 'این گزینه به کاربران این امکان را میدهد تا از گزینه" مرا به خاطر بسپار" استفاده نمایند.',
	'ALLOW_PASSWORD_RESET'			=> 'مجوز ارسال گذرواژه مجدد " فراموشی گذرواژه"',
	'ALLOW_PASSWORD_RESET_EXPLAIN'	=> 'این گزینه باعث میشود کاربران بتوانند گذرواژه خود را در صورت فراموشی بازنشانی کنند. چنانچه از سرویس های خارجی برای ورود کاربران استفاده میکنید این گزینه را غیرفعال کنید.',
	'AUTOLOGIN_LENGTH'				=> 'تاریخ انقضای کلید ورود متداوم به تالار (به روز)',
	'AUTOLOGIN_LENGTH_EXPLAIN'		=> 'تعداد روزهایی که اگر کاربر اقدام به ورود خودکار نکند، کلید ورود خودکار حذف خواهد شد،برای غیرفعال کردن 0 را وارد کنید.',
	'BROWSER_VALID'					=> 'تأیید مرورگر',
	'BROWSER_VALID_EXPLAIN'			=> 'تأیید مرورگر در هر نشست را به منظور بالا بردن سطح امنیت، کنترل می کند.',
	'CHECK_DNSBL'					=> 'کنترل IP در لیست سیاه DNS ',
	'CHECK_DNSBL_EXPLAIN'			=> 'اگر فعال شود،IP کاربران در سایت های خدمات DNSBL در حین ثبت نام و یا ارسال پست کنترل می شود. برای مثال <a href="http://spamcop.net">spamcop.net</a> و <a href="http://www.spamhaus.org">www.spamhaus.org</a>. این فرآیند کمی طول می کشد و بستگی به پیکربندی سرور دارد. اگر فعال سازی این گزینه سرعت تالار را پایین بیاورد و یا اشتباها IP ها را منع کند، این گزینه را غیرفعال کنید.',
	'CLASS_B'						=> 'A.B',
	'CLASS_C'						=> 'A.B.C',
	'EMAIL_CHECK_MX'				=> 'جست‌وجوی دامنه ایمیل برای یافتن MX record معتبر',
	'EMAIL_CHECK_MX_EXPLAIN'		=> 'اگر فعال شود ایمیل های وارد شده در حین ثبت نام و یا نمایه،برای یافتن MX record جست‌وجو می شوند.',
	'FORCE_PASS_CHANGE'				=> 'اجبار در تغییر گذرواژه',
	'FORCE_PASS_CHANGE_EXPLAIN'		=> 'از کاربران خواسته می شود که بعد از تعداد روز معین، گذرواژهشان را تغییر دهند،برای غیرفعال کردن 0 را وارد کنید.',
	'FORM_TIME_MAX'					=> 'حداکثر زمان ارسال فرم',
	'FORM_TIME_MAX_EXPLAIN'			=> 'زمانی که کاربر در آن مدت باید فرم را ارسال کند. برای غیرفعال کردن از -1 استفاده کنید بدون در نظر گرفتن این تنظیم،اگر نشست طولانی باشد ممکن است فرم بی اعتبار شود.',
	'FORM_SID_GUESTS'				=> 'فرم متصل کننده برای نشست مهمانان',
	'FORM_SID_GUESTS_EXPLAIN'		=> 'اگر فعال باشد،برای کاربران مهمانی که خارج از نشست قرار بگیرند این فرم نشان داده خواهد شد.ممکن است در بعضی از ISP ها مشکل ساز باشد.',
	'FORWARDED_FOR_VALID'			=> 'تأیید هدر (heade) <var>X_FORWARDED_FOR</var>',
	'FORWARDED_FOR_VALID_EXPLAIN'	=> 'نشست ها فقط هنگامی ادامه می یابند که هدر <var>X_FORWARDED_FOR</var> با مورد قبلی ارسالی ان برابر باشد. تحریم ها نیز با کنترل IP ها در <var>X_FORWARDED_FOR</var> صورت می گیرند.',
	'IP_VALID'						=> 'تأیید IP نشست',
	'IP_VALID_EXPLAIN'				=> 'مشخص می کند که چه مقدار از IP کاربر باید تأیید شود. <samp>همه</samp> تمامی بخش های IP ، <samp>A.B.C</samp> سه بخش اول x.x.x، <samp>A.B</samp> دو بخش اول x.x را کنترل می کند و <samp>هیچکدام</samp> این فرایند را غیرفعال می کند. در آدرس IPv6 <samp>A.B.C</samp> 4 بلوک اول و <samp>A.B</samp> سه بلوک اول را کنترل می کند.',
	'IP_LOGIN_LIMIT_MAX'			=> 'حداکثر تعداد اقدام برای ورود به تالار در هر IP',
	'IP_LOGIN_LIMIT_MAX_EXPLAIN'	=> 'اگر کاربر بیش از این تعداد اقدام به ورود کند، کد تأیید از او خواسته خواهد شد. برای لغو درخواست کد تایی، 0 را وارد کنید.',
	'IP_LOGIN_LIMIT_TIME'			=> 'تاریخ انقضای اقدام به ورود برای هر IP',
	'IP_LOGIN_LIMIT_TIME_EXPLAIN'	=> 'بعد از این بازه زمانی ورود امکان پذیر نخواهد بود.',
	'IP_LOGIN_LIMIT_USE_FORWARDED'	=> 'اعمال محدودیت در ورود توسط هدر <var>X_FORWARDED_FOR</var>',
	'IP_LOGIN_LIMIT_USE_FORWARDED_EXPLAIN'	=> 'به جای اینکه توسط IP محدودیت هایی در ورود کاربران به وجود آید، داده هدر <var>X_FORWARDED_FOR</var> این محدودیت ها را اعمال می کند. <br><em><strong>هشدار :</strong> این گزینه را فقط هنگامی فعال کنید که سرور پروکسی شما به طور مطمئن داده <var>X_FORWARDED_FOR</var> رر اجرا می کند.</em>',
	'MAX_LOGIN_ATTEMPTS'			=> 'حداکثر تعداد اقدام به ورود',
	'MAX_LOGIN_ATTEMPTS_EXPLAIN'	=> 'بعد از این تعداد ورود ناموفق،از کاربر خواسته خواهد شد تا کد تأیید را وارد کند.',
	'NO_IP_VALIDATION'				=> 'هیچکدام',
	'NO_REF_VALIDATION'				=> 'هیچکدام',
	'PASSWORD_TYPE'					=> 'پیچیدگی گذرواژه',
	'PASSWORD_TYPE_EXPLAIN'			=> 'مشخص می کند که گذرواژه کاربران باید به چه میزانی پیچیده باشند، گزینه‌های بعدی شامل گزینه‌های قبلی نیز می شوند.',
	'PASS_TYPE_ALPHA'				=> 'باید حاوی اعداد و حروف باشد',
	'PASS_TYPE_ANY'					=> 'نیازی نیست',
	'PASS_TYPE_CASE'				=> 'باید پیچیده باشد',
	'PASS_TYPE_SYMBOL'				=> 'باید حاوی نماد باشد',
	'REF_HOST'						=> 'فقط هاست تأیید شود',
	'REF_PATH'						=> 'مسیر نیز تأیید شود',
	'REFERRER_VALID'				=> 'تأیید رجوع کننده',
	'REFERRER_VALID_EXPLAIN'		=> 'اگر فعال شود.درخواست پست ارجاع کننده در تنظیمات اسکریپت/مسیر کنترل خواهد شد. این حالت ممکن است زمانی رخ دهد که تالار از چند دامنه استفاده کرده باشد و یا چند صفحه ورود موجود باشد.',
	'TPL_ALLOW_PHP'					=> 'مجوز استفاده php در قالب‌ها',
	'TPL_ALLOW_PHP_EXPLAIN'			=> 'اگر این گزینه فعال باشد، <code>PHP</code> و <code>INCLUDEPHP</code> شناسایی شده و در قالب تجزیه خواهند شد.',
	'UPLOAD_CERT_VALID'				=> 'اعتبار گواهی بارگذاری',
	'UPLOAD_CERT_VALID_EXPLAIN'		=> 'If enabled, certificates of remote uploads will be validated. This requires the CA bundle to be defined by the <samp>openssl.cafile</samp> or <samp>curl.cainfo</samp> setting in your php.ini.',

));

// Email Settings
$lang = array_merge($lang, array(
	'ACP_EMAIL_SETTINGS_EXPLAIN'	=> 'این اطلاعات، ایمیل های ارسالی به کاربران را تنظیم می کنند، اطمینان حاصل کنید که ایمیل معتبری را وارد کرده اید. این ایمیل منعکس کننده هر گونه خطا در ارسال ایمیل ها به کاربران خواهد بود. اگر سرور ایمیلی را در دسترس ندارید (بر پایه ی PHP)  می‌توانید از تنظیمات SMTP استفاده کنید، برای جزئیات با سرویس خدمات دهی ایمیلتان تماس بگیرید. اگر سرور نیازمند تأیید باشد،گذرواژه و نام کاربری مربوطه را وارد کرده و نیز روش تأیید را مشخص کنید.',

	'ADMIN_EMAIL'					=> 'آدرس ایمیل بازخورد',
	'ADMIN_EMAIL_EXPLAIN'			=> 'این ایمیل در تمامی ایمیل ها و از جمله ایمیل پشتیبانی فنّی مورد استفاده قرار خواهد گرفت. همچنین در <samp>مسیر بازخورد</samp> و <samp>فرستنده</samp> ایمیل ها مورد استفاده قرار خواهد گرفت.',
	'BOARD_EMAIL_FORM'				=> 'ارسال ایمیل توسط کاربران به وسیله تالار',
	'BOARD_EMAIL_FORM_EXPLAIN'		=> 'کاربران خواهند توانست به جای ارسال ایمیل به وسیله آدرس ایمیل خود، این کار را با استفاده از تالار انجام دهند.',
	'BOARD_HIDE_EMAILS'				=> 'مخفی کردن آدرس های ایمیل',
	'BOARD_HIDE_EMAILS_EXPLAIN'		=> 'این عملکرد تمامی ایمیل ها را به صورت مخفی و محرمانه نگهداری خواهد کرد.',
	'CONTACT_EMAIL'					=> 'آدرس ایمیل تماس',
	'CONTACT_EMAIL_EXPLAIN'			=> 'این آدرس ایمیل هنگامی استفاده خواهد شد که پشتیبانی ای از طریق ایمیل مورد نیاز باشد. برای مثال اسپم،خطا ها و غیره... . همیشه در ایمیل ها به عنوان <samp>از</samp> و <samp>پاسخ به</samp> استفاده خواهد شد.',
	'CONTACT_EMAIL_NAME'			=> 'نام تماس',
	'CONTACT_EMAIL_NAME_EXPLAIN'	=> 'نامی که گیرنده های تماس آن را مشاهده خواهند کرد. چنانچه مایل به گذاشتن نامی نیستید این گزینه را خالی بگذارید.',
	'EMAIL_FORCE_SENDER'			=> 'Force from email address',
	'EMAIL_FORCE_SENDER_EXPLAIN'	=> 'This will set the <samp>Return-Path</samp> to the from email address instead of using the local user and hostname of the server. This setting does not apply when using SMTP.<br><em><strong>Warning:</strong> Requires the user that the webserver runs as to be added as trusted user to the sendmail configuration.</em>',
	'EMAIL_PACKAGE_SIZE'			=> 'حجم بسته ایمیل',
	'EMAIL_PACKAGE_SIZE_EXPLAIN'	=> 'این حداکثر تعداد ایمیلی می باشد که می توان در یک بسته ارسال کرد این تنظیمات در پیام‌های داخلی اعمال می شود. اگر با مشکلی در ارسال ایمیل ها روبرو شدید این گزینه را با وارد کردن 0 غیرفعال کنید.',
	'EMAIL_MAX_CHUNK_SIZE'			=> 'حداکثر ایمیل مجاز دریافتی',
	'EMAIL_MAX_CHUNK_SIZE_EXPLAIN'	=> 'در صورت لزوم می‌توانید حداکثر ایمیل مجاز دریافتی را تنظیم کنید تا از تنظیمات سرور شما تجاوز نکند',
	'EMAIL_SIG'						=> 'امضای ایمیل',
	'EMAIL_SIG_EXPLAIN'				=> 'این متن به تمامی ایمیل های ارسالی از این تالار پیوست خواهد شد.',
	'ENABLE_EMAIL'					=> 'فعال سازی ایمیل ها در تالار',
	'ENABLE_EMAIL_EXPLAIN'			=> 'اگر این گزینه غیرفعال باشد،هیچ ایمیلی از تالار ارسال نخواهد شد. <em>لطفا توجه داشته باشید که تنظیمات فعال سازی حساب کاربران و مدیران نیازمند آن است تا این گزینه فعال باشد. اگر اخیراً از فعال سازی "کاربران" و یا "مدیران" استفاده می کنید، غیرفعال کردن این گزینه، باعث غیرفعال شدن ثبت نام می شود.</em>',
	'SEND_TEST_EMAIL'				=> 'ارسال ایمیل آزمایشی',
	'SEND_TEST_EMAIL_EXPLAIN'		=> 'این قسمت باعث ارسال یک ایمیل آزمایشی به آدرس پیش‌فرض حساب شما میشود.',
	'SMTP_ALLOW_SELF_SIGNED'		=> 'مجوز خود-امضا تأییدیه SSL',
	'SMTP_ALLOW_SELF_SIGNED_EXPLAIN'=> 'مجوز اتصال به سرور SMTP با خود-امضای تأییدیه SSL <br><em><strong>هشدار:</strong> مجوز خود-امضای تأییدیه SSL ممکن است باعث بوجود آمدن مسائل امنیتی شود.</em>',
	'SMTP_AUTH_METHOD'				=> 'روش تأیید برای SMTP',
	'SMTP_AUTH_METHOD_EXPLAIN'		=> 'فقط هنگامی استفاده کنید که نام کاربری و گذرواژه تأیید شده باشد، اگر مطمئن نیستید که از کدام گزینه استفاده کنید، با سرویس دهنده خود تماس بگیرید.',
	'SMTP_CRAM_MD5'					=> 'CRAM-MD5',
	'SMTP_DIGEST_MD5'				=> 'DIGEST-MD5',
	'SMTP_LOGIN'					=> 'ورود',
	'SMTP_PASSWORD'					=> 'گذرواژه SMTP',
	'SMTP_PASSWORD_EXPLAIN'			=> 'فقط هنگامی گذرواژه را وارد کنید که سرویس دهنده ایمیل آن را خواسته باشد.<br><em><strong>هشدار :</strong> این گذرواژه به صورت متن ساده در پایگاه داده ذخیره خواهد شد و برای هر کسی که به پایگاه داده و یا به این صفحه پیکربندی دسترسی داشته باشد قابل مشاهده خواهد بود.</em>',
	'SMTP_PLAIN'					=> 'PLAIN',
	'SMTP_POP_BEFORE_SMTP'			=> 'POP-BEFORE-SMTP',
	'SMTP_PORT'						=> 'پورت سرور SMTP',
	'SMTP_PORT_EXPLAIN'				=> 'این گزینه را فقط هنگامی استفاده کنید که مطمئن باشید سرور شما در پورت دیگری جز این اجرا می شود.',
	'SMTP_SERVER'					=> 'آدرس سرور SMTP',
	'SMTP_SERVER_EXPLAIN'			=> 'لطفا از پروتوکل (<samp>ssl://</samp> or <samp>tls://</samp>)  استفاده نکنید، مگر سرور به شما اجازه چنین کاری بدهد',
	'SMTP_SETTINGS'					=> 'تنظیمات SMTP',
	'SMTP_USERNAME'					=> 'نام کاربری SMTP',
	'SMTP_USERNAME_EXPLAIN'			=> 'فقط هنگامی گذرواژه را وارد کنید که سرور ایمیل آن را خواسته باشد.',
	'SMTP_VERIFY_PEER'				=> 'تأیید گواهی SSL',
	'SMTP_VERIFY_PEER_EXPLAIN'		=> 'نیاز به تأیید گواهی SSL توسط سرور SMTP <br><em><strong>هشدار:</strong> اتصال نظیر با گواهینامه SSL تأیید نشده ممکن است مشکلات امنیتی بوجود آورد</em>',
	'SMTP_VERIFY_PEER_NAME'			=> 'تأیید SMTP',
	'SMTP_VERIFY_PEER_NAME_EXPLAIN'	=> 'نیاز به تأیید نام نظیر برای سرور SMYP با استفاده از اتصال SSL / TLS <br><em><strong>هشدار:</strong> اتصال با تأییده نا معتبر باعث ایجاد مشکلات امنیتی خواهد شد. </em>',
	'TEST_EMAIL_SENT'				=> 'ایمیل آزمایشی ارسال شد.<br>اگر ایمیل به دست شما نرسید تنظیمات بخش ایمیل را بررسی کنید.<br><br>اگر نیاز به کمک بیشتری دارید, به بخش پشتیبانی مراجعه کنید <a href="https://www.phpbb.com/community/">بخش پشتیبانی</a>.',
	'USE_SMTP'						=> 'استفاده از سرور SMTP برای ایمیل',
	'USE_SMTP_EXPLAIN'				=> 'برای ارسال ایمیل ها به وسیله سرور SMTP به جای تابع PHP ایمیل، "بله" را انتخاب کنید.',
));

// Jabber settings
$lang = array_merge($lang, array(
	'ACP_JABBER_SETTINGS_EXPLAIN'	=> 'در این بخش می‌توانید Jabber را برای پیام رسانی سریع و درج اطلاعیه‌ها در تالار فعال کنید. Jabber پروتکلی بازمتن می باشد و برای همین برای همه قابل استفاده است. بعضی از Jabber ها دارای درگاه هایی کی باشند که می توانند کاربران را به سایر شبکه ها متصل کنند. تغییر در پروتکل ممکن است موجب عدم انتقال شود. لطفا جزئیات حساب ثبت نام شده را با دقت وارد کنید - phpBB از این اطلاعات استفاده خواهد کرد.',

	'JAB_ALLOW_SELF_SIGNED'			=> 'مجوز خود-امضا گواهینامه SSL',
	'JAB_ALLOW_SELF_SIGNED_EXPLAIN'	=> 'مجوز اتصال به سرور Jabber با خود-امضا گواهینامه SSL <br><em><strong>هشدار:</strong>مجوز خود-امضای گواهینامه SSL در برخی موارد باعث مشکلات امنیتی خواهد شد. .</em>',
	'JAB_ENABLE'					=> 'فعال سازی Jabber',
	'JAB_ENABLE_EXPLAIN'			=> 'فعال سازی استفاده از پیام و اطلاعیه Jabber .',
	'JAB_GTALK_NOTE'				=> 'لطفا توجه کنید که GTalk ممکن است کار  نکند به دلیل عملکرد<samp>dns_get_record</samp>که ممکن است یافت نشود. اسن عملکرد در PHP4 وجود ندارد و با پلتفرم های ویندوز سازگار نیست.و همچنین با سیستم ها BSD مانند مک او اس نیز سازگار نیست. ',
	'JAB_PACKAGE_SIZE'				=> 'اندازه پیکج Jabber',
	'JAB_PACKAGE_SIZE_EXPLAIN'		=> 'این گزینه تعداد پیام‌ها در یک پکیج است. اگر عدد 0 قرار بگیرد بلافاصله  ارسال خواهد شد و در لیست انتظار قرار نمیگیرد.',
	'JAB_PASSWORD'					=> 'گذرواژه Jabber',
	'JAB_PASSWORD_EXPLAIN'			=> '<em><strong>هشدار:</strong>این گذرواژه به صورت فایل متنی در پایگاه داده ذخیره میشود و برای کسانی که به آن دسترسی دارتد و یا بتوانند به فایل‌های تنظیمات دسترسی داشته باشند قابل مشاهده است. </em>',
	'JAB_PORT'						=> 'انتقال Jabber',
	'JAB_PORT_EXPLAIN'				=> 'چنانچه نمیدانید آن را خالی بگذارید و بدانید درگاه 5222 نیست.',
	'JAB_SERVER'					=> 'سرور Jabber',
	'JAB_SERVER_EXPLAIN'			=> 'مشاهده %sjabber.org%s برای دیدن لیست سرور ها',
	'JAB_SETTINGS_CHANGED'			=> 'تنظیمات Jabber با موفقیت انجام شد',
	'JAB_USE_SSL'					=> 'استفاده از SSL برای اتصال',
	'JAB_USE_SSL_EXPLAIN'			=> 'چنانچه اتصال امن برقرار یا سعی در ایجاد آن شود درگاه Jabber به 5223 از 5222 تغییر میکند ',
	'JAB_USERNAME'					=> 'نام کاربری Jabber یا JID',
	'JAB_USERNAME_EXPLAIN'			=> 'یک نام کاربری ثبت نام شده یا یک JID معتبر مشخص کنید. اگر تنها یک نام کاربری مشخص کنید آنگاه JID شما نام کاربری در سرور شما مشخص میشوددر غیر ا ین صورت یک JID معتبر مشخص کنید مثلا  user@jabber.org.',
	'JAB_VERIFY_PEER'				=> 'تأیید گواهینامه SSL',
	'JAB_VERIFY_PEER_EXPLAIN'		=> 'نیاز به تأیید گواهینامه SSL برای استفده از سرور Jabber <br><em><strong>هشدار:</strong> اتصال نظیر با تأییدیه نا معتبرممکن اس باعث ایجاد مشکلات امنیتی شود </em>',
	'JAB_VERIFY_PEER_NAME'			=> 'تأیید نام نظیر Jabber',
	'JAB_VERIFY_PEER_NAME_EXPLAIN'	=> 'نیاز به تأیید یک سرور Jabber که از ارتباط SSL / TSL استفاده میکند <br><em><strong>هشدار:</strong>اتصال نظیر نا معتبر باعث ایجاد مشکلات امنیتی خواهد شد </em>',
));
