<?php
/**
*
* phpBB 3.3.X Project - Persian Translation
* Translators: PHP-BB.IR Group Meis@M Nobari
* Version: 3.3.12 - 1403/03/12
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '<a href="http://www.php-bb.ir">phpBB Persian</a> پشتیبانی فارسی ',
	'DIRECTION'			=> 'rtl',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'DATETIME_FORMAT'	=> '|d M Y, H:i|',	// 01 Jan 2007, 13:37 (with Relative days enabled)
	'USER_LANG'			=> 'fa',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 1,

	'1_DAY'			=> '1 روز',
	'1_MONTH'		=> '1 ماه',
	'1_YEAR'		=> '1 سال',
	'2_WEEKS'		=> '2 هفته',
	'3_MONTHS'		=> '3 ماه',
	'6_MONTHS'		=> '6 ماه',
	'7_DAYS'		=> '7 روز',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'حساب شما در حال حاضر فعال می‌باشد.',
	'ACCOUNT_DEACTIVATED'			=> 'حساب شما به طور دستی غیرفعال شده است و فقط از جانب مدیران کل قابل فعال سازی است.',
	'ACP'							=> 'کنترل پنل مدیر کل',
	'ACP_SHORT'						=> 'ACP',
	'ACTIVATION_ALREADY_SENT'		=> 'ایمیل فعال سازی  به آدرس ایمیل شما ارسال شده. بعد از 24 ساعت مجدد تلاش کنید. چنانچه برای فعال سازی اکانت خود مشکل دارید با مدیریت تالار تماس بگیرید.',
	'ACTIVE'						=> 'فعال',
	'ACTIVE_ERROR'					=> 'نام کاربری مورد نظر غیرفعال می‌باشد. چنانچه مشکلی در فعال سازی آن دارید با مدیریت تماس حاصل فرمائید.',
	'ADMINISTRATOR'					=> 'مدیر کل',
	'ADMINISTRATORS'				=> 'مدیران کل',
	'AGE'							=> 'سن',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'خطا ایجکس',
	'AJAX_ERROR_TEXT'				=> 'مشکلی در هنگام اجرای درخواست شما بوجود آمده است.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'درخواست کاربر نامعتبر است.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'درخواست شما ناموفق بود لطفاً دوباره تلاش کنید.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'هنگام درخواست مشکلی پیش آمده و پاسخی از سوی سرور دریافت نشده است.',
	'ALLOWED'						=> 'مجاز',
	'ALL_FILES'						=> 'تمامی فایل‌ها',
	'ALL_FORUMS'					=> 'همه انجمن‌ها',
	'ALL_MESSAGES'					=> 'همه پیام‌ها',
	'ALL_POSTS'						=> 'همه پست‌ها',
	'ALL_TIMES'						=> 'تمام زمان ها بر اساس <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'					=> 'همه موضوعات',
	'ALT_TEXT'						=> 'متن جایگزین',
	'AND'							=> 'و',
	'ARE_WATCHING_FORUM'			=> 'برای باخبر شدن از پست‌های جدید، در این انجمن عضو شدید.',
	'ARE_WATCHING_TOPIC'			=> 'برای باخبر شدن از پست‌های جدید، در این موضوع عضو شدید.',
	'ASCENDING'						=> 'صعودی',
	'ATTACHMENTS'					=> 'پیوست‌ها',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'تصویری که برای پیوست کردن آن تلاش میکنید، نامعتبر است.',
	'AUTHOR'						=> 'نویسنده',
	'AUTH_NO_PROFILE_CREATED'		=> 'ایجاد مشخصات کاربر ناموفق بود.',
 	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'				=> 'این حساب به کاربر دیگری متصل شده است.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'ورود به پایگاه داده با مشکل مواجه شده است.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'سرویس راه دور مجاز نیست.',
	'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'						=> 'هنگام انجام مرحله OAuth مشکلی پیش آمده است.',
	'AUTH_PROVIDER_OAUTH_RETURN_ERROR'						=> 'سرویس خارجی مقدار اشتباهی را بازگرداند، بنابراین درخواست شما قابل پردازش نیست.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'سرویس ورود راه دور ساخته نشد.',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'بیتلی',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'فیس بوک',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'گوگل',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'توییتر',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'OAuth گرفته شده ذخیره نشده است.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'OAuth به صورت نادرست ذخیره شده.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'بارگذاری فایل متوقف شد، زیرا فایل بارگذاری شده به عنوان یک عامل حمله ای که حاوی اطلاعات مخرب است، شناسایی شد.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'این فایل قابل نمایش نیست زیرا پسوند <strong>%s</strong> غیر مجاز است.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'آواتار مشخص شده قابل بارگزاری شدن نیست، زیرا داده از راه دور غیر معتبر و یا خراب است.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'آواتار بارگذاری شده یک فایل خالی است.',
	'AVATAR_INVALID_FILENAME'		=> 'نام فایل %s غیر معتبر است.',
	'AVATAR_NOT_UPLOADED'			=> 'امکان بارگذاری آواتار وجود ندارد.',
	'AVATAR_NO_TEMP_DIR'			=> 'پوشه موقت یافت نشد یا قابل نوشتن نیست.',
	'AVATAR_NO_SIZE'				=> 'طول و عرض آواتار لینک داده شده مشخص نیست، لطفاً این اطلاعات را دستی وارد کنید.',
	'AVATAR_NO_UPLOAD_DIR'			=> 'محل ذخیره سازی آواتار وجود ندارد یا قابل نوشتن نیست.',
	'AVATAR_NO_UPLOAD_PATH'			=> 'قابلیت بارگذاری آواتار فعال است، اما مسیر ذخیره سازی آن مشخص نشده است.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'فقط قسمتی از آواتار مشخص شده بارگذاری شد.',
	'AVATAR_PHP_SIZE_NA'			=> 'حجم آواتار بسیار زیاد است<br />حداکثر حجم فایل مورد قبول در php.ini قابل تشخیص نیست.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'حجم آواتار بسیار زیاد است. حداکثر حجم مورد قبول %1$d %2$s است.<br />توجه داشته باشید که این مقدار در php.ini مشخص شده و قابل بازنویسی نیست.',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'		=> 'آواتار مشخص شده بارگذاری نشد. زیرا درخواست شما بیش از اندازه طول کشیده است.',
	'AVATAR_PHP_UPLOAD_STOPPED'		=> 'یک افزونه PHP مانع بارگذاری فایل میشود.',
	'AVATAR_URL_INVALID'			=> 'لینک مشخص شده نامعتبر است.',
	'AVATAR_URL_NOT_FOUND'			=> 'فایل مشخص شده یافت نشد.',
	'AVATAR_WRONG_FILESIZE'			=> 'حجم آواتار باید بین 0 و %1$d %2$s باشد.',
	'AVATAR_WRONG_SIZE'				=> 'آواتار فرستاده شده %5$s عرض و %6$s ارتفاع دارد. آواتار ها باید حداقل %1$s عرض و %2$s ارتفاع داشده باشند، ولی نباید بیشتر از %3$s عرض و %4$s ارتفاع باشند.',
	
	'BACK_TO_TOP'			=> 'بالا',
	'BACK_TO_PREV'			=> 'بازگشت به صفحه قبل',
	'BAN_TRIGGERED_BY_EMAIL'=> 'آدرس ایملتان تحریم شده است.',
	'BAN_TRIGGERED_BY_IP'	=> 'آی‌پی آدرس شما تحریم شده است.',
	'BAN_TRIGGERED_BY_USER'	=> 'نام کاربری شما تحریم شده است.',
	'BBCODE_GUIDE'			=> 'راهنمای BBCode',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'متولدین امروز',
	'BOARD_BAN_PERM'		=> 'برای <strong>همیشه</strong>از این تالار تحریم شده اید.<br /><br /> لطفاً با مدیر تالار %2$s، %3$s برای اطلاعات بیشتر تماس بگیرید',
	'BOARD_BAN_REASON'		=> 'دلیل تحریم: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'از این تالار تا <strong>%1$s</strong> تحریم شده اید. <br /><br /> لطفاً با مدیر تالار %2$s، %3$s برای اطلاعات بیشتر تماس بگیرید',
	'BOARD_DISABLE'			=> 'متاسفیم ولی این انجمن درحال حاضر در دسترس نیست.',
	'BOARD_DISABLED'		=> 'درحال حاضر این انجمن غیرفعال است.',
	'BOARD_UNAVAILABLE'		=> 'متاسفیم ولی این انجمن موقتا در دسترس نیست، لطفاً دقایقی دیگر مراجعه فرمائید.',
	'BROWSING_FORUM'		=> 'کاربران حاضر در این انجمن: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'کاربران حاضر در این انجمن: %2$s و %1$d مهمان',
		2	=> 'کاربران حاضر در این انجمن: %2$s و %1$d مهمان',
	),
	'BUTTON_DELETE'			=> 'حذف',
	'BUTTON_EDIT'			=> 'ویرایش',
	'BUTTON_FORUM_LOCKED'	=> 'قفل شده',
	'BUTTON_INFORMATION'	=> 'اطلاعات',
	'BUTTON_NEW_TOPIC'		=> 'موضوع جدید',
	'BUTTON_PM'				=> 'پیام خصوصی',
	'BUTTON_PM_FORWARD'		=> 'ارسال به',
	'BUTTON_PM_NEW'			=> 'پیام جدید',
	'BUTTON_PM_REPLY'		=> 'ارسال پاسخ',
	'BUTTON_PM_REPLY_ALL'	=> 'پاسخ به همه',
	'BUTTON_POST_REPLY'		=> 'ارسال پست',
	'BUTTON_QUOTE'			=> 'نقل قول',
	'BUTTON_REPORT'			=> 'گزارش',
	'BUTTON_TOPIC_LOCKED'	=> 'قفل شده',
	'BUTTON_WARN'			=> 'هشدار',
	'BYTES'					=> 'بایت',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'				=> 'لغو',
	'CHANGE'				=> 'تغییر',
	'CHANGE_FONT_SIZE'		=> 'تغییر اندازه فونت',
	'CHANGING_PREFERENCES'	=> 'تغییر تنظیمات انجمن',
	'CHANGING_PROFILE'		=> 'تغییر تنظیمات نمایه',
	'CHARACTERS'			=> array(
		1	=> '%d نویسه',
		2	=> '%d نویسه',
	),
	// Special version to be used when describing ranges e.g. "min x characters and max y characters"
	'CHARACTERS_XY'			=> array(
		1	=> '%d نویسه',
		2	=> '%d نویسه',
	),	
	'COLLAPSE_VIEW'			=> 'نمای کشویی',
	'CLOSE_WINDOW'			=> 'بستن پنجره',
	'CODE'					=> 'کد',
	'COLOUR_SWATCH'			=> 'تغییر رنگ',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> '، ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'تأیید',
	'CONFIRM_CODE'			=> 'کد تأیید',
	'CONFIRM_CODE_EXPLAIN'	=> 'کد مشاهده شده را به صورت دقیق وارد کنید. نسبت به حروف کوچک و بزرگ حساس نیست.',
	'CONFIRM_CODE_WRONG'	=> 'کد تأیید وارد شده نادرست می‌باشد.',
	'CONFIRM_OPERATION'		=> 'آیا از انجام این کار مطمئنید؟',
	'CONFIRM_AVATAR_DELETE' => 'آیا از حرف این آواتار مطمئنید؟',
	'CONGRATULATIONS'		=> 'تبریک به',
	'CONNECTION_FAILED'		=> 'اتصال صورت نگرفت.',
	'CONNECTION_SUCCESS'	=> 'اتصال با موفقیت صورت گرفت!',
	'CONTACT'				=> 'تماس',
	'CONTACT_USER'			=> 'تماس با %s',
	'CONTACT_US'			=> 'تماس با ما',
	'COOKIE_CONSENT_INFO'	=> 'جزئیات بیشتر',
	'COOKIE_CONSENT_MSG'	=> 'این سایت از کوکی استفاده میکند تا مطمئن شود بهترین تجربه را در سایت ما داشته باشید.',
	'COOKIE_CONSENT_OK'		=> 'متوجه شدم!',
	'COOKIE_CONSENT_HREF'	=> 'http://cookiesandyou.com',
	'COOKIES_DELETED'		=> 'همه کوکی های تالار با موفقیت حذف شدند.',
	'CURRENT_TIME'			=> 'امروز: %s',

	'DAY'					=> 'روز',
	'DAYS'					=> 'روز',
	'DELETE'				=> 'حذف',
	'DELETE_ALL'			=> 'حذف همه',
	'DELETE_COOKIES'		=> 'حذف کوکی ها',
	'DELETE_MARKED'			=> 'حذف موارد انتخاب شده',
	'DELETE_POST'			=> 'حذف پست',
	'DELIMITER'				=> 'محدود کننده',
	'DESCENDING'			=> 'نزولی',
	'DISABLED'				=> 'غیرفعال',
	'DISPLAY'				=> 'نمایش',
	'DISPLAY_GUESTS'		=> 'نمایش مهمان ها',
	'DISPLAY_MESSAGES'		=> 'نمایش پیام‌ها از آخر به اول',
	'DISPLAY_POSTS'			=> 'نمایش پست‌ها از آخر به اول',
	'DISPLAY_TOPICS'		=> 'نمایش موضوعات از آخر به اول',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'The entered email domain has no valid MX record.',
	'DOWNLOADED'			=> 'دانلود شده',
	'DOWNLOADING_FILE'		=> 'دانلود فایل',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'هنوز دانلود نشده',
		1	=> '%d مرتبه دانلود شده',
		2	=> '%d مرتبه دانلود شده',
	),


	'EDIT_POST'							=> 'ویرایش پست',
	'ELLIPSIS'							=>	'…',
	'EMAIL'								=> 'ایمیل', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'آدرس ایمیل',
	'EMAIL_INVALID_EMAIL'				=> 'آدرس ایمیل وارد شده نامعتبر است.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'در ارسال ایمیل مشکلی در <strong>سطر %1$s</strong>به وجود آمده است. پاسخ : %2$s.',
	'EMPTY_SUBJECT'						=> 'هنگام ارسال موضوع باید عنوانی را برای آن مشخص کنید.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'هنگام ارسال پیام جدید باید عنوانی را برای آن مشخص کنید.',
	'ENABLED'							=> 'فعال',
	'ENCLOSURE'							=> 'محوطه',
	'ENTER_USERNAME'					=> 'نام کاربری را وارد کنید',
	'ERR_CHANGING_DIRECTORY'			=> 'تغییر مسیر امکان ندارد.',
	'ERR_CONNECTING_SERVER'				=> 'خطای ارتباط با سرور.',
	'ERR_JAB_AUTH'						=> 'سرور Jabber اجازه اتصال را نمیدهد',
	'ERR_JAB_CONNECT'					=> 'اتصال به سرور Jabber صورت نگرفت',
	'ERR_UNABLE_TO_LOGIN'				=> 'گذرواژه و یا نام کاربری مشخص شده نادرست می‌باشد.',
	'ERR_UNWATCHING'					=> 'در لغو عضویت مشکلی پیش آمد.',
	'ERR_WATCHING'						=> 'در عضویت مشکلی پیش آمد.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'مسیر phpbb مشخص شده نامعتبر می‌باشد',
	'ERROR'									=> 'خطا',
	'EXPAND_VIEW'						=> 'دید وسیع',
	'EXTENSION'							=> 'افزونه',
	'EXTENSION_DISABLED'				=> 'افزونه <strong>%s</strong> فعال نشده است.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'افزونه <strong>%s</strong> غیرفعال شده است و قابل مشاهده نیست.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'افزونه <strong>%s</strong> وجود ندارد.',

	'FACEBOOK'				=> 'فیس بوک',
	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'سوالات متداول',
	'FEATURE_NOT_AVAILABLE' => 'قابلیت درخواست شده در این انجمن در دسترس نیست.',
	'FILENAME'				=> 'نام فایل',
	'FILESIZE'				=> 'اندازه فایل',
	'FILEDATE'				=> 'تاریخ فایل',
	'FILE_COMMENT'			=> 'توضیح فایل',
	'FILE_CONTENT_ERR'		=> 'محتوای فایل رو به رو قابل خواندن نیست: %s',
	'FILE_JSON_DECODE_ERR'	=> 'مشکلی در رمزگشایی فایل json بوجود آمده: %s',
	'FILE_NOT_FOUND'		=> 'فایل درخواست شده یافت نشد: %s',
	'FIND_USERNAME'			=> 'جست‌وجوی کاربر',
	'FOLDER'				=> 'پوشه',
	'FORGOT_PASS'			=> 'گذرواژه‌ام را فراموش کرده ام',
	'FORM_INVALID'			=> 'فرم ثبت شده نامعتبر می‌باشد، لطفاً دوباره امتحان کنید',
	'FORUM'					=> 'انجمن',
	'FORUMS'				=> 'انجمن‌ها',
	'FORUMS_MARKED'			=> 'انجمن‌ها به عنوان خوانده شده علامت گذاری شدند.',
	'FORUM_CAT'				=> 'شاخه انجمن',
	'FORUM_INDEX'			=> 'صفحه اول تالار',
	'FORUM_LINK'			=> 'لینک انجمن',
	'FORUM_LOCATION'		=> 'محل انجمن',
	'FORUM_LOCKED'			=> 'انجمن بسته است',
	'FORUM_RULES'			=> 'قوانین انجمن',
	'FORUM_RULES_LINK'		=> 'برای مشاهده قوانین انجمن لطفاً اینجا کلیک کنید.',
	'FROM'					=> 'از',
	'FSOCK_DISABLED'		=> 'عملیات پایان نیافت. تابع <var>fsockopen</var> غیرفعال شده است و یا در سرور یافت نشد.',
	'FSOCK_TIMEOUT'			=> 'درحین خواندن از شبکه، نشست قطع شد.',

	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'		=> 'گروه فایل قابل تغییر نیست',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS'	=> 'سطح دسترسی فایل قابل تغییر نیست',
	'FILESYSTEM_CANNOT_COPY_FILES'				=> 'فایل‌ها قابل کپی نیستند',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'			=> 'ایجاد لینک ها ممکن نیست',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'		=> 'ساخت دایرکتوری ممکن نیست',
	'FILESYSTEM_CANNOT_DELETE_FILES'			=> 'فایل‌های سیستم قابل حذف نیست',
	'FILESYSTEM_CANNOT_DUMP_FILE'				=> 'فایل مورد نظر قابل حذف نیست',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'		=> 'دایرکتوری قابل کپی برداری نیست',
	'FILESYSTEM_CANNOT_RENAME_FILE'				=> 'فایل داخل سیستم قابل تغییر نام نیست',
	'FILESYSTEM_CANNOT_TOUCH_FILES'				=> 'قابلیت ایجاد یا تغییر فایل وجود ندارد',

	'FTP_FSOCK_HOST'				=> 'هاست FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'سرور FTP که برای اتصال به سایتتان استفاده میکنید.',
	'FTP_FSOCK_PASSWORD'			=> 'گذرواژه FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'گذرواژه برای نام کاربری FTP.',
	'FTP_FSOCK_PORT'				=> 'درگاه FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'درگاه ای که برای اتصال به سایتتان از آن استفاده میکنید.',
	'FTP_FSOCK_ROOT_PATH'			=> 'مسیر به phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'مسیر از روت سایت به تالار phpBB.',
	'FTP_FSOCK_TIMEOUT'				=> 'زمان خروج (timeout) FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'مدت زمانی که سیستم(به ثانیه) صبر خواهد کرد تا پاسخی از جانب سرور دریافت کند.',
	'FTP_FSOCK_USERNAME'			=> 'نام کاربری FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'نام کاربری که برای اتصال به FTP سایتتان از آن استفاده میکنید.',

	'FTP_HOST'					=> 'هاست FTP',
	'FTP_HOST_EXPLAIN'			=> 'سرور FTP که برای اتصال به سایتتان استفاده میکنید.',
	'FTP_PASSWORD'				=> 'گذرواژه FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'گذرواژه برای نام کاربری FTP',
	'FTP_PORT'					=> 'درگاه FTP',
	'FTP_PORT_EXPLAIN'			=> 'درگاه ای که برای اتصال به سایتتان از آن استفاده میکنید.',
	'FTP_ROOT_PATH'				=> 'مسیر به phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'مسیر از روت سایت به تالار phpBB.',
	'FTP_TIMEOUT'				=> 'زمان خروج (timeout) FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'مدت زمانی که سیستم(به ثانیه) صبر خواهد کرد تا پاسخی از جانب سرور دریافت کند.',
	'FTP_USERNAME'				=> 'نام کاربری FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'نام کاربری که برای اتصال به FTP سایتتان از آن استفاده میکنید.',

	'GENERAL_ERROR'				=> 'خطای عمومی',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'برو',
	'GOTO_FIRST_POST'			=> 'برو به اولین پست',
	'GOTO_LAST_POST'			=> 'برو به آخرین پست',
	'GOTO_PAGE'					=> 'برو به صفحه',
	'GROUP'						=> 'گروه',
	'GROUPS'					=> 'گروه‌ها',
	'GROUP_ERR_TYPE'			=> 'نوع گروه نامناسب تعیین شد.',
	'GROUP_ERR_USERNAME'		=> 'نام گروه مشخص نشده است',
	'GROUP_ERR_USER_LONG'		=> 'نام گروه باید حداکثر 60 نویسه باشد. نام گروه وارد شده بسیار طولانی است',
	'GUEST'						=> 'مهمان',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'تعداد %d نفر مهمان آنلاین هستند.',
		2	=> 'تعداد %d نفر مهمان آنلاین هستند.',
	),
	'GUEST_USERS_TOTAL'			=> array(
		1	=> '%d مهمان',
		2	=> '%d مهمان',
	),
	'G_ADMINISTRATORS'			=> 'مدیران کل',
	'G_BOTS'					=> 'ربات‌ها',
	'G_GUESTS'					=> 'مهمان ها',
	'G_REGISTERED'				=> 'کاربران عضو شده',
	'G_REGISTERED_COPPA'		=> 'کاربران COPPA عضو شده',
	'G_GLOBAL_MODERATORS'		=> 'مدیران انجمن',
	'G_NEWLY_REGISTERED'		=> 'کاربران تازه عضو شده',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d کاربران مخفی',
		2	=> '%d کاربران مخفی',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d مخفی',
		2	=> '%d مخفی',
	),
	'HIDE_GUESTS'					=> 'مهمان های مخفی',
	'HIDE_ME'						=> 'آنلاین بودن من را نشان نده',
	'HOURS'							=> 'ساعت',
	'HOME'							=> 'خانه',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'اگر',
	'IMAGE'						=> 'تصویر',
	'IMAGE_FILETYPE_INVALID'	=> 'نوع فایل تصویر %d برای mimetype %s پشتیبانی نمیشود.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'عدم تطبیق نوع فایل تصویر : پسوند مورد انتظار %1$s است ولی پسوند %2$s نمایش داده میشود.',
	'IN'						=> 'در',
	'INACTIVE'					=> 'غیرفعال',
	'INDEX'						=> 'صفحه اول',
	'INFORMATION'				=> 'اطلاعات',
	'INSECURE_REDIRECT'			=> 'تلاش برای تغییر مسیر به آدرسی نا امن',
	'INTERESTS'					=> 'علایق',
	'INVALID_DIGEST_CHALLENGE'	=> 'پرس و جوی نامعتبر',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> احتمالا ایمیل نامعتبری است ؟',
	'INVALID_FEED_ATTACHMENTS'	=> 'The selected feed tried fetching attachments with invalid constraints.',
	'INVALID_PLURAL_RULE'		=> 'قانون صیغه جمع (plural) انتخاب شده نامعتبر است. مقادیر معتبر بین 0 تا 15 می‌باشد',
	'IP'						=> 'آی پی',
	'IP_BLACKLISTED'			=> 'IP شما %1$s مسدود شده است زیرا در لیست مسدود ها قرار دارد. برای جزئیات به <a href="%2$s">%2$s</a> مراجعه کنید',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'تاریخ عضویت',
	'JUMP_PAGE'				=> 'شماره صفحه‌ای را که میخواهید بروید، وارد کنید',
	'JUMP_TO'				=> 'پرش به',
	'JUMP_TO_PAGE'			=> 'پرش به صفحه',
	'JUMP_TO_PAGE_CLICK'	=> 'برای پرش به صفحه‌ای کلیک کنید ...',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'آخرین پست',
	'LAST_UPDATED'						=> 'آخرین به‌روز رسانی',
	'LAST_VISIT'						=> 'آخرین بازدید',
	'LDAP_NO_LDAP_EXTENSION'			=> 'افزونه LDAP موجود نیست.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'اتصال به سرور LDAP صورت نگرفت.',
	'LDAP_SEARCH_FAILED'				=> 'در حین جست‌وجوی مسیر LDAP مشکلی پیش آمد.',
	'LEGEND'							=> 'گروه‌های کاربری',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'اجازه جست‌وجوی زنده را ندارید.',
	'LOADING'							=> 'بارگزاری',
	'LOCATION'							=> 'محل اقامت',
	'LOCK_POST'							=> 'قفل کردن پست',
	'LOCK_POST_EXPLAIN'					=> 'جلوگیری از ویرایش',
	'LOCK_TOPIC'						=> 'بستن موضوع',
	'LOGIN'								=> 'ورود',
	'LOGIN_CHECK_PM'					=> 'برای مشاهده پیام خصوصی، وارد شوید.',
	'LOGIN_CONFIRMATION'				=> 'تأیید ورود',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'در این بخش، برای جلوگیری از ورود های مخرب به حسابتان، اگر بیش از مقدار تعیین شده به صورت نادرست گذرواژه و نام کاربریتان را وارد کنید، از شما خواهد خواست که که کد تأیید را وارد کنید. اگر نمی‌توانید کد را ببینید و یا بخوانید لطفاً با %sمدیر کل تالار%s تماس بگیرید.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'بیش از حد مجاز اقدام به ورود به حسابتان کرده اید، حال باید علاوه بر وارد کردن نام کاربری و گذرواژه، کد تأیید را نیز وارد کنید.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'هویت شما از طرف آپاچی تأیید نشد.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'سرویس تأیید اعتباری که وجود ندارد، درخواست شده است.',
	'LOGIN_ERROR_PASSWORD'				=> 'گذرواژه وارد شده اشتباه می‌باشد، لطفاً گذرواژه خود را بررسی کنید و مجددا تلاش کنید. اگر نتوانستید با %sمدیر کل تالار%s تماس بگیرید.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'در حین به‌روز رسانی نرم افزار داخلی این تالار، امکان بازگردانی گذرواژه شما وجود ندارد. لطفاً %sگذرواژه جدید%s را درخواست کنید. اگر باز هم مشکلی داشتید، لطفاً با %sمدیر کل تالار%s تماس بگیرید.',
	'LOGIN_ERROR_USERNAME'				=> 'نام کاربری نادرستی را وارد کرده اید، لطفاً نام کاربری خود را بررسی کنید و مجددا تلاش کنید. اگر بازهم مشکلی داشتید با %sمدیر کل تالار%s تماس بگیرید.',
	'LOGIN_FORUM'						=> 'برای مشاهده یا ارسال پست در این انجمن باید گذرواژه آن را وارد کنید.',
	'LOGIN_INFO'						=> 'برای ورود باید ثبت نام کنید، ثبت نام در تالار فقط چند لحظه طول میکشد ولی سطح دسترسیتان را بالا میبرد. مدیر تالار میتواند به کاربران اختیارات دیگری نیز دهد و سطح دسترسی آن‌ها را بالا ببرد، قبل از ثبت نام لطفاً قوانین تالار را بخوانید و از آشنایی با آن‌ها مطمئن شوید تا در آینده مشکلی پیش نیاید.',
	'LOGIN_VIEWFORUM'					=> 'برای مشاهده انجمن باید ثبت نام کنید و وارد شوید.',
	'LOGIN_EXPLAIN_EDIT'				=> 'برای ویرایش پست‌های این انجمن باید ثبت نام کنید و وارد شوید.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'برای مشاهده لیست افراد آنلاین باید ثبت نام کنید و وارد شوید.',
	'LOGIN_REQUIRED'					=> 'برای انجام این عمل باید وارد شوید.',
	'LOGOUT'							=> 'خروج',
	'LOGOUT_USER'						=> 'خروج [ %s ]',
	'LOG_ME_IN'							=> 'مرا به خاطر بسپار',

	'MAIN'					=> 'اصلی',
	'MARK'					=> 'علامت',
	'MARK_ALL'				=> 'علامت گذاری همه',
	'MARK_ALL_READ'			=> 'علامت گذاری همه به عنوان خوانده شده',
	'MARK_FORUMS_READ'		=> 'علامت گذاری انجمن‌ها به عنوان خوانده شده',
	'MARK_READ'				=> 'نشانه‌گذاری به خوانده',
	'MARK_SUBFORUMS_READ'	=> 'علامت گذاری زیرانجمن‌ها به عنوان خوانده شده',
	'MB'					=> 'MB',
	'MIB'					=> 'MIB',
	'MCP'					=> 'کنترل پنل مدیر انجمن',
	'MCP_SHORT'				=> 'MCP',
	'MEMBERLIST'			=> 'اعضا',
	'MEMBERLIST_EXPLAIN'	=> 'لیست کامل اعضا',
	'MERGE'					=> 'ادغام',
	'MERGE_POSTS'			=> 'ادغام پست‌ها',
	'MERGE_TOPIC'			=> 'ادغام موضوعات',
	'MESSAGE'				=> 'پیام',
	'MESSAGES'				=> 'پیام‌ها',
	'MESSAGES_COUNT'		=> array(
		0	=> 'پیام نامحدود',	
		1	=> '%d پیام',
		2	=> '%d پیام',
	),
	'MESSAGE_BODY'			=> 'متن پیام',
	'MINUTES'				=> 'دقیقه',
	'MODERATE'				=> 'نظارت',
	'MODERATOR'				=> 'مدیر انجمن',
	'MODERATORS'			=> 'مدیران انجمن',
	'MODULE_NOT_ACCESS'		=> 'ماژول در دسترس نیست.',
	'MODULE_NOT_FIND'		=> 'ماژول مورد نظر یافت نشد %s',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'فایل ماژول %s شامل کلاس های صحیح [%s] نیست. ',
	'MONTH'					=> 'ماه',
	'MOVE'					=> 'انتقال',

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'جدیدترین عضو : <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'پیام جدید',
	'NEW_MESSAGES'				=> 'پیام‌های جدید',
	'NEW_POST'					=> 'پست جدید',	// Not used anymore
	'NEW_POSTS'					=> 'پست‌های جدید',	// Not used anymore
	'NEXT'						=> 'بعدی',		// Used in pagination
	'NEXT_STEP'					=> 'بعدی',
	'NEVER'						=> 'هرگز',
	'NO'						=> 'خیر',
	'NO_NOTIFICATIONS'			=> 'هیچ اعلانی ندارید',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'شما اجازه مدیریت این گروه را ندارید.',
	'NOT_AUTHORISED'			=> 'شما برای دسترسی به این بخش تأیید اعتبار نشده اید.',
	'NOT_WATCHING_FORUM'		=> 'شما دیگر این انجمن را دنبال نمی کنید.',
	'NOT_WATCHING_TOPIC'		=> 'شما دیگر این موضوع را دنبال نمی کنید.',
	'NOTIFICATIONS'				=> 'اعلانات',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>پاسخ</strong> از طرف %1$s برای موضوع نشانه‌گذاری شده:',
	),
	'NOTIFICATION_FORUM'				=> '<em>انجمن:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>درخواست گروه</strong> از %1$s جهت پیوستن به گروه %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>تأیید درخواست گروه</strong> جهت پیوست به گروه %1$s.',
	'NOTIFICATION_METHOD_INVALID'		=> 'روش "%s" یک روش معتبر اعلانات نیست.',
	'NOTIFICATION_PM'					=> '<strong>پیام خصوصی</strong> از طرف %1$s:',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>پاسخ</strong> از طرف %1$s در موضوع:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>پست پذیرفته شد</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>پست تأیید نشد</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>پست نیاز به تأیید</strong> درخواست شده توسط %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>نقل قول</strong> توسط %1$s در:',
	),
	'NOTIFICATION_REFERENCE'			=> '"%1$s"',
	'NOTIFICATION_REASON'				=> '<em>دلیل:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>پیام خصوصی گزارش شد</strong> توسط %1$s:',
	'NOTIFICATION_REPORT_PM_CLOSED'		=> '<strong>گزارش پیام خصوصی بسته شد </strong> توسط %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>پست گزارش شد</strong> توسط %1$s:',
	'NOTIFICATION_REPORT_CLOSED'   		=> '<strong>گزارش بسته شد</strong> توسط %1$s برای:',
	'NOTIFICATION_TOPIC'				=> '<strong>موضوع جدید</strong> توسط %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>موضوع تأیید شد</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>موضوع تأیید نشد</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>موضوع نیاز به تأیید</strong> درخواست شده توسط %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'نوع پیام "%s" از سیستم حذف شده است.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>درخواست فعال سازی</strong> برای کاربران غیرفعال و یا تازه عضو شده : “%1$s”',
	// Used in conjunction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'سایر پیام‌ها',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d سایر پیام‌ها',
	),
	'NOTIFY_ADMIN'				=> 'لطفاً به مدیر تالار اطلاع دهید.',
	'NOTIFY_ADMIN_EMAIL'		=> 'لطفاً به مدیر تالار اطلاع دهید : <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'اجازه دسترسی به این فایل را ندارید.',
	'NO_ACTION'					=> 'عملی مشخص نشده است.',
	'NO_ADMINISTRATORS'			=> 'مدیر کلی وجود ندارد.',
	'NO_AUTH_ADMIN'				=> 'دسترسی به مرکز مدیریت مدیران کل امکان پذیر نیست. شما دسترسی لازم را ندارید.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'اجازه تأیید کاربر دیگری را ندارید.',
	'NO_AUTH_OPERATION'			=> 'سطح دسترسی لازم برای انجام این عملیات را ندارید.',
	'NO_AVATARS'				=> 'آواتاری در دسترس نیست',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'اتصال به سرور smtp موجود نیست. %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'هیچ متولدی امروز وجود ندارد',
	'NO_EMAIL_MESSAGE'			=> 'پیام ایمیل خالی است.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'از سرور ایمیل پاسخی دریافت نشد.',
	'NO_EMAIL_SUBJECT'			=> 'عنوانی برای ایمیل مشخص نشده است.',
	'NO_FORUM'					=> 'انجمن انتخاب شده موجود نیست.',
	'NO_FORUMS'					=> 'این تالار انجمنی ندارد.',
	'NO_GROUP'					=> 'گروه کاربری درخواست شده موجود نمی باشد.',
	'NO_GROUP_MEMBERS'			=> 'این گروه عضوی ندارد.',
	'NO_IPS_DEFINED'			=> 'IP adress یا hostname تعریف نشده است',
	'NO_MEMBERS'				=> 'فعلا کاربری عضو این گروه نمی‌باشد.',
	'NO_MESSAGES'				=> 'پیامی وجود ندارد.',
	'NO_MODE'					=> 'هیچ حالتی مشخص نشده است.',
	'NO_MODERATORS'				=> 'مدیر انجمنی وجود ندارد.',
	'NO_NEW_MESSAGES'			=> 'بدون پیام جدید',
	'NO_NEW_POSTS'				=> 'پست جدید وجود ندارد.',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'کاربر جدیدی وجود ندارد.',
	'NO_POSTS'					=> 'بدون پست',
	'NO_POSTS_TIME_FRAME'		=> 'در بازه زمانی انتخاب شده، پستی درون انجمن موجود نیست.',
	'NO_FEED_ENABLED'			=> 'در این تالار خوراک (feeds) در دسترس نیستند.',
	'NO_FEED'					=> 'خوراک (feed) درخواست شده، در دسترس نیست',
	'NO_STYLE_DATA'				=> 'داده ای از طرف قالب انجمن برای user_style %s و کاربر user_id %s دریافت نشد  ',
	'NO_STYLE_CFG'				=> 'امکان دریافت  تنظیمات فایل قالب وجود ندارد: %s',
	'NO_SUBJECT'				=> 'عنوانی برای موضوع انتخاب نشده است.',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'جست‌وجوی مورد نظر نتیجه ای دربر نداشت.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'متد های تأیید پشتیبانی نمیشود.',
	'NO_TOPIC'					=> 'موضوع درخواست شده موجود نیست.',
	'NO_TOPIC_FORUM'			=> 'موضوع و یا انجمن موجود نیست.',
	'NO_TOPICS'					=> 'هیچ موضوع و یا پستی در این انجمن موجود نیست.',
	'NO_TOPICS_TIME_FRAME'		=> 'در بازه زمانی تعیین شده، موضوعی در این انجمن وجود ندارد.',
	'NO_UNREAD_POSTS'			=> 'پست خوانده نشده ای وجود ندارد.',
	'NO_UPLOAD_FORM_FOUND'		=> 'بارگزاری شروع شده اما فرم معتبری برای آن وجود ندارد.',
	'NO_USER'					=> 'کاربر مورد نظر وجود ندارد.',
	'NO_USERS'					=> 'کاربران مورد نظر وجود ندارند.',
	'NO_USER_SPECIFIED'			=> 'نام کاربری مشخص نشده است.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS' => array(
		1	=> '%d پیوست',
		2	=> '%d پیوست',
	),
	'NUM_POSTS_IN_QUEUE'		=> array(
		0	=> 'پستی در صف وجود ندارد',		// 0
		1	=> '1 پست در صف است',		// 1
		2	=> '%d پست در صف است',		// 2+
	),

	'OCCUPATION'				=> 'شغل',
	'OFFLINE'					=> 'آفلاین',
	'ONLINE'					=> 'آنلاین',
	'ONLINE_BUDDIES'			=> 'دوستان آنلاین',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'در مجموع <strong>%1$d</strong> کاربر آنلاین :: %2$s و %3$s',
		2	=> 'در مجموع <strong>%1$d</strong> کاربر آنلاین :: %2$s و %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'در مجموع <strong>%1$d</strong> کاربر آنلاین :: %2$s %3$s و %4$s',
		2	=> 'در مجموع <strong>%1$d</strong> کاربر آنلاین :: %2$s %3$s و %4$s',
	),
	'OPTIONS'					=> 'گزینه‌ها',

	'PAGE_NOT_FOUND'		=> 'صفحه درخواستی وجود ندارد',
	'PAGE_OF'				=> 'صفحه <strong>%1$d</strong> از <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'صفحه %s',
	'PASSWORD'				=> 'گذرواژه',
	'PIXEL'					=> 'پیکسل',
	'PIXELS'				=> array(
		1	=> '%d پیکسل',
		2	=> '%d پیکسل',
	),
	'PLEASE_WAIT'			=> 'لطفاً منتظر بمانید.',
	'PM'					=> 'پیام خصوصی',
	'PM_REPORTED'			=> 'برای مشاهده گزارش کلیک کنید',
	'POSTING_MESSAGE'		=> 'ارسال پیام خصوصی به %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'نوشتن پیام خصوصی',
	'POST'					=> 'پست',
	'POST_ANNOUNCEMENT'		=> 'اطلاعیه',
	'POST_STICKY'			=> 'سنجاق شده',
	'POSTED'				=> 'ارسال شده',
	'POSTED_IN_FORUM'		=> 'در',
	'POSTED_ON_DATE'		=> 'تاریخ',
	'POSTS'					=> 'پست',
	'POSTS_UNAPPROVED'		=> 'حداقل یک پست در این موضوع تأیید نشده است.',
	'POSTS_UNAPPROVED_FORUM'	=> 'حداقل یک پست در این انجمن تأیید نشده است.',
	'POST_BY_AUTHOR'		=> 'توسط',
	'POST_BY_FOE'			=> '<strong>%1$s</strong>, در لیست دشمنان شما وجود دارد که پستی ارسال کرده است.',
	'POST_DISPLAY'			=> 'نمایش پست',
	'POST_DAY'				=> '%.2f پست در روز',
	'POST_DELETED_ACTION'	=> 'پست حذف شده:',
	'POST_DELETED'			=> 'این پست با موفقیت حذف شد.',
	'POST_DELETED_BY'		=> '<strong>%2$s</strong> پست حذف شده توسط <strong>%1$s</strong> در تاریخ %3$s.',
	'POST_DELETED_BY_REASON'=> '<strong>%2$s</strong> حذف شده توسط <strong>%1$s</strong> در تاریخ %3$s علت حذف: %4$s',
	'POST_DETAILS'			=> 'جزئیات پست',
	'POST_NEW_TOPIC'		=> 'ارسال موضوع جدید',
	'POST_PCT'				=> '%.2f%% از همه پست‌ها',
	'POST_PCT_ACTIVE'		=> '%.2f%% از پست‌های کاربران',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% از پست‌های شما',
	'POST_REPLY'			=> 'ارسال پاسخ',
	'POST_REPORTED'			=> 'برای مشاهده گزارش کلیک کنید',
	'POST_SUBJECT'			=> 'عنوان پست',
	'POST_TIME'				=> 'تاریخ پست',
	'POST_TOPIC'			=> 'ارسال موضوع جدید',
	'POST_UNAPPROVED'		=> 'این پست با موفقیت تأیید شد.',
	'POST_UNAPPROVED_ACTION'	=> 'پست در انتظار پذیرش است:',
	'POST_UNAPPROVED_EXPLAIN'	=> 'این پست برای کاربران دیگر قابل مشاهده نیست. تا زمانی که مدیران آن را تأیید کنند.',
	'POWERED_BY'			=> 'توسعه یافته توسط %s',
	
	'QUOTE'					=> 'نقل قول',

	'PREVIEW'				=> 'پیش‌نمایش',
	'PREVIOUS'				=> 'قبلی',		// Used in pagination
	'PREVIOUS_STEP'			=> 'قبلی',
	'PRIVACY'				=> 'سیاست حفظ اسرار',
	'PRIVACY_LINK'			=> 'حریم شخصی',
	'PRIVATE_MESSAGE'		=> 'پیام خصوصی',
	'PRIVATE_MESSAGES'		=> 'پیام‌های خصوصی',
	'PRIVATE_MESSAGING'		=> 'در حال  ارسال پیام خصوصی',
	'PROFILE'				=> 'کنترل پنل کاربر',
	'QUICK_LINKS'			=> 'لینک سریع',

	'RANK'						=> 'رتبه',
	'READING_FORUM'				=> 'مشاهده موضوعات در %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'خواندن اطلاعیه سراسری',
	'READING_LINK'				=> 'لینک انجمن %s',
	'READING_TOPIC'				=> 'خواندن موضوع در %s',
	'READ_PROFILE'				=> 'نمایه',
	'REASON'					=> 'دلیل',
	'RECORD_ONLINE_USERS'		=> 'بیشترین تعداد کاربر آنلاین <strong>%1$s</strong> نفر در تاریخ %2$s است',
	'REDIRECT'					=> 'انتقال',
	'REDIRECTS'					=> 'همه انتقالات',
	'REGISTER'					=> 'ثبت نام',
	'REGISTERED_USERS'			=> 'کاربران عضو شده حاضر:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'تعداد %1$d کاربر عضو شده و %2$s نفر آنلاین',
		2	=> 'تعداد %1$d کاربر عضو شده و %2$s نفر آنلاین',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d کاربر عضو شده و',
		2	=> '%d کاربر عضو شده و',
	),
	'REMOVE'					=> 'حذف',
	'REMOVE_INSTALL'			=> 'لطفاً پوشه install را حذف، انتقال و یا تغییر نام دهید. در غیر این صورت فقط کنترل پنل مدیریت  در دسترس خواهد بود.',
	'REPLIES'					=> 'پاسخ‌ها',
	'REPLY_WITH_QUOTE'			=> 'پاسخ با نقل قول',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'پاسخ به اطلاعیه ی سرارسری',
	'REPLYING_MESSAGE'			=> 'پاسخ به پیام در %s',
	'REPORT_BY'					=> 'گزارش شده توسط',
	'REPORT_POST'				=> 'گزارش این پست',
	'REPORTING_POST'			=> 'در حال گزارش پست',
	'RESEND_ACTIVATION'			=> 'ارسال مجدد لینک فعال سازی به ایمیل',
	'RESET'						=> 'بازنشانی',
	'RESTORE_PERMISSIONS'		=> 'بازیابی سطوح دسترسی',
	'RETURN_INDEX'				=> '%sبازگشت به صفحه نخست%s',
	'RETURN_FORUM'				=> '%sبازگشت به آخرین انجمن بازدید شده%s',
	'RETURN_PAGE'				=> '%sبازگشت به صفحه قبل%s',
	'RETURN_TOPIC'				=> '%sبازگشت به آخرین موضوع مشاهده شده%s',
	'RETURN_TO'					=> 'بازگشت به “%s”',
	'RETURN_TO_INDEX'			=> 'بازگشت به صفحه اصلی',
	
	'ROUTE_NOT_FOUND'				=> 'مسیر درخواستی “%s” پیدا نشد.',
	'ROUTE_INVALID_MISSING_PARAMS'	=> 'پارامترهای نامعتبر یاگمشده ای برای “%s” ارسال شده',

	'FEED'						=> 'خوراک',
	'FEED_NEWS'					=> 'اخبار',
	'FEED_TOPICS_ACTIVE'		=> 'موضوعات فعال',
	'FEED_TOPICS_NEW'			=> 'موضوعات جدید',
	'RULES_ATTACH_CAN'			=> 'در این انجمن <strong>می‌توانید</strong> پیوست ارسال کنید',
	'RULES_ATTACH_CANNOT'		=> 'در این انجمن <strong>نمی‌توانید</strong> پیوست ارسال کنید',

	'RULES_DELETE_CAN'			=> 'در این انجمن <strong>می‌توانید</strong> پست‌های خود را حذف کنید',
	'RULES_DELETE_CANNOT'		=> 'در این انجمن <strong>نمی‌توانید</strong> پست‌های خود را حذف کنید',
	'RULES_DOWNLOAD_CAN'		=> 'در این انجمن <strong>می‌توانید</strong> پیوست‌ها را دانلود کنید',
	'RULES_DOWNLOAD_CANNOT'		=> 'در این انجمن <strong>نمی‌توانید</strong> پیوست‌ها را دانلود کنید',
	'RULES_EDIT_CAN'			=> 'در این انجمن <strong>می‌توانید</strong> پست خود را ویرایش کنید',
	'RULES_EDIT_CANNOT'			=> 'در این انجمن <strong>نمی‌توانید</strong> پست خود را ویرایش کنید',
	'RULES_LOCK_CAN'			=> 'در این انجمن <strong>می‌توانید</strong> موضوعات خود را قفل کنید',
	'RULES_LOCK_CANNOT'			=> 'در این انجمن <strong>نمی‌توانید</strong> موضوعات خود را قفل کنید',
	'RULES_POST_CAN'			=> 'در این انجمن <strong>می‌توانید </strong> موضوعات جدیدی ارسال کنید',
	'RULES_POST_CANNOT'			=> 'در این انجمن <strong>نمی‌توانید </strong> موضوعات جدیدی ارسال کنید',
	'RULES_REPLY_CAN'			=> 'در این انجمن <strong>می‌توانید</strong> به موضوعات پاسخ دهید',
	'RULES_REPLY_CANNOT'		=> 'در این انجمن <strong>نمی‌توانید</strong> به موضوعات پاسخ دهید',
	'RULES_VOTE_CAN'			=> 'در این انجمن <strong>می‌توانید</strong> به نظرسنجی ها رای بدهید',
	'RULES_VOTE_CANNOT'			=> 'در این انجمن <strong>نمی‌توانید</strong> به نظرسنجی ها رای بدهید',

	'SEARCH'					=> 'جست‌وجو',
	'SEARCH_MINI'				=> 'جست‌وجو…',
	'SEARCH_ADV'				=> 'جست‌وجوی پیشرفته',
	'SEARCH_ADV_EXPLAIN'		=> 'مشاهده گزینه‌های جست‌وجوی پیشرفته',
	'SEARCH_KEYWORDS'			=> 'جست‌وجوی کلمات کلیدی',
	'SEARCHING_FORUMS'			=> 'جست‌وجوی انجمن',
	'SEARCH_ACTIVE_TOPICS'		=> 'موضوعات فعال',
	'SEARCH_FOR'				=> 'جست‌وجو برای',
	'SEARCH_FORUM'				=> 'جست‌وجوی این انجمن…',
	'SEARCH_NEW'				=> 'پست‌های جدید',
	'SEARCH_POSTS_BY'			=> 'جست‌وجوی پست‌ها بر اساس',
	'SEARCH_SELF'				=> 'پست‌های شما',
	'SEARCH_TOPIC'				=> 'جست‌وجوی این موضوع…',
	'SEARCH_UNANSWERED'			=> 'موضوعات پاسخ داده نشده',
	'SEARCH_UNREAD'				=> 'پست‌های خوانده نشده',
	'SEARCH_USER_POSTS'			=> 'جست‌وجوی پست‌های کاربر',
	'SECONDS'					=> 'ثانیه',
	'SEE_ALL'					=> 'مشاهده همه',
	'SELECT'					=> 'انتخاب',
	'SELECT_ALL_CODE'			=> 'انتخاب همه',
	'SELECT_DESTINATION_FORUM'	=> 'لطفاً انجمن مقصد را انتخاب کنید',
	'SELECT_FORUM'				=> 'انجمنی را انتخاب کنید',
	'SEND_EMAIL'				=> 'ارسال ایمیل',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'ارسال ایمیل به %s',
	'SEND_PRIVATE_MESSAGE'		=> 'ارسال پیام خصوصی',
	'SETTINGS'					=> 'تنظیمات',
	'SIGNATURE'					=> 'امضا',
	'SKIP'						=> 'پرش به محتوا',
	'SKYPE'						=> 'اسکایپ',
	'SMTP_NO_AUTH_SUPPORT'		=> 'سرور SMTP تصدیق و پشتیبانی نمیشود',
	'SORRY_AUTH_READ'			=> 'اجازه خواندن این انجمن را ندارید.',
	'SORRY_AUTH_READ_TOPIC'		=> 'اجازه خواندن این موضوع را ندارید.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'اجازه دانلود این پیوست را ندارید.',
	'SORT_BY'					=> 'مرتب سازی بر اساس',
	'SORT_DIRECTION'			=> 'مستقیم',
	'SORT_JOINED'				=> 'تاریخ عضویت',
	'SORT_LOCATION'				=> 'محل اقامت',
	'SORT_OPTIONS'				=> 'نمایش و دسته‌بندی گزینه‌ها',
	'SORT_RANK'					=> 'رتبه',
	'SORT_POSTS'				=> 'پست‌ها',
	'SORT_TOPIC_TITLE'			=> 'عنوان موضوع',
	'SORT_USERNAME'				=> 'نام کاربری',
	'SPLIT_TOPIC'				=> 'تقسیم موضوع',
	'SQL_ERROR_OCCURRED'		=> 'خطای SQL در هنگام بارگزاری این صفحه بوجود آمده است. اگر این مشکل همچنان ادامه داشت، لطفاً با %sمدیر کل تالار%s تماس بگیرید.',
	'STATISTICS'				=> 'آمار و اطلاعات',
	'START_WATCHING_FORUM'		=> 'عضویت در انجمن',
	'START_WATCHING_TOPIC'		=> 'عضویت در موضوع',
	'STOP_WATCHING_FORUM'		=> 'لغو عضویت در انجمن',
	'STOP_WATCHING_TOPIC'		=> 'لغو عضویت در موضوع',
	'STRING_LIST_MULTI'			=> '%1$s, و %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s و %2$s',
	'SUBFORUM'					=> 'زیرانجمن',
	'SUBFORUMS'					=> 'زیرانجمن‌ها',
	'SUBJECT'					=> 'عنوان',
	'SUBMIT'					=> 'ارسال',

	'TB'				=> 'TB',
	'TERMS_LINK'		=> 'قوانین',
	'TERMS_USE'			=> 'قوانین استفاده',
	'TEST_CONNECTION'	=> 'کنترل ارتباط',
	'THE_TEAM'			=> 'لیست مدیران',
	'TIB'				=> 'TiB',
	'TIME'				=> 'زمان',
	'TIMEOUT_PROCESSING_REQ'			=> 'درخواست خارج از زمان.',

	'TOO_LARGE'						=> 'مقدار وارد شده بسیار زیاد می‌باشد.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'مقدار گزینه <strong>بیشترین تعداد گیرنده در هر پیام خصوصی</strong> بسیار زیاد است',

	'TOO_LONG'						=> 'مقدار وارد شده بسیار طولانی است.',

	'TOO_LONG_CONFIRM_CODE'			=> 'کد تأیید وارد شده بسیار طولانی است.',
	'TOO_LONG_DATEFORMAT'			=> 'فرمت تاریخ وارد شده بسیار طولانی است.',
	'TOO_LONG_JABBER'				=> 'حساب jabber وارد شده بسیار طولانی است.',
	'TOO_LONG_NEW_PASSWORD'			=> 'گذرواژه وارد شده بسیار طولانی است.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'تأیید گذرواژه وارد شده بسیار طولانی است.',
	'TOO_LONG_USER_PASSWORD'		=> 'گذرواژه وارد شده بسیار طولانی است.',
	'TOO_LONG_USERNAME'				=> 'نام کاربری وارد شده بسیار طولانی است.',
	'TOO_LONG_EMAIL'				=> 'آدرس ایمیل وارد شده بسیار طولانی است.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'به گزینه‌های زیادی رای داده اید.',

	'TOO_SHORT'						=> 'مقدار وارد شده بسیار کوتاه می‌باشد.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'کد تأیید وارد شده بسیار کوتاه است.',
	'TOO_SHORT_DATEFORMAT'			=> 'فرمت تاریخ وارد شده بسیار کوتاه است.',
	'TOO_SHORT_JABBER'				=> 'حساب jabber وارد شده بسیار کوتاه است.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'گذرواژه وارد شده بسیار کوتاه است.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'تأیید گذرواژه وارد شده بسیار کوتاه است.',
	'TOO_SHORT_USER_PASSWORD'		=> 'گذرواژه وارد شده بسیار کوتاه است.',
	'TOO_SHORT_USERNAME'			=> 'نام کاربری وارد شده بسیار کوتاه است.',
	'TOO_SHORT_EMAIL'				=> 'آدرس ایمیل وارد شده بسیار کوتاه است.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'تأیید ایمیل آدرس بسیار کوتاه است.',
	'TOO_SMALL'						=> 'مقدار وارد شده بسیار کم است.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'مقدار گزینه <strong>بیشترین تعداد گیرنده در هر پیام خصوصی</strong> بسیار کم است',

	'TOPIC'				=> 'موضوع',
	'TOPICS'			=> 'موضوعات',
	'TOPICS_UNAPPROVED'	=> 'حداقل یک موضوع در این انجمن تأیید نشده است.',
	'TOPIC_ICON'		=> 'آیکون موضوع',
	'TOPIC_LOCKED'		=> 'این موضوع قفل شده است، نمی‌توانید پستی را ویرایش یا پاسخی را ارسال کنید.',
	'TOPIC_LOCKED_SHORT'=> 'موضوع قفل شده است',
	'TOPIC_MOVED'		=> 'موضوع انتقال داده شده',
	'TOPIC_REVIEW'		=> 'پیش‌نمایش موضوع',
	'TOPIC_TITLE'		=> 'عنوان موضوع',
	'TOPIC_UNAPPROVED'	=> 'این موضوع تأیید نشده است.',
	'TOPIC_UNAPPROVED_FORUM'	=> array(
		1	=> 'موضوع در انتظار پذیرش',
		2	=> 'موضوعات در انتظار پذیرش',
	),
	'TOPIC_DELETED'		=> 'این موضوع با موفقیت حذف شد.',
	'TOTAL_ATTACHMENTS'	=> 'پیوست‌ها',
	'TOTAL_LOGS'		=> array(
		1	=> '%d رویداد',
		2	=> '%d رویداد',
	),
	'TOTAL_PMS'		=> array(
		1	=> 'در مجموع %d پیام خصوصی',
		2	=> 'در مجموع %d پیام خصوصی',
	),
	'TOPIC_POLL'		=> 'این موضوع نظر سنجی دارد.',
	'TOTAL_POSTS'		=> 'مجموع پست‌ها',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'مجموع پست‌ها <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'این موضوع گزارش شده است.',
	'TOTAL_TOPICS'		=> array(
		2	=> 'مجموع موضوعات <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		2	=> 'مجموع اعضا <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'	=> 'Tracked PHP errors: %s',
	'TWITTER'			=> 'توئیتر',

	'UNABLE_GET_IMAGE_SIZE'	=> 'تعیین ابعاد تصویر ممکن نیست. لطفاً آدرس صحیحی وارد کنید.',
	'UNABLE_TO_DELIVER_FILE'=> 'قادر به دریافت فایل نیستیم.',
	'UNKNOWN_BROWSER'		=> 'مرورگر ناشناس',
	'UNMARK_ALL'			=> 'برداشتن علامت همه',
	'UNREAD_MESSAGES'		=> 'پیام‌های خوانده نشده',
	'UNREAD_POST'			=> 'پست خوانده نشده',
	'UNREAD_POSTS'			=> 'پست‌های خوانده نشده',
	'UNWATCH_FORUM_CONFIRM'		=> 'آیا از لغو عضویت در این انجمن مطمئنید؟',
	'UNWATCH_FORUM_DETAILED'	=> 'آیا از لغو عضویت در انجمن “%s” مطمئنید؟',
	'UNWATCH_TOPIC_CONFIRM'		=> 'آیا از لغو عضویت در این موضوع مطمئنید؟',
	'UNWATCH_TOPIC_DETAILED'	=> 'آیا از لغو عضویت در موضوع “%s” مطمئنید؟',
	'UNWATCHED_FORUMS'			=> 'در انجمن انتخاب شده عضو نیستید.',
	'UNWATCHED_TOPICS'			=> 'در موضوع انتخاب شده عضو نیستید.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'در نوشته انتخاب شده عضو نیستید.',
	'UPDATE'				=> 'به‌روز رسانی',
	'UPLOAD_IN_PROGRESS'	=> 'بارگذاری در حال انجام است.',
	'URL_REDIRECT'			=> 'اگر مرورگرتان از meta redirection پشتیبانی نمیکند، %sبرای انتقال اینجا کلیک کنید%s.',
	'USERGROUPS'			=> 'گروه‌ها',
	'USERNAME'				=> 'نام کاربری',
	'USERNAMES'				=> 'نام های کاربری',
	'USER_AVATAR'			=> 'آواتار کاربر',
	'USER_CANNOT_READ'		=> 'شما دسترسی خواندن پست‌های این انجمن را ندارید.',
	'USER_POSTS'			=> array(
		1	=> '%d پست',
		2	=> '%d پست',
	),
	'USERS'					=> 'کاربران',
	'USE_PERMISSIONS'		=> 'آزمایش سطوح دسترسی کاربر',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'متاسفیم، اجازه دسترسی به این ویژگی را ندارید، برای بالا بردن سطح دسترسیتان لطفاً بیشتر در تالار فعالیت کنید تا بتوانید از این ویژگی استفاده کنید.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'مشاهده شده',
	'VIEWED_COUNTS'		=> array(
		0	=> 'هنوز مشاهده نشده',
		1	=> 'مشاهده %d مرتبه',
		2	=> 'مشاهده %d مرتبه',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'مشاهده صفحه تماس',
	'VIEWING_FAQ'				=> 'مشاهده راهنما',
	'VIEWING_MEMBERS'			=> 'مشاهده جزئیات کاربر',
	'VIEWING_ONLINE'			=> 'مشاهده کاربران حاضر',
	'VIEWING_MCP'				=> 'مشاهده کنترل پنل مدیران',
	'VIEWING_MEMBER_PROFILE'	=> 'مشاهده نمایه کاربران',
	'VIEWING_PRIVATE_MESSAGES'	=> 'خواندن پیام خصوصی',
	'VIEWING_REGISTER'			=> 'در حال ثبت حساب',
	'VIEWING_UCP'				=> 'مشاهده کنترل پنل کاربری',
	'VIEWS'						=> 'مشاهده',
	'VIEW_BOOKMARKS'			=> 'مشاهده نشانه‌گذاری ها',
	'VIEW_FORUM_LOGS'			=> 'مشاهده رخداد',
	'VIEW_LATEST_POST'			=> 'مشاهده اخرین پست',
	'VIEW_NEWEST_POST'			=> 'مشاهده اولین پست خوانده نشده',
	'VIEW_NOTES'				=> 'مشاهده یادداشت کاربر',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'بر اساس اطلاعات مربوط به %d دقیقه پیش',
		2	=> 'بر اساس اطلاعات مربوط به %d دقیقه پیش',
	),
	'VIEW_TOPIC'				=> 'مشاهده موضوع',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'اطلاعیه: ',
	'VIEW_TOPIC_GLOBAL'			=> 'اطلاعیه سراسری: ',
	'VIEW_TOPIC_LOCKED'			=> 'قفل شده: ',
	'VIEW_TOPIC_LOGS'			=> 'مشاهده رخداد ها',
	'VIEW_TOPIC_MOVED'			=> 'انتقال: ',
	'VIEW_TOPIC_POLL'			=> 'نظر سنجی: ',
	'VIEW_TOPIC_STICKY'			=> 'مهم: ',
	'VISIT_WEBSITE'				=> 'مشاهده وب سایت',

	'WARNINGS'			=> 'اخطارها',
	'WARN_USER'			=> 'اخطار به کاربر',
	
	'WATCH_FORUM_CONFIRM'	=> 'آیا از عضویت در انجمن مطمئنید؟',
	'WATCH_FORUM_DETAILED'	=> 'آیا از عضویت در انجمن “%s” مطمئنید؟',
	'WATCH_TOPIC_CONFIRM'	=> 'آیا از عضویت در این موضوع مطمئنید؟',
	'WATCH_TOPIC_DETAILED'	=> 'آیا از عضویت در موضوع “%s” مطمئنید؟',

	'WELCOME_SUBJECT'	=> 'به انجمن %s خوش آمدید',
	'WEBSITE'			=> 'وب سایت',
	'WHOIS'				=> 'چه کسی؟',
	'WHO_IS_ONLINE'		=> 'چه کسی حاضر است؟',
	'WRONG_PASSWORD'	=> 'گذرواژه نادرستی وارد کردید.',

	'WRONG_DATA_COLOUR'		=> 'مقدار رنگ وارد شده نامعتبر است.',
	'WRONG_DATA_JABBER'		=> 'نام وارد شده حساب Jabber نامعتبر است.',
	'WRONG_DATA_LANG'		=> 'زبان انتخاب شده نامعتبر است.',
	'WRONG_DATA_POST_SD'	=> 'نوع مرتب سازی پست انتخابی نامعتبر است.',
	'WRONG_DATA_POST_SK'	=> 'نوع تنظیمات مرتب سازی پست انتخابی نامعتبر است.',
	'WRONG_DATA_TOPIC_SD'	=> 'نوع مرتب سازی موضوع انتخابی نامعتبر است.',
	'WRONG_DATA_TOPIC_SK'	=> 'نوع تنظیمات مرتب سازی موضوع انتخابی نامعتبر است.',
	'WROTE'					=> 'نوشته شده',

	'YAHOO'				=> 'یاهو مسنجر',
	'YOUTUBE'			=> 'یوتیوب',
	'YEAR'				=> 'سال',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'بله',
	'YOU_LAST_VISIT'	=> 'آخرین بازدید: %s',

	'datetime'			=> array(
		'TODAY'		=> 'امروز',
		'TOMORROW'	=> 'فردا',
		'YESTERDAY'	=> 'دیروز',
		'AGO'		=> array(
			0		=> 'کمتر از یک دقیقه پیش',
			1		=> '%d دقیقه پیش',
			2		=> '%d دقیقه پیش',
		),


		'Sunday'	=> 'یک‌شنبه',
		'Monday'	=> 'دوشنبه',
		'Tuesday'	=> 'سه‌شنبه',
		'Wednesday'	=> 'چهارشنبه',
		'Thursday'	=> 'پنج‌شنبه',
		'Friday'	=> 'جمعه',
		'Saturday'	=> 'شنبه',
		
		'Sun'		=> 'یک‌شنبه',
		'Mon'		=> 'دوشنبه',
		'Tue'		=> 'سه‌شنبه',
		'Wed'		=> 'چهارشنبه',
		'Thu'		=> 'پنج‌شنبه',
		'Fri'		=> 'جمعه',
		'Sat'		=> 'شنبه',

		'January'	=> 'ژانویه',
		'February'	=> 'فوریه',
		'March'		=> 'مارس',
		'April'		=> 'آپریل',
		'May'		=> 'می',
		'June'		=> 'ژوئن',
		'July'		=> 'ژولای',
		'August'	=> 'آگوست',
		'September' => 'سپتامبر',
		'October'	=> 'اکتبر',
		'November'	=> 'نوامبر',
		'December'	=> 'دسامبر',

		'Jan'		=> 'ژانویه',
		'Feb'		=> 'فوریه',
		'Mar'		=> 'مارس',
		'Apr'		=> 'آپریل',
		'May_short'	=> 'می',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'ژوئن',
		'Jul'		=> 'ژولای',
		'Aug'		=> 'آگوست',
		'Sep'		=> 'سپتامبر',
		'Oct'		=> 'اکتبر',
		'Nov'		=> 'نوامبر',
		'Dec'		=> 'دسامبر',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(

		'UTC' 					=> 'UTC',
		'UTC_OFFSET' 			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT' 	=> 'UTC%1$s - %2$s',
		
		'Etc/GMT-12' 	=> 'UTC+12',
		'Etc/GMT-11' 	=> 'UTC+11',
		'Etc/GMT-10' 	=> 'UTC+10',
		'Etc/GMT-9' 	=> 'UTC+9',
		'Etc/GMT-8' 	=> 'UTC+8',
		'Etc/GMT-7' 	=> 'UTC+7',
		'Etc/GMT-6' 	=> 'UTC+6',
		'Etc/GMT-5' 	=> 'UTC+5',
		'Etc/GMT-4'		=> 'UTC+4',
		'Etc/GMT-3' 	=> 'UTC+3',
		'Etc/GMT-2' 	=> 'UTC+2',
		'Etc/GMT-1' 	=> 'UTC+1',
		'Etc/GMT+1' 	=> 'UTC-1',
		'Etc/GMT+2' 	=> 'UTC-2',
		'Etc/GMT+3' 	=> 'UTC-3',
		'Etc/GMT+4' 	=> 'UTC-4',
		'Etc/GMT+5' 	=> 'UTC-5',
		'Etc/GMT+6' 	=> 'UTC-6',
		'Etc/GMT+7' 	=> 'UTC-7',
		'Etc/GMT+8' 	=> 'UTC-8',
		'Etc/GMT+9' 	=> 'UTC-9',
		'Etc/GMT+10' 	=> 'UTC-10',
		'Etc/GMT+11' 	=> 'UTC-11',
		'Etc/GMT+12' 	=> 'UTC-12',

		'Africa/Abidjan'	=> 'Africa/Abidjan',
		'Africa/Accra'		=> 'Africa/Accra',
		'Africa/Addis_Ababa'	=> 'Africa/Addis Ababa',
		'Africa/Algiers'	=> 'Africa/Algiers',
		'Africa/Asmara'		=> 'Africa/Asmara',
		'Africa/Bamako'		=> 'Africa/Bamako',
		'Africa/Bangui'		=> 'Africa/Bangui',
		'Africa/Banjul'		=> 'Africa/Banjul',
		'Africa/Bissau'		=> 'Africa/Bissau',
		'Africa/Blantyre'	=> 'Africa/Blantyre',
		'Africa/Brazzaville'	=> 'Africa/Brazzaville',
		'Africa/Bujumbura'	=> 'Africa/Bujumbura',
		'Africa/Cairo'		=> 'Africa/Cairo',
		'Africa/Casablanca'	=> 'Africa/Casablanca',
		'Africa/Ceuta'		=> 'Africa/Ceuta',
		'Africa/Conakry'	=> 'Africa/Conakry',
		'Africa/Dakar'		=> 'Africa/Dakar',
		'Africa/Dar_es_Salaam'	=> 'Africa/Dar es Salaam',
		'Africa/Djibouti'	=> 'Africa/Djibouti',
		'Africa/Douala'		=> 'Africa/Douala',
		'Africa/El_Aaiun'	=> 'Africa/El Aaiun',
		'Africa/Freetown'	=> 'Africa/Freetown',
		'Africa/Gaborone'	=> 'Africa/Gaborone',
		'Africa/Harare'		=> 'Africa/Harare',
		'Africa/Johannesburg'	=> 'Africa/Johannesburg',
		'Africa/Juba'		=> 'Africa/Juba',
		'Africa/Kampala'	=> 'Africa/Kampala',
		'Africa/Khartoum'	=> 'Africa/Khartoum',
		'Africa/Kigali'		=> 'Africa/Kigali',
		'Africa/Kinshasa'	=> 'Africa/Kinshasa',
		'Africa/Lagos'		=> 'Africa/Lagos',
		'Africa/Libreville'	=> 'Africa/Libreville',
		'Africa/Lome'		=> 'Africa/Lome',
		'Africa/Luanda'		=> 'Africa/Luanda',
		'Africa/Lubumbashi'	=> 'Africa/Lubumbashi',
		'Africa/Lusaka'		=> 'Africa/Lusaka',
		'Africa/Malabo'		=> 'Africa/Malabo',
		'Africa/Maputo'		=> 'Africa/Maputo',
		'Africa/Maseru'		=> 'Africa/Maseru',
		'Africa/Mbabane'	=> 'Africa/Mbabane',
		'Africa/Mogadishu'	=> 'Africa/Mogadishu',
		'Africa/Monrovia'	=> 'Africa/Monrovia',
		'Africa/Nairobi'	=> 'Africa/Nairobi',
		'Africa/Ndjamena'	=> 'Africa/Ndjamena',
		'Africa/Niamey'		=> 'Africa/Niamey',
		'Africa/Nouakchott'	=> 'Africa/Nouakchott',
		'Africa/Ouagadougou'	=> 'Africa/Ouagadougou',
		'Africa/Porto-Novo'	=> 'Africa/Porto-Novo',
		'Africa/Sao_Tome'	=> 'Africa/Sao Tome',
		'Africa/Tripoli'	=> 'Africa/Tripoli',
		'Africa/Tunis'		=> 'Africa/Tunis',
		'Africa/Windhoek'	=> 'Africa/Windhoek',

		'America/Adak'		=> 'America/Adak',
		'America/Anchorage'	=> 'America/Anchorage',
		'America/Anguilla'	=> 'America/Anguilla',
		'America/Antigua'	=> 'America/Antigua',
		'America/Araguaina'	=> 'America/Araguaina',

		'America/Argentina/Buenos_Aires'	=> 'America/Argentina/Buenos Aires',
		'America/Argentina/Catamarca'	=> 'America/Argentina/Catamarca',
		'America/Argentina/Cordoba'		=> 'America/Argentina/Cordoba',
		'America/Argentina/Jujuy'		=> 'America/Argentina/Jujuy',
		'America/Argentina/La_Rioja'	=> 'America/Argentina/La Rioja',
		'America/Argentina/Mendoza'		=> 'America/Argentina/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'America/Argentina/Rio Gallegos',
		'America/Argentina/Salta'		=> 'America/Argentina/Salta',
		'America/Argentina/San_Juan'	=> 'America/Argentina/San Juan',
		'America/Argentina/San_Luis'	=> 'America/Argentina/San Luis',
		'America/Argentina/Tucuman'		=> 'America/Argentina/Tucuman',
		'America/Argentina/Ushuaia'		=> 'America/Argentina/Ushuaia',

		'America/Aruba'			=> 'America/Aruba',
		'America/Asuncion'		=> 'America/Asuncion',
		'America/Atikokan'		=> 'America/Atikokan',
		'America/Bahia'			=> 'America/Bahia',
		'America/Bahia_Banderas'	=> 'America/Bahia Banderas',
		'America/Barbados'		=> 'America/Barbados',
		'America/Belem'			=> 'America/Belem',
		'America/Belize'		=> 'America/Belize',
		'America/Blanc-Sablon'	=> 'America/Blanc-Sablon',
		'America/Boa_Vista'		=> 'America/Boa Vista',
		'America/Bogota'		=> 'America/Bogota',
		'America/Boise'			=> 'America/Boise',
		'America/Cambridge_Bay'	=> 'America/Cambridge Bay',
		'America/Campo_Grande'	=> 'America/Campo Grande',
		'America/Cancun'		=> 'America/Cancun',
		'America/Caracas'		=> 'America/Caracas',
		'America/Cayenne'		=> 'America/Cayenne',
		'America/Cayman'		=> 'America/Cayman',
		'America/Chicago'		=> 'America/Chicago',
		'America/Chihuahua'		=> 'America/Chihuahua',
		'America/Costa_Rica'	=> 'America/Costa Rica',
		'America/Creston'		=> 'America/Creston',
		'America/Cuiaba'		=> 'America/Cuiaba',
		'America/Curacao'		=> 'America/Curacao',
		'America/Danmarkshavn'	=> 'America/Danmarkshavn',
		'America/Dawson'		=> 'America/Dawson',
		'America/Dawson_Creek'	=> 'America/Dawson Creek',
		'America/Denver'		=> 'America/Denver',
		'America/Detroit'		=> 'America/Detroit',
		'America/Dominica'		=> 'America/Dominica',
		'America/Edmonton'		=> 'America/Edmonton',
		'America/Eirunepe'		=> 'America/Eirunepe',
		'America/El_Salvador'	=> 'America/El Salvador',
		'America/Fortaleza'		=> 'America/Fortaleza',
		'America/Glace_Bay'		=> 'America/Glace Bay',
		'America/Godthab'		=> 'America/Godthab',
		'America/Goose_Bay'		=> 'America/Goose Bay',
		'America/Grand_Turk'	=> 'America/Grand Turk',
		'America/Grenada'		=> 'America/Grenada',
		'America/Guadeloupe'	=> 'America/Guadeloupe',
		'America/Guatemala'		=> 'America/Guatemala',
		'America/Guayaquil'		=> 'America/Guayaquil',
		'America/Guyana'		=> 'America/Guyana',
		'America/Halifax'		=> 'America/Halifax',
		'America/Havana'		=> 'America/Havana',
		'America/Hermosillo'		=> 'America/Hermosillo',
		'America/Indiana/Indianapolis'	=> 'America/Indiana/Indianapolis',
		'America/Indiana/Knox'		=> 'America/Indiana/Knox',
		'America/Indiana/Marengo'	=> 'America/Indiana/Marengo',
		'America/Indiana/Petersburg'	=> 'America/Indiana/Petersburg',
		'America/Indiana/Tell_City'	=> 'America/Indiana/Tell City',
		'America/Indiana/Vevay'		=> 'America/Indiana/Vevay',
		'America/Indiana/Vincennes'	=> 'America/Indiana/Vincennes',
		'America/Indiana/Winamac'	=> 'America/Indiana/Winamac',
		'America/Inuvik'		=> 'America/Inuvik',
		'America/Iqaluit'		=> 'America/Iqaluit',
		'America/Jamaica'		=> 'America/Jamaica',
		'America/Juneau'		=> 'America/Juneau',
		'America/Kentucky/Louisville'	=> 'America/Kentucky/Louisville',
		'America/Kentucky/Monticello'	=> 'America/Kentucky/Monticello',
		'America/Kralendijk'	=> 'America/Kralendijk',
		'America/La_Paz'		=> 'America/La Paz',
		'America/Lima'			=> 'America/Lima',
		'America/Los_Angeles'	=> 'America/Los Angeles',
		'America/Lower_Princes'	=> 'America/Lower Princes',
		'America/Maceio'		=> 'America/Maceio',
		'America/Managua'		=> 'America/Managua',
		'America/Manaus'		=> 'America/Manaus',
		'America/Marigot'		=> 'America/Marigot',
		'America/Martinique'	=> 'America/Martinique',
		'America/Matamoros'		=> 'America/Matamoros',
		'America/Mazatlan'		=> 'America/Mazatlan',
		'America/Menominee'		=> 'America/Menominee',
		'America/Merida'		=> 'America/Merida',
		'America/Metlakatla'	=> 'America/Metlakatla',
		'America/Mexico_City'	=> 'America/Mexico City',
		'America/Miquelon'		=> 'America/Miquelon',
		'America/Moncton'		=> 'America/Moncton',
		'America/Monterrey'		=> 'America/Monterrey',
		'America/Montevideo'	=> 'America/Montevideo',
		'America/Montreal'		=> 'America/Montreal',
		'America/Montserrat'	=> 'America/Montserrat',
		'America/Nassau'		=> 'America/Nassau',
		'America/New_York'		=> 'America/New York',
		'America/Nipigon'		=> 'America/Nipigon',
		'America/Nome'			=> 'America/Nome',
		'America/Noronha'		=> 'America/Noronha',
		'America/North_Dakota/Beulah'		=> 'America/North Dakota/Beulah',
		'America/North_Dakota/Center'		=> 'America/North Dakota/Center',
		'America/North_Dakota/New_Salem'	=> 'America/North Dakota/New Salem',
		'America/Ojinaga'		=> 'America/Ojinaga',
		'America/Panama'		=> 'America/Panama',
		'America/Pangnirtung'	=> 'America/Pangnirtung',
		'America/Paramaribo'	=> 'America/Paramaribo',
		'America/Phoenix'		=> 'America/Phoenix',
		'America/Port-au-Prince'	=> 'America/Port-au-Prince',
		'America/Port_of_Spain'	=> 'America/Port of Spain',
		'America/Porto_Velho'	=> 'America/Porto Velho',
		'America/Puerto_Rico'	=> 'America/Puerto Rico',
		'America/Rainy_River'	=> 'America/Rainy River',
		'America/Rankin_Inlet'	=> 'America/Rankin Inlet',
		'America/Recife'		=> 'America/Recife',
		'America/Regina'		=> 'America/Regina',
		'America/Resolute'		=> 'America/Resolute',
		'America/Rio_Branco'	=> 'America/Rio Branco',
		'America/Santa_Isabel'	=> 'America/Santa Isabel',
		'America/Santarem'		=> 'America/Santarem',
		'America/Santiago'		=> 'America/Santiago',
		'America/Santo_Domingo'	=> 'America/Santo Domingo',
		'America/Sao_Paulo'		=> 'America/Sao Paulo',
		'America/Scoresbysund'	=> 'America/Scoresbysund',
		'America/Shiprock'		=> 'America/Shiprock',
		'America/Sitka'			=> 'America/Sitka',
		'America/St_Barthelemy'	=> 'America/St. Barthelemy',
		'America/St_Johns'		=> 'America/St. Johns',
		'America/St_Kitts'		=> 'America/St. Kitts',
		'America/St_Lucia'		=> 'America/St. Lucia',
		'America/St_Thomas'		=> 'America/St. Thomas',
		'America/St_Vincent'	=> 'America/St. Vincent',
		'America/Swift_Current'	=> 'America/Swift Current',
		'America/Tegucigalpa'	=> 'America/Tegucigalpa',
		'America/Thule'			=> 'America/Thule',
		'America/Thunder_Bay'	=> 'America/Thunder Bay',
		'America/Tijuana'		=> 'America/Tijuana',
		'America/Toronto'		=> 'America/Toronto',
		'America/Tortola'		=> 'America/Tortola',
		'America/Vancouver'		=> 'America/Vancouver',
		'America/Whitehorse'	=> 'America/Whitehorse',
		'America/Winnipeg'		=> 'America/Winnipeg',
		'America/Yakutat'		=> 'America/Yakutat',
		'America/Yellowknife'	=> 'America/Yellowknife',

		'Antarctica/Casey'		=> 'Antarctica/Casey',
		'Antarctica/Davis'		=> 'Antarctica/Davis',
		'Antarctica/DumontDUrville'	=> 'Antarctica/DumontDUrville',
		'Antarctica/Macquarie'	=> 'Antarctica/Macquarie',
		'Antarctica/Mawson'		=> 'Antarctica/Mawson',
		'Antarctica/McMurdo'	=> 'Antarctica/McMurdo',
		'Antarctica/Palmer'		=> 'Antarctica/Palmer',
		'Antarctica/Rothera'	=> 'Antarctica/Rothera',
		'Antarctica/South_Pole'	=> 'Antarctica/South Pole',
		'Antarctica/Syowa'		=> 'Antarctica/Syowa',
		'Antarctica/Vostok'		=> 'Antarctica/Vostok',

		'Arctic/Longyearbyen'	=> 'Arctic/Longyearbyen',

		'Asia/Aden'			=> 'Asia/Aden',
		'Asia/Almaty'		=> 'Asia/Almaty',
		'Asia/Amman'		=> 'Asia/Amman',
		'Asia/Anadyr'		=> 'Asia/Anadyr',
		'Asia/Aqtau'		=> 'Asia/Aqtau',
		'Asia/Aqtobe'		=> 'Asia/Aqtobe',
		'Asia/Ashgabat'		=> 'Asia/Ashgabat',
		'Asia/Baghdad'		=> 'Asia/Baghdad',
		'Asia/Bahrain'		=> 'Asia/Bahrain',
		'Asia/Baku'			=> 'Asia/Baku',
		'Asia/Bangkok'		=> 'Asia/Bangkok',
		'Asia/Beirut'		=> 'Asia/Beirut',
		'Asia/Bishkek'		=> 'Asia/Bishkek',
		'Asia/Brunei'		=> 'Asia/Brunei',
		'Asia/Choibalsan'	=> 'Asia/Choibalsan',
		'Asia/Chongqing'	=> 'Asia/Chongqing',
		'Asia/Colombo'		=> 'Asia/Colombo',
		'Asia/Damascus'		=> 'Asia/Damascus',
		'Asia/Dhaka'		=> 'Asia/Dhaka',
		'Asia/Dili'			=> 'Asia/Dili',
		'Asia/Dubai'		=> 'Asia/Dubai',
		'Asia/Dushanbe'		=> 'Asia/Dushanbe',
		'Asia/Gaza'			=> 'Asia/Gaza',
		'Asia/Harbin'		=> 'Asia/Harbin',
		'Asia/Hebron'		=> 'Asia/Hebron',
		'Asia/Ho_Chi_Minh'	=> 'Asia/Ho Chi Minh',
		'Asia/Hong_Kong'	=> 'Asia/Hong Kong',
		'Asia/Hovd'			=> 'Asia/Hovd',
		'Asia/Irkutsk'		=> 'Asia/Irkutsk',
		'Asia/Jakarta'		=> 'Asia/Jakarta',
		'Asia/Jayapura'		=> 'Asia/Jayapura',
		'Asia/Jerusalem'	=> 'Asia/Jerusalem',
		'Asia/Kabul'		=> 'آسیا/کابل',
		'Asia/Kamchatka'	=> 'Asia/Kamchatka',
		'Asia/Karachi'		=> 'Asia/Karachi',
		'Asia/Kashgar'		=> 'Asia/Kashgar',
		'Asia/Kathmandu'	=> 'Asia/Kathmandu',
		'Asia/Khandyga'		=> 'Asia/Khandyga',
		'Asia/Kolkata'		=> 'Asia/Kolkata',
		'Asia/Krasnoyarsk'	=> 'Asia/Krasnoyarsk',
		'Asia/Kuala_Lumpur'	=> 'Asia/Kuala Lumpur',
		'Asia/Kuching'		=> 'Asia/Kuching',
		'Asia/Kuwait'		=> 'Asia/Kuwait',
		'Asia/Macau'		=> 'Asia/Macau',
		'Asia/Magadan'		=> 'Asia/Magadan',
		'Asia/Makassar'		=> 'Asia/Makassar',
		'Asia/Manila'		=> 'Asia/Manila',
		'Asia/Muscat'		=> 'Asia/Muscat',
		'Asia/Nicosia'		=> 'Asia/Nicosia',
		'Asia/Novokuznetsk'	=> 'Asia/Novokuznetsk',
		'Asia/Novosibirsk'	=> 'Asia/Novosibirsk',
		'Asia/Omsk'			=> 'Asia/Omsk',
		'Asia/Oral'			=> 'Asia/Oral',
		'Asia/Phnom_Penh'	=> 'Asia/Phnom Penh',
		'Asia/Pontianak'	=> 'Asia/Pontianak',
		'Asia/Pyongyang'	=> 'Asia/Pyongyang',
		'Asia/Qatar'		=> 'Asia/Qatar',
		'Asia/Qyzylorda'	=> 'Asia/Qyzylorda',
		'Asia/Rangoon'		=> 'Asia/Rangoon',
		'Asia/Riyadh'		=> 'Asia/Riyadh',
		'Asia/Sakhalin'		=> 'Asia/Sakhalin',
		'Asia/Samarkand'	=> 'Asia/Samarkand',
		'Asia/Seoul'		=> 'Asia/Seoul',
		'Asia/Shanghai'		=> 'Asia/Shanghai',
		'Asia/Singapore'	=> 'Asia/Singapore',
		'Asia/Taipei'		=> 'Asia/Taipei',
		'Asia/Tashkent'		=> 'Asia/Tashkent',
		'Asia/Tbilisi'		=> 'Asia/Tbilisi',
		'Asia/Tehran'		=> 'آسیا/تهران',
		'Asia/Thimphu'		=> 'Asia/Thimphu',
		'Asia/Tokyo'		=> 'Asia/Tokyo',
		'Asia/Ulaanbaatar'	=> 'Asia/Ulaanbaatar',
		'Asia/Urumqi'		=> 'Asia/Urumqi',
		'Asia/Ust-Nera'		=> 'Asia/Ust-Nera',
		'Asia/Vientiane'	=> 'Asia/Vientiane',
		'Asia/Vladivostok'	=> 'Asia/Vladivostok',
		'Asia/Yakutsk'		=> 'Asia/Yakutsk',
		'Asia/Yekaterinburg'	=> 'Asia/Yekaterinburg',
		'Asia/Yerevan'		=> 'Asia/Yerevan',

		'Atlantic/Azores'		=> 'Atlantic/Azores',
		'Atlantic/Bermuda'		=> 'Atlantic/Bermuda',
		'Atlantic/Canary'		=> 'Atlantic/Canary',
		'Atlantic/Cape_Verde'	=> 'Atlantic/Cape Verde',
		'Atlantic/Faroe'		=> 'Atlantic/Faroe',
		'Atlantic/Madeira'		=> 'Atlantic/Madeira',
		'Atlantic/Reykjavik'	=> 'Atlantic/Reykjavik',
		'Atlantic/South_Georgia'	=> 'Atlantic/South Georgia',
		'Atlantic/St_Helena'	=> 'Atlantic/St. Helena',
		'Atlantic/Stanley'		=> 'Atlantic/Stanley',

		'Australia/Adelaide'	=> 'Australia/Adelaide',
		'Australia/Brisbane'	=> 'Australia/Brisbane',
		'Australia/Broken_Hill'	=> 'Australia/Broken Hill',
		'Australia/Currie'		=> 'Australia/Currie',
		'Australia/Darwin'		=> 'Australia/Darwin',
		'Australia/Eucla'		=> 'Australia/Eucla',
		'Australia/Hobart'		=> 'Australia/Hobart',
		'Australia/Lindeman'	=> 'Australia/Lindeman',
		'Australia/Lord_Howe'	=> 'Australia/Lord Howe',
		'Australia/Melbourne'	=> 'Australia/Melbourne',
		'Australia/Perth'		=> 'Australia/Perth',
		'Australia/Sydney'		=> 'Australia/Sydney',

		'Europe/Amsterdam'	=> 'Europe/Amsterdam',
		'Europe/Andorra'	=> 'Europe/Andorra',
		'Europe/Athens'		=> 'Europe/Athens',
		'Europe/Belgrade'	=> 'Europe/Belgrade',
		'Europe/Berlin'		=> 'Europe/Berlin',
		'Europe/Bratislava'	=> 'Europe/Bratislava',
		'Europe/Brussels'	=> 'Europe/Brussels',
		'Europe/Bucharest'	=> 'Europe/Bucharest',
		'Europe/Budapest'	=> 'Europe/Budapest',
		'Europe/Busingen'	=> 'Europe/Busingen',
		'Europe/Chisinau'	=> 'Europe/Chisinau',
		'Europe/Copenhagen'	=> 'Europe/Copenhagen',
		'Europe/Dublin'		=> 'Europe/Dublin',
		'Europe/Gibraltar'	=> 'Europe/Gibraltar',
		'Europe/Guernsey'	=> 'Europe/Guernsey',
		'Europe/Helsinki'	=> 'Europe/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europe/Isle of Man',
		'Europe/Istanbul'	=> 'Europe/Istanbul',
		'Europe/Jersey'		=> 'Europe/Jersey',
		'Europe/Kaliningrad'	=> 'Europe/Kaliningrad',
		'Europe/Kiev'		=> 'Europe/Kiev',
		'Europe/Lisbon'		=> 'Europe/Lisbon',
		'Europe/Ljubljana'	=> 'Europe/Ljubljana',
		'Europe/London'		=> 'Europe/London',
		'Europe/Luxembourg'	=> 'Europe/Luxembourg',
		'Europe/Madrid'		=> 'Europe/Madrid',
		'Europe/Malta'		=> 'Europe/Malta',
		'Europe/Mariehamn'	=> 'Europe/Mariehamn',
		'Europe/Minsk'		=> 'Europe/Minsk',
		'Europe/Monaco'		=> 'Europe/Monaco',
		'Europe/Moscow'		=> 'Europe/Moscow',
		'Europe/Oslo'		=> 'Europe/Oslo',
		'Europe/Paris'		=> 'Europe/Paris',
		'Europe/Podgorica'	=> 'Europe/Podgorica',
		'Europe/Prague'		=> 'Europe/Prague',
		'Europe/Riga'		=> 'Europe/Riga',
		'Europe/Rome'		=> 'Europe/Rome',
		'Europe/Samara'		=> 'Europe/Samara',
		'Europe/San_Marino'	=> 'Europe/San Marino',
		'Europe/Sarajevo'	=> 'Europe/Sarajevo',
		'Europe/Simferopol'	=> 'Europe/Simferopol',
		'Europe/Skopje'		=> 'Europe/Skopje',
		'Europe/Sofia'		=> 'Europe/Sofia',
		'Europe/Stockholm'	=> 'Europe/Stockholm',
		'Europe/Tallinn'	=> 'Europe/Tallinn',
		'Europe/Tirane'		=> 'Europe/Tirane',
		'Europe/Uzhgorod'	=> 'Europe/Uzhgorod',
		'Europe/Vaduz'		=> 'Europe/Vaduz',
		'Europe/Vatican'	=> 'Europe/Vatican',
		'Europe/Vienna'		=> 'Europe/Vienna',
		'Europe/Vilnius'	=> 'Europe/Vilnius',
		'Europe/Volgograd'	=> 'Europe/Volgograd',
		'Europe/Warsaw'		=> 'Europe/Warsaw',
		'Europe/Zagreb'		=> 'Europe/Zagreb',
		'Europe/Zaporozhye'	=> 'Europe/Zaporozhye',
		'Europe/Zurich'		=> 'Europe/Zurich',

		'Indian/Antananarivo'	=> 'Indian/Antananarivo',
		'Indian/Chagos'		=> 'Indian/Chagos',
		'Indian/Christmas'	=> 'Indian/Christmas',
		'Indian/Cocos'		=> 'Indian/Cocos',
		'Indian/Comoro'		=> 'Indian/Comoro',
		'Indian/Kerguelen'	=> 'Indian/Kerguelen',
		'Indian/Mahe'		=> 'Indian/Mahe',
		'Indian/Maldives'	=> 'Indian/Maldives',
		'Indian/Mauritius'	=> 'Indian/Mauritius',
		'Indian/Mayotte'	=> 'Indian/Mayotte',
		'Indian/Reunion'	=> 'Indian/Reunion',

		'Pacific/Apia'		=> 'Pacific/Apia',
		'Pacific/Auckland'	=> 'Pacific/Auckland',
		'Pacific/Chatham'	=> 'Pacific/Chatham',
		'Pacific/Chuuk'		=> 'Pacific/Chuuk',
		'Pacific/Easter'	=> 'Pacific/Easter',
		'Pacific/Efate'		=> 'Pacific/Efate',
		'Pacific/Enderbury'	=> 'Pacific/Enderbury',
		'Pacific/Fakaofo'	=> 'Pacific/Fakaofo',
		'Pacific/Fiji'		=> 'Pacific/Fiji',
		'Pacific/Funafuti'	=> 'Pacific/Funafuti',
		'Pacific/Galapagos'	=> 'Pacific/Galapagos',
		'Pacific/Gambier'	=> 'Pacific/Gambier',
		'Pacific/Guadalcanal'	=> 'Pacific/Guadalcanal',
		'Pacific/Guam'		=> 'Pacific/Guam',
		'Pacific/Honolulu'	=> 'Pacific/Honolulu',
		'Pacific/Johnston'	=> 'Pacific/Johnston',
		'Pacific/Kiritimati'	=> 'Pacific/Kiritimati',
		'Pacific/Kosrae'	=> 'Pacific/Kosrae',
		'Pacific/Kwajalein'	=> 'Pacific/Kwajalein',
		'Pacific/Majuro'	=> 'Pacific/Majuro',
		'Pacific/Marquesas'	=> 'Pacific/Marquesas',
		'Pacific/Midway'	=> 'Pacific/Midway',
		'Pacific/Nauru'		=> 'Pacific/Nauru',
		'Pacific/Niue'		=> 'Pacific/Niue',
		'Pacific/Norfolk'	=> 'Pacific/Norfolk',
		'Pacific/Noumea'	=> 'Pacific/Noumea',
		'Pacific/Pago_Pago'	=> 'Pacific/Pago Pago',
		'Pacific/Palau'		=> 'Pacific/Palau',
		'Pacific/Pitcairn'	=> 'Pacific/Pitcairn',
		'Pacific/Pohnpei'	=> 'Pacific/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Pacific/Port Moresby',
		'Pacific/Rarotonga'	=> 'Pacific/Rarotonga',
		'Pacific/Saipan'	=> 'Pacific/Saipan',
		'Pacific/Tahiti'	=> 'Pacific/Tahiti',
		'Pacific/Tarawa'	=> 'Pacific/Tarawa',
		'Pacific/Tongatapu'	=> 'Pacific/Tongatapu',
		'Pacific/Wake'		=> 'Pacific/Wake',
		'Pacific/Wallis'	=> 'Pacific/Wallis',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Mon Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'January 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'امروز, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'امروز, 1:37 pm / January 1st, 2007, 1:37 pm',
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));
