<?php
/**
*
* This file is part of the phpBB Forum Software package.
*
* @copyright (c) phpBB Limited <https://www.phpbb.com>
* @license GNU General Public License, version 2 (GPL-2.0)
*
* For full copyright and license information, please see
* the docs/CREDITS.txt file.
*
* Ελληνική μετάφραση από την ομάδα του phpbbgr.com
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '<br>Ελληνική μετάφραση από το <a href="http://phpbbgr.com/">phpbbgr.com</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Ιαν 2007 (με τα σχετικά στοιχεία)
	'DATETIME_FORMAT'	=> '|d M Y, H:i|',	// 01 Jan 2007, 13:37 (σχετική με την ημέρα ενεργοποιημένη)
	'USER_LANG'			=> 'el',

	// You can define different rules for the determination of plural forms here.
	// See https://area51.phpbb.com/docs/dev/3.3.x/language/plurals.html for more information
	// or ask the translation manager for help.
	'PLURAL_RULE'		=> 1,

	'1_DAY'			=> '1 ημέρα',
	'1_MONTH'		=> '1 μήνα',
	'1_YEAR'		=> '1 χρόνο',
	'2_WEEKS'		=> '2 εβδομάδες',
	'3_MONTHS'		=> '3 μήνες',
	'6_MONTHS'		=> '6 μήνες',
	'7_DAYS'		=> '7 ημέρες',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Ο λογαριασμός σας έχει ήδη ενεργοποιηθεί.',
	'ACCOUNT_DEACTIVATED'			=> 'Ο λογαριασμός σας έχει απενεργοποιηθεί χειροκίνητα και μπορεί να επανενεργοποιηθεί μόνον από έναν διαχειριστή.',
	'ACP'							=> 'Πίνακας Ελέγχου Διαχειριστή',
	'ACP_SHORT'						=> 'ΠΕΔ',
	'ACTIVATION_ALREADY_SENT'		=> 'Το μήνυμα ενεργοποίησης έχει ήδη αποσταλεί στην ηλεκτρονική σας διεύθυνση. Μπορείτε να προσπαθήσετε ξανά, μετά από 24 ώρες. Αν συνεχίζετε να αντιμετωπίζετε προβλήματα στην ενεργοποίηση του λογαριασμού σας, παρακαλούμε επικοινωνήστε με το διαχειριστή.',
	'ACTIVE'						=> 'ενεργό',
	'ACTIVE_ERROR'					=> 'Το συγκεκριμένο όνομα μέλους είναι προς το παρόν ανενεργό. Εάν αντιμετωπίζετε προβλήματα με την ενεργοποίηση του λογαριασμού σας, παρακαλώ επικοινωνήστε με κάποιον διαχειριστή του συστήματος συζητήσεων.',
	'ADMINISTRATOR'					=> 'Διαχειριστής',
	'ADMINISTRATORS'				=> 'Διαχειριστές',
	'AGE'							=> 'Ηλικία',
	'AIM'							=> 'AIM',
	'AJAX_ERROR_TITLE'				=> 'Σφάλμα AJAX',
	'AJAX_ERROR_TEXT'				=> 'Κάτι πήγε στραβά κατά την επεξεργασία του αιτήματός σας.',
	'AJAX_ERROR_TEXT_ABORT'			=> 'Το αίτημα ακυρώθηκε από μέλος.',
	'AJAX_ERROR_TEXT_TIMEOUT'		=> 'Εξαντλήθηκε το χρονικό όριο του αιτήματός σας. Παρακαλώ προσπαθήστε εκ νέου.',
	'AJAX_ERROR_TEXT_PARSERERROR'	=> 'Κάτι πήγε στραβά με το αίτημα και ο διακομιστής επέστρεψε μια άκυρη απάντηση.',
	'ALLOWED'						=> 'Επιτρέπεται',
	'ALL_FILES'						=> 'Όλα τα αρχεία',
	'ALL_FORUMS'					=> 'Όλες τις Δ. Συζητήσεις',
	'ALL_MESSAGES'					=> 'Όλα τα μηνύματα',
	'ALL_POSTS'						=> 'Όλες τις δημοσιεύσεις',
	'ALL_TIMES'						=> 'Όλοι οι χρόνοι είναι <span title="%2$s">%1$s</span>',
	'ALL_TOPICS'					=> 'Όλα τα θέματα',
	'ALT_TEXT'						=> 'Εναλλακτικό κείμενο',
	'AND'							=> 'Και',
	'ARE_WATCHING_FORUM'			=> 'Έχετε επιλέξει να ενημερώνεστε για νέες δημοσιεύσεις σε αυτή τη Δ. Συζήτηση.',
	'ARE_WATCHING_TOPIC'			=> 'Έχετε επιλέξει να ενημερώνεστε για νέες δημοσιεύσεις σε αυτό το θέμα.',
	'ASCENDING'						=> 'Αύξουσα',
	'ATTACHMENTS'					=> 'Συνημμένα',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Το αρχείο εικόνας που προσπαθήσατε να επισυνάψετε είναι άκυρο.',
	'AUTHOR'						=> 'Συγγραφέας',
	'AUTH_NO_PROFILE_CREATED'		=> 'Η δημιουργία του προφίλ μέλους ήταν ανεπιτυχής.',
	'AUTH_PROVIDER_OAUTH_ERROR_ALREADY_LINKED'				=> 'Αυτή η υπηρεσία είναι ήδη συσχετισμένη με άλλο λογαριασμό στο σύστημα.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_ENTRY'				=> 'Άκυρη καταχώρηση στη βάση δεδομένων.',
	'AUTH_PROVIDER_OAUTH_ERROR_INVALID_SERVICE_TYPE'		=> 'Άκυρος τύπος υπηρεσίας που παρέχεται στο χειριστή υπηρεσίας OAuth.',
	'AUTH_PROVIDER_OAUTH_ERROR_REQUEST'						=> 'Κάτι πήγε στραβά κατα την επεξεργασία του αιτήματός OAuth σας.',
	'AUTH_PROVIDER_OAUTH_RETURN_ERROR'						=> 'Η εξωτερική υπηρεσία επέστρεψε μια λανθασμένη τιμή, ως εκ τούτου το αίτημά σας δε μπορεί να προχωρήσει.',
	'AUTH_PROVIDER_OAUTH_ERROR_SERVICE_NOT_CREATED'			=> 'Η υπηρεσία OAuth δεν δημιουργήθηκε',
	'AUTH_PROVIDER_OAUTH_SERVICE_BITLY'						=> 'Bitly',
	'AUTH_PROVIDER_OAUTH_SERVICE_FACEBOOK'					=> 'Facebook',
	'AUTH_PROVIDER_OAUTH_SERVICE_GOOGLE'					=> 'Google',
	'AUTH_PROVIDER_OAUTH_SERVICE_TWITTER'					=> 'Twitter',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_NOT_STORED'			=> 'Το διακριτικό OAuth δεν αποθηκεύτηκε.',
	'AUTH_PROVIDER_OAUTH_TOKEN_ERROR_INCORRECTLY_STORED'	=> 'Το διακριτικό OAuth αποθηκεύτηκε εσφαλμένα.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Η φόρτωση απορρίφθηκε επειδή το αρχείο προς φόρτωση προσδιορίστηκε ως πιθανό διάνυσμα επίθεσης.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Αυτό το αρχείο δεν μπορεί να εμφανιστεί επειδή η επέκταση <strong>%s</strong> δεν επιτρέπεται.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Το συγκεκριμένο άβαταρ δεν μπορεί να φορτωθεί επειδή το απομακρυσμένο στοιχείο φαίνεται να είναι άκυρο ή αλλοιωμένο.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Το φορτωμένο αρχείο άβαταρ είναι κενό.',
	'AVATAR_INVALID_FILENAME'		=> 'Το %s είναι ένα άκυρο όνομα αρχείου.',
	'AVATAR_NOT_UPLOADED'			=> 'Το άβαταρ δεν μπορεί να φορτωθεί.',
	'AVATAR_NO_TEMP_DIR'			=> 'Ο προσωρινός φάκελος δεν μπορεί να βρεθεί ή δεν είναι εγγράψιμος.',
	'AVATAR_NO_SIZE'				=> 'Το πλάτος ή το ύψος του άβαταρ δεν μπορεί να καθοριστεί. Παρακαλώ εισάγετέ το χειροκἰνητα.',
	'AVATAR_NO_UPLOAD_DIR'			=> 'Το μονοπάτι αποθήκευσης άβαταρ δεν υπάρχει ή δεν είναι εγγράψιμο.',
	'AVATAR_NO_UPLOAD_PATH'			=> 'Η μεταφόρτωση άβαταρ είναι ενεργοποιημένη, αλλά το μονοπάτι αποθήκευσης άβαταρ δεν έχει ρυθμιστεί.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Το συγκεκριμένο αρχείο φορτώθηκε μόνο εν μέρει.',
	'AVATAR_PHP_SIZE_NA'			=> 'Το μέγεθος αρχείου άβαταρ είναι πολύ μεγάλο.<br />Το μέγιστο επιτρεπτό μέγεθος στο php.ini δεν μπορεί να προσδιοριστεί.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Το μέγεθος του αρχείου άβαταρ είναι πάρα πολύ μεγάλο. Το μέγιστο επιτρεπτό μέγεθος αρχείου φόρτωσης είναι %1$d %2$s.<br />Παρακαλώ σημειώστε ότι αυτό έχει ρυθμιστεί στο php.ini και δεν μπορεί να παρακαμφθεί',
	'AVATAR_REMOTE_UPLOAD_TIMEOUT'	=> 'Το καθορισμένο άβαταρ δεν ήταν δυνατόν να φορτωθεί επειδή εξαντλήθηκε το χρονικό όριο του αιτήματος.',
	'AVATAR_PHP_UPLOAD_STOPPED'		=> 'Μια επέκταση PHP διέκοψε το ανέβασμα του αρχείου.',
	'AVATAR_URL_INVALID'			=> 'Η διεύθυνση συνδέσμου (URL) που καθορίσατε είναι άκυρη.',
	'AVATAR_URL_NOT_FOUND'			=> 'Το συγκεκριμένο αρχείο δεν μπορεί να βρεθεί.',
	'AVATAR_WRONG_FILESIZE'			=> 'Το μέγεθος του αρχείου άβαταρ πρέπει να κυμαίνεται μεταξύ 0 και %1$d %2$s.',
	'AVATAR_WRONG_SIZE'				=> 'Το συγκεκριμένο άβαταρ είναι %5$s πλάτος και %6$s ύψος. Τα άβαταρ πρέπει να είναι τουλάχιστον %1$s πλάτος και %2$s ύψος, αλλά όχι μεγαλύτερα από %3$s πλάτος και %4$s ύψος.',

	'BACK_TO_TOP'			=> 'Κορυφή',
	'BACK_TO_PREV'			=> 'Επιστροφή στην προηγούμενη σελίδα',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Μια απαγόρευση έχει εκδοθεί για τη διεύθυνση ηλεκτρονικού ταχυδρομείου σας.',
	'BAN_TRIGGERED_BY_IP'	=> 'Μια απαγόρευση έχει εκδοθεί για τη διεύθυνση IP σας.',
	'BAN_TRIGGERED_BY_USER'	=> 'Μια απαγόρευση έχει εκδοθεί για το όνομα μέλους σας.',
	'BBCODE_GUIDE'			=> 'Οδηγίες BBCode',
	'BCC'					=> 'Κοιν.',
	'BIRTHDAYS'				=> 'Γενέθλια',
	'BOARD_BAN_PERM'		=> 'Έχετε αποκλειστεί <strong>οριστικά</strong> από αυτό το σύστημα συζητήσεων.<br /><br />Παρακαλώ επικοινωνήστε με τον %2$sΔιαχειριστή του συστήματος συζητήσεων%3$s για περισσότερες πληροφορίες.',
	'BOARD_BAN_REASON'		=> 'Λόγος που δόθηκε για αποκλεισμό: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Έχετε αποκλειστεί από αυτό το σύστημα συζητήσεων μέχρι <strong>%1$s</strong>.<br /><br />Παρακαλώ επικοινωνήστε με τον %2$sΔιαχειριστή του συστήματος συζητήσεων%3$s για περισσότερες πληροφορίες.',
	'BOARD_DISABLE'			=> 'Συγγνώμη αλλά το σύστημα συζητήσεων είναι προς το παρόν μη διαθέσιμο.',
	'BOARD_DISABLED'		=> 'Το σύστημα συζητήσεων είναι προς το παρόν εκτός λειτουργίας.',
	'BOARD_UNAVAILABLE'		=> 'Συγγνώμη αλλά το σύστημα συζητήσεων είναι προσωρινά μη διαθέσιμο, παρακαλώ προσπαθήστε πάλι σε μερικά λεπτά.',
	'BROWSING_FORUM'		=> 'Μέλη σε αυτή τη Δ. Συζήτηση: %1$s',
	'BROWSING_FORUM_GUESTS'	=> array(
		1	=> 'Μέλη σε αυτήν τη Δ. Συζήτηση: %2$s και %1$d επισκέπτης',
		2	=> 'Μέλη σε αυτήν τη Δ. Συζήτηση: %2$s και %1$d επισκέπτες',
	),
	'BUTTON_DELETE'         => 'Διαγραφή',
	'BUTTON_EDIT'			=> 'Επεξεργασία',
	'BUTTON_FORUM_LOCKED'	=> 'Κλειδωμένο',
	'BUTTON_INFORMATION'    => 'Πληροφορίες',
	'BUTTON_NEW_TOPIC'		=> 'Νέο Θέμα',
	'BUTTON_PM'				=> 'ΠΜ',
	'BUTTON_PM_FORWARD'		=> 'Προώθηση',
	'BUTTON_PM_NEW'			=> 'Νέο ΠΜ',
	'BUTTON_PM_REPLY'		=> 'Αποστολή απάντησης',
	'BUTTON_PM_REPLY_ALL'	=> 'Απάντηση Όλα',
	'BUTTON_POST_REPLY'		=> 'Απάντηση',
	'BUTTON_QUOTE'			=> 'Παράθεση',
	'BUTTON_REPORT'         => 'Αναφορά',
	'BUTTON_TOPIC_LOCKED'	=> 'Κλειδωμένο',
	'BUTTON_WARN'           => 'Προειδοποίηση',
	'BYTES'					=> 'Ψηφιολέξεις',
	'BYTES_SHORT'			=> 'B',

	'CANCEL'				=> 'Ακύρωση',
	'CHANGE'				=> 'Αλλαγή',
	'CHANGE_FONT_SIZE'		=> 'Αλλαγή γραμματοσειράς',
	'CHANGING_PREFERENCES'	=> 'Αλλάζει προτιμήσεις Δ. Συζήτησης',
	'CHANGING_PROFILE'		=> 'Αλλάζει ρυθμίσεις προφίλ',
	'CHARACTERS'			=> array(
		1	=> '%d χαρακτήρας',
		2	=> '%d χαρακτήρες',
	),
	// Special version to be used when describing ranges e.g. "min x characters and max y characters"
	'CHARACTERS_XY'			=> array(
		1	=> '%d χαρακτήρας',
		2	=> '%d χαρακτήρες',
	),
	'COLLAPSE_VIEW'			=> 'Συμπτυγμένη προβολή',
	'CLOSE_WINDOW'			=> 'Κλείσιμο παραθύρου',
	'CODE'					=> 'Κώδικας',
	'COLOUR_SWATCH'			=> 'Πίνακας χρωμάτων',
	'COLON'					=> ':',
	'COMMA_SEPARATOR'		=> ', ',	// Comma used to join lists into a single string, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Επιβεβαίωση',
	'CONFIRM_CODE'			=> 'Κώδικας επιβεβαίωσης',
	'CONFIRM_CODE_EXPLAIN'	=> 'Πληκτρολογήστε τον κώδικα ακριβώς όπως εμφανίζεται. Όλα τα γράμματα είναι πεζά ή κεφαλαία.',
	'CONFIRM_CODE_WRONG'	=> 'Ο κώδικας επιβεβαίωσης που εισάγατε ήταν λανθασμένος.',
	'CONFIRM_OPERATION'		=> 'Είστε σίγουρος (-η) ότι επιθυμείτε να διενεργήσετε αυτή τη λειτουργία;',
	'CONFIRM_AVATAR_DELETE' => 'Είστε σίγουρος (-η) ότι επιθυμείτε να διαγράψετε αυτό το άβαταρ;',
	'CONGRATULATIONS'		=> 'Συγχαρητήρια',
	'CONNECTION_FAILED'		=> 'Η σύνδεση απέτυχε.',
	'CONNECTION_SUCCESS'	=> 'Η σύνδεση ήταν επιτυχής!',
	'CONTACT'				=> 'Επικοινωνία',
	'CONTACT_USER'			=> 'Επικοινωνία %s',
	'CONTACT_US'			=> 'Επικοινωνήστε μαζί μας',
	'COOKIE_CONSENT_INFO'	=> 'Μάθετε περισσότερα',
	'COOKIE_CONSENT_MSG'	=> 'Αυτή η ιστοσελίδα χρησιμοποιεί cookies για να επιβεβαιώσει ότι θα έχετε την καλύτερη δυνατή εμπειρία χρήσης.',
	'COOKIE_CONSENT_OK'		=> 'Το κατάλαβα!',
	'COOKIE_CONSENT_HREF'	=> 'http://cookiesandyou.com',
	'COOKIES_DELETED'		=> 'Όλα τα cookies του συστήματος συζητήσεων διαγράφηκαν με επιτυχία.',
	'CURRENT_TIME'			=> 'Τώρα είναι %s',

	'DAY'					=> 'Ημέρα',
	'DAYS'					=> 'Ημέρες',
	'DELETE'				=> 'Διαγραφή',
	'DELETE_ALL'			=> 'Διαγραφή όλων',
	'DELETE_COOKIES'		=> 'Διαγραφή cookies',
	'DELETE_MARKED'			=> 'Διαγραφή σημειωμένων',
	'DELETE_POST'			=> 'Διαγραφή δημοσίευσης',
	'DELIMITER'				=> 'Οριοθέτης',
	'DESCENDING'			=> 'Φθίνουσα ',
	'DISABLED'				=> 'Απενεργοποιημένο',
	'DISPLAY'				=> 'Εμφάνιση',
	'DISPLAY_GUESTS'		=> 'Εμφάνιση επισκεπτών',
	'DISPLAY_MESSAGES'		=> 'Τελευταία μηνύματα πριν από',
	'DISPLAY_POSTS'			=> 'Τελευταίες δημοσιεύσεις πριν από',
	'DISPLAY_TOPICS'		=> 'Τελευταία θέματα πριν από',
	'DOMAIN_NO_MX_RECORD_EMAIL'	=> 'Το όνομα χώρου του email που εισήχθη δεν έχει έγκυρη εγγραφή MX.',
	'DOWNLOADED'			=> 'Μεταφορτώθηκε',
	'DOWNLOADING_FILE'		=> 'Μεταφόρτωση αρχείου',
	'DOWNLOAD_COUNTS'		=> array(
		0	=> 'Καμία μεταφόρτωση ακόμη',
		1	=> 'Μεταφορτώθηκε %d φορά',
		2	=> 'Μεταφορτώθηκε %d φορές',
	),

	'EDIT_POST'							=> 'Επεξεργασία δημοσίευσης',
	'ELLIPSIS'							=>	'…',
	'EMAIL'								=> 'Ηλεκτρονικό ταχυδρομείο',// Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Διεύθυνση ηλεκτρονικού ταχυδρομείου',
	'EMAIL_INVALID_EMAIL'				=> 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου που εισάγατε είναι άκυρη.',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Υπάρχει πρόβλημα κατά την αποστολή ηλεκτρονικού ταχυδρομείου στην <strong>Γραμμή %1$s</strong>. Απόκριση: %2$s.',
	'EMPTY_SUBJECT'						=> 'Πρέπει να διευκρινίσετε ένα θέμα κατά τη δημοσίευση ενός νέου θέματος.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Πρέπει να διευκρινίσετε ένα θέμα κατά τη δημιουργία ενός νέου μηνύματος.',
	'ENABLED'							=> 'Ενεργοποιημένο',
	'ENCLOSURE'							=> 'Συνημμένο',
	'ENTER_USERNAME'					=> 'Εισάγετε όνομα μέλους',
	'ERR_CHANGING_DIRECTORY'			=> 'Ο κατάλογος δεν μπορεί να αλλάξει.',
	'ERR_CONNECTING_SERVER'				=> 'Σφάλμα κατά τη σύνδεση με τον διακομιστή.',
	'ERR_JAB_AUTH'						=> 'Δεν έχετε εξουσιοδότηση για τον διακομιστή Jabber.',
	'ERR_JAB_CONNECT'					=> 'Δεν ήταν δυνατή η σύνδεση με τον διακομιστή Jabber',
	'ERR_UNABLE_TO_LOGIN'				=> 'Το καθορισμένο όνομα χρήστη ή ο κωδικός πρόσβασης είναι λάθος.',
	'ERR_UNWATCHING'					=> 'Ένα σφάλμα προέκυψε κατά την προσπάθεια διακοπής συνδρομής.',
	'ERR_WATCHING'						=> 'Ένα σφάλμα προέκυψε κατά την προσπάθεια έναρξης συνδρομής.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Η καθορισμένη διαδρομή του φακέλου phpBB φαίνεται να είναι άκυρη.',
	'ERROR'								=> 'Λάθος',
	'EXPAND_VIEW'						=> 'Αναπτυγμένη προβολή',
	'EXTENSION'							=> 'Επέκταση',
	'EXTENSION_DISABLED'				=> 'Η επέκταση <strong>%s</strong> δεν είναι ενεργοποιημένη.',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Η επέκταση <strong>%s</strong> έχει απενεργοποιηθεί και δεν μπορεί πλέον να εμφανιστεί.',
	'EXTENSION_DOES_NOT_EXIST'			=> 'Η επέκταση <strong>%s</strong> δεν υπάρχει.',

	'FACEBOOK'				=> 'Facebook',
	'FAQ'					=> 'Συχνές ερωτήσεις',
	'FAQ_EXPLAIN'			=> 'Συνήθεις ερωτήσεις',
	'FEATURE_NOT_AVAILABLE' => 'Η αιτούμενη λειτουργία δεν είναι διαθέσιμη σε αυτό το σύστημα συζητήσεων.',
	'FILENAME'				=> 'Όνομα αρχείου',
	'FILESIZE'				=> 'Μέγεθος αρχείου',
	'FILEDATE'				=> 'Ημερομηνία αρχείου',
	'FILE_COMMENT'			=> 'Σχόλιο αρχείου',
	'FILE_CONTENT_ERR'		=> 'Δεν ήταν δυνατή η ανάγνωση των περιεχομένων του αρχείου: %s',
	'FILE_JSON_DECODE_ERR'	=> 'Απέτυχε η αποκωδικοποίηση του αρχείου json: %s',
	'FILE_NOT_FOUND'		=> 'Το αρχείο που ζητήθηκε δεν μπορεί να βρεθεί: %s',
	'FIND_USERNAME'			=> 'Εύρεση μέλους',
	'FOLDER'				=> 'Φάκελος',
	'FORGOT_PASS'			=> 'Ξέχασα τον κωδικό μου',
	'FORM_INVALID'			=> 'Η υποβληθείσα μορφή ήταν άκυρη. Προσπαθήστε πάλι.',
	'FORUM'					=> 'Δ. Συζήτηση',
	'FORUMS'				=> 'Δ. Συζητήσεις',
	'FORUMS_MARKED'			=> 'Οι Δ. Συζητήσεις έχουν επισημανθεί ως αναγνωσμένες.',
	'FORUM_CAT'				=> 'Κατηγορία Δ. Συζήτησης',
	'FORUM_INDEX'			=> 'Ευρετήριο Δ. Συζήτησης',
	'FORUM_LINK'			=> 'Σύνδεσμος Δ. Συζήτησης',
	'FORUM_LOCATION'		=> 'Τοποθεσία Δ. Συζήτησης',
	'FORUM_LOCKED'			=> 'Κλειδωμένη Δ. Συζήτηση',
	'FORUM_RULES'			=> 'Κανόνες Δ. Συζήτησης',
	'FORUM_RULES_LINK'		=> 'Παρακαλώ πατήστε εδώ για να δείτε τους κανόνες της Δ. Συζήτησης',
	'FROM'					=> 'από',
	'FSOCK_DISABLED'		=> 'Αυτή η λειτουργία δεν μπορεί να ολοκληρωθεί επειδή η λειτουργία <var>fsockopen</var> έχει απενεργοποιηθεί ή ο διακομιστής στον οποίο υποβλήθηκε το ερώτημα δεν μπορεί να βρεθεί.',
	'FSOCK_TIMEOUT'			=> 'Μια υπέρβαση χρονικού ορίου προέκυψε κατά την ανάγνωση από τη ροή του δικτύου',
	
	'FILESYSTEM_CANNOT_CHANGE_FILE_GROUP'		=> 'Αδύνατη η αλλαγή ομάδας αρχείου',
	'FILESYSTEM_CANNOT_CHANGE_FILE_PERMISSIONS'	=> 'Αδύνατη η αλλαγή δικαιωμάτων αρχείου',
	'FILESYSTEM_CANNOT_COPY_FILES'				=> 'Αδύνατη η αντιγραφή αρχείων',
	'FILESYSTEM_CANNOT_CREATE_SYMLINK'			=> 'Αδύνατη η δημιουργία συμβολικού συνδέσμου (symlink)',
	'FILESYSTEM_CANNOT_CREATE_DIRECTORY'		=> 'Αδύνατη η δημιουργία φακέλου',
	'FILESYSTEM_CANNOT_DELETE_FILES'			=> 'Αδύνατη η διαγραφή αρχείων από το σύστημα',
	'FILESYSTEM_CANNOT_DUMP_FILE'				=> 'Αδύνατη η εγγραφή στο αρχείο',
	'FILESYSTEM_CANNOT_MIRROR_DIRECTORY'		=> 'Αδύνατη η αντιγραφή του φακέλου',
	'FILESYSTEM_CANNOT_RENAME_FILE'				=> 'Αδύνατη η μετονομασία ενός αρχείου από το σύστημα',
	'FILESYSTEM_CANNOT_TOUCH_FILES'				=> 'Αδύνατη η δημιουργία του αρχείου ή η αλλαγή της χρονοσφραγίδας του',

	'FTP_FSOCK_HOST'				=> 'Κόμβος FTP',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'Ο διακομιστής FTP που χρησιμοποιείται για να συνδεθείτε στην ιστοσελίδα σας.',
	'FTP_FSOCK_PASSWORD'			=> 'Κωδικός FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Ο κωδικός πρόσβασης για το FTP όνομα χρήστη σας.',
	'FTP_FSOCK_PORT'				=> 'Θύρα FTP',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Η θύρα που χρησιμοποιείται για να συνδεθείτε στον διακομιστή σας.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Διαδρομή του phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Η διαδρομή του ριζικού φακέλου phpBB του συστήματος συζητήσεών σας.',
	'FTP_FSOCK_TIMEOUT'				=> 'Λήξη χρόνου αναμονής FTP',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Το χρονικό διάστημα, σε δευτερόλεπτα, που το σύστημα θα περιμένει μια απάντηση από τον διακομιστή σας.',
	'FTP_FSOCK_USERNAME'			=> 'Όνομα χρήστη FTP',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Το όνομα χρήστη FTP που χρησιμοποιείται για να συνδεθείτε στον διακομιστή σας.',

	'FTP_HOST'					=> 'Κόμβος FTP',
	'FTP_HOST_EXPLAIN'			=> 'Ο διακομιστής FTP που χρησιμοποιείται για να συνδεθείτε στην ιστοσελίδα σας.',
	'FTP_PASSWORD'				=> 'Κωδικός FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'Ο κωδικός πρόσβασης για το FTP όνομα χρήστη σας.',
	'FTP_PORT'					=> 'θύρα FTP',
	'FTP_PORT_EXPLAIN'			=> 'Η θύρα που χρησιμοποιείται για να συνδεθείτε στον διακομιστή σας.',
	'FTP_ROOT_PATH'				=> 'Διαδρομή του phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Η διαδρομή του ριζικού φακέλου phpBB του συστήματος συζητήσεων σας.',
	'FTP_TIMEOUT'				=> 'Λήξη χρόνου αναμονής FTP',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Το χρονικό διάστημα, σε δευτερόλεπτα, που το σύστημα θα περιμένει μια απάντηση από τον διακομιστή σας.',
	'FTP_USERNAME'				=> 'Όνομα χρήστη FTP',
	'FTP_USERNAME_EXPLAIN'		=> 'Το όνομα χρήστη που χρησιμοποιείται για να συνδεθείτε στον διακομιστή σας.',

	'GENERAL_ERROR'				=> 'Γενικό σφάλμα',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Μετάβαση',
	'GOTO_FIRST_POST'			=> 'Μετάβαση στην πρώτη δημοσίευση',
	'GOTO_LAST_POST'			=> 'Μετάβαση στην τελευταία δημοσίευση',
	'GOTO_PAGE'					=> 'Μετάβαση στη σελίδα',
	'GROUP'						=> 'Ομάδα',
	'GROUPS'					=> 'Ομάδες',
	'GROUP_ERR_TYPE'			=> 'Προσδιορίστηκε ένας ακατάλληλος τύπος ομάδας.',
	'GROUP_ERR_USERNAME'		=> 'Δεν έχει προσδιοριστεί κανένα όνομα ομάδας.',
	'GROUP_ERR_USER_LONG'		=> 'Ονόματα ομάδας δεν μπορούν να υπερβαίνουν το μήκος 60 χαρακτήρων. Το καθορισμένο όνομα ομάδας είναι πολύ μεγάλο.',
	'GUEST'						=> 'Επισκέπτης',
	'GUEST_USERS_ONLINE'		=> array(
		1	=> 'Υπάρχει %d επισκέπτης σε σύνδεση',
		2	=> 'Υπάρχουν %d επισκέπτες σε σύνδεση',
	),
	'GUEST_USERS_TOTAL'			=> array(
		1	=> '%d επισκέπτης',
		2	=> '%d επισκέπτες',
	),
	'G_ADMINISTRATORS'			=> 'Διαχειριστές',
	'G_BOTS'					=> 'Bots',
	'G_GUESTS'					=> 'Επισκέπτες',
	'G_REGISTERED'				=> 'Εγγεγραμμένα μέλη ',
	'G_REGISTERED_COPPA'		=> 'Εγγεγραμμένα μέλη COPPA',
	'G_GLOBAL_MODERATORS'		=> 'Καθολικοί συντονιστές',
	'G_NEWLY_REGISTERED'		=> 'Πρόσφατα εγγεγραμμένα μέλη',

	'HIDDEN_USERS_ONLINE'		=> array(
		1	=> '%d μέλος με απόκρυψη',
		2	=> '%d μέλη με απόκρυψη',
	),
	'HIDDEN_USERS_TOTAL'		=> array(
		1	=> '%d με απόκρυψη',
		2	=> '%d με απόκρυψη',
	),
	'HIDE_GUESTS'				=> 'Απόκρυψη επισκεπτών',
	'HIDE_ME'					=> 'Απόκρυψη των στοιχείων μου κατά τη διάρκεια της σύνδεσης',
	'HOURS'						=> 'Ώρες',
	'HOME'						=> 'Αρχική σελίδα',

	'ICQ'						=> 'ICQ',
	'IF'						=> 'Εάν',
	'IMAGE'						=> 'Εικόνα',
	'IMAGE_FILETYPE_INVALID'	=> 'Ο τύπος αρχείου εικόνας %d για το mimetype %s δεν υποστηρίζεται.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Ανακριβής τύπος αρχείου: αναμενόμενη επέκταση %1$s όμως δίνετε η επέκταση %2$s.',
	'IN'						=> 'σε',
	'INACTIVE'					=> 'Ανενεργό',
	'INDEX'						=> 'Ευρετήριο σελίδας',
	'INFORMATION'				=> 'Πληροφορίες',
	'INSECURE_REDIRECT'			=> 'Προσπάθεια ανακατεύθυνσης σε δυνητικά ανασφαλή διεύθυνση URL.',
	'INTERESTS'					=> 'Ενδιαφέροντα',
	'INVALID_DIGEST_CHALLENGE'	=> 'Άκυρη πρόκληση αφομοιώσεων.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> πιθανόν μία άκυρη ηλεκτρονική διεύθυνση;',
	'INVALID_FEED_ATTACHMENTS'	=> 'Η επιλεγμένη τροφοδότηση προσπάθησε να αντλήσει συνημμένα με μη έγκυρες παραμέτρους.',
	'INVALID_PLURAL_RULE'		=> 'Ο επιλεγμένος πολλαπλός κανόνας είναι άκυρος. Οι έγκυρες τιμές είναι ακέραιοι αριθμοί μεταξύ 0 και 15.',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Η διεύθυνση IP σας %1$s έχει αποκλειστεί επειδή βρίσκεται στη μαύρη λίστα. Για περισσότερες λεπτομέρειες δείτε <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Εγγραφή',
	'JUMP_PAGE'				=> 'Εισάγετε τον αριθμό σελίδας στην οποία θέλετε να μεταβείτε.',
	'JUMP_TO'				=> 'Μετάβαση σε',
	'JUMP_TO_PAGE'			=> 'Μετάβαση στη σελίδα',
	'JUMP_TO_PAGE_CLICK'	=> 'Πατήστε για μετάβαση στη σελίδα…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Τελευταία δημοσίευση',
	'LAST_UPDATED'						=> 'Τελευταία ενημέρωση',
	'LAST_VISIT'						=> 'Τελευταία επίσκεψη',
	'LDAP_NO_LDAP_EXTENSION'			=> 'Η επέκταση LDAP δεν είναι διαθέσιμη.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Δεν ήταν δυνατή η σύνδεση με τον διακομιστή LDAP.',
	'LDAP_SEARCH_FAILED'				=> 'Ένα σφάλμα προέκυψε κατά την αναζήτηση στον κατάλογο LDAP.',
	'LEGEND'							=> 'Υπόμνημα',
	'LIVE_SEARCHES_NOT_ALLOWED'			=> 'Ζωντανές αναζητήσεις δεν επιτρέπονται.',
	'LOADING'							=> 'Φόρτωση',
	'LOCATION'							=> 'Τοποθεσία',
	'LOCK_POST'							=> 'Κλείδωμα δημοσίευσης',
	'LOCK_POST_EXPLAIN'					=> 'Αποτροπή επεξεργασίας',
	'LOCK_TOPIC'						=> 'Κλείδωμα θέματος',
	'LOGIN'								=> 'Σύνδεση',
	'LOGIN_CHECK_PM'					=> 'Συνδεθείτε, για να ελέγξετε την αλληλογραφία σας.',
	'LOGIN_CONFIRMATION'				=> 'Επιβεβαίωση σύνδεσης',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Για την αποτροπή επιθέσεων ωμού εξαναγκασμού προς τον λογαριασμό σας το σύστημα συζητήσεων απαιτεί από εσάς να εισάγετε ένα κωδικό επιβεβαίωσης μετά από έναν αριθμό αποτυχημένων προσπαθειών σύνδεσης. Ο κώδικας εμφανίζεται στην εικόνα που θα πρέπει να βλέπετε παρακάτω. Αν είστε άτομα με προβλήματα όρασης ή δεν μπορείτε να διαβάσετε διαφορετικά αυτό τον κώδικα, παρακαλώ επικοινωνήστε με τον %sΔιαχειριστή της Δ. Συζήτησης%s.', // unused
	'LOGIN_ERROR_ATTEMPTS'				=> 'Έχετε υπερβεί το μέγιστο αριθμό προσπαθειών σύνδεσης. Εκτός από το όνομα μέλους και τον κωδικό πρόσβασής σας πρέπει επίσης περάσετε τον έλεγχο CAPTCHA.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Δεν έχετε πιστοποιηθεί από τον Apache.',
	'LOGIN_ERROR_OAUTH_SERVICE_DOES_NOT_EXIST'	=> 'Έχει γίνει αίτημα σε μια μη υπαρκτή υπηρεσία OAuth.',
	'LOGIN_ERROR_PASSWORD'				=> 'Έχετε καθορίσει έναν άκυρο κωδικό πρόσβασης. Παρακαλώ ελέγξτε τον κωδικό πρόσβασης και προσπαθήστε εκ νέου. Εάν συνεχίσετε να έχετε προβλήματα επικοινωνήστε με τον %sΔιαχειριστή της Δ. Συζήτησης%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Δεν ήταν δυνατή η μετατροπή του κωδικού πρόσβασης σας κατά την ενημέρωση του λογισμικού αυτού του συστήματος συζητήσεων. Παρακαλώ %sζητήστε ένα νέο κωδικό%s. Εάν συνεχίσετε να έχετε προβλήματα επικοινωνήστε με τον %sΔιαχειριστή του συστήματος συζητήσεων%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Έχετε καθορίσει ένα λανθασμένο όνομα μέλους. Παρακαλώ ελέγξτε το όνομα μέλους και προσπαθήστε εκ νέου. Εάν συνεχίσετε να έχετε προβλήματα επικοινωνήστε με τον %sΔιαχειριστή της Δ. Συζήτησης%s.',
	'LOGIN_FORUM'						=> 'Για να προβάλετε ή να δημοσιεύσετε σε αυτή τη Δ. Συζήτηση πρέπει να εισάγετε τον κωδικό της.',
	'LOGIN_INFO'						=> 'Προκειμένου να συνδεθείτε πρέπει να είστε εγγεγραμμένο μέλος. Η εγγραφή γίνεται σε λίγα μόνο λεπτά, αλλά σας παρέχει αυξημένες δυνατότητες. Οι διαχειριστές του συστήματος συζητήσεων μπορεί επίσης να χορηγούν επιπρόσθετα δικαιώματα στα εγγεγραμμένα μέλη. Πριν συνδεθείτε, σιγουρευτείτε ότι γνωρίζετε τους όρους χρήσης και τις σχετικές πολιτικές. Παρακαλώ να διαβάσετε τους κανόνες κάθε Δ. Συζήτησης κατά την πλοήγησή σας σε αυτό το σύστημα συζητήσεων.',
	'LOGIN_VIEWFORUM'					=> 'Το σύστημα συζητήσεων απαιτεί ότι πρέπει να είστε εγγεγραμμένο μέλος και να έχετε συνδεθεί για να δείτε τις δημοσιεύσεις σε αυτή τη Δ. Συζήτηση',
	'LOGIN_EXPLAIN_EDIT'				=> 'Προκειμένου να κάνετε επεξεργασία δημοσιεύσεων σε αυτή τη Δ. Συζήτηση πρέπει να είστε εγγεγραμμένο μέλος και να έχετε συνδεθεί.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Προκειμένου να δείτε τη λίστα «ποιος είναι σε σύνδεση» πρέπει να είστε εγγεγραμμένο μέλος και να έχετε συνδεθεί.',
	'LOGIN_REQUIRED'					=> 'Πρέπει να συνδεθείτε για να κάνετε αυτή την ενέργεια.',
	'LOGOUT'							=> 'Αποσύνδεση',
	'LOGOUT_USER'						=> 'Αποσύνδεση [ %s ]',
	'LOG_ME_IN'							=> 'Να με θυμάσαι',

	'MAIN'					=> 'Κύρια',
	'MARK'					=> 'Επισήμανση',
	'MARK_ALL'				=> 'Επισήμανση όλων',
	'MARK_ALL_READ'			=> 'Επισήμανση όλων ως αναγνωσμένες',
	'MARK_FORUMS_READ'		=> 'Επισήμανση Δ. Συζητήσεων ως αναγνωσμένες',
	'MARK_READ'				=> 'Επισήμανση ως αναγνωσμένα',
	'MARK_SUBFORUMS_READ'	=> 'Επισήμανση υπο-συζητήσεων ως αναγνωσμένες',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Πίνακας Ελέγχου Συντονιστών',
	'MCP_SHORT'				=> 'ΠΕΣ',
	'MEMBERLIST'			=> 'Μέλη',
	'MEMBERLIST_EXPLAIN'	=> 'Προβολή πλήρους λίστας μελών',
	'MERGE'					=> 'Συγχώνευση',
	'MERGE_POSTS'			=> 'Μετακίνηση δημοσιεύσεων',
	'MERGE_TOPIC'			=> 'Συγχώνευση θέματος',
	'MESSAGE'				=> 'Μήνυμα',
	'MESSAGES'				=> 'Μηνύματα',
	'MESSAGES_COUNT'		=> array(
		0	=> 'απεριόριστα μηνύματα',
		1	=> '%d μήνυμα',
		2	=> '%d μηνύματα',
	),
	'MESSAGE_BODY'			=> 'Κείμενο μηνύματος',
	'MINUTES'				=> 'Λεπτά',
	'MODERATE'				=> 'Συντονίστε',
	'MODERATOR'				=> 'Συντονιστής',
	'MODERATORS'			=> 'Συντονιστές',
	'MODULE_NOT_ACCESS'		=> 'Η μονάδα δεν είναι προσβάσιμη',
	'MODULE_NOT_FIND'		=> 'Δεν μπορεί να βρεθεί η μονάδα %s',
	'MODULE_FILE_INCORRECT_CLASS'	=> 'Το αρχείο μονάδας %s δεν περιέχει σωστή κατηγορία [%s]',
	'MONTH'					=> 'Μήνας',
	'MOVE'					=> 'Μετακίνηση',

	'NA'						=> 'Δ/Υ',
	'NEWEST_USER'				=> 'Το νεότερο μέλος μας <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Νέο μήνυμα',
	'NEW_MESSAGES'				=> 'Νέα μηνύματα',
	'NEW_POST'					=> 'Νέα δημοσίευση',	// Not used anymore
	'NEW_POSTS'					=> 'Νέες δημοσιεύσεις',	// Not used anymore
	'NEXT'						=> 'Επόμενη',		// Used in pagination
	'NEXT_STEP'					=> 'Επόμενο βήμα',
	'NEVER'						=> 'Ποτέ',
	'NO'						=> 'Όχι',
	'NO_NOTIFICATIONS'			=> 'Δεν έχετε ειδοποιήσεις',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Δεν σας επιτρέπεται να διαχειριστείτε αυτή την ομάδα.',
	'NOT_AUTHORISED'			=> 'Δεν είστε εξουσιοδοτημένοι για πρόσβαση σε αυτή την περιοχή.',
	'NOT_WATCHING_FORUM'		=> 'Δεν είστε πλέον συνδρομητής για ενημερώσεις σε αυτή τη Δ. Συζήτηση.',
	'NOT_WATCHING_TOPIC'		=> 'Δεν είστε πλέον συνδρομητής σε αυτό το θέμα.',
	'NOTIFICATIONS'				=> 'Ειδοποιήσεις',
	// This applies for NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	// %1$s will return a list of users that's concatenated using "," and "and" - see STRING_LIST
	// Once the user count reaches 5 users or more, the list is trimmed using NOTIFICATION_X_OTHERS
	// Once the user count reaches 20 users or more, the list is trimmed using NOTIFICATION_MANY_OTHERS
	// Examples:
	// A replied...
	// A and B replied...
	// A, B and C replied...
	// A, B, C and 2 others replied...
	// A, B, C and others replied...
	'NOTIFICATION_BOOKMARK'				=> array(
		1	=> '<strong>Απάντηση</strong> από %1$s σε θέμα σελιδοδείκτη:',
	),
	'NOTIFICATION_FORUM'				=> '<em>Δ. Συζήτηση:</em> %1$s',
	'NOTIFICATION_GROUP_REQUEST'		=> '<strong>Αίτημα ομάδας</strong> από %1$s για ένταξη στην ομάδα %2$s.',
	'NOTIFICATION_GROUP_REQUEST_APPROVED'	=> '<strong>Εγκρίθηκε το αίτημα ομάδας</strong> για ένταξη στην ομάδα %1$s.',
	'NOTIFICATION_METHOD_INVALID'		=> 'Η μέθοδος "%s" δεν ανταποκρίνεται σε έγκυρη μέθοδο ειδοποίησης.',
	'NOTIFICATION_PM'					=> '<strong>Προσωπικό μήνυμα</strong> από %1$s:',
	'NOTIFICATION_POST'					=> array(
		1	=> '<strong>Απάντηση</strong> από %1$s στο θέμα:',
	),
	'NOTIFICATION_POST_APPROVED'		=> '<strong>Εγκρίθηκε δημοσίευση</strong>:',
	'NOTIFICATION_POST_DISAPPROVED'		=> '<strong>Απορρίφθηκε δημοσίευση</strong>:',
	'NOTIFICATION_POST_IN_QUEUE'		=> '<strong>Αίτημα έγκρισης δημοσίευσης</strong> από %1$s:',
	'NOTIFICATION_QUOTE'				=> array(
		1	=> '<strong>Παράθεση</strong> από %1$s σε:',
	),
	'NOTIFICATION_REFERENCE'			=> '"%1$s"',
	'NOTIFICATION_REASON'				=> '<em>Λόγος:</em> %1$s.',
	'NOTIFICATION_REPORT_PM'			=> '<strong>Αναφορά προσωπικού μηνύματος</strong> από %1$s:',
	'NOTIFICATION_REPORT_PM_CLOSED'		=> '<strong>Αναφορά προσωπικού μηνύματος έχει κλείσει</strong> από %1$s:',
	'NOTIFICATION_REPORT_POST'			=> '<strong>Αναφορά δημοσίευσης</strong> από %1$s:',
	'NOTIFICATION_REPORT_CLOSED'		=> '<strong>Κλείσιμο αναφορά</strong> από %1$s για:',
	'NOTIFICATION_TOPIC'				=> '<strong>Νέο θέμα</strong> από %1$s:',
	'NOTIFICATION_TOPIC_APPROVED'		=> '<strong>Έγκριση θέματος</strong>:',
	'NOTIFICATION_TOPIC_DISAPPROVED'	=> '<strong>Απόρριψη θέματος</strong>:',
	'NOTIFICATION_TOPIC_IN_QUEUE'		=> '<strong>Αίτημα έγκρισης θέματος</strong> από %1$s:',
	'NOTIFICATION_TYPE_NOT_EXIST'		=> 'Ο τύπος ειδοποίησης "%s" λείπει από το σύστημα αρχείων.',
	'NOTIFICATION_ADMIN_ACTIVATE_USER'	=> '<strong>Απαιτείται ενεργοποίηση</strong> για απενεργοποιημένο ή πρόσφατο εγγεγραμμένο μέλος: “%1$s”',
	// Used in conjunction with NOTIFICATION_BOOKMARK and NOTIFICATION_POST.
	'NOTIFICATION_MANY_OTHERS'			=> 'άλλα',
	'NOTIFICATION_X_OTHERS'				=> array(
		2	=> '%d άλλα',
	),
	'NOTIFY_ADMIN'				=> 'Παρακαλώ ενημερώστε τον Διαχειριστή του συστήματος συζητήσεων ή τον webmaster.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Παρακαλώ ενημερώστε τον Διαχειριστή του συστήματος συζητήσεων ή τον webmaster: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Δεν σας επιτρέπεται η πρόσβαση σε αυτό το αρχείο.',
	'NO_ACTION'					=> 'Δεν καθορίστηκε ενέργεια.',
	'NO_ADMINISTRATORS'			=> 'Δεν υπάρχουν διαχειριστές.',
	'NO_AUTH_ADMIN'				=> 'Η πρόσβαση στον Πίνακα Ελέγχου Διαχειριστή δεν σας επιτρέπεται διότι δεν έχετε τα δικαιώματα ενός διαχειριστή.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Δεν μπορείτε να επαναπιστοποιηθείτε ως ένα διαφορετικός μέλος.',
	'NO_AUTH_OPERATION'			=> 'Δεν έχετε τα απαραίτητα δικαιώματα για να ολοκληρώσετε αυτή τη λειτουργία.',
	'NO_AVATARS'				=> 'Δεν υπάρχουν διαθέσιμα άβαταρ προς το παρόν',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Δεν ήταν δυνατή η σύνδεση με διακομιστή smtp : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Κανένα μέλος δεν έχει γενέθλια σήμερα',
	'NO_EMAIL_MESSAGE'			=> 'Το μήνυμα ηλεκτρονικού ταχυδρομείο ήταν κενό.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Δεν ήταν δυνατόν να ληφθούν οι κώδικες απόκρισης του διακομιστή ηλεκτρονικού ταχυδρομείου.',
	'NO_EMAIL_SUBJECT'			=> 'Δεν έχετε καθορίσει κανένα θέμα στο μήνυμα ηλεκτρονικού ταχυδρομείου.',
	'NO_FORUM'					=> 'Η Δ. Συζήτηση που επιλέξατε δεν υπάρχει.',
	'NO_FORUMS'					=> 'Αυτό το σύστημα συζητήσεων δεν έχει Δ. Συζητήσεις.',
	'NO_GROUP'					=> 'Η ομάδα μελών που ζητήθηκε δεν υπάρχει.',
	'NO_GROUP_MEMBERS'			=> 'Αυτή η ομάδα δεν έχει μέλη προς το παρόν.',
	'NO_IPS_DEFINED'			=> 'Δεν προσδιορίστηκαν διευθύνσεις IP ή ονόματα εξυπηρετητών',
	'NO_MEMBERS'				=> 'Δεν βρέθηκαν μέλη με αυτά τα κριτήρια.',
	'NO_MESSAGES'				=> 'Δεν υπάρχουν μηνύματα',
	'NO_MODE'					=> 'Κανένας τρόπος δεν έχει καθοριστεί.',
	'NO_MODERATORS'				=> 'Δεν υπάρχουν συντονιστές.',
	'NO_NEW_MESSAGES'			=> 'Δεν υπάρχουν νέα μηνύματα',
	'NO_NEW_POSTS'				=> 'Δεν υπάρχουν νέες δημοσιεύσεις',	// Not used anymore
	'NO_ONLINE_USERS'			=> 'Δεν υπάρχουν εγγεγραμμένα μέλη',
	'NO_POSTS'					=> 'Δεν υπάρχουν δημοσιεύσεις',
	'NO_POSTS_TIME_FRAME'		=> 'Δεν υπάρχουν νέες δημοσιεύσεις μέσα σε αυτό το θέμα για το επιλεγμένο χρονικό διάστημα.',
	'NO_FEED_ENABLED'			=> 'Οι τροφοδοσίες δεν είναι διαθέσιμες σε αυτό το σύστημα συζητήσεων.',
	'NO_FEED'					=> 'Η ζητούμενη τροφοδοσία δεν είναι διαθέσιμη.',
	'NO_STYLE_DATA'				=> 'Δεν ήταν δυνατή η λήψη δεδομένων στυλ για user_style %s και να ρυθμιστεί για user_id %s',
	'NO_STYLE_CFG'				=> 'Δε μπορεί να βρεθεί το αρχείο ρυθμίσεων για: %s',
	'NO_SUBJECT'				=> 'Δεν καθορίστηκε κανένα θέμα',		// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Το συγκεκριμένο σύστημα υποστήριξης αναζήτησης δεν υπάρχει.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Δεν υπάρχουν υποστηριζόμενοι μέθοδοι πιστοποίησης.',
	'NO_TOPIC'					=> 'Το θέμα που ζητήθηκε δεν υπάρχει.',
	'NO_TOPIC_FORUM'			=> 'Το θέμα ή η Δ. Συζήτηση δεν υπάρχει πλέον.',
	'NO_TOPICS'					=> 'Δεν υπάρχουν θέματα ή δημοσιεύσεις σε αυτή τη Δ. Συζήτηση.',
	'NO_TOPICS_TIME_FRAME'		=> 'Δεν υπάρχουν θέματα μέσα σε αυτή τη Δ. Συζήτηση για το επιλεγμένο χρονικό διάστημα.',
	'NO_UNREAD_POSTS'			=> 'Δεν υπάρχουν μη αναγνωσμένες δημοσιεύσεις',
	'NO_UPLOAD_FORM_FOUND'		=> 'Η αποστολή του αρχείου ξεκίνησε αλλά βρέθηκε μη έγκυρη φόρμα αποστολής αρχείου.',
	'NO_USER'					=> 'Το μέλος που ζητήθηκε δεν υπάρχει.',
	'NO_USERS'					=> 'Τα μέλη που ζητήθηκαν δεν υπάρχουν.',
	'NO_USER_SPECIFIED'			=> 'Δεν προσδιορίστηκε όνομα μέλους.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_ATTACHMENTS'		=> array(
		1	=> '%d συνημμένο',
		2	=> '%d συνημμένα',
	),
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Καμία δημοσίευση σε αναμονή',		// 0
		1			=> '1 δημοσίευση σε αναμονή',		// 1
		2			=> '%d δημοσιεύσεις σε αναμονή',		// 2+
	),

	'OCCUPATION'				=> 'Επάγγελμα',
	'OFFLINE'					=> 'Χωρίς σύνδεση',
	'ONLINE'					=> 'Σε σύνδεση',
	'ONLINE_BUDDIES'			=> 'Σε σύνδεση φίλοι',
	// "... :: x registered and y hidden"
	'ONLINE_USERS_TOTAL'		=> array(
		1	=> 'Συνολικά υπάρχει <strong>%1$d</strong> μέλος σε σύνδεση: %2$s και %3$s',
		2	=> 'Συνολικά υπάρχουν <strong>%1$d</strong> μέλη σε σύνδεση: %2$s και %3$s',
	),
	// "... :: x registered, y hidden and z guests"
	'ONLINE_USERS_TOTAL_GUESTS'	=> array(
		1	=> 'Συνολικά υπάρχει <strong>%1$d</strong> μέλος σε σύνδεση: %2$s, %3$s και %4$s',
		2	=> 'Συνολικά υπάρχουν <strong>%1$d</strong> μέλη σε σύνδεση: %2$s, %3$s και %4$s',
	),
	'OPTIONS'					=> 'Επιλογές',

	'PAGE_NOT_FOUND'		=> 'Η σελίδα που ζητήσατε δε μπορεί να βρεθεί.',
	'PAGE_OF'				=> 'Σελίδα <strong>%1$d</strong> από <strong>%2$d</strong>',
	'PAGE_TITLE_NUMBER'		=> 'Σελίδα %s',
	'PASSWORD'				=> 'Κωδικός',
	'PIXEL'					=> 'px',
	'PIXELS'				=> array(
		1	=> '%d εικονοστοιχείο',
		2	=> '%d εικονοστοιχεία',
	),
	'PLEASE_WAIT'			=> 'Παρακαλώ περιμένετε.',
	'PM'					=> 'ΠΜ',
	'PM_REPORTED'			=> 'Πατήστε για προβολή αναφοράς',	
	'POSTING_MESSAGE'		=> 'Δημοσιεύει μήνυμα σε %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Συντάσσει ένα προσωπικό μήνυμα',
	'POST'					=> 'Δημοσίευση',
	'POST_ANNOUNCEMENT'		=> 'Ανακοίνωση',
	'POST_STICKY'			=> 'Σημείωση',
	'POSTED'				=> 'Δημοσιεύτηκε',
	'POSTED_IN_FORUM'		=> 'σε',
	'POSTED_ON_DATE'		=> 'την',
	'POSTS'					=> 'Δημοσιεύσεις',
	'POSTS_UNAPPROVED'		=> 'Τουλάχιστον μια δημοσίευση σε αυτό το θέμα δεν έχει εγκριθεί.',
	'POSTS_UNAPPROVED_FORUM'=> 'Τουλάχιστον μια δημοσίευση σε αυτή τη Δ. Συζήτηση δεν έχει εγκριθεί.',
	'POST_BY_AUTHOR'		=> 'από',
	'POST_BY_FOE'			=> 'Το μέλος <strong>%1$s</strong>, που είναι προς το παρόν στη λίστα εχθρών σας, έκανε αυτή τη δημοσίευση.',
	'POST_DISPLAY'			=> 'Εμφάνιση αυτής της δημοσίευσης.',
	'POST_DAY'				=> '%.2f δημοσιεύσεις ανά ημέρα',
	'POST_DELETED_ACTION'	=> 'Διαγραμμένη δημοσίευση:',
	'POST_DELETED'			=> 'Αυτή η δημοσίευση διαγράφηκε.',
	'POST_DELETED_BY'		=> 'Το μέλος <strong>%2$s</strong> διέγραψε τη δημοσίευση από <strong>%1$s</strong> την %3$s.',
	'POST_DELETED_BY_REASON'=> 'Το μέλος <strong>%2$s</strong> διέγραψε τη δημοσίευση από <strong>%1$s</strong> την %3$s για τον παρακάτω λόγο: %4$s',
	'POST_DETAILS'			=> 'Λεπτομέρειες δημοσίευσης',
	'POST_NEW_TOPIC'		=> 'Δημιουργία νέου θέματος',
	'POST_PCT'				=> '%.2f%% επί συνόλου ',
	'POST_PCT_ACTIVE'		=> '%.2f%% των δημοσιεύσεων των μελών',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% των δημοσιεύσεων σας',
	'POST_REPLY'			=> 'Δημιουργία απάντησης',
	'POST_REPORTED'			=> 'Πατήστε για προβολή αναφοράς',
	'POST_SUBJECT'			=> 'Θέμα δημοσίευσης',
	'POST_TIME'				=> 'Ώρα δημοσίευσης',
	'POST_TOPIC'			=> 'Δημιουργία νέου θέματος',
	'POST_UNAPPROVED_ACTION'	=> 'Δημοσίευση σε αναμονή έγκρισης:',
	'POST_UNAPPROVED'		=> 'Αυτή η δημοσίευση δεν έχει εγκριθεί.',
	'POST_UNAPPROVED_EXPLAIN'	=> 'Αυτή η δημοσίευση δεν είναι ορατή στους άλλους χρήστες μέχρι να εγγριθεί από κάποιον συντονιστή.',
	'POWERED_BY'			=> 'Δημιουργήθηκε από %s',

	'QUOTE'					=> 'Παράθεση',

	'PREVIEW'				=> 'Προεπισκόπηση',
	'PREVIOUS'				=> 'Προηγούμενη',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Προηγούμενο βήμα',
	'PRIVACY'				=> 'Πολιτική απορρήτου',
	'PRIVACY_LINK'			=> 'Απόρρητο',
	'PRIVATE_MESSAGE'		=> 'Προσωπικό μήνυμα',
	'PRIVATE_MESSAGES'		=> 'Προσωπικά μηνύματα',
	'PRIVATE_MESSAGING'		=> 'Ανταλλαγή προσωπικών μηνυμάτων',
	'PROFILE'				=> 'Πίνακας Ελέγχου Μέλους',

	'QUICK_LINKS'			=> 'Γρήγορες συνδέσεις',

	'RANK'						=> 'Βαθμός',
	'READING_FORUM'				=> 'Διαβάζει τα θέματα στο %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Διαβάζει γενική ανακοίνωση',
	'READING_LINK'				=> 'Ακολουθεί σύνδεσμο της Δ. Συζήτησης %s',
	'READING_TOPIC'				=> 'Διαβάζει θέμα στο %s',
	'READ_PROFILE'				=> 'Προφίλ',
	'REASON'					=> 'Λόγος',
	'RECORD_ONLINE_USERS'		=> 'Περισσότερα μέλη σε σύνδεση <strong>%1$s</strong> την %2$s',
	'REDIRECT'					=> 'Ανακατεύθυνση',
	'REDIRECTS'					=> 'Σύνολο ανακατευθύνσεων',
	'REGISTER'					=> 'Εγγραφή',
	'REGISTERED_USERS'			=> 'Εγγεγραμμένα μέλη:',
	// "... and 2 hidden users online"
	'REG_USERS_ONLINE'			=> array(
		1	=> 'Υπάρχει %1$d εγγεγραμμένο μέλος και %2$s σε σύνδεση',
		2	=> 'Υπάρχουν %1$d εγγεγραμμένα μέλη και %2$s σε σύνδεση',
	),
	'REG_USERS_TOTAL'			=> array(
		1	=> '%d εγγεγραμμένο',
		2	=> '%d εγγεγραμμένα',
	),
	'REMOVE'					=> 'Διαγραφή',
	'REMOVE_INSTALL'			=> 'Παρακαλώ να διαγράψετε, να μετακινήσετε ή να μετονομάσετε τον κατάλογο εγκατάστασης (install) πριν χρησιμοποιήσετε το σύστημα συζητήσεών σας. Εάν αυτός ο κατάλογος εξακολουθεί να υπάρχει, θα είναι προσβάσιμος μόνο ο Πίνακας Ελέγχου Διαχείρισης (ΠΕΔ).',
	'REPLIES'					=> 'Απαντήσεις',
	'REPLY_WITH_QUOTE'			=> 'Απάντηση με παράθεση',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Απαντάει σε γενική ανακοίνωση',
	'REPLYING_MESSAGE'			=> 'Απαντάει σε μήνυμα στο %s',
	'REPORT_BY'					=> 'Αναφορά από',
	'REPORT_POST'				=> 'Αναφέρετε αυτή τη δημοσίευση',
	'REPORTING_POST'			=> 'Αναφέρει μια δημοσίευση',
	'RESEND_ACTIVATION'			=> 'Αποστολή μηνύματος ηλεκτρονικού ταχυδρομείου ενεργοποίησης πάλι',
	'RESET'						=> 'Επαναφορά',
	'RESTORE_PERMISSIONS'		=> 'Επαναφορά δικαιωμάτων',
	'RETURN_INDEX'				=> '%sΕπιστροφή στη σελίδα ευρετηρίου%s',
	'RETURN_FORUM'				=> '%sΕπιστροφή στη Δ. Συζήτηση, που επισκεφτήκατε τελευταία%s',
	'RETURN_PAGE'				=> '%sΕπιστροφή στην προηγούμενη σελίδα%s',
	'RETURN_TOPIC'				=> '%sΕπιστροφή στο θέμα που επισκεφτήκατε τελευταία%s',
	'RETURN_TO'					=> 'Επιστροφή στο “%s”',
	'RETURN_TO_INDEX'			=> 'Επιστροφή στο ευρετήριο',

	'ROUTE_NOT_FOUND'				=> 'Η ζητηθείσα διαδρομή “%s” δε βρέθηκε.',
	'ROUTE_INVALID_MISSING_PARAMS'	=> 'Έχουν περαστεί άκυρες ή ελλειπής παράμετροι για τη διαδρομή “%s”.',

	'FEED'						=> 'Τροφοδοσία',
	'FEED_NEWS'					=> 'Νέα',
	'FEED_TOPICS_ACTIVE'		=> 'Ενεργά Θέματα',
	'FEED_TOPICS_NEW'			=> 'Νέα Θέματα',
	'RULES_ATTACH_CAN'			=> '<strong>Μπορείτε</strong> να επισυνάπτετε αρχεία σε αυτή τη Δ. Συζήτηση',
	'RULES_ATTACH_CANNOT'		=> '<strong>Δεν μπορείτε</strong> να επισυνάπτετε αρχεία σε αυτή τη Δ. Συζήτηση',
	'RULES_DELETE_CAN'			=> '<strong>Μπορείτε</strong> να διαγράφετε τις δημοσιεύσεις σας σε αυτή τη Δ. Συζήτηση',
	'RULES_DELETE_CANNOT'		=> '<strong>Δεν μπορείτε</strong> να διαγράφετε τις δημοσιεύσεις σας σε αυτή τη Δ. Συζήτηση',
	'RULES_DOWNLOAD_CAN'		=> '<strong>Μπορείτε</strong> να μεταφορτώνετε συνημμένα αρχεία σε αυτή τη Δ. Συζήτηση',
	'RULES_DOWNLOAD_CANNOT'		=> '<strong>Δεν μπορείτε</strong> να μεταφορτώνετε συνημμένα αρχεία σε αυτή τη Δ. Συζήτηση',
	'RULES_EDIT_CAN'			=> '<strong>Μπορείτε</strong> να επεξεργάζεστε τις δημοσιεύσεις σας σε αυτή τη Δ. Συζήτηση',
	'RULES_EDIT_CANNOT'			=> '<strong>Δεν μπορείτε</strong> να επεξεργάζεστε τις δημοσιεύσεις σας σε αυτή τη Δ. Συζήτηση',
	'RULES_LOCK_CAN'			=> '<strong>Μπορείτε</strong> να κλειδώνετε τα θέματά σας σε αυτή τη Δ. Συζήτηση',
	'RULES_LOCK_CANNOT'			=> '<strong>Δεν μπορείτε</strong> να κλειδώνετε τα θέματά σας σε αυτή τη Δ. Συζήτηση',
	'RULES_POST_CAN'			=> '<strong>Μπορείτε</strong> να δημοσιεύετε νέα θέματα σε αυτή τη Δ. Συζήτηση',
	'RULES_POST_CANNOT'			=> '<strong>Δεν μπορείτε</strong> να δημοσιεύετε νέα θέματα σε αυτή τη Δ. Συζήτηση',
	'RULES_REPLY_CAN'			=> '<strong>Μπορείτε</strong> να απαντάτε σε θέματα σε αυτή τη Δ. Συζήτηση',
	'RULES_REPLY_CANNOT'		=> '<strong>Δεν μπορείτε</strong> να απαντάτε σε θέματα σε αυτή τη Δ. Συζήτηση',
	'RULES_VOTE_CAN'			=> '<strong>Μπορείτε</strong> να ψηφίζετε σε δημοψηφίσματα σε αυτή τη Δ. Συζήτηση',
	'RULES_VOTE_CANNOT'			=> '<strong>Δεν μπορείτε</strong> να ψηφίζετε σε δημοψηφίσματα σε αυτή τη Δ. Συζήτηση',

	'SEARCH'					=> 'Αναζήτηση',
	'SEARCH_MINI'				=> 'Αναζήτηση…',
	'SEARCH_ADV'				=> 'Ειδική αναζήτηση',
	'SEARCH_ADV_EXPLAIN'		=> 'Δείτε τις επιλογές ειδικής αναζήτησης',
	'SEARCH_KEYWORDS'			=> 'Αναζήτηση για λέξεις-κλειδιά',
	'SEARCHING_FORUMS'			=> 'Αναζήτηση στις Δ. Συζητήσεις',
	'SEARCH_ACTIVE_TOPICS'		=> 'Ενεργά θέματα',
	'SEARCH_FOR'				=> 'Αναζήτηση για',
	'SEARCH_FORUM'				=> 'Αναζητήστε σε αυτή τη Δ. Συζήτηση…',
	'SEARCH_NEW'				=> 'Νέες δημοσιεύσεις',
	'SEARCH_POSTS_BY'			=> 'Αναζητήστε δημοσιεύσεις από',
	'SEARCH_SELF'				=> 'Οι δημοσιεύσεις σας',
	'SEARCH_TOPIC'				=> 'Αναζητήστε στο θέμα…',
	'SEARCH_UNANSWERED'			=> 'Αναπάντητα θέματα',
	'SEARCH_UNREAD'				=> 'Μη αναγνωσμένες δημοσιεύσεις',
	'SEARCH_USER_POSTS'			=> 'Αναζήτηση δημοσιεύσεων μέλους',
	'SECONDS'					=> 'Δευτερόλεπτα',
	'SEE_ALL'					=> 'Προβολή όλων',
	'SELECT'					=> 'Επιλογή',
	'SELECT_ALL_CODE'			=> 'Επιλογή όλων',
	'SELECT_DESTINATION_FORUM'	=> 'Παρακαλώ επιλέξτε τη Δ. Συζήτηση προορισμού',
	'SELECT_FORUM'				=> 'Επιλέξτε μια Δ. Συζήτηση',
	'SEND_EMAIL'				=> 'Αποστολή μηνύματος ηλεκτρονικού ταχυδρομείου',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Αποστολή μηνύματος ηλεκτρονικού ταχυδρομείου προς %s',
	'SEND_PRIVATE_MESSAGE'		=> 'Αποστολή προσωπικού μηνύματος',
	'SETTINGS'					=> 'Ρυθμίσεις',
	'SIGNATURE'					=> 'Υπογραφή',
	'SKIP'						=> 'Μετάβαση στο περιεχόμενο',
	'SKYPE'						=> 'Skype',
	'SMTP_NO_AUTH_SUPPORT'		=> 'Ο διακομιστής SMTP δεν υποστηρίζει πιστοποίηση.',
	'SORRY_AUTH_READ'			=> 'Δεν είστε εξουσιοδοτημένος (-η) να αναγνώσετε αυτή τη Δ. Συζήτηση.',
	'SORRY_AUTH_READ_TOPIC'		=> 'Δεν είστε εξουσιοδοτημένος (-η) να αναγνώσετε αυτό το θέμα.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Δεν είστε εξουσιοδοτημένος (-η) να μεταφορτώσετε αυτό το συνημμένο.',
	'SORT_BY'					=> 'Ταξινόμηση κατά',
	'SORT_DIRECTION'			=> 'Κατεύθυνση',
	'SORT_JOINED'				=> 'Ημερομηνία ένταξης',
	'SORT_LOCATION'				=> 'Τοποθεσία',
	'SORT_OPTIONS'				=> 'Επιλογές εμφάνισης και ταξινόμησης',
	'SORT_RANK'					=> 'Βαθμός',
	'SORT_POSTS'				=> 'Δημοσιεύσεις',
	'SORT_TOPIC_TITLE'			=> 'Τίτλος θέματος',
	'SORT_USERNAME'				=> 'Όνομα μέλους',
	'SPLIT_TOPIC'				=> 'Διαχωρισμός θέματος',
	'SQL_ERROR_OCCURRED'		=> 'Ένα λάθος στη βάση δεδομένων παρουσιάστηκε κατά την ανάκτηση αυτής της σελίδας. Παρακαλώ ενημερώστε τον %sΔιαχειριστή της Δ. Συζήτησης%s εάν το πρόβλημα εξακολουθεί να υφίσταται.',
	'STATISTICS'				=> 'Στατιστικά',
	'START_WATCHING_FORUM'		=> 'Έναρξη συνδρομής Δ. Συζήτησης',
	'START_WATCHING_TOPIC'		=> 'Έναρξη συνδρομής θέματος',
	'STOP_WATCHING_FORUM'		=> 'Διακοπή συνδρομής Δ. Συζήτησης',
	'STOP_WATCHING_TOPIC'		=> 'Διακοπή συνδρομής θέματος',
	'STRING_LIST_MULTI'			=> '%1$s, και %2$s',
	'STRING_LIST_SIMPLE'		=> '%1$s και %2$s',
	'SUBFORUM'					=> 'Υπο-συζήτηση',
	'SUBFORUMS'					=> 'Υπο-συζητήσεις',
	'SUBJECT'					=> 'Θέμα',
	'SUBMIT'					=> 'Υποβολή',

	'TB'						=> 'TB',
	'TERMS_LINK'				=> 'Όροι',
	'TERMS_USE'					=> 'Όροι χρήσης',
	'TEST_CONNECTION'			=> 'Έλεγχος σύνδεσης',
	'THE_TEAM'					=> 'Η ομάδα',
	'TIB'						=> 'TiB',
	'TIME'						=> 'Ώρα',
	'TIMEOUT_PROCESSING_REQ'	=> 'Λήξη χρόνου αιτήματος.',

	'TOO_LARGE'						=> 'Η τιμή που εισάγατε είναι πολύ μεγάλη.',
	'TOO_LARGE_MAX_RECIPIENTS'		=> 'Η τιμή της ρύθμισης <strong>Μέγιστος αριθμός παραληπτών ανά προσωπικό μήνυμα</strong> που εισάγατε είναι πολύ μεγάλη.',

	'TOO_LONG'						=> 'Η τιμή που εισάγατε είναι μεγάλη.',

	'TOO_LONG_CONFIRM_CODE'			=> 'Ο κωδικός επιβεβαίωσης που εισάγατε είναι πολύ μεγάλος.',
	'TOO_LONG_DATEFORMAT'			=> 'Η μορφή ημερομηνίας που εισάγατε είναι πολύ μεγάλη.',
	'TOO_LONG_JABBER'				=> 'Το όνομα λογαριασμού Jabber που εισάγατε είναι πολύ μεγάλο.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Ο κωδικός πρόσβασης που εισάγατε είναι πολύ μεγάλος.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Η επιβεβαίωση του κωδικού πρόσβασης που εισάγατε είναι πολύ μεγάλη.',
	'TOO_LONG_USER_PASSWORD'		=> 'Ο κωδικός πρόσβασης που εισάγατε είναι πολύ μεγάλος.',
	'TOO_LONG_USERNAME'				=> 'Το όνομα μέλους που εισάγατε είναι πολύ μεγάλο.',
	'TOO_LONG_EMAIL'				=> 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου που εισάγατε είναι πολύ μεγάλη.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Προσπαθήσατε να ψηφίσετε για πάρα πολλές επιλογές.',

	'TOO_SHORT'						=> 'Η τιμή που εισάγατε είναι μικρή.',

	'TOO_SHORT_CONFIRM_CODE'		=> 'Ο κωδικός επιβεβαίωσης που εισάγατε είναι πολύ μικρός.',
	'TOO_SHORT_DATEFORMAT'			=> 'Η μορφή ημερομηνίας που εισάγατε είναι πολύ μικρή.',
	'TOO_SHORT_JABBER'				=> 'Το όνομα λογαριασμού Jabber που εισάγατε είναι πολύ μικρό.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Ο κωδικός πρόσβασης που εισάγατε είναι πολύ μικρός.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Η επιβεβαίωση του κωδικού πρόσβασης που εισάγατε είναι πολύ μικρή.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Ο κωδικός πρόσβασης που εισάγατε είναι πολύ μικρός.',
	'TOO_SHORT_USERNAME'			=> 'Το όνομα μέλους που εισάγατε είναι πολύ μικρό.',
	'TOO_SHORT_EMAIL'				=> 'Η διεύθυνση ηλεκτρονικού ταχυδρομείου που εισάγατε είναι πολύ μικρή.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Η επιβεβαίωση της διεύθυνσης ηλεκτρονικού ταχυδρομείου που εισάγατε είναι πολύ μικρή.',
	'TOO_SMALL'						=> 'Η τιμή που εισάγατε είναι μικρή.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> 'Η τιμή της ρύθμισης <strong>Μέγιστος αριθμός παραληπτών ανά προσωπικό μήνυμα</strong> που εισάγατε είναι πολύ μικρή.',

	'TOPIC'				=> 'Θέμα',
	'TOPICS'			=> 'Θέματα',
	'TOPICS_UNAPPROVED'	=> 'Τουλάχιστον ένα θέμα σε αυτή τη Δ. Συζήτηση δεν έχει εγκριθεί.',
	'TOPIC_ICON'		=> 'Εικονίδιο θέματος',
	'TOPIC_LOCKED'		=> 'Αυτό το θέμα είναι κλειδωμένο, δεν μπορείτε να επεξεργαστείτε δημοσιεύσεις ή να προβείτε σε περαιτέρω απαντήσεις.',
	'TOPIC_LOCKED_SHORT'=> 'Το θέμα κλειδώθηκε',
	'TOPIC_MOVED'		=> 'Το Θέμα μετακινήθηκε',
	'TOPIC_REVIEW'		=> 'Περίληψη Θέματος',
	'TOPIC_TITLE'		=> 'Τίτλος θέματος',
	'TOPIC_UNAPPROVED'	=> 'Αυτό το θέμα δεν εγκρίθηκε',
	'TOPIC_UNAPPROVED_FORUM'	=> array(
		1	=> 'Θέμα σε αναμονή έγγρισης',
		2	=> 'Θέματα σε αναμονή έγγρισης',
	),
	'TOPIC_DELETED'		=> 'Αυτή η δημοσίευση διαγράφηκε.',
	'TOTAL_ATTACHMENTS'	=> 'Συνημμένο(α)',
	'TOTAL_LOGS'		=> array(
		1	=> '%d αρχείο ιστορικού',
		2	=> '%d αρχεία ιστορικού',
	),
	'TOTAL_PMS'		=> array(
		1	=> '%d προσωπικό μήνυμα συνολικά',
		2	=> '%d προσωπικά μηνύματα συνολικά',
	),
	'TOPIC_POLL'		=> 'Αυτή η δημοσίευση έχει δημοψήφισμα.',
	'TOTAL_POSTS'		=> 'Συνολικές δημοσιεύσεις',
	'TOTAL_POSTS_COUNT'	=> array(
		2	=> 'Συνολικές δημοσιεύσεις <strong>%d</strong>',
	),
	'TOPIC_REPORTED'	=> 'Αυτό το θέμα έχει αναφερθεί',
	'TOTAL_TOPICS'		=> array(
		2	=> 'Σύνολο θεμάτων <strong>%d</strong>',
	),
	'TOTAL_USERS'		=> array(
		2	=> 'Σύνολο μελών <strong>%d</strong>',
	),
	'TRACKED_PHP_ERROR'	=> 'Εντοπισμένα σφάλματα PHP: %s',
	'TWITTER'			=> 'Twitter',

	'UNABLE_GET_IMAGE_SIZE'		=> 'Δεν ήταν δυνατόν να προσδιοριστούν οι διαστάσεις της εικόνας. Παρακαλώ επαληθεύστε ότι ο σύνδεσμος (URL) που εισάγατε είναι σωστός.',
	'UNABLE_TO_DELIVER_FILE'	=> 'Αδυναμία παράδοσης αρχείου.',
	'UNKNOWN_BROWSER'			=> 'Άγνωστο πρόγραμμα περιήγησης',
	'UNMARK_ALL'				=> 'Εξαίρεση όλων',
	'UNREAD_MESSAGES'			=> 'Μη αναγνωσμένα μηνύματα',
	'UNREAD_POST'				=> 'Μη αναγνωσμένη δημοσίευση',
	'UNREAD_POSTS'				=> 'Μη αναγνωσμένες δημοσιεύσεις',
	'UNWATCH_FORUM_CONFIRM'		=> 'Είστε σίγουρος (-η) ότι επιθυμείτε να διακόψετε τη συνδρομή από αυτή τη Δ. Συζήτηση;',
	'UNWATCH_FORUM_DETAILED'	=> 'Είστε σίγουρος (-η) ότι επιθυμείτε να διακόψετε τη συνδρομή από τη Δ. Συζήτηση “%s”;',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Είστε σίγουρος (-η) ότι επιθυμείτε να διακόψετε τη συνδρομή από αυτό το θέμα;',
	'UNWATCH_TOPIC_DETAILED'	=> 'Είστε σίγουρος (-η) ότι επιθυμείτε να διακόψετε τη συνδρομή από το θέμα “%s”;',
	'UNWATCHED_FORUMS'			=> 'Δεν είστε πλέον συνδρομητής στις επιλεγμένες Δ. Συζητήσεις.',
	'UNWATCHED_TOPICS'			=> 'Δεν είστε πλέον συνδρομητής στα επιλεγμένα θέματα.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Δεν είστε πλέον συνδρομητής στις επιλεγμένες καταχωρήσεις.',
	'UPDATE'					=> 'Ενημέρωση',
	'UPLOAD_IN_PROGRESS'		=> 'Η αποστολή του αρχείου βρίσκεται σε εξέλιξη.',
	'URL_REDIRECT'				=> 'Εάν το πρόγραμμα περιήγησής σας δεν υποστηρίζει ανακατεύθυνση meta %sπαρακαλώ πατήστε ΕΔΩ για να μεταφερθείτε%s.',
	'USERGROUPS'				=> 'Ομάδες',
	'USERNAME'					=> 'Όνομα μέλους',
	'USERNAMES'					=> 'Ονόματα μελών',
	'USER_AVATAR'				=> 'Άβαταρ μέλους',
	'USER_CANNOT_READ'			=> 'Δεν μπορείτε να αναγνώσετε δημοσιεύσεις σε αυτή τη Δ. Συζήτηση',
	'USER_POSTS'				=> array(
		1	=> '%d δημοσίευση',
		2	=> '%d δημοσιεύσεις',
	),
	'USERS'						=> 'Μέλη',
	'USE_PERMISSIONS'			=> 'Δοκιμάστε τα δικαιώματα του μέλους',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Λυπόμαστε, αλλά δεν έχετε εξουσιοδότηση για να χρησιμοποιήσετε αυτό το χαρακτηριστικό. Μπορεί να έχετε μόλις εγγραφεί εδώ και πρέπει να συμμετέχετε περισσότερο στις συζητήσεις για να είστε σε θέση να χρησιμοποιήσετε αυτό το χαρακτηριστικό.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Προβολές',
	'VIEWED_COUNTS'		=> array(
		0	=> 'Καμία προβολή ακόμη',
		1	=> 'Προβλήθηκε %d φορά',
		2	=> 'Προβλήθηκε %d φορές',
	),
	'VIEWING_CONTACT_ADMIN'		=> 'Βλέπει τη σελίδα επικοινωνίας',
	'VIEWING_FAQ'				=> 'Βλέπει τις Συχνές ερωτήσεις',
	'VIEWING_MEMBERS'			=> 'Βλέπει τις λεπτομέρειες μέλους',
	'VIEWING_ONLINE'			=> 'Βλέπει τα μέλη σε σύνδεση',
	'VIEWING_MCP'				=> 'Βλέπει τον πίνακα ελέγχου συντονιστή',
	'VIEWING_MEMBER_PROFILE'	=> 'Βλέπει το προφίλ μέλους',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Βλέπει τα προσωπικά μηνύματα',
	'VIEWING_REGISTER'			=> 'Δημιουργεί λογαριασμό',
	'VIEWING_UCP'				=> 'Βλέπει τον πίνακα ελέγχου μέλους',
	'VIEWS'						=> 'Προβολές',
	'VIEW_BOOKMARKS'			=> 'Προβολή σελιδοδεικτών,',
	'VIEW_FORUM_LOGS'			=> 'Προβολή ιστορικού Δ. Συζήτησης',
	'VIEW_LATEST_POST'			=> 'Προβολή της τελευταίας δημοσίευσης',
	'VIEW_NEWEST_POST'			=> 'Προβολή πρώτης μη αναγνωσμένης δημοσίευσης',
	'VIEW_NOTES'				=> 'Προβολή σημειώσεων μέλους',
	'VIEW_ONLINE_TIMES'			=> array(
		1	=> 'με βάση τα μέλη που ήταν ενεργά το τελευταίο %d λεπτό',
		2	=> 'με βάση τα μέλη που ήταν ενεργά τα τελευταία %d λεπτά',
	),
	'VIEW_TOPIC'				=> 'Προβολή θέματος',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Ανακοίνωση: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Γενική ανακοίνωση: ',
	'VIEW_TOPIC_LOCKED'			=> 'Κλειδωμένο: ',
	'VIEW_TOPIC_LOGS'			=> 'Προβολή ιστορικού',
	'VIEW_TOPIC_MOVED'			=> 'Μετακινήθηκε ',
	'VIEW_TOPIC_POLL'			=> 'Δημοψήφισμα: ',
	'VIEW_TOPIC_STICKY'			=> 'Σημείωση: ',
	'VISIT_WEBSITE'				=> 'Επίσκεψη ιστοσελίδας',

	'WARNINGS'				=> 'Προειδοποιήσεις',
	'WARN_USER'				=> 'Προειδοποιήστε μέλος',
	'WATCH_FORUM_CONFIRM'	=> 'Είστε σίγουρος (-η) ότι επιθυμείτε συνδρομή σε αυτή τη Δ. Συζήτηση;',
	'WATCH_FORUM_DETAILED'	=> 'Είστε σίγουρος (-η) ότι επιθυμείτε συνδρομή στη Δ. Συζήτηση “%s”;',
	'WATCH_TOPIC_CONFIRM'	=> 'Είστε σίγουρος (-η) ότι επιθυμείτε συνδρομή σε αυτό το θέμα;',
	'WATCH_TOPIC_DETAILED'	=> 'Είστε σίγουρος (-η) ότι επιθυμείτε συνδρομή στο θέμα “%s”;',
	'WELCOME_SUBJECT'		=> 'Καλώς ήρθατε στο %s',
	'WEBSITE'				=> 'Ιστοσελίδα',
	'WHOIS'					=> 'Ποιος',
	'WHO_IS_ONLINE'			=> 'Μέλη σε σύνδεση',
	'WRONG_PASSWORD'		=> 'Ο κωδικός πρόσβασης που εισάγατε είναι λάθος.',

	'WRONG_DATA_COLOUR'		=> 'Η τιμή του χρώματος που εισάγατε είναι άκυρη.',
	'WRONG_DATA_JABBER'		=> 'Το όνομα που εισάγατε δεν είναι ένα έγκυρο όνομα λογαριασμού Jabber.',
	'WRONG_DATA_LANG'		=> 'Η γλώσσα που καθορίσατε δεν είναι έγκυρη.',
	'WRONG_DATA_POST_SD'	=> 'Η κατεύθυνση ταξινόμησης δημοσίευσης που καθορίσατε δεν είναι έγκυρη.',
	'WRONG_DATA_POST_SK'	=> 'Η επιλογή ταξινόμησης δημοσίευσης που καθορίσατε δεν είναι έγκυρη.',
	'WRONG_DATA_TOPIC_SD'	=> 'Η κατεύθυνση ταξινόμησης θέματος που καθορίσατε δεν είναι έγκυρη.',
	'WRONG_DATA_TOPIC_SK'	=> 'Η επιλογή ταξινόμησης θέματος που καθορίσατε δεν είναι έγκυρη.',
	'WROTE'					=> 'έγραψε',

	'YAHOO'				=> 'Yahoo Messenger',
	'YOUTUBE'			=> 'YouTube',
	'YEAR'				=> 'Χρόνος',
	'YEAR_MONTH_DAY'	=> '(ΕΕΕΕ-ΜΜ-ΗΗ)',
	'YES'				=> 'Ναι',
	'YOU_LAST_VISIT'	=> 'Τελευταία επίσκεψη: %s',

	'datetime'			=> array(
		'TODAY'		=> 'Σήμερα',
		'TOMORROW'	=> 'Αύριο',
		'YESTERDAY'	=> 'Χθες',
		'AGO'		=> array(
			0		=> 'λιγότερο από 1 λεπτό πριν',
			1		=> '%d λεπτό πριν',
			2		=> '%d λεπτά πριν',
		),

		'Sunday'	=> 'Κυριακή',
		'Monday'	=> 'Δευτέρα',
		'Tuesday'	=> 'Τρίτη',
		'Wednesday'	=> 'Τετάρτη',
		'Thursday'	=> 'Πέμπτη',
		'Friday'	=> 'Παρασκευή',
		'Saturday'	=> 'Σάββατο',

		'Sun'		=> 'Κυρ',
		'Mon'		=> 'Δευ',
		'Tue'		=> 'Τρί',
		'Wed'		=> 'Τετ',
		'Thu'		=> 'Πέμ',
		'Fri'		=> 'Παρ',
		'Sat'		=> 'Σάβ',

		'January'	=> 'Ιανουάριος',
		'February'	=> 'Φεβρουάριος',
		'March'		=> 'Μάρτιος',
		'April'		=> 'Απρίλιος',
		'May'		=> 'Μάιος',
		'June'		=> 'Ιούνιος',
		'July'		=> 'Ιούλιος',
		'August'	=> 'Αύγουστος',
		'September' => 'Σεπτέμβριος',
		'October'	=> 'Οκτώβριος',
		'November'	=> 'Νοέμβριος',
		'December'	=> 'Δεκέμβριος',

		'Jan'		=> 'Ιαν',
		'Feb'		=> 'Φεβ',
		'Mar'		=> 'Μαρ',
		'Apr'		=> 'Απρ',
		'May_short'	=> 'Μάιος',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Ιουν',
		'Jul'		=> 'Ιούλ',
		'Aug'		=> 'Αύγ',
		'Sep'		=> 'Σεπ',
		'Oct'		=> 'Οκτ',
		'Nov'		=> 'Νοέμ',
		'Dec'		=> 'Δεκ',
	),

	// Timezones can be translated. We use this for the Etc/GMT timezones here,
	// because they are named invers to their offset.
	'timezones'		=> array(
		'UTC'					=> 'UTC',
		'UTC_OFFSET'			=> 'UTC%1$s',
		'UTC_OFFSET_CURRENT'	=> 'UTC%1$s - %2$s',

		'Etc/GMT-12'	=> 'GMT+12',
		'Etc/GMT-11'	=> 'GMT+11',
		'Etc/GMT-10'	=> 'GMT+10',
		'Etc/GMT-9'		=> 'GMT+9',
		'Etc/GMT-8'		=> 'GMT+8',
		'Etc/GMT-7'		=> 'GMT+7',
		'Etc/GMT-6'		=> 'GMT+6',
		'Etc/GMT-5'		=> 'GMT+5',
		'Etc/GMT-4'		=> 'GMT+4',
		'Etc/GMT-3'		=> 'GMT+3',
		'Etc/GMT-2'		=> 'GMT+2',
		'Etc/GMT-1'		=> 'GMT+1',
		'Etc/GMT+1'		=> 'GMT-1',
		'Etc/GMT+2'		=> 'GMT-2',
		'Etc/GMT+3'		=> 'GMT-3',
		'Etc/GMT+4'		=> 'GMT-4',
		'Etc/GMT+5'		=> 'GMT-5',
		'Etc/GMT+6'		=> 'GMT-6',
		'Etc/GMT+7'		=> 'GMT-7',
		'Etc/GMT+8'		=> 'GMT-8',
		'Etc/GMT+9'		=> 'GMT-9',
		'Etc/GMT+10'	=> 'GMT-10',
		'Etc/GMT+11'	=> 'GMT-11',
		'Etc/GMT+12'	=> 'GMT-12',

		'Africa/Abidjan'		=> 'Africa/Abidjan',
		'Africa/Accra'			=> 'Africa/Accra',
		'Africa/Addis_Ababa'	=> 'Africa/Addis Ababa',
		'Africa/Algiers'		=> 'Africa/Algiers',
		'Africa/Asmara'			=> 'Africa/Asmara',
		'Africa/Bamako'			=> 'Africa/Bamako',
		'Africa/Bangui'			=> 'Africa/Bangui',
		'Africa/Banjul'			=> 'Africa/Banjul',
		'Africa/Bissau'			=> 'Africa/Bissau',
		'Africa/Blantyre'		=> 'Africa/Blantyre',
		'Africa/Brazzaville'	=> 'Africa/Brazzaville',
		'Africa/Bujumbura'		=> 'Africa/Bujumbura',
		'Africa/Cairo'			=> 'Africa/Cairo',
		'Africa/Casablanca'		=> 'Africa/Casablanca',
		'Africa/Ceuta'			=> 'Africa/Ceuta',
		'Africa/Conakry'		=> 'Africa/Conakry',
		'Africa/Dakar'			=> 'Africa/Dakar',
		'Africa/Dar_es_Salaam'	=> 'Africa/Dar es Salaam',
		'Africa/Djibouti'		=> 'Africa/Djibouti',
		'Africa/Douala'			=> 'Africa/Douala',
		'Africa/El_Aaiun'		=> 'Africa/El Aaiun',
		'Africa/Freetown'		=> 'Africa/Freetown',
		'Africa/Gaborone'		=> 'Africa/Gaborone',
		'Africa/Harare'			=> 'Africa/Harare',
		'Africa/Johannesburg'	=> 'Africa/Johannesburg',
		'Africa/Juba'			=> 'Africa/Juba',
		'Africa/Kampala'		=> 'Africa/Kampala',
		'Africa/Khartoum'		=> 'Africa/Khartoum',
		'Africa/Kigali'			=> 'Africa/Kigali',
		'Africa/Kinshasa'		=> 'Africa/Kinshasa',
		'Africa/Lagos'			=> 'Africa/Lagos',
		'Africa/Libreville'		=> 'Africa/Libreville',
		'Africa/Lome'			=> 'Africa/Lome',
		'Africa/Luanda'			=> 'Africa/Luanda',
		'Africa/Lubumbashi'		=> 'Africa/Lubumbashi',
		'Africa/Lusaka'			=> 'Africa/Lusaka',
		'Africa/Malabo'			=> 'Africa/Malabo',
		'Africa/Maputo'			=> 'Africa/Maputo',
		'Africa/Maseru'			=> 'Africa/Maseru',
		'Africa/Mbabane'		=> 'Africa/Mbabane',
		'Africa/Mogadishu'		=> 'Africa/Mogadishu',
		'Africa/Monrovia'		=> 'Africa/Monrovia',
		'Africa/Nairobi'		=> 'Africa/Nairobi',
		'Africa/Ndjamena'		=> 'Africa/Ndjamena',
		'Africa/Niamey'			=> 'Africa/Niamey',
		'Africa/Nouakchott'		=> 'Africa/Nouakchott',
		'Africa/Ouagadougou'	=> 'Africa/Ouagadougou',
		'Africa/Porto-Novo'		=> 'Africa/Porto-Novo',
		'Africa/Sao_Tome'		=> 'Africa/Sao Tome',
		'Africa/Tripoli'		=> 'Africa/Tripoli',
		'Africa/Tunis'			=> 'Africa/Tunis',
		'Africa/Windhoek'		=> 'Africa/Windhoek',

		'America/Adak'		=> 'America/Adak',
		'America/Anchorage'	=> 'America/Anchorage',
		'America/Anguilla'	=> 'America/Anguilla',
		'America/Antigua'	=> 'America/Antigua',
		'America/Araguaina'	=> 'America/Araguaina',

		'America/Argentina/Buenos_Aires'	=> 'America/Argentina/Buenos Aires',
		'America/Argentina/Catamarca'		=> 'America/Argentina/Catamarca',
		'America/Argentina/Cordoba'			=> 'America/Argentina/Cordoba',
		'America/Argentina/Jujuy'			=> 'America/Argentina/Jujuy',
		'America/Argentina/La_Rioja'		=> 'America/Argentina/La Rioja',
		'America/Argentina/Mendoza'			=> 'America/Argentina/Mendoza',
		'America/Argentina/Rio_Gallegos'	=> 'America/Argentina/Rio Gallegos',
		'America/Argentina/Salta'			=> 'America/Argentina/Salta',
		'America/Argentina/San_Juan'		=> 'America/Argentina/San Juan',
		'America/Argentina/San_Luis'		=> 'America/Argentina/San Luis',
		'America/Argentina/Tucuman'			=> 'America/Argentina/Tucuman',
		'America/Argentina/Ushuaia'			=> 'America/Argentina/Ushuaia',

		'America/Aruba'						=> 'America/Aruba',
		'America/Asuncion'					=> 'America/Asuncion',
		'America/Atikokan'					=> 'America/Atikokan',
		'America/Bahia'						=> 'America/Bahia',
		'America/Bahia_Banderas'			=> 'America/Bahia Banderas',
		'America/Barbados'					=> 'America/Barbados',
		'America/Belem'						=> 'America/Belem',
		'America/Belize'					=> 'America/Belize',
		'America/Blanc-Sablon'				=> 'America/Blanc-Sablon',
		'America/Boa_Vista'					=> 'America/Boa Vista',
		'America/Bogota'					=> 'America/Bogota',
		'America/Boise'						=> 'America/Boise',
		'America/Cambridge_Bay'				=> 'America/Cambridge Bay',
		'America/Campo_Grande'				=> 'America/Campo Grande',
		'America/Cancun'					=> 'America/Cancun',
		'America/Caracas'					=> 'America/Caracas',
		'America/Cayenne'					=> 'America/Cayenne',
		'America/Cayman'					=> 'America/Cayman',
		'America/Chicago'					=> 'America/Chicago',
		'America/Chihuahua'					=> 'America/Chihuahua',
		'America/Costa_Rica'				=> 'America/Costa Rica',
		'America/Creston'					=> 'America/Creston',
		'America/Cuiaba'					=> 'America/Cuiaba',
		'America/Curacao'					=> 'America/Curacao',
		'America/Danmarkshavn'				=> 'America/Danmarkshavn',
		'America/Dawson'					=> 'America/Dawson',
		'America/Dawson_Creek'				=> 'America/Dawson Creek',
		'America/Denver'					=> 'America/Denver',
		'America/Detroit'					=> 'America/Detroit',
		'America/Dominica'					=> 'America/Dominica',
		'America/Edmonton'					=> 'America/Edmonton',
		'America/Eirunepe'					=> 'America/Eirunepe',
		'America/El_Salvador'				=> 'America/El Salvador',
		'America/Fortaleza'					=> 'America/Fortaleza',
		'America/Glace_Bay'					=> 'America/Glace Bay',
		'America/Godthab'					=> 'America/Godthab',
		'America/Goose_Bay'					=> 'America/Goose Bay',
		'America/Grand_Turk'				=> 'America/Grand Turk',
		'America/Grenada'					=> 'America/Grenada',
		'America/Guadeloupe'				=> 'America/Guadeloupe',
		'America/Guatemala'					=> 'America/Guatemala',
		'America/Guayaquil'					=> 'America/Guayaquil',
		'America/Guyana'					=> 'America/Guyana',
		'America/Halifax'					=> 'America/Halifax',
		'America/Havana'					=> 'America/Havana',
		'America/Hermosillo'				=> 'America/Hermosillo',
		'America/Indiana/Indianapolis'		=> 'America/Indiana/Indianapolis',
		'America/Indiana/Knox'				=> 'America/Indiana/Knox',
		'America/Indiana/Marengo'			=> 'America/Indiana/Marengo',
		'America/Indiana/Petersburg'		=> 'America/Indiana/Petersburg',
		'America/Indiana/Tell_City'			=> 'America/Indiana/Tell City',
		'America/Indiana/Vevay'				=> 'America/Indiana/Vevay',
		'America/Indiana/Vincennes'			=> 'America/Indiana/Vincennes',
		'America/Indiana/Winamac'			=> 'America/Indiana/Winamac',
		'America/Inuvik'					=> 'America/Inuvik',
		'America/Iqaluit'					=> 'America/Iqaluit',
		'America/Jamaica'					=> 'America/Jamaica',
		'America/Juneau'					=> 'America/Juneau',
		'America/Kentucky/Louisville'		=> 'America/Kentucky/Louisville',
		'America/Kentucky/Monticello'		=> 'America/Kentucky/Monticello',
		'America/Kralendijk'				=> 'America/Kralendijk',
		'America/La_Paz'					=> 'America/La Paz',
		'America/Lima'						=> 'America/Lima',
		'America/Los_Angeles'				=> 'America/Los Angeles',
		'America/Lower_Princes'				=> 'America/Lower Princes',
		'America/Maceio'					=> 'America/Maceio',
		'America/Managua'					=> 'America/Managua',
		'America/Manaus'					=> 'America/Manaus',
		'America/Marigot'					=> 'America/Marigot',
		'America/Martinique'				=> 'America/Martinique',
		'America/Matamoros'					=> 'America/Matamoros',
		'America/Mazatlan'					=> 'America/Mazatlan',
		'America/Menominee'					=> 'America/Menominee',
		'America/Merida'					=> 'America/Merida',
		'America/Metlakatla'				=> 'America/Metlakatla',
		'America/Mexico_City'				=> 'America/Mexico City',
		'America/Miquelon'					=> 'America/Miquelon',
		'America/Moncton'					=> 'America/Moncton',
		'America/Monterrey'					=> 'America/Monterrey',
		'America/Montevideo'				=> 'America/Montevideo',
		'America/Montreal'					=> 'America/Montreal',
		'America/Montserrat'				=> 'America/Montserrat',
		'America/Nassau'					=> 'America/Nassau',
		'America/New_York'					=> 'America/New York',
		'America/Nipigon'					=> 'America/Nipigon',
		'America/Nome'						=> 'America/Nome',
		'America/Noronha'					=> 'America/Noronha',
		'America/North_Dakota/Beulah'		=> 'America/North Dakota/Beulah',
		'America/North_Dakota/Center'		=> 'America/North Dakota/Center',
		'America/North_Dakota/New_Salem'	=> 'America/North Dakota/New Salem',
		'America/Ojinaga'					=> 'America/Ojinaga',
		'America/Panama'					=> 'America/Panama',
		'America/Pangnirtung'				=> 'America/Pangnirtung',
		'America/Paramaribo'				=> 'America/Paramaribo',
		'America/Phoenix'					=> 'America/Phoenix',
		'America/Port-au-Prince'			=> 'America/Port-au-Prince',
		'America/Port_of_Spain'				=> 'America/Port of Spain',
		'America/Porto_Velho'				=> 'America/Porto Velho',
		'America/Puerto_Rico'				=> 'America/Puerto Rico',
		'America/Rainy_River'				=> 'America/Rainy River',
		'America/Rankin_Inlet'				=> 'America/Rankin Inlet',
		'America/Recife'					=> 'America/Recife',
		'America/Regina'					=> 'America/Regina',
		'America/Resolute'					=> 'America/Resolute',
		'America/Rio_Branco'				=> 'America/Rio Branco',
		'America/Santa_Isabel'				=> 'America/Santa Isabel',
		'America/Santarem'					=> 'America/Santarem',
		'America/Santiago'					=> 'America/Santiago',
		'America/Santo_Domingo'				=> 'America/Santo Domingo',
		'America/Sao_Paulo'					=> 'America/Sao Paulo',
		'America/Scoresbysund'				=> 'America/Scoresbysund',
		'America/Shiprock'					=> 'America/Shiprock',
		'America/Sitka'						=> 'America/Sitka',
		'America/St_Barthelemy'				=> 'America/St. Barthelemy',
		'America/St_Johns'					=> 'America/St. Johns',
		'America/St_Kitts'					=> 'America/St. Kitts',
		'America/St_Lucia'					=> 'America/St. Lucia',
		'America/St_Thomas'					=> 'America/St. Thomas',
		'America/St_Vincent'				=> 'America/St. Vincent',
		'America/Swift_Current'				=> 'America/Swift Current',
		'America/Tegucigalpa'				=> 'America/Tegucigalpa',
		'America/Thule'						=> 'America/Thule',
		'America/Thunder_Bay'				=> 'America/Thunder Bay',
		'America/Tijuana'					=> 'America/Tijuana',
		'America/Toronto'					=> 'America/Toronto',
		'America/Tortola'					=> 'America/Tortola',
		'America/Vancouver'					=> 'America/Vancouver',
		'America/Whitehorse'				=> 'America/Whitehorse',
		'America/Winnipeg'					=> 'America/Winnipeg',
		'America/Yakutat'					=> 'America/Yakutat',
		'America/Yellowknife'				=> 'America/Yellowknife',

		'Antarctica/Casey'			=> 'Antarctica/Casey',
		'Antarctica/Davis'			=> 'Antarctica/Davis',
		'Antarctica/DumontDUrville'	=> 'Antarctica/DumontDUrville',
		'Antarctica/Macquarie'		=> 'Antarctica/Macquarie',
		'Antarctica/Mawson'			=> 'Antarctica/Mawson',
		'Antarctica/McMurdo'		=> 'Antarctica/McMurdo',
		'Antarctica/Palmer'			=> 'Antarctica/Palmer',
		'Antarctica/Rothera'		=> 'Antarctica/Rothera',
		'Antarctica/South_Pole'		=> 'Antarctica/South Pole',
		'Antarctica/Syowa'			=> 'Antarctica/Syowa',
		'Antarctica/Vostok'			=> 'Antarctica/Vostok',

		'Arctic/Longyearbyen'	=> 'Arctic/Longyearbyen',

		'Asia/Aden'				=> 'Asia/Aden',
		'Asia/Almaty'			=> 'Asia/Almaty',
		'Asia/Amman'			=> 'Asia/Amman',
		'Asia/Anadyr'			=> 'Asia/Anadyr',
		'Asia/Aqtau'			=> 'Asia/Aqtau',
		'Asia/Aqtobe'			=> 'Asia/Aqtobe',
		'Asia/Ashgabat'			=> 'Asia/Ashgabat',
		'Asia/Baghdad'			=> 'Asia/Baghdad',
		'Asia/Bahrain'			=> 'Asia/Bahrain',
		'Asia/Baku'				=> 'Asia/Baku',
		'Asia/Bangkok'			=> 'Asia/Bangkok',
		'Asia/Beirut'			=> 'Asia/Beirut',
		'Asia/Bishkek'			=> 'Asia/Bishkek',
		'Asia/Brunei'			=> 'Asia/Brunei',
		'Asia/Choibalsan'		=> 'Asia/Choibalsan',
		'Asia/Chongqing'		=> 'Asia/Chongqing',
		'Asia/Colombo'			=> 'Asia/Colombo',
		'Asia/Damascus'			=> 'Asia/Damascus',
		'Asia/Dhaka'			=> 'Asia/Dhaka',
		'Asia/Dili'				=> 'Asia/Dili',
		'Asia/Dubai'			=> 'Asia/Dubai',
		'Asia/Dushanbe'			=> 'Asia/Dushanbe',
		'Asia/Gaza'				=> 'Asia/Gaza',
		'Asia/Harbin'			=> 'Asia/Harbin',
		'Asia/Hebron'			=> 'Asia/Hebron',
		'Asia/Ho_Chi_Minh'		=> 'Asia/Ho Chi Minh',
		'Asia/Hong_Kong'		=> 'Asia/Hong Kong',
		'Asia/Hovd'				=> 'Asia/Hovd',
		'Asia/Irkutsk'			=> 'Asia/Irkutsk',
		'Asia/Jakarta'			=> 'Asia/Jakarta',
		'Asia/Jayapura'			=> 'Asia/Jayapura',
		'Asia/Jerusalem'		=> 'Asia/Jerusalem',
		'Asia/Kabul'			=> 'Asia/Kabul',
		'Asia/Kamchatka'		=> 'Asia/Kamchatka',
		'Asia/Karachi'			=> 'Asia/Karachi',
		'Asia/Kashgar'			=> 'Asia/Kashgar',
		'Asia/Kathmandu'		=> 'Asia/Kathmandu',
		'Asia/Khandyga'			=> 'Asia/Khandyga',
		'Asia/Kolkata'			=> 'Asia/Kolkata',
		'Asia/Krasnoyarsk'		=> 'Asia/Krasnoyarsk',
		'Asia/Kuala_Lumpur'		=> 'Asia/Kuala Lumpur',
		'Asia/Kuching'			=> 'Asia/Kuching',
		'Asia/Kuwait'			=> 'Asia/Kuwait',
		'Asia/Macau'			=> 'Asia/Macau',
		'Asia/Magadan'			=> 'Asia/Magadan',
		'Asia/Makassar'			=> 'Asia/Makassar',
		'Asia/Manila'			=> 'Asia/Manila',
		'Asia/Muscat'			=> 'Asia/Muscat',
		'Asia/Nicosia'			=> 'Asia/Nicosia',
		'Asia/Novokuznetsk'		=> 'Asia/Novokuznetsk',
		'Asia/Novosibirsk'		=> 'Asia/Novosibirsk',
		'Asia/Omsk'				=> 'Asia/Omsk',
		'Asia/Oral'				=> 'Asia/Oral',
		'Asia/Phnom_Penh'		=> 'Asia/Phnom Penh',
		'Asia/Pontianak'		=> 'Asia/Pontianak',
		'Asia/Pyongyang'		=> 'Asia/Pyongyang',
		'Asia/Qatar'			=> 'Asia/Qatar',
		'Asia/Qyzylorda'		=> 'Asia/Qyzylorda',
		'Asia/Rangoon'			=> 'Asia/Rangoon',
		'Asia/Riyadh'			=> 'Asia/Riyadh',
		'Asia/Sakhalin'			=> 'Asia/Sakhalin',
		'Asia/Samarkand'		=> 'Asia/Samarkand',
		'Asia/Seoul'			=> 'Asia/Seoul',
		'Asia/Shanghai'			=> 'Asia/Shanghai',
		'Asia/Singapore'		=> 'Asia/Singapore',
		'Asia/Taipei'			=> 'Asia/Taipei',
		'Asia/Tashkent'			=> 'Asia/Tashkent',
		'Asia/Tbilisi'			=> 'Asia/Tbilisi',
		'Asia/Tehran'			=> 'Asia/Tehran',
		'Asia/Thimphu'			=> 'Asia/Thimphu',
		'Asia/Tokyo'			=> 'Asia/Tokyo',
		'Asia/Ulaanbaatar'		=> 'Asia/Ulaanbaatar',
		'Asia/Urumqi'			=> 'Asia/Urumqi',
		'Asia/Ust-Nera'			=> 'Asia/Ust-Nera',
		'Asia/Vientiane'		=> 'Asia/Vientiane',
		'Asia/Vladivostok'		=> 'Asia/Vladivostok',
		'Asia/Yakutsk'			=> 'Asia/Yakutsk',
		'Asia/Yekaterinburg'	=> 'Asia/Yekaterinburg',
		'Asia/Yerevan'			=> 'Asia/Yerevan',

		'Atlantic/Azores'			=> 'Atlantic/Azores',
		'Atlantic/Bermuda'			=> 'Atlantic/Bermuda',
		'Atlantic/Canary'			=> 'Atlantic/Canary',
		'Atlantic/Cape_Verde'		=> 'Atlantic/Cape Verde',
		'Atlantic/Faroe'			=> 'Atlantic/Faroe',
		'Atlantic/Madeira'			=> 'Atlantic/Madeira',
		'Atlantic/Reykjavik'		=> 'Atlantic/Reykjavik',
		'Atlantic/South_Georgia'	=> 'Atlantic/South Georgia',
		'Atlantic/St_Helena'		=> 'Atlantic/St. Helena',
		'Atlantic/Stanley'			=> 'Atlantic/Stanley',

		'Australia/Adelaide'	=> 'Australia/Adelaide',
		'Australia/Brisbane'	=> 'Australia/Brisbane',
		'Australia/Broken_Hill'	=> 'Australia/Broken Hill',
		'Australia/Currie'		=> 'Australia/Currie',
		'Australia/Darwin'		=> 'Australia/Darwin',
		'Australia/Eucla'		=> 'Australia/Eucla',
		'Australia/Hobart'		=> 'Australia/Hobart',
		'Australia/Lindeman'	=> 'Australia/Lindeman',
		'Australia/Lord_Howe'	=> 'Australia/Lord Howe',
		'Australia/Melbourne'	=> 'Australia/Melbourne',
		'Australia/Perth'		=> 'Australia/Perth',
		'Australia/Sydney'		=> 'Australia/Sydney',

		'Europe/Amsterdam'		=> 'Europe/Amsterdam',
		'Europe/Andorra'		=> 'Europe/Andorra',
		'Europe/Athens'			=> 'Europe/Athens',
		'Europe/Belgrade'		=> 'Europe/Belgrade',
		'Europe/Berlin'			=> 'Europe/Berlin',
		'Europe/Bratislava'		=> 'Europe/Bratislava',
		'Europe/Brussels'		=> 'Europe/Brussels',
		'Europe/Bucharest'		=> 'Europe/Bucharest',
		'Europe/Budapest'		=> 'Europe/Budapest',
		'Europe/Busingen'		=> 'Europe/Busingen',
		'Europe/Chisinau'		=> 'Europe/Chisinau',
		'Europe/Copenhagen'		=> 'Europe/Copenhagen',
		'Europe/Dublin'			=> 'Europe/Dublin',
		'Europe/Gibraltar'		=> 'Europe/Gibraltar',
		'Europe/Guernsey'		=> 'Europe/Guernsey',
		'Europe/Helsinki'		=> 'Europe/Helsinki',
		'Europe/Isle_of_Man'	=> 'Europe/Isle of Man',
		'Europe/Istanbul'		=> 'Europe/Istanbul',
		'Europe/Jersey'			=> 'Europe/Jersey',
		'Europe/Kaliningrad'	=> 'Europe/Kaliningrad',
		'Europe/Kiev'			=> 'Europe/Kiev',
		'Europe/Lisbon'			=> 'Europe/Lisbon',
		'Europe/Ljubljana'		=> 'Europe/Ljubljana',
		'Europe/London'			=> 'Europe/London',
		'Europe/Luxembourg'		=> 'Europe/Luxembourg',
		'Europe/Madrid'			=> 'Europe/Madrid',
		'Europe/Malta'			=> 'Europe/Malta',
		'Europe/Mariehamn'		=> 'Europe/Mariehamn',
		'Europe/Minsk'			=> 'Europe/Minsk',
		'Europe/Monaco'			=> 'Europe/Monaco',
		'Europe/Moscow'			=> 'Europe/Moscow',
		'Europe/Oslo'			=> 'Europe/Oslo',
		'Europe/Paris'			=> 'Europe/Paris',
		'Europe/Podgorica'		=> 'Europe/Podgorica',
		'Europe/Prague'			=> 'Europe/Prague',
		'Europe/Riga'			=> 'Europe/Riga',
		'Europe/Rome'			=> 'Europe/Rome',
		'Europe/Samara'			=> 'Europe/Samara',
		'Europe/San_Marino'		=> 'Europe/San Marino',
		'Europe/Sarajevo'		=> 'Europe/Sarajevo',
		'Europe/Simferopol'		=> 'Europe/Simferopol',
		'Europe/Skopje'			=> 'Europe/Skopje',
		'Europe/Sofia'			=> 'Europe/Sofia',
		'Europe/Stockholm'		=> 'Europe/Stockholm',
		'Europe/Tallinn'		=> 'Europe/Tallinn',
		'Europe/Tirane'			=> 'Europe/Tirane',
		'Europe/Uzhgorod'		=> 'Europe/Uzhgorod',
		'Europe/Vaduz'			=> 'Europe/Vaduz',
		'Europe/Vatican'		=> 'Europe/Vatican',
		'Europe/Vienna'			=> 'Europe/Vienna',
		'Europe/Vilnius'		=> 'Europe/Vilnius',
		'Europe/Volgograd'		=> 'Europe/Volgograd',
		'Europe/Warsaw'			=> 'Europe/Warsaw',
		'Europe/Zagreb'			=> 'Europe/Zagreb',
		'Europe/Zaporozhye'		=> 'Europe/Zaporozhye',
		'Europe/Zurich'			=> 'Europe/Zurich',

		'Indian/Antananarivo'	=> 'Indian/Antananarivo',
		'Indian/Chagos'			=> 'Indian/Chagos',
		'Indian/Christmas'		=> 'Indian/Christmas',
		'Indian/Cocos'			=> 'Indian/Cocos',
		'Indian/Comoro'			=> 'Indian/Comoro',
		'Indian/Kerguelen'		=> 'Indian/Kerguelen',
		'Indian/Mahe'			=> 'Indian/Mahe',
		'Indian/Maldives'		=> 'Indian/Maldives',
		'Indian/Mauritius'		=> 'Indian/Mauritius',
		'Indian/Mayotte'		=> 'Indian/Mayotte',
		'Indian/Reunion'		=> 'Indian/Reunion',

		'Pacific/Apia'			=> 'Pacific/Apia',
		'Pacific/Auckland'		=> 'Pacific/Auckland',
		'Pacific/Chatham'		=> 'Pacific/Chatham',
		'Pacific/Chuuk'			=> 'Pacific/Chuuk',
		'Pacific/Easter'		=> 'Pacific/Easter',
		'Pacific/Efate'			=> 'Pacific/Efate',
		'Pacific/Enderbury'		=> 'Pacific/Enderbury',
		'Pacific/Fakaofo'		=> 'Pacific/Fakaofo',
		'Pacific/Fiji'			=> 'Pacific/Fiji',
		'Pacific/Funafuti'		=> 'Pacific/Funafuti',
		'Pacific/Galapagos'		=> 'Pacific/Galapagos',
		'Pacific/Gambier'		=> 'Pacific/Gambier',
		'Pacific/Guadalcanal'	=> 'Pacific/Guadalcanal',
		'Pacific/Guam'			=> 'Pacific/Guam',
		'Pacific/Honolulu'		=> 'Pacific/Honolulu',
		'Pacific/Johnston'		=> 'Pacific/Johnston',
		'Pacific/Kiritimati'	=> 'Pacific/Kiritimati',
		'Pacific/Kosrae'		=> 'Pacific/Kosrae',
		'Pacific/Kwajalein'		=> 'Pacific/Kwajalein',
		'Pacific/Majuro'		=> 'Pacific/Majuro',
		'Pacific/Marquesas'		=> 'Pacific/Marquesas',
		'Pacific/Midway'		=> 'Pacific/Midway',
		'Pacific/Nauru'			=> 'Pacific/Nauru',
		'Pacific/Niue'			=> 'Pacific/Niue',
		'Pacific/Norfolk'		=> 'Pacific/Norfolk',
		'Pacific/Noumea'		=> 'Pacific/Noumea',
		'Pacific/Pago_Pago'		=> 'Pacific/Pago Pago',
		'Pacific/Palau'			=> 'Pacific/Palau',
		'Pacific/Pitcairn'		=> 'Pacific/Pitcairn',
		'Pacific/Pohnpei'		=> 'Pacific/Pohnpei',
		'Pacific/Port_Moresby'	=> 'Pacific/Port Moresby',
		'Pacific/Rarotonga'		=> 'Pacific/Rarotonga',
		'Pacific/Saipan'		=> 'Pacific/Saipan',
		'Pacific/Tahiti'		=> 'Pacific/Tahiti',
		'Pacific/Tarawa'		=> 'Pacific/Tarawa',
		'Pacific/Tongatapu'		=> 'Pacific/Tongatapu',
		'Pacific/Wake'			=> 'Pacific/Wake',
		'Pacific/Wallis'		=> 'Pacific/Wallis',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Ιαν 2007, 13:37',
		'd M Y H:i'				=> '01 Ιαν 2007 13:37',
		'M jS, \'y, H:i'		=> 'Ιαν 1η, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Δευ Ιαν 01, 2007 1:37 πμ',
		'D d M Y, g:i a'		=> 'Δευ 01 Ιαν 2007 1:37 πμ',
		'D d M Y, H:i'			=> 'Δευ 01 Ιαν 2007 13:37',
		'F jS, Y, g:i a'		=> 'Ιανουαρίου 1η, 2007, 1:37 πμ',
		'|d M Y|, H:i'			=> 'Σήμερα, 13:37 / 01 Ιαν 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Σήμερα, 1:37 πμ / Ιανουαρίου 1η, 2007, 1:37πμ'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));
