var Slider=new Class({Implements:[Events,Options],Binds:["clickedElement","draggedKnob","scrolledElement"],options:{onTick:function(position){this.setKnobPosition(position)},initialStep:0,snap:false,offset:0,range:false,wheel:false,steps:100,mode:"horizontal"},initialize:function(element,knob,options){this.setOptions(options);options=this.options;this.element=document.id(element);knob=this.knob=document.id(knob);this.previousChange=this.previousEnd=this.step=-1;var limit={},modifiers={x:false,y:false};switch(options.mode){case"vertical":this.axis="y";this.property="top";this.offset="offsetHeight";break;case"horizontal":this.axis="x";this.property="left";this.offset="offsetWidth"}this.setSliderDimensions();this.setRange(options.range);if(knob.getStyle("position")=="static"){knob.setStyle("position","relative")}knob.setStyle(this.property,-options.offset);modifiers[this.axis]=this.property;limit[this.axis]=[-options.offset,this.full-options.offset];var dragOptions={snap:0,limit:limit,modifiers:modifiers,onDrag:this.draggedKnob,onStart:this.draggedKnob,onBeforeStart:(function(){this.isDragging=true}).bind(this),onCancel:function(){this.isDragging=false}.bind(this),onComplete:function(){this.isDragging=false;this.draggedKnob();this.end()}.bind(this)};if(options.snap){this.setSnap(dragOptions)}this.drag=new Drag(knob,dragOptions);this.attach();if(options.initialStep!=null){this.set(options.initialStep)}},attach:function(){this.element.addEvent("mousedown",this.clickedElement);if(this.options.wheel){this.element.addEvent("mousewheel",this.scrolledElement)}this.drag.attach();return this},detach:function(){this.element.removeEvent("mousedown",this.clickedElement).removeEvent("mousewheel",this.scrolledElement);this.drag.detach();return this},autosize:function(){this.setSliderDimensions().setKnobPosition(this.toPosition(this.step));this.drag.options.limit[this.axis]=[-this.options.offset,this.full-this.options.offset];if(this.options.snap){this.setSnap()}return this},setSnap:function(options){if(!options){options=this.drag.options}options.grid=Math.ceil(this.stepWidth);options.limit[this.axis][1]=this.full;return this},setKnobPosition:function(position){if(this.options.snap){position=this.toPosition(this.step)}this.knob.setStyle(this.property,position);return this},setSliderDimensions:function(){this.full=this.element.measure(function(){this.half=this.knob[this.offset]/2;return this.element[this.offset]-this.knob[this.offset]+(this.options.offset*2)}.bind(this));return this},set:function(step){if(!((this.range>0)^(step<this.min))){step=this.min}if(!((this.range>0)^(step>this.max))){step=this.max}this.step=Math.round(step);return this.checkStep().fireEvent("tick",this.toPosition(this.step)).end()},setRange:function(range,pos){this.min=Array.pick([range[0],0]);this.max=Array.pick([range[1],this.options.steps]);this.range=this.max-this.min;this.steps=this.options.steps||this.full;this.stepSize=Math.abs(this.range)/this.steps;this.stepWidth=this.stepSize*this.full/Math.abs(this.range);if(range){this.set(Array.pick([pos,this.step]).floor(this.min).max(this.max))}return this},clickedElement:function(event){if(this.isDragging||event.target==this.knob){return}var dir=this.range<0?-1:1,position=event.page[this.axis]-this.element.getPosition()[this.axis]-this.half;position=position.limit(-this.options.offset,this.full-this.options.offset);this.step=Math.round(this.min+dir*this.toStep(position));this.checkStep().fireEvent("tick",position).end()},scrolledElement:function(event){var mode=(this.options.mode=="horizontal")?(event.wheel<0):(event.wheel>0);this.set(this.step+(mode?-1:1)*this.stepSize);event.stop()},draggedKnob:function(){var dir=this.range<0?-1:1,position=this.drag.value.now[this.axis];position=position.limit(-this.options.offset,this.full-this.options.offset);this.step=Math.round(this.min+dir*this.toStep(position));this.checkStep()},checkStep:function(){var step=this.step;if(this.previousChange!=step){this.previousChange=step;this.fireEvent("change",step)}return this},end:function(){var step=this.step;if(this.previousEnd!==step){this.previousEnd=step;this.fireEvent("complete",step+"")}return this},toStep:function(position){var step=(position+this.options.offset)*this.stepSize/this.full*this.steps;return this.options.steps?Math.round(step-=step%this.stepSize):step},toPosition:function(step){return(this.full*Math.abs(this.min-step))/(this.steps*this.stepSize)-this.options.offset}});