<?php

/**
 * Prado classes map
 *
 * This file contains a mapping between all the old Prado3 classes
 * and their equivalent, php-namespaced name in Prado4.
 *
 * @link https://github.com/pradosoft/prado
 * @license https://github.com/pradosoft/prado/blob/master/LICENSE
 */

return [
'ICache' => 'Prado\Caching\ICache',
'ICacheDependency' => 'Prado\Caching\ICacheDependency',
'TAPCCache' => 'Prado\Caching\TAPCCache',
'TApplicationStateCacheDependency' => 'Prado\Caching\TApplicationStateCacheDependency',
'TCache' => 'Prado\Caching\TCache',
'TCacheDependency' => 'Prado\Caching\TCacheDependency',
'TCacheDependencyList' => 'Prado\Caching\TCacheDependencyList',
'TChainedCacheDependency' => 'Prado\Caching\TChainedCacheDependency',
'TDbCache' => 'Prado\Caching\TDbCache',
'TDirectoryCacheDependency' => 'Prado\Caching\TDirectoryCacheDependency',
'TFileCacheDependency' => 'Prado\Caching\TFileCacheDependency',
'TGlobalStateCacheDependency' => 'Prado\Caching\TGlobalStateCacheDependency',
'TMemCache' => 'Prado\Caching\TMemCache',
'ICollectionFilter' => 'Prado\Collections\ICollectionFilter',
'IPriorityCapture' => 'Prado\Collections\IPriorityCapture',
'IPriorityCollection' => 'Prado\Collections\IPriorityCollection',
'IPriorityItem' => 'Prado\Collections\IPriorityItem',
'IPriorityProperty' => 'Prado\Collections\IPriorityProperty',
'IWeakCollection' => 'Prado\Collections\IWeakCollection',
'IWeakRetainable' => 'Prado\Collections\IWeakRetainable',
'TArraySubscription' => 'Prado\Collections\TArraySubscription',
'TAttributeCollection' => 'Prado\Collections\TAttributeCollection',
'TCollectionSubscription' => 'Prado\Collections\TCollectionSubscription',
'TDummyDataSource' => 'Prado\Collections\TDummyDataSource',
'TDummyDataSourceIterator' => 'Prado\Collections\TDummyDataSourceIterator',
'TList' => 'Prado\Collections\TList',
'TListItemCollection' => 'Prado\Collections\TListItemCollection',
'TMap' => 'Prado\Collections\TMap',
'TPagedDataSource' => 'Prado\Collections\TPagedDataSource',
'TPagedList' => 'Prado\Collections\TPagedList',
'TPagedListFetchDataEventParameter' => 'Prado\Collections\TPagedListFetchDataEventParameter',
'TPagedListIterator' => 'Prado\Collections\TPagedListIterator',
'TPagedListPageChangedEventParameter' => 'Prado\Collections\TPagedListPageChangedEventParameter',
'TPagedMapIterator' => 'Prado\Collections\TPagedMapIterator',
'TPriorityCollectionTrait' => 'Prado\Collections\TPriorityCollectionTrait',
'TPriorityList' => 'Prado\Collections\TPriorityList',
'TPriorityMap' => 'Prado\Collections\TPriorityMap',
'TPriorityPropertyTrait' => 'Prado\Collections\TPriorityPropertyTrait',
'TQueue' => 'Prado\Collections\TQueue',
'TQueueIterator' => 'Prado\Collections\TQueueIterator',
'TStack' => 'Prado\Collections\TStack',
'TWeakCallableCollection' => 'Prado\Collections\TWeakCallableCollection',
'TWeakCollectionTrait' => 'Prado\Collections\TWeakCollectionTrait',
'TWeakList' => 'Prado\Collections\TWeakList',
'TActiveRecordConfigurationException' => 'Prado\Data\ActiveRecord\Exceptions\TActiveRecordConfigurationException',
'TActiveRecordException' => 'Prado\Data\ActiveRecord\Exceptions\TActiveRecordException',
'TActiveRecordBelongsTo' => 'Prado\Data\ActiveRecord\Relations\TActiveRecordBelongsTo',
'TActiveRecordHasMany' => 'Prado\Data\ActiveRecord\Relations\TActiveRecordHasMany',
'TActiveRecordHasManyAssociation' => 'Prado\Data\ActiveRecord\Relations\TActiveRecordHasManyAssociation',
'TActiveRecordHasOne' => 'Prado\Data\ActiveRecord\Relations\TActiveRecordHasOne',
'TActiveRecordRelation' => 'Prado\Data\ActiveRecord\Relations\TActiveRecordRelation',
'TActiveRecordRelationContext' => 'Prado\Data\ActiveRecord\Relations\TActiveRecordRelationContext',
'TIbmScaffoldInput' => 'Prado\Data\ActiveRecord\Scaffold\InputBuilder\TIbmScaffoldInput',
'TMssqlScaffoldInput' => 'Prado\Data\ActiveRecord\Scaffold\InputBuilder\TMssqlScaffoldInput',
'TMysqlScaffoldInput' => 'Prado\Data\ActiveRecord\Scaffold\InputBuilder\TMysqlScaffoldInput',
'TPgsqlScaffoldInput' => 'Prado\Data\ActiveRecord\Scaffold\InputBuilder\TPgsqlScaffoldInput',
'TScaffoldInputBase' => 'Prado\Data\ActiveRecord\Scaffold\InputBuilder\TScaffoldInputBase',
'TScaffoldInputCommon' => 'Prado\Data\ActiveRecord\Scaffold\InputBuilder\TScaffoldInputCommon',
'TSqliteScaffoldInput' => 'Prado\Data\ActiveRecord\Scaffold\InputBuilder\TSqliteScaffoldInput',
'IScaffoldEditRenderer' => 'Prado\Data\ActiveRecord\Scaffold\IScaffoldEditRenderer',
'TScaffoldBase' => 'Prado\Data\ActiveRecord\Scaffold\TScaffoldBase',
'TScaffoldEditView' => 'Prado\Data\ActiveRecord\Scaffold\TScaffoldEditView',
'TScaffoldListView' => 'Prado\Data\ActiveRecord\Scaffold\TScaffoldListView',
'TScaffoldSearch' => 'Prado\Data\ActiveRecord\Scaffold\TScaffoldSearch',
'TScaffoldView' => 'Prado\Data\ActiveRecord\Scaffold\TScaffoldView',
'TActiveRecord' => 'Prado\Data\ActiveRecord\TActiveRecord',
'TActiveRecordChangeEventParameter' => 'Prado\Data\ActiveRecord\TActiveRecordChangeEventParameter',
'TActiveRecordConfig' => 'Prado\Data\ActiveRecord\TActiveRecordConfig',
'TActiveRecordCriteria' => 'Prado\Data\ActiveRecord\TActiveRecordCriteria',
'TActiveRecordGateway' => 'Prado\Data\ActiveRecord\TActiveRecordGateway',
'TActiveRecordInvalidFinderResult' => 'Prado\Data\ActiveRecord\TActiveRecordInvalidFinderResult',
'TActiveRecordManager' => 'Prado\Data\ActiveRecord\TActiveRecordManager',
'TMssqlCommandBuilder' => 'Prado\Data\Common\Mssql\TMssqlCommandBuilder',
'TMssqlMetaData' => 'Prado\Data\Common\Mssql\TMssqlMetaData',
'TMssqlTableColumn' => 'Prado\Data\Common\Mssql\TMssqlTableColumn',
'TMssqlTableInfo' => 'Prado\Data\Common\Mssql\TMssqlTableInfo',
'TMysqlCommandBuilder' => 'Prado\Data\Common\Mysql\TMysqlCommandBuilder',
'TMysqlMetaData' => 'Prado\Data\Common\Mysql\TMysqlMetaData',
'TMysqlTableColumn' => 'Prado\Data\Common\Mysql\TMysqlTableColumn',
'TMysqlTableInfo' => 'Prado\Data\Common\Mysql\TMysqlTableInfo',
'TOracleCommandBuilder' => 'Prado\Data\Common\Oracle\TOracleCommandBuilder',
'TOracleMetaData' => 'Prado\Data\Common\Oracle\TOracleMetaData',
'TOracleTableColumn' => 'Prado\Data\Common\Oracle\TOracleTableColumn',
'TOracleTableInfo' => 'Prado\Data\Common\Oracle\TOracleTableInfo',
'TPgsqlCommandBuilder' => 'Prado\Data\Common\Pgsql\TPgsqlCommandBuilder',
'TPgsqlMetaData' => 'Prado\Data\Common\Pgsql\TPgsqlMetaData',
'TPgsqlTableColumn' => 'Prado\Data\Common\Pgsql\TPgsqlTableColumn',
'TPgsqlTableInfo' => 'Prado\Data\Common\Pgsql\TPgsqlTableInfo',
'TSqliteCommandBuilder' => 'Prado\Data\Common\Sqlite\TSqliteCommandBuilder',
'TSqliteMetaData' => 'Prado\Data\Common\Sqlite\TSqliteMetaData',
'TSqliteTableColumn' => 'Prado\Data\Common\Sqlite\TSqliteTableColumn',
'TSqliteTableInfo' => 'Prado\Data\Common\Sqlite\TSqliteTableInfo',
'TDbCommandBuilder' => 'Prado\Data\Common\TDbCommandBuilder',
'TDbMetaData' => 'Prado\Data\Common\TDbMetaData',
'TDbTableColumn' => 'Prado\Data\Common\TDbTableColumn',
'TDbTableInfo' => 'Prado\Data\Common\TDbTableInfo',
'TDataGatewayCommand' => 'Prado\Data\DataGateway\TDataGatewayCommand',
'TDataGatewayEventParameter' => 'Prado\Data\DataGateway\TDataGatewayEventParameter',
'TDataGatewayResultEventParameter' => 'Prado\Data\DataGateway\TDataGatewayResultEventParameter',
'TSqlCriteria' => 'Prado\Data\DataGateway\TSqlCriteria',
'TTableGateway' => 'Prado\Data\DataGateway\TTableGateway',
'TDiscriminator' => 'Prado\Data\SqlMap\Configuration\TDiscriminator',
'TInlineParameterMapParser' => 'Prado\Data\SqlMap\Configuration\TInlineParameterMapParser',
'TParameterMap' => 'Prado\Data\SqlMap\Configuration\TParameterMap',
'TParameterProperty' => 'Prado\Data\SqlMap\Configuration\TParameterProperty',
'TResultMap' => 'Prado\Data\SqlMap\Configuration\TResultMap',
'TResultProperty' => 'Prado\Data\SqlMap\Configuration\TResultProperty',
'TSimpleDynamicParser' => 'Prado\Data\SqlMap\Configuration\TSimpleDynamicParser',
'TSqlMapCacheKey' => 'Prado\Data\SqlMap\Configuration\TSqlMapCacheKey',
'TSqlMapCacheModel' => 'Prado\Data\SqlMap\Configuration\TSqlMapCacheModel',
'TSqlMapCacheTypes' => 'Prado\Data\SqlMap\Configuration\TSqlMapCacheTypes',
'TSqlMapDelete' => 'Prado\Data\SqlMap\Configuration\TSqlMapDelete',
'TSqlMapInsert' => 'Prado\Data\SqlMap\Configuration\TSqlMapInsert',
'TSqlMapSelect' => 'Prado\Data\SqlMap\Configuration\TSqlMapSelect',
'TSqlMapSelectKey' => 'Prado\Data\SqlMap\Configuration\TSqlMapSelectKey',
'TSqlMapStatement' => 'Prado\Data\SqlMap\Configuration\TSqlMapStatement',
'TSqlMapUpdate' => 'Prado\Data\SqlMap\Configuration\TSqlMapUpdate',
'TSqlMapXmlConfigBuilder' => 'Prado\Data\SqlMap\Configuration\TSqlMapXmlConfigBuilder',
'TSqlMapXmlConfiguration' => 'Prado\Data\SqlMap\Configuration\TSqlMapXmlConfiguration',
'TSqlMapXmlMappingConfiguration' => 'Prado\Data\SqlMap\Configuration\TSqlMapXmlMappingConfiguration',
'TSubMap' => 'Prado\Data\SqlMap\Configuration\TSubMap',
'TInvalidPropertyException' => 'Prado\Data\SqlMap\DataMapper\TInvalidPropertyException',
'TLazyLoadList' => 'Prado\Data\SqlMap\DataMapper\TLazyLoadList',
'TObjectProxy' => 'Prado\Data\SqlMap\DataMapper\TObjectProxy',
'TPropertyAccess' => 'Prado\Data\SqlMap\DataMapper\TPropertyAccess',
'TSqlMapApplicationCache' => 'Prado\Data\SqlMap\DataMapper\TSqlMapApplicationCache',
'TSqlMapCache' => 'Prado\Data\SqlMap\DataMapper\TSqlMapCache',
'TSqlMapConfigurationException' => 'Prado\Data\SqlMap\DataMapper\TSqlMapConfigurationException',
'TSqlMapDuplicateException' => 'Prado\Data\SqlMap\DataMapper\TSqlMapDuplicateException',
'TSqlMapException' => 'Prado\Data\SqlMap\DataMapper\TSqlMapException',
'TSqlMapExecutionException' => 'Prado\Data\SqlMap\DataMapper\TSqlMapExecutionException',
'TSqlMapFifoCache' => 'Prado\Data\SqlMap\DataMapper\TSqlMapFifoCache',
'TSqlMapLruCache' => 'Prado\Data\SqlMap\DataMapper\TSqlMapLruCache',
'TSqlMapPagedList' => 'Prado\Data\SqlMap\DataMapper\TSqlMapPagedList',
'TSqlMapTypeHandler' => 'Prado\Data\SqlMap\DataMapper\TSqlMapTypeHandler',
'TSqlMapTypeHandlerRegistry' => 'Prado\Data\SqlMap\DataMapper\TSqlMapTypeHandlerRegistry',
'TSqlMapUndefinedException' => 'Prado\Data\SqlMap\DataMapper\TSqlMapUndefinedException',
'IMappedStatement' => 'Prado\Data\SqlMap\Statements\IMappedStatement',
'TCachingStatement' => 'Prado\Data\SqlMap\Statements\TCachingStatement',
'TDeleteMappedStatement' => 'Prado\Data\SqlMap\Statements\TDeleteMappedStatement',
'TInsertMappedStatement' => 'Prado\Data\SqlMap\Statements\TInsertMappedStatement',
'TMappedStatement' => 'Prado\Data\SqlMap\Statements\TMappedStatement',
'TPostSelectBinding' => 'Prado\Data\SqlMap\Statements\TPostSelectBinding',
'TPreparedCommand' => 'Prado\Data\SqlMap\Statements\TPreparedCommand',
'TPreparedStatement' => 'Prado\Data\SqlMap\Statements\TPreparedStatement',
'TPreparedStatementFactory' => 'Prado\Data\SqlMap\Statements\TPreparedStatementFactory',
'TResultSetListItemParameter' => 'Prado\Data\SqlMap\Statements\TResultSetListItemParameter',
'TResultSetMapItemParameter' => 'Prado\Data\SqlMap\Statements\TResultSetMapItemParameter',
'TSelectMappedStatement' => 'Prado\Data\SqlMap\Statements\TSelectMappedStatement',
'TSimpleDynamicSql' => 'Prado\Data\SqlMap\Statements\TSimpleDynamicSql',
'TSqlMapObjectCollectionTree' => 'Prado\Data\SqlMap\Statements\TSqlMapObjectCollectionTree',
'TStaticSql' => 'Prado\Data\SqlMap\Statements\TStaticSql',
'TUpdateMappedStatement' => 'Prado\Data\SqlMap\Statements\TUpdateMappedStatement',
'TSqlMapConfig' => 'Prado\Data\SqlMap\TSqlMapConfig',
'TSqlMapGateway' => 'Prado\Data\SqlMap\TSqlMapGateway',
'TSqlMapManager' => 'Prado\Data\SqlMap\TSqlMapManager',
'TDataSourceConfig' => 'Prado\Data\TDataSourceConfig',
'TDbColumnCaseMode' => 'Prado\Data\TDbColumnCaseMode',
'TDbCommand' => 'Prado\Data\TDbCommand',
'TDbConnection' => 'Prado\Data\TDbConnection',
'TDbDataReader' => 'Prado\Data\TDbDataReader',
'TDbNullConversionMode' => 'Prado\Data\TDbNullConversionMode',
'TDbTransaction' => 'Prado\Data\TDbTransaction',
'TApplicationException' => 'Prado\Exceptions\TApplicationException',
'TConfigurationException' => 'Prado\Exceptions\TConfigurationException',
'TDbConnectionException' => 'Prado\Exceptions\TDbConnectionException',
'TDbException' => 'Prado\Exceptions\TDbException',
'TErrorHandler' => 'Prado\Exceptions\TErrorHandler',
'TException' => 'Prado\Exceptions\TException',
'TExitException' => 'Prado\Exceptions\TExitException',
'THttpException' => 'Prado\Exceptions\THttpException',
'TInvalidDataTypeException' => 'Prado\Exceptions\TInvalidDataTypeException',
'TInvalidDataValueException' => 'Prado\Exceptions\TInvalidDataValueException',
'TInvalidOperationException' => 'Prado\Exceptions\TInvalidOperationException',
'TIOException' => 'Prado\Exceptions\TIOException',
'TLogException' => 'Prado\Exceptions\TLogException',
'TNetworkException' => 'Prado\Exceptions\TNetworkException',
'TNotSupportedException' => 'Prado\Exceptions\TNotSupportedException',
'TPhpErrorException' => 'Prado\Exceptions\TPhpErrorException',
'TSocketException' => 'Prado\Exceptions\TSocketException',
'TSystemException' => 'Prado\Exceptions\TSystemException',
'TTemplateException' => 'Prado\Exceptions\TTemplateException',
'TUnknownMethodException' => 'Prado\Exceptions\TUnknownMethodException',
'TUserException' => 'Prado\Exceptions\TUserException',
'ChoiceFormat' => 'Prado\I18N\core\ChoiceFormat',
'CultureInfo' => 'Prado\I18N\core\CultureInfo',
'TGettext' => 'Prado\I18N\core\Gettext\TGettext',
'TGettext_MO' => 'Prado\I18N\core\Gettext\TGettext_MO',
'TGettext_PO' => 'Prado\I18N\core\Gettext\TGettext_PO',
'IMessageSource' => 'Prado\I18N\core\IMessageSource',
'MessageCache' => 'Prado\I18N\core\MessageCache',
'MessageFormat' => 'Prado\I18N\core\MessageFormat',
'MessageSource' => 'Prado\I18N\core\MessageSource',
'MessageSource_Database' => 'Prado\I18N\core\MessageSource_Database',
'MessageSource_gettext' => 'Prado\I18N\core\MessageSource_gettext',
'MessageSource_PHP' => 'Prado\I18N\core\MessageSource_PHP',
'MessageSource_XLIFF' => 'Prado\I18N\core\MessageSource_XLIFF',
'TCache_Lite' => 'Prado\I18N\core\TCache_Lite',
'TMessageSourceIOException' => 'Prado\I18N\core\TMessageSourceIOException',
'TChoiceFormat' => 'Prado\I18N\TChoiceFormat',
'TDateFormat' => 'Prado\I18N\TDateFormat',
'TGlobalization' => 'Prado\I18N\TGlobalization',
'TGlobalizationAutoDetect' => 'Prado\I18N\TGlobalizationAutoDetect',
'TI18NControl' => 'Prado\I18N\TI18NControl',
'TNumberFormat' => 'Prado\I18N\TNumberFormat',
'Translation' => 'Prado\I18N\Translation',
'TTranslate' => 'Prado\I18N\TTranslate',
'TTranslateParameter' => 'Prado\I18N\TTranslateParameter',
'IDataRenderer' => 'Prado\IDataRenderer',
'IEventParameter' => 'Prado\IEventParameter',
'IModule' => 'Prado\IModule',
'ITextWriter' => 'Prado\IO\ITextWriter',
'TOutputWriter' => 'Prado\IO\TOutputWriter',
'TStdOutWriter' => 'Prado\IO\TStdOutWriter',
'TStreamNotificationCallback' => 'Prado\IO\TStreamNotificationCallback',
'TStreamNotificationParameter' => 'Prado\IO\TStreamNotificationParameter',
'TTarFileExtractor' => 'Prado\IO\TTarFileExtractor',
'TTextWriter' => 'Prado\IO\TTextWriter',
'IService' => 'Prado\IService',
'ISingleton' => 'Prado\ISingleton',
'IStatePersister' => 'Prado\IStatePersister',
'Prado' => 'Prado\Prado',
'PradoBase' => 'Prado\PradoBase',
'IUser' => 'Prado\Security\IUser',
'IUserManager' => 'Prado\Security\IUserManager',
'IPermissions' => 'Prado\Security\Permissions\IPermissions',
'TPermissionEvent' => 'Prado\Security\Permissions\TPermissionEvent',
'TPermissionAction' => 'Prado\Security\Permissions\TPermissionsAction',
'TPermissionsBehavior' => 'Prado\Security\Permissions\TPermissionsBehavior',
'TPermissionsConfigurationBehavior' => 'Prado\Security\Permissions\TPermissionsConfigurationBehavior',
'TPermissionsManager' => 'Prado\Security\Permissions\TPermissionsManager',
'TPermissionsManagerPropertyTrait' => 'Prado\Security\Permissions\TPermissionsManagerPropertyTrait',
'TUserOwnerRule' => 'Prado\Security\Permissions\TUserOwnerRule',
'TUserPermissionsBehavior' => 'Prado\Security\Permissions\TUserPermissionsBehavior',
'TAuthManager' => 'Prado\Security\TAuthManager',
'TAuthorizationRule' => 'Prado\Security\TAuthorizationRule',
'TAuthorizationRuleCollection' => 'Prado\Security\TAuthorizationRuleCollection',
'TDbUser' => 'Prado\Security\TDbUser',
'TDbUserManager' => 'Prado\Security\TDbUserManager',
'TSecurityManager' => 'Prado\Security\TSecurityManager',
'TSecurityManagerValidationMode' => 'Prado\Security\TSecurityManagerValidationMode',
'TUser' => 'Prado\Security\TUser',
'TUserManager' => 'Prado\Security\TUserManager',
'TUserManagerPasswordMode' => 'Prado\Security\TUserManagerPasswordMode',
'TActiveRecordAction' => 'Prado\Shell\Actions\TActiveRecordAction',
'TDbParameterAction' => 'Prado\Shell\Actions\TDbParameterAction',
'TFlushCachesAction' => 'Prado\Shell\Actions\TFlushCachesAction',
'THelpAction' => 'Prado\Shell\Actions\THelpAction',
'TPphShellAction' => 'Prado\Shell\Actions\TPphShellAction',
'TWebServerAction' => 'Prado\Shell\Actions\TWebServerAction',
'TShellAction' => 'Prado\Shell\TShellAction',
'TShellApplication' => 'Prado\Shell\TShellApplication',
'TShellLoginBehavior' => 'Prado\Shell\TShellLoginBehavior',
'TShellWriter' => 'Prado\Shell\TShellWriter',
'TApplication' => 'Prado\TApplication',
'TApplicationComponent' => 'Prado\TApplicationComponent',
'TApplicationConfiguration' => 'Prado\TApplicationConfiguration',
'TApplicationMode' => 'Prado\TApplicationMode',
'TApplicationStatePersister' => 'Prado\TApplicationStatePersister',
'TComponent' => 'Prado\TComponent',
'TComponentReflection' => 'Prado\TComponentReflection',
'TEnumerable' => 'Prado\TEnumerable',
'TEventHandler' => 'Prado\TEventHandler',
'TEventParameter' => 'Prado\TEventParameter',
'TEventResults' => 'Prado\TEventResults',
'TEventSubscription' => 'Prado\TEventSubscription',
'TModule' => 'Prado\TModule',
'TPropertyValue' => 'Prado\TPropertyValue',
'TService' => 'Prado\TService',
'TApplicationSignals' => 'Prado\Util\Behaviors\TApplicationSignals',
'TBehaviorParameterLoader' => 'Prado\Util\Behaviors\TBehaviorParameterLoader',
'TCaptureForkLog' => 'Prado\Util\Behaviors\TCaptureForkLog',
'TForkable' => 'Prado\Util\Behaviors\TForkable',
'TGlobalClassAware' => 'Prado\Util\Behaviors\TGlobalClassAware',
'TMapLazyLoadBehavior' => 'Prado\Util\Behaviors\TMapLazyLoadBehavior',
'TMapRouteBehavior' => 'Prado\Util\Behaviors\TMapRouteBehavior',
'TPageGlobalizationCharsetBehavior' => 'Prado\Util\Behaviors\TPageGlobalizationCharsetBehavior',
'TPageNoCacheBehavior' => 'Prado\Util\Behaviors\TPageNoCacheBehavior',
'TPageTopAnchorBehavior' => 'Prado\Util\Behaviors\TPageTopAnchorBehavior',
'TParameterizeBehavior' => 'Prado\Util\Behaviors\TParameterizeBehavior',
'TTimeZoneParameterBehavior' => 'Prado\Util\Behaviors\TTimeZoneParameterBehavior',
'TCronMethodTask' => 'Prado\Util\Cron\TCronMethodTask',
'TCronModule' => 'Prado\Util\Cron\TCronModule',
'TCronTask' => 'Prado\Util\Cron\TCronTask',
'TCronTaskInfo' => 'Prado\Util\Cron\TCronTaskInfo',
'TDbCronCleanLogTask' => 'Prado\Util\Cron\TDbCronCleanLogTask',
'TDbCronModule' => 'Prado\Util\Cron\TDbCronModule',
'TShellCronAction' => 'Prado\Util\Cron\TShellCronAction',
'TShellCronLogBehavior' => 'Prado\Util\Cron\TShellCronLogBehavior',
'TShellDbCronAction' => 'Prado\Util\Cron\TShellDbCronAction',
'TTimeScheduler' => 'Prado\Util\Cron\TTimeScheduler',
'TArrayHelper' => 'Prado\Util\Helpers\TArrayHelper',
'TBitHelper' => 'Prado\Util\Helpers\TBitHelper',
'TEscCharsetConverter' => 'Prado\Util\Helpers\TEscCharsetConverter',
'TProcessHelper' => 'Prado\Util\Helpers\TProcessHelper',
'TProcessWindowsPriority' => 'Prado\Util\Helpers\TProcessWindowsPriority',
'TProcessWindowsPriorityName' => 'Prado\Util\Helpers\TProcessWindowsPriorityName',
'IBaseBehavior' => 'Prado\Util\IBaseBehavior',
'IBehavior' => 'Prado\Util\IBehavior',
'IClassBehavior' => 'Prado\Util\IClassBehavior',
'IDbModule' => 'Prado\Util\IDbModule',
'IDynamicMethods' => 'Prado\Util\IDynamicMethods',
'IInstanceCheck' => 'Prado\Util\IInstanceCheck',
'IOutputLogRoute' => 'Prado\Util\IOutputLogRoute',
'IPluginModule' => 'Prado\Util\IPluginModule',
'TRational' => 'Prado\Util\Math\TRational',
'TURational' => 'Prado\Util\Math\TURational',
'TBaseBehavior' => 'Prado\Util\TBaseBehavior',
'TBehavior' => 'Prado\Util\TBehavior',
'TBehaviorsModule' => 'Prado\Util\TBehaviorsModule',
'TBrowserLogRoute' => 'Prado\Util\TBrowserLogRoute',
'TCallChain' => 'Prado\Util\TCallChain',
'TClassBehavior' => 'Prado\Util\TClassBehavior',
'TClassBehaviorEventParameter' => 'Prado\Util\TClassBehaviorEventParameter',
'TDataFieldAccessor' => 'Prado\Util\TDataFieldAccessor',
'TDbLogRoute' => 'Prado\Util\TDbLogRoute',
'TDbParameterModule' => 'Prado\Util\TDbParameterModule',
'TDbPluginModule' => 'Prado\Util\TDbPluginModule',
'TEmailLogRoute' => 'Prado\Util\TEmailLogRoute',
'TFileLogRoute' => 'Prado\Util\TFileLogRoute',
'TFirebugLogRoute' => 'Prado\Util\TFirebugLogRoute',
'TFirePhpLogRoute' => 'Prado\Util\TFirePhpLogRoute',
'TJsonRpcClient' => 'Prado\Util\TJsonRpcClient',
'TLogger' => 'Prado\Util\TLogger',
'TLogRoute' => 'Prado\Util\TLogRoute',
'TLogRouter' => 'Prado\Util\TLogRouter',
'TParameterModule' => 'Prado\Util\TParameterModule',
'TPluginModule' => 'Prado\Util\TPluginModule',
'TRpcClient' => 'Prado\Util\TRpcClient',
'TRpcClientRequestException' => 'Prado\Util\TRpcClientRequestException',
'TRpcClientResponseException' => 'Prado\Util\TRpcClientResponseException',
'TRpcClientTypesEnumerable' => 'Prado\Util\TRpcClientTypesEnumerable',
'TSignalParameter' => 'Prado\Util\TSignalParameter',
'TSignalsDispatcher' => 'Prado\Util\TSignalsDispatcher',
'TSimpleDateFormatter' => 'Prado\Util\TSimpleDateFormatter',
'TStdOutLogRoute' => 'Prado\Util\TStdOutLogRoute',
'TSysLogRoute' => 'Prado\Util\TSysLogRoute',
'TUtf8Converter' => 'Prado\Util\TUtf8Converter',
'TVarDumper' => 'Prado\Util\TVarDumper',
'TXmlRpcClient' => 'Prado\Util\TXmlRpcClient',
'TRequestConnectionUpgrade' => 'Prado\Web\Behaviors\TRequestConnectionUpgrade',
'TJavaScript' => 'Prado\Web\Javascripts\TJavaScript',
'TJavaScriptAsset' => 'Prado\Web\Javascripts\TJavaScriptAsset',
'TJavaScriptLiteral' => 'Prado\Web\Javascripts\TJavaScriptLiteral',
'TJavaScriptString' => 'Prado\Web\Javascripts\TJavaScriptString',
'IFeedContentProvider' => 'Prado\Web\Services\IFeedContentProvider',
'TFeedService' => 'Prado\Web\Services\TFeedService',
'TJsonResponse' => 'Prado\Web\Services\TJsonResponse',
'TJsonRpcProtocol' => 'Prado\Web\Services\TJsonRpcProtocol',
'TJsonService' => 'Prado\Web\Services\TJsonService',
'TPageConfiguration' => 'Prado\Web\Services\TPageConfiguration',
'TPageService' => 'Prado\Web\Services\TPageService',
'TRpcApiProvider' => 'Prado\Web\Services\TRpcApiProvider',
'TRpcException' => 'Prado\Web\Services\TRpcException',
'TRpcProtocol' => 'Prado\Web\Services\TRpcProtocol',
'TRpcServer' => 'Prado\Web\Services\TRpcServer',
'TRpcService' => 'Prado\Web\Services\TRpcService',
'TSoapServer' => 'Prado\Web\Services\TSoapServer',
'TSoapService' => 'Prado\Web\Services\TSoapService',
'TXmlRpcProtocol' => 'Prado\Web\Services\TXmlRpcProtocol',
'TAssetManager' => 'Prado\Web\TAssetManager',
'TCacheHttpSession' => 'Prado\Web\TCacheHttpSession',
'THttpCookie' => 'Prado\Web\THttpCookie',
'THttpCookieCollection' => 'Prado\Web\THttpCookieCollection',
'THttpRequest' => 'Prado\Web\THttpRequest',
'THttpRequestParameter' => 'Prado\Web\THttpRequestParameter',
'THttpRequestResolveMethod' => 'Prado\Web\THttpRequestResolveMethod',
'THttpRequestUrlFormat' => 'Prado\Web\THttpRequestUrlFormat',
'THttpResponse' => 'Prado\Web\THttpResponse',
'THttpResponseAdapter' => 'Prado\Web\THttpResponseAdapter',
'THttpSession' => 'Prado\Web\THttpSession',
'THttpSessionCookieMode' => 'Prado\Web\THttpSessionCookieMode',
'THttpSessionHandler' => 'Prado\Web\THttpSessionHandler',
'THttpUtility' => 'Prado\Web\THttpUtility',
'TSessionIterator' => 'Prado\Web\TSessionIterator',
'TUri' => 'Prado\Web\TUri',
'TUrlManager' => 'Prado\Web\TUrlManager',
'TUrlMapping' => 'Prado\Web\TUrlMapping',
'TUrlMappingPattern' => 'Prado\Web\TUrlMappingPattern',
'TUrlMappingPatternSecureConnection' => 'Prado\Web\TUrlMappingPatternSecureConnection',
'IActiveControl' => 'Prado\Web\UI\ActiveControls\IActiveControl',
'ICallbackEventHandler' => 'Prado\Web\UI\ActiveControls\ICallbackEventHandler',
'TActiveBoundColumn' => 'Prado\Web\UI\ActiveControls\TActiveBoundColumn',
'TActiveButton' => 'Prado\Web\UI\ActiveControls\TActiveButton',
'TActiveButtonColumn' => 'Prado\Web\UI\ActiveControls\TActiveButtonColumn',
'TActiveCheckBox' => 'Prado\Web\UI\ActiveControls\TActiveCheckBox',
'TActiveCheckBoxColumn' => 'Prado\Web\UI\ActiveControls\TActiveCheckBoxColumn',
'TActiveCheckBoxList' => 'Prado\Web\UI\ActiveControls\TActiveCheckBoxList',
'TActiveCheckBoxListItem' => 'Prado\Web\UI\ActiveControls\TActiveCheckBoxListItem',
'TActiveClientScript' => 'Prado\Web\UI\ActiveControls\TActiveClientScript',
'TActiveControlAdapter' => 'Prado\Web\UI\ActiveControls\TActiveControlAdapter',
'TActiveCustomValidator' => 'Prado\Web\UI\ActiveControls\TActiveCustomValidator',
'TActiveCustomValidatorClientSide' => 'Prado\Web\UI\ActiveControls\TActiveCustomValidatorClientSide',
'TActiveDataGrid' => 'Prado\Web\UI\ActiveControls\TActiveDataGrid',
'TActiveDataGridPager' => 'Prado\Web\UI\ActiveControls\TActiveDataGridPager',
'TActiveDataGridPagerEventParameter' => 'Prado\Web\UI\ActiveControls\TActiveDataGridPagerEventParameter',
'TActiveDataList' => 'Prado\Web\UI\ActiveControls\TActiveDataList',
'TActiveDatePicker' => 'Prado\Web\UI\ActiveControls\TActiveDatePicker',
'TActiveDatePickerClientScript' => 'Prado\Web\UI\ActiveControls\TActiveDatePickerClientScript',
'TActiveDropDownList' => 'Prado\Web\UI\ActiveControls\TActiveDropDownList',
'TActiveDropDownListColumn' => 'Prado\Web\UI\ActiveControls\TActiveDropDownListColumn',
'TActiveEditCommandColumn' => 'Prado\Web\UI\ActiveControls\TActiveEditCommandColumn',
'TActiveFileUpload' => 'Prado\Web\UI\ActiveControls\TActiveFileUpload',
'TActiveFileUploadCallbackParams' => 'Prado\Web\UI\ActiveControls\TActiveFileUploadCallbackParams',
'TActiveHiddenField' => 'Prado\Web\UI\ActiveControls\TActiveHiddenField',
'TActiveHtmlArea' => 'Prado\Web\UI\ActiveControls\TActiveHtmlArea',
'TActiveHtmlArea5' => 'Prado\Web\UI\ActiveControls\TActiveHtmlArea5',
'TActiveHyperLink' => 'Prado\Web\UI\ActiveControls\TActiveHyperLink',
'TActiveHyperLinkColumn' => 'Prado\Web\UI\ActiveControls\TActiveHyperLinkColumn',
'TActiveImage' => 'Prado\Web\UI\ActiveControls\TActiveImage',
'TActiveImageButton' => 'Prado\Web\UI\ActiveControls\TActiveImageButton',
'TActiveLabel' => 'Prado\Web\UI\ActiveControls\TActiveLabel',
'TActiveLinkButton' => 'Prado\Web\UI\ActiveControls\TActiveLinkButton',
'TActiveListBox' => 'Prado\Web\UI\ActiveControls\TActiveListBox',
'TActiveListControlAdapter' => 'Prado\Web\UI\ActiveControls\TActiveListControlAdapter',
'TActiveListItemCollection' => 'Prado\Web\UI\ActiveControls\TActiveListItemCollection',
'TActiveLiteralColumn' => 'Prado\Web\UI\ActiveControls\TActiveLiteralColumn',
'TActiveMultiView' => 'Prado\Web\UI\ActiveControls\TActiveMultiView',
'TActivePageAdapter' => 'Prado\Web\UI\ActiveControls\TActivePageAdapter',
'TActivePager' => 'Prado\Web\UI\ActiveControls\TActivePager',
'TActivePanel' => 'Prado\Web\UI\ActiveControls\TActivePanel',
'TActiveRadioButton' => 'Prado\Web\UI\ActiveControls\TActiveRadioButton',
'TActiveRadioButtonItem' => 'Prado\Web\UI\ActiveControls\TActiveRadioButtonItem',
'TActiveRadioButtonList' => 'Prado\Web\UI\ActiveControls\TActiveRadioButtonList',
'TActiveRatingList' => 'Prado\Web\UI\ActiveControls\TActiveRatingList',
'TActiveRepeater' => 'Prado\Web\UI\ActiveControls\TActiveRepeater',
'TActiveTableCell' => 'Prado\Web\UI\ActiveControls\TActiveTableCell',
'TActiveTableCellEventParameter' => 'Prado\Web\UI\ActiveControls\TActiveTableCellEventParameter',
'TActiveTableRow' => 'Prado\Web\UI\ActiveControls\TActiveTableRow',
'TActiveTableRowEventParameter' => 'Prado\Web\UI\ActiveControls\TActiveTableRowEventParameter',
'TActiveTemplateColumn' => 'Prado\Web\UI\ActiveControls\TActiveTemplateColumn',
'TActiveTextBox' => 'Prado\Web\UI\ActiveControls\TActiveTextBox',
'TBaseActiveCallbackControl' => 'Prado\Web\UI\ActiveControls\TBaseActiveCallbackControl',
'TBaseActiveControl' => 'Prado\Web\UI\ActiveControls\TBaseActiveControl',
'TCallback' => 'Prado\Web\UI\ActiveControls\TCallback',
'TCallbackClientScript' => 'Prado\Web\UI\ActiveControls\TCallbackClientScript',
'TCallbackClientSide' => 'Prado\Web\UI\ActiveControls\TCallbackClientSide',
'TCallbackErrorHandler' => 'Prado\Web\UI\ActiveControls\TCallbackErrorHandler',
'TCallbackEventParameter' => 'Prado\Web\UI\ActiveControls\TCallbackEventParameter',
'TCallbackOptions' => 'Prado\Web\UI\ActiveControls\TCallbackOptions',
'TCallbackPageStateTracker' => 'Prado\Web\UI\ActiveControls\TCallbackPageStateTracker',
'TCallbackResponseAdapter' => 'Prado\Web\UI\ActiveControls\TCallbackResponseAdapter',
'TCallbackResponseWriter' => 'Prado\Web\UI\ActiveControls\TCallbackResponseWriter',
'TEventTriggeredCallback' => 'Prado\Web\UI\ActiveControls\TEventTriggeredCallback',
'TInPlaceTextBox' => 'Prado\Web\UI\ActiveControls\TInPlaceTextBox',
'TInvalidCallbackException' => 'Prado\Web\UI\ActiveControls\TInvalidCallbackException',
'TMapCollectionDiff' => 'Prado\Web\UI\ActiveControls\TMapCollectionDiff',
'TScalarDiff' => 'Prado\Web\UI\ActiveControls\TScalarDiff',
'TStyleDiff' => 'Prado\Web\UI\ActiveControls\TStyleDiff',
'TTimeTriggeredCallback' => 'Prado\Web\UI\ActiveControls\TTimeTriggeredCallback',
'TTriggeredCallback' => 'Prado\Web\UI\ActiveControls\TTriggeredCallback',
'TValueTriggeredCallback' => 'Prado\Web\UI\ActiveControls\TValueTriggeredCallback',
'TViewStateDiff' => 'Prado\Web\UI\ActiveControls\TViewStateDiff',
'IBindable' => 'Prado\Web\UI\IBindable',
'IBroadcastEventReceiver' => 'Prado\Web\UI\IBroadcastEventReceiver',
'IButtonControl' => 'Prado\Web\UI\IButtonControl',
'INamingContainer' => 'Prado\Web\UI\INamingContainer',
'IPageStatePersister' => 'Prado\Web\UI\IPageStatePersister',
'IPostBackDataHandler' => 'Prado\Web\UI\IPostBackDataHandler',
'IPostBackEventHandler' => 'Prado\Web\UI\IPostBackEventHandler',
'IRenderable' => 'Prado\Web\UI\IRenderable',
'ISurroundable' => 'Prado\Web\UI\ISurroundable',
'ITemplate' => 'Prado\Web\UI\ITemplate',
'ITheme' => 'Prado\Web\UI\ITheme',
'IValidatable' => 'Prado\Web\UI\IValidatable',
'IValidator' => 'Prado\Web\UI\IValidator',
'IJuiOptions' => 'Prado\Web\UI\JuiControls\IJuiOptions',
'TJuiAutoComplete' => 'Prado\Web\UI\JuiControls\TJuiAutoComplete',
'TJuiAutoCompleteEventParameter' => 'Prado\Web\UI\JuiControls\TJuiAutoCompleteEventParameter',
'TJuiAutoCompleteTemplate' => 'Prado\Web\UI\JuiControls\TJuiAutoCompleteTemplate',
'TJuiCallbackPageStateTracker' => 'Prado\Web\UI\JuiControls\TJuiCallbackPageStateTracker',
'TJuiControlAdapter' => 'Prado\Web\UI\JuiControls\TJuiControlAdapter',
'TJuiControlOptions' => 'Prado\Web\UI\JuiControls\TJuiControlOptions',
'TJuiDatePicker' => 'Prado\Web\UI\JuiControls\TJuiDatePicker',
'TJuiDialog' => 'Prado\Web\UI\JuiControls\TJuiDialog',
'TJuiDialogButton' => 'Prado\Web\UI\JuiControls\TJuiDialogButton',
'TJuiDraggable' => 'Prado\Web\UI\JuiControls\TJuiDraggable',
'TJuiDroppable' => 'Prado\Web\UI\JuiControls\TJuiDroppable',
'TJuiEventParameter' => 'Prado\Web\UI\JuiControls\TJuiEventParameter',
'TJuiProgressbar' => 'Prado\Web\UI\JuiControls\TJuiProgressbar',
'TJuiResizable' => 'Prado\Web\UI\JuiControls\TJuiResizable',
'TJuiSelectable' => 'Prado\Web\UI\JuiControls\TJuiSelectable',
'TJuiSelectableTemplate' => 'Prado\Web\UI\JuiControls\TJuiSelectableTemplate',
'TJuiSortable' => 'Prado\Web\UI\JuiControls\TJuiSortable',
'TJuiSortableTemplate' => 'Prado\Web\UI\JuiControls\TJuiSortableTemplate',
'TBroadcastEventParameter' => 'Prado\Web\UI\TBroadcastEventParameter',
'TCachePageStatePersister' => 'Prado\Web\UI\TCachePageStatePersister',
'TClientScriptManager' => 'Prado\Web\UI\TClientScriptManager',
'TClientSideOptions' => 'Prado\Web\UI\TClientSideOptions',
'TCommandEventParameter' => 'Prado\Web\UI\TCommandEventParameter',
'TCompositeControl' => 'Prado\Web\UI\TCompositeControl',
'TCompositeLiteral' => 'Prado\Web\UI\TCompositeLiteral',
'TControl' => 'Prado\Web\UI\TControl',
'TControlAdapter' => 'Prado\Web\UI\TControlAdapter',
'TControlCollection' => 'Prado\Web\UI\TControlCollection',
'TEmptyControlCollection' => 'Prado\Web\UI\TEmptyControlCollection',
'TEventContent' => 'Prado\Web\UI\TEventContent',
'TForm' => 'Prado\Web\UI\TForm',
'THtmlWriter' => 'Prado\Web\UI\THtmlWriter',
'TPage' => 'Prado\Web\UI\TPage',
'TPageStateFormatter' => 'Prado\Web\UI\TPageStateFormatter',
'TPageStatePersister' => 'Prado\Web\UI\TPageStatePersister',
'TSessionPageStatePersister' => 'Prado\Web\UI\TSessionPageStatePersister',
'TSkinTemplate' => 'Prado\Web\UI\TSkinTemplate',
'TTemplate' => 'Prado\Web\UI\TTemplate',
'TTemplateControl' => 'Prado\Web\UI\TTemplateControl',
'TTemplateControlInheritable' => 'Prado\Web\UI\TTemplateControlInheritable',
'TTemplateManager' => 'Prado\Web\UI\TTemplateManager',
'TTheme' => 'Prado\Web\UI\TTheme',
'TThemeManager' => 'Prado\Web\UI\TThemeManager',
'TWebColors' => 'Prado\Web\UI\TWebColors',
'IDataSource' => 'Prado\Web\UI\WebControls\IDataSource',
'IItemDataRenderer' => 'Prado\Web\UI\WebControls\IItemDataRenderer',
'IListControlAdapter' => 'Prado\Web\UI\WebControls\IListControlAdapter',
'IRepeatInfoUser' => 'Prado\Web\UI\WebControls\IRepeatInfoUser',
'IStyleable' => 'Prado\Web\UI\WebControls\IStyleable',
'TAccordion' => 'Prado\Web\UI\WebControls\TAccordion',
'TAccordionView' => 'Prado\Web\UI\WebControls\TAccordionView',
'TAccordionViewCollection' => 'Prado\Web\UI\WebControls\TAccordionViewCollection',
'TBaseDataList' => 'Prado\Web\UI\WebControls\TBaseDataList',
'TBaseValidator' => 'Prado\Web\UI\WebControls\TBaseValidator',
'TBoundColumn' => 'Prado\Web\UI\WebControls\TBoundColumn',
'TBulletedList' => 'Prado\Web\UI\WebControls\TBulletedList',
'TBulletedListDisplayMode' => 'Prado\Web\UI\WebControls\TBulletedListDisplayMode',
'TBulletedListEventParameter' => 'Prado\Web\UI\WebControls\TBulletedListEventParameter',
'TBulletStyle' => 'Prado\Web\UI\WebControls\TBulletStyle',
'TButton' => 'Prado\Web\UI\WebControls\TButton',
'TButtonColumn' => 'Prado\Web\UI\WebControls\TButtonColumn',
'TButtonColumnType' => 'Prado\Web\UI\WebControls\TButtonColumnType',
'TButtonTag' => 'Prado\Web\UI\WebControls\TButtonTag',
'TButtonType' => 'Prado\Web\UI\WebControls\TButtonType',
'TCaptcha' => 'Prado\Web\UI\WebControls\TCaptcha',
'TCaptchaValidator' => 'Prado\Web\UI\WebControls\TCaptchaValidator',
'TCheckBox' => 'Prado\Web\UI\WebControls\TCheckBox',
'TCheckBoxColumn' => 'Prado\Web\UI\WebControls\TCheckBoxColumn',
'TCheckBoxItem' => 'Prado\Web\UI\WebControls\TCheckBoxItem',
'TCheckBoxList' => 'Prado\Web\UI\WebControls\TCheckBoxList',
'TCircleHotSpot' => 'Prado\Web\UI\WebControls\TCircleHotSpot',
'TClientScript' => 'Prado\Web\UI\WebControls\TClientScript',
'TClientSideValidationSummaryOptions' => 'Prado\Web\UI\WebControls\TClientSideValidationSummaryOptions',
'TColorPicker' => 'Prado\Web\UI\WebControls\TColorPicker',
'TColorPickerClientSide' => 'Prado\Web\UI\WebControls\TColorPickerClientSide',
'TColorPickerMode' => 'Prado\Web\UI\WebControls\TColorPickerMode',
'TCompareValidator' => 'Prado\Web\UI\WebControls\TCompareValidator',
'TCompleteWizardStep' => 'Prado\Web\UI\WebControls\TCompleteWizardStep',
'TConditional' => 'Prado\Web\UI\WebControls\TConditional',
'TContent' => 'Prado\Web\UI\WebControls\TContent',
'TContentDirection' => 'Prado\Web\UI\WebControls\TContentDirection',
'TContentPlaceHolder' => 'Prado\Web\UI\WebControls\TContentPlaceHolder',
'TCustomValidator' => 'Prado\Web\UI\WebControls\TCustomValidator',
'TDataBoundControl' => 'Prado\Web\UI\WebControls\TDataBoundControl',
'TDataGrid' => 'Prado\Web\UI\WebControls\TDataGrid',
'TDataGridColumn' => 'Prado\Web\UI\WebControls\TDataGridColumn',
'TDataGridColumnCollection' => 'Prado\Web\UI\WebControls\TDataGridColumnCollection',
'TDataGridCommandEventParameter' => 'Prado\Web\UI\WebControls\TDataGridCommandEventParameter',
'TDataGridItem' => 'Prado\Web\UI\WebControls\TDataGridItem',
'TDataGridItemCollection' => 'Prado\Web\UI\WebControls\TDataGridItemCollection',
'TDataGridItemEventParameter' => 'Prado\Web\UI\WebControls\TDataGridItemEventParameter',
'TDataGridItemRenderer' => 'Prado\Web\UI\WebControls\TDataGridItemRenderer',
'TDataGridPageChangedEventParameter' => 'Prado\Web\UI\WebControls\TDataGridPageChangedEventParameter',
'TDataGridPager' => 'Prado\Web\UI\WebControls\TDataGridPager',
'TDataGridPagerButtonType' => 'Prado\Web\UI\WebControls\TDataGridPagerButtonType',
'TDataGridPagerEventParameter' => 'Prado\Web\UI\WebControls\TDataGridPagerEventParameter',
'TDataGridPagerMode' => 'Prado\Web\UI\WebControls\TDataGridPagerMode',
'TDataGridPagerPosition' => 'Prado\Web\UI\WebControls\TDataGridPagerPosition',
'TDataGridPagerStyle' => 'Prado\Web\UI\WebControls\TDataGridPagerStyle',
'TDataGridSortCommandEventParameter' => 'Prado\Web\UI\WebControls\TDataGridSortCommandEventParameter',
'TDataList' => 'Prado\Web\UI\WebControls\TDataList',
'TDataListCommandEventParameter' => 'Prado\Web\UI\WebControls\TDataListCommandEventParameter',
'TDataListItem' => 'Prado\Web\UI\WebControls\TDataListItem',
'TDataListItemCollection' => 'Prado\Web\UI\WebControls\TDataListItemCollection',
'TDataListItemEventParameter' => 'Prado\Web\UI\WebControls\TDataListItemEventParameter',
'TDataListItemRenderer' => 'Prado\Web\UI\WebControls\TDataListItemRenderer',
'TDataRenderer' => 'Prado\Web\UI\WebControls\TDataRenderer',
'TDataSize' => 'Prado\Web\UI\WebControls\TDataSize',
'TDataSourceControl' => 'Prado\Web\UI\WebControls\TDataSourceControl',
'TDataSourceSelectParameters' => 'Prado\Web\UI\WebControls\TDataSourceSelectParameters',
'TDataSourceView' => 'Prado\Web\UI\WebControls\TDataSourceView',
'TDataTypeValidator' => 'Prado\Web\UI\WebControls\TDataTypeValidator',
'TDatePicker' => 'Prado\Web\UI\WebControls\TDatePicker',
'TDatePickerClientScript' => 'Prado\Web\UI\WebControls\TDatePickerClientScript',
'TDatePickerInputMode' => 'Prado\Web\UI\WebControls\TDatePickerInputMode',
'TDatePickerMode' => 'Prado\Web\UI\WebControls\TDatePickerMode',
'TDatePickerPositionMode' => 'Prado\Web\UI\WebControls\TDatePickerPositionMode',
'TDisplayStyle' => 'Prado\Web\UI\WebControls\TDisplayStyle',
'TDropDownList' => 'Prado\Web\UI\WebControls\TDropDownList',
'TDropDownListColumn' => 'Prado\Web\UI\WebControls\TDropDownListColumn',
'TEditCommandColumn' => 'Prado\Web\UI\WebControls\TEditCommandColumn',
'TEmailAddressValidator' => 'Prado\Web\UI\WebControls\TEmailAddressValidator',
'TExpression' => 'Prado\Web\UI\WebControls\TExpression',
'TFileUpload' => 'Prado\Web\UI\WebControls\TFileUpload',
'TFileUploadItem' => 'Prado\Web\UI\WebControls\TFileUploadItem',
'TFlushOutput' => 'Prado\Web\UI\WebControls\TFlushOutput',
'TFont' => 'Prado\Web\UI\WebControls\TFont',
'TGravatar' => 'Prado\Web\UI\WebControls\TGravatar',
'THead' => 'Prado\Web\UI\WebControls\THead',
'THeader1' => 'Prado\Web\UI\WebControls\THeader1',
'THeader2' => 'Prado\Web\UI\WebControls\THeader2',
'THeader3' => 'Prado\Web\UI\WebControls\THeader3',
'THeader4' => 'Prado\Web\UI\WebControls\THeader4',
'THeader5' => 'Prado\Web\UI\WebControls\THeader5',
'THeader6' => 'Prado\Web\UI\WebControls\THeader6',
'THiddenField' => 'Prado\Web\UI\WebControls\THiddenField',
'THorizontalAlign' => 'Prado\Web\UI\WebControls\THorizontalAlign',
'THotSpot' => 'Prado\Web\UI\WebControls\THotSpot',
'THotSpotCollection' => 'Prado\Web\UI\WebControls\THotSpotCollection',
'THotSpotMode' => 'Prado\Web\UI\WebControls\THotSpotMode',
'THtmlArea' => 'Prado\Web\UI\WebControls\THtmlArea',
'THtmlArea5' => 'Prado\Web\UI\WebControls\THtmlArea5',
'THtmlElement' => 'Prado\Web\UI\WebControls\THtmlElement',
'THyperLink' => 'Prado\Web\UI\WebControls\THyperLink',
'THyperLinkColumn' => 'Prado\Web\UI\WebControls\THyperLinkColumn',
'TImage' => 'Prado\Web\UI\WebControls\TImage',
'TImageButton' => 'Prado\Web\UI\WebControls\TImageButton',
'TImageClickEventParameter' => 'Prado\Web\UI\WebControls\TImageClickEventParameter',
'TImageMap' => 'Prado\Web\UI\WebControls\TImageMap',
'TImageMapEventParameter' => 'Prado\Web\UI\WebControls\TImageMapEventParameter',
'TInlineFrame' => 'Prado\Web\UI\WebControls\TInlineFrame',
'TInlineFrameAlign' => 'Prado\Web\UI\WebControls\TInlineFrameAlign',
'TInlineFrameScrollBars' => 'Prado\Web\UI\WebControls\TInlineFrameScrollBars',
'TItemDataRenderer' => 'Prado\Web\UI\WebControls\TItemDataRenderer',
'TJavascriptLogger' => 'Prado\Web\UI\WebControls\TJavascriptLogger',
'TKeyboard' => 'Prado\Web\UI\WebControls\TKeyboard',
'TLabel' => 'Prado\Web\UI\WebControls\TLabel',
'TLinkButton' => 'Prado\Web\UI\WebControls\TLinkButton',
'TListBox' => 'Prado\Web\UI\WebControls\TListBox',
'TListControl' => 'Prado\Web\UI\WebControls\TListControl',
'TListControlValidator' => 'Prado\Web\UI\WebControls\TListControlValidator',
'TListItem' => 'Prado\Web\UI\WebControls\TListItem',
'TListItemType' => 'Prado\Web\UI\WebControls\TListItemType',
'TListSelectionMode' => 'Prado\Web\UI\WebControls\TListSelectionMode',
'TLiteral' => 'Prado\Web\UI\WebControls\TLiteral',
'TLiteralColumn' => 'Prado\Web\UI\WebControls\TLiteralColumn',
'TMarkdown' => 'Prado\Web\UI\WebControls\TMarkdown',
'TMetaTag' => 'Prado\Web\UI\WebControls\TMetaTag',
'TMetaTagCollection' => 'Prado\Web\UI\WebControls\TMetaTagCollection',
'TMultiView' => 'Prado\Web\UI\WebControls\TMultiView',
'TOutputCache' => 'Prado\Web\UI\WebControls\TOutputCache',
'TOutputCacheCalculateKeyEventParameter' => 'Prado\Web\UI\WebControls\TOutputCacheCalculateKeyEventParameter',
'TOutputCacheCheckDependencyEventParameter' => 'Prado\Web\UI\WebControls\TOutputCacheCheckDependencyEventParameter',
'TOutputCacheTextWriterMulti' => 'Prado\Web\UI\WebControls\TOutputCacheTextWriterMulti',
'TPager' => 'Prado\Web\UI\WebControls\TPager',
'TPageLoadTime' => 'Prado\Web\UI\WebControls\TPageLoadTime',
'TPagerButtonType' => 'Prado\Web\UI\WebControls\TPagerButtonType',
'TPagerMode' => 'Prado\Web\UI\WebControls\TPagerMode',
'TPagerPageChangedEventParameter' => 'Prado\Web\UI\WebControls\TPagerPageChangedEventParameter',
'TPanel' => 'Prado\Web\UI\WebControls\TPanel',
'TPanelStyle' => 'Prado\Web\UI\WebControls\TPanelStyle',
'TPlaceHolder' => 'Prado\Web\UI\WebControls\TPlaceHolder',
'TPolygonHotSpot' => 'Prado\Web\UI\WebControls\TPolygonHotSpot',
'TRadioButton' => 'Prado\Web\UI\WebControls\TRadioButton',
'TRadioButtonItem' => 'Prado\Web\UI\WebControls\TRadioButtonItem',
'TRadioButtonList' => 'Prado\Web\UI\WebControls\TRadioButtonList',
'TRangeValidationDataType' => 'Prado\Web\UI\WebControls\TRangeValidationDataType',
'TRangeValidator' => 'Prado\Web\UI\WebControls\TRangeValidator',
'TRatingList' => 'Prado\Web\UI\WebControls\TRatingList',
'TReadOnlyDataSource' => 'Prado\Web\UI\WebControls\TReadOnlyDataSource',
'TReadOnlyDataSourceView' => 'Prado\Web\UI\WebControls\TReadOnlyDataSourceView',
'TReCaptcha' => 'Prado\Web\UI\WebControls\TReCaptcha',
'TReCaptcha2' => 'Prado\Web\UI\WebControls\TReCaptcha2',
'TReCaptcha2Validator' => 'Prado\Web\UI\WebControls\TReCaptcha2Validator',
'TReCaptchaValidator' => 'Prado\Web\UI\WebControls\TReCaptchaValidator',
'TRectangleHotSpot' => 'Prado\Web\UI\WebControls\TRectangleHotSpot',
'TRegularExpressionValidator' => 'Prado\Web\UI\WebControls\TRegularExpressionValidator',
'TRepeatDirection' => 'Prado\Web\UI\WebControls\TRepeatDirection',
'TRepeater' => 'Prado\Web\UI\WebControls\TRepeater',
'TRepeaterCommandEventParameter' => 'Prado\Web\UI\WebControls\TRepeaterCommandEventParameter',
'TRepeaterItem' => 'Prado\Web\UI\WebControls\TRepeaterItem',
'TRepeaterItemCollection' => 'Prado\Web\UI\WebControls\TRepeaterItemCollection',
'TRepeaterItemEventParameter' => 'Prado\Web\UI\WebControls\TRepeaterItemEventParameter',
'TRepeaterItemRenderer' => 'Prado\Web\UI\WebControls\TRepeaterItemRenderer',
'TRepeatInfo' => 'Prado\Web\UI\WebControls\TRepeatInfo',
'TRepeatLayout' => 'Prado\Web\UI\WebControls\TRepeatLayout',
'TRequiredFieldValidator' => 'Prado\Web\UI\WebControls\TRequiredFieldValidator',
'TSafeHtml' => 'Prado\Web\UI\WebControls\TSafeHtml',
'TScrollBars' => 'Prado\Web\UI\WebControls\TScrollBars',
'TServerValidateEventParameter' => 'Prado\Web\UI\WebControls\TServerValidateEventParameter',
'TSlider' => 'Prado\Web\UI\WebControls\TSlider',
'TSliderClientScript' => 'Prado\Web\UI\WebControls\TSliderClientScript',
'TSliderDirection' => 'Prado\Web\UI\WebControls\TSliderDirection',
'TStatements' => 'Prado\Web\UI\WebControls\TStatements',
'TStyle' => 'Prado\Web\UI\WebControls\TStyle',
'TStyleSheet' => 'Prado\Web\UI\WebControls\TStyleSheet',
'TTable' => 'Prado\Web\UI\WebControls\TTable',
'TTableCaptionAlign' => 'Prado\Web\UI\WebControls\TTableCaptionAlign',
'TTableCell' => 'Prado\Web\UI\WebControls\TTableCell',
'TTableCellCollection' => 'Prado\Web\UI\WebControls\TTableCellCollection',
'TTableFooterRow' => 'Prado\Web\UI\WebControls\TTableFooterRow',
'TTableGridLines' => 'Prado\Web\UI\WebControls\TTableGridLines',
'TTableHeaderCell' => 'Prado\Web\UI\WebControls\TTableHeaderCell',
'TTableHeaderRow' => 'Prado\Web\UI\WebControls\TTableHeaderRow',
'TTableHeaderScope' => 'Prado\Web\UI\WebControls\TTableHeaderScope',
'TTableItemStyle' => 'Prado\Web\UI\WebControls\TTableItemStyle',
'TTableRow' => 'Prado\Web\UI\WebControls\TTableRow',
'TTableRowCollection' => 'Prado\Web\UI\WebControls\TTableRowCollection',
'TTableRowSection' => 'Prado\Web\UI\WebControls\TTableRowSection',
'TTableStyle' => 'Prado\Web\UI\WebControls\TTableStyle',
'TTabPanel' => 'Prado\Web\UI\WebControls\TTabPanel',
'TTabView' => 'Prado\Web\UI\WebControls\TTabView',
'TTabViewCollection' => 'Prado\Web\UI\WebControls\TTabViewCollection',
'TTemplateColumn' => 'Prado\Web\UI\WebControls\TTemplateColumn',
'TTemplatedWizardStep' => 'Prado\Web\UI\WebControls\TTemplatedWizardStep',
'TTextAlign' => 'Prado\Web\UI\WebControls\TTextAlign',
'TTextBox' => 'Prado\Web\UI\WebControls\TTextBox',
'TTextBoxAutoCompleteType' => 'Prado\Web\UI\WebControls\TTextBoxAutoCompleteType',
'TTextBoxMode' => 'Prado\Web\UI\WebControls\TTextBoxMode',
'TTextHighlighter' => 'Prado\Web\UI\WebControls\TTextHighlighter',
'TTextProcessor' => 'Prado\Web\UI\WebControls\TTextProcessor',
'TValidationCompareOperator' => 'Prado\Web\UI\WebControls\TValidationCompareOperator',
'TValidationDataType' => 'Prado\Web\UI\WebControls\TValidationDataType',
'TValidationSummary' => 'Prado\Web\UI\WebControls\TValidationSummary',
'TValidationSummaryDisplayMode' => 'Prado\Web\UI\WebControls\TValidationSummaryDisplayMode',
'TValidationSummaryDisplayStyle' => 'Prado\Web\UI\WebControls\TValidationSummaryDisplayStyle',
'TValidatorClientSide' => 'Prado\Web\UI\WebControls\TValidatorClientSide',
'TValidatorDisplayStyle' => 'Prado\Web\UI\WebControls\TValidatorDisplayStyle',
'TVerticalAlign' => 'Prado\Web\UI\WebControls\TVerticalAlign',
'TView' => 'Prado\Web\UI\WebControls\TView',
'TViewCollection' => 'Prado\Web\UI\WebControls\TViewCollection',
'TWebControl' => 'Prado\Web\UI\WebControls\TWebControl',
'TWebControlAdapter' => 'Prado\Web\UI\WebControls\TWebControlAdapter',
'TWebControlDecorator' => 'Prado\Web\UI\WebControls\TWebControlDecorator',
'TWizard' => 'Prado\Web\UI\WebControls\TWizard',
'TWizardFinishNavigationTemplate' => 'Prado\Web\UI\WebControls\TWizardFinishNavigationTemplate',
'TWizardNavigationButtonStyle' => 'Prado\Web\UI\WebControls\TWizardNavigationButtonStyle',
'TWizardNavigationButtonType' => 'Prado\Web\UI\WebControls\TWizardNavigationButtonType',
'TWizardNavigationContainer' => 'Prado\Web\UI\WebControls\TWizardNavigationContainer',
'TWizardNavigationEventParameter' => 'Prado\Web\UI\WebControls\TWizardNavigationEventParameter',
'TWizardNavigationTemplate' => 'Prado\Web\UI\WebControls\TWizardNavigationTemplate',
'TWizardSideBarListItemTemplate' => 'Prado\Web\UI\WebControls\TWizardSideBarListItemTemplate',
'TWizardSideBarTemplate' => 'Prado\Web\UI\WebControls\TWizardSideBarTemplate',
'TWizardStartNavigationTemplate' => 'Prado\Web\UI\WebControls\TWizardStartNavigationTemplate',
'TWizardStep' => 'Prado\Web\UI\WebControls\TWizardStep',
'TWizardStepCollection' => 'Prado\Web\UI\WebControls\TWizardStepCollection',
'TWizardStepNavigationTemplate' => 'Prado\Web\UI\WebControls\TWizardStepNavigationTemplate',
'TWizardStepType' => 'Prado\Web\UI\WebControls\TWizardStepType',
'TXmlTransform' => 'Prado\Web\UI\WebControls\TXmlTransform',
'TXmlDocument' => 'Prado\Xml\TXmlDocument',
'TXmlElement' => 'Prado\Xml\TXmlElement',
'TXmlElementList' => 'Prado\Xml\TXmlElementList',
];
