# Contributing to ProcessWire

Thank you for your interest in contributing to ProcessWire via issue reports, feature 
requests, or pull requests. To keep things organized, we manage each of these 3 types
of contributions in different repositories. Please review the instructions for each below. 


## Issue Reports

- Submit ProcessWire issue reports to the issues repository:
  [processwire-issues](https://github.com/processwire/processwire-issues/issues)
  
- Please do not submit feature requests to the issues repository, instead use the requests repository:
  [processwire-requests](https://github.com/processwire/processwire-requests/issues)
  
- Please do not use the issues repository for ProcessWire support, instead use the support forum:  
  <https://processwire.com/talk/>
  
- Always include the full ProcessWire version (i.e. 3.0.34). Also include the PHP or MySQL version 
  when potentially applicable. 

- Indicate any 3rd party modules that are installed. 

- When possible please confirm the issue on a separate installation before submitting 
  an issue report.
  
- When the issue is resolved, please close it.   


## Feature Requests

- Submit feature requests to the requests repository:
  [processwire-requests](https://github.com/processwire/processwire-requests/issues)
  
- Please note that we generally avoid adding features that aren't going to be used by at least
  30% of the ProcessWire audience. Often new features can be better accommodated with modules. 
  
- If we close your feature request, this does not mean it won't ever be implemented. It just means
  that we aren't ready to implement it just yet. Closed feature requests aren't ever deleted, so 
  consider closed feature requests to just be on the back burner. 
  
- Sometimes we will leave a feature request open for awhile to see how much interest it gains from
  others before we decide whether it should be implemented. 
  
- See also the [Wishlist & Roadmap board](https://processwire.com/talk/forum/5-wishlist-roadmap/).  
  

## Pull Requests (PRs)

- Pull requests should be submitted to the [processwire](https://github.com/processwire/processwire/pulls)
  repository, and based on the [dev branch](https://github.com/processwire/processwire/tree/dev). 

- Before submitting a PR, read the Contributor License Agreement (CLA) at
  <https://processwire.com/about/license/cla/> and indicate your agreement (electronic signature) 
  by completing the form at the bottom of the page. 

- Please note that we generally avoid adding features that aren't going to be used by at least
  30% of the ProcessWire audience. Often new features can be better accommodated with modules.
  When in doubt, submit a [feature request](https://github.com/processwire/processwire-requests/issues)
  first to propose what you'd like to add, and indicate that you are able to submit a PR for it. 

- See the ProcessWire [Coding Style Guide](http://processwire.com/api/coding-style-guide/)
  before submitting a PR. While it's not required that you adhere to the style guide, it does increase
  the odds that we may be able to directly merge your PR. 
  
- Please only submit code that you feel confident is stable and you have thoroughly tested. 
  Verbose code comments are also appreciated when possible. 
  
- In many cases we do not directly merge pull requests with our established workflow. If we do
  not directly merge the pull request, but do add the proposed features/changes, you will still be 
  fully credited directly in the commit message and often times in our blog. 
  

