SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `procwire30255`
--

-- --------------------------------------------------------

--
-- Table structure for table `caches`
--

CREATE TABLE `caches` (
  `name` varchar(191) NOT NULL,
  `data` mediumtext NOT NULL,
  `expires` datetime NOT NULL,
  PRIMARY KEY (`name`),
  KEY `expires` (`expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `caches`
--

-- --------------------------------------------------------

--
-- Table structure for table `fieldgroups`
--

CREATE TABLE `fieldgroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET ascii NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=97 ;

--
-- Dumping data for table `fieldgroups`
--

INSERT INTO `fieldgroups` VALUES
(2, 'admin'),
(83, 'basic-page'),
(1, 'home'),
(5, 'permission'),
(4, 'role'),
(3, 'user');

-- --------------------------------------------------------

--
-- Table structure for table `fieldgroups_fields`
--

CREATE TABLE `fieldgroups_fields` (
  `fieldgroups_id` int(10) unsigned NOT NULL DEFAULT '0',
  `fields_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sort` int(11) unsigned NOT NULL DEFAULT '0',
  `data` text,
  PRIMARY KEY (`fieldgroups_id`,`fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `fieldgroups_fields`
--

INSERT INTO `fieldgroups_fields` VALUES
(1, 1, 0, NULL),
(2, 1, 0, NULL),
(2, 2, 1, NULL),
(3, 3, 0, NULL),
(3, 4, 2, NULL),
(3, 92, 1, NULL),
(3, 97, 3, NULL),
(4, 5, 0, NULL),
(5, 1, 0, NULL),
(83, 1, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `fields`
--

CREATE TABLE `fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(128) CHARACTER SET ascii NOT NULL,
  `name` varchar(191) CHARACTER SET ascii NOT NULL,
  `flags` int(11) NOT NULL DEFAULT '0',
  `label` varchar(191) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=98 ;

--
-- Dumping data for table `fields`
--

INSERT INTO `fields` VALUES
(1, 'FieldtypePageTitle', 'title', 13, 'Title', '{"required":1,"textformatters":["TextformatterEntities"],"size":0,"maxlength":255}'),
(2, 'FieldtypeModule', 'process', 25, 'Process', '{"description":"The process that is executed on this page. Since this is mostly used by ProcessWire internally, it is recommended that you don''t change the value of this unless adding your own pages in the admin.","collapsed":1,"required":1,"moduleTypes":["Process"],"permanent":1}'),
(3, 'FieldtypePassword', 'pass', 24, 'Set Password', '{"collapsed":1,"size":50,"maxlength":128}'),
(4, 'FieldtypePage', 'roles', 24, 'Roles', '{"derefAsPage":0,"parent_id":30,"labelFieldName":"name","inputfield":"InputfieldCheckboxes","description":"User will inherit the permissions assigned to each role. You may assign multiple roles to a user. When accessing a page, the user will only inherit permissions from the roles that are also assigned to the page''s template."}'),
(5, 'FieldtypePage', 'permissions', 24, 'Permissions', '{"derefAsPage":0,"parent_id":31,"labelFieldName":"title","inputfield":"InputfieldCheckboxes"}'),
(92, 'FieldtypeEmail', 'email', 9, 'E-Mail Address', '{"size":70,"maxlength":255}'),
(97, 'FieldtypeModule', 'admin_theme', 8, 'Admin Theme', '{"moduleTypes":["AdminTheme"],"labelField":"title","inputfieldClass":"InputfieldRadios"}');

-- --------------------------------------------------------

--
-- Table structure for table `field_admin_theme`
--

CREATE TABLE `field_admin_theme` (
  `pages_id` int(10) unsigned NOT NULL,
  `data` int(11) NOT NULL,
  PRIMARY KEY (`pages_id`),
  KEY `data` (`data`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `field_admin_theme`
--

INSERT INTO `field_admin_theme` VALUES
(41, 187);

-- --------------------------------------------------------

--
-- Table structure for table `field_email`
--

CREATE TABLE `field_email` (
  `pages_id` int(10) unsigned NOT NULL,
  `data` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`pages_id`),
  KEY `data_exact` (`data`),
  FULLTEXT KEY `data` (`data`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `field_email`
--

INSERT INTO `field_email` VALUES
(41, '[[admin_email]]');

-- --------------------------------------------------------

--
-- Table structure for table `field_pass`
--

CREATE TABLE `field_pass` (
  `pages_id` int(10) unsigned NOT NULL,
  `data` char(40) NOT NULL,
  `salt` char(32) NOT NULL,
  PRIMARY KEY (`pages_id`),
  KEY `data` (`data`)
) ENGINE=InnoDB DEFAULT CHARSET=ascii;

--
-- Dumping data for table `field_pass`
--

INSERT INTO `field_pass` VALUES
(40, '', ''),
(41, '[[admin_pass]]', '[[salt_db]]');

-- --------------------------------------------------------

--
-- Table structure for table `field_permissions`
--

CREATE TABLE `field_permissions` (
  `pages_id` int(10) unsigned NOT NULL,
  `data` int(11) NOT NULL,
  `sort` int(10) unsigned NOT NULL,
  PRIMARY KEY (`pages_id`,`sort`),
  KEY `data` (`data`,`pages_id`,`sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `field_permissions`
--

INSERT INTO `field_permissions` VALUES
(38, 32, 1),
(38, 34, 2),
(38, 35, 3),
(37, 36, 0),
(38, 36, 0),
(38, 50, 4),
(38, 51, 5),
(38, 52, 7),
(38, 53, 8),
(38, 54, 6);

-- --------------------------------------------------------

--
-- Table structure for table `field_process`
--

CREATE TABLE `field_process` (
  `pages_id` int(11) NOT NULL DEFAULT '0',
  `data` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`pages_id`),
  KEY `data` (`data`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `field_process`
--

INSERT INTO `field_process` VALUES
(10, 7),
(23, 10),
(3, 12),
(8, 12),
(9, 14),
(6, 17),
(11, 47),
(16, 48),
(21, 50),
(29, 66),
(30, 68),
(22, 76),
(28, 76),
(2, 87),
(300, 104),
(301, 109),
(302, 121),
(303, 129),
(31, 136),
(304, 138),
(1007, 150),
(1010, 175),
(1012, 207);

-- --------------------------------------------------------

--
-- Table structure for table `field_roles`
--

CREATE TABLE `field_roles` (
  `pages_id` int(10) unsigned NOT NULL,
  `data` int(11) NOT NULL,
  `sort` int(10) unsigned NOT NULL,
  PRIMARY KEY (`pages_id`,`sort`),
  KEY `data` (`data`,`pages_id`,`sort`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `field_roles`
--

INSERT INTO `field_roles` VALUES
(40, 37, 0),
(41, 37, 0),
(41, 38, 2);

-- --------------------------------------------------------

--
-- Table structure for table `field_title`
--

CREATE TABLE `field_title` (
  `pages_id` int(10) unsigned NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`pages_id`),
  KEY `data_exact` (`data`(191)),
  FULLTEXT KEY `data` (`data`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `field_title`
--

INSERT INTO `field_title` VALUES
(1, 'Home'),
(2, 'Admin'),
(3, 'Pages'),
(6, 'Add Page'),
(7, 'Trash'),
(8, 'Tree'),
(9, 'Save Sort'),
(10, 'Edit Page'),
(11, 'Templates'),
(16, 'Fields'),
(21, 'Modules'),
(22, 'Setup'),
(23, 'Login'),
(27, '404 Not Found'),
(28, 'Access'),
(29, 'Users'),
(30, 'Roles'),
(31, 'Permissions'),
(32, 'Edit pages'),
(34, 'Delete pages'),
(35, 'Move pages (change parent)'),
(36, 'View pages'),
(50, 'Sort child pages'),
(51, 'Change templates on pages'),
(52, 'Administer users'),
(53, 'User can update profile/password'),
(54, 'Lock or unlock a page'),
(300, 'Search'),
(301, 'Empty Trash'),
(302, 'Insert Link'),
(303, 'Insert Image'),
(304, 'Profile'),
(1006, 'Use Page Lister'),
(1007, 'Find'),
(1010, 'Recent'),
(1011, 'Can see recently edited pages'),
(1012, 'Logs'),
(1013, 'Can view system logs'),
(1014, 'Can manage system logs');

-- --------------------------------------------------------

--
-- Table structure for table `modules`
--

CREATE TABLE `modules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `class` varchar(128) CHARACTER SET ascii NOT NULL,
  `flags` int(11) NOT NULL DEFAULT '0',
  `data` mediumtext NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `class` (`class`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=217 ;

--
-- Dumping data for table `modules`
--

INSERT INTO `modules` VALUES
(1, 'FieldtypeTextarea', 0, '', '[[regtime]]'),
(3, 'FieldtypeText', 0, '', '[[regtime]]'),
(4, 'FieldtypePage', 0, '', '[[regtime]]'),
(6, 'FieldtypeFile', 0, '', '[[regtime]]'),
(7, 'ProcessPageEdit', 1, '', '[[regtime]]'),
(10, 'ProcessLogin', 0, '', '[[regtime]]'),
(12, 'ProcessPageList', 0, '{"pageLabelField":"title","paginationLimit":25,"limit":50}', '[[regtime]]'),
(14, 'ProcessPageSort', 0, '', '[[regtime]]'),
(15, 'InputfieldPageListSelect', 0, '', '[[regtime]]'),
(17, 'ProcessPageAdd', 0, '', '[[regtime]]'),
(25, 'InputfieldAsmSelect', 0, '', '[[regtime]]'),
(27, 'FieldtypeModule', 0, '', '[[regtime]]'),
(28, 'FieldtypeDatetime', 0, '', '[[regtime]]'),
(29, 'FieldtypeEmail', 0, '', '[[regtime]]'),
(30, 'InputfieldForm', 0, '', '[[regtime]]'),
(32, 'InputfieldSubmit', 0, '', '[[regtime]]'),
(34, 'InputfieldText', 0, '', '[[regtime]]'),
(35, 'InputfieldTextarea', 0, '', '[[regtime]]'),
(36, 'InputfieldSelect', 0, '', '[[regtime]]'),
(37, 'InputfieldCheckbox', 0, '', '[[regtime]]'),
(38, 'InputfieldCheckboxes', 0, '', '[[regtime]]'),
(39, 'InputfieldRadios', 0, '', '[[regtime]]'),
(40, 'InputfieldHidden', 0, '', '[[regtime]]'),
(41, 'InputfieldName', 0, '', '[[regtime]]'),
(43, 'InputfieldSelectMultiple', 0, '', '[[regtime]]'),
(45, 'JqueryWireTabs', 0, '', '[[regtime]]'),
(47, 'ProcessTemplate', 0, '', '[[regtime]]'),
(48, 'ProcessField', 32, '', '[[regtime]]'),
(50, 'ProcessModule', 0, '', '[[regtime]]'),
(55, 'InputfieldFile', 0, '', '[[regtime]]'),
(56, 'InputfieldImage', 0, '', '[[regtime]]'),
(57, 'FieldtypeImage', 0, '', '[[regtime]]'),
(60, 'InputfieldPage', 0, '{"inputfieldClasses":["InputfieldSelect","InputfieldSelectMultiple","InputfieldCheckboxes","InputfieldRadios","InputfieldAsmSelect","InputfieldPageListSelect","InputfieldPageListSelectMultiple"]}', '[[regtime]]'),
(61, 'TextformatterEntities', 0, '', '[[regtime]]'),
(66, 'ProcessUser', 0, '{"showFields":["name","email","roles"]}', '[[regtime]]'),
(67, 'MarkupAdminDataTable', 0, '', '[[regtime]]'),
(68, 'ProcessRole', 0, '{"showFields":["name"]}', '[[regtime]]'),
(76, 'ProcessList', 0, '', '[[regtime]]'),
(78, 'InputfieldFieldset', 0, '', '[[regtime]]'),
(79, 'InputfieldMarkup', 0, '', '[[regtime]]'),
(80, 'InputfieldEmail', 0, '', '[[regtime]]'),
(83, 'ProcessPageView', 0, '', '[[regtime]]'),
(84, 'FieldtypeInteger', 0, '', '[[regtime]]'),
(85, 'InputfieldInteger', 0, '', '[[regtime]]'),
(86, 'InputfieldPageName', 0, '', '[[regtime]]'),
(87, 'ProcessHome', 0, '', '[[regtime]]'),
(89, 'FieldtypeFloat', 1, '', '[[regtime]]'),
(90, 'InputfieldFloat', 0, '', '[[regtime]]'),
(94, 'InputfieldDatetime', 0, '', '[[regtime]]'),
(97, 'FieldtypeCheckbox', 1, '', '[[regtime]]'),
(98, 'MarkupPagerNav', 0, '', '[[regtime]]'),
(103, 'JqueryTableSorter', 1, '', '[[regtime]]'),
(104, 'ProcessPageSearch', 1, '{"searchFields":"title","displayField":"title path"}', '[[regtime]]'),
(105, 'FieldtypeFieldsetOpen', 1, '', '[[regtime]]'),
(106, 'FieldtypeFieldsetClose', 1, '', '[[regtime]]'),
(107, 'FieldtypeFieldsetTabOpen', 1, '', '[[regtime]]'),
(108, 'InputfieldURL', 0, '', '[[regtime]]'),
(109, 'ProcessPageTrash', 1, '', '[[regtime]]'),
(111, 'FieldtypePageTitle', 1, '', '[[regtime]]'),
(112, 'InputfieldPageTitle', 0, '', '[[regtime]]'),
(113, 'MarkupPageArray', 3, '', '[[regtime]]'),
(114, 'PagePermissions', 3, '', '[[regtime]]'),
(115, 'PageRender', 3, '{"clearCache":1}', '[[regtime]]'),
(116, 'JqueryCore', 1, '', '[[regtime]]'),
(117, 'JqueryUI', 1, '', '[[regtime]]'),
(121, 'ProcessPageEditLink', 1, '', '[[regtime]]'),
(122, 'InputfieldPassword', 0, '', '[[regtime]]'),
(125, 'SessionLoginThrottle', 11, '', '[[regtime]]'),
(129, 'ProcessPageEditImageSelect', 1, '', '[[regtime]]'),
(131, 'InputfieldButton', 0, '', '[[regtime]]'),
(133, 'FieldtypePassword', 1, '', '[[regtime]]'),
(134, 'ProcessPageType', 33, '{"showFields":[]}', '[[regtime]]'),
(135, 'FieldtypeURL', 1, '', '[[regtime]]'),
(136, 'ProcessPermission', 1, '{"showFields":["name","title"]}', '[[regtime]]'),
(137, 'InputfieldPageListSelectMultiple', 0, '', '[[regtime]]'),
(138, 'ProcessProfile', 1, '{"profileFields":["pass","email","admin_theme"]}', '[[regtime]]'),
(139, 'SystemUpdater', 1, '{"systemVersion":10,"coreVersion":"3.0.255"}', '[[regtime]]'),
(149, 'InputfieldSelector', 42, '', '[[regtime]]'),
(150, 'ProcessPageLister', 32, '', '[[regtime]]'),
(151, 'JqueryMagnific', 1, '', '[[regtime]]'),
(155, 'InputfieldTinyMCE', 0, '', '[[regtime]]'),
(156, 'MarkupHTMLPurifier', 0, '', '[[regtime]]'),
(159, '.Modules.wire/modules/', 8192, 'AdminTheme/AdminThemeDefault/AdminThemeDefault.module\nAdminTheme/AdminThemeReno/AdminThemeReno.module\nAdminTheme/AdminThemeUikit/AdminThemeUikit.module\nFieldtype/FieldtypeCache.module\nFieldtype/FieldtypeCheckbox.module\nFieldtype/FieldtypeComments/CommentFilterAkismet.module\nFieldtype/FieldtypeComments/FieldtypeComments.module\nFieldtype/FieldtypeComments/InputfieldCommentsAdmin.module\nFieldtype/FieldtypeDatetime.module\nFieldtype/FieldtypeDecimal.module\nFieldtype/FieldtypeEmail.module\nFieldtype/FieldtypeFieldsetClose.module\nFieldtype/FieldtypeFieldsetOpen.module\nFieldtype/FieldtypeFieldsetTabOpen.module\nFieldtype/FieldtypeFile/FieldtypeFile.module\nFieldtype/FieldtypeFloat.module\nFieldtype/FieldtypeImage/FieldtypeImage.module\nFieldtype/FieldtypeInteger.module\nFieldtype/FieldtypeModule.module\nFieldtype/FieldtypeOptions/FieldtypeOptions.module\nFieldtype/FieldtypePage.module\nFieldtype/FieldtypePageTable.module\nFieldtype/FieldtypePageTitle.module\nFieldtype/FieldtypePassword.module\nFieldtype/FieldtypeRepeater/FieldtypeFieldsetPage.module\nFieldtype/FieldtypeRepeater/FieldtypeRepeater.module\nFieldtype/FieldtypeRepeater/InputfieldRepeater.module\nFieldtype/FieldtypeSelector.module\nFieldtype/FieldtypeText.module\nFieldtype/FieldtypeTextarea.module\nFieldtype/FieldtypeToggle.module\nFieldtype/FieldtypeURL.module\nFileCompilerTags.module\nFileValidatorZip.module\nImage/ImageSizerEngineAnimatedGif/ImageSizerEngineAnimatedGif.module\nImage/ImageSizerEngineIMagick/ImageSizerEngineIMagick.module\nInputfield/InputfieldAsmSelect/InputfieldAsmSelect.module\nInputfield/InputfieldButton.module\nInputfield/InputfieldCKEditor/InputfieldCKEditor.module\nInputfield/InputfieldCheckbox/InputfieldCheckbox.module\nInputfield/InputfieldCheckboxes/InputfieldCheckboxes.module\nInputfield/InputfieldDatetime/InputfieldDatetime.module\nInputfield/InputfieldEmail.module\nInputfield/InputfieldFieldset.module\nInputfield/InputfieldFile/InputfieldFile.module\nInputfield/InputfieldFloat.module\nInputfield/InputfieldForm.module\nInputfield/InputfieldHidden.module\nInputfield/InputfieldIcon/InputfieldIcon.module\nInputfield/InputfieldImage/InputfieldImage.module\nInputfield/InputfieldInteger.module\nInputfield/InputfieldMarkup.module\nInputfield/InputfieldName.module\nInputfield/InputfieldPage/InputfieldPage.module\nInputfield/InputfieldPageAutocomplete/InputfieldPageAutocomplete.module\nInputfield/InputfieldPageListSelect/InputfieldPageListSelect.module\nInputfield/InputfieldPageListSelect/InputfieldPageListSelectMultiple.module\nInputfield/InputfieldPageName/InputfieldPageName.module\nInputfield/InputfieldPageTable/InputfieldPageTable.module\nInputfield/InputfieldPageTitle/InputfieldPageTitle.module\nInputfield/InputfieldPassword/InputfieldPassword.module\nInputfield/InputfieldRadios/InputfieldRadios.module\nInputfield/InputfieldSelect.module\nInputfield/InputfieldSelectMultiple.module\nInputfield/InputfieldSelector/InputfieldSelector.module\nInputfield/InputfieldSubmit/InputfieldSubmit.module\nInputfield/InputfieldText/InputfieldText.module\nInputfield/InputfieldTextTags/InputfieldTextTags.module\nInputfield/InputfieldTextarea.module\nInputfield/InputfieldTinyMCE/InputfieldTinyMCE.module.php\nInputfield/InputfieldToggle/InputfieldToggle.module\nInputfield/InputfieldURL.module\nJquery/JqueryCore/JqueryCore.module\nJquery/JqueryMagnific/JqueryMagnific.module\nJquery/JqueryTableSorter/JqueryTableSorter.module\nJquery/JqueryUI/JqueryUI.module\nJquery/JqueryWireTabs/JqueryWireTabs.module\nLanguageSupport/FieldtypePageTitleLanguage.module\nLanguageSupport/FieldtypeTextLanguage.module\nLanguageSupport/FieldtypeTextareaLanguage.module\nLanguageSupport/LanguageSupport.module\nLanguageSupport/LanguageSupportFields.module\nLanguageSupport/LanguageSupportPageNames.module\nLanguageSupport/LanguageTabs.module\nLanguageSupport/ProcessLanguage.module\nLanguageSupport/ProcessLanguageTranslator.module\nLazyCron.module\nMarkup/MarkupAdminDataTable/MarkupAdminDataTable.module\nMarkup/MarkupCache.module\nMarkup/MarkupHTMLPurifier/MarkupHTMLPurifier.module\nMarkup/MarkupPageArray.module\nMarkup/MarkupPageFields.module\nMarkup/MarkupPagerNav/MarkupPagerNav.module\nMarkup/MarkupRSS.module\nPage/PageFrontEdit/PageFrontEdit.module\nPagePathHistory.module\nPagePaths.module\nPagePermissions.module\nPageRender.module\nPages/PagesVersions/PagesVersions.module.php\nProcess/ProcessCommentsManager/ProcessCommentsManager.module\nProcess/ProcessField/ProcessField.module\nProcess/ProcessForgotPassword/ProcessForgotPassword.module\nProcess/ProcessHome.module\nProcess/ProcessList.module\nProcess/ProcessLogger/ProcessLogger.module\nProcess/ProcessLogin/ProcessLogin.module\nProcess/ProcessModule/ProcessModule.module\nProcess/ProcessPageAdd/ProcessPageAdd.module\nProcess/ProcessPageClone.module\nProcess/ProcessPageEdit/ProcessPageEdit.module\nProcess/ProcessPageEditImageSelect/ProcessPageEditImageSelect.module\nProcess/ProcessPageEditLink/ProcessPageEditLink.module\nProcess/ProcessPageList/ProcessPageList.module\nProcess/ProcessPageLister/ProcessPageLister.module\nProcess/ProcessPageSearch/ProcessPageSearch.module\nProcess/ProcessPageSort.module\nProcess/ProcessPageTrash.module\nProcess/ProcessPageType/ProcessPageType.module\nProcess/ProcessPageView.module\nProcess/ProcessPagesExportImport/ProcessPagesExportImport.module\nProcess/ProcessPermission/ProcessPermission.module\nProcess/ProcessProfile/ProcessProfile.module\nProcess/ProcessRecentPages/ProcessRecentPages.module\nProcess/ProcessRole/ProcessRole.module\nProcess/ProcessTemplate/ProcessTemplate.module\nProcess/ProcessUser/ProcessUser.module\nSession/SessionHandlerDB/ProcessSessionDB.module\nSession/SessionHandlerDB/SessionHandlerDB.module\nSession/SessionLoginThrottle/SessionLoginThrottle.module\nSystem/SystemNotifications/FieldtypeNotifications.module\nSystem/SystemNotifications/SystemNotifications.module\nSystem/SystemUpdater/SystemUpdater.module\nTextformatter/TextformatterEntities.module\nTextformatter/TextformatterMarkdownExtra/TextformatterMarkdownExtra.module\nTextformatter/TextformatterNewlineBR.module\nTextformatter/TextformatterNewlineUL.module\nTextformatter/TextformatterPstripper.module\nTextformatter/TextformatterSmartypants/TextformatterSmartypants.module\nTextformatter/TextformatterStripTags.module', '[[regtime]]'),
(160, '.Modules.site/modules/', 8192, '', '[[regtime]]'),
(161, '.Modules.info', 8192, '{"187":{"name":"AdminThemeUikit","title":"Uikit","version":36,"icon":"smile-o","autoload":"template=admin","created":[[timestamp]],"configurable":4},"97":{"name":"FieldtypeCheckbox","title":"Checkbox","version":101,"singular":1,"created":[[timestamp]],"permanent":true},"28":{"name":"FieldtypeDatetime","title":"Datetime","version":105,"created":[[timestamp]]},"29":{"name":"FieldtypeEmail","title":"E-Mail","version":101,"created":[[timestamp]]},"106":{"name":"FieldtypeFieldsetClose","title":"Fieldset (Close)","version":100,"singular":1,"created":[[timestamp]],"permanent":true},"105":{"name":"FieldtypeFieldsetOpen","title":"Fieldset (Open)","version":101,"singular":1,"created":[[timestamp]],"permanent":true},"107":{"name":"FieldtypeFieldsetTabOpen","title":"Fieldset in Tab (Open)","version":100,"singular":1,"created":[[timestamp]],"permanent":true},"6":{"name":"FieldtypeFile","title":"Files","version":107,"created":[[timestamp]],"configurable":4,"permanent":true},"89":{"name":"FieldtypeFloat","title":"Float","version":108,"singular":1,"created":[[timestamp]],"permanent":true},"57":{"name":"FieldtypeImage","title":"Images","version":102,"created":[[timestamp]],"configurable":4,"permanent":true},"84":{"name":"FieldtypeInteger","title":"Integer","version":102,"created":[[timestamp]],"permanent":true},"27":{"name":"FieldtypeModule","title":"Module Reference","version":102,"created":[[timestamp]],"permanent":true},"4":{"name":"FieldtypePage","title":"Page Reference","version":107,"created":[[timestamp]],"configurable":3,"permanent":true},"111":{"name":"FieldtypePageTitle","title":"Page Title","version":100,"singular":true,"created":[[timestamp]],"permanent":true},"133":{"name":"FieldtypePassword","title":"Password","version":101,"singular":true,"created":[[timestamp]],"permanent":true},"3":{"name":"FieldtypeText","title":"Text","version":102,"created":[[timestamp]],"permanent":true},"1":{"name":"FieldtypeTextarea","title":"Textarea","version":107,"created":[[timestamp]],"permanent":true},"135":{"name":"FieldtypeURL","title":"URL","version":101,"singular":1,"created":[[timestamp]],"permanent":true},"25":{"name":"InputfieldAsmSelect","title":"asmSelect","version":203,"created":[[timestamp]],"permanent":true},"131":{"name":"InputfieldButton","title":"Button","version":100,"created":[[timestamp]],"permanent":true},"37":{"name":"InputfieldCheckbox","title":"Checkbox","version":106,"created":[[timestamp]],"permanent":true},"38":{"name":"InputfieldCheckboxes","title":"Checkboxes","version":108,"created":[[timestamp]],"permanent":true},"94":{"name":"InputfieldDatetime","title":"Datetime","version":108,"created":[[timestamp]],"permanent":true},"80":{"name":"InputfieldEmail","title":"Email","version":102,"created":[[timestamp]]},"78":{"name":"InputfieldFieldset","title":"Fieldset","version":101,"created":[[timestamp]],"permanent":true},"55":{"name":"InputfieldFile","title":"Files","version":129,"created":[[timestamp]],"permanent":true},"90":{"name":"InputfieldFloat","title":"Float","version":105,"created":[[timestamp]],"permanent":true},"30":{"name":"InputfieldForm","title":"Form","version":107,"created":[[timestamp]],"permanent":true},"40":{"name":"InputfieldHidden","title":"Hidden","version":101,"created":[[timestamp]],"permanent":true},"56":{"name":"InputfieldImage","title":"Images","version":129,"created":[[timestamp]],"permanent":true},"85":{"name":"InputfieldInteger","title":"Integer","version":105,"created":[[timestamp]],"permanent":true},"79":{"name":"InputfieldMarkup","title":"Markup","version":102,"created":[[timestamp]],"permanent":true},"41":{"name":"InputfieldName","title":"Name","version":100,"created":[[timestamp]],"permanent":true},"60":{"name":"InputfieldPage","title":"Page","version":109,"created":[[timestamp]],"configurable":3,"permanent":true},"15":{"name":"InputfieldPageListSelect","title":"Page List Select","version":101,"created":[[timestamp]],"permanent":true},"137":{"name":"InputfieldPageListSelectMultiple","title":"Page List Select Multiple","version":103,"created":[[timestamp]],"permanent":true},"86":{"name":"InputfieldPageName","title":"Page Name","version":106,"created":[[timestamp]],"configurable":3,"permanent":true},"112":{"name":"InputfieldPageTitle","title":"Page Title","version":102,"created":[[timestamp]],"permanent":true},"122":{"name":"InputfieldPassword","title":"Password","version":102,"created":[[timestamp]],"permanent":true},"39":{"name":"InputfieldRadios","title":"Radio Buttons","version":106,"created":[[timestamp]],"permanent":true},"36":{"name":"InputfieldSelect","title":"Select","version":103,"created":[[timestamp]],"permanent":true},"43":{"name":"InputfieldSelectMultiple","title":"Select Multiple","version":101,"created":[[timestamp]],"permanent":true},"149":{"name":"InputfieldSelector","title":"Selector","version":28,"autoload":"template=admin","created":[[timestamp]],"configurable":3,"addFlag":32},"32":{"name":"InputfieldSubmit","title":"Submit","version":103,"created":[[timestamp]],"permanent":true},"34":{"name":"InputfieldText","title":"Text","version":106,"created":[[timestamp]],"permanent":true},"35":{"name":"InputfieldTextarea","title":"Textarea","version":103,"created":[[timestamp]],"permanent":true},"155":{"name":"InputfieldTinyMCE","title":"TinyMCE","version":618,"icon":"keyboard-o","requiresVersions":{"ProcessWire":[">=","3.0.200"],"MarkupHTMLPurifier":[">=",0]},"created":[[timestamp]],"configurable":4},"108":{"name":"InputfieldURL","title":"URL","version":103,"created":[[timestamp]]},"116":{"name":"JqueryCore","title":"jQuery Core","version":"1.12.4","singular":true,"created":[[timestamp]],"permanent":true},"151":{"name":"JqueryMagnific","title":"jQuery Magnific Popup","version":"1.1.0","singular":1,"created":[[timestamp]]},"103":{"name":"JqueryTableSorter","title":"jQuery Table Sorter Plugin","version":"2.31.3","singular":1,"created":[[timestamp]]},"117":{"name":"JqueryUI","title":"jQuery UI","version":"1.10.4","singular":true,"created":[[timestamp]],"permanent":true},"45":{"name":"JqueryWireTabs","title":"jQuery Wire Tabs Plugin","version":110,"created":[[timestamp]],"configurable":3,"permanent":true},"67":{"name":"MarkupAdminDataTable","title":"Admin Data Table","version":108,"created":[[timestamp]],"permanent":true},"156":{"name":"MarkupHTMLPurifier","title":"HTML Purifier","version":497,"created":[[timestamp]]},"113":{"name":"MarkupPageArray","title":"PageArray Markup","version":100,"autoload":true,"singular":true,"created":[[timestamp]]},"98":{"name":"MarkupPagerNav","title":"Pager (Pagination) Navigation","version":105,"created":[[timestamp]]},"114":{"name":"PagePermissions","title":"Page Permissions","version":105,"autoload":true,"singular":true,"created":[[timestamp]],"permanent":true},"115":{"name":"PageRender","title":"Page Render","version":105,"autoload":true,"singular":true,"created":[[timestamp]],"configurable":3,"permanent":true},"48":{"name":"ProcessField","title":"Fields","version":114,"icon":"cube","permission":"field-admin","created":[[timestamp]],"configurable":3,"permanent":true,"useNavJSON":true,"addFlag":32},"87":{"name":"ProcessHome","title":"Admin Home","version":101,"permission":"page-view","created":[[timestamp]],"permanent":true},"76":{"name":"ProcessList","title":"List","version":101,"permission":"page-view","created":[[timestamp]],"permanent":true},"10":{"name":"ProcessLogin","title":"Login","version":109,"permission":"page-view","created":[[timestamp]],"configurable":4,"permanent":true},"50":{"name":"ProcessModule","title":"Modules","version":121,"permission":"module-admin","created":[[timestamp]],"permanent":true,"useNavJSON":true,"nav":[{"url":"?site#tab_site_modules","label":"Site","icon":"plug","navJSON":"navJSON\\/?site=1"},{"url":"?core#tab_core_modules","label":"Core","icon":"plug","navJSON":"navJSON\\/?core=1"},{"url":"?configurable#tab_configurable_modules","label":"Configure","icon":"gear","navJSON":"navJSON\\/?configurable=1"},{"url":"?install#tab_install_modules","label":"Install","icon":"sign-in","navJSON":"navJSON\\/?install=1"},{"url":"?new#tab_new_modules","label":"New","icon":"plus"},{"url":"?reset=1","label":"Refresh","icon":"refresh"}]},"17":{"name":"ProcessPageAdd","title":"Page Add","version":109,"icon":"plus-circle","permission":"page-edit","created":[[timestamp]],"configurable":3,"permanent":true,"useNavJSON":true},"7":{"name":"ProcessPageEdit","title":"Page Edit","version":112,"icon":"edit","permission":"page-edit","singular":1,"created":[[timestamp]],"configurable":3,"permanent":true,"useNavJSON":true},"129":{"name":"ProcessPageEditImageSelect","title":"Page Edit Image","version":121,"permission":"page-edit","singular":1,"created":[[timestamp]],"configurable":3,"permanent":true},"121":{"name":"ProcessPageEditLink","title":"Page Edit Link","version":112,"icon":"link","permission":"page-edit","singular":1,"created":[[timestamp]],"configurable":4,"permanent":true},"12":{"name":"ProcessPageList","title":"Page List","version":124,"icon":"sitemap","permission":"page-edit","created":[[timestamp]],"configurable":3,"permanent":true,"useNavJSON":true},"150":{"name":"ProcessPageLister","title":"Lister","version":26,"icon":"search","permission":"page-lister","created":[[timestamp]],"configurable":true,"permanent":true,"useNavJSON":true,"addFlag":32},"104":{"name":"ProcessPageSearch","title":"Page Search","version":108,"permission":"page-edit","singular":1,"created":[[timestamp]],"configurable":3,"permanent":true},"14":{"name":"ProcessPageSort","title":"Page Sort and Move","version":101,"permission":"page-edit","created":[[timestamp]],"permanent":true},"109":{"name":"ProcessPageTrash","title":"Page Trash","version":103,"singular":1,"created":[[timestamp]],"permanent":true},"134":{"name":"ProcessPageType","title":"Page Type","version":101,"singular":1,"created":[[timestamp]],"configurable":3,"permanent":true,"useNavJSON":true,"addFlag":32},"83":{"name":"ProcessPageView","title":"Page View","version":106,"permission":"page-view","created":[[timestamp]],"permanent":true},"136":{"name":"ProcessPermission","title":"Permissions","version":101,"icon":"gear","permission":"permission-admin","singular":1,"created":[[timestamp]],"configurable":3,"permanent":true,"useNavJSON":true},"138":{"name":"ProcessProfile","title":"User Profile","version":105,"permission":"profile-edit","singular":1,"created":[[timestamp]],"configurable":3,"permanent":true},"175":{"name":"ProcessRecentPages","title":"Recent Pages","version":2,"icon":"clock-o","permission":"page-edit-recent","singular":1,"created":[[timestamp]],"useNavJSON":true,"nav":[{"url":"?edited=1","label":"Edited","icon":"users","navJSON":"navJSON\\/?edited=1"},{"url":"?added=1","label":"Created","icon":"users","navJSON":"navJSON\\/?added=1"},{"url":"?edited=1&me=1","label":"Edited by me","icon":"user","navJSON":"navJSON\\/?edited=1&me=1"},{"url":"?added=1&me=1","label":"Created by me","icon":"user","navJSON":"navJSON\\/?added=1&me=1"},{"url":"another\\/","label":"Add another","icon":"plus-circle","navJSON":"anotherNavJSON\\/"}]},"68":{"name":"ProcessRole","title":"Roles","version":104,"icon":"gears","permission":"role-admin","created":[[timestamp]],"configurable":3,"permanent":true,"useNavJSON":true},"47":{"name":"ProcessTemplate","title":"Templates","version":114,"icon":"cubes","permission":"template-admin","created":[[timestamp]],"configurable":4,"permanent":true,"useNavJSON":true},"66":{"name":"ProcessUser","title":"Users","version":107,"icon":"group","permission":"user-admin","created":[[timestamp]],"configurable":"ProcessUserConfig.php","permanent":true,"useNavJSON":true},"125":{"name":"SessionLoginThrottle","title":"Session Login Throttle","version":103,"autoload":"function","singular":true,"created":[[timestamp]],"configurable":3},"139":{"name":"SystemUpdater","title":"System Updater","version":21,"singular":true,"created":[[timestamp]],"configurable":3,"permanent":true},"61":{"name":"TextformatterEntities","title":"HTML Entity Encoder (htmlspecialchars)","version":100,"created":[[timestamp]]},"207":{"name":"ProcessLogger","title":"Logs","version":2,"icon":"tree","permission":"logs-view","singular":true,"useNavJSON":true},"212":{"name":"InputfieldIcon","title":"Icon","version":3}}', '[[regtime]]'),
(162, '.ModulesVerbose.info', 8192, '{"187":{"summary":"Uikit v3 admin theme","core":true,"versionStr":"0.3.6"},"97":{"summary":"This Fieldtype stores an ON\\/OFF toggle via a single checkbox. The ON value is 1 and OFF value is 0.","core":true,"versionStr":"1.0.1"},"28":{"summary":"Field that stores a date and optionally time","core":true,"versionStr":"1.0.5"},"29":{"summary":"Field that stores an e-mail address","core":true,"versionStr":"1.0.1"},"106":{"summary":"Close a fieldset opened by FieldsetOpen. ","core":true,"versionStr":"1.0.0"},"105":{"summary":"Open a fieldset to group fields. Should be followed by a Fieldset (Close) after one or more fields.","core":true,"versionStr":"1.0.1"},"107":{"summary":"Open a fieldset to group fields. Same as Fieldset (Open) except that it displays in a tab instead.","core":true,"versionStr":"1.0.0"},"6":{"summary":"Field that stores one or more files","core":true,"versionStr":"1.0.7"},"89":{"summary":"Field that stores a floating point number","core":true,"versionStr":"1.0.8"},"57":{"summary":"Field that stores one or more GIF, JPG, or PNG images","core":true,"versionStr":"1.0.2"},"84":{"summary":"Field that stores an integer","core":true,"versionStr":"1.0.2"},"27":{"summary":"Field that stores a reference to another module","core":true,"versionStr":"1.0.2"},"4":{"summary":"Field that stores one or more references to ProcessWire pages","core":true,"versionStr":"1.0.7"},"111":{"summary":"Field that stores a page title","core":true,"versionStr":"1.0.0"},"133":{"summary":"Field that stores a hashed and salted password","core":true,"versionStr":"1.0.1"},"3":{"summary":"Field that stores a single line of text","core":true,"versionStr":"1.0.2"},"1":{"summary":"Field that stores multiple lines of text","core":true,"versionStr":"1.0.7"},"135":{"summary":"Field that stores a URL","core":true,"versionStr":"1.0.1"},"25":{"summary":"Multiple selection, progressive enhancement to select multiple","core":true,"versionStr":"2.0.3"},"131":{"summary":"Form button element that you can optionally pass an href attribute to.","core":true,"versionStr":"1.0.0"},"37":{"summary":"Single checkbox toggle","core":true,"versionStr":"1.0.6"},"38":{"summary":"Multiple checkbox toggles","core":true,"versionStr":"1.0.8"},"94":{"summary":"Inputfield that accepts date and optionally time","core":true,"versionStr":"1.0.8"},"80":{"summary":"E-Mail address in valid format","core":true,"versionStr":"1.0.2"},"78":{"summary":"Groups one or more fields together in a container","core":true,"versionStr":"1.0.1"},"55":{"summary":"One or more file uploads (sortable)","core":true,"versionStr":"1.2.9"},"90":{"summary":"Floating point number with precision","core":true,"versionStr":"1.0.5"},"30":{"summary":"Contains one or more fields in a form","core":true,"versionStr":"1.0.7"},"40":{"summary":"Hidden input in a form","core":true,"versionStr":"1.0.1"},"56":{"summary":"One or more image uploads (sortable)","core":true,"versionStr":"1.2.9"},"85":{"summary":"Integer (positive or negative)","core":true,"versionStr":"1.0.5"},"79":{"summary":"Contains any other markup and optionally child Inputfields","core":true,"versionStr":"1.0.2"},"41":{"summary":"Text input validated as a ProcessWire name field","core":true,"versionStr":"1.0.0"},"60":{"summary":"Select one or more pages","core":true,"versionStr":"1.0.9"},"15":{"summary":"Selection of a single page from a ProcessWire page tree list","core":true,"versionStr":"1.0.1"},"137":{"summary":"Selection of multiple pages from a ProcessWire page tree list","core":true,"versionStr":"1.0.3"},"86":{"summary":"Text input validated as a ProcessWire Page name field","core":true,"versionStr":"1.0.6"},"112":{"summary":"Handles input of Page Title and auto-generation of Page Name (when name is blank)","core":true,"versionStr":"1.0.2"},"122":{"summary":"Password input with confirmation field.","core":true,"versionStr":"1.0.2"},"39":{"summary":"Radio buttons for selection of a single item","core":true,"versionStr":"1.0.6"},"36":{"summary":"Selection of a single value from a select pulldown","core":true,"versionStr":"1.0.3"},"43":{"summary":"Select multiple items from a list","core":true,"versionStr":"1.0.1"},"149":{"summary":"Build a page finding selector visually.","author":"Avoine + ProcessWire","core":true,"versionStr":"0.2.8"},"32":{"summary":"Form submit button","core":true,"versionStr":"1.0.3"},"34":{"summary":"Single line of text","core":true,"versionStr":"1.0.6"},"35":{"summary":"Multiple lines of text","core":true,"versionStr":"1.0.3"},"155":{"summary":"TinyMCE rich text editor version 6.8.2.","core":true,"versionStr":"6.1.8"},"108":{"summary":"URL in valid format","core":true,"versionStr":"1.0.3"},"116":{"summary":"jQuery Core as required by ProcessWire Admin and plugins","href":"https:\\/\\/jquery.com","core":true,"versionStr":"1.12.4"},"151":{"summary":"Provides lightbox capability for image galleries. Replacement for FancyBox. Uses Magnific Popup by @dimsemenov.","href":"https:\\/\\/github.com\\/dimsemenov\\/Magnific-Popup\\/","core":true,"versionStr":"1.1.0"},"103":{"summary":"Provides a jQuery plugin for sorting tables.","href":"https:\\/\\/mottie.github.io\\/tablesorter\\/","core":true,"versionStr":"2.31.3"},"117":{"summary":"jQuery UI as required by ProcessWire and plugins","href":"https:\\/\\/ui.jquery.com","core":true,"versionStr":"1.10.4"},"45":{"summary":"Provides a jQuery plugin for generating tabs in ProcessWire.","core":true,"versionStr":"1.1.0"},"67":{"summary":"Generates markup for data tables used by ProcessWire admin","core":true,"versionStr":"1.0.8"},"156":{"summary":"Front-end to the HTML Purifier library.","core":true,"versionStr":"4.9.7"},"113":{"summary":"Adds renderPager() method to all PaginatedArray types, for easy pagination output. Plus a render() method to PageArray instances.","core":true,"versionStr":"1.0.0"},"98":{"summary":"Generates markup for pagination navigation","core":true,"versionStr":"1.0.5"},"114":{"summary":"Adds various permission methods to Page objects that are used by Process modules.","core":true,"versionStr":"1.0.5"},"115":{"summary":"Adds a render method to Page and caches page output.","core":true,"versionStr":"1.0.5"},"48":{"summary":"Edit individual fields that hold page data","core":true,"versionStr":"1.1.4","searchable":"fields"},"87":{"summary":"Acts as a placeholder Process for the admin root. Ensures proper flow control after login.","core":true,"versionStr":"1.0.1"},"76":{"summary":"Lists the Process assigned to each child page of the current","core":true,"versionStr":"1.0.1"},"10":{"summary":"Login to ProcessWire","core":true,"versionStr":"1.0.9"},"50":{"summary":"List, edit or install\\/uninstall modules","core":true,"versionStr":"1.2.1"},"17":{"summary":"Add a new page","core":true,"versionStr":"1.0.9"},"7":{"summary":"Edit a Page","core":true,"versionStr":"1.1.2"},"129":{"summary":"Provides image manipulation functions for image fields and rich text editors.","core":true,"versionStr":"1.2.1"},"121":{"summary":"Provides a link capability as used by some Fieldtype modules (like rich text editors).","core":true,"versionStr":"1.1.2"},"12":{"summary":"List pages in a hierarchical tree structure","core":true,"versionStr":"1.2.4"},"150":{"summary":"Admin tool for finding and listing pages by any property.","author":"Ryan Cramer","core":true,"versionStr":"0.2.6","permissions":{"page-lister":"Use Page Lister"}},"104":{"summary":"Provides a page search engine for admin use.","core":true,"versionStr":"1.0.8"},"14":{"summary":"Handles page sorting and moving for PageList","core":true,"versionStr":"1.0.1"},"109":{"summary":"Handles emptying of Page trash","core":true,"versionStr":"1.0.3"},"134":{"summary":"List, Edit and Add pages of a specific type","core":true,"versionStr":"1.0.1"},"83":{"summary":"All page views are routed through this Process","core":true,"versionStr":"1.0.6"},"136":{"summary":"Manage system permissions","core":true,"versionStr":"1.0.1"},"138":{"summary":"Enables user to change their password, email address and other settings that you define.","core":true,"versionStr":"1.0.5"},"175":{"summary":"Shows a list of recently edited pages in your admin.","author":"Ryan Cramer","href":"http:\\/\\/modules.processwire.com\\/","core":true,"versionStr":"0.0.2","permissions":{"page-edit-recent":"Can see recently edited pages"},"page":{"name":"recent-pages","parent":"page","title":"Recent"}},"68":{"summary":"Manage user roles and what permissions are attached","core":true,"versionStr":"1.0.4"},"47":{"summary":"List and edit the templates that control page output","core":true,"versionStr":"1.1.4","searchable":"templates"},"66":{"summary":"Manage system users","core":true,"versionStr":"1.0.7","searchable":"users"},"125":{"summary":"Throttles login attempts to help prevent dictionary attacks.","core":true,"versionStr":"1.0.3"},"139":{"summary":"Manages system versions and upgrades.","core":true,"versionStr":"0.2.1"},"61":{"summary":"Entity encode ampersands, quotes (single and double) and greater-than\\/less-than signs using htmlspecialchars(str, ENT_QUOTES). It is recommended that you use this on all text\\/textarea fields except those using a rich text editor or a markup language like Markdown.","core":true,"versionStr":"1.0.0"},"207":{"summary":"View and manage system logs.","author":"Ryan Cramer","core":true,"versionStr":"0.0.2","permissions":{"logs-view":"Can view system logs","logs-edit":"Can manage system logs"},"page":{"name":"logs","parent":"setup","title":"Logs"}},"212":{"summary":"Select an icon","core":true,"versionStr":"0.0.3"}}', '[[regtime]]');
INSERT INTO `modules` VALUES
(163, '.ModulesUninstalled.info', 8192, '{"AdminThemeReno":{"name":"AdminThemeReno","title":"Reno","version":17,"versionStr":"0.1.7","author":"Tom Reno (Renobird)","summary":"Admin theme for ProcessWire 2.5+ by Tom Reno (Renobird)","requiresVersions":{"AdminThemeDefault":[">=",0]},"autoload":"template=admin","created":1767986603,"installed":false,"configurable":3,"core":true},"AdminThemeUikit":{"name":"AdminThemeUikit","title":"Uikit","version":36,"versionStr":"0.3.6","summary":"Uikit v3 admin theme","icon":"smile-o","autoload":"template=admin","created":1767986603,"installed":false,"configurable":4,"core":true},"FieldtypeCache":{"name":"FieldtypeCache","title":"Cache","version":102,"versionStr":"1.0.2","summary":"Caches the values of other fields for fewer runtime queries. Can also be used to combine multiple text fields and have them all be searchable under the cached field name.","created":1767986603,"installed":false,"core":true},"CommentFilterAkismet":{"name":"CommentFilterAkismet","title":"Comment Filter: Akismet","version":200,"versionStr":"2.0.0","summary":"Uses the Akismet service to identify comment spam. Module plugin for the Comments Fieldtype.","requiresVersions":{"FieldtypeComments":[">=",0]},"created":1767986603,"installed":false,"configurable":3,"core":true},"FieldtypeComments":{"name":"FieldtypeComments","title":"Comments","version":110,"versionStr":"1.1.0","summary":"Field that stores user posted comments for a single Page","installs":["InputfieldCommentsAdmin"],"created":1767986603,"installed":false,"core":true},"InputfieldCommentsAdmin":{"name":"InputfieldCommentsAdmin","title":"Comments Admin","version":104,"versionStr":"1.0.4","summary":"Provides an administrative interface for working with comments","requiresVersions":{"FieldtypeComments":[">=",0]},"created":1767986603,"installed":false,"core":true},"FieldtypeDecimal":{"name":"FieldtypeDecimal","title":"Decimal","version":1,"versionStr":"0.0.1","summary":"Field that stores a decimal number","created":1767986603,"installed":false,"core":true},"FieldtypeOptions":{"name":"FieldtypeOptions","title":"Select Options","version":2,"versionStr":"0.0.2","summary":"Field that stores single and multi select options.","created":1767986603,"installed":false,"core":true},"FieldtypePageTable":{"name":"FieldtypePageTable","title":"ProFields: Page Table","version":8,"versionStr":"0.0.8","summary":"A fieldtype containing a group of editable pages.","installs":["InputfieldPageTable"],"autoload":true,"created":1767986603,"installed":false,"core":true},"FieldtypeFieldsetPage":{"name":"FieldtypeFieldsetPage","title":"Fieldset (Page)","version":1,"versionStr":"0.0.1","summary":"Fieldset with fields isolated to separate namespace (page), enabling re-use of fields.","requiresVersions":{"FieldtypeRepeater":[">=",0]},"autoload":true,"created":1767986603,"installed":false,"configurable":3,"core":true},"FieldtypeRepeater":{"name":"FieldtypeRepeater","title":"Repeater","version":113,"versionStr":"1.1.3","summary":"Maintains a collection of fields that are repeated for any number of times.","installs":["InputfieldRepeater"],"autoload":true,"created":1767986603,"installed":false,"configurable":3,"core":true},"InputfieldRepeater":{"name":"InputfieldRepeater","title":"Repeater","version":111,"versionStr":"1.1.1","summary":"Repeats fields from another template. Provides the input for FieldtypeRepeater.","requiresVersions":{"FieldtypeRepeater":[">=",0]},"created":1767986603,"installed":false,"core":true},"FieldtypeSelector":{"name":"FieldtypeSelector","title":"Selector","version":13,"versionStr":"0.1.3","author":"Avoine + ProcessWire","summary":"Build a page finding selector visually.","created":1767986603,"installed":false,"core":true},"FieldtypeToggle":{"name":"FieldtypeToggle","title":"Toggle (Yes\\/No)","version":1,"versionStr":"0.0.1","summary":"Configurable yes\\/no, on\\/off toggle alternative to a checkbox, plus optional \\u201cother\\u201d option.","requiresVersions":{"InputfieldToggle":[">=",0]},"created":1767986603,"installed":false,"core":true},"FileCompilerTags":{"name":"FileCompilerTags","title":"Tags File Compiler","version":1,"versionStr":"0.0.1","summary":"Enables {var} or {var.property} variables in markup sections of a file. Can be used with any API variable.","created":1767986603,"installed":false,"configurable":4,"core":true},"FileValidatorZip":{"name":"FileValidatorZip","title":"ZIP file validator","version":1,"versionStr":"0.0.1","author":"Ryan Cramer","summary":"Validates ZIP files with various configurable rules.","icon":"file-archive-o","created":1767986603,"installed":false,"configurable":4,"core":true,"validates":["zip"]},"ImageSizerEngineAnimatedGif":{"name":"ImageSizerEngineAnimatedGif","title":"Animated GIF Image Sizer","version":1,"versionStr":"0.0.1","author":"Horst Nogajski","summary":"Upgrades image manipulations for animated GIFs.","created":1767986603,"installed":false,"configurable":4,"core":true},"ImageSizerEngineIMagick":{"name":"ImageSizerEngineIMagick","title":"IMagick Image Sizer","version":3,"versionStr":"0.0.3","author":"Horst Nogajski","summary":"Upgrades image manipulations to use PHP''s ImageMagick library when possible.","created":1767986603,"installed":false,"configurable":4,"core":true},"InputfieldCKEditor":{"name":"InputfieldCKEditor","title":"CKEditor","version":172,"versionStr":"1.7.2","summary":"CKEditor textarea rich text editor.","installs":["MarkupHTMLPurifier"],"created":1767986603,"installed":false,"core":true},"InputfieldIcon":{"name":"InputfieldIcon","title":"Icon","version":3,"versionStr":"0.0.3","summary":"Select an icon","created":1767986603,"installed":false,"core":true},"InputfieldPageAutocomplete":{"name":"InputfieldPageAutocomplete","title":"Page Auto Complete","version":113,"versionStr":"1.1.3","summary":"Multiple Page selection using auto completion and sorting capability. Intended for use as an input field for Page reference fields.","created":1767986603,"installed":false,"core":true},"InputfieldPageTable":{"name":"InputfieldPageTable","title":"ProFields: Page Table","version":14,"versionStr":"0.1.4","summary":"Inputfield to accompany FieldtypePageTable","requiresVersions":{"FieldtypePageTable":[">=",0]},"created":1767986603,"installed":false,"core":true},"InputfieldTextTags":{"name":"InputfieldTextTags","title":"Text Tags","version":7,"versionStr":"0.0.7","summary":"Enables input of user entered tags or selection of predefined tags.","icon":"tags","created":1767986603,"installed":false,"core":true},"InputfieldToggle":{"name":"InputfieldToggle","title":"Toggle","version":1,"versionStr":"0.0.1","summary":"A toggle providing similar input capability to a checkbox but much more configurable.","created":1767986603,"installed":false,"core":true},"FieldtypePageTitleLanguage":{"name":"FieldtypePageTitleLanguage","title":"Page Title (Multi-Language)","version":100,"versionStr":"1.0.0","author":"Ryan Cramer","summary":"Field that stores a page title in multiple languages. Use this only if you want title inputs created for ALL languages on ALL pages. Otherwise create separate languaged-named title fields, i.e. title_fr, title_es, title_fi, etc. ","requiresVersions":{"LanguageSupportFields":[">=",0],"FieldtypeTextLanguage":[">=",0]},"created":1767986603,"installed":false,"core":true},"FieldtypeTextLanguage":{"name":"FieldtypeTextLanguage","title":"Text (Multi-language)","version":100,"versionStr":"1.0.0","summary":"Field that stores a single line of text in multiple languages","requiresVersions":{"LanguageSupportFields":[">=",0]},"created":1767986603,"installed":false,"core":true},"FieldtypeTextareaLanguage":{"name":"FieldtypeTextareaLanguage","title":"Textarea (Multi-language)","version":100,"versionStr":"1.0.0","summary":"Field that stores a multiple lines of text in multiple languages","requiresVersions":{"LanguageSupportFields":[">=",0]},"created":1767986603,"installed":false,"core":true},"LanguageSupport":{"name":"LanguageSupport","title":"Languages Support","version":104,"versionStr":"1.0.4","author":"Ryan Cramer","summary":"ProcessWire multi-language support.","installs":["ProcessLanguage","ProcessLanguageTranslator"],"autoload":true,"singular":true,"created":1767986603,"installed":false,"configurable":3,"core":true,"addFlag":32},"LanguageSupportFields":{"name":"LanguageSupportFields","title":"Languages Support - Fields","version":101,"versionStr":"1.0.1","author":"Ryan Cramer","summary":"Required to use multi-language fields.","requiresVersions":{"LanguageSupport":[">=",0]},"installs":["FieldtypePageTitleLanguage","FieldtypeTextareaLanguage","FieldtypeTextLanguage"],"autoload":true,"singular":true,"created":1767986603,"installed":false,"core":true},"LanguageSupportPageNames":{"name":"LanguageSupportPageNames","title":"Languages Support - Page Names","version":14,"versionStr":"0.1.4","author":"Ryan Cramer","summary":"Required to use multi-language page names.","requiresVersions":{"LanguageSupport":[">=",0],"LanguageSupportFields":[">=",0]},"autoload":true,"singular":true,"created":1767986603,"installed":false,"configurable":4,"core":true},"LanguageTabs":{"name":"LanguageTabs","title":"Languages Support - Tabs","version":117,"versionStr":"1.1.7","author":"adamspruijt, ryan, flipzoom","summary":"Organizes multi-language fields into tabs for a cleaner easier to use interface.","requiresVersions":{"LanguageSupport":[">=",0]},"autoload":"template=admin","singular":true,"created":1767986603,"installed":false,"configurable":4,"core":true},"ProcessLanguage":{"name":"ProcessLanguage","title":"Languages","version":103,"versionStr":"1.0.3","author":"Ryan Cramer","summary":"Manage system languages","icon":"language","requiresVersions":{"LanguageSupport":[">=",0]},"permission":"lang-edit","permissions":{"lang-edit":"Administer languages and static translation files"},"created":1767986603,"installed":false,"configurable":3,"core":true,"useNavJSON":true},"ProcessLanguageTranslator":{"name":"ProcessLanguageTranslator","title":"Language Translator","version":103,"versionStr":"1.0.3","author":"Ryan Cramer","summary":"Provides language translation capabilities for ProcessWire core and modules.","requiresVersions":{"LanguageSupport":[">=",0]},"permission":"lang-edit","created":1767986603,"installed":false,"configurable":4,"core":true},"LazyCron":{"name":"LazyCron","title":"Lazy Cron","version":104,"versionStr":"1.0.4","summary":"Provides hooks that are automatically executed at various intervals. It is called ''lazy'' because it''s triggered by a pageview, so the interval is guaranteed to be at least the time requested, rather than exactly the time requested. This is fine for most cases, but you can make it not lazy by connecting this to a real CRON job. See the module file for details. ","href":"https:\\/\\/processwire.com\\/api\\/modules\\/lazy-cron\\/","autoload":true,"singular":true,"created":1767986603,"installed":false,"core":true},"MarkupCache":{"name":"MarkupCache","title":"Markup Cache","version":101,"versionStr":"1.0.1","summary":"A simple way to cache segments of markup in your templates. ","href":"https:\\/\\/processwire.com\\/api\\/modules\\/markupcache\\/","autoload":true,"singular":true,"created":1767986603,"installed":false,"configurable":3,"core":true},"MarkupPageFields":{"name":"MarkupPageFields","title":"Markup Page Fields","version":100,"versionStr":"1.0.0","summary":"Adds $page->renderFields() and $page->images->render() methods that return basic markup for output during development and debugging.","autoload":true,"singular":true,"created":1767986603,"installed":false,"core":true,"permanent":true},"MarkupRSS":{"name":"MarkupRSS","title":"Markup RSS Feed","version":105,"versionStr":"1.0.5","summary":"Renders an RSS feed. Given a PageArray, renders an RSS feed of them.","icon":"rss-square","created":1767986603,"installed":false,"configurable":3,"core":true},"PageFrontEdit":{"name":"PageFrontEdit","title":"Front-End Page Editor","version":6,"versionStr":"0.0.6","author":"Ryan Cramer","summary":"Enables front-end editing of page fields.","icon":"cube","permissions":{"page-edit-front":"Use the front-end page editor"},"autoload":true,"created":1767986603,"installed":false,"configurable":"PageFrontEditConfig.php","core":true,"license":"MPL 2.0"},"PagePathHistory":{"name":"PagePathHistory","title":"Page Path History","version":8,"versionStr":"0.0.8","summary":"Keeps track of past URLs where pages have lived and automatically redirects (301 permanent) to the new location whenever the past URL is accessed.","autoload":true,"singular":true,"created":1767986603,"installed":false,"configurable":4,"core":true},"PagePaths":{"name":"PagePaths","title":"Page Paths","version":4,"versionStr":"0.0.4","summary":"Enables page paths\\/urls to be queryable by selectors. Also offers potential for improved load performance. Builds an index at install (may take time on a large site).","autoload":true,"singular":true,"created":1767986603,"installed":false,"configurable":4,"core":true},"PagesVersions":{"name":"PagesVersions","title":"Pages Versions","version":2,"versionStr":"0.0.2","author":"Ryan Cramer","summary":"Provides a version control API for pages in ProcessWire.","icon":"code-fork","autoload":true,"singular":true,"created":1767986603,"installed":false,"core":true},"ProcessCommentsManager":{"name":"ProcessCommentsManager","title":"Comments","version":12,"versionStr":"0.1.2","author":"Ryan Cramer","summary":"Manage comments in your site outside of the page editor.","icon":"comments","requiresVersions":{"FieldtypeComments":[">=",0]},"permission":"comments-manager","permissions":{"comments-manager":"Use the comments manager"},"created":1767986603,"installed":false,"searchable":"comments","core":true,"page":{"name":"comments","parent":"setup","title":"Comments"},"nav":[{"url":"?go=approved","label":"Approved"},{"url":"?go=pending","label":"Pending"},{"url":"?go=spam","label":"Spam"},{"url":"?go=all","label":"All"}]},"ProcessForgotPassword":{"name":"ProcessForgotPassword","title":"Forgot Password","version":104,"versionStr":"1.0.4","summary":"Provides password reset\\/email capability for the Login process.","permission":"page-view","created":1767986603,"installed":false,"configurable":4,"core":true},"ProcessLogger":{"name":"ProcessLogger","title":"Logs","version":2,"versionStr":"0.0.2","author":"Ryan Cramer","summary":"View and manage system logs.","icon":"tree","permission":"logs-view","permissions":{"logs-view":"Can view system logs","logs-edit":"Can manage system logs"},"created":1767986603,"installed":false,"core":true,"page":{"name":"logs","parent":"setup","title":"Logs"},"useNavJSON":true},"ProcessPageClone":{"name":"ProcessPageClone","title":"Page Clone","version":106,"versionStr":"1.0.6","summary":"Provides ability to clone\\/copy\\/duplicate pages in the admin. Adds a &quot;copy&quot; option to all applicable pages in the PageList.","permission":"page-clone","permissions":{"page-clone":"Clone a page","page-clone-tree":"Clone a tree of pages"},"autoload":"template=admin","created":1767986603,"installed":false,"configurable":4,"core":true,"page":{"name":"clone","title":"Clone","parent":"page","status":1024}},"ProcessPagesExportImport":{"name":"ProcessPagesExportImport","title":"Pages Export\\/Import","version":1,"versionStr":"0.0.1","author":"Ryan Cramer","summary":"Enables exporting and importing of pages. Development version, not yet recommended for production use.","icon":"paper-plane-o","permission":"page-edit-export","created":1767986603,"installed":false,"core":true,"page":{"name":"export-import","parent":"page","title":"Export\\/Import"}},"ProcessRecentPages":{"name":"ProcessRecentPages","title":"Recent Pages","version":2,"versionStr":"0.0.2","author":"Ryan Cramer","summary":"Shows a list of recently edited pages in your admin.","href":"http:\\/\\/modules.processwire.com\\/","icon":"clock-o","permission":"page-edit-recent","permissions":{"page-edit-recent":"Can see recently edited pages"},"created":1767986603,"installed":false,"core":true,"page":{"name":"recent-pages","parent":"page","title":"Recent"},"useNavJSON":true,"nav":[{"url":"?edited=1","label":"Edited","icon":"users","navJSON":"navJSON\\/?edited=1"},{"url":"?added=1","label":"Created","icon":"users","navJSON":"navJSON\\/?added=1"},{"url":"?edited=1&me=1","label":"Edited by me","icon":"user","navJSON":"navJSON\\/?edited=1&me=1"},{"url":"?added=1&me=1","label":"Created by me","icon":"user","navJSON":"navJSON\\/?added=1&me=1"},{"url":"another\\/","label":"Add another","icon":"plus-circle","navJSON":"anotherNavJSON\\/"}]},"ProcessSessionDB":{"name":"ProcessSessionDB","title":"Sessions","version":5,"versionStr":"0.0.5","summary":"Enables you to browse active database sessions.","icon":"dashboard","requiresVersions":{"SessionHandlerDB":[">=",0]},"created":1767986603,"installed":false,"core":true,"page":{"name":"sessions-db","parent":"access","title":"Sessions"}},"SessionHandlerDB":{"name":"SessionHandlerDB","title":"Session Handler Database","version":6,"versionStr":"0.0.6","summary":"Installing this module makes ProcessWire store sessions in the database rather than the file system. Note that this module will log you out after install or uninstall.","installs":["ProcessSessionDB"],"created":1767986603,"installed":false,"configurable":3,"core":true},"FieldtypeNotifications":{"name":"FieldtypeNotifications","title":"Notifications","version":4,"versionStr":"0.0.4","summary":"Field that stores user notifications.","requiresVersions":{"SystemNotifications":[">=",0]},"created":1767986603,"installed":false,"core":true},"SystemNotifications":{"name":"SystemNotifications","title":"System Notifications","version":12,"versionStr":"0.1.2","summary":"Adds support for notifications in ProcessWire (currently in development)","icon":"bell","installs":["FieldtypeNotifications"],"autoload":true,"created":1767986603,"installed":false,"configurable":"SystemNotificationsConfig.php","core":true},"TextformatterMarkdownExtra":{"name":"TextformatterMarkdownExtra","title":"Markdown\\/Parsedown Extra","version":180,"versionStr":"1.8.0","summary":"Markdown\\/Parsedown extra lightweight markup language by Emanuil Rusev. Based on Markdown by John Gruber.","created":1767986603,"installed":false,"configurable":4,"core":true},"TextformatterNewlineBR":{"name":"TextformatterNewlineBR","title":"Newlines to XHTML Line Breaks","version":100,"versionStr":"1.0.0","summary":"Converts newlines to XHTML line break <br \\/> tags. ","created":1767986603,"installed":false,"core":true},"TextformatterNewlineUL":{"name":"TextformatterNewlineUL","title":"Newlines to Unordered List","version":100,"versionStr":"1.0.0","summary":"Converts newlines to <li> list items and surrounds in an <ul> unordered list. ","created":1767986603,"installed":false,"core":true},"TextformatterPstripper":{"name":"TextformatterPstripper","title":"Paragraph Stripper","version":100,"versionStr":"1.0.0","summary":"Strips paragraph <p> tags that may have been applied by other text formatters before it. ","created":1767986603,"installed":false,"core":true},"TextformatterSmartypants":{"name":"TextformatterSmartypants","title":"SmartyPants Typographer","version":171,"versionStr":"1.7.1","summary":"Smart typography for web sites, by Michel Fortin based on SmartyPants by John Gruber. If combined with Markdown, it should be applied AFTER Markdown.","created":1767986603,"installed":false,"configurable":4,"core":true,"url":"https:\\/\\/github.com\\/michelf\\/php-smartypants"},"TextformatterStripTags":{"name":"TextformatterStripTags","title":"Strip Markup Tags","version":100,"versionStr":"1.0.0","summary":"Strips HTML\\/XHTML Markup Tags","created":1767986603,"installed":false,"configurable":3,"core":true},"AdminThemeDefault":{"name":"AdminThemeDefault","title":"Default","version":14,"versionStr":"0.1.4","summary":"Minimal admin theme that supports all ProcessWire features.","autoload":"template=admin","created":1767986603,"installed":false,"configurable":19,"core":true}}', '[[regtime]]'),
(164, '.ModulesVersions.info', 8192, '[]', '[[regtime]]'),
(175, 'ProcessRecentPages', 1, '', '[[regtime]]'),
(187, 'AdminThemeUikit', 10, '', '[[regtime]]'),
(207, 'ProcessLogger', 1, '', '[[regtime]]'),
(212, 'InputfieldIcon', 0, '', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) unsigned NOT NULL DEFAULT '0',
  `templates_id` int(11) unsigned NOT NULL DEFAULT '0',
  `name` varchar(128) CHARACTER SET ascii NOT NULL,
  `status` int(10) unsigned NOT NULL DEFAULT '1',
  `modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified_users_id` int(10) unsigned NOT NULL DEFAULT '2',
  `created` timestamp NOT NULL DEFAULT '2015-12-18 11:09:00',
  `created_users_id` int(10) unsigned NOT NULL DEFAULT '2',
  `sort` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_parent_id` (`name`,`parent_id`),
  KEY `parent_id` (`parent_id`),
  KEY `templates_id` (`templates_id`),
  KEY `modified` (`modified`),
  KEY `created` (`created`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=1015 ;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages` VALUES
(1, 0, 1, 'home', 9, '[[regtime]]', 41, '[[regtime]]', 2, 0),
(2, 1, 2, '[[admin_folder]]', 1035, '[[regtime]]', 40, '[[regtime]]', 2, 5),
(3, 2, 2, 'page', 21, '[[regtime]]', 41, '[[regtime]]', 2, 0),
(6, 3, 2, 'add', 1045, '[[regtime]]', 41, '[[regtime]]', 2, 0),
(7, 1, 2, 'trash', 1039, '[[regtime]]', 41, '[[regtime]]', 2, 6),
(8, 3, 2, 'list', 21, '[[regtime]]', 41, '[[regtime]]', 2, 1),
(9, 3, 2, 'sort', 1047, '[[regtime]]', 41, '[[regtime]]', 2, 2),
(10, 3, 2, 'edit', 1045, '[[regtime]]', 41, '[[regtime]]', 2, 3),
(11, 22, 2, 'template', 21, '[[regtime]]', 41, '[[regtime]]', 2, 0),
(16, 22, 2, 'field', 21, '[[regtime]]', 41, '[[regtime]]', 2, 2),
(21, 2, 2, 'module', 21, '[[regtime]]', 41, '[[regtime]]', 2, 2),
(22, 2, 2, 'setup', 21, '[[regtime]]', 41, '[[regtime]]', 2, 1),
(23, 2, 2, 'login', 1035, '[[regtime]]', 41, '[[regtime]]', 2, 4),
(27, 1, 29, 'http404', 1035, '[[regtime]]', 41, '[[regtime]]', 3, 4),
(28, 2, 2, 'access', 13, '[[regtime]]', 41, '[[regtime]]', 2, 3),
(29, 28, 2, 'users', 29, '[[regtime]]', 41, '[[regtime]]', 2, 0),
(30, 28, 2, 'roles', 29, '[[regtime]]', 41, '[[regtime]]', 2, 1),
(31, 28, 2, 'permissions', 29, '[[regtime]]', 41, '[[regtime]]', 2, 2),
(32, 31, 5, 'page-edit', 25, '[[regtime]]', 41, '[[regtime]]', 2, 2),
(34, 31, 5, 'page-delete', 25, '[[regtime]]', 41, '[[regtime]]', 2, 3),
(35, 31, 5, 'page-move', 25, '[[regtime]]', 41, '[[regtime]]', 2, 4),
(36, 31, 5, 'page-view', 25, '[[regtime]]', 41, '[[regtime]]', 2, 0),
(37, 30, 4, 'guest', 25, '[[regtime]]', 41, '[[regtime]]', 2, 0),
(38, 30, 4, 'superuser', 25, '[[regtime]]', 41, '[[regtime]]', 2, 1),
(40, 29, 3, 'guest', 25, '[[regtime]]', 41, '[[regtime]]', 2, 1),
(41, 29, 3, '[[admin_username]]', 1, '[[regtime]]', 40, '[[regtime]]', 2, 0),
(50, 31, 5, 'page-sort', 25, '[[regtime]]', 41, '[[regtime]]', 41, 5),
(51, 31, 5, 'page-template', 25, '[[regtime]]', 41, '[[regtime]]', 41, 6),
(52, 31, 5, 'user-admin', 25, '[[regtime]]', 41, '[[regtime]]', 41, 10),
(53, 31, 5, 'profile-edit', 1, '[[regtime]]', 41, '[[regtime]]', 41, 13),
(54, 31, 5, 'page-lock', 1, '[[regtime]]', 41, '[[regtime]]', 41, 8),
(300, 3, 2, 'search', 1045, '[[regtime]]', 41, '[[regtime]]', 2, 5),
(301, 3, 2, 'trash', 1047, '[[regtime]]', 41, '[[regtime]]', 2, 5),
(302, 3, 2, 'link', 1041, '[[regtime]]', 41, '[[regtime]]', 2, 6),
(303, 3, 2, 'image', 1041, '[[regtime]]', 41, '[[regtime]]', 2, 7),
(304, 2, 2, 'profile', 1025, '[[regtime]]', 41, '[[regtime]]', 41, 5),
(1006, 31, 5, 'page-lister', 1, '[[regtime]]', 40, '[[regtime]]', 40, 9),
(1007, 3, 2, 'lister', 1, '[[regtime]]', 40, '[[regtime]]', 40, 8),
(1010, 3, 2, 'recent-pages', 1, '[[regtime]]', 40, '[[regtime]]', 40, 9),
(1011, 31, 5, 'page-edit-recent', 1, '[[regtime]]', 40, '[[regtime]]', 40, 10),
(1012, 22, 2, 'logs', 1, '[[regtime]]', 40, '[[regtime]]', 40, 2),
(1013, 31, 5, 'logs-view', 1, '[[regtime]]', 40, '[[regtime]]', 40, 11),
(1014, 31, 5, 'logs-edit', 1, '[[regtime]]', 40, '[[regtime]]', 40, 12);

-- --------------------------------------------------------

--
-- Table structure for table `pages_access`
--

CREATE TABLE `pages_access` (
  `pages_id` int(11) NOT NULL,
  `templates_id` int(11) NOT NULL,
  `ts` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`pages_id`),
  KEY `templates_id` (`templates_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `pages_access`
--

INSERT INTO `pages_access` VALUES
(32, 2, '[[regtime]]'),
(34, 2, '[[regtime]]'),
(35, 2, '[[regtime]]'),
(36, 2, '[[regtime]]'),
(37, 2, '[[regtime]]'),
(38, 2, '[[regtime]]'),
(50, 2, '[[regtime]]'),
(51, 2, '[[regtime]]'),
(52, 2, '[[regtime]]'),
(53, 2, '[[regtime]]'),
(54, 2, '[[regtime]]'),
(1006, 2, '[[regtime]]'),
(1011, 2, '[[regtime]]'),
(1013, 2, '[[regtime]]'),
(1014, 2, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `pages_parents`
--

CREATE TABLE `pages_parents` (
  `pages_id` int(10) unsigned NOT NULL,
  `parents_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`pages_id`,`parents_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Dumping data for table `pages_parents`
--

INSERT INTO `pages_parents` VALUES
(2, 1),
(3, 1),
(3, 2),
(7, 1),
(22, 1),
(22, 2),
(28, 1),
(28, 2),
(29, 1),
(29, 2),
(29, 28),
(30, 1),
(30, 2),
(30, 28),
(31, 1),
(31, 2),
(31, 28);

-- --------------------------------------------------------

--
-- Table structure for table `pages_sortfields`
--

CREATE TABLE `pages_sortfields` (
  `pages_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sortfield` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `session_login_throttle`
--

CREATE TABLE `session_login_throttle` (
  `name` varchar(128) NOT NULL,
  `attempts` int(10) unsigned NOT NULL DEFAULT '0',
  `last_attempt` int(10) unsigned NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- --------------------------------------------------------

--
-- Table structure for table `templates`
--

CREATE TABLE `templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET ascii NOT NULL,
  `fieldgroups_id` int(10) unsigned NOT NULL DEFAULT '0',
  `flags` int(11) NOT NULL DEFAULT '0',
  `cache_time` mediumint(9) NOT NULL DEFAULT '0',
  `data` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `fieldgroups_id` (`fieldgroups_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8mb4 AUTO_INCREMENT=43 ;

--
-- Dumping data for table `templates`
--

INSERT INTO `templates` VALUES
(1, 'home', 1, 0, 0, '{"useRoles":1,"noParents":1,"slashUrls":1,"modified":1409161729,"roles":[37]}'),
(2, 'admin', 2, 8, 0, '{"useRoles":1,"parentTemplates":[2],"allowPageNum":1,"redirectLogin":23,"slashUrls":1,"noGlobal":1,"compile":3,"modified":1767986603,"ns":"ProcessWire"}'),
(3, 'user', 3, 8, 0, '{"useRoles":1,"noChildren":1,"parentTemplates":[2],"slashUrls":1,"pageClass":"User","noGlobal":1,"noMove":1,"noTrash":1,"noSettings":1,"noChangeTemplate":1,"nameContentTab":1}'),
(4, 'role', 4, 8, 0, '{"noChildren":1,"parentTemplates":[2],"slashUrls":1,"pageClass":"Role","noGlobal":1,"noMove":1,"noTrash":1,"noSettings":1,"noChangeTemplate":1,"nameContentTab":1}'),
(5, 'permission', 5, 8, 0, '{"noChildren":1,"parentTemplates":[2],"slashUrls":1,"guestSearchable":1,"pageClass":"Permission","noGlobal":1,"noMove":1,"noTrash":1,"noSettings":1,"noChangeTemplate":1,"nameContentTab":1}'),
(29, 'basic-page', 83, 0, 0, '{"slashUrls":1,"modified":1409161813}');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
