<?php
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
//
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// MANUAL UPGRADE for SCHLIX CMS
// 
// Use cases: 
// 1) To perform CMS upgrade in a restricted environment where /system is cannot be written
// by the script user
// 2) To perform CMS upgrade in case of automated update failure (from Settings - System Update)
//
// Instruction: copy this file (manual_upgrade.php) and upgrade.php to the root 
// directory of your website where the file runtime.inc.php and index.php resides
// 
require('runtime.inc.php');
// make sure you have copied the file upgrade.php
require('upgrade.php');

error_reporting (E_ERROR | E_CORE_ERROR | E_COMPILE_ERROR | E_PARSE );
ini_set('display_errors','1');

setupSchlixRuntime();

echo 'Performing a manual upgrade .....';
upgrade_schlix('',SCHLIX_DB_HOST,SCHLIX_DB_DATABASE,SCHLIX_DB_USERNAME,SCHLIX_DB_PASSWORD);
echo 'Completed.....Please delete this file - '.__FILE__;
// remember to delete this file (upgrade.php and manual_upgrade.php) once it is completed