<?php

namespace App;

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

class Admin_Admin extends \SCHLIX\cmsAdmin_Basic {

    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct(NULL, NULL);        
    }

    /**
     * @ignore
     */
    public function viewMainPage()
    {
        redirect_url($this->app->createFriendlyURL(''));
    }

    public function getListofApplications()
    {
        $all_frontend_apps = get_list_of_all_apps(false);
        foreach ($all_frontend_apps as $app)
        {
            if ($app != $this->app_name)
            {
                $app_instance_name = '\\App\\' . $app;
                $app_instance = new $app_instance_name();
                if (!$app_instance->isFrontendRuntimeDisabled())
                    $item_array[] = array('label' => $app_instance->getApplicationDescription(), 'value' => $app);
            }
        }
        return $item_array;
    }


    /**
     * Edit Config
     * @global \SCHLIX\cmsConfigRegistry $SystemConfig
     * @param string $override_app_name
     * @param string $override_template_file
     */
    public function editConfig($override_app_name = '', $override_template_file = '')
    {
        global $SystemConfig;
        $configvar = [
            'SCHLIX_DEFAULT_LANGUAGE' => 'str_interface_language',
            'SCHLIX_SITE_NAME' => 'str_site_name',
        ];

        if ($override_app_name == 'system')
        {
            foreach ($configvar as $k => $v)
            {
                $constval = constant($k);
                $dbval = $SystemConfig->get('system', $v);
                if ($constval != $dbval)
                {
                    $SystemConfig->set('system', $v, $constval);
                }
            }
        }
        return parent::editConfig($override_app_name, $override_template_file);
    }

    public function isLanguageInstalled($lang)
    {
        $lang_file = SCHLIX_ROOT_PATH . '/system/languages/' . $lang . '.lang.php';
        return file_exists($lang_file);
    }

    public function getInstalledLanguages()
    {
        global $SchlixSupportedLanguages;

        $available_lang = [];
        foreach ($SchlixSupportedLanguages as $lang => $desc)
            if ($this->isLanguageInstalled($lang))
                $available_lang[] = $lang;
        return $available_lang;
    }

    /**
     * Check if this language is already installed. If not,
     * contact SCHLIX server and request for language file.
     * TODO: display error_list
     * @param string $lang
     * @param bool $force_reinstall
     */
    public function installSystemLanguagePack($lang, $force_reinstall = FALSE)
    {
        $error_list = [];

        $lang = alpha_numeric_with_dash_underscore($lang);
        if (!$this->isLanguageInstalled($lang) || $force_reinstall)
        {
            $this->app->ensureDataDirectoryExists();

            $version_dash = str_replace('.', '-', SCHLIX_VERSION);
            $version_normal = SCHLIX_VERSION;
            $syslangfile = "schlix-cms-syslangpack-{$lang}-v{$version_normal}";
            $zip_lang_filename = "{$syslangfile}.zip";
            $url = "https://www.schlix.com/downloads/schlix-cms/system-language-packs/{$version_dash}/{$zip_lang_filename}";
            $error_msg = '';
            try
            {
                $data = get_remote_file_content($url);
            } catch (\Exception $ex)
            {
                $error_msg = $ex->getMessage();
                $this->recordLog($error_msg);
            }
            if ($data)
            {
                $saved_lang_file = $this->app->getDataFileFullPath('syslangpack', $zip_lang_filename);
                file_put_contents($saved_lang_file, $data);
                $targetpath = $this->app->getDataDirectoryFullPath('tmp');
                // Now extract
                if (!file_exists($saved_lang_file))
                    $error_list[] = sprintf(___('Cannot find system language pack %s'), $zip_lang_filename);
                $zip = new \PclZip($saved_lang_file);
                if (empty($error_list) && is_dir($targetpath) && is_writable($targetpath))
                {
                    if ($zip->extract(PCLZIP_OPT_PATH, $targetpath) == 0)
                        $error_list [] = $zip->errorInfo(true);
                    if (empty($error_list))
                    {
                        copy_recursive($targetpath . '/' . $syslangfile, SCHLIX_ROOT_PATH);
                        return true;
                    }
                } else
                    $error_list[] = sprintf(___('Temporary directory %s is not writable'), $targetpath);
            } else
            {
                $error_list[] = ___('Cannot find the file from server');
                if ($error_msg)
                    $error_list[] = $error_msg;
            }
        } else
            return true;
        return $error_list ? $error_list : false;
    }

    /**
     * Validates config before saved
     * @param array $datavalues
     * @return array
     */
    public function getSaveConfigValidationErrorList($datavalues)
    {
        $error_list = parent::getSaveConfigValidationErrorList($datavalues);
        if (!$error_list)
        {
            $lang = $datavalues['str_interface_language'];
            if (empty($lang))
                $lang = 'en_us';
            if ($lang != 'en_us')
            {
                $result = $this->installSystemLanguagePack($lang);
                if ($result !== TRUE)
                    $error_list = is_array($result) ? $result : ___('An error has occured while trying to install the system language pack');
            }
        }
        return $error_list;
    }

    /**
     * Save Configuration. You can override the app name if required
     * @global \SCHLIX\cmsConfigRegistry $SystemConfig
     * @global \App\Users $CurrentUser
     * @param string $override_app_name
     * @return array
     */
    public function saveConfig($override_app_name = '')
    {
        global $SystemConfig;

        $admin_only_var_names = ['array_groups_allowed_for_backend_access', '_csrftoken'];
        $save_post = [];
        foreach ($admin_only_var_names as $vr)
            $save_post[$vr] = $_POST[$vr];
        
        unset ($_POST['array_groups_allowed_for_backend_access']);
        $retval = parent::saveConfig($override_app_name);
        if ($override_app_name == 'system' && $retval['status'] == SAVE_OK)
        {
            $lang = $SystemConfig->get('system', 'str_interface_language');
            $site_name = $SystemConfig->get('system', 'str_site_name');
            //$site_meta_keywords = str_replace('"','', $SystemConfig->get('system','str_site_meta_keywords'));
            //$site_meta_description = str_replace('"','', $SystemConfig->get('system','str_site_meta_description'));

            $config_to_process = [
                'SCHLIX_DEFAULT_LANGUAGE' => $lang,
                'SCHLIX_SITE_NAME' => $site_name,
                    //'SCHLIX_SITE_META_KEYWORDS' => $site_meta_keywords,
                    //'SCHLIX_SITE_META_DESCRIPTION' => $site_meta_description,
            ];
            $sitemanager = new \App\SiteManager();
            $sitemanager->changeSiteConfigDefinitions($config_to_process);
        }
        // silly workaround;
        $_POST = $save_post;
        $retval = parent::saveConfig();
        return $retval;
    }

    protected function ajxp_RefreshAllHooks()
    {
        check_csrf_halt_on_error();
        \SCHLIX\cmsHooks::refreshAll();
        return ajax_reply_ok('OK');
    }

    protected function ajxp_ClearCache()
    {
        global $SystemDB;
        
        check_csrf_halt_on_error();
        $SystemDB->query("TRUNCATE TABLE gk_cache_items");
        return ajax_reply_ok('OK');
    }

    protected function ajxp_ClearSessions()
    {
        global $SystemDB;
        
        check_csrf_halt_on_error();
        $SystemDB->query("TRUNCATE TABLE `gk_session_handler`");
        $SystemDB->query("TRUNCATE TABLE `gk_user_sessions`");
        return ajax_reply_ok('OK');
    }
    
    protected function ajxp_RegenerateAllTags()
    {
        global $TagManager;
        
        check_csrf_halt_on_error();
        
        $TagManager->regenerateAllTags();
        return ajax_reply_ok('OK');
        
    }
    public function Run()
    {

        $this->CheckIfCurrentUserAllowedAccess();
        switch (fget_alphanumeric('action'))
        {
            case 'editglobalconfig':
                $this->lastConfigSaveResult = NULL;
                $this->editConfig('system', 'config.global');
                return RETURN_FULLPAGE;
                break;
            case 'saveglobalconfig':
                $this->lastConfigSaveResult = $this->saveConfig('system');
                if ($this->lastConfigSaveResult['status'] == SAVE_OK)
                    $this->returnToMainAdminApplication();
                else
                {
                    $this->editConfig('system', 'config.global');
                    return RETURN_FULLPAGE;
                }
                break;
            default: return parent::Run();
        }
    }

}
