/* 
 * Copyright (C) 2015 SCHLIX WEB INC.
 *
 * This software is licensed under GPLv3
 *  
 *
 * Please read the LICENSE.html for details
 */
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

/**
 * View Controller class
 */
SCHLIX.CMS.AdminAdmin = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super( "admin");
    };
    
    static initIframe() {
        if (SCHLIX.Dom.get('schlix_news_main'))
            this.createIframe('schlix_news_main',  site_httpbase + '/admin/readnews?source=news-main');
        if (SCHLIX.Dom.get('schlix_news_ext'))
            this.createIframe('schlix_news_ext',   site_httpbase + '/admin/readnews?source=news-ext');	
        if (SCHLIX.Dom.get('schlix_news_themes'))
            this.createIframe('schlix_news_themes',   site_httpbase + '/admin/readnews?source=news-themes');	
        
    };

    static createIframe (inside_element,src)
    {
    //doesn't block the load event
      var i = document.createElement("iframe");
      i.src = src;
      i.scrolling = "auto";
      i.frameborder = "0";
      i.width = "100%";
      //i.height = "350px";
      i.style.border = "none";
      try{
      document.getElementById(inside_element).appendChild(i);
      }catch (e)
      {
          alert("Cannot find " + inside_element + ": " + e);
      }
    };
    
    onAllHooksRefreshed(o)
    {
        var response = ajax_parse(o.responseText);
        if (response === 'OK')
        {
            SCHLIX.Alert.info('OK');
        }
        else
            alert(response);
    }
    
    onRegenerateAllTagsClick(e)
    {
        var postData = "_csrftoken=" + _csrftoken;
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=regeneratealltags",
                {success: this.onAllHooksRefreshed, failure: this.handleFailure, scope: this}, postData);
    }

    onRefreshAllHooksClick(e)
    {
        var postData = "_csrftoken=" + _csrftoken;
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=refreshallhooks",
                {success: this.onAllHooksRefreshed, failure: this.handleFailure, scope: this}, postData);
    };
    
    onClearCacheClick(e)
    {
        var postData = "_csrftoken=" + _csrftoken;
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=clearcache",
                {success: this.onAllHooksRefreshed, failure: this.handleFailure, scope: this}, postData);
    };

    onClearSessionClick(e)
    {
        var postData = "_csrftoken=" + _csrftoken;
        var request = SCHLIX.Ajax.POST( site_httpbase + "/admin/app/" + this.app_name + "?action=clearsession",
                {success: this.onAllHooksRefreshed, failure: this.handleFailure, scope: this}, postData);
    };
    
    
    onDOMReady()
    {
        SCHLIX.CMS.AdminAdmin.initIframe();
        SCHLIX.Event.on('btn-refresh-all-hooks', 'click', this.onRefreshAllHooksClick, this, true);
        SCHLIX.Event.on('btn-clear-cache', 'click', this.onClearCacheClick, this, true);
        SCHLIX.Event.on('btn-clear-session', 'click', this.onClearSessionClick, this, true);
        SCHLIX.Event.on('btn-regenerate-all-tags', 'click', this.onRegenerateAllTagsClick, this, true);
    };
    
    runCommand  (command, evt)
    {
        switch (command)
        {
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            case 'global-config':
                this.redirectToCMSCommand("editglobalconfig");
                return true;
                break;
                
            default:
                return super.runCommand(command, evt);
                break;
        }
        //alert("Received Command: " + command);
    };
};
