<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
global $HTMLHeader;

// Use HTMLHeader instead of $this->setPageTitle because this warning disables everything else
$HTMLHeader->add('<title>'.___('Security warning').'</title>');
?>
<?php $fix_link = $this->createFriendlyURL('action=fixsecurity') ?>
<div class="alert alert-danger">
    <i class="fa fa-exclamation-circle fa-2x"></i>&nbsp;
    <span style="font-size:150%"><?= sprintf(___('Warning! Potential security issue has been detected'), $fix_link); ?></span>
    <p><?= ___('Report file').': '.$main_report_filename ?></p>
    <?php if ($error): ?>
    <?= $error ?>
    <?php endif ?>
    <?php if ($ist_mu): ?>
    <h3><?= ___('Malicious users') ?></h3>
    <table class="table table-responsive">        
        <tr>
            <th><?= ___('User ID') ?></th>
            <th><?= ___('Username') ?></th>
            <th><?= ___('Email') ?></th>
            <th><?= ___('Last IP Address') ?></th>
            <th><?= ___('Date Created') ?></th>
            <th><?= ___('Last Login') ?></th>
        </tr>
        <?php foreach ($mal_users as $u): ?>
        <tr>
            <td><?= ___h($u['id']) ?></td>
            <td><?= ___h($u['username']) ?></td>
            <td><?= ___h($u['email_address']) ?></td>
            <td><?= ___h($u['last_ip_address']) ?></td>
            <td><?= ___h($u['date_created']) ?></td>
            <td><?= ___h($u['date_last_logged_in']) ?></td>
            
        </tr>        
        <?php endforeach ?>
    </table>
    
    <?php endif ?>
    
    <?php if ($ist_mf): ?>
    <h3><?= ___('Potentially malicious files') ?></h3>
    <table class="table table-responsive">        
        <tr>
            <th><?= ___('Status') ?></th>
            <th><?= ___('Filename') ?></th>
            <th><?= ___('Size') ?></th>
            <th><?= ___('Date Created') ?></th>
        </tr>
        <?php foreach ($this->malicious_files as $mf): ?>
        <tr>
            <td><?= $mf['fixed'] ? ___('Fixed') : ___('Vulnerable') ?></td>
            <td>
                <?= ___h($mf['filename']) ?><br />
                <?= $mf['fixed'] ? ___('Quarantined') : ___('Cannot be processed') ?>
                <?= ___h($mf['quarantine_filename']) ?>
            </td>
            <td><?= filesize ($mf['quarantine_filename']) ?></td>
            <td><?= date (DEFAULT_DATE_FORMAT, filemtime($mf['quarantine_filename'])) ?></td>
        </tr>        
        <?php endforeach ?>
    </table>
    <?php endif ?>
    
    <?php if ($ist_ww): ?>

    <h3><?= ___('World writable file or directory') ?></h3>
    <table class="table table-responsive">        
        <tr>
            <th><?= ___('Status') ?></th>
            <th><?= ___('Filename') ?></th>
            <th><?= ___('Size') ?></th>
            <th><?= ___('Permissions') ?></th>
            <th><?= ___('Owner') ?></th>
            <th><?= ___('Date Created') ?></th>
        </tr>
        <?php foreach ($world_writables as $wf): ?>
        <?php $pui = posix_getpwuid(fileowner($wf['filename'])); ?>
        <tr>
            <td><?= $wf['fixed'] ? ___('Fixed') : ___('World writable') ?></td>
            <td><?= ___h($wf['filename']) ?></td>
            <td><?= filesize ($wf['filename']) ?></td>
            <td><?= get_file_permissions ($wf['filename']) ?></td>
            <td><?= $pui ? ___h($pui['name']) : '' ?></td>
            <td><?= date (DEFAULT_DATE_FORMAT, filemtime($wf['filename'])) ?></td>
        </tr>        
        <?php endforeach ?>
    </table>
    <?php endif ?>    
    <!-- actions -->
    <?php /*
    <?php if ($ist_mu): ?>
    <div class="checkbox">
        <label>
            <input type="checkbox" name="fix_mu" value="1" checked="checked" /><?= ___('Disable malicious users') ?>
        </label>
    </div>
    <?php endif ?>
    <?php if ($ist_ww): ?>
    <div class="checkbox">
        <label>
            <input type="checkbox" name="fix_mu" value="1" checked="checked" /><?= ___('Fix world writable files') ?>
        </label>
    </div>
    <?php endif ?>
    <?php if ($ist_mf): ?>
    <div class="checkbox">
        <label>
            <input type="checkbox" name="fix_mu" value="1" checked="checked" /><?= ___('Quarantine malicious files') ?>
        </label>
    </div>
    <?php endif ?>*/ ?>
    
    
</div>