<?php
if (!defined('SCHLIX_VERSION')) die('No Access');

//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//

?>
<?php global $CurrentUser; ?>
<?php $site_base_url = SCHLIX_SITE_URL . SCHLIX_SITE_HTTPBASE; ?>
<?= '<?xml version="1.0" encoding="utf-8"?>'; ?>
<?php if (file_exists(CURRENT_THEME_PATH . '/rss.css')): ?>
    <?= '<?xml-stylesheet type="text/css" href="'; ?><?= CURRENT_THEME_URL_PATH . $css_path; ?><?= '"?>'; ?>
<?php endif; ?>
<rss version="2.0">
    <channel>
        <title><?= $rss_blog_title; ?></title>
        <link><?= $site_base_url; ?></link>
        <description><?= $rss_desc; ?></description>
        <generator>Schlix</generator>
        <lastBuildDate><?= date("D, d M Y H:i:s O", strtotime($latestposts[0]['date_created'])); ?></lastBuildDate>
        <language>en-us</language>    
        <?php for ($i = 0; $i < $rss_maxposts; $i++): ?>
            <?php $post = $latestposts[$i];
            if ($post['status'] > 0 && $CurrentUser->hasReadPermission($post['permission_read']) && ($post['date_expiry'] == NULL || $post['date_expiry'] == NULL_DATE || days_difference_from_today($post['date_expiry']) > 0 )):
                $post_img = '';
                // you can customize your own stuff here
                $link = SCHLIX_SITE_URL . $this->createFriendlyURL("action=viewitem&id={$post['id']}");
                $entrydate = date("D, d M Y H:i:s O", strtotime($post['date_created']));
                $entrytitle = $post['title'];
                // Must be absolute path - Prana - Feb 3, 2011
                // for: href="/images/"
                $post['summary'] = preg_replace('/(?<=href=")(?!https?:\/\/|\/\/)(\/.*?)(?=")/i', SCHLIX_SITE_URL . '\\1', $post['summary']);
                // for: href="images/"		
                $post['summary'] = preg_replace('/(?<=href=")(?!https?:\/\/|\/\/)(.*?)(?=")/i', $site_base_url . '/\\1', $post['summary']);
                // for: src="/images/"		
                $post['summary'] = preg_replace('/(?<=src=")(?!https?:\/\/|\/\/)(\/.*?)(?=")/i', SCHLIX_SITE_URL . '\\1', $post['summary']);
                // for: src="images/"				
                $post['summary'] = preg_replace('/(?<=src=")(?!https?:\/\/|\/\/)(.*?)(?=")/i', $site_base_url . '/\\1', $post['summary']);
                
                $url_intro_image = $this->getBlogImage('image_small', $post['summary_intro_image']);
                
                if ($post['summary_intro_image'] && $url_intro_image) {
                    $img_attr = [];
                    if ($post['summary_intro_image_caption'])
                        $img_attr['alt'] = $post['summary_intro_image_caption'];
                    if (str_starts_with($url_intro_image, 'https://') || str_starts_with($url_intro_image, 'http://'))
                        $post_img = $url_intro_image;
                    else
                        $post_img = \__HTML::IMG(SCHLIX_SITE_URL . $this->getDataFileURLPath('image_small', $post['summary_intro_image']), $img_attr);
                }
                ?>      
                <item>
                    <pubDate><?= $entrydate; ?></pubDate>
                    <title><?= htmlspecialchars($entrytitle); ?></title>
                    <link><?= $link; ?></link>
                    <guid><?= $link; ?></guid>
                    <description><![CDATA[ <?= $post_img . $post['summary'] ?>]]></description>
                </item>
            <?php endif; ?>
        <?php endfor; ?>
    </channel>
</rss>