<?php
if (!defined('SCHLIX_VERSION'))
    die('No Access');
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
// SCHLIX WEB CONTENT MANAGEMENT SYSTEM - Copyright (C) SCHLIX WEB INC.
// License: GPLv3
// 
// Please read the license for details
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++//
?>
<?php global $SystemConfig, $CurrentUser; ?>

<schlix-config:data-editor   data-schlix-controller="SCHLIX.CMS.ContactsAdmin">
    <!-- end sidebar -->
    <schlix-config:save-result />
    <x-ui:schlix-editor-form id="form-edit-config" method="post" data-config-action="save" action="<?= $this->createFriendlyAdminURL('action=saveconfig') ?>" autocomplete="off">

        <schlix-config:action-buttons />
        <x-ui:csrf />

        <x-ui:schlix-tab-container>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_general" fonticon="far fa-file" label="<?= ___('General') ?>"> 
                <schlix-config:app_alias   config-default-value="<?= strtolower($this->schlix_master_class) ?>" />
                <schlix-config:app_description   />
                <schlix-config:checkbox config-key="bool_no_auto_render_contact_form" label="<?= ___('Do not render contact form automatically (new style)') ?>" />
                <schlix-config:checkbox config-key="bool_enable_captcha" label="<?= ___('Enable captcha for contact form') ?>" />
                <schlix-config:checkbox config-key="bool_disable_contact_form" label="<?= ___('Disable the contact form') ?>" />
                <schlix-config:integerbox min="0" max="999" config-key="int_seconds_before_next_contact" label="<?= ___('Flood control to prevent spam robot - wait time in seconds before next form submission (recommended: 30 seconds)') ?>"   />



            </x-ui:schlix-tab>
            <!-- tab -->

            <x-ui:schlix-tab id="tab_main_opt" fonticon="fa fa-newspaper" label="<?= ___('Default Main page Options') ?>"> 
                <!-- main page -->
                <x-ui:row>
                    <x-ui:column md="6">
                        <schlix-config:textbox config-key="str_mainpage_title" label="<?= ___('Main page title') ?>"   />                        
                        <schlix-config:textarea config-key="str_mainpage_text" label="<?= ___('Main page introduction text') ?>" class="wysiwyg" />

                        <schlix-config:textbox config-key="str_meta_keywords" label="<?= ___('Default Meta Keywords') ?>"   config-fonticon="fa fa-hashtag" />
                        <schlix-config:textbox config-key="str_meta_description" label="<?= ___('Default Meta Description') ?>"   config-fonticon="fa fa-hashtag" />

                    </x-ui:column>
                    <!-- col -->
                    <x-ui:column md="6">
                        <schlix-config:integerbox config-key="int_mainpage_items_per_page" config-default-value="10" label="<?= ___('Default maximum number of items to be displayed per page') ?>"   />
                        <schlix-config:main-page-meta-options config-key="array_mainpage_meta_options" item-per-column="5" column-count="1" />
                    </x-ui:column>
                </x-ui:row>

            </x-ui:schlix-tab>


            <!-- tab -->
            <x-ui:schlix-tab id="tab_category_opt" fonticon="fas fa-folder" label="<?= ___('Default Category Options') ?>"> 

                <schlix-config:integerbox config-key="int_category_items_per_page" config-default-value="10" label="<?= ___('Default maximum number of items to be displayed per page') ?>"   />
                <schlix-config:checkbox config-key="reset_category_items_per_page" label="<?= ___('Reset the number of items per page for all categories') ?>" />
                <schlix-config:category-meta-options config-key="array_default_category_meta_options"  item-per-column="1" column-count="3" />
                <schlix-config:checkbox config-key="reset_category_options" label="<?= ___('Reset all categories options') ?>" />

            </x-ui:schlix-tab>
            <!-- tab -->
            <x-ui:schlix-tab id="tab_item_opt" fonticon="fa fa-file-alt" label="<?= ___('Default Item Options') ?>"> 

                <schlix-config:item-meta-options config-key="array_default_item_meta_options" item-per-column="1" column-count="3" />
                <schlix-config:checkbox config-key="reset_item_options" label="<?= ___('Reset all item options') ?>" />

            </x-ui:schlix-tab>
            <!-- tab -->
            <?= \SCHLIX\cmsHooks::output('getApplicationAdminExtraEditConfigTab', $this) ?>               
            <!-- end -->

        </x-ui:schlix-tab-container>

    </x-ui:schlix-editor-form>
</schlix-config:data-editor>     
