<?php
namespace App;
/**
 * Core: BannedIP - Main Class
 * 
 * Core - BannedIP
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_BannedIP extends \SCHLIX\cmsApplication_List {

    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct('IP Address Ban', 'gk_bannedip_items');
        
        $this->disable_frontend_runtime = true;
    }
	//_______________________________________________________________________________________________________________//		
	public function banExists($ip)
	{
		global $SystemDB;
		
		$ip_addr = sanitize_string($ip);
		$sql = "SELECT COUNT({$this->field_id}) AS total_count FROM {$this->table_items} WHERE ip_address={$ip_addr}";
		$result = $SystemDB->getQueryResultSingleRow($sql);
		return ($result['total_count'] > 0);
	}	
	//_______________________________________________________________________________________________________________//		
	public function banIP($ip, $reason='', $expiry_in_hours = 0)
	{
		$ip = trim($ip);
		$is_valid_hostname = true;
		$is_valid_ipv4 = filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4);
		$is_valid_ipv6 = filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6);
                $ip_addr = '';
		if (!$is_valid_ipv4 && !$is_valid_ipv6)
		{
			$ip_addr = gethostbyname($ip);
			$is_valid_hostname = ($ip_addr != $ip);
		}
		if ($is_valid_ipv4 || $is_valid_ipv6)
		{
			if ($this->banExists($ip)) return false;
			$ip_addr = $ip;
		} elseif($is_valid_hostname)
		{
			if ($this->banExists($ip_addr)) return false;
		}
		else return false;
                
                $datavalues = [];
                $datavalues['ip_address'] = $ip_addr;
                $datavalues['date_created'] = get_current_datetime();
                if ((int) $expiry_in_hours > 0)
                    $datavalues['date_expiry'] = date(DEFAULT_DATE_FORMAT, time() + 3600 * $expiry_in_hours);
                $datavalues['reason'] = $reason;
                $this->table_items->quickInsert($datavalues);
		
		return true;	
	}
	//_______________________________________________________________________________________________________________//	
	public function Run($command)
	{
		return false;
	}



}
