<?php
/**
 * Core: Block Manager - Main page view template. Only lists categories 
 * 
 * Core - Block Manager
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
if (!defined('SCHLIX_VERSION'))
    die();


$str_mainpage_title =  $this->getConfig('str_mainpage_title') ? $this->getConfig('str_mainpage_title') : $this->getApplicationDescription();
$str_mainpage_text =  $this->getConfig('str_mainpage_text');
 // OPTIONAL - feel free to uncomment
 // $this->processDataOutputWithMacro($str_mainpage_text, 'viewMainPage');
?>
<div class="app-page-main app-<?= $this->app_name; ?>" id="app-<?= $this->app_name; ?>-main">
    <h1 class="main title"><?= ___h($str_mainpage_title); ?></h1>
    <?php if ($pg < 2) : ?>
        <?= $str_mainpage_text ?>
    <?php endif ?>

    <?php if ($categories): ?>
    <!-- ########################################################################### -->
    <!-- #######################  categories / subfolder ########################### -->
    <!-- ########################################################################### -->
        <div class="main categories">
            <?php foreach ($categories as $category): ?>
                <?php if ($category['status'] > 0): ?>            
                <section class="child-category">    
                    <?= isset($category['macro_processed_text_outside_article_top']) ? $category['macro_processed_text_outside_article_top'] : null ?>
                    <?php 
                        $category_id = $category[$field_cid];
                        $this->processDataOutputWithMacro($category, 'viewMainPageCategory', array('main_meta_options' => $main_meta_options));
                        $link = $this->createFriendlyURL("action=viewcategory&cid={$category_id}");
                        $category_title = ___h($category['title']);
                        $category_title_text = ($category!= null) && ($main_meta_options['display_child_category_read_more_link']==false || $main_meta_options['display_link_title']==true) ? 
                            \__HTML::A($category_title,$link) : $category_title;
                    ?>
                    <?php if ($category_title_text): ?>
                        <h2 class="category title"><i class="fas fa-folder"></i> <?= $category_title_text; ?></h2>
                    <?php endif ?>

                    <!-- Macro - Pre -->
                    <?php if ($category['macro_processed_text_before_article']): ?>        
                        <div class="meta before-article">        
                            <?= $category['macro_processed_text_before_article'] ?>            
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Pre -->

                    <!-- text -->
                    <?php if ($main_meta_options['display_item_summary']): ?>
                        <div class="text">
                            <?= $category['summary'] ?>
                        </div>
                    <?php endif; ?>
                    <!-- end text -->

                    <!-- Macro - Post -->   
                    <?php if (isset($category['macro_processed_text_after_article'])): ?>                
                        <div class="meta after-article">
                            <?= $category['macro_processed_text_after_article'] ?>
                        </div>
                    <?php endif ?>
                    <!-- End Macro - Post -->
                    <?= $category['macro_processed_text_outside_article_bottom'] ?>
                </section>
                <?php endif ?>
            <?php endforeach ?>       
        </div>
    <!-- ########################################################################### -->
    <!-- ######################## end categories / subfolder ####################### -->
    <!-- ########################################################################### -->
    <?php endif; ?> 
    
    <!-- pagination begin -->
    <?php $pagination_str = $this->displayItemPagination($pg,$pagination['total'],"action=main"); ?>
    <?php if ($pagination_str): ?>
        <div class="pagination"><?= $pagination_str; ?></div>
    <?php endif; ?>
    <!-- end pagination -->
</div>
 