<?php
namespace SCHLIX;


/**
 * Core: Composer - Composer
 * 
 * Core - Composer
 * 
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */

/* THIS PACKAGE IS STILL VERY EXPERIMENTAL WITH ALPHA QUALITY CODE. MORE TESTING IS REQUIRED!! **/
/* THIS PACKAGE IS STILL VERY EXPERIMENTAL WITH ALPHA QUALITY CODE. MORE TESTING IS REQUIRED!! **/
/* THIS PACKAGE IS STILL VERY EXPERIMENTAL WITH ALPHA QUALITY CODE. MORE TESTING IS REQUIRED!! **/

use Composer\Installer;
use Composer\IO\IOInterface;
use Composer\Json\JsonFile;
use Composer\Json\JsonManipulator;
use Composer\Package\Locker;
use Composer\Config;
use Composer\IO\ConsoleIO;
use Composer\Filter\PlatformRequirementFilter\IgnoreListPlatformRequirementFilter;
use Composer\Filter\PlatformRequirementFilter\PlatformRequirementFilterFactory;
use Composer\Filter\PlatformRequirementFilter\PlatformRequirementFilterInterface;
use Symfony\Component\Console\Helper\HelperSet;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Output\StreamOutput;


class SCHLIXComposerInstallerIO extends ConsoleIO
{
    public function __construct(InputInterface $input = null, OutputInterface $output = null, HelperSet $helperSet = null)
    {
        
        $p_input = !is_null($input) ? $input : new ArrayInput([]);
        $p_output =  !is_null($output) ? $output : new StreamOutput(fopen('php://output', 'w'));
        $p_helperSet =  !is_null($helperSet) ? $helperSet : new HelperSet();
        parent::__construct($p_input, $p_output, $p_helperSet);
        ob_implicit_flush(true);
        @ob_end_flush();
    }
    public function writeError($messages, $newline = true, $verbosity = self::NORMAL)
    {
        if (is_array($messages))
        {
            $c = count ($messages);
            for ($i = 0;$i < $c; $i++)
            {
                if (preg_match('/((?<=<error>).+(?=<\/error>))|(\[.+Exception\])/', $messages[$i], $matches)) {
                    throw new \RuntimeException($matches[0]);
                }
                $messages[$i].= '<br />';
                
            }            
        } else if (is_string($messages))
            $messages.= '<br />';

        parent::writeError($messages, $newline);
    }
}



class SCHLIXFactory extends \Composer\Factory
{
    protected static $extra_config = [];

    public static function setExtraConfig($config)
    {
        self::$extra_config = $config;
    }

    public static function createConfig(IOInterface $io = null, $cwd = null)
    {
        $config = new Config(true, $cwd);
        $config->merge(['config' => static::$extra_config]);
        return $config;
    }

}

/**
 * Composer Helper
 */
class ComposerHelper
{
    
    protected $cscfg;
    
    private $dir_vendor;
    private $dir_cache;
    private $dir_home;
    
    private $file_composer_json;
    private $file_composer_lock;
    
    /**
     * 
     * @param string $home
     * @param string $cache_dir
     * @param string $vendor_dir
     * @param string $file_composer_json
     * @param string $file_composer_lock
     */
    public  function __construct($home, $cache_dir, $vendor_dir, $file_composer_json, $file_composer_lock)
    {
        ini_set('memory_limit', '-1');
        $ca_file = ini_get('openssl.cafile');
        if (empty($ca_file) || !is_readable_file($ca_file))
        {
            $schlix_ca_bundle_file = SCHLIX_SYSTEM_PATH.'/libs/data/ca-bundle/ca-bundle.pem';
            if (is_readable($schlix_ca_bundle_file))
            {
                ini_set('openssl.cafile', $schlix_ca_bundle_file);
                $_SERVER['SSL_CERT_FILE'] = $schlix_ca_bundle_file;
            }
        }
        // Fix for PHP8.4 and Composer 2.2
        $errorlevel = error_reporting();
        error_reporting($errorlevel & ~E_DEPRECATED);
        // end fix
        
        $this->file_composer_lock = $file_composer_lock;
        $this->file_composer_json = $file_composer_json;
        if (!file_exists($this->file_composer_json))
        {
            file_put_contents($this->file_composer_json, '{}');
        }
        
        $this->dir_home = $home;
        $this->dir_cache = $cache_dir;
        $this->dir_vendor = $vendor_dir;
        $this->cscfg = [
            'home' => $this->dir_home,
            'cache-dir' => $this->dir_cache,
            'vendor-dir' => $this->dir_vendor,
            'cache-files-ttl' => 3600
        ]; 
        $this->io =  new SCHLIXComposerInstallerIO(null, null);
    } 
    
    public  function __destruct() {
        $_SERVER['SSL_CERT_FILE'] = '';        
    }
    
    private function getComposerInstance()
    {
        $io = $this->io;// new SCHLIXComposerInstallerIO(null, null);
        $file = new JsonFile($this->file_composer_json, null, $io);
        $config = $file->read();
        SCHLIXFactory::setExtraConfig($this->cscfg);
        
        $composer = SCHLIXFactory::create($io, $config);
        return $composer;
        
    }
    
    /**
     * Install composer packages
     * @param array $packages
     * @throws \Exception
     */
    public function InstallPackage(array $packages) 
    {
        
        $json_content = file_get_contents($this->file_composer_json);
        if (empty($json_content))
            $json_content = json_encode (array());
        $composer = $this->getComposerInstance();
        $mngr_repo = $composer->getRepositoryManager();
        $manipulator = new JsonManipulator($json_content);
        $invalid = false;
           
        foreach ($packages as $package ) 
        {
            $constraint = '*';
            $r = $mngr_repo->findPackage($package, $constraint);
            if ($r)
            {
            $invalid = !$manipulator->addLink('require', $package, $constraint, true) || !$manipulator->removeSubNode('require-dev', $package);
                         if ($invalid)
                             break;             
            }
        }
        if (!$invalid)
        {
            $json_content = $manipulator->getContents();
            file_put_contents($this->file_composer_json, $json_content);
        }
        clearstatcache();
        $composer = null; // must nullify
        $composer = $this->getComposerInstance();
        
        $mngr_repo = $composer->getRepositoryManager();
        $mngr_install = $composer->getInstallationManager();
        $lock_json_file = new JsonFile($this->file_composer_lock, null, $this->io);        
        $locker = new Locker($this->io, $lock_json_file, $mngr_install, $json_content);
        $composer->setLocker($locker);
        
        $mngr_install->setOutputProgress(null);
        $installer = Installer::create($this->io, $composer)
            ->setUpdate(true) // THIS is what makes it do "composer update"
            ->setDevMode(true) // or false depending on context
            ->setPreferStable(true)
            ->setPreferDist(true)
            ->setOptimizeAutoloader(true)
            ->setClassMapAuthoritative(false)
            ->setPlatformRequirementFilter(PlatformRequirementFilterFactory::fromBoolOrList(false))
            // more
            ->setVerbose(true)
            ->setWriteLock(true)
//            ->setExecuteOperations(true)
            ->setDumpAutoloader(true)
            ->setRunScripts(false)
            ->setOptimizeAutoloader(true)
            // ->setUpdateAllowList($packages) // disable this
            ->setUpdateAllowTransitiveDependencies(\Composer\DependencyResolver\Request::UPDATE_LISTED_WITH_TRANSITIVE_DEPS_NO_ROOT_REQUIRE ) ;
        try {
            $status = $installer->run();
        } catch (\Throwable $exception) {
            echo $exception->getMessage();
            $status = 1;
        }

        if ($status !== 0) 
        {
            file_put_contents($this->file_composer_json, $json_content);
            throw new \Exception('An error occurred'); 
        }
    }
    

}