<?php
namespace App;

/**
 * Core: Editor Manager - Admin class
 * 
 * Core - Editor Manager
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_EditorManager_Admin extends \SCHLIX\cmsAdmin_PluginsManager {
    /**
     *
     * @var Core_EditorManager 
     */
    protected $app;

    //_________________________________________________________________________//
    /**
     * Constructor
     * @global \SCHLIX\cmsDatabase $SystemDB
     */        
    public function __construct() {
        // Data: Item
        parent::__construct('wysiwygeditors');
                $this->setItemFieldNamesForAjaxListing('id', 'title', 'virtual_filename', 'date_created', 'date_modified', 'is_system');

    }

//_________________________________________________________________________//
    
    public function ajaxGetItemsByCategoryID($id, $start = 0, $end = 0, $sortby = '', $sortdirection = 'ASC')
    {
        $this->checkForUnregisteredItems(); // Experimental
        return parent::ajaxGetItemsByCategoryID($id, $start, $end, $sortby, $sortdirection);
    }
            
    public function installItem($filename) {
        global $SystemDB;

        $datavalues['title'] = $filename;
        $datavalues['virtual_filename'] = $filename;
        
        $SystemDB->simpleInsertInto($this->table_categories, $datavalues);                            
        // Child classes (app, blocks, filters, templates) install inherit here
    }
    
    public function findInstalledItem($title) {
        global $SystemDB;

        $result = $SystemDB->getQueryResultArray( "SELECT * from {$this->table_categories} WHERE (title = :title)", ['title' => $title]);
        return $result;
    }

    
    //_________________________________________________________________________//
    public function cleanUpOrphanedItems($items_from_directory) {
        global $SystemDB;

        $total_count = ___c($items_from_directory);
        for ($i = 0; $i < $total_count; $i++)
            $items_from_directory[$i] = sanitize_string($items_from_directory[$i]);
        $existing_apps = implode(',', $items_from_directory);
        $sql = "DELETE FROM `{$this->table_categories}` WHERE title NOT IN ({$existing_apps})";
        $SystemDB->query($sql);
    }
    
/*    //_________________________________________________________________________//
    public function ajaxSetDefaultEditor($mode, $id) {
        $retval = $this->app->setDefaultWYSIWYG($mode, $id);
        return ajax_reply(200, $retval);
    }
    
    //_________________________________________________________________________//
    public function ajaxGetDefaultWYSIWYGID() {
        $response = [];
        $response['frontend'] = $this->app->getDefaultWYSIWYGID('frontend');
        $response['backend'] = $this->app->getDefaultWYSIWYGID('backend');
        return ajax_reply(200, $response);
    }
*/

    
    /**
     * Modify data before save item
     * @global \App\Users $CurrentUser
     * @global \App\WysiwygEditors $WYSIWYGEditor
     * @param array $datavalues
     * @return array
     */
    public function onModifyDataBeforeSaveItem($datavalues) {
        global $CurrentUser, $WYSIWYGEditor;
        
        $datavalues = parent::onModifyDataBeforeSaveItem($datavalues);
        
        /* NO LONGER NEEDED AS OF 2.2.0 if ($datavalues['permission_read_everyone'])
            $datavalues['permission_read'] = 'everyone';
        $datavalues['permission_read'] = serialize($datavalues['permission_read']);
        $datavalues['permission_write'] = serialize($datavalues['permission_write']); */

        $datavalues['virtual_filename'] = alpha_numeric_with_dash_underscore($datavalues['virtual_filename']);
        $datavalues['virtual_filename'] = $this->app->preventDuplicateValueInItemTable('virtual_filename',  $datavalues['virtual_filename'],$datavalues[$this->field_id]);
        if ((int) $datavalues['id'] > 0)
        { 
            $editor = \App\wysiwygEditors_Profiles::getEditorInstanceByProfileID($datavalues['id']);
        } else
        {
            $editor_data = $WYSIWYGEditor->getWysiwygEditorByName($datavalues['wysiwyg_editor_name']);
            if ($editor_data)
            {
                $datavalues['editor_id'] = $editor_data['id'];
                $editor_name = '\\WysiwygEditor\\'.alpha_numeric_with_dash_underscore($datavalues['wysiwyg_editor_name']);
                $editor = new $editor_name();
                
            } else die (sprintf( ___('Cannot find editor %s'), $datavalues['wysiwyg_editor_name']));
            
        }
        if ($editor)
            $datavalues = $editor->onModifyDataBeforeSaveConfig ($datavalues);
        return $datavalues;
    }
    /**
     * Write config after save item
     * @param array $datavalues
     * @param array $original_datavalues
     * @param array $previous_item
     * @param array $retval
     */
    public function onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval) {
        
        
        parent::onAfterSaveItem($datavalues, $original_datavalues, $previous_item, $retval);
        if ($retval['status'] == SAVE_OK)
        {
            $editor = \App\wysiwygEditors_Profiles::getEditorInstanceByProfileID($retval['id']);
            
            $post_keys_to_ignore = array('id');


            $existing_wysiwyg_profile = $this->getItemByID(intval($retval['id']));
            $data_wysiwyg_short_code_name = $existing_wysiwyg_profile['virtual_filename'];      

            $wysiwyg_config = new \SCHLIX\cmsConfigRegistry('gk_wysiwyg_config');
            $existing_keys = $wysiwyg_config->get($data_wysiwyg_short_code_name);
            $wysiwyg_config->clearCache($data_wysiwyg_short_code_name);
            $wysiwyg_config->deleteSection($data_wysiwyg_short_code_name);
            $data_for_wysiwyg = $_POST;

            foreach ($post_keys_to_ignore as $ignore)
                 unset($data_for_wysiwyg[$ignore]);
            if ((int) $original_datavalues['reset_to_default'] == 1)
            {
                $data_for_wysiwyg = $editor->getDefaultProfileResetSettings($original_datavalues['reset_to_default_profile']);
            } else
            {
                if ($existing_keys)
                {
                    foreach ($existing_keys as $ex_key => $ex_value) {
                        if (!array_key_exists($ex_key, $data_for_wysiwyg))
                            $data_for_wysiwyg[$ex_key] = NULL;
                    }
                }
            }

            // handle checkbox save because it won't show up in post
            foreach ($data_for_wysiwyg as $key => $value) {
                $wysiwyg_config->set($data_wysiwyg_short_code_name, $key, $value);
            }
            
            $editor->onAfterSaveConfig ($retval['id']);
            $editor->reloadConfigFromDatabase();
            $generated_script = $editor->getUncachedConfigurationScript();
            
            $wysiwyg_config->set($data_wysiwyg_short_code_name,'str_generated_config', $generated_script);
            
        }
    }    
    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            /*case 'setdefaultwysiwyg':
                return ajax_echo($this->ajaxSetDefaultEditor($_POST['mode'], $_POST['id']));
                break;
            case 'getdefaultwysiwyg':
                return ajax_echo($this->ajaxGetDefaultWYSIWYGID());
                break;*/
            default: return parent::Run();
        }
    }

}
            