/**
 * Core: Editor Manager - Javascript admin controller class
 * 
 * Core - Editor Manager 
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_EditorManagerAdminController = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("core.editormanager");
    };
    /**
     * Datatable row format: item title
     * @param {type} elCell
     * @param {type} oRecord
     * @param {type} oColumn
     * @param {type} oData
     * @param {type} oDataTable
     * @returns {undefined}
     */
    static formatDataTableCell_DefaultTitleColumn  (elCell, oRecord, oColumn, oData) {

        var field_title = SCHLIX.Util.isUndefined(this.parentControl.element_data["field-item_title"]) ? "title" : this.parentControl.element_data["field-item_title"];
        var odata_id = oRecord.getData("id");
        var odata_cid = oRecord.getData("cid");
        var itemTitle = oRecord.getData(field_title); // oRecord.getData("title");
        var itemLink = site_httpbase;
        if (itemTitle == null)
        {
            SCHLIX.log("formatDataTableCell_DefaultTitleColumn cannot process a null title", 'warn');
            return;
        }
        if (itemTitle.length > 40)
            itemTitle = itemTitle.substr(0, 40) + '...';
        var app_name = this.parentControl.app_name;
        if (odata_cid > 0)
        {
        var the_id = oRecord.getData("cid");
        var theValue = 'c' + the_id;
        var icon = "<i class =\"fas fa-folder fa-2x\"></i>";
        if (itemTitle === '')
            itemTitle = '(Untitled)';
        if (itemTitle)
            itemTitle = SCHLIX.Util.escapeHTML(itemTitle);

        // var checkbox = '<input type="checkbox" class="selections" value="' + theValue + '"  />';            
        var editIcon = "<i class=\"fas fa-pencil-alt\"></i> ";
        //itemLink = _schlix_app_controller + oColumn.app_name + '&action=editcategory&id=' + oRecord.getData("cid");
        elCell.innerHTML = '<div style="float:left" >' + '<a  title="Click here to go into this category" class="datatable-folder" href="javascript:void(0);"  data-category-id="' + the_id + '" id="' + app_name + "-lnk-" + theValue + '">' + " " + icon + " " + itemTitle + '</a>' +
            '</div>';
            
            //SCHLIX.CMS.__default_formatFolderInDataTable(app_name, elCell, oRecord, itemTitle, site_httpbase + this.parentControl.schlix_application_url + 'action=editcategory&id=' + odata_cid);
        } else
        {
            // console.log(oRecord);
            var the_id = oRecord.getData("id");
            var theValue = 'i' + the_id;
            if (itemTitle === '')
                itemTitle = '(Untitled)';
            var icon = "<i class =\"fas fa-pencil-square fa-2x\"></i>";

            itemLink += this.parentControl.schlix_application_url + 'action=edititem&id=' + the_id;
            var item_class = '';
            var display_preview_link = '';
            if (itemTitle)
                itemTitle = SCHLIX.Util.escapeHTML(itemTitle);            

            elCell.innerHTML = '<a class="' + item_class + '" id="' + app_name + "-lnk-" + theValue + '" title="Click here to edit this item" href="' + itemLink + '">' + " " + icon + " " + itemTitle + '</a>' + display_preview_link;
        }
    };
    
    
    static formatDataTableCell_CheckBox (elCell, oRecord, oColumn, oData) {
        var theID = '';
        var theValue = '';

        var app_name = this.parentControl.app_name;
        if (oRecord.getData("cid") > 0)
        {
            theID = app_name + '-select-cid' + oRecord.getData("cid");
            theValue = 'c' + oRecord.getData("cid");
        }
        else
        {
            theID = app_name + '-select-id' + oRecord.getData("id");
            theValue = 'i' + oRecord.getData("id");
        }

        elCell.innerHTML = '<input type="checkbox" class="' + app_name + '-chkselections" name="' + app_name + '-chkselections[]" id="' + theID + '"  value="' + theValue + '" />';
    }; 
    
    static formatDataTableCell_Status (elCell, oRecord, oColumn, oData) {
        var button_name = '';
        var color = '';
        var rec_id = parseInt(oRecord.getData('id'), 10);
        if (rec_id > 0)
        {
            switch (oData)
            {
                case 1:
                    button_name = "check-circle";
                    color = 'green';
                    break;
                    // more ...
                default:
                    button_name = "times-circle";
                    color = 'red';
                    break;
            }
            elCell.innerHTML = '<i class="fa fa-' + button_name + '" style="color:' + color + '"></i>';
        } else 
        {
            elCell.innerHTML = '-';
        }
    }; // end func 
    
   redirectToOtherAppCMSCommand (app, command, open_in_new_window)
   {
       var the_url = site_httpbase + "/admin/app/" + app + "?action=" + command;

       if (open_in_new_window)
       {
           var win = window.open(the_url, 'new');
           if (win) {
               //Browser has allowed it to be opened
               win.focus();
           } else {
               //Browser has blocked it
               SCHLIX.Alert.warning('Cannot open the command in a new window since a popup blocker blocked the call. Please enable popup for this website');
           }
       } else
       {
           window.location.href = the_url;
       }

   };
    
    
    /**
     * Show Edit Category Dialog
     * @param {type} event
     * @returns {undefined}
     */
    showInstallerWindow ()
    {
        var obj = SCHLIX.CMS.getObject('schlix-cms-package-installer');
        obj.show();
    }; // end func
    
    
    runCommand (command, evt)
    {
        //if (evt.type == 'contextmenu')
        var open_in_new_window = is_rightclick_event(evt);
        switch (command)
        {
            case 'new-item':
                var editor_name = (evt.target.getAttribute('data-wysiwyg-editor-name'));
                this.redirectToOtherAppCMSCommand('wysiwygeditors.profiles', "newitem&editorname=" + editor_name,open_in_new_window);
                return true;
                break;
            case 'new-category':
                this.redirectToCMSCommand("newcategory",open_in_new_window);
                return true;
                break;
            case 'edit-current-category':
                var target = evt.target;                
                window.location = target.href;
                return true;
                break;              
            case 'install':
                this.showInstallerWindow();
                break;
            case 'form-submit-ok':
                this.cms_control.refreshControls();
                break;
            
            case 'config':
                this.redirectToCMSCommand("editconfig",open_in_new_window);
                return true;
                break;
            default:
                return super.runCommand(command,evt);
                break;
        }
    }
};