<?php
namespace App;

use \HTMLPurifier;

/**
 * Core: EmailQueue - Admin class
 * 
 * Core - EmailQueue
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @version 1.0
 * @package core
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
class Core_EmailQueue_Admin extends \SCHLIX\cmsAdmin_List {

    /**
     *
     * @var \App\Core_EmailQueue 
     */
    protected $app;
    /**
     * Constructor
     */
    public function __construct()
    {
		// Data: Item
		parent::__construct (true, []);
		$this->search_field = 'description';
                $this->setItemFieldNamesForAjaxListing('id', 'queue_marker', 'date_queued','date_sent','guid','field_subject','field_to_name','field_to_email','status','retry_count');
    } 

        //_________________________________________________________________________//
    /**
     * Get Item By ID
     * @param int $id
     */
    public function ajaxGetEmailByID($id) {

        $id = (int) $id;
        $item = $this->app->getItemByID($id);
        if ($item)
        {
            $error_file = $file_html = SCHLIX_SITE_PATH.$item['store_folder']."/{$id}.error.log";
            $file_html = SCHLIX_SITE_PATH.$item['store_folder']."/{$id}.html";
            $file_text = SCHLIX_SITE_PATH.$item['store_folder']."/{$id}.txt";
            $body_html =  (file_exists($file_html)) ? file_get_contents($file_html) : 'ERROR';
            $body_text =  (file_exists($file_text)) ? file_get_contents($file_text) : 'ERROR';
            if (file_exists($error_file))
                $item['errors'] = @file_get_contents ($error_file);
            //$item['body_html'] = $body_html;
            $item['body_text'] = nl2br($body_text);
            $item['url_body_html'] = $this->createFriendlyAdminURL("action=viewhtmlemailcontent&id={$id}");
            return ajax_reply(200, $item);
        } 
        else
        {
            return ajax_reply(201,'Not found');
        }
    }
    
    /**
     * Get Item By ID
     * @param int $id
     */
    public function viewEmailHtmlByID($id) {

        $html_purifier_cache_dir = SCHLIX_FS_CACHE_FOLDER.'/htmlpurifier';
        $has_fs_cache = create_directory_if_not_exists($html_purifier_cache_dir, true);
        
            
        $id = (int) $id;
        $item = $this->app->getItemByID($id);
        if ($item)
        {
            if (class_exists("\HTMLPurifier")) // just so that the class is autoloaded
            {
                $config = \HTMLPurifier_Config::createDefault();
                if ($has_fs_cache)
                    $config->set('Cache.SerializerPath', $html_purifier_cache_dir);
                $purifier = new \HTMLPurifier($config);

                $error_file = $file_html = SCHLIX_SITE_PATH.$item['store_folder']."/{$id}.error.log";
                $file_html = SCHLIX_SITE_PATH.$item['store_folder']."/{$id}.html";
                $body_html =  (file_exists($file_html)) ? file_get_contents($file_html) : 'ERROR';
                if (file_exists($error_file))
                    $item['errors'] = @file_get_contents ($error_file);
                //$item['body_html'] = $body_html;
                $safe_html  = $purifier->purify($body_html);
                echo $safe_html;
            }
            else echo "No HTML Purifier detected";
        } 
        else
        {
            die('Not found');
        }
        return false;
    }    
    
    public function ajxp_TestEmail()
    {
        global $SystemConfig;
        $error_list = [];
        check_csrf_halt_on_error();
        $email_to  =fpost_string('msg_to', 255);
        $subject = fpost_string('msg_subject', 255);
        $message = fpost_string('msg_message', 4096);
        if (!is_valid_email_address(SCHLIX_MAIL_DEFAULT_EMAIL))
            $error_list[] = ___('Invalid email specified for SCHLIX_MAIL_DEFAULT_EMAIL');
        
        if (is_valid_email_address($email_to))
            $_SESSION['test_email_to'] = $email_to;
        else 
            $error_list[] = ___('Invalid email address');
        
        if (empty($error_list))
        {
            \App\Core_EmailQueue::setDebug(true);
            $dbconfig_timeout = $SystemConfig->get('emailqueue','int_smtp_timeout');
            $unq = new_uuid_v4();
            $result = \App\Core_EmailQueue::__sendEmailDirectly($dbconfig_timeout, $unq, $subject, SCHLIX_MAIL_DEFAULT_SENDER, SCHLIX_MAIL_DEFAULT_EMAIL, 
            $email_to, $email_to, null, null, 
            null, null, null, null,
            null, null, null,
            $message, $message, null);            
            $data = [
                'lines' => $result,
                'debug' => \App\Core_EmailQueue::getLastDebugOutput()
            ];            
            \App\Core_EmailQueue::setDebug(false);
            return ajax_reply_ok($data);
        } else 
        {
            return ajax_reply_error($error_list);
        }
    }

    //_________________________________________________________________________//
    public function Run() {
        switch (fget_alphanumeric('action')) {
            case 'getemail':
                return ajax_echo($this->ajaxGetEmailByID(fget_int('id')));
                break;
            case 'viewhtmlemailcontent':
                $this->viewEmailHtmlByID(fget_int('id'));
                return false;
                break;
            
            default:return parent::Run();
        }
    }
    
}
