/**
 * Core - Help - Javascript admin controller class
 *
 * @copyright 2019 SCHLIX Web Inc
 *
 * @license GPLv3
 *
 * @package core
 * @version 1.0
 * @author  SCHLIX Web Inc <info@schlix.com>
 * @link    http://www.schlix.com
 */
SCHLIX.CMS.Core_EmailSetupAdminController = class extends SCHLIX.CMS.BaseController  {  
    /**
     * Constructor
     */
    constructor ()
    {
        super("core.emailsetup");
    };
   /**
     * Edit category dialog box 
     * @param {event} event
     * @param {bool} is_new
     */
    onShowTestDialogClick(event)
    {
        var dialog_box = SCHLIX.CMS.getObject('schlix-cms-emailtest-dialog');
            var c = SCHLIX.Dom.get('testemail_send_result');
            c.innerHTML =  'Press SEND to begin testing';
        
        dialog_box.show();       
  
    };
    /**
     * Automatically called when the DOM is ready
     * @param {event} event
     */
    onDOMReady (event)
    {
        if (SCHLIX.Dom.get('smtp_use_auth'))
        {
            SCHLIX.Event.on('smtp_use_auth', 'change', this.onSMTPAuthenticationChanged, this, true);           
            this.onSMTPAuthenticationChanged(null);
        }
    }; // end func
    
    /**
     * Called when the dropdown SMTP authentication is changed
     * @param {event} e
     */
    onSMTPAuthenticationChanged(e)
    {
        var elem = SCHLIX.Dom.get('smtp_use_auth');
        if (elem !== null)
        {
            var smtp_auth = parseInt( elem.value);
            var el_smtp_username = SCHLIX.Dom.get('smtp_username_box');
            var el_smtp_password_box = SCHLIX.Dom.get('smtp_password_box');
            
            switch (smtp_auth)
            {
                case 1: 
                    el_smtp_username.style.display = '';
                    el_smtp_password_box.style.display = '';
                    this.onShowOauth2Box('none');
                    break;
                case 2: 
                    el_smtp_username.style.display = '';
                    el_smtp_password_box.style.display = 'none';
                    this.onShowOauth2Box('block');
                    break;                
                default:
                    el_smtp_username.style.display = 'none';
                    el_smtp_password_box.style.display = 'none';
                    this.onShowOauth2Box('none');
            }
        } else SCHLIX.Alert.info('Unable to find SMTP auth input');
    };
    
    onShowOauth2Box(val){
        var el_smtp_oauth2_box = SCHLIX.Dom.get('smtp_oauth2_box');
        if (el_smtp_oauth2_box !== null)
        {
            el_smtp_oauth2_box.style.display = val;
        }
    };
    
    doBeforeDialogFormClose(o) 
    {
        var resp = JSON.parse(o.responseText);
        var response = resp.data;        
        if (response.lines)
        {
            var c = SCHLIX.Dom.get('testemail_send_result');
            c.innerHTML =  response.lines + "<br />===================<br />" + response.debug;
        } 
        
        return false;
    }

 
    runCommand (command, evt)
    {
        switch (command)
        {
            case 'test-send':
                this.onShowTestDialogClick(evt);
                return true;
                break;            
            case 'config':
                this.redirectToCMSCommand("editconfig");
                return true;
                break;
            case 'main':
                this.redirectToCMSCommand("main");
                return true;
                break;
                
            case 'authxo2':
                this.redirectToCMSCommand("authxo2");
                return true;
                break;
            
            
            default:
                return super.runCommand(command, evt);
                break;
        }
    }
};


